/*
 * Decompiled with CFR 0.152.
 */
package adql.query;

import adql.parser.feature.LanguageFeature;
import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.NullADQLIterator;
import adql.query.TextPosition;

public class ClauseOffset
implements ADQLObject {
    public static final LanguageFeature FEATURE = new LanguageFeature("ivo://ivoa.net/std/TAPRegExt#features-adql-offset", "OFFSET", true, "Remove the specified number of rows from the head of the query result.");
    private static final String NAME = "OFFSET";
    protected int value;
    private TextPosition position = null;

    public ClauseOffset(int offsetValue) throws IndexOutOfBoundsException {
        this.setValue(offsetValue);
    }

    public final int getValue() {
        return this.value;
    }

    public void setValue(int offsetValue) throws IndexOutOfBoundsException {
        if (offsetValue < 0) {
            throw new IndexOutOfBoundsException("Incorrect OFFSET value: \"" + offsetValue + "\"! It must be a positive value.");
        }
        this.value = offsetValue;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new ClauseOffset(this.value);
    }

    @Override
    public final String getName() {
        return NAME;
    }

    @Override
    public final LanguageFeature getFeatureDescription() {
        return FEATURE;
    }

    @Override
    public final TextPosition getPosition() {
        return this.position;
    }

    public final void setPosition(TextPosition newPosition) {
        this.position = newPosition;
    }

    @Override
    public ADQLIterator adqlIterator() {
        return new NullADQLIterator();
    }

    @Override
    public String toADQL() {
        return "OFFSET " + this.value;
    }
}

