
##############################################################################
#
# Copyright (c) 2003-2017 by The University of Queensland
# http://www.uq.edu.au
#
# Primary Business: Queensland, Australia
# Licensed under the Apache License, version 2.0
# http://www.apache.org/licenses/LICENSE-2.0
#
# Development until 2012 by Earth Systems Science Computational Center (ESSCC)
# Development 2012-2013 by School of Earth Sciences
# Development from 2014 by Centre for Geoscience Computing (GeoComp)
#
##############################################################################

from __future__ import print_function, division

__copyright__="""Copyright (c) 2003-2017 by The University of Queensland
http://www.uq.edu.au
Primary Business: Queensland, Australia"""
__license__="""Licensed under the Apache License, version 2.0
http://www.apache.org/licenses/LICENSE-2.0"""
__url__="https://launchpad.net/escript-finley"

"""
Tests for gradient on domains in the unit square/cube.

This file was auto-generated.
"""

import esys.escriptcore.utestselect as unittest
from esys.escript import *
import numpy

class Test_Util_Gradient_noBoundary(unittest.TestCase):
    RES_TOL=1.e-8

    def test_gradC_onFunction_fromData_ContinuousFunction_rank0(self):
        """
        tests gradient of rank 0 Data on Function

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=(-0.0371363921473+0.039406396558j)*x[0]**o+((0.922271132962+0.387331725454j))*x[0]+((0.458592850688-0.875658600458j))*x[1]**o+((0.273117118072+0.558507121065j))*x[1]
        ref[0]=(-0.0371363921473+0.039406396558j)*o*x_ref[0]**(o-1)+((0.922271132962+0.387331725454j))
        ref[1]=(0.458592850688-0.875658600458j)*o*x_ref[1]**(o-1)+((0.273117118072+0.558507121065j))
        if dim==3:
            arg+=((-0.904127861676+0.811040340281j))*x[2]**o+((0.928644826364+0.912132297048j))*x[2]
            ref[2]=(-0.904127861676+0.811040340281j)*o*x_ref[2]**(o-1)+((0.928644826364+0.912132297048j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunction_fromData_ContinuousFunction_rank1(self):
        """
        tests gradient of rank 1 Data on Function

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(4,),w)
        ref = Data(0,(4,)+(dim,),w_ref)
        arg[0,]=(-0.0498682946292-0.861052235484j)*x[0]**o+((-0.228220078889-0.905278636322j))*x[0]+((0.240748344011-0.488349121417j))*x[1]**o+((-0.686346911532-0.381562003189j))*x[1]
        ref[0, 0]=(-0.0498682946292-0.861052235484j)*o*x_ref[0]**(o-1)+((-0.228220078889-0.905278636322j))
        ref[0, 1]=(0.240748344011-0.488349121417j)*o*x_ref[1]**(o-1)+((-0.686346911532-0.381562003189j))
        arg[1,]=(0.619607513828-0.927031827589j)*x[0]**o+((0.39757843009-0.596931996454j))*x[0]+((0.0309682836785-0.406842142554j))*x[1]**o+((-0.502809771082-0.220371192172j))*x[1]
        ref[1, 0]=(0.619607513828-0.927031827589j)*o*x_ref[0]**(o-1)+((0.39757843009-0.596931996454j))
        ref[1, 1]=(0.0309682836785-0.406842142554j)*o*x_ref[1]**(o-1)+((-0.502809771082-0.220371192172j))
        arg[2,]=(0.734950357029-0.809793915892j)*x[0]**o+((0.983994034628+0.547335347832j))*x[0]+((0.64407483857-0.825858220043j))*x[1]**o+((-0.756371335536-0.945837663906j))*x[1]
        ref[2, 0]=(0.734950357029-0.809793915892j)*o*x_ref[0]**(o-1)+((0.983994034628+0.547335347832j))
        ref[2, 1]=(0.64407483857-0.825858220043j)*o*x_ref[1]**(o-1)+((-0.756371335536-0.945837663906j))
        arg[3,]=(-0.568010469326-0.619507294635j)*x[0]**o+((-0.0486816509292+0.933113363453j))*x[0]+((-0.720166218223+0.354851757538j))*x[1]**o+((-0.261194173537+0.561702705361j))*x[1]
        ref[3, 0]=(-0.568010469326-0.619507294635j)*o*x_ref[0]**(o-1)+((-0.0486816509292+0.933113363453j))
        ref[3, 1]=(-0.720166218223+0.354851757538j)*o*x_ref[1]**(o-1)+((-0.261194173537+0.561702705361j))
        if dim==3:
            arg[0,]+=(-0.894558476368+0.586009771614j)*x[2]**o+((0.568201762517-0.0764380298403j))*x[2]
            ref[0, 2]=(-0.894558476368+0.586009771614j)*o*x_ref[2]**(o-1)+((0.568201762517-0.0764380298403j))
            arg[1,]+=(-0.393542851276+0.11427099534j)*x[2]**o+((0.606231200435+0.147114747395j))*x[2]
            ref[1, 2]=(-0.393542851276+0.11427099534j)*o*x_ref[2]**(o-1)+((0.606231200435+0.147114747395j))
            arg[2,]+=(0.106607519044+0.669436250333j)*x[2]**o+((-0.410870065882+0.0825007188042j))*x[2]
            ref[2, 2]=(0.106607519044+0.669436250333j)*o*x_ref[2]**(o-1)+((-0.410870065882+0.0825007188042j))
            arg[3,]+=(0.848042270094-0.455528210072j)*x[2]**o+((-0.979000943886-0.415058830156j))*x[2]
            ref[3, 2]=(0.848042270094-0.455528210072j)*o*x_ref[2]**(o-1)+((-0.979000943886-0.415058830156j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunction_fromData_ContinuousFunction_rank2(self):
        """
        tests gradient of rank 2 Data on Function

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(2, 2),w)
        ref = Data(0,(2, 2)+(dim,),w_ref)
        arg[0, 0]=(-0.400938292374+0.0210009422042j)*x[0]**o+((0.0942464955001+0.205256199722j))*x[0]+((0.04997532574-0.857171541113j))*x[1]**o+((-0.880605945119+0.0069905996259j))*x[1]
        ref[0, 0, 0]=(-0.400938292374+0.0210009422042j)*o*x_ref[0]**(o-1)+((0.0942464955001+0.205256199722j))
        ref[0, 0, 1]=(0.04997532574-0.857171541113j)*o*x_ref[1]**(o-1)+((-0.880605945119+0.0069905996259j))
        arg[0, 1]=(0.690354218204-0.516539234083j)*x[0]**o+((0.806630250612+0.216914603195j))*x[0]+((0.639858699236+0.00184536915463j))*x[1]**o+((-0.0889442185699-0.617957414106j))*x[1]
        ref[0, 1, 0]=(0.690354218204-0.516539234083j)*o*x_ref[0]**(o-1)+((0.806630250612+0.216914603195j))
        ref[0, 1, 1]=(0.639858699236+0.00184536915463j)*o*x_ref[1]**(o-1)+((-0.0889442185699-0.617957414106j))
        arg[1, 0]=(0.628319286941+0.751306212044j)*x[0]**o+((0.420785768642-0.221826650077j))*x[0]+((0.503424570888+0.308345608481j))*x[1]**o+((-0.999856622716-0.170788135544j))*x[1]
        ref[1, 0, 0]=(0.628319286941+0.751306212044j)*o*x_ref[0]**(o-1)+((0.420785768642-0.221826650077j))
        ref[1, 0, 1]=(0.503424570888+0.308345608481j)*o*x_ref[1]**(o-1)+((-0.999856622716-0.170788135544j))
        arg[1, 1]=(-0.907531434349-0.0426171114286j)*x[0]**o+((-0.52716814744-0.550205721607j))*x[0]+((0.695042123006-0.214050430492j))*x[1]**o+((0.108255076635+0.357180353435j))*x[1]
        ref[1, 1, 0]=(-0.907531434349-0.0426171114286j)*o*x_ref[0]**(o-1)+((-0.52716814744-0.550205721607j))
        ref[1, 1, 1]=(0.695042123006-0.214050430492j)*o*x_ref[1]**(o-1)+((0.108255076635+0.357180353435j))
        if dim==3:
            arg[0, 0]+=(-0.687742272482+0.997837455305j)*x[2]**o+((0.382615141789-0.557750470251j))*x[2]
            ref[0, 0, 2]=(-0.687742272482+0.997837455305j)*o*x_ref[2]**(o-1)+((0.382615141789-0.557750470251j))
            arg[0, 1]+=(-0.475315415326-0.926707969323j)*x[2]**o+((0.981552231453-0.973252280327j))*x[2]
            ref[0, 1, 2]=(-0.475315415326-0.926707969323j)*o*x_ref[2]**(o-1)+((0.981552231453-0.973252280327j))
            arg[1, 0]+=(0.374358189811+0.226692918176j)*x[2]**o+((-0.52894556414-0.90501380512j))*x[2]
            ref[1, 0, 2]=(0.374358189811+0.226692918176j)*o*x_ref[2]**(o-1)+((-0.52894556414-0.90501380512j))
            arg[1, 1]+=(-0.371690533559-0.615210901823j)*x[2]**o+((0.897164244728+0.627059348943j))*x[2]
            ref[1, 1, 2]=(-0.371690533559-0.615210901823j)*o*x_ref[2]**(o-1)+((0.897164244728+0.627059348943j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2, 2)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunction_fromData_ContinuousFunction_rank3(self):
        """
        tests gradient of rank 3 Data on Function

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(2, 4, 3),w)
        ref = Data(0,(2, 4, 3)+(dim,),w_ref)
        arg[0, 0, 0]=(-0.686545863137-0.195182177585j)*x[0]**o+((-0.621925417051-0.0298316051422j))*x[0]+((0.718145394246-0.898509438376j))*x[1]**o+((-0.103440380012-0.863327388375j))*x[1]
        ref[0, 0, 0, 0]=(-0.686545863137-0.195182177585j)*o*x_ref[0]**(o-1)+((-0.621925417051-0.0298316051422j))
        ref[0, 0, 0, 1]=(0.718145394246-0.898509438376j)*o*x_ref[1]**(o-1)+((-0.103440380012-0.863327388375j))
        arg[0, 0, 1]=(0.11223294674+0.175413475218j)*x[0]**o+((0.26088291445-0.292928701489j))*x[0]+((0.0362445251514-0.936388845129j))*x[1]**o+((-0.237482949457-0.0426081669353j))*x[1]
        ref[0, 0, 1, 0]=(0.11223294674+0.175413475218j)*o*x_ref[0]**(o-1)+((0.26088291445-0.292928701489j))
        ref[0, 0, 1, 1]=(0.0362445251514-0.936388845129j)*o*x_ref[1]**(o-1)+((-0.237482949457-0.0426081669353j))
        arg[0, 0, 2]=(0.338543846282-0.211720878363j)*x[0]**o+((0.373090094782+0.742520331957j))*x[0]+((0.907776776998-0.06437207165j))*x[1]**o+((-0.579131618093+0.86066703124j))*x[1]
        ref[0, 0, 2, 0]=(0.338543846282-0.211720878363j)*o*x_ref[0]**(o-1)+((0.373090094782+0.742520331957j))
        ref[0, 0, 2, 1]=(0.907776776998-0.06437207165j)*o*x_ref[1]**(o-1)+((-0.579131618093+0.86066703124j))
        arg[0, 1, 0]=(0.96097437478+0.713965141654j)*x[0]**o+((-0.988577234363+0.497658969577j))*x[0]+((0.962227087385+0.897204522444j))*x[1]**o+((-0.0823186675378-0.910393832654j))*x[1]
        ref[0, 1, 0, 0]=(0.96097437478+0.713965141654j)*o*x_ref[0]**(o-1)+((-0.988577234363+0.497658969577j))
        ref[0, 1, 0, 1]=(0.962227087385+0.897204522444j)*o*x_ref[1]**(o-1)+((-0.0823186675378-0.910393832654j))
        arg[0, 1, 1]=(0.0608858163792-0.506288104368j)*x[0]**o+((-0.809774297043-0.80168096953j))*x[0]+((-0.339910489239-0.790636836752j))*x[1]**o+((0.822736231674-0.469912488219j))*x[1]
        ref[0, 1, 1, 0]=(0.0608858163792-0.506288104368j)*o*x_ref[0]**(o-1)+((-0.809774297043-0.80168096953j))
        ref[0, 1, 1, 1]=(-0.339910489239-0.790636836752j)*o*x_ref[1]**(o-1)+((0.822736231674-0.469912488219j))
        arg[0, 1, 2]=(-0.273921800145-0.82796104564j)*x[0]**o+((-0.437509022805+0.599480900683j))*x[0]+((-0.217234456033-0.669206325315j))*x[1]**o+((0.901853049517-0.46456055909j))*x[1]
        ref[0, 1, 2, 0]=(-0.273921800145-0.82796104564j)*o*x_ref[0]**(o-1)+((-0.437509022805+0.599480900683j))
        ref[0, 1, 2, 1]=(-0.217234456033-0.669206325315j)*o*x_ref[1]**(o-1)+((0.901853049517-0.46456055909j))
        arg[0, 2, 0]=(-0.00750983499033+0.810986160859j)*x[0]**o+((0.044151077838+0.399748079958j))*x[0]+((-0.553214291667+0.559789129637j))*x[1]**o+((-0.0571596871381-0.165669950852j))*x[1]
        ref[0, 2, 0, 0]=(-0.00750983499033+0.810986160859j)*o*x_ref[0]**(o-1)+((0.044151077838+0.399748079958j))
        ref[0, 2, 0, 1]=(-0.553214291667+0.559789129637j)*o*x_ref[1]**(o-1)+((-0.0571596871381-0.165669950852j))
        arg[0, 2, 1]=(-0.457289891595-0.253363111301j)*x[0]**o+((-0.0190169524221+0.579294582967j))*x[0]+((0.568172643396+0.230092797763j))*x[1]**o+((0.655848239055+0.238359092719j))*x[1]
        ref[0, 2, 1, 0]=(-0.457289891595-0.253363111301j)*o*x_ref[0]**(o-1)+((-0.0190169524221+0.579294582967j))
        ref[0, 2, 1, 1]=(0.568172643396+0.230092797763j)*o*x_ref[1]**(o-1)+((0.655848239055+0.238359092719j))
        arg[0, 2, 2]=(0.41178184284-0.808623218432j)*x[0]**o+((0.260907822163-0.188854294882j))*x[0]+((0.478496306594-0.240132409214j))*x[1]**o+((-0.940332437367+0.817847161936j))*x[1]
        ref[0, 2, 2, 0]=(0.41178184284-0.808623218432j)*o*x_ref[0]**(o-1)+((0.260907822163-0.188854294882j))
        ref[0, 2, 2, 1]=(0.478496306594-0.240132409214j)*o*x_ref[1]**(o-1)+((-0.940332437367+0.817847161936j))
        arg[0, 3, 0]=(-0.364799099328+0.641530137102j)*x[0]**o+((0.6065078974+0.369695477794j))*x[0]+((0.980495093934+0.191486895418j))*x[1]**o+((-0.635574621618-0.247196286875j))*x[1]
        ref[0, 3, 0, 0]=(-0.364799099328+0.641530137102j)*o*x_ref[0]**(o-1)+((0.6065078974+0.369695477794j))
        ref[0, 3, 0, 1]=(0.980495093934+0.191486895418j)*o*x_ref[1]**(o-1)+((-0.635574621618-0.247196286875j))
        arg[0, 3, 1]=(0.405606783292-0.12303483135j)*x[0]**o+((0.0185273358693+0.459381706618j))*x[0]+((0.598996979187-0.0557859468527j))*x[1]**o+((0.873998483614+0.479415765827j))*x[1]
        ref[0, 3, 1, 0]=(0.405606783292-0.12303483135j)*o*x_ref[0]**(o-1)+((0.0185273358693+0.459381706618j))
        ref[0, 3, 1, 1]=(0.598996979187-0.0557859468527j)*o*x_ref[1]**(o-1)+((0.873998483614+0.479415765827j))
        arg[0, 3, 2]=(-0.738859638564-0.239886727616j)*x[0]**o+((-0.711965065303-0.541473175685j))*x[0]+((-0.0752180568666+0.113303153964j))*x[1]**o+((-0.142689827205+0.769392040008j))*x[1]
        ref[0, 3, 2, 0]=(-0.738859638564-0.239886727616j)*o*x_ref[0]**(o-1)+((-0.711965065303-0.541473175685j))
        ref[0, 3, 2, 1]=(-0.0752180568666+0.113303153964j)*o*x_ref[1]**(o-1)+((-0.142689827205+0.769392040008j))
        arg[1, 0, 0]=(-0.493496549109-0.552164696676j)*x[0]**o+((-0.709540377456+0.112449521038j))*x[0]+((-0.538783599671+0.248870250157j))*x[1]**o+((0.815110945148+0.191740144379j))*x[1]
        ref[1, 0, 0, 0]=(-0.493496549109-0.552164696676j)*o*x_ref[0]**(o-1)+((-0.709540377456+0.112449521038j))
        ref[1, 0, 0, 1]=(-0.538783599671+0.248870250157j)*o*x_ref[1]**(o-1)+((0.815110945148+0.191740144379j))
        arg[1, 0, 1]=(-0.00171846494896+0.39330456112j)*x[0]**o+((-0.253811523956-0.441272551132j))*x[0]+((0.0121673129717-0.262206567308j))*x[1]**o+((0.0922018361726+0.495662331126j))*x[1]
        ref[1, 0, 1, 0]=(-0.00171846494896+0.39330456112j)*o*x_ref[0]**(o-1)+((-0.253811523956-0.441272551132j))
        ref[1, 0, 1, 1]=(0.0121673129717-0.262206567308j)*o*x_ref[1]**(o-1)+((0.0922018361726+0.495662331126j))
        arg[1, 0, 2]=(0.426969738126+0.382056563859j)*x[0]**o+((-0.259995926226-0.0939463746681j))*x[0]+((-0.49264287414+0.384987448577j))*x[1]**o+((-0.018987089908-0.204942187559j))*x[1]
        ref[1, 0, 2, 0]=(0.426969738126+0.382056563859j)*o*x_ref[0]**(o-1)+((-0.259995926226-0.0939463746681j))
        ref[1, 0, 2, 1]=(-0.49264287414+0.384987448577j)*o*x_ref[1]**(o-1)+((-0.018987089908-0.204942187559j))
        arg[1, 1, 0]=(-0.673405202558-0.617156362987j)*x[0]**o+((-0.0473044208881-0.355425397445j))*x[0]+((0.103315270076-0.833952219206j))*x[1]**o+((0.640574134642-0.0005917387782j))*x[1]
        ref[1, 1, 0, 0]=(-0.673405202558-0.617156362987j)*o*x_ref[0]**(o-1)+((-0.0473044208881-0.355425397445j))
        ref[1, 1, 0, 1]=(0.103315270076-0.833952219206j)*o*x_ref[1]**(o-1)+((0.640574134642-0.0005917387782j))
        arg[1, 1, 1]=(0.863832970664+0.525075520192j)*x[0]**o+((0.303909427821-0.224241565975j))*x[0]+((0.0240775460044-0.18412459405j))*x[1]**o+((0.235522955443-0.165854382053j))*x[1]
        ref[1, 1, 1, 0]=(0.863832970664+0.525075520192j)*o*x_ref[0]**(o-1)+((0.303909427821-0.224241565975j))
        ref[1, 1, 1, 1]=(0.0240775460044-0.18412459405j)*o*x_ref[1]**(o-1)+((0.235522955443-0.165854382053j))
        arg[1, 1, 2]=(0.217944524067-0.664868501171j)*x[0]**o+((0.196759480662+0.852986461285j))*x[0]+((0.236653935966-0.160284451476j))*x[1]**o+((-0.700689312636-0.0314987484264j))*x[1]
        ref[1, 1, 2, 0]=(0.217944524067-0.664868501171j)*o*x_ref[0]**(o-1)+((0.196759480662+0.852986461285j))
        ref[1, 1, 2, 1]=(0.236653935966-0.160284451476j)*o*x_ref[1]**(o-1)+((-0.700689312636-0.0314987484264j))
        arg[1, 2, 0]=(0.832257463577+0.53499843286j)*x[0]**o+((-0.321736751074+0.738530462002j))*x[0]+((0.977393578417-0.421040004545j))*x[1]**o+((-0.499794103096+0.52086894234j))*x[1]
        ref[1, 2, 0, 0]=(0.832257463577+0.53499843286j)*o*x_ref[0]**(o-1)+((-0.321736751074+0.738530462002j))
        ref[1, 2, 0, 1]=(0.977393578417-0.421040004545j)*o*x_ref[1]**(o-1)+((-0.499794103096+0.52086894234j))
        arg[1, 2, 1]=(-0.0225106073262+0.916891579705j)*x[0]**o+((-0.704432501309-0.555104126484j))*x[0]+((0.914381878375-0.0831963870148j))*x[1]**o+((-0.666846436319-0.588868817559j))*x[1]
        ref[1, 2, 1, 0]=(-0.0225106073262+0.916891579705j)*o*x_ref[0]**(o-1)+((-0.704432501309-0.555104126484j))
        ref[1, 2, 1, 1]=(0.914381878375-0.0831963870148j)*o*x_ref[1]**(o-1)+((-0.666846436319-0.588868817559j))
        arg[1, 2, 2]=(0.523268170768-0.723915749887j)*x[0]**o+((0.428201382553-0.524355080199j))*x[0]+((-0.248440309924+0.652118189664j))*x[1]**o+((-0.996019245714-0.390083550615j))*x[1]
        ref[1, 2, 2, 0]=(0.523268170768-0.723915749887j)*o*x_ref[0]**(o-1)+((0.428201382553-0.524355080199j))
        ref[1, 2, 2, 1]=(-0.248440309924+0.652118189664j)*o*x_ref[1]**(o-1)+((-0.996019245714-0.390083550615j))
        arg[1, 3, 0]=(-0.36808493828-0.548058611785j)*x[0]**o+((-0.341171766561-0.444336652416j))*x[0]+((-0.0209092618637-0.09087486242j))*x[1]**o+((0.202772167168-0.126338126322j))*x[1]
        ref[1, 3, 0, 0]=(-0.36808493828-0.548058611785j)*o*x_ref[0]**(o-1)+((-0.341171766561-0.444336652416j))
        ref[1, 3, 0, 1]=(-0.0209092618637-0.09087486242j)*o*x_ref[1]**(o-1)+((0.202772167168-0.126338126322j))
        arg[1, 3, 1]=(-0.516110531558+0.0603038494706j)*x[0]**o+((-0.457621901844+0.849344769973j))*x[0]+((0.611697287552-0.827443901489j))*x[1]**o+((0.459482507616+0.672818364203j))*x[1]
        ref[1, 3, 1, 0]=(-0.516110531558+0.0603038494706j)*o*x_ref[0]**(o-1)+((-0.457621901844+0.849344769973j))
        ref[1, 3, 1, 1]=(0.611697287552-0.827443901489j)*o*x_ref[1]**(o-1)+((0.459482507616+0.672818364203j))
        arg[1, 3, 2]=(-0.649211651312-0.999767696405j)*x[0]**o+((-0.374328492264-0.429228674222j))*x[0]+((-0.72439824951-0.132019089029j))*x[1]**o+((-0.810520412756-0.824692599688j))*x[1]
        ref[1, 3, 2, 0]=(-0.649211651312-0.999767696405j)*o*x_ref[0]**(o-1)+((-0.374328492264-0.429228674222j))
        ref[1, 3, 2, 1]=(-0.72439824951-0.132019089029j)*o*x_ref[1]**(o-1)+((-0.810520412756-0.824692599688j))
        if dim==3:
            arg[0, 0, 0]+=(0.581730999753-0.927412318264j)*x[2]**o+((-0.2200807186-0.552169765955j))*x[2]
            ref[0, 0, 0, 2]=(0.581730999753-0.927412318264j)*o*x_ref[2]**(o-1)+((-0.2200807186-0.552169765955j))
            arg[0, 0, 1]+=(-0.981780189769+0.808554474312j)*x[2]**o+((-0.681723016102-0.372738650796j))*x[2]
            ref[0, 0, 1, 2]=(-0.981780189769+0.808554474312j)*o*x_ref[2]**(o-1)+((-0.681723016102-0.372738650796j))
            arg[0, 0, 2]+=(0.788511367677+0.107554962667j)*x[2]**o+((-0.0617322922741-0.517080452894j))*x[2]
            ref[0, 0, 2, 2]=(0.788511367677+0.107554962667j)*o*x_ref[2]**(o-1)+((-0.0617322922741-0.517080452894j))
            arg[0, 1, 0]+=(-0.637957317644-0.800902157558j)*x[2]**o+((-0.855915959816+0.165227986482j))*x[2]
            ref[0, 1, 0, 2]=(-0.637957317644-0.800902157558j)*o*x_ref[2]**(o-1)+((-0.855915959816+0.165227986482j))
            arg[0, 1, 1]+=(-0.935438137112+0.397148185534j)*x[2]**o+((-0.733436377914+0.314662434528j))*x[2]
            ref[0, 1, 1, 2]=(-0.935438137112+0.397148185534j)*o*x_ref[2]**(o-1)+((-0.733436377914+0.314662434528j))
            arg[0, 1, 2]+=(0.685834086302+0.232059839949j)*x[2]**o+((0.155466891869+0.127028974668j))*x[2]
            ref[0, 1, 2, 2]=(0.685834086302+0.232059839949j)*o*x_ref[2]**(o-1)+((0.155466891869+0.127028974668j))
            arg[0, 2, 0]+=(-0.431023064722+0.0758308913635j)*x[2]**o+((-0.434440855728-0.895938443865j))*x[2]
            ref[0, 2, 0, 2]=(-0.431023064722+0.0758308913635j)*o*x_ref[2]**(o-1)+((-0.434440855728-0.895938443865j))
            arg[0, 2, 1]+=(-0.572176677155-0.208259554318j)*x[2]**o+((-0.913081614989-0.776598870063j))*x[2]
            ref[0, 2, 1, 2]=(-0.572176677155-0.208259554318j)*o*x_ref[2]**(o-1)+((-0.913081614989-0.776598870063j))
            arg[0, 2, 2]+=(-0.832853209615+0.630726257316j)*x[2]**o+((0.697634376814-0.159423689827j))*x[2]
            ref[0, 2, 2, 2]=(-0.832853209615+0.630726257316j)*o*x_ref[2]**(o-1)+((0.697634376814-0.159423689827j))
            arg[0, 3, 0]+=(0.0685680250985-0.739758054394j)*x[2]**o+((-0.819387007279+0.560663687362j))*x[2]
            ref[0, 3, 0, 2]=(0.0685680250985-0.739758054394j)*o*x_ref[2]**(o-1)+((-0.819387007279+0.560663687362j))
            arg[0, 3, 1]+=(0.915470793255-0.118595194855j)*x[2]**o+((0.556224797004+0.191784813774j))*x[2]
            ref[0, 3, 1, 2]=(0.915470793255-0.118595194855j)*o*x_ref[2]**(o-1)+((0.556224797004+0.191784813774j))
            arg[0, 3, 2]+=(-0.00314897207549-0.508837174843j)*x[2]**o+((0.746832371357-0.0505837137662j))*x[2]
            ref[0, 3, 2, 2]=(-0.00314897207549-0.508837174843j)*o*x_ref[2]**(o-1)+((0.746832371357-0.0505837137662j))
            arg[1, 0, 0]+=(-0.377718695978-0.526847105278j)*x[2]**o+((-0.0231478579132-0.609578014293j))*x[2]
            ref[1, 0, 0, 2]=(-0.377718695978-0.526847105278j)*o*x_ref[2]**(o-1)+((-0.0231478579132-0.609578014293j))
            arg[1, 0, 1]+=(0.355792914999+0.359583097969j)*x[2]**o+((-0.0223995385949+0.914584512488j))*x[2]
            ref[1, 0, 1, 2]=(0.355792914999+0.359583097969j)*o*x_ref[2]**(o-1)+((-0.0223995385949+0.914584512488j))
            arg[1, 0, 2]+=(-0.75260991693-0.272107376398j)*x[2]**o+((0.666796400547-0.694706039504j))*x[2]
            ref[1, 0, 2, 2]=(-0.75260991693-0.272107376398j)*o*x_ref[2]**(o-1)+((0.666796400547-0.694706039504j))
            arg[1, 1, 0]+=(0.687021021067+0.0223090887296j)*x[2]**o+((-0.751020732874-0.62419565323j))*x[2]
            ref[1, 1, 0, 2]=(0.687021021067+0.0223090887296j)*o*x_ref[2]**(o-1)+((-0.751020732874-0.62419565323j))
            arg[1, 1, 1]+=(0.446568136072+0.304525533582j)*x[2]**o+((-0.810264345322-0.24192798029j))*x[2]
            ref[1, 1, 1, 2]=(0.446568136072+0.304525533582j)*o*x_ref[2]**(o-1)+((-0.810264345322-0.24192798029j))
            arg[1, 1, 2]+=(-0.49625103387+0.730587850854j)*x[2]**o+((-0.197812213232+0.594317817567j))*x[2]
            ref[1, 1, 2, 2]=(-0.49625103387+0.730587850854j)*o*x_ref[2]**(o-1)+((-0.197812213232+0.594317817567j))
            arg[1, 2, 0]+=(-0.889922499277+0.568203363884j)*x[2]**o+((-0.988952863486-0.462206439161j))*x[2]
            ref[1, 2, 0, 2]=(-0.889922499277+0.568203363884j)*o*x_ref[2]**(o-1)+((-0.988952863486-0.462206439161j))
            arg[1, 2, 1]+=(-0.685644181922-0.311007477822j)*x[2]**o+((-0.551705343525+0.686520333996j))*x[2]
            ref[1, 2, 1, 2]=(-0.685644181922-0.311007477822j)*o*x_ref[2]**(o-1)+((-0.551705343525+0.686520333996j))
            arg[1, 2, 2]+=(0.246748830112-0.249276341323j)*x[2]**o+((0.0215438361859-0.684749171137j))*x[2]
            ref[1, 2, 2, 2]=(0.246748830112-0.249276341323j)*o*x_ref[2]**(o-1)+((0.0215438361859-0.684749171137j))
            arg[1, 3, 0]+=(0.962126945727-0.433827405701j)*x[2]**o+((0.697463501724+0.232857741746j))*x[2]
            ref[1, 3, 0, 2]=(0.962126945727-0.433827405701j)*o*x_ref[2]**(o-1)+((0.697463501724+0.232857741746j))
            arg[1, 3, 1]+=(-0.89613054965-0.0676037628803j)*x[2]**o+((0.00994625478613-0.665670624015j))*x[2]
            ref[1, 3, 1, 2]=(-0.89613054965-0.0676037628803j)*o*x_ref[2]**(o-1)+((0.00994625478613-0.665670624015j))
            arg[1, 3, 2]+=(-0.523059273101-0.824871486859j)*x[2]**o+((0.332375340134-0.920313103015j))*x[2]
            ref[1, 3, 2, 2]=(-0.523059273101-0.824871486859j)*o*x_ref[2]**(o-1)+((0.332375340134-0.920313103015j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2, 4, 3)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunction_fromData_Solution_rank0(self):
        """
        tests gradient of rank 0 Data on Function

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=(-0.0796587626057-0.265868758046j)*x[0]**o+((-0.451747577068+0.891601883503j))*x[0]+((-0.767296803804+0.5857199557j))*x[1]**o+((-0.195738757371+0.456525432749j))*x[1]
        ref[0]=(-0.0796587626057-0.265868758046j)*o*x_ref[0]**(o-1)+((-0.451747577068+0.891601883503j))
        ref[1]=(-0.767296803804+0.5857199557j)*o*x_ref[1]**(o-1)+((-0.195738757371+0.456525432749j))
        if dim==3:
            arg+=((0.203905363904-0.266767393453j))*x[2]**o+((0.121190320936-0.997153159271j))*x[2]
            ref[2]=(0.203905363904-0.266767393453j)*o*x_ref[2]**(o-1)+((0.121190320936-0.997153159271j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunction_fromData_Solution_rank1(self):
        """
        tests gradient of rank 1 Data on Function

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(3,),w)
        ref = Data(0,(3,)+(dim,),w_ref)
        arg[0,]=(0.201306743613-0.612532774331j)*x[0]**o+((-0.204305708097-0.70143659738j))*x[0]+((0.212898392552+0.094824216568j))*x[1]**o+((0.1958325331-0.665530865299j))*x[1]
        ref[0, 0]=(0.201306743613-0.612532774331j)*o*x_ref[0]**(o-1)+((-0.204305708097-0.70143659738j))
        ref[0, 1]=(0.212898392552+0.094824216568j)*o*x_ref[1]**(o-1)+((0.1958325331-0.665530865299j))
        arg[1,]=(-0.862853874988-0.939740820632j)*x[0]**o+((0.0722069491807+0.511508631442j))*x[0]+((0.674896254273+0.885888036036j))*x[1]**o+((-0.437836648773+0.53279718288j))*x[1]
        ref[1, 0]=(-0.862853874988-0.939740820632j)*o*x_ref[0]**(o-1)+((0.0722069491807+0.511508631442j))
        ref[1, 1]=(0.674896254273+0.885888036036j)*o*x_ref[1]**(o-1)+((-0.437836648773+0.53279718288j))
        arg[2,]=(-0.248977577997+0.490520297839j)*x[0]**o+((0.0452207224173+0.933066025971j))*x[0]+((-0.286505328672+0.886463934459j))*x[1]**o+((-0.109226895442-0.37822696448j))*x[1]
        ref[2, 0]=(-0.248977577997+0.490520297839j)*o*x_ref[0]**(o-1)+((0.0452207224173+0.933066025971j))
        ref[2, 1]=(-0.286505328672+0.886463934459j)*o*x_ref[1]**(o-1)+((-0.109226895442-0.37822696448j))
        if dim==3:
            arg[0,]+=(-0.807378489994+0.013780444822j)*x[2]**o+((0.598831449788-0.983507969647j))*x[2]
            ref[0, 2]=(-0.807378489994+0.013780444822j)*o*x_ref[2]**(o-1)+((0.598831449788-0.983507969647j))
            arg[1,]+=(-0.0128573396373+0.846692007924j)*x[2]**o+((0.214465753193-0.265808088162j))*x[2]
            ref[1, 2]=(-0.0128573396373+0.846692007924j)*o*x_ref[2]**(o-1)+((0.214465753193-0.265808088162j))
            arg[2,]+=(-0.281223573806+0.609319596765j)*x[2]**o+((-0.80778096645-0.831543572803j))*x[2]
            ref[2, 2]=(-0.281223573806+0.609319596765j)*o*x_ref[2]**(o-1)+((-0.80778096645-0.831543572803j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunction_fromData_Solution_rank2(self):
        """
        tests gradient of rank 2 Data on Function

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(3, 4),w)
        ref = Data(0,(3, 4)+(dim,),w_ref)
        arg[0, 0]=(-0.0720568095368-0.646670579857j)*x[0]**o+((0.602375230589+0.0631332247877j))*x[0]+((0.626824916592-0.959105033969j))*x[1]**o+((0.0886238314815-0.464127056901j))*x[1]
        ref[0, 0, 0]=(-0.0720568095368-0.646670579857j)*o*x_ref[0]**(o-1)+((0.602375230589+0.0631332247877j))
        ref[0, 0, 1]=(0.626824916592-0.959105033969j)*o*x_ref[1]**(o-1)+((0.0886238314815-0.464127056901j))
        arg[0, 1]=(-0.553953659567+0.761339220842j)*x[0]**o+((-0.260221474477+0.0947897326054j))*x[0]+((0.916523659149+0.628463066875j))*x[1]**o+((0.387326255267+0.879765031316j))*x[1]
        ref[0, 1, 0]=(-0.553953659567+0.761339220842j)*o*x_ref[0]**(o-1)+((-0.260221474477+0.0947897326054j))
        ref[0, 1, 1]=(0.916523659149+0.628463066875j)*o*x_ref[1]**(o-1)+((0.387326255267+0.879765031316j))
        arg[0, 2]=(-0.238804989379+0.390968169271j)*x[0]**o+((-0.156262792628+0.129110603752j))*x[0]+((-0.124770030315+0.592895316376j))*x[1]**o+((0.260013464011+0.912219077906j))*x[1]
        ref[0, 2, 0]=(-0.238804989379+0.390968169271j)*o*x_ref[0]**(o-1)+((-0.156262792628+0.129110603752j))
        ref[0, 2, 1]=(-0.124770030315+0.592895316376j)*o*x_ref[1]**(o-1)+((0.260013464011+0.912219077906j))
        arg[0, 3]=(-0.295456225706-0.430734421295j)*x[0]**o+((0.140573828827-0.281006512643j))*x[0]+((-0.410988710031-0.531085145552j))*x[1]**o+((0.0425244833675+0.946002246207j))*x[1]
        ref[0, 3, 0]=(-0.295456225706-0.430734421295j)*o*x_ref[0]**(o-1)+((0.140573828827-0.281006512643j))
        ref[0, 3, 1]=(-0.410988710031-0.531085145552j)*o*x_ref[1]**(o-1)+((0.0425244833675+0.946002246207j))
        arg[1, 0]=(0.679151610952+0.752324344859j)*x[0]**o+((-0.169447224941-0.62527173305j))*x[0]+((0.87527478022+0.839708179791j))*x[1]**o+((-0.532882317906-0.126913551661j))*x[1]
        ref[1, 0, 0]=(0.679151610952+0.752324344859j)*o*x_ref[0]**(o-1)+((-0.169447224941-0.62527173305j))
        ref[1, 0, 1]=(0.87527478022+0.839708179791j)*o*x_ref[1]**(o-1)+((-0.532882317906-0.126913551661j))
        arg[1, 1]=(0.684348904647+0.296981076546j)*x[0]**o+((-0.317246185312+0.542009389971j))*x[0]+((0.372717027523-0.319983295507j))*x[1]**o+((-0.770103138256+0.14502510545j))*x[1]
        ref[1, 1, 0]=(0.684348904647+0.296981076546j)*o*x_ref[0]**(o-1)+((-0.317246185312+0.542009389971j))
        ref[1, 1, 1]=(0.372717027523-0.319983295507j)*o*x_ref[1]**(o-1)+((-0.770103138256+0.14502510545j))
        arg[1, 2]=(-0.0957048898522-0.896073501087j)*x[0]**o+((-0.705781847987+0.46814919372j))*x[0]+((-0.904717502258-0.958788289995j))*x[1]**o+((-0.305303697915-0.38138773293j))*x[1]
        ref[1, 2, 0]=(-0.0957048898522-0.896073501087j)*o*x_ref[0]**(o-1)+((-0.705781847987+0.46814919372j))
        ref[1, 2, 1]=(-0.904717502258-0.958788289995j)*o*x_ref[1]**(o-1)+((-0.305303697915-0.38138773293j))
        arg[1, 3]=(-0.951488669345-0.850545364533j)*x[0]**o+((-0.641524150098-0.584058500452j))*x[0]+((0.1776178347-0.153009337254j))*x[1]**o+((-0.511793080791-0.82629572475j))*x[1]
        ref[1, 3, 0]=(-0.951488669345-0.850545364533j)*o*x_ref[0]**(o-1)+((-0.641524150098-0.584058500452j))
        ref[1, 3, 1]=(0.1776178347-0.153009337254j)*o*x_ref[1]**(o-1)+((-0.511793080791-0.82629572475j))
        arg[2, 0]=(0.39968180042+0.8087229587j)*x[0]**o+((0.916438061102-0.901067813306j))*x[0]+((-0.108856934254+0.706244440142j))*x[1]**o+((-0.858911700051-0.718614125535j))*x[1]
        ref[2, 0, 0]=(0.39968180042+0.8087229587j)*o*x_ref[0]**(o-1)+((0.916438061102-0.901067813306j))
        ref[2, 0, 1]=(-0.108856934254+0.706244440142j)*o*x_ref[1]**(o-1)+((-0.858911700051-0.718614125535j))
        arg[2, 1]=(0.113269471306+0.627703460648j)*x[0]**o+((-0.0813822638783-0.541231906429j))*x[0]+((-0.689904575951-0.786026982979j))*x[1]**o+((-0.651822218968-0.886583830224j))*x[1]
        ref[2, 1, 0]=(0.113269471306+0.627703460648j)*o*x_ref[0]**(o-1)+((-0.0813822638783-0.541231906429j))
        ref[2, 1, 1]=(-0.689904575951-0.786026982979j)*o*x_ref[1]**(o-1)+((-0.651822218968-0.886583830224j))
        arg[2, 2]=(-0.886083827825-0.330437554763j)*x[0]**o+((0.613412203096-0.372666382735j))*x[0]+((-0.176757399195+0.0490574925038j))*x[1]**o+((-0.0905581600327+0.203869420218j))*x[1]
        ref[2, 2, 0]=(-0.886083827825-0.330437554763j)*o*x_ref[0]**(o-1)+((0.613412203096-0.372666382735j))
        ref[2, 2, 1]=(-0.176757399195+0.0490574925038j)*o*x_ref[1]**(o-1)+((-0.0905581600327+0.203869420218j))
        arg[2, 3]=(0.296939838912-0.19605432089j)*x[0]**o+((-0.678150865207-0.853282224191j))*x[0]+((0.231304715017-0.794844609563j))*x[1]**o+((0.599110092245-0.525920882232j))*x[1]
        ref[2, 3, 0]=(0.296939838912-0.19605432089j)*o*x_ref[0]**(o-1)+((-0.678150865207-0.853282224191j))
        ref[2, 3, 1]=(0.231304715017-0.794844609563j)*o*x_ref[1]**(o-1)+((0.599110092245-0.525920882232j))
        if dim==3:
            arg[0, 0]+=(-0.803892908508+0.0489032202926j)*x[2]**o+((-0.388040079799-0.260457839045j))*x[2]
            ref[0, 0, 2]=(-0.803892908508+0.0489032202926j)*o*x_ref[2]**(o-1)+((-0.388040079799-0.260457839045j))
            arg[0, 1]+=(-0.681550090044+0.443814376618j)*x[2]**o+((0.327763957925+0.100557460089j))*x[2]
            ref[0, 1, 2]=(-0.681550090044+0.443814376618j)*o*x_ref[2]**(o-1)+((0.327763957925+0.100557460089j))
            arg[0, 2]+=(-0.558404271+0.201131640328j)*x[2]**o+((0.515170389531+0.182955800275j))*x[2]
            ref[0, 2, 2]=(-0.558404271+0.201131640328j)*o*x_ref[2]**(o-1)+((0.515170389531+0.182955800275j))
            arg[0, 3]+=(-0.682960917762+0.875465615597j)*x[2]**o+((0.706803884405-0.874601218771j))*x[2]
            ref[0, 3, 2]=(-0.682960917762+0.875465615597j)*o*x_ref[2]**(o-1)+((0.706803884405-0.874601218771j))
            arg[1, 0]+=(-0.245817617262-0.919491793386j)*x[2]**o+((-0.326813976424+0.494174596178j))*x[2]
            ref[1, 0, 2]=(-0.245817617262-0.919491793386j)*o*x_ref[2]**(o-1)+((-0.326813976424+0.494174596178j))
            arg[1, 1]+=(0.386669055239+0.795094100885j)*x[2]**o+((-0.550221682302+0.0255384294161j))*x[2]
            ref[1, 1, 2]=(0.386669055239+0.795094100885j)*o*x_ref[2]**(o-1)+((-0.550221682302+0.0255384294161j))
            arg[1, 2]+=(0.883679901916-0.609626268127j)*x[2]**o+((0.990102623896-0.48660402885j))*x[2]
            ref[1, 2, 2]=(0.883679901916-0.609626268127j)*o*x_ref[2]**(o-1)+((0.990102623896-0.48660402885j))
            arg[1, 3]+=(0.146162567848+0.555061002164j)*x[2]**o+((-0.9803815589+0.38771788493j))*x[2]
            ref[1, 3, 2]=(0.146162567848+0.555061002164j)*o*x_ref[2]**(o-1)+((-0.9803815589+0.38771788493j))
            arg[2, 0]+=(-0.324379616876+0.0335771582878j)*x[2]**o+((-0.784511570383-0.620402998982j))*x[2]
            ref[2, 0, 2]=(-0.324379616876+0.0335771582878j)*o*x_ref[2]**(o-1)+((-0.784511570383-0.620402998982j))
            arg[2, 1]+=(0.360654937611+0.123618830511j)*x[2]**o+((0.187148122061+0.366871788326j))*x[2]
            ref[2, 1, 2]=(0.360654937611+0.123618830511j)*o*x_ref[2]**(o-1)+((0.187148122061+0.366871788326j))
            arg[2, 2]+=(-0.114386156873+0.335028689862j)*x[2]**o+((-0.0857038206927+0.549958505488j))*x[2]
            ref[2, 2, 2]=(-0.114386156873+0.335028689862j)*o*x_ref[2]**(o-1)+((-0.0857038206927+0.549958505488j))
            arg[2, 3]+=(-0.586837647955-0.157037978786j)*x[2]**o+((0.932957586328+0.544491864566j))*x[2]
            ref[2, 3, 2]=(-0.586837647955-0.157037978786j)*o*x_ref[2]**(o-1)+((0.932957586328+0.544491864566j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3, 4)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunction_fromData_Solution_rank3(self):
        """
        tests gradient of rank 3 Data on Function

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(4, 2, 2),w)
        ref = Data(0,(4, 2, 2)+(dim,),w_ref)
        arg[0, 0, 0]=(-0.487094933057-0.252103871619j)*x[0]**o+((-0.745477030858+0.667944276165j))*x[0]+((-0.0682151984309+0.465637389201j))*x[1]**o+((0.888653353811+0.0209267542944j))*x[1]
        ref[0, 0, 0, 0]=(-0.487094933057-0.252103871619j)*o*x_ref[0]**(o-1)+((-0.745477030858+0.667944276165j))
        ref[0, 0, 0, 1]=(-0.0682151984309+0.465637389201j)*o*x_ref[1]**(o-1)+((0.888653353811+0.0209267542944j))
        arg[0, 0, 1]=(-0.848733960473-0.296172236188j)*x[0]**o+((-0.807242288726-0.593720266228j))*x[0]+((-0.693433030299-0.0520663627863j))*x[1]**o+((-0.547399346731+0.488848492224j))*x[1]
        ref[0, 0, 1, 0]=(-0.848733960473-0.296172236188j)*o*x_ref[0]**(o-1)+((-0.807242288726-0.593720266228j))
        ref[0, 0, 1, 1]=(-0.693433030299-0.0520663627863j)*o*x_ref[1]**(o-1)+((-0.547399346731+0.488848492224j))
        arg[0, 1, 0]=(-0.47714505255+0.897078276361j)*x[0]**o+((0.992785727726-0.757597256183j))*x[0]+((0.878866093707+0.275226765494j))*x[1]**o+((-0.600131842692+0.0359087632548j))*x[1]
        ref[0, 1, 0, 0]=(-0.47714505255+0.897078276361j)*o*x_ref[0]**(o-1)+((0.992785727726-0.757597256183j))
        ref[0, 1, 0, 1]=(0.878866093707+0.275226765494j)*o*x_ref[1]**(o-1)+((-0.600131842692+0.0359087632548j))
        arg[0, 1, 1]=(0.641309072956-0.452732228202j)*x[0]**o+((-0.392180539273+0.767069464788j))*x[0]+((0.529558430089-0.737462092265j))*x[1]**o+((-0.371885801157+0.864765713625j))*x[1]
        ref[0, 1, 1, 0]=(0.641309072956-0.452732228202j)*o*x_ref[0]**(o-1)+((-0.392180539273+0.767069464788j))
        ref[0, 1, 1, 1]=(0.529558430089-0.737462092265j)*o*x_ref[1]**(o-1)+((-0.371885801157+0.864765713625j))
        arg[1, 0, 0]=(0.52327795772+0.266723128485j)*x[0]**o+((0.877452906187+0.541122224532j))*x[0]+((-0.451959741147+0.698976395961j))*x[1]**o+((-0.0932563848823-0.125885481746j))*x[1]
        ref[1, 0, 0, 0]=(0.52327795772+0.266723128485j)*o*x_ref[0]**(o-1)+((0.877452906187+0.541122224532j))
        ref[1, 0, 0, 1]=(-0.451959741147+0.698976395961j)*o*x_ref[1]**(o-1)+((-0.0932563848823-0.125885481746j))
        arg[1, 0, 1]=(-0.713203668019-0.334536381585j)*x[0]**o+((-0.610240269584+0.347147816905j))*x[0]+((0.840154748086-0.513540576057j))*x[1]**o+((0.0857689654088-0.0361518591369j))*x[1]
        ref[1, 0, 1, 0]=(-0.713203668019-0.334536381585j)*o*x_ref[0]**(o-1)+((-0.610240269584+0.347147816905j))
        ref[1, 0, 1, 1]=(0.840154748086-0.513540576057j)*o*x_ref[1]**(o-1)+((0.0857689654088-0.0361518591369j))
        arg[1, 1, 0]=(0.186842062885+0.87110128235j)*x[0]**o+((-0.259417137694-0.241763907442j))*x[0]+((-0.381077807275+0.0545560509106j))*x[1]**o+((-0.682315828483-0.53550881827j))*x[1]
        ref[1, 1, 0, 0]=(0.186842062885+0.87110128235j)*o*x_ref[0]**(o-1)+((-0.259417137694-0.241763907442j))
        ref[1, 1, 0, 1]=(-0.381077807275+0.0545560509106j)*o*x_ref[1]**(o-1)+((-0.682315828483-0.53550881827j))
        arg[1, 1, 1]=(0.994304127682-0.539595127942j)*x[0]**o+((-0.0894207439214-0.439795238469j))*x[0]+((-0.336962784111+0.942727304706j))*x[1]**o+((0.535881348658-0.531484505762j))*x[1]
        ref[1, 1, 1, 0]=(0.994304127682-0.539595127942j)*o*x_ref[0]**(o-1)+((-0.0894207439214-0.439795238469j))
        ref[1, 1, 1, 1]=(-0.336962784111+0.942727304706j)*o*x_ref[1]**(o-1)+((0.535881348658-0.531484505762j))
        arg[2, 0, 0]=(-0.0445419324672+0.851678980722j)*x[0]**o+((-0.792540040141-0.278526037611j))*x[0]+((-0.598711142452-0.297622780097j))*x[1]**o+((0.857174328656+0.494724775548j))*x[1]
        ref[2, 0, 0, 0]=(-0.0445419324672+0.851678980722j)*o*x_ref[0]**(o-1)+((-0.792540040141-0.278526037611j))
        ref[2, 0, 0, 1]=(-0.598711142452-0.297622780097j)*o*x_ref[1]**(o-1)+((0.857174328656+0.494724775548j))
        arg[2, 0, 1]=(-0.303042125199-0.79318205319j)*x[0]**o+((-0.997142395497+0.896731713595j))*x[0]+((0.0670725411258+0.947887216331j))*x[1]**o+((-0.512517531672-0.703746382517j))*x[1]
        ref[2, 0, 1, 0]=(-0.303042125199-0.79318205319j)*o*x_ref[0]**(o-1)+((-0.997142395497+0.896731713595j))
        ref[2, 0, 1, 1]=(0.0670725411258+0.947887216331j)*o*x_ref[1]**(o-1)+((-0.512517531672-0.703746382517j))
        arg[2, 1, 0]=(0.01926463145-0.990967885299j)*x[0]**o+((0.513730195704-0.177205255872j))*x[0]+((-0.691160252136+0.53391926824j))*x[1]**o+((0.707804892018-0.355751565312j))*x[1]
        ref[2, 1, 0, 0]=(0.01926463145-0.990967885299j)*o*x_ref[0]**(o-1)+((0.513730195704-0.177205255872j))
        ref[2, 1, 0, 1]=(-0.691160252136+0.53391926824j)*o*x_ref[1]**(o-1)+((0.707804892018-0.355751565312j))
        arg[2, 1, 1]=(0.99863208717-0.364286879888j)*x[0]**o+((-0.669101406772+0.883766215443j))*x[0]+((0.790786346841+0.220054254106j))*x[1]**o+((0.421639101551-0.262052071221j))*x[1]
        ref[2, 1, 1, 0]=(0.99863208717-0.364286879888j)*o*x_ref[0]**(o-1)+((-0.669101406772+0.883766215443j))
        ref[2, 1, 1, 1]=(0.790786346841+0.220054254106j)*o*x_ref[1]**(o-1)+((0.421639101551-0.262052071221j))
        arg[3, 0, 0]=(-0.254448135275-0.655525360757j)*x[0]**o+((0.661448581061-0.846286882101j))*x[0]+((-0.404089751189-0.759842457143j))*x[1]**o+((0.0649770959136-0.653112155272j))*x[1]
        ref[3, 0, 0, 0]=(-0.254448135275-0.655525360757j)*o*x_ref[0]**(o-1)+((0.661448581061-0.846286882101j))
        ref[3, 0, 0, 1]=(-0.404089751189-0.759842457143j)*o*x_ref[1]**(o-1)+((0.0649770959136-0.653112155272j))
        arg[3, 0, 1]=(0.137041011156-0.512416634249j)*x[0]**o+((0.994538536365-0.821142427435j))*x[0]+((-0.0969158813022+0.1351388886j))*x[1]**o+((0.202474592633+0.852003741186j))*x[1]
        ref[3, 0, 1, 0]=(0.137041011156-0.512416634249j)*o*x_ref[0]**(o-1)+((0.994538536365-0.821142427435j))
        ref[3, 0, 1, 1]=(-0.0969158813022+0.1351388886j)*o*x_ref[1]**(o-1)+((0.202474592633+0.852003741186j))
        arg[3, 1, 0]=(-0.197373238079-0.335069641975j)*x[0]**o+((-0.207264262086+0.405145650104j))*x[0]+((0.924028073961+0.536045047679j))*x[1]**o+((0.42883166151+0.169425585465j))*x[1]
        ref[3, 1, 0, 0]=(-0.197373238079-0.335069641975j)*o*x_ref[0]**(o-1)+((-0.207264262086+0.405145650104j))
        ref[3, 1, 0, 1]=(0.924028073961+0.536045047679j)*o*x_ref[1]**(o-1)+((0.42883166151+0.169425585465j))
        arg[3, 1, 1]=(-0.368768179159+0.426431518475j)*x[0]**o+((-0.161421845543-0.487202907092j))*x[0]+((-0.43544316043+0.681074055684j))*x[1]**o+((-0.518678440603-0.507741763899j))*x[1]
        ref[3, 1, 1, 0]=(-0.368768179159+0.426431518475j)*o*x_ref[0]**(o-1)+((-0.161421845543-0.487202907092j))
        ref[3, 1, 1, 1]=(-0.43544316043+0.681074055684j)*o*x_ref[1]**(o-1)+((-0.518678440603-0.507741763899j))
        if dim==3:
            arg[0, 0, 0]+=(-0.289105667668+0.57232492275j)*x[2]**o+((0.508142706768-0.438122145859j))*x[2]
            ref[0, 0, 0, 2]=(-0.289105667668+0.57232492275j)*o*x_ref[2]**(o-1)+((0.508142706768-0.438122145859j))
            arg[0, 0, 1]+=(0.68223635658-0.0750831970474j)*x[2]**o+((0.441864103265+0.30007200463j))*x[2]
            ref[0, 0, 1, 2]=(0.68223635658-0.0750831970474j)*o*x_ref[2]**(o-1)+((0.441864103265+0.30007200463j))
            arg[0, 1, 0]+=(0.376888383496-0.971061337234j)*x[2]**o+((-0.23338772323+0.837593658232j))*x[2]
            ref[0, 1, 0, 2]=(0.376888383496-0.971061337234j)*o*x_ref[2]**(o-1)+((-0.23338772323+0.837593658232j))
            arg[0, 1, 1]+=(0.722320470275-0.867213760569j)*x[2]**o+((0.920990940013+0.117968473315j))*x[2]
            ref[0, 1, 1, 2]=(0.722320470275-0.867213760569j)*o*x_ref[2]**(o-1)+((0.920990940013+0.117968473315j))
            arg[1, 0, 0]+=(-0.635987991973+0.0248747398904j)*x[2]**o+((0.204593810609-0.906304603279j))*x[2]
            ref[1, 0, 0, 2]=(-0.635987991973+0.0248747398904j)*o*x_ref[2]**(o-1)+((0.204593810609-0.906304603279j))
            arg[1, 0, 1]+=(0.498407751838-0.0396043252771j)*x[2]**o+((-0.539415848248+0.194695197553j))*x[2]
            ref[1, 0, 1, 2]=(0.498407751838-0.0396043252771j)*o*x_ref[2]**(o-1)+((-0.539415848248+0.194695197553j))
            arg[1, 1, 0]+=(0.921415625859-0.00797615144579j)*x[2]**o+((-0.154349102061+0.273164906237j))*x[2]
            ref[1, 1, 0, 2]=(0.921415625859-0.00797615144579j)*o*x_ref[2]**(o-1)+((-0.154349102061+0.273164906237j))
            arg[1, 1, 1]+=(-0.491523437501-0.684687081408j)*x[2]**o+((0.810459134362-0.632165263521j))*x[2]
            ref[1, 1, 1, 2]=(-0.491523437501-0.684687081408j)*o*x_ref[2]**(o-1)+((0.810459134362-0.632165263521j))
            arg[2, 0, 0]+=(-0.903279322768+0.185922891434j)*x[2]**o+((-0.998088830564+0.407433720455j))*x[2]
            ref[2, 0, 0, 2]=(-0.903279322768+0.185922891434j)*o*x_ref[2]**(o-1)+((-0.998088830564+0.407433720455j))
            arg[2, 0, 1]+=(0.393596699876-0.145221455836j)*x[2]**o+((-0.53979634469-0.210246925287j))*x[2]
            ref[2, 0, 1, 2]=(0.393596699876-0.145221455836j)*o*x_ref[2]**(o-1)+((-0.53979634469-0.210246925287j))
            arg[2, 1, 0]+=(0.902728582057-0.84463072432j)*x[2]**o+((0.862750089398-0.596268409091j))*x[2]
            ref[2, 1, 0, 2]=(0.902728582057-0.84463072432j)*o*x_ref[2]**(o-1)+((0.862750089398-0.596268409091j))
            arg[2, 1, 1]+=(0.389087134192-0.293597358787j)*x[2]**o+((0.06238289741-0.1797091042j))*x[2]
            ref[2, 1, 1, 2]=(0.389087134192-0.293597358787j)*o*x_ref[2]**(o-1)+((0.06238289741-0.1797091042j))
            arg[3, 0, 0]+=(-0.0936132003633+0.328816475631j)*x[2]**o+((-0.983231860099-0.724787379049j))*x[2]
            ref[3, 0, 0, 2]=(-0.0936132003633+0.328816475631j)*o*x_ref[2]**(o-1)+((-0.983231860099-0.724787379049j))
            arg[3, 0, 1]+=(-0.401999025956+0.108215813531j)*x[2]**o+((-0.0447740634564-0.189886005779j))*x[2]
            ref[3, 0, 1, 2]=(-0.401999025956+0.108215813531j)*o*x_ref[2]**(o-1)+((-0.0447740634564-0.189886005779j))
            arg[3, 1, 0]+=(-0.156906874809+0.268448361403j)*x[2]**o+((-0.618143029537+0.269041399781j))*x[2]
            ref[3, 1, 0, 2]=(-0.156906874809+0.268448361403j)*o*x_ref[2]**(o-1)+((-0.618143029537+0.269041399781j))
            arg[3, 1, 1]+=(-0.704206178089+0.7778702086j)*x[2]**o+((-0.254114834781-0.674387808896j))*x[2]
            ref[3, 1, 1, 2]=(-0.704206178089+0.7778702086j)*o*x_ref[2]**(o-1)+((-0.254114834781-0.674387808896j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4, 2, 2)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunction_fromData_ReducedSolution_rank0(self):
        """
        tests gradient of rank 0 Data on Function

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=(-0.354635914456+0.859546352125j)*x[0]+((0.718056215127+0.924873803027j))*x[1]
        ref[0]=(-0.354635914456+0.859546352125j)
        ref[1]=(0.718056215127+0.924873803027j)
        if dim==3:
            arg+=((0.30621457076+0.206998401648j))*x[2]
            ref[2]=(0.30621457076+0.206998401648j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunction_fromData_ReducedSolution_rank1(self):
        """
        tests gradient of rank 1 Data on Function

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(2,),w)
        ref = Data(0,(2,)+(dim,),w_ref)
        arg[0,]=(0.700391923494-0.274381324435j)*x[0]+((-0.895754111055+0.5236744156j))*x[1]
        ref[0, 0]=(0.700391923494-0.274381324435j)
        ref[0, 1]=(-0.895754111055+0.5236744156j)
        arg[1,]=(-0.652254350627-0.976716709706j)*x[0]+((0.228234537881-0.157115399267j))*x[1]
        ref[1, 0]=(-0.652254350627-0.976716709706j)
        ref[1, 1]=(0.228234537881-0.157115399267j)
        if dim==3:
            arg[0,]+=(0.378316057133-0.940449224323j)*x[2]
            ref[0, 2]=(0.378316057133-0.940449224323j)
            arg[1,]+=(-0.479772353939+0.0656880114768j)*x[2]
            ref[1, 2]=(-0.479772353939+0.0656880114768j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunction_fromData_ReducedSolution_rank2(self):
        """
        tests gradient of rank 2 Data on Function

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(4, 3),w)
        ref = Data(0,(4, 3)+(dim,),w_ref)
        arg[0, 0]=(0.0505999972447+0.487396800897j)*x[0]+((0.476185146399+0.157350648796j))*x[1]
        ref[0, 0, 0]=(0.0505999972447+0.487396800897j)
        ref[0, 0, 1]=(0.476185146399+0.157350648796j)
        arg[0, 1]=(-0.440376760295+0.825894266457j)*x[0]+((0.669268519911+0.680243806807j))*x[1]
        ref[0, 1, 0]=(-0.440376760295+0.825894266457j)
        ref[0, 1, 1]=(0.669268519911+0.680243806807j)
        arg[0, 2]=(-0.144309049034+0.0481974873293j)*x[0]+((-0.086973510846-0.342820130583j))*x[1]
        ref[0, 2, 0]=(-0.144309049034+0.0481974873293j)
        ref[0, 2, 1]=(-0.086973510846-0.342820130583j)
        arg[1, 0]=(-0.268514488606+0.137771019068j)*x[0]+((0.58261053121-0.394041821795j))*x[1]
        ref[1, 0, 0]=(-0.268514488606+0.137771019068j)
        ref[1, 0, 1]=(0.58261053121-0.394041821795j)
        arg[1, 1]=(-0.727272642756+0.425375555991j)*x[0]+((-0.854420767122-0.94076765872j))*x[1]
        ref[1, 1, 0]=(-0.727272642756+0.425375555991j)
        ref[1, 1, 1]=(-0.854420767122-0.94076765872j)
        arg[1, 2]=(0.0483648031444-0.301810847896j)*x[0]+((0.132915885592+0.496737710312j))*x[1]
        ref[1, 2, 0]=(0.0483648031444-0.301810847896j)
        ref[1, 2, 1]=(0.132915885592+0.496737710312j)
        arg[2, 0]=(0.308444140035+0.383181931722j)*x[0]+((0.0456941760156+0.897344594777j))*x[1]
        ref[2, 0, 0]=(0.308444140035+0.383181931722j)
        ref[2, 0, 1]=(0.0456941760156+0.897344594777j)
        arg[2, 1]=(-0.501560926775-0.662909033585j)*x[0]+((-0.538246542283+0.846344798317j))*x[1]
        ref[2, 1, 0]=(-0.501560926775-0.662909033585j)
        ref[2, 1, 1]=(-0.538246542283+0.846344798317j)
        arg[2, 2]=(-0.442303950174-0.22454674108j)*x[0]+((-0.391167949173-0.746423777153j))*x[1]
        ref[2, 2, 0]=(-0.442303950174-0.22454674108j)
        ref[2, 2, 1]=(-0.391167949173-0.746423777153j)
        arg[3, 0]=(-0.868676351331-0.782658127882j)*x[0]+((0.870173452006-0.0441653464923j))*x[1]
        ref[3, 0, 0]=(-0.868676351331-0.782658127882j)
        ref[3, 0, 1]=(0.870173452006-0.0441653464923j)
        arg[3, 1]=(0.00325447682944-0.370990862165j)*x[0]+((0.404565955083+0.59622684438j))*x[1]
        ref[3, 1, 0]=(0.00325447682944-0.370990862165j)
        ref[3, 1, 1]=(0.404565955083+0.59622684438j)
        arg[3, 2]=(-0.909376585977-0.217911317998j)*x[0]+((0.723838950072+0.896746561383j))*x[1]
        ref[3, 2, 0]=(-0.909376585977-0.217911317998j)
        ref[3, 2, 1]=(0.723838950072+0.896746561383j)
        if dim==3:
            arg[0, 0]+=(0.077070962989+0.659053282472j)*x[2]
            ref[0, 0, 2]=(0.077070962989+0.659053282472j)
            arg[0, 1]+=(-0.830171227869+0.00256472350496j)*x[2]
            ref[0, 1, 2]=(-0.830171227869+0.00256472350496j)
            arg[0, 2]+=(-0.615052629429+0.802297666308j)*x[2]
            ref[0, 2, 2]=(-0.615052629429+0.802297666308j)
            arg[1, 0]+=(0.695294649278+0.700420022782j)*x[2]
            ref[1, 0, 2]=(0.695294649278+0.700420022782j)
            arg[1, 1]+=(-0.816949021838+0.796533413441j)*x[2]
            ref[1, 1, 2]=(-0.816949021838+0.796533413441j)
            arg[1, 2]+=(-0.164267317826+0.833929486906j)*x[2]
            ref[1, 2, 2]=(-0.164267317826+0.833929486906j)
            arg[2, 0]+=(-0.630098065839+0.0483961969486j)*x[2]
            ref[2, 0, 2]=(-0.630098065839+0.0483961969486j)
            arg[2, 1]+=(-0.518415823427+0.878609619952j)*x[2]
            ref[2, 1, 2]=(-0.518415823427+0.878609619952j)
            arg[2, 2]+=(0.926704462615-0.996861468354j)*x[2]
            ref[2, 2, 2]=(0.926704462615-0.996861468354j)
            arg[3, 0]+=(-0.814081312544-0.937618963472j)*x[2]
            ref[3, 0, 2]=(-0.814081312544-0.937618963472j)
            arg[3, 1]+=(-0.465250416275-0.173583164942j)*x[2]
            ref[3, 1, 2]=(-0.465250416275-0.173583164942j)
            arg[3, 2]+=(0.183237191102+0.0183513939043j)*x[2]
            ref[3, 2, 2]=(0.183237191102+0.0183513939043j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4, 3)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunction_fromData_ReducedSolution_rank3(self):
        """
        tests gradient of rank 3 Data on Function

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(3, 4, 2),w)
        ref = Data(0,(3, 4, 2)+(dim,),w_ref)
        arg[0, 0, 0]=(0.634998021609-0.766822015956j)*x[0]+((-0.54886528939+0.707744875345j))*x[1]
        ref[0, 0, 0, 0]=(0.634998021609-0.766822015956j)
        ref[0, 0, 0, 1]=(-0.54886528939+0.707744875345j)
        arg[0, 0, 1]=(0.486187690167-0.63259229135j)*x[0]+((0.222278503414+0.422976629137j))*x[1]
        ref[0, 0, 1, 0]=(0.486187690167-0.63259229135j)
        ref[0, 0, 1, 1]=(0.222278503414+0.422976629137j)
        arg[0, 1, 0]=(-0.407612969908-0.478189605989j)*x[0]+((-0.538207684641-0.904810174576j))*x[1]
        ref[0, 1, 0, 0]=(-0.407612969908-0.478189605989j)
        ref[0, 1, 0, 1]=(-0.538207684641-0.904810174576j)
        arg[0, 1, 1]=(0.896959968092+0.677077526955j)*x[0]+((0.529875463706-0.540187579854j))*x[1]
        ref[0, 1, 1, 0]=(0.896959968092+0.677077526955j)
        ref[0, 1, 1, 1]=(0.529875463706-0.540187579854j)
        arg[0, 2, 0]=(0.143022684963+0.191627425862j)*x[0]+((0.697134368953+0.0252658842402j))*x[1]
        ref[0, 2, 0, 0]=(0.143022684963+0.191627425862j)
        ref[0, 2, 0, 1]=(0.697134368953+0.0252658842402j)
        arg[0, 2, 1]=(0.510015802357+0.539925843085j)*x[0]+((0.564438036788+0.68572434421j))*x[1]
        ref[0, 2, 1, 0]=(0.510015802357+0.539925843085j)
        ref[0, 2, 1, 1]=(0.564438036788+0.68572434421j)
        arg[0, 3, 0]=(-0.748679717878+0.471017765979j)*x[0]+((-0.386954058286-0.823611093822j))*x[1]
        ref[0, 3, 0, 0]=(-0.748679717878+0.471017765979j)
        ref[0, 3, 0, 1]=(-0.386954058286-0.823611093822j)
        arg[0, 3, 1]=(-0.987030731889+0.196788441872j)*x[0]+((0.483562202852+0.328288632644j))*x[1]
        ref[0, 3, 1, 0]=(-0.987030731889+0.196788441872j)
        ref[0, 3, 1, 1]=(0.483562202852+0.328288632644j)
        arg[1, 0, 0]=(0.809110844546-0.459611692106j)*x[0]+((0.849253527112-0.651002546217j))*x[1]
        ref[1, 0, 0, 0]=(0.809110844546-0.459611692106j)
        ref[1, 0, 0, 1]=(0.849253527112-0.651002546217j)
        arg[1, 0, 1]=(-0.386984271529-0.851112469582j)*x[0]+((0.72146187331-0.472386313839j))*x[1]
        ref[1, 0, 1, 0]=(-0.386984271529-0.851112469582j)
        ref[1, 0, 1, 1]=(0.72146187331-0.472386313839j)
        arg[1, 1, 0]=(-0.343755756621-0.193851953488j)*x[0]+((0.00998192804603-0.38407119432j))*x[1]
        ref[1, 1, 0, 0]=(-0.343755756621-0.193851953488j)
        ref[1, 1, 0, 1]=(0.00998192804603-0.38407119432j)
        arg[1, 1, 1]=(-0.608564691922-0.95910308416j)*x[0]+((-0.996863626738+0.260709730379j))*x[1]
        ref[1, 1, 1, 0]=(-0.608564691922-0.95910308416j)
        ref[1, 1, 1, 1]=(-0.996863626738+0.260709730379j)
        arg[1, 2, 0]=(0.537132159856+0.454524871089j)*x[0]+((0.438575772574+0.270383608978j))*x[1]
        ref[1, 2, 0, 0]=(0.537132159856+0.454524871089j)
        ref[1, 2, 0, 1]=(0.438575772574+0.270383608978j)
        arg[1, 2, 1]=(-0.117544142729-0.555957980988j)*x[0]+((0.355193041203+0.445021372968j))*x[1]
        ref[1, 2, 1, 0]=(-0.117544142729-0.555957980988j)
        ref[1, 2, 1, 1]=(0.355193041203+0.445021372968j)
        arg[1, 3, 0]=(0.15511801186+0.0443492976276j)*x[0]+((-0.980585010055-0.306165547413j))*x[1]
        ref[1, 3, 0, 0]=(0.15511801186+0.0443492976276j)
        ref[1, 3, 0, 1]=(-0.980585010055-0.306165547413j)
        arg[1, 3, 1]=(0.563434059453+0.053705347468j)*x[0]+((0.279637646324+0.748815152857j))*x[1]
        ref[1, 3, 1, 0]=(0.563434059453+0.053705347468j)
        ref[1, 3, 1, 1]=(0.279637646324+0.748815152857j)
        arg[2, 0, 0]=(0.857440650121+0.0516482287367j)*x[0]+((0.42518571949-0.594588549749j))*x[1]
        ref[2, 0, 0, 0]=(0.857440650121+0.0516482287367j)
        ref[2, 0, 0, 1]=(0.42518571949-0.594588549749j)
        arg[2, 0, 1]=(-0.716690266193+0.846526011236j)*x[0]+((0.501397715903-0.91139668077j))*x[1]
        ref[2, 0, 1, 0]=(-0.716690266193+0.846526011236j)
        ref[2, 0, 1, 1]=(0.501397715903-0.91139668077j)
        arg[2, 1, 0]=(-0.919384699272+0.168997095494j)*x[0]+((-0.702124992574+0.735903650831j))*x[1]
        ref[2, 1, 0, 0]=(-0.919384699272+0.168997095494j)
        ref[2, 1, 0, 1]=(-0.702124992574+0.735903650831j)
        arg[2, 1, 1]=(0.229368768257-0.303965768008j)*x[0]+((0.675969651246-0.367386145701j))*x[1]
        ref[2, 1, 1, 0]=(0.229368768257-0.303965768008j)
        ref[2, 1, 1, 1]=(0.675969651246-0.367386145701j)
        arg[2, 2, 0]=(0.931626779456-0.839386284018j)*x[0]+((-0.755634992604+0.87478760879j))*x[1]
        ref[2, 2, 0, 0]=(0.931626779456-0.839386284018j)
        ref[2, 2, 0, 1]=(-0.755634992604+0.87478760879j)
        arg[2, 2, 1]=(0.0490568052272+0.71154384317j)*x[0]+((-0.309711309216-0.623273428668j))*x[1]
        ref[2, 2, 1, 0]=(0.0490568052272+0.71154384317j)
        ref[2, 2, 1, 1]=(-0.309711309216-0.623273428668j)
        arg[2, 3, 0]=(-0.920213390358+0.593469718692j)*x[0]+((-0.470979044925+0.88184046006j))*x[1]
        ref[2, 3, 0, 0]=(-0.920213390358+0.593469718692j)
        ref[2, 3, 0, 1]=(-0.470979044925+0.88184046006j)
        arg[2, 3, 1]=(0.810312198206+0.612264828172j)*x[0]+((0.371148434417-0.0354436886991j))*x[1]
        ref[2, 3, 1, 0]=(0.810312198206+0.612264828172j)
        ref[2, 3, 1, 1]=(0.371148434417-0.0354436886991j)
        if dim==3:
            arg[0, 0, 0]+=(0.86782968994-0.684306050454j)*x[2]
            ref[0, 0, 0, 2]=(0.86782968994-0.684306050454j)
            arg[0, 0, 1]+=(0.561235697448+0.462237459077j)*x[2]
            ref[0, 0, 1, 2]=(0.561235697448+0.462237459077j)
            arg[0, 1, 0]+=(0.00553293116804-0.806631996682j)*x[2]
            ref[0, 1, 0, 2]=(0.00553293116804-0.806631996682j)
            arg[0, 1, 1]+=(-0.553200649605-0.86703547324j)*x[2]
            ref[0, 1, 1, 2]=(-0.553200649605-0.86703547324j)
            arg[0, 2, 0]+=(-0.252000218321-0.0452245645595j)*x[2]
            ref[0, 2, 0, 2]=(-0.252000218321-0.0452245645595j)
            arg[0, 2, 1]+=(0.281746402602+0.629291154842j)*x[2]
            ref[0, 2, 1, 2]=(0.281746402602+0.629291154842j)
            arg[0, 3, 0]+=(0.501382586674-0.616944349919j)*x[2]
            ref[0, 3, 0, 2]=(0.501382586674-0.616944349919j)
            arg[0, 3, 1]+=(0.404830971996+0.0134230705565j)*x[2]
            ref[0, 3, 1, 2]=(0.404830971996+0.0134230705565j)
            arg[1, 0, 0]+=(0.397876327971-0.16257044245j)*x[2]
            ref[1, 0, 0, 2]=(0.397876327971-0.16257044245j)
            arg[1, 0, 1]+=(-0.143743464908+0.6247669042j)*x[2]
            ref[1, 0, 1, 2]=(-0.143743464908+0.6247669042j)
            arg[1, 1, 0]+=(-0.46672629226+0.488699580473j)*x[2]
            ref[1, 1, 0, 2]=(-0.46672629226+0.488699580473j)
            arg[1, 1, 1]+=(-0.903708040344+0.584354246306j)*x[2]
            ref[1, 1, 1, 2]=(-0.903708040344+0.584354246306j)
            arg[1, 2, 0]+=(0.0164232871037-0.380058947002j)*x[2]
            ref[1, 2, 0, 2]=(0.0164232871037-0.380058947002j)
            arg[1, 2, 1]+=(-0.71040266838+0.114370134499j)*x[2]
            ref[1, 2, 1, 2]=(-0.71040266838+0.114370134499j)
            arg[1, 3, 0]+=(-0.450757657542-0.118182756152j)*x[2]
            ref[1, 3, 0, 2]=(-0.450757657542-0.118182756152j)
            arg[1, 3, 1]+=(0.917608624913-0.270217824338j)*x[2]
            ref[1, 3, 1, 2]=(0.917608624913-0.270217824338j)
            arg[2, 0, 0]+=(0.206928065134+0.256696143385j)*x[2]
            ref[2, 0, 0, 2]=(0.206928065134+0.256696143385j)
            arg[2, 0, 1]+=(0.292157721928-0.641551427492j)*x[2]
            ref[2, 0, 1, 2]=(0.292157721928-0.641551427492j)
            arg[2, 1, 0]+=(0.356731147-0.250900956454j)*x[2]
            ref[2, 1, 0, 2]=(0.356731147-0.250900956454j)
            arg[2, 1, 1]+=(0.279991446515+0.948855917231j)*x[2]
            ref[2, 1, 1, 2]=(0.279991446515+0.948855917231j)
            arg[2, 2, 0]+=(-0.252146701348-0.249593191169j)*x[2]
            ref[2, 2, 0, 2]=(-0.252146701348-0.249593191169j)
            arg[2, 2, 1]+=(0.742608258752+0.303555922167j)*x[2]
            ref[2, 2, 1, 2]=(0.742608258752+0.303555922167j)
            arg[2, 3, 0]+=(-0.372415240859-0.724742392509j)*x[2]
            ref[2, 3, 0, 2]=(-0.372415240859-0.724742392509j)
            arg[2, 3, 1]+=(0.892231361812-0.284405439369j)*x[2]
            ref[2, 3, 1, 2]=(0.892231361812-0.284405439369j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3, 4, 2)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunction_fromData_ReducedContinuousFunction_rank0(self):
        """
        tests gradient of rank 0 Data on Function

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=(-0.835588911107-0.186037808402j)*x[0]+((0.799341404352-0.912460415984j))*x[1]
        ref[0]=(-0.835588911107-0.186037808402j)
        ref[1]=(0.799341404352-0.912460415984j)
        if dim==3:
            arg+=((0.0934890726532-0.0202519432984j))*x[2]
            ref[2]=(0.0934890726532-0.0202519432984j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunction_fromData_ReducedContinuousFunction_rank1(self):
        """
        tests gradient of rank 1 Data on Function

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(2,),w)
        ref = Data(0,(2,)+(dim,),w_ref)
        arg[0,]=(-0.608003929878+0.61457688657j)*x[0]+((-0.740040094238-0.906211146905j))*x[1]
        ref[0, 0]=(-0.608003929878+0.61457688657j)
        ref[0, 1]=(-0.740040094238-0.906211146905j)
        arg[1,]=(-0.950648504354+0.934591098738j)*x[0]+((0.766366341592-0.574208025647j))*x[1]
        ref[1, 0]=(-0.950648504354+0.934591098738j)
        ref[1, 1]=(0.766366341592-0.574208025647j)
        if dim==3:
            arg[0,]+=(-0.887025989843+0.748907587418j)*x[2]
            ref[0, 2]=(-0.887025989843+0.748907587418j)
            arg[1,]+=(0.73832182871+0.993725440946j)*x[2]
            ref[1, 2]=(0.73832182871+0.993725440946j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunction_fromData_ReducedContinuousFunction_rank2(self):
        """
        tests gradient of rank 2 Data on Function

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(4, 2),w)
        ref = Data(0,(4, 2)+(dim,),w_ref)
        arg[0, 0]=(-0.420462668757+0.0148434132435j)*x[0]+((0.287979082552+0.689097618309j))*x[1]
        ref[0, 0, 0]=(-0.420462668757+0.0148434132435j)
        ref[0, 0, 1]=(0.287979082552+0.689097618309j)
        arg[0, 1]=(-0.775897588065+0.977659833422j)*x[0]+((0.968688774935-0.700192388511j))*x[1]
        ref[0, 1, 0]=(-0.775897588065+0.977659833422j)
        ref[0, 1, 1]=(0.968688774935-0.700192388511j)
        arg[1, 0]=(-0.486375999353+0.73871076968j)*x[0]+((0.139963820539+0.28716898727j))*x[1]
        ref[1, 0, 0]=(-0.486375999353+0.73871076968j)
        ref[1, 0, 1]=(0.139963820539+0.28716898727j)
        arg[1, 1]=(0.13077294594-0.371644916405j)*x[0]+((0.206313136624-0.195210676199j))*x[1]
        ref[1, 1, 0]=(0.13077294594-0.371644916405j)
        ref[1, 1, 1]=(0.206313136624-0.195210676199j)
        arg[2, 0]=(-0.706327282633-0.21982166408j)*x[0]+((0.330135950181-0.871881760985j))*x[1]
        ref[2, 0, 0]=(-0.706327282633-0.21982166408j)
        ref[2, 0, 1]=(0.330135950181-0.871881760985j)
        arg[2, 1]=(-0.971013443702+0.140967162384j)*x[0]+((0.336084099247-0.926381503492j))*x[1]
        ref[2, 1, 0]=(-0.971013443702+0.140967162384j)
        ref[2, 1, 1]=(0.336084099247-0.926381503492j)
        arg[3, 0]=(0.460625064533+0.863044176748j)*x[0]+((-0.888378888248-0.418646213936j))*x[1]
        ref[3, 0, 0]=(0.460625064533+0.863044176748j)
        ref[3, 0, 1]=(-0.888378888248-0.418646213936j)
        arg[3, 1]=(0.765538056946+0.598331198032j)*x[0]+((-0.461571108343-0.853298239305j))*x[1]
        ref[3, 1, 0]=(0.765538056946+0.598331198032j)
        ref[3, 1, 1]=(-0.461571108343-0.853298239305j)
        if dim==3:
            arg[0, 0]+=(0.130958645807-0.848335345137j)*x[2]
            ref[0, 0, 2]=(0.130958645807-0.848335345137j)
            arg[0, 1]+=(0.149412855005+0.624168785192j)*x[2]
            ref[0, 1, 2]=(0.149412855005+0.624168785192j)
            arg[1, 0]+=(-0.230251300666-0.995065833415j)*x[2]
            ref[1, 0, 2]=(-0.230251300666-0.995065833415j)
            arg[1, 1]+=(-0.826661389817-0.830171243107j)*x[2]
            ref[1, 1, 2]=(-0.826661389817-0.830171243107j)
            arg[2, 0]+=(-0.284693129878-0.0304690467914j)*x[2]
            ref[2, 0, 2]=(-0.284693129878-0.0304690467914j)
            arg[2, 1]+=(0.674214037992+0.646602201108j)*x[2]
            ref[2, 1, 2]=(0.674214037992+0.646602201108j)
            arg[3, 0]+=(0.958314145397-0.579327383235j)*x[2]
            ref[3, 0, 2]=(0.958314145397-0.579327383235j)
            arg[3, 1]+=(-0.750733793432-0.872776200752j)*x[2]
            ref[3, 1, 2]=(-0.750733793432-0.872776200752j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4, 2)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunction_fromData_ReducedContinuousFunction_rank3(self):
        """
        tests gradient of rank 3 Data on Function

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(2, 2, 3),w)
        ref = Data(0,(2, 2, 3)+(dim,),w_ref)
        arg[0, 0, 0]=(0.856554484574-0.266273084072j)*x[0]+((-0.942253191451+0.816783266829j))*x[1]
        ref[0, 0, 0, 0]=(0.856554484574-0.266273084072j)
        ref[0, 0, 0, 1]=(-0.942253191451+0.816783266829j)
        arg[0, 0, 1]=(0.602870815428+0.366561759667j)*x[0]+((0.233569790827-0.418456224995j))*x[1]
        ref[0, 0, 1, 0]=(0.602870815428+0.366561759667j)
        ref[0, 0, 1, 1]=(0.233569790827-0.418456224995j)
        arg[0, 0, 2]=(0.492349256818+0.610281150624j)*x[0]+((-0.514951499872+0.818368105355j))*x[1]
        ref[0, 0, 2, 0]=(0.492349256818+0.610281150624j)
        ref[0, 0, 2, 1]=(-0.514951499872+0.818368105355j)
        arg[0, 1, 0]=(0.677677034868+0.393239256955j)*x[0]+((0.0403723454648-0.7490176652j))*x[1]
        ref[0, 1, 0, 0]=(0.677677034868+0.393239256955j)
        ref[0, 1, 0, 1]=(0.0403723454648-0.7490176652j)
        arg[0, 1, 1]=(-0.323414893206+0.761064780042j)*x[0]+((0.794793697688+0.250925923685j))*x[1]
        ref[0, 1, 1, 0]=(-0.323414893206+0.761064780042j)
        ref[0, 1, 1, 1]=(0.794793697688+0.250925923685j)
        arg[0, 1, 2]=(0.319107843441+0.235206604037j)*x[0]+((-0.0142319543543+0.441469626659j))*x[1]
        ref[0, 1, 2, 0]=(0.319107843441+0.235206604037j)
        ref[0, 1, 2, 1]=(-0.0142319543543+0.441469626659j)
        arg[1, 0, 0]=(-0.998384607937+0.977726846035j)*x[0]+((-0.411972307205+0.0190645688526j))*x[1]
        ref[1, 0, 0, 0]=(-0.998384607937+0.977726846035j)
        ref[1, 0, 0, 1]=(-0.411972307205+0.0190645688526j)
        arg[1, 0, 1]=(-0.0810693822136-0.207153572907j)*x[0]+((0.153778095211-0.156073842115j))*x[1]
        ref[1, 0, 1, 0]=(-0.0810693822136-0.207153572907j)
        ref[1, 0, 1, 1]=(0.153778095211-0.156073842115j)
        arg[1, 0, 2]=(-0.423827070616-0.436039169545j)*x[0]+((0.578503395639+0.229653213051j))*x[1]
        ref[1, 0, 2, 0]=(-0.423827070616-0.436039169545j)
        ref[1, 0, 2, 1]=(0.578503395639+0.229653213051j)
        arg[1, 1, 0]=(0.270679358512+0.545944783635j)*x[0]+((-0.978110979715+0.716919103204j))*x[1]
        ref[1, 1, 0, 0]=(0.270679358512+0.545944783635j)
        ref[1, 1, 0, 1]=(-0.978110979715+0.716919103204j)
        arg[1, 1, 1]=(0.12649234375-0.565048920953j)*x[0]+((-0.262280471424-0.7578955585j))*x[1]
        ref[1, 1, 1, 0]=(0.12649234375-0.565048920953j)
        ref[1, 1, 1, 1]=(-0.262280471424-0.7578955585j)
        arg[1, 1, 2]=(-0.390902729531-0.72497049369j)*x[0]+((-0.339843867577+0.879493896644j))*x[1]
        ref[1, 1, 2, 0]=(-0.390902729531-0.72497049369j)
        ref[1, 1, 2, 1]=(-0.339843867577+0.879493896644j)
        if dim==3:
            arg[0, 0, 0]+=(-0.416308892567-0.29126159232j)*x[2]
            ref[0, 0, 0, 2]=(-0.416308892567-0.29126159232j)
            arg[0, 0, 1]+=(-0.378204744522+0.762008586041j)*x[2]
            ref[0, 0, 1, 2]=(-0.378204744522+0.762008586041j)
            arg[0, 0, 2]+=(0.807144556673-0.688098367709j)*x[2]
            ref[0, 0, 2, 2]=(0.807144556673-0.688098367709j)
            arg[0, 1, 0]+=(-0.491010007167+0.209118319419j)*x[2]
            ref[0, 1, 0, 2]=(-0.491010007167+0.209118319419j)
            arg[0, 1, 1]+=(0.656896732899-0.294666481401j)*x[2]
            ref[0, 1, 1, 2]=(0.656896732899-0.294666481401j)
            arg[0, 1, 2]+=(0.189302482725-0.105093496046j)*x[2]
            ref[0, 1, 2, 2]=(0.189302482725-0.105093496046j)
            arg[1, 0, 0]+=(-0.567907641237-0.349394418124j)*x[2]
            ref[1, 0, 0, 2]=(-0.567907641237-0.349394418124j)
            arg[1, 0, 1]+=(-0.746336203559-0.0373776835972j)*x[2]
            ref[1, 0, 1, 2]=(-0.746336203559-0.0373776835972j)
            arg[1, 0, 2]+=(-0.542371746271+0.409150975715j)*x[2]
            ref[1, 0, 2, 2]=(-0.542371746271+0.409150975715j)
            arg[1, 1, 0]+=(-0.590735157932-0.846331241546j)*x[2]
            ref[1, 1, 0, 2]=(-0.590735157932-0.846331241546j)
            arg[1, 1, 1]+=(0.913619678157+0.126549843079j)*x[2]
            ref[1, 1, 1, 2]=(0.913619678157+0.126549843079j)
            arg[1, 1, 2]+=(-0.948252565312-0.682866903724j)*x[2]
            ref[1, 1, 2, 2]=(-0.948252565312-0.682866903724j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2, 2, 3)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunction_fromData_ContinuousFunction_rank0(self):
        """
        tests gradient of rank 0 Data on ReducedFunction

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=(-0.491363741803-0.0193960668289j)*x[0]**o+((0.24658779359+0.387789313407j))*x[0]+((-0.356440654801-0.766779384539j))*x[1]**o+((-0.526426404978-0.786033185768j))*x[1]
        ref[0]=(-0.491363741803-0.0193960668289j)*o*x_ref[0]**(o-1)+((0.24658779359+0.387789313407j))
        ref[1]=(-0.356440654801-0.766779384539j)*o*x_ref[1]**(o-1)+((-0.526426404978-0.786033185768j))
        if dim==3:
            arg+=((0.371482985742-0.543346345754j))*x[2]**o+((-0.94806394186-0.63056462724j))*x[2]
            ref[2]=(0.371482985742-0.543346345754j)*o*x_ref[2]**(o-1)+((-0.94806394186-0.63056462724j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunction_fromData_ContinuousFunction_rank1(self):
        """
        tests gradient of rank 1 Data on ReducedFunction

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(3,),w)
        ref = Data(0,(3,)+(dim,),w_ref)
        arg[0,]=(0.39257292439+0.720410925286j)*x[0]**o+((0.895905403205+0.433545875422j))*x[0]+((0.579567660964+0.712233868012j))*x[1]**o+((0.078576850049-0.102775091126j))*x[1]
        ref[0, 0]=(0.39257292439+0.720410925286j)*o*x_ref[0]**(o-1)+((0.895905403205+0.433545875422j))
        ref[0, 1]=(0.579567660964+0.712233868012j)*o*x_ref[1]**(o-1)+((0.078576850049-0.102775091126j))
        arg[1,]=(0.966016255157+0.276759840284j)*x[0]**o+((0.534754020494-0.150563540988j))*x[0]+((-0.110371285747-0.0717660935892j))*x[1]**o+((-0.462822650364-0.549262824533j))*x[1]
        ref[1, 0]=(0.966016255157+0.276759840284j)*o*x_ref[0]**(o-1)+((0.534754020494-0.150563540988j))
        ref[1, 1]=(-0.110371285747-0.0717660935892j)*o*x_ref[1]**(o-1)+((-0.462822650364-0.549262824533j))
        arg[2,]=(-0.663735323998+0.714240353789j)*x[0]**o+((-0.459056100497+0.653265478688j))*x[0]+((-0.997310876025-0.79455572513j))*x[1]**o+((0.185183104516-0.808013782477j))*x[1]
        ref[2, 0]=(-0.663735323998+0.714240353789j)*o*x_ref[0]**(o-1)+((-0.459056100497+0.653265478688j))
        ref[2, 1]=(-0.997310876025-0.79455572513j)*o*x_ref[1]**(o-1)+((0.185183104516-0.808013782477j))
        if dim==3:
            arg[0,]+=(0.329234258248+0.688827228486j)*x[2]**o+((0.74442808996+0.857573237604j))*x[2]
            ref[0, 2]=(0.329234258248+0.688827228486j)*o*x_ref[2]**(o-1)+((0.74442808996+0.857573237604j))
            arg[1,]+=(-0.0837820523517+0.852419107914j)*x[2]**o+((-0.931403918088-0.653576035076j))*x[2]
            ref[1, 2]=(-0.0837820523517+0.852419107914j)*o*x_ref[2]**(o-1)+((-0.931403918088-0.653576035076j))
            arg[2,]+=(-0.452407692047-0.435896686319j)*x[2]**o+((-0.372012265607-0.975743323945j))*x[2]
            ref[2, 2]=(-0.452407692047-0.435896686319j)*o*x_ref[2]**(o-1)+((-0.372012265607-0.975743323945j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunction_fromData_ContinuousFunction_rank2(self):
        """
        tests gradient of rank 2 Data on ReducedFunction

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(3, 3),w)
        ref = Data(0,(3, 3)+(dim,),w_ref)
        arg[0, 0]=(-0.558250003422-0.484642505861j)*x[0]**o+((-0.139650577046-0.722101859723j))*x[0]+((0.252281631959-0.48444786419j))*x[1]**o+((-0.429474289046-0.110122764225j))*x[1]
        ref[0, 0, 0]=(-0.558250003422-0.484642505861j)*o*x_ref[0]**(o-1)+((-0.139650577046-0.722101859723j))
        ref[0, 0, 1]=(0.252281631959-0.48444786419j)*o*x_ref[1]**(o-1)+((-0.429474289046-0.110122764225j))
        arg[0, 1]=(-0.980144797654-0.0826288195567j)*x[0]**o+((-0.96925356135-0.125689330825j))*x[0]+((0.144677687192-0.23104814925j))*x[1]**o+((0.470989318866+0.754329013758j))*x[1]
        ref[0, 1, 0]=(-0.980144797654-0.0826288195567j)*o*x_ref[0]**(o-1)+((-0.96925356135-0.125689330825j))
        ref[0, 1, 1]=(0.144677687192-0.23104814925j)*o*x_ref[1]**(o-1)+((0.470989318866+0.754329013758j))
        arg[0, 2]=(-0.354722845434-0.784461292127j)*x[0]**o+((0.907928870175-0.157287781068j))*x[0]+((0.0457346185313+0.711772670795j))*x[1]**o+((-0.306866907164+0.100612316049j))*x[1]
        ref[0, 2, 0]=(-0.354722845434-0.784461292127j)*o*x_ref[0]**(o-1)+((0.907928870175-0.157287781068j))
        ref[0, 2, 1]=(0.0457346185313+0.711772670795j)*o*x_ref[1]**(o-1)+((-0.306866907164+0.100612316049j))
        arg[1, 0]=(-0.531378582875+0.118711598183j)*x[0]**o+((0.180750612905+0.78891242896j))*x[0]+((-0.350281000549+0.141805011269j))*x[1]**o+((0.437365961202-0.380051246542j))*x[1]
        ref[1, 0, 0]=(-0.531378582875+0.118711598183j)*o*x_ref[0]**(o-1)+((0.180750612905+0.78891242896j))
        ref[1, 0, 1]=(-0.350281000549+0.141805011269j)*o*x_ref[1]**(o-1)+((0.437365961202-0.380051246542j))
        arg[1, 1]=(-0.871943184702+0.604097305003j)*x[0]**o+((-0.819546772049-0.617854145707j))*x[0]+((0.579759274356+0.0807292429875j))*x[1]**o+((0.578807690672+0.648124996755j))*x[1]
        ref[1, 1, 0]=(-0.871943184702+0.604097305003j)*o*x_ref[0]**(o-1)+((-0.819546772049-0.617854145707j))
        ref[1, 1, 1]=(0.579759274356+0.0807292429875j)*o*x_ref[1]**(o-1)+((0.578807690672+0.648124996755j))
        arg[1, 2]=(-0.0385631250672-0.8898248636j)*x[0]**o+((0.210370900964-0.435632007955j))*x[0]+((0.146967904632+0.908534834406j))*x[1]**o+((0.627909984041+0.583014646344j))*x[1]
        ref[1, 2, 0]=(-0.0385631250672-0.8898248636j)*o*x_ref[0]**(o-1)+((0.210370900964-0.435632007955j))
        ref[1, 2, 1]=(0.146967904632+0.908534834406j)*o*x_ref[1]**(o-1)+((0.627909984041+0.583014646344j))
        arg[2, 0]=(-0.405899907913+0.420930413399j)*x[0]**o+((0.310658384665+0.393572336894j))*x[0]+((-0.778048357014-0.152245086291j))*x[1]**o+((0.0158889671973+0.357298355805j))*x[1]
        ref[2, 0, 0]=(-0.405899907913+0.420930413399j)*o*x_ref[0]**(o-1)+((0.310658384665+0.393572336894j))
        ref[2, 0, 1]=(-0.778048357014-0.152245086291j)*o*x_ref[1]**(o-1)+((0.0158889671973+0.357298355805j))
        arg[2, 1]=(0.272434865488+0.937366362447j)*x[0]**o+((-0.117261913095-0.247576229543j))*x[0]+((-0.726381522765+0.586382608565j))*x[1]**o+((0.54304643527-0.857361810484j))*x[1]
        ref[2, 1, 0]=(0.272434865488+0.937366362447j)*o*x_ref[0]**(o-1)+((-0.117261913095-0.247576229543j))
        ref[2, 1, 1]=(-0.726381522765+0.586382608565j)*o*x_ref[1]**(o-1)+((0.54304643527-0.857361810484j))
        arg[2, 2]=(-0.838022613303-0.483944901613j)*x[0]**o+((0.00500057392554+0.0479163735759j))*x[0]+((0.114003648768+0.978272721586j))*x[1]**o+((-0.707533203043-0.805534197128j))*x[1]
        ref[2, 2, 0]=(-0.838022613303-0.483944901613j)*o*x_ref[0]**(o-1)+((0.00500057392554+0.0479163735759j))
        ref[2, 2, 1]=(0.114003648768+0.978272721586j)*o*x_ref[1]**(o-1)+((-0.707533203043-0.805534197128j))
        if dim==3:
            arg[0, 0]+=(-0.781734478156+0.671889821962j)*x[2]**o+((-0.670809698636-0.00741648643013j))*x[2]
            ref[0, 0, 2]=(-0.781734478156+0.671889821962j)*o*x_ref[2]**(o-1)+((-0.670809698636-0.00741648643013j))
            arg[0, 1]+=(-0.881302271408-0.607502546773j)*x[2]**o+((-0.115267961295+0.992586031894j))*x[2]
            ref[0, 1, 2]=(-0.881302271408-0.607502546773j)*o*x_ref[2]**(o-1)+((-0.115267961295+0.992586031894j))
            arg[0, 2]+=(0.651996269972+0.90270158982j)*x[2]**o+((0.143774075967+0.449853638908j))*x[2]
            ref[0, 2, 2]=(0.651996269972+0.90270158982j)*o*x_ref[2]**(o-1)+((0.143774075967+0.449853638908j))
            arg[1, 0]+=(-0.568251211162-0.135232763834j)*x[2]**o+((-0.993391412237+0.302369148056j))*x[2]
            ref[1, 0, 2]=(-0.568251211162-0.135232763834j)*o*x_ref[2]**(o-1)+((-0.993391412237+0.302369148056j))
            arg[1, 1]+=(-0.6830259085-0.774153790496j)*x[2]**o+((0.554842631929+0.759595088266j))*x[2]
            ref[1, 1, 2]=(-0.6830259085-0.774153790496j)*o*x_ref[2]**(o-1)+((0.554842631929+0.759595088266j))
            arg[1, 2]+=(-0.610088835867-0.920440108615j)*x[2]**o+((0.0875743315215+0.571305101153j))*x[2]
            ref[1, 2, 2]=(-0.610088835867-0.920440108615j)*o*x_ref[2]**(o-1)+((0.0875743315215+0.571305101153j))
            arg[2, 0]+=(-0.54289086921-0.396025236083j)*x[2]**o+((-0.9993836589+0.314023125043j))*x[2]
            ref[2, 0, 2]=(-0.54289086921-0.396025236083j)*o*x_ref[2]**(o-1)+((-0.9993836589+0.314023125043j))
            arg[2, 1]+=(0.920831458284+0.0903118247337j)*x[2]**o+((-0.692102437229+0.811889001428j))*x[2]
            ref[2, 1, 2]=(0.920831458284+0.0903118247337j)*o*x_ref[2]**(o-1)+((-0.692102437229+0.811889001428j))
            arg[2, 2]+=(0.647466664315+0.175031006227j)*x[2]**o+((0.330237368848+0.110359826288j))*x[2]
            ref[2, 2, 2]=(0.647466664315+0.175031006227j)*o*x_ref[2]**(o-1)+((0.330237368848+0.110359826288j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3, 3)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunction_fromData_ContinuousFunction_rank3(self):
        """
        tests gradient of rank 3 Data on ReducedFunction

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(2, 3, 2),w)
        ref = Data(0,(2, 3, 2)+(dim,),w_ref)
        arg[0, 0, 0]=(-0.508850898527+0.58414735738j)*x[0]**o+((-0.103517629449-0.222968070673j))*x[0]+((-0.762081981865+0.774865123857j))*x[1]**o+((-0.0727494292159+0.132338605838j))*x[1]
        ref[0, 0, 0, 0]=(-0.508850898527+0.58414735738j)*o*x_ref[0]**(o-1)+((-0.103517629449-0.222968070673j))
        ref[0, 0, 0, 1]=(-0.762081981865+0.774865123857j)*o*x_ref[1]**(o-1)+((-0.0727494292159+0.132338605838j))
        arg[0, 0, 1]=(-0.880530358004-0.276322156353j)*x[0]**o+((0.348475981646-0.450364203472j))*x[0]+((-0.543898903968-0.0991188196791j))*x[1]**o+((0.546054308578+0.619194982569j))*x[1]
        ref[0, 0, 1, 0]=(-0.880530358004-0.276322156353j)*o*x_ref[0]**(o-1)+((0.348475981646-0.450364203472j))
        ref[0, 0, 1, 1]=(-0.543898903968-0.0991188196791j)*o*x_ref[1]**(o-1)+((0.546054308578+0.619194982569j))
        arg[0, 1, 0]=(-0.307645130698+0.880518707569j)*x[0]**o+((0.262883203802+0.231526172157j))*x[0]+((0.979288456043+0.717985954954j))*x[1]**o+((0.300961230073-0.317826607073j))*x[1]
        ref[0, 1, 0, 0]=(-0.307645130698+0.880518707569j)*o*x_ref[0]**(o-1)+((0.262883203802+0.231526172157j))
        ref[0, 1, 0, 1]=(0.979288456043+0.717985954954j)*o*x_ref[1]**(o-1)+((0.300961230073-0.317826607073j))
        arg[0, 1, 1]=(0.880821656279-0.521677867758j)*x[0]**o+((-0.570885503497+0.923164748854j))*x[0]+((0.00971805305223-0.423518204276j))*x[1]**o+((-0.45567930775-0.567177448055j))*x[1]
        ref[0, 1, 1, 0]=(0.880821656279-0.521677867758j)*o*x_ref[0]**(o-1)+((-0.570885503497+0.923164748854j))
        ref[0, 1, 1, 1]=(0.00971805305223-0.423518204276j)*o*x_ref[1]**(o-1)+((-0.45567930775-0.567177448055j))
        arg[0, 2, 0]=(-0.073270041854+0.27046894336j)*x[0]**o+((0.542343016577-0.708375725238j))*x[0]+((0.138232709404+0.57637158584j))*x[1]**o+((-0.830215608153+0.890155862891j))*x[1]
        ref[0, 2, 0, 0]=(-0.073270041854+0.27046894336j)*o*x_ref[0]**(o-1)+((0.542343016577-0.708375725238j))
        ref[0, 2, 0, 1]=(0.138232709404+0.57637158584j)*o*x_ref[1]**(o-1)+((-0.830215608153+0.890155862891j))
        arg[0, 2, 1]=(0.837539252006+0.0170037926436j)*x[0]**o+((0.885542606228+0.325716100253j))*x[0]+((0.177218113973+0.437433200587j))*x[1]**o+((-0.27042679195+0.981773275603j))*x[1]
        ref[0, 2, 1, 0]=(0.837539252006+0.0170037926436j)*o*x_ref[0]**(o-1)+((0.885542606228+0.325716100253j))
        ref[0, 2, 1, 1]=(0.177218113973+0.437433200587j)*o*x_ref[1]**(o-1)+((-0.27042679195+0.981773275603j))
        arg[1, 0, 0]=(0.813424321468-0.703763596655j)*x[0]**o+((0.0280709538046-0.835374864903j))*x[0]+((0.279125408674-0.510031606481j))*x[1]**o+((0.332608410443-0.195020546871j))*x[1]
        ref[1, 0, 0, 0]=(0.813424321468-0.703763596655j)*o*x_ref[0]**(o-1)+((0.0280709538046-0.835374864903j))
        ref[1, 0, 0, 1]=(0.279125408674-0.510031606481j)*o*x_ref[1]**(o-1)+((0.332608410443-0.195020546871j))
        arg[1, 0, 1]=(0.340173193994+0.0987787601786j)*x[0]**o+((0.338508736733-0.960218522527j))*x[0]+((0.306295447634-0.204250024643j))*x[1]**o+((-0.905262061105+0.880715025041j))*x[1]
        ref[1, 0, 1, 0]=(0.340173193994+0.0987787601786j)*o*x_ref[0]**(o-1)+((0.338508736733-0.960218522527j))
        ref[1, 0, 1, 1]=(0.306295447634-0.204250024643j)*o*x_ref[1]**(o-1)+((-0.905262061105+0.880715025041j))
        arg[1, 1, 0]=(-0.160125995121+0.0144987696969j)*x[0]**o+((0.981475537537-0.0323919932235j))*x[0]+((-0.854086584075-0.0155723035202j))*x[1]**o+((-0.97951573431+0.924294086547j))*x[1]
        ref[1, 1, 0, 0]=(-0.160125995121+0.0144987696969j)*o*x_ref[0]**(o-1)+((0.981475537537-0.0323919932235j))
        ref[1, 1, 0, 1]=(-0.854086584075-0.0155723035202j)*o*x_ref[1]**(o-1)+((-0.97951573431+0.924294086547j))
        arg[1, 1, 1]=(-0.524848626153-0.448569070686j)*x[0]**o+((0.820237441755-0.760352830937j))*x[0]+((0.7986186397+0.555373975198j))*x[1]**o+((-0.287823565341+0.0495911891658j))*x[1]
        ref[1, 1, 1, 0]=(-0.524848626153-0.448569070686j)*o*x_ref[0]**(o-1)+((0.820237441755-0.760352830937j))
        ref[1, 1, 1, 1]=(0.7986186397+0.555373975198j)*o*x_ref[1]**(o-1)+((-0.287823565341+0.0495911891658j))
        arg[1, 2, 0]=(0.904141298909+0.346746729311j)*x[0]**o+((-0.395533648588+0.880443927853j))*x[0]+((-0.60572486897+0.472264998147j))*x[1]**o+((-0.501388602809-0.750668857293j))*x[1]
        ref[1, 2, 0, 0]=(0.904141298909+0.346746729311j)*o*x_ref[0]**(o-1)+((-0.395533648588+0.880443927853j))
        ref[1, 2, 0, 1]=(-0.60572486897+0.472264998147j)*o*x_ref[1]**(o-1)+((-0.501388602809-0.750668857293j))
        arg[1, 2, 1]=(0.177951567725-0.407343317974j)*x[0]**o+((0.3720170927+0.301846284524j))*x[0]+((0.948513245306+0.180135803612j))*x[1]**o+((-0.162805633592-0.59924149103j))*x[1]
        ref[1, 2, 1, 0]=(0.177951567725-0.407343317974j)*o*x_ref[0]**(o-1)+((0.3720170927+0.301846284524j))
        ref[1, 2, 1, 1]=(0.948513245306+0.180135803612j)*o*x_ref[1]**(o-1)+((-0.162805633592-0.59924149103j))
        if dim==3:
            arg[0, 0, 0]+=(-0.952817650912-0.557725300495j)*x[2]**o+((-0.51330137511+0.423511364948j))*x[2]
            ref[0, 0, 0, 2]=(-0.952817650912-0.557725300495j)*o*x_ref[2]**(o-1)+((-0.51330137511+0.423511364948j))
            arg[0, 0, 1]+=(0.619441898365-0.354453350131j)*x[2]**o+((0.0730321168774-0.00272833336049j))*x[2]
            ref[0, 0, 1, 2]=(0.619441898365-0.354453350131j)*o*x_ref[2]**(o-1)+((0.0730321168774-0.00272833336049j))
            arg[0, 1, 0]+=(0.653440463008+0.0760461787528j)*x[2]**o+((0.0663059149092+0.496010609147j))*x[2]
            ref[0, 1, 0, 2]=(0.653440463008+0.0760461787528j)*o*x_ref[2]**(o-1)+((0.0663059149092+0.496010609147j))
            arg[0, 1, 1]+=(-0.524595842953+0.043156722802j)*x[2]**o+((0.798945408179-0.331482825082j))*x[2]
            ref[0, 1, 1, 2]=(-0.524595842953+0.043156722802j)*o*x_ref[2]**(o-1)+((0.798945408179-0.331482825082j))
            arg[0, 2, 0]+=(-0.313802253057+0.928019472402j)*x[2]**o+((0.0285843564702-0.0367142531975j))*x[2]
            ref[0, 2, 0, 2]=(-0.313802253057+0.928019472402j)*o*x_ref[2]**(o-1)+((0.0285843564702-0.0367142531975j))
            arg[0, 2, 1]+=(-0.877935420002+0.28732923293j)*x[2]**o+((0.137595187618+0.197673065455j))*x[2]
            ref[0, 2, 1, 2]=(-0.877935420002+0.28732923293j)*o*x_ref[2]**(o-1)+((0.137595187618+0.197673065455j))
            arg[1, 0, 0]+=(-0.995248748099-0.853372723756j)*x[2]**o+((0.861400102984+0.0958199034098j))*x[2]
            ref[1, 0, 0, 2]=(-0.995248748099-0.853372723756j)*o*x_ref[2]**(o-1)+((0.861400102984+0.0958199034098j))
            arg[1, 0, 1]+=(0.862966366346-0.720398701313j)*x[2]**o+((0.786101391302-0.906848028927j))*x[2]
            ref[1, 0, 1, 2]=(0.862966366346-0.720398701313j)*o*x_ref[2]**(o-1)+((0.786101391302-0.906848028927j))
            arg[1, 1, 0]+=(-0.619458105953-0.766728036668j)*x[2]**o+((-0.926557320012-0.699062296842j))*x[2]
            ref[1, 1, 0, 2]=(-0.619458105953-0.766728036668j)*o*x_ref[2]**(o-1)+((-0.926557320012-0.699062296842j))
            arg[1, 1, 1]+=(0.387930014901-0.807041462415j)*x[2]**o+((-0.407815624517+0.195955014326j))*x[2]
            ref[1, 1, 1, 2]=(0.387930014901-0.807041462415j)*o*x_ref[2]**(o-1)+((-0.407815624517+0.195955014326j))
            arg[1, 2, 0]+=(-0.485064717654-0.157169744261j)*x[2]**o+((-0.299004257769-0.862701769733j))*x[2]
            ref[1, 2, 0, 2]=(-0.485064717654-0.157169744261j)*o*x_ref[2]**(o-1)+((-0.299004257769-0.862701769733j))
            arg[1, 2, 1]+=(-0.784598456335-0.904323053275j)*x[2]**o+((-0.756465164181+0.14471877815j))*x[2]
            ref[1, 2, 1, 2]=(-0.784598456335-0.904323053275j)*o*x_ref[2]**(o-1)+((-0.756465164181+0.14471877815j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2, 3, 2)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunction_fromData_Solution_rank0(self):
        """
        tests gradient of rank 0 Data on ReducedFunction

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=(0.87080502854-0.737568251019j)*x[0]**o+((-0.96108023183-0.483981760011j))*x[0]+((0.226440213722+0.0508162732642j))*x[1]**o+((-0.129171636116-0.0661092204487j))*x[1]
        ref[0]=(0.87080502854-0.737568251019j)*o*x_ref[0]**(o-1)+((-0.96108023183-0.483981760011j))
        ref[1]=(0.226440213722+0.0508162732642j)*o*x_ref[1]**(o-1)+((-0.129171636116-0.0661092204487j))
        if dim==3:
            arg+=((0.862033430479-0.315759302395j))*x[2]**o+((0.164855365557-0.406798171618j))*x[2]
            ref[2]=(0.862033430479-0.315759302395j)*o*x_ref[2]**(o-1)+((0.164855365557-0.406798171618j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunction_fromData_Solution_rank1(self):
        """
        tests gradient of rank 1 Data on ReducedFunction

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(4,),w)
        ref = Data(0,(4,)+(dim,),w_ref)
        arg[0,]=(0.194438334359-0.327620388224j)*x[0]**o+((0.720886667807-0.973713727771j))*x[0]+((0.508404712326+0.505105845351j))*x[1]**o+((0.554325401704-0.920179055264j))*x[1]
        ref[0, 0]=(0.194438334359-0.327620388224j)*o*x_ref[0]**(o-1)+((0.720886667807-0.973713727771j))
        ref[0, 1]=(0.508404712326+0.505105845351j)*o*x_ref[1]**(o-1)+((0.554325401704-0.920179055264j))
        arg[1,]=(0.97649113174+0.145489075612j)*x[0]**o+((0.335799599358+0.764772502255j))*x[0]+((0.833401508403+0.491533220625j))*x[1]**o+((0.532055484772-0.89503418978j))*x[1]
        ref[1, 0]=(0.97649113174+0.145489075612j)*o*x_ref[0]**(o-1)+((0.335799599358+0.764772502255j))
        ref[1, 1]=(0.833401508403+0.491533220625j)*o*x_ref[1]**(o-1)+((0.532055484772-0.89503418978j))
        arg[2,]=(0.916860488164-0.553215857153j)*x[0]**o+((0.65830558845-0.493094736225j))*x[0]+((-0.228314425595+0.446883165379j))*x[1]**o+((-0.766968355575-0.77875915965j))*x[1]
        ref[2, 0]=(0.916860488164-0.553215857153j)*o*x_ref[0]**(o-1)+((0.65830558845-0.493094736225j))
        ref[2, 1]=(-0.228314425595+0.446883165379j)*o*x_ref[1]**(o-1)+((-0.766968355575-0.77875915965j))
        arg[3,]=(0.806986206852-0.274462440157j)*x[0]**o+((-0.0445456277877+0.564077556088j))*x[0]+((-0.740985377322+0.00672300862475j))*x[1]**o+((0.2788988705-0.220122219689j))*x[1]
        ref[3, 0]=(0.806986206852-0.274462440157j)*o*x_ref[0]**(o-1)+((-0.0445456277877+0.564077556088j))
        ref[3, 1]=(-0.740985377322+0.00672300862475j)*o*x_ref[1]**(o-1)+((0.2788988705-0.220122219689j))
        if dim==3:
            arg[0,]+=(-0.887307078342+0.327124486523j)*x[2]**o+((-0.465216546837+0.666668791874j))*x[2]
            ref[0, 2]=(-0.887307078342+0.327124486523j)*o*x_ref[2]**(o-1)+((-0.465216546837+0.666668791874j))
            arg[1,]+=(0.296682286457+0.995551848866j)*x[2]**o+((0.685609007042-0.660478645002j))*x[2]
            ref[1, 2]=(0.296682286457+0.995551848866j)*o*x_ref[2]**(o-1)+((0.685609007042-0.660478645002j))
            arg[2,]+=(-0.724462155732-0.199639085033j)*x[2]**o+((-0.609820597546+0.238944595318j))*x[2]
            ref[2, 2]=(-0.724462155732-0.199639085033j)*o*x_ref[2]**(o-1)+((-0.609820597546+0.238944595318j))
            arg[3,]+=(0.839262595376+0.911660331215j)*x[2]**o+((-0.156006388303-0.818830031082j))*x[2]
            ref[3, 2]=(0.839262595376+0.911660331215j)*o*x_ref[2]**(o-1)+((-0.156006388303-0.818830031082j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunction_fromData_Solution_rank2(self):
        """
        tests gradient of rank 2 Data on ReducedFunction

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(4, 2),w)
        ref = Data(0,(4, 2)+(dim,),w_ref)
        arg[0, 0]=(-0.556531135031-0.909167517939j)*x[0]**o+((0.248342737569+0.276491270689j))*x[0]+((-0.195519236376-0.247573979301j))*x[1]**o+((0.5464415633+0.0456016181973j))*x[1]
        ref[0, 0, 0]=(-0.556531135031-0.909167517939j)*o*x_ref[0]**(o-1)+((0.248342737569+0.276491270689j))
        ref[0, 0, 1]=(-0.195519236376-0.247573979301j)*o*x_ref[1]**(o-1)+((0.5464415633+0.0456016181973j))
        arg[0, 1]=(-0.808523933076+0.0107207517483j)*x[0]**o+((-0.47411095199+0.852158691003j))*x[0]+((0.974372258574+0.22001688171j))*x[1]**o+((0.0764523657176+0.658512859218j))*x[1]
        ref[0, 1, 0]=(-0.808523933076+0.0107207517483j)*o*x_ref[0]**(o-1)+((-0.47411095199+0.852158691003j))
        ref[0, 1, 1]=(0.974372258574+0.22001688171j)*o*x_ref[1]**(o-1)+((0.0764523657176+0.658512859218j))
        arg[1, 0]=(-0.944389467766-0.357241481185j)*x[0]**o+((-0.00536079906634-0.969630392413j))*x[0]+((0.0902761505038+0.60711732022j))*x[1]**o+((0.291714116799-0.99467578293j))*x[1]
        ref[1, 0, 0]=(-0.944389467766-0.357241481185j)*o*x_ref[0]**(o-1)+((-0.00536079906634-0.969630392413j))
        ref[1, 0, 1]=(0.0902761505038+0.60711732022j)*o*x_ref[1]**(o-1)+((0.291714116799-0.99467578293j))
        arg[1, 1]=(0.628894997718+0.98133861231j)*x[0]**o+((0.27057337365+0.812978313021j))*x[0]+((-0.492565507776-0.35762094169j))*x[1]**o+((-0.493827075489-0.477602542392j))*x[1]
        ref[1, 1, 0]=(0.628894997718+0.98133861231j)*o*x_ref[0]**(o-1)+((0.27057337365+0.812978313021j))
        ref[1, 1, 1]=(-0.492565507776-0.35762094169j)*o*x_ref[1]**(o-1)+((-0.493827075489-0.477602542392j))
        arg[2, 0]=(0.633266046529+0.715532133579j)*x[0]**o+((0.673739190537+0.907877123206j))*x[0]+((-0.660296557569-0.635445437701j))*x[1]**o+((-0.550246015874+0.503660307538j))*x[1]
        ref[2, 0, 0]=(0.633266046529+0.715532133579j)*o*x_ref[0]**(o-1)+((0.673739190537+0.907877123206j))
        ref[2, 0, 1]=(-0.660296557569-0.635445437701j)*o*x_ref[1]**(o-1)+((-0.550246015874+0.503660307538j))
        arg[2, 1]=(0.192451673395-0.320352421988j)*x[0]**o+((-0.736535863076+0.934962004045j))*x[0]+((-0.130108728086-0.518785105881j))*x[1]**o+((-0.471953998498-0.193648817702j))*x[1]
        ref[2, 1, 0]=(0.192451673395-0.320352421988j)*o*x_ref[0]**(o-1)+((-0.736535863076+0.934962004045j))
        ref[2, 1, 1]=(-0.130108728086-0.518785105881j)*o*x_ref[1]**(o-1)+((-0.471953998498-0.193648817702j))
        arg[3, 0]=(-0.33803306596+0.462955440104j)*x[0]**o+((-0.776778516465-0.117110385592j))*x[0]+((0.716079067781+0.0209615328981j))*x[1]**o+((-0.480642224263+0.631194415829j))*x[1]
        ref[3, 0, 0]=(-0.33803306596+0.462955440104j)*o*x_ref[0]**(o-1)+((-0.776778516465-0.117110385592j))
        ref[3, 0, 1]=(0.716079067781+0.0209615328981j)*o*x_ref[1]**(o-1)+((-0.480642224263+0.631194415829j))
        arg[3, 1]=(-0.647035148057-0.962992419036j)*x[0]**o+((0.939884221215+0.68104933872j))*x[0]+((0.574309756563+0.99439174352j))*x[1]**o+((-0.00102968022204-0.0995251404578j))*x[1]
        ref[3, 1, 0]=(-0.647035148057-0.962992419036j)*o*x_ref[0]**(o-1)+((0.939884221215+0.68104933872j))
        ref[3, 1, 1]=(0.574309756563+0.99439174352j)*o*x_ref[1]**(o-1)+((-0.00102968022204-0.0995251404578j))
        if dim==3:
            arg[0, 0]+=(0.758068636638+0.572316652437j)*x[2]**o+((-0.688370618825+0.681760168174j))*x[2]
            ref[0, 0, 2]=(0.758068636638+0.572316652437j)*o*x_ref[2]**(o-1)+((-0.688370618825+0.681760168174j))
            arg[0, 1]+=(-0.788117977255-0.586397175652j)*x[2]**o+((0.164716746199-0.990375054881j))*x[2]
            ref[0, 1, 2]=(-0.788117977255-0.586397175652j)*o*x_ref[2]**(o-1)+((0.164716746199-0.990375054881j))
            arg[1, 0]+=(-0.366308271495+0.427156714972j)*x[2]**o+((-0.163447543978+0.0660175779154j))*x[2]
            ref[1, 0, 2]=(-0.366308271495+0.427156714972j)*o*x_ref[2]**(o-1)+((-0.163447543978+0.0660175779154j))
            arg[1, 1]+=(0.95465245773+0.0307852010689j)*x[2]**o+((0.41252118091-0.111620925093j))*x[2]
            ref[1, 1, 2]=(0.95465245773+0.0307852010689j)*o*x_ref[2]**(o-1)+((0.41252118091-0.111620925093j))
            arg[2, 0]+=(-0.853423031003-0.43872459357j)*x[2]**o+((0.235438953001-0.454181635407j))*x[2]
            ref[2, 0, 2]=(-0.853423031003-0.43872459357j)*o*x_ref[2]**(o-1)+((0.235438953001-0.454181635407j))
            arg[2, 1]+=(-0.0493700393565+0.20893455509j)*x[2]**o+((0.165734900586-0.0847077322862j))*x[2]
            ref[2, 1, 2]=(-0.0493700393565+0.20893455509j)*o*x_ref[2]**(o-1)+((0.165734900586-0.0847077322862j))
            arg[3, 0]+=(-0.538955607492-0.411032403148j)*x[2]**o+((-0.952474380265-0.83046295592j))*x[2]
            ref[3, 0, 2]=(-0.538955607492-0.411032403148j)*o*x_ref[2]**(o-1)+((-0.952474380265-0.83046295592j))
            arg[3, 1]+=(0.0388093721327-0.532086550799j)*x[2]**o+((-0.709128881619-0.400264829629j))*x[2]
            ref[3, 1, 2]=(0.0388093721327-0.532086550799j)*o*x_ref[2]**(o-1)+((-0.709128881619-0.400264829629j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4, 2)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunction_fromData_Solution_rank3(self):
        """
        tests gradient of rank 3 Data on ReducedFunction

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(3, 4, 4),w)
        ref = Data(0,(3, 4, 4)+(dim,),w_ref)
        arg[0, 0, 0]=(0.0964435817647+0.690803177614j)*x[0]**o+((0.599127266733-0.976598675907j))*x[0]+((-0.249604336434+0.678203632582j))*x[1]**o+((-0.87719294678+0.908292371305j))*x[1]
        ref[0, 0, 0, 0]=(0.0964435817647+0.690803177614j)*o*x_ref[0]**(o-1)+((0.599127266733-0.976598675907j))
        ref[0, 0, 0, 1]=(-0.249604336434+0.678203632582j)*o*x_ref[1]**(o-1)+((-0.87719294678+0.908292371305j))
        arg[0, 0, 1]=(-0.531156528126+0.933515701838j)*x[0]**o+((-0.65178019366+0.725988225661j))*x[0]+((0.98009838723-0.944057222111j))*x[1]**o+((0.451284429492-0.639566359496j))*x[1]
        ref[0, 0, 1, 0]=(-0.531156528126+0.933515701838j)*o*x_ref[0]**(o-1)+((-0.65178019366+0.725988225661j))
        ref[0, 0, 1, 1]=(0.98009838723-0.944057222111j)*o*x_ref[1]**(o-1)+((0.451284429492-0.639566359496j))
        arg[0, 0, 2]=(-0.841025823378-0.498742679755j)*x[0]**o+((0.141922802533-0.206296116386j))*x[0]+((0.87081354593-0.173556470897j))*x[1]**o+((0.792147244443+0.23309721255j))*x[1]
        ref[0, 0, 2, 0]=(-0.841025823378-0.498742679755j)*o*x_ref[0]**(o-1)+((0.141922802533-0.206296116386j))
        ref[0, 0, 2, 1]=(0.87081354593-0.173556470897j)*o*x_ref[1]**(o-1)+((0.792147244443+0.23309721255j))
        arg[0, 0, 3]=(0.548788109322-0.512443968226j)*x[0]**o+((-0.375203257663-0.924641295334j))*x[0]+((-0.563106539745-0.797821022477j))*x[1]**o+((-0.211288662234-0.411052241324j))*x[1]
        ref[0, 0, 3, 0]=(0.548788109322-0.512443968226j)*o*x_ref[0]**(o-1)+((-0.375203257663-0.924641295334j))
        ref[0, 0, 3, 1]=(-0.563106539745-0.797821022477j)*o*x_ref[1]**(o-1)+((-0.211288662234-0.411052241324j))
        arg[0, 1, 0]=(-0.484355616462-0.210998091408j)*x[0]**o+((-0.260837611257+0.864910371051j))*x[0]+((-0.0236270620603+0.0979145727234j))*x[1]**o+((-0.0387996708993-0.898180173034j))*x[1]
        ref[0, 1, 0, 0]=(-0.484355616462-0.210998091408j)*o*x_ref[0]**(o-1)+((-0.260837611257+0.864910371051j))
        ref[0, 1, 0, 1]=(-0.0236270620603+0.0979145727234j)*o*x_ref[1]**(o-1)+((-0.0387996708993-0.898180173034j))
        arg[0, 1, 1]=(-0.612002725008+0.550338866461j)*x[0]**o+((0.749741403311+0.208381671343j))*x[0]+((0.144628036255-0.687683521962j))*x[1]**o+((0.334801718224-0.778764064059j))*x[1]
        ref[0, 1, 1, 0]=(-0.612002725008+0.550338866461j)*o*x_ref[0]**(o-1)+((0.749741403311+0.208381671343j))
        ref[0, 1, 1, 1]=(0.144628036255-0.687683521962j)*o*x_ref[1]**(o-1)+((0.334801718224-0.778764064059j))
        arg[0, 1, 2]=(-0.620950164764-0.340431587156j)*x[0]**o+((0.332623011834+0.458582959736j))*x[0]+((-0.740068905743+0.105973965448j))*x[1]**o+((0.427855739855+0.742888276911j))*x[1]
        ref[0, 1, 2, 0]=(-0.620950164764-0.340431587156j)*o*x_ref[0]**(o-1)+((0.332623011834+0.458582959736j))
        ref[0, 1, 2, 1]=(-0.740068905743+0.105973965448j)*o*x_ref[1]**(o-1)+((0.427855739855+0.742888276911j))
        arg[0, 1, 3]=(0.544489984637+0.314807774935j)*x[0]**o+((-0.453796885217+0.554847566071j))*x[0]+((-0.611847325066+0.182001591038j))*x[1]**o+((0.607907397821-0.890215096626j))*x[1]
        ref[0, 1, 3, 0]=(0.544489984637+0.314807774935j)*o*x_ref[0]**(o-1)+((-0.453796885217+0.554847566071j))
        ref[0, 1, 3, 1]=(-0.611847325066+0.182001591038j)*o*x_ref[1]**(o-1)+((0.607907397821-0.890215096626j))
        arg[0, 2, 0]=(-0.0886467797292-0.0246663416295j)*x[0]**o+((-0.923856560817+0.948731323512j))*x[0]+((-0.815566726253-0.748700095721j))*x[1]**o+((-0.840158394741+0.174190551898j))*x[1]
        ref[0, 2, 0, 0]=(-0.0886467797292-0.0246663416295j)*o*x_ref[0]**(o-1)+((-0.923856560817+0.948731323512j))
        ref[0, 2, 0, 1]=(-0.815566726253-0.748700095721j)*o*x_ref[1]**(o-1)+((-0.840158394741+0.174190551898j))
        arg[0, 2, 1]=(-0.634526271437-0.0605392703225j)*x[0]**o+((-0.163510079742-0.596028661852j))*x[0]+((0.852952452445+0.0763517117418j))*x[1]**o+((-0.118649820273-0.0654521274963j))*x[1]
        ref[0, 2, 1, 0]=(-0.634526271437-0.0605392703225j)*o*x_ref[0]**(o-1)+((-0.163510079742-0.596028661852j))
        ref[0, 2, 1, 1]=(0.852952452445+0.0763517117418j)*o*x_ref[1]**(o-1)+((-0.118649820273-0.0654521274963j))
        arg[0, 2, 2]=(-0.876627188866-0.866992648995j)*x[0]**o+((-0.561946026976-0.419667499353j))*x[0]+((-0.555656549998+0.932345377936j))*x[1]**o+((0.0964683031012+0.438566840492j))*x[1]
        ref[0, 2, 2, 0]=(-0.876627188866-0.866992648995j)*o*x_ref[0]**(o-1)+((-0.561946026976-0.419667499353j))
        ref[0, 2, 2, 1]=(-0.555656549998+0.932345377936j)*o*x_ref[1]**(o-1)+((0.0964683031012+0.438566840492j))
        arg[0, 2, 3]=(0.694326701016-0.881223225504j)*x[0]**o+((-0.000790340201206+0.994304893341j))*x[0]+((0.00337063201176+0.332919118028j))*x[1]**o+((0.740215101914+0.675078645574j))*x[1]
        ref[0, 2, 3, 0]=(0.694326701016-0.881223225504j)*o*x_ref[0]**(o-1)+((-0.000790340201206+0.994304893341j))
        ref[0, 2, 3, 1]=(0.00337063201176+0.332919118028j)*o*x_ref[1]**(o-1)+((0.740215101914+0.675078645574j))
        arg[0, 3, 0]=(0.0120504821966+0.775381653742j)*x[0]**o+((-0.63619417096-0.418002801655j))*x[0]+((-0.155869282932-0.566787216868j))*x[1]**o+((-0.997318817082+0.0777265652309j))*x[1]
        ref[0, 3, 0, 0]=(0.0120504821966+0.775381653742j)*o*x_ref[0]**(o-1)+((-0.63619417096-0.418002801655j))
        ref[0, 3, 0, 1]=(-0.155869282932-0.566787216868j)*o*x_ref[1]**(o-1)+((-0.997318817082+0.0777265652309j))
        arg[0, 3, 1]=(0.350102204983+0.173263679157j)*x[0]**o+((-0.264821353327-0.87485988676j))*x[0]+((-0.844118766347+0.903988892762j))*x[1]**o+((0.240287396442+0.151142585631j))*x[1]
        ref[0, 3, 1, 0]=(0.350102204983+0.173263679157j)*o*x_ref[0]**(o-1)+((-0.264821353327-0.87485988676j))
        ref[0, 3, 1, 1]=(-0.844118766347+0.903988892762j)*o*x_ref[1]**(o-1)+((0.240287396442+0.151142585631j))
        arg[0, 3, 2]=(0.046543298863+0.637432086945j)*x[0]**o+((0.810782729494+0.647565562664j))*x[0]+((0.147423241954-0.502477352252j))*x[1]**o+((0.525136398441-0.108432877226j))*x[1]
        ref[0, 3, 2, 0]=(0.046543298863+0.637432086945j)*o*x_ref[0]**(o-1)+((0.810782729494+0.647565562664j))
        ref[0, 3, 2, 1]=(0.147423241954-0.502477352252j)*o*x_ref[1]**(o-1)+((0.525136398441-0.108432877226j))
        arg[0, 3, 3]=(-0.370352015827+0.805999835482j)*x[0]**o+((-0.20706855706-0.588332405959j))*x[0]+((-0.879257972237-0.00384144130882j))*x[1]**o+((0.845304844341-0.228519755858j))*x[1]
        ref[0, 3, 3, 0]=(-0.370352015827+0.805999835482j)*o*x_ref[0]**(o-1)+((-0.20706855706-0.588332405959j))
        ref[0, 3, 3, 1]=(-0.879257972237-0.00384144130882j)*o*x_ref[1]**(o-1)+((0.845304844341-0.228519755858j))
        arg[1, 0, 0]=(0.831467292319+0.417946900231j)*x[0]**o+((0.304753553787-0.826632073333j))*x[0]+((-0.022922312503+0.940481432985j))*x[1]**o+((0.545778646125-0.211331177747j))*x[1]
        ref[1, 0, 0, 0]=(0.831467292319+0.417946900231j)*o*x_ref[0]**(o-1)+((0.304753553787-0.826632073333j))
        ref[1, 0, 0, 1]=(-0.022922312503+0.940481432985j)*o*x_ref[1]**(o-1)+((0.545778646125-0.211331177747j))
        arg[1, 0, 1]=(-0.419270492718-0.970514745353j)*x[0]**o+((-0.802151182059+0.755314838092j))*x[0]+((0.291032943924+0.703070587106j))*x[1]**o+((-0.842306794282-0.413031492092j))*x[1]
        ref[1, 0, 1, 0]=(-0.419270492718-0.970514745353j)*o*x_ref[0]**(o-1)+((-0.802151182059+0.755314838092j))
        ref[1, 0, 1, 1]=(0.291032943924+0.703070587106j)*o*x_ref[1]**(o-1)+((-0.842306794282-0.413031492092j))
        arg[1, 0, 2]=(0.0779985831783-0.822447476474j)*x[0]**o+((0.864171449353-0.999627063523j))*x[0]+((-0.0900330157978-0.138491968548j))*x[1]**o+((-0.269503289786-0.702531955286j))*x[1]
        ref[1, 0, 2, 0]=(0.0779985831783-0.822447476474j)*o*x_ref[0]**(o-1)+((0.864171449353-0.999627063523j))
        ref[1, 0, 2, 1]=(-0.0900330157978-0.138491968548j)*o*x_ref[1]**(o-1)+((-0.269503289786-0.702531955286j))
        arg[1, 0, 3]=(-0.123633530779+0.874555235941j)*x[0]**o+((-0.708453453541+0.620506973431j))*x[0]+((-0.192961519583+0.787769076966j))*x[1]**o+((0.385275775578-0.971177488348j))*x[1]
        ref[1, 0, 3, 0]=(-0.123633530779+0.874555235941j)*o*x_ref[0]**(o-1)+((-0.708453453541+0.620506973431j))
        ref[1, 0, 3, 1]=(-0.192961519583+0.787769076966j)*o*x_ref[1]**(o-1)+((0.385275775578-0.971177488348j))
        arg[1, 1, 0]=(0.278519209236+0.195444195216j)*x[0]**o+((0.572276297093+0.0644066828787j))*x[0]+((0.857510743452-0.0497650673575j))*x[1]**o+((0.0124083095965-0.713402227922j))*x[1]
        ref[1, 1, 0, 0]=(0.278519209236+0.195444195216j)*o*x_ref[0]**(o-1)+((0.572276297093+0.0644066828787j))
        ref[1, 1, 0, 1]=(0.857510743452-0.0497650673575j)*o*x_ref[1]**(o-1)+((0.0124083095965-0.713402227922j))
        arg[1, 1, 1]=(0.373708876772-0.957420401418j)*x[0]**o+((0.61888236989-0.925591249954j))*x[0]+((0.595595257508-0.386736977659j))*x[1]**o+((0.769138119269-0.100155305888j))*x[1]
        ref[1, 1, 1, 0]=(0.373708876772-0.957420401418j)*o*x_ref[0]**(o-1)+((0.61888236989-0.925591249954j))
        ref[1, 1, 1, 1]=(0.595595257508-0.386736977659j)*o*x_ref[1]**(o-1)+((0.769138119269-0.100155305888j))
        arg[1, 1, 2]=(-0.0849573057349+0.213461161904j)*x[0]**o+((0.739764088897-0.559287179833j))*x[0]+((0.876186712668-0.719851229482j))*x[1]**o+((-0.0418520932186-0.903251731971j))*x[1]
        ref[1, 1, 2, 0]=(-0.0849573057349+0.213461161904j)*o*x_ref[0]**(o-1)+((0.739764088897-0.559287179833j))
        ref[1, 1, 2, 1]=(0.876186712668-0.719851229482j)*o*x_ref[1]**(o-1)+((-0.0418520932186-0.903251731971j))
        arg[1, 1, 3]=(0.649784302433+0.14721158913j)*x[0]**o+((-0.63473568662-0.0469458560751j))*x[0]+((0.451468078835+0.808244505846j))*x[1]**o+((0.159238467945+0.649670994594j))*x[1]
        ref[1, 1, 3, 0]=(0.649784302433+0.14721158913j)*o*x_ref[0]**(o-1)+((-0.63473568662-0.0469458560751j))
        ref[1, 1, 3, 1]=(0.451468078835+0.808244505846j)*o*x_ref[1]**(o-1)+((0.159238467945+0.649670994594j))
        arg[1, 2, 0]=(0.0969300862668-0.224905292243j)*x[0]**o+((0.420403501854+0.424737526682j))*x[0]+((0.0360620753593+0.250239690551j))*x[1]**o+((0.55333125129+0.390835741918j))*x[1]
        ref[1, 2, 0, 0]=(0.0969300862668-0.224905292243j)*o*x_ref[0]**(o-1)+((0.420403501854+0.424737526682j))
        ref[1, 2, 0, 1]=(0.0360620753593+0.250239690551j)*o*x_ref[1]**(o-1)+((0.55333125129+0.390835741918j))
        arg[1, 2, 1]=(0.260394224048-0.911236680073j)*x[0]**o+((-0.86516462459+0.839567700505j))*x[0]+((0.661519189971-0.0555407540623j))*x[1]**o+((-0.648040057822-0.694336690302j))*x[1]
        ref[1, 2, 1, 0]=(0.260394224048-0.911236680073j)*o*x_ref[0]**(o-1)+((-0.86516462459+0.839567700505j))
        ref[1, 2, 1, 1]=(0.661519189971-0.0555407540623j)*o*x_ref[1]**(o-1)+((-0.648040057822-0.694336690302j))
        arg[1, 2, 2]=(-0.480576275414+0.447920042147j)*x[0]**o+((-0.605261100172+0.89842859881j))*x[0]+((-0.818363300526+0.418490820939j))*x[1]**o+((0.00287507581597-0.75359277732j))*x[1]
        ref[1, 2, 2, 0]=(-0.480576275414+0.447920042147j)*o*x_ref[0]**(o-1)+((-0.605261100172+0.89842859881j))
        ref[1, 2, 2, 1]=(-0.818363300526+0.418490820939j)*o*x_ref[1]**(o-1)+((0.00287507581597-0.75359277732j))
        arg[1, 2, 3]=(0.894132391685-0.513060671229j)*x[0]**o+((-0.639636882965-0.621957965459j))*x[0]+((-0.53644365793-0.449183164947j))*x[1]**o+((-0.510334198816+0.190475827601j))*x[1]
        ref[1, 2, 3, 0]=(0.894132391685-0.513060671229j)*o*x_ref[0]**(o-1)+((-0.639636882965-0.621957965459j))
        ref[1, 2, 3, 1]=(-0.53644365793-0.449183164947j)*o*x_ref[1]**(o-1)+((-0.510334198816+0.190475827601j))
        arg[1, 3, 0]=(-0.247773648361+0.507940803235j)*x[0]**o+((0.186314552007-0.403536733023j))*x[0]+((-0.33724520734+0.19794611724j))*x[1]**o+((-0.491020430506-0.696227495976j))*x[1]
        ref[1, 3, 0, 0]=(-0.247773648361+0.507940803235j)*o*x_ref[0]**(o-1)+((0.186314552007-0.403536733023j))
        ref[1, 3, 0, 1]=(-0.33724520734+0.19794611724j)*o*x_ref[1]**(o-1)+((-0.491020430506-0.696227495976j))
        arg[1, 3, 1]=(-0.49302882648-0.355524413882j)*x[0]**o+((0.996803574843-0.649240696769j))*x[0]+((-0.371736027703+0.693070725123j))*x[1]**o+((-0.662022788148+0.957794965411j))*x[1]
        ref[1, 3, 1, 0]=(-0.49302882648-0.355524413882j)*o*x_ref[0]**(o-1)+((0.996803574843-0.649240696769j))
        ref[1, 3, 1, 1]=(-0.371736027703+0.693070725123j)*o*x_ref[1]**(o-1)+((-0.662022788148+0.957794965411j))
        arg[1, 3, 2]=(0.422122904037+0.168043368036j)*x[0]**o+((0.400382428333-0.855840089849j))*x[0]+((-0.419123884002-0.847318108111j))*x[1]**o+((-0.958861402105+0.105172348284j))*x[1]
        ref[1, 3, 2, 0]=(0.422122904037+0.168043368036j)*o*x_ref[0]**(o-1)+((0.400382428333-0.855840089849j))
        ref[1, 3, 2, 1]=(-0.419123884002-0.847318108111j)*o*x_ref[1]**(o-1)+((-0.958861402105+0.105172348284j))
        arg[1, 3, 3]=(-0.166642271376-0.846642780276j)*x[0]**o+((-0.271889707552-0.00300123755479j))*x[0]+((-0.93255775397-0.581800185355j))*x[1]**o+((0.219166962253+0.67836568524j))*x[1]
        ref[1, 3, 3, 0]=(-0.166642271376-0.846642780276j)*o*x_ref[0]**(o-1)+((-0.271889707552-0.00300123755479j))
        ref[1, 3, 3, 1]=(-0.93255775397-0.581800185355j)*o*x_ref[1]**(o-1)+((0.219166962253+0.67836568524j))
        arg[2, 0, 0]=(-0.414081309736+0.939200293633j)*x[0]**o+((0.17061484919+0.540552439051j))*x[0]+((-0.29957026604+0.493355879957j))*x[1]**o+((-0.468222149428-0.257700710886j))*x[1]
        ref[2, 0, 0, 0]=(-0.414081309736+0.939200293633j)*o*x_ref[0]**(o-1)+((0.17061484919+0.540552439051j))
        ref[2, 0, 0, 1]=(-0.29957026604+0.493355879957j)*o*x_ref[1]**(o-1)+((-0.468222149428-0.257700710886j))
        arg[2, 0, 1]=(-0.811737579686-0.659643523209j)*x[0]**o+((-0.0499320108321+0.200132792503j))*x[0]+((-0.993300275398-0.436956387483j))*x[1]**o+((-0.711063612313+0.108985262833j))*x[1]
        ref[2, 0, 1, 0]=(-0.811737579686-0.659643523209j)*o*x_ref[0]**(o-1)+((-0.0499320108321+0.200132792503j))
        ref[2, 0, 1, 1]=(-0.993300275398-0.436956387483j)*o*x_ref[1]**(o-1)+((-0.711063612313+0.108985262833j))
        arg[2, 0, 2]=(-0.985401191917-0.343263862722j)*x[0]**o+((0.188437188892-0.275238766941j))*x[0]+((-0.75833870531-0.000417808693758j))*x[1]**o+((0.109009318554+0.905292098224j))*x[1]
        ref[2, 0, 2, 0]=(-0.985401191917-0.343263862722j)*o*x_ref[0]**(o-1)+((0.188437188892-0.275238766941j))
        ref[2, 0, 2, 1]=(-0.75833870531-0.000417808693758j)*o*x_ref[1]**(o-1)+((0.109009318554+0.905292098224j))
        arg[2, 0, 3]=(0.208432376892-0.287897528752j)*x[0]**o+((0.876959797542-0.856011012941j))*x[0]+((-0.300786684427+0.844850557817j))*x[1]**o+((-0.83462888016+0.200300121558j))*x[1]
        ref[2, 0, 3, 0]=(0.208432376892-0.287897528752j)*o*x_ref[0]**(o-1)+((0.876959797542-0.856011012941j))
        ref[2, 0, 3, 1]=(-0.300786684427+0.844850557817j)*o*x_ref[1]**(o-1)+((-0.83462888016+0.200300121558j))
        arg[2, 1, 0]=(0.686790592362+0.801882427505j)*x[0]**o+((0.68668285117-0.764258448963j))*x[0]+((-0.496067737825+0.359387528126j))*x[1]**o+((0.499073924369+0.232821833853j))*x[1]
        ref[2, 1, 0, 0]=(0.686790592362+0.801882427505j)*o*x_ref[0]**(o-1)+((0.68668285117-0.764258448963j))
        ref[2, 1, 0, 1]=(-0.496067737825+0.359387528126j)*o*x_ref[1]**(o-1)+((0.499073924369+0.232821833853j))
        arg[2, 1, 1]=(0.0576310412855+0.0312829639504j)*x[0]**o+((-0.136391338809+0.320439861421j))*x[0]+((-0.183257798371+0.961853896256j))*x[1]**o+((-0.539356115819-0.486544563245j))*x[1]
        ref[2, 1, 1, 0]=(0.0576310412855+0.0312829639504j)*o*x_ref[0]**(o-1)+((-0.136391338809+0.320439861421j))
        ref[2, 1, 1, 1]=(-0.183257798371+0.961853896256j)*o*x_ref[1]**(o-1)+((-0.539356115819-0.486544563245j))
        arg[2, 1, 2]=(0.580436225198-0.708819139185j)*x[0]**o+((-0.878351361184+0.0869483460784j))*x[0]+((-0.390588701432-0.523321330889j))*x[1]**o+((-0.0899183597325-0.899127628192j))*x[1]
        ref[2, 1, 2, 0]=(0.580436225198-0.708819139185j)*o*x_ref[0]**(o-1)+((-0.878351361184+0.0869483460784j))
        ref[2, 1, 2, 1]=(-0.390588701432-0.523321330889j)*o*x_ref[1]**(o-1)+((-0.0899183597325-0.899127628192j))
        arg[2, 1, 3]=(0.966403732801+0.0471967175503j)*x[0]**o+((0.85657366067-0.194093933117j))*x[0]+((-0.864027808932-0.681068567581j))*x[1]**o+((-0.315845587099-0.445452884809j))*x[1]
        ref[2, 1, 3, 0]=(0.966403732801+0.0471967175503j)*o*x_ref[0]**(o-1)+((0.85657366067-0.194093933117j))
        ref[2, 1, 3, 1]=(-0.864027808932-0.681068567581j)*o*x_ref[1]**(o-1)+((-0.315845587099-0.445452884809j))
        arg[2, 2, 0]=(-0.955275174983-0.438995506935j)*x[0]**o+((0.611603121335+0.365547649058j))*x[0]+((0.911864820623-0.117735380805j))*x[1]**o+((0.211715716051-0.125997329657j))*x[1]
        ref[2, 2, 0, 0]=(-0.955275174983-0.438995506935j)*o*x_ref[0]**(o-1)+((0.611603121335+0.365547649058j))
        ref[2, 2, 0, 1]=(0.911864820623-0.117735380805j)*o*x_ref[1]**(o-1)+((0.211715716051-0.125997329657j))
        arg[2, 2, 1]=(0.29472293596+0.885103545838j)*x[0]**o+((-0.057433999599-0.64890773558j))*x[0]+((0.730124259489-0.0246484775104j))*x[1]**o+((0.593173039478+0.413415534841j))*x[1]
        ref[2, 2, 1, 0]=(0.29472293596+0.885103545838j)*o*x_ref[0]**(o-1)+((-0.057433999599-0.64890773558j))
        ref[2, 2, 1, 1]=(0.730124259489-0.0246484775104j)*o*x_ref[1]**(o-1)+((0.593173039478+0.413415534841j))
        arg[2, 2, 2]=(0.957451810997-0.183104002632j)*x[0]**o+((-0.851870779736-0.326738013058j))*x[0]+((0.976601050801-0.249438348536j))*x[1]**o+((-0.349719401254-0.661571429226j))*x[1]
        ref[2, 2, 2, 0]=(0.957451810997-0.183104002632j)*o*x_ref[0]**(o-1)+((-0.851870779736-0.326738013058j))
        ref[2, 2, 2, 1]=(0.976601050801-0.249438348536j)*o*x_ref[1]**(o-1)+((-0.349719401254-0.661571429226j))
        arg[2, 2, 3]=(-0.0903383019784+0.14212005584j)*x[0]**o+((-0.539579775168+0.902221327293j))*x[0]+((-0.801525559374+0.566074627323j))*x[1]**o+((0.157535333032-0.664523821545j))*x[1]
        ref[2, 2, 3, 0]=(-0.0903383019784+0.14212005584j)*o*x_ref[0]**(o-1)+((-0.539579775168+0.902221327293j))
        ref[2, 2, 3, 1]=(-0.801525559374+0.566074627323j)*o*x_ref[1]**(o-1)+((0.157535333032-0.664523821545j))
        arg[2, 3, 0]=(-0.546005682133-0.634813616881j)*x[0]**o+((0.825235827486+0.0360035174605j))*x[0]+((-0.368797118244+0.577634542495j))*x[1]**o+((0.958146433944+0.141152648035j))*x[1]
        ref[2, 3, 0, 0]=(-0.546005682133-0.634813616881j)*o*x_ref[0]**(o-1)+((0.825235827486+0.0360035174605j))
        ref[2, 3, 0, 1]=(-0.368797118244+0.577634542495j)*o*x_ref[1]**(o-1)+((0.958146433944+0.141152648035j))
        arg[2, 3, 1]=(0.934674266698-0.773256871745j)*x[0]**o+((-0.469546089703-0.900680613408j))*x[0]+((0.766600704148+0.547682838138j))*x[1]**o+((0.4206888771-0.921370914818j))*x[1]
        ref[2, 3, 1, 0]=(0.934674266698-0.773256871745j)*o*x_ref[0]**(o-1)+((-0.469546089703-0.900680613408j))
        ref[2, 3, 1, 1]=(0.766600704148+0.547682838138j)*o*x_ref[1]**(o-1)+((0.4206888771-0.921370914818j))
        arg[2, 3, 2]=(-0.10899745268+0.295676703801j)*x[0]**o+((0.0531742653915-0.613349266869j))*x[0]+((-0.318912375945+0.335978135966j))*x[1]**o+((0.142841830551-0.435645907379j))*x[1]
        ref[2, 3, 2, 0]=(-0.10899745268+0.295676703801j)*o*x_ref[0]**(o-1)+((0.0531742653915-0.613349266869j))
        ref[2, 3, 2, 1]=(-0.318912375945+0.335978135966j)*o*x_ref[1]**(o-1)+((0.142841830551-0.435645907379j))
        arg[2, 3, 3]=(-0.469220078479-0.738890942345j)*x[0]**o+((-0.201026974122-0.346531853351j))*x[0]+((0.339292384985+0.116026473782j))*x[1]**o+((-0.860583703777+0.168827001406j))*x[1]
        ref[2, 3, 3, 0]=(-0.469220078479-0.738890942345j)*o*x_ref[0]**(o-1)+((-0.201026974122-0.346531853351j))
        ref[2, 3, 3, 1]=(0.339292384985+0.116026473782j)*o*x_ref[1]**(o-1)+((-0.860583703777+0.168827001406j))
        if dim==3:
            arg[0, 0, 0]+=(-0.548123968234+0.67647307833j)*x[2]**o+((-0.118110618062-0.0209230588935j))*x[2]
            ref[0, 0, 0, 2]=(-0.548123968234+0.67647307833j)*o*x_ref[2]**(o-1)+((-0.118110618062-0.0209230588935j))
            arg[0, 0, 1]+=(0.0528065413048+0.377423914688j)*x[2]**o+((-0.0806036692377-0.443881579874j))*x[2]
            ref[0, 0, 1, 2]=(0.0528065413048+0.377423914688j)*o*x_ref[2]**(o-1)+((-0.0806036692377-0.443881579874j))
            arg[0, 0, 2]+=(-0.800295409014+0.0798880708898j)*x[2]**o+((0.450076782279-0.095460811127j))*x[2]
            ref[0, 0, 2, 2]=(-0.800295409014+0.0798880708898j)*o*x_ref[2]**(o-1)+((0.450076782279-0.095460811127j))
            arg[0, 0, 3]+=(-0.437523270971+0.379650451513j)*x[2]**o+((0.255050849683+0.636143277959j))*x[2]
            ref[0, 0, 3, 2]=(-0.437523270971+0.379650451513j)*o*x_ref[2]**(o-1)+((0.255050849683+0.636143277959j))
            arg[0, 1, 0]+=(0.93127649487-0.248974520326j)*x[2]**o+((0.0379472281242-0.0466512708843j))*x[2]
            ref[0, 1, 0, 2]=(0.93127649487-0.248974520326j)*o*x_ref[2]**(o-1)+((0.0379472281242-0.0466512708843j))
            arg[0, 1, 1]+=(-0.34734976177+0.277706072563j)*x[2]**o+((0.0893071596905+0.176604223038j))*x[2]
            ref[0, 1, 1, 2]=(-0.34734976177+0.277706072563j)*o*x_ref[2]**(o-1)+((0.0893071596905+0.176604223038j))
            arg[0, 1, 2]+=(0.352139966179-0.000322563319353j)*x[2]**o+((0.429358855716+0.38264350846j))*x[2]
            ref[0, 1, 2, 2]=(0.352139966179-0.000322563319353j)*o*x_ref[2]**(o-1)+((0.429358855716+0.38264350846j))
            arg[0, 1, 3]+=(-0.283325625964-0.356545079145j)*x[2]**o+((-0.165909744558-0.000401864086318j))*x[2]
            ref[0, 1, 3, 2]=(-0.283325625964-0.356545079145j)*o*x_ref[2]**(o-1)+((-0.165909744558-0.000401864086318j))
            arg[0, 2, 0]+=(-0.105169958162+0.100296792819j)*x[2]**o+((-0.474186655314+0.267330694715j))*x[2]
            ref[0, 2, 0, 2]=(-0.105169958162+0.100296792819j)*o*x_ref[2]**(o-1)+((-0.474186655314+0.267330694715j))
            arg[0, 2, 1]+=(-0.366984882295+0.332800812688j)*x[2]**o+((-0.915648016797+0.0487985067352j))*x[2]
            ref[0, 2, 1, 2]=(-0.366984882295+0.332800812688j)*o*x_ref[2]**(o-1)+((-0.915648016797+0.0487985067352j))
            arg[0, 2, 2]+=(0.164559920175-0.0955892419419j)*x[2]**o+((0.217336516081-0.542372472997j))*x[2]
            ref[0, 2, 2, 2]=(0.164559920175-0.0955892419419j)*o*x_ref[2]**(o-1)+((0.217336516081-0.542372472997j))
            arg[0, 2, 3]+=(-0.965602869053+0.464749447864j)*x[2]**o+((0.159794363385-0.585931436516j))*x[2]
            ref[0, 2, 3, 2]=(-0.965602869053+0.464749447864j)*o*x_ref[2]**(o-1)+((0.159794363385-0.585931436516j))
            arg[0, 3, 0]+=(-0.038439468629-0.176742907529j)*x[2]**o+((-0.95166126268+0.0133427521302j))*x[2]
            ref[0, 3, 0, 2]=(-0.038439468629-0.176742907529j)*o*x_ref[2]**(o-1)+((-0.95166126268+0.0133427521302j))
            arg[0, 3, 1]+=(0.388027285913-0.665498296575j)*x[2]**o+((0.0379666138848+0.765059531036j))*x[2]
            ref[0, 3, 1, 2]=(0.388027285913-0.665498296575j)*o*x_ref[2]**(o-1)+((0.0379666138848+0.765059531036j))
            arg[0, 3, 2]+=(0.810461252959+0.579957545376j)*x[2]**o+((0.0847557095968+0.694903354797j))*x[2]
            ref[0, 3, 2, 2]=(0.810461252959+0.579957545376j)*o*x_ref[2]**(o-1)+((0.0847557095968+0.694903354797j))
            arg[0, 3, 3]+=(-0.0588198858351-0.642009752742j)*x[2]**o+((0.693347974788+0.808999921937j))*x[2]
            ref[0, 3, 3, 2]=(-0.0588198858351-0.642009752742j)*o*x_ref[2]**(o-1)+((0.693347974788+0.808999921937j))
            arg[1, 0, 0]+=(0.811304148935-0.491938563637j)*x[2]**o+((0.283962631325+0.208553956501j))*x[2]
            ref[1, 0, 0, 2]=(0.811304148935-0.491938563637j)*o*x_ref[2]**(o-1)+((0.283962631325+0.208553956501j))
            arg[1, 0, 1]+=(0.780631368478+0.0386182470453j)*x[2]**o+((0.486363010067-0.0841857805445j))*x[2]
            ref[1, 0, 1, 2]=(0.780631368478+0.0386182470453j)*o*x_ref[2]**(o-1)+((0.486363010067-0.0841857805445j))
            arg[1, 0, 2]+=(-0.862041867942-0.358230855076j)*x[2]**o+((0.641989177787-0.45373011475j))*x[2]
            ref[1, 0, 2, 2]=(-0.862041867942-0.358230855076j)*o*x_ref[2]**(o-1)+((0.641989177787-0.45373011475j))
            arg[1, 0, 3]+=(0.509532781422+0.191634568338j)*x[2]**o+((-0.702950389143-0.323932358809j))*x[2]
            ref[1, 0, 3, 2]=(0.509532781422+0.191634568338j)*o*x_ref[2]**(o-1)+((-0.702950389143-0.323932358809j))
            arg[1, 1, 0]+=(0.300170630574-0.431382596636j)*x[2]**o+((0.579018801024+0.805382569815j))*x[2]
            ref[1, 1, 0, 2]=(0.300170630574-0.431382596636j)*o*x_ref[2]**(o-1)+((0.579018801024+0.805382569815j))
            arg[1, 1, 1]+=(-0.642350499073-0.358282621992j)*x[2]**o+((0.510472415939+0.547111169402j))*x[2]
            ref[1, 1, 1, 2]=(-0.642350499073-0.358282621992j)*o*x_ref[2]**(o-1)+((0.510472415939+0.547111169402j))
            arg[1, 1, 2]+=(0.0777716656097+0.761326478558j)*x[2]**o+((-0.999718393847+0.0504804259488j))*x[2]
            ref[1, 1, 2, 2]=(0.0777716656097+0.761326478558j)*o*x_ref[2]**(o-1)+((-0.999718393847+0.0504804259488j))
            arg[1, 1, 3]+=(-0.289230504817+0.128082939519j)*x[2]**o+((0.168305459814-0.00970492299782j))*x[2]
            ref[1, 1, 3, 2]=(-0.289230504817+0.128082939519j)*o*x_ref[2]**(o-1)+((0.168305459814-0.00970492299782j))
            arg[1, 2, 0]+=(-0.229321040707-0.179384929309j)*x[2]**o+((0.719562472363-0.300119675157j))*x[2]
            ref[1, 2, 0, 2]=(-0.229321040707-0.179384929309j)*o*x_ref[2]**(o-1)+((0.719562472363-0.300119675157j))
            arg[1, 2, 1]+=(0.879749453868-0.30492229855j)*x[2]**o+((-0.755033239533-0.760053712187j))*x[2]
            ref[1, 2, 1, 2]=(0.879749453868-0.30492229855j)*o*x_ref[2]**(o-1)+((-0.755033239533-0.760053712187j))
            arg[1, 2, 2]+=(0.634593495053-0.285043069102j)*x[2]**o+((-0.195265175627-0.742562143681j))*x[2]
            ref[1, 2, 2, 2]=(0.634593495053-0.285043069102j)*o*x_ref[2]**(o-1)+((-0.195265175627-0.742562143681j))
            arg[1, 2, 3]+=(0.764096689454+0.0956079010723j)*x[2]**o+((-0.524402158733+0.829625251167j))*x[2]
            ref[1, 2, 3, 2]=(0.764096689454+0.0956079010723j)*o*x_ref[2]**(o-1)+((-0.524402158733+0.829625251167j))
            arg[1, 3, 0]+=(-0.953685213362+0.036752979562j)*x[2]**o+((0.108814642543+0.54961828675j))*x[2]
            ref[1, 3, 0, 2]=(-0.953685213362+0.036752979562j)*o*x_ref[2]**(o-1)+((0.108814642543+0.54961828675j))
            arg[1, 3, 1]+=(0.114374631987-0.32695251984j)*x[2]**o+((-0.860949236478+0.343909195916j))*x[2]
            ref[1, 3, 1, 2]=(0.114374631987-0.32695251984j)*o*x_ref[2]**(o-1)+((-0.860949236478+0.343909195916j))
            arg[1, 3, 2]+=(-0.177501183533+0.342271936784j)*x[2]**o+((-0.304073937675-0.207569158881j))*x[2]
            ref[1, 3, 2, 2]=(-0.177501183533+0.342271936784j)*o*x_ref[2]**(o-1)+((-0.304073937675-0.207569158881j))
            arg[1, 3, 3]+=(0.607624686169-0.135191923576j)*x[2]**o+((-0.418697981965+0.644505511835j))*x[2]
            ref[1, 3, 3, 2]=(0.607624686169-0.135191923576j)*o*x_ref[2]**(o-1)+((-0.418697981965+0.644505511835j))
            arg[2, 0, 0]+=(-0.927416865472+0.217196242318j)*x[2]**o+((0.936671190022+0.510279570778j))*x[2]
            ref[2, 0, 0, 2]=(-0.927416865472+0.217196242318j)*o*x_ref[2]**(o-1)+((0.936671190022+0.510279570778j))
            arg[2, 0, 1]+=(0.883440131653+0.300212149869j)*x[2]**o+((0.232995958836-0.878705396556j))*x[2]
            ref[2, 0, 1, 2]=(0.883440131653+0.300212149869j)*o*x_ref[2]**(o-1)+((0.232995958836-0.878705396556j))
            arg[2, 0, 2]+=(0.892853918547+0.174729094644j)*x[2]**o+((-0.768082643579+0.815593401938j))*x[2]
            ref[2, 0, 2, 2]=(0.892853918547+0.174729094644j)*o*x_ref[2]**(o-1)+((-0.768082643579+0.815593401938j))
            arg[2, 0, 3]+=(0.701635683101-0.917603719241j)*x[2]**o+((0.527199924053-0.59561757016j))*x[2]
            ref[2, 0, 3, 2]=(0.701635683101-0.917603719241j)*o*x_ref[2]**(o-1)+((0.527199924053-0.59561757016j))
            arg[2, 1, 0]+=(0.438813144178+0.304299303539j)*x[2]**o+((0.664039607776+0.717153926072j))*x[2]
            ref[2, 1, 0, 2]=(0.438813144178+0.304299303539j)*o*x_ref[2]**(o-1)+((0.664039607776+0.717153926072j))
            arg[2, 1, 1]+=(-0.660640272041-0.491091834635j)*x[2]**o+((-0.325655108313+0.555961459321j))*x[2]
            ref[2, 1, 1, 2]=(-0.660640272041-0.491091834635j)*o*x_ref[2]**(o-1)+((-0.325655108313+0.555961459321j))
            arg[2, 1, 2]+=(0.827953429572+0.0301165389935j)*x[2]**o+((-0.503442590432+0.351539933002j))*x[2]
            ref[2, 1, 2, 2]=(0.827953429572+0.0301165389935j)*o*x_ref[2]**(o-1)+((-0.503442590432+0.351539933002j))
            arg[2, 1, 3]+=(-0.627113927132-0.226944038897j)*x[2]**o+((-0.372279554335+0.344626105687j))*x[2]
            ref[2, 1, 3, 2]=(-0.627113927132-0.226944038897j)*o*x_ref[2]**(o-1)+((-0.372279554335+0.344626105687j))
            arg[2, 2, 0]+=(0.192230927808+0.927298893319j)*x[2]**o+((0.91449367675+0.51854517849j))*x[2]
            ref[2, 2, 0, 2]=(0.192230927808+0.927298893319j)*o*x_ref[2]**(o-1)+((0.91449367675+0.51854517849j))
            arg[2, 2, 1]+=(0.386936918642-0.407697994971j)*x[2]**o+((-0.5571163275+0.785470170308j))*x[2]
            ref[2, 2, 1, 2]=(0.386936918642-0.407697994971j)*o*x_ref[2]**(o-1)+((-0.5571163275+0.785470170308j))
            arg[2, 2, 2]+=(0.499855910842+0.993815399656j)*x[2]**o+((-0.698919546358-0.48047163554j))*x[2]
            ref[2, 2, 2, 2]=(0.499855910842+0.993815399656j)*o*x_ref[2]**(o-1)+((-0.698919546358-0.48047163554j))
            arg[2, 2, 3]+=(-0.0490700622497+0.141365098807j)*x[2]**o+((-0.538540534365+0.69655270412j))*x[2]
            ref[2, 2, 3, 2]=(-0.0490700622497+0.141365098807j)*o*x_ref[2]**(o-1)+((-0.538540534365+0.69655270412j))
            arg[2, 3, 0]+=(-0.502843306119+0.855018517894j)*x[2]**o+((-0.534049830444+0.473106337165j))*x[2]
            ref[2, 3, 0, 2]=(-0.502843306119+0.855018517894j)*o*x_ref[2]**(o-1)+((-0.534049830444+0.473106337165j))
            arg[2, 3, 1]+=(-0.197118030526-0.248228579893j)*x[2]**o+((-0.297686853057+0.259893953951j))*x[2]
            ref[2, 3, 1, 2]=(-0.197118030526-0.248228579893j)*o*x_ref[2]**(o-1)+((-0.297686853057+0.259893953951j))
            arg[2, 3, 2]+=(-0.419082223083+0.918282128724j)*x[2]**o+((0.852533886815+0.259401067221j))*x[2]
            ref[2, 3, 2, 2]=(-0.419082223083+0.918282128724j)*o*x_ref[2]**(o-1)+((0.852533886815+0.259401067221j))
            arg[2, 3, 3]+=(0.92069773213-0.146940397632j)*x[2]**o+((0.00277961038062+0.942317046517j))*x[2]
            ref[2, 3, 3, 2]=(0.92069773213-0.146940397632j)*o*x_ref[2]**(o-1)+((0.00277961038062+0.942317046517j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3, 4, 4)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunction_fromData_ReducedSolution_rank0(self):
        """
        tests gradient of rank 0 Data on ReducedFunction

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=(-0.0847910893018+0.3039055724j)*x[0]+((0.0271516729638+0.0125022694181j))*x[1]
        ref[0]=(-0.0847910893018+0.3039055724j)
        ref[1]=(0.0271516729638+0.0125022694181j)
        if dim==3:
            arg+=((0.113306733744+0.774559065202j))*x[2]
            ref[2]=(0.113306733744+0.774559065202j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunction_fromData_ReducedSolution_rank1(self):
        """
        tests gradient of rank 1 Data on ReducedFunction

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(4,),w)
        ref = Data(0,(4,)+(dim,),w_ref)
        arg[0,]=(0.175969777823-0.396470606331j)*x[0]+((0.503130267819-0.52760224332j))*x[1]
        ref[0, 0]=(0.175969777823-0.396470606331j)
        ref[0, 1]=(0.503130267819-0.52760224332j)
        arg[1,]=(-0.799641670938-0.606052664479j)*x[0]+((0.975223458992+0.437214707769j))*x[1]
        ref[1, 0]=(-0.799641670938-0.606052664479j)
        ref[1, 1]=(0.975223458992+0.437214707769j)
        arg[2,]=(-0.342724529673+0.327034344117j)*x[0]+((0.0763936473994-0.0298133668704j))*x[1]
        ref[2, 0]=(-0.342724529673+0.327034344117j)
        ref[2, 1]=(0.0763936473994-0.0298133668704j)
        arg[3,]=(-0.307951807028-0.249802186019j)*x[0]+((-0.394470912254-0.289012846083j))*x[1]
        ref[3, 0]=(-0.307951807028-0.249802186019j)
        ref[3, 1]=(-0.394470912254-0.289012846083j)
        if dim==3:
            arg[0,]+=(0.669894000201+0.708319970364j)*x[2]
            ref[0, 2]=(0.669894000201+0.708319970364j)
            arg[1,]+=(0.884060695197+0.87827132764j)*x[2]
            ref[1, 2]=(0.884060695197+0.87827132764j)
            arg[2,]+=(-0.674711978982+0.0535289864238j)*x[2]
            ref[2, 2]=(-0.674711978982+0.0535289864238j)
            arg[3,]+=(-0.571678288084+0.300965361255j)*x[2]
            ref[3, 2]=(-0.571678288084+0.300965361255j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunction_fromData_ReducedSolution_rank2(self):
        """
        tests gradient of rank 2 Data on ReducedFunction

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(4, 3),w)
        ref = Data(0,(4, 3)+(dim,),w_ref)
        arg[0, 0]=(0.0414430379442+0.156245407637j)*x[0]+((-0.284721881387-0.323430284096j))*x[1]
        ref[0, 0, 0]=(0.0414430379442+0.156245407637j)
        ref[0, 0, 1]=(-0.284721881387-0.323430284096j)
        arg[0, 1]=(0.88010403697+0.907019507351j)*x[0]+((-0.207940208083-0.0952855695814j))*x[1]
        ref[0, 1, 0]=(0.88010403697+0.907019507351j)
        ref[0, 1, 1]=(-0.207940208083-0.0952855695814j)
        arg[0, 2]=(-0.262128906556-0.914694010336j)*x[0]+((0.980702524238+0.968933176948j))*x[1]
        ref[0, 2, 0]=(-0.262128906556-0.914694010336j)
        ref[0, 2, 1]=(0.980702524238+0.968933176948j)
        arg[1, 0]=(-0.684420811362+0.606300179654j)*x[0]+((0.0193768251941+0.0231605000644j))*x[1]
        ref[1, 0, 0]=(-0.684420811362+0.606300179654j)
        ref[1, 0, 1]=(0.0193768251941+0.0231605000644j)
        arg[1, 1]=(0.387612382501+0.808739736502j)*x[0]+((0.729455406359+0.591749119458j))*x[1]
        ref[1, 1, 0]=(0.387612382501+0.808739736502j)
        ref[1, 1, 1]=(0.729455406359+0.591749119458j)
        arg[1, 2]=(0.614083110957+0.0590752521229j)*x[0]+((-0.889506123621+0.395621727218j))*x[1]
        ref[1, 2, 0]=(0.614083110957+0.0590752521229j)
        ref[1, 2, 1]=(-0.889506123621+0.395621727218j)
        arg[2, 0]=(0.088663496486-0.537171595045j)*x[0]+((-0.231296118406+0.888801119506j))*x[1]
        ref[2, 0, 0]=(0.088663496486-0.537171595045j)
        ref[2, 0, 1]=(-0.231296118406+0.888801119506j)
        arg[2, 1]=(0.163356863452-0.980541888552j)*x[0]+((0.921548914176+0.476762577755j))*x[1]
        ref[2, 1, 0]=(0.163356863452-0.980541888552j)
        ref[2, 1, 1]=(0.921548914176+0.476762577755j)
        arg[2, 2]=(0.827666310768+0.0286197252685j)*x[0]+((-0.540777651838-0.015068323872j))*x[1]
        ref[2, 2, 0]=(0.827666310768+0.0286197252685j)
        ref[2, 2, 1]=(-0.540777651838-0.015068323872j)
        arg[3, 0]=(-0.542712373016+0.0179199468853j)*x[0]+((0.869233445791+0.320840262597j))*x[1]
        ref[3, 0, 0]=(-0.542712373016+0.0179199468853j)
        ref[3, 0, 1]=(0.869233445791+0.320840262597j)
        arg[3, 1]=(-0.641769535948-0.447741342625j)*x[0]+((-0.67381375887-0.860214229166j))*x[1]
        ref[3, 1, 0]=(-0.641769535948-0.447741342625j)
        ref[3, 1, 1]=(-0.67381375887-0.860214229166j)
        arg[3, 2]=(-0.383296639844-0.879979466288j)*x[0]+((0.310080267606-0.970463354209j))*x[1]
        ref[3, 2, 0]=(-0.383296639844-0.879979466288j)
        ref[3, 2, 1]=(0.310080267606-0.970463354209j)
        if dim==3:
            arg[0, 0]+=(-0.969301037365+0.884322170264j)*x[2]
            ref[0, 0, 2]=(-0.969301037365+0.884322170264j)
            arg[0, 1]+=(0.185787804295+0.575742948269j)*x[2]
            ref[0, 1, 2]=(0.185787804295+0.575742948269j)
            arg[0, 2]+=(0.796467996987-0.414315810224j)*x[2]
            ref[0, 2, 2]=(0.796467996987-0.414315810224j)
            arg[1, 0]+=(0.401409219876+0.417296143246j)*x[2]
            ref[1, 0, 2]=(0.401409219876+0.417296143246j)
            arg[1, 1]+=(0.648813050019+0.281351554608j)*x[2]
            ref[1, 1, 2]=(0.648813050019+0.281351554608j)
            arg[1, 2]+=(-0.966924916085+0.661534439947j)*x[2]
            ref[1, 2, 2]=(-0.966924916085+0.661534439947j)
            arg[2, 0]+=(0.754822893201-0.829166977786j)*x[2]
            ref[2, 0, 2]=(0.754822893201-0.829166977786j)
            arg[2, 1]+=(-0.625549642606-0.618979657982j)*x[2]
            ref[2, 1, 2]=(-0.625549642606-0.618979657982j)
            arg[2, 2]+=(-0.976398315506+0.355106461306j)*x[2]
            ref[2, 2, 2]=(-0.976398315506+0.355106461306j)
            arg[3, 0]+=(0.286141321376-0.79822170197j)*x[2]
            ref[3, 0, 2]=(0.286141321376-0.79822170197j)
            arg[3, 1]+=(0.81453918528-0.377120151349j)*x[2]
            ref[3, 1, 2]=(0.81453918528-0.377120151349j)
            arg[3, 2]+=(0.21402967168+0.868480566125j)*x[2]
            ref[3, 2, 2]=(0.21402967168+0.868480566125j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4, 3)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunction_fromData_ReducedSolution_rank3(self):
        """
        tests gradient of rank 3 Data on ReducedFunction

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(2, 4, 4),w)
        ref = Data(0,(2, 4, 4)+(dim,),w_ref)
        arg[0, 0, 0]=(0.298530121956+0.893779729875j)*x[0]+((-0.908224662987-0.63848487272j))*x[1]
        ref[0, 0, 0, 0]=(0.298530121956+0.893779729875j)
        ref[0, 0, 0, 1]=(-0.908224662987-0.63848487272j)
        arg[0, 0, 1]=(-0.615050060174+0.466406600996j)*x[0]+((0.83967709753-0.0609723397183j))*x[1]
        ref[0, 0, 1, 0]=(-0.615050060174+0.466406600996j)
        ref[0, 0, 1, 1]=(0.83967709753-0.0609723397183j)
        arg[0, 0, 2]=(-0.367647468755-0.621171450211j)*x[0]+((-0.99102615825+0.938633167846j))*x[1]
        ref[0, 0, 2, 0]=(-0.367647468755-0.621171450211j)
        ref[0, 0, 2, 1]=(-0.99102615825+0.938633167846j)
        arg[0, 0, 3]=(0.809552022097+0.497732233879j)*x[0]+((-0.485376156114-0.345582896324j))*x[1]
        ref[0, 0, 3, 0]=(0.809552022097+0.497732233879j)
        ref[0, 0, 3, 1]=(-0.485376156114-0.345582896324j)
        arg[0, 1, 0]=(-0.695074025386+0.879636010586j)*x[0]+((0.536026159456+0.472434743965j))*x[1]
        ref[0, 1, 0, 0]=(-0.695074025386+0.879636010586j)
        ref[0, 1, 0, 1]=(0.536026159456+0.472434743965j)
        arg[0, 1, 1]=(0.911924878765-0.0121819289427j)*x[0]+((0.912727690963-0.593655723594j))*x[1]
        ref[0, 1, 1, 0]=(0.911924878765-0.0121819289427j)
        ref[0, 1, 1, 1]=(0.912727690963-0.593655723594j)
        arg[0, 1, 2]=(-0.795295984459-0.544589386495j)*x[0]+((0.779257825134+0.767217666439j))*x[1]
        ref[0, 1, 2, 0]=(-0.795295984459-0.544589386495j)
        ref[0, 1, 2, 1]=(0.779257825134+0.767217666439j)
        arg[0, 1, 3]=(-0.433349109221-0.540752525287j)*x[0]+((0.275221835054+0.653703937861j))*x[1]
        ref[0, 1, 3, 0]=(-0.433349109221-0.540752525287j)
        ref[0, 1, 3, 1]=(0.275221835054+0.653703937861j)
        arg[0, 2, 0]=(0.744613298255+0.750922657035j)*x[0]+((0.440565888695-0.547901272099j))*x[1]
        ref[0, 2, 0, 0]=(0.744613298255+0.750922657035j)
        ref[0, 2, 0, 1]=(0.440565888695-0.547901272099j)
        arg[0, 2, 1]=(-0.968513622804+0.138373831093j)*x[0]+((-0.21352662283+0.381571550775j))*x[1]
        ref[0, 2, 1, 0]=(-0.968513622804+0.138373831093j)
        ref[0, 2, 1, 1]=(-0.21352662283+0.381571550775j)
        arg[0, 2, 2]=(-0.78652071111+0.805635535669j)*x[0]+((-0.486742949831-0.515064836329j))*x[1]
        ref[0, 2, 2, 0]=(-0.78652071111+0.805635535669j)
        ref[0, 2, 2, 1]=(-0.486742949831-0.515064836329j)
        arg[0, 2, 3]=(0.428369401857-0.752497295679j)*x[0]+((-0.96287182655+0.150773374543j))*x[1]
        ref[0, 2, 3, 0]=(0.428369401857-0.752497295679j)
        ref[0, 2, 3, 1]=(-0.96287182655+0.150773374543j)
        arg[0, 3, 0]=(0.738116269434-0.978524331724j)*x[0]+((-0.486633420859+0.614712485526j))*x[1]
        ref[0, 3, 0, 0]=(0.738116269434-0.978524331724j)
        ref[0, 3, 0, 1]=(-0.486633420859+0.614712485526j)
        arg[0, 3, 1]=(0.131667663971+0.325952715107j)*x[0]+((-0.227842582083-0.5096253116j))*x[1]
        ref[0, 3, 1, 0]=(0.131667663971+0.325952715107j)
        ref[0, 3, 1, 1]=(-0.227842582083-0.5096253116j)
        arg[0, 3, 2]=(0.225081092398-0.314190426482j)*x[0]+((0.901977247683-0.725557905844j))*x[1]
        ref[0, 3, 2, 0]=(0.225081092398-0.314190426482j)
        ref[0, 3, 2, 1]=(0.901977247683-0.725557905844j)
        arg[0, 3, 3]=(-0.961443129121-0.0878213217316j)*x[0]+((-0.93525002348-0.698174302806j))*x[1]
        ref[0, 3, 3, 0]=(-0.961443129121-0.0878213217316j)
        ref[0, 3, 3, 1]=(-0.93525002348-0.698174302806j)
        arg[1, 0, 0]=(-0.624708589486+0.8820181828j)*x[0]+((0.68898011176+0.54613963365j))*x[1]
        ref[1, 0, 0, 0]=(-0.624708589486+0.8820181828j)
        ref[1, 0, 0, 1]=(0.68898011176+0.54613963365j)
        arg[1, 0, 1]=(-0.988324751173+0.935949289521j)*x[0]+((-0.522100443287+0.529294297572j))*x[1]
        ref[1, 0, 1, 0]=(-0.988324751173+0.935949289521j)
        ref[1, 0, 1, 1]=(-0.522100443287+0.529294297572j)
        arg[1, 0, 2]=(-0.247563036634+0.891032054141j)*x[0]+((-0.950619980792-0.959307915321j))*x[1]
        ref[1, 0, 2, 0]=(-0.247563036634+0.891032054141j)
        ref[1, 0, 2, 1]=(-0.950619980792-0.959307915321j)
        arg[1, 0, 3]=(0.831953590869+0.0898296444445j)*x[0]+((-0.562226021319-0.911307925883j))*x[1]
        ref[1, 0, 3, 0]=(0.831953590869+0.0898296444445j)
        ref[1, 0, 3, 1]=(-0.562226021319-0.911307925883j)
        arg[1, 1, 0]=(0.238298531577+0.459699682691j)*x[0]+((-0.43393949551+0.373233889627j))*x[1]
        ref[1, 1, 0, 0]=(0.238298531577+0.459699682691j)
        ref[1, 1, 0, 1]=(-0.43393949551+0.373233889627j)
        arg[1, 1, 1]=(-0.610540605342+0.852150232057j)*x[0]+((-0.205056825525+0.571513118437j))*x[1]
        ref[1, 1, 1, 0]=(-0.610540605342+0.852150232057j)
        ref[1, 1, 1, 1]=(-0.205056825525+0.571513118437j)
        arg[1, 1, 2]=(0.573263180022-0.135589572711j)*x[0]+((0.773623385046-0.678399048337j))*x[1]
        ref[1, 1, 2, 0]=(0.573263180022-0.135589572711j)
        ref[1, 1, 2, 1]=(0.773623385046-0.678399048337j)
        arg[1, 1, 3]=(0.569202844176-0.921476516976j)*x[0]+((-0.606543677065-0.269349664255j))*x[1]
        ref[1, 1, 3, 0]=(0.569202844176-0.921476516976j)
        ref[1, 1, 3, 1]=(-0.606543677065-0.269349664255j)
        arg[1, 2, 0]=(-0.501265139795+0.536195222257j)*x[0]+((-0.0751330579914+0.880772512772j))*x[1]
        ref[1, 2, 0, 0]=(-0.501265139795+0.536195222257j)
        ref[1, 2, 0, 1]=(-0.0751330579914+0.880772512772j)
        arg[1, 2, 1]=(0.42103957507-0.00855816845993j)*x[0]+((0.672597544173+0.325051952099j))*x[1]
        ref[1, 2, 1, 0]=(0.42103957507-0.00855816845993j)
        ref[1, 2, 1, 1]=(0.672597544173+0.325051952099j)
        arg[1, 2, 2]=(0.197268920706-0.817564527023j)*x[0]+((0.708010644038-0.308918522937j))*x[1]
        ref[1, 2, 2, 0]=(0.197268920706-0.817564527023j)
        ref[1, 2, 2, 1]=(0.708010644038-0.308918522937j)
        arg[1, 2, 3]=(0.069410195265+0.631952180943j)*x[0]+((0.478945340054+0.0185836528035j))*x[1]
        ref[1, 2, 3, 0]=(0.069410195265+0.631952180943j)
        ref[1, 2, 3, 1]=(0.478945340054+0.0185836528035j)
        arg[1, 3, 0]=(0.622821483634-0.348755094023j)*x[0]+((-0.703910479168-0.224001999913j))*x[1]
        ref[1, 3, 0, 0]=(0.622821483634-0.348755094023j)
        ref[1, 3, 0, 1]=(-0.703910479168-0.224001999913j)
        arg[1, 3, 1]=(0.256849948537+0.269238793211j)*x[0]+((-0.330932134329+0.425361773339j))*x[1]
        ref[1, 3, 1, 0]=(0.256849948537+0.269238793211j)
        ref[1, 3, 1, 1]=(-0.330932134329+0.425361773339j)
        arg[1, 3, 2]=(-0.473829084079-0.210808804851j)*x[0]+((0.392241833542+0.460804019561j))*x[1]
        ref[1, 3, 2, 0]=(-0.473829084079-0.210808804851j)
        ref[1, 3, 2, 1]=(0.392241833542+0.460804019561j)
        arg[1, 3, 3]=(-0.612013365328+0.265424693889j)*x[0]+((0.286004070766+0.107925480017j))*x[1]
        ref[1, 3, 3, 0]=(-0.612013365328+0.265424693889j)
        ref[1, 3, 3, 1]=(0.286004070766+0.107925480017j)
        if dim==3:
            arg[0, 0, 0]+=(-0.578535965904-0.565948204003j)*x[2]
            ref[0, 0, 0, 2]=(-0.578535965904-0.565948204003j)
            arg[0, 0, 1]+=(0.54054018252+0.402920940293j)*x[2]
            ref[0, 0, 1, 2]=(0.54054018252+0.402920940293j)
            arg[0, 0, 2]+=(0.0444523412365-0.918721998693j)*x[2]
            ref[0, 0, 2, 2]=(0.0444523412365-0.918721998693j)
            arg[0, 0, 3]+=(0.607740111314-0.921658646496j)*x[2]
            ref[0, 0, 3, 2]=(0.607740111314-0.921658646496j)
            arg[0, 1, 0]+=(-0.535594367818-0.98604680339j)*x[2]
            ref[0, 1, 0, 2]=(-0.535594367818-0.98604680339j)
            arg[0, 1, 1]+=(0.0358567206502+0.402883239847j)*x[2]
            ref[0, 1, 1, 2]=(0.0358567206502+0.402883239847j)
            arg[0, 1, 2]+=(0.177059276364-0.516421414127j)*x[2]
            ref[0, 1, 2, 2]=(0.177059276364-0.516421414127j)
            arg[0, 1, 3]+=(0.0683305391378+0.661196515134j)*x[2]
            ref[0, 1, 3, 2]=(0.0683305391378+0.661196515134j)
            arg[0, 2, 0]+=(0.165100784889+0.317158002603j)*x[2]
            ref[0, 2, 0, 2]=(0.165100784889+0.317158002603j)
            arg[0, 2, 1]+=(0.0877168405479+0.898240139182j)*x[2]
            ref[0, 2, 1, 2]=(0.0877168405479+0.898240139182j)
            arg[0, 2, 2]+=(-0.874369264356+0.31256040361j)*x[2]
            ref[0, 2, 2, 2]=(-0.874369264356+0.31256040361j)
            arg[0, 2, 3]+=(-0.875237745701-0.507028668879j)*x[2]
            ref[0, 2, 3, 2]=(-0.875237745701-0.507028668879j)
            arg[0, 3, 0]+=(0.147104911721+0.0975851771951j)*x[2]
            ref[0, 3, 0, 2]=(0.147104911721+0.0975851771951j)
            arg[0, 3, 1]+=(-0.882841147136-0.234498112447j)*x[2]
            ref[0, 3, 1, 2]=(-0.882841147136-0.234498112447j)
            arg[0, 3, 2]+=(-0.769218800761+0.962183942873j)*x[2]
            ref[0, 3, 2, 2]=(-0.769218800761+0.962183942873j)
            arg[0, 3, 3]+=(-0.676887977968+0.0962170012104j)*x[2]
            ref[0, 3, 3, 2]=(-0.676887977968+0.0962170012104j)
            arg[1, 0, 0]+=(0.696883568982+0.363978693499j)*x[2]
            ref[1, 0, 0, 2]=(0.696883568982+0.363978693499j)
            arg[1, 0, 1]+=(0.581480421424-0.298132960985j)*x[2]
            ref[1, 0, 1, 2]=(0.581480421424-0.298132960985j)
            arg[1, 0, 2]+=(-0.862102530349+0.637061433797j)*x[2]
            ref[1, 0, 2, 2]=(-0.862102530349+0.637061433797j)
            arg[1, 0, 3]+=(0.135485836754-0.606798334597j)*x[2]
            ref[1, 0, 3, 2]=(0.135485836754-0.606798334597j)
            arg[1, 1, 0]+=(0.570959050839+0.71126388999j)*x[2]
            ref[1, 1, 0, 2]=(0.570959050839+0.71126388999j)
            arg[1, 1, 1]+=(-0.025629693932-0.908912467647j)*x[2]
            ref[1, 1, 1, 2]=(-0.025629693932-0.908912467647j)
            arg[1, 1, 2]+=(0.0887326823869+0.244814078264j)*x[2]
            ref[1, 1, 2, 2]=(0.0887326823869+0.244814078264j)
            arg[1, 1, 3]+=(-0.425626389764+0.90657489931j)*x[2]
            ref[1, 1, 3, 2]=(-0.425626389764+0.90657489931j)
            arg[1, 2, 0]+=(-0.640581573526-0.387744117102j)*x[2]
            ref[1, 2, 0, 2]=(-0.640581573526-0.387744117102j)
            arg[1, 2, 1]+=(0.578956624246-0.231997332486j)*x[2]
            ref[1, 2, 1, 2]=(0.578956624246-0.231997332486j)
            arg[1, 2, 2]+=(0.482062544356-0.112636928606j)*x[2]
            ref[1, 2, 2, 2]=(0.482062544356-0.112636928606j)
            arg[1, 2, 3]+=(0.276975010562+0.244480352013j)*x[2]
            ref[1, 2, 3, 2]=(0.276975010562+0.244480352013j)
            arg[1, 3, 0]+=(0.303100734765+0.248741424634j)*x[2]
            ref[1, 3, 0, 2]=(0.303100734765+0.248741424634j)
            arg[1, 3, 1]+=(0.302850658661+0.135246156782j)*x[2]
            ref[1, 3, 1, 2]=(0.302850658661+0.135246156782j)
            arg[1, 3, 2]+=(-0.711996637996+0.0244576231765j)*x[2]
            ref[1, 3, 2, 2]=(-0.711996637996+0.0244576231765j)
            arg[1, 3, 3]+=(0.933846079368+0.804711281967j)*x[2]
            ref[1, 3, 3, 2]=(0.933846079368+0.804711281967j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2, 4, 4)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunction_fromData_ReducedContinuousFunction_rank0(self):
        """
        tests gradient of rank 0 Data on ReducedFunction

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=(-0.0669964060288-0.870224412138j)*x[0]+((-0.435527996335+0.54613677796j))*x[1]
        ref[0]=(-0.0669964060288-0.870224412138j)
        ref[1]=(-0.435527996335+0.54613677796j)
        if dim==3:
            arg+=((0.662727461794-0.395371380813j))*x[2]
            ref[2]=(0.662727461794-0.395371380813j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunction_fromData_ReducedContinuousFunction_rank1(self):
        """
        tests gradient of rank 1 Data on ReducedFunction

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(3,),w)
        ref = Data(0,(3,)+(dim,),w_ref)
        arg[0,]=(-0.248906303254-0.250465732124j)*x[0]+((-0.0215588940403-0.576566942595j))*x[1]
        ref[0, 0]=(-0.248906303254-0.250465732124j)
        ref[0, 1]=(-0.0215588940403-0.576566942595j)
        arg[1,]=(-0.616698426766-0.86800196328j)*x[0]+((0.406932309566-0.207579436574j))*x[1]
        ref[1, 0]=(-0.616698426766-0.86800196328j)
        ref[1, 1]=(0.406932309566-0.207579436574j)
        arg[2,]=(-0.823081994097+0.216041706916j)*x[0]+((-0.805359856206+0.570345342925j))*x[1]
        ref[2, 0]=(-0.823081994097+0.216041706916j)
        ref[2, 1]=(-0.805359856206+0.570345342925j)
        if dim==3:
            arg[0,]+=(0.956780202488-0.869274886881j)*x[2]
            ref[0, 2]=(0.956780202488-0.869274886881j)
            arg[1,]+=(-0.114869072474-0.503901726748j)*x[2]
            ref[1, 2]=(-0.114869072474-0.503901726748j)
            arg[2,]+=(0.156709697663-0.686038762321j)*x[2]
            ref[2, 2]=(0.156709697663-0.686038762321j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunction_fromData_ReducedContinuousFunction_rank2(self):
        """
        tests gradient of rank 2 Data on ReducedFunction

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(3, 3),w)
        ref = Data(0,(3, 3)+(dim,),w_ref)
        arg[0, 0]=(0.471633467706-0.649642055322j)*x[0]+((0.608380321337+0.615710295862j))*x[1]
        ref[0, 0, 0]=(0.471633467706-0.649642055322j)
        ref[0, 0, 1]=(0.608380321337+0.615710295862j)
        arg[0, 1]=(0.160170067703+0.408156138444j)*x[0]+((0.272493528919+0.317853846976j))*x[1]
        ref[0, 1, 0]=(0.160170067703+0.408156138444j)
        ref[0, 1, 1]=(0.272493528919+0.317853846976j)
        arg[0, 2]=(-0.0202362919582+0.966344952907j)*x[0]+((-0.798234319165-0.225010671907j))*x[1]
        ref[0, 2, 0]=(-0.0202362919582+0.966344952907j)
        ref[0, 2, 1]=(-0.798234319165-0.225010671907j)
        arg[1, 0]=(0.246904505398-0.168903353276j)*x[0]+((0.630639911113-0.683086783109j))*x[1]
        ref[1, 0, 0]=(0.246904505398-0.168903353276j)
        ref[1, 0, 1]=(0.630639911113-0.683086783109j)
        arg[1, 1]=(-0.759834373385+0.94278805267j)*x[0]+((-0.402547271503+0.198539441107j))*x[1]
        ref[1, 1, 0]=(-0.759834373385+0.94278805267j)
        ref[1, 1, 1]=(-0.402547271503+0.198539441107j)
        arg[1, 2]=(0.364316166338+0.678297971475j)*x[0]+((-0.834536258889-0.283213774497j))*x[1]
        ref[1, 2, 0]=(0.364316166338+0.678297971475j)
        ref[1, 2, 1]=(-0.834536258889-0.283213774497j)
        arg[2, 0]=(-0.421936520075-0.613085960986j)*x[0]+((0.464065710303+0.0423957081744j))*x[1]
        ref[2, 0, 0]=(-0.421936520075-0.613085960986j)
        ref[2, 0, 1]=(0.464065710303+0.0423957081744j)
        arg[2, 1]=(0.814636977967-0.187756983173j)*x[0]+((0.665304445367-0.336972935499j))*x[1]
        ref[2, 1, 0]=(0.814636977967-0.187756983173j)
        ref[2, 1, 1]=(0.665304445367-0.336972935499j)
        arg[2, 2]=(0.117566289846+0.999373152103j)*x[0]+((-0.683868335888-0.730772020322j))*x[1]
        ref[2, 2, 0]=(0.117566289846+0.999373152103j)
        ref[2, 2, 1]=(-0.683868335888-0.730772020322j)
        if dim==3:
            arg[0, 0]+=(-0.25091745187+0.51731506933j)*x[2]
            ref[0, 0, 2]=(-0.25091745187+0.51731506933j)
            arg[0, 1]+=(-0.163233034967+0.591839707918j)*x[2]
            ref[0, 1, 2]=(-0.163233034967+0.591839707918j)
            arg[0, 2]+=(-0.26675155965+0.0461230061222j)*x[2]
            ref[0, 2, 2]=(-0.26675155965+0.0461230061222j)
            arg[1, 0]+=(0.3982160461+0.677545637225j)*x[2]
            ref[1, 0, 2]=(0.3982160461+0.677545637225j)
            arg[1, 1]+=(-0.988896905758+0.43633678427j)*x[2]
            ref[1, 1, 2]=(-0.988896905758+0.43633678427j)
            arg[1, 2]+=(-0.342988475546+0.349303376517j)*x[2]
            ref[1, 2, 2]=(-0.342988475546+0.349303376517j)
            arg[2, 0]+=(0.252751184973+0.981343915638j)*x[2]
            ref[2, 0, 2]=(0.252751184973+0.981343915638j)
            arg[2, 1]+=(0.509492487967+0.157784091376j)*x[2]
            ref[2, 1, 2]=(0.509492487967+0.157784091376j)
            arg[2, 2]+=(-0.424657464634-0.883749772362j)*x[2]
            ref[2, 2, 2]=(-0.424657464634-0.883749772362j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3, 3)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunction_fromData_ReducedContinuousFunction_rank3(self):
        """
        tests gradient of rank 3 Data on ReducedFunction

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(3, 3, 4),w)
        ref = Data(0,(3, 3, 4)+(dim,),w_ref)
        arg[0, 0, 0]=(-0.984934436158+0.709378749773j)*x[0]+((0.475633872308+0.0487125853386j))*x[1]
        ref[0, 0, 0, 0]=(-0.984934436158+0.709378749773j)
        ref[0, 0, 0, 1]=(0.475633872308+0.0487125853386j)
        arg[0, 0, 1]=(-0.739141093563-0.841550747926j)*x[0]+((0.939253140589+0.976664303537j))*x[1]
        ref[0, 0, 1, 0]=(-0.739141093563-0.841550747926j)
        ref[0, 0, 1, 1]=(0.939253140589+0.976664303537j)
        arg[0, 0, 2]=(-0.18310993864+0.423917597263j)*x[0]+((0.25371351502-0.473587316351j))*x[1]
        ref[0, 0, 2, 0]=(-0.18310993864+0.423917597263j)
        ref[0, 0, 2, 1]=(0.25371351502-0.473587316351j)
        arg[0, 0, 3]=(-0.729632257309-0.741135449556j)*x[0]+((-0.56186551022-0.687643880644j))*x[1]
        ref[0, 0, 3, 0]=(-0.729632257309-0.741135449556j)
        ref[0, 0, 3, 1]=(-0.56186551022-0.687643880644j)
        arg[0, 1, 0]=(0.369944431402+0.119967061588j)*x[0]+((0.329313028911+0.727116975342j))*x[1]
        ref[0, 1, 0, 0]=(0.369944431402+0.119967061588j)
        ref[0, 1, 0, 1]=(0.329313028911+0.727116975342j)
        arg[0, 1, 1]=(-0.766335971499-0.545076426177j)*x[0]+((0.0704875489923-0.983391284396j))*x[1]
        ref[0, 1, 1, 0]=(-0.766335971499-0.545076426177j)
        ref[0, 1, 1, 1]=(0.0704875489923-0.983391284396j)
        arg[0, 1, 2]=(0.0136058679845-0.995529419845j)*x[0]+((0.21714345565-0.0777064861024j))*x[1]
        ref[0, 1, 2, 0]=(0.0136058679845-0.995529419845j)
        ref[0, 1, 2, 1]=(0.21714345565-0.0777064861024j)
        arg[0, 1, 3]=(-0.244439765409+0.767573522593j)*x[0]+((-0.750486135048+0.366040073468j))*x[1]
        ref[0, 1, 3, 0]=(-0.244439765409+0.767573522593j)
        ref[0, 1, 3, 1]=(-0.750486135048+0.366040073468j)
        arg[0, 2, 0]=(0.965171949608-0.614020917897j)*x[0]+((-0.966177280752-0.57637285474j))*x[1]
        ref[0, 2, 0, 0]=(0.965171949608-0.614020917897j)
        ref[0, 2, 0, 1]=(-0.966177280752-0.57637285474j)
        arg[0, 2, 1]=(0.645354704342+0.440004891076j)*x[0]+((-0.587018586365+0.764164378191j))*x[1]
        ref[0, 2, 1, 0]=(0.645354704342+0.440004891076j)
        ref[0, 2, 1, 1]=(-0.587018586365+0.764164378191j)
        arg[0, 2, 2]=(-0.0923620266015-0.234204770958j)*x[0]+((-0.58357190894+0.524153612264j))*x[1]
        ref[0, 2, 2, 0]=(-0.0923620266015-0.234204770958j)
        ref[0, 2, 2, 1]=(-0.58357190894+0.524153612264j)
        arg[0, 2, 3]=(-0.165467294048+0.598996615663j)*x[0]+((-0.897680029816-0.339595821372j))*x[1]
        ref[0, 2, 3, 0]=(-0.165467294048+0.598996615663j)
        ref[0, 2, 3, 1]=(-0.897680029816-0.339595821372j)
        arg[1, 0, 0]=(-0.448445280581-0.345626263896j)*x[0]+((-0.124423547665-0.737955603456j))*x[1]
        ref[1, 0, 0, 0]=(-0.448445280581-0.345626263896j)
        ref[1, 0, 0, 1]=(-0.124423547665-0.737955603456j)
        arg[1, 0, 1]=(-0.204535531965+0.195606819138j)*x[0]+((0.703283329178+0.763853467698j))*x[1]
        ref[1, 0, 1, 0]=(-0.204535531965+0.195606819138j)
        ref[1, 0, 1, 1]=(0.703283329178+0.763853467698j)
        arg[1, 0, 2]=(-0.133037701965+0.463017585354j)*x[0]+((0.877505186485+0.473809164007j))*x[1]
        ref[1, 0, 2, 0]=(-0.133037701965+0.463017585354j)
        ref[1, 0, 2, 1]=(0.877505186485+0.473809164007j)
        arg[1, 0, 3]=(0.809679299802+0.372606554784j)*x[0]+((0.997210646256+0.887613484544j))*x[1]
        ref[1, 0, 3, 0]=(0.809679299802+0.372606554784j)
        ref[1, 0, 3, 1]=(0.997210646256+0.887613484544j)
        arg[1, 1, 0]=(0.21940906299+0.792131868489j)*x[0]+((-0.613144971646+0.777699327239j))*x[1]
        ref[1, 1, 0, 0]=(0.21940906299+0.792131868489j)
        ref[1, 1, 0, 1]=(-0.613144971646+0.777699327239j)
        arg[1, 1, 1]=(0.576426723641-0.541425994378j)*x[0]+((-0.72895620084-0.771398345754j))*x[1]
        ref[1, 1, 1, 0]=(0.576426723641-0.541425994378j)
        ref[1, 1, 1, 1]=(-0.72895620084-0.771398345754j)
        arg[1, 1, 2]=(-0.624667924086-0.275374893233j)*x[0]+((0.0869685917415+0.640316350315j))*x[1]
        ref[1, 1, 2, 0]=(-0.624667924086-0.275374893233j)
        ref[1, 1, 2, 1]=(0.0869685917415+0.640316350315j)
        arg[1, 1, 3]=(-0.286177626893+0.148670801727j)*x[0]+((-0.542687662616+0.400936889101j))*x[1]
        ref[1, 1, 3, 0]=(-0.286177626893+0.148670801727j)
        ref[1, 1, 3, 1]=(-0.542687662616+0.400936889101j)
        arg[1, 2, 0]=(-0.189655123566+0.693306400228j)*x[0]+((-0.88027071803+0.809330980545j))*x[1]
        ref[1, 2, 0, 0]=(-0.189655123566+0.693306400228j)
        ref[1, 2, 0, 1]=(-0.88027071803+0.809330980545j)
        arg[1, 2, 1]=(0.767555800917+0.713832633358j)*x[0]+((0.993249480607+0.825617147891j))*x[1]
        ref[1, 2, 1, 0]=(0.767555800917+0.713832633358j)
        ref[1, 2, 1, 1]=(0.993249480607+0.825617147891j)
        arg[1, 2, 2]=(-0.674817234368+0.866657116559j)*x[0]+((0.611072073004+0.997449645603j))*x[1]
        ref[1, 2, 2, 0]=(-0.674817234368+0.866657116559j)
        ref[1, 2, 2, 1]=(0.611072073004+0.997449645603j)
        arg[1, 2, 3]=(-0.555363310899-0.915167184343j)*x[0]+((-0.37318370517+0.537944219226j))*x[1]
        ref[1, 2, 3, 0]=(-0.555363310899-0.915167184343j)
        ref[1, 2, 3, 1]=(-0.37318370517+0.537944219226j)
        arg[2, 0, 0]=(-0.921090616447+0.324650070047j)*x[0]+((-0.838006946582-0.124467745809j))*x[1]
        ref[2, 0, 0, 0]=(-0.921090616447+0.324650070047j)
        ref[2, 0, 0, 1]=(-0.838006946582-0.124467745809j)
        arg[2, 0, 1]=(-0.303047300297+0.264652618982j)*x[0]+((0.445957981098+0.874977405267j))*x[1]
        ref[2, 0, 1, 0]=(-0.303047300297+0.264652618982j)
        ref[2, 0, 1, 1]=(0.445957981098+0.874977405267j)
        arg[2, 0, 2]=(-0.743163529313+0.368887628308j)*x[0]+((-0.968866872504-0.281992359065j))*x[1]
        ref[2, 0, 2, 0]=(-0.743163529313+0.368887628308j)
        ref[2, 0, 2, 1]=(-0.968866872504-0.281992359065j)
        arg[2, 0, 3]=(-0.565665185976+0.220756935391j)*x[0]+((-0.952630735303+0.259679802716j))*x[1]
        ref[2, 0, 3, 0]=(-0.565665185976+0.220756935391j)
        ref[2, 0, 3, 1]=(-0.952630735303+0.259679802716j)
        arg[2, 1, 0]=(-0.794856870253+0.481331847058j)*x[0]+((0.143395732532-0.908850460685j))*x[1]
        ref[2, 1, 0, 0]=(-0.794856870253+0.481331847058j)
        ref[2, 1, 0, 1]=(0.143395732532-0.908850460685j)
        arg[2, 1, 1]=(-0.851275141963+0.32710787754j)*x[0]+((0.358153976593+0.912255683583j))*x[1]
        ref[2, 1, 1, 0]=(-0.851275141963+0.32710787754j)
        ref[2, 1, 1, 1]=(0.358153976593+0.912255683583j)
        arg[2, 1, 2]=(-0.523159386095+0.59837518663j)*x[0]+((-0.525816461031+0.585718629966j))*x[1]
        ref[2, 1, 2, 0]=(-0.523159386095+0.59837518663j)
        ref[2, 1, 2, 1]=(-0.525816461031+0.585718629966j)
        arg[2, 1, 3]=(0.365007555923+0.0418189578196j)*x[0]+((-0.688119230356-0.441968552904j))*x[1]
        ref[2, 1, 3, 0]=(0.365007555923+0.0418189578196j)
        ref[2, 1, 3, 1]=(-0.688119230356-0.441968552904j)
        arg[2, 2, 0]=(0.254679256622-0.985867267827j)*x[0]+((-0.222006088357+0.603217654969j))*x[1]
        ref[2, 2, 0, 0]=(0.254679256622-0.985867267827j)
        ref[2, 2, 0, 1]=(-0.222006088357+0.603217654969j)
        arg[2, 2, 1]=(0.499819660681-0.634617773092j)*x[0]+((0.00771541848036-0.398660479918j))*x[1]
        ref[2, 2, 1, 0]=(0.499819660681-0.634617773092j)
        ref[2, 2, 1, 1]=(0.00771541848036-0.398660479918j)
        arg[2, 2, 2]=(-0.676672492894-0.672931741893j)*x[0]+((-0.0912505852546-0.0490443585719j))*x[1]
        ref[2, 2, 2, 0]=(-0.676672492894-0.672931741893j)
        ref[2, 2, 2, 1]=(-0.0912505852546-0.0490443585719j)
        arg[2, 2, 3]=(-0.0990723865707+0.336372075975j)*x[0]+((0.952480080838+0.679664583337j))*x[1]
        ref[2, 2, 3, 0]=(-0.0990723865707+0.336372075975j)
        ref[2, 2, 3, 1]=(0.952480080838+0.679664583337j)
        if dim==3:
            arg[0, 0, 0]+=(-0.324272072782+0.701582292364j)*x[2]
            ref[0, 0, 0, 2]=(-0.324272072782+0.701582292364j)
            arg[0, 0, 1]+=(0.713909195234+0.132054599874j)*x[2]
            ref[0, 0, 1, 2]=(0.713909195234+0.132054599874j)
            arg[0, 0, 2]+=(0.606512246486+0.061213734855j)*x[2]
            ref[0, 0, 2, 2]=(0.606512246486+0.061213734855j)
            arg[0, 0, 3]+=(0.269079048331-0.855252045108j)*x[2]
            ref[0, 0, 3, 2]=(0.269079048331-0.855252045108j)
            arg[0, 1, 0]+=(-0.969327553275-0.362541329692j)*x[2]
            ref[0, 1, 0, 2]=(-0.969327553275-0.362541329692j)
            arg[0, 1, 1]+=(0.429240074357+0.575701451806j)*x[2]
            ref[0, 1, 1, 2]=(0.429240074357+0.575701451806j)
            arg[0, 1, 2]+=(0.340240559087+0.985980377012j)*x[2]
            ref[0, 1, 2, 2]=(0.340240559087+0.985980377012j)
            arg[0, 1, 3]+=(-0.510856544555-0.964977685209j)*x[2]
            ref[0, 1, 3, 2]=(-0.510856544555-0.964977685209j)
            arg[0, 2, 0]+=(0.0225233624534+0.788938763766j)*x[2]
            ref[0, 2, 0, 2]=(0.0225233624534+0.788938763766j)
            arg[0, 2, 1]+=(0.6212588898-0.575840520872j)*x[2]
            ref[0, 2, 1, 2]=(0.6212588898-0.575840520872j)
            arg[0, 2, 2]+=(0.392495902389-0.976772686158j)*x[2]
            ref[0, 2, 2, 2]=(0.392495902389-0.976772686158j)
            arg[0, 2, 3]+=(0.461437801954-0.487093043457j)*x[2]
            ref[0, 2, 3, 2]=(0.461437801954-0.487093043457j)
            arg[1, 0, 0]+=(0.442376678895-0.833852968704j)*x[2]
            ref[1, 0, 0, 2]=(0.442376678895-0.833852968704j)
            arg[1, 0, 1]+=(-0.201509626327-0.427448758643j)*x[2]
            ref[1, 0, 1, 2]=(-0.201509626327-0.427448758643j)
            arg[1, 0, 2]+=(-0.208774968753-0.794206624036j)*x[2]
            ref[1, 0, 2, 2]=(-0.208774968753-0.794206624036j)
            arg[1, 0, 3]+=(0.949078579382-0.133954413166j)*x[2]
            ref[1, 0, 3, 2]=(0.949078579382-0.133954413166j)
            arg[1, 1, 0]+=(-0.942230385934-0.90446873363j)*x[2]
            ref[1, 1, 0, 2]=(-0.942230385934-0.90446873363j)
            arg[1, 1, 1]+=(0.00787628869236-0.461613400823j)*x[2]
            ref[1, 1, 1, 2]=(0.00787628869236-0.461613400823j)
            arg[1, 1, 2]+=(0.694184632232+0.447549796561j)*x[2]
            ref[1, 1, 2, 2]=(0.694184632232+0.447549796561j)
            arg[1, 1, 3]+=(0.818492698228-0.33209031663j)*x[2]
            ref[1, 1, 3, 2]=(0.818492698228-0.33209031663j)
            arg[1, 2, 0]+=(0.137431964296-0.44092737001j)*x[2]
            ref[1, 2, 0, 2]=(0.137431964296-0.44092737001j)
            arg[1, 2, 1]+=(0.621342573702+0.0873249243444j)*x[2]
            ref[1, 2, 1, 2]=(0.621342573702+0.0873249243444j)
            arg[1, 2, 2]+=(-0.259960976404+0.800985694074j)*x[2]
            ref[1, 2, 2, 2]=(-0.259960976404+0.800985694074j)
            arg[1, 2, 3]+=(0.402442921063-0.223933023935j)*x[2]
            ref[1, 2, 3, 2]=(0.402442921063-0.223933023935j)
            arg[2, 0, 0]+=(-0.741271054735-0.0116505480621j)*x[2]
            ref[2, 0, 0, 2]=(-0.741271054735-0.0116505480621j)
            arg[2, 0, 1]+=(-0.692409563395-0.443112227766j)*x[2]
            ref[2, 0, 1, 2]=(-0.692409563395-0.443112227766j)
            arg[2, 0, 2]+=(-0.467610766979+0.17320797956j)*x[2]
            ref[2, 0, 2, 2]=(-0.467610766979+0.17320797956j)
            arg[2, 0, 3]+=(-0.266027300625-0.508760858026j)*x[2]
            ref[2, 0, 3, 2]=(-0.266027300625-0.508760858026j)
            arg[2, 1, 0]+=(-0.537363292917-0.740893191598j)*x[2]
            ref[2, 1, 0, 2]=(-0.537363292917-0.740893191598j)
            arg[2, 1, 1]+=(0.983685366192+0.185576244243j)*x[2]
            ref[2, 1, 1, 2]=(0.983685366192+0.185576244243j)
            arg[2, 1, 2]+=(-0.714525480247+0.532962770674j)*x[2]
            ref[2, 1, 2, 2]=(-0.714525480247+0.532962770674j)
            arg[2, 1, 3]+=(0.530519426331+0.548643417076j)*x[2]
            ref[2, 1, 3, 2]=(0.530519426331+0.548643417076j)
            arg[2, 2, 0]+=(0.360274785034+0.785715382532j)*x[2]
            ref[2, 2, 0, 2]=(0.360274785034+0.785715382532j)
            arg[2, 2, 1]+=(0.310989397952-0.698444682671j)*x[2]
            ref[2, 2, 1, 2]=(0.310989397952-0.698444682671j)
            arg[2, 2, 2]+=(-0.549247109742-0.38976365586j)*x[2]
            ref[2, 2, 2, 2]=(-0.549247109742-0.38976365586j)
            arg[2, 2, 3]+=(-0.975575292475-0.664748863166j)*x[2]
            ref[2, 2, 3, 2]=(-0.975575292475-0.664748863166j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3, 3, 4)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onFunction_fromData_ContinuousFunction_rank0(self):
        """
        tests gradient of rank 0 Data on Function

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=-0.774476228794*x[0]**o+(-0.335208260553)*x[0]+(-0.422051185595)*x[1]**o+(0.222234501459)*x[1]
        ref[0]=-0.774476228794*o*x_ref[0]**(o-1)+(-0.335208260553)
        ref[1]=-0.422051185595*o*x_ref[1]**(o-1)+(0.222234501459)
        if dim==3:
            arg+=(-0.394394282218)*x[2]**o+(-0.524604355279)*x[2]
            ref[2]=-0.394394282218*o*x_ref[2]**(o-1)+(-0.524604355279)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onFunction_fromData_ContinuousFunction_rank1(self):
        """
        tests gradient of rank 1 Data on Function

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(2,),w)
        ref = Data(0,(2,)+(dim,),w_ref)
        arg[0,]=-0.178009729537*x[0]**o+(0.482980366706)*x[0]+(0.275740650798)*x[1]**o+(-0.832078573704)*x[1]
        ref[0, 0]=-0.178009729537*o*x_ref[0]**(o-1)+(0.482980366706)
        ref[0, 1]=0.275740650798*o*x_ref[1]**(o-1)+(-0.832078573704)
        arg[1,]=0.959519041717*x[0]**o+(-0.148431528967)*x[0]+(-0.739421813025)*x[1]**o+(-0.636515249598)*x[1]
        ref[1, 0]=0.959519041717*o*x_ref[0]**(o-1)+(-0.148431528967)
        ref[1, 1]=-0.739421813025*o*x_ref[1]**(o-1)+(-0.636515249598)
        if dim==3:
            arg[0,]+=-0.264848115022*x[2]**o+(-0.859606832101)*x[2]
            ref[0, 2]=-0.264848115022*o*x_ref[2]**(o-1)+(-0.859606832101)
            arg[1,]+=0.373225152189*x[2]**o+(0.792629380381)*x[2]
            ref[1, 2]=0.373225152189*o*x_ref[2]**(o-1)+(0.792629380381)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onFunction_fromData_ContinuousFunction_rank2(self):
        """
        tests gradient of rank 2 Data on Function

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(3, 2),w)
        ref = Data(0,(3, 2)+(dim,),w_ref)
        arg[0, 0]=-0.289370595843*x[0]**o+(0.81460644718)*x[0]+(0.954820590936)*x[1]**o+(0.152030533729)*x[1]
        ref[0, 0, 0]=-0.289370595843*o*x_ref[0]**(o-1)+(0.81460644718)
        ref[0, 0, 1]=0.954820590936*o*x_ref[1]**(o-1)+(0.152030533729)
        arg[0, 1]=0.481008568709*x[0]**o+(-0.338154048371)*x[0]+(0.582413024393)*x[1]**o+(0.929338364217)*x[1]
        ref[0, 1, 0]=0.481008568709*o*x_ref[0]**(o-1)+(-0.338154048371)
        ref[0, 1, 1]=0.582413024393*o*x_ref[1]**(o-1)+(0.929338364217)
        arg[1, 0]=0.332452465962*x[0]**o+(0.18244657585)*x[0]+(-0.986875807598)*x[1]**o+(0.17271571457)*x[1]
        ref[1, 0, 0]=0.332452465962*o*x_ref[0]**(o-1)+(0.18244657585)
        ref[1, 0, 1]=-0.986875807598*o*x_ref[1]**(o-1)+(0.17271571457)
        arg[1, 1]=0.392252090679*x[0]**o+(0.701501870225)*x[0]+(0.569514662318)*x[1]**o+(0.751078132921)*x[1]
        ref[1, 1, 0]=0.392252090679*o*x_ref[0]**(o-1)+(0.701501870225)
        ref[1, 1, 1]=0.569514662318*o*x_ref[1]**(o-1)+(0.751078132921)
        arg[2, 0]=0.684681293569*x[0]**o+(-0.907752274036)*x[0]+(-0.971332995432)*x[1]**o+(-0.383198421579)*x[1]
        ref[2, 0, 0]=0.684681293569*o*x_ref[0]**(o-1)+(-0.907752274036)
        ref[2, 0, 1]=-0.971332995432*o*x_ref[1]**(o-1)+(-0.383198421579)
        arg[2, 1]=-0.786431856728*x[0]**o+(-0.255543454726)*x[0]+(-0.218326663436)*x[1]**o+(0.599074370907)*x[1]
        ref[2, 1, 0]=-0.786431856728*o*x_ref[0]**(o-1)+(-0.255543454726)
        ref[2, 1, 1]=-0.218326663436*o*x_ref[1]**(o-1)+(0.599074370907)
        if dim==3:
            arg[0, 0]+=0.330913147588*x[2]**o+(-0.893122997744)*x[2]
            ref[0, 0, 2]=0.330913147588*o*x_ref[2]**(o-1)+(-0.893122997744)
            arg[0, 1]+=-0.576416432924*x[2]**o+(-0.416818467199)*x[2]
            ref[0, 1, 2]=-0.576416432924*o*x_ref[2]**(o-1)+(-0.416818467199)
            arg[1, 0]+=0.106134883103*x[2]**o+(-0.534915677603)*x[2]
            ref[1, 0, 2]=0.106134883103*o*x_ref[2]**(o-1)+(-0.534915677603)
            arg[1, 1]+=-0.543809259282*x[2]**o+(0.38023818215)*x[2]
            ref[1, 1, 2]=-0.543809259282*o*x_ref[2]**(o-1)+(0.38023818215)
            arg[2, 0]+=-0.818715649307*x[2]**o+(0.995715372285)*x[2]
            ref[2, 0, 2]=-0.818715649307*o*x_ref[2]**(o-1)+(0.995715372285)
            arg[2, 1]+=-0.106099438151*x[2]**o+(-0.413583233333)*x[2]
            ref[2, 1, 2]=-0.106099438151*o*x_ref[2]**(o-1)+(-0.413583233333)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3, 2)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onFunction_fromData_ContinuousFunction_rank3(self):
        """
        tests gradient of rank 3 Data on Function

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(4, 4, 2),w)
        ref = Data(0,(4, 4, 2)+(dim,),w_ref)
        arg[0, 0, 0]=-0.560059271134*x[0]**o+(0.467330614018)*x[0]+(0.500286819312)*x[1]**o+(0.879822761487)*x[1]
        ref[0, 0, 0, 0]=-0.560059271134*o*x_ref[0]**(o-1)+(0.467330614018)
        ref[0, 0, 0, 1]=0.500286819312*o*x_ref[1]**(o-1)+(0.879822761487)
        arg[0, 0, 1]=-0.587744166251*x[0]**o+(-0.360722417953)*x[0]+(-0.789003689052)*x[1]**o+(0.915174026678)*x[1]
        ref[0, 0, 1, 0]=-0.587744166251*o*x_ref[0]**(o-1)+(-0.360722417953)
        ref[0, 0, 1, 1]=-0.789003689052*o*x_ref[1]**(o-1)+(0.915174026678)
        arg[0, 1, 0]=-0.208033143398*x[0]**o+(0.490574720567)*x[0]+(-0.852621459697)*x[1]**o+(0.198461737568)*x[1]
        ref[0, 1, 0, 0]=-0.208033143398*o*x_ref[0]**(o-1)+(0.490574720567)
        ref[0, 1, 0, 1]=-0.852621459697*o*x_ref[1]**(o-1)+(0.198461737568)
        arg[0, 1, 1]=-0.190589798406*x[0]**o+(0.461832949691)*x[0]+(-0.0166489134899)*x[1]**o+(-0.515947638446)*x[1]
        ref[0, 1, 1, 0]=-0.190589798406*o*x_ref[0]**(o-1)+(0.461832949691)
        ref[0, 1, 1, 1]=-0.0166489134899*o*x_ref[1]**(o-1)+(-0.515947638446)
        arg[0, 2, 0]=-0.754775172753*x[0]**o+(0.263770308638)*x[0]+(0.479146646467)*x[1]**o+(0.943631062779)*x[1]
        ref[0, 2, 0, 0]=-0.754775172753*o*x_ref[0]**(o-1)+(0.263770308638)
        ref[0, 2, 0, 1]=0.479146646467*o*x_ref[1]**(o-1)+(0.943631062779)
        arg[0, 2, 1]=-0.769727078522*x[0]**o+(-0.457169629697)*x[0]+(-0.363190101952)*x[1]**o+(-0.829982374066)*x[1]
        ref[0, 2, 1, 0]=-0.769727078522*o*x_ref[0]**(o-1)+(-0.457169629697)
        ref[0, 2, 1, 1]=-0.363190101952*o*x_ref[1]**(o-1)+(-0.829982374066)
        arg[0, 3, 0]=-0.111983175293*x[0]**o+(-0.836292142909)*x[0]+(0.574044836659)*x[1]**o+(0.0990920931255)*x[1]
        ref[0, 3, 0, 0]=-0.111983175293*o*x_ref[0]**(o-1)+(-0.836292142909)
        ref[0, 3, 0, 1]=0.574044836659*o*x_ref[1]**(o-1)+(0.0990920931255)
        arg[0, 3, 1]=-0.704744719527*x[0]**o+(-0.480030447763)*x[0]+(-0.23773017583)*x[1]**o+(0.703581654481)*x[1]
        ref[0, 3, 1, 0]=-0.704744719527*o*x_ref[0]**(o-1)+(-0.480030447763)
        ref[0, 3, 1, 1]=-0.23773017583*o*x_ref[1]**(o-1)+(0.703581654481)
        arg[1, 0, 0]=-0.819028727425*x[0]**o+(-0.688125197606)*x[0]+(0.816332741094)*x[1]**o+(-0.33400450236)*x[1]
        ref[1, 0, 0, 0]=-0.819028727425*o*x_ref[0]**(o-1)+(-0.688125197606)
        ref[1, 0, 0, 1]=0.816332741094*o*x_ref[1]**(o-1)+(-0.33400450236)
        arg[1, 0, 1]=0.293096940498*x[0]**o+(-0.105404689691)*x[0]+(0.808926761855)*x[1]**o+(-0.314227421885)*x[1]
        ref[1, 0, 1, 0]=0.293096940498*o*x_ref[0]**(o-1)+(-0.105404689691)
        ref[1, 0, 1, 1]=0.808926761855*o*x_ref[1]**(o-1)+(-0.314227421885)
        arg[1, 1, 0]=-0.0332552004508*x[0]**o+(0.0572917579595)*x[0]+(0.419904667536)*x[1]**o+(0.764145311614)*x[1]
        ref[1, 1, 0, 0]=-0.0332552004508*o*x_ref[0]**(o-1)+(0.0572917579595)
        ref[1, 1, 0, 1]=0.419904667536*o*x_ref[1]**(o-1)+(0.764145311614)
        arg[1, 1, 1]=0.611276649696*x[0]**o+(-0.879272473841)*x[0]+(-0.436809968546)*x[1]**o+(-0.612012642965)*x[1]
        ref[1, 1, 1, 0]=0.611276649696*o*x_ref[0]**(o-1)+(-0.879272473841)
        ref[1, 1, 1, 1]=-0.436809968546*o*x_ref[1]**(o-1)+(-0.612012642965)
        arg[1, 2, 0]=-0.353099487437*x[0]**o+(0.125210444616)*x[0]+(-0.573867534033)*x[1]**o+(-0.310703566101)*x[1]
        ref[1, 2, 0, 0]=-0.353099487437*o*x_ref[0]**(o-1)+(0.125210444616)
        ref[1, 2, 0, 1]=-0.573867534033*o*x_ref[1]**(o-1)+(-0.310703566101)
        arg[1, 2, 1]=0.814400846116*x[0]**o+(0.748303540115)*x[0]+(0.411492847381)*x[1]**o+(-0.0285735368845)*x[1]
        ref[1, 2, 1, 0]=0.814400846116*o*x_ref[0]**(o-1)+(0.748303540115)
        ref[1, 2, 1, 1]=0.411492847381*o*x_ref[1]**(o-1)+(-0.0285735368845)
        arg[1, 3, 0]=0.834777078093*x[0]**o+(-0.51401245016)*x[0]+(0.771992988564)*x[1]**o+(0.492859805246)*x[1]
        ref[1, 3, 0, 0]=0.834777078093*o*x_ref[0]**(o-1)+(-0.51401245016)
        ref[1, 3, 0, 1]=0.771992988564*o*x_ref[1]**(o-1)+(0.492859805246)
        arg[1, 3, 1]=0.509859930717*x[0]**o+(-0.495422013232)*x[0]+(0.351512804696)*x[1]**o+(-0.103690228103)*x[1]
        ref[1, 3, 1, 0]=0.509859930717*o*x_ref[0]**(o-1)+(-0.495422013232)
        ref[1, 3, 1, 1]=0.351512804696*o*x_ref[1]**(o-1)+(-0.103690228103)
        arg[2, 0, 0]=-0.124678310195*x[0]**o+(-0.80631191296)*x[0]+(-0.693019389705)*x[1]**o+(-0.0049969418003)*x[1]
        ref[2, 0, 0, 0]=-0.124678310195*o*x_ref[0]**(o-1)+(-0.80631191296)
        ref[2, 0, 0, 1]=-0.693019389705*o*x_ref[1]**(o-1)+(-0.0049969418003)
        arg[2, 0, 1]=0.354961225564*x[0]**o+(0.812420878576)*x[0]+(0.719725844579)*x[1]**o+(0.511817360278)*x[1]
        ref[2, 0, 1, 0]=0.354961225564*o*x_ref[0]**(o-1)+(0.812420878576)
        ref[2, 0, 1, 1]=0.719725844579*o*x_ref[1]**(o-1)+(0.511817360278)
        arg[2, 1, 0]=0.0089408273924*x[0]**o+(-0.398439872347)*x[0]+(-0.751942865955)*x[1]**o+(-0.308729062684)*x[1]
        ref[2, 1, 0, 0]=0.0089408273924*o*x_ref[0]**(o-1)+(-0.398439872347)
        ref[2, 1, 0, 1]=-0.751942865955*o*x_ref[1]**(o-1)+(-0.308729062684)
        arg[2, 1, 1]=0.335094624851*x[0]**o+(-0.646506309902)*x[0]+(0.699657532338)*x[1]**o+(0.102120252889)*x[1]
        ref[2, 1, 1, 0]=0.335094624851*o*x_ref[0]**(o-1)+(-0.646506309902)
        ref[2, 1, 1, 1]=0.699657532338*o*x_ref[1]**(o-1)+(0.102120252889)
        arg[2, 2, 0]=-0.171926443345*x[0]**o+(-0.253110776045)*x[0]+(0.607769382776)*x[1]**o+(-0.108506583463)*x[1]
        ref[2, 2, 0, 0]=-0.171926443345*o*x_ref[0]**(o-1)+(-0.253110776045)
        ref[2, 2, 0, 1]=0.607769382776*o*x_ref[1]**(o-1)+(-0.108506583463)
        arg[2, 2, 1]=-0.866147075866*x[0]**o+(-0.961057476614)*x[0]+(-0.991743445632)*x[1]**o+(0.482009025463)*x[1]
        ref[2, 2, 1, 0]=-0.866147075866*o*x_ref[0]**(o-1)+(-0.961057476614)
        ref[2, 2, 1, 1]=-0.991743445632*o*x_ref[1]**(o-1)+(0.482009025463)
        arg[2, 3, 0]=0.493987126599*x[0]**o+(-0.368594082243)*x[0]+(-0.779832635841)*x[1]**o+(-0.413020359005)*x[1]
        ref[2, 3, 0, 0]=0.493987126599*o*x_ref[0]**(o-1)+(-0.368594082243)
        ref[2, 3, 0, 1]=-0.779832635841*o*x_ref[1]**(o-1)+(-0.413020359005)
        arg[2, 3, 1]=0.205584678173*x[0]**o+(0.0675892272466)*x[0]+(-0.711618971148)*x[1]**o+(0.369349682308)*x[1]
        ref[2, 3, 1, 0]=0.205584678173*o*x_ref[0]**(o-1)+(0.0675892272466)
        ref[2, 3, 1, 1]=-0.711618971148*o*x_ref[1]**(o-1)+(0.369349682308)
        arg[3, 0, 0]=-0.87900179321*x[0]**o+(0.446017574306)*x[0]+(-0.598313678822)*x[1]**o+(-0.797856102598)*x[1]
        ref[3, 0, 0, 0]=-0.87900179321*o*x_ref[0]**(o-1)+(0.446017574306)
        ref[3, 0, 0, 1]=-0.598313678822*o*x_ref[1]**(o-1)+(-0.797856102598)
        arg[3, 0, 1]=0.997227101462*x[0]**o+(0.381502617042)*x[0]+(0.629674142356)*x[1]**o+(-0.00993720052916)*x[1]
        ref[3, 0, 1, 0]=0.997227101462*o*x_ref[0]**(o-1)+(0.381502617042)
        ref[3, 0, 1, 1]=0.629674142356*o*x_ref[1]**(o-1)+(-0.00993720052916)
        arg[3, 1, 0]=0.0957865931193*x[0]**o+(0.585486533033)*x[0]+(0.180280230344)*x[1]**o+(-0.249664018942)*x[1]
        ref[3, 1, 0, 0]=0.0957865931193*o*x_ref[0]**(o-1)+(0.585486533033)
        ref[3, 1, 0, 1]=0.180280230344*o*x_ref[1]**(o-1)+(-0.249664018942)
        arg[3, 1, 1]=0.739475402105*x[0]**o+(-0.203646175828)*x[0]+(0.128839845644)*x[1]**o+(0.555486588979)*x[1]
        ref[3, 1, 1, 0]=0.739475402105*o*x_ref[0]**(o-1)+(-0.203646175828)
        ref[3, 1, 1, 1]=0.128839845644*o*x_ref[1]**(o-1)+(0.555486588979)
        arg[3, 2, 0]=-0.718917249684*x[0]**o+(0.589966781662)*x[0]+(0.877230184976)*x[1]**o+(-0.11707907659)*x[1]
        ref[3, 2, 0, 0]=-0.718917249684*o*x_ref[0]**(o-1)+(0.589966781662)
        ref[3, 2, 0, 1]=0.877230184976*o*x_ref[1]**(o-1)+(-0.11707907659)
        arg[3, 2, 1]=-0.535015463143*x[0]**o+(0.179503372656)*x[0]+(-0.0953679958815)*x[1]**o+(0.294110512546)*x[1]
        ref[3, 2, 1, 0]=-0.535015463143*o*x_ref[0]**(o-1)+(0.179503372656)
        ref[3, 2, 1, 1]=-0.0953679958815*o*x_ref[1]**(o-1)+(0.294110512546)
        arg[3, 3, 0]=-0.650416970146*x[0]**o+(-0.337758796699)*x[0]+(0.0337320883746)*x[1]**o+(-0.536778875653)*x[1]
        ref[3, 3, 0, 0]=-0.650416970146*o*x_ref[0]**(o-1)+(-0.337758796699)
        ref[3, 3, 0, 1]=0.0337320883746*o*x_ref[1]**(o-1)+(-0.536778875653)
        arg[3, 3, 1]=-0.0104326760324*x[0]**o+(0.936922830375)*x[0]+(-0.945917355892)*x[1]**o+(-0.809762493804)*x[1]
        ref[3, 3, 1, 0]=-0.0104326760324*o*x_ref[0]**(o-1)+(0.936922830375)
        ref[3, 3, 1, 1]=-0.945917355892*o*x_ref[1]**(o-1)+(-0.809762493804)
        if dim==3:
            arg[0, 0, 0]+=0.26027072994*x[2]**o+(0.438949053279)*x[2]
            ref[0, 0, 0, 2]=0.26027072994*o*x_ref[2]**(o-1)+(0.438949053279)
            arg[0, 0, 1]+=-0.402417614846*x[2]**o+(0.938356997894)*x[2]
            ref[0, 0, 1, 2]=-0.402417614846*o*x_ref[2]**(o-1)+(0.938356997894)
            arg[0, 1, 0]+=-0.458200239068*x[2]**o+(0.410102740608)*x[2]
            ref[0, 1, 0, 2]=-0.458200239068*o*x_ref[2]**(o-1)+(0.410102740608)
            arg[0, 1, 1]+=0.516084662087*x[2]**o+(0.802447381815)*x[2]
            ref[0, 1, 1, 2]=0.516084662087*o*x_ref[2]**(o-1)+(0.802447381815)
            arg[0, 2, 0]+=-0.616131347455*x[2]**o+(-0.580348367297)*x[2]
            ref[0, 2, 0, 2]=-0.616131347455*o*x_ref[2]**(o-1)+(-0.580348367297)
            arg[0, 2, 1]+=-0.877377947317*x[2]**o+(-0.219704006371)*x[2]
            ref[0, 2, 1, 2]=-0.877377947317*o*x_ref[2]**(o-1)+(-0.219704006371)
            arg[0, 3, 0]+=-0.256093843604*x[2]**o+(-0.310404388672)*x[2]
            ref[0, 3, 0, 2]=-0.256093843604*o*x_ref[2]**(o-1)+(-0.310404388672)
            arg[0, 3, 1]+=-0.478113594287*x[2]**o+(-0.907401607145)*x[2]
            ref[0, 3, 1, 2]=-0.478113594287*o*x_ref[2]**(o-1)+(-0.907401607145)
            arg[1, 0, 0]+=-0.680490152814*x[2]**o+(0.424925315576)*x[2]
            ref[1, 0, 0, 2]=-0.680490152814*o*x_ref[2]**(o-1)+(0.424925315576)
            arg[1, 0, 1]+=0.11021633108*x[2]**o+(-0.744065013118)*x[2]
            ref[1, 0, 1, 2]=0.11021633108*o*x_ref[2]**(o-1)+(-0.744065013118)
            arg[1, 1, 0]+=0.435355894999*x[2]**o+(0.0104037183736)*x[2]
            ref[1, 1, 0, 2]=0.435355894999*o*x_ref[2]**(o-1)+(0.0104037183736)
            arg[1, 1, 1]+=-0.653998144962*x[2]**o+(-0.831658649559)*x[2]
            ref[1, 1, 1, 2]=-0.653998144962*o*x_ref[2]**(o-1)+(-0.831658649559)
            arg[1, 2, 0]+=-0.736061461272*x[2]**o+(-0.5152156695)*x[2]
            ref[1, 2, 0, 2]=-0.736061461272*o*x_ref[2]**(o-1)+(-0.5152156695)
            arg[1, 2, 1]+=0.0708328135449*x[2]**o+(-0.0296100628202)*x[2]
            ref[1, 2, 1, 2]=0.0708328135449*o*x_ref[2]**(o-1)+(-0.0296100628202)
            arg[1, 3, 0]+=0.149941548102*x[2]**o+(0.98810766842)*x[2]
            ref[1, 3, 0, 2]=0.149941548102*o*x_ref[2]**(o-1)+(0.98810766842)
            arg[1, 3, 1]+=0.970289135501*x[2]**o+(-0.0757872190773)*x[2]
            ref[1, 3, 1, 2]=0.970289135501*o*x_ref[2]**(o-1)+(-0.0757872190773)
            arg[2, 0, 0]+=0.684626130251*x[2]**o+(-0.77134106879)*x[2]
            ref[2, 0, 0, 2]=0.684626130251*o*x_ref[2]**(o-1)+(-0.77134106879)
            arg[2, 0, 1]+=-0.499582849902*x[2]**o+(-0.223376358713)*x[2]
            ref[2, 0, 1, 2]=-0.499582849902*o*x_ref[2]**(o-1)+(-0.223376358713)
            arg[2, 1, 0]+=-0.422623930429*x[2]**o+(0.726923080473)*x[2]
            ref[2, 1, 0, 2]=-0.422623930429*o*x_ref[2]**(o-1)+(0.726923080473)
            arg[2, 1, 1]+=-0.4850266656*x[2]**o+(-0.42766216707)*x[2]
            ref[2, 1, 1, 2]=-0.4850266656*o*x_ref[2]**(o-1)+(-0.42766216707)
            arg[2, 2, 0]+=0.255402543515*x[2]**o+(-0.88832307078)*x[2]
            ref[2, 2, 0, 2]=0.255402543515*o*x_ref[2]**(o-1)+(-0.88832307078)
            arg[2, 2, 1]+=0.255382966902*x[2]**o+(0.121550865217)*x[2]
            ref[2, 2, 1, 2]=0.255382966902*o*x_ref[2]**(o-1)+(0.121550865217)
            arg[2, 3, 0]+=-0.667817721605*x[2]**o+(0.261441731609)*x[2]
            ref[2, 3, 0, 2]=-0.667817721605*o*x_ref[2]**(o-1)+(0.261441731609)
            arg[2, 3, 1]+=0.0880711595685*x[2]**o+(0.110882359161)*x[2]
            ref[2, 3, 1, 2]=0.0880711595685*o*x_ref[2]**(o-1)+(0.110882359161)
            arg[3, 0, 0]+=-0.908423788171*x[2]**o+(0.184468633466)*x[2]
            ref[3, 0, 0, 2]=-0.908423788171*o*x_ref[2]**(o-1)+(0.184468633466)
            arg[3, 0, 1]+=-0.91624454956*x[2]**o+(-0.132574190416)*x[2]
            ref[3, 0, 1, 2]=-0.91624454956*o*x_ref[2]**(o-1)+(-0.132574190416)
            arg[3, 1, 0]+=-0.875711878542*x[2]**o+(0.261579513602)*x[2]
            ref[3, 1, 0, 2]=-0.875711878542*o*x_ref[2]**(o-1)+(0.261579513602)
            arg[3, 1, 1]+=-0.96847823677*x[2]**o+(0.34701835653)*x[2]
            ref[3, 1, 1, 2]=-0.96847823677*o*x_ref[2]**(o-1)+(0.34701835653)
            arg[3, 2, 0]+=0.573773825826*x[2]**o+(-0.105568586878)*x[2]
            ref[3, 2, 0, 2]=0.573773825826*o*x_ref[2]**(o-1)+(-0.105568586878)
            arg[3, 2, 1]+=0.913501958506*x[2]**o+(0.0795196523555)*x[2]
            ref[3, 2, 1, 2]=0.913501958506*o*x_ref[2]**(o-1)+(0.0795196523555)
            arg[3, 3, 0]+=-0.346875786666*x[2]**o+(0.43422981074)*x[2]
            ref[3, 3, 0, 2]=-0.346875786666*o*x_ref[2]**(o-1)+(0.43422981074)
            arg[3, 3, 1]+=0.864861278036*x[2]**o+(-0.822461059376)*x[2]
            ref[3, 3, 1, 2]=0.864861278036*o*x_ref[2]**(o-1)+(-0.822461059376)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4, 4, 2)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onFunction_fromData_Solution_rank0(self):
        """
        tests gradient of rank 0 Data on Function

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=0.439884476763*x[0]**o+(0.990190131361)*x[0]+(0.0539437719919)*x[1]**o+(0.611188258043)*x[1]
        ref[0]=0.439884476763*o*x_ref[0]**(o-1)+(0.990190131361)
        ref[1]=0.0539437719919*o*x_ref[1]**(o-1)+(0.611188258043)
        if dim==3:
            arg+=(-0.617109409745)*x[2]**o+(0.1528803613)*x[2]
            ref[2]=-0.617109409745*o*x_ref[2]**(o-1)+(0.1528803613)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onFunction_fromData_Solution_rank1(self):
        """
        tests gradient of rank 1 Data on Function

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(2,),w)
        ref = Data(0,(2,)+(dim,),w_ref)
        arg[0,]=-0.167649380653*x[0]**o+(-0.489900975603)*x[0]+(-0.682244457611)*x[1]**o+(-0.47198375801)*x[1]
        ref[0, 0]=-0.167649380653*o*x_ref[0]**(o-1)+(-0.489900975603)
        ref[0, 1]=-0.682244457611*o*x_ref[1]**(o-1)+(-0.47198375801)
        arg[1,]=0.970694263663*x[0]**o+(-0.745479797507)*x[0]+(0.774233609942)*x[1]**o+(0.0967852429488)*x[1]
        ref[1, 0]=0.970694263663*o*x_ref[0]**(o-1)+(-0.745479797507)
        ref[1, 1]=0.774233609942*o*x_ref[1]**(o-1)+(0.0967852429488)
        if dim==3:
            arg[0,]+=0.142525266956*x[2]**o+(0.346179299632)*x[2]
            ref[0, 2]=0.142525266956*o*x_ref[2]**(o-1)+(0.346179299632)
            arg[1,]+=0.129405215689*x[2]**o+(-0.630843537766)*x[2]
            ref[1, 2]=0.129405215689*o*x_ref[2]**(o-1)+(-0.630843537766)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onFunction_fromData_Solution_rank2(self):
        """
        tests gradient of rank 2 Data on Function

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(3, 4),w)
        ref = Data(0,(3, 4)+(dim,),w_ref)
        arg[0, 0]=-0.877909015805*x[0]**o+(-0.701241315038)*x[0]+(0.636771243683)*x[1]**o+(0.0498307996992)*x[1]
        ref[0, 0, 0]=-0.877909015805*o*x_ref[0]**(o-1)+(-0.701241315038)
        ref[0, 0, 1]=0.636771243683*o*x_ref[1]**(o-1)+(0.0498307996992)
        arg[0, 1]=-0.375828465529*x[0]**o+(-0.4241501204)*x[0]+(0.385257265081)*x[1]**o+(0.929329910547)*x[1]
        ref[0, 1, 0]=-0.375828465529*o*x_ref[0]**(o-1)+(-0.4241501204)
        ref[0, 1, 1]=0.385257265081*o*x_ref[1]**(o-1)+(0.929329910547)
        arg[0, 2]=0.308106406176*x[0]**o+(0.349379482977)*x[0]+(0.60959538763)*x[1]**o+(-0.0159887763805)*x[1]
        ref[0, 2, 0]=0.308106406176*o*x_ref[0]**(o-1)+(0.349379482977)
        ref[0, 2, 1]=0.60959538763*o*x_ref[1]**(o-1)+(-0.0159887763805)
        arg[0, 3]=-0.984631861097*x[0]**o+(0.95560144925)*x[0]+(0.941615054331)*x[1]**o+(0.93914410792)*x[1]
        ref[0, 3, 0]=-0.984631861097*o*x_ref[0]**(o-1)+(0.95560144925)
        ref[0, 3, 1]=0.941615054331*o*x_ref[1]**(o-1)+(0.93914410792)
        arg[1, 0]=0.362420587404*x[0]**o+(-0.314490312925)*x[0]+(0.472107414497)*x[1]**o+(0.990030947269)*x[1]
        ref[1, 0, 0]=0.362420587404*o*x_ref[0]**(o-1)+(-0.314490312925)
        ref[1, 0, 1]=0.472107414497*o*x_ref[1]**(o-1)+(0.990030947269)
        arg[1, 1]=-0.513476982666*x[0]**o+(-0.929576586763)*x[0]+(0.993908090696)*x[1]**o+(-0.247111208969)*x[1]
        ref[1, 1, 0]=-0.513476982666*o*x_ref[0]**(o-1)+(-0.929576586763)
        ref[1, 1, 1]=0.993908090696*o*x_ref[1]**(o-1)+(-0.247111208969)
        arg[1, 2]=0.94121877766*x[0]**o+(0.861883326619)*x[0]+(0.023099826123)*x[1]**o+(0.242430403313)*x[1]
        ref[1, 2, 0]=0.94121877766*o*x_ref[0]**(o-1)+(0.861883326619)
        ref[1, 2, 1]=0.023099826123*o*x_ref[1]**(o-1)+(0.242430403313)
        arg[1, 3]=-0.538399605983*x[0]**o+(0.122831164124)*x[0]+(0.514011345939)*x[1]**o+(-0.21501548208)*x[1]
        ref[1, 3, 0]=-0.538399605983*o*x_ref[0]**(o-1)+(0.122831164124)
        ref[1, 3, 1]=0.514011345939*o*x_ref[1]**(o-1)+(-0.21501548208)
        arg[2, 0]=-0.894262635206*x[0]**o+(0.859532247868)*x[0]+(-0.504491940894)*x[1]**o+(0.0898204501868)*x[1]
        ref[2, 0, 0]=-0.894262635206*o*x_ref[0]**(o-1)+(0.859532247868)
        ref[2, 0, 1]=-0.504491940894*o*x_ref[1]**(o-1)+(0.0898204501868)
        arg[2, 1]=-0.33797599881*x[0]**o+(0.542783030309)*x[0]+(-0.341250110731)*x[1]**o+(-0.281667685625)*x[1]
        ref[2, 1, 0]=-0.33797599881*o*x_ref[0]**(o-1)+(0.542783030309)
        ref[2, 1, 1]=-0.341250110731*o*x_ref[1]**(o-1)+(-0.281667685625)
        arg[2, 2]=0.912029440167*x[0]**o+(0.072066178499)*x[0]+(-0.428610785915)*x[1]**o+(-0.624038257148)*x[1]
        ref[2, 2, 0]=0.912029440167*o*x_ref[0]**(o-1)+(0.072066178499)
        ref[2, 2, 1]=-0.428610785915*o*x_ref[1]**(o-1)+(-0.624038257148)
        arg[2, 3]=0.0248401317943*x[0]**o+(-0.621945174919)*x[0]+(0.508194555737)*x[1]**o+(-0.638413987005)*x[1]
        ref[2, 3, 0]=0.0248401317943*o*x_ref[0]**(o-1)+(-0.621945174919)
        ref[2, 3, 1]=0.508194555737*o*x_ref[1]**(o-1)+(-0.638413987005)
        if dim==3:
            arg[0, 0]+=-0.342397894303*x[2]**o+(0.670839515657)*x[2]
            ref[0, 0, 2]=-0.342397894303*o*x_ref[2]**(o-1)+(0.670839515657)
            arg[0, 1]+=0.187284074365*x[2]**o+(0.906838791867)*x[2]
            ref[0, 1, 2]=0.187284074365*o*x_ref[2]**(o-1)+(0.906838791867)
            arg[0, 2]+=0.296960337964*x[2]**o+(-0.931687167041)*x[2]
            ref[0, 2, 2]=0.296960337964*o*x_ref[2]**(o-1)+(-0.931687167041)
            arg[0, 3]+=0.854444088934*x[2]**o+(0.712737209268)*x[2]
            ref[0, 3, 2]=0.854444088934*o*x_ref[2]**(o-1)+(0.712737209268)
            arg[1, 0]+=-0.743094938445*x[2]**o+(0.00935880069884)*x[2]
            ref[1, 0, 2]=-0.743094938445*o*x_ref[2]**(o-1)+(0.00935880069884)
            arg[1, 1]+=-0.813680649986*x[2]**o+(-0.722341542011)*x[2]
            ref[1, 1, 2]=-0.813680649986*o*x_ref[2]**(o-1)+(-0.722341542011)
            arg[1, 2]+=-0.814091165054*x[2]**o+(0.124642733994)*x[2]
            ref[1, 2, 2]=-0.814091165054*o*x_ref[2]**(o-1)+(0.124642733994)
            arg[1, 3]+=-0.604603713925*x[2]**o+(-0.797120174811)*x[2]
            ref[1, 3, 2]=-0.604603713925*o*x_ref[2]**(o-1)+(-0.797120174811)
            arg[2, 0]+=0.1106554727*x[2]**o+(0.333872848172)*x[2]
            ref[2, 0, 2]=0.1106554727*o*x_ref[2]**(o-1)+(0.333872848172)
            arg[2, 1]+=-0.699040188494*x[2]**o+(0.0940641539417)*x[2]
            ref[2, 1, 2]=-0.699040188494*o*x_ref[2]**(o-1)+(0.0940641539417)
            arg[2, 2]+=-0.593056912794*x[2]**o+(0.0676558011581)*x[2]
            ref[2, 2, 2]=-0.593056912794*o*x_ref[2]**(o-1)+(0.0676558011581)
            arg[2, 3]+=-0.623553620932*x[2]**o+(-0.577867791072)*x[2]
            ref[2, 3, 2]=-0.623553620932*o*x_ref[2]**(o-1)+(-0.577867791072)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3, 4)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onFunction_fromData_Solution_rank3(self):
        """
        tests gradient of rank 3 Data on Function

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(4, 4, 2),w)
        ref = Data(0,(4, 4, 2)+(dim,),w_ref)
        arg[0, 0, 0]=-0.963433720038*x[0]**o+(0.690703294085)*x[0]+(-0.528338774054)*x[1]**o+(-0.000929054478231)*x[1]
        ref[0, 0, 0, 0]=-0.963433720038*o*x_ref[0]**(o-1)+(0.690703294085)
        ref[0, 0, 0, 1]=-0.528338774054*o*x_ref[1]**(o-1)+(-0.000929054478231)
        arg[0, 0, 1]=0.290837954081*x[0]**o+(0.510461586029)*x[0]+(0.583038162572)*x[1]**o+(0.269328399234)*x[1]
        ref[0, 0, 1, 0]=0.290837954081*o*x_ref[0]**(o-1)+(0.510461586029)
        ref[0, 0, 1, 1]=0.583038162572*o*x_ref[1]**(o-1)+(0.269328399234)
        arg[0, 1, 0]=-0.862294844801*x[0]**o+(0.185019671546)*x[0]+(0.33538067428)*x[1]**o+(-0.959433117649)*x[1]
        ref[0, 1, 0, 0]=-0.862294844801*o*x_ref[0]**(o-1)+(0.185019671546)
        ref[0, 1, 0, 1]=0.33538067428*o*x_ref[1]**(o-1)+(-0.959433117649)
        arg[0, 1, 1]=0.347516801439*x[0]**o+(0.370751629707)*x[0]+(-0.213982639699)*x[1]**o+(-0.330956135944)*x[1]
        ref[0, 1, 1, 0]=0.347516801439*o*x_ref[0]**(o-1)+(0.370751629707)
        ref[0, 1, 1, 1]=-0.213982639699*o*x_ref[1]**(o-1)+(-0.330956135944)
        arg[0, 2, 0]=0.534784538502*x[0]**o+(0.00529173963882)*x[0]+(0.215524829602)*x[1]**o+(0.347659803907)*x[1]
        ref[0, 2, 0, 0]=0.534784538502*o*x_ref[0]**(o-1)+(0.00529173963882)
        ref[0, 2, 0, 1]=0.215524829602*o*x_ref[1]**(o-1)+(0.347659803907)
        arg[0, 2, 1]=0.732684374677*x[0]**o+(0.290907026947)*x[0]+(-0.912873112158)*x[1]**o+(0.0737792695313)*x[1]
        ref[0, 2, 1, 0]=0.732684374677*o*x_ref[0]**(o-1)+(0.290907026947)
        ref[0, 2, 1, 1]=-0.912873112158*o*x_ref[1]**(o-1)+(0.0737792695313)
        arg[0, 3, 0]=-0.345625773448*x[0]**o+(0.51118339689)*x[0]+(0.176231322122)*x[1]**o+(0.617313026203)*x[1]
        ref[0, 3, 0, 0]=-0.345625773448*o*x_ref[0]**(o-1)+(0.51118339689)
        ref[0, 3, 0, 1]=0.176231322122*o*x_ref[1]**(o-1)+(0.617313026203)
        arg[0, 3, 1]=-0.534673783976*x[0]**o+(-0.63346612824)*x[0]+(0.291460623751)*x[1]**o+(-0.700186963967)*x[1]
        ref[0, 3, 1, 0]=-0.534673783976*o*x_ref[0]**(o-1)+(-0.63346612824)
        ref[0, 3, 1, 1]=0.291460623751*o*x_ref[1]**(o-1)+(-0.700186963967)
        arg[1, 0, 0]=0.700419553322*x[0]**o+(0.52465111145)*x[0]+(0.818846885832)*x[1]**o+(0.671152138595)*x[1]
        ref[1, 0, 0, 0]=0.700419553322*o*x_ref[0]**(o-1)+(0.52465111145)
        ref[1, 0, 0, 1]=0.818846885832*o*x_ref[1]**(o-1)+(0.671152138595)
        arg[1, 0, 1]=-0.196465779422*x[0]**o+(-0.279205960084)*x[0]+(0.116908353082)*x[1]**o+(0.530042515906)*x[1]
        ref[1, 0, 1, 0]=-0.196465779422*o*x_ref[0]**(o-1)+(-0.279205960084)
        ref[1, 0, 1, 1]=0.116908353082*o*x_ref[1]**(o-1)+(0.530042515906)
        arg[1, 1, 0]=0.0589254897125*x[0]**o+(-0.601860854033)*x[0]+(0.726687832296)*x[1]**o+(0.464257902159)*x[1]
        ref[1, 1, 0, 0]=0.0589254897125*o*x_ref[0]**(o-1)+(-0.601860854033)
        ref[1, 1, 0, 1]=0.726687832296*o*x_ref[1]**(o-1)+(0.464257902159)
        arg[1, 1, 1]=0.367224744517*x[0]**o+(-0.875588247176)*x[0]+(0.865348055743)*x[1]**o+(0.00437553598118)*x[1]
        ref[1, 1, 1, 0]=0.367224744517*o*x_ref[0]**(o-1)+(-0.875588247176)
        ref[1, 1, 1, 1]=0.865348055743*o*x_ref[1]**(o-1)+(0.00437553598118)
        arg[1, 2, 0]=0.281114257229*x[0]**o+(-0.714229553815)*x[0]+(-0.460812024605)*x[1]**o+(-0.81496968221)*x[1]
        ref[1, 2, 0, 0]=0.281114257229*o*x_ref[0]**(o-1)+(-0.714229553815)
        ref[1, 2, 0, 1]=-0.460812024605*o*x_ref[1]**(o-1)+(-0.81496968221)
        arg[1, 2, 1]=0.320929593439*x[0]**o+(-0.565412117745)*x[0]+(-0.802462422575)*x[1]**o+(-0.360784966717)*x[1]
        ref[1, 2, 1, 0]=0.320929593439*o*x_ref[0]**(o-1)+(-0.565412117745)
        ref[1, 2, 1, 1]=-0.802462422575*o*x_ref[1]**(o-1)+(-0.360784966717)
        arg[1, 3, 0]=-0.0636311610228*x[0]**o+(0.346476771004)*x[0]+(0.589566226147)*x[1]**o+(-0.584976950801)*x[1]
        ref[1, 3, 0, 0]=-0.0636311610228*o*x_ref[0]**(o-1)+(0.346476771004)
        ref[1, 3, 0, 1]=0.589566226147*o*x_ref[1]**(o-1)+(-0.584976950801)
        arg[1, 3, 1]=0.882974278377*x[0]**o+(0.73725502277)*x[0]+(0.27240735972)*x[1]**o+(0.74536293339)*x[1]
        ref[1, 3, 1, 0]=0.882974278377*o*x_ref[0]**(o-1)+(0.73725502277)
        ref[1, 3, 1, 1]=0.27240735972*o*x_ref[1]**(o-1)+(0.74536293339)
        arg[2, 0, 0]=0.690879975022*x[0]**o+(0.0646549059385)*x[0]+(0.557006914962)*x[1]**o+(-0.316475837995)*x[1]
        ref[2, 0, 0, 0]=0.690879975022*o*x_ref[0]**(o-1)+(0.0646549059385)
        ref[2, 0, 0, 1]=0.557006914962*o*x_ref[1]**(o-1)+(-0.316475837995)
        arg[2, 0, 1]=0.86712273663*x[0]**o+(0.885670720908)*x[0]+(0.482452181956)*x[1]**o+(0.715887566235)*x[1]
        ref[2, 0, 1, 0]=0.86712273663*o*x_ref[0]**(o-1)+(0.885670720908)
        ref[2, 0, 1, 1]=0.482452181956*o*x_ref[1]**(o-1)+(0.715887566235)
        arg[2, 1, 0]=-0.944687389763*x[0]**o+(0.352507615121)*x[0]+(0.265037683371)*x[1]**o+(-0.592464969)*x[1]
        ref[2, 1, 0, 0]=-0.944687389763*o*x_ref[0]**(o-1)+(0.352507615121)
        ref[2, 1, 0, 1]=0.265037683371*o*x_ref[1]**(o-1)+(-0.592464969)
        arg[2, 1, 1]=-0.31893056484*x[0]**o+(0.936437558154)*x[0]+(0.404413231261)*x[1]**o+(0.957049028844)*x[1]
        ref[2, 1, 1, 0]=-0.31893056484*o*x_ref[0]**(o-1)+(0.936437558154)
        ref[2, 1, 1, 1]=0.404413231261*o*x_ref[1]**(o-1)+(0.957049028844)
        arg[2, 2, 0]=-0.42621390283*x[0]**o+(-0.577415698514)*x[0]+(-0.600598325854)*x[1]**o+(-0.789261748588)*x[1]
        ref[2, 2, 0, 0]=-0.42621390283*o*x_ref[0]**(o-1)+(-0.577415698514)
        ref[2, 2, 0, 1]=-0.600598325854*o*x_ref[1]**(o-1)+(-0.789261748588)
        arg[2, 2, 1]=0.00622634992062*x[0]**o+(0.72140210957)*x[0]+(-0.265000853404)*x[1]**o+(0.551143731636)*x[1]
        ref[2, 2, 1, 0]=0.00622634992062*o*x_ref[0]**(o-1)+(0.72140210957)
        ref[2, 2, 1, 1]=-0.265000853404*o*x_ref[1]**(o-1)+(0.551143731636)
        arg[2, 3, 0]=-0.344964961772*x[0]**o+(-0.583471536835)*x[0]+(0.901567041116)*x[1]**o+(0.296415365106)*x[1]
        ref[2, 3, 0, 0]=-0.344964961772*o*x_ref[0]**(o-1)+(-0.583471536835)
        ref[2, 3, 0, 1]=0.901567041116*o*x_ref[1]**(o-1)+(0.296415365106)
        arg[2, 3, 1]=0.180635752886*x[0]**o+(0.420621026567)*x[0]+(0.00321984032041)*x[1]**o+(-0.818081368138)*x[1]
        ref[2, 3, 1, 0]=0.180635752886*o*x_ref[0]**(o-1)+(0.420621026567)
        ref[2, 3, 1, 1]=0.00321984032041*o*x_ref[1]**(o-1)+(-0.818081368138)
        arg[3, 0, 0]=-0.206554656465*x[0]**o+(0.806787858413)*x[0]+(0.499125291457)*x[1]**o+(-0.429505778364)*x[1]
        ref[3, 0, 0, 0]=-0.206554656465*o*x_ref[0]**(o-1)+(0.806787858413)
        ref[3, 0, 0, 1]=0.499125291457*o*x_ref[1]**(o-1)+(-0.429505778364)
        arg[3, 0, 1]=-0.768380479995*x[0]**o+(-0.708446960254)*x[0]+(-0.395179418841)*x[1]**o+(0.0992926454252)*x[1]
        ref[3, 0, 1, 0]=-0.768380479995*o*x_ref[0]**(o-1)+(-0.708446960254)
        ref[3, 0, 1, 1]=-0.395179418841*o*x_ref[1]**(o-1)+(0.0992926454252)
        arg[3, 1, 0]=-0.702281896971*x[0]**o+(-0.953225968208)*x[0]+(-0.122131740714)*x[1]**o+(0.0225162247151)*x[1]
        ref[3, 1, 0, 0]=-0.702281896971*o*x_ref[0]**(o-1)+(-0.953225968208)
        ref[3, 1, 0, 1]=-0.122131740714*o*x_ref[1]**(o-1)+(0.0225162247151)
        arg[3, 1, 1]=-0.876318314045*x[0]**o+(-0.0733169407283)*x[0]+(0.677317361226)*x[1]**o+(0.0183393847194)*x[1]
        ref[3, 1, 1, 0]=-0.876318314045*o*x_ref[0]**(o-1)+(-0.0733169407283)
        ref[3, 1, 1, 1]=0.677317361226*o*x_ref[1]**(o-1)+(0.0183393847194)
        arg[3, 2, 0]=0.639331303474*x[0]**o+(-0.757191795984)*x[0]+(-0.990547428689)*x[1]**o+(0.293773540598)*x[1]
        ref[3, 2, 0, 0]=0.639331303474*o*x_ref[0]**(o-1)+(-0.757191795984)
        ref[3, 2, 0, 1]=-0.990547428689*o*x_ref[1]**(o-1)+(0.293773540598)
        arg[3, 2, 1]=-0.931707390605*x[0]**o+(-0.855186110334)*x[0]+(0.37848333903)*x[1]**o+(-0.908339766807)*x[1]
        ref[3, 2, 1, 0]=-0.931707390605*o*x_ref[0]**(o-1)+(-0.855186110334)
        ref[3, 2, 1, 1]=0.37848333903*o*x_ref[1]**(o-1)+(-0.908339766807)
        arg[3, 3, 0]=-0.481041626286*x[0]**o+(0.63098305856)*x[0]+(0.427173507638)*x[1]**o+(-0.865640639603)*x[1]
        ref[3, 3, 0, 0]=-0.481041626286*o*x_ref[0]**(o-1)+(0.63098305856)
        ref[3, 3, 0, 1]=0.427173507638*o*x_ref[1]**(o-1)+(-0.865640639603)
        arg[3, 3, 1]=0.738062959132*x[0]**o+(0.843988411974)*x[0]+(0.139882030468)*x[1]**o+(0.790284107371)*x[1]
        ref[3, 3, 1, 0]=0.738062959132*o*x_ref[0]**(o-1)+(0.843988411974)
        ref[3, 3, 1, 1]=0.139882030468*o*x_ref[1]**(o-1)+(0.790284107371)
        if dim==3:
            arg[0, 0, 0]+=-0.0473865990366*x[2]**o+(-0.286323299436)*x[2]
            ref[0, 0, 0, 2]=-0.0473865990366*o*x_ref[2]**(o-1)+(-0.286323299436)
            arg[0, 0, 1]+=-0.76232885191*x[2]**o+(0.049153831827)*x[2]
            ref[0, 0, 1, 2]=-0.76232885191*o*x_ref[2]**(o-1)+(0.049153831827)
            arg[0, 1, 0]+=0.815930656833*x[2]**o+(-0.848560724134)*x[2]
            ref[0, 1, 0, 2]=0.815930656833*o*x_ref[2]**(o-1)+(-0.848560724134)
            arg[0, 1, 1]+=-0.147932934094*x[2]**o+(-0.767377455465)*x[2]
            ref[0, 1, 1, 2]=-0.147932934094*o*x_ref[2]**(o-1)+(-0.767377455465)
            arg[0, 2, 0]+=-0.106884323422*x[2]**o+(-0.461807946827)*x[2]
            ref[0, 2, 0, 2]=-0.106884323422*o*x_ref[2]**(o-1)+(-0.461807946827)
            arg[0, 2, 1]+=0.399383779914*x[2]**o+(-0.0490647846722)*x[2]
            ref[0, 2, 1, 2]=0.399383779914*o*x_ref[2]**(o-1)+(-0.0490647846722)
            arg[0, 3, 0]+=-0.301739970048*x[2]**o+(0.248373184231)*x[2]
            ref[0, 3, 0, 2]=-0.301739970048*o*x_ref[2]**(o-1)+(0.248373184231)
            arg[0, 3, 1]+=-0.0856708923663*x[2]**o+(0.62829202076)*x[2]
            ref[0, 3, 1, 2]=-0.0856708923663*o*x_ref[2]**(o-1)+(0.62829202076)
            arg[1, 0, 0]+=0.636715500377*x[2]**o+(0.619109964001)*x[2]
            ref[1, 0, 0, 2]=0.636715500377*o*x_ref[2]**(o-1)+(0.619109964001)
            arg[1, 0, 1]+=-0.672542263488*x[2]**o+(-0.914919195557)*x[2]
            ref[1, 0, 1, 2]=-0.672542263488*o*x_ref[2]**(o-1)+(-0.914919195557)
            arg[1, 1, 0]+=0.404341313868*x[2]**o+(-0.12316123684)*x[2]
            ref[1, 1, 0, 2]=0.404341313868*o*x_ref[2]**(o-1)+(-0.12316123684)
            arg[1, 1, 1]+=0.78362077898*x[2]**o+(0.542574821529)*x[2]
            ref[1, 1, 1, 2]=0.78362077898*o*x_ref[2]**(o-1)+(0.542574821529)
            arg[1, 2, 0]+=-0.679498482439*x[2]**o+(-0.00796531353047)*x[2]
            ref[1, 2, 0, 2]=-0.679498482439*o*x_ref[2]**(o-1)+(-0.00796531353047)
            arg[1, 2, 1]+=0.448809085029*x[2]**o+(0.0600402496632)*x[2]
            ref[1, 2, 1, 2]=0.448809085029*o*x_ref[2]**(o-1)+(0.0600402496632)
            arg[1, 3, 0]+=0.0357244916407*x[2]**o+(-0.178546405085)*x[2]
            ref[1, 3, 0, 2]=0.0357244916407*o*x_ref[2]**(o-1)+(-0.178546405085)
            arg[1, 3, 1]+=-0.142048644813*x[2]**o+(0.187193889686)*x[2]
            ref[1, 3, 1, 2]=-0.142048644813*o*x_ref[2]**(o-1)+(0.187193889686)
            arg[2, 0, 0]+=0.842422815101*x[2]**o+(0.997494454453)*x[2]
            ref[2, 0, 0, 2]=0.842422815101*o*x_ref[2]**(o-1)+(0.997494454453)
            arg[2, 0, 1]+=-0.206140040496*x[2]**o+(-0.904065562201)*x[2]
            ref[2, 0, 1, 2]=-0.206140040496*o*x_ref[2]**(o-1)+(-0.904065562201)
            arg[2, 1, 0]+=0.158036840028*x[2]**o+(0.34833321395)*x[2]
            ref[2, 1, 0, 2]=0.158036840028*o*x_ref[2]**(o-1)+(0.34833321395)
            arg[2, 1, 1]+=-0.258260874221*x[2]**o+(-0.485189285612)*x[2]
            ref[2, 1, 1, 2]=-0.258260874221*o*x_ref[2]**(o-1)+(-0.485189285612)
            arg[2, 2, 0]+=0.547407150391*x[2]**o+(-0.303707227432)*x[2]
            ref[2, 2, 0, 2]=0.547407150391*o*x_ref[2]**(o-1)+(-0.303707227432)
            arg[2, 2, 1]+=-0.643965243932*x[2]**o+(-0.324360034339)*x[2]
            ref[2, 2, 1, 2]=-0.643965243932*o*x_ref[2]**(o-1)+(-0.324360034339)
            arg[2, 3, 0]+=0.792163574278*x[2]**o+(0.113017104167)*x[2]
            ref[2, 3, 0, 2]=0.792163574278*o*x_ref[2]**(o-1)+(0.113017104167)
            arg[2, 3, 1]+=0.204800642807*x[2]**o+(0.0734575916362)*x[2]
            ref[2, 3, 1, 2]=0.204800642807*o*x_ref[2]**(o-1)+(0.0734575916362)
            arg[3, 0, 0]+=0.709913419966*x[2]**o+(0.699576417978)*x[2]
            ref[3, 0, 0, 2]=0.709913419966*o*x_ref[2]**(o-1)+(0.699576417978)
            arg[3, 0, 1]+=0.279915228229*x[2]**o+(0.285073449055)*x[2]
            ref[3, 0, 1, 2]=0.279915228229*o*x_ref[2]**(o-1)+(0.285073449055)
            arg[3, 1, 0]+=0.899063500198*x[2]**o+(0.619510427001)*x[2]
            ref[3, 1, 0, 2]=0.899063500198*o*x_ref[2]**(o-1)+(0.619510427001)
            arg[3, 1, 1]+=-0.301127396753*x[2]**o+(-0.647815405766)*x[2]
            ref[3, 1, 1, 2]=-0.301127396753*o*x_ref[2]**(o-1)+(-0.647815405766)
            arg[3, 2, 0]+=-0.12379455373*x[2]**o+(0.123003825669)*x[2]
            ref[3, 2, 0, 2]=-0.12379455373*o*x_ref[2]**(o-1)+(0.123003825669)
            arg[3, 2, 1]+=0.0301207542112*x[2]**o+(-0.850448329599)*x[2]
            ref[3, 2, 1, 2]=0.0301207542112*o*x_ref[2]**(o-1)+(-0.850448329599)
            arg[3, 3, 0]+=0.432092957765*x[2]**o+(0.269816383191)*x[2]
            ref[3, 3, 0, 2]=0.432092957765*o*x_ref[2]**(o-1)+(0.269816383191)
            arg[3, 3, 1]+=0.150942607463*x[2]**o+(-0.587332089465)*x[2]
            ref[3, 3, 1, 2]=0.150942607463*o*x_ref[2]**(o-1)+(-0.587332089465)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4, 4, 2)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onFunction_fromData_ReducedSolution_rank0(self):
        """
        tests gradient of rank 0 Data on Function

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=-0.25755193466*x[0]+(-0.931125362247)*x[1]
        ref[0]=-0.25755193466
        ref[1]=-0.931125362247
        if dim==3:
            arg+=(0.233926255584)*x[2]
            ref[2]=0.233926255584
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onFunction_fromData_ReducedSolution_rank1(self):
        """
        tests gradient of rank 1 Data on Function

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(2,),w)
        ref = Data(0,(2,)+(dim,),w_ref)
        arg[0,]=-0.0975093105545*x[0]+(0.744608196184)*x[1]
        ref[0, 0]=-0.0975093105545
        ref[0, 1]=0.744608196184
        arg[1,]=-0.245069789185*x[0]+(0.326152420109)*x[1]
        ref[1, 0]=-0.245069789185
        ref[1, 1]=0.326152420109
        if dim==3:
            arg[0,]+=0.662905362362*x[2]
            ref[0, 2]=0.662905362362
            arg[1,]+=0.137343025568*x[2]
            ref[1, 2]=0.137343025568
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onFunction_fromData_ReducedSolution_rank2(self):
        """
        tests gradient of rank 2 Data on Function

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(4, 2),w)
        ref = Data(0,(4, 2)+(dim,),w_ref)
        arg[0, 0]=-0.864878319222*x[0]+(0.349704559138)*x[1]
        ref[0, 0, 0]=-0.864878319222
        ref[0, 0, 1]=0.349704559138
        arg[0, 1]=-0.50313026256*x[0]+(0.275493364722)*x[1]
        ref[0, 1, 0]=-0.50313026256
        ref[0, 1, 1]=0.275493364722
        arg[1, 0]=-0.632340647936*x[0]+(0.702954591372)*x[1]
        ref[1, 0, 0]=-0.632340647936
        ref[1, 0, 1]=0.702954591372
        arg[1, 1]=-0.125274091672*x[0]+(-0.63556159771)*x[1]
        ref[1, 1, 0]=-0.125274091672
        ref[1, 1, 1]=-0.63556159771
        arg[2, 0]=-0.160029176375*x[0]+(-0.213188325396)*x[1]
        ref[2, 0, 0]=-0.160029176375
        ref[2, 0, 1]=-0.213188325396
        arg[2, 1]=-0.564382409405*x[0]+(-0.115211700347)*x[1]
        ref[2, 1, 0]=-0.564382409405
        ref[2, 1, 1]=-0.115211700347
        arg[3, 0]=0.811427457091*x[0]+(0.0517121636369)*x[1]
        ref[3, 0, 0]=0.811427457091
        ref[3, 0, 1]=0.0517121636369
        arg[3, 1]=-0.198538639727*x[0]+(0.590913870444)*x[1]
        ref[3, 1, 0]=-0.198538639727
        ref[3, 1, 1]=0.590913870444
        if dim==3:
            arg[0, 0]+=-0.622765253183*x[2]
            ref[0, 0, 2]=-0.622765253183
            arg[0, 1]+=0.652462662507*x[2]
            ref[0, 1, 2]=0.652462662507
            arg[1, 0]+=0.026518880036*x[2]
            ref[1, 0, 2]=0.026518880036
            arg[1, 1]+=0.453807500484*x[2]
            ref[1, 1, 2]=0.453807500484
            arg[2, 0]+=-0.627475500209*x[2]
            ref[2, 0, 2]=-0.627475500209
            arg[2, 1]+=-0.68658307312*x[2]
            ref[2, 1, 2]=-0.68658307312
            arg[3, 0]+=-0.38505617241*x[2]
            ref[3, 0, 2]=-0.38505617241
            arg[3, 1]+=0.201836339109*x[2]
            ref[3, 1, 2]=0.201836339109
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4, 2)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onFunction_fromData_ReducedSolution_rank3(self):
        """
        tests gradient of rank 3 Data on Function

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(3, 4, 2),w)
        ref = Data(0,(3, 4, 2)+(dim,),w_ref)
        arg[0, 0, 0]=0.176337429765*x[0]+(-0.407598648354)*x[1]
        ref[0, 0, 0, 0]=0.176337429765
        ref[0, 0, 0, 1]=-0.407598648354
        arg[0, 0, 1]=-0.600097136002*x[0]+(-0.194483400528)*x[1]
        ref[0, 0, 1, 0]=-0.600097136002
        ref[0, 0, 1, 1]=-0.194483400528
        arg[0, 1, 0]=0.00797044349094*x[0]+(0.610665424646)*x[1]
        ref[0, 1, 0, 0]=0.00797044349094
        ref[0, 1, 0, 1]=0.610665424646
        arg[0, 1, 1]=-0.974767119676*x[0]+(0.661161160578)*x[1]
        ref[0, 1, 1, 0]=-0.974767119676
        ref[0, 1, 1, 1]=0.661161160578
        arg[0, 2, 0]=-0.954478812236*x[0]+(0.265972128103)*x[1]
        ref[0, 2, 0, 0]=-0.954478812236
        ref[0, 2, 0, 1]=0.265972128103
        arg[0, 2, 1]=-0.49538623906*x[0]+(-0.727103608573)*x[1]
        ref[0, 2, 1, 0]=-0.49538623906
        ref[0, 2, 1, 1]=-0.727103608573
        arg[0, 3, 0]=-0.655233353937*x[0]+(0.986611024914)*x[1]
        ref[0, 3, 0, 0]=-0.655233353937
        ref[0, 3, 0, 1]=0.986611024914
        arg[0, 3, 1]=-0.472387160309*x[0]+(-0.703929752054)*x[1]
        ref[0, 3, 1, 0]=-0.472387160309
        ref[0, 3, 1, 1]=-0.703929752054
        arg[1, 0, 0]=-0.766206833336*x[0]+(0.811610037578)*x[1]
        ref[1, 0, 0, 0]=-0.766206833336
        ref[1, 0, 0, 1]=0.811610037578
        arg[1, 0, 1]=0.616457270059*x[0]+(-0.773576713097)*x[1]
        ref[1, 0, 1, 0]=0.616457270059
        ref[1, 0, 1, 1]=-0.773576713097
        arg[1, 1, 0]=0.993052706147*x[0]+(0.0999793433202)*x[1]
        ref[1, 1, 0, 0]=0.993052706147
        ref[1, 1, 0, 1]=0.0999793433202
        arg[1, 1, 1]=0.508007011785*x[0]+(0.113179622038)*x[1]
        ref[1, 1, 1, 0]=0.508007011785
        ref[1, 1, 1, 1]=0.113179622038
        arg[1, 2, 0]=0.77851413527*x[0]+(-0.71841866296)*x[1]
        ref[1, 2, 0, 0]=0.77851413527
        ref[1, 2, 0, 1]=-0.71841866296
        arg[1, 2, 1]=-0.0132793372764*x[0]+(-0.609163111882)*x[1]
        ref[1, 2, 1, 0]=-0.0132793372764
        ref[1, 2, 1, 1]=-0.609163111882
        arg[1, 3, 0]=0.0848755937694*x[0]+(0.617462287846)*x[1]
        ref[1, 3, 0, 0]=0.0848755937694
        ref[1, 3, 0, 1]=0.617462287846
        arg[1, 3, 1]=-0.889783221209*x[0]+(0.891017760494)*x[1]
        ref[1, 3, 1, 0]=-0.889783221209
        ref[1, 3, 1, 1]=0.891017760494
        arg[2, 0, 0]=0.42074534728*x[0]+(-0.791763596312)*x[1]
        ref[2, 0, 0, 0]=0.42074534728
        ref[2, 0, 0, 1]=-0.791763596312
        arg[2, 0, 1]=-0.0158059546901*x[0]+(0.907801200744)*x[1]
        ref[2, 0, 1, 0]=-0.0158059546901
        ref[2, 0, 1, 1]=0.907801200744
        arg[2, 1, 0]=0.248625820986*x[0]+(-0.390974519532)*x[1]
        ref[2, 1, 0, 0]=0.248625820986
        ref[2, 1, 0, 1]=-0.390974519532
        arg[2, 1, 1]=0.88389945068*x[0]+(0.425934088097)*x[1]
        ref[2, 1, 1, 0]=0.88389945068
        ref[2, 1, 1, 1]=0.425934088097
        arg[2, 2, 0]=-0.39991516759*x[0]+(-0.474567591681)*x[1]
        ref[2, 2, 0, 0]=-0.39991516759
        ref[2, 2, 0, 1]=-0.474567591681
        arg[2, 2, 1]=0.686196023144*x[0]+(0.822245199054)*x[1]
        ref[2, 2, 1, 0]=0.686196023144
        ref[2, 2, 1, 1]=0.822245199054
        arg[2, 3, 0]=-0.785488114514*x[0]+(0.561237530726)*x[1]
        ref[2, 3, 0, 0]=-0.785488114514
        ref[2, 3, 0, 1]=0.561237530726
        arg[2, 3, 1]=-0.745823193772*x[0]+(0.748998991329)*x[1]
        ref[2, 3, 1, 0]=-0.745823193772
        ref[2, 3, 1, 1]=0.748998991329
        if dim==3:
            arg[0, 0, 0]+=0.254341001782*x[2]
            ref[0, 0, 0, 2]=0.254341001782
            arg[0, 0, 1]+=-0.916057483232*x[2]
            ref[0, 0, 1, 2]=-0.916057483232
            arg[0, 1, 0]+=0.34334838574*x[2]
            ref[0, 1, 0, 2]=0.34334838574
            arg[0, 1, 1]+=0.584311704677*x[2]
            ref[0, 1, 1, 2]=0.584311704677
            arg[0, 2, 0]+=-0.738575464898*x[2]
            ref[0, 2, 0, 2]=-0.738575464898
            arg[0, 2, 1]+=0.571095239438*x[2]
            ref[0, 2, 1, 2]=0.571095239438
            arg[0, 3, 0]+=0.63915009572*x[2]
            ref[0, 3, 0, 2]=0.63915009572
            arg[0, 3, 1]+=0.230590731176*x[2]
            ref[0, 3, 1, 2]=0.230590731176
            arg[1, 0, 0]+=-0.598936692001*x[2]
            ref[1, 0, 0, 2]=-0.598936692001
            arg[1, 0, 1]+=0.712364496728*x[2]
            ref[1, 0, 1, 2]=0.712364496728
            arg[1, 1, 0]+=0.440152566777*x[2]
            ref[1, 1, 0, 2]=0.440152566777
            arg[1, 1, 1]+=-0.720075856642*x[2]
            ref[1, 1, 1, 2]=-0.720075856642
            arg[1, 2, 0]+=0.0532698924365*x[2]
            ref[1, 2, 0, 2]=0.0532698924365
            arg[1, 2, 1]+=-0.73190419219*x[2]
            ref[1, 2, 1, 2]=-0.73190419219
            arg[1, 3, 0]+=0.230131323715*x[2]
            ref[1, 3, 0, 2]=0.230131323715
            arg[1, 3, 1]+=0.578964142672*x[2]
            ref[1, 3, 1, 2]=0.578964142672
            arg[2, 0, 0]+=-0.178352795942*x[2]
            ref[2, 0, 0, 2]=-0.178352795942
            arg[2, 0, 1]+=0.885677632743*x[2]
            ref[2, 0, 1, 2]=0.885677632743
            arg[2, 1, 0]+=0.947524880016*x[2]
            ref[2, 1, 0, 2]=0.947524880016
            arg[2, 1, 1]+=0.783065136041*x[2]
            ref[2, 1, 1, 2]=0.783065136041
            arg[2, 2, 0]+=-0.22373896648*x[2]
            ref[2, 2, 0, 2]=-0.22373896648
            arg[2, 2, 1]+=-0.716291343165*x[2]
            ref[2, 2, 1, 2]=-0.716291343165
            arg[2, 3, 0]+=-0.372451679394*x[2]
            ref[2, 3, 0, 2]=-0.372451679394
            arg[2, 3, 1]+=0.425434883578*x[2]
            ref[2, 3, 1, 2]=0.425434883578
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3, 4, 2)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onFunction_fromData_ReducedContinuousFunction_rank0(self):
        """
        tests gradient of rank 0 Data on Function

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=0.943660817814*x[0]+(-0.825797749216)*x[1]
        ref[0]=0.943660817814
        ref[1]=-0.825797749216
        if dim==3:
            arg+=(-0.879699808579)*x[2]
            ref[2]=-0.879699808579
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onFunction_fromData_ReducedContinuousFunction_rank1(self):
        """
        tests gradient of rank 1 Data on Function

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(2,),w)
        ref = Data(0,(2,)+(dim,),w_ref)
        arg[0,]=0.891434956189*x[0]+(0.30725398501)*x[1]
        ref[0, 0]=0.891434956189
        ref[0, 1]=0.30725398501
        arg[1,]=-0.452207493175*x[0]+(-0.583639494709)*x[1]
        ref[1, 0]=-0.452207493175
        ref[1, 1]=-0.583639494709
        if dim==3:
            arg[0,]+=0.662329435442*x[2]
            ref[0, 2]=0.662329435442
            arg[1,]+=-0.346257085383*x[2]
            ref[1, 2]=-0.346257085383
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onFunction_fromData_ReducedContinuousFunction_rank2(self):
        """
        tests gradient of rank 2 Data on Function

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(4, 3),w)
        ref = Data(0,(4, 3)+(dim,),w_ref)
        arg[0, 0]=-0.793012689363*x[0]+(0.562315030947)*x[1]
        ref[0, 0, 0]=-0.793012689363
        ref[0, 0, 1]=0.562315030947
        arg[0, 1]=-0.370076704027*x[0]+(0.608009465404)*x[1]
        ref[0, 1, 0]=-0.370076704027
        ref[0, 1, 1]=0.608009465404
        arg[0, 2]=0.66676116873*x[0]+(-0.331142538407)*x[1]
        ref[0, 2, 0]=0.66676116873
        ref[0, 2, 1]=-0.331142538407
        arg[1, 0]=-0.840272499433*x[0]+(0.95343195438)*x[1]
        ref[1, 0, 0]=-0.840272499433
        ref[1, 0, 1]=0.95343195438
        arg[1, 1]=-0.597275842725*x[0]+(0.945899722894)*x[1]
        ref[1, 1, 0]=-0.597275842725
        ref[1, 1, 1]=0.945899722894
        arg[1, 2]=0.341522109872*x[0]+(-0.0252291008602)*x[1]
        ref[1, 2, 0]=0.341522109872
        ref[1, 2, 1]=-0.0252291008602
        arg[2, 0]=-0.204367952377*x[0]+(-0.713173363011)*x[1]
        ref[2, 0, 0]=-0.204367952377
        ref[2, 0, 1]=-0.713173363011
        arg[2, 1]=-0.444913228559*x[0]+(0.975862851627)*x[1]
        ref[2, 1, 0]=-0.444913228559
        ref[2, 1, 1]=0.975862851627
        arg[2, 2]=0.148372488253*x[0]+(0.34567732677)*x[1]
        ref[2, 2, 0]=0.148372488253
        ref[2, 2, 1]=0.34567732677
        arg[3, 0]=0.922565930037*x[0]+(-0.0428471571473)*x[1]
        ref[3, 0, 0]=0.922565930037
        ref[3, 0, 1]=-0.0428471571473
        arg[3, 1]=-0.76819492434*x[0]+(0.868429660002)*x[1]
        ref[3, 1, 0]=-0.76819492434
        ref[3, 1, 1]=0.868429660002
        arg[3, 2]=0.974467189747*x[0]+(-0.0917575668586)*x[1]
        ref[3, 2, 0]=0.974467189747
        ref[3, 2, 1]=-0.0917575668586
        if dim==3:
            arg[0, 0]+=-0.817620528149*x[2]
            ref[0, 0, 2]=-0.817620528149
            arg[0, 1]+=-0.105143309177*x[2]
            ref[0, 1, 2]=-0.105143309177
            arg[0, 2]+=-0.0265954047012*x[2]
            ref[0, 2, 2]=-0.0265954047012
            arg[1, 0]+=0.360234367928*x[2]
            ref[1, 0, 2]=0.360234367928
            arg[1, 1]+=-0.0551503688134*x[2]
            ref[1, 1, 2]=-0.0551503688134
            arg[1, 2]+=0.0794740200493*x[2]
            ref[1, 2, 2]=0.0794740200493
            arg[2, 0]+=-0.994696495987*x[2]
            ref[2, 0, 2]=-0.994696495987
            arg[2, 1]+=0.526649029745*x[2]
            ref[2, 1, 2]=0.526649029745
            arg[2, 2]+=-0.0439081350232*x[2]
            ref[2, 2, 2]=-0.0439081350232
            arg[3, 0]+=-0.0449813596418*x[2]
            ref[3, 0, 2]=-0.0449813596418
            arg[3, 1]+=0.405709428978*x[2]
            ref[3, 1, 2]=0.405709428978
            arg[3, 2]+=-0.32464047502*x[2]
            ref[3, 2, 2]=-0.32464047502
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4, 3)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onFunction_fromData_ReducedContinuousFunction_rank3(self):
        """
        tests gradient of rank 3 Data on Function

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on Function
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = Function(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(4, 4, 3),w)
        ref = Data(0,(4, 4, 3)+(dim,),w_ref)
        arg[0, 0, 0]=-0.801824897505*x[0]+(0.78435094044)*x[1]
        ref[0, 0, 0, 0]=-0.801824897505
        ref[0, 0, 0, 1]=0.78435094044
        arg[0, 0, 1]=0.468401213026*x[0]+(0.914369935092)*x[1]
        ref[0, 0, 1, 0]=0.468401213026
        ref[0, 0, 1, 1]=0.914369935092
        arg[0, 0, 2]=-0.881884343355*x[0]+(-0.451818330647)*x[1]
        ref[0, 0, 2, 0]=-0.881884343355
        ref[0, 0, 2, 1]=-0.451818330647
        arg[0, 1, 0]=-0.0614936728245*x[0]+(0.423843538607)*x[1]
        ref[0, 1, 0, 0]=-0.0614936728245
        ref[0, 1, 0, 1]=0.423843538607
        arg[0, 1, 1]=0.52171688526*x[0]+(-0.86698207793)*x[1]
        ref[0, 1, 1, 0]=0.52171688526
        ref[0, 1, 1, 1]=-0.86698207793
        arg[0, 1, 2]=-0.704188035418*x[0]+(-0.920597047941)*x[1]
        ref[0, 1, 2, 0]=-0.704188035418
        ref[0, 1, 2, 1]=-0.920597047941
        arg[0, 2, 0]=-0.965115321749*x[0]+(-0.314857611389)*x[1]
        ref[0, 2, 0, 0]=-0.965115321749
        ref[0, 2, 0, 1]=-0.314857611389
        arg[0, 2, 1]=-0.821086928861*x[0]+(0.916743211012)*x[1]
        ref[0, 2, 1, 0]=-0.821086928861
        ref[0, 2, 1, 1]=0.916743211012
        arg[0, 2, 2]=-0.00727873467722*x[0]+(0.474362745932)*x[1]
        ref[0, 2, 2, 0]=-0.00727873467722
        ref[0, 2, 2, 1]=0.474362745932
        arg[0, 3, 0]=0.629811050206*x[0]+(0.826539898874)*x[1]
        ref[0, 3, 0, 0]=0.629811050206
        ref[0, 3, 0, 1]=0.826539898874
        arg[0, 3, 1]=-0.48920794622*x[0]+(-0.241275210023)*x[1]
        ref[0, 3, 1, 0]=-0.48920794622
        ref[0, 3, 1, 1]=-0.241275210023
        arg[0, 3, 2]=0.305073334812*x[0]+(0.711895045394)*x[1]
        ref[0, 3, 2, 0]=0.305073334812
        ref[0, 3, 2, 1]=0.711895045394
        arg[1, 0, 0]=0.782237609669*x[0]+(0.767432946562)*x[1]
        ref[1, 0, 0, 0]=0.782237609669
        ref[1, 0, 0, 1]=0.767432946562
        arg[1, 0, 1]=-0.35978944982*x[0]+(-0.668501614981)*x[1]
        ref[1, 0, 1, 0]=-0.35978944982
        ref[1, 0, 1, 1]=-0.668501614981
        arg[1, 0, 2]=0.995727603555*x[0]+(0.739913483158)*x[1]
        ref[1, 0, 2, 0]=0.995727603555
        ref[1, 0, 2, 1]=0.739913483158
        arg[1, 1, 0]=-0.572950466828*x[0]+(0.247450173589)*x[1]
        ref[1, 1, 0, 0]=-0.572950466828
        ref[1, 1, 0, 1]=0.247450173589
        arg[1, 1, 1]=0.97939698122*x[0]+(0.518600406576)*x[1]
        ref[1, 1, 1, 0]=0.97939698122
        ref[1, 1, 1, 1]=0.518600406576
        arg[1, 1, 2]=0.998012406274*x[0]+(0.763664525975)*x[1]
        ref[1, 1, 2, 0]=0.998012406274
        ref[1, 1, 2, 1]=0.763664525975
        arg[1, 2, 0]=0.103040062189*x[0]+(-0.714742676547)*x[1]
        ref[1, 2, 0, 0]=0.103040062189
        ref[1, 2, 0, 1]=-0.714742676547
        arg[1, 2, 1]=0.192565122109*x[0]+(0.952754722528)*x[1]
        ref[1, 2, 1, 0]=0.192565122109
        ref[1, 2, 1, 1]=0.952754722528
        arg[1, 2, 2]=0.59670626617*x[0]+(0.187284235942)*x[1]
        ref[1, 2, 2, 0]=0.59670626617
        ref[1, 2, 2, 1]=0.187284235942
        arg[1, 3, 0]=-0.413717005014*x[0]+(-0.775530551426)*x[1]
        ref[1, 3, 0, 0]=-0.413717005014
        ref[1, 3, 0, 1]=-0.775530551426
        arg[1, 3, 1]=-0.924246965097*x[0]+(0.773102645428)*x[1]
        ref[1, 3, 1, 0]=-0.924246965097
        ref[1, 3, 1, 1]=0.773102645428
        arg[1, 3, 2]=0.506445457809*x[0]+(0.184695265552)*x[1]
        ref[1, 3, 2, 0]=0.506445457809
        ref[1, 3, 2, 1]=0.184695265552
        arg[2, 0, 0]=-0.576479985626*x[0]+(-0.121587655664)*x[1]
        ref[2, 0, 0, 0]=-0.576479985626
        ref[2, 0, 0, 1]=-0.121587655664
        arg[2, 0, 1]=-0.496091397544*x[0]+(-0.988559059419)*x[1]
        ref[2, 0, 1, 0]=-0.496091397544
        ref[2, 0, 1, 1]=-0.988559059419
        arg[2, 0, 2]=0.349238653488*x[0]+(0.416073382068)*x[1]
        ref[2, 0, 2, 0]=0.349238653488
        ref[2, 0, 2, 1]=0.416073382068
        arg[2, 1, 0]=-0.524030188715*x[0]+(0.583652886972)*x[1]
        ref[2, 1, 0, 0]=-0.524030188715
        ref[2, 1, 0, 1]=0.583652886972
        arg[2, 1, 1]=-0.356600245095*x[0]+(-0.182166887424)*x[1]
        ref[2, 1, 1, 0]=-0.356600245095
        ref[2, 1, 1, 1]=-0.182166887424
        arg[2, 1, 2]=0.294153024102*x[0]+(-0.863202237355)*x[1]
        ref[2, 1, 2, 0]=0.294153024102
        ref[2, 1, 2, 1]=-0.863202237355
        arg[2, 2, 0]=-0.555613325314*x[0]+(0.72040922524)*x[1]
        ref[2, 2, 0, 0]=-0.555613325314
        ref[2, 2, 0, 1]=0.72040922524
        arg[2, 2, 1]=0.844195817115*x[0]+(0.836887967781)*x[1]
        ref[2, 2, 1, 0]=0.844195817115
        ref[2, 2, 1, 1]=0.836887967781
        arg[2, 2, 2]=0.0243033923985*x[0]+(0.219169176871)*x[1]
        ref[2, 2, 2, 0]=0.0243033923985
        ref[2, 2, 2, 1]=0.219169176871
        arg[2, 3, 0]=-0.394086332407*x[0]+(-0.51647855535)*x[1]
        ref[2, 3, 0, 0]=-0.394086332407
        ref[2, 3, 0, 1]=-0.51647855535
        arg[2, 3, 1]=0.800718917849*x[0]+(0.0383636152068)*x[1]
        ref[2, 3, 1, 0]=0.800718917849
        ref[2, 3, 1, 1]=0.0383636152068
        arg[2, 3, 2]=-0.844316872609*x[0]+(0.408808541251)*x[1]
        ref[2, 3, 2, 0]=-0.844316872609
        ref[2, 3, 2, 1]=0.408808541251
        arg[3, 0, 0]=0.304953263612*x[0]+(-0.795872759257)*x[1]
        ref[3, 0, 0, 0]=0.304953263612
        ref[3, 0, 0, 1]=-0.795872759257
        arg[3, 0, 1]=-0.931419086093*x[0]+(-0.792096507419)*x[1]
        ref[3, 0, 1, 0]=-0.931419086093
        ref[3, 0, 1, 1]=-0.792096507419
        arg[3, 0, 2]=0.493736497156*x[0]+(-0.0446054257634)*x[1]
        ref[3, 0, 2, 0]=0.493736497156
        ref[3, 0, 2, 1]=-0.0446054257634
        arg[3, 1, 0]=0.056130159111*x[0]+(0.298846207201)*x[1]
        ref[3, 1, 0, 0]=0.056130159111
        ref[3, 1, 0, 1]=0.298846207201
        arg[3, 1, 1]=-0.263061196138*x[0]+(-0.90446760279)*x[1]
        ref[3, 1, 1, 0]=-0.263061196138
        ref[3, 1, 1, 1]=-0.90446760279
        arg[3, 1, 2]=0.902228942739*x[0]+(0.775246080038)*x[1]
        ref[3, 1, 2, 0]=0.902228942739
        ref[3, 1, 2, 1]=0.775246080038
        arg[3, 2, 0]=-0.0536740903208*x[0]+(-0.798275491935)*x[1]
        ref[3, 2, 0, 0]=-0.0536740903208
        ref[3, 2, 0, 1]=-0.798275491935
        arg[3, 2, 1]=-0.136462095195*x[0]+(-0.438508965129)*x[1]
        ref[3, 2, 1, 0]=-0.136462095195
        ref[3, 2, 1, 1]=-0.438508965129
        arg[3, 2, 2]=0.0671381300721*x[0]+(0.269874893668)*x[1]
        ref[3, 2, 2, 0]=0.0671381300721
        ref[3, 2, 2, 1]=0.269874893668
        arg[3, 3, 0]=0.594321349829*x[0]+(-0.586075641025)*x[1]
        ref[3, 3, 0, 0]=0.594321349829
        ref[3, 3, 0, 1]=-0.586075641025
        arg[3, 3, 1]=0.984455884822*x[0]+(-0.954592327975)*x[1]
        ref[3, 3, 1, 0]=0.984455884822
        ref[3, 3, 1, 1]=-0.954592327975
        arg[3, 3, 2]=-0.377410901546*x[0]+(-0.881715737848)*x[1]
        ref[3, 3, 2, 0]=-0.377410901546
        ref[3, 3, 2, 1]=-0.881715737848
        if dim==3:
            arg[0, 0, 0]+=-0.879802031979*x[2]
            ref[0, 0, 0, 2]=-0.879802031979
            arg[0, 0, 1]+=0.314115879654*x[2]
            ref[0, 0, 1, 2]=0.314115879654
            arg[0, 0, 2]+=0.236628418115*x[2]
            ref[0, 0, 2, 2]=0.236628418115
            arg[0, 1, 0]+=0.583941563782*x[2]
            ref[0, 1, 0, 2]=0.583941563782
            arg[0, 1, 1]+=0.996937662655*x[2]
            ref[0, 1, 1, 2]=0.996937662655
            arg[0, 1, 2]+=-0.118784266658*x[2]
            ref[0, 1, 2, 2]=-0.118784266658
            arg[0, 2, 0]+=-0.323178223561*x[2]
            ref[0, 2, 0, 2]=-0.323178223561
            arg[0, 2, 1]+=0.0709746887447*x[2]
            ref[0, 2, 1, 2]=0.0709746887447
            arg[0, 2, 2]+=0.0801935426249*x[2]
            ref[0, 2, 2, 2]=0.0801935426249
            arg[0, 3, 0]+=0.553524621989*x[2]
            ref[0, 3, 0, 2]=0.553524621989
            arg[0, 3, 1]+=0.25330451367*x[2]
            ref[0, 3, 1, 2]=0.25330451367
            arg[0, 3, 2]+=0.434245434854*x[2]
            ref[0, 3, 2, 2]=0.434245434854
            arg[1, 0, 0]+=-0.361862821128*x[2]
            ref[1, 0, 0, 2]=-0.361862821128
            arg[1, 0, 1]+=0.95269780009*x[2]
            ref[1, 0, 1, 2]=0.95269780009
            arg[1, 0, 2]+=0.487959249811*x[2]
            ref[1, 0, 2, 2]=0.487959249811
            arg[1, 1, 0]+=-0.873997851777*x[2]
            ref[1, 1, 0, 2]=-0.873997851777
            arg[1, 1, 1]+=0.45507102741*x[2]
            ref[1, 1, 1, 2]=0.45507102741
            arg[1, 1, 2]+=0.266670854518*x[2]
            ref[1, 1, 2, 2]=0.266670854518
            arg[1, 2, 0]+=0.943223500304*x[2]
            ref[1, 2, 0, 2]=0.943223500304
            arg[1, 2, 1]+=0.697795898607*x[2]
            ref[1, 2, 1, 2]=0.697795898607
            arg[1, 2, 2]+=0.295956276413*x[2]
            ref[1, 2, 2, 2]=0.295956276413
            arg[1, 3, 0]+=0.566944827256*x[2]
            ref[1, 3, 0, 2]=0.566944827256
            arg[1, 3, 1]+=-0.296475212288*x[2]
            ref[1, 3, 1, 2]=-0.296475212288
            arg[1, 3, 2]+=0.852952557628*x[2]
            ref[1, 3, 2, 2]=0.852952557628
            arg[2, 0, 0]+=-0.854941500472*x[2]
            ref[2, 0, 0, 2]=-0.854941500472
            arg[2, 0, 1]+=-0.750432492905*x[2]
            ref[2, 0, 1, 2]=-0.750432492905
            arg[2, 0, 2]+=-0.264967973443*x[2]
            ref[2, 0, 2, 2]=-0.264967973443
            arg[2, 1, 0]+=-0.969270412679*x[2]
            ref[2, 1, 0, 2]=-0.969270412679
            arg[2, 1, 1]+=0.0298108316415*x[2]
            ref[2, 1, 1, 2]=0.0298108316415
            arg[2, 1, 2]+=-0.411268046716*x[2]
            ref[2, 1, 2, 2]=-0.411268046716
            arg[2, 2, 0]+=0.227355937338*x[2]
            ref[2, 2, 0, 2]=0.227355937338
            arg[2, 2, 1]+=-0.655810282624*x[2]
            ref[2, 2, 1, 2]=-0.655810282624
            arg[2, 2, 2]+=-0.127208292716*x[2]
            ref[2, 2, 2, 2]=-0.127208292716
            arg[2, 3, 0]+=-0.393843531318*x[2]
            ref[2, 3, 0, 2]=-0.393843531318
            arg[2, 3, 1]+=-0.290796681063*x[2]
            ref[2, 3, 1, 2]=-0.290796681063
            arg[2, 3, 2]+=-0.684403257724*x[2]
            ref[2, 3, 2, 2]=-0.684403257724
            arg[3, 0, 0]+=0.350497716725*x[2]
            ref[3, 0, 0, 2]=0.350497716725
            arg[3, 0, 1]+=0.580248845235*x[2]
            ref[3, 0, 1, 2]=0.580248845235
            arg[3, 0, 2]+=-0.17789441705*x[2]
            ref[3, 0, 2, 2]=-0.17789441705
            arg[3, 1, 0]+=-0.868229227664*x[2]
            ref[3, 1, 0, 2]=-0.868229227664
            arg[3, 1, 1]+=-0.954415792026*x[2]
            ref[3, 1, 1, 2]=-0.954415792026
            arg[3, 1, 2]+=-0.738789760298*x[2]
            ref[3, 1, 2, 2]=-0.738789760298
            arg[3, 2, 0]+=-0.360264870445*x[2]
            ref[3, 2, 0, 2]=-0.360264870445
            arg[3, 2, 1]+=0.76009100246*x[2]
            ref[3, 2, 1, 2]=0.76009100246
            arg[3, 2, 2]+=-0.387127883303*x[2]
            ref[3, 2, 2, 2]=-0.387127883303
            arg[3, 3, 0]+=-0.391842262105*x[2]
            ref[3, 3, 0, 2]=-0.391842262105
            arg[3, 3, 1]+=0.272817577846*x[2]
            ref[3, 3, 1, 2]=0.272817577846
            arg[3, 3, 2]+=0.73038168039*x[2]
            ref[3, 3, 2, 2]=0.73038168039
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4, 4, 3)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onReducedFunction_fromData_ContinuousFunction_rank0(self):
        """
        tests gradient of rank 0 Data on ReducedFunction

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=0.737092219698*x[0]**o+(0.80886346694)*x[0]+(-0.896006953991)*x[1]**o+(0.841258349305)*x[1]
        ref[0]=0.737092219698*o*x_ref[0]**(o-1)+(0.80886346694)
        ref[1]=-0.896006953991*o*x_ref[1]**(o-1)+(0.841258349305)
        if dim==3:
            arg+=(0.864821140528)*x[2]**o+(-0.714745520202)*x[2]
            ref[2]=0.864821140528*o*x_ref[2]**(o-1)+(-0.714745520202)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onReducedFunction_fromData_ContinuousFunction_rank1(self):
        """
        tests gradient of rank 1 Data on ReducedFunction

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(2,),w)
        ref = Data(0,(2,)+(dim,),w_ref)
        arg[0,]=0.587822204965*x[0]**o+(0.606667493057)*x[0]+(0.6210197366)*x[1]**o+(0.780486585494)*x[1]
        ref[0, 0]=0.587822204965*o*x_ref[0]**(o-1)+(0.606667493057)
        ref[0, 1]=0.6210197366*o*x_ref[1]**(o-1)+(0.780486585494)
        arg[1,]=-0.246347362186*x[0]**o+(-0.397687690746)*x[0]+(-0.899622638243)*x[1]**o+(0.695956623238)*x[1]
        ref[1, 0]=-0.246347362186*o*x_ref[0]**(o-1)+(-0.397687690746)
        ref[1, 1]=-0.899622638243*o*x_ref[1]**(o-1)+(0.695956623238)
        if dim==3:
            arg[0,]+=0.169236063745*x[2]**o+(0.750331034237)*x[2]
            ref[0, 2]=0.169236063745*o*x_ref[2]**(o-1)+(0.750331034237)
            arg[1,]+=0.626410254607*x[2]**o+(0.117687091489)*x[2]
            ref[1, 2]=0.626410254607*o*x_ref[2]**(o-1)+(0.117687091489)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onReducedFunction_fromData_ContinuousFunction_rank2(self):
        """
        tests gradient of rank 2 Data on ReducedFunction

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(3, 4),w)
        ref = Data(0,(3, 4)+(dim,),w_ref)
        arg[0, 0]=0.41881405307*x[0]**o+(0.718008031489)*x[0]+(-0.108606502632)*x[1]**o+(0.0351745163837)*x[1]
        ref[0, 0, 0]=0.41881405307*o*x_ref[0]**(o-1)+(0.718008031489)
        ref[0, 0, 1]=-0.108606502632*o*x_ref[1]**(o-1)+(0.0351745163837)
        arg[0, 1]=-0.841657493849*x[0]**o+(0.118946969279)*x[0]+(0.554015408311)*x[1]**o+(0.527624594012)*x[1]
        ref[0, 1, 0]=-0.841657493849*o*x_ref[0]**(o-1)+(0.118946969279)
        ref[0, 1, 1]=0.554015408311*o*x_ref[1]**(o-1)+(0.527624594012)
        arg[0, 2]=0.664244653624*x[0]**o+(0.255163450904)*x[0]+(-0.469920420869)*x[1]**o+(-0.482013474516)*x[1]
        ref[0, 2, 0]=0.664244653624*o*x_ref[0]**(o-1)+(0.255163450904)
        ref[0, 2, 1]=-0.469920420869*o*x_ref[1]**(o-1)+(-0.482013474516)
        arg[0, 3]=-0.266892461656*x[0]**o+(-0.985834220524)*x[0]+(0.503103817812)*x[1]**o+(0.356104802826)*x[1]
        ref[0, 3, 0]=-0.266892461656*o*x_ref[0]**(o-1)+(-0.985834220524)
        ref[0, 3, 1]=0.503103817812*o*x_ref[1]**(o-1)+(0.356104802826)
        arg[1, 0]=-0.890268375709*x[0]**o+(0.521257583281)*x[0]+(-0.618712421049)*x[1]**o+(0.0722915186417)*x[1]
        ref[1, 0, 0]=-0.890268375709*o*x_ref[0]**(o-1)+(0.521257583281)
        ref[1, 0, 1]=-0.618712421049*o*x_ref[1]**(o-1)+(0.0722915186417)
        arg[1, 1]=0.235521028527*x[0]**o+(-0.175746743282)*x[0]+(0.254196037214)*x[1]**o+(-0.435071068229)*x[1]
        ref[1, 1, 0]=0.235521028527*o*x_ref[0]**(o-1)+(-0.175746743282)
        ref[1, 1, 1]=0.254196037214*o*x_ref[1]**(o-1)+(-0.435071068229)
        arg[1, 2]=0.310102703027*x[0]**o+(0.569839657949)*x[0]+(0.346270816481)*x[1]**o+(0.624247885024)*x[1]
        ref[1, 2, 0]=0.310102703027*o*x_ref[0]**(o-1)+(0.569839657949)
        ref[1, 2, 1]=0.346270816481*o*x_ref[1]**(o-1)+(0.624247885024)
        arg[1, 3]=0.439450032292*x[0]**o+(-0.125265960927)*x[0]+(0.024033558049)*x[1]**o+(0.826521680848)*x[1]
        ref[1, 3, 0]=0.439450032292*o*x_ref[0]**(o-1)+(-0.125265960927)
        ref[1, 3, 1]=0.024033558049*o*x_ref[1]**(o-1)+(0.826521680848)
        arg[2, 0]=0.679772176428*x[0]**o+(0.171122993959)*x[0]+(-0.118504901153)*x[1]**o+(0.190575901898)*x[1]
        ref[2, 0, 0]=0.679772176428*o*x_ref[0]**(o-1)+(0.171122993959)
        ref[2, 0, 1]=-0.118504901153*o*x_ref[1]**(o-1)+(0.190575901898)
        arg[2, 1]=0.65072213244*x[0]**o+(-0.347240247411)*x[0]+(0.460039204466)*x[1]**o+(-0.00334678883019)*x[1]
        ref[2, 1, 0]=0.65072213244*o*x_ref[0]**(o-1)+(-0.347240247411)
        ref[2, 1, 1]=0.460039204466*o*x_ref[1]**(o-1)+(-0.00334678883019)
        arg[2, 2]=0.0166252279295*x[0]**o+(-0.717711144238)*x[0]+(0.269542944657)*x[1]**o+(0.226941804109)*x[1]
        ref[2, 2, 0]=0.0166252279295*o*x_ref[0]**(o-1)+(-0.717711144238)
        ref[2, 2, 1]=0.269542944657*o*x_ref[1]**(o-1)+(0.226941804109)
        arg[2, 3]=0.326155251368*x[0]**o+(-0.955332689596)*x[0]+(0.239888672939)*x[1]**o+(-0.895343309953)*x[1]
        ref[2, 3, 0]=0.326155251368*o*x_ref[0]**(o-1)+(-0.955332689596)
        ref[2, 3, 1]=0.239888672939*o*x_ref[1]**(o-1)+(-0.895343309953)
        if dim==3:
            arg[0, 0]+=0.735464436183*x[2]**o+(0.0306248811798)*x[2]
            ref[0, 0, 2]=0.735464436183*o*x_ref[2]**(o-1)+(0.0306248811798)
            arg[0, 1]+=0.723088286701*x[2]**o+(0.357398587576)*x[2]
            ref[0, 1, 2]=0.723088286701*o*x_ref[2]**(o-1)+(0.357398587576)
            arg[0, 2]+=-0.420033296562*x[2]**o+(-0.665549399788)*x[2]
            ref[0, 2, 2]=-0.420033296562*o*x_ref[2]**(o-1)+(-0.665549399788)
            arg[0, 3]+=-0.449378543227*x[2]**o+(-0.0936499291086)*x[2]
            ref[0, 3, 2]=-0.449378543227*o*x_ref[2]**(o-1)+(-0.0936499291086)
            arg[1, 0]+=0.46136620838*x[2]**o+(-0.135583684348)*x[2]
            ref[1, 0, 2]=0.46136620838*o*x_ref[2]**(o-1)+(-0.135583684348)
            arg[1, 1]+=0.15542223617*x[2]**o+(0.0608142847587)*x[2]
            ref[1, 1, 2]=0.15542223617*o*x_ref[2]**(o-1)+(0.0608142847587)
            arg[1, 2]+=-0.705150694707*x[2]**o+(0.0241084468942)*x[2]
            ref[1, 2, 2]=-0.705150694707*o*x_ref[2]**(o-1)+(0.0241084468942)
            arg[1, 3]+=0.431539138279*x[2]**o+(0.0135671916901)*x[2]
            ref[1, 3, 2]=0.431539138279*o*x_ref[2]**(o-1)+(0.0135671916901)
            arg[2, 0]+=0.592653028209*x[2]**o+(-0.164592712406)*x[2]
            ref[2, 0, 2]=0.592653028209*o*x_ref[2]**(o-1)+(-0.164592712406)
            arg[2, 1]+=0.726385973336*x[2]**o+(-0.542345560728)*x[2]
            ref[2, 1, 2]=0.726385973336*o*x_ref[2]**(o-1)+(-0.542345560728)
            arg[2, 2]+=0.130919851822*x[2]**o+(0.803549095131)*x[2]
            ref[2, 2, 2]=0.130919851822*o*x_ref[2]**(o-1)+(0.803549095131)
            arg[2, 3]+=0.889660613407*x[2]**o+(0.132339500744)*x[2]
            ref[2, 3, 2]=0.889660613407*o*x_ref[2]**(o-1)+(0.132339500744)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3, 4)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onReducedFunction_fromData_ContinuousFunction_rank3(self):
        """
        tests gradient of rank 3 Data on ReducedFunction

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(3, 4, 4),w)
        ref = Data(0,(3, 4, 4)+(dim,),w_ref)
        arg[0, 0, 0]=0.248781639974*x[0]**o+(-0.238059158344)*x[0]+(-0.0815073449941)*x[1]**o+(-0.690619383396)*x[1]
        ref[0, 0, 0, 0]=0.248781639974*o*x_ref[0]**(o-1)+(-0.238059158344)
        ref[0, 0, 0, 1]=-0.0815073449941*o*x_ref[1]**(o-1)+(-0.690619383396)
        arg[0, 0, 1]=0.920030542532*x[0]**o+(0.549538055276)*x[0]+(0.453976436321)*x[1]**o+(0.744345278083)*x[1]
        ref[0, 0, 1, 0]=0.920030542532*o*x_ref[0]**(o-1)+(0.549538055276)
        ref[0, 0, 1, 1]=0.453976436321*o*x_ref[1]**(o-1)+(0.744345278083)
        arg[0, 0, 2]=0.561414837961*x[0]**o+(0.963113410712)*x[0]+(-0.358701328815)*x[1]**o+(-0.83213636169)*x[1]
        ref[0, 0, 2, 0]=0.561414837961*o*x_ref[0]**(o-1)+(0.963113410712)
        ref[0, 0, 2, 1]=-0.358701328815*o*x_ref[1]**(o-1)+(-0.83213636169)
        arg[0, 0, 3]=0.600390133653*x[0]**o+(0.757051902239)*x[0]+(-0.011100251559)*x[1]**o+(-0.00747473377824)*x[1]
        ref[0, 0, 3, 0]=0.600390133653*o*x_ref[0]**(o-1)+(0.757051902239)
        ref[0, 0, 3, 1]=-0.011100251559*o*x_ref[1]**(o-1)+(-0.00747473377824)
        arg[0, 1, 0]=0.985806821671*x[0]**o+(0.211802821783)*x[0]+(-0.082000329353)*x[1]**o+(0.534567230177)*x[1]
        ref[0, 1, 0, 0]=0.985806821671*o*x_ref[0]**(o-1)+(0.211802821783)
        ref[0, 1, 0, 1]=-0.082000329353*o*x_ref[1]**(o-1)+(0.534567230177)
        arg[0, 1, 1]=-0.629648102152*x[0]**o+(0.17866568735)*x[0]+(0.84091137084)*x[1]**o+(-0.348898650619)*x[1]
        ref[0, 1, 1, 0]=-0.629648102152*o*x_ref[0]**(o-1)+(0.17866568735)
        ref[0, 1, 1, 1]=0.84091137084*o*x_ref[1]**(o-1)+(-0.348898650619)
        arg[0, 1, 2]=-0.278495259926*x[0]**o+(-0.886895804343)*x[0]+(0.412457288474)*x[1]**o+(0.929284709843)*x[1]
        ref[0, 1, 2, 0]=-0.278495259926*o*x_ref[0]**(o-1)+(-0.886895804343)
        ref[0, 1, 2, 1]=0.412457288474*o*x_ref[1]**(o-1)+(0.929284709843)
        arg[0, 1, 3]=0.679911226409*x[0]**o+(-0.538685582423)*x[0]+(-0.498974236385)*x[1]**o+(-0.543050282346)*x[1]
        ref[0, 1, 3, 0]=0.679911226409*o*x_ref[0]**(o-1)+(-0.538685582423)
        ref[0, 1, 3, 1]=-0.498974236385*o*x_ref[1]**(o-1)+(-0.543050282346)
        arg[0, 2, 0]=-0.133269589645*x[0]**o+(-0.521490067085)*x[0]+(-0.470507869048)*x[1]**o+(-0.195993261556)*x[1]
        ref[0, 2, 0, 0]=-0.133269589645*o*x_ref[0]**(o-1)+(-0.521490067085)
        ref[0, 2, 0, 1]=-0.470507869048*o*x_ref[1]**(o-1)+(-0.195993261556)
        arg[0, 2, 1]=0.068155508654*x[0]**o+(0.191062183217)*x[0]+(-0.382370929119)*x[1]**o+(0.305850925352)*x[1]
        ref[0, 2, 1, 0]=0.068155508654*o*x_ref[0]**(o-1)+(0.191062183217)
        ref[0, 2, 1, 1]=-0.382370929119*o*x_ref[1]**(o-1)+(0.305850925352)
        arg[0, 2, 2]=-0.771696474911*x[0]**o+(-0.00764821918108)*x[0]+(-0.0801266753371)*x[1]**o+(0.527152995017)*x[1]
        ref[0, 2, 2, 0]=-0.771696474911*o*x_ref[0]**(o-1)+(-0.00764821918108)
        ref[0, 2, 2, 1]=-0.0801266753371*o*x_ref[1]**(o-1)+(0.527152995017)
        arg[0, 2, 3]=-0.705997909702*x[0]**o+(0.971187261998)*x[0]+(-0.841873792477)*x[1]**o+(0.194224658033)*x[1]
        ref[0, 2, 3, 0]=-0.705997909702*o*x_ref[0]**(o-1)+(0.971187261998)
        ref[0, 2, 3, 1]=-0.841873792477*o*x_ref[1]**(o-1)+(0.194224658033)
        arg[0, 3, 0]=-0.0464881756423*x[0]**o+(0.0375302765887)*x[0]+(0.0148568753128)*x[1]**o+(-0.226034621134)*x[1]
        ref[0, 3, 0, 0]=-0.0464881756423*o*x_ref[0]**(o-1)+(0.0375302765887)
        ref[0, 3, 0, 1]=0.0148568753128*o*x_ref[1]**(o-1)+(-0.226034621134)
        arg[0, 3, 1]=-0.525804375198*x[0]**o+(0.69074202893)*x[0]+(0.187602634489)*x[1]**o+(-0.568089322045)*x[1]
        ref[0, 3, 1, 0]=-0.525804375198*o*x_ref[0]**(o-1)+(0.69074202893)
        ref[0, 3, 1, 1]=0.187602634489*o*x_ref[1]**(o-1)+(-0.568089322045)
        arg[0, 3, 2]=-0.511947368054*x[0]**o+(-0.463338804694)*x[0]+(0.899314074302)*x[1]**o+(-0.728179195856)*x[1]
        ref[0, 3, 2, 0]=-0.511947368054*o*x_ref[0]**(o-1)+(-0.463338804694)
        ref[0, 3, 2, 1]=0.899314074302*o*x_ref[1]**(o-1)+(-0.728179195856)
        arg[0, 3, 3]=0.573782010874*x[0]**o+(0.637726624764)*x[0]+(-0.369778590369)*x[1]**o+(0.240568206839)*x[1]
        ref[0, 3, 3, 0]=0.573782010874*o*x_ref[0]**(o-1)+(0.637726624764)
        ref[0, 3, 3, 1]=-0.369778590369*o*x_ref[1]**(o-1)+(0.240568206839)
        arg[1, 0, 0]=0.17497277886*x[0]**o+(0.127296628246)*x[0]+(0.296811682365)*x[1]**o+(-0.448990146071)*x[1]
        ref[1, 0, 0, 0]=0.17497277886*o*x_ref[0]**(o-1)+(0.127296628246)
        ref[1, 0, 0, 1]=0.296811682365*o*x_ref[1]**(o-1)+(-0.448990146071)
        arg[1, 0, 1]=-0.769485000536*x[0]**o+(0.220784709468)*x[0]+(-0.62406194198)*x[1]**o+(-0.53631590544)*x[1]
        ref[1, 0, 1, 0]=-0.769485000536*o*x_ref[0]**(o-1)+(0.220784709468)
        ref[1, 0, 1, 1]=-0.62406194198*o*x_ref[1]**(o-1)+(-0.53631590544)
        arg[1, 0, 2]=-0.268928560315*x[0]**o+(0.9270476958)*x[0]+(-0.226599181601)*x[1]**o+(0.577493050858)*x[1]
        ref[1, 0, 2, 0]=-0.268928560315*o*x_ref[0]**(o-1)+(0.9270476958)
        ref[1, 0, 2, 1]=-0.226599181601*o*x_ref[1]**(o-1)+(0.577493050858)
        arg[1, 0, 3]=-0.465799942562*x[0]**o+(-0.49232903903)*x[0]+(-0.670495155568)*x[1]**o+(0.0480742920114)*x[1]
        ref[1, 0, 3, 0]=-0.465799942562*o*x_ref[0]**(o-1)+(-0.49232903903)
        ref[1, 0, 3, 1]=-0.670495155568*o*x_ref[1]**(o-1)+(0.0480742920114)
        arg[1, 1, 0]=-0.0829901942771*x[0]**o+(-0.677405783448)*x[0]+(-0.232233179805)*x[1]**o+(-0.878585232044)*x[1]
        ref[1, 1, 0, 0]=-0.0829901942771*o*x_ref[0]**(o-1)+(-0.677405783448)
        ref[1, 1, 0, 1]=-0.232233179805*o*x_ref[1]**(o-1)+(-0.878585232044)
        arg[1, 1, 1]=-0.428594352271*x[0]**o+(-0.487452402687)*x[0]+(-0.56521288012)*x[1]**o+(-0.208688823368)*x[1]
        ref[1, 1, 1, 0]=-0.428594352271*o*x_ref[0]**(o-1)+(-0.487452402687)
        ref[1, 1, 1, 1]=-0.56521288012*o*x_ref[1]**(o-1)+(-0.208688823368)
        arg[1, 1, 2]=0.178009408445*x[0]**o+(-0.0170168047441)*x[0]+(0.623756510102)*x[1]**o+(-0.422009855586)*x[1]
        ref[1, 1, 2, 0]=0.178009408445*o*x_ref[0]**(o-1)+(-0.0170168047441)
        ref[1, 1, 2, 1]=0.623756510102*o*x_ref[1]**(o-1)+(-0.422009855586)
        arg[1, 1, 3]=0.352894782884*x[0]**o+(0.656598704705)*x[0]+(0.528471251847)*x[1]**o+(0.191705229933)*x[1]
        ref[1, 1, 3, 0]=0.352894782884*o*x_ref[0]**(o-1)+(0.656598704705)
        ref[1, 1, 3, 1]=0.528471251847*o*x_ref[1]**(o-1)+(0.191705229933)
        arg[1, 2, 0]=0.0980116016865*x[0]**o+(-0.525092807843)*x[0]+(0.647253297391)*x[1]**o+(-0.87703688463)*x[1]
        ref[1, 2, 0, 0]=0.0980116016865*o*x_ref[0]**(o-1)+(-0.525092807843)
        ref[1, 2, 0, 1]=0.647253297391*o*x_ref[1]**(o-1)+(-0.87703688463)
        arg[1, 2, 1]=0.647267538024*x[0]**o+(-0.380655967843)*x[0]+(0.724426392823)*x[1]**o+(0.0313324940667)*x[1]
        ref[1, 2, 1, 0]=0.647267538024*o*x_ref[0]**(o-1)+(-0.380655967843)
        ref[1, 2, 1, 1]=0.724426392823*o*x_ref[1]**(o-1)+(0.0313324940667)
        arg[1, 2, 2]=0.991943970062*x[0]**o+(-0.326495948622)*x[0]+(0.06653468572)*x[1]**o+(-0.706576582437)*x[1]
        ref[1, 2, 2, 0]=0.991943970062*o*x_ref[0]**(o-1)+(-0.326495948622)
        ref[1, 2, 2, 1]=0.06653468572*o*x_ref[1]**(o-1)+(-0.706576582437)
        arg[1, 2, 3]=0.317356696337*x[0]**o+(-0.484689216709)*x[0]+(-0.654225619519)*x[1]**o+(-0.177035371712)*x[1]
        ref[1, 2, 3, 0]=0.317356696337*o*x_ref[0]**(o-1)+(-0.484689216709)
        ref[1, 2, 3, 1]=-0.654225619519*o*x_ref[1]**(o-1)+(-0.177035371712)
        arg[1, 3, 0]=-0.919906282891*x[0]**o+(-0.220258859624)*x[0]+(0.573634356161)*x[1]**o+(0.427610605468)*x[1]
        ref[1, 3, 0, 0]=-0.919906282891*o*x_ref[0]**(o-1)+(-0.220258859624)
        ref[1, 3, 0, 1]=0.573634356161*o*x_ref[1]**(o-1)+(0.427610605468)
        arg[1, 3, 1]=-0.00417917174463*x[0]**o+(-0.910661364218)*x[0]+(0.93426839231)*x[1]**o+(0.258376224828)*x[1]
        ref[1, 3, 1, 0]=-0.00417917174463*o*x_ref[0]**(o-1)+(-0.910661364218)
        ref[1, 3, 1, 1]=0.93426839231*o*x_ref[1]**(o-1)+(0.258376224828)
        arg[1, 3, 2]=-0.728191179178*x[0]**o+(-0.131324333553)*x[0]+(0.0686982665418)*x[1]**o+(0.738699756977)*x[1]
        ref[1, 3, 2, 0]=-0.728191179178*o*x_ref[0]**(o-1)+(-0.131324333553)
        ref[1, 3, 2, 1]=0.0686982665418*o*x_ref[1]**(o-1)+(0.738699756977)
        arg[1, 3, 3]=-0.655289973694*x[0]**o+(0.687641461714)*x[0]+(-0.746847271494)*x[1]**o+(0.913798694509)*x[1]
        ref[1, 3, 3, 0]=-0.655289973694*o*x_ref[0]**(o-1)+(0.687641461714)
        ref[1, 3, 3, 1]=-0.746847271494*o*x_ref[1]**(o-1)+(0.913798694509)
        arg[2, 0, 0]=0.683367462192*x[0]**o+(0.000867896927055)*x[0]+(-0.203355713541)*x[1]**o+(-0.520230555011)*x[1]
        ref[2, 0, 0, 0]=0.683367462192*o*x_ref[0]**(o-1)+(0.000867896927055)
        ref[2, 0, 0, 1]=-0.203355713541*o*x_ref[1]**(o-1)+(-0.520230555011)
        arg[2, 0, 1]=0.697747240913*x[0]**o+(0.925651598956)*x[0]+(-0.237177509445)*x[1]**o+(-0.540771424201)*x[1]
        ref[2, 0, 1, 0]=0.697747240913*o*x_ref[0]**(o-1)+(0.925651598956)
        ref[2, 0, 1, 1]=-0.237177509445*o*x_ref[1]**(o-1)+(-0.540771424201)
        arg[2, 0, 2]=0.103995639201*x[0]**o+(-0.427785570485)*x[0]+(-0.793743416776)*x[1]**o+(0.399898913838)*x[1]
        ref[2, 0, 2, 0]=0.103995639201*o*x_ref[0]**(o-1)+(-0.427785570485)
        ref[2, 0, 2, 1]=-0.793743416776*o*x_ref[1]**(o-1)+(0.399898913838)
        arg[2, 0, 3]=0.926107311217*x[0]**o+(-0.409082618651)*x[0]+(-0.669349218611)*x[1]**o+(-0.647119064264)*x[1]
        ref[2, 0, 3, 0]=0.926107311217*o*x_ref[0]**(o-1)+(-0.409082618651)
        ref[2, 0, 3, 1]=-0.669349218611*o*x_ref[1]**(o-1)+(-0.647119064264)
        arg[2, 1, 0]=0.810534036705*x[0]**o+(-0.434754590585)*x[0]+(0.797516455773)*x[1]**o+(-0.186773843181)*x[1]
        ref[2, 1, 0, 0]=0.810534036705*o*x_ref[0]**(o-1)+(-0.434754590585)
        ref[2, 1, 0, 1]=0.797516455773*o*x_ref[1]**(o-1)+(-0.186773843181)
        arg[2, 1, 1]=-0.851110437401*x[0]**o+(-0.117906921064)*x[0]+(0.776246008781)*x[1]**o+(0.498190907433)*x[1]
        ref[2, 1, 1, 0]=-0.851110437401*o*x_ref[0]**(o-1)+(-0.117906921064)
        ref[2, 1, 1, 1]=0.776246008781*o*x_ref[1]**(o-1)+(0.498190907433)
        arg[2, 1, 2]=-0.245922237623*x[0]**o+(0.394303859672)*x[0]+(-0.0902809657716)*x[1]**o+(0.691205444329)*x[1]
        ref[2, 1, 2, 0]=-0.245922237623*o*x_ref[0]**(o-1)+(0.394303859672)
        ref[2, 1, 2, 1]=-0.0902809657716*o*x_ref[1]**(o-1)+(0.691205444329)
        arg[2, 1, 3]=0.124197323764*x[0]**o+(0.545488478913)*x[0]+(-0.58401231205)*x[1]**o+(0.744063287683)*x[1]
        ref[2, 1, 3, 0]=0.124197323764*o*x_ref[0]**(o-1)+(0.545488478913)
        ref[2, 1, 3, 1]=-0.58401231205*o*x_ref[1]**(o-1)+(0.744063287683)
        arg[2, 2, 0]=-0.593944177098*x[0]**o+(0.927065884016)*x[0]+(-0.446860404334)*x[1]**o+(0.959427981842)*x[1]
        ref[2, 2, 0, 0]=-0.593944177098*o*x_ref[0]**(o-1)+(0.927065884016)
        ref[2, 2, 0, 1]=-0.446860404334*o*x_ref[1]**(o-1)+(0.959427981842)
        arg[2, 2, 1]=0.977253490291*x[0]**o+(0.310711704751)*x[0]+(0.946846725723)*x[1]**o+(0.465272065684)*x[1]
        ref[2, 2, 1, 0]=0.977253490291*o*x_ref[0]**(o-1)+(0.310711704751)
        ref[2, 2, 1, 1]=0.946846725723*o*x_ref[1]**(o-1)+(0.465272065684)
        arg[2, 2, 2]=0.931503539781*x[0]**o+(-0.277374441254)*x[0]+(-0.442351604964)*x[1]**o+(0.813384699611)*x[1]
        ref[2, 2, 2, 0]=0.931503539781*o*x_ref[0]**(o-1)+(-0.277374441254)
        ref[2, 2, 2, 1]=-0.442351604964*o*x_ref[1]**(o-1)+(0.813384699611)
        arg[2, 2, 3]=-0.340005635696*x[0]**o+(-0.271026224141)*x[0]+(-0.983312826044)*x[1]**o+(0.399694538662)*x[1]
        ref[2, 2, 3, 0]=-0.340005635696*o*x_ref[0]**(o-1)+(-0.271026224141)
        ref[2, 2, 3, 1]=-0.983312826044*o*x_ref[1]**(o-1)+(0.399694538662)
        arg[2, 3, 0]=0.938598701928*x[0]**o+(-0.610155573277)*x[0]+(-0.423699252913)*x[1]**o+(-0.971998264119)*x[1]
        ref[2, 3, 0, 0]=0.938598701928*o*x_ref[0]**(o-1)+(-0.610155573277)
        ref[2, 3, 0, 1]=-0.423699252913*o*x_ref[1]**(o-1)+(-0.971998264119)
        arg[2, 3, 1]=0.692791075271*x[0]**o+(0.3768950788)*x[0]+(-0.976160912062)*x[1]**o+(-0.78326062973)*x[1]
        ref[2, 3, 1, 0]=0.692791075271*o*x_ref[0]**(o-1)+(0.3768950788)
        ref[2, 3, 1, 1]=-0.976160912062*o*x_ref[1]**(o-1)+(-0.78326062973)
        arg[2, 3, 2]=-0.547576290971*x[0]**o+(-0.406516454564)*x[0]+(-0.12382235162)*x[1]**o+(0.978351615071)*x[1]
        ref[2, 3, 2, 0]=-0.547576290971*o*x_ref[0]**(o-1)+(-0.406516454564)
        ref[2, 3, 2, 1]=-0.12382235162*o*x_ref[1]**(o-1)+(0.978351615071)
        arg[2, 3, 3]=0.659739006764*x[0]**o+(0.967266140077)*x[0]+(-0.485297784748)*x[1]**o+(-0.843434887911)*x[1]
        ref[2, 3, 3, 0]=0.659739006764*o*x_ref[0]**(o-1)+(0.967266140077)
        ref[2, 3, 3, 1]=-0.485297784748*o*x_ref[1]**(o-1)+(-0.843434887911)
        if dim==3:
            arg[0, 0, 0]+=-0.237001064047*x[2]**o+(-0.679698964345)*x[2]
            ref[0, 0, 0, 2]=-0.237001064047*o*x_ref[2]**(o-1)+(-0.679698964345)
            arg[0, 0, 1]+=0.200657795817*x[2]**o+(-0.0546123212034)*x[2]
            ref[0, 0, 1, 2]=0.200657795817*o*x_ref[2]**(o-1)+(-0.0546123212034)
            arg[0, 0, 2]+=0.724319470054*x[2]**o+(-0.51951773839)*x[2]
            ref[0, 0, 2, 2]=0.724319470054*o*x_ref[2]**(o-1)+(-0.51951773839)
            arg[0, 0, 3]+=0.253904117303*x[2]**o+(-0.374211090927)*x[2]
            ref[0, 0, 3, 2]=0.253904117303*o*x_ref[2]**(o-1)+(-0.374211090927)
            arg[0, 1, 0]+=-0.865165895746*x[2]**o+(-0.214304242227)*x[2]
            ref[0, 1, 0, 2]=-0.865165895746*o*x_ref[2]**(o-1)+(-0.214304242227)
            arg[0, 1, 1]+=-0.898767453636*x[2]**o+(0.444108033102)*x[2]
            ref[0, 1, 1, 2]=-0.898767453636*o*x_ref[2]**(o-1)+(0.444108033102)
            arg[0, 1, 2]+=0.293046216854*x[2]**o+(-0.0803960511794)*x[2]
            ref[0, 1, 2, 2]=0.293046216854*o*x_ref[2]**(o-1)+(-0.0803960511794)
            arg[0, 1, 3]+=0.351107725194*x[2]**o+(0.452074342873)*x[2]
            ref[0, 1, 3, 2]=0.351107725194*o*x_ref[2]**(o-1)+(0.452074342873)
            arg[0, 2, 0]+=0.435816558313*x[2]**o+(0.043064921932)*x[2]
            ref[0, 2, 0, 2]=0.435816558313*o*x_ref[2]**(o-1)+(0.043064921932)
            arg[0, 2, 1]+=-0.136587816885*x[2]**o+(0.286329646355)*x[2]
            ref[0, 2, 1, 2]=-0.136587816885*o*x_ref[2]**(o-1)+(0.286329646355)
            arg[0, 2, 2]+=-0.408304969375*x[2]**o+(0.678381126987)*x[2]
            ref[0, 2, 2, 2]=-0.408304969375*o*x_ref[2]**(o-1)+(0.678381126987)
            arg[0, 2, 3]+=0.596485344115*x[2]**o+(-0.421964692876)*x[2]
            ref[0, 2, 3, 2]=0.596485344115*o*x_ref[2]**(o-1)+(-0.421964692876)
            arg[0, 3, 0]+=0.214388943927*x[2]**o+(0.289272339116)*x[2]
            ref[0, 3, 0, 2]=0.214388943927*o*x_ref[2]**(o-1)+(0.289272339116)
            arg[0, 3, 1]+=0.784923494486*x[2]**o+(0.441666291202)*x[2]
            ref[0, 3, 1, 2]=0.784923494486*o*x_ref[2]**(o-1)+(0.441666291202)
            arg[0, 3, 2]+=0.61266319611*x[2]**o+(-0.0227373540544)*x[2]
            ref[0, 3, 2, 2]=0.61266319611*o*x_ref[2]**(o-1)+(-0.0227373540544)
            arg[0, 3, 3]+=0.894468357814*x[2]**o+(0.21416535986)*x[2]
            ref[0, 3, 3, 2]=0.894468357814*o*x_ref[2]**(o-1)+(0.21416535986)
            arg[1, 0, 0]+=0.837980628694*x[2]**o+(-0.755819243934)*x[2]
            ref[1, 0, 0, 2]=0.837980628694*o*x_ref[2]**(o-1)+(-0.755819243934)
            arg[1, 0, 1]+=0.201038262282*x[2]**o+(-0.36712853617)*x[2]
            ref[1, 0, 1, 2]=0.201038262282*o*x_ref[2]**(o-1)+(-0.36712853617)
            arg[1, 0, 2]+=-0.0530151577496*x[2]**o+(-0.858333271294)*x[2]
            ref[1, 0, 2, 2]=-0.0530151577496*o*x_ref[2]**(o-1)+(-0.858333271294)
            arg[1, 0, 3]+=-0.224671926105*x[2]**o+(-0.372162591489)*x[2]
            ref[1, 0, 3, 2]=-0.224671926105*o*x_ref[2]**(o-1)+(-0.372162591489)
            arg[1, 1, 0]+=-0.304642260931*x[2]**o+(-0.424475157691)*x[2]
            ref[1, 1, 0, 2]=-0.304642260931*o*x_ref[2]**(o-1)+(-0.424475157691)
            arg[1, 1, 1]+=-0.376683118286*x[2]**o+(-0.782146507114)*x[2]
            ref[1, 1, 1, 2]=-0.376683118286*o*x_ref[2]**(o-1)+(-0.782146507114)
            arg[1, 1, 2]+=-0.0884171806612*x[2]**o+(0.198822979803)*x[2]
            ref[1, 1, 2, 2]=-0.0884171806612*o*x_ref[2]**(o-1)+(0.198822979803)
            arg[1, 1, 3]+=0.0896104489248*x[2]**o+(-0.262921532144)*x[2]
            ref[1, 1, 3, 2]=0.0896104489248*o*x_ref[2]**(o-1)+(-0.262921532144)
            arg[1, 2, 0]+=-0.862394114381*x[2]**o+(-0.274126738578)*x[2]
            ref[1, 2, 0, 2]=-0.862394114381*o*x_ref[2]**(o-1)+(-0.274126738578)
            arg[1, 2, 1]+=-0.581696061928*x[2]**o+(-0.10110023816)*x[2]
            ref[1, 2, 1, 2]=-0.581696061928*o*x_ref[2]**(o-1)+(-0.10110023816)
            arg[1, 2, 2]+=-0.746054244533*x[2]**o+(-0.388319625983)*x[2]
            ref[1, 2, 2, 2]=-0.746054244533*o*x_ref[2]**(o-1)+(-0.388319625983)
            arg[1, 2, 3]+=-0.941156742343*x[2]**o+(0.635707298062)*x[2]
            ref[1, 2, 3, 2]=-0.941156742343*o*x_ref[2]**(o-1)+(0.635707298062)
            arg[1, 3, 0]+=-0.485742319955*x[2]**o+(0.273295466272)*x[2]
            ref[1, 3, 0, 2]=-0.485742319955*o*x_ref[2]**(o-1)+(0.273295466272)
            arg[1, 3, 1]+=0.755842531877*x[2]**o+(-0.085940978802)*x[2]
            ref[1, 3, 1, 2]=0.755842531877*o*x_ref[2]**(o-1)+(-0.085940978802)
            arg[1, 3, 2]+=-0.670700934099*x[2]**o+(0.569489523477)*x[2]
            ref[1, 3, 2, 2]=-0.670700934099*o*x_ref[2]**(o-1)+(0.569489523477)
            arg[1, 3, 3]+=0.341930523809*x[2]**o+(-0.19684395882)*x[2]
            ref[1, 3, 3, 2]=0.341930523809*o*x_ref[2]**(o-1)+(-0.19684395882)
            arg[2, 0, 0]+=-0.88460946352*x[2]**o+(-0.953766710828)*x[2]
            ref[2, 0, 0, 2]=-0.88460946352*o*x_ref[2]**(o-1)+(-0.953766710828)
            arg[2, 0, 1]+=-0.156744341067*x[2]**o+(0.50169327835)*x[2]
            ref[2, 0, 1, 2]=-0.156744341067*o*x_ref[2]**(o-1)+(0.50169327835)
            arg[2, 0, 2]+=-0.690124252277*x[2]**o+(-0.0541140976202)*x[2]
            ref[2, 0, 2, 2]=-0.690124252277*o*x_ref[2]**(o-1)+(-0.0541140976202)
            arg[2, 0, 3]+=-0.481808314191*x[2]**o+(-0.410491944335)*x[2]
            ref[2, 0, 3, 2]=-0.481808314191*o*x_ref[2]**(o-1)+(-0.410491944335)
            arg[2, 1, 0]+=-0.0658414258249*x[2]**o+(-0.357785093977)*x[2]
            ref[2, 1, 0, 2]=-0.0658414258249*o*x_ref[2]**(o-1)+(-0.357785093977)
            arg[2, 1, 1]+=-0.194714756861*x[2]**o+(-0.38611091308)*x[2]
            ref[2, 1, 1, 2]=-0.194714756861*o*x_ref[2]**(o-1)+(-0.38611091308)
            arg[2, 1, 2]+=-0.864136522859*x[2]**o+(0.184896646788)*x[2]
            ref[2, 1, 2, 2]=-0.864136522859*o*x_ref[2]**(o-1)+(0.184896646788)
            arg[2, 1, 3]+=-0.409132400811*x[2]**o+(-0.477965316045)*x[2]
            ref[2, 1, 3, 2]=-0.409132400811*o*x_ref[2]**(o-1)+(-0.477965316045)
            arg[2, 2, 0]+=0.327906541985*x[2]**o+(-0.98313616629)*x[2]
            ref[2, 2, 0, 2]=0.327906541985*o*x_ref[2]**(o-1)+(-0.98313616629)
            arg[2, 2, 1]+=0.815088496192*x[2]**o+(-0.404789424535)*x[2]
            ref[2, 2, 1, 2]=0.815088496192*o*x_ref[2]**(o-1)+(-0.404789424535)
            arg[2, 2, 2]+=-0.738596269531*x[2]**o+(-0.651871064495)*x[2]
            ref[2, 2, 2, 2]=-0.738596269531*o*x_ref[2]**(o-1)+(-0.651871064495)
            arg[2, 2, 3]+=-0.492848963439*x[2]**o+(0.381118599796)*x[2]
            ref[2, 2, 3, 2]=-0.492848963439*o*x_ref[2]**(o-1)+(0.381118599796)
            arg[2, 3, 0]+=-0.755714213522*x[2]**o+(-0.49787613725)*x[2]
            ref[2, 3, 0, 2]=-0.755714213522*o*x_ref[2]**(o-1)+(-0.49787613725)
            arg[2, 3, 1]+=0.589571004674*x[2]**o+(-0.934085572504)*x[2]
            ref[2, 3, 1, 2]=0.589571004674*o*x_ref[2]**(o-1)+(-0.934085572504)
            arg[2, 3, 2]+=0.265270696335*x[2]**o+(-0.662032789357)*x[2]
            ref[2, 3, 2, 2]=0.265270696335*o*x_ref[2]**(o-1)+(-0.662032789357)
            arg[2, 3, 3]+=-0.864049964987*x[2]**o+(0.596180959552)*x[2]
            ref[2, 3, 3, 2]=-0.864049964987*o*x_ref[2]**(o-1)+(0.596180959552)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3, 4, 4)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onReducedFunction_fromData_Solution_rank0(self):
        """
        tests gradient of rank 0 Data on ReducedFunction

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=0.0726837738806*x[0]**o+(0.777968181025)*x[0]+(-0.557134856822)*x[1]**o+(0.180673106459)*x[1]
        ref[0]=0.0726837738806*o*x_ref[0]**(o-1)+(0.777968181025)
        ref[1]=-0.557134856822*o*x_ref[1]**(o-1)+(0.180673106459)
        if dim==3:
            arg+=(-0.950679335775)*x[2]**o+(-0.289133051123)*x[2]
            ref[2]=-0.950679335775*o*x_ref[2]**(o-1)+(-0.289133051123)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onReducedFunction_fromData_Solution_rank1(self):
        """
        tests gradient of rank 1 Data on ReducedFunction

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(4,),w)
        ref = Data(0,(4,)+(dim,),w_ref)
        arg[0,]=-0.696164174885*x[0]**o+(0.856167514053)*x[0]+(0.0657123288504)*x[1]**o+(-0.998686592749)*x[1]
        ref[0, 0]=-0.696164174885*o*x_ref[0]**(o-1)+(0.856167514053)
        ref[0, 1]=0.0657123288504*o*x_ref[1]**(o-1)+(-0.998686592749)
        arg[1,]=-0.441594351987*x[0]**o+(-0.869787102603)*x[0]+(0.453167049537)*x[1]**o+(-0.994480181798)*x[1]
        ref[1, 0]=-0.441594351987*o*x_ref[0]**(o-1)+(-0.869787102603)
        ref[1, 1]=0.453167049537*o*x_ref[1]**(o-1)+(-0.994480181798)
        arg[2,]=-0.490574343073*x[0]**o+(-0.961657806717)*x[0]+(0.308464705727)*x[1]**o+(-0.680804116705)*x[1]
        ref[2, 0]=-0.490574343073*o*x_ref[0]**(o-1)+(-0.961657806717)
        ref[2, 1]=0.308464705727*o*x_ref[1]**(o-1)+(-0.680804116705)
        arg[3,]=-0.189904034988*x[0]**o+(-0.650114090432)*x[0]+(0.523291218569)*x[1]**o+(0.338852412448)*x[1]
        ref[3, 0]=-0.189904034988*o*x_ref[0]**(o-1)+(-0.650114090432)
        ref[3, 1]=0.523291218569*o*x_ref[1]**(o-1)+(0.338852412448)
        if dim==3:
            arg[0,]+=0.0899014993799*x[2]**o+(0.0743571579567)*x[2]
            ref[0, 2]=0.0899014993799*o*x_ref[2]**(o-1)+(0.0743571579567)
            arg[1,]+=0.477928022455*x[2]**o+(-0.190040112028)*x[2]
            ref[1, 2]=0.477928022455*o*x_ref[2]**(o-1)+(-0.190040112028)
            arg[2,]+=-0.488171239162*x[2]**o+(-0.745196703218)*x[2]
            ref[2, 2]=-0.488171239162*o*x_ref[2]**(o-1)+(-0.745196703218)
            arg[3,]+=0.951582933836*x[2]**o+(-0.75299500436)*x[2]
            ref[3, 2]=0.951582933836*o*x_ref[2]**(o-1)+(-0.75299500436)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onReducedFunction_fromData_Solution_rank2(self):
        """
        tests gradient of rank 2 Data on ReducedFunction

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(4, 4),w)
        ref = Data(0,(4, 4)+(dim,),w_ref)
        arg[0, 0]=0.865784545599*x[0]**o+(-0.54513382524)*x[0]+(-0.571448957672)*x[1]**o+(0.929923236032)*x[1]
        ref[0, 0, 0]=0.865784545599*o*x_ref[0]**(o-1)+(-0.54513382524)
        ref[0, 0, 1]=-0.571448957672*o*x_ref[1]**(o-1)+(0.929923236032)
        arg[0, 1]=0.676657142109*x[0]**o+(0.987548850225)*x[0]+(-0.370320596588)*x[1]**o+(-0.414269803532)*x[1]
        ref[0, 1, 0]=0.676657142109*o*x_ref[0]**(o-1)+(0.987548850225)
        ref[0, 1, 1]=-0.370320596588*o*x_ref[1]**(o-1)+(-0.414269803532)
        arg[0, 2]=-0.233699621407*x[0]**o+(-0.8680467727)*x[0]+(-0.137949398755)*x[1]**o+(-0.463885424036)*x[1]
        ref[0, 2, 0]=-0.233699621407*o*x_ref[0]**(o-1)+(-0.8680467727)
        ref[0, 2, 1]=-0.137949398755*o*x_ref[1]**(o-1)+(-0.463885424036)
        arg[0, 3]=-0.296810994896*x[0]**o+(-0.708305727014)*x[0]+(-0.538048423108)*x[1]**o+(-0.905829517925)*x[1]
        ref[0, 3, 0]=-0.296810994896*o*x_ref[0]**(o-1)+(-0.708305727014)
        ref[0, 3, 1]=-0.538048423108*o*x_ref[1]**(o-1)+(-0.905829517925)
        arg[1, 0]=-0.255097631461*x[0]**o+(0.769395362787)*x[0]+(0.105528433687)*x[1]**o+(-0.616730492933)*x[1]
        ref[1, 0, 0]=-0.255097631461*o*x_ref[0]**(o-1)+(0.769395362787)
        ref[1, 0, 1]=0.105528433687*o*x_ref[1]**(o-1)+(-0.616730492933)
        arg[1, 1]=0.614470946833*x[0]**o+(-0.6589661182)*x[0]+(-0.280908785772)*x[1]**o+(-0.555566228524)*x[1]
        ref[1, 1, 0]=0.614470946833*o*x_ref[0]**(o-1)+(-0.6589661182)
        ref[1, 1, 1]=-0.280908785772*o*x_ref[1]**(o-1)+(-0.555566228524)
        arg[1, 2]=-0.464803507034*x[0]**o+(-0.366440713591)*x[0]+(-0.407094872473)*x[1]**o+(0.786952704428)*x[1]
        ref[1, 2, 0]=-0.464803507034*o*x_ref[0]**(o-1)+(-0.366440713591)
        ref[1, 2, 1]=-0.407094872473*o*x_ref[1]**(o-1)+(0.786952704428)
        arg[1, 3]=0.873162481339*x[0]**o+(0.437782693112)*x[0]+(0.625423562618)*x[1]**o+(0.817147604728)*x[1]
        ref[1, 3, 0]=0.873162481339*o*x_ref[0]**(o-1)+(0.437782693112)
        ref[1, 3, 1]=0.625423562618*o*x_ref[1]**(o-1)+(0.817147604728)
        arg[2, 0]=-0.126947310333*x[0]**o+(0.712865273801)*x[0]+(0.339582565163)*x[1]**o+(-0.707462720673)*x[1]
        ref[2, 0, 0]=-0.126947310333*o*x_ref[0]**(o-1)+(0.712865273801)
        ref[2, 0, 1]=0.339582565163*o*x_ref[1]**(o-1)+(-0.707462720673)
        arg[2, 1]=-0.174436692934*x[0]**o+(0.337586385684)*x[0]+(-0.700820207733)*x[1]**o+(0.821175718763)*x[1]
        ref[2, 1, 0]=-0.174436692934*o*x_ref[0]**(o-1)+(0.337586385684)
        ref[2, 1, 1]=-0.700820207733*o*x_ref[1]**(o-1)+(0.821175718763)
        arg[2, 2]=-0.815158522651*x[0]**o+(0.165757349141)*x[0]+(0.913551373708)*x[1]**o+(-0.966924696273)*x[1]
        ref[2, 2, 0]=-0.815158522651*o*x_ref[0]**(o-1)+(0.165757349141)
        ref[2, 2, 1]=0.913551373708*o*x_ref[1]**(o-1)+(-0.966924696273)
        arg[2, 3]=-0.467617908158*x[0]**o+(-0.409148268416)*x[0]+(-0.953985332165)*x[1]**o+(0.293598495541)*x[1]
        ref[2, 3, 0]=-0.467617908158*o*x_ref[0]**(o-1)+(-0.409148268416)
        ref[2, 3, 1]=-0.953985332165*o*x_ref[1]**(o-1)+(0.293598495541)
        arg[3, 0]=-0.67876744337*x[0]**o+(-0.0154663671456)*x[0]+(0.485586969394)*x[1]**o+(-0.526553593268)*x[1]
        ref[3, 0, 0]=-0.67876744337*o*x_ref[0]**(o-1)+(-0.0154663671456)
        ref[3, 0, 1]=0.485586969394*o*x_ref[1]**(o-1)+(-0.526553593268)
        arg[3, 1]=-0.0508078077741*x[0]**o+(-0.0545467688374)*x[0]+(0.311058235876)*x[1]**o+(-0.582666222298)*x[1]
        ref[3, 1, 0]=-0.0508078077741*o*x_ref[0]**(o-1)+(-0.0545467688374)
        ref[3, 1, 1]=0.311058235876*o*x_ref[1]**(o-1)+(-0.582666222298)
        arg[3, 2]=0.961229012546*x[0]**o+(0.120856686419)*x[0]+(-0.810691453221)*x[1]**o+(0.80371874244)*x[1]
        ref[3, 2, 0]=0.961229012546*o*x_ref[0]**(o-1)+(0.120856686419)
        ref[3, 2, 1]=-0.810691453221*o*x_ref[1]**(o-1)+(0.80371874244)
        arg[3, 3]=-0.0451637489016*x[0]**o+(0.717749081458)*x[0]+(-0.955707517164)*x[1]**o+(-0.453903744805)*x[1]
        ref[3, 3, 0]=-0.0451637489016*o*x_ref[0]**(o-1)+(0.717749081458)
        ref[3, 3, 1]=-0.955707517164*o*x_ref[1]**(o-1)+(-0.453903744805)
        if dim==3:
            arg[0, 0]+=-0.282959662013*x[2]**o+(0.235710527656)*x[2]
            ref[0, 0, 2]=-0.282959662013*o*x_ref[2]**(o-1)+(0.235710527656)
            arg[0, 1]+=-0.107736108161*x[2]**o+(0.42888129889)*x[2]
            ref[0, 1, 2]=-0.107736108161*o*x_ref[2]**(o-1)+(0.42888129889)
            arg[0, 2]+=0.0247441262166*x[2]**o+(-0.350614242913)*x[2]
            ref[0, 2, 2]=0.0247441262166*o*x_ref[2]**(o-1)+(-0.350614242913)
            arg[0, 3]+=-0.785883813639*x[2]**o+(0.982828623081)*x[2]
            ref[0, 3, 2]=-0.785883813639*o*x_ref[2]**(o-1)+(0.982828623081)
            arg[1, 0]+=-0.330233417206*x[2]**o+(0.966431127843)*x[2]
            ref[1, 0, 2]=-0.330233417206*o*x_ref[2]**(o-1)+(0.966431127843)
            arg[1, 1]+=-0.184167817834*x[2]**o+(-0.404750146883)*x[2]
            ref[1, 1, 2]=-0.184167817834*o*x_ref[2]**(o-1)+(-0.404750146883)
            arg[1, 2]+=-0.566544855907*x[2]**o+(0.532353717488)*x[2]
            ref[1, 2, 2]=-0.566544855907*o*x_ref[2]**(o-1)+(0.532353717488)
            arg[1, 3]+=-0.0262099960824*x[2]**o+(0.367207650072)*x[2]
            ref[1, 3, 2]=-0.0262099960824*o*x_ref[2]**(o-1)+(0.367207650072)
            arg[2, 0]+=0.389037050288*x[2]**o+(-0.221755578535)*x[2]
            ref[2, 0, 2]=0.389037050288*o*x_ref[2]**(o-1)+(-0.221755578535)
            arg[2, 1]+=-0.0876562486571*x[2]**o+(-0.405254835995)*x[2]
            ref[2, 1, 2]=-0.0876562486571*o*x_ref[2]**(o-1)+(-0.405254835995)
            arg[2, 2]+=0.408304066402*x[2]**o+(-0.142503798933)*x[2]
            ref[2, 2, 2]=0.408304066402*o*x_ref[2]**(o-1)+(-0.142503798933)
            arg[2, 3]+=0.358905937388*x[2]**o+(-0.144745683941)*x[2]
            ref[2, 3, 2]=0.358905937388*o*x_ref[2]**(o-1)+(-0.144745683941)
            arg[3, 0]+=-0.770790546693*x[2]**o+(0.218547337487)*x[2]
            ref[3, 0, 2]=-0.770790546693*o*x_ref[2]**(o-1)+(0.218547337487)
            arg[3, 1]+=0.969456328177*x[2]**o+(-0.159214566908)*x[2]
            ref[3, 1, 2]=0.969456328177*o*x_ref[2]**(o-1)+(-0.159214566908)
            arg[3, 2]+=-0.927170231243*x[2]**o+(-0.431254112778)*x[2]
            ref[3, 2, 2]=-0.927170231243*o*x_ref[2]**(o-1)+(-0.431254112778)
            arg[3, 3]+=-0.462242047455*x[2]**o+(-0.874976606509)*x[2]
            ref[3, 3, 2]=-0.462242047455*o*x_ref[2]**(o-1)+(-0.874976606509)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4, 4)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onReducedFunction_fromData_Solution_rank3(self):
        """
        tests gradient of rank 3 Data on ReducedFunction

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(2, 3, 2),w)
        ref = Data(0,(2, 3, 2)+(dim,),w_ref)
        arg[0, 0, 0]=-0.425750205965*x[0]**o+(-0.384916371384)*x[0]+(-0.77590671538)*x[1]**o+(0.696759532206)*x[1]
        ref[0, 0, 0, 0]=-0.425750205965*o*x_ref[0]**(o-1)+(-0.384916371384)
        ref[0, 0, 0, 1]=-0.77590671538*o*x_ref[1]**(o-1)+(0.696759532206)
        arg[0, 0, 1]=-0.616189100978*x[0]**o+(0.600039175007)*x[0]+(0.255339394418)*x[1]**o+(0.209882041587)*x[1]
        ref[0, 0, 1, 0]=-0.616189100978*o*x_ref[0]**(o-1)+(0.600039175007)
        ref[0, 0, 1, 1]=0.255339394418*o*x_ref[1]**(o-1)+(0.209882041587)
        arg[0, 1, 0]=-0.85730900908*x[0]**o+(0.0207648837791)*x[0]+(-0.0444942092326)*x[1]**o+(-0.800909520106)*x[1]
        ref[0, 1, 0, 0]=-0.85730900908*o*x_ref[0]**(o-1)+(0.0207648837791)
        ref[0, 1, 0, 1]=-0.0444942092326*o*x_ref[1]**(o-1)+(-0.800909520106)
        arg[0, 1, 1]=0.871215936724*x[0]**o+(-0.515248392023)*x[0]+(0.0646566322368)*x[1]**o+(0.497397537908)*x[1]
        ref[0, 1, 1, 0]=0.871215936724*o*x_ref[0]**(o-1)+(-0.515248392023)
        ref[0, 1, 1, 1]=0.0646566322368*o*x_ref[1]**(o-1)+(0.497397537908)
        arg[0, 2, 0]=0.319954455749*x[0]**o+(0.409819054953)*x[0]+(0.340440405964)*x[1]**o+(0.871674346978)*x[1]
        ref[0, 2, 0, 0]=0.319954455749*o*x_ref[0]**(o-1)+(0.409819054953)
        ref[0, 2, 0, 1]=0.340440405964*o*x_ref[1]**(o-1)+(0.871674346978)
        arg[0, 2, 1]=0.267724071195*x[0]**o+(-0.735583458929)*x[0]+(-0.0772023983432)*x[1]**o+(-0.212203498931)*x[1]
        ref[0, 2, 1, 0]=0.267724071195*o*x_ref[0]**(o-1)+(-0.735583458929)
        ref[0, 2, 1, 1]=-0.0772023983432*o*x_ref[1]**(o-1)+(-0.212203498931)
        arg[1, 0, 0]=0.0913437733668*x[0]**o+(-0.120164009587)*x[0]+(0.467993733656)*x[1]**o+(-0.679774366976)*x[1]
        ref[1, 0, 0, 0]=0.0913437733668*o*x_ref[0]**(o-1)+(-0.120164009587)
        ref[1, 0, 0, 1]=0.467993733656*o*x_ref[1]**(o-1)+(-0.679774366976)
        arg[1, 0, 1]=0.670041574952*x[0]**o+(0.808047219332)*x[0]+(0.427541644709)*x[1]**o+(0.972734940177)*x[1]
        ref[1, 0, 1, 0]=0.670041574952*o*x_ref[0]**(o-1)+(0.808047219332)
        ref[1, 0, 1, 1]=0.427541644709*o*x_ref[1]**(o-1)+(0.972734940177)
        arg[1, 1, 0]=0.999730157952*x[0]**o+(0.486767467685)*x[0]+(-0.238306984712)*x[1]**o+(0.423556131901)*x[1]
        ref[1, 1, 0, 0]=0.999730157952*o*x_ref[0]**(o-1)+(0.486767467685)
        ref[1, 1, 0, 1]=-0.238306984712*o*x_ref[1]**(o-1)+(0.423556131901)
        arg[1, 1, 1]=0.294230750879*x[0]**o+(-0.238744084784)*x[0]+(0.128022000861)*x[1]**o+(0.433848018569)*x[1]
        ref[1, 1, 1, 0]=0.294230750879*o*x_ref[0]**(o-1)+(-0.238744084784)
        ref[1, 1, 1, 1]=0.128022000861*o*x_ref[1]**(o-1)+(0.433848018569)
        arg[1, 2, 0]=-0.722501861189*x[0]**o+(-0.193360264938)*x[0]+(0.0585876948151)*x[1]**o+(0.0108016755269)*x[1]
        ref[1, 2, 0, 0]=-0.722501861189*o*x_ref[0]**(o-1)+(-0.193360264938)
        ref[1, 2, 0, 1]=0.0585876948151*o*x_ref[1]**(o-1)+(0.0108016755269)
        arg[1, 2, 1]=0.0658011634963*x[0]**o+(0.646842145904)*x[0]+(-0.917808320866)*x[1]**o+(-0.911889726734)*x[1]
        ref[1, 2, 1, 0]=0.0658011634963*o*x_ref[0]**(o-1)+(0.646842145904)
        ref[1, 2, 1, 1]=-0.917808320866*o*x_ref[1]**(o-1)+(-0.911889726734)
        if dim==3:
            arg[0, 0, 0]+=0.75038734622*x[2]**o+(-0.0588998929253)*x[2]
            ref[0, 0, 0, 2]=0.75038734622*o*x_ref[2]**(o-1)+(-0.0588998929253)
            arg[0, 0, 1]+=-0.337746691569*x[2]**o+(0.257095364013)*x[2]
            ref[0, 0, 1, 2]=-0.337746691569*o*x_ref[2]**(o-1)+(0.257095364013)
            arg[0, 1, 0]+=-0.578684377398*x[2]**o+(-0.903072642317)*x[2]
            ref[0, 1, 0, 2]=-0.578684377398*o*x_ref[2]**(o-1)+(-0.903072642317)
            arg[0, 1, 1]+=0.449508242738*x[2]**o+(-0.344020181001)*x[2]
            ref[0, 1, 1, 2]=0.449508242738*o*x_ref[2]**(o-1)+(-0.344020181001)
            arg[0, 2, 0]+=0.535975714119*x[2]**o+(-0.510980917684)*x[2]
            ref[0, 2, 0, 2]=0.535975714119*o*x_ref[2]**(o-1)+(-0.510980917684)
            arg[0, 2, 1]+=0.231032469725*x[2]**o+(-0.616718445255)*x[2]
            ref[0, 2, 1, 2]=0.231032469725*o*x_ref[2]**(o-1)+(-0.616718445255)
            arg[1, 0, 0]+=-0.95628677931*x[2]**o+(0.747195118179)*x[2]
            ref[1, 0, 0, 2]=-0.95628677931*o*x_ref[2]**(o-1)+(0.747195118179)
            arg[1, 0, 1]+=-0.631844708571*x[2]**o+(0.262290916261)*x[2]
            ref[1, 0, 1, 2]=-0.631844708571*o*x_ref[2]**(o-1)+(0.262290916261)
            arg[1, 1, 0]+=-0.753034922695*x[2]**o+(-0.883925050351)*x[2]
            ref[1, 1, 0, 2]=-0.753034922695*o*x_ref[2]**(o-1)+(-0.883925050351)
            arg[1, 1, 1]+=0.986499110193*x[2]**o+(-0.146839188563)*x[2]
            ref[1, 1, 1, 2]=0.986499110193*o*x_ref[2]**(o-1)+(-0.146839188563)
            arg[1, 2, 0]+=0.615923885454*x[2]**o+(-0.404665326741)*x[2]
            ref[1, 2, 0, 2]=0.615923885454*o*x_ref[2]**(o-1)+(-0.404665326741)
            arg[1, 2, 1]+=0.0982095475317*x[2]**o+(0.23924342296)*x[2]
            ref[1, 2, 1, 2]=0.0982095475317*o*x_ref[2]**(o-1)+(0.23924342296)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2, 3, 2)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onReducedFunction_fromData_ReducedSolution_rank0(self):
        """
        tests gradient of rank 0 Data on ReducedFunction

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=-0.329262306178*x[0]+(-0.442757038839)*x[1]
        ref[0]=-0.329262306178
        ref[1]=-0.442757038839
        if dim==3:
            arg+=(0.0594179088573)*x[2]
            ref[2]=0.0594179088573
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onReducedFunction_fromData_ReducedSolution_rank1(self):
        """
        tests gradient of rank 1 Data on ReducedFunction

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(4,),w)
        ref = Data(0,(4,)+(dim,),w_ref)
        arg[0,]=0.630528213558*x[0]+(-0.483257658448)*x[1]
        ref[0, 0]=0.630528213558
        ref[0, 1]=-0.483257658448
        arg[1,]=-0.607860783755*x[0]+(0.123726195958)*x[1]
        ref[1, 0]=-0.607860783755
        ref[1, 1]=0.123726195958
        arg[2,]=-0.153450478274*x[0]+(-0.777215020749)*x[1]
        ref[2, 0]=-0.153450478274
        ref[2, 1]=-0.777215020749
        arg[3,]=0.504655325218*x[0]+(0.301600710571)*x[1]
        ref[3, 0]=0.504655325218
        ref[3, 1]=0.301600710571
        if dim==3:
            arg[0,]+=0.833217554051*x[2]
            ref[0, 2]=0.833217554051
            arg[1,]+=-0.481686480879*x[2]
            ref[1, 2]=-0.481686480879
            arg[2,]+=-0.146796145879*x[2]
            ref[2, 2]=-0.146796145879
            arg[3,]+=0.0985700428026*x[2]
            ref[3, 2]=0.0985700428026
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onReducedFunction_fromData_ReducedSolution_rank2(self):
        """
        tests gradient of rank 2 Data on ReducedFunction

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(3, 2),w)
        ref = Data(0,(3, 2)+(dim,),w_ref)
        arg[0, 0]=0.818500331902*x[0]+(-0.85048459677)*x[1]
        ref[0, 0, 0]=0.818500331902
        ref[0, 0, 1]=-0.85048459677
        arg[0, 1]=-0.766131710313*x[0]+(0.153812326163)*x[1]
        ref[0, 1, 0]=-0.766131710313
        ref[0, 1, 1]=0.153812326163
        arg[1, 0]=0.339311907759*x[0]+(-0.767515816822)*x[1]
        ref[1, 0, 0]=0.339311907759
        ref[1, 0, 1]=-0.767515816822
        arg[1, 1]=-0.15511849687*x[0]+(-0.739692610794)*x[1]
        ref[1, 1, 0]=-0.15511849687
        ref[1, 1, 1]=-0.739692610794
        arg[2, 0]=0.23201398459*x[0]+(0.205876236273)*x[1]
        ref[2, 0, 0]=0.23201398459
        ref[2, 0, 1]=0.205876236273
        arg[2, 1]=-0.125248386373*x[0]+(-0.745296503965)*x[1]
        ref[2, 1, 0]=-0.125248386373
        ref[2, 1, 1]=-0.745296503965
        if dim==3:
            arg[0, 0]+=-0.567318904342*x[2]
            ref[0, 0, 2]=-0.567318904342
            arg[0, 1]+=0.615335789536*x[2]
            ref[0, 1, 2]=0.615335789536
            arg[1, 0]+=-0.58015451196*x[2]
            ref[1, 0, 2]=-0.58015451196
            arg[1, 1]+=-0.64806108588*x[2]
            ref[1, 1, 2]=-0.64806108588
            arg[2, 0]+=0.210812642632*x[2]
            ref[2, 0, 2]=0.210812642632
            arg[2, 1]+=-0.737485568126*x[2]
            ref[2, 1, 2]=-0.737485568126
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3, 2)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onReducedFunction_fromData_ReducedSolution_rank3(self):
        """
        tests gradient of rank 3 Data on ReducedFunction

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(3, 4, 4),w)
        ref = Data(0,(3, 4, 4)+(dim,),w_ref)
        arg[0, 0, 0]=0.595282922743*x[0]+(-0.477277742583)*x[1]
        ref[0, 0, 0, 0]=0.595282922743
        ref[0, 0, 0, 1]=-0.477277742583
        arg[0, 0, 1]=0.188617609969*x[0]+(0.100549577526)*x[1]
        ref[0, 0, 1, 0]=0.188617609969
        ref[0, 0, 1, 1]=0.100549577526
        arg[0, 0, 2]=0.0476965917023*x[0]+(-0.341432752817)*x[1]
        ref[0, 0, 2, 0]=0.0476965917023
        ref[0, 0, 2, 1]=-0.341432752817
        arg[0, 0, 3]=0.186581367353*x[0]+(0.636978715681)*x[1]
        ref[0, 0, 3, 0]=0.186581367353
        ref[0, 0, 3, 1]=0.636978715681
        arg[0, 1, 0]=-0.902954014828*x[0]+(0.868625591418)*x[1]
        ref[0, 1, 0, 0]=-0.902954014828
        ref[0, 1, 0, 1]=0.868625591418
        arg[0, 1, 1]=-0.538965481483*x[0]+(-0.20653899971)*x[1]
        ref[0, 1, 1, 0]=-0.538965481483
        ref[0, 1, 1, 1]=-0.20653899971
        arg[0, 1, 2]=0.945242842611*x[0]+(0.0359439781214)*x[1]
        ref[0, 1, 2, 0]=0.945242842611
        ref[0, 1, 2, 1]=0.0359439781214
        arg[0, 1, 3]=-0.882718763415*x[0]+(-0.222626329984)*x[1]
        ref[0, 1, 3, 0]=-0.882718763415
        ref[0, 1, 3, 1]=-0.222626329984
        arg[0, 2, 0]=0.264844064395*x[0]+(-0.900145622721)*x[1]
        ref[0, 2, 0, 0]=0.264844064395
        ref[0, 2, 0, 1]=-0.900145622721
        arg[0, 2, 1]=-0.884102770531*x[0]+(-0.176678018823)*x[1]
        ref[0, 2, 1, 0]=-0.884102770531
        ref[0, 2, 1, 1]=-0.176678018823
        arg[0, 2, 2]=-0.0587768700655*x[0]+(-0.482370167509)*x[1]
        ref[0, 2, 2, 0]=-0.0587768700655
        ref[0, 2, 2, 1]=-0.482370167509
        arg[0, 2, 3]=-0.670617476433*x[0]+(0.630652638669)*x[1]
        ref[0, 2, 3, 0]=-0.670617476433
        ref[0, 2, 3, 1]=0.630652638669
        arg[0, 3, 0]=0.548516409906*x[0]+(-0.00647941996481)*x[1]
        ref[0, 3, 0, 0]=0.548516409906
        ref[0, 3, 0, 1]=-0.00647941996481
        arg[0, 3, 1]=-0.734969712337*x[0]+(0.961891924549)*x[1]
        ref[0, 3, 1, 0]=-0.734969712337
        ref[0, 3, 1, 1]=0.961891924549
        arg[0, 3, 2]=-0.683736448396*x[0]+(-0.447791242531)*x[1]
        ref[0, 3, 2, 0]=-0.683736448396
        ref[0, 3, 2, 1]=-0.447791242531
        arg[0, 3, 3]=-0.383036839627*x[0]+(0.803838076609)*x[1]
        ref[0, 3, 3, 0]=-0.383036839627
        ref[0, 3, 3, 1]=0.803838076609
        arg[1, 0, 0]=0.201102106784*x[0]+(0.583668040451)*x[1]
        ref[1, 0, 0, 0]=0.201102106784
        ref[1, 0, 0, 1]=0.583668040451
        arg[1, 0, 1]=-0.311279747211*x[0]+(-0.938340818998)*x[1]
        ref[1, 0, 1, 0]=-0.311279747211
        ref[1, 0, 1, 1]=-0.938340818998
        arg[1, 0, 2]=-0.789943677164*x[0]+(0.0792761015181)*x[1]
        ref[1, 0, 2, 0]=-0.789943677164
        ref[1, 0, 2, 1]=0.0792761015181
        arg[1, 0, 3]=-0.320262724063*x[0]+(-0.158866903673)*x[1]
        ref[1, 0, 3, 0]=-0.320262724063
        ref[1, 0, 3, 1]=-0.158866903673
        arg[1, 1, 0]=-0.0783335537919*x[0]+(0.357108458)*x[1]
        ref[1, 1, 0, 0]=-0.0783335537919
        ref[1, 1, 0, 1]=0.357108458
        arg[1, 1, 1]=0.423130858241*x[0]+(0.520669173899)*x[1]
        ref[1, 1, 1, 0]=0.423130858241
        ref[1, 1, 1, 1]=0.520669173899
        arg[1, 1, 2]=-0.358050459622*x[0]+(-0.0695843561037)*x[1]
        ref[1, 1, 2, 0]=-0.358050459622
        ref[1, 1, 2, 1]=-0.0695843561037
        arg[1, 1, 3]=0.170855030149*x[0]+(-0.957469229031)*x[1]
        ref[1, 1, 3, 0]=0.170855030149
        ref[1, 1, 3, 1]=-0.957469229031
        arg[1, 2, 0]=-0.513224465477*x[0]+(0.355987481169)*x[1]
        ref[1, 2, 0, 0]=-0.513224465477
        ref[1, 2, 0, 1]=0.355987481169
        arg[1, 2, 1]=0.422056944868*x[0]+(0.364913399709)*x[1]
        ref[1, 2, 1, 0]=0.422056944868
        ref[1, 2, 1, 1]=0.364913399709
        arg[1, 2, 2]=-0.266676114811*x[0]+(-0.0862847476421)*x[1]
        ref[1, 2, 2, 0]=-0.266676114811
        ref[1, 2, 2, 1]=-0.0862847476421
        arg[1, 2, 3]=-0.213125833426*x[0]+(-0.512636401526)*x[1]
        ref[1, 2, 3, 0]=-0.213125833426
        ref[1, 2, 3, 1]=-0.512636401526
        arg[1, 3, 0]=-0.301232063866*x[0]+(0.0127914776905)*x[1]
        ref[1, 3, 0, 0]=-0.301232063866
        ref[1, 3, 0, 1]=0.0127914776905
        arg[1, 3, 1]=-0.327201756395*x[0]+(0.611994157692)*x[1]
        ref[1, 3, 1, 0]=-0.327201756395
        ref[1, 3, 1, 1]=0.611994157692
        arg[1, 3, 2]=-0.354878005799*x[0]+(0.739248041075)*x[1]
        ref[1, 3, 2, 0]=-0.354878005799
        ref[1, 3, 2, 1]=0.739248041075
        arg[1, 3, 3]=0.0638747703559*x[0]+(-0.459896775525)*x[1]
        ref[1, 3, 3, 0]=0.0638747703559
        ref[1, 3, 3, 1]=-0.459896775525
        arg[2, 0, 0]=-0.0541637096707*x[0]+(0.553790290541)*x[1]
        ref[2, 0, 0, 0]=-0.0541637096707
        ref[2, 0, 0, 1]=0.553790290541
        arg[2, 0, 1]=-0.112686537474*x[0]+(-0.797251912516)*x[1]
        ref[2, 0, 1, 0]=-0.112686537474
        ref[2, 0, 1, 1]=-0.797251912516
        arg[2, 0, 2]=0.361556987009*x[0]+(-0.087318937709)*x[1]
        ref[2, 0, 2, 0]=0.361556987009
        ref[2, 0, 2, 1]=-0.087318937709
        arg[2, 0, 3]=-0.563788060557*x[0]+(-0.547181742765)*x[1]
        ref[2, 0, 3, 0]=-0.563788060557
        ref[2, 0, 3, 1]=-0.547181742765
        arg[2, 1, 0]=0.843132200023*x[0]+(0.211664462446)*x[1]
        ref[2, 1, 0, 0]=0.843132200023
        ref[2, 1, 0, 1]=0.211664462446
        arg[2, 1, 1]=0.144139335985*x[0]+(-0.188418165539)*x[1]
        ref[2, 1, 1, 0]=0.144139335985
        ref[2, 1, 1, 1]=-0.188418165539
        arg[2, 1, 2]=-0.55125432682*x[0]+(-0.723148817814)*x[1]
        ref[2, 1, 2, 0]=-0.55125432682
        ref[2, 1, 2, 1]=-0.723148817814
        arg[2, 1, 3]=-0.664823534717*x[0]+(-0.602641680822)*x[1]
        ref[2, 1, 3, 0]=-0.664823534717
        ref[2, 1, 3, 1]=-0.602641680822
        arg[2, 2, 0]=-0.808683472353*x[0]+(0.630526609126)*x[1]
        ref[2, 2, 0, 0]=-0.808683472353
        ref[2, 2, 0, 1]=0.630526609126
        arg[2, 2, 1]=-0.555691082219*x[0]+(-0.873848545871)*x[1]
        ref[2, 2, 1, 0]=-0.555691082219
        ref[2, 2, 1, 1]=-0.873848545871
        arg[2, 2, 2]=0.5806328757*x[0]+(-0.383518380087)*x[1]
        ref[2, 2, 2, 0]=0.5806328757
        ref[2, 2, 2, 1]=-0.383518380087
        arg[2, 2, 3]=0.599209716714*x[0]+(0.129043558001)*x[1]
        ref[2, 2, 3, 0]=0.599209716714
        ref[2, 2, 3, 1]=0.129043558001
        arg[2, 3, 0]=0.646264830587*x[0]+(0.474719238136)*x[1]
        ref[2, 3, 0, 0]=0.646264830587
        ref[2, 3, 0, 1]=0.474719238136
        arg[2, 3, 1]=0.819916491736*x[0]+(0.784226978413)*x[1]
        ref[2, 3, 1, 0]=0.819916491736
        ref[2, 3, 1, 1]=0.784226978413
        arg[2, 3, 2]=-0.546437358806*x[0]+(-0.99104551023)*x[1]
        ref[2, 3, 2, 0]=-0.546437358806
        ref[2, 3, 2, 1]=-0.99104551023
        arg[2, 3, 3]=-0.162089166098*x[0]+(0.445334924536)*x[1]
        ref[2, 3, 3, 0]=-0.162089166098
        ref[2, 3, 3, 1]=0.445334924536
        if dim==3:
            arg[0, 0, 0]+=-0.369259522861*x[2]
            ref[0, 0, 0, 2]=-0.369259522861
            arg[0, 0, 1]+=0.603078388981*x[2]
            ref[0, 0, 1, 2]=0.603078388981
            arg[0, 0, 2]+=-0.756548791268*x[2]
            ref[0, 0, 2, 2]=-0.756548791268
            arg[0, 0, 3]+=-0.892864486279*x[2]
            ref[0, 0, 3, 2]=-0.892864486279
            arg[0, 1, 0]+=0.716282446565*x[2]
            ref[0, 1, 0, 2]=0.716282446565
            arg[0, 1, 1]+=-0.604149097208*x[2]
            ref[0, 1, 1, 2]=-0.604149097208
            arg[0, 1, 2]+=0.426585487378*x[2]
            ref[0, 1, 2, 2]=0.426585487378
            arg[0, 1, 3]+=0.916803193531*x[2]
            ref[0, 1, 3, 2]=0.916803193531
            arg[0, 2, 0]+=0.582739329789*x[2]
            ref[0, 2, 0, 2]=0.582739329789
            arg[0, 2, 1]+=0.102325603447*x[2]
            ref[0, 2, 1, 2]=0.102325603447
            arg[0, 2, 2]+=-0.497430756215*x[2]
            ref[0, 2, 2, 2]=-0.497430756215
            arg[0, 2, 3]+=-0.34294752334*x[2]
            ref[0, 2, 3, 2]=-0.34294752334
            arg[0, 3, 0]+=0.679049493455*x[2]
            ref[0, 3, 0, 2]=0.679049493455
            arg[0, 3, 1]+=-0.102068456364*x[2]
            ref[0, 3, 1, 2]=-0.102068456364
            arg[0, 3, 2]+=0.987942467335*x[2]
            ref[0, 3, 2, 2]=0.987942467335
            arg[0, 3, 3]+=-0.441333493273*x[2]
            ref[0, 3, 3, 2]=-0.441333493273
            arg[1, 0, 0]+=-0.195853225037*x[2]
            ref[1, 0, 0, 2]=-0.195853225037
            arg[1, 0, 1]+=-0.245264022466*x[2]
            ref[1, 0, 1, 2]=-0.245264022466
            arg[1, 0, 2]+=-0.710934568472*x[2]
            ref[1, 0, 2, 2]=-0.710934568472
            arg[1, 0, 3]+=0.221027562645*x[2]
            ref[1, 0, 3, 2]=0.221027562645
            arg[1, 1, 0]+=0.632223428033*x[2]
            ref[1, 1, 0, 2]=0.632223428033
            arg[1, 1, 1]+=0.883262204803*x[2]
            ref[1, 1, 1, 2]=0.883262204803
            arg[1, 1, 2]+=-0.0904577744293*x[2]
            ref[1, 1, 2, 2]=-0.0904577744293
            arg[1, 1, 3]+=0.201985614855*x[2]
            ref[1, 1, 3, 2]=0.201985614855
            arg[1, 2, 0]+=-0.112086301984*x[2]
            ref[1, 2, 0, 2]=-0.112086301984
            arg[1, 2, 1]+=0.133177209857*x[2]
            ref[1, 2, 1, 2]=0.133177209857
            arg[1, 2, 2]+=0.122990135283*x[2]
            ref[1, 2, 2, 2]=0.122990135283
            arg[1, 2, 3]+=-0.319519847869*x[2]
            ref[1, 2, 3, 2]=-0.319519847869
            arg[1, 3, 0]+=0.393361898724*x[2]
            ref[1, 3, 0, 2]=0.393361898724
            arg[1, 3, 1]+=0.922760267886*x[2]
            ref[1, 3, 1, 2]=0.922760267886
            arg[1, 3, 2]+=-0.417956597945*x[2]
            ref[1, 3, 2, 2]=-0.417956597945
            arg[1, 3, 3]+=-0.622310154621*x[2]
            ref[1, 3, 3, 2]=-0.622310154621
            arg[2, 0, 0]+=-0.11134150221*x[2]
            ref[2, 0, 0, 2]=-0.11134150221
            arg[2, 0, 1]+=0.395987153772*x[2]
            ref[2, 0, 1, 2]=0.395987153772
            arg[2, 0, 2]+=0.489477280827*x[2]
            ref[2, 0, 2, 2]=0.489477280827
            arg[2, 0, 3]+=0.581058771272*x[2]
            ref[2, 0, 3, 2]=0.581058771272
            arg[2, 1, 0]+=-0.948070607724*x[2]
            ref[2, 1, 0, 2]=-0.948070607724
            arg[2, 1, 1]+=0.49246936707*x[2]
            ref[2, 1, 1, 2]=0.49246936707
            arg[2, 1, 2]+=0.166917961694*x[2]
            ref[2, 1, 2, 2]=0.166917961694
            arg[2, 1, 3]+=-0.364721956565*x[2]
            ref[2, 1, 3, 2]=-0.364721956565
            arg[2, 2, 0]+=0.114731488592*x[2]
            ref[2, 2, 0, 2]=0.114731488592
            arg[2, 2, 1]+=0.883662720366*x[2]
            ref[2, 2, 1, 2]=0.883662720366
            arg[2, 2, 2]+=0.264831985839*x[2]
            ref[2, 2, 2, 2]=0.264831985839
            arg[2, 2, 3]+=-0.969514559943*x[2]
            ref[2, 2, 3, 2]=-0.969514559943
            arg[2, 3, 0]+=0.878691270626*x[2]
            ref[2, 3, 0, 2]=0.878691270626
            arg[2, 3, 1]+=-0.641161163837*x[2]
            ref[2, 3, 1, 2]=-0.641161163837
            arg[2, 3, 2]+=-0.0962679159631*x[2]
            ref[2, 3, 2, 2]=-0.0962679159631
            arg[2, 3, 3]+=-0.134429531287*x[2]
            ref[2, 3, 3, 2]=-0.134429531287
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3, 4, 4)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onReducedFunction_fromData_ReducedContinuousFunction_rank0(self):
        """
        tests gradient of rank 0 Data on ReducedFunction

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=0.39710061225*x[0]+(0.743062673115)*x[1]
        ref[0]=0.39710061225
        ref[1]=0.743062673115
        if dim==3:
            arg+=(0.788299310708)*x[2]
            ref[2]=0.788299310708
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onReducedFunction_fromData_ReducedContinuousFunction_rank1(self):
        """
        tests gradient of rank 1 Data on ReducedFunction

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(4,),w)
        ref = Data(0,(4,)+(dim,),w_ref)
        arg[0,]=-0.804717093503*x[0]+(0.589710182847)*x[1]
        ref[0, 0]=-0.804717093503
        ref[0, 1]=0.589710182847
        arg[1,]=-0.867279269485*x[0]+(0.870964663368)*x[1]
        ref[1, 0]=-0.867279269485
        ref[1, 1]=0.870964663368
        arg[2,]=0.465235074891*x[0]+(-0.673371884283)*x[1]
        ref[2, 0]=0.465235074891
        ref[2, 1]=-0.673371884283
        arg[3,]=0.513232645165*x[0]+(0.36456045292)*x[1]
        ref[3, 0]=0.513232645165
        ref[3, 1]=0.36456045292
        if dim==3:
            arg[0,]+=-0.511222788658*x[2]
            ref[0, 2]=-0.511222788658
            arg[1,]+=0.180350472234*x[2]
            ref[1, 2]=0.180350472234
            arg[2,]+=-0.194104422166*x[2]
            ref[2, 2]=-0.194104422166
            arg[3,]+=-0.539719331402*x[2]
            ref[3, 2]=-0.539719331402
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onReducedFunction_fromData_ReducedContinuousFunction_rank2(self):
        """
        tests gradient of rank 2 Data on ReducedFunction

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(4, 4),w)
        ref = Data(0,(4, 4)+(dim,),w_ref)
        arg[0, 0]=0.000565612178797*x[0]+(0.0530918532702)*x[1]
        ref[0, 0, 0]=0.000565612178797
        ref[0, 0, 1]=0.0530918532702
        arg[0, 1]=-0.542649232756*x[0]+(-0.49281404613)*x[1]
        ref[0, 1, 0]=-0.542649232756
        ref[0, 1, 1]=-0.49281404613
        arg[0, 2]=-0.943146557559*x[0]+(0.891397164634)*x[1]
        ref[0, 2, 0]=-0.943146557559
        ref[0, 2, 1]=0.891397164634
        arg[0, 3]=-0.353264802772*x[0]+(0.978090605133)*x[1]
        ref[0, 3, 0]=-0.353264802772
        ref[0, 3, 1]=0.978090605133
        arg[1, 0]=0.266334539925*x[0]+(-0.201926560641)*x[1]
        ref[1, 0, 0]=0.266334539925
        ref[1, 0, 1]=-0.201926560641
        arg[1, 1]=-0.629370666897*x[0]+(0.971381303153)*x[1]
        ref[1, 1, 0]=-0.629370666897
        ref[1, 1, 1]=0.971381303153
        arg[1, 2]=-0.871833549935*x[0]+(-0.579280358296)*x[1]
        ref[1, 2, 0]=-0.871833549935
        ref[1, 2, 1]=-0.579280358296
        arg[1, 3]=0.612482869718*x[0]+(-0.192416213744)*x[1]
        ref[1, 3, 0]=0.612482869718
        ref[1, 3, 1]=-0.192416213744
        arg[2, 0]=-0.751948892697*x[0]+(-0.344769204341)*x[1]
        ref[2, 0, 0]=-0.751948892697
        ref[2, 0, 1]=-0.344769204341
        arg[2, 1]=0.787265642852*x[0]+(-0.807584574151)*x[1]
        ref[2, 1, 0]=0.787265642852
        ref[2, 1, 1]=-0.807584574151
        arg[2, 2]=0.194920521043*x[0]+(0.456402061818)*x[1]
        ref[2, 2, 0]=0.194920521043
        ref[2, 2, 1]=0.456402061818
        arg[2, 3]=-0.132151221218*x[0]+(0.432082738134)*x[1]
        ref[2, 3, 0]=-0.132151221218
        ref[2, 3, 1]=0.432082738134
        arg[3, 0]=-0.515279891704*x[0]+(0.304250537586)*x[1]
        ref[3, 0, 0]=-0.515279891704
        ref[3, 0, 1]=0.304250537586
        arg[3, 1]=-0.200477241819*x[0]+(-0.205854697776)*x[1]
        ref[3, 1, 0]=-0.200477241819
        ref[3, 1, 1]=-0.205854697776
        arg[3, 2]=-0.454994088797*x[0]+(0.712689398229)*x[1]
        ref[3, 2, 0]=-0.454994088797
        ref[3, 2, 1]=0.712689398229
        arg[3, 3]=0.0621925456673*x[0]+(0.156519779973)*x[1]
        ref[3, 3, 0]=0.0621925456673
        ref[3, 3, 1]=0.156519779973
        if dim==3:
            arg[0, 0]+=0.81671071543*x[2]
            ref[0, 0, 2]=0.81671071543
            arg[0, 1]+=0.610069715708*x[2]
            ref[0, 1, 2]=0.610069715708
            arg[0, 2]+=-0.171349203959*x[2]
            ref[0, 2, 2]=-0.171349203959
            arg[0, 3]+=-0.389957554417*x[2]
            ref[0, 3, 2]=-0.389957554417
            arg[1, 0]+=0.841363838655*x[2]
            ref[1, 0, 2]=0.841363838655
            arg[1, 1]+=-0.125942861476*x[2]
            ref[1, 1, 2]=-0.125942861476
            arg[1, 2]+=0.771980956846*x[2]
            ref[1, 2, 2]=0.771980956846
            arg[1, 3]+=-0.0988689497763*x[2]
            ref[1, 3, 2]=-0.0988689497763
            arg[2, 0]+=-0.824174435376*x[2]
            ref[2, 0, 2]=-0.824174435376
            arg[2, 1]+=0.724867599618*x[2]
            ref[2, 1, 2]=0.724867599618
            arg[2, 2]+=0.389729564602*x[2]
            ref[2, 2, 2]=0.389729564602
            arg[2, 3]+=0.190133520975*x[2]
            ref[2, 3, 2]=0.190133520975
            arg[3, 0]+=0.907855727556*x[2]
            ref[3, 0, 2]=0.907855727556
            arg[3, 1]+=-0.115918079257*x[2]
            ref[3, 1, 2]=-0.115918079257
            arg[3, 2]+=-0.617187947016*x[2]
            ref[3, 2, 2]=-0.617187947016
            arg[3, 3]+=0.111462162934*x[2]
            ref[3, 3, 2]=0.111462162934
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4, 4)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onReducedFunction_fromData_ReducedContinuousFunction_rank3(self):
        """
        tests gradient of rank 3 Data on ReducedFunction

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunction
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunction(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(4, 4, 2),w)
        ref = Data(0,(4, 4, 2)+(dim,),w_ref)
        arg[0, 0, 0]=0.756380744095*x[0]+(-0.193631360561)*x[1]
        ref[0, 0, 0, 0]=0.756380744095
        ref[0, 0, 0, 1]=-0.193631360561
        arg[0, 0, 1]=0.933161099282*x[0]+(-0.00324281523084)*x[1]
        ref[0, 0, 1, 0]=0.933161099282
        ref[0, 0, 1, 1]=-0.00324281523084
        arg[0, 1, 0]=0.118976911092*x[0]+(0.0297995483052)*x[1]
        ref[0, 1, 0, 0]=0.118976911092
        ref[0, 1, 0, 1]=0.0297995483052
        arg[0, 1, 1]=-0.319222564794*x[0]+(-0.318320409092)*x[1]
        ref[0, 1, 1, 0]=-0.319222564794
        ref[0, 1, 1, 1]=-0.318320409092
        arg[0, 2, 0]=-0.812319312365*x[0]+(-0.807915892811)*x[1]
        ref[0, 2, 0, 0]=-0.812319312365
        ref[0, 2, 0, 1]=-0.807915892811
        arg[0, 2, 1]=-0.457757798076*x[0]+(0.87756743222)*x[1]
        ref[0, 2, 1, 0]=-0.457757798076
        ref[0, 2, 1, 1]=0.87756743222
        arg[0, 3, 0]=-0.738090024647*x[0]+(0.609412540748)*x[1]
        ref[0, 3, 0, 0]=-0.738090024647
        ref[0, 3, 0, 1]=0.609412540748
        arg[0, 3, 1]=-0.911278061746*x[0]+(0.172891881635)*x[1]
        ref[0, 3, 1, 0]=-0.911278061746
        ref[0, 3, 1, 1]=0.172891881635
        arg[1, 0, 0]=-0.908458485222*x[0]+(0.0974756115077)*x[1]
        ref[1, 0, 0, 0]=-0.908458485222
        ref[1, 0, 0, 1]=0.0974756115077
        arg[1, 0, 1]=0.366489945833*x[0]+(-0.626232652078)*x[1]
        ref[1, 0, 1, 0]=0.366489945833
        ref[1, 0, 1, 1]=-0.626232652078
        arg[1, 1, 0]=-0.205270439231*x[0]+(-0.120280236187)*x[1]
        ref[1, 1, 0, 0]=-0.205270439231
        ref[1, 1, 0, 1]=-0.120280236187
        arg[1, 1, 1]=-0.85173139672*x[0]+(-0.688853177824)*x[1]
        ref[1, 1, 1, 0]=-0.85173139672
        ref[1, 1, 1, 1]=-0.688853177824
        arg[1, 2, 0]=0.982412562369*x[0]+(-0.153036762478)*x[1]
        ref[1, 2, 0, 0]=0.982412562369
        ref[1, 2, 0, 1]=-0.153036762478
        arg[1, 2, 1]=-0.695113017954*x[0]+(-0.0038096927793)*x[1]
        ref[1, 2, 1, 0]=-0.695113017954
        ref[1, 2, 1, 1]=-0.0038096927793
        arg[1, 3, 0]=0.18353125369*x[0]+(0.738532941523)*x[1]
        ref[1, 3, 0, 0]=0.18353125369
        ref[1, 3, 0, 1]=0.738532941523
        arg[1, 3, 1]=-0.266291190053*x[0]+(0.88343966004)*x[1]
        ref[1, 3, 1, 0]=-0.266291190053
        ref[1, 3, 1, 1]=0.88343966004
        arg[2, 0, 0]=-0.545843557736*x[0]+(0.557959730294)*x[1]
        ref[2, 0, 0, 0]=-0.545843557736
        ref[2, 0, 0, 1]=0.557959730294
        arg[2, 0, 1]=0.0595454566454*x[0]+(-0.633395052091)*x[1]
        ref[2, 0, 1, 0]=0.0595454566454
        ref[2, 0, 1, 1]=-0.633395052091
        arg[2, 1, 0]=-0.206091715477*x[0]+(-0.212488258098)*x[1]
        ref[2, 1, 0, 0]=-0.206091715477
        ref[2, 1, 0, 1]=-0.212488258098
        arg[2, 1, 1]=-0.439122981192*x[0]+(-0.757880851237)*x[1]
        ref[2, 1, 1, 0]=-0.439122981192
        ref[2, 1, 1, 1]=-0.757880851237
        arg[2, 2, 0]=-0.58971590124*x[0]+(-0.424252048958)*x[1]
        ref[2, 2, 0, 0]=-0.58971590124
        ref[2, 2, 0, 1]=-0.424252048958
        arg[2, 2, 1]=-0.739388713511*x[0]+(-0.52034829574)*x[1]
        ref[2, 2, 1, 0]=-0.739388713511
        ref[2, 2, 1, 1]=-0.52034829574
        arg[2, 3, 0]=-0.931739422342*x[0]+(0.525456170598)*x[1]
        ref[2, 3, 0, 0]=-0.931739422342
        ref[2, 3, 0, 1]=0.525456170598
        arg[2, 3, 1]=0.702347423198*x[0]+(0.298131957138)*x[1]
        ref[2, 3, 1, 0]=0.702347423198
        ref[2, 3, 1, 1]=0.298131957138
        arg[3, 0, 0]=-0.552815043739*x[0]+(-0.422643547912)*x[1]
        ref[3, 0, 0, 0]=-0.552815043739
        ref[3, 0, 0, 1]=-0.422643547912
        arg[3, 0, 1]=-0.213162521606*x[0]+(-0.160393654351)*x[1]
        ref[3, 0, 1, 0]=-0.213162521606
        ref[3, 0, 1, 1]=-0.160393654351
        arg[3, 1, 0]=-0.409656890997*x[0]+(-0.709245562782)*x[1]
        ref[3, 1, 0, 0]=-0.409656890997
        ref[3, 1, 0, 1]=-0.709245562782
        arg[3, 1, 1]=-0.425694184679*x[0]+(0.962857427994)*x[1]
        ref[3, 1, 1, 0]=-0.425694184679
        ref[3, 1, 1, 1]=0.962857427994
        arg[3, 2, 0]=-0.668734012609*x[0]+(0.466097040286)*x[1]
        ref[3, 2, 0, 0]=-0.668734012609
        ref[3, 2, 0, 1]=0.466097040286
        arg[3, 2, 1]=-0.992713076436*x[0]+(0.443296970475)*x[1]
        ref[3, 2, 1, 0]=-0.992713076436
        ref[3, 2, 1, 1]=0.443296970475
        arg[3, 3, 0]=0.214165268358*x[0]+(-0.281882379427)*x[1]
        ref[3, 3, 0, 0]=0.214165268358
        ref[3, 3, 0, 1]=-0.281882379427
        arg[3, 3, 1]=-0.723288455783*x[0]+(0.487305324804)*x[1]
        ref[3, 3, 1, 0]=-0.723288455783
        ref[3, 3, 1, 1]=0.487305324804
        if dim==3:
            arg[0, 0, 0]+=-0.664761574456*x[2]
            ref[0, 0, 0, 2]=-0.664761574456
            arg[0, 0, 1]+=-0.781837611435*x[2]
            ref[0, 0, 1, 2]=-0.781837611435
            arg[0, 1, 0]+=0.610306976899*x[2]
            ref[0, 1, 0, 2]=0.610306976899
            arg[0, 1, 1]+=-0.279264903882*x[2]
            ref[0, 1, 1, 2]=-0.279264903882
            arg[0, 2, 0]+=0.400026661132*x[2]
            ref[0, 2, 0, 2]=0.400026661132
            arg[0, 2, 1]+=-0.059334500964*x[2]
            ref[0, 2, 1, 2]=-0.059334500964
            arg[0, 3, 0]+=0.729774253025*x[2]
            ref[0, 3, 0, 2]=0.729774253025
            arg[0, 3, 1]+=0.682132875935*x[2]
            ref[0, 3, 1, 2]=0.682132875935
            arg[1, 0, 0]+=0.927307898534*x[2]
            ref[1, 0, 0, 2]=0.927307898534
            arg[1, 0, 1]+=-0.688936056593*x[2]
            ref[1, 0, 1, 2]=-0.688936056593
            arg[1, 1, 0]+=0.622223829383*x[2]
            ref[1, 1, 0, 2]=0.622223829383
            arg[1, 1, 1]+=-0.480689581507*x[2]
            ref[1, 1, 1, 2]=-0.480689581507
            arg[1, 2, 0]+=-0.302887927553*x[2]
            ref[1, 2, 0, 2]=-0.302887927553
            arg[1, 2, 1]+=0.661511216006*x[2]
            ref[1, 2, 1, 2]=0.661511216006
            arg[1, 3, 0]+=-0.43823495396*x[2]
            ref[1, 3, 0, 2]=-0.43823495396
            arg[1, 3, 1]+=-0.554281264563*x[2]
            ref[1, 3, 1, 2]=-0.554281264563
            arg[2, 0, 0]+=0.609173162479*x[2]
            ref[2, 0, 0, 2]=0.609173162479
            arg[2, 0, 1]+=-0.824972765873*x[2]
            ref[2, 0, 1, 2]=-0.824972765873
            arg[2, 1, 0]+=-0.261453577608*x[2]
            ref[2, 1, 0, 2]=-0.261453577608
            arg[2, 1, 1]+=0.399978034844*x[2]
            ref[2, 1, 1, 2]=0.399978034844
            arg[2, 2, 0]+=0.468956169674*x[2]
            ref[2, 2, 0, 2]=0.468956169674
            arg[2, 2, 1]+=0.91330882499*x[2]
            ref[2, 2, 1, 2]=0.91330882499
            arg[2, 3, 0]+=-0.549885049895*x[2]
            ref[2, 3, 0, 2]=-0.549885049895
            arg[2, 3, 1]+=0.442582945783*x[2]
            ref[2, 3, 1, 2]=0.442582945783
            arg[3, 0, 0]+=0.794612589673*x[2]
            ref[3, 0, 0, 2]=0.794612589673
            arg[3, 0, 1]+=0.920683902436*x[2]
            ref[3, 0, 1, 2]=0.920683902436
            arg[3, 1, 0]+=-0.386627972574*x[2]
            ref[3, 1, 0, 2]=-0.386627972574
            arg[3, 1, 1]+=-0.871605332762*x[2]
            ref[3, 1, 1, 2]=-0.871605332762
            arg[3, 2, 0]+=-0.986799043547*x[2]
            ref[3, 2, 0, 2]=-0.986799043547
            arg[3, 2, 1]+=-0.689296475444*x[2]
            ref[3, 2, 1, 2]=-0.689296475444
            arg[3, 3, 0]+=-0.75165841011*x[2]
            ref[3, 3, 0, 2]=-0.75165841011
            arg[3, 3, 1]+=-0.925778480127*x[2]
            ref[3, 3, 1, 2]=-0.925778480127
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4, 4, 2)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

class Test_Util_Gradient(Test_Util_Gradient_noBoundary):
    RES_TOL=1.e-8

    def test_gradC_onFunctionOnBoundary_fromData_ContinuousFunction_rank0(self):
        """
        tests gradient of rank 0 Data on FunctionOnBoundary

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=(-0.922806844009+0.435941856733j)*x[0]**o+((-0.35846655342-0.594080934074j))*x[0]+((-0.285322068906-0.798924174387j))*x[1]**o+((-0.059454005799+0.98265629945j))*x[1]
        ref[0]=(-0.922806844009+0.435941856733j)*o*x_ref[0]**(o-1)+((-0.35846655342-0.594080934074j))
        ref[1]=(-0.285322068906-0.798924174387j)*o*x_ref[1]**(o-1)+((-0.059454005799+0.98265629945j))
        if dim==3:
            arg+=((-0.708133822731-0.566925576405j))*x[2]**o+((-0.945315219781-0.988477174824j))*x[2]
            ref[2]=(-0.708133822731-0.566925576405j)*o*x_ref[2]**(o-1)+((-0.945315219781-0.988477174824j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnBoundary_fromData_ContinuousFunction_rank1(self):
        """
        tests gradient of rank 1 Data on FunctionOnBoundary

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(4,),w)
        ref = Data(0,(4,)+(dim,),w_ref)
        arg[0,]=(-0.0647120628435-0.893186651906j)*x[0]**o+((-0.883738822207-0.913305723944j))*x[0]+((0.0530375167833+0.798326136304j))*x[1]**o+((-0.0970852024091-0.0827613786987j))*x[1]
        ref[0, 0]=(-0.0647120628435-0.893186651906j)*o*x_ref[0]**(o-1)+((-0.883738822207-0.913305723944j))
        ref[0, 1]=(0.0530375167833+0.798326136304j)*o*x_ref[1]**(o-1)+((-0.0970852024091-0.0827613786987j))
        arg[1,]=(-0.07500613091-0.370226425239j)*x[0]**o+((-0.611242078508-0.669266177296j))*x[0]+((-0.075309154696-0.581390118796j))*x[1]**o+((0.0520550596683-0.120968094284j))*x[1]
        ref[1, 0]=(-0.07500613091-0.370226425239j)*o*x_ref[0]**(o-1)+((-0.611242078508-0.669266177296j))
        ref[1, 1]=(-0.075309154696-0.581390118796j)*o*x_ref[1]**(o-1)+((0.0520550596683-0.120968094284j))
        arg[2,]=(0.118668018253+0.427384212631j)*x[0]**o+((-0.341740234573+0.975819830738j))*x[0]+((-0.555850053717+0.243427969271j))*x[1]**o+((0.678884281188+0.0269896045673j))*x[1]
        ref[2, 0]=(0.118668018253+0.427384212631j)*o*x_ref[0]**(o-1)+((-0.341740234573+0.975819830738j))
        ref[2, 1]=(-0.555850053717+0.243427969271j)*o*x_ref[1]**(o-1)+((0.678884281188+0.0269896045673j))
        arg[3,]=(0.0990321884322-0.468576015211j)*x[0]**o+((0.934428377287+0.790778644225j))*x[0]+((-0.941593655282+0.237685064281j))*x[1]**o+((-0.127806199978-0.443931281801j))*x[1]
        ref[3, 0]=(0.0990321884322-0.468576015211j)*o*x_ref[0]**(o-1)+((0.934428377287+0.790778644225j))
        ref[3, 1]=(-0.941593655282+0.237685064281j)*o*x_ref[1]**(o-1)+((-0.127806199978-0.443931281801j))
        if dim==3:
            arg[0,]+=(-0.801716303798+0.0133974639381j)*x[2]**o+((-0.0276222689186+0.860268820244j))*x[2]
            ref[0, 2]=(-0.801716303798+0.0133974639381j)*o*x_ref[2]**(o-1)+((-0.0276222689186+0.860268820244j))
            arg[1,]+=(0.466263923425+0.826611964818j)*x[2]**o+((0.514961176512+0.804421290442j))*x[2]
            ref[1, 2]=(0.466263923425+0.826611964818j)*o*x_ref[2]**(o-1)+((0.514961176512+0.804421290442j))
            arg[2,]+=(0.459637164683-0.190282200974j)*x[2]**o+((0.581246367337-0.17589050071j))*x[2]
            ref[2, 2]=(0.459637164683-0.190282200974j)*o*x_ref[2]**(o-1)+((0.581246367337-0.17589050071j))
            arg[3,]+=(-0.907032043617-0.106094590736j)*x[2]**o+((-0.366862110747+0.542222434649j))*x[2]
            ref[3, 2]=(-0.907032043617-0.106094590736j)*o*x_ref[2]**(o-1)+((-0.366862110747+0.542222434649j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnBoundary_fromData_ContinuousFunction_rank2(self):
        """
        tests gradient of rank 2 Data on FunctionOnBoundary

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(4, 2),w)
        ref = Data(0,(4, 2)+(dim,),w_ref)
        arg[0, 0]=(0.0377325931987-0.533191435935j)*x[0]**o+((0.519409392539+0.458792414901j))*x[0]+((-0.974794742175+0.0535674732094j))*x[1]**o+((0.853178999406-0.4518054755j))*x[1]
        ref[0, 0, 0]=(0.0377325931987-0.533191435935j)*o*x_ref[0]**(o-1)+((0.519409392539+0.458792414901j))
        ref[0, 0, 1]=(-0.974794742175+0.0535674732094j)*o*x_ref[1]**(o-1)+((0.853178999406-0.4518054755j))
        arg[0, 1]=(0.378901596846+0.10870026205j)*x[0]**o+((0.465984454063-0.428646414911j))*x[0]+((-0.646069030617+0.631319980722j))*x[1]**o+((-0.677639920148+0.87141325477j))*x[1]
        ref[0, 1, 0]=(0.378901596846+0.10870026205j)*o*x_ref[0]**(o-1)+((0.465984454063-0.428646414911j))
        ref[0, 1, 1]=(-0.646069030617+0.631319980722j)*o*x_ref[1]**(o-1)+((-0.677639920148+0.87141325477j))
        arg[1, 0]=(-0.588115952939+0.855184441449j)*x[0]**o+((-0.368408585854+0.595410878147j))*x[0]+((0.375225632433+0.92034104212j))*x[1]**o+((-0.926605702139+0.48924523859j))*x[1]
        ref[1, 0, 0]=(-0.588115952939+0.855184441449j)*o*x_ref[0]**(o-1)+((-0.368408585854+0.595410878147j))
        ref[1, 0, 1]=(0.375225632433+0.92034104212j)*o*x_ref[1]**(o-1)+((-0.926605702139+0.48924523859j))
        arg[1, 1]=(0.555759369145-0.74477028372j)*x[0]**o+((-0.740846772007+0.19209221943j))*x[0]+((-0.679861846448-0.281626848801j))*x[1]**o+((-0.593378163673+0.538098348783j))*x[1]
        ref[1, 1, 0]=(0.555759369145-0.74477028372j)*o*x_ref[0]**(o-1)+((-0.740846772007+0.19209221943j))
        ref[1, 1, 1]=(-0.679861846448-0.281626848801j)*o*x_ref[1]**(o-1)+((-0.593378163673+0.538098348783j))
        arg[2, 0]=(0.706843947975+0.0101280158788j)*x[0]**o+((-0.986665886843+0.94413250954j))*x[0]+((-0.401885906-0.365183975806j))*x[1]**o+((-0.379417848112+0.407467981556j))*x[1]
        ref[2, 0, 0]=(0.706843947975+0.0101280158788j)*o*x_ref[0]**(o-1)+((-0.986665886843+0.94413250954j))
        ref[2, 0, 1]=(-0.401885906-0.365183975806j)*o*x_ref[1]**(o-1)+((-0.379417848112+0.407467981556j))
        arg[2, 1]=(-0.759562367306+0.0536729641886j)*x[0]**o+((-0.439938569513-0.166996449878j))*x[0]+((0.718393982568-0.605895294468j))*x[1]**o+((0.595098906293+0.83543915919j))*x[1]
        ref[2, 1, 0]=(-0.759562367306+0.0536729641886j)*o*x_ref[0]**(o-1)+((-0.439938569513-0.166996449878j))
        ref[2, 1, 1]=(0.718393982568-0.605895294468j)*o*x_ref[1]**(o-1)+((0.595098906293+0.83543915919j))
        arg[3, 0]=(-0.766189632684-0.950992999291j)*x[0]**o+((-0.0802734876203-0.370589303799j))*x[0]+((-0.124943042765+0.353529467351j))*x[1]**o+((0.738567198497+0.313617607834j))*x[1]
        ref[3, 0, 0]=(-0.766189632684-0.950992999291j)*o*x_ref[0]**(o-1)+((-0.0802734876203-0.370589303799j))
        ref[3, 0, 1]=(-0.124943042765+0.353529467351j)*o*x_ref[1]**(o-1)+((0.738567198497+0.313617607834j))
        arg[3, 1]=(-0.31321259047-0.615563446659j)*x[0]**o+((-0.891975184584-0.449446180416j))*x[0]+((-0.581565210931-0.155980104216j))*x[1]**o+((-0.760100136101-0.344466428459j))*x[1]
        ref[3, 1, 0]=(-0.31321259047-0.615563446659j)*o*x_ref[0]**(o-1)+((-0.891975184584-0.449446180416j))
        ref[3, 1, 1]=(-0.581565210931-0.155980104216j)*o*x_ref[1]**(o-1)+((-0.760100136101-0.344466428459j))
        if dim==3:
            arg[0, 0]+=(-0.544497425081+0.770890680224j)*x[2]**o+((0.060562171079-0.443787477389j))*x[2]
            ref[0, 0, 2]=(-0.544497425081+0.770890680224j)*o*x_ref[2]**(o-1)+((0.060562171079-0.443787477389j))
            arg[0, 1]+=(0.630332628364-0.818095623006j)*x[2]**o+((-0.993228219696+0.199076205073j))*x[2]
            ref[0, 1, 2]=(0.630332628364-0.818095623006j)*o*x_ref[2]**(o-1)+((-0.993228219696+0.199076205073j))
            arg[1, 0]+=(0.451270765907-0.583557646061j)*x[2]**o+((-0.380067652493+0.743558085572j))*x[2]
            ref[1, 0, 2]=(0.451270765907-0.583557646061j)*o*x_ref[2]**(o-1)+((-0.380067652493+0.743558085572j))
            arg[1, 1]+=(-0.334316965777-0.228576713717j)*x[2]**o+((-0.309093780747+0.409484708658j))*x[2]
            ref[1, 1, 2]=(-0.334316965777-0.228576713717j)*o*x_ref[2]**(o-1)+((-0.309093780747+0.409484708658j))
            arg[2, 0]+=(0.124898202963+0.222856289545j)*x[2]**o+((0.824098757584+0.337591801417j))*x[2]
            ref[2, 0, 2]=(0.124898202963+0.222856289545j)*o*x_ref[2]**(o-1)+((0.824098757584+0.337591801417j))
            arg[2, 1]+=(0.653672492775+0.464277456287j)*x[2]**o+((0.0420739073059+0.917884208569j))*x[2]
            ref[2, 1, 2]=(0.653672492775+0.464277456287j)*o*x_ref[2]**(o-1)+((0.0420739073059+0.917884208569j))
            arg[3, 0]+=(0.0988267972099-0.80757052561j)*x[2]**o+((0.088135949423-0.39592708915j))*x[2]
            ref[3, 0, 2]=(0.0988267972099-0.80757052561j)*o*x_ref[2]**(o-1)+((0.088135949423-0.39592708915j))
            arg[3, 1]+=(0.947142956484+0.909422751822j)*x[2]**o+((-0.479690618394-0.213651268862j))*x[2]
            ref[3, 1, 2]=(0.947142956484+0.909422751822j)*o*x_ref[2]**(o-1)+((-0.479690618394-0.213651268862j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4, 2)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnBoundary_fromData_ContinuousFunction_rank3(self):
        """
        tests gradient of rank 3 Data on FunctionOnBoundary

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(3, 2, 2),w)
        ref = Data(0,(3, 2, 2)+(dim,),w_ref)
        arg[0, 0, 0]=(-0.973809891078+0.555173742097j)*x[0]**o+((-0.828356046582-0.0628862563956j))*x[0]+((0.125594818429+0.925468645317j))*x[1]**o+((0.392169450389-0.558866081155j))*x[1]
        ref[0, 0, 0, 0]=(-0.973809891078+0.555173742097j)*o*x_ref[0]**(o-1)+((-0.828356046582-0.0628862563956j))
        ref[0, 0, 0, 1]=(0.125594818429+0.925468645317j)*o*x_ref[1]**(o-1)+((0.392169450389-0.558866081155j))
        arg[0, 0, 1]=(0.27639605649+0.182057949853j)*x[0]**o+((0.797129739851-0.513215807126j))*x[0]+((0.348329349305-0.358588438313j))*x[1]**o+((0.469193755137-0.413042474031j))*x[1]
        ref[0, 0, 1, 0]=(0.27639605649+0.182057949853j)*o*x_ref[0]**(o-1)+((0.797129739851-0.513215807126j))
        ref[0, 0, 1, 1]=(0.348329349305-0.358588438313j)*o*x_ref[1]**(o-1)+((0.469193755137-0.413042474031j))
        arg[0, 1, 0]=(-0.128717726325+0.307228950241j)*x[0]**o+((-0.412804122551+0.0270750053796j))*x[0]+((-0.898280120262+0.959901192309j))*x[1]**o+((0.584664554792-0.499840303064j))*x[1]
        ref[0, 1, 0, 0]=(-0.128717726325+0.307228950241j)*o*x_ref[0]**(o-1)+((-0.412804122551+0.0270750053796j))
        ref[0, 1, 0, 1]=(-0.898280120262+0.959901192309j)*o*x_ref[1]**(o-1)+((0.584664554792-0.499840303064j))
        arg[0, 1, 1]=(0.216038664506+0.199383145347j)*x[0]**o+((0.804823134415-0.0605114568052j))*x[0]+((-0.250750100984-0.949287957631j))*x[1]**o+((-0.281724233275+0.210640072273j))*x[1]
        ref[0, 1, 1, 0]=(0.216038664506+0.199383145347j)*o*x_ref[0]**(o-1)+((0.804823134415-0.0605114568052j))
        ref[0, 1, 1, 1]=(-0.250750100984-0.949287957631j)*o*x_ref[1]**(o-1)+((-0.281724233275+0.210640072273j))
        arg[1, 0, 0]=(0.0358271001374-0.230669702877j)*x[0]**o+((0.22289525611+0.228083191183j))*x[0]+((-0.485529080798-0.235909305306j))*x[1]**o+((-0.976996077828-0.921107750937j))*x[1]
        ref[1, 0, 0, 0]=(0.0358271001374-0.230669702877j)*o*x_ref[0]**(o-1)+((0.22289525611+0.228083191183j))
        ref[1, 0, 0, 1]=(-0.485529080798-0.235909305306j)*o*x_ref[1]**(o-1)+((-0.976996077828-0.921107750937j))
        arg[1, 0, 1]=(0.980228534329+0.103535832677j)*x[0]**o+((-0.356624537329-0.593327580961j))*x[0]+((-0.289235169343-0.143021240115j))*x[1]**o+((0.114125605359+0.354129491881j))*x[1]
        ref[1, 0, 1, 0]=(0.980228534329+0.103535832677j)*o*x_ref[0]**(o-1)+((-0.356624537329-0.593327580961j))
        ref[1, 0, 1, 1]=(-0.289235169343-0.143021240115j)*o*x_ref[1]**(o-1)+((0.114125605359+0.354129491881j))
        arg[1, 1, 0]=(-0.124104458905+0.702763161131j)*x[0]**o+((0.304307313234-0.105282354406j))*x[0]+((-0.996801084648-0.29101280662j))*x[1]**o+((0.181908436866-0.573019363806j))*x[1]
        ref[1, 1, 0, 0]=(-0.124104458905+0.702763161131j)*o*x_ref[0]**(o-1)+((0.304307313234-0.105282354406j))
        ref[1, 1, 0, 1]=(-0.996801084648-0.29101280662j)*o*x_ref[1]**(o-1)+((0.181908436866-0.573019363806j))
        arg[1, 1, 1]=(0.877547254672+0.352753145453j)*x[0]**o+((0.843167297652-0.159399767809j))*x[0]+((-0.733393313757-0.75649834205j))*x[1]**o+((0.509736945118-0.920892842438j))*x[1]
        ref[1, 1, 1, 0]=(0.877547254672+0.352753145453j)*o*x_ref[0]**(o-1)+((0.843167297652-0.159399767809j))
        ref[1, 1, 1, 1]=(-0.733393313757-0.75649834205j)*o*x_ref[1]**(o-1)+((0.509736945118-0.920892842438j))
        arg[2, 0, 0]=(0.423415147999-0.426057072389j)*x[0]**o+((0.944042836508-0.789101226784j))*x[0]+((0.0547055269791+0.472915026694j))*x[1]**o+((0.00286989180349+0.278698866306j))*x[1]
        ref[2, 0, 0, 0]=(0.423415147999-0.426057072389j)*o*x_ref[0]**(o-1)+((0.944042836508-0.789101226784j))
        ref[2, 0, 0, 1]=(0.0547055269791+0.472915026694j)*o*x_ref[1]**(o-1)+((0.00286989180349+0.278698866306j))
        arg[2, 0, 1]=(0.707288527098+0.0569085160615j)*x[0]**o+((-0.887676159914+0.765861091021j))*x[0]+((-0.615767702962+0.150420688096j))*x[1]**o+((0.227437312074-0.447889386939j))*x[1]
        ref[2, 0, 1, 0]=(0.707288527098+0.0569085160615j)*o*x_ref[0]**(o-1)+((-0.887676159914+0.765861091021j))
        ref[2, 0, 1, 1]=(-0.615767702962+0.150420688096j)*o*x_ref[1]**(o-1)+((0.227437312074-0.447889386939j))
        arg[2, 1, 0]=(-0.195578506822+0.648525556944j)*x[0]**o+((0.563348815168+0.484474196133j))*x[0]+((-0.535320672808+0.267955840311j))*x[1]**o+((-0.647359056151-0.288748556484j))*x[1]
        ref[2, 1, 0, 0]=(-0.195578506822+0.648525556944j)*o*x_ref[0]**(o-1)+((0.563348815168+0.484474196133j))
        ref[2, 1, 0, 1]=(-0.535320672808+0.267955840311j)*o*x_ref[1]**(o-1)+((-0.647359056151-0.288748556484j))
        arg[2, 1, 1]=(0.770547909301-0.873675918554j)*x[0]**o+((0.303832873223-0.274797704697j))*x[0]+((-0.307070318593-0.650287037086j))*x[1]**o+((0.779411597088+0.0904718722945j))*x[1]
        ref[2, 1, 1, 0]=(0.770547909301-0.873675918554j)*o*x_ref[0]**(o-1)+((0.303832873223-0.274797704697j))
        ref[2, 1, 1, 1]=(-0.307070318593-0.650287037086j)*o*x_ref[1]**(o-1)+((0.779411597088+0.0904718722945j))
        if dim==3:
            arg[0, 0, 0]+=(0.0383456340772-0.257915041615j)*x[2]**o+((0.369437370311+0.219855249149j))*x[2]
            ref[0, 0, 0, 2]=(0.0383456340772-0.257915041615j)*o*x_ref[2]**(o-1)+((0.369437370311+0.219855249149j))
            arg[0, 0, 1]+=(0.41064878064-0.71545454766j)*x[2]**o+((0.709313232075+0.85215879214j))*x[2]
            ref[0, 0, 1, 2]=(0.41064878064-0.71545454766j)*o*x_ref[2]**(o-1)+((0.709313232075+0.85215879214j))
            arg[0, 1, 0]+=(0.878045134027-0.601620090392j)*x[2]**o+((0.498703510653-0.931894517614j))*x[2]
            ref[0, 1, 0, 2]=(0.878045134027-0.601620090392j)*o*x_ref[2]**(o-1)+((0.498703510653-0.931894517614j))
            arg[0, 1, 1]+=(0.256937127824+0.0812824394107j)*x[2]**o+((0.0787553207236-0.91842302655j))*x[2]
            ref[0, 1, 1, 2]=(0.256937127824+0.0812824394107j)*o*x_ref[2]**(o-1)+((0.0787553207236-0.91842302655j))
            arg[1, 0, 0]+=(-0.365790409606-0.171484497074j)*x[2]**o+((-0.597111917377+0.378412148742j))*x[2]
            ref[1, 0, 0, 2]=(-0.365790409606-0.171484497074j)*o*x_ref[2]**(o-1)+((-0.597111917377+0.378412148742j))
            arg[1, 0, 1]+=(-0.151252072668-0.0700652296251j)*x[2]**o+((-0.246826720895-0.693051813047j))*x[2]
            ref[1, 0, 1, 2]=(-0.151252072668-0.0700652296251j)*o*x_ref[2]**(o-1)+((-0.246826720895-0.693051813047j))
            arg[1, 1, 0]+=(0.462157545749+0.630684161721j)*x[2]**o+((-0.261644373748+0.895109564653j))*x[2]
            ref[1, 1, 0, 2]=(0.462157545749+0.630684161721j)*o*x_ref[2]**(o-1)+((-0.261644373748+0.895109564653j))
            arg[1, 1, 1]+=(-0.513524827254-0.739050600329j)*x[2]**o+((-0.798708731499-0.983420344466j))*x[2]
            ref[1, 1, 1, 2]=(-0.513524827254-0.739050600329j)*o*x_ref[2]**(o-1)+((-0.798708731499-0.983420344466j))
            arg[2, 0, 0]+=(0.7060953069-0.396276374626j)*x[2]**o+((-0.145957486332+0.450693396436j))*x[2]
            ref[2, 0, 0, 2]=(0.7060953069-0.396276374626j)*o*x_ref[2]**(o-1)+((-0.145957486332+0.450693396436j))
            arg[2, 0, 1]+=(0.215388878608-0.585959318206j)*x[2]**o+((-0.436522130746-0.738615374952j))*x[2]
            ref[2, 0, 1, 2]=(0.215388878608-0.585959318206j)*o*x_ref[2]**(o-1)+((-0.436522130746-0.738615374952j))
            arg[2, 1, 0]+=(0.0442743133629+0.983229179037j)*x[2]**o+((0.230621482946-0.288043001472j))*x[2]
            ref[2, 1, 0, 2]=(0.0442743133629+0.983229179037j)*o*x_ref[2]**(o-1)+((0.230621482946-0.288043001472j))
            arg[2, 1, 1]+=(-0.767252705737-0.857444629301j)*x[2]**o+((-0.548533149201+0.657541599614j))*x[2]
            ref[2, 1, 1, 2]=(-0.767252705737-0.857444629301j)*o*x_ref[2]**(o-1)+((-0.548533149201+0.657541599614j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3, 2, 2)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnBoundary_fromData_Solution_rank0(self):
        """
        tests gradient of rank 0 Data on FunctionOnBoundary

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=(-0.590931346148+0.694091789156j)*x[0]**o+((0.922551444926+0.940019722427j))*x[0]+((0.295358871078+0.909557672198j))*x[1]**o+((0.953870526353-0.346617732007j))*x[1]
        ref[0]=(-0.590931346148+0.694091789156j)*o*x_ref[0]**(o-1)+((0.922551444926+0.940019722427j))
        ref[1]=(0.295358871078+0.909557672198j)*o*x_ref[1]**(o-1)+((0.953870526353-0.346617732007j))
        if dim==3:
            arg+=((-0.565642336941-0.192709218661j))*x[2]**o+((0.852713563755+0.00873774880446j))*x[2]
            ref[2]=(-0.565642336941-0.192709218661j)*o*x_ref[2]**(o-1)+((0.852713563755+0.00873774880446j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnBoundary_fromData_Solution_rank1(self):
        """
        tests gradient of rank 1 Data on FunctionOnBoundary

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(2,),w)
        ref = Data(0,(2,)+(dim,),w_ref)
        arg[0,]=(-0.646298389643+0.407102816399j)*x[0]**o+((-0.378100814793-0.81169671534j))*x[0]+((-0.961954418425+0.62785783252j))*x[1]**o+((0.265731794962+0.235538263711j))*x[1]
        ref[0, 0]=(-0.646298389643+0.407102816399j)*o*x_ref[0]**(o-1)+((-0.378100814793-0.81169671534j))
        ref[0, 1]=(-0.961954418425+0.62785783252j)*o*x_ref[1]**(o-1)+((0.265731794962+0.235538263711j))
        arg[1,]=(0.0327349529061-0.644310687518j)*x[0]**o+((-0.859441406597-0.97343451792j))*x[0]+((0.395743978365-0.722886847108j))*x[1]**o+((0.159034671832-0.527755252629j))*x[1]
        ref[1, 0]=(0.0327349529061-0.644310687518j)*o*x_ref[0]**(o-1)+((-0.859441406597-0.97343451792j))
        ref[1, 1]=(0.395743978365-0.722886847108j)*o*x_ref[1]**(o-1)+((0.159034671832-0.527755252629j))
        if dim==3:
            arg[0,]+=(-0.00385026404304-0.736859069018j)*x[2]**o+((-0.139051967205-0.863543550475j))*x[2]
            ref[0, 2]=(-0.00385026404304-0.736859069018j)*o*x_ref[2]**(o-1)+((-0.139051967205-0.863543550475j))
            arg[1,]+=(0.897168452908-0.538028382978j)*x[2]**o+((0.874850294987-0.325247637207j))*x[2]
            ref[1, 2]=(0.897168452908-0.538028382978j)*o*x_ref[2]**(o-1)+((0.874850294987-0.325247637207j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnBoundary_fromData_Solution_rank2(self):
        """
        tests gradient of rank 2 Data on FunctionOnBoundary

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(3, 3),w)
        ref = Data(0,(3, 3)+(dim,),w_ref)
        arg[0, 0]=(-0.652498974703-0.57155734412j)*x[0]**o+((-0.06830685412-0.609496873841j))*x[0]+((-0.864807403266-0.514235856698j))*x[1]**o+((0.588659062035+0.0754414027649j))*x[1]
        ref[0, 0, 0]=(-0.652498974703-0.57155734412j)*o*x_ref[0]**(o-1)+((-0.06830685412-0.609496873841j))
        ref[0, 0, 1]=(-0.864807403266-0.514235856698j)*o*x_ref[1]**(o-1)+((0.588659062035+0.0754414027649j))
        arg[0, 1]=(-0.17347095133-0.171961686705j)*x[0]**o+((-0.837807985221-0.993010709548j))*x[0]+((-0.147008766373+0.819372090189j))*x[1]**o+((-0.495300030064+0.237331490969j))*x[1]
        ref[0, 1, 0]=(-0.17347095133-0.171961686705j)*o*x_ref[0]**(o-1)+((-0.837807985221-0.993010709548j))
        ref[0, 1, 1]=(-0.147008766373+0.819372090189j)*o*x_ref[1]**(o-1)+((-0.495300030064+0.237331490969j))
        arg[0, 2]=(0.165333950654-0.0082193570422j)*x[0]**o+((-0.309902992798-0.165230198015j))*x[0]+((-0.34335680136-0.77127088815j))*x[1]**o+((0.23808555508-0.511059474582j))*x[1]
        ref[0, 2, 0]=(0.165333950654-0.0082193570422j)*o*x_ref[0]**(o-1)+((-0.309902992798-0.165230198015j))
        ref[0, 2, 1]=(-0.34335680136-0.77127088815j)*o*x_ref[1]**(o-1)+((0.23808555508-0.511059474582j))
        arg[1, 0]=(0.912005737227+0.965779138076j)*x[0]**o+((-0.636823732031+0.575068502657j))*x[0]+((0.896274543248-0.289797235513j))*x[1]**o+((-0.121556255746+0.988435164766j))*x[1]
        ref[1, 0, 0]=(0.912005737227+0.965779138076j)*o*x_ref[0]**(o-1)+((-0.636823732031+0.575068502657j))
        ref[1, 0, 1]=(0.896274543248-0.289797235513j)*o*x_ref[1]**(o-1)+((-0.121556255746+0.988435164766j))
        arg[1, 1]=(0.567671777851+0.308656777432j)*x[0]**o+((-0.963353140711-0.613068927029j))*x[0]+((-0.173556908757-0.0494550767172j))*x[1]**o+((0.0493992336612+0.0740932042799j))*x[1]
        ref[1, 1, 0]=(0.567671777851+0.308656777432j)*o*x_ref[0]**(o-1)+((-0.963353140711-0.613068927029j))
        ref[1, 1, 1]=(-0.173556908757-0.0494550767172j)*o*x_ref[1]**(o-1)+((0.0493992336612+0.0740932042799j))
        arg[1, 2]=(0.748987250678-0.636669116493j)*x[0]**o+((0.401589857064-0.120957943163j))*x[0]+((0.102596382373-0.696914579082j))*x[1]**o+((0.934956874255-0.599617696659j))*x[1]
        ref[1, 2, 0]=(0.748987250678-0.636669116493j)*o*x_ref[0]**(o-1)+((0.401589857064-0.120957943163j))
        ref[1, 2, 1]=(0.102596382373-0.696914579082j)*o*x_ref[1]**(o-1)+((0.934956874255-0.599617696659j))
        arg[2, 0]=(-0.707382452152+0.272428851221j)*x[0]**o+((0.157023805949-0.894655159219j))*x[0]+((-0.940676738715+0.444802489653j))*x[1]**o+((-0.701956007323+0.808099869429j))*x[1]
        ref[2, 0, 0]=(-0.707382452152+0.272428851221j)*o*x_ref[0]**(o-1)+((0.157023805949-0.894655159219j))
        ref[2, 0, 1]=(-0.940676738715+0.444802489653j)*o*x_ref[1]**(o-1)+((-0.701956007323+0.808099869429j))
        arg[2, 1]=(-0.381693723957-0.0490291489321j)*x[0]**o+((0.172398182222+0.48014028938j))*x[0]+((0.656500012961+0.622817770851j))*x[1]**o+((-0.9422338137-0.0500599712609j))*x[1]
        ref[2, 1, 0]=(-0.381693723957-0.0490291489321j)*o*x_ref[0]**(o-1)+((0.172398182222+0.48014028938j))
        ref[2, 1, 1]=(0.656500012961+0.622817770851j)*o*x_ref[1]**(o-1)+((-0.9422338137-0.0500599712609j))
        arg[2, 2]=(0.535242471085+0.608113486979j)*x[0]**o+((-0.708259804094-0.690401618323j))*x[0]+((0.0870127802725-0.291979027676j))*x[1]**o+((0.227431909074-0.903400053231j))*x[1]
        ref[2, 2, 0]=(0.535242471085+0.608113486979j)*o*x_ref[0]**(o-1)+((-0.708259804094-0.690401618323j))
        ref[2, 2, 1]=(0.0870127802725-0.291979027676j)*o*x_ref[1]**(o-1)+((0.227431909074-0.903400053231j))
        if dim==3:
            arg[0, 0]+=(0.824827584823-0.545024985749j)*x[2]**o+((0.380259969367+0.0247361429212j))*x[2]
            ref[0, 0, 2]=(0.824827584823-0.545024985749j)*o*x_ref[2]**(o-1)+((0.380259969367+0.0247361429212j))
            arg[0, 1]+=(0.811899468948+0.994919112177j)*x[2]**o+((-0.808636933415-0.245263889718j))*x[2]
            ref[0, 1, 2]=(0.811899468948+0.994919112177j)*o*x_ref[2]**(o-1)+((-0.808636933415-0.245263889718j))
            arg[0, 2]+=(-0.938191091332+0.908760730291j)*x[2]**o+((0.378568221649+0.662079670342j))*x[2]
            ref[0, 2, 2]=(-0.938191091332+0.908760730291j)*o*x_ref[2]**(o-1)+((0.378568221649+0.662079670342j))
            arg[1, 0]+=(0.752759630593+0.12440348j)*x[2]**o+((-0.0643028990759-0.51458681758j))*x[2]
            ref[1, 0, 2]=(0.752759630593+0.12440348j)*o*x_ref[2]**(o-1)+((-0.0643028990759-0.51458681758j))
            arg[1, 1]+=(-0.0161785327559-0.6785293112j)*x[2]**o+((-0.220108130908+0.172639209507j))*x[2]
            ref[1, 1, 2]=(-0.0161785327559-0.6785293112j)*o*x_ref[2]**(o-1)+((-0.220108130908+0.172639209507j))
            arg[1, 2]+=(0.507080928159+0.384478778319j)*x[2]**o+((-0.020337831644+0.870478941815j))*x[2]
            ref[1, 2, 2]=(0.507080928159+0.384478778319j)*o*x_ref[2]**(o-1)+((-0.020337831644+0.870478941815j))
            arg[2, 0]+=(0.253943447823-0.903449290672j)*x[2]**o+((-0.744054984665-0.018847946177j))*x[2]
            ref[2, 0, 2]=(0.253943447823-0.903449290672j)*o*x_ref[2]**(o-1)+((-0.744054984665-0.018847946177j))
            arg[2, 1]+=(-0.0601041195461-0.132469406497j)*x[2]**o+((-0.0141698465531+0.134311210678j))*x[2]
            ref[2, 1, 2]=(-0.0601041195461-0.132469406497j)*o*x_ref[2]**(o-1)+((-0.0141698465531+0.134311210678j))
            arg[2, 2]+=(-0.0946378377448-0.97822288558j)*x[2]**o+((-0.806261790634+0.335323573718j))*x[2]
            ref[2, 2, 2]=(-0.0946378377448-0.97822288558j)*o*x_ref[2]**(o-1)+((-0.806261790634+0.335323573718j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3, 3)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnBoundary_fromData_Solution_rank3(self):
        """
        tests gradient of rank 3 Data on FunctionOnBoundary

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(2, 2, 2),w)
        ref = Data(0,(2, 2, 2)+(dim,),w_ref)
        arg[0, 0, 0]=(-0.410511086899-0.499667454384j)*x[0]**o+((-0.0153062770408+0.193588688735j))*x[0]+((0.000583112208866+0.975622771785j))*x[1]**o+((-0.0393747243729-0.238628724484j))*x[1]
        ref[0, 0, 0, 0]=(-0.410511086899-0.499667454384j)*o*x_ref[0]**(o-1)+((-0.0153062770408+0.193588688735j))
        ref[0, 0, 0, 1]=(0.000583112208866+0.975622771785j)*o*x_ref[1]**(o-1)+((-0.0393747243729-0.238628724484j))
        arg[0, 0, 1]=(0.134886235767-0.763731276242j)*x[0]**o+((0.982636540081-0.358558331828j))*x[0]+((-0.715928560595-0.733017012802j))*x[1]**o+((-0.416666046952-0.864738313562j))*x[1]
        ref[0, 0, 1, 0]=(0.134886235767-0.763731276242j)*o*x_ref[0]**(o-1)+((0.982636540081-0.358558331828j))
        ref[0, 0, 1, 1]=(-0.715928560595-0.733017012802j)*o*x_ref[1]**(o-1)+((-0.416666046952-0.864738313562j))
        arg[0, 1, 0]=(0.656807425649+0.217814098453j)*x[0]**o+((0.779886473334-0.886441062103j))*x[0]+((-0.02397297544-0.585401795602j))*x[1]**o+((-0.951517904496-0.821558637809j))*x[1]
        ref[0, 1, 0, 0]=(0.656807425649+0.217814098453j)*o*x_ref[0]**(o-1)+((0.779886473334-0.886441062103j))
        ref[0, 1, 0, 1]=(-0.02397297544-0.585401795602j)*o*x_ref[1]**(o-1)+((-0.951517904496-0.821558637809j))
        arg[0, 1, 1]=(-0.906602421431-0.568705801591j)*x[0]**o+((-0.426588553444+0.849844545199j))*x[0]+((0.0501855046407-0.617310803233j))*x[1]**o+((-0.937536711126+0.375605092894j))*x[1]
        ref[0, 1, 1, 0]=(-0.906602421431-0.568705801591j)*o*x_ref[0]**(o-1)+((-0.426588553444+0.849844545199j))
        ref[0, 1, 1, 1]=(0.0501855046407-0.617310803233j)*o*x_ref[1]**(o-1)+((-0.937536711126+0.375605092894j))
        arg[1, 0, 0]=(-0.57442671038+0.747443470066j)*x[0]**o+((0.0142344916093-0.551622359657j))*x[0]+((-0.974067431244-0.358807894264j))*x[1]**o+((-0.01237002021-0.852042097331j))*x[1]
        ref[1, 0, 0, 0]=(-0.57442671038+0.747443470066j)*o*x_ref[0]**(o-1)+((0.0142344916093-0.551622359657j))
        ref[1, 0, 0, 1]=(-0.974067431244-0.358807894264j)*o*x_ref[1]**(o-1)+((-0.01237002021-0.852042097331j))
        arg[1, 0, 1]=(0.893471346844-0.342645150657j)*x[0]**o+((-0.109342320443-0.133229903002j))*x[0]+((0.895766221676-0.755815560253j))*x[1]**o+((-0.566064654887+0.316086506835j))*x[1]
        ref[1, 0, 1, 0]=(0.893471346844-0.342645150657j)*o*x_ref[0]**(o-1)+((-0.109342320443-0.133229903002j))
        ref[1, 0, 1, 1]=(0.895766221676-0.755815560253j)*o*x_ref[1]**(o-1)+((-0.566064654887+0.316086506835j))
        arg[1, 1, 0]=(-0.685139555523-0.684958935987j)*x[0]**o+((0.843971371906+0.626067820387j))*x[0]+((-0.0968974923475-0.222084147422j))*x[1]**o+((0.757254422411-0.568306452645j))*x[1]
        ref[1, 1, 0, 0]=(-0.685139555523-0.684958935987j)*o*x_ref[0]**(o-1)+((0.843971371906+0.626067820387j))
        ref[1, 1, 0, 1]=(-0.0968974923475-0.222084147422j)*o*x_ref[1]**(o-1)+((0.757254422411-0.568306452645j))
        arg[1, 1, 1]=(0.879735324576-0.948406602766j)*x[0]**o+((0.22376540654-0.108046653724j))*x[0]+((0.22047261593+0.935954832312j))*x[1]**o+((0.111751999033-0.0608848273226j))*x[1]
        ref[1, 1, 1, 0]=(0.879735324576-0.948406602766j)*o*x_ref[0]**(o-1)+((0.22376540654-0.108046653724j))
        ref[1, 1, 1, 1]=(0.22047261593+0.935954832312j)*o*x_ref[1]**(o-1)+((0.111751999033-0.0608848273226j))
        if dim==3:
            arg[0, 0, 0]+=(0.0446061573373+0.14662947318j)*x[2]**o+((-0.804103760411+0.723879623116j))*x[2]
            ref[0, 0, 0, 2]=(0.0446061573373+0.14662947318j)*o*x_ref[2]**(o-1)+((-0.804103760411+0.723879623116j))
            arg[0, 0, 1]+=(-0.873929910736-0.171837822651j)*x[2]**o+((0.373961755212+0.534396275362j))*x[2]
            ref[0, 0, 1, 2]=(-0.873929910736-0.171837822651j)*o*x_ref[2]**(o-1)+((0.373961755212+0.534396275362j))
            arg[0, 1, 0]+=(-0.206126984036+0.0852507023825j)*x[2]**o+((-0.73326939186+0.924098396103j))*x[2]
            ref[0, 1, 0, 2]=(-0.206126984036+0.0852507023825j)*o*x_ref[2]**(o-1)+((-0.73326939186+0.924098396103j))
            arg[0, 1, 1]+=(0.576239011548-0.998801958938j)*x[2]**o+((0.299286126038+0.936191854044j))*x[2]
            ref[0, 1, 1, 2]=(0.576239011548-0.998801958938j)*o*x_ref[2]**(o-1)+((0.299286126038+0.936191854044j))
            arg[1, 0, 0]+=(0.266601497408-0.929208294662j)*x[2]**o+((0.276508302979-0.327835881973j))*x[2]
            ref[1, 0, 0, 2]=(0.266601497408-0.929208294662j)*o*x_ref[2]**(o-1)+((0.276508302979-0.327835881973j))
            arg[1, 0, 1]+=(-0.869850539892-0.120807327318j)*x[2]**o+((-0.222829626005+0.74564409048j))*x[2]
            ref[1, 0, 1, 2]=(-0.869850539892-0.120807327318j)*o*x_ref[2]**(o-1)+((-0.222829626005+0.74564409048j))
            arg[1, 1, 0]+=(-0.5596356227-0.641252727451j)*x[2]**o+((-0.197107346247-0.182199488023j))*x[2]
            ref[1, 1, 0, 2]=(-0.5596356227-0.641252727451j)*o*x_ref[2]**(o-1)+((-0.197107346247-0.182199488023j))
            arg[1, 1, 1]+=(-0.483318251334+0.20263271444j)*x[2]**o+((0.308846241436+0.0605328585231j))*x[2]
            ref[1, 1, 1, 2]=(-0.483318251334+0.20263271444j)*o*x_ref[2]**(o-1)+((0.308846241436+0.0605328585231j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2, 2, 2)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnBoundary_fromData_ReducedSolution_rank0(self):
        """
        tests gradient of rank 0 Data on FunctionOnBoundary

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=(0.396000759416-0.40309451929j)*x[0]+((0.177041737883+0.599834423692j))*x[1]
        ref[0]=(0.396000759416-0.40309451929j)
        ref[1]=(0.177041737883+0.599834423692j)
        if dim==3:
            arg+=((0.925994114172+0.0133036763164j))*x[2]
            ref[2]=(0.925994114172+0.0133036763164j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnBoundary_fromData_ReducedSolution_rank1(self):
        """
        tests gradient of rank 1 Data on FunctionOnBoundary

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(4,),w)
        ref = Data(0,(4,)+(dim,),w_ref)
        arg[0,]=(-0.877746500915-0.479756479038j)*x[0]+((-0.536281328855+0.0449819971131j))*x[1]
        ref[0, 0]=(-0.877746500915-0.479756479038j)
        ref[0, 1]=(-0.536281328855+0.0449819971131j)
        arg[1,]=(0.380474551868-0.00123097049293j)*x[0]+((0.567371303949-0.257576519808j))*x[1]
        ref[1, 0]=(0.380474551868-0.00123097049293j)
        ref[1, 1]=(0.567371303949-0.257576519808j)
        arg[2,]=(-0.885790304943+0.374814512372j)*x[0]+((-0.0664262535372-0.381504825267j))*x[1]
        ref[2, 0]=(-0.885790304943+0.374814512372j)
        ref[2, 1]=(-0.0664262535372-0.381504825267j)
        arg[3,]=(-0.177666668374-0.33014620832j)*x[0]+((-0.488513709195+0.0590012144647j))*x[1]
        ref[3, 0]=(-0.177666668374-0.33014620832j)
        ref[3, 1]=(-0.488513709195+0.0590012144647j)
        if dim==3:
            arg[0,]+=(0.656441282833+0.393619903331j)*x[2]
            ref[0, 2]=(0.656441282833+0.393619903331j)
            arg[1,]+=(-0.607951922034-0.926116176417j)*x[2]
            ref[1, 2]=(-0.607951922034-0.926116176417j)
            arg[2,]+=(-0.31366245821-0.50426991289j)*x[2]
            ref[2, 2]=(-0.31366245821-0.50426991289j)
            arg[3,]+=(-0.63446578347+0.793949998496j)*x[2]
            ref[3, 2]=(-0.63446578347+0.793949998496j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnBoundary_fromData_ReducedSolution_rank2(self):
        """
        tests gradient of rank 2 Data on FunctionOnBoundary

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(3, 4),w)
        ref = Data(0,(3, 4)+(dim,),w_ref)
        arg[0, 0]=(0.0391240039814-0.426479121156j)*x[0]+((-0.168823086721-0.822661982119j))*x[1]
        ref[0, 0, 0]=(0.0391240039814-0.426479121156j)
        ref[0, 0, 1]=(-0.168823086721-0.822661982119j)
        arg[0, 1]=(-0.938225792445+0.909400005524j)*x[0]+((0.675244141044-0.874431808677j))*x[1]
        ref[0, 1, 0]=(-0.938225792445+0.909400005524j)
        ref[0, 1, 1]=(0.675244141044-0.874431808677j)
        arg[0, 2]=(0.853975629741+0.0446015902877j)*x[0]+((0.364163547872+0.705343403735j))*x[1]
        ref[0, 2, 0]=(0.853975629741+0.0446015902877j)
        ref[0, 2, 1]=(0.364163547872+0.705343403735j)
        arg[0, 3]=(-0.463421908902+0.896997658293j)*x[0]+((-0.298646331808-0.0999440551672j))*x[1]
        ref[0, 3, 0]=(-0.463421908902+0.896997658293j)
        ref[0, 3, 1]=(-0.298646331808-0.0999440551672j)
        arg[1, 0]=(-0.3623828179+0.308365117696j)*x[0]+((0.922114489257+0.0451083931849j))*x[1]
        ref[1, 0, 0]=(-0.3623828179+0.308365117696j)
        ref[1, 0, 1]=(0.922114489257+0.0451083931849j)
        arg[1, 1]=(-0.15359177238+0.948159540189j)*x[0]+((-0.430501700578+0.963125622708j))*x[1]
        ref[1, 1, 0]=(-0.15359177238+0.948159540189j)
        ref[1, 1, 1]=(-0.430501700578+0.963125622708j)
        arg[1, 2]=(-0.945832184059+0.0101687331884j)*x[0]+((-0.0192750244289-0.138859242362j))*x[1]
        ref[1, 2, 0]=(-0.945832184059+0.0101687331884j)
        ref[1, 2, 1]=(-0.0192750244289-0.138859242362j)
        arg[1, 3]=(0.0398896348177-0.585863142446j)*x[0]+((0.975198386115-0.391198148832j))*x[1]
        ref[1, 3, 0]=(0.0398896348177-0.585863142446j)
        ref[1, 3, 1]=(0.975198386115-0.391198148832j)
        arg[2, 0]=(-0.471416486262-0.454809543905j)*x[0]+((-0.81070986811-0.125937896187j))*x[1]
        ref[2, 0, 0]=(-0.471416486262-0.454809543905j)
        ref[2, 0, 1]=(-0.81070986811-0.125937896187j)
        arg[2, 1]=(0.533435570337-0.318770201642j)*x[0]+((0.00903270697074-0.275996767944j))*x[1]
        ref[2, 1, 0]=(0.533435570337-0.318770201642j)
        ref[2, 1, 1]=(0.00903270697074-0.275996767944j)
        arg[2, 2]=(0.732701409973-0.520281676325j)*x[0]+((-0.79583987648-0.0550018983441j))*x[1]
        ref[2, 2, 0]=(0.732701409973-0.520281676325j)
        ref[2, 2, 1]=(-0.79583987648-0.0550018983441j)
        arg[2, 3]=(-0.44498976891+0.55335332841j)*x[0]+((0.873105143095-0.665006364139j))*x[1]
        ref[2, 3, 0]=(-0.44498976891+0.55335332841j)
        ref[2, 3, 1]=(0.873105143095-0.665006364139j)
        if dim==3:
            arg[0, 0]+=(0.849928819809-0.832780645951j)*x[2]
            ref[0, 0, 2]=(0.849928819809-0.832780645951j)
            arg[0, 1]+=(-0.547453389021-0.341176676307j)*x[2]
            ref[0, 1, 2]=(-0.547453389021-0.341176676307j)
            arg[0, 2]+=(-0.723571910169+0.152301894691j)*x[2]
            ref[0, 2, 2]=(-0.723571910169+0.152301894691j)
            arg[0, 3]+=(0.112575319585-0.929833134226j)*x[2]
            ref[0, 3, 2]=(0.112575319585-0.929833134226j)
            arg[1, 0]+=(-0.225096115828-0.670374757709j)*x[2]
            ref[1, 0, 2]=(-0.225096115828-0.670374757709j)
            arg[1, 1]+=(0.871894631613+0.801862377113j)*x[2]
            ref[1, 1, 2]=(0.871894631613+0.801862377113j)
            arg[1, 2]+=(-0.660434289677-0.731817611161j)*x[2]
            ref[1, 2, 2]=(-0.660434289677-0.731817611161j)
            arg[1, 3]+=(0.643829156994-0.641862810126j)*x[2]
            ref[1, 3, 2]=(0.643829156994-0.641862810126j)
            arg[2, 0]+=(0.441660226319-0.0427340184302j)*x[2]
            ref[2, 0, 2]=(0.441660226319-0.0427340184302j)
            arg[2, 1]+=(0.565068591785-0.110037552348j)*x[2]
            ref[2, 1, 2]=(0.565068591785-0.110037552348j)
            arg[2, 2]+=(0.484226067979-0.504889016886j)*x[2]
            ref[2, 2, 2]=(0.484226067979-0.504889016886j)
            arg[2, 3]+=(-0.83858787361-0.479759402087j)*x[2]
            ref[2, 3, 2]=(-0.83858787361-0.479759402087j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3, 4)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnBoundary_fromData_ReducedSolution_rank3(self):
        """
        tests gradient of rank 3 Data on FunctionOnBoundary

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(2, 3, 3),w)
        ref = Data(0,(2, 3, 3)+(dim,),w_ref)
        arg[0, 0, 0]=(0.381773025828+0.890666746511j)*x[0]+((0.73031489001+0.442091371305j))*x[1]
        ref[0, 0, 0, 0]=(0.381773025828+0.890666746511j)
        ref[0, 0, 0, 1]=(0.73031489001+0.442091371305j)
        arg[0, 0, 1]=(0.0236629897178+0.382557436299j)*x[0]+((-0.28193988497+0.0916590799877j))*x[1]
        ref[0, 0, 1, 0]=(0.0236629897178+0.382557436299j)
        ref[0, 0, 1, 1]=(-0.28193988497+0.0916590799877j)
        arg[0, 0, 2]=(-0.277770631767+0.339586560716j)*x[0]+((0.599121763213-0.708584703056j))*x[1]
        ref[0, 0, 2, 0]=(-0.277770631767+0.339586560716j)
        ref[0, 0, 2, 1]=(0.599121763213-0.708584703056j)
        arg[0, 1, 0]=(-0.0739053724469-0.251426172528j)*x[0]+((0.0271974353242+0.2867699308j))*x[1]
        ref[0, 1, 0, 0]=(-0.0739053724469-0.251426172528j)
        ref[0, 1, 0, 1]=(0.0271974353242+0.2867699308j)
        arg[0, 1, 1]=(-0.960416041255+0.430811815116j)*x[0]+((0.356353747455+0.0625891659394j))*x[1]
        ref[0, 1, 1, 0]=(-0.960416041255+0.430811815116j)
        ref[0, 1, 1, 1]=(0.356353747455+0.0625891659394j)
        arg[0, 1, 2]=(-0.51260510163+0.276172152265j)*x[0]+((-0.519007835681+0.929637186942j))*x[1]
        ref[0, 1, 2, 0]=(-0.51260510163+0.276172152265j)
        ref[0, 1, 2, 1]=(-0.519007835681+0.929637186942j)
        arg[0, 2, 0]=(-0.112977154088-0.642077287418j)*x[0]+((0.0483095423544+0.207530167073j))*x[1]
        ref[0, 2, 0, 0]=(-0.112977154088-0.642077287418j)
        ref[0, 2, 0, 1]=(0.0483095423544+0.207530167073j)
        arg[0, 2, 1]=(-0.170076907489+0.534527212412j)*x[0]+((-0.385923584392-0.671677472834j))*x[1]
        ref[0, 2, 1, 0]=(-0.170076907489+0.534527212412j)
        ref[0, 2, 1, 1]=(-0.385923584392-0.671677472834j)
        arg[0, 2, 2]=(0.030713467272-0.178051484869j)*x[0]+((0.471995111846-0.0244682439942j))*x[1]
        ref[0, 2, 2, 0]=(0.030713467272-0.178051484869j)
        ref[0, 2, 2, 1]=(0.471995111846-0.0244682439942j)
        arg[1, 0, 0]=(-0.400180171128+0.932482838065j)*x[0]+((-0.84310560723-0.603340243023j))*x[1]
        ref[1, 0, 0, 0]=(-0.400180171128+0.932482838065j)
        ref[1, 0, 0, 1]=(-0.84310560723-0.603340243023j)
        arg[1, 0, 1]=(0.68750990574-0.864920136169j)*x[0]+((-0.348690930005-0.410123319832j))*x[1]
        ref[1, 0, 1, 0]=(0.68750990574-0.864920136169j)
        ref[1, 0, 1, 1]=(-0.348690930005-0.410123319832j)
        arg[1, 0, 2]=(-0.407477799796-0.545500610485j)*x[0]+((-0.620244945671+0.039990402211j))*x[1]
        ref[1, 0, 2, 0]=(-0.407477799796-0.545500610485j)
        ref[1, 0, 2, 1]=(-0.620244945671+0.039990402211j)
        arg[1, 1, 0]=(0.557448230327-0.360632429805j)*x[0]+((-0.46147426156+0.540596211317j))*x[1]
        ref[1, 1, 0, 0]=(0.557448230327-0.360632429805j)
        ref[1, 1, 0, 1]=(-0.46147426156+0.540596211317j)
        arg[1, 1, 1]=(0.996940918783+0.574246460022j)*x[0]+((-0.195129751668-0.235012925118j))*x[1]
        ref[1, 1, 1, 0]=(0.996940918783+0.574246460022j)
        ref[1, 1, 1, 1]=(-0.195129751668-0.235012925118j)
        arg[1, 1, 2]=(-0.503665134645-0.675147765815j)*x[0]+((-0.311503097366-0.516148925041j))*x[1]
        ref[1, 1, 2, 0]=(-0.503665134645-0.675147765815j)
        ref[1, 1, 2, 1]=(-0.311503097366-0.516148925041j)
        arg[1, 2, 0]=(0.411461324797+0.189521164042j)*x[0]+((-0.570243841387+0.75639561732j))*x[1]
        ref[1, 2, 0, 0]=(0.411461324797+0.189521164042j)
        ref[1, 2, 0, 1]=(-0.570243841387+0.75639561732j)
        arg[1, 2, 1]=(0.883339316652+0.690758719796j)*x[0]+((-0.326493176415-0.38086891447j))*x[1]
        ref[1, 2, 1, 0]=(0.883339316652+0.690758719796j)
        ref[1, 2, 1, 1]=(-0.326493176415-0.38086891447j)
        arg[1, 2, 2]=(0.988218674239-0.0676182632276j)*x[0]+((-0.690712992444-0.0481543281459j))*x[1]
        ref[1, 2, 2, 0]=(0.988218674239-0.0676182632276j)
        ref[1, 2, 2, 1]=(-0.690712992444-0.0481543281459j)
        if dim==3:
            arg[0, 0, 0]+=(0.699087081376-0.420117146247j)*x[2]
            ref[0, 0, 0, 2]=(0.699087081376-0.420117146247j)
            arg[0, 0, 1]+=(0.785226878491-0.842180089616j)*x[2]
            ref[0, 0, 1, 2]=(0.785226878491-0.842180089616j)
            arg[0, 0, 2]+=(0.0344799688957-0.134353420626j)*x[2]
            ref[0, 0, 2, 2]=(0.0344799688957-0.134353420626j)
            arg[0, 1, 0]+=(-0.621605366157-0.540159770254j)*x[2]
            ref[0, 1, 0, 2]=(-0.621605366157-0.540159770254j)
            arg[0, 1, 1]+=(0.686189424295-0.162223104702j)*x[2]
            ref[0, 1, 1, 2]=(0.686189424295-0.162223104702j)
            arg[0, 1, 2]+=(0.195145272134+0.846965460704j)*x[2]
            ref[0, 1, 2, 2]=(0.195145272134+0.846965460704j)
            arg[0, 2, 0]+=(-0.627971857086+0.920693650308j)*x[2]
            ref[0, 2, 0, 2]=(-0.627971857086+0.920693650308j)
            arg[0, 2, 1]+=(0.960899482171-0.683806943231j)*x[2]
            ref[0, 2, 1, 2]=(0.960899482171-0.683806943231j)
            arg[0, 2, 2]+=(0.85395491456+0.127603010481j)*x[2]
            ref[0, 2, 2, 2]=(0.85395491456+0.127603010481j)
            arg[1, 0, 0]+=(-0.511516980316+0.657071064463j)*x[2]
            ref[1, 0, 0, 2]=(-0.511516980316+0.657071064463j)
            arg[1, 0, 1]+=(-0.263277208002-0.152968213117j)*x[2]
            ref[1, 0, 1, 2]=(-0.263277208002-0.152968213117j)
            arg[1, 0, 2]+=(0.437162717136+0.219329918404j)*x[2]
            ref[1, 0, 2, 2]=(0.437162717136+0.219329918404j)
            arg[1, 1, 0]+=(-0.206351185436+0.916569904091j)*x[2]
            ref[1, 1, 0, 2]=(-0.206351185436+0.916569904091j)
            arg[1, 1, 1]+=(-0.477610368653-0.332668990217j)*x[2]
            ref[1, 1, 1, 2]=(-0.477610368653-0.332668990217j)
            arg[1, 1, 2]+=(-0.931191450573-0.586371710141j)*x[2]
            ref[1, 1, 2, 2]=(-0.931191450573-0.586371710141j)
            arg[1, 2, 0]+=(0.662881134268-0.571762835504j)*x[2]
            ref[1, 2, 0, 2]=(0.662881134268-0.571762835504j)
            arg[1, 2, 1]+=(-0.441540035819+0.614934971072j)*x[2]
            ref[1, 2, 1, 2]=(-0.441540035819+0.614934971072j)
            arg[1, 2, 2]+=(-0.749338243418-0.728957625144j)*x[2]
            ref[1, 2, 2, 2]=(-0.749338243418-0.728957625144j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2, 3, 3)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnBoundary_fromData_ReducedContinuousFunction_rank0(self):
        """
        tests gradient of rank 0 Data on FunctionOnBoundary

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=(-0.86372268671+0.0230865392856j)*x[0]+((-0.341267903673+0.102611959851j))*x[1]
        ref[0]=(-0.86372268671+0.0230865392856j)
        ref[1]=(-0.341267903673+0.102611959851j)
        if dim==3:
            arg+=((0.0617991126703-0.0909633757985j))*x[2]
            ref[2]=(0.0617991126703-0.0909633757985j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnBoundary_fromData_ReducedContinuousFunction_rank1(self):
        """
        tests gradient of rank 1 Data on FunctionOnBoundary

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(2,),w)
        ref = Data(0,(2,)+(dim,),w_ref)
        arg[0,]=(0.767733366125-0.84664970333j)*x[0]+((0.484433882574+0.84972852728j))*x[1]
        ref[0, 0]=(0.767733366125-0.84664970333j)
        ref[0, 1]=(0.484433882574+0.84972852728j)
        arg[1,]=(0.965703661433+0.866501477962j)*x[0]+((0.0131111502873+0.515440903159j))*x[1]
        ref[1, 0]=(0.965703661433+0.866501477962j)
        ref[1, 1]=(0.0131111502873+0.515440903159j)
        if dim==3:
            arg[0,]+=(0.455259426654-0.410017171051j)*x[2]
            ref[0, 2]=(0.455259426654-0.410017171051j)
            arg[1,]+=(-0.0485789973188+0.599947001325j)*x[2]
            ref[1, 2]=(-0.0485789973188+0.599947001325j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnBoundary_fromData_ReducedContinuousFunction_rank2(self):
        """
        tests gradient of rank 2 Data on FunctionOnBoundary

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(2, 2),w)
        ref = Data(0,(2, 2)+(dim,),w_ref)
        arg[0, 0]=(0.489169497271-0.0623131575293j)*x[0]+((-0.387793695971+0.4477179645j))*x[1]
        ref[0, 0, 0]=(0.489169497271-0.0623131575293j)
        ref[0, 0, 1]=(-0.387793695971+0.4477179645j)
        arg[0, 1]=(-0.031149320009-0.956287799853j)*x[0]+((-0.188555663502-0.734655751119j))*x[1]
        ref[0, 1, 0]=(-0.031149320009-0.956287799853j)
        ref[0, 1, 1]=(-0.188555663502-0.734655751119j)
        arg[1, 0]=(-0.652770356311+0.591489677433j)*x[0]+((0.745911054323+0.108301867093j))*x[1]
        ref[1, 0, 0]=(-0.652770356311+0.591489677433j)
        ref[1, 0, 1]=(0.745911054323+0.108301867093j)
        arg[1, 1]=(-0.775387834252+0.746249165362j)*x[0]+((0.644368315028+0.240768941426j))*x[1]
        ref[1, 1, 0]=(-0.775387834252+0.746249165362j)
        ref[1, 1, 1]=(0.644368315028+0.240768941426j)
        if dim==3:
            arg[0, 0]+=(0.45641470821+0.911671710189j)*x[2]
            ref[0, 0, 2]=(0.45641470821+0.911671710189j)
            arg[0, 1]+=(0.090208602319-0.609711238055j)*x[2]
            ref[0, 1, 2]=(0.090208602319-0.609711238055j)
            arg[1, 0]+=(-0.61226155946+0.744562701708j)*x[2]
            ref[1, 0, 2]=(-0.61226155946+0.744562701708j)
            arg[1, 1]+=(-0.337267208011-0.792807646524j)*x[2]
            ref[1, 1, 2]=(-0.337267208011-0.792807646524j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2, 2)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnBoundary_fromData_ReducedContinuousFunction_rank3(self):
        """
        tests gradient of rank 3 Data on FunctionOnBoundary

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(2, 2, 4),w)
        ref = Data(0,(2, 2, 4)+(dim,),w_ref)
        arg[0, 0, 0]=(0.218662603333-0.997810946086j)*x[0]+((0.133667462453+0.860407094006j))*x[1]
        ref[0, 0, 0, 0]=(0.218662603333-0.997810946086j)
        ref[0, 0, 0, 1]=(0.133667462453+0.860407094006j)
        arg[0, 0, 1]=(-0.534356548501-0.261334108226j)*x[0]+((0.504553712506-0.360302065862j))*x[1]
        ref[0, 0, 1, 0]=(-0.534356548501-0.261334108226j)
        ref[0, 0, 1, 1]=(0.504553712506-0.360302065862j)
        arg[0, 0, 2]=(-0.764247536231-0.073831761413j)*x[0]+((-0.763443969911-0.037081440708j))*x[1]
        ref[0, 0, 2, 0]=(-0.764247536231-0.073831761413j)
        ref[0, 0, 2, 1]=(-0.763443969911-0.037081440708j)
        arg[0, 0, 3]=(0.565574609006-0.695119905313j)*x[0]+((0.0215375906984-0.829204295619j))*x[1]
        ref[0, 0, 3, 0]=(0.565574609006-0.695119905313j)
        ref[0, 0, 3, 1]=(0.0215375906984-0.829204295619j)
        arg[0, 1, 0]=(-0.531748219889+0.458141498397j)*x[0]+((0.859820630293+0.130551767296j))*x[1]
        ref[0, 1, 0, 0]=(-0.531748219889+0.458141498397j)
        ref[0, 1, 0, 1]=(0.859820630293+0.130551767296j)
        arg[0, 1, 1]=(0.486214969151+0.970541596359j)*x[0]+((0.545583833891-0.127985076767j))*x[1]
        ref[0, 1, 1, 0]=(0.486214969151+0.970541596359j)
        ref[0, 1, 1, 1]=(0.545583833891-0.127985076767j)
        arg[0, 1, 2]=(-0.953569739842-0.0539929617482j)*x[0]+((0.136464822765+0.700029213134j))*x[1]
        ref[0, 1, 2, 0]=(-0.953569739842-0.0539929617482j)
        ref[0, 1, 2, 1]=(0.136464822765+0.700029213134j)
        arg[0, 1, 3]=(0.744619923316+0.559407659804j)*x[0]+((0.824263297924-0.308922859874j))*x[1]
        ref[0, 1, 3, 0]=(0.744619923316+0.559407659804j)
        ref[0, 1, 3, 1]=(0.824263297924-0.308922859874j)
        arg[1, 0, 0]=(-0.950311667962+0.480609707299j)*x[0]+((0.774444770404-0.123358290455j))*x[1]
        ref[1, 0, 0, 0]=(-0.950311667962+0.480609707299j)
        ref[1, 0, 0, 1]=(0.774444770404-0.123358290455j)
        arg[1, 0, 1]=(-0.147896895082-0.574930530222j)*x[0]+((-0.53985722301-0.223065180736j))*x[1]
        ref[1, 0, 1, 0]=(-0.147896895082-0.574930530222j)
        ref[1, 0, 1, 1]=(-0.53985722301-0.223065180736j)
        arg[1, 0, 2]=(0.622198557541+0.271126598368j)*x[0]+((-0.158332043851+0.402590040509j))*x[1]
        ref[1, 0, 2, 0]=(0.622198557541+0.271126598368j)
        ref[1, 0, 2, 1]=(-0.158332043851+0.402590040509j)
        arg[1, 0, 3]=(-0.369151673484-0.941493764772j)*x[0]+((-0.735648272114-0.440735345817j))*x[1]
        ref[1, 0, 3, 0]=(-0.369151673484-0.941493764772j)
        ref[1, 0, 3, 1]=(-0.735648272114-0.440735345817j)
        arg[1, 1, 0]=(0.405942628655+0.13471150342j)*x[0]+((0.0943558522284+0.557247273646j))*x[1]
        ref[1, 1, 0, 0]=(0.405942628655+0.13471150342j)
        ref[1, 1, 0, 1]=(0.0943558522284+0.557247273646j)
        arg[1, 1, 1]=(0.740351938069-0.405700202948j)*x[0]+((0.556533593504-0.631255184756j))*x[1]
        ref[1, 1, 1, 0]=(0.740351938069-0.405700202948j)
        ref[1, 1, 1, 1]=(0.556533593504-0.631255184756j)
        arg[1, 1, 2]=(-0.95790285997-0.0583519327547j)*x[0]+((0.943728411576-0.182027082558j))*x[1]
        ref[1, 1, 2, 0]=(-0.95790285997-0.0583519327547j)
        ref[1, 1, 2, 1]=(0.943728411576-0.182027082558j)
        arg[1, 1, 3]=(-0.422300868354+0.857089917587j)*x[0]+((0.700072149664+0.440848084503j))*x[1]
        ref[1, 1, 3, 0]=(-0.422300868354+0.857089917587j)
        ref[1, 1, 3, 1]=(0.700072149664+0.440848084503j)
        if dim==3:
            arg[0, 0, 0]+=(0.983899363537-0.646778584838j)*x[2]
            ref[0, 0, 0, 2]=(0.983899363537-0.646778584838j)
            arg[0, 0, 1]+=(-0.371943963703+0.300896427782j)*x[2]
            ref[0, 0, 1, 2]=(-0.371943963703+0.300896427782j)
            arg[0, 0, 2]+=(0.542625687137-0.674940304963j)*x[2]
            ref[0, 0, 2, 2]=(0.542625687137-0.674940304963j)
            arg[0, 0, 3]+=(0.256638183374+0.801906670639j)*x[2]
            ref[0, 0, 3, 2]=(0.256638183374+0.801906670639j)
            arg[0, 1, 0]+=(0.636377082891+0.386481562843j)*x[2]
            ref[0, 1, 0, 2]=(0.636377082891+0.386481562843j)
            arg[0, 1, 1]+=(0.907503025953-0.871197770333j)*x[2]
            ref[0, 1, 1, 2]=(0.907503025953-0.871197770333j)
            arg[0, 1, 2]+=(-0.145124294152-0.359930981206j)*x[2]
            ref[0, 1, 2, 2]=(-0.145124294152-0.359930981206j)
            arg[0, 1, 3]+=(-0.848971617658+0.77240073938j)*x[2]
            ref[0, 1, 3, 2]=(-0.848971617658+0.77240073938j)
            arg[1, 0, 0]+=(-0.90632160126+0.897603117755j)*x[2]
            ref[1, 0, 0, 2]=(-0.90632160126+0.897603117755j)
            arg[1, 0, 1]+=(-0.186541437376-0.707738187631j)*x[2]
            ref[1, 0, 1, 2]=(-0.186541437376-0.707738187631j)
            arg[1, 0, 2]+=(-0.267003171458+0.121499625477j)*x[2]
            ref[1, 0, 2, 2]=(-0.267003171458+0.121499625477j)
            arg[1, 0, 3]+=(0.759074321865+0.954912554672j)*x[2]
            ref[1, 0, 3, 2]=(0.759074321865+0.954912554672j)
            arg[1, 1, 0]+=(0.337837965329-0.300770241049j)*x[2]
            ref[1, 1, 0, 2]=(0.337837965329-0.300770241049j)
            arg[1, 1, 1]+=(-0.282646515939-0.152142304359j)*x[2]
            ref[1, 1, 1, 2]=(-0.282646515939-0.152142304359j)
            arg[1, 1, 2]+=(0.665708601387-0.41852567827j)*x[2]
            ref[1, 1, 2, 2]=(0.665708601387-0.41852567827j)
            arg[1, 1, 3]+=(0.523578468775-0.109514447694j)*x[2]
            ref[1, 1, 3, 2]=(0.523578468775-0.109514447694j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2, 2, 4)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnBoundary_fromData_ContinuousFunction_rank0(self):
        """
        tests gradient of rank 0 Data on ReducedFunctionOnBoundary

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=(0.257408702226+0.782350106857j)*x[0]**o+((0.644205252174-0.99335078721j))*x[0]+((0.232593492656+0.404539810861j))*x[1]**o+((-0.0866554806373-0.711136063691j))*x[1]
        ref[0]=(0.257408702226+0.782350106857j)*o*x_ref[0]**(o-1)+((0.644205252174-0.99335078721j))
        ref[1]=(0.232593492656+0.404539810861j)*o*x_ref[1]**(o-1)+((-0.0866554806373-0.711136063691j))
        if dim==3:
            arg+=((-0.216377801105-0.777311948529j))*x[2]**o+((-0.781849818382+0.245231446353j))*x[2]
            ref[2]=(-0.216377801105-0.777311948529j)*o*x_ref[2]**(o-1)+((-0.781849818382+0.245231446353j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnBoundary_fromData_ContinuousFunction_rank1(self):
        """
        tests gradient of rank 1 Data on ReducedFunctionOnBoundary

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(2,),w)
        ref = Data(0,(2,)+(dim,),w_ref)
        arg[0,]=(0.992913911427-0.269142458007j)*x[0]**o+((-0.851341554934+0.109695134246j))*x[0]+((0.597505455179+0.597596136134j))*x[1]**o+((-0.568861510899+0.418828406475j))*x[1]
        ref[0, 0]=(0.992913911427-0.269142458007j)*o*x_ref[0]**(o-1)+((-0.851341554934+0.109695134246j))
        ref[0, 1]=(0.597505455179+0.597596136134j)*o*x_ref[1]**(o-1)+((-0.568861510899+0.418828406475j))
        arg[1,]=(0.415902917541+0.300536196835j)*x[0]**o+((0.164504595432-0.643633524312j))*x[0]+((-0.92711614196+0.855404227952j))*x[1]**o+((0.366549422747+0.992856004788j))*x[1]
        ref[1, 0]=(0.415902917541+0.300536196835j)*o*x_ref[0]**(o-1)+((0.164504595432-0.643633524312j))
        ref[1, 1]=(-0.92711614196+0.855404227952j)*o*x_ref[1]**(o-1)+((0.366549422747+0.992856004788j))
        if dim==3:
            arg[0,]+=(0.818001848269-0.247065387851j)*x[2]**o+((-0.111252642736+0.104889927657j))*x[2]
            ref[0, 2]=(0.818001848269-0.247065387851j)*o*x_ref[2]**(o-1)+((-0.111252642736+0.104889927657j))
            arg[1,]+=(-0.755154157187-0.718631818125j)*x[2]**o+((-0.00368207061686-0.951307340728j))*x[2]
            ref[1, 2]=(-0.755154157187-0.718631818125j)*o*x_ref[2]**(o-1)+((-0.00368207061686-0.951307340728j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnBoundary_fromData_ContinuousFunction_rank2(self):
        """
        tests gradient of rank 2 Data on ReducedFunctionOnBoundary

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(2, 2),w)
        ref = Data(0,(2, 2)+(dim,),w_ref)
        arg[0, 0]=(0.839297015231-0.157004176515j)*x[0]**o+((0.177468209384-0.996811547873j))*x[0]+((0.227428943391-0.232790542531j))*x[1]**o+((-0.456203623769+0.821339629813j))*x[1]
        ref[0, 0, 0]=(0.839297015231-0.157004176515j)*o*x_ref[0]**(o-1)+((0.177468209384-0.996811547873j))
        ref[0, 0, 1]=(0.227428943391-0.232790542531j)*o*x_ref[1]**(o-1)+((-0.456203623769+0.821339629813j))
        arg[0, 1]=(-0.490034404956+0.406698669405j)*x[0]**o+((-0.554808574024-0.200168401314j))*x[0]+((-0.304510455316-0.826415424669j))*x[1]**o+((0.142959410573+0.506397951978j))*x[1]
        ref[0, 1, 0]=(-0.490034404956+0.406698669405j)*o*x_ref[0]**(o-1)+((-0.554808574024-0.200168401314j))
        ref[0, 1, 1]=(-0.304510455316-0.826415424669j)*o*x_ref[1]**(o-1)+((0.142959410573+0.506397951978j))
        arg[1, 0]=(-0.774928971277+0.638113217748j)*x[0]**o+((0.172248291292-0.175608607379j))*x[0]+((0.155706612611+0.72631401915j))*x[1]**o+((0.415505721007+0.989647135775j))*x[1]
        ref[1, 0, 0]=(-0.774928971277+0.638113217748j)*o*x_ref[0]**(o-1)+((0.172248291292-0.175608607379j))
        ref[1, 0, 1]=(0.155706612611+0.72631401915j)*o*x_ref[1]**(o-1)+((0.415505721007+0.989647135775j))
        arg[1, 1]=(0.737323110117+0.50297646524j)*x[0]**o+((0.752470656148-0.947374467253j))*x[0]+((0.603006049614-0.27941277176j))*x[1]**o+((-0.361540707223+0.532637222322j))*x[1]
        ref[1, 1, 0]=(0.737323110117+0.50297646524j)*o*x_ref[0]**(o-1)+((0.752470656148-0.947374467253j))
        ref[1, 1, 1]=(0.603006049614-0.27941277176j)*o*x_ref[1]**(o-1)+((-0.361540707223+0.532637222322j))
        if dim==3:
            arg[0, 0]+=(-0.419284762635-0.988681336342j)*x[2]**o+((-0.346846411943+0.41059841489j))*x[2]
            ref[0, 0, 2]=(-0.419284762635-0.988681336342j)*o*x_ref[2]**(o-1)+((-0.346846411943+0.41059841489j))
            arg[0, 1]+=(0.772677164264-0.0656504549952j)*x[2]**o+((0.215606708033-0.47806956376j))*x[2]
            ref[0, 1, 2]=(0.772677164264-0.0656504549952j)*o*x_ref[2]**(o-1)+((0.215606708033-0.47806956376j))
            arg[1, 0]+=(-0.0654483950885+0.475990400976j)*x[2]**o+((-0.2931015768-0.466601041035j))*x[2]
            ref[1, 0, 2]=(-0.0654483950885+0.475990400976j)*o*x_ref[2]**(o-1)+((-0.2931015768-0.466601041035j))
            arg[1, 1]+=(0.448497189519-0.174736544266j)*x[2]**o+((-0.556357971884-0.273378201094j))*x[2]
            ref[1, 1, 2]=(0.448497189519-0.174736544266j)*o*x_ref[2]**(o-1)+((-0.556357971884-0.273378201094j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2, 2)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnBoundary_fromData_ContinuousFunction_rank3(self):
        """
        tests gradient of rank 3 Data on ReducedFunctionOnBoundary

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(4, 2, 3),w)
        ref = Data(0,(4, 2, 3)+(dim,),w_ref)
        arg[0, 0, 0]=(0.25584273689+0.371594765786j)*x[0]**o+((0.799146736463-0.320422915573j))*x[0]+((-0.77516982502-0.0123931866741j))*x[1]**o+((-0.818765535234+0.763628764052j))*x[1]
        ref[0, 0, 0, 0]=(0.25584273689+0.371594765786j)*o*x_ref[0]**(o-1)+((0.799146736463-0.320422915573j))
        ref[0, 0, 0, 1]=(-0.77516982502-0.0123931866741j)*o*x_ref[1]**(o-1)+((-0.818765535234+0.763628764052j))
        arg[0, 0, 1]=(-0.483210343407-0.434321573413j)*x[0]**o+((0.191312712515-0.504165023254j))*x[0]+((-0.491585345119+0.628712913607j))*x[1]**o+((0.167824207032+0.875606539103j))*x[1]
        ref[0, 0, 1, 0]=(-0.483210343407-0.434321573413j)*o*x_ref[0]**(o-1)+((0.191312712515-0.504165023254j))
        ref[0, 0, 1, 1]=(-0.491585345119+0.628712913607j)*o*x_ref[1]**(o-1)+((0.167824207032+0.875606539103j))
        arg[0, 0, 2]=(-0.812535547164-0.748436520276j)*x[0]**o+((0.000591219950602+0.579100915416j))*x[0]+((-0.0198374012105-0.464045942409j))*x[1]**o+((-0.820510651024-0.390009476654j))*x[1]
        ref[0, 0, 2, 0]=(-0.812535547164-0.748436520276j)*o*x_ref[0]**(o-1)+((0.000591219950602+0.579100915416j))
        ref[0, 0, 2, 1]=(-0.0198374012105-0.464045942409j)*o*x_ref[1]**(o-1)+((-0.820510651024-0.390009476654j))
        arg[0, 1, 0]=(0.623278251558-0.439460621037j)*x[0]**o+((0.613007939267-0.987937512809j))*x[0]+((-0.8748147183+0.172577093254j))*x[1]**o+((-0.469520887523-0.700723569452j))*x[1]
        ref[0, 1, 0, 0]=(0.623278251558-0.439460621037j)*o*x_ref[0]**(o-1)+((0.613007939267-0.987937512809j))
        ref[0, 1, 0, 1]=(-0.8748147183+0.172577093254j)*o*x_ref[1]**(o-1)+((-0.469520887523-0.700723569452j))
        arg[0, 1, 1]=(0.4028884667-0.53227518602j)*x[0]**o+((0.567520730304-0.016729122602j))*x[0]+((-0.442230656721-0.0139631755598j))*x[1]**o+((0.728127864739+0.90455633901j))*x[1]
        ref[0, 1, 1, 0]=(0.4028884667-0.53227518602j)*o*x_ref[0]**(o-1)+((0.567520730304-0.016729122602j))
        ref[0, 1, 1, 1]=(-0.442230656721-0.0139631755598j)*o*x_ref[1]**(o-1)+((0.728127864739+0.90455633901j))
        arg[0, 1, 2]=(-0.540663679392-0.13360314834j)*x[0]**o+((0.812745106944+0.661944207608j))*x[0]+((-0.760725464337-0.0904797769459j))*x[1]**o+((0.0848666447156-0.893658600209j))*x[1]
        ref[0, 1, 2, 0]=(-0.540663679392-0.13360314834j)*o*x_ref[0]**(o-1)+((0.812745106944+0.661944207608j))
        ref[0, 1, 2, 1]=(-0.760725464337-0.0904797769459j)*o*x_ref[1]**(o-1)+((0.0848666447156-0.893658600209j))
        arg[1, 0, 0]=(-0.694385257876+0.897109790158j)*x[0]**o+((-0.290143475533+0.242561483255j))*x[0]+((0.577160434836+0.12295511204j))*x[1]**o+((-0.700960092606-0.979540833962j))*x[1]
        ref[1, 0, 0, 0]=(-0.694385257876+0.897109790158j)*o*x_ref[0]**(o-1)+((-0.290143475533+0.242561483255j))
        ref[1, 0, 0, 1]=(0.577160434836+0.12295511204j)*o*x_ref[1]**(o-1)+((-0.700960092606-0.979540833962j))
        arg[1, 0, 1]=(0.03616994352-0.696324145965j)*x[0]**o+((0.816255707051+0.519772933832j))*x[0]+((-0.174867848065+0.171429528863j))*x[1]**o+((0.672534087329+0.716588987167j))*x[1]
        ref[1, 0, 1, 0]=(0.03616994352-0.696324145965j)*o*x_ref[0]**(o-1)+((0.816255707051+0.519772933832j))
        ref[1, 0, 1, 1]=(-0.174867848065+0.171429528863j)*o*x_ref[1]**(o-1)+((0.672534087329+0.716588987167j))
        arg[1, 0, 2]=(-0.725537599362-0.302189924687j)*x[0]**o+((0.856373627426-0.741865048692j))*x[0]+((0.129099839866+0.784933511424j))*x[1]**o+((0.62406729188-0.558739950829j))*x[1]
        ref[1, 0, 2, 0]=(-0.725537599362-0.302189924687j)*o*x_ref[0]**(o-1)+((0.856373627426-0.741865048692j))
        ref[1, 0, 2, 1]=(0.129099839866+0.784933511424j)*o*x_ref[1]**(o-1)+((0.62406729188-0.558739950829j))
        arg[1, 1, 0]=(0.345704306511-0.754050957195j)*x[0]**o+((-0.198780842682+0.763553303091j))*x[0]+((0.410648218306-0.0939480470708j))*x[1]**o+((0.944980315438-0.886698545506j))*x[1]
        ref[1, 1, 0, 0]=(0.345704306511-0.754050957195j)*o*x_ref[0]**(o-1)+((-0.198780842682+0.763553303091j))
        ref[1, 1, 0, 1]=(0.410648218306-0.0939480470708j)*o*x_ref[1]**(o-1)+((0.944980315438-0.886698545506j))
        arg[1, 1, 1]=(0.286975457072-0.299538050182j)*x[0]**o+((0.212592781882+0.117156653417j))*x[0]+((0.19647906058+0.863920516041j))*x[1]**o+((-0.0556507847004+0.507616760643j))*x[1]
        ref[1, 1, 1, 0]=(0.286975457072-0.299538050182j)*o*x_ref[0]**(o-1)+((0.212592781882+0.117156653417j))
        ref[1, 1, 1, 1]=(0.19647906058+0.863920516041j)*o*x_ref[1]**(o-1)+((-0.0556507847004+0.507616760643j))
        arg[1, 1, 2]=(-0.140021720973-0.940057618827j)*x[0]**o+((-0.999371366689-0.453649847078j))*x[0]+((0.82433269888+0.418440194291j))*x[1]**o+((-0.943596038591-0.850291638137j))*x[1]
        ref[1, 1, 2, 0]=(-0.140021720973-0.940057618827j)*o*x_ref[0]**(o-1)+((-0.999371366689-0.453649847078j))
        ref[1, 1, 2, 1]=(0.82433269888+0.418440194291j)*o*x_ref[1]**(o-1)+((-0.943596038591-0.850291638137j))
        arg[2, 0, 0]=(0.506201071042+0.980251720091j)*x[0]**o+((-0.538825608374-0.144444226823j))*x[0]+((0.283129481657-0.951815244635j))*x[1]**o+((0.370141537711+0.976153408267j))*x[1]
        ref[2, 0, 0, 0]=(0.506201071042+0.980251720091j)*o*x_ref[0]**(o-1)+((-0.538825608374-0.144444226823j))
        ref[2, 0, 0, 1]=(0.283129481657-0.951815244635j)*o*x_ref[1]**(o-1)+((0.370141537711+0.976153408267j))
        arg[2, 0, 1]=(-0.550187349738-0.574541353901j)*x[0]**o+((-0.469362846815+0.881927244446j))*x[0]+((-0.746384694224+0.87557601922j))*x[1]**o+((0.885029111185-0.721672439652j))*x[1]
        ref[2, 0, 1, 0]=(-0.550187349738-0.574541353901j)*o*x_ref[0]**(o-1)+((-0.469362846815+0.881927244446j))
        ref[2, 0, 1, 1]=(-0.746384694224+0.87557601922j)*o*x_ref[1]**(o-1)+((0.885029111185-0.721672439652j))
        arg[2, 0, 2]=(0.555201167431+0.283631243542j)*x[0]**o+((0.326334221487-0.28338434602j))*x[0]+((0.0263400723297-0.0712327668617j))*x[1]**o+((0.560739414811-0.852321028512j))*x[1]
        ref[2, 0, 2, 0]=(0.555201167431+0.283631243542j)*o*x_ref[0]**(o-1)+((0.326334221487-0.28338434602j))
        ref[2, 0, 2, 1]=(0.0263400723297-0.0712327668617j)*o*x_ref[1]**(o-1)+((0.560739414811-0.852321028512j))
        arg[2, 1, 0]=(0.615006918598-0.0383639443995j)*x[0]**o+((0.892317953552-0.98905036692j))*x[0]+((0.15933626136-0.309488077502j))*x[1]**o+((-0.179408528881+0.839941303478j))*x[1]
        ref[2, 1, 0, 0]=(0.615006918598-0.0383639443995j)*o*x_ref[0]**(o-1)+((0.892317953552-0.98905036692j))
        ref[2, 1, 0, 1]=(0.15933626136-0.309488077502j)*o*x_ref[1]**(o-1)+((-0.179408528881+0.839941303478j))
        arg[2, 1, 1]=(0.23181076167-0.341964190703j)*x[0]**o+((0.911458159287-0.486769291812j))*x[0]+((-0.427690872207+0.323693058251j))*x[1]**o+((0.433743375854-0.583779979186j))*x[1]
        ref[2, 1, 1, 0]=(0.23181076167-0.341964190703j)*o*x_ref[0]**(o-1)+((0.911458159287-0.486769291812j))
        ref[2, 1, 1, 1]=(-0.427690872207+0.323693058251j)*o*x_ref[1]**(o-1)+((0.433743375854-0.583779979186j))
        arg[2, 1, 2]=(0.58445801196-0.15923414793j)*x[0]**o+((0.793041823429-0.793280728299j))*x[0]+((0.437148196826+0.763717252365j))*x[1]**o+((-0.116369573848-0.863357477893j))*x[1]
        ref[2, 1, 2, 0]=(0.58445801196-0.15923414793j)*o*x_ref[0]**(o-1)+((0.793041823429-0.793280728299j))
        ref[2, 1, 2, 1]=(0.437148196826+0.763717252365j)*o*x_ref[1]**(o-1)+((-0.116369573848-0.863357477893j))
        arg[3, 0, 0]=(0.857966413285-0.32814855294j)*x[0]**o+((-0.266482072225-0.00994968472402j))*x[0]+((0.854355401645+0.024725385605j))*x[1]**o+((0.718444433016+0.321354374975j))*x[1]
        ref[3, 0, 0, 0]=(0.857966413285-0.32814855294j)*o*x_ref[0]**(o-1)+((-0.266482072225-0.00994968472402j))
        ref[3, 0, 0, 1]=(0.854355401645+0.024725385605j)*o*x_ref[1]**(o-1)+((0.718444433016+0.321354374975j))
        arg[3, 0, 1]=(0.826178327196+0.134342954659j)*x[0]**o+((-0.227863183618-0.855727666349j))*x[0]+((0.610122327597-0.497021985773j))*x[1]**o+((-0.930083581582+0.587735953254j))*x[1]
        ref[3, 0, 1, 0]=(0.826178327196+0.134342954659j)*o*x_ref[0]**(o-1)+((-0.227863183618-0.855727666349j))
        ref[3, 0, 1, 1]=(0.610122327597-0.497021985773j)*o*x_ref[1]**(o-1)+((-0.930083581582+0.587735953254j))
        arg[3, 0, 2]=(-0.700570011704-0.835022608876j)*x[0]**o+((0.290383149017-0.562064221794j))*x[0]+((0.739505848353+0.275895671982j))*x[1]**o+((0.203084920955-0.976197937731j))*x[1]
        ref[3, 0, 2, 0]=(-0.700570011704-0.835022608876j)*o*x_ref[0]**(o-1)+((0.290383149017-0.562064221794j))
        ref[3, 0, 2, 1]=(0.739505848353+0.275895671982j)*o*x_ref[1]**(o-1)+((0.203084920955-0.976197937731j))
        arg[3, 1, 0]=(-0.0815718410174-0.693967675537j)*x[0]**o+((0.684378909132-0.106904096875j))*x[0]+((-0.0304616986569+0.500857305894j))*x[1]**o+((-0.588687763887-0.447358310386j))*x[1]
        ref[3, 1, 0, 0]=(-0.0815718410174-0.693967675537j)*o*x_ref[0]**(o-1)+((0.684378909132-0.106904096875j))
        ref[3, 1, 0, 1]=(-0.0304616986569+0.500857305894j)*o*x_ref[1]**(o-1)+((-0.588687763887-0.447358310386j))
        arg[3, 1, 1]=(-0.114985716611+0.661115655448j)*x[0]**o+((0.439688796497-0.825944846639j))*x[0]+((0.963955054731-0.203457401529j))*x[1]**o+((-0.389322132673-0.668083281943j))*x[1]
        ref[3, 1, 1, 0]=(-0.114985716611+0.661115655448j)*o*x_ref[0]**(o-1)+((0.439688796497-0.825944846639j))
        ref[3, 1, 1, 1]=(0.963955054731-0.203457401529j)*o*x_ref[1]**(o-1)+((-0.389322132673-0.668083281943j))
        arg[3, 1, 2]=(0.37456231794+0.67670132734j)*x[0]**o+((-0.510960723841+0.557086117757j))*x[0]+((0.311394885356-0.176507639899j))*x[1]**o+((0.961100570912+0.995592522194j))*x[1]
        ref[3, 1, 2, 0]=(0.37456231794+0.67670132734j)*o*x_ref[0]**(o-1)+((-0.510960723841+0.557086117757j))
        ref[3, 1, 2, 1]=(0.311394885356-0.176507639899j)*o*x_ref[1]**(o-1)+((0.961100570912+0.995592522194j))
        if dim==3:
            arg[0, 0, 0]+=(-0.479507917814-0.416623501714j)*x[2]**o+((-0.537710719748-0.0960143442828j))*x[2]
            ref[0, 0, 0, 2]=(-0.479507917814-0.416623501714j)*o*x_ref[2]**(o-1)+((-0.537710719748-0.0960143442828j))
            arg[0, 0, 1]+=(-0.986300074328-0.406420668165j)*x[2]**o+((0.233560388785+0.26403667604j))*x[2]
            ref[0, 0, 1, 2]=(-0.986300074328-0.406420668165j)*o*x_ref[2]**(o-1)+((0.233560388785+0.26403667604j))
            arg[0, 0, 2]+=(-0.348667693122-0.444952151698j)*x[2]**o+((0.936947825014-0.941338610095j))*x[2]
            ref[0, 0, 2, 2]=(-0.348667693122-0.444952151698j)*o*x_ref[2]**(o-1)+((0.936947825014-0.941338610095j))
            arg[0, 1, 0]+=(0.254149436975+0.929311082644j)*x[2]**o+((0.518994507843+0.577140735728j))*x[2]
            ref[0, 1, 0, 2]=(0.254149436975+0.929311082644j)*o*x_ref[2]**(o-1)+((0.518994507843+0.577140735728j))
            arg[0, 1, 1]+=(-0.020454072399-0.0975783872315j)*x[2]**o+((0.880170392526-0.405778936532j))*x[2]
            ref[0, 1, 1, 2]=(-0.020454072399-0.0975783872315j)*o*x_ref[2]**(o-1)+((0.880170392526-0.405778936532j))
            arg[0, 1, 2]+=(-0.201323844358+0.784597357634j)*x[2]**o+((0.607035602699+0.241491767784j))*x[2]
            ref[0, 1, 2, 2]=(-0.201323844358+0.784597357634j)*o*x_ref[2]**(o-1)+((0.607035602699+0.241491767784j))
            arg[1, 0, 0]+=(-0.0187991551647+0.938117334219j)*x[2]**o+((-0.878271980481-0.567930930812j))*x[2]
            ref[1, 0, 0, 2]=(-0.0187991551647+0.938117334219j)*o*x_ref[2]**(o-1)+((-0.878271980481-0.567930930812j))
            arg[1, 0, 1]+=(-0.574187963571-0.320386537533j)*x[2]**o+((-0.599472338638-0.336866488136j))*x[2]
            ref[1, 0, 1, 2]=(-0.574187963571-0.320386537533j)*o*x_ref[2]**(o-1)+((-0.599472338638-0.336866488136j))
            arg[1, 0, 2]+=(-0.292839942762+0.174632466425j)*x[2]**o+((0.218179618551-0.678161302497j))*x[2]
            ref[1, 0, 2, 2]=(-0.292839942762+0.174632466425j)*o*x_ref[2]**(o-1)+((0.218179618551-0.678161302497j))
            arg[1, 1, 0]+=(-0.874754147094-0.0891109279021j)*x[2]**o+((0.183917187044-0.454390292651j))*x[2]
            ref[1, 1, 0, 2]=(-0.874754147094-0.0891109279021j)*o*x_ref[2]**(o-1)+((0.183917187044-0.454390292651j))
            arg[1, 1, 1]+=(0.39802765828-0.29870449866j)*x[2]**o+((-0.844017117158-0.636000437063j))*x[2]
            ref[1, 1, 1, 2]=(0.39802765828-0.29870449866j)*o*x_ref[2]**(o-1)+((-0.844017117158-0.636000437063j))
            arg[1, 1, 2]+=(-0.686013459484+0.668117506782j)*x[2]**o+((0.11363503128+0.664492655269j))*x[2]
            ref[1, 1, 2, 2]=(-0.686013459484+0.668117506782j)*o*x_ref[2]**(o-1)+((0.11363503128+0.664492655269j))
            arg[2, 0, 0]+=(0.894012958653+0.85556945229j)*x[2]**o+((0.976132432513+0.103121572646j))*x[2]
            ref[2, 0, 0, 2]=(0.894012958653+0.85556945229j)*o*x_ref[2]**(o-1)+((0.976132432513+0.103121572646j))
            arg[2, 0, 1]+=(0.851035309568+0.158063739565j)*x[2]**o+((-0.684575376711+0.84671469361j))*x[2]
            ref[2, 0, 1, 2]=(0.851035309568+0.158063739565j)*o*x_ref[2]**(o-1)+((-0.684575376711+0.84671469361j))
            arg[2, 0, 2]+=(0.991790873585+0.477084187714j)*x[2]**o+((0.931302139797-0.437660010871j))*x[2]
            ref[2, 0, 2, 2]=(0.991790873585+0.477084187714j)*o*x_ref[2]**(o-1)+((0.931302139797-0.437660010871j))
            arg[2, 1, 0]+=(0.605619021172-0.944370479174j)*x[2]**o+((-0.645977095066+0.156583420869j))*x[2]
            ref[2, 1, 0, 2]=(0.605619021172-0.944370479174j)*o*x_ref[2]**(o-1)+((-0.645977095066+0.156583420869j))
            arg[2, 1, 1]+=(0.304407498429+0.549049700275j)*x[2]**o+((-0.191392332616+0.464936725594j))*x[2]
            ref[2, 1, 1, 2]=(0.304407498429+0.549049700275j)*o*x_ref[2]**(o-1)+((-0.191392332616+0.464936725594j))
            arg[2, 1, 2]+=(-0.784775353616+0.666759029942j)*x[2]**o+((-0.690558976987+0.863560591168j))*x[2]
            ref[2, 1, 2, 2]=(-0.784775353616+0.666759029942j)*o*x_ref[2]**(o-1)+((-0.690558976987+0.863560591168j))
            arg[3, 0, 0]+=(-0.191470684951+0.0995143241027j)*x[2]**o+((-0.504953905471-0.263213349832j))*x[2]
            ref[3, 0, 0, 2]=(-0.191470684951+0.0995143241027j)*o*x_ref[2]**(o-1)+((-0.504953905471-0.263213349832j))
            arg[3, 0, 1]+=(0.380112919589-0.350302692836j)*x[2]**o+((-0.516583558434+0.882241965239j))*x[2]
            ref[3, 0, 1, 2]=(0.380112919589-0.350302692836j)*o*x_ref[2]**(o-1)+((-0.516583558434+0.882241965239j))
            arg[3, 0, 2]+=(-0.466187411914+0.660829785848j)*x[2]**o+((0.655696198752+0.131855296618j))*x[2]
            ref[3, 0, 2, 2]=(-0.466187411914+0.660829785848j)*o*x_ref[2]**(o-1)+((0.655696198752+0.131855296618j))
            arg[3, 1, 0]+=(0.322269433737+0.976510572651j)*x[2]**o+((0.421938522728-0.780369796961j))*x[2]
            ref[3, 1, 0, 2]=(0.322269433737+0.976510572651j)*o*x_ref[2]**(o-1)+((0.421938522728-0.780369796961j))
            arg[3, 1, 1]+=(-0.410888240663-0.792654908877j)*x[2]**o+((-0.137012595657-0.605133440205j))*x[2]
            ref[3, 1, 1, 2]=(-0.410888240663-0.792654908877j)*o*x_ref[2]**(o-1)+((-0.137012595657-0.605133440205j))
            arg[3, 1, 2]+=(0.508401686122-0.351266424387j)*x[2]**o+((0.228842078214-0.322764270447j))*x[2]
            ref[3, 1, 2, 2]=(0.508401686122-0.351266424387j)*o*x_ref[2]**(o-1)+((0.228842078214-0.322764270447j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4, 2, 3)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnBoundary_fromData_Solution_rank0(self):
        """
        tests gradient of rank 0 Data on ReducedFunctionOnBoundary

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=(-0.0357206952394+0.79697007626j)*x[0]**o+((0.0883468374497+0.604506426471j))*x[0]+((0.26345801919+0.401311911213j))*x[1]**o+((-0.778680555282-0.278210721796j))*x[1]
        ref[0]=(-0.0357206952394+0.79697007626j)*o*x_ref[0]**(o-1)+((0.0883468374497+0.604506426471j))
        ref[1]=(0.26345801919+0.401311911213j)*o*x_ref[1]**(o-1)+((-0.778680555282-0.278210721796j))
        if dim==3:
            arg+=((-0.980706625806+0.385734040741j))*x[2]**o+((-0.0141693532817+0.198283953512j))*x[2]
            ref[2]=(-0.980706625806+0.385734040741j)*o*x_ref[2]**(o-1)+((-0.0141693532817+0.198283953512j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnBoundary_fromData_Solution_rank1(self):
        """
        tests gradient of rank 1 Data on ReducedFunctionOnBoundary

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(4,),w)
        ref = Data(0,(4,)+(dim,),w_ref)
        arg[0,]=(0.599422349904+0.206696279896j)*x[0]**o+((-0.737883913326+0.858222353759j))*x[0]+((0.231316078054+0.630159734784j))*x[1]**o+((0.655959214438+0.114400373055j))*x[1]
        ref[0, 0]=(0.599422349904+0.206696279896j)*o*x_ref[0]**(o-1)+((-0.737883913326+0.858222353759j))
        ref[0, 1]=(0.231316078054+0.630159734784j)*o*x_ref[1]**(o-1)+((0.655959214438+0.114400373055j))
        arg[1,]=(0.238258392384+0.251982227746j)*x[0]**o+((0.470803876829-0.980096492722j))*x[0]+((0.940777752396-0.786041735441j))*x[1]**o+((0.564247116857-0.541553233565j))*x[1]
        ref[1, 0]=(0.238258392384+0.251982227746j)*o*x_ref[0]**(o-1)+((0.470803876829-0.980096492722j))
        ref[1, 1]=(0.940777752396-0.786041735441j)*o*x_ref[1]**(o-1)+((0.564247116857-0.541553233565j))
        arg[2,]=(0.967923458504+0.0722604589464j)*x[0]**o+((0.807186014726-0.956144129591j))*x[0]+((-0.795182576453+0.929440590363j))*x[1]**o+((0.757357054162-0.266349979263j))*x[1]
        ref[2, 0]=(0.967923458504+0.0722604589464j)*o*x_ref[0]**(o-1)+((0.807186014726-0.956144129591j))
        ref[2, 1]=(-0.795182576453+0.929440590363j)*o*x_ref[1]**(o-1)+((0.757357054162-0.266349979263j))
        arg[3,]=(-0.189361592693-0.129535794999j)*x[0]**o+((0.607223019058+0.718521078347j))*x[0]+((-0.69903215647-0.62533202686j))*x[1]**o+((0.594363271098+0.898468945833j))*x[1]
        ref[3, 0]=(-0.189361592693-0.129535794999j)*o*x_ref[0]**(o-1)+((0.607223019058+0.718521078347j))
        ref[3, 1]=(-0.69903215647-0.62533202686j)*o*x_ref[1]**(o-1)+((0.594363271098+0.898468945833j))
        if dim==3:
            arg[0,]+=(0.81102615007+0.577032683812j)*x[2]**o+((-0.783025634863-0.313615701661j))*x[2]
            ref[0, 2]=(0.81102615007+0.577032683812j)*o*x_ref[2]**(o-1)+((-0.783025634863-0.313615701661j))
            arg[1,]+=(0.712531272355-0.570996796403j)*x[2]**o+((-0.627783863098+0.535462259198j))*x[2]
            ref[1, 2]=(0.712531272355-0.570996796403j)*o*x_ref[2]**(o-1)+((-0.627783863098+0.535462259198j))
            arg[2,]+=(0.615268523031-0.429917866518j)*x[2]**o+((-0.380288841227+0.379159540438j))*x[2]
            ref[2, 2]=(0.615268523031-0.429917866518j)*o*x_ref[2]**(o-1)+((-0.380288841227+0.379159540438j))
            arg[3,]+=(-0.267970990236+0.275161537749j)*x[2]**o+((0.487061536906+0.908323269854j))*x[2]
            ref[3, 2]=(-0.267970990236+0.275161537749j)*o*x_ref[2]**(o-1)+((0.487061536906+0.908323269854j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnBoundary_fromData_Solution_rank2(self):
        """
        tests gradient of rank 2 Data on ReducedFunctionOnBoundary

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(3, 2),w)
        ref = Data(0,(3, 2)+(dim,),w_ref)
        arg[0, 0]=(-0.787802739012+0.165050382782j)*x[0]**o+((0.286120426632+0.52003491086j))*x[0]+((0.405811182601+0.828279363136j))*x[1]**o+((-0.265021251218-0.705627690476j))*x[1]
        ref[0, 0, 0]=(-0.787802739012+0.165050382782j)*o*x_ref[0]**(o-1)+((0.286120426632+0.52003491086j))
        ref[0, 0, 1]=(0.405811182601+0.828279363136j)*o*x_ref[1]**(o-1)+((-0.265021251218-0.705627690476j))
        arg[0, 1]=(0.513273676115+0.771988712727j)*x[0]**o+((0.984013857846-0.287786849679j))*x[0]+((-0.458375789972+0.157286736091j))*x[1]**o+((0.39557844107-0.853795140107j))*x[1]
        ref[0, 1, 0]=(0.513273676115+0.771988712727j)*o*x_ref[0]**(o-1)+((0.984013857846-0.287786849679j))
        ref[0, 1, 1]=(-0.458375789972+0.157286736091j)*o*x_ref[1]**(o-1)+((0.39557844107-0.853795140107j))
        arg[1, 0]=(0.856123501116+0.280243020347j)*x[0]**o+((-0.0823837505423-0.8371080653j))*x[0]+((-0.643412873383-0.00865739579688j))*x[1]**o+((0.207761042925+0.470141021762j))*x[1]
        ref[1, 0, 0]=(0.856123501116+0.280243020347j)*o*x_ref[0]**(o-1)+((-0.0823837505423-0.8371080653j))
        ref[1, 0, 1]=(-0.643412873383-0.00865739579688j)*o*x_ref[1]**(o-1)+((0.207761042925+0.470141021762j))
        arg[1, 1]=(-0.131010703809-0.941126038538j)*x[0]**o+((0.352602311493-0.0960237526643j))*x[0]+((-0.293844265274-0.618619096844j))*x[1]**o+((-0.783213724701-0.774675117458j))*x[1]
        ref[1, 1, 0]=(-0.131010703809-0.941126038538j)*o*x_ref[0]**(o-1)+((0.352602311493-0.0960237526643j))
        ref[1, 1, 1]=(-0.293844265274-0.618619096844j)*o*x_ref[1]**(o-1)+((-0.783213724701-0.774675117458j))
        arg[2, 0]=(-0.892388894137-0.469660703357j)*x[0]**o+((0.839470524642-0.860435082808j))*x[0]+((-0.340981185026-0.428985550434j))*x[1]**o+((0.456546151699-0.136072127825j))*x[1]
        ref[2, 0, 0]=(-0.892388894137-0.469660703357j)*o*x_ref[0]**(o-1)+((0.839470524642-0.860435082808j))
        ref[2, 0, 1]=(-0.340981185026-0.428985550434j)*o*x_ref[1]**(o-1)+((0.456546151699-0.136072127825j))
        arg[2, 1]=(0.443914221534+0.763547693981j)*x[0]**o+((-0.458619338785-0.242163532083j))*x[0]+((0.493144409228-0.486480922386j))*x[1]**o+((-0.56356169486-0.503744219881j))*x[1]
        ref[2, 1, 0]=(0.443914221534+0.763547693981j)*o*x_ref[0]**(o-1)+((-0.458619338785-0.242163532083j))
        ref[2, 1, 1]=(0.493144409228-0.486480922386j)*o*x_ref[1]**(o-1)+((-0.56356169486-0.503744219881j))
        if dim==3:
            arg[0, 0]+=(-0.893606575023-0.439536422295j)*x[2]**o+((0.187615941268-0.385628219458j))*x[2]
            ref[0, 0, 2]=(-0.893606575023-0.439536422295j)*o*x_ref[2]**(o-1)+((0.187615941268-0.385628219458j))
            arg[0, 1]+=(-0.790956572469+0.418644926877j)*x[2]**o+((0.684300482459-0.844144609353j))*x[2]
            ref[0, 1, 2]=(-0.790956572469+0.418644926877j)*o*x_ref[2]**(o-1)+((0.684300482459-0.844144609353j))
            arg[1, 0]+=(0.59131973456-0.568087631625j)*x[2]**o+((0.225319671688+0.266338996481j))*x[2]
            ref[1, 0, 2]=(0.59131973456-0.568087631625j)*o*x_ref[2]**(o-1)+((0.225319671688+0.266338996481j))
            arg[1, 1]+=(-0.753057144348+0.20977698141j)*x[2]**o+((-0.369387420239+0.28301685328j))*x[2]
            ref[1, 1, 2]=(-0.753057144348+0.20977698141j)*o*x_ref[2]**(o-1)+((-0.369387420239+0.28301685328j))
            arg[2, 0]+=(-0.371628632065-0.411636989624j)*x[2]**o+((-0.785514299194+0.651449753025j))*x[2]
            ref[2, 0, 2]=(-0.371628632065-0.411636989624j)*o*x_ref[2]**(o-1)+((-0.785514299194+0.651449753025j))
            arg[2, 1]+=(0.469692005079-0.924495671604j)*x[2]**o+((-0.0212296150048+0.186550557388j))*x[2]
            ref[2, 1, 2]=(0.469692005079-0.924495671604j)*o*x_ref[2]**(o-1)+((-0.0212296150048+0.186550557388j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3, 2)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnBoundary_fromData_Solution_rank3(self):
        """
        tests gradient of rank 3 Data on ReducedFunctionOnBoundary

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(4, 4, 2),w)
        ref = Data(0,(4, 4, 2)+(dim,),w_ref)
        arg[0, 0, 0]=(0.083172570342-0.700618951915j)*x[0]**o+((-0.477142189003+0.343387515152j))*x[0]+((0.103260026788+0.410478101437j))*x[1]**o+((-0.142277954017+0.783719410149j))*x[1]
        ref[0, 0, 0, 0]=(0.083172570342-0.700618951915j)*o*x_ref[0]**(o-1)+((-0.477142189003+0.343387515152j))
        ref[0, 0, 0, 1]=(0.103260026788+0.410478101437j)*o*x_ref[1]**(o-1)+((-0.142277954017+0.783719410149j))
        arg[0, 0, 1]=(0.0411225211423+0.245323823668j)*x[0]**o+((0.54974505581-0.446557933945j))*x[0]+((-0.903200537406+0.660195538061j))*x[1]**o+((0.590576895356-0.605979515237j))*x[1]
        ref[0, 0, 1, 0]=(0.0411225211423+0.245323823668j)*o*x_ref[0]**(o-1)+((0.54974505581-0.446557933945j))
        ref[0, 0, 1, 1]=(-0.903200537406+0.660195538061j)*o*x_ref[1]**(o-1)+((0.590576895356-0.605979515237j))
        arg[0, 1, 0]=(0.716270879882-0.113317544257j)*x[0]**o+((-0.424088241921-0.173861337606j))*x[0]+((-0.405689655298-0.712418988106j))*x[1]**o+((-0.956693446252-0.696826152724j))*x[1]
        ref[0, 1, 0, 0]=(0.716270879882-0.113317544257j)*o*x_ref[0]**(o-1)+((-0.424088241921-0.173861337606j))
        ref[0, 1, 0, 1]=(-0.405689655298-0.712418988106j)*o*x_ref[1]**(o-1)+((-0.956693446252-0.696826152724j))
        arg[0, 1, 1]=(-0.302663879577-0.944983742295j)*x[0]**o+((-0.971363141991-0.299630404088j))*x[0]+((0.705134533893+0.946855438454j))*x[1]**o+((0.976869163927-0.606516211742j))*x[1]
        ref[0, 1, 1, 0]=(-0.302663879577-0.944983742295j)*o*x_ref[0]**(o-1)+((-0.971363141991-0.299630404088j))
        ref[0, 1, 1, 1]=(0.705134533893+0.946855438454j)*o*x_ref[1]**(o-1)+((0.976869163927-0.606516211742j))
        arg[0, 2, 0]=(0.604453313209-0.864768517068j)*x[0]**o+((-0.81351423358-0.68790578225j))*x[0]+((-0.44172643519-0.0782990628871j))*x[1]**o+((0.756407433623-0.403922756916j))*x[1]
        ref[0, 2, 0, 0]=(0.604453313209-0.864768517068j)*o*x_ref[0]**(o-1)+((-0.81351423358-0.68790578225j))
        ref[0, 2, 0, 1]=(-0.44172643519-0.0782990628871j)*o*x_ref[1]**(o-1)+((0.756407433623-0.403922756916j))
        arg[0, 2, 1]=(-0.466246039639-0.0933743024383j)*x[0]**o+((-0.100757519293+0.43699960662j))*x[0]+((0.590800995206+0.0469733326444j))*x[1]**o+((0.159186455158+0.0284019342224j))*x[1]
        ref[0, 2, 1, 0]=(-0.466246039639-0.0933743024383j)*o*x_ref[0]**(o-1)+((-0.100757519293+0.43699960662j))
        ref[0, 2, 1, 1]=(0.590800995206+0.0469733326444j)*o*x_ref[1]**(o-1)+((0.159186455158+0.0284019342224j))
        arg[0, 3, 0]=(-0.961922694254+0.463420781116j)*x[0]**o+((0.18315101057+0.569372180403j))*x[0]+((-0.258551485068-0.653865266602j))*x[1]**o+((0.872905468263+0.208952047022j))*x[1]
        ref[0, 3, 0, 0]=(-0.961922694254+0.463420781116j)*o*x_ref[0]**(o-1)+((0.18315101057+0.569372180403j))
        ref[0, 3, 0, 1]=(-0.258551485068-0.653865266602j)*o*x_ref[1]**(o-1)+((0.872905468263+0.208952047022j))
        arg[0, 3, 1]=(-0.290851213313-0.124807730776j)*x[0]**o+((0.658711315077-0.873387082982j))*x[0]+((-0.980228380863+0.599919733905j))*x[1]**o+((0.181039906274-0.0354593573011j))*x[1]
        ref[0, 3, 1, 0]=(-0.290851213313-0.124807730776j)*o*x_ref[0]**(o-1)+((0.658711315077-0.873387082982j))
        ref[0, 3, 1, 1]=(-0.980228380863+0.599919733905j)*o*x_ref[1]**(o-1)+((0.181039906274-0.0354593573011j))
        arg[1, 0, 0]=(-0.725086978583-0.0130641901011j)*x[0]**o+((0.522676000105-0.492241114869j))*x[0]+((0.865656791211-0.847816324694j))*x[1]**o+((0.38881053906+0.615232774698j))*x[1]
        ref[1, 0, 0, 0]=(-0.725086978583-0.0130641901011j)*o*x_ref[0]**(o-1)+((0.522676000105-0.492241114869j))
        ref[1, 0, 0, 1]=(0.865656791211-0.847816324694j)*o*x_ref[1]**(o-1)+((0.38881053906+0.615232774698j))
        arg[1, 0, 1]=(0.252164389347-0.330320019311j)*x[0]**o+((0.378365682643-0.23527814392j))*x[0]+((0.921143721123+0.0184386786551j))*x[1]**o+((-0.562962887108+0.360361870028j))*x[1]
        ref[1, 0, 1, 0]=(0.252164389347-0.330320019311j)*o*x_ref[0]**(o-1)+((0.378365682643-0.23527814392j))
        ref[1, 0, 1, 1]=(0.921143721123+0.0184386786551j)*o*x_ref[1]**(o-1)+((-0.562962887108+0.360361870028j))
        arg[1, 1, 0]=(0.910897841416+0.0473623060888j)*x[0]**o+((0.803988859428+0.80751670191j))*x[0]+((-0.0339537684625+0.0259286551861j))*x[1]**o+((-0.412148343312+0.0786598618443j))*x[1]
        ref[1, 1, 0, 0]=(0.910897841416+0.0473623060888j)*o*x_ref[0]**(o-1)+((0.803988859428+0.80751670191j))
        ref[1, 1, 0, 1]=(-0.0339537684625+0.0259286551861j)*o*x_ref[1]**(o-1)+((-0.412148343312+0.0786598618443j))
        arg[1, 1, 1]=(0.585571241007+0.136786327295j)*x[0]**o+((-0.924419968844-0.35482093073j))*x[0]+((-0.170273341071+0.96350837274j))*x[1]**o+((0.412059788459+0.773649691577j))*x[1]
        ref[1, 1, 1, 0]=(0.585571241007+0.136786327295j)*o*x_ref[0]**(o-1)+((-0.924419968844-0.35482093073j))
        ref[1, 1, 1, 1]=(-0.170273341071+0.96350837274j)*o*x_ref[1]**(o-1)+((0.412059788459+0.773649691577j))
        arg[1, 2, 0]=(0.160103156419+0.320452935716j)*x[0]**o+((-0.22514561446+0.526484102142j))*x[0]+((-0.199805911348-0.797001943137j))*x[1]**o+((0.914373826675+0.306537509453j))*x[1]
        ref[1, 2, 0, 0]=(0.160103156419+0.320452935716j)*o*x_ref[0]**(o-1)+((-0.22514561446+0.526484102142j))
        ref[1, 2, 0, 1]=(-0.199805911348-0.797001943137j)*o*x_ref[1]**(o-1)+((0.914373826675+0.306537509453j))
        arg[1, 2, 1]=(0.69770521178-0.569924864125j)*x[0]**o+((-0.21781273078-0.513501729188j))*x[0]+((-0.78152129835+0.17731116268j))*x[1]**o+((0.404324059665+0.476313066414j))*x[1]
        ref[1, 2, 1, 0]=(0.69770521178-0.569924864125j)*o*x_ref[0]**(o-1)+((-0.21781273078-0.513501729188j))
        ref[1, 2, 1, 1]=(-0.78152129835+0.17731116268j)*o*x_ref[1]**(o-1)+((0.404324059665+0.476313066414j))
        arg[1, 3, 0]=(0.857404363795-0.800517941825j)*x[0]**o+((-0.790214353545-0.754347031575j))*x[0]+((0.776456783705+0.64805641233j))*x[1]**o+((0.552309779648+0.459052131256j))*x[1]
        ref[1, 3, 0, 0]=(0.857404363795-0.800517941825j)*o*x_ref[0]**(o-1)+((-0.790214353545-0.754347031575j))
        ref[1, 3, 0, 1]=(0.776456783705+0.64805641233j)*o*x_ref[1]**(o-1)+((0.552309779648+0.459052131256j))
        arg[1, 3, 1]=(-0.836653332665-0.608797287355j)*x[0]**o+((-0.0538886491753-0.27515993931j))*x[0]+((0.269333157965+0.855766847147j))*x[1]**o+((0.455358612481+0.37194729806j))*x[1]
        ref[1, 3, 1, 0]=(-0.836653332665-0.608797287355j)*o*x_ref[0]**(o-1)+((-0.0538886491753-0.27515993931j))
        ref[1, 3, 1, 1]=(0.269333157965+0.855766847147j)*o*x_ref[1]**(o-1)+((0.455358612481+0.37194729806j))
        arg[2, 0, 0]=(0.484618996764-0.0919303719971j)*x[0]**o+((0.485167483685-0.389189935126j))*x[0]+((-0.764674114315+0.0902305434367j))*x[1]**o+((0.802306132336+0.24026818244j))*x[1]
        ref[2, 0, 0, 0]=(0.484618996764-0.0919303719971j)*o*x_ref[0]**(o-1)+((0.485167483685-0.389189935126j))
        ref[2, 0, 0, 1]=(-0.764674114315+0.0902305434367j)*o*x_ref[1]**(o-1)+((0.802306132336+0.24026818244j))
        arg[2, 0, 1]=(-0.0147991398348-0.64590662076j)*x[0]**o+((-0.157064696014-0.151494487816j))*x[0]+((-0.548490211519-0.937977800924j))*x[1]**o+((0.886813250157-0.501219168054j))*x[1]
        ref[2, 0, 1, 0]=(-0.0147991398348-0.64590662076j)*o*x_ref[0]**(o-1)+((-0.157064696014-0.151494487816j))
        ref[2, 0, 1, 1]=(-0.548490211519-0.937977800924j)*o*x_ref[1]**(o-1)+((0.886813250157-0.501219168054j))
        arg[2, 1, 0]=(-0.0023007913641-0.00712432504431j)*x[0]**o+((-0.736802080897-0.664137929527j))*x[0]+((0.535386621446+0.614247641387j))*x[1]**o+((-0.891621881428-0.413006859625j))*x[1]
        ref[2, 1, 0, 0]=(-0.0023007913641-0.00712432504431j)*o*x_ref[0]**(o-1)+((-0.736802080897-0.664137929527j))
        ref[2, 1, 0, 1]=(0.535386621446+0.614247641387j)*o*x_ref[1]**(o-1)+((-0.891621881428-0.413006859625j))
        arg[2, 1, 1]=(0.459044627223+0.713025321989j)*x[0]**o+((0.0243749816416+0.399776701482j))*x[0]+((-0.0258594674622+0.886214570341j))*x[1]**o+((0.603309810104+0.816391380841j))*x[1]
        ref[2, 1, 1, 0]=(0.459044627223+0.713025321989j)*o*x_ref[0]**(o-1)+((0.0243749816416+0.399776701482j))
        ref[2, 1, 1, 1]=(-0.0258594674622+0.886214570341j)*o*x_ref[1]**(o-1)+((0.603309810104+0.816391380841j))
        arg[2, 2, 0]=(-0.48458049697-0.242591455911j)*x[0]**o+((0.00197330287047+0.0694303238795j))*x[0]+((-0.0987419671875-0.159022249369j))*x[1]**o+((0.216334857821+0.0290765904728j))*x[1]
        ref[2, 2, 0, 0]=(-0.48458049697-0.242591455911j)*o*x_ref[0]**(o-1)+((0.00197330287047+0.0694303238795j))
        ref[2, 2, 0, 1]=(-0.0987419671875-0.159022249369j)*o*x_ref[1]**(o-1)+((0.216334857821+0.0290765904728j))
        arg[2, 2, 1]=(0.516394020409+0.0547859500105j)*x[0]**o+((0.161718093044-0.195739464177j))*x[0]+((0.737859832529-0.938671869577j))*x[1]**o+((-0.348256898051-0.989435772286j))*x[1]
        ref[2, 2, 1, 0]=(0.516394020409+0.0547859500105j)*o*x_ref[0]**(o-1)+((0.161718093044-0.195739464177j))
        ref[2, 2, 1, 1]=(0.737859832529-0.938671869577j)*o*x_ref[1]**(o-1)+((-0.348256898051-0.989435772286j))
        arg[2, 3, 0]=(-0.545095594352+0.67132625255j)*x[0]**o+((-0.101583530873+0.360481199654j))*x[0]+((-0.118324790717-0.392925537343j))*x[1]**o+((0.590228243164-0.45938496413j))*x[1]
        ref[2, 3, 0, 0]=(-0.545095594352+0.67132625255j)*o*x_ref[0]**(o-1)+((-0.101583530873+0.360481199654j))
        ref[2, 3, 0, 1]=(-0.118324790717-0.392925537343j)*o*x_ref[1]**(o-1)+((0.590228243164-0.45938496413j))
        arg[2, 3, 1]=(-0.112513914176-0.332000468986j)*x[0]**o+((-0.823634101644-0.0385483680359j))*x[0]+((0.675704298817-0.0661430935894j))*x[1]**o+((-0.596018418434-0.0475113326502j))*x[1]
        ref[2, 3, 1, 0]=(-0.112513914176-0.332000468986j)*o*x_ref[0]**(o-1)+((-0.823634101644-0.0385483680359j))
        ref[2, 3, 1, 1]=(0.675704298817-0.0661430935894j)*o*x_ref[1]**(o-1)+((-0.596018418434-0.0475113326502j))
        arg[3, 0, 0]=(-0.504749317447+0.054247837761j)*x[0]**o+((-0.883603628794+0.137965574031j))*x[0]+((-0.297762754695+0.240138624631j))*x[1]**o+((0.998926710662+0.783520473783j))*x[1]
        ref[3, 0, 0, 0]=(-0.504749317447+0.054247837761j)*o*x_ref[0]**(o-1)+((-0.883603628794+0.137965574031j))
        ref[3, 0, 0, 1]=(-0.297762754695+0.240138624631j)*o*x_ref[1]**(o-1)+((0.998926710662+0.783520473783j))
        arg[3, 0, 1]=(-0.699096249913-0.57568326774j)*x[0]**o+((-0.975286863777-0.680646651286j))*x[0]+((0.489966586987+0.133551445694j))*x[1]**o+((-0.989415997263-0.785098848725j))*x[1]
        ref[3, 0, 1, 0]=(-0.699096249913-0.57568326774j)*o*x_ref[0]**(o-1)+((-0.975286863777-0.680646651286j))
        ref[3, 0, 1, 1]=(0.489966586987+0.133551445694j)*o*x_ref[1]**(o-1)+((-0.989415997263-0.785098848725j))
        arg[3, 1, 0]=(0.64126510336-0.541320730449j)*x[0]**o+((-0.35423059661-0.0664713671658j))*x[0]+((-0.833328300981-0.162463573899j))*x[1]**o+((-0.415306781545+0.515371880153j))*x[1]
        ref[3, 1, 0, 0]=(0.64126510336-0.541320730449j)*o*x_ref[0]**(o-1)+((-0.35423059661-0.0664713671658j))
        ref[3, 1, 0, 1]=(-0.833328300981-0.162463573899j)*o*x_ref[1]**(o-1)+((-0.415306781545+0.515371880153j))
        arg[3, 1, 1]=(0.838552797573-0.981328620833j)*x[0]**o+((0.148449508048+0.94596170266j))*x[0]+((-0.749696232929+0.47475264037j))*x[1]**o+((-0.272005616615-0.475333742994j))*x[1]
        ref[3, 1, 1, 0]=(0.838552797573-0.981328620833j)*o*x_ref[0]**(o-1)+((0.148449508048+0.94596170266j))
        ref[3, 1, 1, 1]=(-0.749696232929+0.47475264037j)*o*x_ref[1]**(o-1)+((-0.272005616615-0.475333742994j))
        arg[3, 2, 0]=(-0.122087305998+0.559553232327j)*x[0]**o+((0.440198490194-0.620348054694j))*x[0]+((0.309953736006-0.877475533251j))*x[1]**o+((0.684451221454-0.323981343706j))*x[1]
        ref[3, 2, 0, 0]=(-0.122087305998+0.559553232327j)*o*x_ref[0]**(o-1)+((0.440198490194-0.620348054694j))
        ref[3, 2, 0, 1]=(0.309953736006-0.877475533251j)*o*x_ref[1]**(o-1)+((0.684451221454-0.323981343706j))
        arg[3, 2, 1]=(0.347877070343-0.769266653133j)*x[0]**o+((-0.994001038546+0.343735148208j))*x[0]+((0.11782638854-0.318878084828j))*x[1]**o+((0.542398867512+0.60895622743j))*x[1]
        ref[3, 2, 1, 0]=(0.347877070343-0.769266653133j)*o*x_ref[0]**(o-1)+((-0.994001038546+0.343735148208j))
        ref[3, 2, 1, 1]=(0.11782638854-0.318878084828j)*o*x_ref[1]**(o-1)+((0.542398867512+0.60895622743j))
        arg[3, 3, 0]=(-0.356419308762+0.0876459223219j)*x[0]**o+((0.744481624517+0.0921399236724j))*x[0]+((0.533817049488+0.711411207222j))*x[1]**o+((-0.950214358452-0.695109316976j))*x[1]
        ref[3, 3, 0, 0]=(-0.356419308762+0.0876459223219j)*o*x_ref[0]**(o-1)+((0.744481624517+0.0921399236724j))
        ref[3, 3, 0, 1]=(0.533817049488+0.711411207222j)*o*x_ref[1]**(o-1)+((-0.950214358452-0.695109316976j))
        arg[3, 3, 1]=(0.912324745211-0.23199376618j)*x[0]**o+((-0.296011357792-0.702655513732j))*x[0]+((0.00142372874638+0.0712269276197j))*x[1]**o+((0.795948058708-0.494629641166j))*x[1]
        ref[3, 3, 1, 0]=(0.912324745211-0.23199376618j)*o*x_ref[0]**(o-1)+((-0.296011357792-0.702655513732j))
        ref[3, 3, 1, 1]=(0.00142372874638+0.0712269276197j)*o*x_ref[1]**(o-1)+((0.795948058708-0.494629641166j))
        if dim==3:
            arg[0, 0, 0]+=(0.62471697835+0.249783193786j)*x[2]**o+((-0.153161804542+0.496949694597j))*x[2]
            ref[0, 0, 0, 2]=(0.62471697835+0.249783193786j)*o*x_ref[2]**(o-1)+((-0.153161804542+0.496949694597j))
            arg[0, 0, 1]+=(-0.948743604827+0.575809428052j)*x[2]**o+((-0.740262919106-0.810928437948j))*x[2]
            ref[0, 0, 1, 2]=(-0.948743604827+0.575809428052j)*o*x_ref[2]**(o-1)+((-0.740262919106-0.810928437948j))
            arg[0, 1, 0]+=(-0.707611941191-0.645095811659j)*x[2]**o+((-0.451015429566+0.610661027908j))*x[2]
            ref[0, 1, 0, 2]=(-0.707611941191-0.645095811659j)*o*x_ref[2]**(o-1)+((-0.451015429566+0.610661027908j))
            arg[0, 1, 1]+=(-0.0990878542448+0.724406621022j)*x[2]**o+((-0.722566026698-0.388650255053j))*x[2]
            ref[0, 1, 1, 2]=(-0.0990878542448+0.724406621022j)*o*x_ref[2]**(o-1)+((-0.722566026698-0.388650255053j))
            arg[0, 2, 0]+=(0.443702599897-0.0658011265341j)*x[2]**o+((-0.659761709883+0.592346564254j))*x[2]
            ref[0, 2, 0, 2]=(0.443702599897-0.0658011265341j)*o*x_ref[2]**(o-1)+((-0.659761709883+0.592346564254j))
            arg[0, 2, 1]+=(-0.876202669774+0.783304159891j)*x[2]**o+((-0.82268656174-0.380644748684j))*x[2]
            ref[0, 2, 1, 2]=(-0.876202669774+0.783304159891j)*o*x_ref[2]**(o-1)+((-0.82268656174-0.380644748684j))
            arg[0, 3, 0]+=(0.572737051088-0.624796059658j)*x[2]**o+((-0.405025322084+0.576945491063j))*x[2]
            ref[0, 3, 0, 2]=(0.572737051088-0.624796059658j)*o*x_ref[2]**(o-1)+((-0.405025322084+0.576945491063j))
            arg[0, 3, 1]+=(0.871986574497-0.844499994007j)*x[2]**o+((0.594181321917-0.501296173044j))*x[2]
            ref[0, 3, 1, 2]=(0.871986574497-0.844499994007j)*o*x_ref[2]**(o-1)+((0.594181321917-0.501296173044j))
            arg[1, 0, 0]+=(-0.0883044708954+0.83532350068j)*x[2]**o+((0.539817747876+0.617377535299j))*x[2]
            ref[1, 0, 0, 2]=(-0.0883044708954+0.83532350068j)*o*x_ref[2]**(o-1)+((0.539817747876+0.617377535299j))
            arg[1, 0, 1]+=(0.34142193363-0.670205169529j)*x[2]**o+((0.238164161891+0.890662125553j))*x[2]
            ref[1, 0, 1, 2]=(0.34142193363-0.670205169529j)*o*x_ref[2]**(o-1)+((0.238164161891+0.890662125553j))
            arg[1, 1, 0]+=(-0.473489378112+0.041610554343j)*x[2]**o+((-0.149851058618-0.361435184436j))*x[2]
            ref[1, 1, 0, 2]=(-0.473489378112+0.041610554343j)*o*x_ref[2]**(o-1)+((-0.149851058618-0.361435184436j))
            arg[1, 1, 1]+=(-0.836702883608-0.921755153001j)*x[2]**o+((-0.0309699799645-0.623000595882j))*x[2]
            ref[1, 1, 1, 2]=(-0.836702883608-0.921755153001j)*o*x_ref[2]**(o-1)+((-0.0309699799645-0.623000595882j))
            arg[1, 2, 0]+=(-0.118043599615-0.0384582653234j)*x[2]**o+((-0.31072868108+0.910214838652j))*x[2]
            ref[1, 2, 0, 2]=(-0.118043599615-0.0384582653234j)*o*x_ref[2]**(o-1)+((-0.31072868108+0.910214838652j))
            arg[1, 2, 1]+=(0.998466425602+0.916256763847j)*x[2]**o+((-0.770558558565+0.0845818444348j))*x[2]
            ref[1, 2, 1, 2]=(0.998466425602+0.916256763847j)*o*x_ref[2]**(o-1)+((-0.770558558565+0.0845818444348j))
            arg[1, 3, 0]+=(-0.595030417589-0.255328381826j)*x[2]**o+((0.226638615937+0.910529227819j))*x[2]
            ref[1, 3, 0, 2]=(-0.595030417589-0.255328381826j)*o*x_ref[2]**(o-1)+((0.226638615937+0.910529227819j))
            arg[1, 3, 1]+=(0.337521126562-0.768465673253j)*x[2]**o+((0.329764729145+0.263285881094j))*x[2]
            ref[1, 3, 1, 2]=(0.337521126562-0.768465673253j)*o*x_ref[2]**(o-1)+((0.329764729145+0.263285881094j))
            arg[2, 0, 0]+=(0.0558485829528-0.268272073532j)*x[2]**o+((0.361270791328-0.887147611675j))*x[2]
            ref[2, 0, 0, 2]=(0.0558485829528-0.268272073532j)*o*x_ref[2]**(o-1)+((0.361270791328-0.887147611675j))
            arg[2, 0, 1]+=(-0.375122992941-0.403769487733j)*x[2]**o+((0.658621468217-0.501535308709j))*x[2]
            ref[2, 0, 1, 2]=(-0.375122992941-0.403769487733j)*o*x_ref[2]**(o-1)+((0.658621468217-0.501535308709j))
            arg[2, 1, 0]+=(-0.459856711779-0.979222903032j)*x[2]**o+((0.41922399329+0.278651923968j))*x[2]
            ref[2, 1, 0, 2]=(-0.459856711779-0.979222903032j)*o*x_ref[2]**(o-1)+((0.41922399329+0.278651923968j))
            arg[2, 1, 1]+=(0.761550869278+0.194517240038j)*x[2]**o+((-0.367872461852+0.119505489876j))*x[2]
            ref[2, 1, 1, 2]=(0.761550869278+0.194517240038j)*o*x_ref[2]**(o-1)+((-0.367872461852+0.119505489876j))
            arg[2, 2, 0]+=(0.635294708343-0.657936080119j)*x[2]**o+((0.866623221884+0.819445555557j))*x[2]
            ref[2, 2, 0, 2]=(0.635294708343-0.657936080119j)*o*x_ref[2]**(o-1)+((0.866623221884+0.819445555557j))
            arg[2, 2, 1]+=(-0.377835691984-0.06107560841j)*x[2]**o+((-0.964515416994+0.434884476708j))*x[2]
            ref[2, 2, 1, 2]=(-0.377835691984-0.06107560841j)*o*x_ref[2]**(o-1)+((-0.964515416994+0.434884476708j))
            arg[2, 3, 0]+=(0.915493569266+0.753254776416j)*x[2]**o+((0.158950160024+0.852382195016j))*x[2]
            ref[2, 3, 0, 2]=(0.915493569266+0.753254776416j)*o*x_ref[2]**(o-1)+((0.158950160024+0.852382195016j))
            arg[2, 3, 1]+=(-0.0336712113531-0.281977712001j)*x[2]**o+((0.998272592598-0.267716392545j))*x[2]
            ref[2, 3, 1, 2]=(-0.0336712113531-0.281977712001j)*o*x_ref[2]**(o-1)+((0.998272592598-0.267716392545j))
            arg[3, 0, 0]+=(-0.746314816729-0.271070503153j)*x[2]**o+((0.641933054+0.172727219748j))*x[2]
            ref[3, 0, 0, 2]=(-0.746314816729-0.271070503153j)*o*x_ref[2]**(o-1)+((0.641933054+0.172727219748j))
            arg[3, 0, 1]+=(0.626930130229+0.450668764912j)*x[2]**o+((0.00363258739025+0.937938288359j))*x[2]
            ref[3, 0, 1, 2]=(0.626930130229+0.450668764912j)*o*x_ref[2]**(o-1)+((0.00363258739025+0.937938288359j))
            arg[3, 1, 0]+=(0.777722519214-0.413968499749j)*x[2]**o+((-0.405303226092-0.870837750053j))*x[2]
            ref[3, 1, 0, 2]=(0.777722519214-0.413968499749j)*o*x_ref[2]**(o-1)+((-0.405303226092-0.870837750053j))
            arg[3, 1, 1]+=(0.373626610237-0.371907896136j)*x[2]**o+((0.675703422966-0.179300927113j))*x[2]
            ref[3, 1, 1, 2]=(0.373626610237-0.371907896136j)*o*x_ref[2]**(o-1)+((0.675703422966-0.179300927113j))
            arg[3, 2, 0]+=(0.19628269306-0.51222739068j)*x[2]**o+((-0.112798761373+0.897166507885j))*x[2]
            ref[3, 2, 0, 2]=(0.19628269306-0.51222739068j)*o*x_ref[2]**(o-1)+((-0.112798761373+0.897166507885j))
            arg[3, 2, 1]+=(0.583597890607+0.928948902499j)*x[2]**o+((0.01592010134-0.0340342377627j))*x[2]
            ref[3, 2, 1, 2]=(0.583597890607+0.928948902499j)*o*x_ref[2]**(o-1)+((0.01592010134-0.0340342377627j))
            arg[3, 3, 0]+=(-0.0108155283379+0.0627685443159j)*x[2]**o+((-0.745847015315-0.160662642043j))*x[2]
            ref[3, 3, 0, 2]=(-0.0108155283379+0.0627685443159j)*o*x_ref[2]**(o-1)+((-0.745847015315-0.160662642043j))
            arg[3, 3, 1]+=(-0.484349243614-0.986016286478j)*x[2]**o+((-0.185796615459-0.507781016901j))*x[2]
            ref[3, 3, 1, 2]=(-0.484349243614-0.986016286478j)*o*x_ref[2]**(o-1)+((-0.185796615459-0.507781016901j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4, 4, 2)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnBoundary_fromData_ReducedSolution_rank0(self):
        """
        tests gradient of rank 0 Data on ReducedFunctionOnBoundary

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=(0.83875569196-0.833045746712j)*x[0]+((0.419351769008+0.375234029371j))*x[1]
        ref[0]=(0.83875569196-0.833045746712j)
        ref[1]=(0.419351769008+0.375234029371j)
        if dim==3:
            arg+=((0.0946854490599+0.196920808611j))*x[2]
            ref[2]=(0.0946854490599+0.196920808611j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnBoundary_fromData_ReducedSolution_rank1(self):
        """
        tests gradient of rank 1 Data on ReducedFunctionOnBoundary

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(2,),w)
        ref = Data(0,(2,)+(dim,),w_ref)
        arg[0,]=(-0.303363494278-0.102755261612j)*x[0]+((0.706398623753-0.578839582503j))*x[1]
        ref[0, 0]=(-0.303363494278-0.102755261612j)
        ref[0, 1]=(0.706398623753-0.578839582503j)
        arg[1,]=(0.816280052249+0.0816444445569j)*x[0]+((-0.978244695555+0.149696371463j))*x[1]
        ref[1, 0]=(0.816280052249+0.0816444445569j)
        ref[1, 1]=(-0.978244695555+0.149696371463j)
        if dim==3:
            arg[0,]+=(-0.224098560559-0.367545732548j)*x[2]
            ref[0, 2]=(-0.224098560559-0.367545732548j)
            arg[1,]+=(-0.125250069314+0.00260144155324j)*x[2]
            ref[1, 2]=(-0.125250069314+0.00260144155324j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnBoundary_fromData_ReducedSolution_rank2(self):
        """
        tests gradient of rank 2 Data on ReducedFunctionOnBoundary

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(4, 3),w)
        ref = Data(0,(4, 3)+(dim,),w_ref)
        arg[0, 0]=(-0.984805087698-0.995423687891j)*x[0]+((0.375153370178+0.492577963445j))*x[1]
        ref[0, 0, 0]=(-0.984805087698-0.995423687891j)
        ref[0, 0, 1]=(0.375153370178+0.492577963445j)
        arg[0, 1]=(0.981220811106+0.278498296256j)*x[0]+((0.119501899974-0.503096254675j))*x[1]
        ref[0, 1, 0]=(0.981220811106+0.278498296256j)
        ref[0, 1, 1]=(0.119501899974-0.503096254675j)
        arg[0, 2]=(0.875424739874-0.244644385813j)*x[0]+((-0.480843911504-0.0173402306472j))*x[1]
        ref[0, 2, 0]=(0.875424739874-0.244644385813j)
        ref[0, 2, 1]=(-0.480843911504-0.0173402306472j)
        arg[1, 0]=(-0.466924770218-0.474945773812j)*x[0]+((0.991100396664-0.609675281778j))*x[1]
        ref[1, 0, 0]=(-0.466924770218-0.474945773812j)
        ref[1, 0, 1]=(0.991100396664-0.609675281778j)
        arg[1, 1]=(0.512233261583+0.457880364149j)*x[0]+((0.914376842639-0.215644919332j))*x[1]
        ref[1, 1, 0]=(0.512233261583+0.457880364149j)
        ref[1, 1, 1]=(0.914376842639-0.215644919332j)
        arg[1, 2]=(-0.247491715047+0.662254086682j)*x[0]+((-0.338053787052-0.666510037158j))*x[1]
        ref[1, 2, 0]=(-0.247491715047+0.662254086682j)
        ref[1, 2, 1]=(-0.338053787052-0.666510037158j)
        arg[2, 0]=(0.170682919285+0.313695742023j)*x[0]+((-0.602000473747+0.541131818905j))*x[1]
        ref[2, 0, 0]=(0.170682919285+0.313695742023j)
        ref[2, 0, 1]=(-0.602000473747+0.541131818905j)
        arg[2, 1]=(-0.444693155175+0.251846744235j)*x[0]+((0.998558873231-0.769585066704j))*x[1]
        ref[2, 1, 0]=(-0.444693155175+0.251846744235j)
        ref[2, 1, 1]=(0.998558873231-0.769585066704j)
        arg[2, 2]=(0.701898709567+0.185554847551j)*x[0]+((0.274890392232-0.0582694982802j))*x[1]
        ref[2, 2, 0]=(0.701898709567+0.185554847551j)
        ref[2, 2, 1]=(0.274890392232-0.0582694982802j)
        arg[3, 0]=(-0.176995259418+0.813022289006j)*x[0]+((0.528172415064+0.467651076955j))*x[1]
        ref[3, 0, 0]=(-0.176995259418+0.813022289006j)
        ref[3, 0, 1]=(0.528172415064+0.467651076955j)
        arg[3, 1]=(-0.803166399519-0.121041754054j)*x[0]+((-0.44874749652-0.600931231256j))*x[1]
        ref[3, 1, 0]=(-0.803166399519-0.121041754054j)
        ref[3, 1, 1]=(-0.44874749652-0.600931231256j)
        arg[3, 2]=(-0.0278320034263+0.758942371254j)*x[0]+((0.313740025128-0.741097931838j))*x[1]
        ref[3, 2, 0]=(-0.0278320034263+0.758942371254j)
        ref[3, 2, 1]=(0.313740025128-0.741097931838j)
        if dim==3:
            arg[0, 0]+=(0.0392909758569-0.943635642263j)*x[2]
            ref[0, 0, 2]=(0.0392909758569-0.943635642263j)
            arg[0, 1]+=(0.378359148631-0.00410500155272j)*x[2]
            ref[0, 1, 2]=(0.378359148631-0.00410500155272j)
            arg[0, 2]+=(-0.388123061805-0.779046218782j)*x[2]
            ref[0, 2, 2]=(-0.388123061805-0.779046218782j)
            arg[1, 0]+=(0.484150814418+0.622823842615j)*x[2]
            ref[1, 0, 2]=(0.484150814418+0.622823842615j)
            arg[1, 1]+=(0.290189538724-0.983309165484j)*x[2]
            ref[1, 1, 2]=(0.290189538724-0.983309165484j)
            arg[1, 2]+=(-0.0976007320658-0.506926129688j)*x[2]
            ref[1, 2, 2]=(-0.0976007320658-0.506926129688j)
            arg[2, 0]+=(-0.805582330993-0.990518517991j)*x[2]
            ref[2, 0, 2]=(-0.805582330993-0.990518517991j)
            arg[2, 1]+=(-0.894717608643-0.610723393799j)*x[2]
            ref[2, 1, 2]=(-0.894717608643-0.610723393799j)
            arg[2, 2]+=(-0.908872875428+0.921859147743j)*x[2]
            ref[2, 2, 2]=(-0.908872875428+0.921859147743j)
            arg[3, 0]+=(0.951333094754+0.00554706429199j)*x[2]
            ref[3, 0, 2]=(0.951333094754+0.00554706429199j)
            arg[3, 1]+=(-0.728441902117+0.502112245085j)*x[2]
            ref[3, 1, 2]=(-0.728441902117+0.502112245085j)
            arg[3, 2]+=(0.0302892208785+0.0137209659976j)*x[2]
            ref[3, 2, 2]=(0.0302892208785+0.0137209659976j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4, 3)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnBoundary_fromData_ReducedSolution_rank3(self):
        """
        tests gradient of rank 3 Data on ReducedFunctionOnBoundary

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(2, 4, 2),w)
        ref = Data(0,(2, 4, 2)+(dim,),w_ref)
        arg[0, 0, 0]=(0.26993546754-0.077615339859j)*x[0]+((-0.463175136761-0.774332614662j))*x[1]
        ref[0, 0, 0, 0]=(0.26993546754-0.077615339859j)
        ref[0, 0, 0, 1]=(-0.463175136761-0.774332614662j)
        arg[0, 0, 1]=(0.485183570678-0.436054557961j)*x[0]+((-0.0906630498804-0.761295751639j))*x[1]
        ref[0, 0, 1, 0]=(0.485183570678-0.436054557961j)
        ref[0, 0, 1, 1]=(-0.0906630498804-0.761295751639j)
        arg[0, 1, 0]=(-0.226085662553-0.857715624064j)*x[0]+((-0.851224999103+0.402253783065j))*x[1]
        ref[0, 1, 0, 0]=(-0.226085662553-0.857715624064j)
        ref[0, 1, 0, 1]=(-0.851224999103+0.402253783065j)
        arg[0, 1, 1]=(-0.264055034123-0.168701349448j)*x[0]+((-0.0766576644492+0.453886558298j))*x[1]
        ref[0, 1, 1, 0]=(-0.264055034123-0.168701349448j)
        ref[0, 1, 1, 1]=(-0.0766576644492+0.453886558298j)
        arg[0, 2, 0]=(0.599790536357-0.582533208681j)*x[0]+((-0.941888732239-0.868587510552j))*x[1]
        ref[0, 2, 0, 0]=(0.599790536357-0.582533208681j)
        ref[0, 2, 0, 1]=(-0.941888732239-0.868587510552j)
        arg[0, 2, 1]=(0.887401108098+0.911893537967j)*x[0]+((-0.159397399328-0.197248946791j))*x[1]
        ref[0, 2, 1, 0]=(0.887401108098+0.911893537967j)
        ref[0, 2, 1, 1]=(-0.159397399328-0.197248946791j)
        arg[0, 3, 0]=(0.041522943594-0.642753746116j)*x[0]+((-0.7368920436+0.943458816974j))*x[1]
        ref[0, 3, 0, 0]=(0.041522943594-0.642753746116j)
        ref[0, 3, 0, 1]=(-0.7368920436+0.943458816974j)
        arg[0, 3, 1]=(0.0403465780193-0.194720837411j)*x[0]+((0.49122184483+0.55102914398j))*x[1]
        ref[0, 3, 1, 0]=(0.0403465780193-0.194720837411j)
        ref[0, 3, 1, 1]=(0.49122184483+0.55102914398j)
        arg[1, 0, 0]=(-0.0479000801604-0.633066410238j)*x[0]+((-0.467713049227+0.905719323153j))*x[1]
        ref[1, 0, 0, 0]=(-0.0479000801604-0.633066410238j)
        ref[1, 0, 0, 1]=(-0.467713049227+0.905719323153j)
        arg[1, 0, 1]=(-0.625242928232+0.780141061862j)*x[0]+((0.8894801783+0.334349902991j))*x[1]
        ref[1, 0, 1, 0]=(-0.625242928232+0.780141061862j)
        ref[1, 0, 1, 1]=(0.8894801783+0.334349902991j)
        arg[1, 1, 0]=(-0.334126319599-0.899368205306j)*x[0]+((0.249297956332+0.992499818198j))*x[1]
        ref[1, 1, 0, 0]=(-0.334126319599-0.899368205306j)
        ref[1, 1, 0, 1]=(0.249297956332+0.992499818198j)
        arg[1, 1, 1]=(-0.202234616264-0.918455142068j)*x[0]+((-0.987747722441-0.0530739637505j))*x[1]
        ref[1, 1, 1, 0]=(-0.202234616264-0.918455142068j)
        ref[1, 1, 1, 1]=(-0.987747722441-0.0530739637505j)
        arg[1, 2, 0]=(-0.600586492901-0.834483694491j)*x[0]+((0.774230546373+0.262589388545j))*x[1]
        ref[1, 2, 0, 0]=(-0.600586492901-0.834483694491j)
        ref[1, 2, 0, 1]=(0.774230546373+0.262589388545j)
        arg[1, 2, 1]=(0.588240565361+0.357801963233j)*x[0]+((0.212449824911+0.949533835957j))*x[1]
        ref[1, 2, 1, 0]=(0.588240565361+0.357801963233j)
        ref[1, 2, 1, 1]=(0.212449824911+0.949533835957j)
        arg[1, 3, 0]=(0.320782287909-0.314115199391j)*x[0]+((-0.477693883758+0.208123849056j))*x[1]
        ref[1, 3, 0, 0]=(0.320782287909-0.314115199391j)
        ref[1, 3, 0, 1]=(-0.477693883758+0.208123849056j)
        arg[1, 3, 1]=(0.41958912835+0.388475800215j)*x[0]+((0.340946707061-0.534335828982j))*x[1]
        ref[1, 3, 1, 0]=(0.41958912835+0.388475800215j)
        ref[1, 3, 1, 1]=(0.340946707061-0.534335828982j)
        if dim==3:
            arg[0, 0, 0]+=(-0.433923824262+0.280531869006j)*x[2]
            ref[0, 0, 0, 2]=(-0.433923824262+0.280531869006j)
            arg[0, 0, 1]+=(-0.490196714-0.221138312022j)*x[2]
            ref[0, 0, 1, 2]=(-0.490196714-0.221138312022j)
            arg[0, 1, 0]+=(-0.415240880116-0.316126652374j)*x[2]
            ref[0, 1, 0, 2]=(-0.415240880116-0.316126652374j)
            arg[0, 1, 1]+=(-0.609877337787-0.116682623492j)*x[2]
            ref[0, 1, 1, 2]=(-0.609877337787-0.116682623492j)
            arg[0, 2, 0]+=(-0.601715797108+0.778480758102j)*x[2]
            ref[0, 2, 0, 2]=(-0.601715797108+0.778480758102j)
            arg[0, 2, 1]+=(-0.173397445754-0.646427091292j)*x[2]
            ref[0, 2, 1, 2]=(-0.173397445754-0.646427091292j)
            arg[0, 3, 0]+=(-0.946545960007-0.620818232638j)*x[2]
            ref[0, 3, 0, 2]=(-0.946545960007-0.620818232638j)
            arg[0, 3, 1]+=(0.877468441559+0.199595992162j)*x[2]
            ref[0, 3, 1, 2]=(0.877468441559+0.199595992162j)
            arg[1, 0, 0]+=(-0.516592581675-0.185859903738j)*x[2]
            ref[1, 0, 0, 2]=(-0.516592581675-0.185859903738j)
            arg[1, 0, 1]+=(-0.929676578027-0.386238466357j)*x[2]
            ref[1, 0, 1, 2]=(-0.929676578027-0.386238466357j)
            arg[1, 1, 0]+=(0.800835977959+0.51226926888j)*x[2]
            ref[1, 1, 0, 2]=(0.800835977959+0.51226926888j)
            arg[1, 1, 1]+=(0.42202119668-0.21277436338j)*x[2]
            ref[1, 1, 1, 2]=(0.42202119668-0.21277436338j)
            arg[1, 2, 0]+=(0.027046316004+0.746798455322j)*x[2]
            ref[1, 2, 0, 2]=(0.027046316004+0.746798455322j)
            arg[1, 2, 1]+=(-0.627537361628+0.780096028638j)*x[2]
            ref[1, 2, 1, 2]=(-0.627537361628+0.780096028638j)
            arg[1, 3, 0]+=(-0.932744969977+0.530560868284j)*x[2]
            ref[1, 3, 0, 2]=(-0.932744969977+0.530560868284j)
            arg[1, 3, 1]+=(-0.415803007672+0.444790357114j)*x[2]
            ref[1, 3, 1, 2]=(-0.415803007672+0.444790357114j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2, 4, 2)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnBoundary_fromData_ReducedContinuousFunction_rank0(self):
        """
        tests gradient of rank 0 Data on ReducedFunctionOnBoundary

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=(-0.645353801993+0.0750834942935j)*x[0]+((0.269820070954-0.588214596224j))*x[1]
        ref[0]=(-0.645353801993+0.0750834942935j)
        ref[1]=(0.269820070954-0.588214596224j)
        if dim==3:
            arg+=((-0.910355658458+0.23690453526j))*x[2]
            ref[2]=(-0.910355658458+0.23690453526j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnBoundary_fromData_ReducedContinuousFunction_rank1(self):
        """
        tests gradient of rank 1 Data on ReducedFunctionOnBoundary

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(2,),w)
        ref = Data(0,(2,)+(dim,),w_ref)
        arg[0,]=(0.616205880518-0.810906327597j)*x[0]+((0.398778504735+0.607212072606j))*x[1]
        ref[0, 0]=(0.616205880518-0.810906327597j)
        ref[0, 1]=(0.398778504735+0.607212072606j)
        arg[1,]=(-0.730075022372-0.497878122995j)*x[0]+((-0.653778569674+0.903092140077j))*x[1]
        ref[1, 0]=(-0.730075022372-0.497878122995j)
        ref[1, 1]=(-0.653778569674+0.903092140077j)
        if dim==3:
            arg[0,]+=(-0.207009476275-0.482399508067j)*x[2]
            ref[0, 2]=(-0.207009476275-0.482399508067j)
            arg[1,]+=(-0.309978893311-0.929588601198j)*x[2]
            ref[1, 2]=(-0.309978893311-0.929588601198j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnBoundary_fromData_ReducedContinuousFunction_rank2(self):
        """
        tests gradient of rank 2 Data on ReducedFunctionOnBoundary

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(3, 4),w)
        ref = Data(0,(3, 4)+(dim,),w_ref)
        arg[0, 0]=(-0.933970556706-0.545245457596j)*x[0]+((-0.0878249857783+0.940874676968j))*x[1]
        ref[0, 0, 0]=(-0.933970556706-0.545245457596j)
        ref[0, 0, 1]=(-0.0878249857783+0.940874676968j)
        arg[0, 1]=(0.21088554412+0.0995719225291j)*x[0]+((-0.615620097031-0.906600847251j))*x[1]
        ref[0, 1, 0]=(0.21088554412+0.0995719225291j)
        ref[0, 1, 1]=(-0.615620097031-0.906600847251j)
        arg[0, 2]=(-0.0740699850475-0.0591327877302j)*x[0]+((0.704495553828+0.830712711436j))*x[1]
        ref[0, 2, 0]=(-0.0740699850475-0.0591327877302j)
        ref[0, 2, 1]=(0.704495553828+0.830712711436j)
        arg[0, 3]=(0.451645187409-0.189813339937j)*x[0]+((0.530121304149-0.551921508632j))*x[1]
        ref[0, 3, 0]=(0.451645187409-0.189813339937j)
        ref[0, 3, 1]=(0.530121304149-0.551921508632j)
        arg[1, 0]=(0.748120194164-0.603302273778j)*x[0]+((0.864620124057-0.478603150184j))*x[1]
        ref[1, 0, 0]=(0.748120194164-0.603302273778j)
        ref[1, 0, 1]=(0.864620124057-0.478603150184j)
        arg[1, 1]=(0.837599317108-0.302686972019j)*x[0]+((-0.628546580309-0.600460026068j))*x[1]
        ref[1, 1, 0]=(0.837599317108-0.302686972019j)
        ref[1, 1, 1]=(-0.628546580309-0.600460026068j)
        arg[1, 2]=(0.17734320674-0.433815686162j)*x[0]+((-0.821037747989+0.89121102281j))*x[1]
        ref[1, 2, 0]=(0.17734320674-0.433815686162j)
        ref[1, 2, 1]=(-0.821037747989+0.89121102281j)
        arg[1, 3]=(-0.965918995325-0.994230038346j)*x[0]+((-0.282616764917-0.0225769868612j))*x[1]
        ref[1, 3, 0]=(-0.965918995325-0.994230038346j)
        ref[1, 3, 1]=(-0.282616764917-0.0225769868612j)
        arg[2, 0]=(0.123927051004-0.775734597253j)*x[0]+((0.474150600741-0.194985008084j))*x[1]
        ref[2, 0, 0]=(0.123927051004-0.775734597253j)
        ref[2, 0, 1]=(0.474150600741-0.194985008084j)
        arg[2, 1]=(0.286071351066-0.537563667013j)*x[0]+((-0.126101618085-0.710374385623j))*x[1]
        ref[2, 1, 0]=(0.286071351066-0.537563667013j)
        ref[2, 1, 1]=(-0.126101618085-0.710374385623j)
        arg[2, 2]=(-0.706662080506+0.214544401843j)*x[0]+((-0.50219225692-0.997936397914j))*x[1]
        ref[2, 2, 0]=(-0.706662080506+0.214544401843j)
        ref[2, 2, 1]=(-0.50219225692-0.997936397914j)
        arg[2, 3]=(-0.259362522488-0.328658316441j)*x[0]+((0.744003104892-0.405508028734j))*x[1]
        ref[2, 3, 0]=(-0.259362522488-0.328658316441j)
        ref[2, 3, 1]=(0.744003104892-0.405508028734j)
        if dim==3:
            arg[0, 0]+=(-0.755350090876+0.876093424007j)*x[2]
            ref[0, 0, 2]=(-0.755350090876+0.876093424007j)
            arg[0, 1]+=(-0.510235258815-0.875233311766j)*x[2]
            ref[0, 1, 2]=(-0.510235258815-0.875233311766j)
            arg[0, 2]+=(-0.588106293677-0.657133092101j)*x[2]
            ref[0, 2, 2]=(-0.588106293677-0.657133092101j)
            arg[0, 3]+=(0.427157156219+0.442393485535j)*x[2]
            ref[0, 3, 2]=(0.427157156219+0.442393485535j)
            arg[1, 0]+=(0.780175822593-0.543832780992j)*x[2]
            ref[1, 0, 2]=(0.780175822593-0.543832780992j)
            arg[1, 1]+=(0.205427099451+0.144519832635j)*x[2]
            ref[1, 1, 2]=(0.205427099451+0.144519832635j)
            arg[1, 2]+=(0.0415713282972-0.219385148291j)*x[2]
            ref[1, 2, 2]=(0.0415713282972-0.219385148291j)
            arg[1, 3]+=(-0.659942294649-0.885270720799j)*x[2]
            ref[1, 3, 2]=(-0.659942294649-0.885270720799j)
            arg[2, 0]+=(0.215101180173+0.545270644139j)*x[2]
            ref[2, 0, 2]=(0.215101180173+0.545270644139j)
            arg[2, 1]+=(0.0466856929156-0.394775847435j)*x[2]
            ref[2, 1, 2]=(0.0466856929156-0.394775847435j)
            arg[2, 2]+=(-0.492447001103-0.359849095796j)*x[2]
            ref[2, 2, 2]=(-0.492447001103-0.359849095796j)
            arg[2, 3]+=(0.185298080161-0.265643955371j)*x[2]
            ref[2, 3, 2]=(0.185298080161-0.265643955371j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3, 4)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnBoundary_fromData_ReducedContinuousFunction_rank3(self):
        """
        tests gradient of rank 3 Data on ReducedFunctionOnBoundary

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(2, 2, 2),w)
        ref = Data(0,(2, 2, 2)+(dim,),w_ref)
        arg[0, 0, 0]=(0.248384195202-0.358127191016j)*x[0]+((0.919258345101+0.26164347035j))*x[1]
        ref[0, 0, 0, 0]=(0.248384195202-0.358127191016j)
        ref[0, 0, 0, 1]=(0.919258345101+0.26164347035j)
        arg[0, 0, 1]=(-0.793676017424+0.0351559789424j)*x[0]+((-0.231817362437-0.785549007468j))*x[1]
        ref[0, 0, 1, 0]=(-0.793676017424+0.0351559789424j)
        ref[0, 0, 1, 1]=(-0.231817362437-0.785549007468j)
        arg[0, 1, 0]=(-0.0737826652792+0.851309604072j)*x[0]+((-0.0906749196398-0.00707135847665j))*x[1]
        ref[0, 1, 0, 0]=(-0.0737826652792+0.851309604072j)
        ref[0, 1, 0, 1]=(-0.0906749196398-0.00707135847665j)
        arg[0, 1, 1]=(0.78245337134-0.444106274686j)*x[0]+((0.945052234817-0.837532609369j))*x[1]
        ref[0, 1, 1, 0]=(0.78245337134-0.444106274686j)
        ref[0, 1, 1, 1]=(0.945052234817-0.837532609369j)
        arg[1, 0, 0]=(0.625040367237-0.367418245589j)*x[0]+((0.406469971842+0.578761075422j))*x[1]
        ref[1, 0, 0, 0]=(0.625040367237-0.367418245589j)
        ref[1, 0, 0, 1]=(0.406469971842+0.578761075422j)
        arg[1, 0, 1]=(0.53580252501-0.460981645495j)*x[0]+((-0.850220252886-0.612536274466j))*x[1]
        ref[1, 0, 1, 0]=(0.53580252501-0.460981645495j)
        ref[1, 0, 1, 1]=(-0.850220252886-0.612536274466j)
        arg[1, 1, 0]=(0.924310218328-0.274633438178j)*x[0]+((-0.338995980678+0.284309518448j))*x[1]
        ref[1, 1, 0, 0]=(0.924310218328-0.274633438178j)
        ref[1, 1, 0, 1]=(-0.338995980678+0.284309518448j)
        arg[1, 1, 1]=(-0.334969712588+0.354283921779j)*x[0]+((-0.564735417245-0.964915448245j))*x[1]
        ref[1, 1, 1, 0]=(-0.334969712588+0.354283921779j)
        ref[1, 1, 1, 1]=(-0.564735417245-0.964915448245j)
        if dim==3:
            arg[0, 0, 0]+=(0.635703830569-0.445699633609j)*x[2]
            ref[0, 0, 0, 2]=(0.635703830569-0.445699633609j)
            arg[0, 0, 1]+=(0.695629941179-0.286496096054j)*x[2]
            ref[0, 0, 1, 2]=(0.695629941179-0.286496096054j)
            arg[0, 1, 0]+=(-0.608399098328-0.457837555966j)*x[2]
            ref[0, 1, 0, 2]=(-0.608399098328-0.457837555966j)
            arg[0, 1, 1]+=(-0.316502862561-0.803781398294j)*x[2]
            ref[0, 1, 1, 2]=(-0.316502862561-0.803781398294j)
            arg[1, 0, 0]+=(0.0344787831141+0.910929644711j)*x[2]
            ref[1, 0, 0, 2]=(0.0344787831141+0.910929644711j)
            arg[1, 0, 1]+=(0.493062211467+0.211354229234j)*x[2]
            ref[1, 0, 1, 2]=(0.493062211467+0.211354229234j)
            arg[1, 1, 0]+=(-0.655701515158+0.865947758184j)*x[2]
            ref[1, 1, 0, 2]=(-0.655701515158+0.865947758184j)
            arg[1, 1, 1]+=(-0.665146490301+0.153258270639j)*x[2]
            ref[1, 1, 1, 2]=(-0.665146490301+0.153258270639j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2, 2, 2)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnContactZero_fromData_ContinuousFunction_rank0(self):
        """
        tests gradient of rank 0 Data on FunctionOnContactZero

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on FunctionOnContactZero
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnContactZero(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=(0.0487891867951-0.0352000781064j)*x[0]**o+((0.573667257227+0.78575343786j))*x[0]+((0.36322351576+0.955286718299j))*x[1]**o+((-0.37961368593+0.789376497645j))*x[1]
        ref[0]=(0.0487891867951-0.0352000781064j)*o*x_ref[0]**(o-1)+((0.573667257227+0.78575343786j))
        ref[1]=(0.36322351576+0.955286718299j)*o*x_ref[1]**(o-1)+((-0.37961368593+0.789376497645j))
        if dim==3:
            arg+=((-0.899701626701-0.360045233241j))*x[2]**o+((-0.515739908416-0.653336903379j))*x[2]
            ref[2]=(-0.899701626701-0.360045233241j)*o*x_ref[2]**(o-1)+((-0.515739908416-0.653336903379j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnContactZero_fromData_ContinuousFunction_rank1(self):
        """
        tests gradient of rank 1 Data on FunctionOnContactZero

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on FunctionOnContactZero
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnContactZero(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(3,),w)
        ref = Data(0,(3,)+(dim,),w_ref)
        arg[0,]=(-0.840682910665+0.405991069347j)*x[0]**o+((0.387220760459-0.349338555499j))*x[0]+((-0.798307126197+0.34500367147j))*x[1]**o+((0.883281378828-0.538475772601j))*x[1]
        ref[0, 0]=(-0.840682910665+0.405991069347j)*o*x_ref[0]**(o-1)+((0.387220760459-0.349338555499j))
        ref[0, 1]=(-0.798307126197+0.34500367147j)*o*x_ref[1]**(o-1)+((0.883281378828-0.538475772601j))
        arg[1,]=(-0.384854918745+0.0965796091868j)*x[0]**o+((-0.134920065574-0.0639367307563j))*x[0]+((-0.848337984459-0.234292670853j))*x[1]**o+((0.940044017244-0.0359622112741j))*x[1]
        ref[1, 0]=(-0.384854918745+0.0965796091868j)*o*x_ref[0]**(o-1)+((-0.134920065574-0.0639367307563j))
        ref[1, 1]=(-0.848337984459-0.234292670853j)*o*x_ref[1]**(o-1)+((0.940044017244-0.0359622112741j))
        arg[2,]=(-0.955856495254+0.167145322333j)*x[0]**o+((0.700891838539-0.0323631591738j))*x[0]+((-0.0783539862891-0.259666755962j))*x[1]**o+((-0.0769301542047-0.603439263644j))*x[1]
        ref[2, 0]=(-0.955856495254+0.167145322333j)*o*x_ref[0]**(o-1)+((0.700891838539-0.0323631591738j))
        ref[2, 1]=(-0.0783539862891-0.259666755962j)*o*x_ref[1]**(o-1)+((-0.0769301542047-0.603439263644j))
        if dim==3:
            arg[0,]+=(0.717053331404-0.333966380786j)*x[2]**o+((-0.768579902275+0.350405437811j))*x[2]
            ref[0, 2]=(0.717053331404-0.333966380786j)*o*x_ref[2]**(o-1)+((-0.768579902275+0.350405437811j))
            arg[1,]+=(-0.205699591462+0.235772694265j)*x[2]**o+((0.965811233662+0.0629181173263j))*x[2]
            ref[1, 2]=(-0.205699591462+0.235772694265j)*o*x_ref[2]**(o-1)+((0.965811233662+0.0629181173263j))
            arg[2,]+=(-0.576068179764-0.553034246083j)*x[2]**o+((-0.730669961182-0.455489557576j))*x[2]
            ref[2, 2]=(-0.576068179764-0.553034246083j)*o*x_ref[2]**(o-1)+((-0.730669961182-0.455489557576j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnContactZero_fromData_ContinuousFunction_rank2(self):
        """
        tests gradient of rank 2 Data on FunctionOnContactZero

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on FunctionOnContactZero
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnContactZero(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(2, 3),w)
        ref = Data(0,(2, 3)+(dim,),w_ref)
        arg[0, 0]=(-0.694855573838+0.875314896735j)*x[0]**o+((0.0787055338539+0.993512664542j))*x[0]+((-0.426789133098+0.584610274293j))*x[1]**o+((0.275167279128-0.480917275166j))*x[1]
        ref[0, 0, 0]=(-0.694855573838+0.875314896735j)*o*x_ref[0]**(o-1)+((0.0787055338539+0.993512664542j))
        ref[0, 0, 1]=(-0.426789133098+0.584610274293j)*o*x_ref[1]**(o-1)+((0.275167279128-0.480917275166j))
        arg[0, 1]=(-0.709079420004-0.625323503921j)*x[0]**o+((0.317738638049+0.214642449702j))*x[0]+((0.362916595976-0.607314176076j))*x[1]**o+((0.129714529828+0.176586108946j))*x[1]
        ref[0, 1, 0]=(-0.709079420004-0.625323503921j)*o*x_ref[0]**(o-1)+((0.317738638049+0.214642449702j))
        ref[0, 1, 1]=(0.362916595976-0.607314176076j)*o*x_ref[1]**(o-1)+((0.129714529828+0.176586108946j))
        arg[0, 2]=(-0.0977726470834-0.604522234951j)*x[0]**o+((-0.230421162368+0.15324778677j))*x[0]+((0.311946662835-0.782470995165j))*x[1]**o+((-0.486017870692-0.201863210483j))*x[1]
        ref[0, 2, 0]=(-0.0977726470834-0.604522234951j)*o*x_ref[0]**(o-1)+((-0.230421162368+0.15324778677j))
        ref[0, 2, 1]=(0.311946662835-0.782470995165j)*o*x_ref[1]**(o-1)+((-0.486017870692-0.201863210483j))
        arg[1, 0]=(0.422073187806+0.0668089358052j)*x[0]**o+((-0.44566468205+0.559804006361j))*x[0]+((0.701374482392+0.470460306852j))*x[1]**o+((0.547796408816+0.904578960094j))*x[1]
        ref[1, 0, 0]=(0.422073187806+0.0668089358052j)*o*x_ref[0]**(o-1)+((-0.44566468205+0.559804006361j))
        ref[1, 0, 1]=(0.701374482392+0.470460306852j)*o*x_ref[1]**(o-1)+((0.547796408816+0.904578960094j))
        arg[1, 1]=(0.821433331851-0.541539681869j)*x[0]**o+((0.0826061357499+0.853069872294j))*x[0]+((0.849999640188+0.550879274859j))*x[1]**o+((0.81815161742-0.591479037747j))*x[1]
        ref[1, 1, 0]=(0.821433331851-0.541539681869j)*o*x_ref[0]**(o-1)+((0.0826061357499+0.853069872294j))
        ref[1, 1, 1]=(0.849999640188+0.550879274859j)*o*x_ref[1]**(o-1)+((0.81815161742-0.591479037747j))
        arg[1, 2]=(-0.92201677932-0.073596004636j)*x[0]**o+((-0.911446656557+0.173764546384j))*x[0]+((0.441945870187-0.489375650466j))*x[1]**o+((0.0985931037914-0.255181446845j))*x[1]
        ref[1, 2, 0]=(-0.92201677932-0.073596004636j)*o*x_ref[0]**(o-1)+((-0.911446656557+0.173764546384j))
        ref[1, 2, 1]=(0.441945870187-0.489375650466j)*o*x_ref[1]**(o-1)+((0.0985931037914-0.255181446845j))
        if dim==3:
            arg[0, 0]+=(-0.185343115182-0.46221413796j)*x[2]**o+((0.0983798583096+0.842451303963j))*x[2]
            ref[0, 0, 2]=(-0.185343115182-0.46221413796j)*o*x_ref[2]**(o-1)+((0.0983798583096+0.842451303963j))
            arg[0, 1]+=(-0.972428162428+0.447611482174j)*x[2]**o+((0.255725705306-0.498547050433j))*x[2]
            ref[0, 1, 2]=(-0.972428162428+0.447611482174j)*o*x_ref[2]**(o-1)+((0.255725705306-0.498547050433j))
            arg[0, 2]+=(-0.92446056036-0.726700807242j)*x[2]**o+((0.450470831717-0.098808914465j))*x[2]
            ref[0, 2, 2]=(-0.92446056036-0.726700807242j)*o*x_ref[2]**(o-1)+((0.450470831717-0.098808914465j))
            arg[1, 0]+=(0.931997208406+0.0300825306349j)*x[2]**o+((-0.40250575593-0.406803826642j))*x[2]
            ref[1, 0, 2]=(0.931997208406+0.0300825306349j)*o*x_ref[2]**(o-1)+((-0.40250575593-0.406803826642j))
            arg[1, 1]+=(0.286837508839+0.449483920594j)*x[2]**o+((0.500201964367+0.902576545839j))*x[2]
            ref[1, 1, 2]=(0.286837508839+0.449483920594j)*o*x_ref[2]**(o-1)+((0.500201964367+0.902576545839j))
            arg[1, 2]+=(-0.452134542171-0.517246041427j)*x[2]**o+((-0.292455566783-0.240814193067j))*x[2]
            ref[1, 2, 2]=(-0.452134542171-0.517246041427j)*o*x_ref[2]**(o-1)+((-0.292455566783-0.240814193067j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2, 3)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnContactZero_fromData_ContinuousFunction_rank3(self):
        """
        tests gradient of rank 3 Data on FunctionOnContactZero

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on FunctionOnContactZero
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnContactZero(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(3, 3, 2),w)
        ref = Data(0,(3, 3, 2)+(dim,),w_ref)
        arg[0, 0, 0]=(0.838425189343-0.378017917487j)*x[0]**o+((0.989976885971-0.0442352687838j))*x[0]+((0.426791996893+0.392256379111j))*x[1]**o+((0.124603477318-0.430308447053j))*x[1]
        ref[0, 0, 0, 0]=(0.838425189343-0.378017917487j)*o*x_ref[0]**(o-1)+((0.989976885971-0.0442352687838j))
        ref[0, 0, 0, 1]=(0.426791996893+0.392256379111j)*o*x_ref[1]**(o-1)+((0.124603477318-0.430308447053j))
        arg[0, 0, 1]=(-0.0764903928517-0.73475174197j)*x[0]**o+((-0.766663725697+0.192648199481j))*x[0]+((-0.254909959766+0.158778536586j))*x[1]**o+((0.0295165340753-0.489753006223j))*x[1]
        ref[0, 0, 1, 0]=(-0.0764903928517-0.73475174197j)*o*x_ref[0]**(o-1)+((-0.766663725697+0.192648199481j))
        ref[0, 0, 1, 1]=(-0.254909959766+0.158778536586j)*o*x_ref[1]**(o-1)+((0.0295165340753-0.489753006223j))
        arg[0, 1, 0]=(0.475670783307+0.166827776133j)*x[0]**o+((-0.540473695936-0.497401746662j))*x[0]+((-0.961235613225-0.159389083473j))*x[1]**o+((0.487659350999-0.548812621685j))*x[1]
        ref[0, 1, 0, 0]=(0.475670783307+0.166827776133j)*o*x_ref[0]**(o-1)+((-0.540473695936-0.497401746662j))
        ref[0, 1, 0, 1]=(-0.961235613225-0.159389083473j)*o*x_ref[1]**(o-1)+((0.487659350999-0.548812621685j))
        arg[0, 1, 1]=(-0.157608615921+0.415281531783j)*x[0]**o+((-0.23799727162-0.0229940700833j))*x[0]+((-0.0312379704116-0.531041390018j))*x[1]**o+((-0.34676191445+0.124410872947j))*x[1]
        ref[0, 1, 1, 0]=(-0.157608615921+0.415281531783j)*o*x_ref[0]**(o-1)+((-0.23799727162-0.0229940700833j))
        ref[0, 1, 1, 1]=(-0.0312379704116-0.531041390018j)*o*x_ref[1]**(o-1)+((-0.34676191445+0.124410872947j))
        arg[0, 2, 0]=(-0.838858350232-0.634601245455j)*x[0]**o+((0.924125802808-0.618360088357j))*x[0]+((0.39344124848+0.983330181769j))*x[1]**o+((0.650704479859+0.857845316347j))*x[1]
        ref[0, 2, 0, 0]=(-0.838858350232-0.634601245455j)*o*x_ref[0]**(o-1)+((0.924125802808-0.618360088357j))
        ref[0, 2, 0, 1]=(0.39344124848+0.983330181769j)*o*x_ref[1]**(o-1)+((0.650704479859+0.857845316347j))
        arg[0, 2, 1]=(0.0873166675676-0.381197718083j)*x[0]**o+((-0.585802281362-0.164857144241j))*x[0]+((-0.220175132218+0.726690413159j))*x[1]**o+((-0.656046667375+0.494368306731j))*x[1]
        ref[0, 2, 1, 0]=(0.0873166675676-0.381197718083j)*o*x_ref[0]**(o-1)+((-0.585802281362-0.164857144241j))
        ref[0, 2, 1, 1]=(-0.220175132218+0.726690413159j)*o*x_ref[1]**(o-1)+((-0.656046667375+0.494368306731j))
        arg[1, 0, 0]=(-0.294446649631+0.593988168791j)*x[0]**o+((-0.220687374797+0.592813736748j))*x[0]+((-0.668408665058+0.498085370141j))*x[1]**o+((-0.0195109605137-0.264409790904j))*x[1]
        ref[1, 0, 0, 0]=(-0.294446649631+0.593988168791j)*o*x_ref[0]**(o-1)+((-0.220687374797+0.592813736748j))
        ref[1, 0, 0, 1]=(-0.668408665058+0.498085370141j)*o*x_ref[1]**(o-1)+((-0.0195109605137-0.264409790904j))
        arg[1, 0, 1]=(-0.788837464094-0.155643071755j)*x[0]**o+((0.941234532593-0.41298711429j))*x[0]+((0.344716767917-0.751657643484j))*x[1]**o+((0.090957648793+0.83664626649j))*x[1]
        ref[1, 0, 1, 0]=(-0.788837464094-0.155643071755j)*o*x_ref[0]**(o-1)+((0.941234532593-0.41298711429j))
        ref[1, 0, 1, 1]=(0.344716767917-0.751657643484j)*o*x_ref[1]**(o-1)+((0.090957648793+0.83664626649j))
        arg[1, 1, 0]=(-0.189349509098-0.0105006219791j)*x[0]**o+((0.445919936002+0.804559529219j))*x[0]+((-0.738940314823-0.952466428103j))*x[1]**o+((-0.774509627005+0.779910805204j))*x[1]
        ref[1, 1, 0, 0]=(-0.189349509098-0.0105006219791j)*o*x_ref[0]**(o-1)+((0.445919936002+0.804559529219j))
        ref[1, 1, 0, 1]=(-0.738940314823-0.952466428103j)*o*x_ref[1]**(o-1)+((-0.774509627005+0.779910805204j))
        arg[1, 1, 1]=(-0.970288554019-0.947558575666j)*x[0]**o+((0.131203645032-0.105988370676j))*x[0]+((-0.198543583036+0.682639501425j))*x[1]**o+((-0.689321544399+0.959313367484j))*x[1]
        ref[1, 1, 1, 0]=(-0.970288554019-0.947558575666j)*o*x_ref[0]**(o-1)+((0.131203645032-0.105988370676j))
        ref[1, 1, 1, 1]=(-0.198543583036+0.682639501425j)*o*x_ref[1]**(o-1)+((-0.689321544399+0.959313367484j))
        arg[1, 2, 0]=(-0.178304784379-0.89320935119j)*x[0]**o+((0.970378948476-0.814984432867j))*x[0]+((0.0888539996745-0.275277935736j))*x[1]**o+((-0.0172411610696-0.877711693873j))*x[1]
        ref[1, 2, 0, 0]=(-0.178304784379-0.89320935119j)*o*x_ref[0]**(o-1)+((0.970378948476-0.814984432867j))
        ref[1, 2, 0, 1]=(0.0888539996745-0.275277935736j)*o*x_ref[1]**(o-1)+((-0.0172411610696-0.877711693873j))
        arg[1, 2, 1]=(-0.819196405446-0.349517051962j)*x[0]**o+((-0.885950085356-0.201843625824j))*x[0]+((0.448220715818+0.100343473873j))*x[1]**o+((0.248466266656+0.0429243899428j))*x[1]
        ref[1, 2, 1, 0]=(-0.819196405446-0.349517051962j)*o*x_ref[0]**(o-1)+((-0.885950085356-0.201843625824j))
        ref[1, 2, 1, 1]=(0.448220715818+0.100343473873j)*o*x_ref[1]**(o-1)+((0.248466266656+0.0429243899428j))
        arg[2, 0, 0]=(-0.434152893383+0.599041204065j)*x[0]**o+((-0.416124200773-0.462016017606j))*x[0]+((0.551086633399-0.508729468214j))*x[1]**o+((0.896310851384-0.212971516826j))*x[1]
        ref[2, 0, 0, 0]=(-0.434152893383+0.599041204065j)*o*x_ref[0]**(o-1)+((-0.416124200773-0.462016017606j))
        ref[2, 0, 0, 1]=(0.551086633399-0.508729468214j)*o*x_ref[1]**(o-1)+((0.896310851384-0.212971516826j))
        arg[2, 0, 1]=(-0.821377973756-0.170985733599j)*x[0]**o+((-0.106192794798+0.620325161326j))*x[0]+((0.000641717078262-0.285041938635j))*x[1]**o+((0.633981477371+0.335328591255j))*x[1]
        ref[2, 0, 1, 0]=(-0.821377973756-0.170985733599j)*o*x_ref[0]**(o-1)+((-0.106192794798+0.620325161326j))
        ref[2, 0, 1, 1]=(0.000641717078262-0.285041938635j)*o*x_ref[1]**(o-1)+((0.633981477371+0.335328591255j))
        arg[2, 1, 0]=(0.383111244715+0.0066341978789j)*x[0]**o+((0.444592471768-0.560135251847j))*x[0]+((0.595661044164-0.68537461525j))*x[1]**o+((-0.0681351287079+0.134199306265j))*x[1]
        ref[2, 1, 0, 0]=(0.383111244715+0.0066341978789j)*o*x_ref[0]**(o-1)+((0.444592471768-0.560135251847j))
        ref[2, 1, 0, 1]=(0.595661044164-0.68537461525j)*o*x_ref[1]**(o-1)+((-0.0681351287079+0.134199306265j))
        arg[2, 1, 1]=(0.291396424228-0.961975662662j)*x[0]**o+((0.255156011061+0.720751041681j))*x[0]+((0.417592809515-0.903301852766j))*x[1]**o+((-0.396045491163-0.435008009376j))*x[1]
        ref[2, 1, 1, 0]=(0.291396424228-0.961975662662j)*o*x_ref[0]**(o-1)+((0.255156011061+0.720751041681j))
        ref[2, 1, 1, 1]=(0.417592809515-0.903301852766j)*o*x_ref[1]**(o-1)+((-0.396045491163-0.435008009376j))
        arg[2, 2, 0]=(-0.964145245118-0.875142737017j)*x[0]**o+((0.793872908348+0.106335707703j))*x[0]+((-0.0272847022517-0.128780990968j))*x[1]**o+((0.531665149466+0.479089352573j))*x[1]
        ref[2, 2, 0, 0]=(-0.964145245118-0.875142737017j)*o*x_ref[0]**(o-1)+((0.793872908348+0.106335707703j))
        ref[2, 2, 0, 1]=(-0.0272847022517-0.128780990968j)*o*x_ref[1]**(o-1)+((0.531665149466+0.479089352573j))
        arg[2, 2, 1]=(-0.611839941186-0.515189702231j)*x[0]**o+((0.671523400253+0.325126978597j))*x[0]+((0.223509829836-0.0216706271836j))*x[1]**o+((-0.755661310824+0.945122070807j))*x[1]
        ref[2, 2, 1, 0]=(-0.611839941186-0.515189702231j)*o*x_ref[0]**(o-1)+((0.671523400253+0.325126978597j))
        ref[2, 2, 1, 1]=(0.223509829836-0.0216706271836j)*o*x_ref[1]**(o-1)+((-0.755661310824+0.945122070807j))
        if dim==3:
            arg[0, 0, 0]+=(0.287988685944-0.817645515036j)*x[2]**o+((-0.965670393949-0.0861526502309j))*x[2]
            ref[0, 0, 0, 2]=(0.287988685944-0.817645515036j)*o*x_ref[2]**(o-1)+((-0.965670393949-0.0861526502309j))
            arg[0, 0, 1]+=(-0.770536929404-0.515939304189j)*x[2]**o+((-0.434196284917-0.787219548694j))*x[2]
            ref[0, 0, 1, 2]=(-0.770536929404-0.515939304189j)*o*x_ref[2]**(o-1)+((-0.434196284917-0.787219548694j))
            arg[0, 1, 0]+=(-0.563489181733-0.194856963537j)*x[2]**o+((0.662859194964+0.264122962633j))*x[2]
            ref[0, 1, 0, 2]=(-0.563489181733-0.194856963537j)*o*x_ref[2]**(o-1)+((0.662859194964+0.264122962633j))
            arg[0, 1, 1]+=(0.000422853131611-0.666018317053j)*x[2]**o+((0.793093505155+0.578570462689j))*x[2]
            ref[0, 1, 1, 2]=(0.000422853131611-0.666018317053j)*o*x_ref[2]**(o-1)+((0.793093505155+0.578570462689j))
            arg[0, 2, 0]+=(-0.483554404977-0.964655915708j)*x[2]**o+((0.755652284235+0.385639000645j))*x[2]
            ref[0, 2, 0, 2]=(-0.483554404977-0.964655915708j)*o*x_ref[2]**(o-1)+((0.755652284235+0.385639000645j))
            arg[0, 2, 1]+=(-0.984683384266+0.181414168519j)*x[2]**o+((0.621966072423+0.191794773526j))*x[2]
            ref[0, 2, 1, 2]=(-0.984683384266+0.181414168519j)*o*x_ref[2]**(o-1)+((0.621966072423+0.191794773526j))
            arg[1, 0, 0]+=(-0.701609402146-0.549125724089j)*x[2]**o+((0.707104630106-0.160855345916j))*x[2]
            ref[1, 0, 0, 2]=(-0.701609402146-0.549125724089j)*o*x_ref[2]**(o-1)+((0.707104630106-0.160855345916j))
            arg[1, 0, 1]+=(-0.496211025774-0.840050120013j)*x[2]**o+((0.889622929643-0.228871242854j))*x[2]
            ref[1, 0, 1, 2]=(-0.496211025774-0.840050120013j)*o*x_ref[2]**(o-1)+((0.889622929643-0.228871242854j))
            arg[1, 1, 0]+=(0.959412623109+0.906121652205j)*x[2]**o+((-0.921183888462-0.804660863247j))*x[2]
            ref[1, 1, 0, 2]=(0.959412623109+0.906121652205j)*o*x_ref[2]**(o-1)+((-0.921183888462-0.804660863247j))
            arg[1, 1, 1]+=(0.189826806185-0.599811878107j)*x[2]**o+((-0.977544504884+0.477203360773j))*x[2]
            ref[1, 1, 1, 2]=(0.189826806185-0.599811878107j)*o*x_ref[2]**(o-1)+((-0.977544504884+0.477203360773j))
            arg[1, 2, 0]+=(0.680475645765-0.171979924777j)*x[2]**o+((-0.445455972294-0.574368112376j))*x[2]
            ref[1, 2, 0, 2]=(0.680475645765-0.171979924777j)*o*x_ref[2]**(o-1)+((-0.445455972294-0.574368112376j))
            arg[1, 2, 1]+=(-0.071948775719+0.558043369134j)*x[2]**o+((-0.866769682107+0.500657878152j))*x[2]
            ref[1, 2, 1, 2]=(-0.071948775719+0.558043369134j)*o*x_ref[2]**(o-1)+((-0.866769682107+0.500657878152j))
            arg[2, 0, 0]+=(0.0827382468907+0.971204711699j)*x[2]**o+((-0.848429246807-0.537508462607j))*x[2]
            ref[2, 0, 0, 2]=(0.0827382468907+0.971204711699j)*o*x_ref[2]**(o-1)+((-0.848429246807-0.537508462607j))
            arg[2, 0, 1]+=(-0.40035340487+0.263111160445j)*x[2]**o+((0.469048555107-0.582559989787j))*x[2]
            ref[2, 0, 1, 2]=(-0.40035340487+0.263111160445j)*o*x_ref[2]**(o-1)+((0.469048555107-0.582559989787j))
            arg[2, 1, 0]+=(-0.153539882149+0.865252672199j)*x[2]**o+((-0.260875955853-0.998869264604j))*x[2]
            ref[2, 1, 0, 2]=(-0.153539882149+0.865252672199j)*o*x_ref[2]**(o-1)+((-0.260875955853-0.998869264604j))
            arg[2, 1, 1]+=(-0.0972659239365-0.492727822661j)*x[2]**o+((0.0994421320829-0.651299832169j))*x[2]
            ref[2, 1, 1, 2]=(-0.0972659239365-0.492727822661j)*o*x_ref[2]**(o-1)+((0.0994421320829-0.651299832169j))
            arg[2, 2, 0]+=(0.400402461349-0.200552627028j)*x[2]**o+((-0.141312098009+0.80038784878j))*x[2]
            ref[2, 2, 0, 2]=(0.400402461349-0.200552627028j)*o*x_ref[2]**(o-1)+((-0.141312098009+0.80038784878j))
            arg[2, 2, 1]+=(0.255233371084+0.313486910131j)*x[2]**o+((0.576459447176+0.496656576083j))*x[2]
            ref[2, 2, 1, 2]=(0.255233371084+0.313486910131j)*o*x_ref[2]**(o-1)+((0.576459447176+0.496656576083j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3, 3, 2)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnContactZero_fromData_Solution_rank0(self):
        """
        tests gradient of rank 0 Data on FunctionOnContactZero

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on FunctionOnContactZero
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnContactZero(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=(0.616412811444-0.091195015284j)*x[0]**o+((0.433478781351+0.341960961428j))*x[0]+((0.104942851948+0.183580804099j))*x[1]**o+((0.0505626422691-0.0838012008693j))*x[1]
        ref[0]=(0.616412811444-0.091195015284j)*o*x_ref[0]**(o-1)+((0.433478781351+0.341960961428j))
        ref[1]=(0.104942851948+0.183580804099j)*o*x_ref[1]**(o-1)+((0.0505626422691-0.0838012008693j))
        if dim==3:
            arg+=((0.941542557455-0.214468474019j))*x[2]**o+((0.963786947968-0.0577472603129j))*x[2]
            ref[2]=(0.941542557455-0.214468474019j)*o*x_ref[2]**(o-1)+((0.963786947968-0.0577472603129j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnContactZero_fromData_Solution_rank1(self):
        """
        tests gradient of rank 1 Data on FunctionOnContactZero

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on FunctionOnContactZero
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnContactZero(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(3,),w)
        ref = Data(0,(3,)+(dim,),w_ref)
        arg[0,]=(0.0633638591159+0.42309396414j)*x[0]**o+((-0.708344870752-0.508207557447j))*x[0]+((0.966530285926+0.598182692923j))*x[1]**o+((-0.365723700457+0.0722484579452j))*x[1]
        ref[0, 0]=(0.0633638591159+0.42309396414j)*o*x_ref[0]**(o-1)+((-0.708344870752-0.508207557447j))
        ref[0, 1]=(0.966530285926+0.598182692923j)*o*x_ref[1]**(o-1)+((-0.365723700457+0.0722484579452j))
        arg[1,]=(0.852391997678-0.770092197816j)*x[0]**o+((0.140581791415-0.651396285885j))*x[0]+((-0.596865942372-0.921763735988j))*x[1]**o+((-0.500761490236-0.506898626654j))*x[1]
        ref[1, 0]=(0.852391997678-0.770092197816j)*o*x_ref[0]**(o-1)+((0.140581791415-0.651396285885j))
        ref[1, 1]=(-0.596865942372-0.921763735988j)*o*x_ref[1]**(o-1)+((-0.500761490236-0.506898626654j))
        arg[2,]=(-0.360774124839-0.501121172881j)*x[0]**o+((0.297467838614+0.642408681777j))*x[0]+((-0.736205499922+0.0172349128125j))*x[1]**o+((-0.113840751702+0.492195008468j))*x[1]
        ref[2, 0]=(-0.360774124839-0.501121172881j)*o*x_ref[0]**(o-1)+((0.297467838614+0.642408681777j))
        ref[2, 1]=(-0.736205499922+0.0172349128125j)*o*x_ref[1]**(o-1)+((-0.113840751702+0.492195008468j))
        if dim==3:
            arg[0,]+=(-0.358584332133+0.833344206053j)*x[2]**o+((0.208947443023-0.174422250142j))*x[2]
            ref[0, 2]=(-0.358584332133+0.833344206053j)*o*x_ref[2]**(o-1)+((0.208947443023-0.174422250142j))
            arg[1,]+=(0.240427736689+0.845419098264j)*x[2]**o+((-0.533174429226-0.0726771036321j))*x[2]
            ref[1, 2]=(0.240427736689+0.845419098264j)*o*x_ref[2]**(o-1)+((-0.533174429226-0.0726771036321j))
            arg[2,]+=(0.531770998973+0.99024081463j)*x[2]**o+((0.985462299062+0.309464847991j))*x[2]
            ref[2, 2]=(0.531770998973+0.99024081463j)*o*x_ref[2]**(o-1)+((0.985462299062+0.309464847991j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnContactZero_fromData_Solution_rank2(self):
        """
        tests gradient of rank 2 Data on FunctionOnContactZero

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on FunctionOnContactZero
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnContactZero(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(3, 2),w)
        ref = Data(0,(3, 2)+(dim,),w_ref)
        arg[0, 0]=(-0.0253684198806-0.347823864287j)*x[0]**o+((0.0122710000412-0.655380075016j))*x[0]+((0.637868202725-0.062324875184j))*x[1]**o+((0.426312779891-0.984400068874j))*x[1]
        ref[0, 0, 0]=(-0.0253684198806-0.347823864287j)*o*x_ref[0]**(o-1)+((0.0122710000412-0.655380075016j))
        ref[0, 0, 1]=(0.637868202725-0.062324875184j)*o*x_ref[1]**(o-1)+((0.426312779891-0.984400068874j))
        arg[0, 1]=(0.730021550005+0.708731389262j)*x[0]**o+((-0.754339811758+0.902770344227j))*x[0]+((0.48181089457-0.711472599504j))*x[1]**o+((-0.45895315933+0.738515064132j))*x[1]
        ref[0, 1, 0]=(0.730021550005+0.708731389262j)*o*x_ref[0]**(o-1)+((-0.754339811758+0.902770344227j))
        ref[0, 1, 1]=(0.48181089457-0.711472599504j)*o*x_ref[1]**(o-1)+((-0.45895315933+0.738515064132j))
        arg[1, 0]=(-0.439052275674+0.887445039099j)*x[0]**o+((0.490355320054+0.147019733463j))*x[0]+((-0.0544462253941-0.402711932469j))*x[1]**o+((0.279665247245-0.52393570559j))*x[1]
        ref[1, 0, 0]=(-0.439052275674+0.887445039099j)*o*x_ref[0]**(o-1)+((0.490355320054+0.147019733463j))
        ref[1, 0, 1]=(-0.0544462253941-0.402711932469j)*o*x_ref[1]**(o-1)+((0.279665247245-0.52393570559j))
        arg[1, 1]=(0.374994059279+0.770360981241j)*x[0]**o+((0.419159735125+0.819848526952j))*x[0]+((0.0983548697632-0.703969277986j))*x[1]**o+((-0.341614671672-0.502202146799j))*x[1]
        ref[1, 1, 0]=(0.374994059279+0.770360981241j)*o*x_ref[0]**(o-1)+((0.419159735125+0.819848526952j))
        ref[1, 1, 1]=(0.0983548697632-0.703969277986j)*o*x_ref[1]**(o-1)+((-0.341614671672-0.502202146799j))
        arg[2, 0]=(-0.811184894011-0.846399714821j)*x[0]**o+((-0.167542705836-0.387744468718j))*x[0]+((0.832430676789-0.0848158204701j))*x[1]**o+((0.540378905943-0.218018482881j))*x[1]
        ref[2, 0, 0]=(-0.811184894011-0.846399714821j)*o*x_ref[0]**(o-1)+((-0.167542705836-0.387744468718j))
        ref[2, 0, 1]=(0.832430676789-0.0848158204701j)*o*x_ref[1]**(o-1)+((0.540378905943-0.218018482881j))
        arg[2, 1]=(-0.20271803314+0.726693808112j)*x[0]**o+((0.161698725122+0.799830259226j))*x[0]+((-0.765052818146+0.0708839398851j))*x[1]**o+((-0.490680837198-0.30256024753j))*x[1]
        ref[2, 1, 0]=(-0.20271803314+0.726693808112j)*o*x_ref[0]**(o-1)+((0.161698725122+0.799830259226j))
        ref[2, 1, 1]=(-0.765052818146+0.0708839398851j)*o*x_ref[1]**(o-1)+((-0.490680837198-0.30256024753j))
        if dim==3:
            arg[0, 0]+=(0.0703936607491+0.839574944663j)*x[2]**o+((-0.610394066597-0.696211556006j))*x[2]
            ref[0, 0, 2]=(0.0703936607491+0.839574944663j)*o*x_ref[2]**(o-1)+((-0.610394066597-0.696211556006j))
            arg[0, 1]+=(-0.531408947122-0.249456482307j)*x[2]**o+((-0.9921515019-0.465459308201j))*x[2]
            ref[0, 1, 2]=(-0.531408947122-0.249456482307j)*o*x_ref[2]**(o-1)+((-0.9921515019-0.465459308201j))
            arg[1, 0]+=(-0.396590558906+0.586325226412j)*x[2]**o+((0.320135489111-0.984890826299j))*x[2]
            ref[1, 0, 2]=(-0.396590558906+0.586325226412j)*o*x_ref[2]**(o-1)+((0.320135489111-0.984890826299j))
            arg[1, 1]+=(0.597750023672+0.560596132779j)*x[2]**o+((-0.926962356792+0.54006476661j))*x[2]
            ref[1, 1, 2]=(0.597750023672+0.560596132779j)*o*x_ref[2]**(o-1)+((-0.926962356792+0.54006476661j))
            arg[2, 0]+=(0.593336387467+0.413083528675j)*x[2]**o+((-0.711436430181-0.334559908619j))*x[2]
            ref[2, 0, 2]=(0.593336387467+0.413083528675j)*o*x_ref[2]**(o-1)+((-0.711436430181-0.334559908619j))
            arg[2, 1]+=(-0.173638004667+0.409708236569j)*x[2]**o+((0.550694308044-0.615754135691j))*x[2]
            ref[2, 1, 2]=(-0.173638004667+0.409708236569j)*o*x_ref[2]**(o-1)+((0.550694308044-0.615754135691j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3, 2)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnContactZero_fromData_Solution_rank3(self):
        """
        tests gradient of rank 3 Data on FunctionOnContactZero

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on FunctionOnContactZero
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnContactZero(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(4, 3, 2),w)
        ref = Data(0,(4, 3, 2)+(dim,),w_ref)
        arg[0, 0, 0]=(-0.960039341476+0.46269827758j)*x[0]**o+((0.78822933019-0.684328065878j))*x[0]+((0.767820764439+0.734999891143j))*x[1]**o+((-0.103455553038+0.379859647321j))*x[1]
        ref[0, 0, 0, 0]=(-0.960039341476+0.46269827758j)*o*x_ref[0]**(o-1)+((0.78822933019-0.684328065878j))
        ref[0, 0, 0, 1]=(0.767820764439+0.734999891143j)*o*x_ref[1]**(o-1)+((-0.103455553038+0.379859647321j))
        arg[0, 0, 1]=(-0.825777967079-0.342123174308j)*x[0]**o+((-0.324411484251-0.757049233433j))*x[0]+((-0.524156833126-0.00473202396789j))*x[1]**o+((0.957048880323+0.813787017502j))*x[1]
        ref[0, 0, 1, 0]=(-0.825777967079-0.342123174308j)*o*x_ref[0]**(o-1)+((-0.324411484251-0.757049233433j))
        ref[0, 0, 1, 1]=(-0.524156833126-0.00473202396789j)*o*x_ref[1]**(o-1)+((0.957048880323+0.813787017502j))
        arg[0, 1, 0]=(0.842409576545+0.402572469621j)*x[0]**o+((-0.554093745007+0.749099878089j))*x[0]+((0.221465634754-0.83060292727j))*x[1]**o+((0.268002715129-0.153639835793j))*x[1]
        ref[0, 1, 0, 0]=(0.842409576545+0.402572469621j)*o*x_ref[0]**(o-1)+((-0.554093745007+0.749099878089j))
        ref[0, 1, 0, 1]=(0.221465634754-0.83060292727j)*o*x_ref[1]**(o-1)+((0.268002715129-0.153639835793j))
        arg[0, 1, 1]=(-0.787856379789+0.5015035365j)*x[0]**o+((0.325286093828+0.226384894093j))*x[0]+((-0.780570763279-0.519444068981j))*x[1]**o+((0.533973909988-0.599280537898j))*x[1]
        ref[0, 1, 1, 0]=(-0.787856379789+0.5015035365j)*o*x_ref[0]**(o-1)+((0.325286093828+0.226384894093j))
        ref[0, 1, 1, 1]=(-0.780570763279-0.519444068981j)*o*x_ref[1]**(o-1)+((0.533973909988-0.599280537898j))
        arg[0, 2, 0]=(0.255569556775-0.893629500723j)*x[0]**o+((0.48604866693-0.688099850954j))*x[0]+((-0.920073512817+0.137948550637j))*x[1]**o+((-0.518299100622-0.649279952606j))*x[1]
        ref[0, 2, 0, 0]=(0.255569556775-0.893629500723j)*o*x_ref[0]**(o-1)+((0.48604866693-0.688099850954j))
        ref[0, 2, 0, 1]=(-0.920073512817+0.137948550637j)*o*x_ref[1]**(o-1)+((-0.518299100622-0.649279952606j))
        arg[0, 2, 1]=(-0.20825271768+0.697992266258j)*x[0]**o+((0.964724676097+0.464373666955j))*x[0]+((-0.715551986424-0.356098261343j))*x[1]**o+((0.556768033901-0.526192657061j))*x[1]
        ref[0, 2, 1, 0]=(-0.20825271768+0.697992266258j)*o*x_ref[0]**(o-1)+((0.964724676097+0.464373666955j))
        ref[0, 2, 1, 1]=(-0.715551986424-0.356098261343j)*o*x_ref[1]**(o-1)+((0.556768033901-0.526192657061j))
        arg[1, 0, 0]=(-0.979678373731+0.627298310431j)*x[0]**o+((0.569557504583+0.0991859357945j))*x[0]+((-0.825730820486-0.69194700262j))*x[1]**o+((0.134917810158+0.129498412865j))*x[1]
        ref[1, 0, 0, 0]=(-0.979678373731+0.627298310431j)*o*x_ref[0]**(o-1)+((0.569557504583+0.0991859357945j))
        ref[1, 0, 0, 1]=(-0.825730820486-0.69194700262j)*o*x_ref[1]**(o-1)+((0.134917810158+0.129498412865j))
        arg[1, 0, 1]=(0.860243578956-0.771209509502j)*x[0]**o+((-0.782783957891-0.860799811222j))*x[0]+((-0.283891493053-0.831888949678j))*x[1]**o+((0.0843026389252+0.0883641019458j))*x[1]
        ref[1, 0, 1, 0]=(0.860243578956-0.771209509502j)*o*x_ref[0]**(o-1)+((-0.782783957891-0.860799811222j))
        ref[1, 0, 1, 1]=(-0.283891493053-0.831888949678j)*o*x_ref[1]**(o-1)+((0.0843026389252+0.0883641019458j))
        arg[1, 1, 0]=(-0.452843274726+0.497386542792j)*x[0]**o+((-0.593920731512-0.991287699768j))*x[0]+((0.912279849721+0.30286103967j))*x[1]**o+((0.791461669093-0.719330844581j))*x[1]
        ref[1, 1, 0, 0]=(-0.452843274726+0.497386542792j)*o*x_ref[0]**(o-1)+((-0.593920731512-0.991287699768j))
        ref[1, 1, 0, 1]=(0.912279849721+0.30286103967j)*o*x_ref[1]**(o-1)+((0.791461669093-0.719330844581j))
        arg[1, 1, 1]=(0.558248240096-0.230509104277j)*x[0]**o+((0.702602717477-0.761644055565j))*x[0]+((0.678189139464-0.855204242437j))*x[1]**o+((0.653683632306-0.217137610126j))*x[1]
        ref[1, 1, 1, 0]=(0.558248240096-0.230509104277j)*o*x_ref[0]**(o-1)+((0.702602717477-0.761644055565j))
        ref[1, 1, 1, 1]=(0.678189139464-0.855204242437j)*o*x_ref[1]**(o-1)+((0.653683632306-0.217137610126j))
        arg[1, 2, 0]=(0.375727648976-0.122393609163j)*x[0]**o+((0.244355606736-0.47642633595j))*x[0]+((0.217336348313+0.488923479418j))*x[1]**o+((-0.599340999264-0.826186354726j))*x[1]
        ref[1, 2, 0, 0]=(0.375727648976-0.122393609163j)*o*x_ref[0]**(o-1)+((0.244355606736-0.47642633595j))
        ref[1, 2, 0, 1]=(0.217336348313+0.488923479418j)*o*x_ref[1]**(o-1)+((-0.599340999264-0.826186354726j))
        arg[1, 2, 1]=(0.897927422562-0.0519397581788j)*x[0]**o+((-0.207712564694+0.623614551154j))*x[0]+((-0.438691499588+0.625198920369j))*x[1]**o+((-0.109043961519-0.796250973302j))*x[1]
        ref[1, 2, 1, 0]=(0.897927422562-0.0519397581788j)*o*x_ref[0]**(o-1)+((-0.207712564694+0.623614551154j))
        ref[1, 2, 1, 1]=(-0.438691499588+0.625198920369j)*o*x_ref[1]**(o-1)+((-0.109043961519-0.796250973302j))
        arg[2, 0, 0]=(0.18339207601-0.776835850244j)*x[0]**o+((-0.79575702711-0.583228693119j))*x[0]+((-0.578072471255-0.606924845786j))*x[1]**o+((0.62974770604-0.597880793165j))*x[1]
        ref[2, 0, 0, 0]=(0.18339207601-0.776835850244j)*o*x_ref[0]**(o-1)+((-0.79575702711-0.583228693119j))
        ref[2, 0, 0, 1]=(-0.578072471255-0.606924845786j)*o*x_ref[1]**(o-1)+((0.62974770604-0.597880793165j))
        arg[2, 0, 1]=(0.710729002663+0.192333621517j)*x[0]**o+((0.184240604126+0.207747308141j))*x[0]+((0.284515710576-0.496624514021j))*x[1]**o+((0.522757245259+0.492772723591j))*x[1]
        ref[2, 0, 1, 0]=(0.710729002663+0.192333621517j)*o*x_ref[0]**(o-1)+((0.184240604126+0.207747308141j))
        ref[2, 0, 1, 1]=(0.284515710576-0.496624514021j)*o*x_ref[1]**(o-1)+((0.522757245259+0.492772723591j))
        arg[2, 1, 0]=(-0.476809530569+0.501071609515j)*x[0]**o+((-0.983631136917+0.956615083211j))*x[0]+((0.515689009695-0.810937637827j))*x[1]**o+((0.614659031783+0.812481792196j))*x[1]
        ref[2, 1, 0, 0]=(-0.476809530569+0.501071609515j)*o*x_ref[0]**(o-1)+((-0.983631136917+0.956615083211j))
        ref[2, 1, 0, 1]=(0.515689009695-0.810937637827j)*o*x_ref[1]**(o-1)+((0.614659031783+0.812481792196j))
        arg[2, 1, 1]=(-0.42993761268-0.42474406769j)*x[0]**o+((0.152978556998+0.709885564037j))*x[0]+((0.624360504816+0.778610401192j))*x[1]**o+((-0.508700858123-0.363954235263j))*x[1]
        ref[2, 1, 1, 0]=(-0.42993761268-0.42474406769j)*o*x_ref[0]**(o-1)+((0.152978556998+0.709885564037j))
        ref[2, 1, 1, 1]=(0.624360504816+0.778610401192j)*o*x_ref[1]**(o-1)+((-0.508700858123-0.363954235263j))
        arg[2, 2, 0]=(-0.302821076674+0.214386302462j)*x[0]**o+((0.104577320592-0.137790859795j))*x[0]+((0.526451734781+0.762176744337j))*x[1]**o+((-0.0586267211044-0.475086759824j))*x[1]
        ref[2, 2, 0, 0]=(-0.302821076674+0.214386302462j)*o*x_ref[0]**(o-1)+((0.104577320592-0.137790859795j))
        ref[2, 2, 0, 1]=(0.526451734781+0.762176744337j)*o*x_ref[1]**(o-1)+((-0.0586267211044-0.475086759824j))
        arg[2, 2, 1]=(0.488953944115+0.367496193161j)*x[0]**o+((-0.342016120716-0.31630457113j))*x[0]+((0.431290304916-0.156229616877j))*x[1]**o+((-0.733270989246+0.510455647114j))*x[1]
        ref[2, 2, 1, 0]=(0.488953944115+0.367496193161j)*o*x_ref[0]**(o-1)+((-0.342016120716-0.31630457113j))
        ref[2, 2, 1, 1]=(0.431290304916-0.156229616877j)*o*x_ref[1]**(o-1)+((-0.733270989246+0.510455647114j))
        arg[3, 0, 0]=(0.491346674494-0.157570569113j)*x[0]**o+((-0.770392061202+0.131512281366j))*x[0]+((-0.668607177663+0.793400865467j))*x[1]**o+((-0.976698250624+0.0527066718652j))*x[1]
        ref[3, 0, 0, 0]=(0.491346674494-0.157570569113j)*o*x_ref[0]**(o-1)+((-0.770392061202+0.131512281366j))
        ref[3, 0, 0, 1]=(-0.668607177663+0.793400865467j)*o*x_ref[1]**(o-1)+((-0.976698250624+0.0527066718652j))
        arg[3, 0, 1]=(-0.0619204873105+0.0482848060224j)*x[0]**o+((0.400325893744-0.824007513048j))*x[0]+((0.525195261199-0.629828838714j))*x[1]**o+((0.458947709752+0.963525860354j))*x[1]
        ref[3, 0, 1, 0]=(-0.0619204873105+0.0482848060224j)*o*x_ref[0]**(o-1)+((0.400325893744-0.824007513048j))
        ref[3, 0, 1, 1]=(0.525195261199-0.629828838714j)*o*x_ref[1]**(o-1)+((0.458947709752+0.963525860354j))
        arg[3, 1, 0]=(-0.915547646353-0.620654448633j)*x[0]**o+((-0.846113424543+0.394021961357j))*x[0]+((0.177448450134-0.718067012123j))*x[1]**o+((-0.528042137155-0.987473748715j))*x[1]
        ref[3, 1, 0, 0]=(-0.915547646353-0.620654448633j)*o*x_ref[0]**(o-1)+((-0.846113424543+0.394021961357j))
        ref[3, 1, 0, 1]=(0.177448450134-0.718067012123j)*o*x_ref[1]**(o-1)+((-0.528042137155-0.987473748715j))
        arg[3, 1, 1]=(-0.219664456819+0.551892467182j)*x[0]**o+((-0.613082801257-0.585132795854j))*x[0]+((0.213961578473-0.995491368699j))*x[1]**o+((0.384353918616-0.244965616484j))*x[1]
        ref[3, 1, 1, 0]=(-0.219664456819+0.551892467182j)*o*x_ref[0]**(o-1)+((-0.613082801257-0.585132795854j))
        ref[3, 1, 1, 1]=(0.213961578473-0.995491368699j)*o*x_ref[1]**(o-1)+((0.384353918616-0.244965616484j))
        arg[3, 2, 0]=(-0.265001056188+0.667794963918j)*x[0]**o+((0.336942390541+0.96587876002j))*x[0]+((0.822924175852-0.901948975159j))*x[1]**o+((0.574649512226-0.783075232163j))*x[1]
        ref[3, 2, 0, 0]=(-0.265001056188+0.667794963918j)*o*x_ref[0]**(o-1)+((0.336942390541+0.96587876002j))
        ref[3, 2, 0, 1]=(0.822924175852-0.901948975159j)*o*x_ref[1]**(o-1)+((0.574649512226-0.783075232163j))
        arg[3, 2, 1]=(0.639477096732+0.807963708751j)*x[0]**o+((-0.426351148837+0.315557559618j))*x[0]+((-0.0652011541463-0.323979031494j))*x[1]**o+((0.636564689595+0.255987593268j))*x[1]
        ref[3, 2, 1, 0]=(0.639477096732+0.807963708751j)*o*x_ref[0]**(o-1)+((-0.426351148837+0.315557559618j))
        ref[3, 2, 1, 1]=(-0.0652011541463-0.323979031494j)*o*x_ref[1]**(o-1)+((0.636564689595+0.255987593268j))
        if dim==3:
            arg[0, 0, 0]+=(-0.662533239389+0.573369324895j)*x[2]**o+((-0.66685083459-0.750648542226j))*x[2]
            ref[0, 0, 0, 2]=(-0.662533239389+0.573369324895j)*o*x_ref[2]**(o-1)+((-0.66685083459-0.750648542226j))
            arg[0, 0, 1]+=(0.488476249128+0.835754672465j)*x[2]**o+((0.850199326216-0.504560394309j))*x[2]
            ref[0, 0, 1, 2]=(0.488476249128+0.835754672465j)*o*x_ref[2]**(o-1)+((0.850199326216-0.504560394309j))
            arg[0, 1, 0]+=(-0.345343119565+0.688625696212j)*x[2]**o+((0.501966557817-0.149462916046j))*x[2]
            ref[0, 1, 0, 2]=(-0.345343119565+0.688625696212j)*o*x_ref[2]**(o-1)+((0.501966557817-0.149462916046j))
            arg[0, 1, 1]+=(0.0351804445506+0.0687760317914j)*x[2]**o+((0.598713256-0.956074196154j))*x[2]
            ref[0, 1, 1, 2]=(0.0351804445506+0.0687760317914j)*o*x_ref[2]**(o-1)+((0.598713256-0.956074196154j))
            arg[0, 2, 0]+=(0.524634633954+0.640745600371j)*x[2]**o+((-0.631297276285-0.169037772843j))*x[2]
            ref[0, 2, 0, 2]=(0.524634633954+0.640745600371j)*o*x_ref[2]**(o-1)+((-0.631297276285-0.169037772843j))
            arg[0, 2, 1]+=(-0.503034963893+0.712722882005j)*x[2]**o+((0.389292532661-0.563525409676j))*x[2]
            ref[0, 2, 1, 2]=(-0.503034963893+0.712722882005j)*o*x_ref[2]**(o-1)+((0.389292532661-0.563525409676j))
            arg[1, 0, 0]+=(0.432602105389-0.708149218497j)*x[2]**o+((0.857773490227+0.982512131798j))*x[2]
            ref[1, 0, 0, 2]=(0.432602105389-0.708149218497j)*o*x_ref[2]**(o-1)+((0.857773490227+0.982512131798j))
            arg[1, 0, 1]+=(0.991433529008+0.769378690074j)*x[2]**o+((-0.751211836307-0.284150195503j))*x[2]
            ref[1, 0, 1, 2]=(0.991433529008+0.769378690074j)*o*x_ref[2]**(o-1)+((-0.751211836307-0.284150195503j))
            arg[1, 1, 0]+=(0.245538629579-0.856346439669j)*x[2]**o+((0.670127130457-0.520137831819j))*x[2]
            ref[1, 1, 0, 2]=(0.245538629579-0.856346439669j)*o*x_ref[2]**(o-1)+((0.670127130457-0.520137831819j))
            arg[1, 1, 1]+=(0.295935614496+0.849967281993j)*x[2]**o+((0.0835118240775+0.153808190031j))*x[2]
            ref[1, 1, 1, 2]=(0.295935614496+0.849967281993j)*o*x_ref[2]**(o-1)+((0.0835118240775+0.153808190031j))
            arg[1, 2, 0]+=(0.629370770436-0.458509213977j)*x[2]**o+((-0.314667372265-0.748332589185j))*x[2]
            ref[1, 2, 0, 2]=(0.629370770436-0.458509213977j)*o*x_ref[2]**(o-1)+((-0.314667372265-0.748332589185j))
            arg[1, 2, 1]+=(-0.832243458831-0.760078710786j)*x[2]**o+((0.365596004534-0.720480950457j))*x[2]
            ref[1, 2, 1, 2]=(-0.832243458831-0.760078710786j)*o*x_ref[2]**(o-1)+((0.365596004534-0.720480950457j))
            arg[2, 0, 0]+=(0.93452260645+0.287575454339j)*x[2]**o+((0.100108933033-0.421884809666j))*x[2]
            ref[2, 0, 0, 2]=(0.93452260645+0.287575454339j)*o*x_ref[2]**(o-1)+((0.100108933033-0.421884809666j))
            arg[2, 0, 1]+=(-0.63455953166+0.893465328996j)*x[2]**o+((0.835001998343+0.150005342251j))*x[2]
            ref[2, 0, 1, 2]=(-0.63455953166+0.893465328996j)*o*x_ref[2]**(o-1)+((0.835001998343+0.150005342251j))
            arg[2, 1, 0]+=(-0.631839283655+0.499857028479j)*x[2]**o+((-0.937462012422+0.54866619262j))*x[2]
            ref[2, 1, 0, 2]=(-0.631839283655+0.499857028479j)*o*x_ref[2]**(o-1)+((-0.937462012422+0.54866619262j))
            arg[2, 1, 1]+=(0.470039103556+0.0399619122114j)*x[2]**o+((0.168734521815-0.0926863478719j))*x[2]
            ref[2, 1, 1, 2]=(0.470039103556+0.0399619122114j)*o*x_ref[2]**(o-1)+((0.168734521815-0.0926863478719j))
            arg[2, 2, 0]+=(-0.39241100971-0.578745195982j)*x[2]**o+((0.504346307416-0.108210128876j))*x[2]
            ref[2, 2, 0, 2]=(-0.39241100971-0.578745195982j)*o*x_ref[2]**(o-1)+((0.504346307416-0.108210128876j))
            arg[2, 2, 1]+=(-0.634424783834-0.793387848993j)*x[2]**o+((-0.26991002198+0.105544545079j))*x[2]
            ref[2, 2, 1, 2]=(-0.634424783834-0.793387848993j)*o*x_ref[2]**(o-1)+((-0.26991002198+0.105544545079j))
            arg[3, 0, 0]+=(-0.462161399319+0.910311400359j)*x[2]**o+((-0.013958514263-0.160727819434j))*x[2]
            ref[3, 0, 0, 2]=(-0.462161399319+0.910311400359j)*o*x_ref[2]**(o-1)+((-0.013958514263-0.160727819434j))
            arg[3, 0, 1]+=(-0.0751618273084-0.599332134531j)*x[2]**o+((-0.754694907707-0.637658345318j))*x[2]
            ref[3, 0, 1, 2]=(-0.0751618273084-0.599332134531j)*o*x_ref[2]**(o-1)+((-0.754694907707-0.637658345318j))
            arg[3, 1, 0]+=(0.936961963702-0.51042385577j)*x[2]**o+((-0.799409771222+0.641845555394j))*x[2]
            ref[3, 1, 0, 2]=(0.936961963702-0.51042385577j)*o*x_ref[2]**(o-1)+((-0.799409771222+0.641845555394j))
            arg[3, 1, 1]+=(-0.967322087006+0.365099022192j)*x[2]**o+((-0.267352925701-0.0199637470112j))*x[2]
            ref[3, 1, 1, 2]=(-0.967322087006+0.365099022192j)*o*x_ref[2]**(o-1)+((-0.267352925701-0.0199637470112j))
            arg[3, 2, 0]+=(-0.419349855967+0.0182677935657j)*x[2]**o+((-0.859668986795-0.127861296527j))*x[2]
            ref[3, 2, 0, 2]=(-0.419349855967+0.0182677935657j)*o*x_ref[2]**(o-1)+((-0.859668986795-0.127861296527j))
            arg[3, 2, 1]+=(-0.94621163835-0.845614407011j)*x[2]**o+((-0.961767678568-0.806437797957j))*x[2]
            ref[3, 2, 1, 2]=(-0.94621163835-0.845614407011j)*o*x_ref[2]**(o-1)+((-0.961767678568-0.806437797957j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4, 3, 2)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnContactZero_fromData_ReducedSolution_rank0(self):
        """
        tests gradient of rank 0 Data on FunctionOnContactZero

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on FunctionOnContactZero
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnContactZero(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=(0.764791191104-0.556832200489j)*x[0]+((0.810207633568-0.594978349408j))*x[1]
        ref[0]=(0.764791191104-0.556832200489j)
        ref[1]=(0.810207633568-0.594978349408j)
        if dim==3:
            arg+=((0.117737240779+0.114448110892j))*x[2]
            ref[2]=(0.117737240779+0.114448110892j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnContactZero_fromData_ReducedSolution_rank1(self):
        """
        tests gradient of rank 1 Data on FunctionOnContactZero

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on FunctionOnContactZero
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnContactZero(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(3,),w)
        ref = Data(0,(3,)+(dim,),w_ref)
        arg[0,]=(-0.806578595831-0.661577903754j)*x[0]+((0.832098318261-0.912515065035j))*x[1]
        ref[0, 0]=(-0.806578595831-0.661577903754j)
        ref[0, 1]=(0.832098318261-0.912515065035j)
        arg[1,]=(0.530504930676-0.888236095155j)*x[0]+((-0.324088952505+0.618908647792j))*x[1]
        ref[1, 0]=(0.530504930676-0.888236095155j)
        ref[1, 1]=(-0.324088952505+0.618908647792j)
        arg[2,]=(-0.380435014166-0.957165574398j)*x[0]+((0.394835515301-0.545238640654j))*x[1]
        ref[2, 0]=(-0.380435014166-0.957165574398j)
        ref[2, 1]=(0.394835515301-0.545238640654j)
        if dim==3:
            arg[0,]+=(0.45453604398-0.167464458223j)*x[2]
            ref[0, 2]=(0.45453604398-0.167464458223j)
            arg[1,]+=(0.517343771561-0.00626834079677j)*x[2]
            ref[1, 2]=(0.517343771561-0.00626834079677j)
            arg[2,]+=(0.368444129454-0.551194080108j)*x[2]
            ref[2, 2]=(0.368444129454-0.551194080108j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnContactZero_fromData_ReducedSolution_rank2(self):
        """
        tests gradient of rank 2 Data on FunctionOnContactZero

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on FunctionOnContactZero
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnContactZero(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(4, 4),w)
        ref = Data(0,(4, 4)+(dim,),w_ref)
        arg[0, 0]=(-0.879182094085-0.922091121985j)*x[0]+((0.327862807272+0.832397929588j))*x[1]
        ref[0, 0, 0]=(-0.879182094085-0.922091121985j)
        ref[0, 0, 1]=(0.327862807272+0.832397929588j)
        arg[0, 1]=(-0.152261819653-0.139784746694j)*x[0]+((-0.932522737122-0.602564360511j))*x[1]
        ref[0, 1, 0]=(-0.152261819653-0.139784746694j)
        ref[0, 1, 1]=(-0.932522737122-0.602564360511j)
        arg[0, 2]=(0.227150114304+0.942571242949j)*x[0]+((0.812936200119-0.55254008665j))*x[1]
        ref[0, 2, 0]=(0.227150114304+0.942571242949j)
        ref[0, 2, 1]=(0.812936200119-0.55254008665j)
        arg[0, 3]=(0.244196467213+0.978657132804j)*x[0]+((0.608264628854+0.665858291991j))*x[1]
        ref[0, 3, 0]=(0.244196467213+0.978657132804j)
        ref[0, 3, 1]=(0.608264628854+0.665858291991j)
        arg[1, 0]=(0.0736386791122+0.899113559526j)*x[0]+((0.0601755131235+0.599129384328j))*x[1]
        ref[1, 0, 0]=(0.0736386791122+0.899113559526j)
        ref[1, 0, 1]=(0.0601755131235+0.599129384328j)
        arg[1, 1]=(-0.9949376022-0.994712986834j)*x[0]+((0.750176651358+0.963811676864j))*x[1]
        ref[1, 1, 0]=(-0.9949376022-0.994712986834j)
        ref[1, 1, 1]=(0.750176651358+0.963811676864j)
        arg[1, 2]=(-0.825001025519-0.874905297367j)*x[0]+((-0.30910191519-0.2571891576j))*x[1]
        ref[1, 2, 0]=(-0.825001025519-0.874905297367j)
        ref[1, 2, 1]=(-0.30910191519-0.2571891576j)
        arg[1, 3]=(-0.403982695288-0.147460339691j)*x[0]+((0.975465216179+0.129457048394j))*x[1]
        ref[1, 3, 0]=(-0.403982695288-0.147460339691j)
        ref[1, 3, 1]=(0.975465216179+0.129457048394j)
        arg[2, 0]=(0.375790983056-0.680303037491j)*x[0]+((0.250070438957+0.457073332768j))*x[1]
        ref[2, 0, 0]=(0.375790983056-0.680303037491j)
        ref[2, 0, 1]=(0.250070438957+0.457073332768j)
        arg[2, 1]=(0.824783951674-0.377071251108j)*x[0]+((0.663190299495-0.24155766475j))*x[1]
        ref[2, 1, 0]=(0.824783951674-0.377071251108j)
        ref[2, 1, 1]=(0.663190299495-0.24155766475j)
        arg[2, 2]=(0.719632573405+0.569207439157j)*x[0]+((-0.3063574067+0.673727452186j))*x[1]
        ref[2, 2, 0]=(0.719632573405+0.569207439157j)
        ref[2, 2, 1]=(-0.3063574067+0.673727452186j)
        arg[2, 3]=(-0.719430186804+0.156718943018j)*x[0]+((0.477176533653+0.0572187957196j))*x[1]
        ref[2, 3, 0]=(-0.719430186804+0.156718943018j)
        ref[2, 3, 1]=(0.477176533653+0.0572187957196j)
        arg[3, 0]=(-0.158303280096-0.636590199785j)*x[0]+((-0.41378484152-0.777363701068j))*x[1]
        ref[3, 0, 0]=(-0.158303280096-0.636590199785j)
        ref[3, 0, 1]=(-0.41378484152-0.777363701068j)
        arg[3, 1]=(-0.406579797314-0.186616369419j)*x[0]+((-0.867207560938-0.138502865759j))*x[1]
        ref[3, 1, 0]=(-0.406579797314-0.186616369419j)
        ref[3, 1, 1]=(-0.867207560938-0.138502865759j)
        arg[3, 2]=(0.574496203056-0.372132490784j)*x[0]+((-0.700262987785-0.472195229493j))*x[1]
        ref[3, 2, 0]=(0.574496203056-0.372132490784j)
        ref[3, 2, 1]=(-0.700262987785-0.472195229493j)
        arg[3, 3]=(0.0170537849199+0.444932895649j)*x[0]+((0.4324664108-0.336294478804j))*x[1]
        ref[3, 3, 0]=(0.0170537849199+0.444932895649j)
        ref[3, 3, 1]=(0.4324664108-0.336294478804j)
        if dim==3:
            arg[0, 0]+=(-0.645350230978-0.18305715218j)*x[2]
            ref[0, 0, 2]=(-0.645350230978-0.18305715218j)
            arg[0, 1]+=(0.466020229114-0.861325019202j)*x[2]
            ref[0, 1, 2]=(0.466020229114-0.861325019202j)
            arg[0, 2]+=(0.315430903982+0.0808288343865j)*x[2]
            ref[0, 2, 2]=(0.315430903982+0.0808288343865j)
            arg[0, 3]+=(-0.462476833364-0.413826354265j)*x[2]
            ref[0, 3, 2]=(-0.462476833364-0.413826354265j)
            arg[1, 0]+=(-0.329150987778-0.125428074937j)*x[2]
            ref[1, 0, 2]=(-0.329150987778-0.125428074937j)
            arg[1, 1]+=(0.750668665705+0.360091930742j)*x[2]
            ref[1, 1, 2]=(0.750668665705+0.360091930742j)
            arg[1, 2]+=(-0.168753218825-0.650710035034j)*x[2]
            ref[1, 2, 2]=(-0.168753218825-0.650710035034j)
            arg[1, 3]+=(0.314916495361+0.417151655316j)*x[2]
            ref[1, 3, 2]=(0.314916495361+0.417151655316j)
            arg[2, 0]+=(-0.900052055281+0.042171285763j)*x[2]
            ref[2, 0, 2]=(-0.900052055281+0.042171285763j)
            arg[2, 1]+=(-0.279716781283-0.292922519583j)*x[2]
            ref[2, 1, 2]=(-0.279716781283-0.292922519583j)
            arg[2, 2]+=(-0.81077217778-0.18759482826j)*x[2]
            ref[2, 2, 2]=(-0.81077217778-0.18759482826j)
            arg[2, 3]+=(0.600635921357+0.208597166462j)*x[2]
            ref[2, 3, 2]=(0.600635921357+0.208597166462j)
            arg[3, 0]+=(-0.14751109548+0.214879961788j)*x[2]
            ref[3, 0, 2]=(-0.14751109548+0.214879961788j)
            arg[3, 1]+=(0.152656513493+0.686217769255j)*x[2]
            ref[3, 1, 2]=(0.152656513493+0.686217769255j)
            arg[3, 2]+=(-0.491234050973-0.362183574699j)*x[2]
            ref[3, 2, 2]=(-0.491234050973-0.362183574699j)
            arg[3, 3]+=(0.723434950166+0.61502854585j)*x[2]
            ref[3, 3, 2]=(0.723434950166+0.61502854585j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4, 4)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnContactZero_fromData_ReducedSolution_rank3(self):
        """
        tests gradient of rank 3 Data on FunctionOnContactZero

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on FunctionOnContactZero
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnContactZero(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(3, 4, 3),w)
        ref = Data(0,(3, 4, 3)+(dim,),w_ref)
        arg[0, 0, 0]=(0.468284333114-0.92640478288j)*x[0]+((0.316151603524-0.0113781781865j))*x[1]
        ref[0, 0, 0, 0]=(0.468284333114-0.92640478288j)
        ref[0, 0, 0, 1]=(0.316151603524-0.0113781781865j)
        arg[0, 0, 1]=(0.443517382327-0.444841721154j)*x[0]+((-0.637304820112+0.659176577599j))*x[1]
        ref[0, 0, 1, 0]=(0.443517382327-0.444841721154j)
        ref[0, 0, 1, 1]=(-0.637304820112+0.659176577599j)
        arg[0, 0, 2]=(0.884267003309+0.709756818381j)*x[0]+((0.879955772589-0.182058618686j))*x[1]
        ref[0, 0, 2, 0]=(0.884267003309+0.709756818381j)
        ref[0, 0, 2, 1]=(0.879955772589-0.182058618686j)
        arg[0, 1, 0]=(0.933241439406-0.770495761191j)*x[0]+((-0.704387959309-0.975103037342j))*x[1]
        ref[0, 1, 0, 0]=(0.933241439406-0.770495761191j)
        ref[0, 1, 0, 1]=(-0.704387959309-0.975103037342j)
        arg[0, 1, 1]=(0.0513294217705+0.444831325531j)*x[0]+((0.161756943347+0.883985161779j))*x[1]
        ref[0, 1, 1, 0]=(0.0513294217705+0.444831325531j)
        ref[0, 1, 1, 1]=(0.161756943347+0.883985161779j)
        arg[0, 1, 2]=(0.353365519091+0.970932500651j)*x[0]+((-0.833221834194-0.606032595561j))*x[1]
        ref[0, 1, 2, 0]=(0.353365519091+0.970932500651j)
        ref[0, 1, 2, 1]=(-0.833221834194-0.606032595561j)
        arg[0, 2, 0]=(0.395116156532-0.0359110641202j)*x[0]+((-0.513582692084+0.517863667073j))*x[1]
        ref[0, 2, 0, 0]=(0.395116156532-0.0359110641202j)
        ref[0, 2, 0, 1]=(-0.513582692084+0.517863667073j)
        arg[0, 2, 1]=(-0.528913646601-0.674821109586j)*x[0]+((-0.652355063103-0.643478136104j))*x[1]
        ref[0, 2, 1, 0]=(-0.528913646601-0.674821109586j)
        ref[0, 2, 1, 1]=(-0.652355063103-0.643478136104j)
        arg[0, 2, 2]=(-0.709742942124+0.580057300051j)*x[0]+((-0.503657281993+0.0839447052578j))*x[1]
        ref[0, 2, 2, 0]=(-0.709742942124+0.580057300051j)
        ref[0, 2, 2, 1]=(-0.503657281993+0.0839447052578j)
        arg[0, 3, 0]=(0.510591339616+0.623703596254j)*x[0]+((-0.0731226524959-0.39651611245j))*x[1]
        ref[0, 3, 0, 0]=(0.510591339616+0.623703596254j)
        ref[0, 3, 0, 1]=(-0.0731226524959-0.39651611245j)
        arg[0, 3, 1]=(0.836205641785-0.638730259454j)*x[0]+((0.819722020799+0.788686232478j))*x[1]
        ref[0, 3, 1, 0]=(0.836205641785-0.638730259454j)
        ref[0, 3, 1, 1]=(0.819722020799+0.788686232478j)
        arg[0, 3, 2]=(0.508965280446-0.534003225917j)*x[0]+((-0.913038820037-0.605117384163j))*x[1]
        ref[0, 3, 2, 0]=(0.508965280446-0.534003225917j)
        ref[0, 3, 2, 1]=(-0.913038820037-0.605117384163j)
        arg[1, 0, 0]=(0.177060104917-0.14145962283j)*x[0]+((-0.620699701288+0.453635096919j))*x[1]
        ref[1, 0, 0, 0]=(0.177060104917-0.14145962283j)
        ref[1, 0, 0, 1]=(-0.620699701288+0.453635096919j)
        arg[1, 0, 1]=(0.148316128604-0.542612455539j)*x[0]+((-0.0557715190378-0.397282046971j))*x[1]
        ref[1, 0, 1, 0]=(0.148316128604-0.542612455539j)
        ref[1, 0, 1, 1]=(-0.0557715190378-0.397282046971j)
        arg[1, 0, 2]=(0.914821510379-0.339375425208j)*x[0]+((0.659835392892-0.284764126615j))*x[1]
        ref[1, 0, 2, 0]=(0.914821510379-0.339375425208j)
        ref[1, 0, 2, 1]=(0.659835392892-0.284764126615j)
        arg[1, 1, 0]=(0.796619473462+0.0715912556094j)*x[0]+((-0.377823624066+0.569776434191j))*x[1]
        ref[1, 1, 0, 0]=(0.796619473462+0.0715912556094j)
        ref[1, 1, 0, 1]=(-0.377823624066+0.569776434191j)
        arg[1, 1, 1]=(0.743563472581+0.507833158399j)*x[0]+((-0.501177587664+0.656794583694j))*x[1]
        ref[1, 1, 1, 0]=(0.743563472581+0.507833158399j)
        ref[1, 1, 1, 1]=(-0.501177587664+0.656794583694j)
        arg[1, 1, 2]=(-0.377553679874-0.984257879015j)*x[0]+((0.353552695189+0.516463808779j))*x[1]
        ref[1, 1, 2, 0]=(-0.377553679874-0.984257879015j)
        ref[1, 1, 2, 1]=(0.353552695189+0.516463808779j)
        arg[1, 2, 0]=(-0.382438807119+0.861232491466j)*x[0]+((0.461980285397+0.911527193096j))*x[1]
        ref[1, 2, 0, 0]=(-0.382438807119+0.861232491466j)
        ref[1, 2, 0, 1]=(0.461980285397+0.911527193096j)
        arg[1, 2, 1]=(0.428806374074-0.213648699204j)*x[0]+((-0.121165778985+0.169030920555j))*x[1]
        ref[1, 2, 1, 0]=(0.428806374074-0.213648699204j)
        ref[1, 2, 1, 1]=(-0.121165778985+0.169030920555j)
        arg[1, 2, 2]=(-0.081917283383-0.74417037969j)*x[0]+((0.875964757259-0.343086909423j))*x[1]
        ref[1, 2, 2, 0]=(-0.081917283383-0.74417037969j)
        ref[1, 2, 2, 1]=(0.875964757259-0.343086909423j)
        arg[1, 3, 0]=(0.787080048129-0.354340211793j)*x[0]+((0.875000000968-0.3049434585j))*x[1]
        ref[1, 3, 0, 0]=(0.787080048129-0.354340211793j)
        ref[1, 3, 0, 1]=(0.875000000968-0.3049434585j)
        arg[1, 3, 1]=(0.704124994087-0.528901691521j)*x[0]+((-0.112611562586+0.366387186487j))*x[1]
        ref[1, 3, 1, 0]=(0.704124994087-0.528901691521j)
        ref[1, 3, 1, 1]=(-0.112611562586+0.366387186487j)
        arg[1, 3, 2]=(-0.354128925927+0.870448596728j)*x[0]+((-0.626580914192-0.421320575852j))*x[1]
        ref[1, 3, 2, 0]=(-0.354128925927+0.870448596728j)
        ref[1, 3, 2, 1]=(-0.626580914192-0.421320575852j)
        arg[2, 0, 0]=(-0.832523493125-0.827021990746j)*x[0]+((-0.152344911997+0.0334857663831j))*x[1]
        ref[2, 0, 0, 0]=(-0.832523493125-0.827021990746j)
        ref[2, 0, 0, 1]=(-0.152344911997+0.0334857663831j)
        arg[2, 0, 1]=(-0.291192038648+0.306703089998j)*x[0]+((0.726078023153-0.850614193506j))*x[1]
        ref[2, 0, 1, 0]=(-0.291192038648+0.306703089998j)
        ref[2, 0, 1, 1]=(0.726078023153-0.850614193506j)
        arg[2, 0, 2]=(0.962955520135+0.356934712577j)*x[0]+((-0.289907949037-0.583159173447j))*x[1]
        ref[2, 0, 2, 0]=(0.962955520135+0.356934712577j)
        ref[2, 0, 2, 1]=(-0.289907949037-0.583159173447j)
        arg[2, 1, 0]=(-0.76097963792+0.299848494293j)*x[0]+((-0.519323514901+0.389048839424j))*x[1]
        ref[2, 1, 0, 0]=(-0.76097963792+0.299848494293j)
        ref[2, 1, 0, 1]=(-0.519323514901+0.389048839424j)
        arg[2, 1, 1]=(-0.925356871658-0.411677376962j)*x[0]+((-0.475760821111-0.232593525101j))*x[1]
        ref[2, 1, 1, 0]=(-0.925356871658-0.411677376962j)
        ref[2, 1, 1, 1]=(-0.475760821111-0.232593525101j)
        arg[2, 1, 2]=(-0.0853116395133+0.893982193595j)*x[0]+((-0.133937810739+0.499175134582j))*x[1]
        ref[2, 1, 2, 0]=(-0.0853116395133+0.893982193595j)
        ref[2, 1, 2, 1]=(-0.133937810739+0.499175134582j)
        arg[2, 2, 0]=(0.776051133069+0.927221145193j)*x[0]+((-0.236119478582-0.336848533312j))*x[1]
        ref[2, 2, 0, 0]=(0.776051133069+0.927221145193j)
        ref[2, 2, 0, 1]=(-0.236119478582-0.336848533312j)
        arg[2, 2, 1]=(0.927460292169-0.228923959325j)*x[0]+((0.0965656559703-0.136360413958j))*x[1]
        ref[2, 2, 1, 0]=(0.927460292169-0.228923959325j)
        ref[2, 2, 1, 1]=(0.0965656559703-0.136360413958j)
        arg[2, 2, 2]=(-0.180944474124+0.678272323322j)*x[0]+((0.766578064175+0.74747408286j))*x[1]
        ref[2, 2, 2, 0]=(-0.180944474124+0.678272323322j)
        ref[2, 2, 2, 1]=(0.766578064175+0.74747408286j)
        arg[2, 3, 0]=(-0.941764976103+0.317438646316j)*x[0]+((-0.623021200166-0.154983540483j))*x[1]
        ref[2, 3, 0, 0]=(-0.941764976103+0.317438646316j)
        ref[2, 3, 0, 1]=(-0.623021200166-0.154983540483j)
        arg[2, 3, 1]=(0.108097826644-0.999150602318j)*x[0]+((0.878330514471-0.892014422241j))*x[1]
        ref[2, 3, 1, 0]=(0.108097826644-0.999150602318j)
        ref[2, 3, 1, 1]=(0.878330514471-0.892014422241j)
        arg[2, 3, 2]=(-0.624291744827+0.38729282139j)*x[0]+((0.971210579476-0.759886466317j))*x[1]
        ref[2, 3, 2, 0]=(-0.624291744827+0.38729282139j)
        ref[2, 3, 2, 1]=(0.971210579476-0.759886466317j)
        if dim==3:
            arg[0, 0, 0]+=(-0.342597280132-0.0876853220686j)*x[2]
            ref[0, 0, 0, 2]=(-0.342597280132-0.0876853220686j)
            arg[0, 0, 1]+=(-0.224531717762-0.661945550024j)*x[2]
            ref[0, 0, 1, 2]=(-0.224531717762-0.661945550024j)
            arg[0, 0, 2]+=(-0.602013067168+0.651586519688j)*x[2]
            ref[0, 0, 2, 2]=(-0.602013067168+0.651586519688j)
            arg[0, 1, 0]+=(0.453557615201+0.751710091847j)*x[2]
            ref[0, 1, 0, 2]=(0.453557615201+0.751710091847j)
            arg[0, 1, 1]+=(0.10157529508-0.32883219354j)*x[2]
            ref[0, 1, 1, 2]=(0.10157529508-0.32883219354j)
            arg[0, 1, 2]+=(0.168438650197-0.0938560397286j)*x[2]
            ref[0, 1, 2, 2]=(0.168438650197-0.0938560397286j)
            arg[0, 2, 0]+=(-0.571176039668-0.124655557841j)*x[2]
            ref[0, 2, 0, 2]=(-0.571176039668-0.124655557841j)
            arg[0, 2, 1]+=(-0.0560380673318+0.534806242964j)*x[2]
            ref[0, 2, 1, 2]=(-0.0560380673318+0.534806242964j)
            arg[0, 2, 2]+=(-0.133672521891+0.668001681549j)*x[2]
            ref[0, 2, 2, 2]=(-0.133672521891+0.668001681549j)
            arg[0, 3, 0]+=(0.455513548969+0.326588419456j)*x[2]
            ref[0, 3, 0, 2]=(0.455513548969+0.326588419456j)
            arg[0, 3, 1]+=(-0.765606505924+0.894104201624j)*x[2]
            ref[0, 3, 1, 2]=(-0.765606505924+0.894104201624j)
            arg[0, 3, 2]+=(-0.398517621269-0.577493483599j)*x[2]
            ref[0, 3, 2, 2]=(-0.398517621269-0.577493483599j)
            arg[1, 0, 0]+=(-0.380586719716+0.711357409596j)*x[2]
            ref[1, 0, 0, 2]=(-0.380586719716+0.711357409596j)
            arg[1, 0, 1]+=(0.679482727426+0.336401813592j)*x[2]
            ref[1, 0, 1, 2]=(0.679482727426+0.336401813592j)
            arg[1, 0, 2]+=(-0.514885238635+0.625736379565j)*x[2]
            ref[1, 0, 2, 2]=(-0.514885238635+0.625736379565j)
            arg[1, 1, 0]+=(0.363968298936+0.486457523j)*x[2]
            ref[1, 1, 0, 2]=(0.363968298936+0.486457523j)
            arg[1, 1, 1]+=(-0.478305784334-0.735900001684j)*x[2]
            ref[1, 1, 1, 2]=(-0.478305784334-0.735900001684j)
            arg[1, 1, 2]+=(0.479864634057+0.826120969173j)*x[2]
            ref[1, 1, 2, 2]=(0.479864634057+0.826120969173j)
            arg[1, 2, 0]+=(0.503069580733+0.282854034338j)*x[2]
            ref[1, 2, 0, 2]=(0.503069580733+0.282854034338j)
            arg[1, 2, 1]+=(-0.151594408772+0.048468622358j)*x[2]
            ref[1, 2, 1, 2]=(-0.151594408772+0.048468622358j)
            arg[1, 2, 2]+=(-0.313028708038+0.104858611973j)*x[2]
            ref[1, 2, 2, 2]=(-0.313028708038+0.104858611973j)
            arg[1, 3, 0]+=(0.576636599364+0.993166426468j)*x[2]
            ref[1, 3, 0, 2]=(0.576636599364+0.993166426468j)
            arg[1, 3, 1]+=(-0.064315052257-0.14231271784j)*x[2]
            ref[1, 3, 1, 2]=(-0.064315052257-0.14231271784j)
            arg[1, 3, 2]+=(-0.302145930686+0.371553110768j)*x[2]
            ref[1, 3, 2, 2]=(-0.302145930686+0.371553110768j)
            arg[2, 0, 0]+=(-0.154677845742+0.669648343799j)*x[2]
            ref[2, 0, 0, 2]=(-0.154677845742+0.669648343799j)
            arg[2, 0, 1]+=(-0.716768047205-0.982041739027j)*x[2]
            ref[2, 0, 1, 2]=(-0.716768047205-0.982041739027j)
            arg[2, 0, 2]+=(-0.240334003123+0.614325961223j)*x[2]
            ref[2, 0, 2, 2]=(-0.240334003123+0.614325961223j)
            arg[2, 1, 0]+=(-0.704016662603-0.258980681807j)*x[2]
            ref[2, 1, 0, 2]=(-0.704016662603-0.258980681807j)
            arg[2, 1, 1]+=(0.602194587923+0.321396055263j)*x[2]
            ref[2, 1, 1, 2]=(0.602194587923+0.321396055263j)
            arg[2, 1, 2]+=(0.724907696828-0.587027142949j)*x[2]
            ref[2, 1, 2, 2]=(0.724907696828-0.587027142949j)
            arg[2, 2, 0]+=(-0.944243011751-0.341856062623j)*x[2]
            ref[2, 2, 0, 2]=(-0.944243011751-0.341856062623j)
            arg[2, 2, 1]+=(-0.568797984988+0.700960449507j)*x[2]
            ref[2, 2, 1, 2]=(-0.568797984988+0.700960449507j)
            arg[2, 2, 2]+=(-0.305211562296+0.934789115012j)*x[2]
            ref[2, 2, 2, 2]=(-0.305211562296+0.934789115012j)
            arg[2, 3, 0]+=(0.540472648256-0.243011824381j)*x[2]
            ref[2, 3, 0, 2]=(0.540472648256-0.243011824381j)
            arg[2, 3, 1]+=(-0.147192078451-0.717037848369j)*x[2]
            ref[2, 3, 1, 2]=(-0.147192078451-0.717037848369j)
            arg[2, 3, 2]+=(-0.312855297009-0.854214776132j)*x[2]
            ref[2, 3, 2, 2]=(-0.312855297009-0.854214776132j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3, 4, 3)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnContactZero_fromData_ReducedContinuousFunction_rank0(self):
        """
        tests gradient of rank 0 Data on FunctionOnContactZero

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on FunctionOnContactZero
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnContactZero(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=(0.663146636926-0.648679178189j)*x[0]+((0.931614880867+0.636616453321j))*x[1]
        ref[0]=(0.663146636926-0.648679178189j)
        ref[1]=(0.931614880867+0.636616453321j)
        if dim==3:
            arg+=((0.973004556098-0.837761416254j))*x[2]
            ref[2]=(0.973004556098-0.837761416254j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnContactZero_fromData_ReducedContinuousFunction_rank1(self):
        """
        tests gradient of rank 1 Data on FunctionOnContactZero

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on FunctionOnContactZero
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnContactZero(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(3,),w)
        ref = Data(0,(3,)+(dim,),w_ref)
        arg[0,]=(0.920060493066-0.288094807866j)*x[0]+((-0.64877519684+0.226538980166j))*x[1]
        ref[0, 0]=(0.920060493066-0.288094807866j)
        ref[0, 1]=(-0.64877519684+0.226538980166j)
        arg[1,]=(-0.517468847815-0.815399525512j)*x[0]+((0.670626650081-0.534114740539j))*x[1]
        ref[1, 0]=(-0.517468847815-0.815399525512j)
        ref[1, 1]=(0.670626650081-0.534114740539j)
        arg[2,]=(-0.897345376815+0.781568869652j)*x[0]+((0.790795232473-0.8065828475j))*x[1]
        ref[2, 0]=(-0.897345376815+0.781568869652j)
        ref[2, 1]=(0.790795232473-0.8065828475j)
        if dim==3:
            arg[0,]+=(-0.750192286387+0.53988353112j)*x[2]
            ref[0, 2]=(-0.750192286387+0.53988353112j)
            arg[1,]+=(0.737000239324+0.830274731899j)*x[2]
            ref[1, 2]=(0.737000239324+0.830274731899j)
            arg[2,]+=(0.198530934104-0.296502310841j)*x[2]
            ref[2, 2]=(0.198530934104-0.296502310841j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnContactZero_fromData_ReducedContinuousFunction_rank2(self):
        """
        tests gradient of rank 2 Data on FunctionOnContactZero

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on FunctionOnContactZero
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnContactZero(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(4, 2),w)
        ref = Data(0,(4, 2)+(dim,),w_ref)
        arg[0, 0]=(-0.591446576467-0.705556423428j)*x[0]+((-0.375690162551+0.0343451849027j))*x[1]
        ref[0, 0, 0]=(-0.591446576467-0.705556423428j)
        ref[0, 0, 1]=(-0.375690162551+0.0343451849027j)
        arg[0, 1]=(-0.933456326673-0.771724745114j)*x[0]+((-0.18641397473+0.0741459268436j))*x[1]
        ref[0, 1, 0]=(-0.933456326673-0.771724745114j)
        ref[0, 1, 1]=(-0.18641397473+0.0741459268436j)
        arg[1, 0]=(-0.585142723008+0.324861983966j)*x[0]+((-0.531023120964-0.00104070677075j))*x[1]
        ref[1, 0, 0]=(-0.585142723008+0.324861983966j)
        ref[1, 0, 1]=(-0.531023120964-0.00104070677075j)
        arg[1, 1]=(0.414565202503-0.450262051328j)*x[0]+((0.591460136191+0.857062484029j))*x[1]
        ref[1, 1, 0]=(0.414565202503-0.450262051328j)
        ref[1, 1, 1]=(0.591460136191+0.857062484029j)
        arg[2, 0]=(0.714623319235+0.619606727483j)*x[0]+((-0.0342879724767-0.646550047006j))*x[1]
        ref[2, 0, 0]=(0.714623319235+0.619606727483j)
        ref[2, 0, 1]=(-0.0342879724767-0.646550047006j)
        arg[2, 1]=(0.174607589535+0.242028024091j)*x[0]+((-0.252929222026+0.78432536967j))*x[1]
        ref[2, 1, 0]=(0.174607589535+0.242028024091j)
        ref[2, 1, 1]=(-0.252929222026+0.78432536967j)
        arg[3, 0]=(-0.820411609982-0.819609298324j)*x[0]+((-0.539839415378+0.727863780736j))*x[1]
        ref[3, 0, 0]=(-0.820411609982-0.819609298324j)
        ref[3, 0, 1]=(-0.539839415378+0.727863780736j)
        arg[3, 1]=(-0.839888499703-0.387836912586j)*x[0]+((-0.640267126087+0.0635376551479j))*x[1]
        ref[3, 1, 0]=(-0.839888499703-0.387836912586j)
        ref[3, 1, 1]=(-0.640267126087+0.0635376551479j)
        if dim==3:
            arg[0, 0]+=(-0.922875585514-0.210701222079j)*x[2]
            ref[0, 0, 2]=(-0.922875585514-0.210701222079j)
            arg[0, 1]+=(0.374374702689-0.683819765152j)*x[2]
            ref[0, 1, 2]=(0.374374702689-0.683819765152j)
            arg[1, 0]+=(-0.971209697816-0.976199973256j)*x[2]
            ref[1, 0, 2]=(-0.971209697816-0.976199973256j)
            arg[1, 1]+=(0.78206822081+0.760771549983j)*x[2]
            ref[1, 1, 2]=(0.78206822081+0.760771549983j)
            arg[2, 0]+=(-0.0284559468736+0.0195936549888j)*x[2]
            ref[2, 0, 2]=(-0.0284559468736+0.0195936549888j)
            arg[2, 1]+=(-0.601348031812+0.35397418517j)*x[2]
            ref[2, 1, 2]=(-0.601348031812+0.35397418517j)
            arg[3, 0]+=(-0.926369749401-0.252910743481j)*x[2]
            ref[3, 0, 2]=(-0.926369749401-0.252910743481j)
            arg[3, 1]+=(0.922867675282+0.507203850806j)*x[2]
            ref[3, 1, 2]=(0.922867675282+0.507203850806j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4, 2)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnContactZero_fromData_ReducedContinuousFunction_rank3(self):
        """
        tests gradient of rank 3 Data on FunctionOnContactZero

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on FunctionOnContactZero
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnContactZero(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(2, 3, 4),w)
        ref = Data(0,(2, 3, 4)+(dim,),w_ref)
        arg[0, 0, 0]=(0.33909434847+0.506258930659j)*x[0]+((0.990472263532+0.281182982789j))*x[1]
        ref[0, 0, 0, 0]=(0.33909434847+0.506258930659j)
        ref[0, 0, 0, 1]=(0.990472263532+0.281182982789j)
        arg[0, 0, 1]=(-0.130821750923+0.334653251274j)*x[0]+((0.74056221034+0.108168811583j))*x[1]
        ref[0, 0, 1, 0]=(-0.130821750923+0.334653251274j)
        ref[0, 0, 1, 1]=(0.74056221034+0.108168811583j)
        arg[0, 0, 2]=(-0.0162321613542-0.440014394139j)*x[0]+((0.514400786391+0.382876627733j))*x[1]
        ref[0, 0, 2, 0]=(-0.0162321613542-0.440014394139j)
        ref[0, 0, 2, 1]=(0.514400786391+0.382876627733j)
        arg[0, 0, 3]=(-0.164194327801+0.706200897477j)*x[0]+((-0.580280111466+0.520188117331j))*x[1]
        ref[0, 0, 3, 0]=(-0.164194327801+0.706200897477j)
        ref[0, 0, 3, 1]=(-0.580280111466+0.520188117331j)
        arg[0, 1, 0]=(0.731660521073+0.728581123973j)*x[0]+((0.0547142705663-0.446547943151j))*x[1]
        ref[0, 1, 0, 0]=(0.731660521073+0.728581123973j)
        ref[0, 1, 0, 1]=(0.0547142705663-0.446547943151j)
        arg[0, 1, 1]=(0.958439894575-0.731454884233j)*x[0]+((-0.925218362741-0.493574596704j))*x[1]
        ref[0, 1, 1, 0]=(0.958439894575-0.731454884233j)
        ref[0, 1, 1, 1]=(-0.925218362741-0.493574596704j)
        arg[0, 1, 2]=(-0.100939595788+0.579327374623j)*x[0]+((-0.691554392557+0.740606883177j))*x[1]
        ref[0, 1, 2, 0]=(-0.100939595788+0.579327374623j)
        ref[0, 1, 2, 1]=(-0.691554392557+0.740606883177j)
        arg[0, 1, 3]=(0.792215952561+0.719396260734j)*x[0]+((-0.275664010357+0.85545571528j))*x[1]
        ref[0, 1, 3, 0]=(0.792215952561+0.719396260734j)
        ref[0, 1, 3, 1]=(-0.275664010357+0.85545571528j)
        arg[0, 2, 0]=(-0.210351099617-0.587045477818j)*x[0]+((-0.559390482241+0.896635018111j))*x[1]
        ref[0, 2, 0, 0]=(-0.210351099617-0.587045477818j)
        ref[0, 2, 0, 1]=(-0.559390482241+0.896635018111j)
        arg[0, 2, 1]=(-0.397249750124-0.0518888515937j)*x[0]+((0.33834718774+0.593657335983j))*x[1]
        ref[0, 2, 1, 0]=(-0.397249750124-0.0518888515937j)
        ref[0, 2, 1, 1]=(0.33834718774+0.593657335983j)
        arg[0, 2, 2]=(-0.868526252058+0.521704001433j)*x[0]+((0.21032561413+0.796463676649j))*x[1]
        ref[0, 2, 2, 0]=(-0.868526252058+0.521704001433j)
        ref[0, 2, 2, 1]=(0.21032561413+0.796463676649j)
        arg[0, 2, 3]=(0.450823460186-0.272153689406j)*x[0]+((0.345070703495-0.33945383803j))*x[1]
        ref[0, 2, 3, 0]=(0.450823460186-0.272153689406j)
        ref[0, 2, 3, 1]=(0.345070703495-0.33945383803j)
        arg[1, 0, 0]=(0.306632488994+0.728234721458j)*x[0]+((0.507713109663+0.702903924014j))*x[1]
        ref[1, 0, 0, 0]=(0.306632488994+0.728234721458j)
        ref[1, 0, 0, 1]=(0.507713109663+0.702903924014j)
        arg[1, 0, 1]=(-0.929699104402-0.0496256665819j)*x[0]+((-0.139926873574-0.66415564908j))*x[1]
        ref[1, 0, 1, 0]=(-0.929699104402-0.0496256665819j)
        ref[1, 0, 1, 1]=(-0.139926873574-0.66415564908j)
        arg[1, 0, 2]=(0.429672985213-0.993792994164j)*x[0]+((0.413939864522+0.577952823355j))*x[1]
        ref[1, 0, 2, 0]=(0.429672985213-0.993792994164j)
        ref[1, 0, 2, 1]=(0.413939864522+0.577952823355j)
        arg[1, 0, 3]=(0.447583040887-0.0587186811174j)*x[0]+((-0.648549670302+0.282598356968j))*x[1]
        ref[1, 0, 3, 0]=(0.447583040887-0.0587186811174j)
        ref[1, 0, 3, 1]=(-0.648549670302+0.282598356968j)
        arg[1, 1, 0]=(0.562025643048-0.0468618265833j)*x[0]+((-0.719309004339+0.0895327314239j))*x[1]
        ref[1, 1, 0, 0]=(0.562025643048-0.0468618265833j)
        ref[1, 1, 0, 1]=(-0.719309004339+0.0895327314239j)
        arg[1, 1, 1]=(-0.88992939818+0.302926572182j)*x[0]+((0.385774361343+0.0221300326472j))*x[1]
        ref[1, 1, 1, 0]=(-0.88992939818+0.302926572182j)
        ref[1, 1, 1, 1]=(0.385774361343+0.0221300326472j)
        arg[1, 1, 2]=(0.123922876908+0.443041020971j)*x[0]+((0.450647375034-0.358660049594j))*x[1]
        ref[1, 1, 2, 0]=(0.123922876908+0.443041020971j)
        ref[1, 1, 2, 1]=(0.450647375034-0.358660049594j)
        arg[1, 1, 3]=(-0.735436699546-0.154480709119j)*x[0]+((0.139471875572-0.97031269531j))*x[1]
        ref[1, 1, 3, 0]=(-0.735436699546-0.154480709119j)
        ref[1, 1, 3, 1]=(0.139471875572-0.97031269531j)
        arg[1, 2, 0]=(-0.15552100075-0.426762344776j)*x[0]+((-0.124080654884-0.919255895233j))*x[1]
        ref[1, 2, 0, 0]=(-0.15552100075-0.426762344776j)
        ref[1, 2, 0, 1]=(-0.124080654884-0.919255895233j)
        arg[1, 2, 1]=(0.146829146375+0.908357506026j)*x[0]+((-0.118915589765-0.841141526958j))*x[1]
        ref[1, 2, 1, 0]=(0.146829146375+0.908357506026j)
        ref[1, 2, 1, 1]=(-0.118915589765-0.841141526958j)
        arg[1, 2, 2]=(-0.0733653924135+0.655059559238j)*x[0]+((-0.438492130872-0.0287702782709j))*x[1]
        ref[1, 2, 2, 0]=(-0.0733653924135+0.655059559238j)
        ref[1, 2, 2, 1]=(-0.438492130872-0.0287702782709j)
        arg[1, 2, 3]=(-0.806389948271+0.0701795789675j)*x[0]+((-0.0173474645732+0.42804891998j))*x[1]
        ref[1, 2, 3, 0]=(-0.806389948271+0.0701795789675j)
        ref[1, 2, 3, 1]=(-0.0173474645732+0.42804891998j)
        if dim==3:
            arg[0, 0, 0]+=(-0.517443070189+0.860870114139j)*x[2]
            ref[0, 0, 0, 2]=(-0.517443070189+0.860870114139j)
            arg[0, 0, 1]+=(0.758396798818-0.48229656983j)*x[2]
            ref[0, 0, 1, 2]=(0.758396798818-0.48229656983j)
            arg[0, 0, 2]+=(-0.799647839144-0.727812758634j)*x[2]
            ref[0, 0, 2, 2]=(-0.799647839144-0.727812758634j)
            arg[0, 0, 3]+=(0.685354292215+0.68563870371j)*x[2]
            ref[0, 0, 3, 2]=(0.685354292215+0.68563870371j)
            arg[0, 1, 0]+=(0.401369215416+0.861507686193j)*x[2]
            ref[0, 1, 0, 2]=(0.401369215416+0.861507686193j)
            arg[0, 1, 1]+=(-0.476395416284+0.769675166326j)*x[2]
            ref[0, 1, 1, 2]=(-0.476395416284+0.769675166326j)
            arg[0, 1, 2]+=(0.217650204876+0.927453570545j)*x[2]
            ref[0, 1, 2, 2]=(0.217650204876+0.927453570545j)
            arg[0, 1, 3]+=(-0.577358824963+0.976654134039j)*x[2]
            ref[0, 1, 3, 2]=(-0.577358824963+0.976654134039j)
            arg[0, 2, 0]+=(0.748406261341-0.089385323646j)*x[2]
            ref[0, 2, 0, 2]=(0.748406261341-0.089385323646j)
            arg[0, 2, 1]+=(-0.0507087425319-0.0189746015338j)*x[2]
            ref[0, 2, 1, 2]=(-0.0507087425319-0.0189746015338j)
            arg[0, 2, 2]+=(0.45003582344+0.306706846831j)*x[2]
            ref[0, 2, 2, 2]=(0.45003582344+0.306706846831j)
            arg[0, 2, 3]+=(-0.602485799943+0.40838158064j)*x[2]
            ref[0, 2, 3, 2]=(-0.602485799943+0.40838158064j)
            arg[1, 0, 0]+=(-0.498376035388-0.654425221426j)*x[2]
            ref[1, 0, 0, 2]=(-0.498376035388-0.654425221426j)
            arg[1, 0, 1]+=(-0.0174588162035+0.531557691361j)*x[2]
            ref[1, 0, 1, 2]=(-0.0174588162035+0.531557691361j)
            arg[1, 0, 2]+=(0.21805791368-0.119716794985j)*x[2]
            ref[1, 0, 2, 2]=(0.21805791368-0.119716794985j)
            arg[1, 0, 3]+=(-0.827996485141+0.86296500774j)*x[2]
            ref[1, 0, 3, 2]=(-0.827996485141+0.86296500774j)
            arg[1, 1, 0]+=(0.156971033508+0.471010279499j)*x[2]
            ref[1, 1, 0, 2]=(0.156971033508+0.471010279499j)
            arg[1, 1, 1]+=(-0.30823849674+0.0955259907658j)*x[2]
            ref[1, 1, 1, 2]=(-0.30823849674+0.0955259907658j)
            arg[1, 1, 2]+=(0.551105013885-0.413110484803j)*x[2]
            ref[1, 1, 2, 2]=(0.551105013885-0.413110484803j)
            arg[1, 1, 3]+=(-0.397348216786+0.960108548161j)*x[2]
            ref[1, 1, 3, 2]=(-0.397348216786+0.960108548161j)
            arg[1, 2, 0]+=(0.855644280728-0.436772406866j)*x[2]
            ref[1, 2, 0, 2]=(0.855644280728-0.436772406866j)
            arg[1, 2, 1]+=(-0.449732204088-0.71404899721j)*x[2]
            ref[1, 2, 1, 2]=(-0.449732204088-0.71404899721j)
            arg[1, 2, 2]+=(-0.2060747398+0.262595878902j)*x[2]
            ref[1, 2, 2, 2]=(-0.2060747398+0.262595878902j)
            arg[1, 2, 3]+=(-0.18146206035+0.9751930445j)*x[2]
            ref[1, 2, 3, 2]=(-0.18146206035+0.9751930445j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2, 3, 4)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnContactZero_fromData_ContinuousFunction_rank0(self):
        """
        tests gradient of rank 0 Data on ReducedFunctionOnContactZero

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnContactZero
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnContactZero(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=(-0.331710936653+0.822427080856j)*x[0]**o+((0.0400204558133-0.713282211845j))*x[0]+((0.777891791565+0.111009967605j))*x[1]**o+((-0.656378590107+0.575005104886j))*x[1]
        ref[0]=(-0.331710936653+0.822427080856j)*o*x_ref[0]**(o-1)+((0.0400204558133-0.713282211845j))
        ref[1]=(0.777891791565+0.111009967605j)*o*x_ref[1]**(o-1)+((-0.656378590107+0.575005104886j))
        if dim==3:
            arg+=((-0.302576432199-0.219479242929j))*x[2]**o+((0.765376145821+0.863429069356j))*x[2]
            ref[2]=(-0.302576432199-0.219479242929j)*o*x_ref[2]**(o-1)+((0.765376145821+0.863429069356j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnContactZero_fromData_ContinuousFunction_rank1(self):
        """
        tests gradient of rank 1 Data on ReducedFunctionOnContactZero

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnContactZero
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnContactZero(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(4,),w)
        ref = Data(0,(4,)+(dim,),w_ref)
        arg[0,]=(0.607225442216+0.159319850706j)*x[0]**o+((-0.439732598084+0.329495521018j))*x[0]+((-0.691426718532+0.605431464025j))*x[1]**o+((0.179543323189+0.49405457044j))*x[1]
        ref[0, 0]=(0.607225442216+0.159319850706j)*o*x_ref[0]**(o-1)+((-0.439732598084+0.329495521018j))
        ref[0, 1]=(-0.691426718532+0.605431464025j)*o*x_ref[1]**(o-1)+((0.179543323189+0.49405457044j))
        arg[1,]=(0.0476503398076+0.919060670648j)*x[0]**o+((-0.701406421084+0.494768491994j))*x[0]+((0.033810605187+0.904512743954j))*x[1]**o+((-0.606676771196-0.370960718484j))*x[1]
        ref[1, 0]=(0.0476503398076+0.919060670648j)*o*x_ref[0]**(o-1)+((-0.701406421084+0.494768491994j))
        ref[1, 1]=(0.033810605187+0.904512743954j)*o*x_ref[1]**(o-1)+((-0.606676771196-0.370960718484j))
        arg[2,]=(0.756944662358+0.820597232321j)*x[0]**o+((0.956837370192-0.812081978247j))*x[0]+((0.642242933272-0.644438491296j))*x[1]**o+((0.959102228084+0.136671714665j))*x[1]
        ref[2, 0]=(0.756944662358+0.820597232321j)*o*x_ref[0]**(o-1)+((0.956837370192-0.812081978247j))
        ref[2, 1]=(0.642242933272-0.644438491296j)*o*x_ref[1]**(o-1)+((0.959102228084+0.136671714665j))
        arg[3,]=(-0.952165818298-0.925992329284j)*x[0]**o+((0.38541285164-0.546411541135j))*x[0]+((-0.553810960369+0.80076433806j))*x[1]**o+((0.258270473756+0.979471172052j))*x[1]
        ref[3, 0]=(-0.952165818298-0.925992329284j)*o*x_ref[0]**(o-1)+((0.38541285164-0.546411541135j))
        ref[3, 1]=(-0.553810960369+0.80076433806j)*o*x_ref[1]**(o-1)+((0.258270473756+0.979471172052j))
        if dim==3:
            arg[0,]+=(0.709404696707-0.51593350297j)*x[2]**o+((-0.851597364136-0.0369980930476j))*x[2]
            ref[0, 2]=(0.709404696707-0.51593350297j)*o*x_ref[2]**(o-1)+((-0.851597364136-0.0369980930476j))
            arg[1,]+=(0.0700081424002+0.0822827372477j)*x[2]**o+((0.672290757443+0.813448998497j))*x[2]
            ref[1, 2]=(0.0700081424002+0.0822827372477j)*o*x_ref[2]**(o-1)+((0.672290757443+0.813448998497j))
            arg[2,]+=(0.7121418205-0.841874772663j)*x[2]**o+((-0.446117428639-0.0289404617841j))*x[2]
            ref[2, 2]=(0.7121418205-0.841874772663j)*o*x_ref[2]**(o-1)+((-0.446117428639-0.0289404617841j))
            arg[3,]+=(-0.259549626251+0.5941670264j)*x[2]**o+((-0.0145534833194+0.828007341432j))*x[2]
            ref[3, 2]=(-0.259549626251+0.5941670264j)*o*x_ref[2]**(o-1)+((-0.0145534833194+0.828007341432j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnContactZero_fromData_ContinuousFunction_rank2(self):
        """
        tests gradient of rank 2 Data on ReducedFunctionOnContactZero

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnContactZero
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnContactZero(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(2, 3),w)
        ref = Data(0,(2, 3)+(dim,),w_ref)
        arg[0, 0]=(0.409382603363+0.736613257269j)*x[0]**o+((-0.451454054703-0.880504202393j))*x[0]+((0.5460458537-0.0663609825575j))*x[1]**o+((0.968403629974-0.486114105275j))*x[1]
        ref[0, 0, 0]=(0.409382603363+0.736613257269j)*o*x_ref[0]**(o-1)+((-0.451454054703-0.880504202393j))
        ref[0, 0, 1]=(0.5460458537-0.0663609825575j)*o*x_ref[1]**(o-1)+((0.968403629974-0.486114105275j))
        arg[0, 1]=(-0.208126588683+0.81594032232j)*x[0]**o+((0.560625472786-0.456798473946j))*x[0]+((0.226947355927+0.0729145311672j))*x[1]**o+((0.297008821206+0.774443236204j))*x[1]
        ref[0, 1, 0]=(-0.208126588683+0.81594032232j)*o*x_ref[0]**(o-1)+((0.560625472786-0.456798473946j))
        ref[0, 1, 1]=(0.226947355927+0.0729145311672j)*o*x_ref[1]**(o-1)+((0.297008821206+0.774443236204j))
        arg[0, 2]=(-0.179308188955-0.787143249071j)*x[0]**o+((-0.271717146134+0.715296479036j))*x[0]+((-0.881042852416-0.712038467582j))*x[1]**o+((-0.980243385781+0.538764164872j))*x[1]
        ref[0, 2, 0]=(-0.179308188955-0.787143249071j)*o*x_ref[0]**(o-1)+((-0.271717146134+0.715296479036j))
        ref[0, 2, 1]=(-0.881042852416-0.712038467582j)*o*x_ref[1]**(o-1)+((-0.980243385781+0.538764164872j))
        arg[1, 0]=(0.01657119637+0.405615771267j)*x[0]**o+((-0.736361306918-0.385731714218j))*x[0]+((-0.694578945904-0.796933402623j))*x[1]**o+((-0.0789581468245+0.0520250748905j))*x[1]
        ref[1, 0, 0]=(0.01657119637+0.405615771267j)*o*x_ref[0]**(o-1)+((-0.736361306918-0.385731714218j))
        ref[1, 0, 1]=(-0.694578945904-0.796933402623j)*o*x_ref[1]**(o-1)+((-0.0789581468245+0.0520250748905j))
        arg[1, 1]=(0.443624482941-0.608816147782j)*x[0]**o+((-0.571672471999-0.343645012103j))*x[0]+((0.717828711558+0.909336773897j))*x[1]**o+((0.815981773473+0.961200965236j))*x[1]
        ref[1, 1, 0]=(0.443624482941-0.608816147782j)*o*x_ref[0]**(o-1)+((-0.571672471999-0.343645012103j))
        ref[1, 1, 1]=(0.717828711558+0.909336773897j)*o*x_ref[1]**(o-1)+((0.815981773473+0.961200965236j))
        arg[1, 2]=(-0.407469598213+0.510670400505j)*x[0]**o+((0.648594723178+0.390343792448j))*x[0]+((0.771589847626+0.918519939203j))*x[1]**o+((0.127215005526-0.3944311563j))*x[1]
        ref[1, 2, 0]=(-0.407469598213+0.510670400505j)*o*x_ref[0]**(o-1)+((0.648594723178+0.390343792448j))
        ref[1, 2, 1]=(0.771589847626+0.918519939203j)*o*x_ref[1]**(o-1)+((0.127215005526-0.3944311563j))
        if dim==3:
            arg[0, 0]+=(-0.720976149435-0.161401447998j)*x[2]**o+((-0.395901432905-0.244188695281j))*x[2]
            ref[0, 0, 2]=(-0.720976149435-0.161401447998j)*o*x_ref[2]**(o-1)+((-0.395901432905-0.244188695281j))
            arg[0, 1]+=(-0.0292490505004-0.507058115346j)*x[2]**o+((-0.672035182145-0.635462675431j))*x[2]
            ref[0, 1, 2]=(-0.0292490505004-0.507058115346j)*o*x_ref[2]**(o-1)+((-0.672035182145-0.635462675431j))
            arg[0, 2]+=(-0.607227652901-0.225509432871j)*x[2]**o+((-0.865796898419+0.611923775415j))*x[2]
            ref[0, 2, 2]=(-0.607227652901-0.225509432871j)*o*x_ref[2]**(o-1)+((-0.865796898419+0.611923775415j))
            arg[1, 0]+=(0.640318168685+0.164532619241j)*x[2]**o+((-0.96561053301-0.656587424001j))*x[2]
            ref[1, 0, 2]=(0.640318168685+0.164532619241j)*o*x_ref[2]**(o-1)+((-0.96561053301-0.656587424001j))
            arg[1, 1]+=(-0.143218339472-0.656085842423j)*x[2]**o+((0.972566330107-0.0358928508718j))*x[2]
            ref[1, 1, 2]=(-0.143218339472-0.656085842423j)*o*x_ref[2]**(o-1)+((0.972566330107-0.0358928508718j))
            arg[1, 2]+=(-0.878426386407-0.503389260968j)*x[2]**o+((0.983216777667-0.0718699635764j))*x[2]
            ref[1, 2, 2]=(-0.878426386407-0.503389260968j)*o*x_ref[2]**(o-1)+((0.983216777667-0.0718699635764j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2, 3)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnContactZero_fromData_ContinuousFunction_rank3(self):
        """
        tests gradient of rank 3 Data on ReducedFunctionOnContactZero

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnContactZero
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnContactZero(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(3, 2, 3),w)
        ref = Data(0,(3, 2, 3)+(dim,),w_ref)
        arg[0, 0, 0]=(0.705302468295-0.876674765423j)*x[0]**o+((0.233334949318-0.899742253597j))*x[0]+((0.600274057784-0.413396441591j))*x[1]**o+((0.225514684389-0.405181783528j))*x[1]
        ref[0, 0, 0, 0]=(0.705302468295-0.876674765423j)*o*x_ref[0]**(o-1)+((0.233334949318-0.899742253597j))
        ref[0, 0, 0, 1]=(0.600274057784-0.413396441591j)*o*x_ref[1]**(o-1)+((0.225514684389-0.405181783528j))
        arg[0, 0, 1]=(-0.982546683311-0.354515518737j)*x[0]**o+((0.76901397349+0.437597251828j))*x[0]+((-0.702497689145-0.372820091257j))*x[1]**o+((-0.832996300363-0.196444254707j))*x[1]
        ref[0, 0, 1, 0]=(-0.982546683311-0.354515518737j)*o*x_ref[0]**(o-1)+((0.76901397349+0.437597251828j))
        ref[0, 0, 1, 1]=(-0.702497689145-0.372820091257j)*o*x_ref[1]**(o-1)+((-0.832996300363-0.196444254707j))
        arg[0, 0, 2]=(0.24518188859-0.238596936834j)*x[0]**o+((-0.895961233659+0.139767316211j))*x[0]+((-0.526533175438+0.444561071796j))*x[1]**o+((-0.633287586945+0.075028643707j))*x[1]
        ref[0, 0, 2, 0]=(0.24518188859-0.238596936834j)*o*x_ref[0]**(o-1)+((-0.895961233659+0.139767316211j))
        ref[0, 0, 2, 1]=(-0.526533175438+0.444561071796j)*o*x_ref[1]**(o-1)+((-0.633287586945+0.075028643707j))
        arg[0, 1, 0]=(0.797473589289-0.680314142417j)*x[0]**o+((0.0475109207052-0.385164353755j))*x[0]+((-0.938954854371+0.6243995758j))*x[1]**o+((-0.349599827093+0.374506886702j))*x[1]
        ref[0, 1, 0, 0]=(0.797473589289-0.680314142417j)*o*x_ref[0]**(o-1)+((0.0475109207052-0.385164353755j))
        ref[0, 1, 0, 1]=(-0.938954854371+0.6243995758j)*o*x_ref[1]**(o-1)+((-0.349599827093+0.374506886702j))
        arg[0, 1, 1]=(0.622643747609+0.156595625229j)*x[0]**o+((0.994204587757+0.629841995301j))*x[0]+((-0.947960826902-0.823761812059j))*x[1]**o+((-0.185337223233+0.838270962832j))*x[1]
        ref[0, 1, 1, 0]=(0.622643747609+0.156595625229j)*o*x_ref[0]**(o-1)+((0.994204587757+0.629841995301j))
        ref[0, 1, 1, 1]=(-0.947960826902-0.823761812059j)*o*x_ref[1]**(o-1)+((-0.185337223233+0.838270962832j))
        arg[0, 1, 2]=(-0.110487283359+0.213852025878j)*x[0]**o+((0.522270903318-0.444187827709j))*x[0]+((0.145419584083-0.281684914289j))*x[1]**o+((-0.338829599954+0.535719461491j))*x[1]
        ref[0, 1, 2, 0]=(-0.110487283359+0.213852025878j)*o*x_ref[0]**(o-1)+((0.522270903318-0.444187827709j))
        ref[0, 1, 2, 1]=(0.145419584083-0.281684914289j)*o*x_ref[1]**(o-1)+((-0.338829599954+0.535719461491j))
        arg[1, 0, 0]=(0.0667804345299-0.459198877792j)*x[0]**o+((-0.258829465584+0.470348226519j))*x[0]+((0.0218513356933+0.329416401216j))*x[1]**o+((0.234038897453-0.335130297593j))*x[1]
        ref[1, 0, 0, 0]=(0.0667804345299-0.459198877792j)*o*x_ref[0]**(o-1)+((-0.258829465584+0.470348226519j))
        ref[1, 0, 0, 1]=(0.0218513356933+0.329416401216j)*o*x_ref[1]**(o-1)+((0.234038897453-0.335130297593j))
        arg[1, 0, 1]=(0.263676890936-0.795317647425j)*x[0]**o+((0.0114032068696+0.899155756416j))*x[0]+((-0.376332659612+0.426914123932j))*x[1]**o+((0.897727160832+0.905454471992j))*x[1]
        ref[1, 0, 1, 0]=(0.263676890936-0.795317647425j)*o*x_ref[0]**(o-1)+((0.0114032068696+0.899155756416j))
        ref[1, 0, 1, 1]=(-0.376332659612+0.426914123932j)*o*x_ref[1]**(o-1)+((0.897727160832+0.905454471992j))
        arg[1, 0, 2]=(-0.641151959273+0.648360393184j)*x[0]**o+((0.673559843251+0.926251381774j))*x[0]+((0.913863440616+0.0152024594711j))*x[1]**o+((0.671168037555+0.394462846037j))*x[1]
        ref[1, 0, 2, 0]=(-0.641151959273+0.648360393184j)*o*x_ref[0]**(o-1)+((0.673559843251+0.926251381774j))
        ref[1, 0, 2, 1]=(0.913863440616+0.0152024594711j)*o*x_ref[1]**(o-1)+((0.671168037555+0.394462846037j))
        arg[1, 1, 0]=(-0.742540333791+0.836237975294j)*x[0]**o+((0.242045543057+0.0952748018478j))*x[0]+((-0.497056772179+0.279707447749j))*x[1]**o+((-0.21860945138-0.266765722912j))*x[1]
        ref[1, 1, 0, 0]=(-0.742540333791+0.836237975294j)*o*x_ref[0]**(o-1)+((0.242045543057+0.0952748018478j))
        ref[1, 1, 0, 1]=(-0.497056772179+0.279707447749j)*o*x_ref[1]**(o-1)+((-0.21860945138-0.266765722912j))
        arg[1, 1, 1]=(-0.0788597239944+0.812698744368j)*x[0]**o+((0.982958760056-0.890797218086j))*x[0]+((0.0394666580418-0.26989768447j))*x[1]**o+((0.381641750559+0.630655036417j))*x[1]
        ref[1, 1, 1, 0]=(-0.0788597239944+0.812698744368j)*o*x_ref[0]**(o-1)+((0.982958760056-0.890797218086j))
        ref[1, 1, 1, 1]=(0.0394666580418-0.26989768447j)*o*x_ref[1]**(o-1)+((0.381641750559+0.630655036417j))
        arg[1, 1, 2]=(0.0333894021927+0.667001526233j)*x[0]**o+((0.673373759092-0.611051378334j))*x[0]+((0.204845136841-0.172098183003j))*x[1]**o+((0.468453023413+0.381339712256j))*x[1]
        ref[1, 1, 2, 0]=(0.0333894021927+0.667001526233j)*o*x_ref[0]**(o-1)+((0.673373759092-0.611051378334j))
        ref[1, 1, 2, 1]=(0.204845136841-0.172098183003j)*o*x_ref[1]**(o-1)+((0.468453023413+0.381339712256j))
        arg[2, 0, 0]=(-0.786350784977-0.67929682892j)*x[0]**o+((0.515280905572+0.0984575492047j))*x[0]+((0.306329586324+0.390136186199j))*x[1]**o+((0.535243423828-0.675126648992j))*x[1]
        ref[2, 0, 0, 0]=(-0.786350784977-0.67929682892j)*o*x_ref[0]**(o-1)+((0.515280905572+0.0984575492047j))
        ref[2, 0, 0, 1]=(0.306329586324+0.390136186199j)*o*x_ref[1]**(o-1)+((0.535243423828-0.675126648992j))
        arg[2, 0, 1]=(-0.983855733476+0.221004090867j)*x[0]**o+((-0.35653689231-0.488198161593j))*x[0]+((0.782382354629+0.593095880452j))*x[1]**o+((-0.428950888629+0.720340853513j))*x[1]
        ref[2, 0, 1, 0]=(-0.983855733476+0.221004090867j)*o*x_ref[0]**(o-1)+((-0.35653689231-0.488198161593j))
        ref[2, 0, 1, 1]=(0.782382354629+0.593095880452j)*o*x_ref[1]**(o-1)+((-0.428950888629+0.720340853513j))
        arg[2, 0, 2]=(-0.753989380251-0.821820019836j)*x[0]**o+((-0.625234091527+0.594203692822j))*x[0]+((0.229422586327+0.875204143166j))*x[1]**o+((0.91576408018+0.0196348080783j))*x[1]
        ref[2, 0, 2, 0]=(-0.753989380251-0.821820019836j)*o*x_ref[0]**(o-1)+((-0.625234091527+0.594203692822j))
        ref[2, 0, 2, 1]=(0.229422586327+0.875204143166j)*o*x_ref[1]**(o-1)+((0.91576408018+0.0196348080783j))
        arg[2, 1, 0]=(0.476210728295-0.536242092762j)*x[0]**o+((0.794925396016-0.764459687073j))*x[0]+((-0.445932394509-0.905143242316j))*x[1]**o+((0.614347996325-0.741626998286j))*x[1]
        ref[2, 1, 0, 0]=(0.476210728295-0.536242092762j)*o*x_ref[0]**(o-1)+((0.794925396016-0.764459687073j))
        ref[2, 1, 0, 1]=(-0.445932394509-0.905143242316j)*o*x_ref[1]**(o-1)+((0.614347996325-0.741626998286j))
        arg[2, 1, 1]=(0.0394952793542+0.287944119559j)*x[0]**o+((-0.84334413738-0.478865488756j))*x[0]+((0.509207703561-0.691216613644j))*x[1]**o+((-0.797283078322+0.4855800865j))*x[1]
        ref[2, 1, 1, 0]=(0.0394952793542+0.287944119559j)*o*x_ref[0]**(o-1)+((-0.84334413738-0.478865488756j))
        ref[2, 1, 1, 1]=(0.509207703561-0.691216613644j)*o*x_ref[1]**(o-1)+((-0.797283078322+0.4855800865j))
        arg[2, 1, 2]=(-0.402621740918+0.393093085951j)*x[0]**o+((0.523487832582+0.993591476915j))*x[0]+((-0.161023989087-0.768350278039j))*x[1]**o+((0.529090187802+0.992733449639j))*x[1]
        ref[2, 1, 2, 0]=(-0.402621740918+0.393093085951j)*o*x_ref[0]**(o-1)+((0.523487832582+0.993591476915j))
        ref[2, 1, 2, 1]=(-0.161023989087-0.768350278039j)*o*x_ref[1]**(o-1)+((0.529090187802+0.992733449639j))
        if dim==3:
            arg[0, 0, 0]+=(0.400208463684+0.709775519869j)*x[2]**o+((0.738741613457+0.251548310664j))*x[2]
            ref[0, 0, 0, 2]=(0.400208463684+0.709775519869j)*o*x_ref[2]**(o-1)+((0.738741613457+0.251548310664j))
            arg[0, 0, 1]+=(0.921766408457-0.57384133045j)*x[2]**o+((-0.376368396374+0.729311642003j))*x[2]
            ref[0, 0, 1, 2]=(0.921766408457-0.57384133045j)*o*x_ref[2]**(o-1)+((-0.376368396374+0.729311642003j))
            arg[0, 0, 2]+=(0.62434867216-0.662476092487j)*x[2]**o+((0.281817578275-0.36329916185j))*x[2]
            ref[0, 0, 2, 2]=(0.62434867216-0.662476092487j)*o*x_ref[2]**(o-1)+((0.281817578275-0.36329916185j))
            arg[0, 1, 0]+=(-0.178576780861+0.511249640663j)*x[2]**o+((-0.773371661952+0.279333514687j))*x[2]
            ref[0, 1, 0, 2]=(-0.178576780861+0.511249640663j)*o*x_ref[2]**(o-1)+((-0.773371661952+0.279333514687j))
            arg[0, 1, 1]+=(0.316027039775+0.836800828103j)*x[2]**o+((0.498393246078-0.805669740312j))*x[2]
            ref[0, 1, 1, 2]=(0.316027039775+0.836800828103j)*o*x_ref[2]**(o-1)+((0.498393246078-0.805669740312j))
            arg[0, 1, 2]+=(0.257652873774-0.416882660503j)*x[2]**o+((0.267395038533-0.346441532407j))*x[2]
            ref[0, 1, 2, 2]=(0.257652873774-0.416882660503j)*o*x_ref[2]**(o-1)+((0.267395038533-0.346441532407j))
            arg[1, 0, 0]+=(-0.258200376682+0.412838221367j)*x[2]**o+((0.625412442992-0.68524085424j))*x[2]
            ref[1, 0, 0, 2]=(-0.258200376682+0.412838221367j)*o*x_ref[2]**(o-1)+((0.625412442992-0.68524085424j))
            arg[1, 0, 1]+=(0.0149634519184+0.0957410439427j)*x[2]**o+((0.911939144601+0.719024796568j))*x[2]
            ref[1, 0, 1, 2]=(0.0149634519184+0.0957410439427j)*o*x_ref[2]**(o-1)+((0.911939144601+0.719024796568j))
            arg[1, 0, 2]+=(-0.95580220336+0.577524062531j)*x[2]**o+((-0.285162814521+0.636484347897j))*x[2]
            ref[1, 0, 2, 2]=(-0.95580220336+0.577524062531j)*o*x_ref[2]**(o-1)+((-0.285162814521+0.636484347897j))
            arg[1, 1, 0]+=(0.856438745698-0.888074095231j)*x[2]**o+((-0.391010650485-0.856536736074j))*x[2]
            ref[1, 1, 0, 2]=(0.856438745698-0.888074095231j)*o*x_ref[2]**(o-1)+((-0.391010650485-0.856536736074j))
            arg[1, 1, 1]+=(0.927854033875-0.404762152916j)*x[2]**o+((0.871918714414-0.800705978002j))*x[2]
            ref[1, 1, 1, 2]=(0.927854033875-0.404762152916j)*o*x_ref[2]**(o-1)+((0.871918714414-0.800705978002j))
            arg[1, 1, 2]+=(0.658072941929-0.0644303603602j)*x[2]**o+((0.156003941246+0.0392777846643j))*x[2]
            ref[1, 1, 2, 2]=(0.658072941929-0.0644303603602j)*o*x_ref[2]**(o-1)+((0.156003941246+0.0392777846643j))
            arg[2, 0, 0]+=(-0.829447839444-0.183216704967j)*x[2]**o+((0.0943520373067-0.0409974564804j))*x[2]
            ref[2, 0, 0, 2]=(-0.829447839444-0.183216704967j)*o*x_ref[2]**(o-1)+((0.0943520373067-0.0409974564804j))
            arg[2, 0, 1]+=(-0.211745356064-0.947876049423j)*x[2]**o+((0.531587835451-0.0106212185956j))*x[2]
            ref[2, 0, 1, 2]=(-0.211745356064-0.947876049423j)*o*x_ref[2]**(o-1)+((0.531587835451-0.0106212185956j))
            arg[2, 0, 2]+=(0.350800705664+0.229779355585j)*x[2]**o+((-0.996356077741-0.20549045699j))*x[2]
            ref[2, 0, 2, 2]=(0.350800705664+0.229779355585j)*o*x_ref[2]**(o-1)+((-0.996356077741-0.20549045699j))
            arg[2, 1, 0]+=(0.780816204981-0.100038007735j)*x[2]**o+((-0.89434413395-0.292258050324j))*x[2]
            ref[2, 1, 0, 2]=(0.780816204981-0.100038007735j)*o*x_ref[2]**(o-1)+((-0.89434413395-0.292258050324j))
            arg[2, 1, 1]+=(-0.749563545119+0.960626807741j)*x[2]**o+((0.538319830239+0.273493699154j))*x[2]
            ref[2, 1, 1, 2]=(-0.749563545119+0.960626807741j)*o*x_ref[2]**(o-1)+((0.538319830239+0.273493699154j))
            arg[2, 1, 2]+=(0.372202207971-0.867254836776j)*x[2]**o+((-0.632095906131-0.292481731548j))*x[2]
            ref[2, 1, 2, 2]=(0.372202207971-0.867254836776j)*o*x_ref[2]**(o-1)+((-0.632095906131-0.292481731548j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3, 2, 3)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnContactZero_fromData_Solution_rank0(self):
        """
        tests gradient of rank 0 Data on ReducedFunctionOnContactZero

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnContactZero
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnContactZero(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=(0.221945822089+0.21236081892j)*x[0]**o+((-0.0939887115211-0.0940417697508j))*x[0]+((0.57412600241-0.804626451041j))*x[1]**o+((-0.960690342726+0.494489697187j))*x[1]
        ref[0]=(0.221945822089+0.21236081892j)*o*x_ref[0]**(o-1)+((-0.0939887115211-0.0940417697508j))
        ref[1]=(0.57412600241-0.804626451041j)*o*x_ref[1]**(o-1)+((-0.960690342726+0.494489697187j))
        if dim==3:
            arg+=((-0.775650978247-0.660549912188j))*x[2]**o+((-0.899227248955+0.372392411639j))*x[2]
            ref[2]=(-0.775650978247-0.660549912188j)*o*x_ref[2]**(o-1)+((-0.899227248955+0.372392411639j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnContactZero_fromData_Solution_rank1(self):
        """
        tests gradient of rank 1 Data on ReducedFunctionOnContactZero

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnContactZero
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnContactZero(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(3,),w)
        ref = Data(0,(3,)+(dim,),w_ref)
        arg[0,]=(-0.0450204740836+0.677225958527j)*x[0]**o+((-0.781113982314+0.460942951561j))*x[0]+((-0.529428466425-0.578355030336j))*x[1]**o+((0.523179853195-0.477055504077j))*x[1]
        ref[0, 0]=(-0.0450204740836+0.677225958527j)*o*x_ref[0]**(o-1)+((-0.781113982314+0.460942951561j))
        ref[0, 1]=(-0.529428466425-0.578355030336j)*o*x_ref[1]**(o-1)+((0.523179853195-0.477055504077j))
        arg[1,]=(-0.0666004928494-0.752313123492j)*x[0]**o+((-0.937533024753-0.258743862902j))*x[0]+((-0.481063871391+0.562178043992j))*x[1]**o+((-0.93655466245-0.142194520644j))*x[1]
        ref[1, 0]=(-0.0666004928494-0.752313123492j)*o*x_ref[0]**(o-1)+((-0.937533024753-0.258743862902j))
        ref[1, 1]=(-0.481063871391+0.562178043992j)*o*x_ref[1]**(o-1)+((-0.93655466245-0.142194520644j))
        arg[2,]=(-0.636706112693-0.63915204177j)*x[0]**o+((0.464435576488+0.0638923664866j))*x[0]+((0.717897949907-0.148781200253j))*x[1]**o+((0.711072278338-0.876161130254j))*x[1]
        ref[2, 0]=(-0.636706112693-0.63915204177j)*o*x_ref[0]**(o-1)+((0.464435576488+0.0638923664866j))
        ref[2, 1]=(0.717897949907-0.148781200253j)*o*x_ref[1]**(o-1)+((0.711072278338-0.876161130254j))
        if dim==3:
            arg[0,]+=(0.642031957937+0.282329285385j)*x[2]**o+((-0.250380768279+0.797471479027j))*x[2]
            ref[0, 2]=(0.642031957937+0.282329285385j)*o*x_ref[2]**(o-1)+((-0.250380768279+0.797471479027j))
            arg[1,]+=(0.659199107336+0.827137371477j)*x[2]**o+((-0.273163514387-0.580247002328j))*x[2]
            ref[1, 2]=(0.659199107336+0.827137371477j)*o*x_ref[2]**(o-1)+((-0.273163514387-0.580247002328j))
            arg[2,]+=(0.749703916389-0.254265103342j)*x[2]**o+((0.0608617223402+0.0740725306816j))*x[2]
            ref[2, 2]=(0.749703916389-0.254265103342j)*o*x_ref[2]**(o-1)+((0.0608617223402+0.0740725306816j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnContactZero_fromData_Solution_rank2(self):
        """
        tests gradient of rank 2 Data on ReducedFunctionOnContactZero

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnContactZero
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnContactZero(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(4, 2),w)
        ref = Data(0,(4, 2)+(dim,),w_ref)
        arg[0, 0]=(0.470861832989+0.907503919912j)*x[0]**o+((0.594875658934+0.620355031009j))*x[0]+((-0.319618778117+0.200959409122j))*x[1]**o+((-0.0996820157805+0.0485612580191j))*x[1]
        ref[0, 0, 0]=(0.470861832989+0.907503919912j)*o*x_ref[0]**(o-1)+((0.594875658934+0.620355031009j))
        ref[0, 0, 1]=(-0.319618778117+0.200959409122j)*o*x_ref[1]**(o-1)+((-0.0996820157805+0.0485612580191j))
        arg[0, 1]=(-0.663867463948+0.322417115447j)*x[0]**o+((-0.311816597718+0.561014077066j))*x[0]+((0.71606193654+0.0296531889368j))*x[1]**o+((0.620743338912-0.917401858103j))*x[1]
        ref[0, 1, 0]=(-0.663867463948+0.322417115447j)*o*x_ref[0]**(o-1)+((-0.311816597718+0.561014077066j))
        ref[0, 1, 1]=(0.71606193654+0.0296531889368j)*o*x_ref[1]**(o-1)+((0.620743338912-0.917401858103j))
        arg[1, 0]=(-0.0076100790045-0.462704346756j)*x[0]**o+((-0.0595890896785-0.988588334125j))*x[0]+((-0.47147711373+0.628198574473j))*x[1]**o+((-0.262378906169+0.751023748957j))*x[1]
        ref[1, 0, 0]=(-0.0076100790045-0.462704346756j)*o*x_ref[0]**(o-1)+((-0.0595890896785-0.988588334125j))
        ref[1, 0, 1]=(-0.47147711373+0.628198574473j)*o*x_ref[1]**(o-1)+((-0.262378906169+0.751023748957j))
        arg[1, 1]=(0.323900198194+0.423693958027j)*x[0]**o+((0.81789464547+0.00210023045087j))*x[0]+((0.831863740962-0.238682945168j))*x[1]**o+((0.876035924169-0.0103590576138j))*x[1]
        ref[1, 1, 0]=(0.323900198194+0.423693958027j)*o*x_ref[0]**(o-1)+((0.81789464547+0.00210023045087j))
        ref[1, 1, 1]=(0.831863740962-0.238682945168j)*o*x_ref[1]**(o-1)+((0.876035924169-0.0103590576138j))
        arg[2, 0]=(0.81349854136+0.376907589411j)*x[0]**o+((0.0078801343041-0.129802085006j))*x[0]+((-0.37765270235+0.768628751704j))*x[1]**o+((0.37207833379-0.0299555565605j))*x[1]
        ref[2, 0, 0]=(0.81349854136+0.376907589411j)*o*x_ref[0]**(o-1)+((0.0078801343041-0.129802085006j))
        ref[2, 0, 1]=(-0.37765270235+0.768628751704j)*o*x_ref[1]**(o-1)+((0.37207833379-0.0299555565605j))
        arg[2, 1]=(0.596947083915-0.412634282571j)*x[0]**o+((0.0594626901762+0.390027689389j))*x[0]+((0.743256659229+0.818553346508j))*x[1]**o+((-0.903375769284+0.456110995155j))*x[1]
        ref[2, 1, 0]=(0.596947083915-0.412634282571j)*o*x_ref[0]**(o-1)+((0.0594626901762+0.390027689389j))
        ref[2, 1, 1]=(0.743256659229+0.818553346508j)*o*x_ref[1]**(o-1)+((-0.903375769284+0.456110995155j))
        arg[3, 0]=(-0.633357827137+0.718277415184j)*x[0]**o+((0.188983560641+0.612320487682j))*x[0]+((0.836147116678-0.519870652314j))*x[1]**o+((-0.38378258798-0.259634910553j))*x[1]
        ref[3, 0, 0]=(-0.633357827137+0.718277415184j)*o*x_ref[0]**(o-1)+((0.188983560641+0.612320487682j))
        ref[3, 0, 1]=(0.836147116678-0.519870652314j)*o*x_ref[1]**(o-1)+((-0.38378258798-0.259634910553j))
        arg[3, 1]=(-0.612780960792-0.731734375764j)*x[0]**o+((0.711332990611+0.936386113758j))*x[0]+((-0.841612460317+0.444487526953j))*x[1]**o+((-0.0398461832744+0.387784857695j))*x[1]
        ref[3, 1, 0]=(-0.612780960792-0.731734375764j)*o*x_ref[0]**(o-1)+((0.711332990611+0.936386113758j))
        ref[3, 1, 1]=(-0.841612460317+0.444487526953j)*o*x_ref[1]**(o-1)+((-0.0398461832744+0.387784857695j))
        if dim==3:
            arg[0, 0]+=(-0.419596277501-0.656738680309j)*x[2]**o+((-0.832242880948+0.0706731842717j))*x[2]
            ref[0, 0, 2]=(-0.419596277501-0.656738680309j)*o*x_ref[2]**(o-1)+((-0.832242880948+0.0706731842717j))
            arg[0, 1]+=(-0.96578297918-0.420465175562j)*x[2]**o+((0.369278740393+0.158668223808j))*x[2]
            ref[0, 1, 2]=(-0.96578297918-0.420465175562j)*o*x_ref[2]**(o-1)+((0.369278740393+0.158668223808j))
            arg[1, 0]+=(-0.61149001034+0.345142168368j)*x[2]**o+((0.286339549093-0.330937474218j))*x[2]
            ref[1, 0, 2]=(-0.61149001034+0.345142168368j)*o*x_ref[2]**(o-1)+((0.286339549093-0.330937474218j))
            arg[1, 1]+=(-0.32465462931+0.394581441235j)*x[2]**o+((0.0429982213379-0.434950770656j))*x[2]
            ref[1, 1, 2]=(-0.32465462931+0.394581441235j)*o*x_ref[2]**(o-1)+((0.0429982213379-0.434950770656j))
            arg[2, 0]+=(-0.381594971515+0.491715900685j)*x[2]**o+((-0.388248091329+0.487934592297j))*x[2]
            ref[2, 0, 2]=(-0.381594971515+0.491715900685j)*o*x_ref[2]**(o-1)+((-0.388248091329+0.487934592297j))
            arg[2, 1]+=(-0.959860409265-0.481852865608j)*x[2]**o+((-0.444709175897+0.0813459458717j))*x[2]
            ref[2, 1, 2]=(-0.959860409265-0.481852865608j)*o*x_ref[2]**(o-1)+((-0.444709175897+0.0813459458717j))
            arg[3, 0]+=(-0.778577635738-0.693883472238j)*x[2]**o+((-0.971172086806-0.184230321134j))*x[2]
            ref[3, 0, 2]=(-0.778577635738-0.693883472238j)*o*x_ref[2]**(o-1)+((-0.971172086806-0.184230321134j))
            arg[3, 1]+=(0.692481326654-0.873384896308j)*x[2]**o+((0.194766277944-0.0250191516508j))*x[2]
            ref[3, 1, 2]=(0.692481326654-0.873384896308j)*o*x_ref[2]**(o-1)+((0.194766277944-0.0250191516508j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4, 2)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnContactZero_fromData_Solution_rank3(self):
        """
        tests gradient of rank 3 Data on ReducedFunctionOnContactZero

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnContactZero
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnContactZero(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(3, 3, 4),w)
        ref = Data(0,(3, 3, 4)+(dim,),w_ref)
        arg[0, 0, 0]=(0.420044923012+0.83839959924j)*x[0]**o+((0.441371142871-0.289342014305j))*x[0]+((0.589405959686-0.609588661392j))*x[1]**o+((-0.584492964454+0.479398497401j))*x[1]
        ref[0, 0, 0, 0]=(0.420044923012+0.83839959924j)*o*x_ref[0]**(o-1)+((0.441371142871-0.289342014305j))
        ref[0, 0, 0, 1]=(0.589405959686-0.609588661392j)*o*x_ref[1]**(o-1)+((-0.584492964454+0.479398497401j))
        arg[0, 0, 1]=(0.66106782354-0.369983655191j)*x[0]**o+((0.975229131059+0.171991366908j))*x[0]+((-0.567391403686-0.00232862230899j))*x[1]**o+((-0.0410002552709+0.817484308957j))*x[1]
        ref[0, 0, 1, 0]=(0.66106782354-0.369983655191j)*o*x_ref[0]**(o-1)+((0.975229131059+0.171991366908j))
        ref[0, 0, 1, 1]=(-0.567391403686-0.00232862230899j)*o*x_ref[1]**(o-1)+((-0.0410002552709+0.817484308957j))
        arg[0, 0, 2]=(0.375722355431-0.113109742434j)*x[0]**o+((0.857485019436-0.0964712383894j))*x[0]+((-0.724028395387-0.332523534036j))*x[1]**o+((-0.850761039134-0.188610879259j))*x[1]
        ref[0, 0, 2, 0]=(0.375722355431-0.113109742434j)*o*x_ref[0]**(o-1)+((0.857485019436-0.0964712383894j))
        ref[0, 0, 2, 1]=(-0.724028395387-0.332523534036j)*o*x_ref[1]**(o-1)+((-0.850761039134-0.188610879259j))
        arg[0, 0, 3]=(-0.355485649257-0.168199821682j)*x[0]**o+((0.473398726685+0.252924203547j))*x[0]+((0.106776073026+0.886524899572j))*x[1]**o+((-0.619377043899+0.881617503752j))*x[1]
        ref[0, 0, 3, 0]=(-0.355485649257-0.168199821682j)*o*x_ref[0]**(o-1)+((0.473398726685+0.252924203547j))
        ref[0, 0, 3, 1]=(0.106776073026+0.886524899572j)*o*x_ref[1]**(o-1)+((-0.619377043899+0.881617503752j))
        arg[0, 1, 0]=(0.780561897099-0.587673091521j)*x[0]**o+((-0.895514346963+0.96550411259j))*x[0]+((0.59031888228-0.622772506063j))*x[1]**o+((-0.476044669144-0.0767239350201j))*x[1]
        ref[0, 1, 0, 0]=(0.780561897099-0.587673091521j)*o*x_ref[0]**(o-1)+((-0.895514346963+0.96550411259j))
        ref[0, 1, 0, 1]=(0.59031888228-0.622772506063j)*o*x_ref[1]**(o-1)+((-0.476044669144-0.0767239350201j))
        arg[0, 1, 1]=(-0.466065530629-0.640358822822j)*x[0]**o+((0.0900828727482+0.1687639607j))*x[0]+((0.23633831817-0.647848008722j))*x[1]**o+((-0.56254056535-0.0604585969633j))*x[1]
        ref[0, 1, 1, 0]=(-0.466065530629-0.640358822822j)*o*x_ref[0]**(o-1)+((0.0900828727482+0.1687639607j))
        ref[0, 1, 1, 1]=(0.23633831817-0.647848008722j)*o*x_ref[1]**(o-1)+((-0.56254056535-0.0604585969633j))
        arg[0, 1, 2]=(0.867901439053-0.583345730038j)*x[0]**o+((0.13543618842-0.0459701879174j))*x[0]+((-0.219461305606-0.904642030648j))*x[1]**o+((-0.887013625856+0.376445335041j))*x[1]
        ref[0, 1, 2, 0]=(0.867901439053-0.583345730038j)*o*x_ref[0]**(o-1)+((0.13543618842-0.0459701879174j))
        ref[0, 1, 2, 1]=(-0.219461305606-0.904642030648j)*o*x_ref[1]**(o-1)+((-0.887013625856+0.376445335041j))
        arg[0, 1, 3]=(0.108196501739-0.410181821624j)*x[0]**o+((0.476005739738-0.740326817204j))*x[0]+((0.141314993312-0.727274365161j))*x[1]**o+((-0.230208059942-0.384556849683j))*x[1]
        ref[0, 1, 3, 0]=(0.108196501739-0.410181821624j)*o*x_ref[0]**(o-1)+((0.476005739738-0.740326817204j))
        ref[0, 1, 3, 1]=(0.141314993312-0.727274365161j)*o*x_ref[1]**(o-1)+((-0.230208059942-0.384556849683j))
        arg[0, 2, 0]=(-0.548465271281-0.123745760815j)*x[0]**o+((-0.068902149285+0.115038451673j))*x[0]+((-0.229372209505+0.285151514056j))*x[1]**o+((0.146193120458-0.781028174447j))*x[1]
        ref[0, 2, 0, 0]=(-0.548465271281-0.123745760815j)*o*x_ref[0]**(o-1)+((-0.068902149285+0.115038451673j))
        ref[0, 2, 0, 1]=(-0.229372209505+0.285151514056j)*o*x_ref[1]**(o-1)+((0.146193120458-0.781028174447j))
        arg[0, 2, 1]=(0.209555811044+0.3282639744j)*x[0]**o+((0.847431043493+0.12527375942j))*x[0]+((0.665706618451-0.926911769726j))*x[1]**o+((0.61945777336-0.594606758239j))*x[1]
        ref[0, 2, 1, 0]=(0.209555811044+0.3282639744j)*o*x_ref[0]**(o-1)+((0.847431043493+0.12527375942j))
        ref[0, 2, 1, 1]=(0.665706618451-0.926911769726j)*o*x_ref[1]**(o-1)+((0.61945777336-0.594606758239j))
        arg[0, 2, 2]=(-0.831945453306+0.214584029942j)*x[0]**o+((0.445028558661-0.340854805608j))*x[0]+((-0.877830769204-0.033456991626j))*x[1]**o+((0.688478467048-0.921909930895j))*x[1]
        ref[0, 2, 2, 0]=(-0.831945453306+0.214584029942j)*o*x_ref[0]**(o-1)+((0.445028558661-0.340854805608j))
        ref[0, 2, 2, 1]=(-0.877830769204-0.033456991626j)*o*x_ref[1]**(o-1)+((0.688478467048-0.921909930895j))
        arg[0, 2, 3]=(0.136594549637+0.934739032551j)*x[0]**o+((0.0397325645255-0.624295352301j))*x[0]+((-0.634561212095-0.106494292487j))*x[1]**o+((-0.8151719565+0.222201021328j))*x[1]
        ref[0, 2, 3, 0]=(0.136594549637+0.934739032551j)*o*x_ref[0]**(o-1)+((0.0397325645255-0.624295352301j))
        ref[0, 2, 3, 1]=(-0.634561212095-0.106494292487j)*o*x_ref[1]**(o-1)+((-0.8151719565+0.222201021328j))
        arg[1, 0, 0]=(-0.228857353432+0.146599504649j)*x[0]**o+((0.634431785674-0.720314694688j))*x[0]+((0.54175707534+0.16861360194j))*x[1]**o+((-0.724820722247-0.0470340773344j))*x[1]
        ref[1, 0, 0, 0]=(-0.228857353432+0.146599504649j)*o*x_ref[0]**(o-1)+((0.634431785674-0.720314694688j))
        ref[1, 0, 0, 1]=(0.54175707534+0.16861360194j)*o*x_ref[1]**(o-1)+((-0.724820722247-0.0470340773344j))
        arg[1, 0, 1]=(-0.239758948971-0.73109460981j)*x[0]**o+((0.745147456565+0.21285984724j))*x[0]+((-0.774771461721+0.459043074612j))*x[1]**o+((0.689981054099+0.0459344886674j))*x[1]
        ref[1, 0, 1, 0]=(-0.239758948971-0.73109460981j)*o*x_ref[0]**(o-1)+((0.745147456565+0.21285984724j))
        ref[1, 0, 1, 1]=(-0.774771461721+0.459043074612j)*o*x_ref[1]**(o-1)+((0.689981054099+0.0459344886674j))
        arg[1, 0, 2]=(0.372679273591+0.821495460405j)*x[0]**o+((-0.999158573554-0.320693196703j))*x[0]+((0.649317283027-0.0778786185005j))*x[1]**o+((-0.953169632377-0.621792864176j))*x[1]
        ref[1, 0, 2, 0]=(0.372679273591+0.821495460405j)*o*x_ref[0]**(o-1)+((-0.999158573554-0.320693196703j))
        ref[1, 0, 2, 1]=(0.649317283027-0.0778786185005j)*o*x_ref[1]**(o-1)+((-0.953169632377-0.621792864176j))
        arg[1, 0, 3]=(-0.666062293671-0.744218940703j)*x[0]**o+((0.0347618111628-0.230894203076j))*x[0]+((0.209606495444-0.629756866852j))*x[1]**o+((0.188366916738-0.51661293316j))*x[1]
        ref[1, 0, 3, 0]=(-0.666062293671-0.744218940703j)*o*x_ref[0]**(o-1)+((0.0347618111628-0.230894203076j))
        ref[1, 0, 3, 1]=(0.209606495444-0.629756866852j)*o*x_ref[1]**(o-1)+((0.188366916738-0.51661293316j))
        arg[1, 1, 0]=(-0.94807326014-0.691464394106j)*x[0]**o+((0.601214185783-0.352763211315j))*x[0]+((-0.147200196705-0.353268345157j))*x[1]**o+((-0.754784268767+0.2312751974j))*x[1]
        ref[1, 1, 0, 0]=(-0.94807326014-0.691464394106j)*o*x_ref[0]**(o-1)+((0.601214185783-0.352763211315j))
        ref[1, 1, 0, 1]=(-0.147200196705-0.353268345157j)*o*x_ref[1]**(o-1)+((-0.754784268767+0.2312751974j))
        arg[1, 1, 1]=(-0.362894065668-0.757707566772j)*x[0]**o+((-0.569117679259-0.154107832719j))*x[0]+((-0.752765799806-0.90417803338j))*x[1]**o+((-0.271096538032-0.843049511511j))*x[1]
        ref[1, 1, 1, 0]=(-0.362894065668-0.757707566772j)*o*x_ref[0]**(o-1)+((-0.569117679259-0.154107832719j))
        ref[1, 1, 1, 1]=(-0.752765799806-0.90417803338j)*o*x_ref[1]**(o-1)+((-0.271096538032-0.843049511511j))
        arg[1, 1, 2]=(-0.857845704616+0.716839018752j)*x[0]**o+((0.64349560012+0.719948931243j))*x[0]+((-0.348013346776-0.941483236138j))*x[1]**o+((0.635096270481+0.999984261664j))*x[1]
        ref[1, 1, 2, 0]=(-0.857845704616+0.716839018752j)*o*x_ref[0]**(o-1)+((0.64349560012+0.719948931243j))
        ref[1, 1, 2, 1]=(-0.348013346776-0.941483236138j)*o*x_ref[1]**(o-1)+((0.635096270481+0.999984261664j))
        arg[1, 1, 3]=(-0.892741264316+0.0247757455519j)*x[0]**o+((0.466833487607-0.985995231467j))*x[0]+((0.67135129222-0.701352568242j))*x[1]**o+((-0.229551807404+0.0127174125109j))*x[1]
        ref[1, 1, 3, 0]=(-0.892741264316+0.0247757455519j)*o*x_ref[0]**(o-1)+((0.466833487607-0.985995231467j))
        ref[1, 1, 3, 1]=(0.67135129222-0.701352568242j)*o*x_ref[1]**(o-1)+((-0.229551807404+0.0127174125109j))
        arg[1, 2, 0]=(0.273789466262-0.998682545961j)*x[0]**o+((0.0791149633248+0.399775250203j))*x[0]+((-0.995506329179+0.14744671359j))*x[1]**o+((-0.368352699298-0.41251248065j))*x[1]
        ref[1, 2, 0, 0]=(0.273789466262-0.998682545961j)*o*x_ref[0]**(o-1)+((0.0791149633248+0.399775250203j))
        ref[1, 2, 0, 1]=(-0.995506329179+0.14744671359j)*o*x_ref[1]**(o-1)+((-0.368352699298-0.41251248065j))
        arg[1, 2, 1]=(-0.945672502235+0.393279552093j)*x[0]**o+((0.55842609883+0.787038260464j))*x[0]+((-0.57047495988+0.187103384501j))*x[1]**o+((0.843466896905+0.1605983117j))*x[1]
        ref[1, 2, 1, 0]=(-0.945672502235+0.393279552093j)*o*x_ref[0]**(o-1)+((0.55842609883+0.787038260464j))
        ref[1, 2, 1, 1]=(-0.57047495988+0.187103384501j)*o*x_ref[1]**(o-1)+((0.843466896905+0.1605983117j))
        arg[1, 2, 2]=(-0.739395802988-0.902410358784j)*x[0]**o+((0.323601338606+0.539132837253j))*x[0]+((0.538065508802+0.685558056679j))*x[1]**o+((-0.41017756114-0.794721828177j))*x[1]
        ref[1, 2, 2, 0]=(-0.739395802988-0.902410358784j)*o*x_ref[0]**(o-1)+((0.323601338606+0.539132837253j))
        ref[1, 2, 2, 1]=(0.538065508802+0.685558056679j)*o*x_ref[1]**(o-1)+((-0.41017756114-0.794721828177j))
        arg[1, 2, 3]=(-0.725606965961-0.341273265464j)*x[0]**o+((0.763261410069+0.968261760945j))*x[0]+((0.572616745698-0.95412085768j))*x[1]**o+((-0.488059251924+0.818606738348j))*x[1]
        ref[1, 2, 3, 0]=(-0.725606965961-0.341273265464j)*o*x_ref[0]**(o-1)+((0.763261410069+0.968261760945j))
        ref[1, 2, 3, 1]=(0.572616745698-0.95412085768j)*o*x_ref[1]**(o-1)+((-0.488059251924+0.818606738348j))
        arg[2, 0, 0]=(-0.213367699199+0.444663255313j)*x[0]**o+((-0.320466223728-0.612750184746j))*x[0]+((0.267091376318+0.529402843774j))*x[1]**o+((-0.649646595101-0.888680569871j))*x[1]
        ref[2, 0, 0, 0]=(-0.213367699199+0.444663255313j)*o*x_ref[0]**(o-1)+((-0.320466223728-0.612750184746j))
        ref[2, 0, 0, 1]=(0.267091376318+0.529402843774j)*o*x_ref[1]**(o-1)+((-0.649646595101-0.888680569871j))
        arg[2, 0, 1]=(0.453210622915-0.586354618319j)*x[0]**o+((-0.0334821575949-0.228951192906j))*x[0]+((0.882753716461-0.803937288564j))*x[1]**o+((0.0333224926795+0.680401795653j))*x[1]
        ref[2, 0, 1, 0]=(0.453210622915-0.586354618319j)*o*x_ref[0]**(o-1)+((-0.0334821575949-0.228951192906j))
        ref[2, 0, 1, 1]=(0.882753716461-0.803937288564j)*o*x_ref[1]**(o-1)+((0.0333224926795+0.680401795653j))
        arg[2, 0, 2]=(-0.983258242998+0.29999009634j)*x[0]**o+((-0.600145203647+0.77677687675j))*x[0]+((0.160075822693-0.307356137771j))*x[1]**o+((-0.526520667011+0.58978334707j))*x[1]
        ref[2, 0, 2, 0]=(-0.983258242998+0.29999009634j)*o*x_ref[0]**(o-1)+((-0.600145203647+0.77677687675j))
        ref[2, 0, 2, 1]=(0.160075822693-0.307356137771j)*o*x_ref[1]**(o-1)+((-0.526520667011+0.58978334707j))
        arg[2, 0, 3]=(0.414044912275-0.366810703714j)*x[0]**o+((0.180600782308-0.170313230028j))*x[0]+((-0.227231711623+0.181844754256j))*x[1]**o+((-0.65314649168+0.911740156721j))*x[1]
        ref[2, 0, 3, 0]=(0.414044912275-0.366810703714j)*o*x_ref[0]**(o-1)+((0.180600782308-0.170313230028j))
        ref[2, 0, 3, 1]=(-0.227231711623+0.181844754256j)*o*x_ref[1]**(o-1)+((-0.65314649168+0.911740156721j))
        arg[2, 1, 0]=(0.463805552579-0.779617179304j)*x[0]**o+((0.933509346356+0.895333841812j))*x[0]+((0.992928112108-0.93209172517j))*x[1]**o+((0.386641398988+0.0339556973108j))*x[1]
        ref[2, 1, 0, 0]=(0.463805552579-0.779617179304j)*o*x_ref[0]**(o-1)+((0.933509346356+0.895333841812j))
        ref[2, 1, 0, 1]=(0.992928112108-0.93209172517j)*o*x_ref[1]**(o-1)+((0.386641398988+0.0339556973108j))
        arg[2, 1, 1]=(0.972826896729-0.850087057618j)*x[0]**o+((-0.705231070681-0.838493346971j))*x[0]+((0.581267426045-0.933373731784j))*x[1]**o+((-0.381357065637-0.911338052533j))*x[1]
        ref[2, 1, 1, 0]=(0.972826896729-0.850087057618j)*o*x_ref[0]**(o-1)+((-0.705231070681-0.838493346971j))
        ref[2, 1, 1, 1]=(0.581267426045-0.933373731784j)*o*x_ref[1]**(o-1)+((-0.381357065637-0.911338052533j))
        arg[2, 1, 2]=(-0.25328748871+0.219989199856j)*x[0]**o+((0.67957845759+0.698574222539j))*x[0]+((-0.543427546702+0.917142934851j))*x[1]**o+((-0.193404990713+0.905485192841j))*x[1]
        ref[2, 1, 2, 0]=(-0.25328748871+0.219989199856j)*o*x_ref[0]**(o-1)+((0.67957845759+0.698574222539j))
        ref[2, 1, 2, 1]=(-0.543427546702+0.917142934851j)*o*x_ref[1]**(o-1)+((-0.193404990713+0.905485192841j))
        arg[2, 1, 3]=(-0.183315672486+0.636108650163j)*x[0]**o+((0.574489526072-0.124891781972j))*x[0]+((-0.461136143837+0.261258329126j))*x[1]**o+((-0.144060831173+0.324788717448j))*x[1]
        ref[2, 1, 3, 0]=(-0.183315672486+0.636108650163j)*o*x_ref[0]**(o-1)+((0.574489526072-0.124891781972j))
        ref[2, 1, 3, 1]=(-0.461136143837+0.261258329126j)*o*x_ref[1]**(o-1)+((-0.144060831173+0.324788717448j))
        arg[2, 2, 0]=(-0.205305231162-0.043616094504j)*x[0]**o+((-0.479591473555-0.909625874984j))*x[0]+((0.833902164725+0.271523798843j))*x[1]**o+((-0.9833232856-0.405272689501j))*x[1]
        ref[2, 2, 0, 0]=(-0.205305231162-0.043616094504j)*o*x_ref[0]**(o-1)+((-0.479591473555-0.909625874984j))
        ref[2, 2, 0, 1]=(0.833902164725+0.271523798843j)*o*x_ref[1]**(o-1)+((-0.9833232856-0.405272689501j))
        arg[2, 2, 1]=(-0.465754054521-0.0988515849241j)*x[0]**o+((0.233253948268-0.161392387762j))*x[0]+((0.702126310971-0.324186337759j))*x[1]**o+((-0.593981028444+0.389619301989j))*x[1]
        ref[2, 2, 1, 0]=(-0.465754054521-0.0988515849241j)*o*x_ref[0]**(o-1)+((0.233253948268-0.161392387762j))
        ref[2, 2, 1, 1]=(0.702126310971-0.324186337759j)*o*x_ref[1]**(o-1)+((-0.593981028444+0.389619301989j))
        arg[2, 2, 2]=(0.701515981572+0.824670956073j)*x[0]**o+((0.0284327764992-0.316085794051j))*x[0]+((-0.896353370623-0.410599486361j))*x[1]**o+((0.756654993449+0.0273001669851j))*x[1]
        ref[2, 2, 2, 0]=(0.701515981572+0.824670956073j)*o*x_ref[0]**(o-1)+((0.0284327764992-0.316085794051j))
        ref[2, 2, 2, 1]=(-0.896353370623-0.410599486361j)*o*x_ref[1]**(o-1)+((0.756654993449+0.0273001669851j))
        arg[2, 2, 3]=(-0.329808379113-0.403887159509j)*x[0]**o+((-0.597809777809+0.227304983198j))*x[0]+((0.150738153481+0.732623125968j))*x[1]**o+((0.805361055158-0.310503615541j))*x[1]
        ref[2, 2, 3, 0]=(-0.329808379113-0.403887159509j)*o*x_ref[0]**(o-1)+((-0.597809777809+0.227304983198j))
        ref[2, 2, 3, 1]=(0.150738153481+0.732623125968j)*o*x_ref[1]**(o-1)+((0.805361055158-0.310503615541j))
        if dim==3:
            arg[0, 0, 0]+=(0.184545831975+0.407518214998j)*x[2]**o+((0.12214595314+0.735093368997j))*x[2]
            ref[0, 0, 0, 2]=(0.184545831975+0.407518214998j)*o*x_ref[2]**(o-1)+((0.12214595314+0.735093368997j))
            arg[0, 0, 1]+=(0.00526705634855+0.716462194051j)*x[2]**o+((-0.952704024558+0.813529600304j))*x[2]
            ref[0, 0, 1, 2]=(0.00526705634855+0.716462194051j)*o*x_ref[2]**(o-1)+((-0.952704024558+0.813529600304j))
            arg[0, 0, 2]+=(-0.351480922714-0.629893229523j)*x[2]**o+((0.259758144504-0.829902898433j))*x[2]
            ref[0, 0, 2, 2]=(-0.351480922714-0.629893229523j)*o*x_ref[2]**(o-1)+((0.259758144504-0.829902898433j))
            arg[0, 0, 3]+=(-0.650916005273-0.362031724657j)*x[2]**o+((-0.304009123457-0.869388101014j))*x[2]
            ref[0, 0, 3, 2]=(-0.650916005273-0.362031724657j)*o*x_ref[2]**(o-1)+((-0.304009123457-0.869388101014j))
            arg[0, 1, 0]+=(0.894938730243+0.370595957764j)*x[2]**o+((-0.573048316875-0.211754271103j))*x[2]
            ref[0, 1, 0, 2]=(0.894938730243+0.370595957764j)*o*x_ref[2]**(o-1)+((-0.573048316875-0.211754271103j))
            arg[0, 1, 1]+=(-0.409741610438-0.653690491439j)*x[2]**o+((-0.766021199894+0.53396480866j))*x[2]
            ref[0, 1, 1, 2]=(-0.409741610438-0.653690491439j)*o*x_ref[2]**(o-1)+((-0.766021199894+0.53396480866j))
            arg[0, 1, 2]+=(-0.316346716591-0.184985717439j)*x[2]**o+((-0.294209009397-0.293777866262j))*x[2]
            ref[0, 1, 2, 2]=(-0.316346716591-0.184985717439j)*o*x_ref[2]**(o-1)+((-0.294209009397-0.293777866262j))
            arg[0, 1, 3]+=(0.23858627747+0.79778010557j)*x[2]**o+((-0.496715863592+0.946805194911j))*x[2]
            ref[0, 1, 3, 2]=(0.23858627747+0.79778010557j)*o*x_ref[2]**(o-1)+((-0.496715863592+0.946805194911j))
            arg[0, 2, 0]+=(0.525718541994+0.725935607547j)*x[2]**o+((0.161408625948+0.978018213583j))*x[2]
            ref[0, 2, 0, 2]=(0.525718541994+0.725935607547j)*o*x_ref[2]**(o-1)+((0.161408625948+0.978018213583j))
            arg[0, 2, 1]+=(-0.247513582264+0.438287782496j)*x[2]**o+((-0.924288658515+0.882743829342j))*x[2]
            ref[0, 2, 1, 2]=(-0.247513582264+0.438287782496j)*o*x_ref[2]**(o-1)+((-0.924288658515+0.882743829342j))
            arg[0, 2, 2]+=(-0.622757424793-0.162549674471j)*x[2]**o+((-0.924457368312-0.833684247326j))*x[2]
            ref[0, 2, 2, 2]=(-0.622757424793-0.162549674471j)*o*x_ref[2]**(o-1)+((-0.924457368312-0.833684247326j))
            arg[0, 2, 3]+=(-0.657521961331-0.791525099874j)*x[2]**o+((-0.976667562515-0.861398225392j))*x[2]
            ref[0, 2, 3, 2]=(-0.657521961331-0.791525099874j)*o*x_ref[2]**(o-1)+((-0.976667562515-0.861398225392j))
            arg[1, 0, 0]+=(-0.988710840363+0.0929395282047j)*x[2]**o+((0.986766561869-0.812844955671j))*x[2]
            ref[1, 0, 0, 2]=(-0.988710840363+0.0929395282047j)*o*x_ref[2]**(o-1)+((0.986766561869-0.812844955671j))
            arg[1, 0, 1]+=(-0.367404484399+0.662617168063j)*x[2]**o+((0.614520098099-0.703733997473j))*x[2]
            ref[1, 0, 1, 2]=(-0.367404484399+0.662617168063j)*o*x_ref[2]**(o-1)+((0.614520098099-0.703733997473j))
            arg[1, 0, 2]+=(-0.600416690486+0.0840588654304j)*x[2]**o+((0.20078217998-0.393601907455j))*x[2]
            ref[1, 0, 2, 2]=(-0.600416690486+0.0840588654304j)*o*x_ref[2]**(o-1)+((0.20078217998-0.393601907455j))
            arg[1, 0, 3]+=(0.577645517175-0.382586439193j)*x[2]**o+((0.860117994475-0.117634786365j))*x[2]
            ref[1, 0, 3, 2]=(0.577645517175-0.382586439193j)*o*x_ref[2]**(o-1)+((0.860117994475-0.117634786365j))
            arg[1, 1, 0]+=(-0.543415728799+0.412385644284j)*x[2]**o+((-0.186063351424-0.463394669344j))*x[2]
            ref[1, 1, 0, 2]=(-0.543415728799+0.412385644284j)*o*x_ref[2]**(o-1)+((-0.186063351424-0.463394669344j))
            arg[1, 1, 1]+=(-0.955100191196+0.938520968699j)*x[2]**o+((-0.876423028759+0.725769674389j))*x[2]
            ref[1, 1, 1, 2]=(-0.955100191196+0.938520968699j)*o*x_ref[2]**(o-1)+((-0.876423028759+0.725769674389j))
            arg[1, 1, 2]+=(-0.260306456861+0.905015572372j)*x[2]**o+((-0.0129189746235-0.379209214707j))*x[2]
            ref[1, 1, 2, 2]=(-0.260306456861+0.905015572372j)*o*x_ref[2]**(o-1)+((-0.0129189746235-0.379209214707j))
            arg[1, 1, 3]+=(-0.474890102174+0.902187016263j)*x[2]**o+((0.35290508829-0.515362512325j))*x[2]
            ref[1, 1, 3, 2]=(-0.474890102174+0.902187016263j)*o*x_ref[2]**(o-1)+((0.35290508829-0.515362512325j))
            arg[1, 2, 0]+=(-0.266542693991+0.987503202185j)*x[2]**o+((0.717253257704+0.705039317592j))*x[2]
            ref[1, 2, 0, 2]=(-0.266542693991+0.987503202185j)*o*x_ref[2]**(o-1)+((0.717253257704+0.705039317592j))
            arg[1, 2, 1]+=(-0.32942250917+0.709227406453j)*x[2]**o+((-0.588498914898-0.919236982004j))*x[2]
            ref[1, 2, 1, 2]=(-0.32942250917+0.709227406453j)*o*x_ref[2]**(o-1)+((-0.588498914898-0.919236982004j))
            arg[1, 2, 2]+=(0.893128952287-0.240251767367j)*x[2]**o+((-0.220168523865-0.783188161552j))*x[2]
            ref[1, 2, 2, 2]=(0.893128952287-0.240251767367j)*o*x_ref[2]**(o-1)+((-0.220168523865-0.783188161552j))
            arg[1, 2, 3]+=(-0.396709361867+0.52213334735j)*x[2]**o+((-0.655670325681+0.93282862837j))*x[2]
            ref[1, 2, 3, 2]=(-0.396709361867+0.52213334735j)*o*x_ref[2]**(o-1)+((-0.655670325681+0.93282862837j))
            arg[2, 0, 0]+=(0.831013459624-0.102650643243j)*x[2]**o+((-0.200588535537+0.0440785606302j))*x[2]
            ref[2, 0, 0, 2]=(0.831013459624-0.102650643243j)*o*x_ref[2]**(o-1)+((-0.200588535537+0.0440785606302j))
            arg[2, 0, 1]+=(-0.9084762263+0.0645099454302j)*x[2]**o+((-0.957332497845+0.788610341193j))*x[2]
            ref[2, 0, 1, 2]=(-0.9084762263+0.0645099454302j)*o*x_ref[2]**(o-1)+((-0.957332497845+0.788610341193j))
            arg[2, 0, 2]+=(-0.564052533795+0.849627571143j)*x[2]**o+((-0.605654877642-0.585058782294j))*x[2]
            ref[2, 0, 2, 2]=(-0.564052533795+0.849627571143j)*o*x_ref[2]**(o-1)+((-0.605654877642-0.585058782294j))
            arg[2, 0, 3]+=(0.760044280878-0.791340370507j)*x[2]**o+((-0.460991811873+0.800767889253j))*x[2]
            ref[2, 0, 3, 2]=(0.760044280878-0.791340370507j)*o*x_ref[2]**(o-1)+((-0.460991811873+0.800767889253j))
            arg[2, 1, 0]+=(-0.954917427458+0.165648181605j)*x[2]**o+((-0.106224193256+0.27615564869j))*x[2]
            ref[2, 1, 0, 2]=(-0.954917427458+0.165648181605j)*o*x_ref[2]**(o-1)+((-0.106224193256+0.27615564869j))
            arg[2, 1, 1]+=(-0.600734693796+0.128099920813j)*x[2]**o+((0.214241486309-0.499260769778j))*x[2]
            ref[2, 1, 1, 2]=(-0.600734693796+0.128099920813j)*o*x_ref[2]**(o-1)+((0.214241486309-0.499260769778j))
            arg[2, 1, 2]+=(-0.157265610897+0.430710279379j)*x[2]**o+((0.935861010752-0.058038187552j))*x[2]
            ref[2, 1, 2, 2]=(-0.157265610897+0.430710279379j)*o*x_ref[2]**(o-1)+((0.935861010752-0.058038187552j))
            arg[2, 1, 3]+=(-0.928232213261-0.330073069968j)*x[2]**o+((-0.727355429358+0.286903946857j))*x[2]
            ref[2, 1, 3, 2]=(-0.928232213261-0.330073069968j)*o*x_ref[2]**(o-1)+((-0.727355429358+0.286903946857j))
            arg[2, 2, 0]+=(0.146826236002+0.0164745024399j)*x[2]**o+((0.982249325989+0.64581073998j))*x[2]
            ref[2, 2, 0, 2]=(0.146826236002+0.0164745024399j)*o*x_ref[2]**(o-1)+((0.982249325989+0.64581073998j))
            arg[2, 2, 1]+=(0.374179789392-0.279538266543j)*x[2]**o+((-0.0270228405349-0.756324897451j))*x[2]
            ref[2, 2, 1, 2]=(0.374179789392-0.279538266543j)*o*x_ref[2]**(o-1)+((-0.0270228405349-0.756324897451j))
            arg[2, 2, 2]+=(-0.778588426262+0.470689779097j)*x[2]**o+((-0.978873087838+0.0536553556742j))*x[2]
            ref[2, 2, 2, 2]=(-0.778588426262+0.470689779097j)*o*x_ref[2]**(o-1)+((-0.978873087838+0.0536553556742j))
            arg[2, 2, 3]+=(-0.0303324616423+0.419028519621j)*x[2]**o+((-0.220820248439+0.624520472493j))*x[2]
            ref[2, 2, 3, 2]=(-0.0303324616423+0.419028519621j)*o*x_ref[2]**(o-1)+((-0.220820248439+0.624520472493j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3, 3, 4)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnContactZero_fromData_ReducedSolution_rank0(self):
        """
        tests gradient of rank 0 Data on ReducedFunctionOnContactZero

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnContactZero
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnContactZero(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=(0.872608912596-0.229245343761j)*x[0]+((0.736938523324+0.569724984617j))*x[1]
        ref[0]=(0.872608912596-0.229245343761j)
        ref[1]=(0.736938523324+0.569724984617j)
        if dim==3:
            arg+=((0.872341449967-0.563549676327j))*x[2]
            ref[2]=(0.872341449967-0.563549676327j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnContactZero_fromData_ReducedSolution_rank1(self):
        """
        tests gradient of rank 1 Data on ReducedFunctionOnContactZero

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnContactZero
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnContactZero(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(2,),w)
        ref = Data(0,(2,)+(dim,),w_ref)
        arg[0,]=(-0.272982620784-0.921729185182j)*x[0]+((0.804304453555+0.848454065352j))*x[1]
        ref[0, 0]=(-0.272982620784-0.921729185182j)
        ref[0, 1]=(0.804304453555+0.848454065352j)
        arg[1,]=(-0.270638292779-0.293532969845j)*x[0]+((-0.662205329517-0.600042489103j))*x[1]
        ref[1, 0]=(-0.270638292779-0.293532969845j)
        ref[1, 1]=(-0.662205329517-0.600042489103j)
        if dim==3:
            arg[0,]+=(0.587948324358+0.971912312766j)*x[2]
            ref[0, 2]=(0.587948324358+0.971912312766j)
            arg[1,]+=(-0.563019718532-0.450863024044j)*x[2]
            ref[1, 2]=(-0.563019718532-0.450863024044j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnContactZero_fromData_ReducedSolution_rank2(self):
        """
        tests gradient of rank 2 Data on ReducedFunctionOnContactZero

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnContactZero
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnContactZero(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(4, 4),w)
        ref = Data(0,(4, 4)+(dim,),w_ref)
        arg[0, 0]=(-0.992624944062-0.506160492452j)*x[0]+((0.993947860022-0.291805239396j))*x[1]
        ref[0, 0, 0]=(-0.992624944062-0.506160492452j)
        ref[0, 0, 1]=(0.993947860022-0.291805239396j)
        arg[0, 1]=(0.544810756787-0.0460566883991j)*x[0]+((-0.031911168892-0.625161075131j))*x[1]
        ref[0, 1, 0]=(0.544810756787-0.0460566883991j)
        ref[0, 1, 1]=(-0.031911168892-0.625161075131j)
        arg[0, 2]=(-0.0237688932677-0.304025609639j)*x[0]+((-0.73268334973+0.102756037855j))*x[1]
        ref[0, 2, 0]=(-0.0237688932677-0.304025609639j)
        ref[0, 2, 1]=(-0.73268334973+0.102756037855j)
        arg[0, 3]=(0.916283074781+0.651416043694j)*x[0]+((0.744524657758-0.227703596112j))*x[1]
        ref[0, 3, 0]=(0.916283074781+0.651416043694j)
        ref[0, 3, 1]=(0.744524657758-0.227703596112j)
        arg[1, 0]=(-0.811995912199+0.619169910909j)*x[0]+((-0.473680758868+0.464137649799j))*x[1]
        ref[1, 0, 0]=(-0.811995912199+0.619169910909j)
        ref[1, 0, 1]=(-0.473680758868+0.464137649799j)
        arg[1, 1]=(-0.575468206508-0.20339103381j)*x[0]+((-0.89093325568-0.556767426478j))*x[1]
        ref[1, 1, 0]=(-0.575468206508-0.20339103381j)
        ref[1, 1, 1]=(-0.89093325568-0.556767426478j)
        arg[1, 2]=(0.552955963483-0.388017506513j)*x[0]+((0.34254442114-0.67350137706j))*x[1]
        ref[1, 2, 0]=(0.552955963483-0.388017506513j)
        ref[1, 2, 1]=(0.34254442114-0.67350137706j)
        arg[1, 3]=(0.888475065314-0.257255312662j)*x[0]+((0.22224755301-0.92480899064j))*x[1]
        ref[1, 3, 0]=(0.888475065314-0.257255312662j)
        ref[1, 3, 1]=(0.22224755301-0.92480899064j)
        arg[2, 0]=(-0.124150866337-0.987261122673j)*x[0]+((0.120703791223-0.255566459852j))*x[1]
        ref[2, 0, 0]=(-0.124150866337-0.987261122673j)
        ref[2, 0, 1]=(0.120703791223-0.255566459852j)
        arg[2, 1]=(0.0601669349296+0.408913322793j)*x[0]+((0.184120921971-0.581650045992j))*x[1]
        ref[2, 1, 0]=(0.0601669349296+0.408913322793j)
        ref[2, 1, 1]=(0.184120921971-0.581650045992j)
        arg[2, 2]=(0.803526144148-0.271262623561j)*x[0]+((-0.875851698041+0.991600057149j))*x[1]
        ref[2, 2, 0]=(0.803526144148-0.271262623561j)
        ref[2, 2, 1]=(-0.875851698041+0.991600057149j)
        arg[2, 3]=(-0.540636474751-0.0162936507954j)*x[0]+((0.773904270149+0.760316497943j))*x[1]
        ref[2, 3, 0]=(-0.540636474751-0.0162936507954j)
        ref[2, 3, 1]=(0.773904270149+0.760316497943j)
        arg[3, 0]=(-0.415474815661+0.681509668113j)*x[0]+((-0.0694443765619+0.0828004792102j))*x[1]
        ref[3, 0, 0]=(-0.415474815661+0.681509668113j)
        ref[3, 0, 1]=(-0.0694443765619+0.0828004792102j)
        arg[3, 1]=(-0.0965098765217+0.0640786097262j)*x[0]+((0.73608826396+0.223717921512j))*x[1]
        ref[3, 1, 0]=(-0.0965098765217+0.0640786097262j)
        ref[3, 1, 1]=(0.73608826396+0.223717921512j)
        arg[3, 2]=(-0.343554303362+0.108610496556j)*x[0]+((0.0167085935155-0.285109984976j))*x[1]
        ref[3, 2, 0]=(-0.343554303362+0.108610496556j)
        ref[3, 2, 1]=(0.0167085935155-0.285109984976j)
        arg[3, 3]=(-0.149178367895+0.998064408977j)*x[0]+((0.54841633497+0.871597027676j))*x[1]
        ref[3, 3, 0]=(-0.149178367895+0.998064408977j)
        ref[3, 3, 1]=(0.54841633497+0.871597027676j)
        if dim==3:
            arg[0, 0]+=(0.706085810135+0.123954460572j)*x[2]
            ref[0, 0, 2]=(0.706085810135+0.123954460572j)
            arg[0, 1]+=(-0.220246374918+0.237599974348j)*x[2]
            ref[0, 1, 2]=(-0.220246374918+0.237599974348j)
            arg[0, 2]+=(-0.750110968316-0.0519036999682j)*x[2]
            ref[0, 2, 2]=(-0.750110968316-0.0519036999682j)
            arg[0, 3]+=(-0.791338069284+0.410497470629j)*x[2]
            ref[0, 3, 2]=(-0.791338069284+0.410497470629j)
            arg[1, 0]+=(0.325657453032+0.978657742315j)*x[2]
            ref[1, 0, 2]=(0.325657453032+0.978657742315j)
            arg[1, 1]+=(0.0734790450542-0.722752834406j)*x[2]
            ref[1, 1, 2]=(0.0734790450542-0.722752834406j)
            arg[1, 2]+=(-0.177960848142-0.521445303176j)*x[2]
            ref[1, 2, 2]=(-0.177960848142-0.521445303176j)
            arg[1, 3]+=(-0.401224865075+0.0225801954061j)*x[2]
            ref[1, 3, 2]=(-0.401224865075+0.0225801954061j)
            arg[2, 0]+=(-0.0539807436726+0.64504893525j)*x[2]
            ref[2, 0, 2]=(-0.0539807436726+0.64504893525j)
            arg[2, 1]+=(-0.217169480465+0.275027738018j)*x[2]
            ref[2, 1, 2]=(-0.217169480465+0.275027738018j)
            arg[2, 2]+=(0.397193509631-0.699096284598j)*x[2]
            ref[2, 2, 2]=(0.397193509631-0.699096284598j)
            arg[2, 3]+=(-0.275415467183+0.897103727263j)*x[2]
            ref[2, 3, 2]=(-0.275415467183+0.897103727263j)
            arg[3, 0]+=(-0.883131254737+0.910945953212j)*x[2]
            ref[3, 0, 2]=(-0.883131254737+0.910945953212j)
            arg[3, 1]+=(-0.370931763143+0.930786800151j)*x[2]
            ref[3, 1, 2]=(-0.370931763143+0.930786800151j)
            arg[3, 2]+=(0.955489705234+0.480710010831j)*x[2]
            ref[3, 2, 2]=(0.955489705234+0.480710010831j)
            arg[3, 3]+=(-0.732714813181-0.352584131135j)*x[2]
            ref[3, 3, 2]=(-0.732714813181-0.352584131135j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4, 4)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnContactZero_fromData_ReducedSolution_rank3(self):
        """
        tests gradient of rank 3 Data on ReducedFunctionOnContactZero

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnContactZero
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnContactZero(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(4, 3, 2),w)
        ref = Data(0,(4, 3, 2)+(dim,),w_ref)
        arg[0, 0, 0]=(-0.629838778216-0.253689259181j)*x[0]+((-0.873452118998-0.28768786892j))*x[1]
        ref[0, 0, 0, 0]=(-0.629838778216-0.253689259181j)
        ref[0, 0, 0, 1]=(-0.873452118998-0.28768786892j)
        arg[0, 0, 1]=(-0.189610260493-0.35587674441j)*x[0]+((0.435424885989+0.887566353994j))*x[1]
        ref[0, 0, 1, 0]=(-0.189610260493-0.35587674441j)
        ref[0, 0, 1, 1]=(0.435424885989+0.887566353994j)
        arg[0, 1, 0]=(-0.627553479262+0.547776144663j)*x[0]+((-0.0901070110929+0.52021289509j))*x[1]
        ref[0, 1, 0, 0]=(-0.627553479262+0.547776144663j)
        ref[0, 1, 0, 1]=(-0.0901070110929+0.52021289509j)
        arg[0, 1, 1]=(-0.602976036426-0.400846619885j)*x[0]+((0.142701798559-0.464563620787j))*x[1]
        ref[0, 1, 1, 0]=(-0.602976036426-0.400846619885j)
        ref[0, 1, 1, 1]=(0.142701798559-0.464563620787j)
        arg[0, 2, 0]=(-0.121108949564+0.613805963618j)*x[0]+((-0.0124905645882-0.350621952466j))*x[1]
        ref[0, 2, 0, 0]=(-0.121108949564+0.613805963618j)
        ref[0, 2, 0, 1]=(-0.0124905645882-0.350621952466j)
        arg[0, 2, 1]=(-0.436408166879-0.109297450756j)*x[0]+((0.265513502844+0.36202973073j))*x[1]
        ref[0, 2, 1, 0]=(-0.436408166879-0.109297450756j)
        ref[0, 2, 1, 1]=(0.265513502844+0.36202973073j)
        arg[1, 0, 0]=(0.548661863702-0.168631311729j)*x[0]+((-0.624460109765+0.0886135160735j))*x[1]
        ref[1, 0, 0, 0]=(0.548661863702-0.168631311729j)
        ref[1, 0, 0, 1]=(-0.624460109765+0.0886135160735j)
        arg[1, 0, 1]=(-0.18860554479+0.963455542841j)*x[0]+((-0.402624701816+0.528581923862j))*x[1]
        ref[1, 0, 1, 0]=(-0.18860554479+0.963455542841j)
        ref[1, 0, 1, 1]=(-0.402624701816+0.528581923862j)
        arg[1, 1, 0]=(-0.528384716836-0.784941460507j)*x[0]+((-0.416796040865-0.611907240503j))*x[1]
        ref[1, 1, 0, 0]=(-0.528384716836-0.784941460507j)
        ref[1, 1, 0, 1]=(-0.416796040865-0.611907240503j)
        arg[1, 1, 1]=(0.875938591042-0.658832211124j)*x[0]+((0.97474758379+0.0156078743566j))*x[1]
        ref[1, 1, 1, 0]=(0.875938591042-0.658832211124j)
        ref[1, 1, 1, 1]=(0.97474758379+0.0156078743566j)
        arg[1, 2, 0]=(0.348895637029-0.685686486263j)*x[0]+((0.849084921182+0.242215770566j))*x[1]
        ref[1, 2, 0, 0]=(0.348895637029-0.685686486263j)
        ref[1, 2, 0, 1]=(0.849084921182+0.242215770566j)
        arg[1, 2, 1]=(-0.236753377065-0.837892980864j)*x[0]+((-0.908371706232-0.254023049151j))*x[1]
        ref[1, 2, 1, 0]=(-0.236753377065-0.837892980864j)
        ref[1, 2, 1, 1]=(-0.908371706232-0.254023049151j)
        arg[2, 0, 0]=(-0.169399612396+0.801170800478j)*x[0]+((0.647701199485-0.29867950439j))*x[1]
        ref[2, 0, 0, 0]=(-0.169399612396+0.801170800478j)
        ref[2, 0, 0, 1]=(0.647701199485-0.29867950439j)
        arg[2, 0, 1]=(0.83618534837+0.768387690015j)*x[0]+((-0.655382434032-0.383274275353j))*x[1]
        ref[2, 0, 1, 0]=(0.83618534837+0.768387690015j)
        ref[2, 0, 1, 1]=(-0.655382434032-0.383274275353j)
        arg[2, 1, 0]=(-0.779804203393-0.201507613905j)*x[0]+((0.991510302218+0.52086639022j))*x[1]
        ref[2, 1, 0, 0]=(-0.779804203393-0.201507613905j)
        ref[2, 1, 0, 1]=(0.991510302218+0.52086639022j)
        arg[2, 1, 1]=(0.40254064808-0.575491792215j)*x[0]+((-0.220699599805-0.980884492648j))*x[1]
        ref[2, 1, 1, 0]=(0.40254064808-0.575491792215j)
        ref[2, 1, 1, 1]=(-0.220699599805-0.980884492648j)
        arg[2, 2, 0]=(0.409911317562+0.0619362552194j)*x[0]+((-0.320565636303+0.672491534559j))*x[1]
        ref[2, 2, 0, 0]=(0.409911317562+0.0619362552194j)
        ref[2, 2, 0, 1]=(-0.320565636303+0.672491534559j)
        arg[2, 2, 1]=(0.892065905506+0.7619452602j)*x[0]+((-0.424858109263+0.307726484131j))*x[1]
        ref[2, 2, 1, 0]=(0.892065905506+0.7619452602j)
        ref[2, 2, 1, 1]=(-0.424858109263+0.307726484131j)
        arg[3, 0, 0]=(0.227808874318-0.925470046574j)*x[0]+((0.331103316164+0.0390893714891j))*x[1]
        ref[3, 0, 0, 0]=(0.227808874318-0.925470046574j)
        ref[3, 0, 0, 1]=(0.331103316164+0.0390893714891j)
        arg[3, 0, 1]=(0.0424669575759-0.82904143786j)*x[0]+((0.0153180125242+0.948626726372j))*x[1]
        ref[3, 0, 1, 0]=(0.0424669575759-0.82904143786j)
        ref[3, 0, 1, 1]=(0.0153180125242+0.948626726372j)
        arg[3, 1, 0]=(-0.404490428585+0.739199593333j)*x[0]+((0.606640878595+0.85359965584j))*x[1]
        ref[3, 1, 0, 0]=(-0.404490428585+0.739199593333j)
        ref[3, 1, 0, 1]=(0.606640878595+0.85359965584j)
        arg[3, 1, 1]=(0.365970988023+0.853989559732j)*x[0]+((0.57222882236-0.348277471259j))*x[1]
        ref[3, 1, 1, 0]=(0.365970988023+0.853989559732j)
        ref[3, 1, 1, 1]=(0.57222882236-0.348277471259j)
        arg[3, 2, 0]=(-0.470366463139-0.946045072962j)*x[0]+((0.0217109825981-0.974169664945j))*x[1]
        ref[3, 2, 0, 0]=(-0.470366463139-0.946045072962j)
        ref[3, 2, 0, 1]=(0.0217109825981-0.974169664945j)
        arg[3, 2, 1]=(-0.639980320113-0.942932189472j)*x[0]+((-0.720465436299-0.870411541265j))*x[1]
        ref[3, 2, 1, 0]=(-0.639980320113-0.942932189472j)
        ref[3, 2, 1, 1]=(-0.720465436299-0.870411541265j)
        if dim==3:
            arg[0, 0, 0]+=(-0.575960465865-0.810364800886j)*x[2]
            ref[0, 0, 0, 2]=(-0.575960465865-0.810364800886j)
            arg[0, 0, 1]+=(-0.177286661261+0.205477593493j)*x[2]
            ref[0, 0, 1, 2]=(-0.177286661261+0.205477593493j)
            arg[0, 1, 0]+=(-0.420404095912+0.29569300931j)*x[2]
            ref[0, 1, 0, 2]=(-0.420404095912+0.29569300931j)
            arg[0, 1, 1]+=(0.286334540967-0.330413461645j)*x[2]
            ref[0, 1, 1, 2]=(0.286334540967-0.330413461645j)
            arg[0, 2, 0]+=(-0.785676292623-0.88709241948j)*x[2]
            ref[0, 2, 0, 2]=(-0.785676292623-0.88709241948j)
            arg[0, 2, 1]+=(0.266208449466-0.199970544098j)*x[2]
            ref[0, 2, 1, 2]=(0.266208449466-0.199970544098j)
            arg[1, 0, 0]+=(-0.413496564959+0.664791160904j)*x[2]
            ref[1, 0, 0, 2]=(-0.413496564959+0.664791160904j)
            arg[1, 0, 1]+=(0.20860085263+0.0484603909819j)*x[2]
            ref[1, 0, 1, 2]=(0.20860085263+0.0484603909819j)
            arg[1, 1, 0]+=(-0.449879954934-0.849360162657j)*x[2]
            ref[1, 1, 0, 2]=(-0.449879954934-0.849360162657j)
            arg[1, 1, 1]+=(0.210615713348+0.0736284208872j)*x[2]
            ref[1, 1, 1, 2]=(0.210615713348+0.0736284208872j)
            arg[1, 2, 0]+=(-0.431168311417+0.468373515748j)*x[2]
            ref[1, 2, 0, 2]=(-0.431168311417+0.468373515748j)
            arg[1, 2, 1]+=(0.294087784081-0.10236792863j)*x[2]
            ref[1, 2, 1, 2]=(0.294087784081-0.10236792863j)
            arg[2, 0, 0]+=(-0.710784554697-0.320990089568j)*x[2]
            ref[2, 0, 0, 2]=(-0.710784554697-0.320990089568j)
            arg[2, 0, 1]+=(0.669714527834-0.929394457986j)*x[2]
            ref[2, 0, 1, 2]=(0.669714527834-0.929394457986j)
            arg[2, 1, 0]+=(-0.155290742538+0.589850699362j)*x[2]
            ref[2, 1, 0, 2]=(-0.155290742538+0.589850699362j)
            arg[2, 1, 1]+=(-0.0229377814611+0.0234221999202j)*x[2]
            ref[2, 1, 1, 2]=(-0.0229377814611+0.0234221999202j)
            arg[2, 2, 0]+=(-0.930733407776-0.404133132279j)*x[2]
            ref[2, 2, 0, 2]=(-0.930733407776-0.404133132279j)
            arg[2, 2, 1]+=(-0.978941776505+0.760874131402j)*x[2]
            ref[2, 2, 1, 2]=(-0.978941776505+0.760874131402j)
            arg[3, 0, 0]+=(-0.0392196655234-0.236752909509j)*x[2]
            ref[3, 0, 0, 2]=(-0.0392196655234-0.236752909509j)
            arg[3, 0, 1]+=(0.35135533249+0.923409498333j)*x[2]
            ref[3, 0, 1, 2]=(0.35135533249+0.923409498333j)
            arg[3, 1, 0]+=(0.175063504772-0.286649392852j)*x[2]
            ref[3, 1, 0, 2]=(0.175063504772-0.286649392852j)
            arg[3, 1, 1]+=(-0.697230611235+0.395112539529j)*x[2]
            ref[3, 1, 1, 2]=(-0.697230611235+0.395112539529j)
            arg[3, 2, 0]+=(0.838382103955-0.911949238917j)*x[2]
            ref[3, 2, 0, 2]=(0.838382103955-0.911949238917j)
            arg[3, 2, 1]+=(-0.218983554844+0.308644545025j)*x[2]
            ref[3, 2, 1, 2]=(-0.218983554844+0.308644545025j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4, 3, 2)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnContactZero_fromData_ReducedContinuousFunction_rank0(self):
        """
        tests gradient of rank 0 Data on ReducedFunctionOnContactZero

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnContactZero
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnContactZero(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=(0.568135493446-0.158709197692j)*x[0]+((0.957224351388+0.980352625493j))*x[1]
        ref[0]=(0.568135493446-0.158709197692j)
        ref[1]=(0.957224351388+0.980352625493j)
        if dim==3:
            arg+=((-0.028596280885+0.308788365068j))*x[2]
            ref[2]=(-0.028596280885+0.308788365068j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnContactZero_fromData_ReducedContinuousFunction_rank1(self):
        """
        tests gradient of rank 1 Data on ReducedFunctionOnContactZero

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnContactZero
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnContactZero(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(3,),w)
        ref = Data(0,(3,)+(dim,),w_ref)
        arg[0,]=(-0.642023299564-0.139324023141j)*x[0]+((-0.58149693349-0.0895954786309j))*x[1]
        ref[0, 0]=(-0.642023299564-0.139324023141j)
        ref[0, 1]=(-0.58149693349-0.0895954786309j)
        arg[1,]=(-0.532576164885+0.49596688529j)*x[0]+((0.871101657477+0.589326061599j))*x[1]
        ref[1, 0]=(-0.532576164885+0.49596688529j)
        ref[1, 1]=(0.871101657477+0.589326061599j)
        arg[2,]=(-0.484955823272+0.104745513999j)*x[0]+((-0.397961611422-0.287185035181j))*x[1]
        ref[2, 0]=(-0.484955823272+0.104745513999j)
        ref[2, 1]=(-0.397961611422-0.287185035181j)
        if dim==3:
            arg[0,]+=(-0.235870348739-0.581255966119j)*x[2]
            ref[0, 2]=(-0.235870348739-0.581255966119j)
            arg[1,]+=(0.0748155206692+0.0696817711676j)*x[2]
            ref[1, 2]=(0.0748155206692+0.0696817711676j)
            arg[2,]+=(0.486577894495-0.966642858615j)*x[2]
            ref[2, 2]=(0.486577894495-0.966642858615j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnContactZero_fromData_ReducedContinuousFunction_rank2(self):
        """
        tests gradient of rank 2 Data on ReducedFunctionOnContactZero

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnContactZero
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnContactZero(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(4, 4),w)
        ref = Data(0,(4, 4)+(dim,),w_ref)
        arg[0, 0]=(-0.52390866493-0.191251514902j)*x[0]+((0.501017816766+0.749633582797j))*x[1]
        ref[0, 0, 0]=(-0.52390866493-0.191251514902j)
        ref[0, 0, 1]=(0.501017816766+0.749633582797j)
        arg[0, 1]=(0.955891275056+0.375020844574j)*x[0]+((-0.16876373765+0.778350447263j))*x[1]
        ref[0, 1, 0]=(0.955891275056+0.375020844574j)
        ref[0, 1, 1]=(-0.16876373765+0.778350447263j)
        arg[0, 2]=(0.670842161496+0.545714481198j)*x[0]+((-0.192903248524-0.899557684731j))*x[1]
        ref[0, 2, 0]=(0.670842161496+0.545714481198j)
        ref[0, 2, 1]=(-0.192903248524-0.899557684731j)
        arg[0, 3]=(-0.818183867084+0.267073347785j)*x[0]+((0.237694236764+0.627512683829j))*x[1]
        ref[0, 3, 0]=(-0.818183867084+0.267073347785j)
        ref[0, 3, 1]=(0.237694236764+0.627512683829j)
        arg[1, 0]=(0.455613474149-0.112254890543j)*x[0]+((-0.00726667074008-0.0985489071198j))*x[1]
        ref[1, 0, 0]=(0.455613474149-0.112254890543j)
        ref[1, 0, 1]=(-0.00726667074008-0.0985489071198j)
        arg[1, 1]=(-0.827574103983+0.16439676583j)*x[0]+((-0.116468059214-0.189929153994j))*x[1]
        ref[1, 1, 0]=(-0.827574103983+0.16439676583j)
        ref[1, 1, 1]=(-0.116468059214-0.189929153994j)
        arg[1, 2]=(-0.0360208932746+0.539276411973j)*x[0]+((0.885791973127-0.866136686789j))*x[1]
        ref[1, 2, 0]=(-0.0360208932746+0.539276411973j)
        ref[1, 2, 1]=(0.885791973127-0.866136686789j)
        arg[1, 3]=(-0.473886816803-0.450485662148j)*x[0]+((0.411102220916+0.741278400074j))*x[1]
        ref[1, 3, 0]=(-0.473886816803-0.450485662148j)
        ref[1, 3, 1]=(0.411102220916+0.741278400074j)
        arg[2, 0]=(0.647637645131+0.644452756547j)*x[0]+((0.106632867545-0.0736540776084j))*x[1]
        ref[2, 0, 0]=(0.647637645131+0.644452756547j)
        ref[2, 0, 1]=(0.106632867545-0.0736540776084j)
        arg[2, 1]=(-0.744797535462-0.453047079253j)*x[0]+((-0.225665473756+0.259288361222j))*x[1]
        ref[2, 1, 0]=(-0.744797535462-0.453047079253j)
        ref[2, 1, 1]=(-0.225665473756+0.259288361222j)
        arg[2, 2]=(-0.501183250002-0.550049001174j)*x[0]+((0.247119625096+0.205743278812j))*x[1]
        ref[2, 2, 0]=(-0.501183250002-0.550049001174j)
        ref[2, 2, 1]=(0.247119625096+0.205743278812j)
        arg[2, 3]=(-0.183503417424-0.561903610842j)*x[0]+((-0.304440258904-0.00356578494441j))*x[1]
        ref[2, 3, 0]=(-0.183503417424-0.561903610842j)
        ref[2, 3, 1]=(-0.304440258904-0.00356578494441j)
        arg[3, 0]=(0.0657998609263-0.874488766297j)*x[0]+((0.836442809008-0.15500997935j))*x[1]
        ref[3, 0, 0]=(0.0657998609263-0.874488766297j)
        ref[3, 0, 1]=(0.836442809008-0.15500997935j)
        arg[3, 1]=(-0.976502965102+0.325283932315j)*x[0]+((0.451154010085+0.836450843889j))*x[1]
        ref[3, 1, 0]=(-0.976502965102+0.325283932315j)
        ref[3, 1, 1]=(0.451154010085+0.836450843889j)
        arg[3, 2]=(-0.765320762346+0.527937071931j)*x[0]+((0.017055706682-0.857264251708j))*x[1]
        ref[3, 2, 0]=(-0.765320762346+0.527937071931j)
        ref[3, 2, 1]=(0.017055706682-0.857264251708j)
        arg[3, 3]=(0.298681117617-0.742845374019j)*x[0]+((0.0685530111304-0.488339149209j))*x[1]
        ref[3, 3, 0]=(0.298681117617-0.742845374019j)
        ref[3, 3, 1]=(0.0685530111304-0.488339149209j)
        if dim==3:
            arg[0, 0]+=(0.898105918017-0.50908054438j)*x[2]
            ref[0, 0, 2]=(0.898105918017-0.50908054438j)
            arg[0, 1]+=(0.971460528382-0.913297079187j)*x[2]
            ref[0, 1, 2]=(0.971460528382-0.913297079187j)
            arg[0, 2]+=(0.553102891142+0.392110186527j)*x[2]
            ref[0, 2, 2]=(0.553102891142+0.392110186527j)
            arg[0, 3]+=(-0.0761813268684-0.34471059777j)*x[2]
            ref[0, 3, 2]=(-0.0761813268684-0.34471059777j)
            arg[1, 0]+=(-0.254335557654+0.0925044281101j)*x[2]
            ref[1, 0, 2]=(-0.254335557654+0.0925044281101j)
            arg[1, 1]+=(0.488611261533-0.637033487197j)*x[2]
            ref[1, 1, 2]=(0.488611261533-0.637033487197j)
            arg[1, 2]+=(0.291340156577+0.670777317205j)*x[2]
            ref[1, 2, 2]=(0.291340156577+0.670777317205j)
            arg[1, 3]+=(0.919298099735+0.008858094689j)*x[2]
            ref[1, 3, 2]=(0.919298099735+0.008858094689j)
            arg[2, 0]+=(0.267460287827-0.00432982578537j)*x[2]
            ref[2, 0, 2]=(0.267460287827-0.00432982578537j)
            arg[2, 1]+=(0.850044815235-0.2297598102j)*x[2]
            ref[2, 1, 2]=(0.850044815235-0.2297598102j)
            arg[2, 2]+=(-0.243753688982-0.122324819356j)*x[2]
            ref[2, 2, 2]=(-0.243753688982-0.122324819356j)
            arg[2, 3]+=(-0.686005842116-0.238918822992j)*x[2]
            ref[2, 3, 2]=(-0.686005842116-0.238918822992j)
            arg[3, 0]+=(-0.209526809499+0.897256776286j)*x[2]
            ref[3, 0, 2]=(-0.209526809499+0.897256776286j)
            arg[3, 1]+=(-0.376315774146-0.32636606686j)*x[2]
            ref[3, 1, 2]=(-0.376315774146-0.32636606686j)
            arg[3, 2]+=(-0.841771699145+0.964114324616j)*x[2]
            ref[3, 2, 2]=(-0.841771699145+0.964114324616j)
            arg[3, 3]+=(0.296524089522-0.547342639569j)*x[2]
            ref[3, 3, 2]=(0.296524089522-0.547342639569j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4, 4)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnContactZero_fromData_ReducedContinuousFunction_rank3(self):
        """
        tests gradient of rank 3 Data on ReducedFunctionOnContactZero

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnContactZero
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnContactZero(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(2, 2, 4),w)
        ref = Data(0,(2, 2, 4)+(dim,),w_ref)
        arg[0, 0, 0]=(0.0475403657803+0.721281819266j)*x[0]+((-0.348223671721+0.484336881331j))*x[1]
        ref[0, 0, 0, 0]=(0.0475403657803+0.721281819266j)
        ref[0, 0, 0, 1]=(-0.348223671721+0.484336881331j)
        arg[0, 0, 1]=(0.0152262784762+0.554805554096j)*x[0]+((-0.840822048189-0.139773761722j))*x[1]
        ref[0, 0, 1, 0]=(0.0152262784762+0.554805554096j)
        ref[0, 0, 1, 1]=(-0.840822048189-0.139773761722j)
        arg[0, 0, 2]=(-0.975190638587-0.683312865417j)*x[0]+((-0.170798568843+0.450575535059j))*x[1]
        ref[0, 0, 2, 0]=(-0.975190638587-0.683312865417j)
        ref[0, 0, 2, 1]=(-0.170798568843+0.450575535059j)
        arg[0, 0, 3]=(-0.389040852334+0.0707754188654j)*x[0]+((0.856409819716-0.390840619794j))*x[1]
        ref[0, 0, 3, 0]=(-0.389040852334+0.0707754188654j)
        ref[0, 0, 3, 1]=(0.856409819716-0.390840619794j)
        arg[0, 1, 0]=(0.647634031122-0.602689129604j)*x[0]+((-0.39887302447-0.562687007238j))*x[1]
        ref[0, 1, 0, 0]=(0.647634031122-0.602689129604j)
        ref[0, 1, 0, 1]=(-0.39887302447-0.562687007238j)
        arg[0, 1, 1]=(0.102863379424+0.26658110439j)*x[0]+((0.311155218931-0.958345149485j))*x[1]
        ref[0, 1, 1, 0]=(0.102863379424+0.26658110439j)
        ref[0, 1, 1, 1]=(0.311155218931-0.958345149485j)
        arg[0, 1, 2]=(0.732028911374-0.126400526444j)*x[0]+((0.222553514537+0.570161936059j))*x[1]
        ref[0, 1, 2, 0]=(0.732028911374-0.126400526444j)
        ref[0, 1, 2, 1]=(0.222553514537+0.570161936059j)
        arg[0, 1, 3]=(-0.0249679421446+0.41160124049j)*x[0]+((0.291103372161+0.861147847998j))*x[1]
        ref[0, 1, 3, 0]=(-0.0249679421446+0.41160124049j)
        ref[0, 1, 3, 1]=(0.291103372161+0.861147847998j)
        arg[1, 0, 0]=(0.856567475477+0.0112692019084j)*x[0]+((-0.855256203439-0.754755450445j))*x[1]
        ref[1, 0, 0, 0]=(0.856567475477+0.0112692019084j)
        ref[1, 0, 0, 1]=(-0.855256203439-0.754755450445j)
        arg[1, 0, 1]=(-0.278276941083+0.39928641703j)*x[0]+((0.471715593051+0.0391273282665j))*x[1]
        ref[1, 0, 1, 0]=(-0.278276941083+0.39928641703j)
        ref[1, 0, 1, 1]=(0.471715593051+0.0391273282665j)
        arg[1, 0, 2]=(-0.82296960595-0.520461819259j)*x[0]+((-0.506522116683+0.788547707969j))*x[1]
        ref[1, 0, 2, 0]=(-0.82296960595-0.520461819259j)
        ref[1, 0, 2, 1]=(-0.506522116683+0.788547707969j)
        arg[1, 0, 3]=(-0.681978937539+0.397683349775j)*x[0]+((0.54821165263-0.251771322682j))*x[1]
        ref[1, 0, 3, 0]=(-0.681978937539+0.397683349775j)
        ref[1, 0, 3, 1]=(0.54821165263-0.251771322682j)
        arg[1, 1, 0]=(-0.827039162203+0.143928885791j)*x[0]+((0.180674764706-0.969265640811j))*x[1]
        ref[1, 1, 0, 0]=(-0.827039162203+0.143928885791j)
        ref[1, 1, 0, 1]=(0.180674764706-0.969265640811j)
        arg[1, 1, 1]=(-0.739242393864+0.691472047882j)*x[0]+((0.0268635920225+0.542155546427j))*x[1]
        ref[1, 1, 1, 0]=(-0.739242393864+0.691472047882j)
        ref[1, 1, 1, 1]=(0.0268635920225+0.542155546427j)
        arg[1, 1, 2]=(0.708012953543+0.905959654066j)*x[0]+((-0.604010085565+0.66311717232j))*x[1]
        ref[1, 1, 2, 0]=(0.708012953543+0.905959654066j)
        ref[1, 1, 2, 1]=(-0.604010085565+0.66311717232j)
        arg[1, 1, 3]=(0.211018655626-0.458435406904j)*x[0]+((0.521397394004+0.193310205946j))*x[1]
        ref[1, 1, 3, 0]=(0.211018655626-0.458435406904j)
        ref[1, 1, 3, 1]=(0.521397394004+0.193310205946j)
        if dim==3:
            arg[0, 0, 0]+=(0.0646144016708+0.809774815073j)*x[2]
            ref[0, 0, 0, 2]=(0.0646144016708+0.809774815073j)
            arg[0, 0, 1]+=(0.617519174507+0.166679565782j)*x[2]
            ref[0, 0, 1, 2]=(0.617519174507+0.166679565782j)
            arg[0, 0, 2]+=(-0.841286204178-0.941928749464j)*x[2]
            ref[0, 0, 2, 2]=(-0.841286204178-0.941928749464j)
            arg[0, 0, 3]+=(-0.80117837805-0.811592521373j)*x[2]
            ref[0, 0, 3, 2]=(-0.80117837805-0.811592521373j)
            arg[0, 1, 0]+=(0.282169834712-0.662931914568j)*x[2]
            ref[0, 1, 0, 2]=(0.282169834712-0.662931914568j)
            arg[0, 1, 1]+=(0.903257468146-0.541435329313j)*x[2]
            ref[0, 1, 1, 2]=(0.903257468146-0.541435329313j)
            arg[0, 1, 2]+=(-0.742635694566+0.310673192753j)*x[2]
            ref[0, 1, 2, 2]=(-0.742635694566+0.310673192753j)
            arg[0, 1, 3]+=(0.0827489131954+0.855038935169j)*x[2]
            ref[0, 1, 3, 2]=(0.0827489131954+0.855038935169j)
            arg[1, 0, 0]+=(-0.315375524058-0.577943467343j)*x[2]
            ref[1, 0, 0, 2]=(-0.315375524058-0.577943467343j)
            arg[1, 0, 1]+=(0.0247041795427-0.742204365872j)*x[2]
            ref[1, 0, 1, 2]=(0.0247041795427-0.742204365872j)
            arg[1, 0, 2]+=(-0.557239406252+0.225495326143j)*x[2]
            ref[1, 0, 2, 2]=(-0.557239406252+0.225495326143j)
            arg[1, 0, 3]+=(-0.345023289254-0.536249949718j)*x[2]
            ref[1, 0, 3, 2]=(-0.345023289254-0.536249949718j)
            arg[1, 1, 0]+=(0.172056535266+0.0150749193857j)*x[2]
            ref[1, 1, 0, 2]=(0.172056535266+0.0150749193857j)
            arg[1, 1, 1]+=(-0.265434576469+0.34296838458j)*x[2]
            ref[1, 1, 1, 2]=(-0.265434576469+0.34296838458j)
            arg[1, 1, 2]+=(-0.806376175945+0.540158295447j)*x[2]
            ref[1, 1, 2, 2]=(-0.806376175945+0.540158295447j)
            arg[1, 1, 3]+=(-0.199055239441+0.197683206619j)*x[2]
            ref[1, 1, 3, 2]=(-0.199055239441+0.197683206619j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2, 2, 4)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnContactOne_fromData_ContinuousFunction_rank0(self):
        """
        tests gradient of rank 0 Data on FunctionOnContactOne

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on FunctionOnContactOne
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnContactOne(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=(0.466152647578-0.133295489569j)*x[0]**o+((0.770012876582-0.315067632431j))*x[0]+((0.37472108293+0.916815506118j))*x[1]**o+((0.344970238016+0.616409102446j))*x[1]
        ref[0]=(0.466152647578-0.133295489569j)*o*x_ref[0]**(o-1)+((0.770012876582-0.315067632431j))
        ref[1]=(0.37472108293+0.916815506118j)*o*x_ref[1]**(o-1)+((0.344970238016+0.616409102446j))
        if dim==3:
            arg+=((-0.700089355064+0.243895831542j))*x[2]**o+((-0.333158795144-0.25836431213j))*x[2]
            ref[2]=(-0.700089355064+0.243895831542j)*o*x_ref[2]**(o-1)+((-0.333158795144-0.25836431213j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnContactOne_fromData_ContinuousFunction_rank1(self):
        """
        tests gradient of rank 1 Data on FunctionOnContactOne

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on FunctionOnContactOne
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnContactOne(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(2,),w)
        ref = Data(0,(2,)+(dim,),w_ref)
        arg[0,]=(-0.0840045031987-0.851369911762j)*x[0]**o+((-0.080968689999+0.223516269562j))*x[0]+((0.364268703417+0.679378267275j))*x[1]**o+((0.387055875118-0.163133139455j))*x[1]
        ref[0, 0]=(-0.0840045031987-0.851369911762j)*o*x_ref[0]**(o-1)+((-0.080968689999+0.223516269562j))
        ref[0, 1]=(0.364268703417+0.679378267275j)*o*x_ref[1]**(o-1)+((0.387055875118-0.163133139455j))
        arg[1,]=(-0.791434892995+0.815202912876j)*x[0]**o+((-0.203599063148+0.32409250444j))*x[0]+((-0.897023249254-0.851426173081j))*x[1]**o+((-0.70838522916-0.195657648539j))*x[1]
        ref[1, 0]=(-0.791434892995+0.815202912876j)*o*x_ref[0]**(o-1)+((-0.203599063148+0.32409250444j))
        ref[1, 1]=(-0.897023249254-0.851426173081j)*o*x_ref[1]**(o-1)+((-0.70838522916-0.195657648539j))
        if dim==3:
            arg[0,]+=(0.252586102305+0.571588126583j)*x[2]**o+((-0.850183310841+0.528602215765j))*x[2]
            ref[0, 2]=(0.252586102305+0.571588126583j)*o*x_ref[2]**(o-1)+((-0.850183310841+0.528602215765j))
            arg[1,]+=(0.511620295331+0.899154532427j)*x[2]**o+((0.746255927406+0.856195738638j))*x[2]
            ref[1, 2]=(0.511620295331+0.899154532427j)*o*x_ref[2]**(o-1)+((0.746255927406+0.856195738638j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnContactOne_fromData_ContinuousFunction_rank2(self):
        """
        tests gradient of rank 2 Data on FunctionOnContactOne

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on FunctionOnContactOne
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnContactOne(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(4, 3),w)
        ref = Data(0,(4, 3)+(dim,),w_ref)
        arg[0, 0]=(-0.356698832214-0.134093743163j)*x[0]**o+((0.755515268467+0.0183758010074j))*x[0]+((0.889421455714-0.541567297622j))*x[1]**o+((0.446368674886+0.561159243708j))*x[1]
        ref[0, 0, 0]=(-0.356698832214-0.134093743163j)*o*x_ref[0]**(o-1)+((0.755515268467+0.0183758010074j))
        ref[0, 0, 1]=(0.889421455714-0.541567297622j)*o*x_ref[1]**(o-1)+((0.446368674886+0.561159243708j))
        arg[0, 1]=(0.275666864555+0.446559816269j)*x[0]**o+((-0.241805534981+0.942565430802j))*x[0]+((-0.582576755281-0.552423646435j))*x[1]**o+((-0.760233317243-0.385883728257j))*x[1]
        ref[0, 1, 0]=(0.275666864555+0.446559816269j)*o*x_ref[0]**(o-1)+((-0.241805534981+0.942565430802j))
        ref[0, 1, 1]=(-0.582576755281-0.552423646435j)*o*x_ref[1]**(o-1)+((-0.760233317243-0.385883728257j))
        arg[0, 2]=(0.717075745616-0.128652487417j)*x[0]**o+((-0.531748105278-0.638775987471j))*x[0]+((0.405528682188+0.709907629426j))*x[1]**o+((0.515769490161+0.339622487792j))*x[1]
        ref[0, 2, 0]=(0.717075745616-0.128652487417j)*o*x_ref[0]**(o-1)+((-0.531748105278-0.638775987471j))
        ref[0, 2, 1]=(0.405528682188+0.709907629426j)*o*x_ref[1]**(o-1)+((0.515769490161+0.339622487792j))
        arg[1, 0]=(-0.445424582735-0.592713994831j)*x[0]**o+((0.562763020784+0.997570324944j))*x[0]+((-0.540735781508-0.336264347784j))*x[1]**o+((0.0468128900778-0.220059777575j))*x[1]
        ref[1, 0, 0]=(-0.445424582735-0.592713994831j)*o*x_ref[0]**(o-1)+((0.562763020784+0.997570324944j))
        ref[1, 0, 1]=(-0.540735781508-0.336264347784j)*o*x_ref[1]**(o-1)+((0.0468128900778-0.220059777575j))
        arg[1, 1]=(0.192655647878-0.664137566637j)*x[0]**o+((0.0718084165544+0.0969735474631j))*x[0]+((-0.307565567567-0.540948710921j))*x[1]**o+((-0.502249892497+0.0285477206522j))*x[1]
        ref[1, 1, 0]=(0.192655647878-0.664137566637j)*o*x_ref[0]**(o-1)+((0.0718084165544+0.0969735474631j))
        ref[1, 1, 1]=(-0.307565567567-0.540948710921j)*o*x_ref[1]**(o-1)+((-0.502249892497+0.0285477206522j))
        arg[1, 2]=(0.621644051077-0.290339452827j)*x[0]**o+((-0.979994686227-0.440549121473j))*x[0]+((0.0909936859345-0.574795132185j))*x[1]**o+((-0.876940949903+0.388658257437j))*x[1]
        ref[1, 2, 0]=(0.621644051077-0.290339452827j)*o*x_ref[0]**(o-1)+((-0.979994686227-0.440549121473j))
        ref[1, 2, 1]=(0.0909936859345-0.574795132185j)*o*x_ref[1]**(o-1)+((-0.876940949903+0.388658257437j))
        arg[2, 0]=(-0.861303981929-0.00800677362157j)*x[0]**o+((0.272766996112+0.0630573245514j))*x[0]+((-0.258082444866+0.0363461161035j))*x[1]**o+((0.168679291128+0.831884814176j))*x[1]
        ref[2, 0, 0]=(-0.861303981929-0.00800677362157j)*o*x_ref[0]**(o-1)+((0.272766996112+0.0630573245514j))
        ref[2, 0, 1]=(-0.258082444866+0.0363461161035j)*o*x_ref[1]**(o-1)+((0.168679291128+0.831884814176j))
        arg[2, 1]=(-0.5084712979+0.757011642356j)*x[0]**o+((0.76360301089+0.528440562313j))*x[0]+((-0.307276890566-0.328753943908j))*x[1]**o+((-0.255568669804-0.504972757102j))*x[1]
        ref[2, 1, 0]=(-0.5084712979+0.757011642356j)*o*x_ref[0]**(o-1)+((0.76360301089+0.528440562313j))
        ref[2, 1, 1]=(-0.307276890566-0.328753943908j)*o*x_ref[1]**(o-1)+((-0.255568669804-0.504972757102j))
        arg[2, 2]=(-0.613315602195-0.45543220564j)*x[0]**o+((-0.94169943171+0.334037181283j))*x[0]+((-0.318388080917+0.952564892053j))*x[1]**o+((-0.209039676549+0.748580007515j))*x[1]
        ref[2, 2, 0]=(-0.613315602195-0.45543220564j)*o*x_ref[0]**(o-1)+((-0.94169943171+0.334037181283j))
        ref[2, 2, 1]=(-0.318388080917+0.952564892053j)*o*x_ref[1]**(o-1)+((-0.209039676549+0.748580007515j))
        arg[3, 0]=(-0.510879509601+0.470092979342j)*x[0]**o+((-0.613593153447+0.946639276904j))*x[0]+((-0.334904718443-0.363503240847j))*x[1]**o+((0.375541102495+0.547813982437j))*x[1]
        ref[3, 0, 0]=(-0.510879509601+0.470092979342j)*o*x_ref[0]**(o-1)+((-0.613593153447+0.946639276904j))
        ref[3, 0, 1]=(-0.334904718443-0.363503240847j)*o*x_ref[1]**(o-1)+((0.375541102495+0.547813982437j))
        arg[3, 1]=(0.592945995457+0.459846681968j)*x[0]**o+((-0.461289005392+0.826717461289j))*x[0]+((0.949106133114-0.754061298116j))*x[1]**o+((0.742661160295+0.0494562619451j))*x[1]
        ref[3, 1, 0]=(0.592945995457+0.459846681968j)*o*x_ref[0]**(o-1)+((-0.461289005392+0.826717461289j))
        ref[3, 1, 1]=(0.949106133114-0.754061298116j)*o*x_ref[1]**(o-1)+((0.742661160295+0.0494562619451j))
        arg[3, 2]=(0.217356286201-0.0307762246585j)*x[0]**o+((-0.309479217903-0.842338224388j))*x[0]+((-0.227278853173+0.687557842431j))*x[1]**o+((0.837177374341+0.465866004805j))*x[1]
        ref[3, 2, 0]=(0.217356286201-0.0307762246585j)*o*x_ref[0]**(o-1)+((-0.309479217903-0.842338224388j))
        ref[3, 2, 1]=(-0.227278853173+0.687557842431j)*o*x_ref[1]**(o-1)+((0.837177374341+0.465866004805j))
        if dim==3:
            arg[0, 0]+=(0.985770567254+0.802477847851j)*x[2]**o+((0.00656836580105-0.0886627125498j))*x[2]
            ref[0, 0, 2]=(0.985770567254+0.802477847851j)*o*x_ref[2]**(o-1)+((0.00656836580105-0.0886627125498j))
            arg[0, 1]+=(0.167859634301-0.957161097573j)*x[2]**o+((-0.121453672154-0.543246258249j))*x[2]
            ref[0, 1, 2]=(0.167859634301-0.957161097573j)*o*x_ref[2]**(o-1)+((-0.121453672154-0.543246258249j))
            arg[0, 2]+=(0.937564214987+0.684795387319j)*x[2]**o+((0.749117836713-0.223631172566j))*x[2]
            ref[0, 2, 2]=(0.937564214987+0.684795387319j)*o*x_ref[2]**(o-1)+((0.749117836713-0.223631172566j))
            arg[1, 0]+=(0.208958208531+0.804205608307j)*x[2]**o+((0.835957745874-0.891830026158j))*x[2]
            ref[1, 0, 2]=(0.208958208531+0.804205608307j)*o*x_ref[2]**(o-1)+((0.835957745874-0.891830026158j))
            arg[1, 1]+=(-0.729880820753-0.011928231697j)*x[2]**o+((-0.814074817888+0.856423840897j))*x[2]
            ref[1, 1, 2]=(-0.729880820753-0.011928231697j)*o*x_ref[2]**(o-1)+((-0.814074817888+0.856423840897j))
            arg[1, 2]+=(-0.424575932794-0.856639560753j)*x[2]**o+((-0.539026850898+0.0324609045402j))*x[2]
            ref[1, 2, 2]=(-0.424575932794-0.856639560753j)*o*x_ref[2]**(o-1)+((-0.539026850898+0.0324609045402j))
            arg[2, 0]+=(-0.651081242088+0.237607703277j)*x[2]**o+((0.139374320777+0.790078409599j))*x[2]
            ref[2, 0, 2]=(-0.651081242088+0.237607703277j)*o*x_ref[2]**(o-1)+((0.139374320777+0.790078409599j))
            arg[2, 1]+=(0.605469155519+0.552927771039j)*x[2]**o+((-0.86989521541-0.815937434908j))*x[2]
            ref[2, 1, 2]=(0.605469155519+0.552927771039j)*o*x_ref[2]**(o-1)+((-0.86989521541-0.815937434908j))
            arg[2, 2]+=(-0.168508232356-0.637385763768j)*x[2]**o+((0.0287601660577-0.48709910008j))*x[2]
            ref[2, 2, 2]=(-0.168508232356-0.637385763768j)*o*x_ref[2]**(o-1)+((0.0287601660577-0.48709910008j))
            arg[3, 0]+=(0.923963817415-0.3003397646j)*x[2]**o+((0.380383034-0.451311993616j))*x[2]
            ref[3, 0, 2]=(0.923963817415-0.3003397646j)*o*x_ref[2]**(o-1)+((0.380383034-0.451311993616j))
            arg[3, 1]+=(0.794297177217+0.169051990407j)*x[2]**o+((-0.367004126261-0.803390560195j))*x[2]
            ref[3, 1, 2]=(0.794297177217+0.169051990407j)*o*x_ref[2]**(o-1)+((-0.367004126261-0.803390560195j))
            arg[3, 2]+=(-0.986876983229-0.0429793856422j)*x[2]**o+((-0.535214007538-0.232131236674j))*x[2]
            ref[3, 2, 2]=(-0.986876983229-0.0429793856422j)*o*x_ref[2]**(o-1)+((-0.535214007538-0.232131236674j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4, 3)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnContactOne_fromData_ContinuousFunction_rank3(self):
        """
        tests gradient of rank 3 Data on FunctionOnContactOne

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on FunctionOnContactOne
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnContactOne(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(3, 4, 3),w)
        ref = Data(0,(3, 4, 3)+(dim,),w_ref)
        arg[0, 0, 0]=(-0.887451866206+0.848604863034j)*x[0]**o+((0.518155880313-0.208874961069j))*x[0]+((-0.707121131389-0.311400637167j))*x[1]**o+((-0.41596135207-0.381505119114j))*x[1]
        ref[0, 0, 0, 0]=(-0.887451866206+0.848604863034j)*o*x_ref[0]**(o-1)+((0.518155880313-0.208874961069j))
        ref[0, 0, 0, 1]=(-0.707121131389-0.311400637167j)*o*x_ref[1]**(o-1)+((-0.41596135207-0.381505119114j))
        arg[0, 0, 1]=(0.781826325112+0.333334390815j)*x[0]**o+((-0.36310828734-0.873326165515j))*x[0]+((-0.922539619029-0.0340687596874j))*x[1]**o+((-0.934789042093+0.833914028755j))*x[1]
        ref[0, 0, 1, 0]=(0.781826325112+0.333334390815j)*o*x_ref[0]**(o-1)+((-0.36310828734-0.873326165515j))
        ref[0, 0, 1, 1]=(-0.922539619029-0.0340687596874j)*o*x_ref[1]**(o-1)+((-0.934789042093+0.833914028755j))
        arg[0, 0, 2]=(-0.794384377659-0.129548723761j)*x[0]**o+((0.234007538581+0.743835309587j))*x[0]+((0.742519406427+0.0951768250433j))*x[1]**o+((0.416525547179-0.0652308464478j))*x[1]
        ref[0, 0, 2, 0]=(-0.794384377659-0.129548723761j)*o*x_ref[0]**(o-1)+((0.234007538581+0.743835309587j))
        ref[0, 0, 2, 1]=(0.742519406427+0.0951768250433j)*o*x_ref[1]**(o-1)+((0.416525547179-0.0652308464478j))
        arg[0, 1, 0]=(-0.648004349909-0.0915006972594j)*x[0]**o+((-0.27309791943-0.254189441354j))*x[0]+((-0.536563593661-0.820832856979j))*x[1]**o+((0.507767267827+0.95972465842j))*x[1]
        ref[0, 1, 0, 0]=(-0.648004349909-0.0915006972594j)*o*x_ref[0]**(o-1)+((-0.27309791943-0.254189441354j))
        ref[0, 1, 0, 1]=(-0.536563593661-0.820832856979j)*o*x_ref[1]**(o-1)+((0.507767267827+0.95972465842j))
        arg[0, 1, 1]=(-0.0486241680827-0.634998142512j)*x[0]**o+((-0.751824463636+0.725983618338j))*x[0]+((-0.92547130139+0.958124321292j))*x[1]**o+((0.287931700527-0.9188894354j))*x[1]
        ref[0, 1, 1, 0]=(-0.0486241680827-0.634998142512j)*o*x_ref[0]**(o-1)+((-0.751824463636+0.725983618338j))
        ref[0, 1, 1, 1]=(-0.92547130139+0.958124321292j)*o*x_ref[1]**(o-1)+((0.287931700527-0.9188894354j))
        arg[0, 1, 2]=(-0.408886869143-0.896099909137j)*x[0]**o+((-0.115880022131-0.3929524357j))*x[0]+((-0.981377279548+0.167386958767j))*x[1]**o+((0.752982625838-0.847912216282j))*x[1]
        ref[0, 1, 2, 0]=(-0.408886869143-0.896099909137j)*o*x_ref[0]**(o-1)+((-0.115880022131-0.3929524357j))
        ref[0, 1, 2, 1]=(-0.981377279548+0.167386958767j)*o*x_ref[1]**(o-1)+((0.752982625838-0.847912216282j))
        arg[0, 2, 0]=(0.674165015758+0.94771068119j)*x[0]**o+((0.815537804192-0.247906436911j))*x[0]+((0.769531643387+0.668962635823j))*x[1]**o+((-0.535764262179-0.323914834769j))*x[1]
        ref[0, 2, 0, 0]=(0.674165015758+0.94771068119j)*o*x_ref[0]**(o-1)+((0.815537804192-0.247906436911j))
        ref[0, 2, 0, 1]=(0.769531643387+0.668962635823j)*o*x_ref[1]**(o-1)+((-0.535764262179-0.323914834769j))
        arg[0, 2, 1]=(0.303835489816-0.214754865965j)*x[0]**o+((0.92609912441-0.5198878249j))*x[0]+((-0.841702439159-0.439048827673j))*x[1]**o+((0.257502462666+0.414975788935j))*x[1]
        ref[0, 2, 1, 0]=(0.303835489816-0.214754865965j)*o*x_ref[0]**(o-1)+((0.92609912441-0.5198878249j))
        ref[0, 2, 1, 1]=(-0.841702439159-0.439048827673j)*o*x_ref[1]**(o-1)+((0.257502462666+0.414975788935j))
        arg[0, 2, 2]=(-0.420498604126-0.342002123497j)*x[0]**o+((0.132475948112+0.909461498912j))*x[0]+((-0.439296053033-0.397333124645j))*x[1]**o+((-0.948787550527+0.415672736171j))*x[1]
        ref[0, 2, 2, 0]=(-0.420498604126-0.342002123497j)*o*x_ref[0]**(o-1)+((0.132475948112+0.909461498912j))
        ref[0, 2, 2, 1]=(-0.439296053033-0.397333124645j)*o*x_ref[1]**(o-1)+((-0.948787550527+0.415672736171j))
        arg[0, 3, 0]=(0.24321903201-0.82889922118j)*x[0]**o+((0.756504866943+0.338828865414j))*x[0]+((0.754652126022-0.409771188829j))*x[1]**o+((0.0630745787172-0.184487123558j))*x[1]
        ref[0, 3, 0, 0]=(0.24321903201-0.82889922118j)*o*x_ref[0]**(o-1)+((0.756504866943+0.338828865414j))
        ref[0, 3, 0, 1]=(0.754652126022-0.409771188829j)*o*x_ref[1]**(o-1)+((0.0630745787172-0.184487123558j))
        arg[0, 3, 1]=(-0.150726249226-0.941767134708j)*x[0]**o+((0.339616441313+0.55102609105j))*x[0]+((-0.103586791666+0.84438032215j))*x[1]**o+((0.954860821998+0.59524306281j))*x[1]
        ref[0, 3, 1, 0]=(-0.150726249226-0.941767134708j)*o*x_ref[0]**(o-1)+((0.339616441313+0.55102609105j))
        ref[0, 3, 1, 1]=(-0.103586791666+0.84438032215j)*o*x_ref[1]**(o-1)+((0.954860821998+0.59524306281j))
        arg[0, 3, 2]=(-0.911828438274+0.538846462053j)*x[0]**o+((-0.873707906083+0.298609560387j))*x[0]+((-0.67373944448-0.388773323835j))*x[1]**o+((0.788847191951-0.884650693805j))*x[1]
        ref[0, 3, 2, 0]=(-0.911828438274+0.538846462053j)*o*x_ref[0]**(o-1)+((-0.873707906083+0.298609560387j))
        ref[0, 3, 2, 1]=(-0.67373944448-0.388773323835j)*o*x_ref[1]**(o-1)+((0.788847191951-0.884650693805j))
        arg[1, 0, 0]=(0.334965067553-0.728596570927j)*x[0]**o+((0.775745730611-0.881192892879j))*x[0]+((0.782856081029+0.492775219716j))*x[1]**o+((-0.956512701805-0.516882372047j))*x[1]
        ref[1, 0, 0, 0]=(0.334965067553-0.728596570927j)*o*x_ref[0]**(o-1)+((0.775745730611-0.881192892879j))
        ref[1, 0, 0, 1]=(0.782856081029+0.492775219716j)*o*x_ref[1]**(o-1)+((-0.956512701805-0.516882372047j))
        arg[1, 0, 1]=(0.280952567561-0.580939238454j)*x[0]**o+((-0.536939741302-0.189299532584j))*x[0]+((-0.567029110337-0.41824036524j))*x[1]**o+((-0.61507510422-0.400137966216j))*x[1]
        ref[1, 0, 1, 0]=(0.280952567561-0.580939238454j)*o*x_ref[0]**(o-1)+((-0.536939741302-0.189299532584j))
        ref[1, 0, 1, 1]=(-0.567029110337-0.41824036524j)*o*x_ref[1]**(o-1)+((-0.61507510422-0.400137966216j))
        arg[1, 0, 2]=(0.113101487685+0.427369406658j)*x[0]**o+((0.0157689414167-0.718998108196j))*x[0]+((-0.388184450579+0.929552295809j))*x[1]**o+((0.108258427532+0.147980424476j))*x[1]
        ref[1, 0, 2, 0]=(0.113101487685+0.427369406658j)*o*x_ref[0]**(o-1)+((0.0157689414167-0.718998108196j))
        ref[1, 0, 2, 1]=(-0.388184450579+0.929552295809j)*o*x_ref[1]**(o-1)+((0.108258427532+0.147980424476j))
        arg[1, 1, 0]=(-0.910403893761-0.105114310824j)*x[0]**o+((0.883369357221+0.0507155164867j))*x[0]+((0.557060612109-0.935233371167j))*x[1]**o+((-0.415118360213-0.741191656183j))*x[1]
        ref[1, 1, 0, 0]=(-0.910403893761-0.105114310824j)*o*x_ref[0]**(o-1)+((0.883369357221+0.0507155164867j))
        ref[1, 1, 0, 1]=(0.557060612109-0.935233371167j)*o*x_ref[1]**(o-1)+((-0.415118360213-0.741191656183j))
        arg[1, 1, 1]=(-0.489313765855+0.534220829049j)*x[0]**o+((-0.418673040961+0.858649801308j))*x[0]+((0.828484765863-0.0118369506701j))*x[1]**o+((0.345908753229+0.779634649921j))*x[1]
        ref[1, 1, 1, 0]=(-0.489313765855+0.534220829049j)*o*x_ref[0]**(o-1)+((-0.418673040961+0.858649801308j))
        ref[1, 1, 1, 1]=(0.828484765863-0.0118369506701j)*o*x_ref[1]**(o-1)+((0.345908753229+0.779634649921j))
        arg[1, 1, 2]=(-0.467486120307+0.0724295996823j)*x[0]**o+((0.699146124162+0.849100816009j))*x[0]+((0.388411629191+0.275935100334j))*x[1]**o+((0.641309815926-0.142156628326j))*x[1]
        ref[1, 1, 2, 0]=(-0.467486120307+0.0724295996823j)*o*x_ref[0]**(o-1)+((0.699146124162+0.849100816009j))
        ref[1, 1, 2, 1]=(0.388411629191+0.275935100334j)*o*x_ref[1]**(o-1)+((0.641309815926-0.142156628326j))
        arg[1, 2, 0]=(0.60246250175+0.553994019495j)*x[0]**o+((-0.0191960518297-0.637263495031j))*x[0]+((0.599467457768+0.203841425884j))*x[1]**o+((-0.0767499773342-0.0114074219597j))*x[1]
        ref[1, 2, 0, 0]=(0.60246250175+0.553994019495j)*o*x_ref[0]**(o-1)+((-0.0191960518297-0.637263495031j))
        ref[1, 2, 0, 1]=(0.599467457768+0.203841425884j)*o*x_ref[1]**(o-1)+((-0.0767499773342-0.0114074219597j))
        arg[1, 2, 1]=(-0.334688862232-0.428653146609j)*x[0]**o+((-0.0175340557335+0.230004302137j))*x[0]+((-0.40291768267-0.178399434099j))*x[1]**o+((-0.854070876318-0.729084250459j))*x[1]
        ref[1, 2, 1, 0]=(-0.334688862232-0.428653146609j)*o*x_ref[0]**(o-1)+((-0.0175340557335+0.230004302137j))
        ref[1, 2, 1, 1]=(-0.40291768267-0.178399434099j)*o*x_ref[1]**(o-1)+((-0.854070876318-0.729084250459j))
        arg[1, 2, 2]=(-0.994249681489+0.0161234940403j)*x[0]**o+((-0.171574977153-0.0709814752135j))*x[0]+((0.374974490215-0.913233771118j))*x[1]**o+((0.955487086732+0.199427461744j))*x[1]
        ref[1, 2, 2, 0]=(-0.994249681489+0.0161234940403j)*o*x_ref[0]**(o-1)+((-0.171574977153-0.0709814752135j))
        ref[1, 2, 2, 1]=(0.374974490215-0.913233771118j)*o*x_ref[1]**(o-1)+((0.955487086732+0.199427461744j))
        arg[1, 3, 0]=(0.066599875338+0.536612513862j)*x[0]**o+((-0.722405094941-0.330259331664j))*x[0]+((-0.368360526954-0.0297118533995j))*x[1]**o+((-0.13274251293+0.958236201883j))*x[1]
        ref[1, 3, 0, 0]=(0.066599875338+0.536612513862j)*o*x_ref[0]**(o-1)+((-0.722405094941-0.330259331664j))
        ref[1, 3, 0, 1]=(-0.368360526954-0.0297118533995j)*o*x_ref[1]**(o-1)+((-0.13274251293+0.958236201883j))
        arg[1, 3, 1]=(0.0275476067102+0.00532676918277j)*x[0]**o+((0.930439275331+0.58323815079j))*x[0]+((0.505322456549+0.487918150277j))*x[1]**o+((-0.92803263819+0.421068289283j))*x[1]
        ref[1, 3, 1, 0]=(0.0275476067102+0.00532676918277j)*o*x_ref[0]**(o-1)+((0.930439275331+0.58323815079j))
        ref[1, 3, 1, 1]=(0.505322456549+0.487918150277j)*o*x_ref[1]**(o-1)+((-0.92803263819+0.421068289283j))
        arg[1, 3, 2]=(-0.40836318005+0.393834013973j)*x[0]**o+((-0.195544080751-0.763252500438j))*x[0]+((0.703628420826-0.942055436446j))*x[1]**o+((-0.977253949841+0.8696172547j))*x[1]
        ref[1, 3, 2, 0]=(-0.40836318005+0.393834013973j)*o*x_ref[0]**(o-1)+((-0.195544080751-0.763252500438j))
        ref[1, 3, 2, 1]=(0.703628420826-0.942055436446j)*o*x_ref[1]**(o-1)+((-0.977253949841+0.8696172547j))
        arg[2, 0, 0]=(0.772524600353-0.0747444798428j)*x[0]**o+((-0.94965869632+0.152085651213j))*x[0]+((-0.666960093338-0.319735257649j))*x[1]**o+((0.0603327005313-0.842759757187j))*x[1]
        ref[2, 0, 0, 0]=(0.772524600353-0.0747444798428j)*o*x_ref[0]**(o-1)+((-0.94965869632+0.152085651213j))
        ref[2, 0, 0, 1]=(-0.666960093338-0.319735257649j)*o*x_ref[1]**(o-1)+((0.0603327005313-0.842759757187j))
        arg[2, 0, 1]=(0.966410341879+0.389110018456j)*x[0]**o+((-0.0163229867526+0.527241979879j))*x[0]+((-0.826781973635+0.0451531327999j))*x[1]**o+((0.0158439995604-0.0447905175039j))*x[1]
        ref[2, 0, 1, 0]=(0.966410341879+0.389110018456j)*o*x_ref[0]**(o-1)+((-0.0163229867526+0.527241979879j))
        ref[2, 0, 1, 1]=(-0.826781973635+0.0451531327999j)*o*x_ref[1]**(o-1)+((0.0158439995604-0.0447905175039j))
        arg[2, 0, 2]=(-0.141923477434+0.248468770646j)*x[0]**o+((0.466682994167-0.656737785665j))*x[0]+((-0.428654143353+0.556964774066j))*x[1]**o+((0.481883019719-0.528132248786j))*x[1]
        ref[2, 0, 2, 0]=(-0.141923477434+0.248468770646j)*o*x_ref[0]**(o-1)+((0.466682994167-0.656737785665j))
        ref[2, 0, 2, 1]=(-0.428654143353+0.556964774066j)*o*x_ref[1]**(o-1)+((0.481883019719-0.528132248786j))
        arg[2, 1, 0]=(0.788019865213+0.479688834341j)*x[0]**o+((-0.723802171917-0.930175434974j))*x[0]+((-0.572694160847-0.42631465272j))*x[1]**o+((0.179890148533+0.189468498685j))*x[1]
        ref[2, 1, 0, 0]=(0.788019865213+0.479688834341j)*o*x_ref[0]**(o-1)+((-0.723802171917-0.930175434974j))
        ref[2, 1, 0, 1]=(-0.572694160847-0.42631465272j)*o*x_ref[1]**(o-1)+((0.179890148533+0.189468498685j))
        arg[2, 1, 1]=(-0.213430036081-0.978412397523j)*x[0]**o+((0.601997042011-0.804403504294j))*x[0]+((-0.273080716913-0.228077908823j))*x[1]**o+((-0.233433106314-0.999364383748j))*x[1]
        ref[2, 1, 1, 0]=(-0.213430036081-0.978412397523j)*o*x_ref[0]**(o-1)+((0.601997042011-0.804403504294j))
        ref[2, 1, 1, 1]=(-0.273080716913-0.228077908823j)*o*x_ref[1]**(o-1)+((-0.233433106314-0.999364383748j))
        arg[2, 1, 2]=(0.194611580598-0.0113323557231j)*x[0]**o+((0.481248019047-0.928818261525j))*x[0]+((-0.183152055881-0.496423583599j))*x[1]**o+((-0.472270903474+0.311569186769j))*x[1]
        ref[2, 1, 2, 0]=(0.194611580598-0.0113323557231j)*o*x_ref[0]**(o-1)+((0.481248019047-0.928818261525j))
        ref[2, 1, 2, 1]=(-0.183152055881-0.496423583599j)*o*x_ref[1]**(o-1)+((-0.472270903474+0.311569186769j))
        arg[2, 2, 0]=(0.858397315791+0.0282373908212j)*x[0]**o+((0.237817071541+0.376268113225j))*x[0]+((0.708839568625+0.699967498015j))*x[1]**o+((0.980096069709+0.773008059432j))*x[1]
        ref[2, 2, 0, 0]=(0.858397315791+0.0282373908212j)*o*x_ref[0]**(o-1)+((0.237817071541+0.376268113225j))
        ref[2, 2, 0, 1]=(0.708839568625+0.699967498015j)*o*x_ref[1]**(o-1)+((0.980096069709+0.773008059432j))
        arg[2, 2, 1]=(-0.468632650243-0.236789741859j)*x[0]**o+((-0.191536068479+0.599247754669j))*x[0]+((-0.977360261703+0.469001455205j))*x[1]**o+((-0.559796478216+0.457720603197j))*x[1]
        ref[2, 2, 1, 0]=(-0.468632650243-0.236789741859j)*o*x_ref[0]**(o-1)+((-0.191536068479+0.599247754669j))
        ref[2, 2, 1, 1]=(-0.977360261703+0.469001455205j)*o*x_ref[1]**(o-1)+((-0.559796478216+0.457720603197j))
        arg[2, 2, 2]=(0.228485398392-0.954121036955j)*x[0]**o+((0.275975282655+0.792507003914j))*x[0]+((-0.0418206977573-0.558568384126j))*x[1]**o+((-0.778451325083-0.671159443385j))*x[1]
        ref[2, 2, 2, 0]=(0.228485398392-0.954121036955j)*o*x_ref[0]**(o-1)+((0.275975282655+0.792507003914j))
        ref[2, 2, 2, 1]=(-0.0418206977573-0.558568384126j)*o*x_ref[1]**(o-1)+((-0.778451325083-0.671159443385j))
        arg[2, 3, 0]=(-0.800046847054+0.592612870318j)*x[0]**o+((-0.654432796862-0.796778827457j))*x[0]+((0.510613750484-0.792381468447j))*x[1]**o+((-0.288264864718+0.519398656966j))*x[1]
        ref[2, 3, 0, 0]=(-0.800046847054+0.592612870318j)*o*x_ref[0]**(o-1)+((-0.654432796862-0.796778827457j))
        ref[2, 3, 0, 1]=(0.510613750484-0.792381468447j)*o*x_ref[1]**(o-1)+((-0.288264864718+0.519398656966j))
        arg[2, 3, 1]=(0.0718566894414-0.820406256474j)*x[0]**o+((-0.137446721466+0.05134935879j))*x[0]+((-0.962384322694+0.276197510336j))*x[1]**o+((0.0813188346713+0.0510351916858j))*x[1]
        ref[2, 3, 1, 0]=(0.0718566894414-0.820406256474j)*o*x_ref[0]**(o-1)+((-0.137446721466+0.05134935879j))
        ref[2, 3, 1, 1]=(-0.962384322694+0.276197510336j)*o*x_ref[1]**(o-1)+((0.0813188346713+0.0510351916858j))
        arg[2, 3, 2]=(0.626080405851-0.998375593112j)*x[0]**o+((-0.302497596709+0.129942812055j))*x[0]+((-0.112721791763+0.770640506182j))*x[1]**o+((0.501930020015+0.542177095051j))*x[1]
        ref[2, 3, 2, 0]=(0.626080405851-0.998375593112j)*o*x_ref[0]**(o-1)+((-0.302497596709+0.129942812055j))
        ref[2, 3, 2, 1]=(-0.112721791763+0.770640506182j)*o*x_ref[1]**(o-1)+((0.501930020015+0.542177095051j))
        if dim==3:
            arg[0, 0, 0]+=(-0.865737789331-0.83289722826j)*x[2]**o+((0.485483533173+0.0349783447226j))*x[2]
            ref[0, 0, 0, 2]=(-0.865737789331-0.83289722826j)*o*x_ref[2]**(o-1)+((0.485483533173+0.0349783447226j))
            arg[0, 0, 1]+=(-0.343633534698-0.691626270705j)*x[2]**o+((0.668928663402+0.108996443069j))*x[2]
            ref[0, 0, 1, 2]=(-0.343633534698-0.691626270705j)*o*x_ref[2]**(o-1)+((0.668928663402+0.108996443069j))
            arg[0, 0, 2]+=(0.529262985508+0.370077484851j)*x[2]**o+((-0.615275140751+0.784698154816j))*x[2]
            ref[0, 0, 2, 2]=(0.529262985508+0.370077484851j)*o*x_ref[2]**(o-1)+((-0.615275140751+0.784698154816j))
            arg[0, 1, 0]+=(0.548483439229+0.784655668577j)*x[2]**o+((0.812794579681-0.932890626291j))*x[2]
            ref[0, 1, 0, 2]=(0.548483439229+0.784655668577j)*o*x_ref[2]**(o-1)+((0.812794579681-0.932890626291j))
            arg[0, 1, 1]+=(-0.323534471624+0.928289479674j)*x[2]**o+((-0.614047326675+0.559236585227j))*x[2]
            ref[0, 1, 1, 2]=(-0.323534471624+0.928289479674j)*o*x_ref[2]**(o-1)+((-0.614047326675+0.559236585227j))
            arg[0, 1, 2]+=(-0.209423712084-0.300303739831j)*x[2]**o+((0.992770693656-0.0633682201521j))*x[2]
            ref[0, 1, 2, 2]=(-0.209423712084-0.300303739831j)*o*x_ref[2]**(o-1)+((0.992770693656-0.0633682201521j))
            arg[0, 2, 0]+=(0.835786305548+0.753938598888j)*x[2]**o+((0.261022764732-0.0316326421428j))*x[2]
            ref[0, 2, 0, 2]=(0.835786305548+0.753938598888j)*o*x_ref[2]**(o-1)+((0.261022764732-0.0316326421428j))
            arg[0, 2, 1]+=(-0.634079708548-0.059783275632j)*x[2]**o+((-0.463407362678+0.00989361966211j))*x[2]
            ref[0, 2, 1, 2]=(-0.634079708548-0.059783275632j)*o*x_ref[2]**(o-1)+((-0.463407362678+0.00989361966211j))
            arg[0, 2, 2]+=(-0.324338511379+0.944156663437j)*x[2]**o+((0.274105289703+0.612714529644j))*x[2]
            ref[0, 2, 2, 2]=(-0.324338511379+0.944156663437j)*o*x_ref[2]**(o-1)+((0.274105289703+0.612714529644j))
            arg[0, 3, 0]+=(-0.825188039405+0.183032984404j)*x[2]**o+((-0.417870813595-0.345196652084j))*x[2]
            ref[0, 3, 0, 2]=(-0.825188039405+0.183032984404j)*o*x_ref[2]**(o-1)+((-0.417870813595-0.345196652084j))
            arg[0, 3, 1]+=(0.958337332072+0.754077195346j)*x[2]**o+((0.124158082361+0.399861914791j))*x[2]
            ref[0, 3, 1, 2]=(0.958337332072+0.754077195346j)*o*x_ref[2]**(o-1)+((0.124158082361+0.399861914791j))
            arg[0, 3, 2]+=(0.0997258251508-0.184747969597j)*x[2]**o+((-0.274237562769+0.602200285966j))*x[2]
            ref[0, 3, 2, 2]=(0.0997258251508-0.184747969597j)*o*x_ref[2]**(o-1)+((-0.274237562769+0.602200285966j))
            arg[1, 0, 0]+=(-0.599074841251+0.454999104565j)*x[2]**o+((-0.455415595281+0.949884212881j))*x[2]
            ref[1, 0, 0, 2]=(-0.599074841251+0.454999104565j)*o*x_ref[2]**(o-1)+((-0.455415595281+0.949884212881j))
            arg[1, 0, 1]+=(0.474826850831+0.72234465839j)*x[2]**o+((-0.57744596139+0.17326893558j))*x[2]
            ref[1, 0, 1, 2]=(0.474826850831+0.72234465839j)*o*x_ref[2]**(o-1)+((-0.57744596139+0.17326893558j))
            arg[1, 0, 2]+=(-0.747601159816-0.852321876431j)*x[2]**o+((0.312211641507+0.729587770869j))*x[2]
            ref[1, 0, 2, 2]=(-0.747601159816-0.852321876431j)*o*x_ref[2]**(o-1)+((0.312211641507+0.729587770869j))
            arg[1, 1, 0]+=(0.486331277864+0.408366153357j)*x[2]**o+((0.193809948436+0.837924684705j))*x[2]
            ref[1, 1, 0, 2]=(0.486331277864+0.408366153357j)*o*x_ref[2]**(o-1)+((0.193809948436+0.837924684705j))
            arg[1, 1, 1]+=(-0.682730480625+0.574028592063j)*x[2]**o+((0.101366169486+0.175497043925j))*x[2]
            ref[1, 1, 1, 2]=(-0.682730480625+0.574028592063j)*o*x_ref[2]**(o-1)+((0.101366169486+0.175497043925j))
            arg[1, 1, 2]+=(0.221460519129+0.0920204406129j)*x[2]**o+((0.975112877498+0.64203337622j))*x[2]
            ref[1, 1, 2, 2]=(0.221460519129+0.0920204406129j)*o*x_ref[2]**(o-1)+((0.975112877498+0.64203337622j))
            arg[1, 2, 0]+=(0.426479140195-0.325732321031j)*x[2]**o+((0.0332194458267-0.014362232889j))*x[2]
            ref[1, 2, 0, 2]=(0.426479140195-0.325732321031j)*o*x_ref[2]**(o-1)+((0.0332194458267-0.014362232889j))
            arg[1, 2, 1]+=(0.5923606257+0.615073514964j)*x[2]**o+((-0.198705856827+0.128612751367j))*x[2]
            ref[1, 2, 1, 2]=(0.5923606257+0.615073514964j)*o*x_ref[2]**(o-1)+((-0.198705856827+0.128612751367j))
            arg[1, 2, 2]+=(0.910290334683+0.451650364798j)*x[2]**o+((-0.0144704668587+0.294476920447j))*x[2]
            ref[1, 2, 2, 2]=(0.910290334683+0.451650364798j)*o*x_ref[2]**(o-1)+((-0.0144704668587+0.294476920447j))
            arg[1, 3, 0]+=(-0.0821665644627-0.464147448488j)*x[2]**o+((0.204143769775+0.161616390105j))*x[2]
            ref[1, 3, 0, 2]=(-0.0821665644627-0.464147448488j)*o*x_ref[2]**(o-1)+((0.204143769775+0.161616390105j))
            arg[1, 3, 1]+=(-0.138542562937+0.562829612883j)*x[2]**o+((-0.380252525607-0.157299446143j))*x[2]
            ref[1, 3, 1, 2]=(-0.138542562937+0.562829612883j)*o*x_ref[2]**(o-1)+((-0.380252525607-0.157299446143j))
            arg[1, 3, 2]+=(-0.763411501417-0.983141979497j)*x[2]**o+((0.95708986001-0.785940668152j))*x[2]
            ref[1, 3, 2, 2]=(-0.763411501417-0.983141979497j)*o*x_ref[2]**(o-1)+((0.95708986001-0.785940668152j))
            arg[2, 0, 0]+=(0.281822108807-0.51448829523j)*x[2]**o+((-0.701183905902+0.360547701408j))*x[2]
            ref[2, 0, 0, 2]=(0.281822108807-0.51448829523j)*o*x_ref[2]**(o-1)+((-0.701183905902+0.360547701408j))
            arg[2, 0, 1]+=(0.594871148133-0.307286901222j)*x[2]**o+((0.141143132844+0.421789661633j))*x[2]
            ref[2, 0, 1, 2]=(0.594871148133-0.307286901222j)*o*x_ref[2]**(o-1)+((0.141143132844+0.421789661633j))
            arg[2, 0, 2]+=(-0.897956949572-0.685593546961j)*x[2]**o+((-0.295857807535-0.644697433797j))*x[2]
            ref[2, 0, 2, 2]=(-0.897956949572-0.685593546961j)*o*x_ref[2]**(o-1)+((-0.295857807535-0.644697433797j))
            arg[2, 1, 0]+=(-0.953490364572-0.397879445311j)*x[2]**o+((0.669296314895-0.0547372724533j))*x[2]
            ref[2, 1, 0, 2]=(-0.953490364572-0.397879445311j)*o*x_ref[2]**(o-1)+((0.669296314895-0.0547372724533j))
            arg[2, 1, 1]+=(0.143303948879-0.0507478666524j)*x[2]**o+((0.143704283871+0.335703742986j))*x[2]
            ref[2, 1, 1, 2]=(0.143303948879-0.0507478666524j)*o*x_ref[2]**(o-1)+((0.143704283871+0.335703742986j))
            arg[2, 1, 2]+=(-0.329144861791+0.00301549935115j)*x[2]**o+((-0.572939218076-0.0758467624886j))*x[2]
            ref[2, 1, 2, 2]=(-0.329144861791+0.00301549935115j)*o*x_ref[2]**(o-1)+((-0.572939218076-0.0758467624886j))
            arg[2, 2, 0]+=(-0.932430494609-0.658040417185j)*x[2]**o+((-0.78462160145+0.913553428063j))*x[2]
            ref[2, 2, 0, 2]=(-0.932430494609-0.658040417185j)*o*x_ref[2]**(o-1)+((-0.78462160145+0.913553428063j))
            arg[2, 2, 1]+=(0.320614421353+0.154542748466j)*x[2]**o+((-0.446484962644+0.879796820991j))*x[2]
            ref[2, 2, 1, 2]=(0.320614421353+0.154542748466j)*o*x_ref[2]**(o-1)+((-0.446484962644+0.879796820991j))
            arg[2, 2, 2]+=(-0.151774836488-0.325067254116j)*x[2]**o+((0.588225079265-0.102343303843j))*x[2]
            ref[2, 2, 2, 2]=(-0.151774836488-0.325067254116j)*o*x_ref[2]**(o-1)+((0.588225079265-0.102343303843j))
            arg[2, 3, 0]+=(-0.161978675784+0.117876646358j)*x[2]**o+((-0.957371688484+0.828501114028j))*x[2]
            ref[2, 3, 0, 2]=(-0.161978675784+0.117876646358j)*o*x_ref[2]**(o-1)+((-0.957371688484+0.828501114028j))
            arg[2, 3, 1]+=(-0.551442643755+0.736914632186j)*x[2]**o+((-0.324890773681-0.739023732167j))*x[2]
            ref[2, 3, 1, 2]=(-0.551442643755+0.736914632186j)*o*x_ref[2]**(o-1)+((-0.324890773681-0.739023732167j))
            arg[2, 3, 2]+=(-0.953509247678+0.611032512811j)*x[2]**o+((-0.0883200954415-0.808908060516j))*x[2]
            ref[2, 3, 2, 2]=(-0.953509247678+0.611032512811j)*o*x_ref[2]**(o-1)+((-0.0883200954415-0.808908060516j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3, 4, 3)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnContactOne_fromData_Solution_rank0(self):
        """
        tests gradient of rank 0 Data on FunctionOnContactOne

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on FunctionOnContactOne
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnContactOne(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=(0.128150012782+0.852436798738j)*x[0]**o+((0.148293479119-0.794840489559j))*x[0]+((-0.101879588786-0.46329366497j))*x[1]**o+((0.179669324914+0.724327924344j))*x[1]
        ref[0]=(0.128150012782+0.852436798738j)*o*x_ref[0]**(o-1)+((0.148293479119-0.794840489559j))
        ref[1]=(-0.101879588786-0.46329366497j)*o*x_ref[1]**(o-1)+((0.179669324914+0.724327924344j))
        if dim==3:
            arg+=((0.715443637088-0.752370133913j))*x[2]**o+((0.699135612481+0.586774180924j))*x[2]
            ref[2]=(0.715443637088-0.752370133913j)*o*x_ref[2]**(o-1)+((0.699135612481+0.586774180924j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnContactOne_fromData_Solution_rank1(self):
        """
        tests gradient of rank 1 Data on FunctionOnContactOne

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on FunctionOnContactOne
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnContactOne(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(4,),w)
        ref = Data(0,(4,)+(dim,),w_ref)
        arg[0,]=(-0.683029941473-0.67999284049j)*x[0]**o+((-0.593978889741+0.786705650697j))*x[0]+((0.988763025914-0.776809944858j))*x[1]**o+((0.617995889981+0.00763369825642j))*x[1]
        ref[0, 0]=(-0.683029941473-0.67999284049j)*o*x_ref[0]**(o-1)+((-0.593978889741+0.786705650697j))
        ref[0, 1]=(0.988763025914-0.776809944858j)*o*x_ref[1]**(o-1)+((0.617995889981+0.00763369825642j))
        arg[1,]=(-0.565434612634+0.865782554835j)*x[0]**o+((0.726997094956+0.214293883771j))*x[0]+((-0.399838274848+0.619323698381j))*x[1]**o+((0.207838811752+0.525644448843j))*x[1]
        ref[1, 0]=(-0.565434612634+0.865782554835j)*o*x_ref[0]**(o-1)+((0.726997094956+0.214293883771j))
        ref[1, 1]=(-0.399838274848+0.619323698381j)*o*x_ref[1]**(o-1)+((0.207838811752+0.525644448843j))
        arg[2,]=(-0.781828818778+0.444178529411j)*x[0]**o+((-0.201196417855-0.246876157366j))*x[0]+((0.295515097911-0.858661586622j))*x[1]**o+((0.27555111254+0.542498719078j))*x[1]
        ref[2, 0]=(-0.781828818778+0.444178529411j)*o*x_ref[0]**(o-1)+((-0.201196417855-0.246876157366j))
        ref[2, 1]=(0.295515097911-0.858661586622j)*o*x_ref[1]**(o-1)+((0.27555111254+0.542498719078j))
        arg[3,]=(-0.011949525403+0.0128759348256j)*x[0]**o+((-0.734757684461-0.0473501109544j))*x[0]+((-0.907872063794+0.557786687299j))*x[1]**o+((-0.423928201095-0.894458615359j))*x[1]
        ref[3, 0]=(-0.011949525403+0.0128759348256j)*o*x_ref[0]**(o-1)+((-0.734757684461-0.0473501109544j))
        ref[3, 1]=(-0.907872063794+0.557786687299j)*o*x_ref[1]**(o-1)+((-0.423928201095-0.894458615359j))
        if dim==3:
            arg[0,]+=(-0.507012839477-0.448318775123j)*x[2]**o+((-0.162305958897+0.930995074441j))*x[2]
            ref[0, 2]=(-0.507012839477-0.448318775123j)*o*x_ref[2]**(o-1)+((-0.162305958897+0.930995074441j))
            arg[1,]+=(0.260692519239+0.0181724207872j)*x[2]**o+((0.976341984832-0.0179344299955j))*x[2]
            ref[1, 2]=(0.260692519239+0.0181724207872j)*o*x_ref[2]**(o-1)+((0.976341984832-0.0179344299955j))
            arg[2,]+=(-0.936541891988+0.85213118034j)*x[2]**o+((0.951722748402-0.887136066187j))*x[2]
            ref[2, 2]=(-0.936541891988+0.85213118034j)*o*x_ref[2]**(o-1)+((0.951722748402-0.887136066187j))
            arg[3,]+=(-0.901170207648-0.217299769789j)*x[2]**o+((0.394680645565-0.693281317504j))*x[2]
            ref[3, 2]=(-0.901170207648-0.217299769789j)*o*x_ref[2]**(o-1)+((0.394680645565-0.693281317504j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnContactOne_fromData_Solution_rank2(self):
        """
        tests gradient of rank 2 Data on FunctionOnContactOne

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on FunctionOnContactOne
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnContactOne(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(2, 2),w)
        ref = Data(0,(2, 2)+(dim,),w_ref)
        arg[0, 0]=(-0.855115339189+0.356758279725j)*x[0]**o+((-0.84528477855-0.916520277015j))*x[0]+((0.595815508391+0.973697356098j))*x[1]**o+((0.829955303334-0.74845028629j))*x[1]
        ref[0, 0, 0]=(-0.855115339189+0.356758279725j)*o*x_ref[0]**(o-1)+((-0.84528477855-0.916520277015j))
        ref[0, 0, 1]=(0.595815508391+0.973697356098j)*o*x_ref[1]**(o-1)+((0.829955303334-0.74845028629j))
        arg[0, 1]=(-0.887708098991+0.682981681076j)*x[0]**o+((-0.887264419281-0.590750642068j))*x[0]+((0.146177857944-0.0833353946395j))*x[1]**o+((-0.34261374962+0.796904345609j))*x[1]
        ref[0, 1, 0]=(-0.887708098991+0.682981681076j)*o*x_ref[0]**(o-1)+((-0.887264419281-0.590750642068j))
        ref[0, 1, 1]=(0.146177857944-0.0833353946395j)*o*x_ref[1]**(o-1)+((-0.34261374962+0.796904345609j))
        arg[1, 0]=(-0.376865158166+0.70464925748j)*x[0]**o+((-0.170920889562+0.0737168175382j))*x[0]+((-0.158248076995-0.902486084131j))*x[1]**o+((-0.295433363141-0.754700643445j))*x[1]
        ref[1, 0, 0]=(-0.376865158166+0.70464925748j)*o*x_ref[0]**(o-1)+((-0.170920889562+0.0737168175382j))
        ref[1, 0, 1]=(-0.158248076995-0.902486084131j)*o*x_ref[1]**(o-1)+((-0.295433363141-0.754700643445j))
        arg[1, 1]=(0.579991868391-0.602817111655j)*x[0]**o+((-0.00426232068316-0.363902992711j))*x[0]+((0.867701241217+0.592536994402j))*x[1]**o+((0.230421606856+0.0642753799197j))*x[1]
        ref[1, 1, 0]=(0.579991868391-0.602817111655j)*o*x_ref[0]**(o-1)+((-0.00426232068316-0.363902992711j))
        ref[1, 1, 1]=(0.867701241217+0.592536994402j)*o*x_ref[1]**(o-1)+((0.230421606856+0.0642753799197j))
        if dim==3:
            arg[0, 0]+=(0.678563355215+0.858117982155j)*x[2]**o+((-0.851776864844-0.362997697774j))*x[2]
            ref[0, 0, 2]=(0.678563355215+0.858117982155j)*o*x_ref[2]**(o-1)+((-0.851776864844-0.362997697774j))
            arg[0, 1]+=(0.815409375563-0.746944604491j)*x[2]**o+((0.55132119213+0.730390500256j))*x[2]
            ref[0, 1, 2]=(0.815409375563-0.746944604491j)*o*x_ref[2]**(o-1)+((0.55132119213+0.730390500256j))
            arg[1, 0]+=(0.338320436402-0.935282397146j)*x[2]**o+((0.469340932744+0.0727935734823j))*x[2]
            ref[1, 0, 2]=(0.338320436402-0.935282397146j)*o*x_ref[2]**(o-1)+((0.469340932744+0.0727935734823j))
            arg[1, 1]+=(0.777055818612-0.383542999269j)*x[2]**o+((0.414337157137+0.29618859452j))*x[2]
            ref[1, 1, 2]=(0.777055818612-0.383542999269j)*o*x_ref[2]**(o-1)+((0.414337157137+0.29618859452j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2, 2)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnContactOne_fromData_Solution_rank3(self):
        """
        tests gradient of rank 3 Data on FunctionOnContactOne

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on FunctionOnContactOne
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnContactOne(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(4, 3, 2),w)
        ref = Data(0,(4, 3, 2)+(dim,),w_ref)
        arg[0, 0, 0]=(-0.0834339553863+0.481925008594j)*x[0]**o+((-0.685389026584-0.213843905798j))*x[0]+((0.716691846526-0.3604154716j))*x[1]**o+((-0.707830852417-0.273208382395j))*x[1]
        ref[0, 0, 0, 0]=(-0.0834339553863+0.481925008594j)*o*x_ref[0]**(o-1)+((-0.685389026584-0.213843905798j))
        ref[0, 0, 0, 1]=(0.716691846526-0.3604154716j)*o*x_ref[1]**(o-1)+((-0.707830852417-0.273208382395j))
        arg[0, 0, 1]=(0.528345674401-0.570715314427j)*x[0]**o+((0.661617852326-0.418995856803j))*x[0]+((-0.974462971351-0.416310030409j))*x[1]**o+((-0.672824540614+0.316462078226j))*x[1]
        ref[0, 0, 1, 0]=(0.528345674401-0.570715314427j)*o*x_ref[0]**(o-1)+((0.661617852326-0.418995856803j))
        ref[0, 0, 1, 1]=(-0.974462971351-0.416310030409j)*o*x_ref[1]**(o-1)+((-0.672824540614+0.316462078226j))
        arg[0, 1, 0]=(0.443942339187-0.261272206302j)*x[0]**o+((0.440947713599-0.245656526193j))*x[0]+((-0.0722631086443+0.235753823815j))*x[1]**o+((0.812725262343-0.958229753236j))*x[1]
        ref[0, 1, 0, 0]=(0.443942339187-0.261272206302j)*o*x_ref[0]**(o-1)+((0.440947713599-0.245656526193j))
        ref[0, 1, 0, 1]=(-0.0722631086443+0.235753823815j)*o*x_ref[1]**(o-1)+((0.812725262343-0.958229753236j))
        arg[0, 1, 1]=(0.442626972589+0.0553509785645j)*x[0]**o+((0.652178838172+0.467299117572j))*x[0]+((-0.923628871567-0.734236114702j))*x[1]**o+((0.471589123284+0.485381969381j))*x[1]
        ref[0, 1, 1, 0]=(0.442626972589+0.0553509785645j)*o*x_ref[0]**(o-1)+((0.652178838172+0.467299117572j))
        ref[0, 1, 1, 1]=(-0.923628871567-0.734236114702j)*o*x_ref[1]**(o-1)+((0.471589123284+0.485381969381j))
        arg[0, 2, 0]=(0.419922007778-0.330132773268j)*x[0]**o+((-0.21680631096-0.634102402466j))*x[0]+((-0.806514782075-0.274226646045j))*x[1]**o+((0.104572268435-0.0015253232772j))*x[1]
        ref[0, 2, 0, 0]=(0.419922007778-0.330132773268j)*o*x_ref[0]**(o-1)+((-0.21680631096-0.634102402466j))
        ref[0, 2, 0, 1]=(-0.806514782075-0.274226646045j)*o*x_ref[1]**(o-1)+((0.104572268435-0.0015253232772j))
        arg[0, 2, 1]=(0.0638977024333+0.815528700867j)*x[0]**o+((-0.478602803265-0.218010339345j))*x[0]+((-0.341075283553+0.614478772542j))*x[1]**o+((-0.253210735429-0.46899487917j))*x[1]
        ref[0, 2, 1, 0]=(0.0638977024333+0.815528700867j)*o*x_ref[0]**(o-1)+((-0.478602803265-0.218010339345j))
        ref[0, 2, 1, 1]=(-0.341075283553+0.614478772542j)*o*x_ref[1]**(o-1)+((-0.253210735429-0.46899487917j))
        arg[1, 0, 0]=(0.443144659263-0.070070799261j)*x[0]**o+((0.20564754826+0.958138560787j))*x[0]+((0.187208153405-0.0274259553889j))*x[1]**o+((-0.722034801166-0.657751278806j))*x[1]
        ref[1, 0, 0, 0]=(0.443144659263-0.070070799261j)*o*x_ref[0]**(o-1)+((0.20564754826+0.958138560787j))
        ref[1, 0, 0, 1]=(0.187208153405-0.0274259553889j)*o*x_ref[1]**(o-1)+((-0.722034801166-0.657751278806j))
        arg[1, 0, 1]=(-0.0440674842115-0.868393549421j)*x[0]**o+((-0.852472120259-0.0514555160263j))*x[0]+((0.871016268659-0.691522686304j))*x[1]**o+((0.633783948334+0.395407401743j))*x[1]
        ref[1, 0, 1, 0]=(-0.0440674842115-0.868393549421j)*o*x_ref[0]**(o-1)+((-0.852472120259-0.0514555160263j))
        ref[1, 0, 1, 1]=(0.871016268659-0.691522686304j)*o*x_ref[1]**(o-1)+((0.633783948334+0.395407401743j))
        arg[1, 1, 0]=(0.00503227266519+0.0252361664942j)*x[0]**o+((0.658474682155+0.382611134097j))*x[0]+((-0.211225607786+0.102592160828j))*x[1]**o+((0.871206310039-0.925155993231j))*x[1]
        ref[1, 1, 0, 0]=(0.00503227266519+0.0252361664942j)*o*x_ref[0]**(o-1)+((0.658474682155+0.382611134097j))
        ref[1, 1, 0, 1]=(-0.211225607786+0.102592160828j)*o*x_ref[1]**(o-1)+((0.871206310039-0.925155993231j))
        arg[1, 1, 1]=(-0.932097813708+0.252973668027j)*x[0]**o+((0.462787457668-0.170987911628j))*x[0]+((-0.181526207968+0.529168582502j))*x[1]**o+((-0.904837196822+0.747007092573j))*x[1]
        ref[1, 1, 1, 0]=(-0.932097813708+0.252973668027j)*o*x_ref[0]**(o-1)+((0.462787457668-0.170987911628j))
        ref[1, 1, 1, 1]=(-0.181526207968+0.529168582502j)*o*x_ref[1]**(o-1)+((-0.904837196822+0.747007092573j))
        arg[1, 2, 0]=(-0.373285583796-0.497612016581j)*x[0]**o+((0.831104538519+0.388873269514j))*x[0]+((0.486890401035-0.445994507409j))*x[1]**o+((0.0103806800085-0.384792701649j))*x[1]
        ref[1, 2, 0, 0]=(-0.373285583796-0.497612016581j)*o*x_ref[0]**(o-1)+((0.831104538519+0.388873269514j))
        ref[1, 2, 0, 1]=(0.486890401035-0.445994507409j)*o*x_ref[1]**(o-1)+((0.0103806800085-0.384792701649j))
        arg[1, 2, 1]=(0.0788768332117-0.538008848818j)*x[0]**o+((0.137003463012-0.858369782196j))*x[0]+((0.277035842591+0.869312196852j))*x[1]**o+((-0.705555645029-0.0543753351912j))*x[1]
        ref[1, 2, 1, 0]=(0.0788768332117-0.538008848818j)*o*x_ref[0]**(o-1)+((0.137003463012-0.858369782196j))
        ref[1, 2, 1, 1]=(0.277035842591+0.869312196852j)*o*x_ref[1]**(o-1)+((-0.705555645029-0.0543753351912j))
        arg[2, 0, 0]=(-0.29186334004-0.601558735601j)*x[0]**o+((-0.463842737603-0.119133424304j))*x[0]+((-0.837363799806-0.895794239669j))*x[1]**o+((-0.0957456392975+0.611335631339j))*x[1]
        ref[2, 0, 0, 0]=(-0.29186334004-0.601558735601j)*o*x_ref[0]**(o-1)+((-0.463842737603-0.119133424304j))
        ref[2, 0, 0, 1]=(-0.837363799806-0.895794239669j)*o*x_ref[1]**(o-1)+((-0.0957456392975+0.611335631339j))
        arg[2, 0, 1]=(-0.994191629511-0.500079521154j)*x[0]**o+((0.778522094362+0.996693924568j))*x[0]+((-0.628884020159+0.501151501805j))*x[1]**o+((0.925433918429+0.193391469101j))*x[1]
        ref[2, 0, 1, 0]=(-0.994191629511-0.500079521154j)*o*x_ref[0]**(o-1)+((0.778522094362+0.996693924568j))
        ref[2, 0, 1, 1]=(-0.628884020159+0.501151501805j)*o*x_ref[1]**(o-1)+((0.925433918429+0.193391469101j))
        arg[2, 1, 0]=(0.239963267985-0.447028376715j)*x[0]**o+((0.410121537887+0.0314310175841j))*x[0]+((-0.212315390012-0.178261483946j))*x[1]**o+((-0.241457885906+0.200027577195j))*x[1]
        ref[2, 1, 0, 0]=(0.239963267985-0.447028376715j)*o*x_ref[0]**(o-1)+((0.410121537887+0.0314310175841j))
        ref[2, 1, 0, 1]=(-0.212315390012-0.178261483946j)*o*x_ref[1]**(o-1)+((-0.241457885906+0.200027577195j))
        arg[2, 1, 1]=(0.484067604506+0.922140094476j)*x[0]**o+((0.381057883874+0.0572476875614j))*x[0]+((0.388947949057+0.618459880591j))*x[1]**o+((-0.79482947261+0.805607121948j))*x[1]
        ref[2, 1, 1, 0]=(0.484067604506+0.922140094476j)*o*x_ref[0]**(o-1)+((0.381057883874+0.0572476875614j))
        ref[2, 1, 1, 1]=(0.388947949057+0.618459880591j)*o*x_ref[1]**(o-1)+((-0.79482947261+0.805607121948j))
        arg[2, 2, 0]=(-0.317259860816-0.831758829298j)*x[0]**o+((-0.170470440985-0.409699709887j))*x[0]+((0.101267843368-0.20692314726j))*x[1]**o+((0.476367494227-0.344159575663j))*x[1]
        ref[2, 2, 0, 0]=(-0.317259860816-0.831758829298j)*o*x_ref[0]**(o-1)+((-0.170470440985-0.409699709887j))
        ref[2, 2, 0, 1]=(0.101267843368-0.20692314726j)*o*x_ref[1]**(o-1)+((0.476367494227-0.344159575663j))
        arg[2, 2, 1]=(0.78642714046+0.450497126531j)*x[0]**o+((0.316122061729-0.971652256058j))*x[0]+((0.765353267796+0.277718383554j))*x[1]**o+((-0.982847273684+0.759993601421j))*x[1]
        ref[2, 2, 1, 0]=(0.78642714046+0.450497126531j)*o*x_ref[0]**(o-1)+((0.316122061729-0.971652256058j))
        ref[2, 2, 1, 1]=(0.765353267796+0.277718383554j)*o*x_ref[1]**(o-1)+((-0.982847273684+0.759993601421j))
        arg[3, 0, 0]=(-0.311586095721-0.179876128448j)*x[0]**o+((0.726857210676-0.137574603024j))*x[0]+((-0.364325593985-0.737509146862j))*x[1]**o+((0.354285436471-0.633330657455j))*x[1]
        ref[3, 0, 0, 0]=(-0.311586095721-0.179876128448j)*o*x_ref[0]**(o-1)+((0.726857210676-0.137574603024j))
        ref[3, 0, 0, 1]=(-0.364325593985-0.737509146862j)*o*x_ref[1]**(o-1)+((0.354285436471-0.633330657455j))
        arg[3, 0, 1]=(0.885830493899-0.54174908145j)*x[0]**o+((-0.389274929045-0.165318257701j))*x[0]+((-0.812862616241-0.265847961044j))*x[1]**o+((-0.506312360018+0.16317625839j))*x[1]
        ref[3, 0, 1, 0]=(0.885830493899-0.54174908145j)*o*x_ref[0]**(o-1)+((-0.389274929045-0.165318257701j))
        ref[3, 0, 1, 1]=(-0.812862616241-0.265847961044j)*o*x_ref[1]**(o-1)+((-0.506312360018+0.16317625839j))
        arg[3, 1, 0]=(0.124007324299-0.372249642308j)*x[0]**o+((-0.763851858862-0.42972083939j))*x[0]+((0.534268037321-0.642040255413j))*x[1]**o+((0.511114791791-0.0345070309554j))*x[1]
        ref[3, 1, 0, 0]=(0.124007324299-0.372249642308j)*o*x_ref[0]**(o-1)+((-0.763851858862-0.42972083939j))
        ref[3, 1, 0, 1]=(0.534268037321-0.642040255413j)*o*x_ref[1]**(o-1)+((0.511114791791-0.0345070309554j))
        arg[3, 1, 1]=(-0.684156079075+0.593202371889j)*x[0]**o+((-0.77430661573-0.04072716533j))*x[0]+((0.291443933661-0.870571739027j))*x[1]**o+((-0.323826183244+0.67278479991j))*x[1]
        ref[3, 1, 1, 0]=(-0.684156079075+0.593202371889j)*o*x_ref[0]**(o-1)+((-0.77430661573-0.04072716533j))
        ref[3, 1, 1, 1]=(0.291443933661-0.870571739027j)*o*x_ref[1]**(o-1)+((-0.323826183244+0.67278479991j))
        arg[3, 2, 0]=(0.638112614548+0.542395068386j)*x[0]**o+((0.551501566548-0.493580691495j))*x[0]+((0.971445126639-0.637986683271j))*x[1]**o+((-0.89801342124-0.0953463033184j))*x[1]
        ref[3, 2, 0, 0]=(0.638112614548+0.542395068386j)*o*x_ref[0]**(o-1)+((0.551501566548-0.493580691495j))
        ref[3, 2, 0, 1]=(0.971445126639-0.637986683271j)*o*x_ref[1]**(o-1)+((-0.89801342124-0.0953463033184j))
        arg[3, 2, 1]=(-0.0752158077935+0.33805216747j)*x[0]**o+((-0.230612958823-0.412915579j))*x[0]+((-0.439717129733-0.512220814865j))*x[1]**o+((0.573585550711-0.377205427074j))*x[1]
        ref[3, 2, 1, 0]=(-0.0752158077935+0.33805216747j)*o*x_ref[0]**(o-1)+((-0.230612958823-0.412915579j))
        ref[3, 2, 1, 1]=(-0.439717129733-0.512220814865j)*o*x_ref[1]**(o-1)+((0.573585550711-0.377205427074j))
        if dim==3:
            arg[0, 0, 0]+=(-0.652493539123-0.485985806521j)*x[2]**o+((0.193499329932+0.224708836442j))*x[2]
            ref[0, 0, 0, 2]=(-0.652493539123-0.485985806521j)*o*x_ref[2]**(o-1)+((0.193499329932+0.224708836442j))
            arg[0, 0, 1]+=(0.954968153573-0.616051239505j)*x[2]**o+((-0.954861083659-0.623911743465j))*x[2]
            ref[0, 0, 1, 2]=(0.954968153573-0.616051239505j)*o*x_ref[2]**(o-1)+((-0.954861083659-0.623911743465j))
            arg[0, 1, 0]+=(0.756340423699+0.397228951652j)*x[2]**o+((0.649540231262+0.549959158975j))*x[2]
            ref[0, 1, 0, 2]=(0.756340423699+0.397228951652j)*o*x_ref[2]**(o-1)+((0.649540231262+0.549959158975j))
            arg[0, 1, 1]+=(-0.342907114243+0.973396511249j)*x[2]**o+((-0.046111692497+0.564042834123j))*x[2]
            ref[0, 1, 1, 2]=(-0.342907114243+0.973396511249j)*o*x_ref[2]**(o-1)+((-0.046111692497+0.564042834123j))
            arg[0, 2, 0]+=(0.174268648277+0.153845403565j)*x[2]**o+((0.738185752805+0.541901209137j))*x[2]
            ref[0, 2, 0, 2]=(0.174268648277+0.153845403565j)*o*x_ref[2]**(o-1)+((0.738185752805+0.541901209137j))
            arg[0, 2, 1]+=(0.329577691489+0.498677615639j)*x[2]**o+((-0.33409688166-0.556872576673j))*x[2]
            ref[0, 2, 1, 2]=(0.329577691489+0.498677615639j)*o*x_ref[2]**(o-1)+((-0.33409688166-0.556872576673j))
            arg[1, 0, 0]+=(-0.653795251089+0.991885530447j)*x[2]**o+((0.678542195142-0.00611203661149j))*x[2]
            ref[1, 0, 0, 2]=(-0.653795251089+0.991885530447j)*o*x_ref[2]**(o-1)+((0.678542195142-0.00611203661149j))
            arg[1, 0, 1]+=(-0.0274350262108-0.355785561164j)*x[2]**o+((0.355320825869-0.183254713502j))*x[2]
            ref[1, 0, 1, 2]=(-0.0274350262108-0.355785561164j)*o*x_ref[2]**(o-1)+((0.355320825869-0.183254713502j))
            arg[1, 1, 0]+=(0.899768935485+0.836834851112j)*x[2]**o+((-0.142189336199-0.228458860116j))*x[2]
            ref[1, 1, 0, 2]=(0.899768935485+0.836834851112j)*o*x_ref[2]**(o-1)+((-0.142189336199-0.228458860116j))
            arg[1, 1, 1]+=(0.652523552061-0.696376927456j)*x[2]**o+((-0.0855734443721+0.886554337325j))*x[2]
            ref[1, 1, 1, 2]=(0.652523552061-0.696376927456j)*o*x_ref[2]**(o-1)+((-0.0855734443721+0.886554337325j))
            arg[1, 2, 0]+=(0.252628652934-0.0973793967772j)*x[2]**o+((-0.854145657969-0.368788224255j))*x[2]
            ref[1, 2, 0, 2]=(0.252628652934-0.0973793967772j)*o*x_ref[2]**(o-1)+((-0.854145657969-0.368788224255j))
            arg[1, 2, 1]+=(-0.443999395859-0.655691504232j)*x[2]**o+((-0.728246335807+0.43413151599j))*x[2]
            ref[1, 2, 1, 2]=(-0.443999395859-0.655691504232j)*o*x_ref[2]**(o-1)+((-0.728246335807+0.43413151599j))
            arg[2, 0, 0]+=(0.395217510601+0.46643933719j)*x[2]**o+((0.308511909167+0.162866094392j))*x[2]
            ref[2, 0, 0, 2]=(0.395217510601+0.46643933719j)*o*x_ref[2]**(o-1)+((0.308511909167+0.162866094392j))
            arg[2, 0, 1]+=(-0.841978277794+0.369777787132j)*x[2]**o+((0.282509314198-0.65802525686j))*x[2]
            ref[2, 0, 1, 2]=(-0.841978277794+0.369777787132j)*o*x_ref[2]**(o-1)+((0.282509314198-0.65802525686j))
            arg[2, 1, 0]+=(-0.661657117396+0.376480717225j)*x[2]**o+((0.955790295888-0.336434308903j))*x[2]
            ref[2, 1, 0, 2]=(-0.661657117396+0.376480717225j)*o*x_ref[2]**(o-1)+((0.955790295888-0.336434308903j))
            arg[2, 1, 1]+=(0.973294473607-0.207035750549j)*x[2]**o+((0.0449404964315-0.76114683969j))*x[2]
            ref[2, 1, 1, 2]=(0.973294473607-0.207035750549j)*o*x_ref[2]**(o-1)+((0.0449404964315-0.76114683969j))
            arg[2, 2, 0]+=(-0.188393080822-0.980339367334j)*x[2]**o+((0.688300697286+0.651459102632j))*x[2]
            ref[2, 2, 0, 2]=(-0.188393080822-0.980339367334j)*o*x_ref[2]**(o-1)+((0.688300697286+0.651459102632j))
            arg[2, 2, 1]+=(0.847264813216-0.56846528666j)*x[2]**o+((-0.934501949457+0.326087306288j))*x[2]
            ref[2, 2, 1, 2]=(0.847264813216-0.56846528666j)*o*x_ref[2]**(o-1)+((-0.934501949457+0.326087306288j))
            arg[3, 0, 0]+=(0.687629434166+0.549440578441j)*x[2]**o+((0.707042213082-0.459024346582j))*x[2]
            ref[3, 0, 0, 2]=(0.687629434166+0.549440578441j)*o*x_ref[2]**(o-1)+((0.707042213082-0.459024346582j))
            arg[3, 0, 1]+=(-0.821078018951-0.667138558427j)*x[2]**o+((-0.735206362907-0.482787308222j))*x[2]
            ref[3, 0, 1, 2]=(-0.821078018951-0.667138558427j)*o*x_ref[2]**(o-1)+((-0.735206362907-0.482787308222j))
            arg[3, 1, 0]+=(-0.408806591672+0.773313959736j)*x[2]**o+((0.473926680525-0.643038552794j))*x[2]
            ref[3, 1, 0, 2]=(-0.408806591672+0.773313959736j)*o*x_ref[2]**(o-1)+((0.473926680525-0.643038552794j))
            arg[3, 1, 1]+=(-0.372560249179+0.0173632293402j)*x[2]**o+((-0.542297729401-0.897635731397j))*x[2]
            ref[3, 1, 1, 2]=(-0.372560249179+0.0173632293402j)*o*x_ref[2]**(o-1)+((-0.542297729401-0.897635731397j))
            arg[3, 2, 0]+=(-0.749917567505+0.783855520936j)*x[2]**o+((0.616485885201+0.974412968295j))*x[2]
            ref[3, 2, 0, 2]=(-0.749917567505+0.783855520936j)*o*x_ref[2]**(o-1)+((0.616485885201+0.974412968295j))
            arg[3, 2, 1]+=(0.565417009897-0.507653220449j)*x[2]**o+((-0.045544247558-0.327636482584j))*x[2]
            ref[3, 2, 1, 2]=(0.565417009897-0.507653220449j)*o*x_ref[2]**(o-1)+((-0.045544247558-0.327636482584j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4, 3, 2)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnContactOne_fromData_ReducedSolution_rank0(self):
        """
        tests gradient of rank 0 Data on FunctionOnContactOne

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on FunctionOnContactOne
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnContactOne(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=(0.987999003917-0.435171194898j)*x[0]+((0.181753572832-0.583238251195j))*x[1]
        ref[0]=(0.987999003917-0.435171194898j)
        ref[1]=(0.181753572832-0.583238251195j)
        if dim==3:
            arg+=((-0.438763305336+0.424883598162j))*x[2]
            ref[2]=(-0.438763305336+0.424883598162j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnContactOne_fromData_ReducedSolution_rank1(self):
        """
        tests gradient of rank 1 Data on FunctionOnContactOne

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on FunctionOnContactOne
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnContactOne(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(4,),w)
        ref = Data(0,(4,)+(dim,),w_ref)
        arg[0,]=(0.391252338149+0.300200823706j)*x[0]+((0.931483795049+0.0832121355835j))*x[1]
        ref[0, 0]=(0.391252338149+0.300200823706j)
        ref[0, 1]=(0.931483795049+0.0832121355835j)
        arg[1,]=(0.119392324946+0.778995928516j)*x[0]+((-0.501401777176+0.962819876145j))*x[1]
        ref[1, 0]=(0.119392324946+0.778995928516j)
        ref[1, 1]=(-0.501401777176+0.962819876145j)
        arg[2,]=(-0.552426343999-0.400802850763j)*x[0]+((-0.229499687775-0.965170820744j))*x[1]
        ref[2, 0]=(-0.552426343999-0.400802850763j)
        ref[2, 1]=(-0.229499687775-0.965170820744j)
        arg[3,]=(0.416209673003-0.142322935414j)*x[0]+((-0.661006629721-0.209692786342j))*x[1]
        ref[3, 0]=(0.416209673003-0.142322935414j)
        ref[3, 1]=(-0.661006629721-0.209692786342j)
        if dim==3:
            arg[0,]+=(-0.994828868311+0.762538871158j)*x[2]
            ref[0, 2]=(-0.994828868311+0.762538871158j)
            arg[1,]+=(0.708965563891-0.161879450473j)*x[2]
            ref[1, 2]=(0.708965563891-0.161879450473j)
            arg[2,]+=(0.625222984404-0.0792044184893j)*x[2]
            ref[2, 2]=(0.625222984404-0.0792044184893j)
            arg[3,]+=(0.135053053362-0.605463113612j)*x[2]
            ref[3, 2]=(0.135053053362-0.605463113612j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnContactOne_fromData_ReducedSolution_rank2(self):
        """
        tests gradient of rank 2 Data on FunctionOnContactOne

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on FunctionOnContactOne
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnContactOne(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(2, 4),w)
        ref = Data(0,(2, 4)+(dim,),w_ref)
        arg[0, 0]=(-0.411789798842+0.356586191374j)*x[0]+((-0.701920883256+0.308008522717j))*x[1]
        ref[0, 0, 0]=(-0.411789798842+0.356586191374j)
        ref[0, 0, 1]=(-0.701920883256+0.308008522717j)
        arg[0, 1]=(-0.197782710881-0.167382915013j)*x[0]+((0.650822673864-0.243300940878j))*x[1]
        ref[0, 1, 0]=(-0.197782710881-0.167382915013j)
        ref[0, 1, 1]=(0.650822673864-0.243300940878j)
        arg[0, 2]=(0.191965747823-0.748955242434j)*x[0]+((0.168079121697+0.33658919055j))*x[1]
        ref[0, 2, 0]=(0.191965747823-0.748955242434j)
        ref[0, 2, 1]=(0.168079121697+0.33658919055j)
        arg[0, 3]=(0.866984815841+0.941285027814j)*x[0]+((-0.331515543206+0.171502221323j))*x[1]
        ref[0, 3, 0]=(0.866984815841+0.941285027814j)
        ref[0, 3, 1]=(-0.331515543206+0.171502221323j)
        arg[1, 0]=(0.214595749661-0.0617937077777j)*x[0]+((-0.329465652373-0.841623292158j))*x[1]
        ref[1, 0, 0]=(0.214595749661-0.0617937077777j)
        ref[1, 0, 1]=(-0.329465652373-0.841623292158j)
        arg[1, 1]=(-0.528034521838-0.241681247203j)*x[0]+((0.85784857777-0.211937932851j))*x[1]
        ref[1, 1, 0]=(-0.528034521838-0.241681247203j)
        ref[1, 1, 1]=(0.85784857777-0.211937932851j)
        arg[1, 2]=(0.415586714197+0.826245147979j)*x[0]+((-0.482390910814-0.238130818934j))*x[1]
        ref[1, 2, 0]=(0.415586714197+0.826245147979j)
        ref[1, 2, 1]=(-0.482390910814-0.238130818934j)
        arg[1, 3]=(-0.663286224855+0.0704628670295j)*x[0]+((0.919754286484+0.0415108563317j))*x[1]
        ref[1, 3, 0]=(-0.663286224855+0.0704628670295j)
        ref[1, 3, 1]=(0.919754286484+0.0415108563317j)
        if dim==3:
            arg[0, 0]+=(0.334475810795+0.672324465447j)*x[2]
            ref[0, 0, 2]=(0.334475810795+0.672324465447j)
            arg[0, 1]+=(0.255973423873+0.156917571915j)*x[2]
            ref[0, 1, 2]=(0.255973423873+0.156917571915j)
            arg[0, 2]+=(0.752613682847-0.728752572252j)*x[2]
            ref[0, 2, 2]=(0.752613682847-0.728752572252j)
            arg[0, 3]+=(-0.673461852801-0.517806763323j)*x[2]
            ref[0, 3, 2]=(-0.673461852801-0.517806763323j)
            arg[1, 0]+=(-0.702111911777+0.131928677216j)*x[2]
            ref[1, 0, 2]=(-0.702111911777+0.131928677216j)
            arg[1, 1]+=(-0.350752120883+0.165819964807j)*x[2]
            ref[1, 1, 2]=(-0.350752120883+0.165819964807j)
            arg[1, 2]+=(-0.967993205423+0.480282455529j)*x[2]
            ref[1, 2, 2]=(-0.967993205423+0.480282455529j)
            arg[1, 3]+=(-0.0302939478577+0.742214695305j)*x[2]
            ref[1, 3, 2]=(-0.0302939478577+0.742214695305j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2, 4)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnContactOne_fromData_ReducedSolution_rank3(self):
        """
        tests gradient of rank 3 Data on FunctionOnContactOne

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on FunctionOnContactOne
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnContactOne(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(4, 4, 3),w)
        ref = Data(0,(4, 4, 3)+(dim,),w_ref)
        arg[0, 0, 0]=(-0.207047196988-0.0296467641985j)*x[0]+((0.609026373929-0.337519094083j))*x[1]
        ref[0, 0, 0, 0]=(-0.207047196988-0.0296467641985j)
        ref[0, 0, 0, 1]=(0.609026373929-0.337519094083j)
        arg[0, 0, 1]=(-0.425531955171-0.658364408916j)*x[0]+((-0.315510614304+0.125834379161j))*x[1]
        ref[0, 0, 1, 0]=(-0.425531955171-0.658364408916j)
        ref[0, 0, 1, 1]=(-0.315510614304+0.125834379161j)
        arg[0, 0, 2]=(-0.563552425504-0.0715275813268j)*x[0]+((-0.450182023711+0.479720360122j))*x[1]
        ref[0, 0, 2, 0]=(-0.563552425504-0.0715275813268j)
        ref[0, 0, 2, 1]=(-0.450182023711+0.479720360122j)
        arg[0, 1, 0]=(-0.455372972476+0.361763486586j)*x[0]+((-0.457132950802-0.531527730175j))*x[1]
        ref[0, 1, 0, 0]=(-0.455372972476+0.361763486586j)
        ref[0, 1, 0, 1]=(-0.457132950802-0.531527730175j)
        arg[0, 1, 1]=(0.25099142982-0.0620558100922j)*x[0]+((-0.988620627348+0.608325874746j))*x[1]
        ref[0, 1, 1, 0]=(0.25099142982-0.0620558100922j)
        ref[0, 1, 1, 1]=(-0.988620627348+0.608325874746j)
        arg[0, 1, 2]=(0.407437877563+0.57545620501j)*x[0]+((0.241684223176-0.432806352805j))*x[1]
        ref[0, 1, 2, 0]=(0.407437877563+0.57545620501j)
        ref[0, 1, 2, 1]=(0.241684223176-0.432806352805j)
        arg[0, 2, 0]=(-0.050683739713-0.0405626783943j)*x[0]+((-0.638153418264+0.435551224448j))*x[1]
        ref[0, 2, 0, 0]=(-0.050683739713-0.0405626783943j)
        ref[0, 2, 0, 1]=(-0.638153418264+0.435551224448j)
        arg[0, 2, 1]=(-0.505367350143-0.791699040987j)*x[0]+((-0.494475867177+0.802216398457j))*x[1]
        ref[0, 2, 1, 0]=(-0.505367350143-0.791699040987j)
        ref[0, 2, 1, 1]=(-0.494475867177+0.802216398457j)
        arg[0, 2, 2]=(-0.0107142660312-0.95889390015j)*x[0]+((0.309203669663-0.973570546814j))*x[1]
        ref[0, 2, 2, 0]=(-0.0107142660312-0.95889390015j)
        ref[0, 2, 2, 1]=(0.309203669663-0.973570546814j)
        arg[0, 3, 0]=(-0.293606365739+0.834894040064j)*x[0]+((0.365330759314-0.333901500678j))*x[1]
        ref[0, 3, 0, 0]=(-0.293606365739+0.834894040064j)
        ref[0, 3, 0, 1]=(0.365330759314-0.333901500678j)
        arg[0, 3, 1]=(-0.794392145624+0.401645762161j)*x[0]+((0.134983369266-0.956010737852j))*x[1]
        ref[0, 3, 1, 0]=(-0.794392145624+0.401645762161j)
        ref[0, 3, 1, 1]=(0.134983369266-0.956010737852j)
        arg[0, 3, 2]=(0.156977493255+0.302266004881j)*x[0]+((-0.195589525921-0.654690970755j))*x[1]
        ref[0, 3, 2, 0]=(0.156977493255+0.302266004881j)
        ref[0, 3, 2, 1]=(-0.195589525921-0.654690970755j)
        arg[1, 0, 0]=(-0.589694632281+0.960754868756j)*x[0]+((0.213602969415+0.519186518062j))*x[1]
        ref[1, 0, 0, 0]=(-0.589694632281+0.960754868756j)
        ref[1, 0, 0, 1]=(0.213602969415+0.519186518062j)
        arg[1, 0, 1]=(0.921831583948+0.899731205904j)*x[0]+((0.122218105223+0.786947434278j))*x[1]
        ref[1, 0, 1, 0]=(0.921831583948+0.899731205904j)
        ref[1, 0, 1, 1]=(0.122218105223+0.786947434278j)
        arg[1, 0, 2]=(0.87366856132+0.230000243777j)*x[0]+((-0.0558227627646-0.44133776679j))*x[1]
        ref[1, 0, 2, 0]=(0.87366856132+0.230000243777j)
        ref[1, 0, 2, 1]=(-0.0558227627646-0.44133776679j)
        arg[1, 1, 0]=(0.0543014463859-0.721324983918j)*x[0]+((0.208704447092-0.964470044119j))*x[1]
        ref[1, 1, 0, 0]=(0.0543014463859-0.721324983918j)
        ref[1, 1, 0, 1]=(0.208704447092-0.964470044119j)
        arg[1, 1, 1]=(-0.649695440169+0.119109903183j)*x[0]+((0.0548341931302+0.10262378242j))*x[1]
        ref[1, 1, 1, 0]=(-0.649695440169+0.119109903183j)
        ref[1, 1, 1, 1]=(0.0548341931302+0.10262378242j)
        arg[1, 1, 2]=(0.291263616563-0.241369394661j)*x[0]+((0.465237150685-0.87987027253j))*x[1]
        ref[1, 1, 2, 0]=(0.291263616563-0.241369394661j)
        ref[1, 1, 2, 1]=(0.465237150685-0.87987027253j)
        arg[1, 2, 0]=(-0.681892510079+0.729299558827j)*x[0]+((0.821694810544-0.44326529967j))*x[1]
        ref[1, 2, 0, 0]=(-0.681892510079+0.729299558827j)
        ref[1, 2, 0, 1]=(0.821694810544-0.44326529967j)
        arg[1, 2, 1]=(0.247926077133+0.0799270127076j)*x[0]+((-0.33818536855+0.478921618641j))*x[1]
        ref[1, 2, 1, 0]=(0.247926077133+0.0799270127076j)
        ref[1, 2, 1, 1]=(-0.33818536855+0.478921618641j)
        arg[1, 2, 2]=(0.761939404014-0.109031696274j)*x[0]+((-0.970494356829-0.169098672611j))*x[1]
        ref[1, 2, 2, 0]=(0.761939404014-0.109031696274j)
        ref[1, 2, 2, 1]=(-0.970494356829-0.169098672611j)
        arg[1, 3, 0]=(-0.357315313768+0.135971307801j)*x[0]+((0.0666784012317+0.422916007856j))*x[1]
        ref[1, 3, 0, 0]=(-0.357315313768+0.135971307801j)
        ref[1, 3, 0, 1]=(0.0666784012317+0.422916007856j)
        arg[1, 3, 1]=(-0.145555417765-0.802278830095j)*x[0]+((0.82696009361-0.589436114524j))*x[1]
        ref[1, 3, 1, 0]=(-0.145555417765-0.802278830095j)
        ref[1, 3, 1, 1]=(0.82696009361-0.589436114524j)
        arg[1, 3, 2]=(-0.712542425631-0.228617284222j)*x[0]+((0.0442340097361-0.633008593486j))*x[1]
        ref[1, 3, 2, 0]=(-0.712542425631-0.228617284222j)
        ref[1, 3, 2, 1]=(0.0442340097361-0.633008593486j)
        arg[2, 0, 0]=(-0.511783440784+0.614367212756j)*x[0]+((0.920792515894+0.268193118395j))*x[1]
        ref[2, 0, 0, 0]=(-0.511783440784+0.614367212756j)
        ref[2, 0, 0, 1]=(0.920792515894+0.268193118395j)
        arg[2, 0, 1]=(-0.450127362288+0.191121686588j)*x[0]+((-0.244225863298+0.0123580760522j))*x[1]
        ref[2, 0, 1, 0]=(-0.450127362288+0.191121686588j)
        ref[2, 0, 1, 1]=(-0.244225863298+0.0123580760522j)
        arg[2, 0, 2]=(-0.447804564549+0.215565865678j)*x[0]+((0.64892271478+0.380534397906j))*x[1]
        ref[2, 0, 2, 0]=(-0.447804564549+0.215565865678j)
        ref[2, 0, 2, 1]=(0.64892271478+0.380534397906j)
        arg[2, 1, 0]=(-0.147740956498+0.535821028548j)*x[0]+((0.490517891441+0.674743066083j))*x[1]
        ref[2, 1, 0, 0]=(-0.147740956498+0.535821028548j)
        ref[2, 1, 0, 1]=(0.490517891441+0.674743066083j)
        arg[2, 1, 1]=(0.108979409514-0.602176957677j)*x[0]+((-0.186441385985+0.157735118893j))*x[1]
        ref[2, 1, 1, 0]=(0.108979409514-0.602176957677j)
        ref[2, 1, 1, 1]=(-0.186441385985+0.157735118893j)
        arg[2, 1, 2]=(0.167851934796+0.533053655885j)*x[0]+((0.33137981284+0.828921505821j))*x[1]
        ref[2, 1, 2, 0]=(0.167851934796+0.533053655885j)
        ref[2, 1, 2, 1]=(0.33137981284+0.828921505821j)
        arg[2, 2, 0]=(0.385803461201-0.310626367095j)*x[0]+((0.355730091888-0.95347651199j))*x[1]
        ref[2, 2, 0, 0]=(0.385803461201-0.310626367095j)
        ref[2, 2, 0, 1]=(0.355730091888-0.95347651199j)
        arg[2, 2, 1]=(0.775539872265+0.266609096165j)*x[0]+((-0.763500492601-0.251297669205j))*x[1]
        ref[2, 2, 1, 0]=(0.775539872265+0.266609096165j)
        ref[2, 2, 1, 1]=(-0.763500492601-0.251297669205j)
        arg[2, 2, 2]=(-0.829473823248-0.798529426073j)*x[0]+((-0.680660735656+0.786789625968j))*x[1]
        ref[2, 2, 2, 0]=(-0.829473823248-0.798529426073j)
        ref[2, 2, 2, 1]=(-0.680660735656+0.786789625968j)
        arg[2, 3, 0]=(-0.62809567774+0.910927511338j)*x[0]+((-0.0139413581269-0.689415318463j))*x[1]
        ref[2, 3, 0, 0]=(-0.62809567774+0.910927511338j)
        ref[2, 3, 0, 1]=(-0.0139413581269-0.689415318463j)
        arg[2, 3, 1]=(-0.18330134889+0.700653781193j)*x[0]+((-0.335410247132-0.647682105431j))*x[1]
        ref[2, 3, 1, 0]=(-0.18330134889+0.700653781193j)
        ref[2, 3, 1, 1]=(-0.335410247132-0.647682105431j)
        arg[2, 3, 2]=(-0.235489585806+0.222059901269j)*x[0]+((-0.870343760529+0.528931508153j))*x[1]
        ref[2, 3, 2, 0]=(-0.235489585806+0.222059901269j)
        ref[2, 3, 2, 1]=(-0.870343760529+0.528931508153j)
        arg[3, 0, 0]=(0.547192564488-0.900482692765j)*x[0]+((-0.922934944431-0.811880335448j))*x[1]
        ref[3, 0, 0, 0]=(0.547192564488-0.900482692765j)
        ref[3, 0, 0, 1]=(-0.922934944431-0.811880335448j)
        arg[3, 0, 1]=(0.713783707188+0.428947729799j)*x[0]+((-0.893525966921+0.703486590186j))*x[1]
        ref[3, 0, 1, 0]=(0.713783707188+0.428947729799j)
        ref[3, 0, 1, 1]=(-0.893525966921+0.703486590186j)
        arg[3, 0, 2]=(0.854086598905-0.447474485126j)*x[0]+((0.468477172649-0.127363858208j))*x[1]
        ref[3, 0, 2, 0]=(0.854086598905-0.447474485126j)
        ref[3, 0, 2, 1]=(0.468477172649-0.127363858208j)
        arg[3, 1, 0]=(-0.148916999181-0.267034752214j)*x[0]+((-0.106114049694+0.194703361593j))*x[1]
        ref[3, 1, 0, 0]=(-0.148916999181-0.267034752214j)
        ref[3, 1, 0, 1]=(-0.106114049694+0.194703361593j)
        arg[3, 1, 1]=(-0.246477893322+0.873575915224j)*x[0]+((-0.512553332837-0.756580303105j))*x[1]
        ref[3, 1, 1, 0]=(-0.246477893322+0.873575915224j)
        ref[3, 1, 1, 1]=(-0.512553332837-0.756580303105j)
        arg[3, 1, 2]=(-0.980310769947+0.374708533626j)*x[0]+((0.320825647411-0.843434822281j))*x[1]
        ref[3, 1, 2, 0]=(-0.980310769947+0.374708533626j)
        ref[3, 1, 2, 1]=(0.320825647411-0.843434822281j)
        arg[3, 2, 0]=(-0.810380796731-0.714928368185j)*x[0]+((-0.198722523915+0.219371253879j))*x[1]
        ref[3, 2, 0, 0]=(-0.810380796731-0.714928368185j)
        ref[3, 2, 0, 1]=(-0.198722523915+0.219371253879j)
        arg[3, 2, 1]=(-0.833376853176+0.740645223268j)*x[0]+((-0.206948837481-0.496222048085j))*x[1]
        ref[3, 2, 1, 0]=(-0.833376853176+0.740645223268j)
        ref[3, 2, 1, 1]=(-0.206948837481-0.496222048085j)
        arg[3, 2, 2]=(0.25626585613+0.839898052855j)*x[0]+((-0.306359443619+0.350516085521j))*x[1]
        ref[3, 2, 2, 0]=(0.25626585613+0.839898052855j)
        ref[3, 2, 2, 1]=(-0.306359443619+0.350516085521j)
        arg[3, 3, 0]=(-0.0655746384726+0.441781832165j)*x[0]+((-0.374232096649-0.777591968824j))*x[1]
        ref[3, 3, 0, 0]=(-0.0655746384726+0.441781832165j)
        ref[3, 3, 0, 1]=(-0.374232096649-0.777591968824j)
        arg[3, 3, 1]=(0.739533505036-0.639715608833j)*x[0]+((-0.927247314658+0.230452277901j))*x[1]
        ref[3, 3, 1, 0]=(0.739533505036-0.639715608833j)
        ref[3, 3, 1, 1]=(-0.927247314658+0.230452277901j)
        arg[3, 3, 2]=(-0.490216529947-0.183770747101j)*x[0]+((0.359930469025+0.167175343843j))*x[1]
        ref[3, 3, 2, 0]=(-0.490216529947-0.183770747101j)
        ref[3, 3, 2, 1]=(0.359930469025+0.167175343843j)
        if dim==3:
            arg[0, 0, 0]+=(-0.980867230927+0.232120858787j)*x[2]
            ref[0, 0, 0, 2]=(-0.980867230927+0.232120858787j)
            arg[0, 0, 1]+=(-0.728871225867-0.389785387434j)*x[2]
            ref[0, 0, 1, 2]=(-0.728871225867-0.389785387434j)
            arg[0, 0, 2]+=(-0.283201368494+0.678337697452j)*x[2]
            ref[0, 0, 2, 2]=(-0.283201368494+0.678337697452j)
            arg[0, 1, 0]+=(-0.552882482436+0.212471805099j)*x[2]
            ref[0, 1, 0, 2]=(-0.552882482436+0.212471805099j)
            arg[0, 1, 1]+=(-0.742183270525-0.347890208005j)*x[2]
            ref[0, 1, 1, 2]=(-0.742183270525-0.347890208005j)
            arg[0, 1, 2]+=(0.842186696506+0.550049759485j)*x[2]
            ref[0, 1, 2, 2]=(0.842186696506+0.550049759485j)
            arg[0, 2, 0]+=(0.756599018509-0.999311621522j)*x[2]
            ref[0, 2, 0, 2]=(0.756599018509-0.999311621522j)
            arg[0, 2, 1]+=(0.893293457721+0.921469841188j)*x[2]
            ref[0, 2, 1, 2]=(0.893293457721+0.921469841188j)
            arg[0, 2, 2]+=(0.893697466529-0.993251431718j)*x[2]
            ref[0, 2, 2, 2]=(0.893697466529-0.993251431718j)
            arg[0, 3, 0]+=(-0.50029760198+0.928872465773j)*x[2]
            ref[0, 3, 0, 2]=(-0.50029760198+0.928872465773j)
            arg[0, 3, 1]+=(0.324167678379-0.764668403788j)*x[2]
            ref[0, 3, 1, 2]=(0.324167678379-0.764668403788j)
            arg[0, 3, 2]+=(-0.747575049282-0.516147243213j)*x[2]
            ref[0, 3, 2, 2]=(-0.747575049282-0.516147243213j)
            arg[1, 0, 0]+=(0.843724491724-0.518638119843j)*x[2]
            ref[1, 0, 0, 2]=(0.843724491724-0.518638119843j)
            arg[1, 0, 1]+=(0.810017146321-0.261731994139j)*x[2]
            ref[1, 0, 1, 2]=(0.810017146321-0.261731994139j)
            arg[1, 0, 2]+=(-0.703006384761+0.903313964432j)*x[2]
            ref[1, 0, 2, 2]=(-0.703006384761+0.903313964432j)
            arg[1, 1, 0]+=(0.814785186504-0.124829141797j)*x[2]
            ref[1, 1, 0, 2]=(0.814785186504-0.124829141797j)
            arg[1, 1, 1]+=(0.0695843837579-0.954549816747j)*x[2]
            ref[1, 1, 1, 2]=(0.0695843837579-0.954549816747j)
            arg[1, 1, 2]+=(0.57618830996-0.76327101858j)*x[2]
            ref[1, 1, 2, 2]=(0.57618830996-0.76327101858j)
            arg[1, 2, 0]+=(0.395067836669-0.442951070725j)*x[2]
            ref[1, 2, 0, 2]=(0.395067836669-0.442951070725j)
            arg[1, 2, 1]+=(-0.359588358068-0.575234219027j)*x[2]
            ref[1, 2, 1, 2]=(-0.359588358068-0.575234219027j)
            arg[1, 2, 2]+=(0.824008517933+0.807812663863j)*x[2]
            ref[1, 2, 2, 2]=(0.824008517933+0.807812663863j)
            arg[1, 3, 0]+=(0.205228149932-0.130343292666j)*x[2]
            ref[1, 3, 0, 2]=(0.205228149932-0.130343292666j)
            arg[1, 3, 1]+=(-0.400538401105-0.957149467934j)*x[2]
            ref[1, 3, 1, 2]=(-0.400538401105-0.957149467934j)
            arg[1, 3, 2]+=(0.620011589178+0.104912697205j)*x[2]
            ref[1, 3, 2, 2]=(0.620011589178+0.104912697205j)
            arg[2, 0, 0]+=(-0.427000666843-0.951795027168j)*x[2]
            ref[2, 0, 0, 2]=(-0.427000666843-0.951795027168j)
            arg[2, 0, 1]+=(-0.308394024056+0.00987524936907j)*x[2]
            ref[2, 0, 1, 2]=(-0.308394024056+0.00987524936907j)
            arg[2, 0, 2]+=(0.137773977717+0.802235423643j)*x[2]
            ref[2, 0, 2, 2]=(0.137773977717+0.802235423643j)
            arg[2, 1, 0]+=(-0.524454337337+0.215722654826j)*x[2]
            ref[2, 1, 0, 2]=(-0.524454337337+0.215722654826j)
            arg[2, 1, 1]+=(-0.443287154213+0.572760585659j)*x[2]
            ref[2, 1, 1, 2]=(-0.443287154213+0.572760585659j)
            arg[2, 1, 2]+=(-0.138518259214+0.0596323971305j)*x[2]
            ref[2, 1, 2, 2]=(-0.138518259214+0.0596323971305j)
            arg[2, 2, 0]+=(0.295519276915+0.512543875829j)*x[2]
            ref[2, 2, 0, 2]=(0.295519276915+0.512543875829j)
            arg[2, 2, 1]+=(0.58684183317+0.425397516062j)*x[2]
            ref[2, 2, 1, 2]=(0.58684183317+0.425397516062j)
            arg[2, 2, 2]+=(-0.0237216436149+0.0204215797224j)*x[2]
            ref[2, 2, 2, 2]=(-0.0237216436149+0.0204215797224j)
            arg[2, 3, 0]+=(0.837287912807-0.201346575682j)*x[2]
            ref[2, 3, 0, 2]=(0.837287912807-0.201346575682j)
            arg[2, 3, 1]+=(-0.159215370801+0.369717940181j)*x[2]
            ref[2, 3, 1, 2]=(-0.159215370801+0.369717940181j)
            arg[2, 3, 2]+=(-0.682494673819-0.218887193394j)*x[2]
            ref[2, 3, 2, 2]=(-0.682494673819-0.218887193394j)
            arg[3, 0, 0]+=(0.0306421185478-0.101237257598j)*x[2]
            ref[3, 0, 0, 2]=(0.0306421185478-0.101237257598j)
            arg[3, 0, 1]+=(-0.773603018974-0.200925704402j)*x[2]
            ref[3, 0, 1, 2]=(-0.773603018974-0.200925704402j)
            arg[3, 0, 2]+=(-0.101183449872+0.885036902566j)*x[2]
            ref[3, 0, 2, 2]=(-0.101183449872+0.885036902566j)
            arg[3, 1, 0]+=(-0.563657916531-0.415459716082j)*x[2]
            ref[3, 1, 0, 2]=(-0.563657916531-0.415459716082j)
            arg[3, 1, 1]+=(0.420330621491+0.531077290641j)*x[2]
            ref[3, 1, 1, 2]=(0.420330621491+0.531077290641j)
            arg[3, 1, 2]+=(-0.453514711727+0.0512863608666j)*x[2]
            ref[3, 1, 2, 2]=(-0.453514711727+0.0512863608666j)
            arg[3, 2, 0]+=(-0.180241873112+0.779151519774j)*x[2]
            ref[3, 2, 0, 2]=(-0.180241873112+0.779151519774j)
            arg[3, 2, 1]+=(0.0668053216632+0.446830146369j)*x[2]
            ref[3, 2, 1, 2]=(0.0668053216632+0.446830146369j)
            arg[3, 2, 2]+=(0.793054392246-0.270717052254j)*x[2]
            ref[3, 2, 2, 2]=(0.793054392246-0.270717052254j)
            arg[3, 3, 0]+=(-0.138552221551-0.95092128208j)*x[2]
            ref[3, 3, 0, 2]=(-0.138552221551-0.95092128208j)
            arg[3, 3, 1]+=(0.0873660317511+0.690857670406j)*x[2]
            ref[3, 3, 1, 2]=(0.0873660317511+0.690857670406j)
            arg[3, 3, 2]+=(-0.784966346658-0.649539240615j)*x[2]
            ref[3, 3, 2, 2]=(-0.784966346658-0.649539240615j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4, 4, 3)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnContactOne_fromData_ReducedContinuousFunction_rank0(self):
        """
        tests gradient of rank 0 Data on FunctionOnContactOne

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on FunctionOnContactOne
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnContactOne(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=(-0.402119896754-0.58549226233j)*x[0]+((0.644785348819+0.0379756934615j))*x[1]
        ref[0]=(-0.402119896754-0.58549226233j)
        ref[1]=(0.644785348819+0.0379756934615j)
        if dim==3:
            arg+=((-0.267129663048+0.0677218432684j))*x[2]
            ref[2]=(-0.267129663048+0.0677218432684j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnContactOne_fromData_ReducedContinuousFunction_rank1(self):
        """
        tests gradient of rank 1 Data on FunctionOnContactOne

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on FunctionOnContactOne
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnContactOne(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(3,),w)
        ref = Data(0,(3,)+(dim,),w_ref)
        arg[0,]=(0.601516938676+0.268484366258j)*x[0]+((0.700332849911+0.0541977924917j))*x[1]
        ref[0, 0]=(0.601516938676+0.268484366258j)
        ref[0, 1]=(0.700332849911+0.0541977924917j)
        arg[1,]=(-0.530251308746-0.203513887639j)*x[0]+((0.123486255194+0.835780087485j))*x[1]
        ref[1, 0]=(-0.530251308746-0.203513887639j)
        ref[1, 1]=(0.123486255194+0.835780087485j)
        arg[2,]=(0.760397474234+0.62511781982j)*x[0]+((-0.696957564928+0.514393256625j))*x[1]
        ref[2, 0]=(0.760397474234+0.62511781982j)
        ref[2, 1]=(-0.696957564928+0.514393256625j)
        if dim==3:
            arg[0,]+=(0.755141896321-0.215489403872j)*x[2]
            ref[0, 2]=(0.755141896321-0.215489403872j)
            arg[1,]+=(-0.822481280973+0.666741313842j)*x[2]
            ref[1, 2]=(-0.822481280973+0.666741313842j)
            arg[2,]+=(0.939163350603-0.147730567049j)*x[2]
            ref[2, 2]=(0.939163350603-0.147730567049j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnContactOne_fromData_ReducedContinuousFunction_rank2(self):
        """
        tests gradient of rank 2 Data on FunctionOnContactOne

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on FunctionOnContactOne
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnContactOne(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(3, 2),w)
        ref = Data(0,(3, 2)+(dim,),w_ref)
        arg[0, 0]=(0.484573903589-0.955768733071j)*x[0]+((-0.542340694026+0.883926229131j))*x[1]
        ref[0, 0, 0]=(0.484573903589-0.955768733071j)
        ref[0, 0, 1]=(-0.542340694026+0.883926229131j)
        arg[0, 1]=(-0.0267587792662+0.149041761528j)*x[0]+((0.311464155737+0.982818064656j))*x[1]
        ref[0, 1, 0]=(-0.0267587792662+0.149041761528j)
        ref[0, 1, 1]=(0.311464155737+0.982818064656j)
        arg[1, 0]=(0.942874231457-0.819401369317j)*x[0]+((-0.512937061847-0.429814665976j))*x[1]
        ref[1, 0, 0]=(0.942874231457-0.819401369317j)
        ref[1, 0, 1]=(-0.512937061847-0.429814665976j)
        arg[1, 1]=(-0.730955257339-0.667284092821j)*x[0]+((-0.229866070132-0.483043240697j))*x[1]
        ref[1, 1, 0]=(-0.730955257339-0.667284092821j)
        ref[1, 1, 1]=(-0.229866070132-0.483043240697j)
        arg[2, 0]=(0.620218890747-0.754076858658j)*x[0]+((0.120624063575-0.682661686327j))*x[1]
        ref[2, 0, 0]=(0.620218890747-0.754076858658j)
        ref[2, 0, 1]=(0.120624063575-0.682661686327j)
        arg[2, 1]=(-0.309230457237+0.0588802803232j)*x[0]+((0.994728987727+0.359010764428j))*x[1]
        ref[2, 1, 0]=(-0.309230457237+0.0588802803232j)
        ref[2, 1, 1]=(0.994728987727+0.359010764428j)
        if dim==3:
            arg[0, 0]+=(0.671093547507-0.772398065276j)*x[2]
            ref[0, 0, 2]=(0.671093547507-0.772398065276j)
            arg[0, 1]+=(-0.539598055722+0.827305399189j)*x[2]
            ref[0, 1, 2]=(-0.539598055722+0.827305399189j)
            arg[1, 0]+=(-0.195362239572+0.0751141431016j)*x[2]
            ref[1, 0, 2]=(-0.195362239572+0.0751141431016j)
            arg[1, 1]+=(0.777886180586-0.474921929309j)*x[2]
            ref[1, 1, 2]=(0.777886180586-0.474921929309j)
            arg[2, 0]+=(-0.874831480065+0.589307053699j)*x[2]
            ref[2, 0, 2]=(-0.874831480065+0.589307053699j)
            arg[2, 1]+=(-0.314352705101-0.848560412321j)*x[2]
            ref[2, 1, 2]=(-0.314352705101-0.848560412321j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3, 2)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onFunctionOnContactOne_fromData_ReducedContinuousFunction_rank3(self):
        """
        tests gradient of rank 3 Data on FunctionOnContactOne

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on FunctionOnContactOne
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnContactOne(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(4, 2, 4),w)
        ref = Data(0,(4, 2, 4)+(dim,),w_ref)
        arg[0, 0, 0]=(0.5558659098+0.779468181162j)*x[0]+((-0.29552386209-0.362686057713j))*x[1]
        ref[0, 0, 0, 0]=(0.5558659098+0.779468181162j)
        ref[0, 0, 0, 1]=(-0.29552386209-0.362686057713j)
        arg[0, 0, 1]=(-0.34637657769-0.899492532583j)*x[0]+((0.689153592092+0.879524139051j))*x[1]
        ref[0, 0, 1, 0]=(-0.34637657769-0.899492532583j)
        ref[0, 0, 1, 1]=(0.689153592092+0.879524139051j)
        arg[0, 0, 2]=(0.0623459507475-0.399308411587j)*x[0]+((-0.886502511065+0.542280798571j))*x[1]
        ref[0, 0, 2, 0]=(0.0623459507475-0.399308411587j)
        ref[0, 0, 2, 1]=(-0.886502511065+0.542280798571j)
        arg[0, 0, 3]=(0.110351466512+0.439557507635j)*x[0]+((0.866251362068-0.935164218961j))*x[1]
        ref[0, 0, 3, 0]=(0.110351466512+0.439557507635j)
        ref[0, 0, 3, 1]=(0.866251362068-0.935164218961j)
        arg[0, 1, 0]=(-0.859090156719-0.185605160012j)*x[0]+((0.398073578505+0.850470800762j))*x[1]
        ref[0, 1, 0, 0]=(-0.859090156719-0.185605160012j)
        ref[0, 1, 0, 1]=(0.398073578505+0.850470800762j)
        arg[0, 1, 1]=(0.726494223851+0.0876392325541j)*x[0]+((0.366257777672-0.908373363941j))*x[1]
        ref[0, 1, 1, 0]=(0.726494223851+0.0876392325541j)
        ref[0, 1, 1, 1]=(0.366257777672-0.908373363941j)
        arg[0, 1, 2]=(0.395848130781-0.0146457622081j)*x[0]+((0.790929100982-0.560682130399j))*x[1]
        ref[0, 1, 2, 0]=(0.395848130781-0.0146457622081j)
        ref[0, 1, 2, 1]=(0.790929100982-0.560682130399j)
        arg[0, 1, 3]=(0.379098243624+0.276337000876j)*x[0]+((0.8569548691-0.807221271328j))*x[1]
        ref[0, 1, 3, 0]=(0.379098243624+0.276337000876j)
        ref[0, 1, 3, 1]=(0.8569548691-0.807221271328j)
        arg[1, 0, 0]=(0.915800190597+0.99260277811j)*x[0]+((0.642303739426+0.929931098458j))*x[1]
        ref[1, 0, 0, 0]=(0.915800190597+0.99260277811j)
        ref[1, 0, 0, 1]=(0.642303739426+0.929931098458j)
        arg[1, 0, 1]=(-0.220521603581-0.124177209268j)*x[0]+((-0.617055779566+0.43538651833j))*x[1]
        ref[1, 0, 1, 0]=(-0.220521603581-0.124177209268j)
        ref[1, 0, 1, 1]=(-0.617055779566+0.43538651833j)
        arg[1, 0, 2]=(-0.63100568555+0.95161685966j)*x[0]+((-0.640211999563+0.221467464963j))*x[1]
        ref[1, 0, 2, 0]=(-0.63100568555+0.95161685966j)
        ref[1, 0, 2, 1]=(-0.640211999563+0.221467464963j)
        arg[1, 0, 3]=(-0.273450134703+0.342409991704j)*x[0]+((-0.685883963709+0.782921485j))*x[1]
        ref[1, 0, 3, 0]=(-0.273450134703+0.342409991704j)
        ref[1, 0, 3, 1]=(-0.685883963709+0.782921485j)
        arg[1, 1, 0]=(0.510834645642-0.702357061127j)*x[0]+((-0.545610470111-0.448238217308j))*x[1]
        ref[1, 1, 0, 0]=(0.510834645642-0.702357061127j)
        ref[1, 1, 0, 1]=(-0.545610470111-0.448238217308j)
        arg[1, 1, 1]=(-0.458017249058+0.0124762885362j)*x[0]+((0.778042821704+0.706162634876j))*x[1]
        ref[1, 1, 1, 0]=(-0.458017249058+0.0124762885362j)
        ref[1, 1, 1, 1]=(0.778042821704+0.706162634876j)
        arg[1, 1, 2]=(0.131803865305+0.83667403128j)*x[0]+((0.287073740951-0.795189447068j))*x[1]
        ref[1, 1, 2, 0]=(0.131803865305+0.83667403128j)
        ref[1, 1, 2, 1]=(0.287073740951-0.795189447068j)
        arg[1, 1, 3]=(-0.744856003803+0.181229094649j)*x[0]+((-0.463693223901-0.146747415327j))*x[1]
        ref[1, 1, 3, 0]=(-0.744856003803+0.181229094649j)
        ref[1, 1, 3, 1]=(-0.463693223901-0.146747415327j)
        arg[2, 0, 0]=(-0.293204646118+0.641738790091j)*x[0]+((-0.160312476383-0.0647965032025j))*x[1]
        ref[2, 0, 0, 0]=(-0.293204646118+0.641738790091j)
        ref[2, 0, 0, 1]=(-0.160312476383-0.0647965032025j)
        arg[2, 0, 1]=(0.184201469056+0.108416929812j)*x[0]+((-0.910310165566+0.921513476343j))*x[1]
        ref[2, 0, 1, 0]=(0.184201469056+0.108416929812j)
        ref[2, 0, 1, 1]=(-0.910310165566+0.921513476343j)
        arg[2, 0, 2]=(-0.821630088169+0.500870736602j)*x[0]+((0.0180242611159-0.972823754918j))*x[1]
        ref[2, 0, 2, 0]=(-0.821630088169+0.500870736602j)
        ref[2, 0, 2, 1]=(0.0180242611159-0.972823754918j)
        arg[2, 0, 3]=(-0.0182912527802-0.535643349193j)*x[0]+((-0.090717749324+0.954476117554j))*x[1]
        ref[2, 0, 3, 0]=(-0.0182912527802-0.535643349193j)
        ref[2, 0, 3, 1]=(-0.090717749324+0.954476117554j)
        arg[2, 1, 0]=(0.136786653228+0.681727230263j)*x[0]+((0.336529800859+0.30974874623j))*x[1]
        ref[2, 1, 0, 0]=(0.136786653228+0.681727230263j)
        ref[2, 1, 0, 1]=(0.336529800859+0.30974874623j)
        arg[2, 1, 1]=(-0.00445590214132-0.280732928349j)*x[0]+((0.998267208071+0.601268334612j))*x[1]
        ref[2, 1, 1, 0]=(-0.00445590214132-0.280732928349j)
        ref[2, 1, 1, 1]=(0.998267208071+0.601268334612j)
        arg[2, 1, 2]=(-0.538174511003+0.539082487136j)*x[0]+((0.553221262269-0.392265457071j))*x[1]
        ref[2, 1, 2, 0]=(-0.538174511003+0.539082487136j)
        ref[2, 1, 2, 1]=(0.553221262269-0.392265457071j)
        arg[2, 1, 3]=(-0.417512196516-0.0999364747728j)*x[0]+((0.345406492751+0.772429911048j))*x[1]
        ref[2, 1, 3, 0]=(-0.417512196516-0.0999364747728j)
        ref[2, 1, 3, 1]=(0.345406492751+0.772429911048j)
        arg[3, 0, 0]=(0.211907284978-0.889467622561j)*x[0]+((0.4167547058-0.806671466453j))*x[1]
        ref[3, 0, 0, 0]=(0.211907284978-0.889467622561j)
        ref[3, 0, 0, 1]=(0.4167547058-0.806671466453j)
        arg[3, 0, 1]=(0.457580160709-0.93115934052j)*x[0]+((0.714480353438+0.350629129699j))*x[1]
        ref[3, 0, 1, 0]=(0.457580160709-0.93115934052j)
        ref[3, 0, 1, 1]=(0.714480353438+0.350629129699j)
        arg[3, 0, 2]=(0.730638640898-0.0145406561529j)*x[0]+((0.444388427209-0.418363978814j))*x[1]
        ref[3, 0, 2, 0]=(0.730638640898-0.0145406561529j)
        ref[3, 0, 2, 1]=(0.444388427209-0.418363978814j)
        arg[3, 0, 3]=(-0.848172263889-0.581484002801j)*x[0]+((0.0888008256355-0.663827301023j))*x[1]
        ref[3, 0, 3, 0]=(-0.848172263889-0.581484002801j)
        ref[3, 0, 3, 1]=(0.0888008256355-0.663827301023j)
        arg[3, 1, 0]=(-0.447874378048+0.73417152882j)*x[0]+((-0.994810289374+0.176016906529j))*x[1]
        ref[3, 1, 0, 0]=(-0.447874378048+0.73417152882j)
        ref[3, 1, 0, 1]=(-0.994810289374+0.176016906529j)
        arg[3, 1, 1]=(0.35996322349+0.130875262702j)*x[0]+((0.304609739129-0.116755841368j))*x[1]
        ref[3, 1, 1, 0]=(0.35996322349+0.130875262702j)
        ref[3, 1, 1, 1]=(0.304609739129-0.116755841368j)
        arg[3, 1, 2]=(0.826369906595+0.119963818539j)*x[0]+((-0.972271478968-0.932407707086j))*x[1]
        ref[3, 1, 2, 0]=(0.826369906595+0.119963818539j)
        ref[3, 1, 2, 1]=(-0.972271478968-0.932407707086j)
        arg[3, 1, 3]=(0.043730414977+0.764430807238j)*x[0]+((-0.725496553898+0.185430866416j))*x[1]
        ref[3, 1, 3, 0]=(0.043730414977+0.764430807238j)
        ref[3, 1, 3, 1]=(-0.725496553898+0.185430866416j)
        if dim==3:
            arg[0, 0, 0]+=(0.970842311763+0.945884641332j)*x[2]
            ref[0, 0, 0, 2]=(0.970842311763+0.945884641332j)
            arg[0, 0, 1]+=(-0.934763996927+0.0399800651697j)*x[2]
            ref[0, 0, 1, 2]=(-0.934763996927+0.0399800651697j)
            arg[0, 0, 2]+=(-0.187877909923+0.186449357884j)*x[2]
            ref[0, 0, 2, 2]=(-0.187877909923+0.186449357884j)
            arg[0, 0, 3]+=(-0.446885444617-0.0416164438284j)*x[2]
            ref[0, 0, 3, 2]=(-0.446885444617-0.0416164438284j)
            arg[0, 1, 0]+=(0.545762297642-0.604967207286j)*x[2]
            ref[0, 1, 0, 2]=(0.545762297642-0.604967207286j)
            arg[0, 1, 1]+=(-0.376071119555-0.902307251976j)*x[2]
            ref[0, 1, 1, 2]=(-0.376071119555-0.902307251976j)
            arg[0, 1, 2]+=(0.760411837349+0.539678724605j)*x[2]
            ref[0, 1, 2, 2]=(0.760411837349+0.539678724605j)
            arg[0, 1, 3]+=(-0.699166638957-0.545420191024j)*x[2]
            ref[0, 1, 3, 2]=(-0.699166638957-0.545420191024j)
            arg[1, 0, 0]+=(0.33703355957+0.278755559293j)*x[2]
            ref[1, 0, 0, 2]=(0.33703355957+0.278755559293j)
            arg[1, 0, 1]+=(0.470425433129+0.579753204973j)*x[2]
            ref[1, 0, 1, 2]=(0.470425433129+0.579753204973j)
            arg[1, 0, 2]+=(-0.638964135536+0.747104786493j)*x[2]
            ref[1, 0, 2, 2]=(-0.638964135536+0.747104786493j)
            arg[1, 0, 3]+=(-0.0833966897857+0.570266873676j)*x[2]
            ref[1, 0, 3, 2]=(-0.0833966897857+0.570266873676j)
            arg[1, 1, 0]+=(-0.117290566472-0.433996701418j)*x[2]
            ref[1, 1, 0, 2]=(-0.117290566472-0.433996701418j)
            arg[1, 1, 1]+=(-0.953490457568+0.679044666904j)*x[2]
            ref[1, 1, 1, 2]=(-0.953490457568+0.679044666904j)
            arg[1, 1, 2]+=(-0.277852210567-0.901510087154j)*x[2]
            ref[1, 1, 2, 2]=(-0.277852210567-0.901510087154j)
            arg[1, 1, 3]+=(0.0140123766107-0.68949388903j)*x[2]
            ref[1, 1, 3, 2]=(0.0140123766107-0.68949388903j)
            arg[2, 0, 0]+=(-0.568673510179+0.199626247216j)*x[2]
            ref[2, 0, 0, 2]=(-0.568673510179+0.199626247216j)
            arg[2, 0, 1]+=(0.956890792844-0.243068723666j)*x[2]
            ref[2, 0, 1, 2]=(0.956890792844-0.243068723666j)
            arg[2, 0, 2]+=(-0.283577819023-0.660410594099j)*x[2]
            ref[2, 0, 2, 2]=(-0.283577819023-0.660410594099j)
            arg[2, 0, 3]+=(0.350933874453+0.635992950966j)*x[2]
            ref[2, 0, 3, 2]=(0.350933874453+0.635992950966j)
            arg[2, 1, 0]+=(-0.657540351284-0.999529431112j)*x[2]
            ref[2, 1, 0, 2]=(-0.657540351284-0.999529431112j)
            arg[2, 1, 1]+=(0.209544681991+0.329706800812j)*x[2]
            ref[2, 1, 1, 2]=(0.209544681991+0.329706800812j)
            arg[2, 1, 2]+=(-0.97598408666+0.224639862112j)*x[2]
            ref[2, 1, 2, 2]=(-0.97598408666+0.224639862112j)
            arg[2, 1, 3]+=(0.984559077784-0.266314472285j)*x[2]
            ref[2, 1, 3, 2]=(0.984559077784-0.266314472285j)
            arg[3, 0, 0]+=(0.201193702967-0.565643103525j)*x[2]
            ref[3, 0, 0, 2]=(0.201193702967-0.565643103525j)
            arg[3, 0, 1]+=(0.0995406795499-0.138393460972j)*x[2]
            ref[3, 0, 1, 2]=(0.0995406795499-0.138393460972j)
            arg[3, 0, 2]+=(0.684449467944+0.0206173669331j)*x[2]
            ref[3, 0, 2, 2]=(0.684449467944+0.0206173669331j)
            arg[3, 0, 3]+=(0.378081638342-0.333379084693j)*x[2]
            ref[3, 0, 3, 2]=(0.378081638342-0.333379084693j)
            arg[3, 1, 0]+=(-0.284275732898-0.344847174992j)*x[2]
            ref[3, 1, 0, 2]=(-0.284275732898-0.344847174992j)
            arg[3, 1, 1]+=(-0.706390755187-0.00925125817514j)*x[2]
            ref[3, 1, 1, 2]=(-0.706390755187-0.00925125817514j)
            arg[3, 1, 2]+=(0.615668673585+0.907451911177j)*x[2]
            ref[3, 1, 2, 2]=(0.615668673585+0.907451911177j)
            arg[3, 1, 3]+=(0.0237406983738-0.249944516276j)*x[2]
            ref[3, 1, 3, 2]=(0.0237406983738-0.249944516276j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4, 2, 4)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnContactOne_fromData_ContinuousFunction_rank0(self):
        """
        tests gradient of rank 0 Data on ReducedFunctionOnContactOne

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnContactOne
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnContactOne(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=(0.64070657437+0.00567227574053j)*x[0]**o+((-0.916318138509-0.763439493706j))*x[0]+((0.267136153585+0.238905685527j))*x[1]**o+((-0.158086715903+0.0806356217707j))*x[1]
        ref[0]=(0.64070657437+0.00567227574053j)*o*x_ref[0]**(o-1)+((-0.916318138509-0.763439493706j))
        ref[1]=(0.267136153585+0.238905685527j)*o*x_ref[1]**(o-1)+((-0.158086715903+0.0806356217707j))
        if dim==3:
            arg+=((-0.889364477163+0.912088115851j))*x[2]**o+((-0.610809117638+0.0898835614699j))*x[2]
            ref[2]=(-0.889364477163+0.912088115851j)*o*x_ref[2]**(o-1)+((-0.610809117638+0.0898835614699j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnContactOne_fromData_ContinuousFunction_rank1(self):
        """
        tests gradient of rank 1 Data on ReducedFunctionOnContactOne

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnContactOne
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnContactOne(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(3,),w)
        ref = Data(0,(3,)+(dim,),w_ref)
        arg[0,]=(0.709372063928-0.16816930594j)*x[0]**o+((0.913635436231+0.0986293808756j))*x[0]+((-0.927817217277+0.900935388796j))*x[1]**o+((-0.413306842525-0.0111550985561j))*x[1]
        ref[0, 0]=(0.709372063928-0.16816930594j)*o*x_ref[0]**(o-1)+((0.913635436231+0.0986293808756j))
        ref[0, 1]=(-0.927817217277+0.900935388796j)*o*x_ref[1]**(o-1)+((-0.413306842525-0.0111550985561j))
        arg[1,]=(-0.0267430024165+0.226612529173j)*x[0]**o+((0.996995355905+0.566724823408j))*x[0]+((0.284650691797+0.636171417202j))*x[1]**o+((0.396011323215-0.0642112729336j))*x[1]
        ref[1, 0]=(-0.0267430024165+0.226612529173j)*o*x_ref[0]**(o-1)+((0.996995355905+0.566724823408j))
        ref[1, 1]=(0.284650691797+0.636171417202j)*o*x_ref[1]**(o-1)+((0.396011323215-0.0642112729336j))
        arg[2,]=(0.600382983688-0.735090915201j)*x[0]**o+((-0.200399066922+0.0515061388099j))*x[0]+((0.298224271085-0.0126732540395j))*x[1]**o+((0.798936187544-0.849779722782j))*x[1]
        ref[2, 0]=(0.600382983688-0.735090915201j)*o*x_ref[0]**(o-1)+((-0.200399066922+0.0515061388099j))
        ref[2, 1]=(0.298224271085-0.0126732540395j)*o*x_ref[1]**(o-1)+((0.798936187544-0.849779722782j))
        if dim==3:
            arg[0,]+=(0.256189769845-0.647186831051j)*x[2]**o+((0.565337316328+0.551049965614j))*x[2]
            ref[0, 2]=(0.256189769845-0.647186831051j)*o*x_ref[2]**(o-1)+((0.565337316328+0.551049965614j))
            arg[1,]+=(-0.91220261976-0.25253374754j)*x[2]**o+((0.977572814842-0.565532787995j))*x[2]
            ref[1, 2]=(-0.91220261976-0.25253374754j)*o*x_ref[2]**(o-1)+((0.977572814842-0.565532787995j))
            arg[2,]+=(0.512151229221+0.636110912236j)*x[2]**o+((-0.391990374141-0.529386298948j))*x[2]
            ref[2, 2]=(0.512151229221+0.636110912236j)*o*x_ref[2]**(o-1)+((-0.391990374141-0.529386298948j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnContactOne_fromData_ContinuousFunction_rank2(self):
        """
        tests gradient of rank 2 Data on ReducedFunctionOnContactOne

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnContactOne
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnContactOne(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(2, 4),w)
        ref = Data(0,(2, 4)+(dim,),w_ref)
        arg[0, 0]=(0.779713050886+0.353588714648j)*x[0]**o+((0.238176280855-0.115561344345j))*x[0]+((-0.341688113148+0.756720050213j))*x[1]**o+((0.0181241804676+0.759686212105j))*x[1]
        ref[0, 0, 0]=(0.779713050886+0.353588714648j)*o*x_ref[0]**(o-1)+((0.238176280855-0.115561344345j))
        ref[0, 0, 1]=(-0.341688113148+0.756720050213j)*o*x_ref[1]**(o-1)+((0.0181241804676+0.759686212105j))
        arg[0, 1]=(0.580408292769+0.906287128704j)*x[0]**o+((-0.675510483364+0.67693227944j))*x[0]+((0.427263353603+0.758154981303j))*x[1]**o+((-0.0746437332086+0.079508987041j))*x[1]
        ref[0, 1, 0]=(0.580408292769+0.906287128704j)*o*x_ref[0]**(o-1)+((-0.675510483364+0.67693227944j))
        ref[0, 1, 1]=(0.427263353603+0.758154981303j)*o*x_ref[1]**(o-1)+((-0.0746437332086+0.079508987041j))
        arg[0, 2]=(0.00907875823076+0.188695347676j)*x[0]**o+((-0.373306539337-0.376801845715j))*x[0]+((-0.99369319597+0.870124507041j))*x[1]**o+((-0.581865430634+0.558141747916j))*x[1]
        ref[0, 2, 0]=(0.00907875823076+0.188695347676j)*o*x_ref[0]**(o-1)+((-0.373306539337-0.376801845715j))
        ref[0, 2, 1]=(-0.99369319597+0.870124507041j)*o*x_ref[1]**(o-1)+((-0.581865430634+0.558141747916j))
        arg[0, 3]=(-0.692645646517-0.320378388597j)*x[0]**o+((-0.899660342587-0.940709650131j))*x[0]+((-0.750113455841+0.544192378163j))*x[1]**o+((0.134931209894-0.262608307782j))*x[1]
        ref[0, 3, 0]=(-0.692645646517-0.320378388597j)*o*x_ref[0]**(o-1)+((-0.899660342587-0.940709650131j))
        ref[0, 3, 1]=(-0.750113455841+0.544192378163j)*o*x_ref[1]**(o-1)+((0.134931209894-0.262608307782j))
        arg[1, 0]=(0.294941864324-0.697239316883j)*x[0]**o+((-0.97732119856+0.101380146802j))*x[0]+((-0.368786282866-0.446772739398j))*x[1]**o+((-0.023245143629+0.321584686436j))*x[1]
        ref[1, 0, 0]=(0.294941864324-0.697239316883j)*o*x_ref[0]**(o-1)+((-0.97732119856+0.101380146802j))
        ref[1, 0, 1]=(-0.368786282866-0.446772739398j)*o*x_ref[1]**(o-1)+((-0.023245143629+0.321584686436j))
        arg[1, 1]=(-0.61026003734-0.162517061936j)*x[0]**o+((-0.696904668117-0.0176171626574j))*x[0]+((-0.182840289236+0.194229404458j))*x[1]**o+((-0.823958552908+0.363264372971j))*x[1]
        ref[1, 1, 0]=(-0.61026003734-0.162517061936j)*o*x_ref[0]**(o-1)+((-0.696904668117-0.0176171626574j))
        ref[1, 1, 1]=(-0.182840289236+0.194229404458j)*o*x_ref[1]**(o-1)+((-0.823958552908+0.363264372971j))
        arg[1, 2]=(-0.186876099773-0.509575297418j)*x[0]**o+((-0.664334850297+0.810466038513j))*x[0]+((-0.742516502572-0.914519350796j))*x[1]**o+((0.00270805717601-0.841804377088j))*x[1]
        ref[1, 2, 0]=(-0.186876099773-0.509575297418j)*o*x_ref[0]**(o-1)+((-0.664334850297+0.810466038513j))
        ref[1, 2, 1]=(-0.742516502572-0.914519350796j)*o*x_ref[1]**(o-1)+((0.00270805717601-0.841804377088j))
        arg[1, 3]=(-0.263307220221-0.0701119226344j)*x[0]**o+((0.193810257204-0.766725373051j))*x[0]+((0.156665482892-0.70241431776j))*x[1]**o+((0.678941628524+0.209604621653j))*x[1]
        ref[1, 3, 0]=(-0.263307220221-0.0701119226344j)*o*x_ref[0]**(o-1)+((0.193810257204-0.766725373051j))
        ref[1, 3, 1]=(0.156665482892-0.70241431776j)*o*x_ref[1]**(o-1)+((0.678941628524+0.209604621653j))
        if dim==3:
            arg[0, 0]+=(-0.646345092724-0.96064449017j)*x[2]**o+((-0.408790691407-0.0978933880844j))*x[2]
            ref[0, 0, 2]=(-0.646345092724-0.96064449017j)*o*x_ref[2]**(o-1)+((-0.408790691407-0.0978933880844j))
            arg[0, 1]+=(0.900558375104+0.516080513446j)*x[2]**o+((-0.301268365389-0.276896731322j))*x[2]
            ref[0, 1, 2]=(0.900558375104+0.516080513446j)*o*x_ref[2]**(o-1)+((-0.301268365389-0.276896731322j))
            arg[0, 2]+=(-0.301743923478+0.837118589085j)*x[2]**o+((-0.344981231414+0.629707368919j))*x[2]
            ref[0, 2, 2]=(-0.301743923478+0.837118589085j)*o*x_ref[2]**(o-1)+((-0.344981231414+0.629707368919j))
            arg[0, 3]+=(-0.83668254128+0.475580276889j)*x[2]**o+((-0.949548561142-0.592040354227j))*x[2]
            ref[0, 3, 2]=(-0.83668254128+0.475580276889j)*o*x_ref[2]**(o-1)+((-0.949548561142-0.592040354227j))
            arg[1, 0]+=(0.25160208599+0.434309370198j)*x[2]**o+((-0.82376800272+0.867422487403j))*x[2]
            ref[1, 0, 2]=(0.25160208599+0.434309370198j)*o*x_ref[2]**(o-1)+((-0.82376800272+0.867422487403j))
            arg[1, 1]+=(0.764460869857+0.551153332782j)*x[2]**o+((0.559711106167-0.582727789957j))*x[2]
            ref[1, 1, 2]=(0.764460869857+0.551153332782j)*o*x_ref[2]**(o-1)+((0.559711106167-0.582727789957j))
            arg[1, 2]+=(0.117039112936+0.776931610384j)*x[2]**o+((0.550092910839-0.0499970427032j))*x[2]
            ref[1, 2, 2]=(0.117039112936+0.776931610384j)*o*x_ref[2]**(o-1)+((0.550092910839-0.0499970427032j))
            arg[1, 3]+=(-0.457996503427+0.078899735515j)*x[2]**o+((0.0969505845386+0.717806422977j))*x[2]
            ref[1, 3, 2]=(-0.457996503427+0.078899735515j)*o*x_ref[2]**(o-1)+((0.0969505845386+0.717806422977j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2, 4)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnContactOne_fromData_ContinuousFunction_rank3(self):
        """
        tests gradient of rank 3 Data on ReducedFunctionOnContactOne

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnContactOne
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnContactOne(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(4, 4, 4),w)
        ref = Data(0,(4, 4, 4)+(dim,),w_ref)
        arg[0, 0, 0]=(0.89658140296-0.0421447740344j)*x[0]**o+((0.326575039049+0.354378363237j))*x[0]+((-0.608993198585-0.827357506951j))*x[1]**o+((-0.968155311355-0.736336469778j))*x[1]
        ref[0, 0, 0, 0]=(0.89658140296-0.0421447740344j)*o*x_ref[0]**(o-1)+((0.326575039049+0.354378363237j))
        ref[0, 0, 0, 1]=(-0.608993198585-0.827357506951j)*o*x_ref[1]**(o-1)+((-0.968155311355-0.736336469778j))
        arg[0, 0, 1]=(-0.527791981472-0.562600472895j)*x[0]**o+((-0.405905515739+0.184294681661j))*x[0]+((0.590102555044+0.96185076837j))*x[1]**o+((-0.822542250091+0.263665208234j))*x[1]
        ref[0, 0, 1, 0]=(-0.527791981472-0.562600472895j)*o*x_ref[0]**(o-1)+((-0.405905515739+0.184294681661j))
        ref[0, 0, 1, 1]=(0.590102555044+0.96185076837j)*o*x_ref[1]**(o-1)+((-0.822542250091+0.263665208234j))
        arg[0, 0, 2]=(0.304582835523-0.577151407715j)*x[0]**o+((-0.383821043989-0.415725509j))*x[0]+((-0.712058385229-0.842089892364j))*x[1]**o+((-0.585607271266-0.180921890807j))*x[1]
        ref[0, 0, 2, 0]=(0.304582835523-0.577151407715j)*o*x_ref[0]**(o-1)+((-0.383821043989-0.415725509j))
        ref[0, 0, 2, 1]=(-0.712058385229-0.842089892364j)*o*x_ref[1]**(o-1)+((-0.585607271266-0.180921890807j))
        arg[0, 0, 3]=(-0.833609191197+0.393821112745j)*x[0]**o+((0.191689915065-0.994966147692j))*x[0]+((0.175168891557-0.321892159145j))*x[1]**o+((-0.722351727152+0.670974326565j))*x[1]
        ref[0, 0, 3, 0]=(-0.833609191197+0.393821112745j)*o*x_ref[0]**(o-1)+((0.191689915065-0.994966147692j))
        ref[0, 0, 3, 1]=(0.175168891557-0.321892159145j)*o*x_ref[1]**(o-1)+((-0.722351727152+0.670974326565j))
        arg[0, 1, 0]=(-0.0666053958709+0.514098013931j)*x[0]**o+((-0.599947294436+0.327727230212j))*x[0]+((-0.28208846841-0.152688108799j))*x[1]**o+((0.297720914939+0.687997439477j))*x[1]
        ref[0, 1, 0, 0]=(-0.0666053958709+0.514098013931j)*o*x_ref[0]**(o-1)+((-0.599947294436+0.327727230212j))
        ref[0, 1, 0, 1]=(-0.28208846841-0.152688108799j)*o*x_ref[1]**(o-1)+((0.297720914939+0.687997439477j))
        arg[0, 1, 1]=(0.852868911611-0.739862952512j)*x[0]**o+((-0.770259791067-0.661695158072j))*x[0]+((0.604880665799+0.321922807397j))*x[1]**o+((-0.0507807829452+0.955260479577j))*x[1]
        ref[0, 1, 1, 0]=(0.852868911611-0.739862952512j)*o*x_ref[0]**(o-1)+((-0.770259791067-0.661695158072j))
        ref[0, 1, 1, 1]=(0.604880665799+0.321922807397j)*o*x_ref[1]**(o-1)+((-0.0507807829452+0.955260479577j))
        arg[0, 1, 2]=(-0.10681308389-0.946584375226j)*x[0]**o+((0.387450683477+0.0685461336249j))*x[0]+((-0.622241205641-0.624568468939j))*x[1]**o+((0.475759144532+0.554482253164j))*x[1]
        ref[0, 1, 2, 0]=(-0.10681308389-0.946584375226j)*o*x_ref[0]**(o-1)+((0.387450683477+0.0685461336249j))
        ref[0, 1, 2, 1]=(-0.622241205641-0.624568468939j)*o*x_ref[1]**(o-1)+((0.475759144532+0.554482253164j))
        arg[0, 1, 3]=(0.852576815381-0.664960396095j)*x[0]**o+((-0.25523261867-0.689841645449j))*x[0]+((-0.510673760873+0.98066823349j))*x[1]**o+((0.838305175405-0.896335163121j))*x[1]
        ref[0, 1, 3, 0]=(0.852576815381-0.664960396095j)*o*x_ref[0]**(o-1)+((-0.25523261867-0.689841645449j))
        ref[0, 1, 3, 1]=(-0.510673760873+0.98066823349j)*o*x_ref[1]**(o-1)+((0.838305175405-0.896335163121j))
        arg[0, 2, 0]=(-0.231488562057-0.586380477929j)*x[0]**o+((-0.572526291549+0.45991387448j))*x[0]+((0.579556123276+0.39864289252j))*x[1]**o+((0.697048658249+0.400035127479j))*x[1]
        ref[0, 2, 0, 0]=(-0.231488562057-0.586380477929j)*o*x_ref[0]**(o-1)+((-0.572526291549+0.45991387448j))
        ref[0, 2, 0, 1]=(0.579556123276+0.39864289252j)*o*x_ref[1]**(o-1)+((0.697048658249+0.400035127479j))
        arg[0, 2, 1]=(0.722868688389+0.164167110731j)*x[0]**o+((0.666875110709+0.415924596207j))*x[0]+((0.18518936067-0.55278384103j))*x[1]**o+((0.0469237102467+0.56161646448j))*x[1]
        ref[0, 2, 1, 0]=(0.722868688389+0.164167110731j)*o*x_ref[0]**(o-1)+((0.666875110709+0.415924596207j))
        ref[0, 2, 1, 1]=(0.18518936067-0.55278384103j)*o*x_ref[1]**(o-1)+((0.0469237102467+0.56161646448j))
        arg[0, 2, 2]=(0.155869090606+0.571596470339j)*x[0]**o+((0.46407263496-0.593070193832j))*x[0]+((0.512812371838+0.216812094832j))*x[1]**o+((-0.123894383921-0.505575796601j))*x[1]
        ref[0, 2, 2, 0]=(0.155869090606+0.571596470339j)*o*x_ref[0]**(o-1)+((0.46407263496-0.593070193832j))
        ref[0, 2, 2, 1]=(0.512812371838+0.216812094832j)*o*x_ref[1]**(o-1)+((-0.123894383921-0.505575796601j))
        arg[0, 2, 3]=(-0.772507775367-0.12720916349j)*x[0]**o+((0.68108704591+0.878645008185j))*x[0]+((-0.511439079612+0.0962795354655j))*x[1]**o+((0.145707362154-0.540451684999j))*x[1]
        ref[0, 2, 3, 0]=(-0.772507775367-0.12720916349j)*o*x_ref[0]**(o-1)+((0.68108704591+0.878645008185j))
        ref[0, 2, 3, 1]=(-0.511439079612+0.0962795354655j)*o*x_ref[1]**(o-1)+((0.145707362154-0.540451684999j))
        arg[0, 3, 0]=(0.619798100603+0.371847358141j)*x[0]**o+((0.18478437535-0.828193393221j))*x[0]+((0.201014189975+0.436291493374j))*x[1]**o+((-0.543517081776+0.498421308429j))*x[1]
        ref[0, 3, 0, 0]=(0.619798100603+0.371847358141j)*o*x_ref[0]**(o-1)+((0.18478437535-0.828193393221j))
        ref[0, 3, 0, 1]=(0.201014189975+0.436291493374j)*o*x_ref[1]**(o-1)+((-0.543517081776+0.498421308429j))
        arg[0, 3, 1]=(0.196551093971+0.480382066567j)*x[0]**o+((0.186006542493-0.34487927842j))*x[0]+((-0.123459630964+0.637499036686j))*x[1]**o+((0.502034242724+0.507492501188j))*x[1]
        ref[0, 3, 1, 0]=(0.196551093971+0.480382066567j)*o*x_ref[0]**(o-1)+((0.186006542493-0.34487927842j))
        ref[0, 3, 1, 1]=(-0.123459630964+0.637499036686j)*o*x_ref[1]**(o-1)+((0.502034242724+0.507492501188j))
        arg[0, 3, 2]=(0.290983731479-0.0927867113829j)*x[0]**o+((-0.737397562867+0.145131911546j))*x[0]+((-0.567184781577+0.151293410067j))*x[1]**o+((-0.31509295924+0.117973665664j))*x[1]
        ref[0, 3, 2, 0]=(0.290983731479-0.0927867113829j)*o*x_ref[0]**(o-1)+((-0.737397562867+0.145131911546j))
        ref[0, 3, 2, 1]=(-0.567184781577+0.151293410067j)*o*x_ref[1]**(o-1)+((-0.31509295924+0.117973665664j))
        arg[0, 3, 3]=(0.89110973314-0.836919201627j)*x[0]**o+((-0.605674369948-0.0729219175644j))*x[0]+((0.808120913058-0.681607398321j))*x[1]**o+((0.815193305573+0.72503028326j))*x[1]
        ref[0, 3, 3, 0]=(0.89110973314-0.836919201627j)*o*x_ref[0]**(o-1)+((-0.605674369948-0.0729219175644j))
        ref[0, 3, 3, 1]=(0.808120913058-0.681607398321j)*o*x_ref[1]**(o-1)+((0.815193305573+0.72503028326j))
        arg[1, 0, 0]=(0.0358979500807+0.380387254275j)*x[0]**o+((0.436813275994+0.43115644879j))*x[0]+((-0.698270531091+0.850512344848j))*x[1]**o+((-0.274390586475-0.224278835564j))*x[1]
        ref[1, 0, 0, 0]=(0.0358979500807+0.380387254275j)*o*x_ref[0]**(o-1)+((0.436813275994+0.43115644879j))
        ref[1, 0, 0, 1]=(-0.698270531091+0.850512344848j)*o*x_ref[1]**(o-1)+((-0.274390586475-0.224278835564j))
        arg[1, 0, 1]=(-0.695885247732-0.178252176209j)*x[0]**o+((0.363972207325-0.441415029739j))*x[0]+((0.631184566721+0.366499790914j))*x[1]**o+((-0.953834697107+0.0780642492001j))*x[1]
        ref[1, 0, 1, 0]=(-0.695885247732-0.178252176209j)*o*x_ref[0]**(o-1)+((0.363972207325-0.441415029739j))
        ref[1, 0, 1, 1]=(0.631184566721+0.366499790914j)*o*x_ref[1]**(o-1)+((-0.953834697107+0.0780642492001j))
        arg[1, 0, 2]=(-0.0810682790028-0.43000433724j)*x[0]**o+((-0.399539445724-0.681476550195j))*x[0]+((0.169859208762-0.272896289563j))*x[1]**o+((0.810848902398+0.434062940986j))*x[1]
        ref[1, 0, 2, 0]=(-0.0810682790028-0.43000433724j)*o*x_ref[0]**(o-1)+((-0.399539445724-0.681476550195j))
        ref[1, 0, 2, 1]=(0.169859208762-0.272896289563j)*o*x_ref[1]**(o-1)+((0.810848902398+0.434062940986j))
        arg[1, 0, 3]=(0.865806531632-0.0420463801021j)*x[0]**o+((-0.221747860401+0.210534635693j))*x[0]+((-0.42167590465+0.964836534307j))*x[1]**o+((0.909782979995+0.89418751176j))*x[1]
        ref[1, 0, 3, 0]=(0.865806531632-0.0420463801021j)*o*x_ref[0]**(o-1)+((-0.221747860401+0.210534635693j))
        ref[1, 0, 3, 1]=(-0.42167590465+0.964836534307j)*o*x_ref[1]**(o-1)+((0.909782979995+0.89418751176j))
        arg[1, 1, 0]=(0.225036841404-0.900147199976j)*x[0]**o+((0.600835168088+0.444228361036j))*x[0]+((0.512598372175+0.19415503316j))*x[1]**o+((0.525856705598-0.306513737713j))*x[1]
        ref[1, 1, 0, 0]=(0.225036841404-0.900147199976j)*o*x_ref[0]**(o-1)+((0.600835168088+0.444228361036j))
        ref[1, 1, 0, 1]=(0.512598372175+0.19415503316j)*o*x_ref[1]**(o-1)+((0.525856705598-0.306513737713j))
        arg[1, 1, 1]=(-0.422339014006-0.814599177852j)*x[0]**o+((-0.233508484333+0.729203959133j))*x[0]+((-0.599484404943+0.0408907497162j))*x[1]**o+((0.0991589413896+0.324929301335j))*x[1]
        ref[1, 1, 1, 0]=(-0.422339014006-0.814599177852j)*o*x_ref[0]**(o-1)+((-0.233508484333+0.729203959133j))
        ref[1, 1, 1, 1]=(-0.599484404943+0.0408907497162j)*o*x_ref[1]**(o-1)+((0.0991589413896+0.324929301335j))
        arg[1, 1, 2]=(-0.654113557564-0.141300626991j)*x[0]**o+((-0.0288309758811-0.442254578609j))*x[0]+((0.513061069543-0.821437022541j))*x[1]**o+((-0.634157735292-0.169397872671j))*x[1]
        ref[1, 1, 2, 0]=(-0.654113557564-0.141300626991j)*o*x_ref[0]**(o-1)+((-0.0288309758811-0.442254578609j))
        ref[1, 1, 2, 1]=(0.513061069543-0.821437022541j)*o*x_ref[1]**(o-1)+((-0.634157735292-0.169397872671j))
        arg[1, 1, 3]=(-0.126628225671+0.852506367479j)*x[0]**o+((-0.0984281715229-0.308577642013j))*x[0]+((0.506928822549+0.729276199053j))*x[1]**o+((0.755931131244-0.644568525719j))*x[1]
        ref[1, 1, 3, 0]=(-0.126628225671+0.852506367479j)*o*x_ref[0]**(o-1)+((-0.0984281715229-0.308577642013j))
        ref[1, 1, 3, 1]=(0.506928822549+0.729276199053j)*o*x_ref[1]**(o-1)+((0.755931131244-0.644568525719j))
        arg[1, 2, 0]=(-0.263862581946-0.930137826127j)*x[0]**o+((0.501693203707+0.876421741473j))*x[0]+((-0.326390450767-0.114412416844j))*x[1]**o+((-0.770599894895-0.297899938871j))*x[1]
        ref[1, 2, 0, 0]=(-0.263862581946-0.930137826127j)*o*x_ref[0]**(o-1)+((0.501693203707+0.876421741473j))
        ref[1, 2, 0, 1]=(-0.326390450767-0.114412416844j)*o*x_ref[1]**(o-1)+((-0.770599894895-0.297899938871j))
        arg[1, 2, 1]=(0.860424742312-0.106820332406j)*x[0]**o+((0.219368481331+0.508638623212j))*x[0]+((0.417945790113-0.814536393136j))*x[1]**o+((-0.489360643455+0.690554465431j))*x[1]
        ref[1, 2, 1, 0]=(0.860424742312-0.106820332406j)*o*x_ref[0]**(o-1)+((0.219368481331+0.508638623212j))
        ref[1, 2, 1, 1]=(0.417945790113-0.814536393136j)*o*x_ref[1]**(o-1)+((-0.489360643455+0.690554465431j))
        arg[1, 2, 2]=(0.327260568372+0.431032616004j)*x[0]**o+((-0.455951612535+0.487449625456j))*x[0]+((0.244374706518+0.429993234898j))*x[1]**o+((-0.04449678993-0.658900864063j))*x[1]
        ref[1, 2, 2, 0]=(0.327260568372+0.431032616004j)*o*x_ref[0]**(o-1)+((-0.455951612535+0.487449625456j))
        ref[1, 2, 2, 1]=(0.244374706518+0.429993234898j)*o*x_ref[1]**(o-1)+((-0.04449678993-0.658900864063j))
        arg[1, 2, 3]=(-0.0662836632496-0.308225277686j)*x[0]**o+((-0.372777476575-0.154722753667j))*x[0]+((-0.480118265427+0.680353361977j))*x[1]**o+((-0.0961934484411-0.520850603515j))*x[1]
        ref[1, 2, 3, 0]=(-0.0662836632496-0.308225277686j)*o*x_ref[0]**(o-1)+((-0.372777476575-0.154722753667j))
        ref[1, 2, 3, 1]=(-0.480118265427+0.680353361977j)*o*x_ref[1]**(o-1)+((-0.0961934484411-0.520850603515j))
        arg[1, 3, 0]=(0.719670605329+0.497103922192j)*x[0]**o+((0.541054855547-0.226257061848j))*x[0]+((-0.505788109323-0.87857192147j))*x[1]**o+((0.337097188715+0.751432863868j))*x[1]
        ref[1, 3, 0, 0]=(0.719670605329+0.497103922192j)*o*x_ref[0]**(o-1)+((0.541054855547-0.226257061848j))
        ref[1, 3, 0, 1]=(-0.505788109323-0.87857192147j)*o*x_ref[1]**(o-1)+((0.337097188715+0.751432863868j))
        arg[1, 3, 1]=(0.317604135845+0.776112582915j)*x[0]**o+((0.443725353306-0.65289757484j))*x[0]+((0.367686851983-0.446428206936j))*x[1]**o+((-0.8178058788-0.960822372876j))*x[1]
        ref[1, 3, 1, 0]=(0.317604135845+0.776112582915j)*o*x_ref[0]**(o-1)+((0.443725353306-0.65289757484j))
        ref[1, 3, 1, 1]=(0.367686851983-0.446428206936j)*o*x_ref[1]**(o-1)+((-0.8178058788-0.960822372876j))
        arg[1, 3, 2]=(0.627121297877-0.486279739737j)*x[0]**o+((0.843325601253-0.18474610421j))*x[0]+((0.206862366631-0.139238213403j))*x[1]**o+((0.763692769205+0.398027387844j))*x[1]
        ref[1, 3, 2, 0]=(0.627121297877-0.486279739737j)*o*x_ref[0]**(o-1)+((0.843325601253-0.18474610421j))
        ref[1, 3, 2, 1]=(0.206862366631-0.139238213403j)*o*x_ref[1]**(o-1)+((0.763692769205+0.398027387844j))
        arg[1, 3, 3]=(0.913920564082+0.0216808317683j)*x[0]**o+((-0.944107720681+0.227221085967j))*x[0]+((-0.218444621204-0.0877541458011j))*x[1]**o+((0.552396804964+0.343631616879j))*x[1]
        ref[1, 3, 3, 0]=(0.913920564082+0.0216808317683j)*o*x_ref[0]**(o-1)+((-0.944107720681+0.227221085967j))
        ref[1, 3, 3, 1]=(-0.218444621204-0.0877541458011j)*o*x_ref[1]**(o-1)+((0.552396804964+0.343631616879j))
        arg[2, 0, 0]=(-0.467469685142-0.898122509022j)*x[0]**o+((0.730011483745-0.832874359702j))*x[0]+((0.181679584924+0.108943082902j))*x[1]**o+((0.362041698305-0.288673058763j))*x[1]
        ref[2, 0, 0, 0]=(-0.467469685142-0.898122509022j)*o*x_ref[0]**(o-1)+((0.730011483745-0.832874359702j))
        ref[2, 0, 0, 1]=(0.181679584924+0.108943082902j)*o*x_ref[1]**(o-1)+((0.362041698305-0.288673058763j))
        arg[2, 0, 1]=(-0.585264600687+0.615752985698j)*x[0]**o+((-0.14013449906+0.889099609496j))*x[0]+((-0.036325351586+0.221075137624j))*x[1]**o+((0.729812577962+0.686114081165j))*x[1]
        ref[2, 0, 1, 0]=(-0.585264600687+0.615752985698j)*o*x_ref[0]**(o-1)+((-0.14013449906+0.889099609496j))
        ref[2, 0, 1, 1]=(-0.036325351586+0.221075137624j)*o*x_ref[1]**(o-1)+((0.729812577962+0.686114081165j))
        arg[2, 0, 2]=(0.254488937108+0.453583816175j)*x[0]**o+((-0.935926296837-0.761081647001j))*x[0]+((0.593130147367+0.908460705455j))*x[1]**o+((0.0884757830279+0.702800690062j))*x[1]
        ref[2, 0, 2, 0]=(0.254488937108+0.453583816175j)*o*x_ref[0]**(o-1)+((-0.935926296837-0.761081647001j))
        ref[2, 0, 2, 1]=(0.593130147367+0.908460705455j)*o*x_ref[1]**(o-1)+((0.0884757830279+0.702800690062j))
        arg[2, 0, 3]=(0.193378740807+0.419665083781j)*x[0]**o+((-0.500897565529+0.746137535191j))*x[0]+((-0.636997165374-0.416678553992j))*x[1]**o+((-0.433168595271-0.014303586627j))*x[1]
        ref[2, 0, 3, 0]=(0.193378740807+0.419665083781j)*o*x_ref[0]**(o-1)+((-0.500897565529+0.746137535191j))
        ref[2, 0, 3, 1]=(-0.636997165374-0.416678553992j)*o*x_ref[1]**(o-1)+((-0.433168595271-0.014303586627j))
        arg[2, 1, 0]=(0.21149180203-0.95268710409j)*x[0]**o+((0.425407243029-0.943757149395j))*x[0]+((-0.142472040932+0.236643673127j))*x[1]**o+((-0.980656130529+0.329723976088j))*x[1]
        ref[2, 1, 0, 0]=(0.21149180203-0.95268710409j)*o*x_ref[0]**(o-1)+((0.425407243029-0.943757149395j))
        ref[2, 1, 0, 1]=(-0.142472040932+0.236643673127j)*o*x_ref[1]**(o-1)+((-0.980656130529+0.329723976088j))
        arg[2, 1, 1]=(0.361668423572-0.378220909483j)*x[0]**o+((-0.212507223588+0.940631196292j))*x[0]+((-0.0789585984449-0.84650741488j))*x[1]**o+((0.562786065779-0.476597515228j))*x[1]
        ref[2, 1, 1, 0]=(0.361668423572-0.378220909483j)*o*x_ref[0]**(o-1)+((-0.212507223588+0.940631196292j))
        ref[2, 1, 1, 1]=(-0.0789585984449-0.84650741488j)*o*x_ref[1]**(o-1)+((0.562786065779-0.476597515228j))
        arg[2, 1, 2]=(-0.362403824564+0.597511578172j)*x[0]**o+((0.119573818485+0.772377122127j))*x[0]+((-0.683206537725+0.744210094338j))*x[1]**o+((-0.835832612321-0.129857225158j))*x[1]
        ref[2, 1, 2, 0]=(-0.362403824564+0.597511578172j)*o*x_ref[0]**(o-1)+((0.119573818485+0.772377122127j))
        ref[2, 1, 2, 1]=(-0.683206537725+0.744210094338j)*o*x_ref[1]**(o-1)+((-0.835832612321-0.129857225158j))
        arg[2, 1, 3]=(0.376732260841+0.47720526704j)*x[0]**o+((-0.655959734845+0.0239351024166j))*x[0]+((0.135929069494-0.733981990819j))*x[1]**o+((0.00772286608938+0.639134116283j))*x[1]
        ref[2, 1, 3, 0]=(0.376732260841+0.47720526704j)*o*x_ref[0]**(o-1)+((-0.655959734845+0.0239351024166j))
        ref[2, 1, 3, 1]=(0.135929069494-0.733981990819j)*o*x_ref[1]**(o-1)+((0.00772286608938+0.639134116283j))
        arg[2, 2, 0]=(0.409494146535-0.437976018088j)*x[0]**o+((0.942335845122-0.567610953611j))*x[0]+((0.117110977458+0.0331747243035j))*x[1]**o+((-0.0274032808154-0.59074538971j))*x[1]
        ref[2, 2, 0, 0]=(0.409494146535-0.437976018088j)*o*x_ref[0]**(o-1)+((0.942335845122-0.567610953611j))
        ref[2, 2, 0, 1]=(0.117110977458+0.0331747243035j)*o*x_ref[1]**(o-1)+((-0.0274032808154-0.59074538971j))
        arg[2, 2, 1]=(-0.348850943198-0.604467535229j)*x[0]**o+((-0.831342741216+0.443162900379j))*x[0]+((-0.445220904025-0.0198633428151j))*x[1]**o+((-0.0397857626084+0.448037825689j))*x[1]
        ref[2, 2, 1, 0]=(-0.348850943198-0.604467535229j)*o*x_ref[0]**(o-1)+((-0.831342741216+0.443162900379j))
        ref[2, 2, 1, 1]=(-0.445220904025-0.0198633428151j)*o*x_ref[1]**(o-1)+((-0.0397857626084+0.448037825689j))
        arg[2, 2, 2]=(-0.705019004607-0.472598403462j)*x[0]**o+((-0.682089146326-0.882062764639j))*x[0]+((-0.00980307511769-0.645970426123j))*x[1]**o+((-0.140479800972+0.102966331454j))*x[1]
        ref[2, 2, 2, 0]=(-0.705019004607-0.472598403462j)*o*x_ref[0]**(o-1)+((-0.682089146326-0.882062764639j))
        ref[2, 2, 2, 1]=(-0.00980307511769-0.645970426123j)*o*x_ref[1]**(o-1)+((-0.140479800972+0.102966331454j))
        arg[2, 2, 3]=(-0.883378634418-0.961843503746j)*x[0]**o+((-0.611475060498+0.451572167622j))*x[0]+((0.067193322377+0.588061501263j))*x[1]**o+((-0.734943219811+0.889446475374j))*x[1]
        ref[2, 2, 3, 0]=(-0.883378634418-0.961843503746j)*o*x_ref[0]**(o-1)+((-0.611475060498+0.451572167622j))
        ref[2, 2, 3, 1]=(0.067193322377+0.588061501263j)*o*x_ref[1]**(o-1)+((-0.734943219811+0.889446475374j))
        arg[2, 3, 0]=(0.0804349192393-0.660547763355j)*x[0]**o+((-0.350298068937-0.173171642207j))*x[0]+((-0.420866129125+0.888411960174j))*x[1]**o+((-0.293328680612-0.468816368194j))*x[1]
        ref[2, 3, 0, 0]=(0.0804349192393-0.660547763355j)*o*x_ref[0]**(o-1)+((-0.350298068937-0.173171642207j))
        ref[2, 3, 0, 1]=(-0.420866129125+0.888411960174j)*o*x_ref[1]**(o-1)+((-0.293328680612-0.468816368194j))
        arg[2, 3, 1]=(-0.406166252938-0.763801656158j)*x[0]**o+((-0.304881990566-0.615934187178j))*x[0]+((0.157553735649+0.984538080804j))*x[1]**o+((-0.314434087118-0.55304036608j))*x[1]
        ref[2, 3, 1, 0]=(-0.406166252938-0.763801656158j)*o*x_ref[0]**(o-1)+((-0.304881990566-0.615934187178j))
        ref[2, 3, 1, 1]=(0.157553735649+0.984538080804j)*o*x_ref[1]**(o-1)+((-0.314434087118-0.55304036608j))
        arg[2, 3, 2]=(0.426732432471+0.696063637205j)*x[0]**o+((0.568437785891-0.370710603701j))*x[0]+((0.289281105857+0.970477434692j))*x[1]**o+((0.501812645719+0.384173199517j))*x[1]
        ref[2, 3, 2, 0]=(0.426732432471+0.696063637205j)*o*x_ref[0]**(o-1)+((0.568437785891-0.370710603701j))
        ref[2, 3, 2, 1]=(0.289281105857+0.970477434692j)*o*x_ref[1]**(o-1)+((0.501812645719+0.384173199517j))
        arg[2, 3, 3]=(0.345939433973-0.0858099190427j)*x[0]**o+((0.808562195062+0.199456284686j))*x[0]+((0.464119932595-0.657006018454j))*x[1]**o+((0.0895365659243+0.584512561404j))*x[1]
        ref[2, 3, 3, 0]=(0.345939433973-0.0858099190427j)*o*x_ref[0]**(o-1)+((0.808562195062+0.199456284686j))
        ref[2, 3, 3, 1]=(0.464119932595-0.657006018454j)*o*x_ref[1]**(o-1)+((0.0895365659243+0.584512561404j))
        arg[3, 0, 0]=(0.44001374657-0.357407782819j)*x[0]**o+((0.821790552758+0.604349818322j))*x[0]+((0.981759623161-0.865281092042j))*x[1]**o+((-0.487400635636-0.785615875322j))*x[1]
        ref[3, 0, 0, 0]=(0.44001374657-0.357407782819j)*o*x_ref[0]**(o-1)+((0.821790552758+0.604349818322j))
        ref[3, 0, 0, 1]=(0.981759623161-0.865281092042j)*o*x_ref[1]**(o-1)+((-0.487400635636-0.785615875322j))
        arg[3, 0, 1]=(0.66821095979+0.432534402464j)*x[0]**o+((-0.218144100822+0.634661685075j))*x[0]+((-0.730473618608-0.985748153948j))*x[1]**o+((0.0793271033202+0.767623155049j))*x[1]
        ref[3, 0, 1, 0]=(0.66821095979+0.432534402464j)*o*x_ref[0]**(o-1)+((-0.218144100822+0.634661685075j))
        ref[3, 0, 1, 1]=(-0.730473618608-0.985748153948j)*o*x_ref[1]**(o-1)+((0.0793271033202+0.767623155049j))
        arg[3, 0, 2]=(-0.27985567163-0.580678039404j)*x[0]**o+((0.0229086775965-0.584065140308j))*x[0]+((0.277295603443-0.854471013245j))*x[1]**o+((-0.890175227633-0.976516471502j))*x[1]
        ref[3, 0, 2, 0]=(-0.27985567163-0.580678039404j)*o*x_ref[0]**(o-1)+((0.0229086775965-0.584065140308j))
        ref[3, 0, 2, 1]=(0.277295603443-0.854471013245j)*o*x_ref[1]**(o-1)+((-0.890175227633-0.976516471502j))
        arg[3, 0, 3]=(0.967563637186-0.979840637689j)*x[0]**o+((-0.711581679059-0.534514276548j))*x[0]+((-0.291411670465-0.247506430114j))*x[1]**o+((0.579439500525+0.242371272207j))*x[1]
        ref[3, 0, 3, 0]=(0.967563637186-0.979840637689j)*o*x_ref[0]**(o-1)+((-0.711581679059-0.534514276548j))
        ref[3, 0, 3, 1]=(-0.291411670465-0.247506430114j)*o*x_ref[1]**(o-1)+((0.579439500525+0.242371272207j))
        arg[3, 1, 0]=(-0.0466676351644-0.462985552749j)*x[0]**o+((0.116062809942+0.114940607682j))*x[0]+((-0.170638624617-0.873230918179j))*x[1]**o+((-0.748109666055+0.192167944347j))*x[1]
        ref[3, 1, 0, 0]=(-0.0466676351644-0.462985552749j)*o*x_ref[0]**(o-1)+((0.116062809942+0.114940607682j))
        ref[3, 1, 0, 1]=(-0.170638624617-0.873230918179j)*o*x_ref[1]**(o-1)+((-0.748109666055+0.192167944347j))
        arg[3, 1, 1]=(-0.861397878967-0.788778037941j)*x[0]**o+((-0.419191361017+0.507157863865j))*x[0]+((0.190471171149+0.240828185147j))*x[1]**o+((0.186050565547+0.245228763625j))*x[1]
        ref[3, 1, 1, 0]=(-0.861397878967-0.788778037941j)*o*x_ref[0]**(o-1)+((-0.419191361017+0.507157863865j))
        ref[3, 1, 1, 1]=(0.190471171149+0.240828185147j)*o*x_ref[1]**(o-1)+((0.186050565547+0.245228763625j))
        arg[3, 1, 2]=(-0.345468131905+0.833506887833j)*x[0]**o+((-0.73840036236+0.936046456528j))*x[0]+((0.409293738692-0.507331286787j))*x[1]**o+((-0.281216611939+0.0196815282597j))*x[1]
        ref[3, 1, 2, 0]=(-0.345468131905+0.833506887833j)*o*x_ref[0]**(o-1)+((-0.73840036236+0.936046456528j))
        ref[3, 1, 2, 1]=(0.409293738692-0.507331286787j)*o*x_ref[1]**(o-1)+((-0.281216611939+0.0196815282597j))
        arg[3, 1, 3]=(0.322261681266+0.308221014568j)*x[0]**o+((-0.18393795035-0.181086786898j))*x[0]+((-0.779569687274+0.753561412405j))*x[1]**o+((0.911188848908+0.862211594977j))*x[1]
        ref[3, 1, 3, 0]=(0.322261681266+0.308221014568j)*o*x_ref[0]**(o-1)+((-0.18393795035-0.181086786898j))
        ref[3, 1, 3, 1]=(-0.779569687274+0.753561412405j)*o*x_ref[1]**(o-1)+((0.911188848908+0.862211594977j))
        arg[3, 2, 0]=(-0.496629203826+0.39701079924j)*x[0]**o+((0.940787219028+0.979239514799j))*x[0]+((-0.808455147673+0.262855122262j))*x[1]**o+((-0.291349791544-0.775439489339j))*x[1]
        ref[3, 2, 0, 0]=(-0.496629203826+0.39701079924j)*o*x_ref[0]**(o-1)+((0.940787219028+0.979239514799j))
        ref[3, 2, 0, 1]=(-0.808455147673+0.262855122262j)*o*x_ref[1]**(o-1)+((-0.291349791544-0.775439489339j))
        arg[3, 2, 1]=(0.319669414543+0.125234060245j)*x[0]**o+((0.402332400356-0.921712950595j))*x[0]+((-0.492392919435+0.0886651978397j))*x[1]**o+((0.760548126731+0.476918115978j))*x[1]
        ref[3, 2, 1, 0]=(0.319669414543+0.125234060245j)*o*x_ref[0]**(o-1)+((0.402332400356-0.921712950595j))
        ref[3, 2, 1, 1]=(-0.492392919435+0.0886651978397j)*o*x_ref[1]**(o-1)+((0.760548126731+0.476918115978j))
        arg[3, 2, 2]=(0.0605603384169+0.700644609127j)*x[0]**o+((-0.0743695696762+0.141725914997j))*x[0]+((0.356853819201+0.460441913066j))*x[1]**o+((-0.331577243706-0.85020756978j))*x[1]
        ref[3, 2, 2, 0]=(0.0605603384169+0.700644609127j)*o*x_ref[0]**(o-1)+((-0.0743695696762+0.141725914997j))
        ref[3, 2, 2, 1]=(0.356853819201+0.460441913066j)*o*x_ref[1]**(o-1)+((-0.331577243706-0.85020756978j))
        arg[3, 2, 3]=(-0.401686736408-0.0748478129769j)*x[0]**o+((0.843244563102-0.598907950631j))*x[0]+((0.889077837205-0.583439251363j))*x[1]**o+((0.120843272417-0.685098002948j))*x[1]
        ref[3, 2, 3, 0]=(-0.401686736408-0.0748478129769j)*o*x_ref[0]**(o-1)+((0.843244563102-0.598907950631j))
        ref[3, 2, 3, 1]=(0.889077837205-0.583439251363j)*o*x_ref[1]**(o-1)+((0.120843272417-0.685098002948j))
        arg[3, 3, 0]=(-0.69321778257-0.447560736379j)*x[0]**o+((-0.905984427469+0.864411013717j))*x[0]+((0.876537518357-0.419156727844j))*x[1]**o+((0.516618819413+0.356905938822j))*x[1]
        ref[3, 3, 0, 0]=(-0.69321778257-0.447560736379j)*o*x_ref[0]**(o-1)+((-0.905984427469+0.864411013717j))
        ref[3, 3, 0, 1]=(0.876537518357-0.419156727844j)*o*x_ref[1]**(o-1)+((0.516618819413+0.356905938822j))
        arg[3, 3, 1]=(-0.550516540289-0.591533526126j)*x[0]**o+((-0.139395866503-0.980202412463j))*x[0]+((-0.365021249574+0.782104316839j))*x[1]**o+((-0.348942770079-0.00709923810277j))*x[1]
        ref[3, 3, 1, 0]=(-0.550516540289-0.591533526126j)*o*x_ref[0]**(o-1)+((-0.139395866503-0.980202412463j))
        ref[3, 3, 1, 1]=(-0.365021249574+0.782104316839j)*o*x_ref[1]**(o-1)+((-0.348942770079-0.00709923810277j))
        arg[3, 3, 2]=(0.567117047441-0.254635999544j)*x[0]**o+((0.31537876119+0.875962723513j))*x[0]+((0.58367320584-0.602586061219j))*x[1]**o+((0.794045645436-0.859873297881j))*x[1]
        ref[3, 3, 2, 0]=(0.567117047441-0.254635999544j)*o*x_ref[0]**(o-1)+((0.31537876119+0.875962723513j))
        ref[3, 3, 2, 1]=(0.58367320584-0.602586061219j)*o*x_ref[1]**(o-1)+((0.794045645436-0.859873297881j))
        arg[3, 3, 3]=(0.434561074321-0.938083465069j)*x[0]**o+((0.752840872241+0.903603775781j))*x[0]+((0.325835838316-0.0427156240586j))*x[1]**o+((0.979165612713+0.111655709944j))*x[1]
        ref[3, 3, 3, 0]=(0.434561074321-0.938083465069j)*o*x_ref[0]**(o-1)+((0.752840872241+0.903603775781j))
        ref[3, 3, 3, 1]=(0.325835838316-0.0427156240586j)*o*x_ref[1]**(o-1)+((0.979165612713+0.111655709944j))
        if dim==3:
            arg[0, 0, 0]+=(-0.576554800038+0.760268685682j)*x[2]**o+((0.0454970237874-0.236856597563j))*x[2]
            ref[0, 0, 0, 2]=(-0.576554800038+0.760268685682j)*o*x_ref[2]**(o-1)+((0.0454970237874-0.236856597563j))
            arg[0, 0, 1]+=(-0.942425068112+0.918298114464j)*x[2]**o+((0.461251149997-0.737663822922j))*x[2]
            ref[0, 0, 1, 2]=(-0.942425068112+0.918298114464j)*o*x_ref[2]**(o-1)+((0.461251149997-0.737663822922j))
            arg[0, 0, 2]+=(0.72181006725-0.473218668238j)*x[2]**o+((-0.566180929085-0.233919437486j))*x[2]
            ref[0, 0, 2, 2]=(0.72181006725-0.473218668238j)*o*x_ref[2]**(o-1)+((-0.566180929085-0.233919437486j))
            arg[0, 0, 3]+=(-0.0172782093856-0.950245846457j)*x[2]**o+((0.153831336785-0.491501368549j))*x[2]
            ref[0, 0, 3, 2]=(-0.0172782093856-0.950245846457j)*o*x_ref[2]**(o-1)+((0.153831336785-0.491501368549j))
            arg[0, 1, 0]+=(0.382071593016+0.652773921546j)*x[2]**o+((-0.439639490379+0.8482873531j))*x[2]
            ref[0, 1, 0, 2]=(0.382071593016+0.652773921546j)*o*x_ref[2]**(o-1)+((-0.439639490379+0.8482873531j))
            arg[0, 1, 1]+=(0.568899142923-0.853140242949j)*x[2]**o+((-0.274792405346-0.275381237341j))*x[2]
            ref[0, 1, 1, 2]=(0.568899142923-0.853140242949j)*o*x_ref[2]**(o-1)+((-0.274792405346-0.275381237341j))
            arg[0, 1, 2]+=(0.456939275816-0.293833452349j)*x[2]**o+((0.32117175369+0.942508193353j))*x[2]
            ref[0, 1, 2, 2]=(0.456939275816-0.293833452349j)*o*x_ref[2]**(o-1)+((0.32117175369+0.942508193353j))
            arg[0, 1, 3]+=(-0.0295131126558+0.714085532571j)*x[2]**o+((-0.653232064823-0.015714322178j))*x[2]
            ref[0, 1, 3, 2]=(-0.0295131126558+0.714085532571j)*o*x_ref[2]**(o-1)+((-0.653232064823-0.015714322178j))
            arg[0, 2, 0]+=(-0.963651696521+0.00907964697542j)*x[2]**o+((-0.639348042816-0.0632632667611j))*x[2]
            ref[0, 2, 0, 2]=(-0.963651696521+0.00907964697542j)*o*x_ref[2]**(o-1)+((-0.639348042816-0.0632632667611j))
            arg[0, 2, 1]+=(-0.566285252004+0.868869133408j)*x[2]**o+((0.0814993531451+0.172996896915j))*x[2]
            ref[0, 2, 1, 2]=(-0.566285252004+0.868869133408j)*o*x_ref[2]**(o-1)+((0.0814993531451+0.172996896915j))
            arg[0, 2, 2]+=(0.741318095067+0.457004694443j)*x[2]**o+((0.893799302651+0.974663054391j))*x[2]
            ref[0, 2, 2, 2]=(0.741318095067+0.457004694443j)*o*x_ref[2]**(o-1)+((0.893799302651+0.974663054391j))
            arg[0, 2, 3]+=(0.545631977286-0.207939484948j)*x[2]**o+((0.626297574458+0.157651954293j))*x[2]
            ref[0, 2, 3, 2]=(0.545631977286-0.207939484948j)*o*x_ref[2]**(o-1)+((0.626297574458+0.157651954293j))
            arg[0, 3, 0]+=(0.736023273109+0.509305934094j)*x[2]**o+((-0.835246515412+0.733581209254j))*x[2]
            ref[0, 3, 0, 2]=(0.736023273109+0.509305934094j)*o*x_ref[2]**(o-1)+((-0.835246515412+0.733581209254j))
            arg[0, 3, 1]+=(0.212172423293-0.351633788549j)*x[2]**o+((-0.412882273142+0.50068821792j))*x[2]
            ref[0, 3, 1, 2]=(0.212172423293-0.351633788549j)*o*x_ref[2]**(o-1)+((-0.412882273142+0.50068821792j))
            arg[0, 3, 2]+=(-0.369495207958-0.970857220903j)*x[2]**o+((0.694723790694+0.104424698866j))*x[2]
            ref[0, 3, 2, 2]=(-0.369495207958-0.970857220903j)*o*x_ref[2]**(o-1)+((0.694723790694+0.104424698866j))
            arg[0, 3, 3]+=(-0.510670889947+0.358376747043j)*x[2]**o+((0.168351232419+0.802400972781j))*x[2]
            ref[0, 3, 3, 2]=(-0.510670889947+0.358376747043j)*o*x_ref[2]**(o-1)+((0.168351232419+0.802400972781j))
            arg[1, 0, 0]+=(-0.273508729416+0.433656784537j)*x[2]**o+((0.303293355641-0.474052445311j))*x[2]
            ref[1, 0, 0, 2]=(-0.273508729416+0.433656784537j)*o*x_ref[2]**(o-1)+((0.303293355641-0.474052445311j))
            arg[1, 0, 1]+=(-0.0836067792287-0.618179133282j)*x[2]**o+((0.450149934193-0.550349853179j))*x[2]
            ref[1, 0, 1, 2]=(-0.0836067792287-0.618179133282j)*o*x_ref[2]**(o-1)+((0.450149934193-0.550349853179j))
            arg[1, 0, 2]+=(-0.013545605535+0.138292254177j)*x[2]**o+((0.321764139851+0.187373473559j))*x[2]
            ref[1, 0, 2, 2]=(-0.013545605535+0.138292254177j)*o*x_ref[2]**(o-1)+((0.321764139851+0.187373473559j))
            arg[1, 0, 3]+=(0.974013805274-0.509817081362j)*x[2]**o+((-0.455651809011-0.691715372891j))*x[2]
            ref[1, 0, 3, 2]=(0.974013805274-0.509817081362j)*o*x_ref[2]**(o-1)+((-0.455651809011-0.691715372891j))
            arg[1, 1, 0]+=(-0.43464085947+0.620630134326j)*x[2]**o+((-0.190249697418+0.181392038801j))*x[2]
            ref[1, 1, 0, 2]=(-0.43464085947+0.620630134326j)*o*x_ref[2]**(o-1)+((-0.190249697418+0.181392038801j))
            arg[1, 1, 1]+=(-0.360003116459-0.0971823108049j)*x[2]**o+((0.00404672639388+0.271818147503j))*x[2]
            ref[1, 1, 1, 2]=(-0.360003116459-0.0971823108049j)*o*x_ref[2]**(o-1)+((0.00404672639388+0.271818147503j))
            arg[1, 1, 2]+=(0.246588172801+0.22431465349j)*x[2]**o+((-0.432085804015+0.407500017022j))*x[2]
            ref[1, 1, 2, 2]=(0.246588172801+0.22431465349j)*o*x_ref[2]**(o-1)+((-0.432085804015+0.407500017022j))
            arg[1, 1, 3]+=(-0.887400717837-0.621724575837j)*x[2]**o+((-0.137250763677+0.776464772321j))*x[2]
            ref[1, 1, 3, 2]=(-0.887400717837-0.621724575837j)*o*x_ref[2]**(o-1)+((-0.137250763677+0.776464772321j))
            arg[1, 2, 0]+=(0.579801270586+0.302016924141j)*x[2]**o+((0.926153226926-0.0151689695006j))*x[2]
            ref[1, 2, 0, 2]=(0.579801270586+0.302016924141j)*o*x_ref[2]**(o-1)+((0.926153226926-0.0151689695006j))
            arg[1, 2, 1]+=(0.266901119962-0.464047007593j)*x[2]**o+((-0.37461160819+0.994832480767j))*x[2]
            ref[1, 2, 1, 2]=(0.266901119962-0.464047007593j)*o*x_ref[2]**(o-1)+((-0.37461160819+0.994832480767j))
            arg[1, 2, 2]+=(0.360512924735+0.990659048384j)*x[2]**o+((-0.914458219671+0.783424064178j))*x[2]
            ref[1, 2, 2, 2]=(0.360512924735+0.990659048384j)*o*x_ref[2]**(o-1)+((-0.914458219671+0.783424064178j))
            arg[1, 2, 3]+=(-0.390756543085-0.867287906624j)*x[2]**o+((-0.273461403307+0.395673592947j))*x[2]
            ref[1, 2, 3, 2]=(-0.390756543085-0.867287906624j)*o*x_ref[2]**(o-1)+((-0.273461403307+0.395673592947j))
            arg[1, 3, 0]+=(0.760991025027+0.79518090006j)*x[2]**o+((0.308278406371-0.751981081962j))*x[2]
            ref[1, 3, 0, 2]=(0.760991025027+0.79518090006j)*o*x_ref[2]**(o-1)+((0.308278406371-0.751981081962j))
            arg[1, 3, 1]+=(0.587597241221+0.771885288978j)*x[2]**o+((-0.0567269481916+0.831923452167j))*x[2]
            ref[1, 3, 1, 2]=(0.587597241221+0.771885288978j)*o*x_ref[2]**(o-1)+((-0.0567269481916+0.831923452167j))
            arg[1, 3, 2]+=(-0.951268537674-0.124399411659j)*x[2]**o+((0.494906306747+0.494100425335j))*x[2]
            ref[1, 3, 2, 2]=(-0.951268537674-0.124399411659j)*o*x_ref[2]**(o-1)+((0.494906306747+0.494100425335j))
            arg[1, 3, 3]+=(-0.143656167406-0.220403874057j)*x[2]**o+((0.881530948012+0.742302840199j))*x[2]
            ref[1, 3, 3, 2]=(-0.143656167406-0.220403874057j)*o*x_ref[2]**(o-1)+((0.881530948012+0.742302840199j))
            arg[2, 0, 0]+=(-0.600399616961-0.812598661987j)*x[2]**o+((0.616642389422+0.571043523747j))*x[2]
            ref[2, 0, 0, 2]=(-0.600399616961-0.812598661987j)*o*x_ref[2]**(o-1)+((0.616642389422+0.571043523747j))
            arg[2, 0, 1]+=(-0.418564436291-0.201563402579j)*x[2]**o+((-0.0822665428415+0.807576463805j))*x[2]
            ref[2, 0, 1, 2]=(-0.418564436291-0.201563402579j)*o*x_ref[2]**(o-1)+((-0.0822665428415+0.807576463805j))
            arg[2, 0, 2]+=(-0.45898221693+0.0913040681226j)*x[2]**o+((-0.602297034163-0.742269418441j))*x[2]
            ref[2, 0, 2, 2]=(-0.45898221693+0.0913040681226j)*o*x_ref[2]**(o-1)+((-0.602297034163-0.742269418441j))
            arg[2, 0, 3]+=(-0.439847395901+0.200238240227j)*x[2]**o+((-0.624550789816+0.446010566643j))*x[2]
            ref[2, 0, 3, 2]=(-0.439847395901+0.200238240227j)*o*x_ref[2]**(o-1)+((-0.624550789816+0.446010566643j))
            arg[2, 1, 0]+=(0.636734129683+0.364757538435j)*x[2]**o+((0.165161901065+0.543271332863j))*x[2]
            ref[2, 1, 0, 2]=(0.636734129683+0.364757538435j)*o*x_ref[2]**(o-1)+((0.165161901065+0.543271332863j))
            arg[2, 1, 1]+=(0.86457665224+0.73427843993j)*x[2]**o+((0.916895580966+0.0164735864135j))*x[2]
            ref[2, 1, 1, 2]=(0.86457665224+0.73427843993j)*o*x_ref[2]**(o-1)+((0.916895580966+0.0164735864135j))
            arg[2, 1, 2]+=(-0.978092913166-0.592060359721j)*x[2]**o+((0.917742409387+0.0149068890041j))*x[2]
            ref[2, 1, 2, 2]=(-0.978092913166-0.592060359721j)*o*x_ref[2]**(o-1)+((0.917742409387+0.0149068890041j))
            arg[2, 1, 3]+=(-0.289236233706+0.782014999071j)*x[2]**o+((0.748236988384+0.209368392271j))*x[2]
            ref[2, 1, 3, 2]=(-0.289236233706+0.782014999071j)*o*x_ref[2]**(o-1)+((0.748236988384+0.209368392271j))
            arg[2, 2, 0]+=(-0.157963202092+0.199666829602j)*x[2]**o+((-0.730414899279-0.778871024719j))*x[2]
            ref[2, 2, 0, 2]=(-0.157963202092+0.199666829602j)*o*x_ref[2]**(o-1)+((-0.730414899279-0.778871024719j))
            arg[2, 2, 1]+=(0.199002460161-0.265832639219j)*x[2]**o+((0.613805856838-0.462576605725j))*x[2]
            ref[2, 2, 1, 2]=(0.199002460161-0.265832639219j)*o*x_ref[2]**(o-1)+((0.613805856838-0.462576605725j))
            arg[2, 2, 2]+=(0.648361802569-0.354105672665j)*x[2]**o+((-0.097863285453-0.882017007184j))*x[2]
            ref[2, 2, 2, 2]=(0.648361802569-0.354105672665j)*o*x_ref[2]**(o-1)+((-0.097863285453-0.882017007184j))
            arg[2, 2, 3]+=(-0.881458148127+0.2098940498j)*x[2]**o+((-0.220040276868-0.244049687223j))*x[2]
            ref[2, 2, 3, 2]=(-0.881458148127+0.2098940498j)*o*x_ref[2]**(o-1)+((-0.220040276868-0.244049687223j))
            arg[2, 3, 0]+=(0.929289791412+0.578041017177j)*x[2]**o+((0.383261188487+0.720628953191j))*x[2]
            ref[2, 3, 0, 2]=(0.929289791412+0.578041017177j)*o*x_ref[2]**(o-1)+((0.383261188487+0.720628953191j))
            arg[2, 3, 1]+=(0.708939905096-0.618339602652j)*x[2]**o+((-0.179414315461+0.907029203216j))*x[2]
            ref[2, 3, 1, 2]=(0.708939905096-0.618339602652j)*o*x_ref[2]**(o-1)+((-0.179414315461+0.907029203216j))
            arg[2, 3, 2]+=(-0.564615960535+0.801767639024j)*x[2]**o+((0.426492022801-0.420195761572j))*x[2]
            ref[2, 3, 2, 2]=(-0.564615960535+0.801767639024j)*o*x_ref[2]**(o-1)+((0.426492022801-0.420195761572j))
            arg[2, 3, 3]+=(0.585351825322+0.406929495047j)*x[2]**o+((-0.56028045222+0.750296519498j))*x[2]
            ref[2, 3, 3, 2]=(0.585351825322+0.406929495047j)*o*x_ref[2]**(o-1)+((-0.56028045222+0.750296519498j))
            arg[3, 0, 0]+=(0.842174820303-0.290815765298j)*x[2]**o+((-0.206910086572-0.389083534419j))*x[2]
            ref[3, 0, 0, 2]=(0.842174820303-0.290815765298j)*o*x_ref[2]**(o-1)+((-0.206910086572-0.389083534419j))
            arg[3, 0, 1]+=(-0.900023401813-0.727455447025j)*x[2]**o+((0.796969650366-0.378772883694j))*x[2]
            ref[3, 0, 1, 2]=(-0.900023401813-0.727455447025j)*o*x_ref[2]**(o-1)+((0.796969650366-0.378772883694j))
            arg[3, 0, 2]+=(-0.868281074495-0.49013436053j)*x[2]**o+((0.643693712482+0.211870994761j))*x[2]
            ref[3, 0, 2, 2]=(-0.868281074495-0.49013436053j)*o*x_ref[2]**(o-1)+((0.643693712482+0.211870994761j))
            arg[3, 0, 3]+=(0.603285620721-0.505626277483j)*x[2]**o+((0.399187172395+0.38014766368j))*x[2]
            ref[3, 0, 3, 2]=(0.603285620721-0.505626277483j)*o*x_ref[2]**(o-1)+((0.399187172395+0.38014766368j))
            arg[3, 1, 0]+=(0.813141102802+0.774282627709j)*x[2]**o+((-0.965623796639-0.0518692437286j))*x[2]
            ref[3, 1, 0, 2]=(0.813141102802+0.774282627709j)*o*x_ref[2]**(o-1)+((-0.965623796639-0.0518692437286j))
            arg[3, 1, 1]+=(-0.668264789933-0.194743432428j)*x[2]**o+((-0.17324410802+0.0608364845972j))*x[2]
            ref[3, 1, 1, 2]=(-0.668264789933-0.194743432428j)*o*x_ref[2]**(o-1)+((-0.17324410802+0.0608364845972j))
            arg[3, 1, 2]+=(-0.622063341472+0.195193936902j)*x[2]**o+((-0.612210513729-0.379005342999j))*x[2]
            ref[3, 1, 2, 2]=(-0.622063341472+0.195193936902j)*o*x_ref[2]**(o-1)+((-0.612210513729-0.379005342999j))
            arg[3, 1, 3]+=(0.604293283699+0.900898271301j)*x[2]**o+((-0.160490091807+0.469043060316j))*x[2]
            ref[3, 1, 3, 2]=(0.604293283699+0.900898271301j)*o*x_ref[2]**(o-1)+((-0.160490091807+0.469043060316j))
            arg[3, 2, 0]+=(-0.933030291602-0.536086703101j)*x[2]**o+((-0.898308449193+0.453661697331j))*x[2]
            ref[3, 2, 0, 2]=(-0.933030291602-0.536086703101j)*o*x_ref[2]**(o-1)+((-0.898308449193+0.453661697331j))
            arg[3, 2, 1]+=(-0.720156766667-0.335397697356j)*x[2]**o+((0.497740548177+0.980438459723j))*x[2]
            ref[3, 2, 1, 2]=(-0.720156766667-0.335397697356j)*o*x_ref[2]**(o-1)+((0.497740548177+0.980438459723j))
            arg[3, 2, 2]+=(-0.450979862598+0.999787378021j)*x[2]**o+((0.26571168215-0.756153773126j))*x[2]
            ref[3, 2, 2, 2]=(-0.450979862598+0.999787378021j)*o*x_ref[2]**(o-1)+((0.26571168215-0.756153773126j))
            arg[3, 2, 3]+=(0.526015354487-0.323349071287j)*x[2]**o+((-0.462676805231+0.809157091126j))*x[2]
            ref[3, 2, 3, 2]=(0.526015354487-0.323349071287j)*o*x_ref[2]**(o-1)+((-0.462676805231+0.809157091126j))
            arg[3, 3, 0]+=(-0.165436202081-0.135893118477j)*x[2]**o+((0.925051282681+0.430641152513j))*x[2]
            ref[3, 3, 0, 2]=(-0.165436202081-0.135893118477j)*o*x_ref[2]**(o-1)+((0.925051282681+0.430641152513j))
            arg[3, 3, 1]+=(-0.290021709748-0.712904869848j)*x[2]**o+((-0.57720947302+0.659138498291j))*x[2]
            ref[3, 3, 1, 2]=(-0.290021709748-0.712904869848j)*o*x_ref[2]**(o-1)+((-0.57720947302+0.659138498291j))
            arg[3, 3, 2]+=(0.898289225625+0.653956246437j)*x[2]**o+((-0.915742665122+0.238062088403j))*x[2]
            ref[3, 3, 2, 2]=(0.898289225625+0.653956246437j)*o*x_ref[2]**(o-1)+((-0.915742665122+0.238062088403j))
            arg[3, 3, 3]+=(0.752427230374-0.0508070122923j)*x[2]**o+((0.787943470083+0.669767524122j))*x[2]
            ref[3, 3, 3, 2]=(0.752427230374-0.0508070122923j)*o*x_ref[2]**(o-1)+((0.787943470083+0.669767524122j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4, 4, 4)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnContactOne_fromData_Solution_rank0(self):
        """
        tests gradient of rank 0 Data on ReducedFunctionOnContactOne

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnContactOne
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnContactOne(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=(0.303344873589+0.791951643615j)*x[0]**o+((-0.625759519734+0.678904200813j))*x[0]+((0.38903732123-0.0315335356467j))*x[1]**o+((0.589334123637-0.442655340859j))*x[1]
        ref[0]=(0.303344873589+0.791951643615j)*o*x_ref[0]**(o-1)+((-0.625759519734+0.678904200813j))
        ref[1]=(0.38903732123-0.0315335356467j)*o*x_ref[1]**(o-1)+((0.589334123637-0.442655340859j))
        if dim==3:
            arg+=((0.262284923073+0.551101170898j))*x[2]**o+((-0.292364765321-0.340247470549j))*x[2]
            ref[2]=(0.262284923073+0.551101170898j)*o*x_ref[2]**(o-1)+((-0.292364765321-0.340247470549j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnContactOne_fromData_Solution_rank1(self):
        """
        tests gradient of rank 1 Data on ReducedFunctionOnContactOne

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnContactOne
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnContactOne(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(2,),w)
        ref = Data(0,(2,)+(dim,),w_ref)
        arg[0,]=(-0.401961236288+0.738927358114j)*x[0]**o+((-0.145151129957+0.690395533763j))*x[0]+((-0.0606843527897+0.54859606798j))*x[1]**o+((-0.459662534987-0.471821903473j))*x[1]
        ref[0, 0]=(-0.401961236288+0.738927358114j)*o*x_ref[0]**(o-1)+((-0.145151129957+0.690395533763j))
        ref[0, 1]=(-0.0606843527897+0.54859606798j)*o*x_ref[1]**(o-1)+((-0.459662534987-0.471821903473j))
        arg[1,]=(-0.0201726175893-0.904944378972j)*x[0]**o+((-0.782093022435+0.381473389072j))*x[0]+((-0.372644506614+0.188605241391j))*x[1]**o+((0.230981485353-0.00578873997808j))*x[1]
        ref[1, 0]=(-0.0201726175893-0.904944378972j)*o*x_ref[0]**(o-1)+((-0.782093022435+0.381473389072j))
        ref[1, 1]=(-0.372644506614+0.188605241391j)*o*x_ref[1]**(o-1)+((0.230981485353-0.00578873997808j))
        if dim==3:
            arg[0,]+=(-0.816762378927-0.297386563365j)*x[2]**o+((-0.906729030273+0.840185360695j))*x[2]
            ref[0, 2]=(-0.816762378927-0.297386563365j)*o*x_ref[2]**(o-1)+((-0.906729030273+0.840185360695j))
            arg[1,]+=(0.57347191196-0.707252605781j)*x[2]**o+((-0.824901739485+0.194329640968j))*x[2]
            ref[1, 2]=(0.57347191196-0.707252605781j)*o*x_ref[2]**(o-1)+((-0.824901739485+0.194329640968j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnContactOne_fromData_Solution_rank2(self):
        """
        tests gradient of rank 2 Data on ReducedFunctionOnContactOne

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnContactOne
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnContactOne(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(2, 3),w)
        ref = Data(0,(2, 3)+(dim,),w_ref)
        arg[0, 0]=(-0.379677113311-0.363854806633j)*x[0]**o+((0.0261902394358-0.494183615873j))*x[0]+((0.445406397114+0.357634097586j))*x[1]**o+((0.837678622688+0.447782124256j))*x[1]
        ref[0, 0, 0]=(-0.379677113311-0.363854806633j)*o*x_ref[0]**(o-1)+((0.0261902394358-0.494183615873j))
        ref[0, 0, 1]=(0.445406397114+0.357634097586j)*o*x_ref[1]**(o-1)+((0.837678622688+0.447782124256j))
        arg[0, 1]=(0.737375355555+0.945288965689j)*x[0]**o+((-0.168009576897-0.633829475991j))*x[0]+((-0.067358230129+0.806593602553j))*x[1]**o+((-0.844245219768+0.756418112398j))*x[1]
        ref[0, 1, 0]=(0.737375355555+0.945288965689j)*o*x_ref[0]**(o-1)+((-0.168009576897-0.633829475991j))
        ref[0, 1, 1]=(-0.067358230129+0.806593602553j)*o*x_ref[1]**(o-1)+((-0.844245219768+0.756418112398j))
        arg[0, 2]=(-0.158167706243+0.473689791284j)*x[0]**o+((0.838640781071-0.656354499204j))*x[0]+((-0.976882430818+0.473396436095j))*x[1]**o+((0.649718501537+0.018896136829j))*x[1]
        ref[0, 2, 0]=(-0.158167706243+0.473689791284j)*o*x_ref[0]**(o-1)+((0.838640781071-0.656354499204j))
        ref[0, 2, 1]=(-0.976882430818+0.473396436095j)*o*x_ref[1]**(o-1)+((0.649718501537+0.018896136829j))
        arg[1, 0]=(0.751464486533-0.942677160637j)*x[0]**o+((-0.357701101766+0.158013628237j))*x[0]+((-0.668229093144-0.965284257501j))*x[1]**o+((0.216204809424+0.458977690095j))*x[1]
        ref[1, 0, 0]=(0.751464486533-0.942677160637j)*o*x_ref[0]**(o-1)+((-0.357701101766+0.158013628237j))
        ref[1, 0, 1]=(-0.668229093144-0.965284257501j)*o*x_ref[1]**(o-1)+((0.216204809424+0.458977690095j))
        arg[1, 1]=(0.606684811512+0.869344076758j)*x[0]**o+((0.50590408061+0.803586098429j))*x[0]+((0.449488744012-0.770067744568j))*x[1]**o+((-0.896233254326-0.997316679464j))*x[1]
        ref[1, 1, 0]=(0.606684811512+0.869344076758j)*o*x_ref[0]**(o-1)+((0.50590408061+0.803586098429j))
        ref[1, 1, 1]=(0.449488744012-0.770067744568j)*o*x_ref[1]**(o-1)+((-0.896233254326-0.997316679464j))
        arg[1, 2]=(0.487064162969+0.332696494981j)*x[0]**o+((-0.539421146201+0.272070498139j))*x[0]+((0.224773778808-0.354028212608j))*x[1]**o+((-0.708920442567+0.874252587994j))*x[1]
        ref[1, 2, 0]=(0.487064162969+0.332696494981j)*o*x_ref[0]**(o-1)+((-0.539421146201+0.272070498139j))
        ref[1, 2, 1]=(0.224773778808-0.354028212608j)*o*x_ref[1]**(o-1)+((-0.708920442567+0.874252587994j))
        if dim==3:
            arg[0, 0]+=(-0.721815238672+0.645249322562j)*x[2]**o+((0.967834138279-0.327411251505j))*x[2]
            ref[0, 0, 2]=(-0.721815238672+0.645249322562j)*o*x_ref[2]**(o-1)+((0.967834138279-0.327411251505j))
            arg[0, 1]+=(-0.00138585285253+0.340205355775j)*x[2]**o+((-0.471262213456-0.279757196792j))*x[2]
            ref[0, 1, 2]=(-0.00138585285253+0.340205355775j)*o*x_ref[2]**(o-1)+((-0.471262213456-0.279757196792j))
            arg[0, 2]+=(-0.902393998925-0.776573242589j)*x[2]**o+((-0.784220779654-0.25496010405j))*x[2]
            ref[0, 2, 2]=(-0.902393998925-0.776573242589j)*o*x_ref[2]**(o-1)+((-0.784220779654-0.25496010405j))
            arg[1, 0]+=(0.27550262707-0.709646997465j)*x[2]**o+((0.638978830041-0.793565423382j))*x[2]
            ref[1, 0, 2]=(0.27550262707-0.709646997465j)*o*x_ref[2]**(o-1)+((0.638978830041-0.793565423382j))
            arg[1, 1]+=(-0.14264930869+0.0902510647462j)*x[2]**o+((-0.572668028233+0.171412058696j))*x[2]
            ref[1, 1, 2]=(-0.14264930869+0.0902510647462j)*o*x_ref[2]**(o-1)+((-0.572668028233+0.171412058696j))
            arg[1, 2]+=(0.670423874322+0.14104054082j)*x[2]**o+((0.275465959512-0.878127877335j))*x[2]
            ref[1, 2, 2]=(0.670423874322+0.14104054082j)*o*x_ref[2]**(o-1)+((0.275465959512-0.878127877335j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2, 3)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnContactOne_fromData_Solution_rank3(self):
        """
        tests gradient of rank 3 Data on ReducedFunctionOnContactOne

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnContactOne
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnContactOne(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(4, 4, 4),w)
        ref = Data(0,(4, 4, 4)+(dim,),w_ref)
        arg[0, 0, 0]=(-0.135072678392-0.850192212743j)*x[0]**o+((-0.496049509877-0.0863355074132j))*x[0]+((0.69400204982+0.698127531707j))*x[1]**o+((-0.98195304039-0.978045514681j))*x[1]
        ref[0, 0, 0, 0]=(-0.135072678392-0.850192212743j)*o*x_ref[0]**(o-1)+((-0.496049509877-0.0863355074132j))
        ref[0, 0, 0, 1]=(0.69400204982+0.698127531707j)*o*x_ref[1]**(o-1)+((-0.98195304039-0.978045514681j))
        arg[0, 0, 1]=(0.549004638882+0.526133749959j)*x[0]**o+((0.969868400327+0.0605116999361j))*x[0]+((0.690927845134-0.0200707515139j))*x[1]**o+((0.16309555756-0.996218750852j))*x[1]
        ref[0, 0, 1, 0]=(0.549004638882+0.526133749959j)*o*x_ref[0]**(o-1)+((0.969868400327+0.0605116999361j))
        ref[0, 0, 1, 1]=(0.690927845134-0.0200707515139j)*o*x_ref[1]**(o-1)+((0.16309555756-0.996218750852j))
        arg[0, 0, 2]=(0.470021573316+0.725587270592j)*x[0]**o+((0.587844669169+0.330779525535j))*x[0]+((0.261574183166-0.649865786852j))*x[1]**o+((-0.246581296005+0.445756325841j))*x[1]
        ref[0, 0, 2, 0]=(0.470021573316+0.725587270592j)*o*x_ref[0]**(o-1)+((0.587844669169+0.330779525535j))
        ref[0, 0, 2, 1]=(0.261574183166-0.649865786852j)*o*x_ref[1]**(o-1)+((-0.246581296005+0.445756325841j))
        arg[0, 0, 3]=(0.110021189946-0.255138785976j)*x[0]**o+((-0.585482985631-0.236677434195j))*x[0]+((0.515287117127+0.290833098867j))*x[1]**o+((0.604350258542+0.79519631517j))*x[1]
        ref[0, 0, 3, 0]=(0.110021189946-0.255138785976j)*o*x_ref[0]**(o-1)+((-0.585482985631-0.236677434195j))
        ref[0, 0, 3, 1]=(0.515287117127+0.290833098867j)*o*x_ref[1]**(o-1)+((0.604350258542+0.79519631517j))
        arg[0, 1, 0]=(-0.234938202747+0.695922413236j)*x[0]**o+((-0.591314154922-0.470660959695j))*x[0]+((-0.355936387268+0.397182133797j))*x[1]**o+((0.972163175126-0.431655732239j))*x[1]
        ref[0, 1, 0, 0]=(-0.234938202747+0.695922413236j)*o*x_ref[0]**(o-1)+((-0.591314154922-0.470660959695j))
        ref[0, 1, 0, 1]=(-0.355936387268+0.397182133797j)*o*x_ref[1]**(o-1)+((0.972163175126-0.431655732239j))
        arg[0, 1, 1]=(-0.143705319592+0.480420418127j)*x[0]**o+((0.716512647281+0.442452824877j))*x[0]+((0.309077481953-0.297629703762j))*x[1]**o+((-0.306163745231+0.317476976161j))*x[1]
        ref[0, 1, 1, 0]=(-0.143705319592+0.480420418127j)*o*x_ref[0]**(o-1)+((0.716512647281+0.442452824877j))
        ref[0, 1, 1, 1]=(0.309077481953-0.297629703762j)*o*x_ref[1]**(o-1)+((-0.306163745231+0.317476976161j))
        arg[0, 1, 2]=(-0.277250044089-0.99297474939j)*x[0]**o+((0.590315836353+0.0691757555219j))*x[0]+((0.0473810153127-0.309060586987j))*x[1]**o+((-0.528175796102+0.249303029335j))*x[1]
        ref[0, 1, 2, 0]=(-0.277250044089-0.99297474939j)*o*x_ref[0]**(o-1)+((0.590315836353+0.0691757555219j))
        ref[0, 1, 2, 1]=(0.0473810153127-0.309060586987j)*o*x_ref[1]**(o-1)+((-0.528175796102+0.249303029335j))
        arg[0, 1, 3]=(0.502476277902+0.746111975865j)*x[0]**o+((0.517214122199+0.563213034995j))*x[0]+((0.370899177885-0.995139476106j))*x[1]**o+((-0.545762610955+0.762065256441j))*x[1]
        ref[0, 1, 3, 0]=(0.502476277902+0.746111975865j)*o*x_ref[0]**(o-1)+((0.517214122199+0.563213034995j))
        ref[0, 1, 3, 1]=(0.370899177885-0.995139476106j)*o*x_ref[1]**(o-1)+((-0.545762610955+0.762065256441j))
        arg[0, 2, 0]=(0.263627008683-0.174951666431j)*x[0]**o+((-0.821356228851+0.397050664859j))*x[0]+((0.844047068026+0.604144594162j))*x[1]**o+((0.122587091657+0.547917768069j))*x[1]
        ref[0, 2, 0, 0]=(0.263627008683-0.174951666431j)*o*x_ref[0]**(o-1)+((-0.821356228851+0.397050664859j))
        ref[0, 2, 0, 1]=(0.844047068026+0.604144594162j)*o*x_ref[1]**(o-1)+((0.122587091657+0.547917768069j))
        arg[0, 2, 1]=(0.685112141782+0.221605296935j)*x[0]**o+((0.269234296012+0.102657792078j))*x[0]+((0.107533035361+0.216804524893j))*x[1]**o+((-0.714905057057+0.830482015134j))*x[1]
        ref[0, 2, 1, 0]=(0.685112141782+0.221605296935j)*o*x_ref[0]**(o-1)+((0.269234296012+0.102657792078j))
        ref[0, 2, 1, 1]=(0.107533035361+0.216804524893j)*o*x_ref[1]**(o-1)+((-0.714905057057+0.830482015134j))
        arg[0, 2, 2]=(-0.459156953617+0.612439141626j)*x[0]**o+((-0.886765419848-0.249950978599j))*x[0]+((-0.813373471183-0.148004153741j))*x[1]**o+((0.963158576309+0.417935005814j))*x[1]
        ref[0, 2, 2, 0]=(-0.459156953617+0.612439141626j)*o*x_ref[0]**(o-1)+((-0.886765419848-0.249950978599j))
        ref[0, 2, 2, 1]=(-0.813373471183-0.148004153741j)*o*x_ref[1]**(o-1)+((0.963158576309+0.417935005814j))
        arg[0, 2, 3]=(0.677653929204-0.972568156981j)*x[0]**o+((0.899473886176+0.273989554304j))*x[0]+((0.243389215082-0.788597206778j))*x[1]**o+((-0.441110569019+0.631092403405j))*x[1]
        ref[0, 2, 3, 0]=(0.677653929204-0.972568156981j)*o*x_ref[0]**(o-1)+((0.899473886176+0.273989554304j))
        ref[0, 2, 3, 1]=(0.243389215082-0.788597206778j)*o*x_ref[1]**(o-1)+((-0.441110569019+0.631092403405j))
        arg[0, 3, 0]=(0.545373855784+0.461474637602j)*x[0]**o+((0.724081118844-0.340556871186j))*x[0]+((0.375780601357-0.506387828039j))*x[1]**o+((-0.805261202802-0.834187860344j))*x[1]
        ref[0, 3, 0, 0]=(0.545373855784+0.461474637602j)*o*x_ref[0]**(o-1)+((0.724081118844-0.340556871186j))
        ref[0, 3, 0, 1]=(0.375780601357-0.506387828039j)*o*x_ref[1]**(o-1)+((-0.805261202802-0.834187860344j))
        arg[0, 3, 1]=(-0.742972740598-0.713066892709j)*x[0]**o+((0.620784546365-0.845091131936j))*x[0]+((-0.100599666666+0.92958342962j))*x[1]**o+((-0.864782501714+0.719189582344j))*x[1]
        ref[0, 3, 1, 0]=(-0.742972740598-0.713066892709j)*o*x_ref[0]**(o-1)+((0.620784546365-0.845091131936j))
        ref[0, 3, 1, 1]=(-0.100599666666+0.92958342962j)*o*x_ref[1]**(o-1)+((-0.864782501714+0.719189582344j))
        arg[0, 3, 2]=(-0.295738818342+0.232417548677j)*x[0]**o+((-0.617867605863-0.205204550223j))*x[0]+((0.0791985552702+0.899263294899j))*x[1]**o+((0.682497198579-0.706691847468j))*x[1]
        ref[0, 3, 2, 0]=(-0.295738818342+0.232417548677j)*o*x_ref[0]**(o-1)+((-0.617867605863-0.205204550223j))
        ref[0, 3, 2, 1]=(0.0791985552702+0.899263294899j)*o*x_ref[1]**(o-1)+((0.682497198579-0.706691847468j))
        arg[0, 3, 3]=(0.43647040078-0.878196922324j)*x[0]**o+((0.312221689957-0.795129752709j))*x[0]+((0.226002747606+0.370987419967j))*x[1]**o+((0.471013585591+0.837056319117j))*x[1]
        ref[0, 3, 3, 0]=(0.43647040078-0.878196922324j)*o*x_ref[0]**(o-1)+((0.312221689957-0.795129752709j))
        ref[0, 3, 3, 1]=(0.226002747606+0.370987419967j)*o*x_ref[1]**(o-1)+((0.471013585591+0.837056319117j))
        arg[1, 0, 0]=(-0.479851838447+0.630842337198j)*x[0]**o+((0.246005323187-0.283839279058j))*x[0]+((0.862186293316+0.00368092218705j))*x[1]**o+((-0.264750103402-0.717761420688j))*x[1]
        ref[1, 0, 0, 0]=(-0.479851838447+0.630842337198j)*o*x_ref[0]**(o-1)+((0.246005323187-0.283839279058j))
        ref[1, 0, 0, 1]=(0.862186293316+0.00368092218705j)*o*x_ref[1]**(o-1)+((-0.264750103402-0.717761420688j))
        arg[1, 0, 1]=(-0.0263575580933+0.783467306941j)*x[0]**o+((0.70874172922-0.122426785861j))*x[0]+((0.30948717457-0.935321258013j))*x[1]**o+((0.229437707865-0.999280477429j))*x[1]
        ref[1, 0, 1, 0]=(-0.0263575580933+0.783467306941j)*o*x_ref[0]**(o-1)+((0.70874172922-0.122426785861j))
        ref[1, 0, 1, 1]=(0.30948717457-0.935321258013j)*o*x_ref[1]**(o-1)+((0.229437707865-0.999280477429j))
        arg[1, 0, 2]=(-0.911679393427+0.735000089962j)*x[0]**o+((0.232662995142+0.699301914617j))*x[0]+((0.156442158935+0.865349345842j))*x[1]**o+((-0.325114329315-0.642279973393j))*x[1]
        ref[1, 0, 2, 0]=(-0.911679393427+0.735000089962j)*o*x_ref[0]**(o-1)+((0.232662995142+0.699301914617j))
        ref[1, 0, 2, 1]=(0.156442158935+0.865349345842j)*o*x_ref[1]**(o-1)+((-0.325114329315-0.642279973393j))
        arg[1, 0, 3]=(0.587425897109-0.249733068389j)*x[0]**o+((0.189018958088+0.150236179634j))*x[0]+((0.210152873111-0.141040283173j))*x[1]**o+((0.860188020356-0.646573684578j))*x[1]
        ref[1, 0, 3, 0]=(0.587425897109-0.249733068389j)*o*x_ref[0]**(o-1)+((0.189018958088+0.150236179634j))
        ref[1, 0, 3, 1]=(0.210152873111-0.141040283173j)*o*x_ref[1]**(o-1)+((0.860188020356-0.646573684578j))
        arg[1, 1, 0]=(-0.63457658692+0.421432643732j)*x[0]**o+((0.189131252616-0.716818698164j))*x[0]+((0.830712138791+0.641147118682j))*x[1]**o+((0.0268546838012-0.530185851409j))*x[1]
        ref[1, 1, 0, 0]=(-0.63457658692+0.421432643732j)*o*x_ref[0]**(o-1)+((0.189131252616-0.716818698164j))
        ref[1, 1, 0, 1]=(0.830712138791+0.641147118682j)*o*x_ref[1]**(o-1)+((0.0268546838012-0.530185851409j))
        arg[1, 1, 1]=(-0.208441598576+0.840051254705j)*x[0]**o+((-0.5059376123-0.405559107594j))*x[0]+((0.725953262619-0.470257574005j))*x[1]**o+((0.237317127181-0.937429520844j))*x[1]
        ref[1, 1, 1, 0]=(-0.208441598576+0.840051254705j)*o*x_ref[0]**(o-1)+((-0.5059376123-0.405559107594j))
        ref[1, 1, 1, 1]=(0.725953262619-0.470257574005j)*o*x_ref[1]**(o-1)+((0.237317127181-0.937429520844j))
        arg[1, 1, 2]=(-0.155011924916-0.628243491606j)*x[0]**o+((0.219269044813+0.577264268752j))*x[0]+((0.381156185328+0.129258389195j))*x[1]**o+((-0.715672566943+0.645413943438j))*x[1]
        ref[1, 1, 2, 0]=(-0.155011924916-0.628243491606j)*o*x_ref[0]**(o-1)+((0.219269044813+0.577264268752j))
        ref[1, 1, 2, 1]=(0.381156185328+0.129258389195j)*o*x_ref[1]**(o-1)+((-0.715672566943+0.645413943438j))
        arg[1, 1, 3]=(-0.628222966238-0.832145654453j)*x[0]**o+((-0.641175172989+0.343650991971j))*x[0]+((0.918995270141-0.207239552527j))*x[1]**o+((0.34272171363+0.144627887447j))*x[1]
        ref[1, 1, 3, 0]=(-0.628222966238-0.832145654453j)*o*x_ref[0]**(o-1)+((-0.641175172989+0.343650991971j))
        ref[1, 1, 3, 1]=(0.918995270141-0.207239552527j)*o*x_ref[1]**(o-1)+((0.34272171363+0.144627887447j))
        arg[1, 2, 0]=(0.66872216261-0.782667574464j)*x[0]**o+((-0.139635281915+0.442641303869j))*x[0]+((-0.733611616122-0.491505163845j))*x[1]**o+((0.238807922009+0.72226601597j))*x[1]
        ref[1, 2, 0, 0]=(0.66872216261-0.782667574464j)*o*x_ref[0]**(o-1)+((-0.139635281915+0.442641303869j))
        ref[1, 2, 0, 1]=(-0.733611616122-0.491505163845j)*o*x_ref[1]**(o-1)+((0.238807922009+0.72226601597j))
        arg[1, 2, 1]=(-0.469099879168-0.915773299198j)*x[0]**o+((-0.441558488393-0.0916036277028j))*x[0]+((0.751604349665+0.946337470787j))*x[1]**o+((-0.728293934151-0.248368486432j))*x[1]
        ref[1, 2, 1, 0]=(-0.469099879168-0.915773299198j)*o*x_ref[0]**(o-1)+((-0.441558488393-0.0916036277028j))
        ref[1, 2, 1, 1]=(0.751604349665+0.946337470787j)*o*x_ref[1]**(o-1)+((-0.728293934151-0.248368486432j))
        arg[1, 2, 2]=(-0.670278224345-0.289566215726j)*x[0]**o+((0.8093097306+0.51395345137j))*x[0]+((0.105275760329+0.37712289309j))*x[1]**o+((-0.816781215645-0.364015351092j))*x[1]
        ref[1, 2, 2, 0]=(-0.670278224345-0.289566215726j)*o*x_ref[0]**(o-1)+((0.8093097306+0.51395345137j))
        ref[1, 2, 2, 1]=(0.105275760329+0.37712289309j)*o*x_ref[1]**(o-1)+((-0.816781215645-0.364015351092j))
        arg[1, 2, 3]=(-0.384289154209+0.988009783314j)*x[0]**o+((0.447811029519+0.775901430055j))*x[0]+((0.578020044313+0.278850903664j))*x[1]**o+((0.527562244365+0.58568784272j))*x[1]
        ref[1, 2, 3, 0]=(-0.384289154209+0.988009783314j)*o*x_ref[0]**(o-1)+((0.447811029519+0.775901430055j))
        ref[1, 2, 3, 1]=(0.578020044313+0.278850903664j)*o*x_ref[1]**(o-1)+((0.527562244365+0.58568784272j))
        arg[1, 3, 0]=(-0.134925912954-0.85417584632j)*x[0]**o+((0.500101343077+0.628981968634j))*x[0]+((0.229547777+0.437817713753j))*x[1]**o+((0.715506558878+0.564531801754j))*x[1]
        ref[1, 3, 0, 0]=(-0.134925912954-0.85417584632j)*o*x_ref[0]**(o-1)+((0.500101343077+0.628981968634j))
        ref[1, 3, 0, 1]=(0.229547777+0.437817713753j)*o*x_ref[1]**(o-1)+((0.715506558878+0.564531801754j))
        arg[1, 3, 1]=(-0.864245937824+0.594538820342j)*x[0]**o+((-0.133376733947+0.44403552096j))*x[0]+((0.856981770363-0.42144442666j))*x[1]**o+((0.999123585718-0.123148997099j))*x[1]
        ref[1, 3, 1, 0]=(-0.864245937824+0.594538820342j)*o*x_ref[0]**(o-1)+((-0.133376733947+0.44403552096j))
        ref[1, 3, 1, 1]=(0.856981770363-0.42144442666j)*o*x_ref[1]**(o-1)+((0.999123585718-0.123148997099j))
        arg[1, 3, 2]=(0.58370417325-0.884856537536j)*x[0]**o+((0.777621507828+0.798925360423j))*x[0]+((0.827177808699+0.386455276101j))*x[1]**o+((0.203059584468+0.968323551032j))*x[1]
        ref[1, 3, 2, 0]=(0.58370417325-0.884856537536j)*o*x_ref[0]**(o-1)+((0.777621507828+0.798925360423j))
        ref[1, 3, 2, 1]=(0.827177808699+0.386455276101j)*o*x_ref[1]**(o-1)+((0.203059584468+0.968323551032j))
        arg[1, 3, 3]=(0.330353235933-0.948763987705j)*x[0]**o+((-0.158662420414+0.111395165126j))*x[0]+((0.50027804963-0.955158055027j))*x[1]**o+((-0.663358861929-0.600678732058j))*x[1]
        ref[1, 3, 3, 0]=(0.330353235933-0.948763987705j)*o*x_ref[0]**(o-1)+((-0.158662420414+0.111395165126j))
        ref[1, 3, 3, 1]=(0.50027804963-0.955158055027j)*o*x_ref[1]**(o-1)+((-0.663358861929-0.600678732058j))
        arg[2, 0, 0]=(-0.589513987362+0.0751944811072j)*x[0]**o+((-0.792536690371-0.141185940372j))*x[0]+((0.857831118185+0.800826341611j))*x[1]**o+((0.443945094143-0.602464051447j))*x[1]
        ref[2, 0, 0, 0]=(-0.589513987362+0.0751944811072j)*o*x_ref[0]**(o-1)+((-0.792536690371-0.141185940372j))
        ref[2, 0, 0, 1]=(0.857831118185+0.800826341611j)*o*x_ref[1]**(o-1)+((0.443945094143-0.602464051447j))
        arg[2, 0, 1]=(-0.390044378241-0.771719830134j)*x[0]**o+((-0.536283971101-0.131020727666j))*x[0]+((-0.60512345824-0.315553629161j))*x[1]**o+((-0.780917006307-0.254171729986j))*x[1]
        ref[2, 0, 1, 0]=(-0.390044378241-0.771719830134j)*o*x_ref[0]**(o-1)+((-0.536283971101-0.131020727666j))
        ref[2, 0, 1, 1]=(-0.60512345824-0.315553629161j)*o*x_ref[1]**(o-1)+((-0.780917006307-0.254171729986j))
        arg[2, 0, 2]=(-0.626252845125+0.0623825221444j)*x[0]**o+((0.659835946818-0.124347601207j))*x[0]+((0.104448048685+0.321006823668j))*x[1]**o+((-0.613858287276+0.178758927377j))*x[1]
        ref[2, 0, 2, 0]=(-0.626252845125+0.0623825221444j)*o*x_ref[0]**(o-1)+((0.659835946818-0.124347601207j))
        ref[2, 0, 2, 1]=(0.104448048685+0.321006823668j)*o*x_ref[1]**(o-1)+((-0.613858287276+0.178758927377j))
        arg[2, 0, 3]=(-0.866458010627-0.953801194794j)*x[0]**o+((0.408957987163+0.519638677638j))*x[0]+((0.447016390488-0.487671224021j))*x[1]**o+((0.79535632544-0.624052266802j))*x[1]
        ref[2, 0, 3, 0]=(-0.866458010627-0.953801194794j)*o*x_ref[0]**(o-1)+((0.408957987163+0.519638677638j))
        ref[2, 0, 3, 1]=(0.447016390488-0.487671224021j)*o*x_ref[1]**(o-1)+((0.79535632544-0.624052266802j))
        arg[2, 1, 0]=(-0.698207388865+0.513035711977j)*x[0]**o+((0.151939610125+0.101911204198j))*x[0]+((-0.37105252042-0.732666670849j))*x[1]**o+((-0.832811856596-0.0659678795031j))*x[1]
        ref[2, 1, 0, 0]=(-0.698207388865+0.513035711977j)*o*x_ref[0]**(o-1)+((0.151939610125+0.101911204198j))
        ref[2, 1, 0, 1]=(-0.37105252042-0.732666670849j)*o*x_ref[1]**(o-1)+((-0.832811856596-0.0659678795031j))
        arg[2, 1, 1]=(-0.592786714082+0.97649281527j)*x[0]**o+((0.424504001199+0.544662231003j))*x[0]+((-0.442252887214+0.480746508688j))*x[1]**o+((-0.0981156467383+0.33823767921j))*x[1]
        ref[2, 1, 1, 0]=(-0.592786714082+0.97649281527j)*o*x_ref[0]**(o-1)+((0.424504001199+0.544662231003j))
        ref[2, 1, 1, 1]=(-0.442252887214+0.480746508688j)*o*x_ref[1]**(o-1)+((-0.0981156467383+0.33823767921j))
        arg[2, 1, 2]=(0.0368705570807-0.541817720606j)*x[0]**o+((0.742189475459-0.832467235559j))*x[0]+((0.224887508884+0.636026387915j))*x[1]**o+((-0.718608421654+0.866171118136j))*x[1]
        ref[2, 1, 2, 0]=(0.0368705570807-0.541817720606j)*o*x_ref[0]**(o-1)+((0.742189475459-0.832467235559j))
        ref[2, 1, 2, 1]=(0.224887508884+0.636026387915j)*o*x_ref[1]**(o-1)+((-0.718608421654+0.866171118136j))
        arg[2, 1, 3]=(-0.766507320899+0.22821266777j)*x[0]**o+((-0.127987212586+0.447658679205j))*x[0]+((0.741381116556-0.00926292185458j))*x[1]**o+((0.625253683613+0.510794156599j))*x[1]
        ref[2, 1, 3, 0]=(-0.766507320899+0.22821266777j)*o*x_ref[0]**(o-1)+((-0.127987212586+0.447658679205j))
        ref[2, 1, 3, 1]=(0.741381116556-0.00926292185458j)*o*x_ref[1]**(o-1)+((0.625253683613+0.510794156599j))
        arg[2, 2, 0]=(0.580552839851+0.0468253970591j)*x[0]**o+((0.385439807219+0.470992257676j))*x[0]+((-0.402834272252-0.197950098874j))*x[1]**o+((-0.415220534919-0.73710440094j))*x[1]
        ref[2, 2, 0, 0]=(0.580552839851+0.0468253970591j)*o*x_ref[0]**(o-1)+((0.385439807219+0.470992257676j))
        ref[2, 2, 0, 1]=(-0.402834272252-0.197950098874j)*o*x_ref[1]**(o-1)+((-0.415220534919-0.73710440094j))
        arg[2, 2, 1]=(-0.0034839272923+0.763817833067j)*x[0]**o+((0.413441966766+0.353345647394j))*x[0]+((0.522711535457-0.481367337458j))*x[1]**o+((-0.830539187005-0.328629756633j))*x[1]
        ref[2, 2, 1, 0]=(-0.0034839272923+0.763817833067j)*o*x_ref[0]**(o-1)+((0.413441966766+0.353345647394j))
        ref[2, 2, 1, 1]=(0.522711535457-0.481367337458j)*o*x_ref[1]**(o-1)+((-0.830539187005-0.328629756633j))
        arg[2, 2, 2]=(-0.659932757029+0.842673653255j)*x[0]**o+((-0.870646061932-0.466861927465j))*x[0]+((0.1058567206+0.456844198945j))*x[1]**o+((-0.0312042102579-0.851820274768j))*x[1]
        ref[2, 2, 2, 0]=(-0.659932757029+0.842673653255j)*o*x_ref[0]**(o-1)+((-0.870646061932-0.466861927465j))
        ref[2, 2, 2, 1]=(0.1058567206+0.456844198945j)*o*x_ref[1]**(o-1)+((-0.0312042102579-0.851820274768j))
        arg[2, 2, 3]=(0.306730081076+0.211338743188j)*x[0]**o+((0.0390285580342+0.797252851298j))*x[0]+((0.989670226814+0.15003231193j))*x[1]**o+((0.976708610017+0.854062883809j))*x[1]
        ref[2, 2, 3, 0]=(0.306730081076+0.211338743188j)*o*x_ref[0]**(o-1)+((0.0390285580342+0.797252851298j))
        ref[2, 2, 3, 1]=(0.989670226814+0.15003231193j)*o*x_ref[1]**(o-1)+((0.976708610017+0.854062883809j))
        arg[2, 3, 0]=(-0.15597252413+0.538552801247j)*x[0]**o+((-0.491469921241-0.0572243137173j))*x[0]+((0.331009519808+0.840089066768j))*x[1]**o+((0.863820431148-0.25529634845j))*x[1]
        ref[2, 3, 0, 0]=(-0.15597252413+0.538552801247j)*o*x_ref[0]**(o-1)+((-0.491469921241-0.0572243137173j))
        ref[2, 3, 0, 1]=(0.331009519808+0.840089066768j)*o*x_ref[1]**(o-1)+((0.863820431148-0.25529634845j))
        arg[2, 3, 1]=(0.829766510233+0.000266525829664j)*x[0]**o+((-0.175023392204+0.890372709128j))*x[0]+((0.445508580461-0.234499680531j))*x[1]**o+((-0.594387449911+0.513961426085j))*x[1]
        ref[2, 3, 1, 0]=(0.829766510233+0.000266525829664j)*o*x_ref[0]**(o-1)+((-0.175023392204+0.890372709128j))
        ref[2, 3, 1, 1]=(0.445508580461-0.234499680531j)*o*x_ref[1]**(o-1)+((-0.594387449911+0.513961426085j))
        arg[2, 3, 2]=(-0.417636047459-0.39985411436j)*x[0]**o+((0.229435990074-0.287550014747j))*x[0]+((-0.485595638035+0.278908601758j))*x[1]**o+((-0.673015034409+0.689828416569j))*x[1]
        ref[2, 3, 2, 0]=(-0.417636047459-0.39985411436j)*o*x_ref[0]**(o-1)+((0.229435990074-0.287550014747j))
        ref[2, 3, 2, 1]=(-0.485595638035+0.278908601758j)*o*x_ref[1]**(o-1)+((-0.673015034409+0.689828416569j))
        arg[2, 3, 3]=(0.0296983323745-0.187155415986j)*x[0]**o+((-0.0876419585523+0.671792564336j))*x[0]+((0.0170126745491-0.666657384376j))*x[1]**o+((0.959993151133+0.231463342356j))*x[1]
        ref[2, 3, 3, 0]=(0.0296983323745-0.187155415986j)*o*x_ref[0]**(o-1)+((-0.0876419585523+0.671792564336j))
        ref[2, 3, 3, 1]=(0.0170126745491-0.666657384376j)*o*x_ref[1]**(o-1)+((0.959993151133+0.231463342356j))
        arg[3, 0, 0]=(0.359000695233-0.317336164141j)*x[0]**o+((0.107463859369+0.845316832634j))*x[0]+((-0.124870193258-0.13703905767j))*x[1]**o+((0.40680292396+0.0292128899011j))*x[1]
        ref[3, 0, 0, 0]=(0.359000695233-0.317336164141j)*o*x_ref[0]**(o-1)+((0.107463859369+0.845316832634j))
        ref[3, 0, 0, 1]=(-0.124870193258-0.13703905767j)*o*x_ref[1]**(o-1)+((0.40680292396+0.0292128899011j))
        arg[3, 0, 1]=(-0.182666487621-0.160383618991j)*x[0]**o+((-0.38376418386+0.279457191568j))*x[0]+((-0.160627149868+0.960645741252j))*x[1]**o+((-0.932503265681+0.432382374607j))*x[1]
        ref[3, 0, 1, 0]=(-0.182666487621-0.160383618991j)*o*x_ref[0]**(o-1)+((-0.38376418386+0.279457191568j))
        ref[3, 0, 1, 1]=(-0.160627149868+0.960645741252j)*o*x_ref[1]**(o-1)+((-0.932503265681+0.432382374607j))
        arg[3, 0, 2]=(-0.0206625075876-0.711575680582j)*x[0]**o+((0.524026012252-0.805687899192j))*x[0]+((-0.880171582845+0.205634280546j))*x[1]**o+((0.637170791454+0.856446396121j))*x[1]
        ref[3, 0, 2, 0]=(-0.0206625075876-0.711575680582j)*o*x_ref[0]**(o-1)+((0.524026012252-0.805687899192j))
        ref[3, 0, 2, 1]=(-0.880171582845+0.205634280546j)*o*x_ref[1]**(o-1)+((0.637170791454+0.856446396121j))
        arg[3, 0, 3]=(-0.566376484616-0.32579699656j)*x[0]**o+((0.56986644003+0.86977468637j))*x[0]+((-0.775279843108-0.038489692086j))*x[1]**o+((0.507865066249-0.322350532241j))*x[1]
        ref[3, 0, 3, 0]=(-0.566376484616-0.32579699656j)*o*x_ref[0]**(o-1)+((0.56986644003+0.86977468637j))
        ref[3, 0, 3, 1]=(-0.775279843108-0.038489692086j)*o*x_ref[1]**(o-1)+((0.507865066249-0.322350532241j))
        arg[3, 1, 0]=(-0.341230202649-0.622853561228j)*x[0]**o+((-0.413183517738+0.738380255596j))*x[0]+((-0.551963130048+0.392356124296j))*x[1]**o+((0.259286212193-0.358113054737j))*x[1]
        ref[3, 1, 0, 0]=(-0.341230202649-0.622853561228j)*o*x_ref[0]**(o-1)+((-0.413183517738+0.738380255596j))
        ref[3, 1, 0, 1]=(-0.551963130048+0.392356124296j)*o*x_ref[1]**(o-1)+((0.259286212193-0.358113054737j))
        arg[3, 1, 1]=(0.145278917277+0.127383612002j)*x[0]**o+((0.920998100344-0.443932965989j))*x[0]+((-0.575049608836+0.580925758767j))*x[1]**o+((0.759907813834-0.544362140377j))*x[1]
        ref[3, 1, 1, 0]=(0.145278917277+0.127383612002j)*o*x_ref[0]**(o-1)+((0.920998100344-0.443932965989j))
        ref[3, 1, 1, 1]=(-0.575049608836+0.580925758767j)*o*x_ref[1]**(o-1)+((0.759907813834-0.544362140377j))
        arg[3, 1, 2]=(-0.58432491842-0.815402642363j)*x[0]**o+((-0.225480073175+0.304528165787j))*x[0]+((0.789082155256-0.170129627945j))*x[1]**o+((-0.66197060625+0.115507630165j))*x[1]
        ref[3, 1, 2, 0]=(-0.58432491842-0.815402642363j)*o*x_ref[0]**(o-1)+((-0.225480073175+0.304528165787j))
        ref[3, 1, 2, 1]=(0.789082155256-0.170129627945j)*o*x_ref[1]**(o-1)+((-0.66197060625+0.115507630165j))
        arg[3, 1, 3]=(0.605210464048+0.861579072681j)*x[0]**o+((0.835048406129-0.137139628972j))*x[0]+((0.767547387077+0.183472123899j))*x[1]**o+((0.525132081781-0.792653161638j))*x[1]
        ref[3, 1, 3, 0]=(0.605210464048+0.861579072681j)*o*x_ref[0]**(o-1)+((0.835048406129-0.137139628972j))
        ref[3, 1, 3, 1]=(0.767547387077+0.183472123899j)*o*x_ref[1]**(o-1)+((0.525132081781-0.792653161638j))
        arg[3, 2, 0]=(0.85192148153-0.57411156887j)*x[0]**o+((-0.606876948513-0.684542502522j))*x[0]+((-0.487011538892-0.743700383137j))*x[1]**o+((0.0118600244003-0.0565225492786j))*x[1]
        ref[3, 2, 0, 0]=(0.85192148153-0.57411156887j)*o*x_ref[0]**(o-1)+((-0.606876948513-0.684542502522j))
        ref[3, 2, 0, 1]=(-0.487011538892-0.743700383137j)*o*x_ref[1]**(o-1)+((0.0118600244003-0.0565225492786j))
        arg[3, 2, 1]=(-0.905130268135-0.851318152117j)*x[0]**o+((-0.152724415554+0.0821897432395j))*x[0]+((0.726025311113+0.622662359095j))*x[1]**o+((-0.360407762961+0.887170473806j))*x[1]
        ref[3, 2, 1, 0]=(-0.905130268135-0.851318152117j)*o*x_ref[0]**(o-1)+((-0.152724415554+0.0821897432395j))
        ref[3, 2, 1, 1]=(0.726025311113+0.622662359095j)*o*x_ref[1]**(o-1)+((-0.360407762961+0.887170473806j))
        arg[3, 2, 2]=(0.385253344311+0.542068880241j)*x[0]**o+((0.210691548021+0.246125270996j))*x[0]+((-0.758818076892-0.98074471828j))*x[1]**o+((-0.365874868371+0.0975479730516j))*x[1]
        ref[3, 2, 2, 0]=(0.385253344311+0.542068880241j)*o*x_ref[0]**(o-1)+((0.210691548021+0.246125270996j))
        ref[3, 2, 2, 1]=(-0.758818076892-0.98074471828j)*o*x_ref[1]**(o-1)+((-0.365874868371+0.0975479730516j))
        arg[3, 2, 3]=(0.062901304424+0.713548508189j)*x[0]**o+((-0.118382305261+0.11715201007j))*x[0]+((-0.935385319964-0.653330735256j))*x[1]**o+((-0.725504244183-0.709800836344j))*x[1]
        ref[3, 2, 3, 0]=(0.062901304424+0.713548508189j)*o*x_ref[0]**(o-1)+((-0.118382305261+0.11715201007j))
        ref[3, 2, 3, 1]=(-0.935385319964-0.653330735256j)*o*x_ref[1]**(o-1)+((-0.725504244183-0.709800836344j))
        arg[3, 3, 0]=(-0.835569923295+0.907768435909j)*x[0]**o+((0.246448598297+0.0143983198875j))*x[0]+((0.578580248925-0.93631216199j))*x[1]**o+((-0.361011550881-0.846573136246j))*x[1]
        ref[3, 3, 0, 0]=(-0.835569923295+0.907768435909j)*o*x_ref[0]**(o-1)+((0.246448598297+0.0143983198875j))
        ref[3, 3, 0, 1]=(0.578580248925-0.93631216199j)*o*x_ref[1]**(o-1)+((-0.361011550881-0.846573136246j))
        arg[3, 3, 1]=(-0.281371667125-0.300923747853j)*x[0]**o+((0.0258435867219-0.385029755301j))*x[0]+((-0.896460452499+0.881639389707j))*x[1]**o+((0.31129002708-0.355758558367j))*x[1]
        ref[3, 3, 1, 0]=(-0.281371667125-0.300923747853j)*o*x_ref[0]**(o-1)+((0.0258435867219-0.385029755301j))
        ref[3, 3, 1, 1]=(-0.896460452499+0.881639389707j)*o*x_ref[1]**(o-1)+((0.31129002708-0.355758558367j))
        arg[3, 3, 2]=(-0.778717051676-0.347930707456j)*x[0]**o+((-0.145134449076+0.0793442618963j))*x[0]+((-0.196474261713-0.0440077340874j))*x[1]**o+((0.976912250284+0.821888536984j))*x[1]
        ref[3, 3, 2, 0]=(-0.778717051676-0.347930707456j)*o*x_ref[0]**(o-1)+((-0.145134449076+0.0793442618963j))
        ref[3, 3, 2, 1]=(-0.196474261713-0.0440077340874j)*o*x_ref[1]**(o-1)+((0.976912250284+0.821888536984j))
        arg[3, 3, 3]=(0.383109184895+0.713334560815j)*x[0]**o+((-0.506570136657+0.381950501657j))*x[0]+((0.930071951539-0.910351637284j))*x[1]**o+((-0.892194477138+0.455492190949j))*x[1]
        ref[3, 3, 3, 0]=(0.383109184895+0.713334560815j)*o*x_ref[0]**(o-1)+((-0.506570136657+0.381950501657j))
        ref[3, 3, 3, 1]=(0.930071951539-0.910351637284j)*o*x_ref[1]**(o-1)+((-0.892194477138+0.455492190949j))
        if dim==3:
            arg[0, 0, 0]+=(0.247536390313-0.471101182166j)*x[2]**o+((0.407489447074-0.192879394557j))*x[2]
            ref[0, 0, 0, 2]=(0.247536390313-0.471101182166j)*o*x_ref[2]**(o-1)+((0.407489447074-0.192879394557j))
            arg[0, 0, 1]+=(-0.493962960554+0.393637478491j)*x[2]**o+((-0.605491039326-0.537567664909j))*x[2]
            ref[0, 0, 1, 2]=(-0.493962960554+0.393637478491j)*o*x_ref[2]**(o-1)+((-0.605491039326-0.537567664909j))
            arg[0, 0, 2]+=(0.574246947597+0.869853031903j)*x[2]**o+((-0.726258055559-0.832511062595j))*x[2]
            ref[0, 0, 2, 2]=(0.574246947597+0.869853031903j)*o*x_ref[2]**(o-1)+((-0.726258055559-0.832511062595j))
            arg[0, 0, 3]+=(-0.872080792946-0.830560693983j)*x[2]**o+((0.657538814943-0.560025701488j))*x[2]
            ref[0, 0, 3, 2]=(-0.872080792946-0.830560693983j)*o*x_ref[2]**(o-1)+((0.657538814943-0.560025701488j))
            arg[0, 1, 0]+=(-0.732906678469-0.644265624383j)*x[2]**o+((-0.953778373741+0.692612507302j))*x[2]
            ref[0, 1, 0, 2]=(-0.732906678469-0.644265624383j)*o*x_ref[2]**(o-1)+((-0.953778373741+0.692612507302j))
            arg[0, 1, 1]+=(-0.823366118544+0.735346315809j)*x[2]**o+((-0.945421721921-0.589157227768j))*x[2]
            ref[0, 1, 1, 2]=(-0.823366118544+0.735346315809j)*o*x_ref[2]**(o-1)+((-0.945421721921-0.589157227768j))
            arg[0, 1, 2]+=(0.873937881535-0.80143995331j)*x[2]**o+((-0.585516606398+0.953193561419j))*x[2]
            ref[0, 1, 2, 2]=(0.873937881535-0.80143995331j)*o*x_ref[2]**(o-1)+((-0.585516606398+0.953193561419j))
            arg[0, 1, 3]+=(-0.916215551276-0.860714811675j)*x[2]**o+((0.525254617803-0.607344201264j))*x[2]
            ref[0, 1, 3, 2]=(-0.916215551276-0.860714811675j)*o*x_ref[2]**(o-1)+((0.525254617803-0.607344201264j))
            arg[0, 2, 0]+=(-0.426212504873+0.151441309828j)*x[2]**o+((-0.119916173053+0.994748070053j))*x[2]
            ref[0, 2, 0, 2]=(-0.426212504873+0.151441309828j)*o*x_ref[2]**(o-1)+((-0.119916173053+0.994748070053j))
            arg[0, 2, 1]+=(-0.378628230267-0.755455811546j)*x[2]**o+((-0.805381662645-0.830206184398j))*x[2]
            ref[0, 2, 1, 2]=(-0.378628230267-0.755455811546j)*o*x_ref[2]**(o-1)+((-0.805381662645-0.830206184398j))
            arg[0, 2, 2]+=(0.407140867128+0.766350631664j)*x[2]**o+((-0.405021122777-0.0303132926846j))*x[2]
            ref[0, 2, 2, 2]=(0.407140867128+0.766350631664j)*o*x_ref[2]**(o-1)+((-0.405021122777-0.0303132926846j))
            arg[0, 2, 3]+=(0.116876046283-0.22086999164j)*x[2]**o+((-0.971870769047+0.327417416912j))*x[2]
            ref[0, 2, 3, 2]=(0.116876046283-0.22086999164j)*o*x_ref[2]**(o-1)+((-0.971870769047+0.327417416912j))
            arg[0, 3, 0]+=(0.95910915872-0.666275773222j)*x[2]**o+((0.430814815283+0.72231770927j))*x[2]
            ref[0, 3, 0, 2]=(0.95910915872-0.666275773222j)*o*x_ref[2]**(o-1)+((0.430814815283+0.72231770927j))
            arg[0, 3, 1]+=(0.383330519422-0.152332456906j)*x[2]**o+((-0.497560974753-0.38187549882j))*x[2]
            ref[0, 3, 1, 2]=(0.383330519422-0.152332456906j)*o*x_ref[2]**(o-1)+((-0.497560974753-0.38187549882j))
            arg[0, 3, 2]+=(0.477512936713-0.294353758152j)*x[2]**o+((-0.437525679576+0.559033827242j))*x[2]
            ref[0, 3, 2, 2]=(0.477512936713-0.294353758152j)*o*x_ref[2]**(o-1)+((-0.437525679576+0.559033827242j))
            arg[0, 3, 3]+=(0.0492193463858+0.70812138943j)*x[2]**o+((0.372645245207-0.720997406906j))*x[2]
            ref[0, 3, 3, 2]=(0.0492193463858+0.70812138943j)*o*x_ref[2]**(o-1)+((0.372645245207-0.720997406906j))
            arg[1, 0, 0]+=(-0.51378066691+0.532842399898j)*x[2]**o+((-0.898865855392+0.83057413375j))*x[2]
            ref[1, 0, 0, 2]=(-0.51378066691+0.532842399898j)*o*x_ref[2]**(o-1)+((-0.898865855392+0.83057413375j))
            arg[1, 0, 1]+=(-0.594549758107+0.650561488916j)*x[2]**o+((0.0444539568476+0.177510261628j))*x[2]
            ref[1, 0, 1, 2]=(-0.594549758107+0.650561488916j)*o*x_ref[2]**(o-1)+((0.0444539568476+0.177510261628j))
            arg[1, 0, 2]+=(0.816206897878+0.344608582951j)*x[2]**o+((0.180773856597+0.288089755382j))*x[2]
            ref[1, 0, 2, 2]=(0.816206897878+0.344608582951j)*o*x_ref[2]**(o-1)+((0.180773856597+0.288089755382j))
            arg[1, 0, 3]+=(-0.5582654033-0.351786071392j)*x[2]**o+((-0.0256548429841+0.0904359119213j))*x[2]
            ref[1, 0, 3, 2]=(-0.5582654033-0.351786071392j)*o*x_ref[2]**(o-1)+((-0.0256548429841+0.0904359119213j))
            arg[1, 1, 0]+=(0.286700986447-0.956022687646j)*x[2]**o+((0.121449058017-0.288436729142j))*x[2]
            ref[1, 1, 0, 2]=(0.286700986447-0.956022687646j)*o*x_ref[2]**(o-1)+((0.121449058017-0.288436729142j))
            arg[1, 1, 1]+=(0.720134341969-0.505120751233j)*x[2]**o+((0.360498020959-0.784765090705j))*x[2]
            ref[1, 1, 1, 2]=(0.720134341969-0.505120751233j)*o*x_ref[2]**(o-1)+((0.360498020959-0.784765090705j))
            arg[1, 1, 2]+=(0.0169960013442-0.0340025572571j)*x[2]**o+((0.507659494466-0.216745652439j))*x[2]
            ref[1, 1, 2, 2]=(0.0169960013442-0.0340025572571j)*o*x_ref[2]**(o-1)+((0.507659494466-0.216745652439j))
            arg[1, 1, 3]+=(0.625592354503-0.959566188597j)*x[2]**o+((0.935302016321+0.795255326625j))*x[2]
            ref[1, 1, 3, 2]=(0.625592354503-0.959566188597j)*o*x_ref[2]**(o-1)+((0.935302016321+0.795255326625j))
            arg[1, 2, 0]+=(-0.919104396777-0.544160274063j)*x[2]**o+((0.0623496332865+0.55505779814j))*x[2]
            ref[1, 2, 0, 2]=(-0.919104396777-0.544160274063j)*o*x_ref[2]**(o-1)+((0.0623496332865+0.55505779814j))
            arg[1, 2, 1]+=(0.595973204175+0.735632140113j)*x[2]**o+((0.715223888624-0.190372262635j))*x[2]
            ref[1, 2, 1, 2]=(0.595973204175+0.735632140113j)*o*x_ref[2]**(o-1)+((0.715223888624-0.190372262635j))
            arg[1, 2, 2]+=(0.0433019786347+0.884559113827j)*x[2]**o+((-0.424092450068-0.761938004318j))*x[2]
            ref[1, 2, 2, 2]=(0.0433019786347+0.884559113827j)*o*x_ref[2]**(o-1)+((-0.424092450068-0.761938004318j))
            arg[1, 2, 3]+=(0.998096728527+0.994103931215j)*x[2]**o+((0.584688155023-0.589274334488j))*x[2]
            ref[1, 2, 3, 2]=(0.998096728527+0.994103931215j)*o*x_ref[2]**(o-1)+((0.584688155023-0.589274334488j))
            arg[1, 3, 0]+=(0.406725660388-0.722994919894j)*x[2]**o+((-0.260856299898-0.263178907397j))*x[2]
            ref[1, 3, 0, 2]=(0.406725660388-0.722994919894j)*o*x_ref[2]**(o-1)+((-0.260856299898-0.263178907397j))
            arg[1, 3, 1]+=(0.05411246465+0.156944822991j)*x[2]**o+((-0.613099873735-0.844706161087j))*x[2]
            ref[1, 3, 1, 2]=(0.05411246465+0.156944822991j)*o*x_ref[2]**(o-1)+((-0.613099873735-0.844706161087j))
            arg[1, 3, 2]+=(-0.12068933838+0.0635742795204j)*x[2]**o+((-0.954291823788-0.698763986043j))*x[2]
            ref[1, 3, 2, 2]=(-0.12068933838+0.0635742795204j)*o*x_ref[2]**(o-1)+((-0.954291823788-0.698763986043j))
            arg[1, 3, 3]+=(-0.383574181368-0.14677152042j)*x[2]**o+((0.45375777476-0.491192346976j))*x[2]
            ref[1, 3, 3, 2]=(-0.383574181368-0.14677152042j)*o*x_ref[2]**(o-1)+((0.45375777476-0.491192346976j))
            arg[2, 0, 0]+=(0.62929441392-0.304700086034j)*x[2]**o+((0.429195769088-0.229229194772j))*x[2]
            ref[2, 0, 0, 2]=(0.62929441392-0.304700086034j)*o*x_ref[2]**(o-1)+((0.429195769088-0.229229194772j))
            arg[2, 0, 1]+=(0.802619110886-0.270108385363j)*x[2]**o+((0.637048694147-0.826904170058j))*x[2]
            ref[2, 0, 1, 2]=(0.802619110886-0.270108385363j)*o*x_ref[2]**(o-1)+((0.637048694147-0.826904170058j))
            arg[2, 0, 2]+=(-0.15713726451-0.488043405048j)*x[2]**o+((-0.117631308976-0.66864274752j))*x[2]
            ref[2, 0, 2, 2]=(-0.15713726451-0.488043405048j)*o*x_ref[2]**(o-1)+((-0.117631308976-0.66864274752j))
            arg[2, 0, 3]+=(0.774325048864-0.0722606047027j)*x[2]**o+((0.302573780255-0.208255747763j))*x[2]
            ref[2, 0, 3, 2]=(0.774325048864-0.0722606047027j)*o*x_ref[2]**(o-1)+((0.302573780255-0.208255747763j))
            arg[2, 1, 0]+=(-0.157561482672-0.0794715623969j)*x[2]**o+((-0.47609524869-0.267335001172j))*x[2]
            ref[2, 1, 0, 2]=(-0.157561482672-0.0794715623969j)*o*x_ref[2]**(o-1)+((-0.47609524869-0.267335001172j))
            arg[2, 1, 1]+=(0.936429284394+0.393291725959j)*x[2]**o+((-0.692672637398+0.440916217609j))*x[2]
            ref[2, 1, 1, 2]=(0.936429284394+0.393291725959j)*o*x_ref[2]**(o-1)+((-0.692672637398+0.440916217609j))
            arg[2, 1, 2]+=(-0.183487922968+0.37889125623j)*x[2]**o+((0.502311680412+0.711219593228j))*x[2]
            ref[2, 1, 2, 2]=(-0.183487922968+0.37889125623j)*o*x_ref[2]**(o-1)+((0.502311680412+0.711219593228j))
            arg[2, 1, 3]+=(-0.584991349004-0.663671613957j)*x[2]**o+((0.14896626587-0.338994759792j))*x[2]
            ref[2, 1, 3, 2]=(-0.584991349004-0.663671613957j)*o*x_ref[2]**(o-1)+((0.14896626587-0.338994759792j))
            arg[2, 2, 0]+=(-0.116229621086-0.106553159367j)*x[2]**o+((0.853610578684+0.412084129905j))*x[2]
            ref[2, 2, 0, 2]=(-0.116229621086-0.106553159367j)*o*x_ref[2]**(o-1)+((0.853610578684+0.412084129905j))
            arg[2, 2, 1]+=(-0.982414295073+0.135094494252j)*x[2]**o+((0.492510771647+0.859305470483j))*x[2]
            ref[2, 2, 1, 2]=(-0.982414295073+0.135094494252j)*o*x_ref[2]**(o-1)+((0.492510771647+0.859305470483j))
            arg[2, 2, 2]+=(0.266891182135-0.577643575242j)*x[2]**o+((-0.303341967972-0.731404208801j))*x[2]
            ref[2, 2, 2, 2]=(0.266891182135-0.577643575242j)*o*x_ref[2]**(o-1)+((-0.303341967972-0.731404208801j))
            arg[2, 2, 3]+=(-0.164547699922-0.295713840784j)*x[2]**o+((-0.837475448535+0.636986085216j))*x[2]
            ref[2, 2, 3, 2]=(-0.164547699922-0.295713840784j)*o*x_ref[2]**(o-1)+((-0.837475448535+0.636986085216j))
            arg[2, 3, 0]+=(0.60272682729-0.34019279854j)*x[2]**o+((-0.487754169455+0.435191390782j))*x[2]
            ref[2, 3, 0, 2]=(0.60272682729-0.34019279854j)*o*x_ref[2]**(o-1)+((-0.487754169455+0.435191390782j))
            arg[2, 3, 1]+=(-0.731121444801-0.400467757244j)*x[2]**o+((0.477738605636-0.0128936892751j))*x[2]
            ref[2, 3, 1, 2]=(-0.731121444801-0.400467757244j)*o*x_ref[2]**(o-1)+((0.477738605636-0.0128936892751j))
            arg[2, 3, 2]+=(-0.569509226604-0.642241165255j)*x[2]**o+((-0.90137615674+0.857874212918j))*x[2]
            ref[2, 3, 2, 2]=(-0.569509226604-0.642241165255j)*o*x_ref[2]**(o-1)+((-0.90137615674+0.857874212918j))
            arg[2, 3, 3]+=(0.895905868548-0.584575623358j)*x[2]**o+((-0.659762149248+0.365407252957j))*x[2]
            ref[2, 3, 3, 2]=(0.895905868548-0.584575623358j)*o*x_ref[2]**(o-1)+((-0.659762149248+0.365407252957j))
            arg[3, 0, 0]+=(-0.430109617878+0.954829821575j)*x[2]**o+((0.979611610607+0.940290636492j))*x[2]
            ref[3, 0, 0, 2]=(-0.430109617878+0.954829821575j)*o*x_ref[2]**(o-1)+((0.979611610607+0.940290636492j))
            arg[3, 0, 1]+=(-0.127184355516+0.827804854529j)*x[2]**o+((-0.584769497286-0.734738830135j))*x[2]
            ref[3, 0, 1, 2]=(-0.127184355516+0.827804854529j)*o*x_ref[2]**(o-1)+((-0.584769497286-0.734738830135j))
            arg[3, 0, 2]+=(0.902081077428-0.57522174376j)*x[2]**o+((0.441826152399+0.57317898623j))*x[2]
            ref[3, 0, 2, 2]=(0.902081077428-0.57522174376j)*o*x_ref[2]**(o-1)+((0.441826152399+0.57317898623j))
            arg[3, 0, 3]+=(-0.265768088295-0.120725802124j)*x[2]**o+((0.043045125419-0.13170696763j))*x[2]
            ref[3, 0, 3, 2]=(-0.265768088295-0.120725802124j)*o*x_ref[2]**(o-1)+((0.043045125419-0.13170696763j))
            arg[3, 1, 0]+=(-0.732375858906-0.844741753134j)*x[2]**o+((0.186211163558+0.806378966308j))*x[2]
            ref[3, 1, 0, 2]=(-0.732375858906-0.844741753134j)*o*x_ref[2]**(o-1)+((0.186211163558+0.806378966308j))
            arg[3, 1, 1]+=(0.762149664255+0.46903474238j)*x[2]**o+((-0.903884362634+0.264811868965j))*x[2]
            ref[3, 1, 1, 2]=(0.762149664255+0.46903474238j)*o*x_ref[2]**(o-1)+((-0.903884362634+0.264811868965j))
            arg[3, 1, 2]+=(0.53859196676+0.922549393031j)*x[2]**o+((0.202741492186+0.511576360639j))*x[2]
            ref[3, 1, 2, 2]=(0.53859196676+0.922549393031j)*o*x_ref[2]**(o-1)+((0.202741492186+0.511576360639j))
            arg[3, 1, 3]+=(-0.441380536124-0.918562830191j)*x[2]**o+((0.439132745327+0.513985429257j))*x[2]
            ref[3, 1, 3, 2]=(-0.441380536124-0.918562830191j)*o*x_ref[2]**(o-1)+((0.439132745327+0.513985429257j))
            arg[3, 2, 0]+=(-0.0229122826294+0.968293761231j)*x[2]**o+((-0.289105501113+0.857589960344j))*x[2]
            ref[3, 2, 0, 2]=(-0.0229122826294+0.968293761231j)*o*x_ref[2]**(o-1)+((-0.289105501113+0.857589960344j))
            arg[3, 2, 1]+=(0.967562983336-0.942116524393j)*x[2]**o+((-0.48932265189+0.216931327914j))*x[2]
            ref[3, 2, 1, 2]=(0.967562983336-0.942116524393j)*o*x_ref[2]**(o-1)+((-0.48932265189+0.216931327914j))
            arg[3, 2, 2]+=(0.0364451201475-0.519754883299j)*x[2]**o+((-0.176096190391-0.314547207088j))*x[2]
            ref[3, 2, 2, 2]=(0.0364451201475-0.519754883299j)*o*x_ref[2]**(o-1)+((-0.176096190391-0.314547207088j))
            arg[3, 2, 3]+=(0.808317524565+0.140261484986j)*x[2]**o+((0.524484468733+0.617525711292j))*x[2]
            ref[3, 2, 3, 2]=(0.808317524565+0.140261484986j)*o*x_ref[2]**(o-1)+((0.524484468733+0.617525711292j))
            arg[3, 3, 0]+=(-0.72570203296-0.713789679584j)*x[2]**o+((-0.637119869663-0.200054224572j))*x[2]
            ref[3, 3, 0, 2]=(-0.72570203296-0.713789679584j)*o*x_ref[2]**(o-1)+((-0.637119869663-0.200054224572j))
            arg[3, 3, 1]+=(-0.870327513706+0.423892170854j)*x[2]**o+((0.181689627037+0.984903212835j))*x[2]
            ref[3, 3, 1, 2]=(-0.870327513706+0.423892170854j)*o*x_ref[2]**(o-1)+((0.181689627037+0.984903212835j))
            arg[3, 3, 2]+=(0.640407702374-0.0566120521824j)*x[2]**o+((-0.541368703513-0.714347399564j))*x[2]
            ref[3, 3, 2, 2]=(0.640407702374-0.0566120521824j)*o*x_ref[2]**(o-1)+((-0.541368703513-0.714347399564j))
            arg[3, 3, 3]+=(-0.75951562708+0.236227068191j)*x[2]**o+((-0.159891978339-0.506037118517j))*x[2]
            ref[3, 3, 3, 2]=(-0.75951562708+0.236227068191j)*o*x_ref[2]**(o-1)+((-0.159891978339-0.506037118517j))
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4, 4, 4)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnContactOne_fromData_ReducedSolution_rank0(self):
        """
        tests gradient of rank 0 Data on ReducedFunctionOnContactOne

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnContactOne
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnContactOne(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=(0.453253418313+0.331304151776j)*x[0]+((-0.69162922142+0.62486268007j))*x[1]
        ref[0]=(0.453253418313+0.331304151776j)
        ref[1]=(-0.69162922142+0.62486268007j)
        if dim==3:
            arg+=((-0.802006177857+0.833414184822j))*x[2]
            ref[2]=(-0.802006177857+0.833414184822j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnContactOne_fromData_ReducedSolution_rank1(self):
        """
        tests gradient of rank 1 Data on ReducedFunctionOnContactOne

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnContactOne
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnContactOne(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(2,),w)
        ref = Data(0,(2,)+(dim,),w_ref)
        arg[0,]=(0.952692962255-0.357827689117j)*x[0]+((-0.458010109733-0.458002518462j))*x[1]
        ref[0, 0]=(0.952692962255-0.357827689117j)
        ref[0, 1]=(-0.458010109733-0.458002518462j)
        arg[1,]=(0.403504366542-0.965927593128j)*x[0]+((-0.651102401316-0.234014101924j))*x[1]
        ref[1, 0]=(0.403504366542-0.965927593128j)
        ref[1, 1]=(-0.651102401316-0.234014101924j)
        if dim==3:
            arg[0,]+=(-0.468162307136+0.82195464742j)*x[2]
            ref[0, 2]=(-0.468162307136+0.82195464742j)
            arg[1,]+=(0.969144672194-0.975955609879j)*x[2]
            ref[1, 2]=(0.969144672194-0.975955609879j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnContactOne_fromData_ReducedSolution_rank2(self):
        """
        tests gradient of rank 2 Data on ReducedFunctionOnContactOne

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnContactOne
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnContactOne(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(2, 4),w)
        ref = Data(0,(2, 4)+(dim,),w_ref)
        arg[0, 0]=(-0.588131392704-0.327998528972j)*x[0]+((0.0899587227752+0.197531491357j))*x[1]
        ref[0, 0, 0]=(-0.588131392704-0.327998528972j)
        ref[0, 0, 1]=(0.0899587227752+0.197531491357j)
        arg[0, 1]=(-0.965106638453-0.00363545860889j)*x[0]+((0.994661561119+0.137923010873j))*x[1]
        ref[0, 1, 0]=(-0.965106638453-0.00363545860889j)
        ref[0, 1, 1]=(0.994661561119+0.137923010873j)
        arg[0, 2]=(0.758429904564+0.418141612701j)*x[0]+((-0.178260960849-0.384860385323j))*x[1]
        ref[0, 2, 0]=(0.758429904564+0.418141612701j)
        ref[0, 2, 1]=(-0.178260960849-0.384860385323j)
        arg[0, 3]=(-0.797063047851+0.161377831198j)*x[0]+((0.395592588514+0.16991132043j))*x[1]
        ref[0, 3, 0]=(-0.797063047851+0.161377831198j)
        ref[0, 3, 1]=(0.395592588514+0.16991132043j)
        arg[1, 0]=(-0.689628525174-0.468458073717j)*x[0]+((0.209841444458-0.637717723773j))*x[1]
        ref[1, 0, 0]=(-0.689628525174-0.468458073717j)
        ref[1, 0, 1]=(0.209841444458-0.637717723773j)
        arg[1, 1]=(0.884987718408-0.00407464817374j)*x[0]+((0.291358384492+0.973236343314j))*x[1]
        ref[1, 1, 0]=(0.884987718408-0.00407464817374j)
        ref[1, 1, 1]=(0.291358384492+0.973236343314j)
        arg[1, 2]=(-0.607158956955-0.586965937695j)*x[0]+((-0.199288193673-0.883429325057j))*x[1]
        ref[1, 2, 0]=(-0.607158956955-0.586965937695j)
        ref[1, 2, 1]=(-0.199288193673-0.883429325057j)
        arg[1, 3]=(0.805191511561-0.117940680412j)*x[0]+((-0.0514995981286-0.275305918521j))*x[1]
        ref[1, 3, 0]=(0.805191511561-0.117940680412j)
        ref[1, 3, 1]=(-0.0514995981286-0.275305918521j)
        if dim==3:
            arg[0, 0]+=(-0.167883367261-0.496083875143j)*x[2]
            ref[0, 0, 2]=(-0.167883367261-0.496083875143j)
            arg[0, 1]+=(-0.447161096331+0.514998108816j)*x[2]
            ref[0, 1, 2]=(-0.447161096331+0.514998108816j)
            arg[0, 2]+=(0.808133186247+0.196172936465j)*x[2]
            ref[0, 2, 2]=(0.808133186247+0.196172936465j)
            arg[0, 3]+=(-0.194508484723-0.656395889639j)*x[2]
            ref[0, 3, 2]=(-0.194508484723-0.656395889639j)
            arg[1, 0]+=(0.574034532846+0.352161223046j)*x[2]
            ref[1, 0, 2]=(0.574034532846+0.352161223046j)
            arg[1, 1]+=(-0.846400227712-0.67759665831j)*x[2]
            ref[1, 1, 2]=(-0.846400227712-0.67759665831j)
            arg[1, 2]+=(0.0615068678594+0.732161866584j)*x[2]
            ref[1, 2, 2]=(0.0615068678594+0.732161866584j)
            arg[1, 3]+=(0.469331276439-0.324235091576j)*x[2]
            ref[1, 3, 2]=(0.469331276439-0.324235091576j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2, 4)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnContactOne_fromData_ReducedSolution_rank3(self):
        """
        tests gradient of rank 3 Data on ReducedFunctionOnContactOne

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnContactOne
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnContactOne(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(4, 3, 3),w)
        ref = Data(0,(4, 3, 3)+(dim,),w_ref)
        arg[0, 0, 0]=(-0.795168924211-0.384448943908j)*x[0]+((-0.401318176153-0.432371528181j))*x[1]
        ref[0, 0, 0, 0]=(-0.795168924211-0.384448943908j)
        ref[0, 0, 0, 1]=(-0.401318176153-0.432371528181j)
        arg[0, 0, 1]=(0.650720033446-0.412724448319j)*x[0]+((0.563446324338-0.783824857535j))*x[1]
        ref[0, 0, 1, 0]=(0.650720033446-0.412724448319j)
        ref[0, 0, 1, 1]=(0.563446324338-0.783824857535j)
        arg[0, 0, 2]=(0.16329344984+0.914867597563j)*x[0]+((0.855362256244+0.443985114275j))*x[1]
        ref[0, 0, 2, 0]=(0.16329344984+0.914867597563j)
        ref[0, 0, 2, 1]=(0.855362256244+0.443985114275j)
        arg[0, 1, 0]=(0.151202797595+0.896646596936j)*x[0]+((0.894181113467-0.600183307898j))*x[1]
        ref[0, 1, 0, 0]=(0.151202797595+0.896646596936j)
        ref[0, 1, 0, 1]=(0.894181113467-0.600183307898j)
        arg[0, 1, 1]=(-0.973207432163-0.315538995279j)*x[0]+((0.777712202897+0.513750433542j))*x[1]
        ref[0, 1, 1, 0]=(-0.973207432163-0.315538995279j)
        ref[0, 1, 1, 1]=(0.777712202897+0.513750433542j)
        arg[0, 1, 2]=(-0.856186088085-0.18100858857j)*x[0]+((-0.581843042671+0.372428441811j))*x[1]
        ref[0, 1, 2, 0]=(-0.856186088085-0.18100858857j)
        ref[0, 1, 2, 1]=(-0.581843042671+0.372428441811j)
        arg[0, 2, 0]=(0.780985435493+0.748261075498j)*x[0]+((0.785111068424+0.026066408576j))*x[1]
        ref[0, 2, 0, 0]=(0.780985435493+0.748261075498j)
        ref[0, 2, 0, 1]=(0.785111068424+0.026066408576j)
        arg[0, 2, 1]=(0.399534686602+0.0256401418344j)*x[0]+((-0.652915180379+0.322370573826j))*x[1]
        ref[0, 2, 1, 0]=(0.399534686602+0.0256401418344j)
        ref[0, 2, 1, 1]=(-0.652915180379+0.322370573826j)
        arg[0, 2, 2]=(-0.695049670727-0.0126142167871j)*x[0]+((-0.835761842261-0.593650196085j))*x[1]
        ref[0, 2, 2, 0]=(-0.695049670727-0.0126142167871j)
        ref[0, 2, 2, 1]=(-0.835761842261-0.593650196085j)
        arg[1, 0, 0]=(-0.0721096492033+0.613094510448j)*x[0]+((-0.568197938526+0.89858363354j))*x[1]
        ref[1, 0, 0, 0]=(-0.0721096492033+0.613094510448j)
        ref[1, 0, 0, 1]=(-0.568197938526+0.89858363354j)
        arg[1, 0, 1]=(-0.873143607179-0.401692215095j)*x[0]+((-0.53801419+0.903972642767j))*x[1]
        ref[1, 0, 1, 0]=(-0.873143607179-0.401692215095j)
        ref[1, 0, 1, 1]=(-0.53801419+0.903972642767j)
        arg[1, 0, 2]=(-0.370754361558-0.449558945868j)*x[0]+((-0.260863511908-0.112504768964j))*x[1]
        ref[1, 0, 2, 0]=(-0.370754361558-0.449558945868j)
        ref[1, 0, 2, 1]=(-0.260863511908-0.112504768964j)
        arg[1, 1, 0]=(-0.964289133368+0.0265647717651j)*x[0]+((-0.999308562528-0.807576325786j))*x[1]
        ref[1, 1, 0, 0]=(-0.964289133368+0.0265647717651j)
        ref[1, 1, 0, 1]=(-0.999308562528-0.807576325786j)
        arg[1, 1, 1]=(0.857391977422-0.0861833375792j)*x[0]+((-0.301032320383-0.735414777865j))*x[1]
        ref[1, 1, 1, 0]=(0.857391977422-0.0861833375792j)
        ref[1, 1, 1, 1]=(-0.301032320383-0.735414777865j)
        arg[1, 1, 2]=(-0.267253403702-0.0497270560257j)*x[0]+((-0.817541554408+0.798627804659j))*x[1]
        ref[1, 1, 2, 0]=(-0.267253403702-0.0497270560257j)
        ref[1, 1, 2, 1]=(-0.817541554408+0.798627804659j)
        arg[1, 2, 0]=(-0.231717620514-0.920941160873j)*x[0]+((-0.0984952955387-0.409566158519j))*x[1]
        ref[1, 2, 0, 0]=(-0.231717620514-0.920941160873j)
        ref[1, 2, 0, 1]=(-0.0984952955387-0.409566158519j)
        arg[1, 2, 1]=(0.035272128981+0.443273090179j)*x[0]+((0.934479321623-0.0073799479509j))*x[1]
        ref[1, 2, 1, 0]=(0.035272128981+0.443273090179j)
        ref[1, 2, 1, 1]=(0.934479321623-0.0073799479509j)
        arg[1, 2, 2]=(0.322742318349-0.516630935358j)*x[0]+((0.248545967011+0.890881036571j))*x[1]
        ref[1, 2, 2, 0]=(0.322742318349-0.516630935358j)
        ref[1, 2, 2, 1]=(0.248545967011+0.890881036571j)
        arg[2, 0, 0]=(0.314647813389+0.689738563251j)*x[0]+((0.408450682037+0.911880392417j))*x[1]
        ref[2, 0, 0, 0]=(0.314647813389+0.689738563251j)
        ref[2, 0, 0, 1]=(0.408450682037+0.911880392417j)
        arg[2, 0, 1]=(-0.824624156879-0.456120908398j)*x[0]+((-0.716429158827+0.0271075674677j))*x[1]
        ref[2, 0, 1, 0]=(-0.824624156879-0.456120908398j)
        ref[2, 0, 1, 1]=(-0.716429158827+0.0271075674677j)
        arg[2, 0, 2]=(-0.999517522103+0.0611061736877j)*x[0]+((-0.335550289511-0.00348248113652j))*x[1]
        ref[2, 0, 2, 0]=(-0.999517522103+0.0611061736877j)
        ref[2, 0, 2, 1]=(-0.335550289511-0.00348248113652j)
        arg[2, 1, 0]=(0.853567774894+0.241851221025j)*x[0]+((-0.572610228608-0.896559738096j))*x[1]
        ref[2, 1, 0, 0]=(0.853567774894+0.241851221025j)
        ref[2, 1, 0, 1]=(-0.572610228608-0.896559738096j)
        arg[2, 1, 1]=(0.582761158084+0.821669855931j)*x[0]+((-0.342647797652+0.871608708356j))*x[1]
        ref[2, 1, 1, 0]=(0.582761158084+0.821669855931j)
        ref[2, 1, 1, 1]=(-0.342647797652+0.871608708356j)
        arg[2, 1, 2]=(0.683359546581+0.527470900574j)*x[0]+((0.2994947947-0.20806796774j))*x[1]
        ref[2, 1, 2, 0]=(0.683359546581+0.527470900574j)
        ref[2, 1, 2, 1]=(0.2994947947-0.20806796774j)
        arg[2, 2, 0]=(0.288173284833-0.683588294619j)*x[0]+((0.677737850815-0.402538608336j))*x[1]
        ref[2, 2, 0, 0]=(0.288173284833-0.683588294619j)
        ref[2, 2, 0, 1]=(0.677737850815-0.402538608336j)
        arg[2, 2, 1]=(0.643792009424+0.990108195115j)*x[0]+((0.332219349288+0.833557856356j))*x[1]
        ref[2, 2, 1, 0]=(0.643792009424+0.990108195115j)
        ref[2, 2, 1, 1]=(0.332219349288+0.833557856356j)
        arg[2, 2, 2]=(0.884389087946+0.815644787765j)*x[0]+((0.493848153004+0.613490446809j))*x[1]
        ref[2, 2, 2, 0]=(0.884389087946+0.815644787765j)
        ref[2, 2, 2, 1]=(0.493848153004+0.613490446809j)
        arg[3, 0, 0]=(0.157232186856-0.909419767114j)*x[0]+((-0.533510850938+0.0388717760515j))*x[1]
        ref[3, 0, 0, 0]=(0.157232186856-0.909419767114j)
        ref[3, 0, 0, 1]=(-0.533510850938+0.0388717760515j)
        arg[3, 0, 1]=(0.408715291545-0.171479713678j)*x[0]+((0.990835910677+0.719423478031j))*x[1]
        ref[3, 0, 1, 0]=(0.408715291545-0.171479713678j)
        ref[3, 0, 1, 1]=(0.990835910677+0.719423478031j)
        arg[3, 0, 2]=(0.619805360283-0.566796138297j)*x[0]+((-0.309685870967-0.859974894717j))*x[1]
        ref[3, 0, 2, 0]=(0.619805360283-0.566796138297j)
        ref[3, 0, 2, 1]=(-0.309685870967-0.859974894717j)
        arg[3, 1, 0]=(0.61357223275-0.952327686422j)*x[0]+((0.891713226846+0.132719644772j))*x[1]
        ref[3, 1, 0, 0]=(0.61357223275-0.952327686422j)
        ref[3, 1, 0, 1]=(0.891713226846+0.132719644772j)
        arg[3, 1, 1]=(-0.775519187077-0.910982745767j)*x[0]+((0.0873144849149-0.992494747347j))*x[1]
        ref[3, 1, 1, 0]=(-0.775519187077-0.910982745767j)
        ref[3, 1, 1, 1]=(0.0873144849149-0.992494747347j)
        arg[3, 1, 2]=(-0.0910450109383+0.507293905937j)*x[0]+((-0.35808449186+0.662429762454j))*x[1]
        ref[3, 1, 2, 0]=(-0.0910450109383+0.507293905937j)
        ref[3, 1, 2, 1]=(-0.35808449186+0.662429762454j)
        arg[3, 2, 0]=(-0.961415687424-0.231281784584j)*x[0]+((-0.811758435649-0.525209712154j))*x[1]
        ref[3, 2, 0, 0]=(-0.961415687424-0.231281784584j)
        ref[3, 2, 0, 1]=(-0.811758435649-0.525209712154j)
        arg[3, 2, 1]=(0.1220021683+0.852222220604j)*x[0]+((-0.690107341821-0.131110589645j))*x[1]
        ref[3, 2, 1, 0]=(0.1220021683+0.852222220604j)
        ref[3, 2, 1, 1]=(-0.690107341821-0.131110589645j)
        arg[3, 2, 2]=(-0.293811153338-0.406880003073j)*x[0]+((0.0150473321543-0.5001647647j))*x[1]
        ref[3, 2, 2, 0]=(-0.293811153338-0.406880003073j)
        ref[3, 2, 2, 1]=(0.0150473321543-0.5001647647j)
        if dim==3:
            arg[0, 0, 0]+=(0.223976662745-0.034997159451j)*x[2]
            ref[0, 0, 0, 2]=(0.223976662745-0.034997159451j)
            arg[0, 0, 1]+=(-0.183179018225-0.49659995064j)*x[2]
            ref[0, 0, 1, 2]=(-0.183179018225-0.49659995064j)
            arg[0, 0, 2]+=(-0.00536697837257-0.605019355012j)*x[2]
            ref[0, 0, 2, 2]=(-0.00536697837257-0.605019355012j)
            arg[0, 1, 0]+=(-0.29394616202-0.61778441132j)*x[2]
            ref[0, 1, 0, 2]=(-0.29394616202-0.61778441132j)
            arg[0, 1, 1]+=(-0.00854744914657-0.329977148385j)*x[2]
            ref[0, 1, 1, 2]=(-0.00854744914657-0.329977148385j)
            arg[0, 1, 2]+=(0.408005391019+0.654245103679j)*x[2]
            ref[0, 1, 2, 2]=(0.408005391019+0.654245103679j)
            arg[0, 2, 0]+=(0.701930523934-0.788752076646j)*x[2]
            ref[0, 2, 0, 2]=(0.701930523934-0.788752076646j)
            arg[0, 2, 1]+=(0.755159149152-0.741815510961j)*x[2]
            ref[0, 2, 1, 2]=(0.755159149152-0.741815510961j)
            arg[0, 2, 2]+=(0.75231929905+0.511725603814j)*x[2]
            ref[0, 2, 2, 2]=(0.75231929905+0.511725603814j)
            arg[1, 0, 0]+=(-0.592277520104+0.584986268684j)*x[2]
            ref[1, 0, 0, 2]=(-0.592277520104+0.584986268684j)
            arg[1, 0, 1]+=(0.360820378086+0.386759752707j)*x[2]
            ref[1, 0, 1, 2]=(0.360820378086+0.386759752707j)
            arg[1, 0, 2]+=(-0.522819822016-0.0877297640044j)*x[2]
            ref[1, 0, 2, 2]=(-0.522819822016-0.0877297640044j)
            arg[1, 1, 0]+=(0.246957302815-0.286057312514j)*x[2]
            ref[1, 1, 0, 2]=(0.246957302815-0.286057312514j)
            arg[1, 1, 1]+=(0.346172335188+0.699279409106j)*x[2]
            ref[1, 1, 1, 2]=(0.346172335188+0.699279409106j)
            arg[1, 1, 2]+=(0.314438499318+0.257271901613j)*x[2]
            ref[1, 1, 2, 2]=(0.314438499318+0.257271901613j)
            arg[1, 2, 0]+=(-0.56491050044-0.367160500259j)*x[2]
            ref[1, 2, 0, 2]=(-0.56491050044-0.367160500259j)
            arg[1, 2, 1]+=(0.77990889978+0.328566480434j)*x[2]
            ref[1, 2, 1, 2]=(0.77990889978+0.328566480434j)
            arg[1, 2, 2]+=(0.00725863471129+0.737235709476j)*x[2]
            ref[1, 2, 2, 2]=(0.00725863471129+0.737235709476j)
            arg[2, 0, 0]+=(0.367067029509+0.490530312075j)*x[2]
            ref[2, 0, 0, 2]=(0.367067029509+0.490530312075j)
            arg[2, 0, 1]+=(-0.235925400505+0.391426685681j)*x[2]
            ref[2, 0, 1, 2]=(-0.235925400505+0.391426685681j)
            arg[2, 0, 2]+=(-0.714431651698-0.108888387923j)*x[2]
            ref[2, 0, 2, 2]=(-0.714431651698-0.108888387923j)
            arg[2, 1, 0]+=(0.783668171495-0.860138666152j)*x[2]
            ref[2, 1, 0, 2]=(0.783668171495-0.860138666152j)
            arg[2, 1, 1]+=(-0.540629546044-0.914348856761j)*x[2]
            ref[2, 1, 1, 2]=(-0.540629546044-0.914348856761j)
            arg[2, 1, 2]+=(-0.713711875384+0.831964670804j)*x[2]
            ref[2, 1, 2, 2]=(-0.713711875384+0.831964670804j)
            arg[2, 2, 0]+=(-0.864244955703-0.394643871472j)*x[2]
            ref[2, 2, 0, 2]=(-0.864244955703-0.394643871472j)
            arg[2, 2, 1]+=(0.630355907131+0.79078988226j)*x[2]
            ref[2, 2, 1, 2]=(0.630355907131+0.79078988226j)
            arg[2, 2, 2]+=(-0.178287089118-0.847201469542j)*x[2]
            ref[2, 2, 2, 2]=(-0.178287089118-0.847201469542j)
            arg[3, 0, 0]+=(0.137980502106+0.583123150573j)*x[2]
            ref[3, 0, 0, 2]=(0.137980502106+0.583123150573j)
            arg[3, 0, 1]+=(-0.719813295164-0.987207922182j)*x[2]
            ref[3, 0, 1, 2]=(-0.719813295164-0.987207922182j)
            arg[3, 0, 2]+=(0.24029967022-0.196194075932j)*x[2]
            ref[3, 0, 2, 2]=(0.24029967022-0.196194075932j)
            arg[3, 1, 0]+=(0.562862255502+0.536331084159j)*x[2]
            ref[3, 1, 0, 2]=(0.562862255502+0.536331084159j)
            arg[3, 1, 1]+=(0.458516010173-0.045768650724j)*x[2]
            ref[3, 1, 1, 2]=(0.458516010173-0.045768650724j)
            arg[3, 1, 2]+=(0.358771442745+0.532940877868j)*x[2]
            ref[3, 1, 2, 2]=(0.358771442745+0.532940877868j)
            arg[3, 2, 0]+=(0.132246883121+0.443631270027j)*x[2]
            ref[3, 2, 0, 2]=(0.132246883121+0.443631270027j)
            arg[3, 2, 1]+=(0.445661887828+0.648020723611j)*x[2]
            ref[3, 2, 1, 2]=(0.445661887828+0.648020723611j)
            arg[3, 2, 2]+=(-0.933186417071-0.999955004209j)*x[2]
            ref[3, 2, 2, 2]=(-0.933186417071-0.999955004209j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4, 3, 3)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnContactOne_fromData_ReducedContinuousFunction_rank0(self):
        """
        tests gradient of rank 0 Data on ReducedFunctionOnContactOne

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnContactOne
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnContactOne(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=(-0.0107864031318+0.931555773482j)*x[0]+((0.141825846162-0.817205635248j))*x[1]
        ref[0]=(-0.0107864031318+0.931555773482j)
        ref[1]=(0.141825846162-0.817205635248j)
        if dim==3:
            arg+=((0.224551233084-0.778811778471j))*x[2]
            ref[2]=(0.224551233084-0.778811778471j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnContactOne_fromData_ReducedContinuousFunction_rank1(self):
        """
        tests gradient of rank 1 Data on ReducedFunctionOnContactOne

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnContactOne
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnContactOne(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(4,),w)
        ref = Data(0,(4,)+(dim,),w_ref)
        arg[0,]=(-0.350302982263+0.274877957202j)*x[0]+((0.61974597633-0.534630605911j))*x[1]
        ref[0, 0]=(-0.350302982263+0.274877957202j)
        ref[0, 1]=(0.61974597633-0.534630605911j)
        arg[1,]=(-0.913780438687-0.0142515775489j)*x[0]+((0.505433625229-0.898451786291j))*x[1]
        ref[1, 0]=(-0.913780438687-0.0142515775489j)
        ref[1, 1]=(0.505433625229-0.898451786291j)
        arg[2,]=(-0.687252535091-0.601225917424j)*x[0]+((0.23540523556-0.562841498025j))*x[1]
        ref[2, 0]=(-0.687252535091-0.601225917424j)
        ref[2, 1]=(0.23540523556-0.562841498025j)
        arg[3,]=(-0.233643274243+0.946478800237j)*x[0]+((0.571907329859+0.17946569267j))*x[1]
        ref[3, 0]=(-0.233643274243+0.946478800237j)
        ref[3, 1]=(0.571907329859+0.17946569267j)
        if dim==3:
            arg[0,]+=(-0.736980222367-0.607186852666j)*x[2]
            ref[0, 2]=(-0.736980222367-0.607186852666j)
            arg[1,]+=(-0.163160012307+0.0513553190601j)*x[2]
            ref[1, 2]=(-0.163160012307+0.0513553190601j)
            arg[2,]+=(0.825614629685+0.476708472293j)*x[2]
            ref[2, 2]=(0.825614629685+0.476708472293j)
            arg[3,]+=(-0.721854307434-0.114602239933j)*x[2]
            ref[3, 2]=(-0.721854307434-0.114602239933j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnContactOne_fromData_ReducedContinuousFunction_rank2(self):
        """
        tests gradient of rank 2 Data on ReducedFunctionOnContactOne

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnContactOne
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnContactOne(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(3, 3),w)
        ref = Data(0,(3, 3)+(dim,),w_ref)
        arg[0, 0]=(0.15737664091-0.724256530133j)*x[0]+((-0.690000197978+0.671275051795j))*x[1]
        ref[0, 0, 0]=(0.15737664091-0.724256530133j)
        ref[0, 0, 1]=(-0.690000197978+0.671275051795j)
        arg[0, 1]=(0.168080043372+0.993565153192j)*x[0]+((0.964943767375+0.466932107715j))*x[1]
        ref[0, 1, 0]=(0.168080043372+0.993565153192j)
        ref[0, 1, 1]=(0.964943767375+0.466932107715j)
        arg[0, 2]=(-0.416831344092-0.247518858479j)*x[0]+((-0.740817805861+0.682079928696j))*x[1]
        ref[0, 2, 0]=(-0.416831344092-0.247518858479j)
        ref[0, 2, 1]=(-0.740817805861+0.682079928696j)
        arg[1, 0]=(0.432853392977+0.986126728342j)*x[0]+((0.864482269768-0.782199873165j))*x[1]
        ref[1, 0, 0]=(0.432853392977+0.986126728342j)
        ref[1, 0, 1]=(0.864482269768-0.782199873165j)
        arg[1, 1]=(-0.697993674026-0.945299829006j)*x[0]+((0.644534716179+0.191659047176j))*x[1]
        ref[1, 1, 0]=(-0.697993674026-0.945299829006j)
        ref[1, 1, 1]=(0.644534716179+0.191659047176j)
        arg[1, 2]=(-0.314744913315-0.243081770768j)*x[0]+((-0.546597761586+0.250718305139j))*x[1]
        ref[1, 2, 0]=(-0.314744913315-0.243081770768j)
        ref[1, 2, 1]=(-0.546597761586+0.250718305139j)
        arg[2, 0]=(-0.572871947503+0.0231673804812j)*x[0]+((0.0154783370486-0.999295724646j))*x[1]
        ref[2, 0, 0]=(-0.572871947503+0.0231673804812j)
        ref[2, 0, 1]=(0.0154783370486-0.999295724646j)
        arg[2, 1]=(0.467476459881+0.777265597374j)*x[0]+((-0.80789145438+0.124245832797j))*x[1]
        ref[2, 1, 0]=(0.467476459881+0.777265597374j)
        ref[2, 1, 1]=(-0.80789145438+0.124245832797j)
        arg[2, 2]=(-0.174430786428+0.242028716717j)*x[0]+((0.955990400914-0.979510813213j))*x[1]
        ref[2, 2, 0]=(-0.174430786428+0.242028716717j)
        ref[2, 2, 1]=(0.955990400914-0.979510813213j)
        if dim==3:
            arg[0, 0]+=(0.915427356267-0.977403394903j)*x[2]
            ref[0, 0, 2]=(0.915427356267-0.977403394903j)
            arg[0, 1]+=(0.696658749798+0.428893550058j)*x[2]
            ref[0, 1, 2]=(0.696658749798+0.428893550058j)
            arg[0, 2]+=(0.201225351875+0.934238666633j)*x[2]
            ref[0, 2, 2]=(0.201225351875+0.934238666633j)
            arg[1, 0]+=(0.467478100697-0.00327930067269j)*x[2]
            ref[1, 0, 2]=(0.467478100697-0.00327930067269j)
            arg[1, 1]+=(-0.304769757825-0.879216613789j)*x[2]
            ref[1, 1, 2]=(-0.304769757825-0.879216613789j)
            arg[1, 2]+=(-0.451782824422-0.929162834256j)*x[2]
            ref[1, 2, 2]=(-0.451782824422-0.929162834256j)
            arg[2, 0]+=(0.14443444204+0.378854466798j)*x[2]
            ref[2, 0, 2]=(0.14443444204+0.378854466798j)
            arg[2, 1]+=(-0.65195564449-0.290611251933j)*x[2]
            ref[2, 1, 2]=(-0.65195564449-0.290611251933j)
            arg[2, 2]+=(-0.44132694257+0.543496599681j)*x[2]
            ref[2, 2, 2]=(-0.44132694257+0.543496599681j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3, 3)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_gradC_onReducedFunctionOnContactOne_fromData_ReducedContinuousFunction_rank3(self):
        """
        tests gradient of rank 3 Data on ReducedFunctionOnContactOne

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnContactOne
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnContactOne(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(2, 3, 2),w)
        ref = Data(0,(2, 3, 2)+(dim,),w_ref)
        arg[0, 0, 0]=(0.337695874284+0.16592267312j)*x[0]+((-0.599511285491-0.45983809803j))*x[1]
        ref[0, 0, 0, 0]=(0.337695874284+0.16592267312j)
        ref[0, 0, 0, 1]=(-0.599511285491-0.45983809803j)
        arg[0, 0, 1]=(0.71056360491+0.21427579913j)*x[0]+((0.277627671593+0.745828906668j))*x[1]
        ref[0, 0, 1, 0]=(0.71056360491+0.21427579913j)
        ref[0, 0, 1, 1]=(0.277627671593+0.745828906668j)
        arg[0, 1, 0]=(0.72539953261+0.820317512764j)*x[0]+((0.873421998719+0.261591478198j))*x[1]
        ref[0, 1, 0, 0]=(0.72539953261+0.820317512764j)
        ref[0, 1, 0, 1]=(0.873421998719+0.261591478198j)
        arg[0, 1, 1]=(-0.0150585601996-0.291877425046j)*x[0]+((-0.769227286725+0.714059406571j))*x[1]
        ref[0, 1, 1, 0]=(-0.0150585601996-0.291877425046j)
        ref[0, 1, 1, 1]=(-0.769227286725+0.714059406571j)
        arg[0, 2, 0]=(-0.238386985906+0.272324846282j)*x[0]+((-0.316544340425-0.26354903668j))*x[1]
        ref[0, 2, 0, 0]=(-0.238386985906+0.272324846282j)
        ref[0, 2, 0, 1]=(-0.316544340425-0.26354903668j)
        arg[0, 2, 1]=(0.428565487744+0.349510278032j)*x[0]+((-0.211604303491-0.280642432548j))*x[1]
        ref[0, 2, 1, 0]=(0.428565487744+0.349510278032j)
        ref[0, 2, 1, 1]=(-0.211604303491-0.280642432548j)
        arg[1, 0, 0]=(0.368511951936+0.74168824693j)*x[0]+((0.935331165398+0.57331038597j))*x[1]
        ref[1, 0, 0, 0]=(0.368511951936+0.74168824693j)
        ref[1, 0, 0, 1]=(0.935331165398+0.57331038597j)
        arg[1, 0, 1]=(-0.81482734385-0.958635729657j)*x[0]+((0.0509902509956-0.946602753076j))*x[1]
        ref[1, 0, 1, 0]=(-0.81482734385-0.958635729657j)
        ref[1, 0, 1, 1]=(0.0509902509956-0.946602753076j)
        arg[1, 1, 0]=(0.949082384971+0.0787300595228j)*x[0]+((-0.620048743802-0.450171467398j))*x[1]
        ref[1, 1, 0, 0]=(0.949082384971+0.0787300595228j)
        ref[1, 1, 0, 1]=(-0.620048743802-0.450171467398j)
        arg[1, 1, 1]=(-0.161887076524+0.917134432281j)*x[0]+((-0.54569580765+0.673102656524j))*x[1]
        ref[1, 1, 1, 0]=(-0.161887076524+0.917134432281j)
        ref[1, 1, 1, 1]=(-0.54569580765+0.673102656524j)
        arg[1, 2, 0]=(0.045862497225+0.579045211895j)*x[0]+((-0.815532320742-0.156307331335j))*x[1]
        ref[1, 2, 0, 0]=(0.045862497225+0.579045211895j)
        ref[1, 2, 0, 1]=(-0.815532320742-0.156307331335j)
        arg[1, 2, 1]=(-0.652335409264+0.466683417854j)*x[0]+((0.0151314173764-0.424417374401j))*x[1]
        ref[1, 2, 1, 0]=(-0.652335409264+0.466683417854j)
        ref[1, 2, 1, 1]=(0.0151314173764-0.424417374401j)
        if dim==3:
            arg[0, 0, 0]+=(0.700227490259-0.618398600213j)*x[2]
            ref[0, 0, 0, 2]=(0.700227490259-0.618398600213j)
            arg[0, 0, 1]+=(0.56367495616-0.814971531399j)*x[2]
            ref[0, 0, 1, 2]=(0.56367495616-0.814971531399j)
            arg[0, 1, 0]+=(-0.800829753388+0.65126907681j)*x[2]
            ref[0, 1, 0, 2]=(-0.800829753388+0.65126907681j)
            arg[0, 1, 1]+=(-0.669706384523-0.594751069339j)*x[2]
            ref[0, 1, 1, 2]=(-0.669706384523-0.594751069339j)
            arg[0, 2, 0]+=(0.614692494435-0.56118582725j)*x[2]
            ref[0, 2, 0, 2]=(0.614692494435-0.56118582725j)
            arg[0, 2, 1]+=(0.385753724578+0.0371634587648j)*x[2]
            ref[0, 2, 1, 2]=(0.385753724578+0.0371634587648j)
            arg[1, 0, 0]+=(0.889103744478+0.672609383416j)*x[2]
            ref[1, 0, 0, 2]=(0.889103744478+0.672609383416j)
            arg[1, 0, 1]+=(-0.306783518539+0.473445204286j)*x[2]
            ref[1, 0, 1, 2]=(-0.306783518539+0.473445204286j)
            arg[1, 1, 0]+=(-0.777811020005+0.252169530562j)*x[2]
            ref[1, 1, 0, 2]=(-0.777811020005+0.252169530562j)
            arg[1, 1, 1]+=(-0.498404270551+0.194459987866j)*x[2]
            ref[1, 1, 1, 2]=(-0.498404270551+0.194459987866j)
            arg[1, 2, 0]+=(-0.997058720934+0.758581907873j)*x[2]
            ref[1, 2, 0, 2]=(-0.997058720934+0.758581907873j)
            arg[1, 2, 1]+=(-0.683246241617-0.70876211378j)*x[2]
            ref[1, 2, 1, 2]=(-0.683246241617-0.70876211378j)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2, 3, 2)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onFunctionOnBoundary_fromData_ContinuousFunction_rank0(self):
        """
        tests gradient of rank 0 Data on FunctionOnBoundary

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=-0.642983494129*x[0]**o+(0.588159997828)*x[0]+(0.275203024481)*x[1]**o+(0.0717888936012)*x[1]
        ref[0]=-0.642983494129*o*x_ref[0]**(o-1)+(0.588159997828)
        ref[1]=0.275203024481*o*x_ref[1]**(o-1)+(0.0717888936012)
        if dim==3:
            arg+=(0.858097814991)*x[2]**o+(-0.550332987458)*x[2]
            ref[2]=0.858097814991*o*x_ref[2]**(o-1)+(-0.550332987458)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onFunctionOnBoundary_fromData_ContinuousFunction_rank1(self):
        """
        tests gradient of rank 1 Data on FunctionOnBoundary

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(4,),w)
        ref = Data(0,(4,)+(dim,),w_ref)
        arg[0,]=0.448884133383*x[0]**o+(0.957869771265)*x[0]+(0.189283461872)*x[1]**o+(-0.805302362971)*x[1]
        ref[0, 0]=0.448884133383*o*x_ref[0]**(o-1)+(0.957869771265)
        ref[0, 1]=0.189283461872*o*x_ref[1]**(o-1)+(-0.805302362971)
        arg[1,]=0.0282825124276*x[0]**o+(0.0368692844946)*x[0]+(0.326661058707)*x[1]**o+(-0.172860705226)*x[1]
        ref[1, 0]=0.0282825124276*o*x_ref[0]**(o-1)+(0.0368692844946)
        ref[1, 1]=0.326661058707*o*x_ref[1]**(o-1)+(-0.172860705226)
        arg[2,]=0.298691375048*x[0]**o+(0.269935398339)*x[0]+(-0.813035280309)*x[1]**o+(0.789779508851)*x[1]
        ref[2, 0]=0.298691375048*o*x_ref[0]**(o-1)+(0.269935398339)
        ref[2, 1]=-0.813035280309*o*x_ref[1]**(o-1)+(0.789779508851)
        arg[3,]=0.0109600857014*x[0]**o+(0.394279244195)*x[0]+(-0.746687373101)*x[1]**o+(-0.605565113946)*x[1]
        ref[3, 0]=0.0109600857014*o*x_ref[0]**(o-1)+(0.394279244195)
        ref[3, 1]=-0.746687373101*o*x_ref[1]**(o-1)+(-0.605565113946)
        if dim==3:
            arg[0,]+=-0.512966723617*x[2]**o+(-0.175892650288)*x[2]
            ref[0, 2]=-0.512966723617*o*x_ref[2]**(o-1)+(-0.175892650288)
            arg[1,]+=0.598140030605*x[2]**o+(-0.922067331148)*x[2]
            ref[1, 2]=0.598140030605*o*x_ref[2]**(o-1)+(-0.922067331148)
            arg[2,]+=0.955164679502*x[2]**o+(0.170554134918)*x[2]
            ref[2, 2]=0.955164679502*o*x_ref[2]**(o-1)+(0.170554134918)
            arg[3,]+=0.53169018607*x[2]**o+(0.477549966688)*x[2]
            ref[3, 2]=0.53169018607*o*x_ref[2]**(o-1)+(0.477549966688)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onFunctionOnBoundary_fromData_ContinuousFunction_rank2(self):
        """
        tests gradient of rank 2 Data on FunctionOnBoundary

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(4, 4),w)
        ref = Data(0,(4, 4)+(dim,),w_ref)
        arg[0, 0]=-0.411855280029*x[0]**o+(0.397032166995)*x[0]+(0.593691759921)*x[1]**o+(0.515455271833)*x[1]
        ref[0, 0, 0]=-0.411855280029*o*x_ref[0]**(o-1)+(0.397032166995)
        ref[0, 0, 1]=0.593691759921*o*x_ref[1]**(o-1)+(0.515455271833)
        arg[0, 1]=-0.881874066901*x[0]**o+(0.412406579973)*x[0]+(0.29085363694)*x[1]**o+(-0.523566102314)*x[1]
        ref[0, 1, 0]=-0.881874066901*o*x_ref[0]**(o-1)+(0.412406579973)
        ref[0, 1, 1]=0.29085363694*o*x_ref[1]**(o-1)+(-0.523566102314)
        arg[0, 2]=-0.502990417924*x[0]**o+(0.30928682494)*x[0]+(0.561874734026)*x[1]**o+(0.58115535525)*x[1]
        ref[0, 2, 0]=-0.502990417924*o*x_ref[0]**(o-1)+(0.30928682494)
        ref[0, 2, 1]=0.561874734026*o*x_ref[1]**(o-1)+(0.58115535525)
        arg[0, 3]=-0.470818417102*x[0]**o+(0.818306867141)*x[0]+(0.826726104603)*x[1]**o+(-0.556096244599)*x[1]
        ref[0, 3, 0]=-0.470818417102*o*x_ref[0]**(o-1)+(0.818306867141)
        ref[0, 3, 1]=0.826726104603*o*x_ref[1]**(o-1)+(-0.556096244599)
        arg[1, 0]=0.184542540303*x[0]**o+(0.940293660429)*x[0]+(-0.71786288627)*x[1]**o+(-0.00609166134939)*x[1]
        ref[1, 0, 0]=0.184542540303*o*x_ref[0]**(o-1)+(0.940293660429)
        ref[1, 0, 1]=-0.71786288627*o*x_ref[1]**(o-1)+(-0.00609166134939)
        arg[1, 1]=0.590521314339*x[0]**o+(-0.98595365692)*x[0]+(0.903053999267)*x[1]**o+(0.659085787115)*x[1]
        ref[1, 1, 0]=0.590521314339*o*x_ref[0]**(o-1)+(-0.98595365692)
        ref[1, 1, 1]=0.903053999267*o*x_ref[1]**(o-1)+(0.659085787115)
        arg[1, 2]=0.603256472248*x[0]**o+(-0.998567994431)*x[0]+(0.741928703316)*x[1]**o+(0.381828408173)*x[1]
        ref[1, 2, 0]=0.603256472248*o*x_ref[0]**(o-1)+(-0.998567994431)
        ref[1, 2, 1]=0.741928703316*o*x_ref[1]**(o-1)+(0.381828408173)
        arg[1, 3]=0.527272811035*x[0]**o+(-0.910686540304)*x[0]+(-0.519865950291)*x[1]**o+(0.223137327326)*x[1]
        ref[1, 3, 0]=0.527272811035*o*x_ref[0]**(o-1)+(-0.910686540304)
        ref[1, 3, 1]=-0.519865950291*o*x_ref[1]**(o-1)+(0.223137327326)
        arg[2, 0]=-0.666958015112*x[0]**o+(0.212945454735)*x[0]+(-0.458826227087)*x[1]**o+(-0.0879275042395)*x[1]
        ref[2, 0, 0]=-0.666958015112*o*x_ref[0]**(o-1)+(0.212945454735)
        ref[2, 0, 1]=-0.458826227087*o*x_ref[1]**(o-1)+(-0.0879275042395)
        arg[2, 1]=0.547201123146*x[0]**o+(-0.959240884913)*x[0]+(-0.788102648342)*x[1]**o+(0.992008386471)*x[1]
        ref[2, 1, 0]=0.547201123146*o*x_ref[0]**(o-1)+(-0.959240884913)
        ref[2, 1, 1]=-0.788102648342*o*x_ref[1]**(o-1)+(0.992008386471)
        arg[2, 2]=-0.91705984776*x[0]**o+(-0.382885786385)*x[0]+(0.674049245599)*x[1]**o+(0.802849748595)*x[1]
        ref[2, 2, 0]=-0.91705984776*o*x_ref[0]**(o-1)+(-0.382885786385)
        ref[2, 2, 1]=0.674049245599*o*x_ref[1]**(o-1)+(0.802849748595)
        arg[2, 3]=0.40579530195*x[0]**o+(0.310148176347)*x[0]+(-0.452554138032)*x[1]**o+(0.469087665157)*x[1]
        ref[2, 3, 0]=0.40579530195*o*x_ref[0]**(o-1)+(0.310148176347)
        ref[2, 3, 1]=-0.452554138032*o*x_ref[1]**(o-1)+(0.469087665157)
        arg[3, 0]=-0.211301930347*x[0]**o+(0.613911443846)*x[0]+(-0.862953365484)*x[1]**o+(-0.363996740553)*x[1]
        ref[3, 0, 0]=-0.211301930347*o*x_ref[0]**(o-1)+(0.613911443846)
        ref[3, 0, 1]=-0.862953365484*o*x_ref[1]**(o-1)+(-0.363996740553)
        arg[3, 1]=-0.0533442679625*x[0]**o+(0.192408762209)*x[0]+(-0.370985654526)*x[1]**o+(0.237023044015)*x[1]
        ref[3, 1, 0]=-0.0533442679625*o*x_ref[0]**(o-1)+(0.192408762209)
        ref[3, 1, 1]=-0.370985654526*o*x_ref[1]**(o-1)+(0.237023044015)
        arg[3, 2]=-0.90970854711*x[0]**o+(0.937900004511)*x[0]+(0.175995950397)*x[1]**o+(0.0912107377011)*x[1]
        ref[3, 2, 0]=-0.90970854711*o*x_ref[0]**(o-1)+(0.937900004511)
        ref[3, 2, 1]=0.175995950397*o*x_ref[1]**(o-1)+(0.0912107377011)
        arg[3, 3]=-0.742378452583*x[0]**o+(0.399565933738)*x[0]+(-0.367841928119)*x[1]**o+(-0.329636193683)*x[1]
        ref[3, 3, 0]=-0.742378452583*o*x_ref[0]**(o-1)+(0.399565933738)
        ref[3, 3, 1]=-0.367841928119*o*x_ref[1]**(o-1)+(-0.329636193683)
        if dim==3:
            arg[0, 0]+=-0.166238779117*x[2]**o+(0.180535101541)*x[2]
            ref[0, 0, 2]=-0.166238779117*o*x_ref[2]**(o-1)+(0.180535101541)
            arg[0, 1]+=0.307947356549*x[2]**o+(-0.284416502016)*x[2]
            ref[0, 1, 2]=0.307947356549*o*x_ref[2]**(o-1)+(-0.284416502016)
            arg[0, 2]+=0.417698090357*x[2]**o+(0.928308790173)*x[2]
            ref[0, 2, 2]=0.417698090357*o*x_ref[2]**(o-1)+(0.928308790173)
            arg[0, 3]+=0.359433532496*x[2]**o+(-0.85069394479)*x[2]
            ref[0, 3, 2]=0.359433532496*o*x_ref[2]**(o-1)+(-0.85069394479)
            arg[1, 0]+=0.693709634809*x[2]**o+(0.350287345217)*x[2]
            ref[1, 0, 2]=0.693709634809*o*x_ref[2]**(o-1)+(0.350287345217)
            arg[1, 1]+=-0.186225995568*x[2]**o+(-0.0692858742043)*x[2]
            ref[1, 1, 2]=-0.186225995568*o*x_ref[2]**(o-1)+(-0.0692858742043)
            arg[1, 2]+=-0.940638216127*x[2]**o+(-0.289377373278)*x[2]
            ref[1, 2, 2]=-0.940638216127*o*x_ref[2]**(o-1)+(-0.289377373278)
            arg[1, 3]+=-0.564761249497*x[2]**o+(-0.796305888305)*x[2]
            ref[1, 3, 2]=-0.564761249497*o*x_ref[2]**(o-1)+(-0.796305888305)
            arg[2, 0]+=0.52496285649*x[2]**o+(0.860539767098)*x[2]
            ref[2, 0, 2]=0.52496285649*o*x_ref[2]**(o-1)+(0.860539767098)
            arg[2, 1]+=0.770294843521*x[2]**o+(0.0453603034663)*x[2]
            ref[2, 1, 2]=0.770294843521*o*x_ref[2]**(o-1)+(0.0453603034663)
            arg[2, 2]+=-0.113781337992*x[2]**o+(-0.784527990425)*x[2]
            ref[2, 2, 2]=-0.113781337992*o*x_ref[2]**(o-1)+(-0.784527990425)
            arg[2, 3]+=-0.560985176304*x[2]**o+(0.528824902912)*x[2]
            ref[2, 3, 2]=-0.560985176304*o*x_ref[2]**(o-1)+(0.528824902912)
            arg[3, 0]+=-0.362860384503*x[2]**o+(-0.0796148945099)*x[2]
            ref[3, 0, 2]=-0.362860384503*o*x_ref[2]**(o-1)+(-0.0796148945099)
            arg[3, 1]+=0.191034093687*x[2]**o+(0.988110360064)*x[2]
            ref[3, 1, 2]=0.191034093687*o*x_ref[2]**(o-1)+(0.988110360064)
            arg[3, 2]+=-0.731891383232*x[2]**o+(-0.0706627750449)*x[2]
            ref[3, 2, 2]=-0.731891383232*o*x_ref[2]**(o-1)+(-0.0706627750449)
            arg[3, 3]+=-0.668574244344*x[2]**o+(0.439962138531)*x[2]
            ref[3, 3, 2]=-0.668574244344*o*x_ref[2]**(o-1)+(0.439962138531)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4, 4)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onFunctionOnBoundary_fromData_ContinuousFunction_rank3(self):
        """
        tests gradient of rank 3 Data on FunctionOnBoundary

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(3, 2, 4),w)
        ref = Data(0,(3, 2, 4)+(dim,),w_ref)
        arg[0, 0, 0]=-0.680288621249*x[0]**o+(0.926265460913)*x[0]+(-0.712591751279)*x[1]**o+(-0.443398514566)*x[1]
        ref[0, 0, 0, 0]=-0.680288621249*o*x_ref[0]**(o-1)+(0.926265460913)
        ref[0, 0, 0, 1]=-0.712591751279*o*x_ref[1]**(o-1)+(-0.443398514566)
        arg[0, 0, 1]=0.644848523166*x[0]**o+(-0.253716397765)*x[0]+(-0.139341746476)*x[1]**o+(0.0822006122417)*x[1]
        ref[0, 0, 1, 0]=0.644848523166*o*x_ref[0]**(o-1)+(-0.253716397765)
        ref[0, 0, 1, 1]=-0.139341746476*o*x_ref[1]**(o-1)+(0.0822006122417)
        arg[0, 0, 2]=0.285615894682*x[0]**o+(-0.821543027501)*x[0]+(0.89268278879)*x[1]**o+(-0.808446759436)*x[1]
        ref[0, 0, 2, 0]=0.285615894682*o*x_ref[0]**(o-1)+(-0.821543027501)
        ref[0, 0, 2, 1]=0.89268278879*o*x_ref[1]**(o-1)+(-0.808446759436)
        arg[0, 0, 3]=-0.528520217863*x[0]**o+(0.596324099108)*x[0]+(-0.224063088736)*x[1]**o+(-0.786339647883)*x[1]
        ref[0, 0, 3, 0]=-0.528520217863*o*x_ref[0]**(o-1)+(0.596324099108)
        ref[0, 0, 3, 1]=-0.224063088736*o*x_ref[1]**(o-1)+(-0.786339647883)
        arg[0, 1, 0]=0.270117670344*x[0]**o+(0.0590991251015)*x[0]+(0.142824577526)*x[1]**o+(-0.00102600734649)*x[1]
        ref[0, 1, 0, 0]=0.270117670344*o*x_ref[0]**(o-1)+(0.0590991251015)
        ref[0, 1, 0, 1]=0.142824577526*o*x_ref[1]**(o-1)+(-0.00102600734649)
        arg[0, 1, 1]=-0.352739510458*x[0]**o+(-0.561722565836)*x[0]+(-0.277554885524)*x[1]**o+(-0.205381155318)*x[1]
        ref[0, 1, 1, 0]=-0.352739510458*o*x_ref[0]**(o-1)+(-0.561722565836)
        ref[0, 1, 1, 1]=-0.277554885524*o*x_ref[1]**(o-1)+(-0.205381155318)
        arg[0, 1, 2]=-0.919550288607*x[0]**o+(-0.300608543714)*x[0]+(0.363043890329)*x[1]**o+(-0.591628881887)*x[1]
        ref[0, 1, 2, 0]=-0.919550288607*o*x_ref[0]**(o-1)+(-0.300608543714)
        ref[0, 1, 2, 1]=0.363043890329*o*x_ref[1]**(o-1)+(-0.591628881887)
        arg[0, 1, 3]=-0.83047824844*x[0]**o+(-0.419438021731)*x[0]+(-0.629587566273)*x[1]**o+(0.199241967272)*x[1]
        ref[0, 1, 3, 0]=-0.83047824844*o*x_ref[0]**(o-1)+(-0.419438021731)
        ref[0, 1, 3, 1]=-0.629587566273*o*x_ref[1]**(o-1)+(0.199241967272)
        arg[1, 0, 0]=0.00564265589531*x[0]**o+(-0.636269339213)*x[0]+(0.152139168534)*x[1]**o+(-0.269742506725)*x[1]
        ref[1, 0, 0, 0]=0.00564265589531*o*x_ref[0]**(o-1)+(-0.636269339213)
        ref[1, 0, 0, 1]=0.152139168534*o*x_ref[1]**(o-1)+(-0.269742506725)
        arg[1, 0, 1]=0.917356931456*x[0]**o+(0.80543553787)*x[0]+(0.677110787736)*x[1]**o+(0.0750421581212)*x[1]
        ref[1, 0, 1, 0]=0.917356931456*o*x_ref[0]**(o-1)+(0.80543553787)
        ref[1, 0, 1, 1]=0.677110787736*o*x_ref[1]**(o-1)+(0.0750421581212)
        arg[1, 0, 2]=-0.517325388228*x[0]**o+(-0.603241783024)*x[0]+(0.277173383393)*x[1]**o+(-0.815101491989)*x[1]
        ref[1, 0, 2, 0]=-0.517325388228*o*x_ref[0]**(o-1)+(-0.603241783024)
        ref[1, 0, 2, 1]=0.277173383393*o*x_ref[1]**(o-1)+(-0.815101491989)
        arg[1, 0, 3]=0.389771683259*x[0]**o+(0.0639427502149)*x[0]+(0.463901131905)*x[1]**o+(0.59507243739)*x[1]
        ref[1, 0, 3, 0]=0.389771683259*o*x_ref[0]**(o-1)+(0.0639427502149)
        ref[1, 0, 3, 1]=0.463901131905*o*x_ref[1]**(o-1)+(0.59507243739)
        arg[1, 1, 0]=-0.1605270667*x[0]**o+(-0.334783298325)*x[0]+(-0.125639693411)*x[1]**o+(-0.140304107222)*x[1]
        ref[1, 1, 0, 0]=-0.1605270667*o*x_ref[0]**(o-1)+(-0.334783298325)
        ref[1, 1, 0, 1]=-0.125639693411*o*x_ref[1]**(o-1)+(-0.140304107222)
        arg[1, 1, 1]=0.70936903578*x[0]**o+(0.0725533313516)*x[0]+(-0.732487555755)*x[1]**o+(-0.259737054738)*x[1]
        ref[1, 1, 1, 0]=0.70936903578*o*x_ref[0]**(o-1)+(0.0725533313516)
        ref[1, 1, 1, 1]=-0.732487555755*o*x_ref[1]**(o-1)+(-0.259737054738)
        arg[1, 1, 2]=0.243249694862*x[0]**o+(-0.1393680256)*x[0]+(-0.0611828102749)*x[1]**o+(-0.273389065968)*x[1]
        ref[1, 1, 2, 0]=0.243249694862*o*x_ref[0]**(o-1)+(-0.1393680256)
        ref[1, 1, 2, 1]=-0.0611828102749*o*x_ref[1]**(o-1)+(-0.273389065968)
        arg[1, 1, 3]=-0.393822099711*x[0]**o+(-0.708822106402)*x[0]+(-0.724068062792)*x[1]**o+(-0.645026377852)*x[1]
        ref[1, 1, 3, 0]=-0.393822099711*o*x_ref[0]**(o-1)+(-0.708822106402)
        ref[1, 1, 3, 1]=-0.724068062792*o*x_ref[1]**(o-1)+(-0.645026377852)
        arg[2, 0, 0]=-0.799639342512*x[0]**o+(-0.424730759944)*x[0]+(0.286433445209)*x[1]**o+(-0.125071556327)*x[1]
        ref[2, 0, 0, 0]=-0.799639342512*o*x_ref[0]**(o-1)+(-0.424730759944)
        ref[2, 0, 0, 1]=0.286433445209*o*x_ref[1]**(o-1)+(-0.125071556327)
        arg[2, 0, 1]=-0.195936310835*x[0]**o+(-0.839191527941)*x[0]+(0.342015044794)*x[1]**o+(0.250175712115)*x[1]
        ref[2, 0, 1, 0]=-0.195936310835*o*x_ref[0]**(o-1)+(-0.839191527941)
        ref[2, 0, 1, 1]=0.342015044794*o*x_ref[1]**(o-1)+(0.250175712115)
        arg[2, 0, 2]=0.480233070837*x[0]**o+(0.2900497341)*x[0]+(-0.993119234528)*x[1]**o+(-0.82208008397)*x[1]
        ref[2, 0, 2, 0]=0.480233070837*o*x_ref[0]**(o-1)+(0.2900497341)
        ref[2, 0, 2, 1]=-0.993119234528*o*x_ref[1]**(o-1)+(-0.82208008397)
        arg[2, 0, 3]=-0.124926542048*x[0]**o+(0.560598275757)*x[0]+(0.716730686655)*x[1]**o+(-0.658448150984)*x[1]
        ref[2, 0, 3, 0]=-0.124926542048*o*x_ref[0]**(o-1)+(0.560598275757)
        ref[2, 0, 3, 1]=0.716730686655*o*x_ref[1]**(o-1)+(-0.658448150984)
        arg[2, 1, 0]=0.41980999891*x[0]**o+(0.152703858656)*x[0]+(0.00740859397072)*x[1]**o+(-0.664998896861)*x[1]
        ref[2, 1, 0, 0]=0.41980999891*o*x_ref[0]**(o-1)+(0.152703858656)
        ref[2, 1, 0, 1]=0.00740859397072*o*x_ref[1]**(o-1)+(-0.664998896861)
        arg[2, 1, 1]=0.726889869317*x[0]**o+(0.471385769669)*x[0]+(-0.977606332949)*x[1]**o+(0.467155485419)*x[1]
        ref[2, 1, 1, 0]=0.726889869317*o*x_ref[0]**(o-1)+(0.471385769669)
        ref[2, 1, 1, 1]=-0.977606332949*o*x_ref[1]**(o-1)+(0.467155485419)
        arg[2, 1, 2]=-0.139095381901*x[0]**o+(0.0258966990481)*x[0]+(0.929233313602)*x[1]**o+(0.416629847129)*x[1]
        ref[2, 1, 2, 0]=-0.139095381901*o*x_ref[0]**(o-1)+(0.0258966990481)
        ref[2, 1, 2, 1]=0.929233313602*o*x_ref[1]**(o-1)+(0.416629847129)
        arg[2, 1, 3]=-0.163077853233*x[0]**o+(0.396820354954)*x[0]+(0.531674902282)*x[1]**o+(-0.519381107418)*x[1]
        ref[2, 1, 3, 0]=-0.163077853233*o*x_ref[0]**(o-1)+(0.396820354954)
        ref[2, 1, 3, 1]=0.531674902282*o*x_ref[1]**(o-1)+(-0.519381107418)
        if dim==3:
            arg[0, 0, 0]+=-0.481218116732*x[2]**o+(-0.23780290923)*x[2]
            ref[0, 0, 0, 2]=-0.481218116732*o*x_ref[2]**(o-1)+(-0.23780290923)
            arg[0, 0, 1]+=-0.491735775647*x[2]**o+(0.951904848689)*x[2]
            ref[0, 0, 1, 2]=-0.491735775647*o*x_ref[2]**(o-1)+(0.951904848689)
            arg[0, 0, 2]+=0.557155959514*x[2]**o+(-0.520455489257)*x[2]
            ref[0, 0, 2, 2]=0.557155959514*o*x_ref[2]**(o-1)+(-0.520455489257)
            arg[0, 0, 3]+=0.321995748211*x[2]**o+(-0.309568727514)*x[2]
            ref[0, 0, 3, 2]=0.321995748211*o*x_ref[2]**(o-1)+(-0.309568727514)
            arg[0, 1, 0]+=0.880783341046*x[2]**o+(0.0665193262803)*x[2]
            ref[0, 1, 0, 2]=0.880783341046*o*x_ref[2]**(o-1)+(0.0665193262803)
            arg[0, 1, 1]+=-0.662139589449*x[2]**o+(-0.53171313226)*x[2]
            ref[0, 1, 1, 2]=-0.662139589449*o*x_ref[2]**(o-1)+(-0.53171313226)
            arg[0, 1, 2]+=-0.543900121866*x[2]**o+(-0.78066450282)*x[2]
            ref[0, 1, 2, 2]=-0.543900121866*o*x_ref[2]**(o-1)+(-0.78066450282)
            arg[0, 1, 3]+=-0.438789312721*x[2]**o+(0.182214020522)*x[2]
            ref[0, 1, 3, 2]=-0.438789312721*o*x_ref[2]**(o-1)+(0.182214020522)
            arg[1, 0, 0]+=-0.917913045703*x[2]**o+(0.404355477009)*x[2]
            ref[1, 0, 0, 2]=-0.917913045703*o*x_ref[2]**(o-1)+(0.404355477009)
            arg[1, 0, 1]+=-0.456986918435*x[2]**o+(0.77750901739)*x[2]
            ref[1, 0, 1, 2]=-0.456986918435*o*x_ref[2]**(o-1)+(0.77750901739)
            arg[1, 0, 2]+=-0.624918127411*x[2]**o+(-0.868958789217)*x[2]
            ref[1, 0, 2, 2]=-0.624918127411*o*x_ref[2]**(o-1)+(-0.868958789217)
            arg[1, 0, 3]+=-0.623323786019*x[2]**o+(-0.88463110387)*x[2]
            ref[1, 0, 3, 2]=-0.623323786019*o*x_ref[2]**(o-1)+(-0.88463110387)
            arg[1, 1, 0]+=0.3735030205*x[2]**o+(-0.0886794520272)*x[2]
            ref[1, 1, 0, 2]=0.3735030205*o*x_ref[2]**(o-1)+(-0.0886794520272)
            arg[1, 1, 1]+=0.135919447053*x[2]**o+(-0.912307643656)*x[2]
            ref[1, 1, 1, 2]=0.135919447053*o*x_ref[2]**(o-1)+(-0.912307643656)
            arg[1, 1, 2]+=0.276225193442*x[2]**o+(-0.309491177727)*x[2]
            ref[1, 1, 2, 2]=0.276225193442*o*x_ref[2]**(o-1)+(-0.309491177727)
            arg[1, 1, 3]+=-0.816050620741*x[2]**o+(-0.288855963408)*x[2]
            ref[1, 1, 3, 2]=-0.816050620741*o*x_ref[2]**(o-1)+(-0.288855963408)
            arg[2, 0, 0]+=0.147024625835*x[2]**o+(-0.00506306249632)*x[2]
            ref[2, 0, 0, 2]=0.147024625835*o*x_ref[2]**(o-1)+(-0.00506306249632)
            arg[2, 0, 1]+=0.613397332616*x[2]**o+(0.780268696982)*x[2]
            ref[2, 0, 1, 2]=0.613397332616*o*x_ref[2]**(o-1)+(0.780268696982)
            arg[2, 0, 2]+=0.12224192384*x[2]**o+(-0.363361981059)*x[2]
            ref[2, 0, 2, 2]=0.12224192384*o*x_ref[2]**(o-1)+(-0.363361981059)
            arg[2, 0, 3]+=-0.244990258607*x[2]**o+(0.479629573594)*x[2]
            ref[2, 0, 3, 2]=-0.244990258607*o*x_ref[2]**(o-1)+(0.479629573594)
            arg[2, 1, 0]+=-0.511864606323*x[2]**o+(-0.945800958233)*x[2]
            ref[2, 1, 0, 2]=-0.511864606323*o*x_ref[2]**(o-1)+(-0.945800958233)
            arg[2, 1, 1]+=0.899131622324*x[2]**o+(-0.214899478268)*x[2]
            ref[2, 1, 1, 2]=0.899131622324*o*x_ref[2]**(o-1)+(-0.214899478268)
            arg[2, 1, 2]+=-0.467090639135*x[2]**o+(0.0504534918183)*x[2]
            ref[2, 1, 2, 2]=-0.467090639135*o*x_ref[2]**(o-1)+(0.0504534918183)
            arg[2, 1, 3]+=-0.623034293567*x[2]**o+(0.193409436381)*x[2]
            ref[2, 1, 3, 2]=-0.623034293567*o*x_ref[2]**(o-1)+(0.193409436381)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3, 2, 4)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onFunctionOnBoundary_fromData_Solution_rank0(self):
        """
        tests gradient of rank 0 Data on FunctionOnBoundary

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=-0.249048404446*x[0]**o+(0.471571216551)*x[0]+(-0.492744401036)*x[1]**o+(0.537255847821)*x[1]
        ref[0]=-0.249048404446*o*x_ref[0]**(o-1)+(0.471571216551)
        ref[1]=-0.492744401036*o*x_ref[1]**(o-1)+(0.537255847821)
        if dim==3:
            arg+=(-0.532849735966)*x[2]**o+(0.211140284929)*x[2]
            ref[2]=-0.532849735966*o*x_ref[2]**(o-1)+(0.211140284929)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onFunctionOnBoundary_fromData_Solution_rank1(self):
        """
        tests gradient of rank 1 Data on FunctionOnBoundary

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(4,),w)
        ref = Data(0,(4,)+(dim,),w_ref)
        arg[0,]=0.255519750739*x[0]**o+(0.679908930528)*x[0]+(0.85574850526)*x[1]**o+(0.924560679625)*x[1]
        ref[0, 0]=0.255519750739*o*x_ref[0]**(o-1)+(0.679908930528)
        ref[0, 1]=0.85574850526*o*x_ref[1]**(o-1)+(0.924560679625)
        arg[1,]=-0.264685001526*x[0]**o+(0.97238058684)*x[0]+(-0.542844633883)*x[1]**o+(0.864686344867)*x[1]
        ref[1, 0]=-0.264685001526*o*x_ref[0]**(o-1)+(0.97238058684)
        ref[1, 1]=-0.542844633883*o*x_ref[1]**(o-1)+(0.864686344867)
        arg[2,]=-0.825999401239*x[0]**o+(0.18632245907)*x[0]+(-0.123960032975)*x[1]**o+(-0.748517294279)*x[1]
        ref[2, 0]=-0.825999401239*o*x_ref[0]**(o-1)+(0.18632245907)
        ref[2, 1]=-0.123960032975*o*x_ref[1]**(o-1)+(-0.748517294279)
        arg[3,]=0.197331207055*x[0]**o+(-0.346094591333)*x[0]+(0.051636406978)*x[1]**o+(0.251542894861)*x[1]
        ref[3, 0]=0.197331207055*o*x_ref[0]**(o-1)+(-0.346094591333)
        ref[3, 1]=0.051636406978*o*x_ref[1]**(o-1)+(0.251542894861)
        if dim==3:
            arg[0,]+=-0.805249445089*x[2]**o+(0.120719728825)*x[2]
            ref[0, 2]=-0.805249445089*o*x_ref[2]**(o-1)+(0.120719728825)
            arg[1,]+=0.262945471889*x[2]**o+(-0.159969476146)*x[2]
            ref[1, 2]=0.262945471889*o*x_ref[2]**(o-1)+(-0.159969476146)
            arg[2,]+=-0.555789122185*x[2]**o+(-0.0526130320355)*x[2]
            ref[2, 2]=-0.555789122185*o*x_ref[2]**(o-1)+(-0.0526130320355)
            arg[3,]+=-0.817032327647*x[2]**o+(0.212419299881)*x[2]
            ref[3, 2]=-0.817032327647*o*x_ref[2]**(o-1)+(0.212419299881)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onFunctionOnBoundary_fromData_Solution_rank2(self):
        """
        tests gradient of rank 2 Data on FunctionOnBoundary

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(3, 4),w)
        ref = Data(0,(3, 4)+(dim,),w_ref)
        arg[0, 0]=0.435894522012*x[0]**o+(-0.343555718528)*x[0]+(0.678603420379)*x[1]**o+(-0.741317921755)*x[1]
        ref[0, 0, 0]=0.435894522012*o*x_ref[0]**(o-1)+(-0.343555718528)
        ref[0, 0, 1]=0.678603420379*o*x_ref[1]**(o-1)+(-0.741317921755)
        arg[0, 1]=0.527033563987*x[0]**o+(-0.911575758307)*x[0]+(-0.821803441307)*x[1]**o+(0.542047477587)*x[1]
        ref[0, 1, 0]=0.527033563987*o*x_ref[0]**(o-1)+(-0.911575758307)
        ref[0, 1, 1]=-0.821803441307*o*x_ref[1]**(o-1)+(0.542047477587)
        arg[0, 2]=0.608365709372*x[0]**o+(-0.35514291434)*x[0]+(0.486091926539)*x[1]**o+(-0.582407287297)*x[1]
        ref[0, 2, 0]=0.608365709372*o*x_ref[0]**(o-1)+(-0.35514291434)
        ref[0, 2, 1]=0.486091926539*o*x_ref[1]**(o-1)+(-0.582407287297)
        arg[0, 3]=0.842540375528*x[0]**o+(0.49562365419)*x[0]+(-0.40687892174)*x[1]**o+(-0.742726592246)*x[1]
        ref[0, 3, 0]=0.842540375528*o*x_ref[0]**(o-1)+(0.49562365419)
        ref[0, 3, 1]=-0.40687892174*o*x_ref[1]**(o-1)+(-0.742726592246)
        arg[1, 0]=0.724863331398*x[0]**o+(0.326042765396)*x[0]+(-0.0762054993783)*x[1]**o+(-0.0766917446248)*x[1]
        ref[1, 0, 0]=0.724863331398*o*x_ref[0]**(o-1)+(0.326042765396)
        ref[1, 0, 1]=-0.0762054993783*o*x_ref[1]**(o-1)+(-0.0766917446248)
        arg[1, 1]=0.650253393002*x[0]**o+(-0.492389855698)*x[0]+(-0.385284261866)*x[1]**o+(-0.344215898989)*x[1]
        ref[1, 1, 0]=0.650253393002*o*x_ref[0]**(o-1)+(-0.492389855698)
        ref[1, 1, 1]=-0.385284261866*o*x_ref[1]**(o-1)+(-0.344215898989)
        arg[1, 2]=0.859823794538*x[0]**o+(-0.00132778803236)*x[0]+(0.0506551602522)*x[1]**o+(-0.101813548422)*x[1]
        ref[1, 2, 0]=0.859823794538*o*x_ref[0]**(o-1)+(-0.00132778803236)
        ref[1, 2, 1]=0.0506551602522*o*x_ref[1]**(o-1)+(-0.101813548422)
        arg[1, 3]=0.482635478404*x[0]**o+(0.0233352194476)*x[0]+(0.129621480181)*x[1]**o+(-0.684144456337)*x[1]
        ref[1, 3, 0]=0.482635478404*o*x_ref[0]**(o-1)+(0.0233352194476)
        ref[1, 3, 1]=0.129621480181*o*x_ref[1]**(o-1)+(-0.684144456337)
        arg[2, 0]=0.234752479906*x[0]**o+(0.984892763468)*x[0]+(-0.193568454491)*x[1]**o+(0.7777405465)*x[1]
        ref[2, 0, 0]=0.234752479906*o*x_ref[0]**(o-1)+(0.984892763468)
        ref[2, 0, 1]=-0.193568454491*o*x_ref[1]**(o-1)+(0.7777405465)
        arg[2, 1]=0.46180002666*x[0]**o+(0.17487342226)*x[0]+(0.453404128189)*x[1]**o+(0.135776943962)*x[1]
        ref[2, 1, 0]=0.46180002666*o*x_ref[0]**(o-1)+(0.17487342226)
        ref[2, 1, 1]=0.453404128189*o*x_ref[1]**(o-1)+(0.135776943962)
        arg[2, 2]=0.729035027684*x[0]**o+(0.00516992703414)*x[0]+(0.956724006152)*x[1]**o+(0.154538043537)*x[1]
        ref[2, 2, 0]=0.729035027684*o*x_ref[0]**(o-1)+(0.00516992703414)
        ref[2, 2, 1]=0.956724006152*o*x_ref[1]**(o-1)+(0.154538043537)
        arg[2, 3]=0.608254699567*x[0]**o+(-0.547911155657)*x[0]+(-0.611463471384)*x[1]**o+(-0.232563257197)*x[1]
        ref[2, 3, 0]=0.608254699567*o*x_ref[0]**(o-1)+(-0.547911155657)
        ref[2, 3, 1]=-0.611463471384*o*x_ref[1]**(o-1)+(-0.232563257197)
        if dim==3:
            arg[0, 0]+=-0.149644280479*x[2]**o+(0.377677269656)*x[2]
            ref[0, 0, 2]=-0.149644280479*o*x_ref[2]**(o-1)+(0.377677269656)
            arg[0, 1]+=-0.680888008955*x[2]**o+(0.521084465402)*x[2]
            ref[0, 1, 2]=-0.680888008955*o*x_ref[2]**(o-1)+(0.521084465402)
            arg[0, 2]+=-0.0572371923647*x[2]**o+(0.18815213321)*x[2]
            ref[0, 2, 2]=-0.0572371923647*o*x_ref[2]**(o-1)+(0.18815213321)
            arg[0, 3]+=0.524841688778*x[2]**o+(0.219355773865)*x[2]
            ref[0, 3, 2]=0.524841688778*o*x_ref[2]**(o-1)+(0.219355773865)
            arg[1, 0]+=-0.7106038064*x[2]**o+(-0.719860710901)*x[2]
            ref[1, 0, 2]=-0.7106038064*o*x_ref[2]**(o-1)+(-0.719860710901)
            arg[1, 1]+=-0.641354391864*x[2]**o+(-0.00485931407985)*x[2]
            ref[1, 1, 2]=-0.641354391864*o*x_ref[2]**(o-1)+(-0.00485931407985)
            arg[1, 2]+=0.678581850036*x[2]**o+(0.206032752729)*x[2]
            ref[1, 2, 2]=0.678581850036*o*x_ref[2]**(o-1)+(0.206032752729)
            arg[1, 3]+=-0.324990233249*x[2]**o+(0.53989751879)*x[2]
            ref[1, 3, 2]=-0.324990233249*o*x_ref[2]**(o-1)+(0.53989751879)
            arg[2, 0]+=-0.380670678947*x[2]**o+(0.955562536938)*x[2]
            ref[2, 0, 2]=-0.380670678947*o*x_ref[2]**(o-1)+(0.955562536938)
            arg[2, 1]+=-0.952040571015*x[2]**o+(-0.130444724898)*x[2]
            ref[2, 1, 2]=-0.952040571015*o*x_ref[2]**(o-1)+(-0.130444724898)
            arg[2, 2]+=0.222719685449*x[2]**o+(-0.058329852956)*x[2]
            ref[2, 2, 2]=0.222719685449*o*x_ref[2]**(o-1)+(-0.058329852956)
            arg[2, 3]+=-0.133448888013*x[2]**o+(-0.159701245103)*x[2]
            ref[2, 3, 2]=-0.133448888013*o*x_ref[2]**(o-1)+(-0.159701245103)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3, 4)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onFunctionOnBoundary_fromData_Solution_rank3(self):
        """
        tests gradient of rank 3 Data on FunctionOnBoundary

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = Solution(self.domain)
        x = w.getX()
        arg = Data(0,(4, 3, 3),w)
        ref = Data(0,(4, 3, 3)+(dim,),w_ref)
        arg[0, 0, 0]=-0.196558943546*x[0]**o+(-0.903988266507)*x[0]+(0.242366482889)*x[1]**o+(-0.83740764102)*x[1]
        ref[0, 0, 0, 0]=-0.196558943546*o*x_ref[0]**(o-1)+(-0.903988266507)
        ref[0, 0, 0, 1]=0.242366482889*o*x_ref[1]**(o-1)+(-0.83740764102)
        arg[0, 0, 1]=0.340652712426*x[0]**o+(0.536989952808)*x[0]+(0.42207142386)*x[1]**o+(-0.919133240162)*x[1]
        ref[0, 0, 1, 0]=0.340652712426*o*x_ref[0]**(o-1)+(0.536989952808)
        ref[0, 0, 1, 1]=0.42207142386*o*x_ref[1]**(o-1)+(-0.919133240162)
        arg[0, 0, 2]=0.644537927512*x[0]**o+(-0.954812104274)*x[0]+(-0.595828162654)*x[1]**o+(-0.497669139448)*x[1]
        ref[0, 0, 2, 0]=0.644537927512*o*x_ref[0]**(o-1)+(-0.954812104274)
        ref[0, 0, 2, 1]=-0.595828162654*o*x_ref[1]**(o-1)+(-0.497669139448)
        arg[0, 1, 0]=-0.0195771283269*x[0]**o+(0.577869708671)*x[0]+(-0.986649634776)*x[1]**o+(0.413667385654)*x[1]
        ref[0, 1, 0, 0]=-0.0195771283269*o*x_ref[0]**(o-1)+(0.577869708671)
        ref[0, 1, 0, 1]=-0.986649634776*o*x_ref[1]**(o-1)+(0.413667385654)
        arg[0, 1, 1]=-0.210023403449*x[0]**o+(-0.734516257395)*x[0]+(0.458670926671)*x[1]**o+(0.385916565324)*x[1]
        ref[0, 1, 1, 0]=-0.210023403449*o*x_ref[0]**(o-1)+(-0.734516257395)
        ref[0, 1, 1, 1]=0.458670926671*o*x_ref[1]**(o-1)+(0.385916565324)
        arg[0, 1, 2]=-0.587250447291*x[0]**o+(-0.713878166078)*x[0]+(-0.108547486394)*x[1]**o+(-0.578400355559)*x[1]
        ref[0, 1, 2, 0]=-0.587250447291*o*x_ref[0]**(o-1)+(-0.713878166078)
        ref[0, 1, 2, 1]=-0.108547486394*o*x_ref[1]**(o-1)+(-0.578400355559)
        arg[0, 2, 0]=0.138983472675*x[0]**o+(0.262146543969)*x[0]+(0.151708214446)*x[1]**o+(-0.056711722948)*x[1]
        ref[0, 2, 0, 0]=0.138983472675*o*x_ref[0]**(o-1)+(0.262146543969)
        ref[0, 2, 0, 1]=0.151708214446*o*x_ref[1]**(o-1)+(-0.056711722948)
        arg[0, 2, 1]=0.84531357976*x[0]**o+(-0.502284834401)*x[0]+(-0.0871573544751)*x[1]**o+(0.397379322436)*x[1]
        ref[0, 2, 1, 0]=0.84531357976*o*x_ref[0]**(o-1)+(-0.502284834401)
        ref[0, 2, 1, 1]=-0.0871573544751*o*x_ref[1]**(o-1)+(0.397379322436)
        arg[0, 2, 2]=-0.151552497153*x[0]**o+(0.917522050436)*x[0]+(0.875834662996)*x[1]**o+(-0.322357921624)*x[1]
        ref[0, 2, 2, 0]=-0.151552497153*o*x_ref[0]**(o-1)+(0.917522050436)
        ref[0, 2, 2, 1]=0.875834662996*o*x_ref[1]**(o-1)+(-0.322357921624)
        arg[1, 0, 0]=-0.694914335037*x[0]**o+(0.807315513463)*x[0]+(0.674443086192)*x[1]**o+(0.443407692339)*x[1]
        ref[1, 0, 0, 0]=-0.694914335037*o*x_ref[0]**(o-1)+(0.807315513463)
        ref[1, 0, 0, 1]=0.674443086192*o*x_ref[1]**(o-1)+(0.443407692339)
        arg[1, 0, 1]=0.269938852051*x[0]**o+(-0.246483884402)*x[0]+(0.621238574752)*x[1]**o+(-0.392112815183)*x[1]
        ref[1, 0, 1, 0]=0.269938852051*o*x_ref[0]**(o-1)+(-0.246483884402)
        ref[1, 0, 1, 1]=0.621238574752*o*x_ref[1]**(o-1)+(-0.392112815183)
        arg[1, 0, 2]=0.126571455355*x[0]**o+(0.381370002951)*x[0]+(-0.10479626892)*x[1]**o+(-0.181179576079)*x[1]
        ref[1, 0, 2, 0]=0.126571455355*o*x_ref[0]**(o-1)+(0.381370002951)
        ref[1, 0, 2, 1]=-0.10479626892*o*x_ref[1]**(o-1)+(-0.181179576079)
        arg[1, 1, 0]=0.438790317572*x[0]**o+(0.407308332487)*x[0]+(-0.244311402167)*x[1]**o+(-0.941184866857)*x[1]
        ref[1, 1, 0, 0]=0.438790317572*o*x_ref[0]**(o-1)+(0.407308332487)
        ref[1, 1, 0, 1]=-0.244311402167*o*x_ref[1]**(o-1)+(-0.941184866857)
        arg[1, 1, 1]=0.274020347421*x[0]**o+(0.475443693953)*x[0]+(-0.690994782961)*x[1]**o+(0.278289852797)*x[1]
        ref[1, 1, 1, 0]=0.274020347421*o*x_ref[0]**(o-1)+(0.475443693953)
        ref[1, 1, 1, 1]=-0.690994782961*o*x_ref[1]**(o-1)+(0.278289852797)
        arg[1, 1, 2]=0.706568101719*x[0]**o+(0.229370950892)*x[0]+(0.7745745781)*x[1]**o+(0.314586773152)*x[1]
        ref[1, 1, 2, 0]=0.706568101719*o*x_ref[0]**(o-1)+(0.229370950892)
        ref[1, 1, 2, 1]=0.7745745781*o*x_ref[1]**(o-1)+(0.314586773152)
        arg[1, 2, 0]=-0.281825373149*x[0]**o+(-0.549622178109)*x[0]+(0.266418720636)*x[1]**o+(0.829346768406)*x[1]
        ref[1, 2, 0, 0]=-0.281825373149*o*x_ref[0]**(o-1)+(-0.549622178109)
        ref[1, 2, 0, 1]=0.266418720636*o*x_ref[1]**(o-1)+(0.829346768406)
        arg[1, 2, 1]=-0.480833205791*x[0]**o+(-0.824144991237)*x[0]+(-0.847819149002)*x[1]**o+(-0.498663045664)*x[1]
        ref[1, 2, 1, 0]=-0.480833205791*o*x_ref[0]**(o-1)+(-0.824144991237)
        ref[1, 2, 1, 1]=-0.847819149002*o*x_ref[1]**(o-1)+(-0.498663045664)
        arg[1, 2, 2]=-0.969175360974*x[0]**o+(-0.140473756762)*x[0]+(-0.429819798462)*x[1]**o+(0.349867967185)*x[1]
        ref[1, 2, 2, 0]=-0.969175360974*o*x_ref[0]**(o-1)+(-0.140473756762)
        ref[1, 2, 2, 1]=-0.429819798462*o*x_ref[1]**(o-1)+(0.349867967185)
        arg[2, 0, 0]=0.732574455966*x[0]**o+(0.749735264957)*x[0]+(-0.894021192057)*x[1]**o+(-0.19448898741)*x[1]
        ref[2, 0, 0, 0]=0.732574455966*o*x_ref[0]**(o-1)+(0.749735264957)
        ref[2, 0, 0, 1]=-0.894021192057*o*x_ref[1]**(o-1)+(-0.19448898741)
        arg[2, 0, 1]=-0.110509282425*x[0]**o+(0.767697081419)*x[0]+(-0.358513399098)*x[1]**o+(0.257495274322)*x[1]
        ref[2, 0, 1, 0]=-0.110509282425*o*x_ref[0]**(o-1)+(0.767697081419)
        ref[2, 0, 1, 1]=-0.358513399098*o*x_ref[1]**(o-1)+(0.257495274322)
        arg[2, 0, 2]=-0.920090797575*x[0]**o+(-0.735680869677)*x[0]+(-0.638797057211)*x[1]**o+(-0.785441792129)*x[1]
        ref[2, 0, 2, 0]=-0.920090797575*o*x_ref[0]**(o-1)+(-0.735680869677)
        ref[2, 0, 2, 1]=-0.638797057211*o*x_ref[1]**(o-1)+(-0.785441792129)
        arg[2, 1, 0]=0.038002144422*x[0]**o+(-0.618174508747)*x[0]+(0.633917490418)*x[1]**o+(0.648930404181)*x[1]
        ref[2, 1, 0, 0]=0.038002144422*o*x_ref[0]**(o-1)+(-0.618174508747)
        ref[2, 1, 0, 1]=0.633917490418*o*x_ref[1]**(o-1)+(0.648930404181)
        arg[2, 1, 1]=0.794764004331*x[0]**o+(0.983864916633)*x[0]+(-0.46370828184)*x[1]**o+(-0.788162867861)*x[1]
        ref[2, 1, 1, 0]=0.794764004331*o*x_ref[0]**(o-1)+(0.983864916633)
        ref[2, 1, 1, 1]=-0.46370828184*o*x_ref[1]**(o-1)+(-0.788162867861)
        arg[2, 1, 2]=-0.912896643244*x[0]**o+(-0.0133505464352)*x[0]+(-0.820476975801)*x[1]**o+(-0.50001591789)*x[1]
        ref[2, 1, 2, 0]=-0.912896643244*o*x_ref[0]**(o-1)+(-0.0133505464352)
        ref[2, 1, 2, 1]=-0.820476975801*o*x_ref[1]**(o-1)+(-0.50001591789)
        arg[2, 2, 0]=-0.641790327479*x[0]**o+(0.703663438085)*x[0]+(-0.92573401981)*x[1]**o+(0.977525395704)*x[1]
        ref[2, 2, 0, 0]=-0.641790327479*o*x_ref[0]**(o-1)+(0.703663438085)
        ref[2, 2, 0, 1]=-0.92573401981*o*x_ref[1]**(o-1)+(0.977525395704)
        arg[2, 2, 1]=0.280902921238*x[0]**o+(-0.844134958976)*x[0]+(-0.418735462574)*x[1]**o+(-0.754617589887)*x[1]
        ref[2, 2, 1, 0]=0.280902921238*o*x_ref[0]**(o-1)+(-0.844134958976)
        ref[2, 2, 1, 1]=-0.418735462574*o*x_ref[1]**(o-1)+(-0.754617589887)
        arg[2, 2, 2]=0.257016495658*x[0]**o+(-0.343994638233)*x[0]+(0.432214873788)*x[1]**o+(-0.943985324414)*x[1]
        ref[2, 2, 2, 0]=0.257016495658*o*x_ref[0]**(o-1)+(-0.343994638233)
        ref[2, 2, 2, 1]=0.432214873788*o*x_ref[1]**(o-1)+(-0.943985324414)
        arg[3, 0, 0]=-0.657834697631*x[0]**o+(0.447314669372)*x[0]+(-0.69780058203)*x[1]**o+(-0.435993369354)*x[1]
        ref[3, 0, 0, 0]=-0.657834697631*o*x_ref[0]**(o-1)+(0.447314669372)
        ref[3, 0, 0, 1]=-0.69780058203*o*x_ref[1]**(o-1)+(-0.435993369354)
        arg[3, 0, 1]=0.224055773501*x[0]**o+(0.851615627504)*x[0]+(-0.299235624371)*x[1]**o+(0.0682800593858)*x[1]
        ref[3, 0, 1, 0]=0.224055773501*o*x_ref[0]**(o-1)+(0.851615627504)
        ref[3, 0, 1, 1]=-0.299235624371*o*x_ref[1]**(o-1)+(0.0682800593858)
        arg[3, 0, 2]=0.886199419848*x[0]**o+(0.0765429072502)*x[0]+(0.454888191894)*x[1]**o+(-0.327924692334)*x[1]
        ref[3, 0, 2, 0]=0.886199419848*o*x_ref[0]**(o-1)+(0.0765429072502)
        ref[3, 0, 2, 1]=0.454888191894*o*x_ref[1]**(o-1)+(-0.327924692334)
        arg[3, 1, 0]=0.613251124912*x[0]**o+(0.232352284867)*x[0]+(-0.524918262854)*x[1]**o+(0.617439572652)*x[1]
        ref[3, 1, 0, 0]=0.613251124912*o*x_ref[0]**(o-1)+(0.232352284867)
        ref[3, 1, 0, 1]=-0.524918262854*o*x_ref[1]**(o-1)+(0.617439572652)
        arg[3, 1, 1]=-0.174373757715*x[0]**o+(-0.43028133843)*x[0]+(-0.762763558427)*x[1]**o+(-0.26346483132)*x[1]
        ref[3, 1, 1, 0]=-0.174373757715*o*x_ref[0]**(o-1)+(-0.43028133843)
        ref[3, 1, 1, 1]=-0.762763558427*o*x_ref[1]**(o-1)+(-0.26346483132)
        arg[3, 1, 2]=0.699847486829*x[0]**o+(-0.326623134716)*x[0]+(-0.162677672737)*x[1]**o+(-0.452796803731)*x[1]
        ref[3, 1, 2, 0]=0.699847486829*o*x_ref[0]**(o-1)+(-0.326623134716)
        ref[3, 1, 2, 1]=-0.162677672737*o*x_ref[1]**(o-1)+(-0.452796803731)
        arg[3, 2, 0]=-0.0282050465297*x[0]**o+(-0.517067637543)*x[0]+(-0.61780957879)*x[1]**o+(0.965336321447)*x[1]
        ref[3, 2, 0, 0]=-0.0282050465297*o*x_ref[0]**(o-1)+(-0.517067637543)
        ref[3, 2, 0, 1]=-0.61780957879*o*x_ref[1]**(o-1)+(0.965336321447)
        arg[3, 2, 1]=0.964305823556*x[0]**o+(0.733179418742)*x[0]+(-0.243877200574)*x[1]**o+(-0.699707080414)*x[1]
        ref[3, 2, 1, 0]=0.964305823556*o*x_ref[0]**(o-1)+(0.733179418742)
        ref[3, 2, 1, 1]=-0.243877200574*o*x_ref[1]**(o-1)+(-0.699707080414)
        arg[3, 2, 2]=-0.291775861137*x[0]**o+(-0.372056947787)*x[0]+(0.873658233925)*x[1]**o+(-0.271026209657)*x[1]
        ref[3, 2, 2, 0]=-0.291775861137*o*x_ref[0]**(o-1)+(-0.372056947787)
        ref[3, 2, 2, 1]=0.873658233925*o*x_ref[1]**(o-1)+(-0.271026209657)
        if dim==3:
            arg[0, 0, 0]+=-0.251260504608*x[2]**o+(0.251782733251)*x[2]
            ref[0, 0, 0, 2]=-0.251260504608*o*x_ref[2]**(o-1)+(0.251782733251)
            arg[0, 0, 1]+=0.111025038992*x[2]**o+(0.295156037124)*x[2]
            ref[0, 0, 1, 2]=0.111025038992*o*x_ref[2]**(o-1)+(0.295156037124)
            arg[0, 0, 2]+=-0.436639365273*x[2]**o+(0.710827504259)*x[2]
            ref[0, 0, 2, 2]=-0.436639365273*o*x_ref[2]**(o-1)+(0.710827504259)
            arg[0, 1, 0]+=0.940650973977*x[2]**o+(-0.207683811442)*x[2]
            ref[0, 1, 0, 2]=0.940650973977*o*x_ref[2]**(o-1)+(-0.207683811442)
            arg[0, 1, 1]+=-0.972280500761*x[2]**o+(-0.911834914157)*x[2]
            ref[0, 1, 1, 2]=-0.972280500761*o*x_ref[2]**(o-1)+(-0.911834914157)
            arg[0, 1, 2]+=0.621569169889*x[2]**o+(0.858671375507)*x[2]
            ref[0, 1, 2, 2]=0.621569169889*o*x_ref[2]**(o-1)+(0.858671375507)
            arg[0, 2, 0]+=-0.483808680261*x[2]**o+(-0.602771401107)*x[2]
            ref[0, 2, 0, 2]=-0.483808680261*o*x_ref[2]**(o-1)+(-0.602771401107)
            arg[0, 2, 1]+=-0.820559386711*x[2]**o+(0.285007701172)*x[2]
            ref[0, 2, 1, 2]=-0.820559386711*o*x_ref[2]**(o-1)+(0.285007701172)
            arg[0, 2, 2]+=-0.176972376623*x[2]**o+(-0.667157391204)*x[2]
            ref[0, 2, 2, 2]=-0.176972376623*o*x_ref[2]**(o-1)+(-0.667157391204)
            arg[1, 0, 0]+=-0.410345679463*x[2]**o+(-0.180086529417)*x[2]
            ref[1, 0, 0, 2]=-0.410345679463*o*x_ref[2]**(o-1)+(-0.180086529417)
            arg[1, 0, 1]+=-0.75109703744*x[2]**o+(-0.601514514326)*x[2]
            ref[1, 0, 1, 2]=-0.75109703744*o*x_ref[2]**(o-1)+(-0.601514514326)
            arg[1, 0, 2]+=-0.606514124007*x[2]**o+(0.677258036645)*x[2]
            ref[1, 0, 2, 2]=-0.606514124007*o*x_ref[2]**(o-1)+(0.677258036645)
            arg[1, 1, 0]+=-0.771602659551*x[2]**o+(-0.763088754447)*x[2]
            ref[1, 1, 0, 2]=-0.771602659551*o*x_ref[2]**(o-1)+(-0.763088754447)
            arg[1, 1, 1]+=0.695141224235*x[2]**o+(-0.231764298821)*x[2]
            ref[1, 1, 1, 2]=0.695141224235*o*x_ref[2]**(o-1)+(-0.231764298821)
            arg[1, 1, 2]+=0.765151983435*x[2]**o+(0.625127007229)*x[2]
            ref[1, 1, 2, 2]=0.765151983435*o*x_ref[2]**(o-1)+(0.625127007229)
            arg[1, 2, 0]+=-0.504733790317*x[2]**o+(-0.513280777824)*x[2]
            ref[1, 2, 0, 2]=-0.504733790317*o*x_ref[2]**(o-1)+(-0.513280777824)
            arg[1, 2, 1]+=-0.971998066124*x[2]**o+(-0.56138405784)*x[2]
            ref[1, 2, 1, 2]=-0.971998066124*o*x_ref[2]**(o-1)+(-0.56138405784)
            arg[1, 2, 2]+=0.591456430068*x[2]**o+(0.273432378296)*x[2]
            ref[1, 2, 2, 2]=0.591456430068*o*x_ref[2]**(o-1)+(0.273432378296)
            arg[2, 0, 0]+=-0.542974378343*x[2]**o+(0.368893773417)*x[2]
            ref[2, 0, 0, 2]=-0.542974378343*o*x_ref[2]**(o-1)+(0.368893773417)
            arg[2, 0, 1]+=0.0319433461809*x[2]**o+(-0.790171583456)*x[2]
            ref[2, 0, 1, 2]=0.0319433461809*o*x_ref[2]**(o-1)+(-0.790171583456)
            arg[2, 0, 2]+=0.328996988792*x[2]**o+(-0.917237513216)*x[2]
            ref[2, 0, 2, 2]=0.328996988792*o*x_ref[2]**(o-1)+(-0.917237513216)
            arg[2, 1, 0]+=-0.0654974867184*x[2]**o+(-0.40332495808)*x[2]
            ref[2, 1, 0, 2]=-0.0654974867184*o*x_ref[2]**(o-1)+(-0.40332495808)
            arg[2, 1, 1]+=0.559025031077*x[2]**o+(0.170368444494)*x[2]
            ref[2, 1, 1, 2]=0.559025031077*o*x_ref[2]**(o-1)+(0.170368444494)
            arg[2, 1, 2]+=0.497243303495*x[2]**o+(-0.557929999081)*x[2]
            ref[2, 1, 2, 2]=0.497243303495*o*x_ref[2]**(o-1)+(-0.557929999081)
            arg[2, 2, 0]+=-0.482726460223*x[2]**o+(0.792112526703)*x[2]
            ref[2, 2, 0, 2]=-0.482726460223*o*x_ref[2]**(o-1)+(0.792112526703)
            arg[2, 2, 1]+=0.513471320201*x[2]**o+(-0.598471800507)*x[2]
            ref[2, 2, 1, 2]=0.513471320201*o*x_ref[2]**(o-1)+(-0.598471800507)
            arg[2, 2, 2]+=0.579191469194*x[2]**o+(0.514696479498)*x[2]
            ref[2, 2, 2, 2]=0.579191469194*o*x_ref[2]**(o-1)+(0.514696479498)
            arg[3, 0, 0]+=-0.607764539537*x[2]**o+(0.360464512639)*x[2]
            ref[3, 0, 0, 2]=-0.607764539537*o*x_ref[2]**(o-1)+(0.360464512639)
            arg[3, 0, 1]+=0.889688134422*x[2]**o+(0.680457003077)*x[2]
            ref[3, 0, 1, 2]=0.889688134422*o*x_ref[2]**(o-1)+(0.680457003077)
            arg[3, 0, 2]+=-0.271666934724*x[2]**o+(-0.481574363031)*x[2]
            ref[3, 0, 2, 2]=-0.271666934724*o*x_ref[2]**(o-1)+(-0.481574363031)
            arg[3, 1, 0]+=0.263220557881*x[2]**o+(0.12977712035)*x[2]
            ref[3, 1, 0, 2]=0.263220557881*o*x_ref[2]**(o-1)+(0.12977712035)
            arg[3, 1, 1]+=0.689851844432*x[2]**o+(0.819825415201)*x[2]
            ref[3, 1, 1, 2]=0.689851844432*o*x_ref[2]**(o-1)+(0.819825415201)
            arg[3, 1, 2]+=-0.602482567719*x[2]**o+(0.447387386143)*x[2]
            ref[3, 1, 2, 2]=-0.602482567719*o*x_ref[2]**(o-1)+(0.447387386143)
            arg[3, 2, 0]+=-0.0567316965495*x[2]**o+(-0.573848397602)*x[2]
            ref[3, 2, 0, 2]=-0.0567316965495*o*x_ref[2]**(o-1)+(-0.573848397602)
            arg[3, 2, 1]+=0.464056767826*x[2]**o+(0.0734290656668)*x[2]
            ref[3, 2, 1, 2]=0.464056767826*o*x_ref[2]**(o-1)+(0.0734290656668)
            arg[3, 2, 2]+=-0.421964191631*x[2]**o+(-0.60782272194)*x[2]
            ref[3, 2, 2, 2]=-0.421964191631*o*x_ref[2]**(o-1)+(-0.60782272194)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4, 3, 3)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onFunctionOnBoundary_fromData_ReducedSolution_rank0(self):
        """
        tests gradient of rank 0 Data on FunctionOnBoundary

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=-0.799403448525*x[0]+(-0.926932895037)*x[1]
        ref[0]=-0.799403448525
        ref[1]=-0.926932895037
        if dim==3:
            arg+=(0.706675578171)*x[2]
            ref[2]=0.706675578171
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onFunctionOnBoundary_fromData_ReducedSolution_rank1(self):
        """
        tests gradient of rank 1 Data on FunctionOnBoundary

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(4,),w)
        ref = Data(0,(4,)+(dim,),w_ref)
        arg[0,]=-0.886555398145*x[0]+(-0.316523933204)*x[1]
        ref[0, 0]=-0.886555398145
        ref[0, 1]=-0.316523933204
        arg[1,]=0.0729731469621*x[0]+(0.410968206819)*x[1]
        ref[1, 0]=0.0729731469621
        ref[1, 1]=0.410968206819
        arg[2,]=-0.974441226843*x[0]+(0.163434282991)*x[1]
        ref[2, 0]=-0.974441226843
        ref[2, 1]=0.163434282991
        arg[3,]=-0.303121512047*x[0]+(-0.776582165854)*x[1]
        ref[3, 0]=-0.303121512047
        ref[3, 1]=-0.776582165854
        if dim==3:
            arg[0,]+=0.423867219292*x[2]
            ref[0, 2]=0.423867219292
            arg[1,]+=-0.471742705549*x[2]
            ref[1, 2]=-0.471742705549
            arg[2,]+=0.90651161019*x[2]
            ref[2, 2]=0.90651161019
            arg[3,]+=0.25487917854*x[2]
            ref[3, 2]=0.25487917854
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onFunctionOnBoundary_fromData_ReducedSolution_rank2(self):
        """
        tests gradient of rank 2 Data on FunctionOnBoundary

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(4, 4),w)
        ref = Data(0,(4, 4)+(dim,),w_ref)
        arg[0, 0]=-0.0600919513286*x[0]+(0.382291062781)*x[1]
        ref[0, 0, 0]=-0.0600919513286
        ref[0, 0, 1]=0.382291062781
        arg[0, 1]=-0.569482806955*x[0]+(0.188816757643)*x[1]
        ref[0, 1, 0]=-0.569482806955
        ref[0, 1, 1]=0.188816757643
        arg[0, 2]=0.436024430139*x[0]+(0.825668239668)*x[1]
        ref[0, 2, 0]=0.436024430139
        ref[0, 2, 1]=0.825668239668
        arg[0, 3]=0.186766217576*x[0]+(0.129493667339)*x[1]
        ref[0, 3, 0]=0.186766217576
        ref[0, 3, 1]=0.129493667339
        arg[1, 0]=0.686204183448*x[0]+(0.739752622075)*x[1]
        ref[1, 0, 0]=0.686204183448
        ref[1, 0, 1]=0.739752622075
        arg[1, 1]=0.493711632667*x[0]+(-0.172284590334)*x[1]
        ref[1, 1, 0]=0.493711632667
        ref[1, 1, 1]=-0.172284590334
        arg[1, 2]=-0.563103565004*x[0]+(0.937358730894)*x[1]
        ref[1, 2, 0]=-0.563103565004
        ref[1, 2, 1]=0.937358730894
        arg[1, 3]=-0.992087852443*x[0]+(0.440291695439)*x[1]
        ref[1, 3, 0]=-0.992087852443
        ref[1, 3, 1]=0.440291695439
        arg[2, 0]=0.602840917084*x[0]+(-0.325130125023)*x[1]
        ref[2, 0, 0]=0.602840917084
        ref[2, 0, 1]=-0.325130125023
        arg[2, 1]=0.354525830801*x[0]+(0.0732397205231)*x[1]
        ref[2, 1, 0]=0.354525830801
        ref[2, 1, 1]=0.0732397205231
        arg[2, 2]=-0.16806447338*x[0]+(0.924835152033)*x[1]
        ref[2, 2, 0]=-0.16806447338
        ref[2, 2, 1]=0.924835152033
        arg[2, 3]=0.237345897398*x[0]+(0.266266433417)*x[1]
        ref[2, 3, 0]=0.237345897398
        ref[2, 3, 1]=0.266266433417
        arg[3, 0]=0.0883921978061*x[0]+(-0.594340487413)*x[1]
        ref[3, 0, 0]=0.0883921978061
        ref[3, 0, 1]=-0.594340487413
        arg[3, 1]=-0.0257002143185*x[0]+(-0.995425476356)*x[1]
        ref[3, 1, 0]=-0.0257002143185
        ref[3, 1, 1]=-0.995425476356
        arg[3, 2]=-0.451292820281*x[0]+(-0.655112178149)*x[1]
        ref[3, 2, 0]=-0.451292820281
        ref[3, 2, 1]=-0.655112178149
        arg[3, 3]=-0.935637470377*x[0]+(0.397876301046)*x[1]
        ref[3, 3, 0]=-0.935637470377
        ref[3, 3, 1]=0.397876301046
        if dim==3:
            arg[0, 0]+=-0.46397140679*x[2]
            ref[0, 0, 2]=-0.46397140679
            arg[0, 1]+=-0.544939246696*x[2]
            ref[0, 1, 2]=-0.544939246696
            arg[0, 2]+=-0.901388187437*x[2]
            ref[0, 2, 2]=-0.901388187437
            arg[0, 3]+=-0.743687839654*x[2]
            ref[0, 3, 2]=-0.743687839654
            arg[1, 0]+=0.703779064471*x[2]
            ref[1, 0, 2]=0.703779064471
            arg[1, 1]+=0.804274767536*x[2]
            ref[1, 1, 2]=0.804274767536
            arg[1, 2]+=0.0100772327379*x[2]
            ref[1, 2, 2]=0.0100772327379
            arg[1, 3]+=0.759741354196*x[2]
            ref[1, 3, 2]=0.759741354196
            arg[2, 0]+=0.801700155036*x[2]
            ref[2, 0, 2]=0.801700155036
            arg[2, 1]+=-0.914090348825*x[2]
            ref[2, 1, 2]=-0.914090348825
            arg[2, 2]+=-0.252164210002*x[2]
            ref[2, 2, 2]=-0.252164210002
            arg[2, 3]+=-0.0769704239364*x[2]
            ref[2, 3, 2]=-0.0769704239364
            arg[3, 0]+=0.945421704275*x[2]
            ref[3, 0, 2]=0.945421704275
            arg[3, 1]+=0.189200359657*x[2]
            ref[3, 1, 2]=0.189200359657
            arg[3, 2]+=0.71706431582*x[2]
            ref[3, 2, 2]=0.71706431582
            arg[3, 3]+=0.0162652176717*x[2]
            ref[3, 3, 2]=0.0162652176717
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4, 4)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onFunctionOnBoundary_fromData_ReducedSolution_rank3(self):
        """
        tests gradient of rank 3 Data on FunctionOnBoundary

        assumptions: ReducedSolution(self.domain) exists
                     self.domain supports gradient on FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ReducedSolution(self.domain)
        x = w.getX()
        arg = Data(0,(3, 4, 4),w)
        ref = Data(0,(3, 4, 4)+(dim,),w_ref)
        arg[0, 0, 0]=-0.237067786719*x[0]+(0.605015094617)*x[1]
        ref[0, 0, 0, 0]=-0.237067786719
        ref[0, 0, 0, 1]=0.605015094617
        arg[0, 0, 1]=-0.536888201101*x[0]+(0.595531719781)*x[1]
        ref[0, 0, 1, 0]=-0.536888201101
        ref[0, 0, 1, 1]=0.595531719781
        arg[0, 0, 2]=-0.252210841606*x[0]+(0.379524542293)*x[1]
        ref[0, 0, 2, 0]=-0.252210841606
        ref[0, 0, 2, 1]=0.379524542293
        arg[0, 0, 3]=0.827762742733*x[0]+(-0.274551422309)*x[1]
        ref[0, 0, 3, 0]=0.827762742733
        ref[0, 0, 3, 1]=-0.274551422309
        arg[0, 1, 0]=-0.925699030764*x[0]+(0.741222065386)*x[1]
        ref[0, 1, 0, 0]=-0.925699030764
        ref[0, 1, 0, 1]=0.741222065386
        arg[0, 1, 1]=0.778172474424*x[0]+(0.779304824725)*x[1]
        ref[0, 1, 1, 0]=0.778172474424
        ref[0, 1, 1, 1]=0.779304824725
        arg[0, 1, 2]=-0.520906783311*x[0]+(-0.979005245945)*x[1]
        ref[0, 1, 2, 0]=-0.520906783311
        ref[0, 1, 2, 1]=-0.979005245945
        arg[0, 1, 3]=0.645743845211*x[0]+(0.731348745156)*x[1]
        ref[0, 1, 3, 0]=0.645743845211
        ref[0, 1, 3, 1]=0.731348745156
        arg[0, 2, 0]=0.496549514171*x[0]+(0.453553604783)*x[1]
        ref[0, 2, 0, 0]=0.496549514171
        ref[0, 2, 0, 1]=0.453553604783
        arg[0, 2, 1]=-0.378634595711*x[0]+(0.0646329461742)*x[1]
        ref[0, 2, 1, 0]=-0.378634595711
        ref[0, 2, 1, 1]=0.0646329461742
        arg[0, 2, 2]=-0.4861221847*x[0]+(0.796731079575)*x[1]
        ref[0, 2, 2, 0]=-0.4861221847
        ref[0, 2, 2, 1]=0.796731079575
        arg[0, 2, 3]=-0.231831430714*x[0]+(0.878995603644)*x[1]
        ref[0, 2, 3, 0]=-0.231831430714
        ref[0, 2, 3, 1]=0.878995603644
        arg[0, 3, 0]=-0.244798271235*x[0]+(-0.148613467964)*x[1]
        ref[0, 3, 0, 0]=-0.244798271235
        ref[0, 3, 0, 1]=-0.148613467964
        arg[0, 3, 1]=0.459673884581*x[0]+(0.408166333319)*x[1]
        ref[0, 3, 1, 0]=0.459673884581
        ref[0, 3, 1, 1]=0.408166333319
        arg[0, 3, 2]=-0.433060668874*x[0]+(-0.855647712614)*x[1]
        ref[0, 3, 2, 0]=-0.433060668874
        ref[0, 3, 2, 1]=-0.855647712614
        arg[0, 3, 3]=0.121234149292*x[0]+(0.384017266782)*x[1]
        ref[0, 3, 3, 0]=0.121234149292
        ref[0, 3, 3, 1]=0.384017266782
        arg[1, 0, 0]=0.436406034721*x[0]+(-0.543010380821)*x[1]
        ref[1, 0, 0, 0]=0.436406034721
        ref[1, 0, 0, 1]=-0.543010380821
        arg[1, 0, 1]=0.282306697558*x[0]+(0.638032019066)*x[1]
        ref[1, 0, 1, 0]=0.282306697558
        ref[1, 0, 1, 1]=0.638032019066
        arg[1, 0, 2]=-0.420219522583*x[0]+(0.779053081918)*x[1]
        ref[1, 0, 2, 0]=-0.420219522583
        ref[1, 0, 2, 1]=0.779053081918
        arg[1, 0, 3]=-0.747742867554*x[0]+(0.662668448086)*x[1]
        ref[1, 0, 3, 0]=-0.747742867554
        ref[1, 0, 3, 1]=0.662668448086
        arg[1, 1, 0]=0.623723696777*x[0]+(-0.128891582469)*x[1]
        ref[1, 1, 0, 0]=0.623723696777
        ref[1, 1, 0, 1]=-0.128891582469
        arg[1, 1, 1]=0.913170388206*x[0]+(0.470092204606)*x[1]
        ref[1, 1, 1, 0]=0.913170388206
        ref[1, 1, 1, 1]=0.470092204606
        arg[1, 1, 2]=0.00762891443288*x[0]+(-0.225074638184)*x[1]
        ref[1, 1, 2, 0]=0.00762891443288
        ref[1, 1, 2, 1]=-0.225074638184
        arg[1, 1, 3]=0.709267287534*x[0]+(0.425960408608)*x[1]
        ref[1, 1, 3, 0]=0.709267287534
        ref[1, 1, 3, 1]=0.425960408608
        arg[1, 2, 0]=0.564919246819*x[0]+(0.282531503515)*x[1]
        ref[1, 2, 0, 0]=0.564919246819
        ref[1, 2, 0, 1]=0.282531503515
        arg[1, 2, 1]=0.527853219283*x[0]+(0.441117156808)*x[1]
        ref[1, 2, 1, 0]=0.527853219283
        ref[1, 2, 1, 1]=0.441117156808
        arg[1, 2, 2]=0.346808372493*x[0]+(0.00359216487142)*x[1]
        ref[1, 2, 2, 0]=0.346808372493
        ref[1, 2, 2, 1]=0.00359216487142
        arg[1, 2, 3]=0.707865155757*x[0]+(0.90505426057)*x[1]
        ref[1, 2, 3, 0]=0.707865155757
        ref[1, 2, 3, 1]=0.90505426057
        arg[1, 3, 0]=0.394906972884*x[0]+(0.385429314799)*x[1]
        ref[1, 3, 0, 0]=0.394906972884
        ref[1, 3, 0, 1]=0.385429314799
        arg[1, 3, 1]=0.73748040294*x[0]+(0.92311975959)*x[1]
        ref[1, 3, 1, 0]=0.73748040294
        ref[1, 3, 1, 1]=0.92311975959
        arg[1, 3, 2]=-0.950541906897*x[0]+(-0.766322244138)*x[1]
        ref[1, 3, 2, 0]=-0.950541906897
        ref[1, 3, 2, 1]=-0.766322244138
        arg[1, 3, 3]=-0.7836571975*x[0]+(0.453829711885)*x[1]
        ref[1, 3, 3, 0]=-0.7836571975
        ref[1, 3, 3, 1]=0.453829711885
        arg[2, 0, 0]=-0.679609328897*x[0]+(-0.138183927062)*x[1]
        ref[2, 0, 0, 0]=-0.679609328897
        ref[2, 0, 0, 1]=-0.138183927062
        arg[2, 0, 1]=-0.00153575789257*x[0]+(0.0300295333486)*x[1]
        ref[2, 0, 1, 0]=-0.00153575789257
        ref[2, 0, 1, 1]=0.0300295333486
        arg[2, 0, 2]=-0.060488272834*x[0]+(-0.0995864156852)*x[1]
        ref[2, 0, 2, 0]=-0.060488272834
        ref[2, 0, 2, 1]=-0.0995864156852
        arg[2, 0, 3]=0.40951711179*x[0]+(0.853803455453)*x[1]
        ref[2, 0, 3, 0]=0.40951711179
        ref[2, 0, 3, 1]=0.853803455453
        arg[2, 1, 0]=-0.443035108917*x[0]+(0.0845644772221)*x[1]
        ref[2, 1, 0, 0]=-0.443035108917
        ref[2, 1, 0, 1]=0.0845644772221
        arg[2, 1, 1]=0.650501059834*x[0]+(-0.389894162454)*x[1]
        ref[2, 1, 1, 0]=0.650501059834
        ref[2, 1, 1, 1]=-0.389894162454
        arg[2, 1, 2]=-0.447741541709*x[0]+(-0.182644396299)*x[1]
        ref[2, 1, 2, 0]=-0.447741541709
        ref[2, 1, 2, 1]=-0.182644396299
        arg[2, 1, 3]=-0.327762787774*x[0]+(0.535781871304)*x[1]
        ref[2, 1, 3, 0]=-0.327762787774
        ref[2, 1, 3, 1]=0.535781871304
        arg[2, 2, 0]=0.620325798231*x[0]+(-0.202286963948)*x[1]
        ref[2, 2, 0, 0]=0.620325798231
        ref[2, 2, 0, 1]=-0.202286963948
        arg[2, 2, 1]=0.0761876683671*x[0]+(-0.744668125784)*x[1]
        ref[2, 2, 1, 0]=0.0761876683671
        ref[2, 2, 1, 1]=-0.744668125784
        arg[2, 2, 2]=-0.543746282477*x[0]+(-0.349405255019)*x[1]
        ref[2, 2, 2, 0]=-0.543746282477
        ref[2, 2, 2, 1]=-0.349405255019
        arg[2, 2, 3]=-0.157949165669*x[0]+(-0.311031562031)*x[1]
        ref[2, 2, 3, 0]=-0.157949165669
        ref[2, 2, 3, 1]=-0.311031562031
        arg[2, 3, 0]=-0.0269987446522*x[0]+(-0.459942346509)*x[1]
        ref[2, 3, 0, 0]=-0.0269987446522
        ref[2, 3, 0, 1]=-0.459942346509
        arg[2, 3, 1]=-0.465285372077*x[0]+(-0.56766263336)*x[1]
        ref[2, 3, 1, 0]=-0.465285372077
        ref[2, 3, 1, 1]=-0.56766263336
        arg[2, 3, 2]=0.0178217317622*x[0]+(0.557416148997)*x[1]
        ref[2, 3, 2, 0]=0.0178217317622
        ref[2, 3, 2, 1]=0.557416148997
        arg[2, 3, 3]=0.953712295956*x[0]+(0.944174199137)*x[1]
        ref[2, 3, 3, 0]=0.953712295956
        ref[2, 3, 3, 1]=0.944174199137
        if dim==3:
            arg[0, 0, 0]+=0.114089839669*x[2]
            ref[0, 0, 0, 2]=0.114089839669
            arg[0, 0, 1]+=0.213925568899*x[2]
            ref[0, 0, 1, 2]=0.213925568899
            arg[0, 0, 2]+=0.112138871618*x[2]
            ref[0, 0, 2, 2]=0.112138871618
            arg[0, 0, 3]+=-0.108083352361*x[2]
            ref[0, 0, 3, 2]=-0.108083352361
            arg[0, 1, 0]+=-0.449154764502*x[2]
            ref[0, 1, 0, 2]=-0.449154764502
            arg[0, 1, 1]+=0.792386025396*x[2]
            ref[0, 1, 1, 2]=0.792386025396
            arg[0, 1, 2]+=-0.713531364889*x[2]
            ref[0, 1, 2, 2]=-0.713531364889
            arg[0, 1, 3]+=0.751726440362*x[2]
            ref[0, 1, 3, 2]=0.751726440362
            arg[0, 2, 0]+=0.863538887587*x[2]
            ref[0, 2, 0, 2]=0.863538887587
            arg[0, 2, 1]+=0.585426543963*x[2]
            ref[0, 2, 1, 2]=0.585426543963
            arg[0, 2, 2]+=-0.287784302353*x[2]
            ref[0, 2, 2, 2]=-0.287784302353
            arg[0, 2, 3]+=0.214870899533*x[2]
            ref[0, 2, 3, 2]=0.214870899533
            arg[0, 3, 0]+=0.56064479006*x[2]
            ref[0, 3, 0, 2]=0.56064479006
            arg[0, 3, 1]+=0.017222971673*x[2]
            ref[0, 3, 1, 2]=0.017222971673
            arg[0, 3, 2]+=-0.444736168237*x[2]
            ref[0, 3, 2, 2]=-0.444736168237
            arg[0, 3, 3]+=0.68256608579*x[2]
            ref[0, 3, 3, 2]=0.68256608579
            arg[1, 0, 0]+=0.395555351897*x[2]
            ref[1, 0, 0, 2]=0.395555351897
            arg[1, 0, 1]+=-0.751519845712*x[2]
            ref[1, 0, 1, 2]=-0.751519845712
            arg[1, 0, 2]+=0.863130792942*x[2]
            ref[1, 0, 2, 2]=0.863130792942
            arg[1, 0, 3]+=0.355320604074*x[2]
            ref[1, 0, 3, 2]=0.355320604074
            arg[1, 1, 0]+=-0.902306087969*x[2]
            ref[1, 1, 0, 2]=-0.902306087969
            arg[1, 1, 1]+=0.428546984457*x[2]
            ref[1, 1, 1, 2]=0.428546984457
            arg[1, 1, 2]+=-0.0773728147124*x[2]
            ref[1, 1, 2, 2]=-0.0773728147124
            arg[1, 1, 3]+=0.558674673393*x[2]
            ref[1, 1, 3, 2]=0.558674673393
            arg[1, 2, 0]+=-0.402665920057*x[2]
            ref[1, 2, 0, 2]=-0.402665920057
            arg[1, 2, 1]+=-0.778205136595*x[2]
            ref[1, 2, 1, 2]=-0.778205136595
            arg[1, 2, 2]+=-0.878069442535*x[2]
            ref[1, 2, 2, 2]=-0.878069442535
            arg[1, 2, 3]+=0.161572530415*x[2]
            ref[1, 2, 3, 2]=0.161572530415
            arg[1, 3, 0]+=-0.225943123912*x[2]
            ref[1, 3, 0, 2]=-0.225943123912
            arg[1, 3, 1]+=0.424124914331*x[2]
            ref[1, 3, 1, 2]=0.424124914331
            arg[1, 3, 2]+=0.449808405494*x[2]
            ref[1, 3, 2, 2]=0.449808405494
            arg[1, 3, 3]+=-0.888682168086*x[2]
            ref[1, 3, 3, 2]=-0.888682168086
            arg[2, 0, 0]+=-0.211271101499*x[2]
            ref[2, 0, 0, 2]=-0.211271101499
            arg[2, 0, 1]+=-0.830622438054*x[2]
            ref[2, 0, 1, 2]=-0.830622438054
            arg[2, 0, 2]+=0.471935036037*x[2]
            ref[2, 0, 2, 2]=0.471935036037
            arg[2, 0, 3]+=0.794656381695*x[2]
            ref[2, 0, 3, 2]=0.794656381695
            arg[2, 1, 0]+=0.754297549601*x[2]
            ref[2, 1, 0, 2]=0.754297549601
            arg[2, 1, 1]+=-0.984573092379*x[2]
            ref[2, 1, 1, 2]=-0.984573092379
            arg[2, 1, 2]+=-0.97450933437*x[2]
            ref[2, 1, 2, 2]=-0.97450933437
            arg[2, 1, 3]+=0.691331154158*x[2]
            ref[2, 1, 3, 2]=0.691331154158
            arg[2, 2, 0]+=-0.886253943391*x[2]
            ref[2, 2, 0, 2]=-0.886253943391
            arg[2, 2, 1]+=0.255699364477*x[2]
            ref[2, 2, 1, 2]=0.255699364477
            arg[2, 2, 2]+=-0.65276017437*x[2]
            ref[2, 2, 2, 2]=-0.65276017437
            arg[2, 2, 3]+=0.261471104256*x[2]
            ref[2, 2, 3, 2]=0.261471104256
            arg[2, 3, 0]+=0.555123750879*x[2]
            ref[2, 3, 0, 2]=0.555123750879
            arg[2, 3, 1]+=-0.493776533425*x[2]
            ref[2, 3, 1, 2]=-0.493776533425
            arg[2, 3, 2]+=-0.290119377253*x[2]
            ref[2, 3, 2, 2]=-0.290119377253
            arg[2, 3, 3]+=-0.0147632895648*x[2]
            ref[2, 3, 3, 2]=-0.0147632895648
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3, 4, 4)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onFunctionOnBoundary_fromData_ReducedContinuousFunction_rank0(self):
        """
        tests gradient of rank 0 Data on FunctionOnBoundary

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=-0.0601558040225*x[0]+(-0.397494727137)*x[1]
        ref[0]=-0.0601558040225
        ref[1]=-0.397494727137
        if dim==3:
            arg+=(0.0666565100163)*x[2]
            ref[2]=0.0666565100163
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onFunctionOnBoundary_fromData_ReducedContinuousFunction_rank1(self):
        """
        tests gradient of rank 1 Data on FunctionOnBoundary

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(2,),w)
        ref = Data(0,(2,)+(dim,),w_ref)
        arg[0,]=0.177454285459*x[0]+(0.992533962996)*x[1]
        ref[0, 0]=0.177454285459
        ref[0, 1]=0.992533962996
        arg[1,]=0.367762784884*x[0]+(0.378467034311)*x[1]
        ref[1, 0]=0.367762784884
        ref[1, 1]=0.378467034311
        if dim==3:
            arg[0,]+=0.534053347196*x[2]
            ref[0, 2]=0.534053347196
            arg[1,]+=0.875837330609*x[2]
            ref[1, 2]=0.875837330609
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(2,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onFunctionOnBoundary_fromData_ReducedContinuousFunction_rank2(self):
        """
        tests gradient of rank 2 Data on FunctionOnBoundary

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(3, 3),w)
        ref = Data(0,(3, 3)+(dim,),w_ref)
        arg[0, 0]=-0.0738312768866*x[0]+(-0.763368600261)*x[1]
        ref[0, 0, 0]=-0.0738312768866
        ref[0, 0, 1]=-0.763368600261
        arg[0, 1]=-0.903945384869*x[0]+(-0.293140877156)*x[1]
        ref[0, 1, 0]=-0.903945384869
        ref[0, 1, 1]=-0.293140877156
        arg[0, 2]=0.45446030802*x[0]+(-0.445407767799)*x[1]
        ref[0, 2, 0]=0.45446030802
        ref[0, 2, 1]=-0.445407767799
        arg[1, 0]=-0.533715429686*x[0]+(-0.464677354867)*x[1]
        ref[1, 0, 0]=-0.533715429686
        ref[1, 0, 1]=-0.464677354867
        arg[1, 1]=0.760642911331*x[0]+(0.114249453846)*x[1]
        ref[1, 1, 0]=0.760642911331
        ref[1, 1, 1]=0.114249453846
        arg[1, 2]=-0.240274767116*x[0]+(-0.538775789057)*x[1]
        ref[1, 2, 0]=-0.240274767116
        ref[1, 2, 1]=-0.538775789057
        arg[2, 0]=0.451825083663*x[0]+(-0.10702609221)*x[1]
        ref[2, 0, 0]=0.451825083663
        ref[2, 0, 1]=-0.10702609221
        arg[2, 1]=-0.627239184885*x[0]+(-0.826104506453)*x[1]
        ref[2, 1, 0]=-0.627239184885
        ref[2, 1, 1]=-0.826104506453
        arg[2, 2]=0.761408499345*x[0]+(-0.917588055604)*x[1]
        ref[2, 2, 0]=0.761408499345
        ref[2, 2, 1]=-0.917588055604
        if dim==3:
            arg[0, 0]+=-0.403222239072*x[2]
            ref[0, 0, 2]=-0.403222239072
            arg[0, 1]+=0.649017201181*x[2]
            ref[0, 1, 2]=0.649017201181
            arg[0, 2]+=-0.233873501336*x[2]
            ref[0, 2, 2]=-0.233873501336
            arg[1, 0]+=-0.45052689362*x[2]
            ref[1, 0, 2]=-0.45052689362
            arg[1, 1]+=0.452454798139*x[2]
            ref[1, 1, 2]=0.452454798139
            arg[1, 2]+=0.411061950458*x[2]
            ref[1, 2, 2]=0.411061950458
            arg[2, 0]+=-0.129094903646*x[2]
            ref[2, 0, 2]=-0.129094903646
            arg[2, 1]+=-0.922353929347*x[2]
            ref[2, 1, 2]=-0.922353929347
            arg[2, 2]+=-0.862073746792*x[2]
            ref[2, 2, 2]=-0.862073746792
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3, 3)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onFunctionOnBoundary_fromData_ReducedContinuousFunction_rank3(self):
        """
        tests gradient of rank 3 Data on FunctionOnBoundary

        assumptions: ReducedContinuousFunction(self.domain) exists
                     self.domain supports gradient on FunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = FunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ReducedContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(4, 3, 4),w)
        ref = Data(0,(4, 3, 4)+(dim,),w_ref)
        arg[0, 0, 0]=0.379458562876*x[0]+(-0.958535103688)*x[1]
        ref[0, 0, 0, 0]=0.379458562876
        ref[0, 0, 0, 1]=-0.958535103688
        arg[0, 0, 1]=0.926407979389*x[0]+(-0.522856783667)*x[1]
        ref[0, 0, 1, 0]=0.926407979389
        ref[0, 0, 1, 1]=-0.522856783667
        arg[0, 0, 2]=-0.548742215126*x[0]+(0.0708774409098)*x[1]
        ref[0, 0, 2, 0]=-0.548742215126
        ref[0, 0, 2, 1]=0.0708774409098
        arg[0, 0, 3]=-0.920835531365*x[0]+(0.993573096959)*x[1]
        ref[0, 0, 3, 0]=-0.920835531365
        ref[0, 0, 3, 1]=0.993573096959
        arg[0, 1, 0]=-0.14759540662*x[0]+(-0.538877043308)*x[1]
        ref[0, 1, 0, 0]=-0.14759540662
        ref[0, 1, 0, 1]=-0.538877043308
        arg[0, 1, 1]=0.668038715449*x[0]+(-0.471106017901)*x[1]
        ref[0, 1, 1, 0]=0.668038715449
        ref[0, 1, 1, 1]=-0.471106017901
        arg[0, 1, 2]=0.694873701686*x[0]+(-0.515354689672)*x[1]
        ref[0, 1, 2, 0]=0.694873701686
        ref[0, 1, 2, 1]=-0.515354689672
        arg[0, 1, 3]=0.846617352682*x[0]+(0.750229627377)*x[1]
        ref[0, 1, 3, 0]=0.846617352682
        ref[0, 1, 3, 1]=0.750229627377
        arg[0, 2, 0]=-0.41469523515*x[0]+(-0.369341696823)*x[1]
        ref[0, 2, 0, 0]=-0.41469523515
        ref[0, 2, 0, 1]=-0.369341696823
        arg[0, 2, 1]=0.530267245762*x[0]+(0.494713177846)*x[1]
        ref[0, 2, 1, 0]=0.530267245762
        ref[0, 2, 1, 1]=0.494713177846
        arg[0, 2, 2]=0.368244470145*x[0]+(-0.297179133478)*x[1]
        ref[0, 2, 2, 0]=0.368244470145
        ref[0, 2, 2, 1]=-0.297179133478
        arg[0, 2, 3]=0.940131707496*x[0]+(0.949129559156)*x[1]
        ref[0, 2, 3, 0]=0.940131707496
        ref[0, 2, 3, 1]=0.949129559156
        arg[1, 0, 0]=0.994653685626*x[0]+(-0.753447776024)*x[1]
        ref[1, 0, 0, 0]=0.994653685626
        ref[1, 0, 0, 1]=-0.753447776024
        arg[1, 0, 1]=-0.222696369254*x[0]+(-0.848052078996)*x[1]
        ref[1, 0, 1, 0]=-0.222696369254
        ref[1, 0, 1, 1]=-0.848052078996
        arg[1, 0, 2]=0.615097691748*x[0]+(-0.00406987356212)*x[1]
        ref[1, 0, 2, 0]=0.615097691748
        ref[1, 0, 2, 1]=-0.00406987356212
        arg[1, 0, 3]=-0.745135283943*x[0]+(0.835830705858)*x[1]
        ref[1, 0, 3, 0]=-0.745135283943
        ref[1, 0, 3, 1]=0.835830705858
        arg[1, 1, 0]=-0.991532072675*x[0]+(-0.162954903585)*x[1]
        ref[1, 1, 0, 0]=-0.991532072675
        ref[1, 1, 0, 1]=-0.162954903585
        arg[1, 1, 1]=0.371841734658*x[0]+(-0.876016077372)*x[1]
        ref[1, 1, 1, 0]=0.371841734658
        ref[1, 1, 1, 1]=-0.876016077372
        arg[1, 1, 2]=-0.922309502585*x[0]+(0.481954789732)*x[1]
        ref[1, 1, 2, 0]=-0.922309502585
        ref[1, 1, 2, 1]=0.481954789732
        arg[1, 1, 3]=0.214194335601*x[0]+(0.618986418208)*x[1]
        ref[1, 1, 3, 0]=0.214194335601
        ref[1, 1, 3, 1]=0.618986418208
        arg[1, 2, 0]=-0.392598888816*x[0]+(-0.275278388557)*x[1]
        ref[1, 2, 0, 0]=-0.392598888816
        ref[1, 2, 0, 1]=-0.275278388557
        arg[1, 2, 1]=-0.636907630692*x[0]+(-0.77704587733)*x[1]
        ref[1, 2, 1, 0]=-0.636907630692
        ref[1, 2, 1, 1]=-0.77704587733
        arg[1, 2, 2]=0.96677035281*x[0]+(-0.795500930365)*x[1]
        ref[1, 2, 2, 0]=0.96677035281
        ref[1, 2, 2, 1]=-0.795500930365
        arg[1, 2, 3]=0.15271150112*x[0]+(-0.711011386671)*x[1]
        ref[1, 2, 3, 0]=0.15271150112
        ref[1, 2, 3, 1]=-0.711011386671
        arg[2, 0, 0]=0.713060570864*x[0]+(-0.629828009615)*x[1]
        ref[2, 0, 0, 0]=0.713060570864
        ref[2, 0, 0, 1]=-0.629828009615
        arg[2, 0, 1]=-0.936517933183*x[0]+(0.818410077785)*x[1]
        ref[2, 0, 1, 0]=-0.936517933183
        ref[2, 0, 1, 1]=0.818410077785
        arg[2, 0, 2]=0.22907161174*x[0]+(-0.724485312558)*x[1]
        ref[2, 0, 2, 0]=0.22907161174
        ref[2, 0, 2, 1]=-0.724485312558
        arg[2, 0, 3]=0.779237230436*x[0]+(0.47662048081)*x[1]
        ref[2, 0, 3, 0]=0.779237230436
        ref[2, 0, 3, 1]=0.47662048081
        arg[2, 1, 0]=-0.744897758982*x[0]+(-0.671192302261)*x[1]
        ref[2, 1, 0, 0]=-0.744897758982
        ref[2, 1, 0, 1]=-0.671192302261
        arg[2, 1, 1]=-0.372142036896*x[0]+(-0.517894092164)*x[1]
        ref[2, 1, 1, 0]=-0.372142036896
        ref[2, 1, 1, 1]=-0.517894092164
        arg[2, 1, 2]=0.0261240202948*x[0]+(0.639438323428)*x[1]
        ref[2, 1, 2, 0]=0.0261240202948
        ref[2, 1, 2, 1]=0.639438323428
        arg[2, 1, 3]=0.939077408199*x[0]+(0.834677726343)*x[1]
        ref[2, 1, 3, 0]=0.939077408199
        ref[2, 1, 3, 1]=0.834677726343
        arg[2, 2, 0]=-0.333842475646*x[0]+(-0.0392074897955)*x[1]
        ref[2, 2, 0, 0]=-0.333842475646
        ref[2, 2, 0, 1]=-0.0392074897955
        arg[2, 2, 1]=-0.936015259767*x[0]+(-0.990388320532)*x[1]
        ref[2, 2, 1, 0]=-0.936015259767
        ref[2, 2, 1, 1]=-0.990388320532
        arg[2, 2, 2]=-0.940471094157*x[0]+(-0.946609624311)*x[1]
        ref[2, 2, 2, 0]=-0.940471094157
        ref[2, 2, 2, 1]=-0.946609624311
        arg[2, 2, 3]=0.698464033945*x[0]+(0.36014888056)*x[1]
        ref[2, 2, 3, 0]=0.698464033945
        ref[2, 2, 3, 1]=0.36014888056
        arg[3, 0, 0]=0.387202280238*x[0]+(-0.0226366249627)*x[1]
        ref[3, 0, 0, 0]=0.387202280238
        ref[3, 0, 0, 1]=-0.0226366249627
        arg[3, 0, 1]=0.468524660457*x[0]+(0.846912578148)*x[1]
        ref[3, 0, 1, 0]=0.468524660457
        ref[3, 0, 1, 1]=0.846912578148
        arg[3, 0, 2]=-0.245687094138*x[0]+(0.00572724736656)*x[1]
        ref[3, 0, 2, 0]=-0.245687094138
        ref[3, 0, 2, 1]=0.00572724736656
        arg[3, 0, 3]=0.717422363732*x[0]+(0.76795851425)*x[1]
        ref[3, 0, 3, 0]=0.717422363732
        ref[3, 0, 3, 1]=0.76795851425
        arg[3, 1, 0]=0.597973711876*x[0]+(0.963501080843)*x[1]
        ref[3, 1, 0, 0]=0.597973711876
        ref[3, 1, 0, 1]=0.963501080843
        arg[3, 1, 1]=0.146003877191*x[0]+(-0.869544026305)*x[1]
        ref[3, 1, 1, 0]=0.146003877191
        ref[3, 1, 1, 1]=-0.869544026305
        arg[3, 1, 2]=0.794969561088*x[0]+(0.123806083488)*x[1]
        ref[3, 1, 2, 0]=0.794969561088
        ref[3, 1, 2, 1]=0.123806083488
        arg[3, 1, 3]=0.363764558424*x[0]+(0.105564073384)*x[1]
        ref[3, 1, 3, 0]=0.363764558424
        ref[3, 1, 3, 1]=0.105564073384
        arg[3, 2, 0]=0.12810439635*x[0]+(-0.583526572465)*x[1]
        ref[3, 2, 0, 0]=0.12810439635
        ref[3, 2, 0, 1]=-0.583526572465
        arg[3, 2, 1]=0.14501837942*x[0]+(-0.739785883127)*x[1]
        ref[3, 2, 1, 0]=0.14501837942
        ref[3, 2, 1, 1]=-0.739785883127
        arg[3, 2, 2]=0.653894417968*x[0]+(0.309361818477)*x[1]
        ref[3, 2, 2, 0]=0.653894417968
        ref[3, 2, 2, 1]=0.309361818477
        arg[3, 2, 3]=0.375555031336*x[0]+(-0.405074127566)*x[1]
        ref[3, 2, 3, 0]=0.375555031336
        ref[3, 2, 3, 1]=-0.405074127566
        if dim==3:
            arg[0, 0, 0]+=-0.563073156496*x[2]
            ref[0, 0, 0, 2]=-0.563073156496
            arg[0, 0, 1]+=0.885795699351*x[2]
            ref[0, 0, 1, 2]=0.885795699351
            arg[0, 0, 2]+=-0.853513880466*x[2]
            ref[0, 0, 2, 2]=-0.853513880466
            arg[0, 0, 3]+=0.195208232054*x[2]
            ref[0, 0, 3, 2]=0.195208232054
            arg[0, 1, 0]+=0.566052910323*x[2]
            ref[0, 1, 0, 2]=0.566052910323
            arg[0, 1, 1]+=-0.470847348064*x[2]
            ref[0, 1, 1, 2]=-0.470847348064
            arg[0, 1, 2]+=-0.880190205329*x[2]
            ref[0, 1, 2, 2]=-0.880190205329
            arg[0, 1, 3]+=0.63747370374*x[2]
            ref[0, 1, 3, 2]=0.63747370374
            arg[0, 2, 0]+=-0.969252193985*x[2]
            ref[0, 2, 0, 2]=-0.969252193985
            arg[0, 2, 1]+=-0.261727988825*x[2]
            ref[0, 2, 1, 2]=-0.261727988825
            arg[0, 2, 2]+=0.184162835891*x[2]
            ref[0, 2, 2, 2]=0.184162835891
            arg[0, 2, 3]+=-0.875914350654*x[2]
            ref[0, 2, 3, 2]=-0.875914350654
            arg[1, 0, 0]+=-0.700000351505*x[2]
            ref[1, 0, 0, 2]=-0.700000351505
            arg[1, 0, 1]+=-0.94181504572*x[2]
            ref[1, 0, 1, 2]=-0.94181504572
            arg[1, 0, 2]+=-0.450072901448*x[2]
            ref[1, 0, 2, 2]=-0.450072901448
            arg[1, 0, 3]+=-0.913460982874*x[2]
            ref[1, 0, 3, 2]=-0.913460982874
            arg[1, 1, 0]+=0.849663000152*x[2]
            ref[1, 1, 0, 2]=0.849663000152
            arg[1, 1, 1]+=-0.0977336848529*x[2]
            ref[1, 1, 1, 2]=-0.0977336848529
            arg[1, 1, 2]+=0.503440388641*x[2]
            ref[1, 1, 2, 2]=0.503440388641
            arg[1, 1, 3]+=-0.731919802099*x[2]
            ref[1, 1, 3, 2]=-0.731919802099
            arg[1, 2, 0]+=-0.0045007740045*x[2]
            ref[1, 2, 0, 2]=-0.0045007740045
            arg[1, 2, 1]+=0.934148295682*x[2]
            ref[1, 2, 1, 2]=0.934148295682
            arg[1, 2, 2]+=0.653291500113*x[2]
            ref[1, 2, 2, 2]=0.653291500113
            arg[1, 2, 3]+=-0.479263004612*x[2]
            ref[1, 2, 3, 2]=-0.479263004612
            arg[2, 0, 0]+=-0.15781033089*x[2]
            ref[2, 0, 0, 2]=-0.15781033089
            arg[2, 0, 1]+=0.738821013142*x[2]
            ref[2, 0, 1, 2]=0.738821013142
            arg[2, 0, 2]+=-0.454028071709*x[2]
            ref[2, 0, 2, 2]=-0.454028071709
            arg[2, 0, 3]+=-0.536674115871*x[2]
            ref[2, 0, 3, 2]=-0.536674115871
            arg[2, 1, 0]+=0.584024619969*x[2]
            ref[2, 1, 0, 2]=0.584024619969
            arg[2, 1, 1]+=0.711669125977*x[2]
            ref[2, 1, 1, 2]=0.711669125977
            arg[2, 1, 2]+=-0.843783162489*x[2]
            ref[2, 1, 2, 2]=-0.843783162489
            arg[2, 1, 3]+=-0.999974816387*x[2]
            ref[2, 1, 3, 2]=-0.999974816387
            arg[2, 2, 0]+=-0.318365665792*x[2]
            ref[2, 2, 0, 2]=-0.318365665792
            arg[2, 2, 1]+=-0.224913215206*x[2]
            ref[2, 2, 1, 2]=-0.224913215206
            arg[2, 2, 2]+=-0.591523938658*x[2]
            ref[2, 2, 2, 2]=-0.591523938658
            arg[2, 2, 3]+=-0.472939079893*x[2]
            ref[2, 2, 3, 2]=-0.472939079893
            arg[3, 0, 0]+=0.39584063248*x[2]
            ref[3, 0, 0, 2]=0.39584063248
            arg[3, 0, 1]+=-0.0499937991492*x[2]
            ref[3, 0, 1, 2]=-0.0499937991492
            arg[3, 0, 2]+=-0.174430563659*x[2]
            ref[3, 0, 2, 2]=-0.174430563659
            arg[3, 0, 3]+=-0.972227349307*x[2]
            ref[3, 0, 3, 2]=-0.972227349307
            arg[3, 1, 0]+=0.303983199754*x[2]
            ref[3, 1, 0, 2]=0.303983199754
            arg[3, 1, 1]+=0.272867972539*x[2]
            ref[3, 1, 1, 2]=0.272867972539
            arg[3, 1, 2]+=-0.759222403303*x[2]
            ref[3, 1, 2, 2]=-0.759222403303
            arg[3, 1, 3]+=0.22527602324*x[2]
            ref[3, 1, 3, 2]=0.22527602324
            arg[3, 2, 0]+=-0.443873381508*x[2]
            ref[3, 2, 0, 2]=-0.443873381508
            arg[3, 2, 1]+=0.378256272572*x[2]
            ref[3, 2, 1, 2]=0.378256272572
            arg[3, 2, 2]+=-0.999518391365*x[2]
            ref[3, 2, 2, 2]=-0.999518391365
            arg[3, 2, 3]+=0.803609692815*x[2]
            ref[3, 2, 3, 2]=0.803609692815
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4, 3, 4)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onReducedFunctionOnBoundary_fromData_ContinuousFunction_rank0(self):
        """
        tests gradient of rank 0 Data on ReducedFunctionOnBoundary

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(),w)
        ref = Data(0,()+(dim,),w_ref)
        arg=0.343551132995*x[0]**o+(-0.575567088698)*x[0]+(-0.761242668552)*x[1]**o+(-0.40460308283)*x[1]
        ref[0]=0.343551132995*o*x_ref[0]**(o-1)+(-0.575567088698)
        ref[1]=-0.761242668552*o*x_ref[1]**(o-1)+(-0.40460308283)
        if dim==3:
            arg+=(-0.0911753834201)*x[2]**o+(0.401965038351)*x[2]
            ref[2]=-0.0911753834201*o*x_ref[2]**(o-1)+(0.401965038351)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),()+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onReducedFunctionOnBoundary_fromData_ContinuousFunction_rank1(self):
        """
        tests gradient of rank 1 Data on ReducedFunctionOnBoundary

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(4,),w)
        ref = Data(0,(4,)+(dim,),w_ref)
        arg[0,]=-0.374852418779*x[0]**o+(-0.794585992923)*x[0]+(-0.368018259459)*x[1]**o+(-0.108126793531)*x[1]
        ref[0, 0]=-0.374852418779*o*x_ref[0]**(o-1)+(-0.794585992923)
        ref[0, 1]=-0.368018259459*o*x_ref[1]**(o-1)+(-0.108126793531)
        arg[1,]=-0.146459440493*x[0]**o+(-0.1268204543)*x[0]+(0.853850364896)*x[1]**o+(-0.450594275174)*x[1]
        ref[1, 0]=-0.146459440493*o*x_ref[0]**(o-1)+(-0.1268204543)
        ref[1, 1]=0.853850364896*o*x_ref[1]**(o-1)+(-0.450594275174)
        arg[2,]=-0.792313729776*x[0]**o+(-0.97050665917)*x[0]+(-0.851925260299)*x[1]**o+(0.56435656635)*x[1]
        ref[2, 0]=-0.792313729776*o*x_ref[0]**(o-1)+(-0.97050665917)
        ref[2, 1]=-0.851925260299*o*x_ref[1]**(o-1)+(0.56435656635)
        arg[3,]=0.209387836604*x[0]**o+(-0.0875212341261)*x[0]+(0.127408360582)*x[1]**o+(-0.514864284723)*x[1]
        ref[3, 0]=0.209387836604*o*x_ref[0]**(o-1)+(-0.0875212341261)
        ref[3, 1]=0.127408360582*o*x_ref[1]**(o-1)+(-0.514864284723)
        if dim==3:
            arg[0,]+=0.868433237157*x[2]**o+(-0.902685783924)*x[2]
            ref[0, 2]=0.868433237157*o*x_ref[2]**(o-1)+(-0.902685783924)
            arg[1,]+=0.718009528134*x[2]**o+(0.984030552569)*x[2]
            ref[1, 2]=0.718009528134*o*x_ref[2]**(o-1)+(0.984030552569)
            arg[2,]+=0.841643506934*x[2]**o+(0.632454709643)*x[2]
            ref[2, 2]=0.841643506934*o*x_ref[2]**(o-1)+(0.632454709643)
            arg[3,]+=0.222109256325*x[2]**o+(0.363947934888)*x[2]
            ref[3, 2]=0.222109256325*o*x_ref[2]**(o-1)+(0.363947934888)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4,)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onReducedFunctionOnBoundary_fromData_ContinuousFunction_rank2(self):
        """
        tests gradient of rank 2 Data on ReducedFunctionOnBoundary

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(3, 2),w)
        ref = Data(0,(3, 2)+(dim,),w_ref)
        arg[0, 0]=0.204039941822*x[0]**o+(-0.44300583924)*x[0]+(-0.365232788045)*x[1]**o+(0.428316620611)*x[1]
        ref[0, 0, 0]=0.204039941822*o*x_ref[0]**(o-1)+(-0.44300583924)
        ref[0, 0, 1]=-0.365232788045*o*x_ref[1]**(o-1)+(0.428316620611)
        arg[0, 1]=0.31095993463*x[0]**o+(0.598236945024)*x[0]+(0.646057477302)*x[1]**o+(0.340327151269)*x[1]
        ref[0, 1, 0]=0.31095993463*o*x_ref[0]**(o-1)+(0.598236945024)
        ref[0, 1, 1]=0.646057477302*o*x_ref[1]**(o-1)+(0.340327151269)
        arg[1, 0]=-0.532887405787*x[0]**o+(-0.549743223467)*x[0]+(0.404280060172)*x[1]**o+(-0.964954629799)*x[1]
        ref[1, 0, 0]=-0.532887405787*o*x_ref[0]**(o-1)+(-0.549743223467)
        ref[1, 0, 1]=0.404280060172*o*x_ref[1]**(o-1)+(-0.964954629799)
        arg[1, 1]=-0.84684040446*x[0]**o+(0.984516318766)*x[0]+(-0.288889417126)*x[1]**o+(-0.126791900274)*x[1]
        ref[1, 1, 0]=-0.84684040446*o*x_ref[0]**(o-1)+(0.984516318766)
        ref[1, 1, 1]=-0.288889417126*o*x_ref[1]**(o-1)+(-0.126791900274)
        arg[2, 0]=0.842930084432*x[0]**o+(0.000847353485426)*x[0]+(-0.770029745351)*x[1]**o+(0.0502876050681)*x[1]
        ref[2, 0, 0]=0.842930084432*o*x_ref[0]**(o-1)+(0.000847353485426)
        ref[2, 0, 1]=-0.770029745351*o*x_ref[1]**(o-1)+(0.0502876050681)
        arg[2, 1]=0.5854037193*x[0]**o+(0.464462365315)*x[0]+(-0.333705958468)*x[1]**o+(-0.543474795793)*x[1]
        ref[2, 1, 0]=0.5854037193*o*x_ref[0]**(o-1)+(0.464462365315)
        ref[2, 1, 1]=-0.333705958468*o*x_ref[1]**(o-1)+(-0.543474795793)
        if dim==3:
            arg[0, 0]+=0.613135040819*x[2]**o+(0.0538649862075)*x[2]
            ref[0, 0, 2]=0.613135040819*o*x_ref[2]**(o-1)+(0.0538649862075)
            arg[0, 1]+=0.861051840693*x[2]**o+(0.269730899337)*x[2]
            ref[0, 1, 2]=0.861051840693*o*x_ref[2]**(o-1)+(0.269730899337)
            arg[1, 0]+=-0.524019532604*x[2]**o+(0.58921985248)*x[2]
            ref[1, 0, 2]=-0.524019532604*o*x_ref[2]**(o-1)+(0.58921985248)
            arg[1, 1]+=0.214350792413*x[2]**o+(0.752599676423)*x[2]
            ref[1, 1, 2]=0.214350792413*o*x_ref[2]**(o-1)+(0.752599676423)
            arg[2, 0]+=-0.370633814791*x[2]**o+(-0.646744295462)*x[2]
            ref[2, 0, 2]=-0.370633814791*o*x_ref[2]**(o-1)+(-0.646744295462)
            arg[2, 1]+=0.766560807091*x[2]**o+(-0.723559484414)*x[2]
            ref[2, 1, 2]=0.766560807091*o*x_ref[2]**(o-1)+(-0.723559484414)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(3, 2)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onReducedFunctionOnBoundary_fromData_ContinuousFunction_rank3(self):
        """
        tests gradient of rank 3 Data on ReducedFunctionOnBoundary

        assumptions: ContinuousFunction(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnBoundary(self.domain)
        x_ref = w_ref.getX()
        w = ContinuousFunction(self.domain)
        x = w.getX()
        arg = Data(0,(4, 3, 2),w)
        ref = Data(0,(4, 3, 2)+(dim,),w_ref)
        arg[0, 0, 0]=-0.572932041102*x[0]**o+(-0.201693261057)*x[0]+(-0.417046977785)*x[1]**o+(0.093959830832)*x[1]
        ref[0, 0, 0, 0]=-0.572932041102*o*x_ref[0]**(o-1)+(-0.201693261057)
        ref[0, 0, 0, 1]=-0.417046977785*o*x_ref[1]**(o-1)+(0.093959830832)
        arg[0, 0, 1]=-0.980911755091*x[0]**o+(-0.216814593961)*x[0]+(0.389999256692)*x[1]**o+(0.430950777469)*x[1]
        ref[0, 0, 1, 0]=-0.980911755091*o*x_ref[0]**(o-1)+(-0.216814593961)
        ref[0, 0, 1, 1]=0.389999256692*o*x_ref[1]**(o-1)+(0.430950777469)
        arg[0, 1, 0]=0.130974999942*x[0]**o+(-0.195414424503)*x[0]+(-0.806454723719)*x[1]**o+(0.346907274957)*x[1]
        ref[0, 1, 0, 0]=0.130974999942*o*x_ref[0]**(o-1)+(-0.195414424503)
        ref[0, 1, 0, 1]=-0.806454723719*o*x_ref[1]**(o-1)+(0.346907274957)
        arg[0, 1, 1]=0.750181116704*x[0]**o+(-0.0924437615757)*x[0]+(-0.939748369233)*x[1]**o+(-0.935119418921)*x[1]
        ref[0, 1, 1, 0]=0.750181116704*o*x_ref[0]**(o-1)+(-0.0924437615757)
        ref[0, 1, 1, 1]=-0.939748369233*o*x_ref[1]**(o-1)+(-0.935119418921)
        arg[0, 2, 0]=0.338262030288*x[0]**o+(0.270152263291)*x[0]+(0.312797596006)*x[1]**o+(-0.537579853708)*x[1]
        ref[0, 2, 0, 0]=0.338262030288*o*x_ref[0]**(o-1)+(0.270152263291)
        ref[0, 2, 0, 1]=0.312797596006*o*x_ref[1]**(o-1)+(-0.537579853708)
        arg[0, 2, 1]=-0.882891693982*x[0]**o+(0.632628509551)*x[0]+(-0.988782716655)*x[1]**o+(0.221891277864)*x[1]
        ref[0, 2, 1, 0]=-0.882891693982*o*x_ref[0]**(o-1)+(0.632628509551)
        ref[0, 2, 1, 1]=-0.988782716655*o*x_ref[1]**(o-1)+(0.221891277864)
        arg[1, 0, 0]=-0.0843288921046*x[0]**o+(0.459024076714)*x[0]+(0.0778146504085)*x[1]**o+(-0.69823752189)*x[1]
        ref[1, 0, 0, 0]=-0.0843288921046*o*x_ref[0]**(o-1)+(0.459024076714)
        ref[1, 0, 0, 1]=0.0778146504085*o*x_ref[1]**(o-1)+(-0.69823752189)
        arg[1, 0, 1]=0.331548529316*x[0]**o+(0.294902805428)*x[0]+(0.662254815768)*x[1]**o+(0.701446670345)*x[1]
        ref[1, 0, 1, 0]=0.331548529316*o*x_ref[0]**(o-1)+(0.294902805428)
        ref[1, 0, 1, 1]=0.662254815768*o*x_ref[1]**(o-1)+(0.701446670345)
        arg[1, 1, 0]=-0.763002687978*x[0]**o+(-0.671329135297)*x[0]+(-0.503363837405)*x[1]**o+(-0.764584720596)*x[1]
        ref[1, 1, 0, 0]=-0.763002687978*o*x_ref[0]**(o-1)+(-0.671329135297)
        ref[1, 1, 0, 1]=-0.503363837405*o*x_ref[1]**(o-1)+(-0.764584720596)
        arg[1, 1, 1]=-0.592859884586*x[0]**o+(-0.903888951796)*x[0]+(0.499853119995)*x[1]**o+(0.606364718074)*x[1]
        ref[1, 1, 1, 0]=-0.592859884586*o*x_ref[0]**(o-1)+(-0.903888951796)
        ref[1, 1, 1, 1]=0.499853119995*o*x_ref[1]**(o-1)+(0.606364718074)
        arg[1, 2, 0]=-0.492582240254*x[0]**o+(-0.777074897565)*x[0]+(-0.215653284249)*x[1]**o+(0.2124829569)*x[1]
        ref[1, 2, 0, 0]=-0.492582240254*o*x_ref[0]**(o-1)+(-0.777074897565)
        ref[1, 2, 0, 1]=-0.215653284249*o*x_ref[1]**(o-1)+(0.2124829569)
        arg[1, 2, 1]=-0.356387226515*x[0]**o+(-0.340341376721)*x[0]+(-0.858824936121)*x[1]**o+(0.725274427148)*x[1]
        ref[1, 2, 1, 0]=-0.356387226515*o*x_ref[0]**(o-1)+(-0.340341376721)
        ref[1, 2, 1, 1]=-0.858824936121*o*x_ref[1]**(o-1)+(0.725274427148)
        arg[2, 0, 0]=0.763635332519*x[0]**o+(0.229287881671)*x[0]+(0.427204326684)*x[1]**o+(-0.307640649528)*x[1]
        ref[2, 0, 0, 0]=0.763635332519*o*x_ref[0]**(o-1)+(0.229287881671)
        ref[2, 0, 0, 1]=0.427204326684*o*x_ref[1]**(o-1)+(-0.307640649528)
        arg[2, 0, 1]=0.695276807267*x[0]**o+(-0.459077978836)*x[0]+(-0.186332225366)*x[1]**o+(0.314547050148)*x[1]
        ref[2, 0, 1, 0]=0.695276807267*o*x_ref[0]**(o-1)+(-0.459077978836)
        ref[2, 0, 1, 1]=-0.186332225366*o*x_ref[1]**(o-1)+(0.314547050148)
        arg[2, 1, 0]=-0.399638637263*x[0]**o+(-0.310540453436)*x[0]+(0.806701806887)*x[1]**o+(-0.104372115534)*x[1]
        ref[2, 1, 0, 0]=-0.399638637263*o*x_ref[0]**(o-1)+(-0.310540453436)
        ref[2, 1, 0, 1]=0.806701806887*o*x_ref[1]**(o-1)+(-0.104372115534)
        arg[2, 1, 1]=-0.100549772791*x[0]**o+(0.282730603818)*x[0]+(0.389042408938)*x[1]**o+(-0.451516936753)*x[1]
        ref[2, 1, 1, 0]=-0.100549772791*o*x_ref[0]**(o-1)+(0.282730603818)
        ref[2, 1, 1, 1]=0.389042408938*o*x_ref[1]**(o-1)+(-0.451516936753)
        arg[2, 2, 0]=-0.72269012729*x[0]**o+(-0.591356363415)*x[0]+(-0.55840034044)*x[1]**o+(0.576173544101)*x[1]
        ref[2, 2, 0, 0]=-0.72269012729*o*x_ref[0]**(o-1)+(-0.591356363415)
        ref[2, 2, 0, 1]=-0.55840034044*o*x_ref[1]**(o-1)+(0.576173544101)
        arg[2, 2, 1]=0.45025492127*x[0]**o+(-0.00409207857738)*x[0]+(0.459565631229)*x[1]**o+(0.166490120148)*x[1]
        ref[2, 2, 1, 0]=0.45025492127*o*x_ref[0]**(o-1)+(-0.00409207857738)
        ref[2, 2, 1, 1]=0.459565631229*o*x_ref[1]**(o-1)+(0.166490120148)
        arg[3, 0, 0]=-0.303298534834*x[0]**o+(0.260671352813)*x[0]+(-0.43399717331)*x[1]**o+(0.526760273346)*x[1]
        ref[3, 0, 0, 0]=-0.303298534834*o*x_ref[0]**(o-1)+(0.260671352813)
        ref[3, 0, 0, 1]=-0.43399717331*o*x_ref[1]**(o-1)+(0.526760273346)
        arg[3, 0, 1]=-0.60515859546*x[0]**o+(-0.421292837119)*x[0]+(-0.319664907838)*x[1]**o+(-0.530657524636)*x[1]
        ref[3, 0, 1, 0]=-0.60515859546*o*x_ref[0]**(o-1)+(-0.421292837119)
        ref[3, 0, 1, 1]=-0.319664907838*o*x_ref[1]**(o-1)+(-0.530657524636)
        arg[3, 1, 0]=0.159560305658*x[0]**o+(-0.590512237052)*x[0]+(-0.339544444728)*x[1]**o+(-0.456814824575)*x[1]
        ref[3, 1, 0, 0]=0.159560305658*o*x_ref[0]**(o-1)+(-0.590512237052)
        ref[3, 1, 0, 1]=-0.339544444728*o*x_ref[1]**(o-1)+(-0.456814824575)
        arg[3, 1, 1]=-0.216137339533*x[0]**o+(-0.908149056067)*x[0]+(0.851471247283)*x[1]**o+(0.151864861976)*x[1]
        ref[3, 1, 1, 0]=-0.216137339533*o*x_ref[0]**(o-1)+(-0.908149056067)
        ref[3, 1, 1, 1]=0.851471247283*o*x_ref[1]**(o-1)+(0.151864861976)
        arg[3, 2, 0]=-0.697756709675*x[0]**o+(-0.605676080348)*x[0]+(0.380134809347)*x[1]**o+(-0.4939919008)*x[1]
        ref[3, 2, 0, 0]=-0.697756709675*o*x_ref[0]**(o-1)+(-0.605676080348)
        ref[3, 2, 0, 1]=0.380134809347*o*x_ref[1]**(o-1)+(-0.4939919008)
        arg[3, 2, 1]=0.451414114007*x[0]**o+(-0.455354664548)*x[0]+(-0.730825477513)*x[1]**o+(0.936671660271)*x[1]
        ref[3, 2, 1, 0]=0.451414114007*o*x_ref[0]**(o-1)+(-0.455354664548)
        ref[3, 2, 1, 1]=-0.730825477513*o*x_ref[1]**(o-1)+(0.936671660271)
        if dim==3:
            arg[0, 0, 0]+=0.788513067134*x[2]**o+(-0.823618707747)*x[2]
            ref[0, 0, 0, 2]=0.788513067134*o*x_ref[2]**(o-1)+(-0.823618707747)
            arg[0, 0, 1]+=-0.598992761178*x[2]**o+(-0.618228978033)*x[2]
            ref[0, 0, 1, 2]=-0.598992761178*o*x_ref[2]**(o-1)+(-0.618228978033)
            arg[0, 1, 0]+=-0.851235921052*x[2]**o+(-0.552231768935)*x[2]
            ref[0, 1, 0, 2]=-0.851235921052*o*x_ref[2]**(o-1)+(-0.552231768935)
            arg[0, 1, 1]+=0.133267292091*x[2]**o+(-0.946904897506)*x[2]
            ref[0, 1, 1, 2]=0.133267292091*o*x_ref[2]**(o-1)+(-0.946904897506)
            arg[0, 2, 0]+=0.27834957826*x[2]**o+(-0.576919411755)*x[2]
            ref[0, 2, 0, 2]=0.27834957826*o*x_ref[2]**(o-1)+(-0.576919411755)
            arg[0, 2, 1]+=-0.208126811531*x[2]**o+(-0.823664412179)*x[2]
            ref[0, 2, 1, 2]=-0.208126811531*o*x_ref[2]**(o-1)+(-0.823664412179)
            arg[1, 0, 0]+=0.372456348692*x[2]**o+(0.043038127891)*x[2]
            ref[1, 0, 0, 2]=0.372456348692*o*x_ref[2]**(o-1)+(0.043038127891)
            arg[1, 0, 1]+=0.870759123077*x[2]**o+(-0.546745391445)*x[2]
            ref[1, 0, 1, 2]=0.870759123077*o*x_ref[2]**(o-1)+(-0.546745391445)
            arg[1, 1, 0]+=0.357107936483*x[2]**o+(0.500138384655)*x[2]
            ref[1, 1, 0, 2]=0.357107936483*o*x_ref[2]**(o-1)+(0.500138384655)
            arg[1, 1, 1]+=-0.954334749025*x[2]**o+(0.24614344396)*x[2]
            ref[1, 1, 1, 2]=-0.954334749025*o*x_ref[2]**(o-1)+(0.24614344396)
            arg[1, 2, 0]+=-0.893161100509*x[2]**o+(-0.952795343909)*x[2]
            ref[1, 2, 0, 2]=-0.893161100509*o*x_ref[2]**(o-1)+(-0.952795343909)
            arg[1, 2, 1]+=-0.351420271775*x[2]**o+(-0.0567019836221)*x[2]
            ref[1, 2, 1, 2]=-0.351420271775*o*x_ref[2]**(o-1)+(-0.0567019836221)
            arg[2, 0, 0]+=-0.485519627785*x[2]**o+(-0.779830414409)*x[2]
            ref[2, 0, 0, 2]=-0.485519627785*o*x_ref[2]**(o-1)+(-0.779830414409)
            arg[2, 0, 1]+=0.597863316529*x[2]**o+(-0.711756498653)*x[2]
            ref[2, 0, 1, 2]=0.597863316529*o*x_ref[2]**(o-1)+(-0.711756498653)
            arg[2, 1, 0]+=-0.0289969144237*x[2]**o+(-0.180511855158)*x[2]
            ref[2, 1, 0, 2]=-0.0289969144237*o*x_ref[2]**(o-1)+(-0.180511855158)
            arg[2, 1, 1]+=0.844443217622*x[2]**o+(-0.595680483934)*x[2]
            ref[2, 1, 1, 2]=0.844443217622*o*x_ref[2]**(o-1)+(-0.595680483934)
            arg[2, 2, 0]+=-0.890161144413*x[2]**o+(0.410549971952)*x[2]
            ref[2, 2, 0, 2]=-0.890161144413*o*x_ref[2]**(o-1)+(0.410549971952)
            arg[2, 2, 1]+=0.0593427393622*x[2]**o+(-0.710738540825)*x[2]
            ref[2, 2, 1, 2]=0.0593427393622*o*x_ref[2]**(o-1)+(-0.710738540825)
            arg[3, 0, 0]+=-0.753840989544*x[2]**o+(0.0345445543035)*x[2]
            ref[3, 0, 0, 2]=-0.753840989544*o*x_ref[2]**(o-1)+(0.0345445543035)
            arg[3, 0, 1]+=-0.399902854152*x[2]**o+(0.608183881767)*x[2]
            ref[3, 0, 1, 2]=-0.399902854152*o*x_ref[2]**(o-1)+(0.608183881767)
            arg[3, 1, 0]+=0.149911796976*x[2]**o+(-0.0964613853676)*x[2]
            ref[3, 1, 0, 2]=0.149911796976*o*x_ref[2]**(o-1)+(-0.0964613853676)
            arg[3, 1, 1]+=-0.794172773392*x[2]**o+(-0.695198384444)*x[2]
            ref[3, 1, 1, 2]=-0.794172773392*o*x_ref[2]**(o-1)+(-0.695198384444)
            arg[3, 2, 0]+=-0.436844472898*x[2]**o+(-0.0794279663585)*x[2]
            ref[3, 2, 0, 2]=-0.436844472898*o*x_ref[2]**(o-1)+(-0.0794279663585)
            arg[3, 2, 1]+=0.604007024416*x[2]**o+(-0.270329764564)*x[2]
            ref[3, 2, 1, 2]=0.604007024416*o*x_ref[2]**(o-1)+(-0.270329764564)
        res=grad(arg,where=w_ref)
        self.assertTrue(isinstance(res,Data),'wrong type of result.')
        self.assertEqual(res.getFunctionSpace(),w_ref,'wrong function space of result.')
        self.assertEqual(res.getShape(),(4, 3, 2)+(dim,),'wrong shape of result.')
        self.assertLess(Lsup(res-ref),self.RES_TOL*Lsup(ref),'wrong result')
    #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    def test_grad_onReducedFunctionOnBoundary_fromData_Solution_rank0(self):
        """
        tests gradient of rank 0 Data on ReducedFunctionOnBoundary

        assumptions: Solution(self.domain) exists
                     self.domain supports gradient on ReducedFunctionOnBoundary
        """
        o = self.order
        dim = self.domain.getDim()
        w_ref = ReducedFunctionOnBo