//===-- Implementation of strfromd ------------------------------*- C++ -*-===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#include "src/stdlib/strfromd.h"
#include "src/__support/macros/config.h"
#include "src/stdlib/str_from_util.h"

namespace LIBC_NAMESPACE_DECL {

LLVM_LIBC_FUNCTION(int, strfromd,
                   (char *__restrict s, size_t n, const char *__restrict format,
                    double fp)) {
  LIBC_ASSERT(s != nullptr);

  printf_core::FormatSection section =
      internal::parse_format_string(format, fp);
  printf_core::WriteBuffer<printf_core::Mode<
      printf_core::WriteMode::FILL_BUFF_AND_DROP_OVERFLOW>::value>
      wb(s, (n > 0 ? n - 1 : 0));
  printf_core::Writer writer(wb);

  int result = 0;
  if (section.has_conv)
    result = internal::strfromfloat_convert<double>(&writer, section);
  else
    result = writer.write(section.raw_string);

  if (result < 0)
    return result;

  if (n > 0)
    wb.buff[wb.buff_cur] = '\0';

  return writer.get_chars_written();
}

} // namespace LIBC_NAMESPACE_DECL
