/* 
   Unix SMB/CIFS implementation.
   test suite for epmap ndr operations

   Copyright (C) Jelmer Vernooij 2007
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "includes.h"
#include "torture/ndr/ndr.h"
#include "librpc/gen_ndr/ndr_epmapper.h"
#include "torture/ndr/proto.h"

static const uint8_t map_in_data[] = {
  0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
  0x4b, 0x00, 0x00, 0x00, 0x4b, 0x00, 0x00, 0x00, 0x05, 0x00, 0x13, 0x00,
  0x0d, 0x78, 0x57, 0x34, 0x12, 0x34, 0x12, 0xcd, 0xab, 0xef, 0x00, 0x01,
  0x23, 0x45, 0x67, 0x89, 0xac, 0x01, 0x00, 0x02, 0x00, 0x00, 0x00, 0x13,
  0x00, 0x0d, 0x04, 0x5d, 0x88, 0x8a, 0xeb, 0x1c, 0xc9, 0x11, 0x9f, 0xe8,
  0x08, 0x00, 0x2b, 0x10, 0x48, 0x60, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x0b, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x07, 0x02, 0x00,
  0x00, 0x00, 0x01, 0x00, 0x09, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00
};

static bool map_in_check(struct torture_context *tctx, 
						 struct epm_Map *r)
{
	/* FIXME: Object */
	torture_assert_int_equal(tctx, r->in.max_towers, 1, "max towers");
	torture_assert(tctx, r->in.map_tower != NULL, "map tower");
	torture_assert_int_equal(tctx, r->in.map_tower->tower_length, 75, "tower len");
	/* FIXME: entry handle */

	return true;
}

static const uint8_t map_out_data[] = {
  0x00, 0x00, 0x00, 0x00, 0x18, 0xc3, 0x47, 0xdd, 0xe6, 0x5a, 0x8b, 0x42,
  0xb3, 0xb7, 0xc7, 0x79, 0x7b, 0xf0, 0x45, 0xe0, 0x01, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x05, 0x00, 0x00, 0x00, 0x4b, 0x00, 0x00, 0x00
};

static bool map_out_check(struct torture_context *tctx, 
						  struct epm_Map *r)
{
	torture_assert_int_equal(tctx, *r->out.num_towers, 1, "num towers");
	torture_assert_int_equal(tctx, r->out.result, 0x4b, "return code");
	/* FIXME: entry handle */

	return true;
}

struct torture_suite *ndr_epmap_suite(TALLOC_CTX *ctx)
{
	struct torture_suite *suite = torture_suite_create(ctx, "epmap");

	torture_suite_add_ndr_pull_fn_test(suite, epm_Map, map_in_data, NDR_IN, map_in_check );
	/* torture_suite_add_ndr_pull_fn_test(suite, epm_Map, map_out_data, NDR_OUT, map_out_check ); */

	return suite;
}

