#ifndef RADEON_DRM_PUBLIC_H
#define RADEON_DRM_PUBLIC_H

#include "pipe/p_defines.h"

struct r300_winsys_screen;

struct r300_winsys_screen *r300_drm_winsys_screen_create(int fd);

static INLINE boolean is_r3xx(int pciid)
{
      switch (pciid) {
      case 0x4144: /* PCI_CHIP_R300_AD */
      case 0x4145: /* PCI_CHIP_R300_AE */
      case 0x4146: /* PCI_CHIP_R300_AF */
      case 0x4147: /* PCI_CHIP_R300_AG */
      case 0x4E44: /* PCI_CHIP_R300_ND */
      case 0x4E45: /* PCI_CHIP_R300_NE */
      case 0x4E46: /* PCI_CHIP_R300_NF */
      case 0x4E47: /* PCI_CHIP_R300_NG */
      case 0x4E48: /* PCI_CHIP_R350_NH */
      case 0x4E49: /* PCI_CHIP_R350_NI */
      case 0x4E4B: /* PCI_CHIP_R350_NK */
      case 0x4148: /* PCI_CHIP_R350_AH */
      case 0x4149: /* PCI_CHIP_R350_AI */
      case 0x414A: /* PCI_CHIP_R350_AJ */
      case 0x414B: /* PCI_CHIP_R350_AK */
      case 0x4E4A: /* PCI_CHIP_R360_NJ */
      case 0x4150: /* PCI_CHIP_RV350_AP */
      case 0x4151: /* PCI_CHIP_RV350_AQ */
      case 0x4152: /* PCI_CHIP_RV350_AR */
      case 0x4153: /* PCI_CHIP_RV350_AS */
      case 0x4154: /* PCI_CHIP_RV350_AT */
      case 0x4155: /* PCI_CHIP_RV350_AU */
      case 0x4156: /* PCI_CHIP_RV350_AV */
      case 0x4E50: /* PCI_CHIP_RV350_NP */
      case 0x4E51: /* PCI_CHIP_RV350_NQ */
      case 0x4E52: /* PCI_CHIP_RV350_NR */
      case 0x4E53: /* PCI_CHIP_RV350_NS */
      case 0x4E54: /* PCI_CHIP_RV350_NT */
      case 0x4E56: /* PCI_CHIP_RV350_NV */
      case 0x5460: /* PCI_CHIP_RV370_5460 */
      case 0x5462: /* PCI_CHIP_RV370_5462 */
      case 0x5464: /* PCI_CHIP_RV370_5464 */
      case 0x5B60: /* PCI_CHIP_RV370_5B60 */
      case 0x5B62: /* PCI_CHIP_RV370_5B62 */
      case 0x5B63: /* PCI_CHIP_RV370_5B63 */
      case 0x5B64: /* PCI_CHIP_RV370_5B64 */
      case 0x5B65: /* PCI_CHIP_RV370_5B65 */
      case 0x3150: /* PCI_CHIP_RV380_3150 */
      case 0x3152: /* PCI_CHIP_RV380_3152 */
      case 0x3154: /* PCI_CHIP_RV380_3154 */
      case 0x3155: /* PCI_CHIP_RV380_3155 */
      case 0x3E50: /* PCI_CHIP_RV380_3E50 */
      case 0x3E54: /* PCI_CHIP_RV380_3E54 */
      case 0x4A48: /* PCI_CHIP_R420_JH */
      case 0x4A49: /* PCI_CHIP_R420_JI */
      case 0x4A4A: /* PCI_CHIP_R420_JJ */
      case 0x4A4B: /* PCI_CHIP_R420_JK */
      case 0x4A4C: /* PCI_CHIP_R420_JL */
      case 0x4A4D: /* PCI_CHIP_R420_JM */
      case 0x4A4E: /* PCI_CHIP_R420_JN */
      case 0x4A4F: /* PCI_CHIP_R420_JO */
      case 0x4A50: /* PCI_CHIP_R420_JP */
      case 0x4A54: /* PCI_CHIP_R420_JT */
      case 0x5548: /* PCI_CHIP_R423_UH */
      case 0x5549: /* PCI_CHIP_R423_UI */
      case 0x554A: /* PCI_CHIP_R423_UJ */
      case 0x554B: /* PCI_CHIP_R423_UK */
      case 0x5550: /* PCI_CHIP_R423_5550 */
      case 0x5551: /* PCI_CHIP_R423_UQ */
      case 0x5552: /* PCI_CHIP_R423_UR */
      case 0x5554: /* PCI_CHIP_R423_UT */
      case 0x5D57: /* PCI_CHIP_R423_5D57 */
      case 0x554C: /* PCI_CHIP_R430_554C */
      case 0x554D: /* PCI_CHIP_R430_554D */
      case 0x554E: /* PCI_CHIP_R430_554E */
      case 0x554F: /* PCI_CHIP_R430_554F */
      case 0x5D48: /* PCI_CHIP_R430_5D48 */
      case 0x5D49: /* PCI_CHIP_R430_5D49 */
      case 0x5D4A: /* PCI_CHIP_R430_5D4A */
      case 0x5D4C: /* PCI_CHIP_R480_5D4C */
      case 0x5D4D: /* PCI_CHIP_R480_5D4D */
      case 0x5D4E: /* PCI_CHIP_R480_5D4E */
      case 0x5D4F: /* PCI_CHIP_R480_5D4F */
      case 0x5D50: /* PCI_CHIP_R480_5D50 */
      case 0x5D52: /* PCI_CHIP_R480_5D52 */
      case 0x4B49: /* PCI_CHIP_R481_4B49 */
      case 0x4B4A: /* PCI_CHIP_R481_4B4A */
      case 0x4B4B: /* PCI_CHIP_R481_4B4B */
      case 0x4B4C: /* PCI_CHIP_R481_4B4C */
      case 0x564A: /* PCI_CHIP_RV410_564A */
      case 0x564B: /* PCI_CHIP_RV410_564B */
      case 0x564F: /* PCI_CHIP_RV410_564F */
      case 0x5652: /* PCI_CHIP_RV410_5652 */
      case 0x5653: /* PCI_CHIP_RV410_5653 */
      case 0x5657: /* PCI_CHIP_RV410_5657 */
      case 0x5E48: /* PCI_CHIP_RV410_5E48 */
      case 0x5E4A: /* PCI_CHIP_RV410_5E4A */
      case 0x5E4B: /* PCI_CHIP_RV410_5E4B */
      case 0x5E4C: /* PCI_CHIP_RV410_5E4C */
      case 0x5E4D: /* PCI_CHIP_RV410_5E4D */
      case 0x5E4F: /* PCI_CHIP_RV410_5E4F */
      case 0x5A41: /* PCI_CHIP_RS400_5A41 */
      case 0x5A42: /* PCI_CHIP_RS400_5A42 */
      case 0x5A61: /* PCI_CHIP_RC410_5A61 */
      case 0x5A62: /* PCI_CHIP_RC410_5A62 */
      case 0x5954: /* PCI_CHIP_RS480_5954 */
      case 0x5955: /* PCI_CHIP_RS480_5955 */
      case 0x5974: /* PCI_CHIP_RS482_5974 */
      case 0x5975: /* PCI_CHIP_RS482_5975 */
      case 0x7100: /* PCI_CHIP_R520_7100 */
      case 0x7101: /* PCI_CHIP_R520_7101 */
      case 0x7102: /* PCI_CHIP_R520_7102 */
      case 0x7103: /* PCI_CHIP_R520_7103 */
      case 0x7104: /* PCI_CHIP_R520_7104 */
      case 0x7105: /* PCI_CHIP_R520_7105 */
      case 0x7106: /* PCI_CHIP_R520_7106 */
      case 0x7108: /* PCI_CHIP_R520_7108 */
      case 0x7109: /* PCI_CHIP_R520_7109 */
      case 0x710A: /* PCI_CHIP_R520_710A */
      case 0x710B: /* PCI_CHIP_R520_710B */
      case 0x710C: /* PCI_CHIP_R520_710C */
      case 0x710E: /* PCI_CHIP_R520_710E */
      case 0x710F: /* PCI_CHIP_R520_710F */
      case 0x7140: /* PCI_CHIP_RV515_7140 */
      case 0x7141: /* PCI_CHIP_RV515_7141 */
      case 0x7142: /* PCI_CHIP_RV515_7142 */
      case 0x7143: /* PCI_CHIP_RV515_7143 */
      case 0x7144: /* PCI_CHIP_RV515_7144 */
      case 0x7145: /* PCI_CHIP_RV515_7145 */
      case 0x7146: /* PCI_CHIP_RV515_7146 */
      case 0x7147: /* PCI_CHIP_RV515_7147 */
      case 0x7149: /* PCI_CHIP_RV515_7149 */
      case 0x714A: /* PCI_CHIP_RV515_714A */
      case 0x714B: /* PCI_CHIP_RV515_714B */
      case 0x714C: /* PCI_CHIP_RV515_714C */
      case 0x714D: /* PCI_CHIP_RV515_714D */
      case 0x714E: /* PCI_CHIP_RV515_714E */
      case 0x714F: /* PCI_CHIP_RV515_714F */
      case 0x7151: /* PCI_CHIP_RV515_7151 */
      case 0x7152: /* PCI_CHIP_RV515_7152 */
      case 0x7153: /* PCI_CHIP_RV515_7153 */
      case 0x715E: /* PCI_CHIP_RV515_715E */
      case 0x715F: /* PCI_CHIP_RV515_715F */
      case 0x7180: /* PCI_CHIP_RV515_7180 */
      case 0x7181: /* PCI_CHIP_RV515_7181 */
      case 0x7183: /* PCI_CHIP_RV515_7183 */
      case 0x7186: /* PCI_CHIP_RV515_7186 */
      case 0x7187: /* PCI_CHIP_RV515_7187 */
      case 0x7188: /* PCI_CHIP_RV515_7188 */
      case 0x718A: /* PCI_CHIP_RV515_718A */
      case 0x718B: /* PCI_CHIP_RV515_718B */
      case 0x718C: /* PCI_CHIP_RV515_718C */
      case 0x718D: /* PCI_CHIP_RV515_718D */
      case 0x718F: /* PCI_CHIP_RV515_718F */
      case 0x7193: /* PCI_CHIP_RV515_7193 */
      case 0x7196: /* PCI_CHIP_RV515_7196 */
      case 0x719B: /* PCI_CHIP_RV515_719B */
      case 0x719F: /* PCI_CHIP_RV515_719F */
      case 0x7200: /* PCI_CHIP_RV515_7200 */
      case 0x7210: /* PCI_CHIP_RV515_7210 */
      case 0x7211: /* PCI_CHIP_RV515_7211 */
      case 0x71C0: /* PCI_CHIP_RV530_71C0 */
      case 0x71C1: /* PCI_CHIP_RV530_71C1 */
      case 0x71C2: /* PCI_CHIP_RV530_71C2 */
      case 0x71C3: /* PCI_CHIP_RV530_71C3 */
      case 0x71C4: /* PCI_CHIP_RV530_71C4 */
      case 0x71C5: /* PCI_CHIP_RV530_71C5 */
      case 0x71C6: /* PCI_CHIP_RV530_71C6 */
      case 0x71C7: /* PCI_CHIP_RV530_71C7 */
      case 0x71CD: /* PCI_CHIP_RV530_71CD */
      case 0x71CE: /* PCI_CHIP_RV530_71CE */
      case 0x71D2: /* PCI_CHIP_RV530_71D2 */
      case 0x71D4: /* PCI_CHIP_RV530_71D4 */
      case 0x71D5: /* PCI_CHIP_RV530_71D5 */
      case 0x71D6: /* PCI_CHIP_RV530_71D6 */
      case 0x71DA: /* PCI_CHIP_RV530_71DA */
      case 0x71DE: /* PCI_CHIP_RV530_71DE */
      case 0x7281: /* PCI_CHIP_RV560_7281 */
      case 0x7283: /* PCI_CHIP_RV560_7283 */
      case 0x7287: /* PCI_CHIP_RV560_7287 */
      case 0x7290: /* PCI_CHIP_RV560_7290 */
      case 0x7291: /* PCI_CHIP_RV560_7291 */
      case 0x7293: /* PCI_CHIP_RV560_7293 */
      case 0x7297: /* PCI_CHIP_RV560_7297 */
      case 0x7280: /* PCI_CHIP_RV570_7280 */
      case 0x7288: /* PCI_CHIP_RV570_7288 */
      case 0x7289: /* PCI_CHIP_RV570_7289 */
      case 0x728B: /* PCI_CHIP_RV570_728B */
      case 0x728C: /* PCI_CHIP_RV570_728C */
      case 0x7240: /* PCI_CHIP_R580_7240 */
      case 0x7243: /* PCI_CHIP_R580_7243 */
      case 0x7244: /* PCI_CHIP_R580_7244 */
      case 0x7245: /* PCI_CHIP_R580_7245 */
      case 0x7246: /* PCI_CHIP_R580_7246 */
      case 0x7247: /* PCI_CHIP_R580_7247 */
      case 0x7248: /* PCI_CHIP_R580_7248 */
      case 0x7249: /* PCI_CHIP_R580_7249 */
      case 0x724A: /* PCI_CHIP_R580_724A */
      case 0x724B: /* PCI_CHIP_R580_724B */
      case 0x724C: /* PCI_CHIP_R580_724C */
      case 0x724D: /* PCI_CHIP_R580_724D */
      case 0x724E: /* PCI_CHIP_R580_724E */
      case 0x724F: /* PCI_CHIP_R580_724F */
      case 0x7284: /* PCI_CHIP_R580_7284 */
      case 0x793F: /* PCI_CHIP_RS600_793F */
      case 0x7941: /* PCI_CHIP_RS600_7941 */
      case 0x7942: /* PCI_CHIP_RS600_7942 */
      case 0x791E: /* PCI_CHIP_RS690_791E */
      case 0x791F: /* PCI_CHIP_RS690_791F */
      case 0x796C: /* PCI_CHIP_RS740_796C */
      case 0x796D: /* PCI_CHIP_RS740_796D */
      case 0x796E: /* PCI_CHIP_RS740_796E */
      case 0x796F: /* PCI_CHIP_RS740_796F */
	      return TRUE;
      default:
	      return FALSE;
      }
}

#endif
