#!/usr/bin/perl

# From http://www.roads.lut.ac.uk/txt/exim-mrtg.html

use POSIX qw(strftime);

$ETC = "/var/log/exim/";
$EXIM = "/usr/bin/exim";

$number_in = $number_out = $spam = $cancelled = $duff_spamd = 0;
$frozen = $queued = $to_deliver = $qkb = $largest = 0;

open(LOG,"</var/log/exim/main.log")
  || die "$0: couldn't open mainlog: $!";
while(<LOG>) {
  if (/<=/) {
    $number_in++;
  } elsif (/[-=]>/) {
    $number_out++;
  } elsif (/cancelled by system filter:/) {
    $cancelled++;
  }
}
close(LOG);

open(LOG,"</var/log/maillog")
  || die "$0: couldn't open mainlog: $!";
while(<LOG>) {
if (/identified spam/) {
    $spam++;
  }
}
close(LOG);

$now = strftime("%Y-%m-%d %H:%M", gmtime(time - 300));

open(LOG,"</var/log/exim/reject.log")
  || die "$0: couldn't open rejectlog: $!";
while(<LOG>) {
  next unless /^$now/;
}
while(<LOG>) {
  next unless /problem with spamd facility/;
  $duff_spamd++;
}
close(LOG);

chdir("$ETC") || die "$0: couldn't chdir($ETC): $!";

open(MAILQ, "$EXIM -bp|")
  || die "$0: couldn't open pipe from Exim ($EXIM): $!";
while(<MAILQ>) {
  chop;
  if (/[<>]/) {
    $frozen++ if /frozen/;
    $queued++;
  
    s/\s+/ /g;
    my ($time, $size, $msgid, $sender) = split;

    if ($size =~ /K$/) {
      $size =~ s/K$//;
      $size *= 1024;         # multiply by 1024 to go from KB -> bytes
      $qkb += int($size);
    } elsif ($size =~ /M/) {
      $size =~ s/M$//;
      $size *= 1024;         # multiply by 1024 to go from MB -> KB
      $size *= 1024;         # multiply by 1024 to go from KB -> bytes
      $qkb += int($size);
    } else {
      $qkb += int($size);
    }

    if ($size > $largest) {
      $largest = int($size);
    }
  } else {
    next if /D /;
    $to_deliver++;
  }
}
close(MAILQ);

open(TOTAL,">scan_exim_log.total.$$")
  || die "Can't write the file 'scan_exim_log.total.$$'\n";
print TOTAL <<EOF;
$frozen
$queued
$to_deliver
$qkb
$largest
$number_in
$number_out
$spam
$duff_spamd
EOF
close(TOTAL);

rename("scan_exim_log.total.$$", "scan_exim_log.total");
