/*
 * Decompiled with CFR 0.152.
 */
package adql.parser;

import adql.db.exception.UnresolvedIdentifiersException;
import adql.db.exception.UnsupportedFeatureException;
import adql.db.region.CoordSys;
import adql.db.region.Region;
import adql.db.region.STCS;
import adql.parser.ADQLQueryFactory;
import adql.parser.QueryChecker;
import adql.parser.QueryFixer;
import adql.parser.feature.FeatureSet;
import adql.parser.feature.LanguageFeature;
import adql.parser.grammar.ADQLGrammar;
import adql.parser.grammar.ADQLGrammar200;
import adql.parser.grammar.ADQLGrammar201;
import adql.parser.grammar.ParseException;
import adql.parser.grammar.Token;
import adql.parser.grammar.TokenMgrError;
import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.ADQLOrder;
import adql.query.ADQLQuery;
import adql.query.ADQLSet;
import adql.query.ClauseADQL;
import adql.query.ClauseConstraints;
import adql.query.ClauseSelect;
import adql.query.from.FromContent;
import adql.query.operand.ADQLOperand;
import adql.query.operand.StringConstant;
import adql.query.operand.function.geometry.BoxFunction;
import adql.query.operand.function.geometry.CircleFunction;
import adql.query.operand.function.geometry.GeometryFunction;
import adql.query.operand.function.geometry.PointFunction;
import adql.query.operand.function.geometry.PolygonFunction;
import adql.query.operand.function.geometry.RegionFunction;
import adql.search.SearchOptionalFeaturesHandler;
import adql.search.SimpleSearchHandler;
import adql.translator.PostgreSQLTranslator;
import adql.translator.TranslationException;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class ADQLParser {
    protected final ADQLGrammar grammarParser;
    protected FeatureSet supportedFeatures;
    protected String[] allowedCoordSys = null;
    protected String coordSysRegExp = null;
    protected QueryChecker queryChecker = null;
    protected QueryFixer quickFixer;
    protected boolean anyUdfAllowed = false;
    protected boolean extendedRegionExpressionAllowed = false;
    public static final ADQLVersion DEFAULT_VERSION = ADQLVersion.V2_0;

    public static ADQLVersion[] getSupportedVersions() {
        return ADQLVersion.values();
    }

    public static String getSupportedVersionsAsString() {
        StringBuilder buf = new StringBuilder();
        for (ADQLVersion v : ADQLVersion.values()) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(v.toString());
            if (v != DEFAULT_VERSION) continue;
            buf.append(" (default)");
        }
        return buf.toString();
    }

    public ADQLParser() {
        this(DEFAULT_VERSION, null, null, null);
    }

    public ADQLParser(ADQLVersion version) {
        this(version, null, null, null);
    }

    public ADQLParser(ADQLVersion version, QueryChecker queryChecker, ADQLQueryFactory factory, FeatureSet features) {
        if (version == null) {
            version = DEFAULT_VERSION;
        }
        switch (version) {
            case V2_0: {
                this.grammarParser = new ADQLGrammar200(new ByteArrayInputStream("".getBytes()));
                break;
            }
            default: {
                this.grammarParser = new ADQLGrammar201(new ByteArrayInputStream("".getBytes()));
            }
        }
        this.setQuickFixer(new QueryFixer(this.grammarParser));
        if (features == null) {
            this.setDefaultFeatures();
        } else {
            this.setSupportedFeatures(features);
        }
        this.setQueryFactory(factory == null ? new ADQLQueryFactory() : factory);
        this.setQueryChecker(queryChecker);
        this.setDebug(false);
    }

    public final ADQLVersion getADQLVersion() {
        return this.grammarParser.getVersion();
    }

    public final ADQLGrammar getGrammarParser() {
        return this.grammarParser;
    }

    public final QueryFixer getQuickFixer() {
        return this.quickFixer;
    }

    public final void setQuickFixer(QueryFixer fixer) throws NullPointerException {
        if (fixer == null) {
            throw new NullPointerException("Missing new QuickFixer! An ADQLParser can not try to fix ADQL queries without a QuickFixer instance.");
        }
        this.quickFixer = fixer;
    }

    public final ADQLQueryFactory getQueryFactory() {
        return this.grammarParser.getQueryFactory();
    }

    public final void setQueryFactory(ADQLQueryFactory factory) throws NullPointerException {
        if (factory == null) {
            throw new NullPointerException("Missing ADQLQueryFactory to use! It is required for ADQL query parsing.");
        }
        this.grammarParser.setQueryFactory(factory);
    }

    public final FeatureSet getSupportedFeatures() {
        return this.supportedFeatures;
    }

    public final void setDefaultFeatures() {
        switch (this.getADQLVersion()) {
            case V2_0: {
                this.supportedFeatures = new FeatureSet(false);
                this.supportedFeatures.supportAll("ivo://ivoa.net/std/TAPRegExt#features-adqlgeo");
                break;
            }
            default: {
                this.supportedFeatures = new FeatureSet(true);
            }
        }
    }

    public final void setSupportedFeatures(FeatureSet features) throws NullPointerException {
        if (features == null) {
            throw new NullPointerException("Missing list of supported features! It is required for ADQL query parsing.");
        }
        this.supportedFeatures = features;
    }

    public final String[] getAllowedCoordSys() {
        return this.allowedCoordSys;
    }

    public final void setAllowedCoordSys(Collection<String> allowedCoordSys) throws ParseException {
        String[] tempAllowedCoordSys = this.specialSort(allowedCoordSys);
        this.coordSysRegExp = CoordSys.buildCoordSysRegExp(tempAllowedCoordSys);
        this.allowedCoordSys = tempAllowedCoordSys;
    }

    public void allowAnyUdf(boolean allowed) {
        this.anyUdfAllowed = allowed;
    }

    public boolean isAnyUdfAllowed() {
        return this.anyUdfAllowed;
    }

    public void allowExtendedRegionParam(boolean allowed) {
        this.extendedRegionExpressionAllowed = allowed;
    }

    public boolean isExtendedRegionParamAllowed() {
        return this.extendedRegionExpressionAllowed;
    }

    public final QueryChecker getQueryChecker() {
        return this.queryChecker;
    }

    public final void setQueryChecker(QueryChecker checker) {
        this.queryChecker = checker;
    }

    public final void setDebug(boolean debug) {
        if (debug) {
            this.grammarParser.enable_tracing();
        } else {
            this.grammarParser.disable_tracing();
        }
    }

    public final ADQLSet parseQuery(String q) throws ParseException {
        try {
            this.grammarParser.reset(new ByteArrayInputStream(q.getBytes()));
        }
        catch (Exception ex) {
            throw this.grammarParser.generateParseException(ex);
        }
        return this.effectiveParseQuery();
    }

    public final ADQLSet parseQuery(InputStream stream) throws ParseException {
        try {
            this.grammarParser.reset(stream);
        }
        catch (Exception ex) {
            throw this.grammarParser.generateParseException(ex);
        }
        return this.effectiveParseQuery();
    }

    protected ADQLSet effectiveParseQuery() throws ParseException {
        ADQLSet parsedQuery;
        try {
            parsedQuery = this.grammarParser.Query();
        }
        catch (TokenMgrError tme) {
            throw new ParseException(tme);
        }
        this.allChecks(parsedQuery);
        return parsedQuery;
    }

    public final ClauseSelect parseSelect(String adql) throws ParseException {
        try {
            this.grammarParser.reset(new ByteArrayInputStream(adql.getBytes()));
        }
        catch (Exception ex) {
            throw this.grammarParser.generateParseException(ex);
        }
        try {
            ClauseSelect select = this.grammarParser.Select();
            ADQLQuery q = new ADQLQuery(this.grammarParser.getVersion());
            q.setSelect(select);
            this.allChecks(q);
            return select;
        }
        catch (TokenMgrError tme) {
            throw new ParseException(tme);
        }
    }

    public final FromContent parseFrom(String adql) throws ParseException {
        try {
            this.grammarParser.reset(new ByteArrayInputStream(adql.getBytes()));
        }
        catch (Exception ex) {
            throw this.grammarParser.generateParseException(ex);
        }
        try {
            FromContent from = this.grammarParser.From();
            ADQLQuery q = new ADQLQuery(this.grammarParser.getVersion());
            q.setFrom(from);
            this.allChecks(q);
            return from;
        }
        catch (TokenMgrError tme) {
            throw new ParseException(tme);
        }
    }

    public final ClauseConstraints parseWhere(String adql) throws ParseException {
        try {
            this.grammarParser.reset(new ByteArrayInputStream(adql.getBytes()));
        }
        catch (Exception ex) {
            throw this.grammarParser.generateParseException(ex);
        }
        try {
            ClauseConstraints where = this.grammarParser.Where();
            ADQLQuery q = new ADQLQuery(this.grammarParser.getVersion());
            q.setWhere(where);
            this.allChecks(q);
            return where;
        }
        catch (TokenMgrError tme) {
            throw new ParseException(tme);
        }
    }

    public final ClauseADQL<ADQLOrder> parseOrderBy(String adql) throws ParseException {
        try {
            this.grammarParser.reset(new ByteArrayInputStream(adql.getBytes()));
        }
        catch (Exception ex) {
            throw this.grammarParser.generateParseException(ex);
        }
        try {
            ClauseADQL<ADQLOrder> orderBy = this.grammarParser.OrderBy();
            ADQLQuery q = new ADQLQuery(this.grammarParser.getVersion());
            q.setOrderBy(orderBy);
            this.allChecks(q);
            return orderBy;
        }
        catch (TokenMgrError tme) {
            throw new ParseException(tme);
        }
        catch (Exception ex) {
            throw this.grammarParser.generateParseException(ex);
        }
    }

    public final ClauseADQL<ADQLOperand> parseGroupBy(String adql) throws ParseException {
        try {
            this.grammarParser.reset(new ByteArrayInputStream(adql.getBytes()));
        }
        catch (Exception ex) {
            throw this.grammarParser.generateParseException(ex);
        }
        try {
            ClauseADQL<ADQLOperand> groupBy = this.grammarParser.GroupBy();
            ADQLQuery q = new ADQLQuery(this.grammarParser.getVersion());
            q.setGroupBy(groupBy);
            this.allChecks(q);
            return groupBy;
        }
        catch (TokenMgrError tme) {
            throw new ParseException(tme);
        }
    }

    protected void allChecks(ADQLSet q) throws ParseException {
        this.generalChecks(q);
        if (this.queryChecker != null) {
            this.queryChecker.check(q);
        }
    }

    protected void generalChecks(ADQLSet q) throws ParseException {
        UnresolvedIdentifiersException exUnsupportedFeatures = new UnresolvedIdentifiersException("unsupported expression");
        SearchOptionalFeaturesHandler sFeaturesHandler = new SearchOptionalFeaturesHandler(true, false);
        sFeaturesHandler.search(q);
        for (ADQLObject obj : sFeaturesHandler) {
            if (this.isAnyUdfAllowed() && "ivo://ivoa.net/std/TAPRegExt#features-udf".equals(obj.getFeatureDescription().type) || this.supportedFeatures.isSupporting(obj.getFeatureDescription())) continue;
            exUnsupportedFeatures.addException(new UnsupportedFeatureException(obj));
        }
        this.resolveCoordinateSystems(q, exUnsupportedFeatures);
        if (this.supportedFeatures.isSupporting(RegionFunction.FEATURE)) {
            this.resolveRegionExpressions(q, exUnsupportedFeatures);
        }
        if (exUnsupportedFeatures.getNbErrors() > 0) {
            throw exUnsupportedFeatures;
        }
    }

    protected final String[] specialSort(Collection<String> items) {
        if (items == null) {
            return null;
        }
        String[] tmp = new String[items.size()];
        int cnt = 0;
        for (String item : items) {
            if (item == null || item.trim().length() <= 0) continue;
            tmp[cnt++] = item;
        }
        Object[] copy = new String[cnt];
        System.arraycopy(tmp, 0, copy, 0, cnt);
        Arrays.sort(copy);
        return copy;
    }

    protected void resolveCoordinateSystems(ADQLSet query, UnresolvedIdentifiersException errors) {
        SearchCoordSysHandler sHandler = new SearchCoordSysHandler();
        sHandler.search(query);
        for (ADQLObject result : sHandler) {
            this.checkCoordinateSystem((StringConstant)result, errors);
        }
    }

    protected void checkCoordinateSystem(StringConstant adqlCoordSys, UnresolvedIdentifiersException errors) {
        String coordSysStr = adqlCoordSys.getValue();
        try {
            this.checkCoordinateSystem(STCS.parseCoordSys(coordSysStr), adqlCoordSys, errors);
        }
        catch (ParseException pe) {
            errors.addException(new ParseException(pe.getMessage(), adqlCoordSys.getPosition()));
        }
    }

    protected void checkCoordinateSystem(CoordSys coordSys, ADQLOperand operand, UnresolvedIdentifiersException errors) {
        if (this.coordSysRegExp != null && coordSys != null && !coordSys.toFullSTCS().matches(this.coordSysRegExp)) {
            StringBuffer buf = new StringBuffer();
            if (this.allowedCoordSys != null) {
                for (String cs : this.allowedCoordSys) {
                    if (buf.length() > 0) {
                        buf.append(", ");
                    }
                    buf.append(cs);
                }
            }
            if (buf.length() == 0) {
                buf.append("No coordinate system is allowed!");
            } else {
                buf.insert(0, "Allowed coordinate systems are: ");
            }
            errors.addException(new ParseException("Coordinate system \"" + (operand instanceof StringConstant ? ((StringConstant)operand).getValue() : coordSys.toString()) + "\" (= \"" + coordSys.toFullSTCS() + "\") not allowed in this implementation. " + buf.toString(), operand.getPosition()));
        }
    }

    protected void resolveRegionExpressions(ADQLSet query, UnresolvedIdentifiersException errors) {
        SearchRegionHandler sHandler = new SearchRegionHandler();
        sHandler.search(query);
        for (ADQLObject result : sHandler) {
            RegionFunction fct = (RegionFunction)result;
            fct.setExtendedRegionExpression(this.isExtendedRegionParamAllowed());
            if (this.isExtendedRegionParamAllowed()) continue;
            if (fct.getParameter(0) instanceof StringConstant) {
                try {
                    String regionStr = ((StringConstant)((RegionFunction)result).getParameter(0)).getValue();
                    Region region = Region.parse(regionStr);
                    this.checkRegion(region, (RegionFunction)result, errors);
                }
                catch (ParseException pe) {
                    errors.addException(new ParseException(pe.getMessage(), result.getPosition()));
                }
                continue;
            }
            errors.addException(new ParseException("Unsupported REGION(...) parameter! Only a string literal is accepted.", result.getPosition()));
        }
    }

    protected void checkRegion(Region r, RegionFunction fct, UnresolvedIdentifiersException errors) {
        LanguageFeature feature;
        if (r == null) {
            return;
        }
        if (r.coordSys != null) {
            this.checkCoordinateSystem(r.coordSys, fct, errors);
        }
        switch (r.type) {
            case POSITION: {
                feature = PointFunction.FEATURE;
                break;
            }
            case BOX: {
                feature = BoxFunction.FEATURE;
                break;
            }
            case CIRCLE: {
                feature = CircleFunction.FEATURE;
                break;
            }
            case POLYGON: {
                feature = PolygonFunction.FEATURE;
                break;
            }
            case UNION: {
                feature = RegionFunction.FEATURE_UNION;
                break;
            }
            case INTERSECTION: {
                feature = RegionFunction.FEATURE_INTERSECT;
                break;
            }
            default: {
                feature = null;
            }
        }
        if (!(r.type == Region.RegionType.NOT || feature != null && this.supportedFeatures.isSupporting(feature))) {
            errors.addException(new UnsupportedFeatureException(fct, "Unsupported region type: \"" + (Object)((Object)r.type) + "\"" + (feature == null ? "!" : " (equivalent to the ADQL feature \"" + feature.form + "\" of type '" + feature.type + "')!")));
        }
        if (r.regions != null) {
            for (Region innerR : r.regions) {
                this.checkRegion(innerR, fct, errors);
            }
        }
    }

    public Token[] tokenize(String expr, boolean stopAtEnd) throws ParseException {
        ADQLGrammar.Tokenizer tokenizer = this.grammarParser.getTokenizer(expr == null ? "" : expr);
        try {
            ArrayList<Token> tokens = new ArrayList<Token>();
            Token token = tokenizer.nextToken();
            while (!(token == null || stopAtEnd && this.grammarParser.isEnd(token))) {
                tokens.add(token);
                token = tokenizer.nextToken();
            }
            return tokens.toArray(new Token[tokens.size()]);
        }
        catch (TokenMgrError err) {
            throw new ParseException(err);
        }
    }

    public final String tryQuickFix(InputStream input) throws IOException, ParseException {
        int nbChar;
        StringBuffer buf = new StringBuffer();
        byte[] cBuf = new byte[1024];
        while ((nbChar = input.read(cBuf)) > -1) {
            buf.append(new String(cBuf, 0, nbChar));
        }
        return this.quickFixer.fix(buf.toString());
    }

    public final String tryQuickFix(String adqlQuery) throws ParseException {
        return this.quickFixer.fix(adqlQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void main(String[] args) throws Exception {
        String USAGE = "Usage:\n    adqlParser.jar [--version=...] [-h] [-d] [-v] [-e] [-a|-s] [-f] [<FILE>|<URL>]\n\nNOTE: If no file or URL is given, the ADQL query is expected in the standard\n      input. This query must end with a ';' or <Ctrl+D>!\n\nParameters:\n    --version=...   : Set the version of the ADQL grammar to follow.\n                      It must be one among: " + ADQLParser.getSupportedVersionsAsString() + "\n    -h or --help    : Display this help.\n    -v or --verbose : Print the main steps of the parsing\n    -d or --debug   : Print stack traces when a grave error occurs\n    -e or --explain : Explain the ADQL parsing (or Expand the parsing tree)\n    -a or --adql    : Display the understood ADQL query\n    -s or --sql     : Ask the SQL translation of the given ADQL query\n                      (SQL compatible with PostgreSQL)\n    -f or --try-fix : Try fixing the most common ADQL query issues before\n                      attempting to parse the query.\n\nReturn:\n    By default: nothing if the query is correct. Otherwise a message explaining\n                why the query is not correct is displayed.\n    With the -s option, the SQL translation of the given ADQL query will be\n    returned.\n    With the -a option, the ADQL query is returned as it has been understood.\n\nExit status:\n    0  OK !\n    1  Parameter error (missing or incorrect parameter)\n    2  File error (incorrect file/url, reading error, ...)\n    3  Parsing error (syntactic or semantic error)\n    4  Translation error (a problem has occurred during the translation of the\n       given ADQL query in SQL).";
        String NEED_HELP_MSG = "Try -h or --help to get more help about the usage of this program.";
        String urlRegex = "^(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
        int mode = -1;
        String file = null;
        ADQLVersion version = DEFAULT_VERSION;
        boolean verbose = false;
        boolean debug = false;
        boolean explain = false;
        boolean tryFix = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("--version=")) {
                String[] parts = args[i].split("=");
                if (parts.length <= 1) {
                    System.err.println("((!)) Missing ADQL version! It must be one among: " + ADQLParser.getSupportedVersionsAsString() + ". ((!))\n" + "Try -h or --help to get more help about the usage of this program.");
                    System.exit(1);
                }
                if ((version = ADQLVersion.parse(parts[1])) != null) continue;
                System.err.println("((!)) Incorrect ADQL version: \"" + args[i].split("=")[1] + "\"! It must be one among: " + ADQLParser.getSupportedVersionsAsString() + ". ((!))\n" + "Try -h or --help to get more help about the usage of this program.");
                System.exit(1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-d") || args[i].equalsIgnoreCase("--debug")) {
                debug = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-v") || args[i].equalsIgnoreCase("--verbose")) {
                verbose = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-e") || args[i].equalsIgnoreCase("--explain")) {
                explain = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-a") || args[i].equalsIgnoreCase("--adql")) {
                if (mode != -1) {
                    System.err.println("((!)) Too much parameter: you must choose between -s, -c, -a or nothing ((!))\nTry -h or --help to get more help about the usage of this program.");
                    System.exit(1);
                    continue;
                }
                mode = 1;
                continue;
            }
            if (args[i].equalsIgnoreCase("-s") || args[i].equalsIgnoreCase("--sql")) {
                if (mode != -1) {
                    System.err.println("((!)) Too much parameter: you must choose between -s, -c, -a or nothing ((!))\nTry -h or --help to get more help about the usage of this program.");
                    System.exit(1);
                    continue;
                }
                mode = 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-f") || args[i].equalsIgnoreCase("--try-fix")) {
                tryFix = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-h") || args[i].equalsIgnoreCase("--help")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            if (args[i].startsWith("-")) {
                System.err.println("((!)) Unknown parameter: \"" + args[i] + "\" ((!))\n" + "Try -h or --help to get more help about the usage of this program.");
                System.exit(1);
                continue;
            }
            file = args[i].trim();
        }
        try {
            ADQLParser parser = new ADQLParser(version);
            InputStream in = null;
            if (tryFix) {
                if (verbose) {
                    System.out.println("((i)) Trying to automatically fix the query...");
                }
                try {
                    in = file == null || file.length() == 0 ? System.in : (file.matches("^(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]") ? new URL(file).openStream() : new FileInputStream(file));
                    String query = parser.tryQuickFix(in);
                    if (verbose) {
                        System.out.println("((i)) SUGGESTED QUERY:\n" + query);
                    }
                    in = new ByteArrayInputStream(query.getBytes());
                }
                catch (ParseException pe) {
                    System.out.println("((!)) Quick fix failure! Cause: " + pe.getMessage() + ".");
                    if (debug) {
                        pe.printStackTrace();
                    } else {
                        System.out.println("      (run again with -d for more details)");
                    }
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                    in = null;
                }
            }
            if (in == null) {
                in = file == null || file.length() == 0 ? System.in : (file.matches("^(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]") ? new URL(file).openStream() : new FileInputStream(file));
            }
            parser.setDebug(explain);
            try {
                if (verbose) {
                    System.out.print("((i)) Parsing ADQL query...");
                }
                ADQLSet q = parser.parseQuery(in);
                if (verbose) {
                    System.out.println("((i)) CORRECT ADQL QUERY ((i))");
                }
                if (mode == 2) {
                    PostgreSQLTranslator translator = new PostgreSQLTranslator();
                    if (verbose) {
                        System.out.print("((i)) Translating in SQL...");
                    }
                    String sql = translator.translate(q);
                    if (verbose) {
                        System.out.println("ok");
                    }
                    System.out.println(sql);
                } else if (mode == 1) {
                    System.out.println(q.toADQL());
                }
            }
            catch (UnresolvedIdentifiersException uie) {
                System.err.println("((X)) " + uie.getNbErrors() + " unresolved identifiers:");
                for (ParseException pe : uie) {
                    System.err.println("\t - at " + pe.getPosition() + ": " + uie.getMessage());
                }
                if (debug) {
                    uie.printStackTrace(System.err);
                }
                System.exit(3);
            }
            catch (ParseException pe) {
                System.err.println("((X)) Syntax error: " + pe.getMessage() + " ((X))");
                if (debug) {
                    pe.printStackTrace(System.err);
                }
                System.exit(3);
            }
            catch (TranslationException te) {
                if (verbose) {
                    System.out.println("error");
                }
                System.err.println("((X)) Translation error: " + te.getMessage() + " ((X))");
                if (debug) {
                    te.printStackTrace(System.err);
                }
                System.exit(4);
            }
        }
        catch (IOException ioe) {
            System.err.println("\n((X)) Error while reading the file \"" + file + "\": " + ioe.getMessage() + " ((X))");
            if (debug) {
                ioe.printStackTrace(System.err);
            }
            System.exit(2);
        }
    }

    private static class SearchRegionHandler
    extends SimpleSearchHandler {
        private SearchRegionHandler() {
        }

        @Override
        protected boolean match(ADQLObject obj) {
            return obj instanceof RegionFunction;
        }
    }

    private static class SearchCoordSysHandler
    extends SimpleSearchHandler {
        private SearchCoordSysHandler() {
        }

        @Override
        protected boolean match(ADQLObject obj) {
            if (obj instanceof PointFunction || obj instanceof BoxFunction || obj instanceof CircleFunction || obj instanceof PolygonFunction) {
                return ((GeometryFunction)obj).getCoordinateSystem() instanceof StringConstant;
            }
            return false;
        }

        @Override
        protected void addMatch(ADQLObject matchObj, ADQLIterator it) {
            this.results.add(((GeometryFunction)matchObj).getCoordinateSystem());
        }
    }

    public static enum ADQLVersion {
        V2_0,
        V2_1;


        public String toString() {
            return this.name().toLowerCase().replace('_', '.');
        }

        public static ADQLVersion parse(String str) {
            if (str == null) {
                return null;
            }
            if ((str = str.trim().toUpperCase()).isEmpty()) {
                return null;
            }
            if (str.charAt(0) != 'V') {
                str = 'V' + str;
            }
            try {
                return ADQLVersion.valueOf(str.replaceAll("\\.", "_"));
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }
    }
}

