//start of LzssInputStream.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * LzssInputStream.java
 * 
 * Copyright (C) 2001-2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.util.lha;

//import classes and interfaces
import java.io.InputStream;
import jp.gr.java_conf.dangan.util.lha.PreLzssDecoder;

//import exceptions
import java.io.IOException;
import java.io.EOFException;

/**
 * LZSS kꂽf[^𓀂Ȃ狟̓Xg[B<br>
 * 
 * <pre>
 * -- revision history --
 * $Log: LzssInputStream.java,v $
 * Revision 1.1  2002/12/08 00:00:00  dangan
 * [bug fix]
 *     mark() Őڑꂽ PreLzssDecoder  
 *     mark ɗ^ readLimit ̌vZÂ̂CB
 *
 * Revision 1.0  2002/07/25 00:00:00  dangan
 * add to version control
 * [bug fix]
 *     available() ̃Xy~XCB
 *     skip() ɂ decode() ĂԔԈĂ̂CB
 * [maintenance]
 *     \[X
 *     ^up~
 *     CZX̏C
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.1 $
 */
public class LzssInputStream extends InputStream{


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  source
    //------------------------------------------------------------------
    //  private PreLzssDecoder decoder
    //------------------------------------------------------------------
    /**
     * LZSSkR[hԂ̓Xg[
     */
    private PreLzssDecoder decoder;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  LZSS parameter
    //------------------------------------------------------------------
    //  private int Threshold
    //  private int MaxMatch
    //  private long Length
    //------------------------------------------------------------------
    /**
     * LZSSkɎgp臒lB
     * v ̒lȏł΁AkR[ho͂B
     */
    private int Threshold;

    /**
     * LZSSkɎgplB
     * ővB
     */
    private int MaxMatch;

    /**
     * 𓀌̃f[^TCY
     */
    private long Length;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  text buffer
    //------------------------------------------------------------------
    //  private byte[] TextBuffer
    //  private long TextPosition
    //  private long TextDecoded
    //------------------------------------------------------------------
    /**
     * LZSSkWJ邽߂̃obt@B
     */
    private byte[] TextBuffer;

    /**
     * ݓǂݍ݈ʒuB
     * read() ɂĊOɓǂݏoꂽʒuB
     */
    private long TextPosition;

    /**
     * ݓǂݍ݈ʒuB
     * LZSSkR[hWJēꂽʒuB
     */
    private long TextDecoded;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  backup for mark/reset
    //------------------------------------------------------------------
    //  private byte[] MarkTextBuffer
    //  private long MarkTextPosition
    //  private long MarkTextDecoded
    //------------------------------------------------------------------
    /** TextBuffer ̃obNAbvp */
    private byte[] MarkTextBuffer;

    /** TextPosition ̃obNAbvp */
    private long MarkTextPosition;

    /** TextDecoded ̃obNAbvp */
    private long MarkTextDecoded;


    //------------------------------------------------------------------
    //  constructor
    //------------------------------------------------------------------
    //  private LzssInputStream()
    //  public LzssInputStream( PreLzssDecoder decoder )
    //  public LzssInputStream( PreLzssDecoder decoder, long length )
    //------------------------------------------------------------------
    /**
     * ftHgRXgN^B
     * gpsB
     */
    private LzssInputStream(){ }

    /**
     * in  LZSSkf[^ ̓͂󂯂āA
     * 𓀂ꂽf[^񋟂̓Xg[\zB
     * ̃RXgN^琶ꂽ LzssInputStream
     * -lh1-̉𓀃f[^̍Ō̃f[^ǂݍ񂾌A
     * ̃f[^̓ǂݎŕKEndOfStreamɒBƂ
     * Ȃf[^𐳏ɕłȂ(I[ȍ~ɃS~
     * f[^\)B
     * 
     * @param decoder LZSSkf[^Xg[
     */
    public LzssInputStream( PreLzssDecoder decoder ){
        this( decoder, Long.MAX_VALUE );
    }

    /**
     * in  LZSSkf[^ ̓͂󂯂āA
     * 𓀂ꂽf[^񋟂̓Xg[\zB
     * 
     * 
     * @param decoder LZSSkf[^Xg[
     * @param length  𓀌̃TCY
     */
    public LzssInputStream( PreLzssDecoder decoder,
                            long           length ){
        this.MaxMatch      = decoder.getMaxMatch();
        this.Threshold     = decoder.getThreshold();
        this.Length        = length;

        this.decoder        = decoder;
        this.TextBuffer     = new byte[ decoder.getDictionarySize() ];
        this.TextPosition   = 0;
        this.TextDecoded    = 0;

        if( this.decoder instanceof PreLz5Decoder )
            this.initLz5TextBuffer();
    }


    //------------------------------------------------------------------
    //  method of java.io.InputStream
    //------------------------------------------------------------------
    //  read
    //------------------------------------------------------------------
    //  public int read()
    //  public int read( byte[] buffer )
    //  public int read( byte[] buffer, int index, int length )
    //  public long skip( long length )
    //------------------------------------------------------------------
    /**
     * RXgN^Ŏw肳ꂽ PreLzssDecoder 
     * kꂽf[^𓀂A1oCg̃f[^B
     * 
     * @return 𓀂ꂽ 1oCg̃f[^
     * 
     * @exception IOException o̓G[ꍇ
     */
    public int read() throws IOException {
        if( this.TextDecoded <= this.TextPosition ){
            try{
                this.decode();                                                  //throws EOFException IOException
            }catch( EOFException exception ){
                if( this.TextDecoded <= this.TextPosition )
                    return -1;
            }
        }

        return this.TextBuffer[ (int)this.TextPosition++
                                 & ( this.TextBuffer.length - 1 ) ] & 0xFF;
    }

    /**
     * RXgN^Ŏw肳ꂽ PreLzssDecoder 
     * kꂽf[^𓀂Abuffer𖞂悤
     * 𓀂ꂽf[^ǂݍށB
     * 
     * @param buffer f[^ǂݍރobt@
     * 
     * @return ǂ݂񂾃f[^
     * 
     * @exception IOException o̓G[ꍇ
     */
    public int read( byte[] buffer ) throws IOException {
        return this.read( buffer, 0, buffer.length );
    }

    /**
     * RXgN^Ŏw肳ꂽ PreLzssDecoder 
     * kꂽf[^𓀂Abuffer  index 
     * length oCg̃f[^ǂݍށB
     * 
     * @param buffer f[^ǂݍރobt@
     * @param index  buffer ̃f[^ǂ݂݊Jnʒu
     * @param length ǂݍރf[^
     * 
     * @return ǂ݂񂾃f[^
     * 
     * @exception IOException o̓G[ꍇ
     */
    public int read( byte[] buffer, int index, int length ) throws IOException {
        int position = index;
        int end      = index + length;
        try{
            while( position < end ){
                if( this.TextDecoded <= this.TextPosition )
                    this.decode();                                              //throws IOException

                position = this.copyTextBufferToBuffer( buffer, position, end );
            }
        }catch( EOFException exception ){
            position = this.copyTextBufferToBuffer( buffer, position, end );

            if( position == index ) return -1;
        }

        return position - index;
    }

    /**
     * 𓀂ꂽf[^ lengthoCgǂݔ΂B
     * 
     * @param length ǂݔ΂f[^(Pʂ̓oCg)
     * 
     * @return ۂɓǂݔ΂oCg
     * 
     * @exception IOException o̓G[ꍇ
     */
    public long skip( long length ) throws IOException {
        long end = this.TextPosition + length;
        try{
            while( this.TextPosition < end ){
                if( this.TextDecoded <= this.TextPosition )
                    this.decode();

                this.TextPosition = Math.min( end, this.TextDecoded );
            }
        }catch( EOFException exception ){
            this.TextPosition = Math.min( end, this.TextDecoded );
        }

        return length - ( end - this.TextPosition );
    }


    //------------------------------------------------------------------
    //  method of java.io.InputStream
    //------------------------------------------------------------------
    //  mark/reset
    //------------------------------------------------------------------
    //  public void mark( int readLimit )
    //  public void reset()
    //  public boolean markSupported()
    //------------------------------------------------------------------
    /**
     * ڑꂽ̓Xg[݈̌ʒuɃ}[Nݒ肵A
     * reset() \bhŃ}[N_ ǂݍ݈ʒu
     * ߂悤ɂB<br>
     * InputStream  mark() ƈႢA readLimit Őݒ肵
     * EoCgOɃ}[NʒuɂȂ\B
     * AreadLimit 𖳎Ė reset() \ 
     * InputStream ƐڑĂꍇ readLimit 
     * ǂ̂悤Ȓlݒ肳Ă
     * reset() ŕK}[Nʒuɕł鎖ۏ؂B<br>
     * 
     * @param readLimit }[Nʒuɖ߂ẼoCgB
     *                  ̃oCg𒴂ăf[^ǂ
     *                  񂾏ꍇ reset()łȂȂ
     *                  \B<br>
     * 
     * @see PreLzssDecoder#mark(int)
     */
    public void mark( int readLimit ){
        readLimit -= (int)( this.TextDecoded - this.TextPosition );
        int Size = this.TextBuffer.length - this.MaxMatch;
        readLimit = ( readLimit + Size - 1 ) / Size * Size;
        this.decoder.mark( Math.max( readLimit, 0 ) );

        if( this.MarkTextBuffer == null ){
            this.MarkTextBuffer = (byte[])this.TextBuffer.clone();
        }else{
            System.arraycopy( this.TextBuffer, 0, 
                              this.MarkTextBuffer, 0, 
                              this.TextBuffer.length );
        }
        this.MarkTextPosition = this.TextPosition;
        this.MarkTextDecoded  = this.TextDecoded;
    }

    /**
     * ڑꂽ̓Xg[̓ǂݍ݈ʒuŌ
     * mark() \bhĂяoꂽƂ̈ʒuɐݒ肷B<br>
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void reset() throws IOException {
        if( this.MarkTextBuffer == null ){
            throw new IOException( "not marked." );
        }else if( this.TextDecoded - this.MarkTextPosition 
               <= this.TextBuffer.length ){
            this.TextPosition = this.MarkTextPosition;
        }else if( this.decoder.markSupported() ){
            //reset
            this.decoder.reset();                                               //throws IOException
            System.arraycopy( this.MarkTextBuffer, 0, 
                              this.TextBuffer, 0, 
                              this.TextBuffer.length );
            this.TextPosition = this.MarkTextPosition;
            this.TextDecoded  = this.MarkTextDecoded;
        }else{
            throw new IOException( "mark/reset not supported." );
        }
    }

    /**
     * ڑꂽ̓Xg[ mark()  reset() 
     * T|[g邩𓾂B<br>
     * 
     * @return Xg[ mark()  reset() 
     *         T|[gꍇ trueB<br>
     *         T|[gȂꍇ falseB<br>
     */
    public boolean markSupported(){
        return  this.decoder.markSupported();
    }


    //------------------------------------------------------------------
    //  method of java.io.InputStream
    //------------------------------------------------------------------
    //  other methods
    //------------------------------------------------------------------
    //  public int available()
    //  public void close()
    //------------------------------------------------------------------
    /**
     * ڑꂽ̓Xg[ubNȂ
     * ǂݍނƂ̂łoCg𓾂B<br>
     * 
     * @return ubNȂœǂݏooCgB<br>
     * 
     * @exception IOException o̓G[ꍇ
     */
    public int available() throws IOException {
        return (int)( this.TextDecoded - this.TextPosition )
               + this.decoder.available();
    }

    /**
     * ̓̓Xg[AgpĂ
     * SẴ\[XJB<br>
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void close() throws IOException {
        this.decoder.close();
        this.decoder        = null;
        this.TextBuffer     = null;
        this.MarkTextBuffer = null;
    }


    //------------------------------------------------------------------
    //  local method
    //------------------------------------------------------------------
    //  private void decode()
    //  private int copyTextBufferToBuffer( byte[] buffer, int position, int end )
    //  private void initLz5TextBuffer()
    //------------------------------------------------------------------
    /**
     * privateϐ this.in 爳kf[^ǂݍ
     * 𓀂Ȃ TextBuffer Ƀf[^ށB
     * 
     * @exception IOException  o̓G[ꍇ
     * @exception EOFException Xg[I[ɒBꍇ
     */
    private void decode() throws IOException {
        if( this.TextDecoded < this.Length ){
            final int  TextMask  = this.TextBuffer.length - 1;
            final int  TextStart = (int)this.TextDecoded & TextMask;
            int        TextPos   = TextStart;
            int        TextLimit = (int)( Math.min( this.TextPosition 
                                                         + this.TextBuffer.length 
                                                         - this.MaxMatch,
                                                     this.Length ) 
                                           - this.TextDecoded ) + TextStart;
            try{
                while( TextPos < TextLimit ){
                    int Code = this.decoder.readCode();                             //throws EOFException IOException

                    if( Code < 0x100 ){
                        this.TextBuffer[ TextMask & TextPos++ ] = (byte)Code;
                    }else{
                        int MatchLength   = ( Code & 0xFF ) + this.Threshold;
                        int MatchPosition = TextPos - this.decoder.readOffset() - 1;//throws IOException

                        while( 0 < MatchLength-- )
                            this.TextBuffer[ TextMask & TextPos++ ]
                                = this.TextBuffer[ TextMask & MatchPosition++ ];
                    }
                }
            }finally{
                this.TextDecoded += TextPos - TextStart;
            }
        }else{
            throw new EOFException();
        }
    }

    /**
     * private ϐ this.TextBuffer  bufferɃf[^]B
     * 
     * @param buffer   TextBuffer̓eRs[obt@
     * @param position buffeȑ݌݈ʒu
     * @param end      buffeȑݏIʒu
     * 
     * @return buffer̎ɏ݂sׂʒu
     */
    private int copyTextBufferToBuffer( byte[] buffer, int position, int end ){
        if( ( this.TextPosition & ~( this.TextBuffer.length - 1 ) )
              < ( this.TextDecoded & ~( this.TextBuffer.length - 1 ) ) ){
            int length = Math.min( this.TextBuffer.length - 
                                     ( (int)this.TextPosition 
                                          & this.TextBuffer.length - 1 ),
                                     end - position );

            System.arraycopy( this.TextBuffer, 
                              (int)this.TextPosition
                                 & this.TextBuffer.length - 1,
                              buffer, position, length  );

            this.TextPosition += length;
            position          += length;
        }

        if( this.TextPosition < this.TextDecoded ){
            int length = Math.min( (int)( this.TextDecoded 
                                          - this.TextPosition ),
                                     end - position );

            System.arraycopy( this.TextBuffer, 
                              (int)this.TextPosition
                                 & this.TextBuffer.length - 1,
                              buffer, position, length  );

            this.TextPosition += length;
            position          += length;
        }

        return position;
    }

    /**
     * -lz5- p TextBuffer B
     */
    private void initLz5TextBuffer(){
        int position = 18;
        for( int i = 0 ; i < 256 ; i++ )
            for( int j = 0 ; j < 13 ; j++ )
                this.TextBuffer[ position++ ] = (byte)i;

        for( int i = 0 ; i < 256 ; i++ )
            this.TextBuffer[ position++ ] = (byte)i;

        for( int i = 0 ; i < 256 ; i++ )
            this.TextBuffer[ position++ ] = (byte)(255 - i);

        for( int i = 0 ; i < 128 ; i++ )
            this.TextBuffer[ position++ ] = 0;

        while( position < this.TextBuffer.length )
            this.TextBuffer[ position++ ] = (byte)' ';
    }

}
//end of LzssInputStream.java
