/*
 ***** BEGIN LICENSE BLOCK *****
 * Version: EPL 2.0/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Eclipse Public
 * License Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.eclipse.org/legal/epl-v10.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * Copyright (C) 2013-2017 The JRuby Team (jruby@jruby.org)
 * 
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the EPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the EPL, the GPL or the LGPL.
 ***** END LICENSE BLOCK *****/
package org.jruby.parser;

public class YyTables {
   private static short[] combine(short[] t1, short[] t2, 
                                  short[] t3, short[] t4) {
      short[] t = new short[t1.length + t2.length + t3.length + t4.length];
      int index = 0;
      System.arraycopy(t1, 0, t, index, t1.length);
      index += t1.length;
      System.arraycopy(t2, 0, t, index, t2.length);
      index += t2.length;
      System.arraycopy(t3, 0, t, index, t3.length);
      index += t3.length;
      System.arraycopy(t4, 0, t, index, t4.length);
      return t;
   }

   public static final short[] yyTable() {
      return combine(yyTable1(), yyTable2(), yyTable3(), yyTable4());
   }

   public static final short[] yyCheck() {
      return combine(yyCheck1(), yyCheck2(), yyCheck3(), yyCheck4());
   }
   private static final short[] yyTable1() {
      return new short[] {

          305,  378,  308,  487,  307,   88,   88,  134,  134,  418, 
          214,  420,  250,  250,  250,  228,  302,  276,  250,  250, 
          354,  664,  250,  230,  645,   83,   83,  683,  465,  427, 
          603,  324,  352,  288,  288,  228,  107,  288,  670,  643, 
          440,  630,  616,  230,  215,  215,  643,  631,   88,  577, 
          133,  133,  350,  632,  250,  260,  360,  643,  682,    8, 
          133,  682,  710,  579,  644,  215,  683,  292,  292,    8, 
          643,  292,  301,  659,  254,  257,  632,  571,  643,  293, 
          304,  291,  291,  577,  304,  291,  256,  673,  643,  293, 
          215,  599,  435,  607,  707,  133,  612,  579,  577,  331, 
          335,  433,  350,  692,  526,   86,  578,  795,  528,  782, 
          256,  571,  579,  330,  745,  643,  272,  805,    8,  643, 
          644,   73,   72,  286,  514,  802,  571,  589,  934,  431, 
          387,  250,  602,   88,  599,  255,  607,  997,  293,  811, 
          578, 1020,  841,  256,  393,  133,  704,  256,  260,  343, 
          644,  314,  643,  629, 1027,  578,  376,  432,  785,  255, 
          787,  589,  563,  301,  643,  643,  571,  852,  274,  523, 
          823,  461,   71,  643,  563,  643,  589,  807,  500,  387, 
          297,  602,  449,  775,  644,  643,  273,  432,  563,  638, 
          450,  310,  255,  393,  384,  385,  255,  475,  343,  376, 
          571,  643,  748,  522,  643,  643,  487,  638,  745,  644, 
          745,  563,  842,  408,  643,  571,  781,  563,  794,  753, 
          467,  548,  643,  563,  746,  380,  786,  602,  683,   74, 
          408,  623,  836,  509,  643,  436,  749,   88,  377,  597, 
          523,   83,  106,  106,  300, 1020,  501,  502,   75,  106, 
          106,  106,  373,  755,  997,  106,  106, 1027,  563,  106, 
          300,  682,  682,   86,  250,  250,  877,  378,  724,  725, 
          548,  534,  884,  597,  525,  304,  602,   81,  381,  530, 
           72,  377,  745,   79,  946,  106,   76,  934,  597,  950, 
          304,  106,   83,  819,  376,  386,  924,  379,  315,   75, 
          250,  260,  250,  250,  324,  374,  250,   84,  250, 1059, 
          867,  377,  375,   88,  310,  288,  942,  288,  288,   88, 
           77,   88,  365,  797,  794,  470,  471,  401,   81,   82, 
          250,  403,  404,   53,   79,  890,  367,   76,  632,  512, 
           72,  293,  293,  293,  577,  517,  293,  293,  293,  292, 
          293,  292,  350,  632,  642,  632,  371,  667,   84,  632, 
          384,  385, 1010,  291,  260,  291,  986,  456,  106,  643, 
          106,   77,  293,  293,  293,  293,  293,  790,  643,  915, 
           82,  577,  250,  250,  250,  250,   88,  250,  250,  430, 
          616,  613,  815,  617,  373,  133,  644,  627,  631,  644, 
          456,  536,  537,  587,  630,  745,  566,  745,  539,  625, 
          631,  324,  579,  643,  577,  303,  643,  412,  293,  643, 
          250,  293,    8,  643,  643,  250,  571,  250,   88,  350, 
          643,  250,  250,  643,   88,  288,  892,  587,  423,  808, 
          643, 1053,  293,  562,  563,  564,  565,  250,  272,   88, 
          250,  272,  587,   73,   83,  578,  608,  683,  424,  608, 
           88,  571,  288,  250,  633,  530,  293,  988,   88,  609, 
          422,  965,  133,  821,  106,   17,  589,  250,  288,  387, 
          690,  602,  643,  608,  643,   92,   92,  135,  135,  643, 
          622,  682,  288,  393,  622,  428,  609,  277,  571,  608, 
          274,  106,  106,  274,  867,  319,  563,  250,  867,   88, 
           83,  228,  609,  608,  669,  669,  548,   75,  273,  230, 
           88,  273,  602,  310,   17,  429,  609,  815,   92,   83, 
         1083,  571,  351,  665,  597,  681,  250,  106,  350,  106, 
          106,  215,  466,  106, 1030,  106,   81,  608,  441,  563, 
          106,  288,   79,  548,  530,   76,  106,  380,  106,  602, 
          609,   74,   16,  536,  537,   80,  745,  106,  754,  303, 
          539,  597,  608,   83,  700,  452,   84,  761,  498,   78, 
           75,  133,  351,  438,  373,  609,  548,  439,  597,   77, 
          319,  455,  602,  462,  759,  463,   43,  464,   82,  378, 
          518,  519,  765,  467,  597,  516,   43,  768,  469,   81, 
          381,   16,  867,   92,  476,   79,   80,  761,   76,  106, 
          106,  106,  106,  106,  106,  106,  376,  350,  789,  379, 
           78,  822,  472,  761,  483,  482,  486,  374,  386,   84, 
          250,   88,  510,  377,  375,  866, 1064,  761,   95,   95, 
          758,   88,   77,  506,  788,   43,  511,  106,  764,  228, 
          278,   82,  106,  764,  106,  106,  527,  230,  106,  106, 
          133,  106,  643,  289,  295,  983,  515,  296,  761,  250, 
          779,  985,  521,  529,  106,  855,  106,  106,  215,  215, 
          643,   95,  758,  643,  643,  764,  886,  106,  587,   88, 
          106,  780,  546,  414,  350,  106,  530,  932,  535,  644, 
          415,  419,  102,  102,  106,  920,  550,   92,  622,   83, 
          554,  643,  557,  868,  626,  873,  875,   17,   17,   17, 
          634,  880,  882,   17,   17,  587,   17,  504,  816,  647, 
          812,  617,  444,  444,  106,  551,  106,  133,  444,  445, 
          552,  652,  587,  656,   88,  102,   88,  106,   88,  250, 
          250,  654,  643,  684,  718,  250,  250,  666,  587,  719, 
          507,  688,  689,  106,  736,  250,   95,  685,  319,  350, 
          930,  686,  933,  285,  536,  537,  643,  417,  687,  697, 
          558,  539,  693,   92,   52,  559,  544,   88,  445,   92, 
          250,   92,  724,  725,   52,  696,  932,   17,  701,  444, 
          868,   88,   88,   88,   16,   16,   16,  712,  845,  847, 
           16,   16,  133,   16,  894,  747,  756,  772,   17,  460, 
          868,  898,  351,  757,   80,  643,  866,  476,  726,  866, 
          102,  866,  476,  866,   88,   88,  762,  961,   78,  478, 
         1041,  126,   17,   52,  478,  763,  669,  773,   43,   43, 
           43,  907,  932,  776,   43,   43,   92,   43,  736,  954, 
          736,  783,  794,  800,   96,  801,  803,  106,  106, 1014, 
           95,  250,  804, 1018,  806,  319,  818,  837,  106,   43, 
           43,   43,   43,   43,   16,   88,   88,   80,  774,  838, 
          126, 1034,  474,  980,  110,  460,  839,   88,   92,  351, 
          932,   78,  133,  844,   92,   16,  106,  655,  846,  329, 
          333,  784,  848,  122,  850,  663,  643,  511,  851,   92, 
          879,  643,  313,  643,  854,  871,  106,  878,   43,   16, 
           92, 1044,  736,  866,  102,  866,  133,  866,   92,  895, 
          866,  533,  897,  110,  444,  488,   95,  491, 1023,   43, 
          900,  511,   95,  904,   95,  908,  817,  909,  910,   88, 
          916,  917,  122,  922,  820,  940,  511,  713,  943,  714, 
          715,  716,  717,   43,  866,  511,   88, 1079,   88,   92, 
          945,  106,  947,  106,   88,  106,  106,  106,  949, 1060, 
           92,  133,  106,  106,  435,  955,  445,  957,  511, 1000, 
          956,  958,  106,  103, 1004, 1006,  960, 1008,  351, 1009, 
          102,  989,  107,  990,  414,  995,  102,  999,  102,   95, 
         1002,  415,  416,  998,  106, 1001,  250,  106,  761, 1003, 
          643,   88, 1005, 1007,  643,  643,  414,  103,  106,  106, 
          106,  288, 1013,  415,  443, 1021,   52,   52,   52, 1033, 
          896,   52,   52,   52,  103,   52,  414, 1029, 1028,  313, 
          621,   95,  608,  415,  459,   52, 1061,   95,  445, 1031, 
          994,  106,  106, 1039, 1047,  609, 1049,   52,   52,   52, 
           52,   52,   95,  102,  435,  536,  537,  538,  832,  285, 
         1051, 1054,  539,   95,  313, 1072, 1069,  351,  126,  285, 
          923,   95,  713, 1074,  714,  715,  716,  717,  106,  103, 
         1084,   92,  379,  380,  381,  382,  383, 1073, 1075, 1076, 
         1077,   92,  106,  106, 1088,  102,   52,  630,  313,  414, 
          643,  102,  414,  285,  106,  643,  415,  473,  632,  415, 
          508,  631,   95,  313,  636, 1040,  102,   52,  285,  632, 
          636,  110,  632,   95,  643,  638,  435,  102,  632,  313, 
         1092,  375,  493,  480,  614,  102,  313,  313,  363,   92, 
          122,   52,  618,  137,  351,  313,  698,  556,  414, 1068, 
          217,  414,  829,  435,  993,  415,  532,  614,  415, 1022, 
          769, 1071,  931,  536,  537,  541,  106,  966,  832,  921, 
          539,  869,  858,  870,  936,  872,  102,   97,  248,  248, 
          248, 1015,  511,  106, 1016,  106,  885,  102,  279,  511, 
          511,  106, 1085, 1067,   92,  614,   92,   97,   92,  919, 
            0,  435, 1082,  332,    0,  511,    0,    0,  435,  435, 
            0,    0,  511,  511,  903,    0,  614,  126,  614,  351, 
          536,  537,  543,    0,  517,    0,    0,  539,  912,  913, 
          914,   97,    0,  106,    0,  435,  511,   92,  106,  614, 
            0,    0,  103,  435,   95,  290,    0,    0,   97,  493, 
            0,   92,   92,   92,   95,  290,  414,    0,  832,  865, 
          832,  928,  929,  415, 1032,  542,  313,  545,    0,  548, 
          536,  537,  541,  313,  313,  548,  493,  539,  517,  618, 
            0,  536,  537,  547,   92,   92,  107,  677,  539,  285, 
            0,  435,  493,    0,    0,  113,    0,  437,  435,  435, 
          825,  826,   95,  827,  290,  103,  493,    0,  102,  135, 
            0,    0,  964,    0,  122,  435,    0,    0,  102,    0, 
          107,  285,  285,  285,  984,  435,  285,  285,  285,    0, 
          285,    0,    0,  832, 1042,   92,   92,  107,   96,  514, 
          285,  285,    0,  981,  113,    0,    0,   92,  386,  285, 
          285,    0,  285,  285,  285,  285,  285,   95,  938,   95, 
            0,   95,    0,  435,    0,  493,  102,  313,   59,   60, 
          435,  435,    0,  514,    0,    0,  514,  832,  621,  832, 
          401,    0,  313,  542,  403,  404,  405,  406,  514,  313, 
          313,    0,  752,  752,    0,  618,    0,  435,  135,    0, 
           95,  285,    0, 1035,  285, 1036,  285,    0,    0,   92, 
          832, 1037,  116,  313,   95,   95,   95,  536,  537,  555, 
          514,  102,  285,  102,  539,  102,   92,  752,   92,    0, 
          248,  248,    0,  287,   92,    0,  477,  478,  479,  767, 
          643,  481,    0,  287,  767,    0,  285,   95,   95,  304, 
          865,    0,  711,  865,    0, 1017,    0,  865, 1070,  711, 
            0,  517,    0,    0,  102,    0,   97,    0,  517,  517, 
            0,    0,  497,    0,  499,    0,  767,  287,  102,  102, 
          102,   92,    0,    0,  793,  796,   96,  796,    0,  643, 
            0,    0,  287,    0,    0,  796,  520,    0,   95,   95, 
          287,  287,    0,    0,  287,    0,  982,  290,  290,  290, 
           95,  102,  102,  290,  290,  517,  290,  482,  482,  482, 
           96,    0,  517,  517,  482,    0,  311,  313,   96,   97, 
            0,    0,  287,  287,    0,  353,  355,   96,  290,  290, 
          290,  290,  290,    0,  116,    0,    0,    0,  248,  248, 
          248,  248,  113,  567,  568,  107,   96,  865,    0,  865, 
            0,  865,  102,  102,  865,  615,  713,  516,  714,  715, 
          716,  717,   95,  713,  102,  714,  715,  716,  717,  620, 
            0,    0,    0,  630,    0,  621,    0,  290,    0,   95, 
            0,   95,    0,  116,   91,    0,    0,   95,  865,    0, 
          830,    0,    0,  516,  313,    0,    0,  830,  290,  615, 
          752,  313,  313,  514,    0,  831,  646,  618,  107,  621, 
          514,  514,  620,    0,  902,  517,  615,  906,   91,    0, 
            0,    0,  290,    0,  621,    0,  102,  678,  680,    0, 
            0,  332,    0,    0,   95,   91,    0,  615,    0,  464, 
          464,  464,    0,  102,    0,  102,  464,  514,  862,    0, 
            0,  102,    0,    0,  514,  514,  621,  470,  470,  470, 
          615,    0,    0,  691,  470,  511,  541,  680,    0,  713, 
          332,  714,  715,  716,  717,    0,    0,    0,  514,    0, 
            0,  615,  643,  643,  643,  287,  287,  287,    0,  643, 
          287,  287,  287,  386,  287,    0,    0, 1024,  102,  714, 
          715,  716,  717,  830,  287,  287,  115,    0,    0,  399, 
          400,  996,    0,  287,  287,  541,  287,  287,  287,  287, 
          287,   61,   62,   63,   64,  401,    0,  402,    0,  403, 
          404,  405,  406,    0,  796,  713,    0,  714,  715,  716, 
          717,  718,    0,    0,  117,   96,  719,  937,    0,    0, 
          937,    0,    0,    0,  239,  115,  287,  287,  287,  355, 
          770,  287,    0,    0,  239,  287,    0,    0,  287,  720, 
          287,    0,  287,    0,  287,  287,    0,  722,  723,  724, 
          725,  115,    0,  505,    0,    0,  287,  516,    0,    0, 
            0,  116,    0,  117,  516,    0,  248,  791,  239,    0, 
            0,  516,  516,    0,    0,    0,    0,  118,   96,    0, 
          287,    0,  239,  239,    0,  726,    0,  239,    0,    0, 
            0,    0,  813,    0,  814,  518,    0,    0,    0,    0, 
          516,  680,  332,    0,    0,  248,    0,  516,  516,  862, 
            0,    0,  862,    0,  937,  621,  862,  120,    0,  124, 
            0,    0,  517,   91,  614,  493,  118,    0,  796,  517, 
          517,  569,  570,  571,  572,  573,  574,  575,  576,  577, 
          578,  579,  580,  581,  582,  583,  584,  585,  586,  587, 
          588,  589,  590,  591,  592,  593,  594,    0,  519,  853, 
            0,    0,  287,  621,    0,    0,  120,  614,  124,  618, 
          621,  621,  511,  287,  632,    0,  617,    0,    0,  511, 
          511,    0,    0,   98,    0,  614,   91,    0,  889,  287, 
            0,  644,    0,    0,  621,    0,    0,  621,  521,   99, 
          621,  644,    0,    0,    0,  287,  614,  614,  662,  632, 
            0,    0,  287,  101,    0,    0,  862,    0,  862,  287, 
          862,    0,  911,  862,    0,    0,  248,  287,  287,    0, 
          518,  287,  541,  115,  541,  541,  541,  541,  541,    0, 
            0,    0,    0,  541,    0,   94,  519,    0,    0,  123, 
          644,    0,    0,    0,    0,  694,  695,  862,    0,    0, 
          521,    0,    0,  291,    0,    0,  541,  287,    0,  939, 
          287,  117,    0,  291,  541,  541,  541,  541,  287,   94, 
            0,    0,    0,    0,    0,    0,  239,  239,  239,    0, 
            0,  239,  239,  239,  516,  239,   94,    0,  123,    0, 
            0,  516,  516,  963,    0,  239,  239,  287,    0,    0, 
            0,    0,  541,    0,  239,  239,    0,  239,  239,  239, 
          239,  239,  291,    0,    0,    0,  514,    0,    0,  239, 
          617,  332,  518,    0,  118,    0,    0,    0,    0,  518, 
          518,    0,  239,  239,  239,  239,  239,  239,  239,  239, 
          239,  239,    0,  239,  239,    0,    0,  239,  239,    0, 
          287,    0,    0,  239,    0,    0,  239,    0,    0,  239, 
            0,  239,    0,  239,  120,  239,  124,  239,  239,  239, 
          239,  239,  239,  239,    0,  239,    0,  239,    0,  621, 
            0,    0,    0,    0,    0,  519,    0,  287,    0,  239, 
            0,    0,  519,  519,    0,  511,    0,    0,    0,    0, 
            0,  239,    0,    0,    0,  511,    0,    0,  117,  630, 
          630,  630,  287,    0,  287,  630,  630,    0,  630,    0, 
            0,  287,  287,    0,  118,  521,    0,  621,    0,    0, 
            0,    0,  521,  521,  621,  621,    0,    0,  120,  511, 
          617,    0,    0,  644,  644,  644,    0,    0,  644,  644, 
          644,    0,  644,  511,  511,    0,  110,  518,  511,    0, 
            0,  621,  644,  644,  518,  518,    0,    0,    0,    0, 
            0,  644,  644,  519,  644,  644,  644,  644,  644,  287, 
          519,  519,    0,    0,    0,    0,  511,  521,    0,  630, 
            0,  874,  876,    0,  521,  521,  123,  881,  883,    0, 
            0,    0,    0,    0,   94,  615,  887,  662,  287,  617, 
          630,    0,  891,    0,    0,  291,  291,  291,    0,    0, 
          291,  291,  291,  644,  291,    0,  644,  514,  644,    0, 
            0,    0,    0,    0,  630,  874,  876,  514,  881,  883, 
            0,    0,  287,    0,  644,    0,  291,  291,  291,  291, 
          291,    0,    0,  514,    0,    0,    0,  617,    0,    0, 
          514,  514,    0,    0,  617,  617,  615,   94,  644,    0, 
          617,  514,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  514,  514,  615,  113,  287, 
          514,  617,  291,    0,  713,  291,  714,  715,  716,  717, 
          718,    0,    0,    0,    0,  719,  959,    0,    0,    0, 
            0,    0,    0,  962,    0,    0,  291,    0,  514,    0, 
            0,    0,    0,  287,    0,    0,    0,    0,  720,  721, 
            0,    0,    0,    0,    0,    0,  722,  723,  724,  725, 
          291,    0,    0,    0,  962,    0,    0,  206,    0,    0, 
            0,  287,  614,  614,  614,    0,  614,  511,  511,  511, 
          614,  614,  511,  511,  511,  614,  511,  614,  614,  614, 
          614,  614,  614,  614,  726,  614,  511,  511,  614,  614, 
          614,  614,  614,  614,  614,  511,  511,  614,  511,  511, 
          511,  511,  511,    0,  614,    0,  206,  614,  614,  614, 
          511,  614,  614,  614,  614,  614,  614,  614,  614,  614, 
          614,  614,  511,  511,  511,  511,  511,  511,  511,  511, 
          511,  511,  511,  511,  511,  511,    0,    0,  511,  511, 
          511,  511,  614,  523,  511,  614,  614,  511,  614,  614, 
          511,  614,  511,  614,  511,  614,  511,  614,  511,  511, 
          511,  511,  511,  511,  511,  614,  511,  614,  511,  100, 
          614,  614,  614,  614,  614,  614,    0,    0,  287,  614, 
          511,  614,  614,    0,  614,  614,  614,  614,  199,  614, 
          614,  614,  511,    0,  615,  615,  615,    0,  615,  514, 
          514,  514,  615,  615,  514,  514,  514,  615,  514,  615, 
          615,  615,  615,  615,  615,  615,  520,  615,  514,  514, 
          615,  615,  615,  615,  615,  615,  615,  514,  514,  615, 
          514,  514,  514,  514,  514,    0,  615,  199,    0,  615, 
          615,  615,  514,  615,  615,  615,  615,  615,  615,  615, 
          615,  615,  615,  615,  514,  514,  514,  514,  514,  514, 
          514,  514,  514,  514,  514,  514,  514,  514,  102,    0, 
          514,  514,  514,  514,  615,  526,  514,  615,  615,  514, 
          615,  615,  514,  615,  514,  615,  514,  615,  514,  615, 
          514,  514,  514,  514,  514,  514,  514,  615,  514,  615, 
          514,    0,  615,  615,  615,  615,  615,  615,    0,    0, 
          621,  615,  514,  615,  615,  522,  615,  615,  615,  615, 
          621,  615,  615,  615,  514,  631,  631,  631,    0,    0, 
            0,  631,  631,    0,  631,    0,  713,    0,  714,  715, 
          716,  717,  718,    0,    0,    0,    0,  719,    0,    0, 
            0,    0,    0,  206,  621,  206,  206,  206,  206,  206, 
            0,    0,    0,    0,  206,    0,    0,    0,  621,  621, 
          720,  124,    0,  621,  386,  517,    0,    0,  722,  723, 
          724,  725,    0,  517,    0,    0,    0,  206,  206,    0, 
          399,  400,    0,    0,    0,  206,  206,  206,  206,    0, 
            0,  621,    0,    0,  119,  631,  401,    0,    0,    0, 
          403,  404,  405,  406,    0,    0,  726,    0,  713,    0, 
          714,  715,  716,  717,  718,    0,  631,    0,    0,  719, 
            0,    0,  386,  206,    0,    0,    0,  391,  392,    0, 
            0,  617,    0,    0,    0,    0,    0,    0,  399,  400, 
          631,  617,  720,  520,    0,    0,    0,    0,    0,    0, 
          520,  520,  724,  725,  401,    0,  402,    0,  403,  404, 
          405,  406,  407,  408,  409,    0,  410,    0,    0,    0, 
            0,    0,    0,    0,  199,  617,  199,  199,  199,  199, 
          199,    0,    0,    0,    0,  199,    0,    0,  726,  617, 
          617,    0,  123,  121,  617,    0,  516,  386,  387,  388, 
          389,  390,  391,  392,  516,    0,  395,  396,  199,  199, 
            0,    0,    0,  399,  400,    0,  199,  199,  199,  199, 
            0,    0,  617,    0,    0,    0,    0,    0,    0,  401, 
            0,  402,    0,  403,  404,  405,  406,  407,  408,  409, 
            0,  410,  522,    0,    0,    0,    0,    0,    0,  522, 
          522,  209,    0,    0,  199,    0,    0,  617,  617,  617, 
            0,  617,  621,  621,  621,  617,  617,  621,  621,  621, 
          617,  621,  617,  617,  617,  617,  617,  617,  617,    0, 
          621,  621,  621,  617,  617,  617,  617,  617,  617,  617, 
          621,  621,  617,  621,  621,  621,  621,  621,    0,  617, 
          209,    0,  617,  617,  617,  621,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  621,  621,  621, 
          621,  621,  621,  621,  621,  621,  621,  621,  621,  621, 
          621,   93,    0,  621,  621,  621,  621,  617,    0,  621, 
          617,  617,  621,  617,  617,  621,  617,  621,  617,  621, 
          617,  621,  617,  621,  621,  621,  621,  621,  621,  621, 
          617,  621,  621,  621,    0,  617,  617,  617,  617,  617, 
          617,    0,    0,    0,  617,  621,  617,  617,  513,  617, 
          617,  617,  617,    0,  617,  617,  617,  621,  617,  617, 
          617,    0,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
            0,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,    0, 
          617,    0,    0,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,   92,    0,  617,  617,  617,  617,  617,    0, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,    0,  617,  617,  617,  617, 
          617,  617,    0,    0,  618,  617,  617,  617,  617,  512, 
          617,  617,  617,  617,  618,  617,  617,  617,  617,    0, 
          944,    0,    0,    0,  948,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  209,  618,  209, 
          209,  209,  209,  209,    0,    0,    0,    0,  209,    0, 
            0,    0,  618,  618,    0,  125,  112,  618,    0,  518, 
            0,    0,    0,    0,    0,    0,    0,  518,    0,    0, 
            0,  209,  209,    0,    0,    0,    0,    0,    0,  209, 
          209,  209,  209,    0,    0,  618,    0,    0,    0,    0, 
          386,  387,  388,  389,  390,  391,  392,  393,  394,  395, 
          396,    0,    0,    0,  386,  513,  399,  400,    0,    0, 
            0,    0,  513,  513,    0,    0,    0,  209,    0,    0, 
          399,  400,  401,    0,  402,  304,  403,  404,  405,  406, 
          407,  408,  409,    0,  410,  304,  401,    0,  402,    0, 
          403,  404,  405,  406,    0,    0,  409,    0,  410,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0, 1048,    0,    0, 1050, 1052,  304, 
            0, 1055, 1056,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  304,  304,    0,    0,  111,  304,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  304,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0, 1087, 1089, 1090, 1091,    0,  512,    0,    0,    0, 
            0,    0,    0,  512,  512,  194, 1094,    0,    0,    0, 
            0,  618,  618,  618,    0,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,    0,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,    0,  618,  194,    0,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,   95,    0,  618,  618,  618, 
          618,  618,    0,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,    0,  618, 
          618,  618,  618,  618,  618,    0,    0,    0,  618,  618, 
          618,  618,  515,  618,  618,  618,  618,    0,  618,  618, 
          618,  618,  616,  616,  616,    0,  616,  304,  304,  304, 
          616,  616,  304,  304,  304,  616,  304,  616,  616,  616, 
          616,  616,  616,  616,    0,  616,  304,  304,  616,  616, 
          616,  616,  616,  616,  616,  304,  304,  616,  304,  304, 
          304,  304,  304,    0,  616,    0,    0,  616,  616,  616, 
          304,  616,  616,  616,  616,  616,  616,  616,  616,  616, 
          616,  616,  304,  304,  304,  304,  304,  304,  304,  304, 
          304,  304,  304,  304,  304,  304,  109,    0,  304,  304, 
          304,  304,  616,    0,  304,  616,  616,  304,  616,  616, 
          304,  616,  304,  616,  304,  616,  304,  616,  304,  304, 
          304,  304,  304,  304,  304,  616,  304,  616,  304,    0, 
          616,  616,  616,  616,  616,  616,    0,    0,  622,  616, 
          304,  616,  616,  303,  616,  616,  616,  616,  622,  616, 
          616,  616,  304,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  194,  622,  194,  194,  194,  194,  194,    0,    0, 
            0,    0,  194,    0,    0,    0,  622,  622,    0,    0, 
          114,  622,    0,  519,    0,    0,    0,    0,    0,    0, 
            0,  519,    0,    0,    0,  194,  194,    0,    0,    0, 
            0,    0,    0,  194,  194,  194,  194,    0,    0,  622, 
            0,    0,    0,    0,  386,  387,  388,  389,  390,  391, 
          392,  393,    0,  395,  396,    0,    0,    0,    0,  515, 
          399,  400,    0,    0,    0,    0,  515,  515,    0,    0, 
            0,  194,    0,    0,    0,    0,  401,    0,  402,  623, 
          403,  404,  405,  406,  407,  408,  409,    0,  410,  623, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  596,  597,    0,    0,  598,    0,    0,    0,  183, 
          184,    0,  185,  186,  187,  188,  189,  190,  191,    0, 
            0,  192,  193,  623,    0,    0,  194,  195,  196,  197, 
            0,    0,    0,    0,    0,    0,  300,  623,  623,    0, 
            0,  128,  623,  199,  200,    0,  201,  202,  203,  204, 
          205,  206,  207,  208,  209,  210,  211,    0,    0,  212, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          623,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  213,    0,    0,    0,    0,    0,    0,    0,    0, 
          303,    0,    0,    0,    0,    0,    0,  303,  303,  176, 
            0,    0,    0,    0,    0,  619,  619,  619,    0,  619, 
          622,  622,  622,  619,  619,  622,  622,  622,  619,  622, 
          619,  619,  619,  619,  619,  619,  619,    0,  622,  622, 
          622,  619,  619,  619,  619,  619,  619,  619,  622,  622, 
          619,  622,  622,  622,  622,  622,    0,  619,  176,    0, 
          619,  619,  619,  622,  619,  619,  619,  619,  619,  619, 
          619,  619,  619,  619,  619,  622,  622,  622,  622,  622, 
          622,  622,  622,  622,  622,  622,  622,  622,  622,  108, 
            0,  622,  622,  622,  622,  619,    0,  622,  619,  619, 
          622,  619,  619,  622,  619,  622,  619,  622,  619,  622, 
          619,  622,  622,  622,  622,  622,  622,  622,  619,  622, 
          622,  622,    0,  619,  619,  619,  619,  619,  619,    0, 
            0,    0,  619,  622,  619,  619,  314,  619,  619,  619, 
          619,    0,  619,  619,  619,  622,  620,  620,  620,    0, 
          620,  623,  623,  623,  620,  620,  623,  623,  623,  620, 
          623,  620,  620,  620,  620,  620,  620,  620,    0,  623, 
          623,  623,  620,  620,  620,  620,  620,  620,  620,  623, 
          623,  620,  623,  623,  623,  623,  623,  411,  620,    0, 
            0,  620,  620,  620,  623,  620,  620,  620,  620,  620, 
          620,  620,  620,  620,  620,  620,  623,  623,  623,  623, 
          623,  623,  623,  623,  623,  623,  623,  623,  623,  623, 
            0,    0,  623,  623,  623,  623,  620,    0,  623,  620, 
          620,  623,  620,  620,  623,  620,  623,  620,  623,  620, 
          623,  620,  623,  623,  623,  623,  623,  623,  623,  620, 
          623,  623,  623,    0,  620,  620,  620,  620,  620,  620, 
            0,    0,  313,  620,  623,  620,  620,    0,  620,  620, 
          620,  620,  313,  620,  620,  620,  623,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  176,  313,  176,  176,  176, 
          176,  176,    0,    0,    0,    0,  176,    0,    0,    0, 
          313,  313,    0,  126,  127,  313,    0,  521,    0,    0, 
            0,    0,    0,    0,    0,  521,    0,    0,    0,  176, 
          176,    0,    0,    0,    0,    0,    0,  176,  176,  176, 
          176,    0,    0,  313,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  314,    0,    0,    0,    0,    0,    0, 
          314,  314,    0,    0,    0,  176,    0,    0,    0,    0, 
            0,    0,    0,  434,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  434,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  771,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  434,    0,    0, 
            0,  386,  387,  388,  389,  390,  391,  392,  393,  394, 
          395,  396,  434,  397,  398,    0,  434,  399,  400,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  401,    0,  402,    0,  403,  404,  405, 
          406,  407,  408,  409,  434,  410,    0,    0,    0,    0, 
            0,    0,  177,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  618, 
          618,  618,    0,  618,  313,  313,  313,  618,  618,  313, 
          313,  313,  618,  313,  618,  618,  618,  618,  618,  618, 
          618,  177,    0,  313,  313,  618,  618,  618,  618,  618, 
          618,  618,  313,  313,  618,  313,  313,  313,  313,  313, 
            0,  618,    0,    0,  618,  618,  618,  313,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,  618,  313, 
          313,  313,  313,  313,  313,  313,  313,  313,  313,  313, 
          313,  313,  313,   91,    0,  313,  313,  313,  313,  618, 
            0,  313,  618,  618,  313,  618,  618,  313,  618,  313, 
          618,  313,  618,  313,  618,  313,  313,  313,  313,  313, 
          313,  313,  618,  313,    0,  313,    0,  618,  618,  618, 
          618,  618,  618,    0,    0,    0,  618,  313,  618,  618, 
          511,  618,  618,  618,  618,    0,  618,  618,  618,  313, 
          280,  280,  280,    0,  280,  434,  434,  434,  280,  280, 
          434,  434,  434,  280,  434,  280,  280,  280,  280,  280, 
          280,  280,  411,  434,  434,  434,  280,  280,  280,  280, 
          280,  280,  280,  434,  434,  280,  434,  434,  434,  434, 
          434,    0,  280,    0,    0,  280,  280,  280,    0,  280, 
          280,  280,  280,  280,  280,  280,  280,  280,  280,  280, 
          434,  434,  434,  434,  434,  434,  434,  434,  434,  434, 
          434,  434,  434,  434,  643,    0,  434,  434,  434,  434, 
          280,    0,  434,  280,  643,  434,  280,  280,  434,  280, 
          434,  280,  434,  280,  434,  280,  434,  434,  434,  434, 
          434,  434,  434,  280,  434,  434,  434,    0,  280,  280, 
          280,  280,  280,  280,    0,    0,    0,  280,  643,  280, 
          280,    0,  280,  280,  280,  280,    0,  280,  280,  280, 
          434,    0,    0,  643,    0,    0,    0,  643,  177,    0, 
          177,  177,  177,  177,  177,    0,    0,    0,    0,  177, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          520,    0,    0,    0,    0,  643,    0,    0,  520,    0, 
            0,    0,  177,  177,    0,    0,    0,    0,  110,  614, 
          177,  177,  177,  177,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  320,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  320,    0,    0,  177,    0, 
            0,    0,    0,    0,    0,    0,    0,  511,    0,    0, 
            0,    0,    0,    0,  511,  511,    0,    0,    0,    0, 
          614,    0,    0,    0,    0,    0,    0,    0,    0,  320, 
            0,    0,    0,    0,    0,    0,  777,    0,    0,    0, 
            0,  614,    0,    0,  320,    0,    0,    0,  320,    0, 
            0,    0,    0,    0,    0,    0,  386,  387,  388,  389, 
          390,  391,  392,  393,  394,  395,  396,    0,  397,  398, 
            0,    0,  399,  400,    0,    0,  320,    0,    0,    0, 
            0,    0,    0,    0,  178,    0,    0,    0,  401,    0, 
          402,    0,  403,  404,  405,  406,  407,  408,  409,    0, 
          410,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  280,  280,  280,    0,  280,  643,  643,  643,  280, 
          280,  643,  643,  643,  280,  643,  280,  280,  280,  280, 
          280,  280,  280,  178,  643,  643,  643,  280,  280,  280, 
          280,  280,  280,  280,  643,  643,  280,  643,  643,  643, 
          643,  643,    0,  280,    0,    0,  280,  280,  280,    0, 
          280,  280,  280,  280,  280,  280,  280,  280,  280,  280, 
          280,  643,  643,  643,  643,  643,  643,  643,  643,  643, 
          643,  643,  643,  643,  643,   94,    0,  643,  643,  643, 
          643,  280,    0,  643,  280,    0,  643,  280,  280,  643, 
          280,  643,  280,  643,  280,  643,  280,  643,  643,  643, 
          643,  643,  643,  643,  280,  643,  643,  643,    0,  280, 
          280,  280,  280,  280,  280,    0,    0,    0,  280,    0, 
          280,  280,  514,  280,  280,  280,  280,    0,  280,  280, 
          280,  643,  280,  280,  280,    0,  280,  320,  320,  320, 
          280,  280,  320,  320,  320,  280,  320,  280,  280,  280, 
          280,  280,  280,  280,  411,    0,  320,  320,  280,  280, 
          280,  280,  280,  280,  280,  320,  320,  280,  320,  320, 
          320,  320,  320,    0,  280,    0,    0,  280,  280,  280, 
            0,  280,  280,  280,  280,  280,  280,  280,  280,  280, 
          280,  280,  320,  320,  320,  320,  320,  320,  320,  320, 
          320,  320,  320,  320,  320,  320,  511,    0,  320,  320, 
          320,  320,  280,    0,  320,  280,  511,  320,  280,  280, 
          320,  280,  320,  280,  320,  280,  320,  280,  320,  320, 
          320,  320,  320,  320,  320,  280,  320,    0,  320,    0, 
          280,  280,  280,  280,  280,  280,    0,    0,    0,  280, 
           91,  280,  280,    0,  280,  280,  280,  280,    0,  280, 
          280,  280,  320,    0,    0,  511,    0,  110,    0,  511, 
          178,    0,  178,  178,  178,  178,  178,    0,    0,    0, 
            0,  178,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  522,    0,    0,    0,    0,  511,    0,    0, 
          522,    0,    0,    0,  178,  178,    0,    0,    0,    0, 
          113,  615,  178,  178,  178,  178,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  514,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  514,    0,    0, 
          178,    0,    0,    0,    0,    0,    0,    0,    0,  514, 
            0,    0,    0,    0,    0,    0,  514,  514,    0,    0, 
            0,    0,  615,    0,    0,    0,    0,    0,    0,    0, 
            0,   94,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  615,    0,    0,  514,    0,  113,    0, 
          514,    0,    0,    0,    0,    0,    0,   98,  386,  387, 
          388,  389,  390,  391,  392,  393,  394,  395,  396,    0, 
          397,  398,    0,    0,  399,  400,    0,    0,  514,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          401,   98,  402,    0,  403,  404,  405,  406,  407,  408, 
          409,    0,  410,    0,    0,    0,    0,  134,   98,    0, 
            0,    0,    0,  614,  614,  614,    0,  614,  511,  511, 
          511,  614,  614,    0,  511,  511,  614,  511,  614,  614, 
          614,  614,  614,  614,  614,    0,  614,    0,  518,  614, 
          614,  614,  614,  614,  614,  614,  511,  511,  614,  511, 
          511,  511,  511,  511,  135,  614,  134,    0,  614,  614, 
          614,    0,  614,  614,  614,  614,  614,  614,  614,  614, 
          614,  614,  614,  511,  511,  511,  511,  511,  511,  511, 
          511,  511,  511,  511,  511,  511,  511,    0,    0,  511, 
          511,  511,  511,  614,  523,    0,  614,  614,  511,  614, 
          614,    0,  614,  135,  614,  511,  614,  511,  614,  511, 
          511,  511,  511,  511,  511,  511,  614,  511,  614,  511, 
            0,  614,  614,  614,  614,  614,  614,    0,    0,    0, 
          614,    0,  614,  614,    0,  614,  614,  614,  614,    0, 
          614,  614,  614,  511,  615,  615,  615,    0,  615,  514, 
          514,  514,  615,  615,    0,  514,  514,  615,  514,  615, 
          615,  615,  615,  615,  615,  615,    0,  615,  857,    0, 
          615,  615,  615,  615,  615,  615,  615,  514,  514,  615, 
          514,  514,  514,  514,  514,    0,  615,    0,    0,  615, 
          615,  615,    0,  615,  615,  615,  615,  615,  615,  615, 
          615,  615,  615,  615,  514,  514,  514,  514,  514,  514, 
          514,  514,  514,  514,  514,  514,  514,  514,    0,    0, 
          514,  514,  514,  514,  615,  526,   98,  615,  615,  514, 
          615,  615,    0,  615,    0,  615,  514,  615,  514,  615, 
          514,  514,  514,  514,  514,  514,  514,  615,  514,  615, 
          514,    0,  615,  615,  615,  615,  615,  615,  925,    0, 
          621,  615,    0,  615,  615,  935,  615,  615,  615,  615, 
          621,  615,  615,  615,  514,  518,    0,    0,    0,    0, 
            0,    0,  518,  518,    0,    0,    0,    0,    0,   98, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  134,  105,  134,  134,  134,  134,  134, 
            0,    0,    0,    0,  134,    0,    0,    0,    0,  621, 
            0,  124,    0,  621,    0,  511,    0,    0,    0,    0, 
            0,    0,    0,  511,    0,    0,    0,  134,  134,    0, 
            0,    0,    0,    0,    0,  134,  134,  134,  134,    0, 
          135,  621,  135,  135,  135,  135,  135,    0,    0, 1011, 
            0,  135,    0,    0,    0,    0, 1019,    0,    0,    0, 
            0,    0,  514,    0,    0,    0,    0,    0,    0,    0, 
          514,    0,    0,  134,  135,  135,    0,    0,    0,    0, 
            0,  617,  135,  135,  135,  135,    0,    0,    0,    0, 
            0,  617,    0,    0,   99,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0, 1043,    0, 1045,    0, 1046,    0,    0,    0, 
          135,    0,    0,    0,    0,  104,    0,    0,   99,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          617,    0,  123,    0,  617,   99,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0, 1078,    0, 
         1080,    0,    0, 1081,    0,    0,    0,    0,    0,    0, 
            0,    0,  617,    0,    0,  519,    0,    0,    0,    0, 
            0,    0,    0, 1086,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0, 1093,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  617,  617,  617, 
            0,  617,  621,  621,  621,  617,  617,    0,  621,  621, 
          617,  621,  617,  617,  617,  617,  617,  617,  617,    0, 
          621,    0,    0,  617,  617,  617,  617,  617,  617,  617, 
          621,  621,  617,  621,  621,  621,  621,  621,    0,  617, 
          105,    0,  617,  617,  617,    0,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  621,  621,  621, 
          621,  621,  621,  621,  621,  621,  621,  621,  621,  621, 
          621,    0,    0,  621,  621,  621,  621,  617,    0,    0, 
          617,  617,  621,  617,  617,    0,  617,  621,  617,  621, 
          617,  621,  617,  621,  621,  621,  621,  621,  621,  621, 
          617,  621,  621,  621,    0,  617,  617,  617,  617,  617, 
          617,    0,    0,    0,  617,    0,  617,  617,    0,  617, 
          617,  617,  617,    0,  617,  617,  617,  621,  617,  617, 
          617,    0,  617,  617,  617,  617,  617,  617,    0,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
            0,  617,    0, 
      };
   }

   private static final short[] yyTable2() {
      return new short[] {

           99,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,    0,  617,  104,    0, 
          617,  617,  617,    0,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  519, 
            0,  617,  617,  617,  617,  617,  519,  519,  617,  617, 
          617,  617,  617,   99,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,    0,  617,  617,  617,  617,  617,  617,    0, 
            0,  618,  617,    0,  617,  617,    0,  617,  617,  617, 
          617,  618,  617,  617,  617,  617,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  124,  621,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  106,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          618,    0,  125,    0,  618,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  621,    0,    0,    0,    0,    0,    0,  621,  621, 
            0,    0,  618,    0,  617,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  621,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  313,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  313,    0,    0,  101,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  123,  617,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  107,    0,    0,  101, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  313,    0,  126,    0,  313,  101,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  617,    0,    0,    0,    0,    0,    0,  617, 
          617,    0,    0,  313,    0,  617,  521,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  617,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  618,  618, 
          618,    0,  618,  618,  618,  618,  618,  618,    0,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,  618,  618, 
            0,  618,    0,    0,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,  618,    0, 
          618,    0,    0,  618,  618,  618,    0,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,    0,    0,  618,  618,  618,  618,  618,    0, 
            0,  618,  618,  618,  618,  618,    0,  618,    0,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,    0,  618,  618,  618,  618, 
          618,  618,    0,    0,  643,  618,    0,  618,  618,    0, 
          618,  618,  618,  618,  643,  618,  618,  618,  618,  618, 
          618,  618,    0,  618,  313,  313,  313,  618,  618,    0, 
          313,  313,  618,  313,  618,  618,  618,  618,  618,  618, 
          618,    0,    0,    0,  101,  618,  618,  618,  618,  618, 
          618,  618,  313,  313,  618,  313,  313,  313,  313,  313, 
            0,  618,    0,  643,  618,  618,  618,    0,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,  618,  313, 
          313,  313,  313,  313,  313,  313,  313,  313,  313,  313, 
          313,  313,  313,  521,    0,  313,  313,  313,  313,  618, 
          521,  521,  618,  618,  313,  618,  618,  101,  618,    0, 
          618,  313,  618,  313,  618,  313,  313,  313,  313,  313, 
          313,  313,  618,  313,    0,  313,    0,  618,  618,  618, 
          618,  618,  618,    0,    0,  435,  618,    0,  618,  618, 
            0,  618,  618,  618,  618,  435,  618,  618,  618,  313, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  105,    0,  435, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  435,  435,    0,  122,    0,  435,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  105,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  435,    0,  105,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  621,    0, 
            0,  280,  280,  280,    0,  280,  643,  643,  643,  280, 
          280,  643,  643,  643,  280,  643,  280,  280,  280,  280, 
          280,  280,  280,  106,  643,  643,    0,  280,  280,  280, 
          280,  280,  280,  280,  643,  643,  280,  643,  643,  643, 
          643,  643,    0,  280,    0,    0,  280,  280,  280,    0, 
          280,  280,  280,  280,  280,  280,  280,  280,  280,  280, 
          280,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          618,    0,  643,    0,    0,    0,    0,    0,    0,  643, 
          643,  280,    0,    0,  280,    0,  643,  280,  280,    0, 
          280,  434,  280,    0,  280,    0,  280,    0,    0,    0, 
            0,  434,    0,    0,  280,    0,  643,  643,    0,  280, 
          280,  280,  280,  280,  280,    0,    0,    0,  280,    0, 
          280,  280,    0,  280,  280,  280,  280,    0,  280,  280, 
          280,  643,    0,    0,    0,  434,    0,  435,  435,  435, 
            0,    0,  435,  435,  435,    0,  435,    0,    0,  434, 
          434,    0,    0,    0,  434,  435,  435,  435,    0,    0, 
            0,    0,    0,    0,    0,  435,  435,    0,  435,  435, 
          435,  435,  435,    0,    0,    0,    0,    0,    0,    0, 
          435,    0,  434,    0,    0,    0,  105,  621,    0,    0, 
            0,    0,  435,  435,  435,  435,  435,  435,  435,  435, 
          435,  435,  435,  435,  435,  435,    0,    0,  435,  435, 
          435,  435,    0,  517,  435,    0,    0,  435,    0,    0, 
          435,    0,  435,  517,  435,    0,  435,    0,  435,  435, 
          435,  435,  435,  435,  435,  621,  435,  435,  435,    0, 
            0,    0,  621,  621,    0,    0,    0,    0,  617,  105, 
          435,    0,    0,    0,    0,    0,    0,  517,  125,  618, 
            0,    0,  435,    0,    0,    0,    0,    0,    0,  621, 
            0,  517,  517,    0,  116,    0,  517,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  517,    0,    0,  618,  119,    0, 
            0,    0,    0,    0,  618,  618,    0,  104,    0,    0, 
          618,  218,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  218,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  618,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  104,    0,  434,  434,  434,    0,  119,  434,  434, 
          434,    0,  434,    0,    0,  262,    0,    0,  104,    0, 
            0,  434,  434,  434,    0,    0,    0,    0,    0,    0, 
          218,  434,  434,    0,  434,  434,  434,  434,  434,  520, 
            0,    0,    0,    0,    0,    0,  434,  516,  617,    0, 
            0,    0,    0,    0,    0,    0,    0,  516,  434,  434, 
          434,  434,  434,  434,  434,  434,  434,  434,  434,  434, 
          434,  434,    0,    0,  434,  434,  434,  434,    0,    0, 
          434,    0,    0,  434,    0,    0,  434,    0,  434,    0, 
          434,  516,  434,    0,  434,  434,  434,  434,  434,  434, 
          434,    0,  434,  434,  434,  516,  516,    0,  115,    0, 
          516,    0,    0,    0,    0,    0,  434,    0,    0,    0, 
            0,    0,    0,    0,    0,  517,  517,  517,  434,    0, 
          517,  517,  517,    0,  517,    0,    0,    0,  516,    0, 
            0,    0,    0,    0,  517,  517,    0,    0,    0,    0, 
            0,    0,    0,  517,  517,    0,  517,  517,  517,  517, 
          517,    0,    0,    0,    0,    0,    0,    0,  517,  518, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  518, 
          517,  517,  517,  517,  517,  517,  517,  517,  517,  517, 
          517,  517,  517,  517,    0,    0,  517,  517,  517,  517, 
            0,  529,  517,    0,    0,  517,    0,    0,  517,    0, 
          517,    0,  517,  518,  517,  119,  517,  517,  517,  517, 
          517,  517,  517,    0,  517,    0,  517,  518,  518,    0, 
          117,    0,  518,  218,  218,  218,  104,  617,  517,  218, 
          218,    0,  218,    0,    0,    0,    0,    0,    0,    0, 
          517,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          518,  218,  218,    0,  218,  218,  218,  218,    0,    0, 
            0,    0,    0,  106,    0,    0,  520,   25,    0,    0, 
            0,    0,    0,  520,  520,  617,    0,   25,    0,    0, 
            0,    0,  617,  617,    0,    0,    0,    0,  617,  104, 
            0,    0,    0,    0,    0,    0,    0,  106,    0,  516, 
          516,  516,    0,  218,  516,  516,  516,    0,  516,  617, 
            0,    0,    0,    0,  106,    0,    0,    0,  516,  516, 
            0,    0,    0,    0,  218,    0,   25,  516,  516,    0, 
          516,  516,  516,  516,  516,    0,    0,    0,    0,    0, 
            0,    0,  516,  519,  618,    0,    0,    0,  218,    0, 
            0,    0,    0,  519,  516,  516,  516,  516,  516,  516, 
          516,  516,  516,  516,  516,  516,  516,  516,    0,    0, 
          516,  516,  516,  516,    0,  528,  516,    0,    0,  516, 
            0,    0,  516,    0,  516,    0,  516,  519,  516,    0, 
          516,  516,  516,  516,  516,  516,  516,    0,  516,    0, 
          516,  519,  519,    0,  118,    0,  519,    0,    0,    0, 
            0,    0,  516,    0,    0,    0,    0,    0,    0,    0, 
            0,  518,  518,  518,  516,    0,  518,  518,  518,    0, 
          518,    0,    0,    0,  519,    0,    0,    0,    0,    0, 
          518,  518,    0,    0,    0,    0,    0,    0,    0,  518, 
          518,    0,  518,  518,  518,  518,  518,    0,    0,    0, 
            0,    0,    0,    0,  518,  521,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  521,  518,  518,  518,  518, 
          518,  518,  518,  518,  518,  518,  518,  518,  518,  518, 
            0,    0,  518,  518,  518,  518,    0,  530,  518,    0, 
            0,  518,    0,    0,  518,    0,  518,    0,  518,  521, 
          518,    0,  518,  518,  518,  518,  518,  518,  518,    0, 
          518,    0,  518,  521,  521,    0,  120,    0,  521,   25, 
           25,   25,  106,  618,  518,   25,   25,    0,   25,  100, 
            0,    0,    0,    0,    0,    0,  518,    0,  102,    0, 
            0,    0,    0,    0,    0,    0,  521,    0,    0,    0, 
           25,   25,   25,   25,   25,    0,    0,    0,    0,    0, 
           93,    0,    0,  100,  125,    0,    0,    0,    0,    0, 
            0,  618,  102,    0,    0,    0,    0,    0,  618,  618, 
          100,    0,    0,    0,  618,  106,    0,    0,    0,  102, 
            0,    0,    0,    0,   93,  519,  519,  519,    0,   25, 
          519,  519,  519,    0,  519,  618,    0,    0,    0,    0, 
          520,   93,    0,  125,  519,  519,    0,    0,    0,  522, 
           25,    0,    0,  519,  519,    0,  519,  519,  519,  519, 
          519,    0,    0,    0,    0,    0,    0,    0,  519,  520, 
            0,  513,    0,    0,   25,  618,    0,    0,    0,  520, 
          519,  519,  519,  519,  519,  519,  519,  519,  519,  519, 
          519,  519,  519,  519,    0,    0,  519,  519,  519,  519, 
            0,  531,  519,    0,    0,  519,    0,    0,  519,    0, 
          519,    0,  519,  520,  519,    0,  519,  519,  519,  519, 
          519,  519,  519,    0,  519,    0,  519,  520,  520,    0, 
          119,    0,  520,    0,    0,    0,    0,    0,  519,    0, 
            0,    0,    0,    0,    0,    0,    0,  521,  521,  521, 
          519,    0,  521,  521,  521,    0,  521,    0,    0,    0, 
          520,    0,    0,    0,    0,    0,  521,  521,    0,    0, 
            0,    0,    0,    0,    0,  521,  521,    0,  521,  521, 
          521,  521,  521,    0,    0,    0,    0,    0,    0,    0, 
          521,  522,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  522,  521,  521,  521,  521,  521,  521,  521,  521, 
          521,  521,  521,  521,  521,  521,    0,    0,  521,  521, 
          521,  521,    0,  533,  521,    0,    0,  521,  100,    0, 
          521,    0,  521,    0,  521,  522,  521,  102,  521,  521, 
          521,  521,  521,  521,  521,    0,  521,    0,  521,  522, 
          522,  125,  121,    0,  522,    0,    0,    0,    0,   93, 
          521,    0,    0,    0,  618,    0,    0,    0,    0,    0, 
            0,    0,  521,    0,  121,    0,    0,  520,    0,    0, 
          112,    0,  522,    0,  520,  520,  522,    0,    0,    0, 
           92,  100,   95,  522,  522,    0,    0,    0,    0,    0, 
          102,  109,    0,    0,    0,    0,    0,    0,  513,    0, 
            0,    0,  618,    0,    0,  513,  513,    0,    0,  618, 
          618,    0,   93,  121,   92,  618,   95,    0,    0,  112, 
            0,  520,  520,  520,  111,  109,  520,  520,  520,    0, 
          520,   92,    0,   95,    0,    0,  618,    0,    0,    0, 
          520,  520,  109,    0,    0,  522,    0,    0,    0,  520, 
          520,  513,  520,  520,  520,  520,  520,    0,    0,    0, 
            0,  512,    0,  515,  520,  513,    0,    0,    0,    0, 
            0,    0,  303,  111,    0,  513,  520,  520,  520,  520, 
          520,  520,  520,  520,  520,  520,  520,  520,  520,  520, 
            0,    0,  520,  520,  520,  520,    0,  532,  520,    0, 
            0,  520,    0,    0,  520,  512,  520,    0,  520,  513, 
          520,    0,  520,  520,  520,  520,  520,  520,  520,    0, 
          520,    0,  520,  513,  513,    0,  112,    0,  513,    0, 
            0,    0,    0,    0,  520,    0,    0,    0,    0,    0, 
            0,    0,    0,  522,  522,  522,  520,    0,  522,  522, 
          522,    0,  522,    0,    0,    0,  513,    0,    0,    0, 
            0,    0,  522,  522,    0,    0,    0,    0,    0,    0, 
            0,  522,  522,    0,  522,  522,  522,  522,  522,    0, 
            0,    0,    0,    0,    0,    0,  522,  512,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  512,  522,  522, 
          522,  522,  522,  522,  522,  522,  522,  522,  522,  522, 
          522,  522,    0,    0,  522,  522,  522,  522,    0,  534, 
          522,  121,    0,  522,    0,    0,  522,  112,  522,  108, 
          522,  512,  522,    0,  522,  522,  522,  522,  522,  522, 
          522,    0,  522,    0,  522,  512,  512,    0,  111,   92, 
          512,   95,    0,    0,    0,    0,  522,    0,    0,    0, 
          109,    0,  114,  108,    0,    0,    0,    0,  522,    0, 
            0,  128,    0,  127,    0,    0,    0,    0,  512,    0, 
          108,  111,  522,    0,    0,    0,    0,    0,  513,  522, 
          522,    0,    0,    0,    0,  513,  513,    0,  512,    0, 
          515,    0,    0,    0,    0,  512,  512,  515,  515,  303, 
          314,  114,   92,    0,   95,    0,  303,  303,    0,    0, 
          128,    0,  127,  109,    0,    0,    0,  513,  513,  513, 
            0,    0,  513,  513,  513,    0,  513,    0,    0,    0, 
            0,    0,  512,  515,    0,    0,  513,  513,    0,  512, 
          512,    0,  303,    0,  314,  513,  513,    0,  513,  513, 
          513,  513,  513,    0,    0,    0,    0,    0,    0,    0, 
          513,  515,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  515,  513,  513,  513,  513,  513,  513,  513,  513, 
          513,  513,  513,  513,  513,  513,    0,    0,  513,  513, 
          513,  513,    0,  525,  513,    0,    0,  513,    0,    0, 
          513,    0,  513,    0,  513,  515,  513,    0,  513,  513, 
          513,  513,  513,  513,  513,    0,  513,    0,  513,  515, 
          515,    0,  114,    0,  515,    0,    0,    0,    0,    0, 
          513,    0,    0,    0,    0,    0,    0,    0,    0,  512, 
          512,  512,  513,    0,  512,  512,  512,    0,  512,    0, 
            0,    0,  515,    0,    0,    0,    0,    0,  512,  512, 
            0,    0,    0,    0,    0,    0,    0,  512,  512,    0, 
          512,  512,  512,  512,  512,    0,    0,    0,    0,    0, 
            0,    0,  512,  643,    0,    0,    0,    0,  108,    0, 
            0,    0,    0,  643,  512,  512,  512,  512,  512,  512, 
          512,  512,  512,  512,  512,  512,  512,  512,    0,  114, 
          512,  512,  512,  512,    0,  524,  512,    0,  128,  512, 
          127,    0,  512,    0,  512,    0,  512,  643,  512,    0, 
          512,  512,  512,  512,  512,  512,  512,  314,  512,    0, 
          512,  643,  643,    0,  314,  314,  643,    0,    0,    0, 
            0,  108,  512,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  512,    0,    0,    0,    0,    0, 
          515,    0,    0,    0,  643,    0,    0,  515,  515,  303, 
            0,  314,    0,    0,    0,    0,  303,  303,  314,  314, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  515,  515,  515,    0,    0,  515,  515, 
          515,    0,  515,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  515,  515,    0,    0,    0,    0,    0,    0, 
            0,  515,  515,    0,  515,  515,  515,  515,  515,    0, 
            0,    0,    0,    0,    0,    0,  515,  303,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  303,  515,  515, 
          515,  515,  515,  515,  515,  515,  515,  515,  515,  515, 
          515,  515,    0,    0,  515,  515,  515,  515,    0,  527, 
          515,    0,    0,  515,    0,    0,  515,    0,  515,    0, 
          515,  303,  515,    0,  515,  515,  515,  515,  515,  515, 
          515,    0,  515,    0,  515,  303,  303,    0,  128,    0, 
          303,    0,    0,    0,    0,    0,  515,    0,    0,    0, 
            0,    0,    0,    0,    0,  643,  643,  643,  515,    0, 
          643,  643,  643,    0,  643,    0,    0,    0,  303,    0, 
            0,    0,    0,  643,  643,  643,    0,    0,    0,    0, 
            0,    0,    0,  643,  643,    0,  643,  643,  643,  643, 
          643,    0,    0,    0,    0,    0,    0,    0,  643,  314, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  314, 
          643,  643,  643,  643,  643,  643,  643,  643,  643,  643, 
          643,  643,  643,  643,    0,    0,  643,  643,  643,  643, 
            0,    0,  643,    0,    0,  643,    0,    0,  643,    0, 
          643,    0,  643,  314,  643,    0,  643,  643,  643,  643, 
          643,  643,  643,    0,  643,  643,  643,  314,  314,    0, 
          127,    0,  314,    0,    0,    0,    0,    0,  643,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          643,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          314,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  303, 
          303,  303,    0,    0,  303,  303,  303,    0,  303,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  303,  303, 
            0,    0,    0,    0,    0,    0,    0,  303,  303,    0, 
          303,  303,  303,  303,  303,    0,    0,    0,    0,    0, 
            0,    0,  303,  455,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  455,  303,  303,  303,  303,  303,  303, 
          303,  303,  303,  303,  303,  303,  303,  303,    0,    0, 
          303,  303,  303,  303,    0,    0,  303,    0,    0,  303, 
            0,    0,  303,    0,  303,    0,  303,  455,  303,    0, 
          303,  303,  303,  303,  303,  303,  303,    0,  303,    0, 
          303,  455,  455,    0,    0,    0,  455,    0,    0,    0, 
            0,    0,  303,    0,    0,    0,    0,    0,    0,    0, 
            0,  314,  314,  314,  303,    0,  314,  314,  314,    0, 
          314,    0,    0,    0,  455,    0,    0,    0,    0,    0, 
          314,  314,    0,    0,    0,    0,    0,    0,    0,  314, 
          314,    0,  314,  314,  314,  314,  314,    0,    0,    0, 
            0,    0,    0,    0,  314,  325,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  325,  314,  314,  314,  314, 
          314,  314,  314,  314,  314,  314,  314,  314,  314,  314, 
            0,    0,  314,  314,  314,  314,    0,    0,  314,    0, 
            0,  314,    0,    0,  314,    0,  314,    0,  314,  325, 
          314,    0,  314,  314,  314,  314,  314,  314,  314,    0, 
          314,    0,  314,  325,  325,    0,    0,    0,  325,    0, 
            0,    0,    0,    0,  314,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  314,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  325,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  455,  455,  455,    0,    0, 
          455,  455,  455,    0,  455,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  455,  455,    0,    0,    0,    0, 
            0,    0,    0,  455,  455,    0,  455,  455,  455,  455, 
          455,    0,    0,    0,    0,    0,    0,    0,  455,  261, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  261, 
          455,  455,  455,  455,  455,  455,  455,  455,  455,  455, 
          455,  455,  455,  455,    0,    0,  455,  455,  455,  455, 
            0,    0,  455,    0,    0,  455,    0,    0,  455,    0, 
          455,    0,  455,  261,  455,    0,  455,  455,  455,  455, 
          455,  455,  455,    0,  455,    0,  455,  261,  261,    0, 
            0,    0,  261,    0,    0,    0,    0,    0,  455,    0, 
            0,    0,    0,    0,    0,    0,    0,  325,  325,  325, 
          455,    0,  325,  325,  325,    0,  325,    0,    0,    0, 
          357,    0,    0,    0,    0,    0,  325,  325,    0,    0, 
            0,    0,    0,    0,    0,  325,  325,    0,  325,  325, 
          325,  325,  325,    0,    0,    0,    0,    0,    0,    0, 
          325,  320,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  320,  325,  325,  325,  325,  325,  325,  325,  325, 
          325,  325,  325,  325,  325,  325,    0,    0,  325,  325, 
          325,  325,    0,    0,  325,    0,    0,  325,    0,    0, 
          325,    0,  325,    0,  325,  320,  325,    0,  325,  325, 
          325,  325,  325,  325,  325,    0,  325,    0,  325,  320, 
          320,    0,    0,    0,  320,    0,    0,    0,    0,    0, 
          325,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  325,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  320,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  261,  261,  261,    0,    0,  261,  261,  261,    0, 
          261,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          261,  261,    0,    0,    0,    0,    0,    0,    0,  261, 
          261,    0,  261,  261,  261,  261,  261,    0,    0,    0, 
            0,    0,    0,    0,  261,  506,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  506,  261,  261,  261,  261, 
          261,  261,  261,  261,  261,  261,  261,  357,  261,  261, 
            0,    0,  261,  261,  357,  357,    0,    0,  261,    0, 
            0,  261,    0,    0,  261,    0,  261,    0,  261,  506, 
          261,    0,  261,  261,  261,  261,  261,  261,  261,    0, 
          261,    0,  261,  506,  506,    0,    0,    0,  506,    0, 
            0,    0,    0,    0,  261,    0,    0,    0,    0,    0, 
            0,    0,    0,  320,  320,  320,  261,    0,  320,  320, 
          320,    0,  320,    0,    0,    0,  506,    0,    0,    0, 
            0,    0,  320,  320,    0,    0,    0,    0,    0,    0, 
            0,  320,  320,    0,  320,  320,  320,  320,  320,    0, 
            0,    0,    0,    0,    0,    0,  320,  353,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  353,  320,  320, 
          320,  320,  320,  320,  320,  320,  320,  320,  320,  320, 
          320,  320,    0,    0,  320,  320,  320,  320,    0,    0, 
          320,    0,    0,  320,    0,    0,  320,    0,  320,    0, 
          320,  353,  320,    0,  320,  320,  320,  320,  320,  320, 
          320,    0,  320,    0,  320,    0,  353,    0,    0,    0, 
          353,    0,    0,    0,    0,    0,  320,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  320,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  353,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  354,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  354,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  506,  506,  506, 
            0,    0,  506,  506,  506,  354,  506,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  506,  506,    0,    0, 
          354,    0,    0,    0,  354,  506,  506,    0,  506,  506, 
          506,  506,  506,    0,    0,    0,    0,    0,    0,    0, 
          506,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  354,  506,  506,  506,  506,  506,  506,  506, 
          506,  506,  506,  506,  506,  506,    0,    0,  506,  506, 
          506,  506,    0,  317,  506,    0,    0,  506,    0,    0, 
          506,    0,  506,  317,  506,    0,  506,    0,  506,  506, 
          506,  506,  506,  506,  506,    0,  506,    0,  506,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          506,    0,    0,    0,    0,    0,    0,  317,    0,  353, 
          353,  353,  506,    0,  353,  353,  353,    0,  353,    0, 
            0,    0,  317,    0,    0,    0,  317,    0,  353,  353, 
            0,    0,    0,    0,    0,    0,    0,  353,  353,    0, 
          353,  353,  353,  353,  353,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  317,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  353,  353,  353,  353,  353,  353, 
          353,  353,  353,  353,  353,  353,  353,  353,    0,    0, 
          353,  353,  353,  353,    0,    0,  353,    0,    0,  353, 
            0,    0,  353,    0,  353,    0,  353,    0,  353,  236, 
          353,  353,  353,  353,  353,  353,  353,    0,  353,  236, 
          353,    0,    0,  354,  354,  354,    0,    0,  354,  354, 
          354,    0,  354,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  354,  354,  353,    0,    0,    0,    0,    0, 
            0,  354,  354,  236,  354,  354,  354,  354,  354,    0, 
            0,    0,    0,    0,    0,    0,    0,  236,  236,    0, 
            0,    0,  236,    0,    0,    0,    0,    0,  354,  354, 
          354,  354,  354,  354,  354,  354,  354,  354,  354,  354, 
          354,  354,    0,    0,  354,  354,  354,  354,    0,    0, 
          354,    0,    0,  354,    0,    0,  354,    0,  354,    0, 
          354,    0,  354,    0,  354,  354,  354,  354,  354,  354, 
          354,    0,  354,    0,  354,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  317,  317,  317,    0,    0, 
          317,  317,  317,    0,  317,    0,    0,    0,  354,    0, 
            0,    0,    0,    0,  317,  317,    0,    0,    0,    0, 
            0,    0,    0,  317,  317,    0,  317,  317,  317,  317, 
          317,    0,    0,    0,    0,    0,    0,    0,    0,  233, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  233, 
          317,  317,  317,  317,  317,  317,  317,  317,  317,  317, 
          317,  317,  317,  317,    0,    0,  317,  317,  317,  317, 
            0,    0,  317,    0,    0,  317,    0,    0,  317,    0, 
          317,    0,  317,  233,  317,    0,  317,  317,  317,  317, 
          317,  317,  317,    0,  317,    0,  317,  233,  233,    0, 
            0,    0,  233,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          317,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  236,  236,  236,    0,    0,  236,  236,  236,    0, 
          236,    0,  235,    0,    0,    0,    0,    0,    0,    0, 
          236,  236,  235,    0,    0,    0,    0,    0,    0,  236, 
          236,    0,  236,  236,  236,  236,  236,    0,    0,    0, 
            0,    0,    0,    0,  236,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  235,  236,  236,  236, 
          236,  236,  236,  236,  236,  236,  236,    0,  236,  236, 
          235,  235,  236,  236,    0,  235,    0,    0,  236,    0, 
            0,  236,    0,    0,  236,    0,  236,    0,  236,    0, 
          236,    0,  236,  236,  236,  236,  236,  236,  236,    0, 
          236,    0,  236,    0,  604,  605,    0,    0,  606,    0, 
            0,    0,  183,  184,  236,  185,  186,  187,  188,  189, 
          190,  191,    0,    0,  192,  193,  236,    0,    0,  194, 
          195,  196,  197,    0,    0,    0,    0,    0,  234,  300, 
            0,    0,    0,    0,    0,    0,  199,  200,  234,  201, 
          202,  203,  204,  205,  206,  207,  208,  209,  210,  211, 
            0,    0,  212,    0,    0,    0,    0,    0,    0,    0, 
            0,  233,  233,  233,    0,    0,  233,  233,  233,    0, 
          233,    0,  234,    0,  213,    0,    0,    0,    0,    0, 
          233,  233,    0,    0,    0,    0,  234,  234,    0,  233, 
          233,  234,  233,  233,  233,  233,  233,    0,    0,    0, 
            0,    0,    0,    0,  233,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  233,  233,  233, 
          233,  233,  233,  233,  233,  233,  233,    0,  233,  233, 
            0,    0,  233,  233,    0,    0,    0,    0,  233,    0, 
            0,  233,    0,    0,  233,    0,  233,    0,  233,    0, 
          233,    0,  233,  233,  233,  233,  233,  233,  233,    0, 
          233,    0,  233,    0,  235,  235,  235,    0,    0,  235, 
          235,  235,    0,  235,  233,  237,    0,    0,    0,    0, 
            0,    0,    0,  235,  235,  237,  233,    0,    0,    0, 
            0,    0,  235,  235,    0,  235,  235,  235,  235,  235, 
            0,    0,    0,    0,    0,    0,    0,  235,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  237, 
          235,  235,  235,  235,  235,  235,  235,  235,  235,  235, 
            0,  235,  235,  237,  237,  235,  235,    0,  237,    0, 
            0,  235,    0,    0,  235,    0,    0,  235,    0,  235, 
            0,  235,    0,  235,    0,  235,  235,  235,  235,  235, 
          235,  235,    0,  235,    0,  235,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  235,    0,    0, 
            0,    0,    0,    0,  424,    0,    0,    0,    0,  235, 
          234,  234,  234,    0,  424,  234,  234,  234,    0,  234, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  234, 
          234,    0,    0,    0,    0,    0,    0,    0,  234,  234, 
            0,  234,  234,  234,  234,  234,    0,    0,    0,    0, 
            0,    0,    0,  234,  435,    0,    0,    0,    0,    0, 
            0,    0,    0,  424,  435,    0,  234,  234,  234,  234, 
          234,  234,  234,  234,  234,  234,    0,  234,  234,    0, 
            0,  234,  234,    0,    0,    0,    0,  234,    0,    0, 
          234,    0,    0,  234,    0,  234,    0,  234,  103,  234, 
            0,  234,  234,  234,  234,  234,  234,  234,    0,  234, 
            0,  234,    0,  435,    0,  122,    0,  435,    0,    0, 
            0,    0,    0,  234,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  234,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  435,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  237,  237,  237, 
            0,    0,  237,  237,  237,    0,  237,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  237,  237,    0,    0, 
            0,    0,    0,    0,    0,  237,  237,    0,  237,  237, 
          237,  237,  237,    0,    0,    0,    0,    0,    0,    0, 
          237,  517,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  517,    0,  237,  237,  237,  237,  237,  237,  237, 
          237,  237,  237,    0,  237,  237,    0,    0,  237,  237, 
            0,    0,    0,    0,  237,    0,    0,  237,    0,    0, 
          237,    0,  237,    0,  237,   97,  237,    0,  237,  237, 
          237,  237,  237,  237,  237,    0,  237,    0,  237,    0, 
          517,    0,  116,    0,  517,    0,  424,  424,  424,    0, 
          237,  424,  424,  424,    0,  424,    0,    0,    0,    0, 
            0,    0,  237,    0,    0,  424,    0,    0,    0,    0, 
            0,    0,  517,    0,  424,  424,    0,  424,  424,  424, 
          424,  424,    0,    0,    0,   51,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   51,  435,  435,  435,    0, 
            0,    0,  435,  435,    0,  435,    0,    0,    0,    0, 
            0,    0,  424,    0,  435,    0,    0,    0,    0,  424, 
          424,    0,    0,    0,  435,  435,  424,  435,  435,  435, 
          435,  435,    0,    0,    0,    0,    0,    0,    0,    0, 
          516,    0,    0,    0,   51,    0,    0,  424,    0,    0, 
          516,  435,  435,  435,  435,  435,  435,  435,  435,  435, 
          435,  435,  435,  435,  435,    0,    0,  435,  435,  435, 
          435,  424,    0,    0,    0,    0,  435,    0,    0,    0, 
            0,    0,    0,  435,   96,  435,    0,  435,  435,  435, 
          435,  435,  435,  435,    0,  435,  435,  435,    0,  516, 
            0,  115,    0,  516,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  435,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  516,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  517,  517,  517,    0,    0,    0,  517, 
          517,    0,  517,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  517,  517,    0,  517,  517,  517,  517,  517,    0, 
            0,    0,  518,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  518,    0,    0,    0,    0,    0,  517,  517, 
          517,  517,  517,  517,  517,  517,  517,  517,  517,  517, 
          517,  517,    0,    0,  517,  517,  517,  517,    0,  529, 
            0,    0,    0,  517,    0,    0,   98,    0,    0,    0, 
          517,    0,  517,    0,  517,  517,  517,  517,  517,  517, 
          517,  518,  517,  117,  517,  518,    0,   51,   51,   51, 
            0,    0,   51,   51,   51,    0,   51,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   51,    0,  517,    0, 
            0,    0,    0,  518,    0,   51,   51,    0,   51,   51, 
           51,   51,   51,    0,    0,    0,    0,    0,  519,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  519,    0, 
            0,    0,  516,  516,  516,    0,    0,    0,  516,  516, 
            0,  516,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   51,    0,    0, 
          516,  516,   99,  516,  516,  516,  516,  516,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  519,   51,  118, 
            0,  519,    0,    0,    0,    0,    0,  516,  516,  516, 
          516,  516,  516,  516,  516,  516,  516,  516,  516,  516, 
          516,    0,   51,  516,  516,  516,  516,    0,  528,  519, 
            0,    0,  516,    0,    0,    0,    0,    0,    0,  516, 
            0,  516,    0,  516,  516,  516,  516,  516,  516,  516, 
            0,  516,    0,  516,    0,  521,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  521,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  516,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  518,  518,  518,    0,    0,  101, 
          518,  518,    0,  518,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  521,    0,  120,    0,  521,    0, 
            0,    0,  518,  518,    0,  518,  518,  518,  518,  518, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  521,    0,    0,  518, 
          518,  518,  518,  518,  518,  518,  518,  518,  518,  518, 
          518,  518,  518,    0,    0,  518,  518,  518,  518,    0, 
          530,    0,    0,    0,  518,    0,    0,    0,    0,    0, 
            0,  518,    0,  518,    0,  518,  518,  518,  518,  518, 
          518,  518,    0,  518,    0,  518,    0,    0,    0,    0, 
          519,  519,  519,    0,    0,    0,  519,  519,    0,  519, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  518, 
            0,    0,    0,    0,    0,    0,    0,    0,  519,  519, 
            0,  519,  519,  519,  519,  519,    0,    0,    0,  520, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  520, 
            0,    0,    0,    0,    0,  519,  519,  519,  519,  519, 
          519,  519,  519,  519,  519,  519,  519,  519,  519,    0, 
            0,  519,  519,  519,  519,    0,  531,    0,    0,    0, 
          519,    0,    0,  100,    0,    0,    0,  519,    0,  519, 
            0,  519,  519,  519,  519,  519,  519,  519,  520,  519, 
          119,  519,  520,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  521,  521,  521, 
            0,    0,    0,  521,  521,  519,  521,    0,    0,    0, 
          520,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  521,  521,    0,  521,  521, 
          521,  521,  521,    0,    0,    0,  522,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  522,    0,    0,    0, 
            0,    0,  521,  521,  521,  521,  521,  521,  521,  521, 
          521,  521,  521,  521,  521,  521,    0,    0,  521,  521, 
          521,  521,    0,  533,    0,    0,    0,  521,    0,    0, 
          102,    0,    0,    0,  521,    0,  521,    0,  521,  521, 
          521,  521,  521,  521,  521,  522,  521,  121,  521,  522, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  513,    0,    0,    0,    0,    0,    0, 
            0,    0,  521,  513,    0,    0,    0,  522,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   93,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  513,    0,  112,    0,  513,    0,    0,    0, 
            0,  520,  520,  520,    0,    0,    0,  520,  520,    0, 
          520,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  513,    0,    0,    0,    0,  520, 
          520,    0,  520,  520,  520,  520,  520,    0,    0,    0, 
          512,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          512,    0,    0,    0,    0,    0,  520,  520,  520,  520, 
          520,  520,  520,  520,  520,  520,  520,  520,  520,  520, 
            0,    0,  520,  520,  520,  520,    0,  532,    0,    0, 
            0,  520,    0,    0,   92,    0,    0,    0,  520,    0, 
          520,    0,  520,  520,  520,  520,  520,  520,  520,  512, 
          520,  111,  520,  512,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  522,  522, 
          522,    0,    0,    0,  522,  522,  520,  522,    0,    0, 
            0,  512,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  522,  522,    0,  522, 
          522,  522,  522,  522,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  522,  522,  522,  522,  522,  522,  522, 
          522,  522,  522, 
      };
   }

   private static final short[] yyTable3() {
      return new short[] {

          522,  522,  522,  522,    0,    0,  522,  522,  522,  522, 
            0,  534,  513,  513,  513,  522,    0,    0,  513,  513, 
            0,  513,  522,    0,  522,    0,  522,  522,  522,  522, 
          522,  522,  522,    0,  522,    0,  522,    0,    0,    0, 
          513,  513,    0,  513,  513,  513,  513,  513,    0,    0, 
            0,  515,    0,    0,    0,    0,    0,    0,    0,    0, 
          522,  515,    0,    0,    0,    0,    0,  513,  513,  513, 
          513,  513,  513,  513,  513,  513,  513,  513,  513,  513, 
          513,    0,    0,  513,  513,  513,  513,    0,  525,    0, 
            0,    0,  513,    0,    0,   95,    0,    0,    0,  513, 
            0,  513,    0,  513,  513,  513,  513,  513,  513,  513, 
          515,  513,  114,  513,  515,    0,    0,    0,    0,  512, 
          512,  512,    0,    0,    0,  512,  512,    0,  512,    0, 
            0,    0,    0,    0,    0,    0,    0,  513,    0,    0, 
            0,    0,  515,    0,    0,    0,    0,  512,  512,    0, 
          512,  512,  512,  512,  512,    0,    0,    0,  303,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  303,    0, 
            0,    0,    0,    0,  512,  512,  512,  512,  512,  512, 
          512,  512,  512,  512,  512,  512,  512,  512,    0,    0, 
          512,  512,  512,  512,    0,  524,    0,    0,    0,  512, 
            0,    0,  109,    0,    0,    0,  512,    0,  512,    0, 
          512,  512,  512,  512,  512,  512,  512,  303,  512,  128, 
          512,  303,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  314,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  314,  512,    0,    0,    0,    0,  303, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  108,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  314,    0,  127,    0,  314,    0,    0,  304, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  515,  515,  515,    0,    0,    0,  515, 
          515,    0,  515,    0,  314,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  515,  515,    0,  515,  515,  515,  515,  515,    0, 
            0,    0,  411,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  515,  515, 
          515,  515,  515,  515,  515,  515,  515,  515,  515,  515, 
          515,  515,    0,    0,  515,  515,  515,  515,    0,  527, 
            0,    0,    0,  515,    0,    0,    0,    0,    0,    0, 
          515,  231,  515,    0,  515,  515,  515,  515,  515,  515, 
          515,  231,  515,    0,  515,    0,    0,    0,    0,    0, 
          303,  303,  303,    0,    0,    0,  303,  303,    0,  303, 
            0,    0,    0,    0,    0,    0,    0,    0,  515,    0, 
            0,    0,    0,    0,    0,  231,    0,    0,  303,  303, 
            0,  303,  303,  303,  303,  303,    0,    0,    0,  231, 
          231,    0,    0,    0,  231,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  303,  303,  303,  303,  303, 
          303,  303,  303,  303,  303,  303,  303,  303,  303,    0, 
            0,  303,  303,  303,  303,  314,  314,  314,    0,    0, 
          303,  314,  314,    0,  314,    0,    0,  303,    0,  303, 
            0,  303,  303,  303,  303,  303,  303,  303,    0,  303, 
            0,  303,    0,  314,  314,    0,  314,  314,  314,  314, 
          314,    0,    0,    0,    0,    0,    0,    0,    0,  232, 
            0,    0,    0,    0,    0,  303,    0,    0,    0,  232, 
          314,  314,  314,  314,  314,  314,  314,  314,  314,  314, 
          314,  314,  314,  314,    0,    0,  314,  314,  314,  314, 
            0,    0,    0,    0,    0,  314,    0,    0,    0,    0, 
            0,    0,  314,  232,  314,    0,  314,  314,  314,  314, 
          314,  314,  314,    0,  314,    0,  314,  232,  232,    0, 
            0,    0,  232,    0,    0,    0,  386,  387,  388,  389, 
          390,  391,  392,  393,  394,  395,  396,    0,  397,  398, 
          314,    0,  399,  400,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  401,    0, 
          402,  255,  403,  404,  405,  406,  407,  408,  409,    0, 
          410,  255,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  231,  231,  231,    0,    0,  231,  231, 
          231,    0,  231,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  231,  231,    0,  255,    0,    0,    0,    0, 
            0,  231,  231,    0,  231,  231,  231,  231,  231,  255, 
          255,    0,    0,    0,  255,    0,  231,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  231, 
          231,  231,  231,  231,  231,  231,  231,  231,  231,    0, 
          231,  231,    0,    0,  231,  231,    0,    0,    0,    0, 
          231,    0,    0,  231,    0,    0,  231,    0,  231,    0, 
            0,    0,  231,    0,    0,  256,  231,  231,  231,  231, 
          231,    0,  231,    0,  231,  256,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  231,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  231,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  256, 
            0,  232,  232,  232,    0,    0,  232,  232,  232,    0, 
          232,    0,    0,  256,  256,    0,    0,    0,  256,    0, 
          232,  232,    0,    0,    0,    0,    0,    0,    0,  232, 
          232,    0,  232,  232,  232,  232,  232,    0,    0,    0, 
            0,    0,    0,    0,  232,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  232,  232,  232, 
          232,  232,  232,  232,  232,  232,  232,    0,  232,  232, 
            0,    0,  232,  232,    0,    0,    0,    0,  232,    0, 
            0,  232,    0,    0,  232,    0,  232,    0,    0,  242, 
          232,    0,    0,    0,  232,  232,  232,  232,  232,  242, 
          232,    0,  232,  255,  255,  255,    0,    0,  255,  255, 
          255,    0,  255,    0,  232,    0,    0,    0,    0,    0, 
            0,    0,  255,  255,    0,    0,  232,    0,    0,    0, 
            0,  255,  255,  242,  255,  255,  255,  255,  255,    0, 
            0,    0,    0,    0,    0,    0,  255,  242,  242,    0, 
            0,    0,  242,    0,    0,    0,    0,    0,    0,  255, 
          255,  255,  255,  255,  255,  255,  255,  255,  255,    0, 
          255,  255,    0,    0,  255,  255,    0,    0,    0,    0, 
          255,    0,    0,  255,    0,    0,  255,    0,  255,    0, 
            0,    0,  255,    0,    0,    0,    0,    0,  255,  255, 
          255,    0,  255,  240,  255,    0,    0,    0,    0,    0, 
            0,    0,    0,  240,    0,    0,  255,  256,  256,  256, 
            0,    0,  256,  256,  256,    0,  256,    0,  255,    0, 
            0,    0,    0,    0,    0,    0,  256,  256,    0,    0, 
            0,    0,    0,    0,    0,  256,  256,  240,  256,  256, 
          256,  256,  256,    0,    0,    0,    0,    0,    0,    0, 
          256,  240,  240,    0,    0,    0,  240,    0,    0,    0, 
            0,    0,    0,  256,  256,  256,  256,  256,  256,  256, 
          256,  256,  256,    0,  256,  256,    0,    0,  256,  256, 
            0,    0,    0,    0,  256,    0,    0,  256,    0,    0, 
          256,    0,  256,    0,    0,  241,  256,    0,    0,    0, 
            0,    0,  256,  256,  256,  241,  256,    0,  256,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          256,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  256,    0,    0,    0,    0,    0,    0,  241, 
            0,  242,  242,  242,    0,    0,  242,  242,  242,    0, 
          242,    0,    0,  241,  241,    0,    0,    0,  241,    0, 
          242,  242,    0,    0,    0,    0,    0,    0,    0,  242, 
          242,    0,  242,  242,  242,  242,  242,    0,    0,    0, 
            0,    0,    0,    0,  242,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  242,  242,  242, 
          242,  242,  242,  242,  242,  242,  242,    0,  242,  242, 
            0,    0,    0,    0,    0,    0,    0,    0,  242,    0, 
            0,  242,    0,    0,  242,    0,  242,    0,    0,    0, 
          242,    0,    0,  245,    0,    0,  242,  242,  242,    0, 
          242,    0,  242,  245,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  242,  240,  240,  240,    0,    0, 
          240,  240,  240,    0,  240,    0,  242,    0,    0,    0, 
            0,    0,    0,    0,  240,  240,    0,  245,    0,    0, 
            0,    0,    0,  240,  240,    0,  240,  240,  240,  240, 
          240,  245,  245,    0,    0,    0,  245,    0,  240,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  240,  240,  240,  240,  240,  240,  240,  240,  240, 
          240,    0,  240,  240,    0,    0,    0,    0,    0,    0, 
            0,    0,  240,    0,    0,  240,    0,    0,  240,    0, 
          240,    0,    0,  247,    0,    0,    0,    0,    0,    0, 
          240,  240,  240,  247,  240,    0,  240,  241,  241,  241, 
            0,    0,  241,  241,  241,    0,  241,    0,  240,    0, 
            0,    0,    0,    0,    0,    0,  241,  241,    0,    0, 
          240,    0,    0,    0,    0,  241,  241,  247,  241,  241, 
          241,  241,  241,    0,    0,    0,    0,    0,    0,    0, 
          241,  247,  247,    0,    0,    0,  247,    0,    0,    0, 
            0,    0,    0,  241,  241,  241,  241,  241,  241,  241, 
          241,  241,  241,    0,  241,  241,    0,    0,    0,    0, 
            0,    0,    0,    0,  241,    0,    0,  241,    0,    0, 
          241,    0,  241,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  241,  241,  241,    0,  241,    0,  241,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          241,    0,    0,  246,    0,    0,    0,    0,    0,    0, 
            0,    0,  241,  246,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  245,  245,  245,    0,    0, 
          245,  245,  245,    0,  245,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  245,  245,    0,  246,    0,    0, 
            0,    0,    0,  245,  245,    0,  245,  245,  245,  245, 
          245,  246,  246,    0,    0,    0,  246,    0,  245,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  245,  245,  245,  245,  245,  245,  245,  245,  245, 
          245,    0,  245,  245,    0,    0,    0,    0,    0,    0, 
            0,    0,  245,    0,    0,  245,    0,    0,  245,    0, 
          245,    0,    0,  244,    0,    0,    0,    0,    0,    0, 
          245,  245,    0,  244,    0,    0,  245,    0,    0,    0, 
            0,    0,    0,    0,    0,  247,  247,  247,  245,    0, 
          247,  247,  247,    0,  247,    0,    0,    0,    0,    0, 
          245,    0,    0,    0,  247,  247,    0,  244,    0,    0, 
            0,    0,    0,  247,  247,    0,  247,  247,  247,  247, 
          247,  244,  244,    0,    0,    0,  244,    0,  247,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  247,  247,  247,  247,  247,  247,  247,  247,  247, 
          247,    0,  247,  247,    0,    0,    0,    0,    0,    0, 
            0,    0,  247,    0,    0,  247,    0,    0,  247,    0, 
          247,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          247,  247,    0,    0,    0,    0,  247,    0,    0,    0, 
            0,    0,    0,  243,    0,    0,    0,    0,  247,    0, 
            0,    0,    0,  243,    0,    0,    0,    0,    0,    0, 
          247,    0,    0,    0,    0,  246,  246,  246,    0,    0, 
          246,  246,  246,    0,  246,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  246,  246,    0,  243,    0,    0, 
            0,    0,    0,  246,  246,    0,  246,  246,  246,  246, 
          246,  243,  243,    0,    0,    0,  243,    0,  246,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  246,  246,  246,  246,  246,  246,  246,  246,  246, 
          246,    0,  246,  246,    0,    0,    0,    0,    0,    0, 
            0,    0,  246,    0,    0,  246,    0,    0,  246,    0, 
          246,    0,    0,  248,    0,    0,    0,    0,    0,    0, 
          246,  246,    0,  248,    0,    0,  246,    0,    0,    0, 
            0,    0,    0,    0,    0,  244,  244,  244,  246,    0, 
          244,  244,  244,    0,  244,    0,    0,    0,    0,    0, 
          246,    0,    0,    0,  244,  244,    0,  248,    0,    0, 
            0,    0,    0,  244,  244,    0,  244,  244,  244,  244, 
          244,  248,  248,    0,    0,    0,  248,    0,  244,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  244,  244,  244,  244,  244,  244,  244,  244,  244, 
          244,    0,  244,  244,    0,    0,    0,    0,    0,    0, 
            0,    0,  244,    0,    0,  244,    0,    0,  244,    0, 
          244,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          244,  244,    0,    0,    0,    0,  244,    0,    0,    0, 
            0,    0,    0,  249,    0,    0,    0,    0,  244,    0, 
            0,    0,    0,  249,    0,    0,    0,    0,    0,    0, 
          244,    0,    0,    0,    0,  243,  243,  243,    0,    0, 
          243,  243,  243,    0,  243,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  243,  243,    0,  249,    0,    0, 
            0,    0,    0,  243,  243,    0,  243,  243,  243,  243, 
          243,  249,  249,    0,    0,    0,  249,    0,  243,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  243,  243,  250, 
            0,    0,  243,  243,    0,    0,    0,    0,    0,  250, 
            0,    0,  243,    0,    0,  243,    0,    0,  243,    0, 
          243,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  243,    0,    0,    0, 
            0,    0,    0,  250,    0,  248,  248,  248,  243,    0, 
          248,  248,  248,    0,  248,    0,    0,  250,  250,    0, 
          243,    0,  250,    0,  248,  248,    0,    0,    0,    0, 
            0,    0,    0,  248,  248,    0,  248,  248,  248,  248, 
          248,    0,    0,    0,    0,  257,    0,    0,  248,    0, 
            0,    0,    0,    0,    0,  257,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  248,  248,    0, 
            0,    0,  248,  248,    0,    0,    0,    0,    0,    0, 
            0,    0,  248,    0,    0,  248,    0,    0,  248,  257, 
          248,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  257,  257,    0,  248,    0,  257,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  248,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          248,    0,    0,  251,    0,  249,  249,  249,    0,    0, 
          249,  249,  249,  251,  249,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  249,  249,    0,    0,    0,    0, 
            0,    0,    0,  249,  249,    0,  249,  249,  249,  249, 
          249,    0,    0,    0,    0,    0,    0,  251,  249,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  251,  251,    0,    0,    0,  251,  249,  249,    0, 
            0,    0,  249,  249,    0,    0,    0,    0,    0,    0, 
            0,    0,  249,    0,    0,  249,    0,    0,  249,  252, 
          249,  250,  250,  250,    0,    0,  250,  250,  250,  252, 
          250,    0,    0,    0,    0,    0,  249,    0,    0,    0, 
          250,  250,    0,    0,    0,    0,    0,    0,  249,  250, 
          250,    0,  250,  250,  250,  250,  250,    0,    0,    0, 
          249,    0,    0,  252,  250,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  252,  252,    0, 
            0,    0,  252,  250,  250,    0,    0,    0,  250,  250, 
            0,    0,    0,    0,    0,    0,    0,    0,  250,    0, 
            0,  250,    0,    0,  250,  258,  250,  257,  257,  257, 
            0,    0,  257,  257,  257,  258,  257,    0,    0,    0, 
            0,    0,  250,    0,    0,    0,  257,  257,    0,    0, 
            0,    0,    0,    0,  250,  257,  257,    0,  257,  257, 
          257,  257,  257,    0,    0,    0,  250,    0,    0,  258, 
          257,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  258,  258,    0,    0,    0,  258,  257, 
          257,    0,    0,    0,  257,  257,    0,    0,    0,    0, 
            0,    0,    0,    0,  257,    0,    0,  257,    0,    0, 
          257,    0,  257,  229,    0,  251,  251,  251,    0,    0, 
          251,  251,  251,  229,  251,    0,    0,    0,  257,    0, 
            0,    0,    0,    0,  251,  251,    0,    0,    0,    0, 
          257,    0,    0,  251,  251,    0,  251,  251,  251,  251, 
          251,    0,  257,    0,    0,    0,    0,  229,  251,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  229,  229,    0,    0,    0,  229,  251,  251,    0, 
            0,    0,  251,  251,    0,    0,    0,    0,    0,    0, 
            0,    0,  251,    0,    0,  251,    0,    0,  251,  230, 
          251,  252,  252,  252,    0,    0,  252,  252,  252,  230, 
          252,    0,    0,    0,    0,    0,  251,    0,    0,    0, 
          252,  252,    0,    0,    0,    0,    0,    0,  251,  252, 
          252,    0,  252,  252,  252,  252,  252,    0,    0,    0, 
          251,    0,    0,  230,  252,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  230,  230,    0, 
            0,    0,  230,  252,  252,    0,    0,    0,  252,  252, 
            0,    0,    0,    0,    0,    0,    0,    0,  252,    0, 
            0,  252,    0,    0,  252,  259,  252,  258,  258,  258, 
            0,    0,  258,  258,  258,  259,  258,    0,    0,    0, 
            0,    0,  252,    0,    0,    0,  258,  258,    0,    0, 
            0,    0,    0,    0,  252,  258,  258,    0,  258,  258, 
          258,  258,  258,    0,    0,    0,  252,    0,    0,  259, 
          258,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  259,  259,    0,    0,    0,    0,    0, 
          258,    0,    0,    0,  258,  258,    0,    0,    0,    0, 
            0,    0,    0,    0,  258,    0,    0,  258,    0,    0, 
          258,    0,  258,  228,    0,  229,  229,  229,    0,    0, 
          229,  229,  229,  228,  229,    0,    0,    0,  258,    0, 
            0,    0,    0,    0,  229,  229,    0,    0,    0,    0, 
          258,    0,    0,  229,  229,    0,  229,  229,  229,  229, 
          229,    0,  258,    0,    0,    0,    0,  228,  229,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  228,  228,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  229,    0,    0,  229,    0,    0,  229,  227, 
          229,  230,  230,  230,    0,    0,  230,  230,  230,  227, 
          230,    0,    0,    0,    0,    0,  229,    0,    0,    0, 
          230,  230,    0,    0,    0,    0,    0,    0,  229,  230, 
          230,    0,  230,  230,  230,  230,  230,    0,    0,    0, 
          229,    0,    0,  227,  230,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  227,  227,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  230,    0, 
            0,  230,    0,    0,  230,  225,  230,  259,  259,  259, 
            0,    0,  259,  259,  259,  225,  259,    0,    0,    0, 
            0,    0,  230,    0,    0,    0,  259,  259,    0,    0, 
            0,    0,    0,    0,  230,  259,  259,    0,  259,  259, 
          259,  259,  259,    0,    0,    0,  230,    0,    0,  225, 
          259,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  225,  225,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  259,    0,    0,  259,    0,    0, 
          259,    0,  259,  226,    0,  228,  228,  228,    0,    0, 
          228,  228,  228,  226,  228,    0,    0,    0,  259,    0, 
            0,    0,    0,    0,  228,  228,    0,    0,    0,    0, 
          259,    0,    0,  228,  228,    0,  228,  228,  228,  228, 
          228,    0,  259,    0,    0,    0,    0,  226,  228,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  226,  226,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  228,    0,    0,  228,    0,    0,  228,  223, 
          228,  227,  227,  227,    0,    0,  227,  227,  227,  223, 
          227,    0,    0,    0,    0,    0,  228,    0,    0,    0, 
          227,  227,    0,    0,    0,    0,    0,    0,  228,  227, 
          227,    0,  227,  227,  227,  227,  227,    0,    0,    0, 
          228,    0,    0,  223,  227,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  223,  223,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  227,    0, 
            0,  227,    0,    0,  227,  224,  227,  225,  225,  225, 
            0,    0,  225,  225,  225,  224,  225,    0,    0,    0, 
            0,    0,  227,    0,    0,    0,  225,  225,    0,    0, 
            0,    0,    0,    0,  227,  225,  225,    0,  225,  225, 
          225,  225,  225,    0,    0,    0,  227,    0,    0,  224, 
          225,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  224,  224,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  225,    0,    0,  225,    0,    0, 
          225,    0,  225,  219,    0,  226,  226,  226,    0,    0, 
          226,  226,  226,  219,  226,    0,    0,    0,  225,    0, 
            0,    0,    0,    0,  226,  226,    0,    0,    0,    0, 
          225,    0,    0,  226,  226,    0,  226,  226,  226,  226, 
          226,    0,  225,    0,    0,    0,    0,  219,  226,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  219,  219,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  226,    0,    0,  226,    0,    0,  226,  221, 
          226,  223,  223,  223,    0,    0,  223,  223,  223,  221, 
          223,    0,    0,    0,    0,    0,  226,    0,    0,    0, 
          223,  223,    0,    0,    0,    0,    0,    0,  226,  223, 
          223,    0,  223,  223,  223,  223,  223,    0,    0,    0, 
          226,    0,    0,  221,  223,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  221,  221,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  223,    0, 
            0,  223,    0,    0,  223,  260,  223,  224,  224,  224, 
            0,    0,  224,  224,  224,  260,  224,    0,    0,    0, 
            0,    0,  223,    0,    0,    0,  224,  224,    0,    0, 
            0,    0,    0,    0,  223,  224,  224,    0,  224,  224, 
          224,  224,  224,    0,    0,    0,  223,    0,    0,  260, 
          224,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  260,  260,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  224,    0,    0,  224,    0,    0, 
          224,    0,  224,  222,    0,  219,  219,  219,    0,    0, 
          219,  219,  219,  222,  219,    0,    0,    0,  224,    0, 
            0,    0,    0,    0,  219,  219,    0,    0,    0,    0, 
          224,    0,    0,  219,  219,    0,  219,  219,  219,  219, 
          219,    0,  224,    0,    0,    0,    0,  222,  219,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  222,  222,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  219,    0,    0,  219,    0,    0,  219,  262, 
          219,  221,  221,  221,    0,    0,  221,  221,  221,  262, 
          221,    0,    0,    0,    0,    0,  219,    0,    0,    0, 
          221,  221,    0,    0,    0,    0,    0,    0,  219,  221, 
          221,    0,  221,  221,  221,  221,  221,    0,    0,    0, 
          219,    0,    0,  262,  221,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  262,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  221,    0, 
            0,  221,    0,    0,  221,  220,  221,  260,  260,  260, 
            0,    0,  260,  260,  260,  220,  260,    0,    0,    0, 
            0,    0,  221,    0,    0,    0,  260,  260,    0,    0, 
            0,    0,    0,    0,  221,  260,  260,    0,  260,  260, 
          260,  260,  260,    0,    0,    0,  221,    0,    0,  220, 
          260,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  220,  220,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  260,    0,    0,  260,    0,    0, 
          260,    0,  260,  218,    0,  222,  222,  222,    0,    0, 
          222,  222,  222,  218,  222,    0,    0,    0,  260,    0, 
            0,    0,    0,    0,  222,  222,    0,    0,    0,    0, 
          260,    0,    0,  222,  222,    0,  222,  222,  222,  222, 
          222,    0,  260,   60,    0,    0,    0,  218,  222,    0, 
            0,    0,    0,   60,    0,    0,    0,    0,    0,    0, 
            0,  218,  218,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  222,    0,    0,  222,    0,    0,  222,    0, 
          222,  262,  262,  262,    0,    0,  262,  262,  262,    0, 
          262,    0,   60,    0,    0,   64,  222,    0,    0,    0, 
          262,  262,    0,    0,    0,   64,    0,    0,  222,  262, 
          262,    0,  262,  262,  262,  262,  262,    0,    0,    0, 
          222,    0,    0,    0,  262,    0,    0,    0,    0,    0, 
            0,   62,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   62,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   64,    0,    0,    0,  262,    0, 
            0,  262,    0,    0,  262,    0,  262,  220,  220,  220, 
            0,    0,  220,  220,  220,    0,  220,    0,    0,    0, 
            0,    0,  262,    0,    0,    0,  220,  220,    0,    0, 
           62,    0,    0,    0,  262,  220,  220,    0,  220,  220, 
          220,  220,    0,    0,    0,    0,  262,    0,    0,    0, 
          220,    0,    0,    0,    0,    0,    0,   53,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   53,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  220,    0,    0,  220,    0,    0, 
          220,    0,  220,   55,    0,  218,  218,  218,    0,    0, 
          218,  218,  218,   55,  218,    0,    0,    0,  220,    0, 
            0,    0,    0,    0,  218,  218,   53,    0,    0,    0, 
          220,    0,    0,  218,  218,    0,  218,  218,  218,  218, 
            0,    0,  220,   56,    0,   60,   60,   60,  218,    0, 
           60,   60,   60,   56,   60,    0,    0,    0,    0,    0, 
            0,    0,   55,    0,   60,   60,    0,    0,    0,    0, 
            0,    0,    0,   60,   60,    0,   60,   60,   60,   60, 
           60,    0,  218,    0,    0,  218,    0,    0,  218,    0, 
          218,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   56,    0,    0,    0,  218,   64,   64,   64, 
            0,    0,   64,   64,   64,    0,   64,    0,  218,    0, 
            0,    0,    0,    0,  292,   60,   64,   64,   60,    0, 
          218,    0,    0,    0,  292,   64,   64,    0,   64,   64, 
           64,   64,   64,   62,   62,   62,   60,    0,   62,   62, 
           62,    0,   62,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   62,   62,    0,    0,    0,    0,  288,    0, 
           60,   62,   62,    0,   62,   62,   62,   62,   62,    0, 
          304,    0,    0,  292,    0,    0,    0,   64,    0,    0, 
           64,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   64,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   62,    0,    0,   62,    0,    0,   53, 
           53,   53,   64,    0,   53,   53,   53,    0,   53,    0, 
            0,    0,    0,    0,   62,    0,    0,    0,   53,    0, 
            0,    0,    0,    0,    0,    0,    0,   53,   53,    0, 
           53,   53,   53,   53,   53,   55,   55,   55,   62,    0, 
           55,   55,   55,    0,   55,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   55,    0,    0,    0,    0,    0, 
            0,    0,    0,   55,   55,    0,   55,   55,   55,   55, 
           55,    0,    0,    0,    0,   56,   56,   56,    0,   53, 
           56,   56,   56,  129,   56,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   56,    0,    0,    0,    0,    0, 
           53,    0,    0,   56,   56,    0,   56,   56,   56,   56, 
           56,    0,    0,    0,    0,   55,    0,    0,    0,    0, 
            0,    0,    0,    0,   53,    0,    0,    0,    0,    0, 
            0,    0,  129,    0,    0,    0,   55,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   56,  292,  292,  292,    0, 
           55,  292,  292,  292,  511,  292,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   56,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  292,  292,  292, 
          292,  292,    0,    0,    0,    0,    0,    4,    5,    6, 
           56,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   15,   16,   17,   18,    0, 
          130,    0,    0,   19,   20,   21,  235,  236,  237,  238, 
            0,    0,  117,  292,    0,    0,  292,    0,    0,   28, 
            0,    0,  239,  240,  241,    0,  242,   35,  243,  244, 
          245,  246,  281,   40,   41,   42,   43,  292,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  130, 
            0,    0,    0,    0,    0,    0,    0,  247,    0,    0, 
          130,  292,    0,   46,   47,    0,   48,    0,  282,    0, 
          283,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
          284,  514,    0,    0,    0,   52,  285,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,   65,   66,  286,    0,    0,  129, 
          129,  129,  129,  129,  129,  129,  129,  129,  129,  129, 
            0,    0,  129,  129,    0,  129,  129,  129,  129,  129, 
          129,  129,    0,  614,    0,  129,  129,  129,  129,  129, 
          129,  129,  129,    0,    0,  129,    0,    0,    0,    0, 
            0,  129,  129,    0,  129,  129,  129,  129,    0,  129, 
          129,  129,  129,  129,  129,    0,  129,  129,  129,  129, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  511,    0,    0,  129,    0,    0,    0,  511,  511, 
          129,    0,    0,  129,  614,    0,  129,  129,    0,  129, 
            0,  129,    0,    0,    0,  129,    0,    0,    0,    0, 
          129,    0,    0,  129,    0,  614,  621,    0,  129,  129, 
          129,  129,  129,  129,    0,    0,    0,  129,    0,  129, 
          129,    0,  129,  129,  129,  129,    0,  129,  129,    0, 
            0,    0,    0,    0,    0,    0,  130,  130,  130,  130, 
          130,  130,  130,  130,  130,  130,  130,    0,    0,  130, 
          130,    0,  130,  130,  130,  130,  130,  130,  130,    0, 
          615,    0,  130,  130,  130,  130,  130,  130,  130,  130, 
            0,    0,  130,    0,    0,    0,    0,    0,  130,  130, 
            0,  130,  130,  130,  130,    0,  130,  130,  130,  130, 
          130,  130,    0,  130,  130,  130,  130,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  514,    0, 
            0,  130,    0,    0,    0,  514,  514,  130,    0,    0, 
          130,  615,    0,  130,  130,    0,  130,    0,  130,    0, 
            0,    0,  130,    0,    0,    0,    0,  130,    0,    0, 
          130,    0,  615,  313,    0,  130,  130,  130,  130,  130, 
          130,    0,    0,    0,  130,    0,  130,  130,    0,  130, 
          130,  130,  130,    0,  130,  130,    0,    0,    0,    0, 
            0,  129,  129,  129,  129,  129,  129,  129,  129,  129, 
          129,  129,    0,    0,  129,  129,    0,  129,  129,  129, 
          129,  129,  129,  129,    0,  621,    0,  130,  129,  129, 
          129,  129,  129,  129,  129,    0,    0,  129,    0,    0, 
            0,    0,    0,  129,  129,    0,  129,  129,  129,  129, 
            0,  129,  129,  129,  129,  129,  129,    0,  129,  129, 
          129,  129,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  621,    0,    0,  130,    0,    0,    0, 
          621,  621,  129,    0,    0,  129,  617,    0,  129,  129, 
            0,  129,    0,  129,    0,    0,    0,  129,    0,    0, 
            0,    0,  129,    0,    0,  129,    0,  621,  314,    0, 
          129,  129,  129,  129,  129,  129,    0,    0,    0,  129, 
            0,  129,  129,    0,  129,  129,  129,  129,    0,  129, 
          129,    0,    0,    0,    0,    0,    0,    0,  130,  130, 
          130,  130,  130,  130,  130,  130,  130,  130,  130,    0, 
            0,  130,  130,    0,  130,  130,  130,  130,  130,  130, 
          130,    0,  358,    0,    0,  130,  130,  130,  130,  130, 
          130,  130,    0,    0,  130,    0,    0,    0,    0,    0, 
          130,  130,    0,  130,  130,  130,  130,    0,  130,  130, 
          130,  130,  130,  130,    0,  130,  130,  130,  130,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          313,  358,    0,    0,    0,    0,    0,  313,  313,  130, 
            0,    0,  130,  618,    0,  130,  130,    0,  130,    0, 
          130,    0,    0,    0,  130,    0,    0,    0,    0,  130, 
            0,    0,  130,    0,    0,    0,    0,  130,  130,  130, 
          130,  130,  130,    0,    0,    0,  130,    0,  130,  130, 
            0,  130,  130,  130,  130,    0,  130,  130,    0,    0, 
            0,    0,    0,  130,  130,  130,  130,  130,  130,  130, 
          130,  130,  130,  130,    0,    0,  130,  130,    0,  130, 
          130,  130,  130,  130,  130,  130,    0,  305,    0,    0, 
          130,  130,  130,  130,  130,  130,  130,    0,    0,  130, 
            0,    0,    0,    0,    0,  130,  130,    0,  130,  130, 
          130,  130,    0,  130,  130,  130,  130,  130,  130,    0, 
          130,  130,  130,  130,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  314,  305,    0,    0,    0, 
            0,    0,  314,  314,  130,    0,    0,  130,    0,    0, 
          130,  130,    0,  130,    0,  130,    0,    0,    0,  130, 
            0,    0,    0,    0,  130,    0,    0,  130,    0,    0, 
            0,    0,  130,  130,  130,  130,  130,  130,    0,    0, 
            0,  130,    0,  130,  130,    0,  130,  130,  130,  130, 
            0,  130,  130,    0,    0,    0,    0,    0,  358,  358, 
          358,  358,  358,  358,  358,  358,  358,  358,  358,    0, 
          358,  358,  358,  358,  358,  358,  358,  358,  358,  358, 
          358,  539,    0,    0,    0,  358,  358,  358,  358,  358, 
          358,  358,    0,    0,  358,    0,    0,    0,    0,    0, 
          358,  358,    0,  358,  358,  358,  358,    0,  358,  358, 
          358,  358,  358,  358,    0,  358,  358,  358,  358,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          539,    0,    0,    0,    0,    0,    0,    0,    0,  358, 
            0,    0,  358,    0,    0,  358,  358,    0,  358,    0, 
          358,    0,    0,    0,  358,    0,    0,    0,    0,    0, 
            0,    0,  358,    0,    0,    0,    0,  358,  358,  358, 
          358,  358,  358,    0,    0,    0,  358,    0,  358,  358, 
            0,  358,  358,  358,  358,    0,  358,  358,    0,    0, 
            0,    0,    0,  305,  305,  305,  305,  305,  305,  305, 
          305,  305,  305,  305,    0,    0,  305,  305,    0,  305, 
          305,  305,  305,  305,  305,  305,  643,    0,    0,    0, 
          305,  305,  305,  305,  305,  305,  305,    0,    0,  305, 
            0,    0,    0,    0,    0,  305,  305,    0,  305,  305, 
          305,  305,    0,  305,  305,  305,  305,  305,  305,    0, 
          305,  305,  305,  305,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  643,    0,    0,    0,    0, 
            0,    0,    0,    0,  305,    0,    0,  305,    0,    0, 
          305,  305,    0,  305,    0,  305,    0,    0,    0,  305, 
            0,    0,    0,    0,    0,    0,    0,  305,    0,   18, 
            0,    0,  305,  305,  305,  305,  305,  305,    0,    0, 
            0,  305,    0,  305,  305,    0,  305,  305,  305,  305, 
            0,  305,  305,    0,    0,    0,    0,  539,  539,  539, 
          539,  539,  539,  539,  539,  539,  539,  539,    0,    0, 
          539,  539,    0,  539,  539,  539,  539,  539,  539,  539, 
          643,    0,    0,    0,  539,  539,  539,  539,  539,  539, 
          539,    0,    0,  539,    0,    0,    0,    0,    0,  539, 
          539,    0,  539,  539,  539,  539,    0,  539,  539,  539, 
          539,  539,  539,    0,  539,  539,  539,  539,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  643, 
            0,    0,    0,    0,    0,    0,    0,    0,  539,    0, 
            0,  539,    0,    0,  539,  539,    0,  539,    0,  539, 
            0,    0,    0,  539,    0,    0,    0,    0,    0,    0, 
            0,  539,    0,    0,    0,    0,  539,  539,  539,  539, 
          539,  539,    0,    0,    0,  539,    0,  539,  539,    0, 
          539,  539,  539,  539,    0,  539,  539,    0,    0,    0, 
            0,    0,  643,  643,  643,  643,  643,  643,    0,    0, 
          643,  643,  643,    0,    0,    0,  643,    0,  643,  643, 
          643,  643,  643,  643,  643,  256,    0,    0,    0,  643, 
          643,  643,  643,  643,  643,  643,    0,    0,  643,    0, 
            0,    0,    0,    0,  643,  643,    0,  643,  643,  643, 
          643,    0,  643,  643,  643,  643,  643,  643,    0,  643, 
          643,  643,  643,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  255,    0,    0,    0,    0,    0, 
            0,    0,    0,  643,    0,    0,  643,    0,    0,  643, 
          643,    0,  643,    0,  643,    0,    0,    0,  643,    0, 
            0,    0,    0,    0,    0,    0,  643,    0,    0,    0, 
            0,  643,  643,  643,  643,  643,  643,    0,    0,    0, 
          643,    0,  643,  643,    0,  643,  643,  643,  643,    0, 
          643,  643,    0,    0,    0,    0,  643,  643,  643,  643, 
          643,  643,    0,    0,    0,  643,  643,    0,    0,    0, 
          643,    0,  643,  643,  643,  643,  643,  643,  643,  307, 
            0,    0,    0,  643,  643,  643,  643,  643,  643,  643, 
            0,    0,  643,    0,    0,    0,    0,    0,  643,  643, 
            0,  643,  643,  643,  643,    0,  643,  643,  643,  643, 
          643,  643,    0,  643,  643,  643,  643,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  643,    0,    0, 
          643,    0,    0,  643,  643,    0,  643,    0,  643,    0, 
            0,    0,  643,    0,    0,    0,    0,    0,    0,    0, 
          643,    0,    0,  643,    0,  643,  643,  643,  643,  643, 
          643,    0,    0,    0,  643,    0,  643,  643,    0,  643, 
          643,  643,  643,    0,  643,  643,    0,    0,    0,    0, 
            0,    0,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           15,   16,   17,   18,  304,    0,    0,    0,   19,   20, 
           21,  235,  236,  237,  238,    0,    0,   26,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,  239,  240,  241, 
            0,  242,   35,  243,  244,  245,  246,    0,   40,   41, 
           42,   43,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  247,    0,    0,  130,    0,    0,   46,   47, 
            0,   48,    0, 
      };
   }

   private static final short[] yyTable4() {
      return new short[] {

            0,    0,    0,    0,   50,    0,    0,    0,    0,    0, 
            0,    0,   51,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,   63,   64,    0,   65,   66,    0,    0, 
            0,    0,    0,  309,  309,  309,    0,  309,    0,    0, 
            0,  309,  309,    0,    0,    0,  309,    0,  309,  309, 
          309,  309,  309,  309,  309,    0,    0,    0,    0,  309, 
          309,  309,  309,  309,  309,  309,    0,    0,  309,    0, 
            0,    0,    0,    0,    0,  309,    0,    0,  309,  309, 
          309,    0,  309,  309,  309,  309,  309,  309,  349,  309, 
          309,  309,  309,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  309,    0,    0,  309,    0,  307,  309, 
          309,    0,  309,    0,    0,    0,    0,    0,  309,    0, 
            0,    0,    0,    0,    0,    0,  309,    0,    0,    0, 
            0,  309,  309,  309,  309,  309,  309,    0,    0,    0, 
          309,    0,  309,  309,    0,  309,  309,  309,  309,    0, 
          309,  309,    0,    0,    0,    0,    0,    0,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   15,   16,   17,   18, 
            0,    0,    0,    0,   19,   20,   21,  235,  236,  237, 
          238,    0,    0,   26,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,  239,  240,  241,    0,  242,   35,  243, 
          244,  245,  246,  624,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  247,    0, 
            0,  130,    0,    0,   46,   47,    0,   48,    0,    0, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,   51,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,   65,   66,    0,    0,    0, 
            0,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  108, 
          109,   17,   18,    0,    0,    0,    0,  110,  111,  112, 
          336,  337,  338,  339,    0,    0,  117,    0,    0,    0, 
            0,    0,    0,  118,    0,    0,  340,  341,  342,    0, 
          343,   35,  344,  345,  346,  347,    0,   40,    0,    0, 
          127,    0,    0,    0,    0,    0,    0,  469,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  348,    0,    0,  130,    0,    0,   46,   47,    0, 
           48,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,   65,   66, 
            0,    0,    0,    0,    0,    0,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,  108,  109,   17,   18,    0,    0, 
            0,    0,  110,  111,  112,  336,  337,  338,  339,    0, 
            0,  117,    0,    0,    0,    0,    0,    0,  118,    0, 
            0,  340,  341,  342,    0,  343,   35,  344,  345,  346, 
          347,    0,   40,    0,    0,  127,  469,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  348,    0,    0,  130, 
            0,    0,   46,   47,    0,   48,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
           63,   64,    0,   65,   66,    4,    5,    6,    7,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   15,   16,   17,   18,    0,    0,    0, 
            0,   19,   20,   21,   22,   23,   24,   25,    0,    0, 
           26,    0,    0,    0,    0,    0,   27,   28,   29,   30, 
           31,   32,   33,    0,   34,   35,   36,   37,   38,   39, 
            0,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   44,    0,    0,   45,    0, 
            0,   46,   47,    0,   48,    0,   49,    0,    0,    0, 
           50,    0,    0,    0,    0,    0,    0,    0,   51,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,   63, 
           64,    0,   65,   66,    4,    5,    6,    7,  317,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   15,   16,   17,   18,    0,    0,    0,    0, 
           19,   20,   21,   22,   23,   24,   25,    0,    0,   26, 
            0,    0,    0,    0,    0,   27,   28,    0,   30,   31, 
           32,   33,    0,   34,   35,   36,   37,   38,   39,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   44,    0,    0,   45,    0,    0, 
           46,   47,    0,   48,    0,   49,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,   51,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,   65,   66,  138,  139,  140,  141,  142,  143,  144, 
          145,  146,  147,  148,  149,  150,  151,  152,  153,  154, 
          155,  156,  157,  158,  159,  160,  161,    0,    0,  162, 
          163,  164,  165,  166,  167,  168,  169,  170,  171,    0, 
            0,    0,    0,  172,  173,  174,  175,  176,  177,  178, 
          179,    0,  180,  181,  123,  124,  182,  126,    0,    0, 
          183,  184,    0,  185,  186,  187,  188,  189,  190,  191, 
            0,    0,  192,  193,    0,    0,    0,  194,  195,  196, 
          197,    0,    0,    0,    0,    0,    0,  198,    0,    0, 
            0,    0,    0,    0,  199,  200,    0,  201,  202,  203, 
          204,  205,  206,  207,  208,  209,  210,  211,    0,    0, 
          212,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  213,  138,  139,  140,  141,  142,  143,  144, 
          145,  146,  147,  148,  149,  150,  151,  152,  153,  154, 
          155,  156,  157,  158,  159,  160,  161,    0,    0,  162, 
          163,  164,  219,  220,  221,  222,  169,  170,  171,    0, 
            0,    0,    0,  172,  173,  174,  175,  176,  223,  224, 
          225,    0,  226,  181,  356,  357,  227,  358,    0,    0, 
          183,  184,    0,  185,  186,  187,  188,  189,  190,  191, 
            0,    0,  192,  193,    0,    0,    0,  194,  195,  196, 
          197,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  199,  200,    0,  201,  202,  203, 
          204,  205,  206,  207,  208,  209,  210,  211,    0,    0, 
          212,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  213,  138,  139,  140,  141,  142,  143,  144, 
          145,  146,  147,  148,  149,  150,  151,  152,  153,  154, 
          155,  156,  157,  158,  159,  160,  161,    0,    0,  162, 
          163,  164,  219,  220,  221,  222,  169,  170,  171,    0, 
            0,    0,    0,  172,  173,  174,  175,  176,  223,  224, 
          225,    0,  226,  181,  306,    0,  227,    0,    0,    0, 
          183,  184,    0,  185,  186,  187,  188,  189,  190,  191, 
            0,    0,  192,  193,    0,    0,    0,  194,  195,  196, 
          197,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  199,  200,    0,  201,  202,  203, 
          204,  205,  206,  207,  208,  209,  210,  211,    0,    0, 
          212,   52,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  213,  138,  139,  140,  141,  142,  143,  144, 
          145,  146,  147,  148,  149,  150,  151,  152,  153,  154, 
          155,  156,  157,  158,  159,  160,  161,    0,    0,  162, 
          163,  164,  219,  220,  221,  222,  169,  170,  171,    0, 
            0,    0,    0,  172,  173,  174,  175,  176,  223,  224, 
          225,    0,  226,  181,    0,    0,  227,    0,    0,    0, 
          183,  184,    0,  185,  186,  187,  188,  189,  190,  191, 
            0,    0,  192,  193,    0,    0,    0,  194,  195,  196, 
          197,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  199,  200,    0,  201,  202,  203, 
          204,  205,  206,  207,  208,  209,  210,  211,    0,    0, 
          212,   52,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  213,  138,  139,  140,  141,  142,  143,  144, 
          145,  146,  147,  148,  149,  150,  151,  152,  153,  154, 
          155,  156,  157,  158,  159,  160,  161,    0,    0,  162, 
          163,  164,  219,  220,  221,  222,  169,  170,  171,    0, 
            0,    0,    0,  172,  173,  174,  175,  176,  223,  224, 
          225,    0,  226,  181,    0,    0,  227,    0,    0,    0, 
          183,  184,    0,  185,  186,  187,  188,  189,  190,  191, 
            0,    0,  192,  193,    0,    0,    0,  194,  195,  196, 
          197,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  199,  200,    0,  201,  202,  203, 
          204,  205,  206,  207,  208,  209,  210,  211,    0,    0, 
          212,    0,    0,    0,    0,    0,    0,    3,    4,    5, 
            6,    7,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,  213,   12,   13,   14,   15,   16,   17,   18, 
            0,    0,    0,    0,   19,   20,   21,   22,   23,   24, 
           25,    0,    0,   26,    0,    0,    0,    0,    0,   27, 
           28,   29,   30,   31,   32,   33,    0,   34,   35,   36, 
           37,   38,   39,    0,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   44,    0, 
            0,   45,    0,    0,   46,   47,    0,   48,    0,   49, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,   51,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,   65,   66,  316,    4,    5, 
            6,    7,  317,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   15,   16,   17,   18, 
            0,    0,    0,    0,   19,   20,   21,   22,   23,   24, 
           25,    0,    0,   26,    0,    0,    0,    0,    0,   27, 
           28,    0,   30,   31,   32,   33,    0,   34,   35,   36, 
           37,   38,   39,    0,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   44,    0, 
            0,  318,    0,    0,   46,   47,    0,   48,    0,   49, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,   51,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,   65,   66,  316,    4,    5, 
            6,    7,  317,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   15,   16,   17,   18, 
            0,    0,    0,    0,   19,   20,   21,   22,   23,   24, 
           25,    0,    0,   26,    0,    0,    0,    0,    0,   27, 
           28,    0,   30,   31,   32,   33,    0,   34,   35,   36, 
           37,   38,   39,    0,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   44,    0, 
            0,   45,    0,    0,   46,   47,    0,   48,    0,   49, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,   51,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,   65,   66,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   15,   16,   17,   18,    0, 
            0,    0,    0,   19,   20,   21,  235,  236,  237,  238, 
            0,    0,  117,    0,    0,    0,    0,    0,    0,   28, 
            0,    0,  239,  240,  241,    0,  242,   35,  243,  244, 
          245,  246,  281,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  247,    0,    0, 
          130,    0,    0,   46,   47,    0,   48,    0,  282,    0, 
          283,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
          284,    0,    0,    0,    0,   52,  285,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,   65,   66,  286,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  108,  109,   17,   18,    0, 
            0,    0,    0,  110,  111,  112,  235,  236,  237,  238, 
            0,    0,  117,    0,    0,    0,    0,    0,    0,   28, 
            0,    0,  239,  240,  241,    0,  242,   35,  243,  244, 
          245,  246,  281,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  247,    0,    0, 
          130,    0,    0,   46,   47,    0,   48,    0,  679,    0, 
          283,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
          284,    0,    0,    0,    0,   52,  285,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,   65,   66,  286,  280,  280,  280, 
            0,  280,    0,    0,    0,  280,  280,    0,    0,    0, 
          280,    0,  280,  280,  280,  280,  280,  280,  280,    0, 
            0,    0,    0,  280,  280,  280,  280,  280,  280,  280, 
            0,    0,  280,    0,    0,    0,    0,    0,    0,  280, 
            0,    0,  280,  280,  280,    0,  280,  280,  280,  280, 
          280,  280,  280,  280,  280,  280,  280,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  280,    0,    0, 
          280,    0,    0,  280,  280,    0,  280,    0,  280,    0, 
          280,    0,  280,    0,    0,    0,    0,    0,    0,    0, 
          280,    0,    0,    0,    0,  280,  280,  280,  280,  280, 
          280,    0,    0,    0,  280,    0,  280,  280,    0,  280, 
          280,  280,  280,    0,  280,  280,  280,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  108,  109,   17,   18,    0, 
            0,    0,    0,  110,  111,  112,  235,  236,  237,  238, 
            0,    0,  117,    0,    0,    0,    0,    0,    0,   28, 
            0,    0,  239,  240,  241,    0,  242,   35,  243,  244, 
          245,  246,  281,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  247,    0,    0, 
          130,    0,    0,   46,   47,    0,   48,    0,  282,    0, 
            0,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
          284,    0,    0,    0,    0,   52,  285,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,   65,   66,  286,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  108,  109,   17,   18,    0, 
            0,    0,    0,  110,  111,  112,  235,  236,  237,  238, 
            0,    0,  117,    0,    0,    0,    0,    0,    0,   28, 
            0,    0,  239,  240,  241,    0,  242,   35,  243,  244, 
          245,  246,  281,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  247,    0,    0, 
          130,    0,    0,   46,   47,    0,   48,    0,    0,    0, 
          283,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
          284,    0,    0,    0,    0,   52,  285,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,   65,   66,  286,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  108,  109,   17,   18,    0, 
            0,    0,    0,  110,  111,  112,  235,  236,  237,  238, 
            0,    0,  117,    0,    0,    0,    0,    0,    0,   28, 
            0,    0,  239,  240,  241,    0,  242,   35,  243,  244, 
          245,  246,  281,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  247,    0,    0, 
          130,    0,    0,   46,   47,    0,   48,    0,  679,    0, 
            0,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
          284,    0,    0,    0,    0,   52,  285,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,   65,   66,  286,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  108,  109,   17,   18,    0, 
            0,    0,    0,  110,  111,  112,  235,  236,  237,  238, 
            0,    0,  117,    0,    0,    0,    0,    0,    0,   28, 
            0,    0,  239,  240,  241,    0,  242,   35,  243,  244, 
          245,  246,  281,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  247,    0,    0, 
          130,    0,    0,   46,   47,    0,   48,    0,    0,    0, 
            0,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
          284,    0,    0,    0,    0,   52,  285,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,   65,   66,  286,    4,    5,    6, 
            7,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   15,   16,   17,   18,    0, 
            0,    0,    0,   19,   20,   21,   22,   23,   24,   25, 
            0,    0,   26,    0,    0,    0,    0,    0,   27,   28, 
           29,   30,   31,   32,   33,    0,   34,   35,   36,   37, 
           38,   39,    0,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   44,    0,    0, 
           45,    0,    0,   46,   47,    0,   48,    0,   49,    0, 
            0,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
           51,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,   65,   66,    4,    5,    6,    7, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   15,   16,   17,   18,    0,    0, 
            0,    0,   19,   20,   21,   22,   23,   24,   25,    0, 
            0,   26,    0,    0,    0,    0,    0,   27,   28,    0, 
           30,   31,   32,   33,    0,   34,   35,   36,   37,   38, 
           39,    0,   40,   41,   42,   43,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   44,    0,    0,   45, 
            0,    0,   46,   47,    0,   48,    0,   49,    0,    0, 
            0,   50,    0,    0,    0,    0,    0,    0,    0,   51, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
           63,   64,    0,   65,   66,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,  108,  109,   17,   18,    0,    0,    0, 
            0,  110,  111,  112,  235,  236,  237,  238,    0,    0, 
          117,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
          239,  240,  241,    0,  242,   35,  243,  244,  245,  246, 
            0,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  247,    0,    0,  130,  504, 
            0,   46,   47,    0,   48,    0,    0,    0,    0,    0, 
           50,    0,    0,    0,    0,    0,    0,    0,  284,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,   63, 
           64,    0,   65,   66,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   15,   16,   17,   18,    0,    0,    0,    0, 
           19,   20,   21,  235,  236,  237,  238,    0,    0,  117, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,  239, 
          240,  241,    0,  242,   35,  243,  244,  245,  246,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  247,    0,    0,  130,    0,    0, 
           46,   47,    0,   48,    0,  615,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  284,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,   65,   66,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  108,  109,   17,   18,    0,    0,    0,    0,  110, 
          111,  112,  235,  236,  237,  238,    0,    0,  117,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,  239,  240, 
          241,    0,  242,   35,  243,  244,  245,  246,    0,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  247,    0,    0,  130,    0,    0,   46, 
           47,    0,   48,    0,  282,    0,    0,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,  284,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,   63,   64,    0, 
           65,   66,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
          108,  109,   17,   18,    0,    0,    0,    0,  110,  111, 
          112,  235,  236,  237,  238,    0,    0,  117,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,  239,  240,  241, 
            0,  242,   35,  243,  244,  245,  246,    0,   40,   41, 
           42,   43,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  247,    0,    0,  130,    0,    0,   46,   47, 
            0,   48,    0,  615,    0,    0,    0,   50,    0,    0, 
            0,    0,    0,    0,    0,  284,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,   63,   64,    0,   65, 
           66,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  108, 
          109,   17,   18,    0,    0,    0,    0,  110,  111,  112, 
          235,  236,  237,  238,    0,    0,  117,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,  239,  240,  241,    0, 
          242,   35,  243,  244,  245,  246,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  247,    0,    0,  130,    0,    0,   46,   47,    0, 
           48,    0,  888,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,  284,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,   65,   66, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  108,  109, 
           17,   18,    0,    0,    0,    0,  110,  111,  112,  235, 
          236,  237,  238,    0,    0,  117,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,  239,  240,  241,    0,  242, 
           35,  243,  244,  245,  246,    0,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          247,    0,    0,  130,    0,    0,   46,   47,    0,   48, 
            0,  679,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  284,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,   65,   66,  632, 
          632,  632,    0,  632,    0,    0,    0,  632,  632,    0, 
            0,    0,  632,    0,  632,  632,  632,  632,  632,  632, 
          632,    0,    0,    0,    0,  632,  632,  632,  632,  632, 
          632,  632,    0,    0,  632,    0,    0,    0,    0,    0, 
            0,  632,    0,    0,  632,  632,  632,    0,  632,  632, 
          632,  632,  632,  632,    0,  632,  632,  632,  632,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  632, 
            0,    0,  632,  632,    0,  632,  632,    0,  632,    0, 
            0,    0,    0,    0,  632,    0,    0,    0,    0,    0, 
            0,    0,  632,    0,    0,    0,    0,  632,  632,  632, 
          632,  632,  632,    0,    0,    0,  632,    0,  632,  632, 
            0,  632,  632,  632,  632,    0,  632,  632,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   15,   16,   17,   18, 
            0,    0,    0,    0,   19,   20,   21,  235,  236,  237, 
          238,    0,    0,   26,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,  239,  240,  241,    0,  242,   35,  243, 
          244,  245,  246,    0,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  247,    0, 
            0,  130,    0,    0,   46,   47,    0,   48,    0,    0, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,   51,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,   65,   66,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  108,  109,   17,   18,    0, 
            0,    0,    0,  110,  111,  112,  235,  236,  237,  238, 
            0,    0,  117,    0,    0,    0,    0,    0,    0,   28, 
            0,    0,  239,  240,  241,    0,  242,   35,  243,  244, 
          245,  246,    0,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  247,    0,    0, 
          130,    0,    0,   46,   47,    0,   48,    0,    0,    0, 
            0,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
          284,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,   65,   66,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   15,   16,   17,   18,    0,    0, 
            0,    0,   19,   20,   21,  235,  236,  237,  238,    0, 
            0,  117,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,  239,  240,  241,    0,  242,   35,  243,  244,  245, 
          246,    0,   40,   41,   42,   43,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  247,    0,    0,  130, 
            0,    0,   46,   47,    0,   48,    0,    0,    0,    0, 
            0,   50,    0,    0,    0,    0,    0,    0,    0,  284, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
           63,   64,    0,   65,   66,  632,  632,  632,    0,  632, 
            0,    0,    0,  632,  632,    0,    0,    0,  632,    0, 
          632,  632,  632,  632,  632,  632,  632,    0,    0,    0, 
            0,  632,  632,  632,  632,  632,  632,  632,    0,    0, 
          632,    0,    0,    0,    0,    0,    0,  632,    0,    0, 
          632,  632,  632,    0,  632,  632,  632,  632,  632,  632, 
            0,  632,  632,  632,  632,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  632,    0,    0,  632,    0, 
            0,  632,  632,    0,  632,    0,    0,    0,    0,    0, 
          632,    0,    0,    0,    0,    0,    0,    0,  632,    0, 
            0,    0,    0,  632,  632,  632,  632,  632,  632,    0, 
            0,    0,  632,    0,  632,  632,    0,  632,  632,  632, 
          632,    0,  632,  632,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  108,  109,   17,   18,    0,    0,    0,    0, 
          110,  111,  112,  113,  114,  115,  116,    0,    0,  117, 
            0,    0,    0,    0,    0,    0,  118,    0,    0,  119, 
          120,  121,    0,  122,   35,  123,  124,  125,  126,    0, 
           40,    0,    0,  127,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          128,    0,    0,    0,  129,    0,    0,  130,    0,    0, 
           46,   47,    0,   48,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,   65,   66,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  108,  109,   17,   18,    0,    0,    0,    0,  110, 
          111,  112,  263,  264,  265,  266,    0,    0,  117,    0, 
            0,    0,    0,    0,    0,  118,    0,    0,  267,  268, 
          269,    0,  270,   35,  271,  272,  273,  274,    0,   40, 
            0,    0,  127,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  275,    0,    0,   45,    0,    0,   46, 
           47,    0,   48,    0,   49,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,   63,   64,    0, 
           65,   66,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
          108,  109,   17,   18,    0,    0,    0,    0,  110,  111, 
          112,  336,  337,  338,  339,    0,    0,  117,    0,    0, 
            0,    0,    0,    0,  118,    0,    0,  340,  341,  342, 
            0,  343,   35,  344,  345,  346,  347,    0,   40,    0, 
            0,  127,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  348,    0,    0,  425,    0,    0,   46,   47, 
            0,   48,    0,  426,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,   63,   64,    0,   65, 
           66,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  108, 
          109,   17,   18,    0,    0,    0,    0,  110,  111,  112, 
          113,  114,  115,  116,    0,    0,  117,    0,    0,    0, 
            0,    0,    0,  118,    0,    0,  119,  120,  121,    0, 
          122,   35,  123,  124,  125,  126,    0,   40,    0,    0, 
          127,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  129,    0,    0,  130,    0,    0,   46,   47,    0, 
           48,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,   65,   66, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  108,  109, 
           17,   18,    0,    0,    0,    0,  110,  111,  112,  336, 
          337,  338,  339,    0,    0,  117,    0,    0,    0,    0, 
            0,    0,  118,    0,    0,  340,  341,  342,    0,  343, 
           35,  344,  345,  346,  347,    0,   40,    0,    0,  127, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          348,    0,    0,  425,    0,    0,   46,   47,    0,   48, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,   65,   66,    4, 
            5,    6,    0,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,  108,  109,   17, 
           18,    0,    0,    0,    0,  110,  111,  112,  113,  114, 
          115,  116,    0,    0,  117,    0,    0,    0,    0,    0, 
            0,  118,    0,    0,  119,  120,  121,    0,  951,   35, 
          123,  124,  952,  126,    0,   40,    0,    0,  127,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  953, 
            0,    0,  130,    0,    0,   46,   47,    0,   48,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,   63,   64,    0,   65,   66,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,  108,  109,   17,   18, 
            0,    0,    0,    0,  110,  111,  112,  967,  968,  969, 
          970,    0,    0,  117,    0,    0,    0,    0,    0,    0, 
          118,    0,    0,  971,  972,  973,    0,  974,   35,  975, 
          976,  977,  978,    0,   40,    0,    0,  127,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  979,    0, 
            0,  130,    0,    0,   46,   47,    0,   48,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,   65,   66,  639,  597,    0, 
            0,  640,    0,    0,    0,  183,  184,    0,  185,  186, 
          187,  188,  189,  190,  191,    0,    0,  192,  193,    0, 
            0,    0,  194,  195,  196,  197,    0,    0,    0,    0, 
            0,    0,  300,    0,    0,    0,    0,    0,    0,  199, 
          200,    0,  201,  202,  203,  204,  205,  206,  207,  208, 
          209,  210,  211,  610,  605,  212,    0,  611,    0,    0, 
            0,  183,  184,    0,  185,  186,  187,  188,  189,  190, 
          191,    0,    0,  192,  193,    0,    0,  213,  194,  195, 
          196,  197,    0,    0,    0,    0,    0,    0,  300,    0, 
            0,    0,    0,    0,    0,  199,  200,    0,  201,  202, 
          203,  204,  205,  206,  207,  208,  209,  210,  211,  657, 
          597,  212,    0,  658,    0,    0,    0,  183,  184,    0, 
          185,  186,  187,  188,  189,  190,  191,    0,    0,  192, 
          193,    0,    0,  213,  194,  195,  196,  197,    0,    0, 
            0,    0,    0,    0,  300,    0,    0,    0,    0,    0, 
            0,  199,  200,    0,  201,  202,  203,  204,  205,  206, 
          207,  208,  209,  210,  211,  660,  605,  212,    0,  661, 
            0,    0,    0,  183,  184,    0,  185,  186,  187,  188, 
          189,  190,  191,    0,    0,  192,  193,    0,    0,  213, 
          194,  195,  196,  197,    0,    0,    0,    0,    0,    0, 
          300,    0,    0,    0,    0,    0,    0,  199,  200,    0, 
          201,  202,  203,  204,  205,  206,  207,  208,  209,  210, 
          211,  671,  597,  212,    0,  672,    0,    0,    0,  183, 
          184,    0,  185,  186,  187,  188,  189,  190,  191,    0, 
            0,  192,  193,    0,    0,  213,  194,  195,  196,  197, 
            0,    0,    0,    0,    0,    0,  300,    0,    0,    0, 
            0,    0,    0,  199,  200,    0,  201,  202,  203,  204, 
          205,  206,  207,  208,  209,  210,  211,  674,  605,  212, 
            0,  675,    0,    0,    0,  183,  184,    0,  185,  186, 
          187,  188,  189,  190,  191,    0,    0,  192,  193,    0, 
            0,  213,  194,  195,  196,  197,    0,    0,    0,    0, 
            0,    0,  300,    0,    0,    0,    0,    0,    0,  199, 
          200,    0,  201,  202,  203,  204,  205,  206,  207,  208, 
          209,  210,  211,  702,  597,  212,    0,  703,    0,    0, 
            0,  183,  184,    0,  185,  186,  187,  188,  189,  190, 
          191,    0,    0,  192,  193,    0,    0,  213,  194,  195, 
          196,  197,    0,    0,    0,    0,    0,    0,  300,    0, 
            0,    0,    0,    0,    0,  199,  200,    0,  201,  202, 
          203,  204,  205,  206,  207,  208,  209,  210,  211,  705, 
          605,  212,    0,  706,    0,    0,    0,  183,  184,    0, 
          185,  186,  187,  188,  189,  190,  191,    0,    0,  192, 
          193,    0,    0,  213,  194,  195,  196,  197,    0,    0, 
            0,    0,    0,    0,  300,    0,    0,    0,    0,    0, 
            0,  199,  200,    0,  201,  202,  203,  204,  205,  206, 
          207,  208,  209,  210,  211, 1057,  597,  212,    0, 1058, 
            0,    0,    0,  183,  184,    0,  185,  186,  187,  188, 
          189,  190,  191,    0,    0,  192,  193,    0,    0,  213, 
          194,  195,  196,  197,    0,    0,    0,    0,    0,    0, 
          300,    0,    0,    0,    0,    0,    0,  199,  200,    0, 
          201,  202,  203,  204,  205,  206,  207,  208,  209,  210, 
          211, 1062,  597,  212,    0, 1063,    0,    0,    0,  183, 
          184,    0,  185,  186,  187,  188,  189,  190,  191,    0, 
            0,  192,  193,    0,    0,  213,  194,  195,  196,  197, 
            0,    0,    0,    0,    0,    0,  300,    0,    0,    0, 
            0,    0,    0,  199,  200,    0,  201,  202,  203,  204, 
          205,  206,  207,  208,  209,  210,  211, 1065,  605,  212, 
            0, 1066,    0,    0,    0,  183,  184,    0,  185,  186, 
          187,  188,  189,  190,  191,    0,    0,  192,  193,    0, 
            0,  213,  194,  195,  196,  197,    0,    0,    0,    0, 
            0,    0,  300,    0,    0,    0,    0,    0,    0,  199, 
          200,    0,  201,  202,  203,  204,  205,  206,  207,  208, 
          209,  210,  211,  610,  605,  212,    0,  611,    0,    0, 
            0,  183,  184,    0,  185,  186,  187,  188,  189,  190, 
          191,    0,    0,  192,  193,    0,    0,  213,  194,  195, 
          196,  197,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  199,  200,    0,  201,  202, 
          203,  204,  205,  206,  207,  208,  209,  210,  211,    0, 
            0,  212,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  213, 
      };
   }

   private static final short[] yyCheck1() {
      return new short[] {

           26,   74,   28,  292,   27,    2,    3,    4,    5,   88, 
            6,   90,    9,   10,   11,    7,   21,   14,   15,   16, 
           51,  466,   19,    7,  446,    2,    3,  486,  254,   99, 
          417,   45,   49,   15,   16,   27,    3,   19,  471,   10, 
          129,    0,  424,   27,    6,    7,   10,    0,   45,   10, 
            4,    5,   49,   59,   51,   11,   52,  444,  483,    0, 
           14,  486,   32,   10,   10,   27,  525,   15,   16,   10, 
           10,   19,   21,  460,   10,   11,   59,   10,   10,    0, 
           10,   15,   16,   44,   10,   19,   10,  474,   59,   10, 
           52,  416,  118,  418,  535,   49,  421,   44,   59,   47, 
           48,  106,   99,  506,  331,   44,   10,  653,  335,  643, 
           10,   44,   59,   47,  553,   10,   10,  663,   59,   59, 
          445,   10,   61,   44,  318,  659,   59,   10,  846,  104, 
           10,  128,   10,  130,  459,   59,  461,  922,   59,  673, 
           44,  947,  305,   10,   10,   99,  533,   10,  104,   10, 
          475,   43,   10,  428,  956,   59,  280,  106,  647,   59, 
          649,   44,   10,  112,   59,   10,   10,  743,   10,   10, 
          704,  250,   61,   10,   10,    0,   59,   44,  308,   59, 
          341,   59,  328,  624,  509,   10,   10,  136,  305,  345, 
          336,   10,   59,   59,  290,  291,   59,  276,   59,  280, 
           44,   59,  325,   44,  263,  264,  495,  363,  647,  534, 
          649,   59,  375,  342,   59,   59,  638,   10,  269,  561, 
          271,   10,   59,   59,   32,   10,  648,   10,  687,   10, 
          359,  425,  721,  312,   59,  127,  359,  234,  362,   10, 
           10,   10,    2,    3,  341, 1051,  376,  377,   10,    9, 
           10,   11,   10,  595, 1039,   15,   16, 1059,  375,   19, 
          341,  686,  687,   44,  261,  262,  759,   10,  350,  351, 
           59,  350,  765,   44,   44,   10,   59,   10,   10,  349, 
           61,  362,  721,   10,  860,   45,   10, 1005,   59,  865, 
           10,   51,   61,  696,   10,  317,  836,   10,  310,   61, 
          297,  257,  299,  300,  318,   10,  303,   10,  305,   44, 
          749,   10,   10,  310,  362,  297,  856,  299,  300,  316, 
           10,  318,   32,  268,  269,  261,  262,  349,   61,   10, 
          327,  353,  354,  366,   61,  776,   32,   61,  342,  316, 
          279,  262,  263,  264,  305,  320,  267,  268,  269,  297, 
          271,  299,  349,  359,  443,  359,   32,  281,   61,  342, 
          290,  291,  938,  297,  320,  299,  912,  267,  128,  264, 
          130,   61,  293,  294,  295,  296,  297,  652,  342,  812, 
           61,  342,  379,  380,  381,  382,  383,  384,  385,  104, 
          772,  422,  681,  424,   32,  349,  342,  428,  429,  345, 
          267,  371,  372,   10,  363,  844,  383,  846,  378,  426, 
          363,  425,  359,  345,  375,  341,  387,  282,  339,  264, 
          417,  342,  363,  363,  269,  422,  359,  424,  425,  426, 
          267,  428,  429,   10,  431,  417,  778,   44,   44,  665, 
           10, 1017,  363,  379,  380,  381,  382,  444,  342,  446, 
          447,  345,   59,  342,  431,  359,  418,  916,   61,  421, 
          457,  305,  444,  460,  431,  535,  387,  912,  465,  418, 
          338,  893,  426,  700,  234,   10,  359,  474,  460,  359, 
          503,  359,   59,  445,  342,    2,    3,    4,    5,   59, 
          424,  916,  474,  359,  428,   61,  445,   14,  342,  461, 
          342,  261,  262,  345,  943,   45,  342,  504,  947,  506, 
          279,  503,  461,  475,  470,  471,  305,  279,  342,  503, 
          517,  345,  305,  342,   59,  338,  475,  816,   45,  506, 
         1064,  375,   49,  467,  305,  483,  533,  297,  535,  299, 
          300,  503,  257,  303,  966,  305,  279,  509,  357,  342, 
          310,  533,  279,  342,  624,  279,  316,  342,  318,  342, 
          509,  342,   10,  371,  372,   10, 1005,  327,  594,  341, 
          378,  342,  534,  342,  522,   44,  279,  603,  303,   10, 
          342,  535,   99,  306,  342,  534,  375,  310,  359,  279, 
          130,  310,  375,  338,  599,   61,    0,  338,  279,  342, 
          325,  326,  607,  271,  375,  320,   10,  612,   59,  342, 
          342,   59, 1051,  130,  279,  342,   61,  643,  342,  379, 
          380,  381,  382,  383,  384,  385,  342,  624,  651,  342, 
           61,  701,  310,  659,   44,  339,   44,  342,  317,  342, 
          637,  638,  317,  342,  342,  749, 1033,  673,    2,    3, 
          599,  648,  342,  362,  650,   59,  338,  417,  607,  651, 
           14,  342,  422,  612,  424,  425,  363,  651,  428,  429, 
          624,  431,   10,   15,   16,  901,  342,   19,  704,  676, 
          636,  907,  345,  310,  444,  749,  446,  447,  650,  651, 
          267,   45,  641,  263,  264,  644,  769,  457,  305,  696, 
          460,  637,  373,  328,  701,  465,  776,  844,   44, 1034, 
          335,  336,    2,    3,  474,   44,  373,  234,  652,  696, 
          373,   59,  373,  749,   44,  756,  757,  262,  263,  264, 
          347,  762,  763,  268,  269,  342,  271,  341,  686,  341, 
          676,  772,  263,  264,  504,  373,  506,  701,  269,   10, 
          378,  262,  359,  267,  751,   45,  753,  517,  755,  756, 
          757,  264,  339,  488,  312,  762,  763,  264,  375,  317, 
          310,  496,  497,  533,  553,  772,  130,  342,  318,  776, 
          844,   44,  846,   44,  371,  372,   10,   91,   44,  514, 
          373,  378,  363,  310,    0,  378,  383,  794,   59,  316, 
          797,  318,  350,  351,   10,  362,  943,  342,   44,   91, 
          836,  808,  809,  810,  262,  263,  264,   32,  734,  735, 
          268,  269,  776,  271,  780,   32,  338,   61,  363,   91, 
          856,  787,  349,  338,  279,   59,  940,  373,  386,  943, 
          130,  945,  378,  947,  841,  842,  338,  878,  279,  373, 
           44,   10,  387,   59,  378,  338,  812,   44,  262,  263, 
          264,  797,  999,   44,  268,  269,  383,  271,  647,  866, 
          649,  264,  269,  338,    2,  338,  338,  637,  638,  943, 
          234,  878,  338,  947,  264,  425,  363,  306,  648,  293, 
          294,  295,  296,  297,  342,  892,  893,  342,  623,  306, 
           59,  980,   91,  900,   10,   91,   44,  904,  425,  426, 
         1047,  342,  866,   44,  431,  363,  676,  457,   44,   47, 
           48,  646,   44,   10,  306,  465,  264,   10,   44,  446, 
          345,  269,   91,  271,   61,   58,  696,  338,  342,  387, 
          457, 1005,  721, 1047,  234, 1049,  900, 1051,  465,  264, 
         1054,   91,  264,   59,   91,  297,  310,  299,  955,  363, 
          339,   44,  316,  263,  318,  264,  691,  338,  264,  966, 
           44,  363,   59,   44,  699,   44,   59,  306,   44,  308, 
          309,  310,  311,  387, 1088,   91,  983, 1051,  985,  506, 
           44,  751,   44,  753,  991,  755,  756,  757,  359, 1025, 
          517,  955,  762,  763,   91,   61,  267,  264,   91,  925, 
           59,  363,  772,   10,  930,  931,  264,  933,  535,  935, 
          310,  264,   44,  264,  328,   44,  316,   44,  318,  383, 
          363,  335,  336,  342,  794,  264, 1033,  797, 1064,   44, 
          264, 1038,   44,   44,  268,  269,  328,   44,  808,  809, 
          810, 1033,  359,  335,  336,  310,  262,  263,  264,   91, 
          785,  267,  268,  269,   61,  271,  328,  264,  363,   91, 
          424,  425, 1034,  335,  336,  281,  264,  431,  339,  310, 
          920,  841,  842,   44,   44, 1034,   44,  293,  294,  295, 
          296,  297,  446,  383,   91,  371,  372,  373,  720,    0, 
           44,   44,  378,  457,   10,   44,  264,  624,  267,   10, 
          835,  465,  306,   44,  308,  309,  310,  311,  878,   44, 
          387,  638,  293,  294,  295,  296,  297, 1043, 1044, 1045, 
         1046,  648,  892,  893,   44,  425,  342,  271,   44,  328, 
          345,  431,  328,   44,  904,  363,  335,  336,  341,  335, 
          336,  271,  506,   59,  345,  995,  446,  363,   59,  342, 
          363,  267,   58,  517,  264,  345,   91,  457,  345,  328, 
         1086,   70,  300,  285,  280,  465,  335,  336,   54,  696, 
          267,  387,  341,    5,  701,   91,  517,  372,  328, 1036, 
            6,  328,  709,  280,  919,  335,  336,  280,  335,  336, 
          612, 1041,  844,  371,  372,  373,  966,  899,  830,  831, 
          378,  751,  749,  753,  848,  755,  506,   44,    9,   10, 
           11,  943,  328,  983,  945,  985,  768,  517,   14,  335, 
          336,  991, 1072, 1035,  751,  341,  753,   10,  755,  830, 
           -1,  328, 1059,   48,   -1,  328,   -1,   -1,  335,  336, 
           -1,   -1,  335,  336,  794,   -1,  362,  279,  341,  776, 
          371,  372,  373,   -1,   91,   -1,   -1,  378,  808,  809, 
          810,   44,   -1, 1033,   -1,  362,  359,  794, 1038,  362, 
           -1,   -1,  279,  280,  638,    0,   -1,   -1,   61,  417, 
           -1,  808,  809,  810,  648,   10,  328,   -1,  920,  749, 
          922,  841,  842,  335,  336,  362,  328,  364,   -1,  366, 
          371,  372,  373,  335,  336,  372,  444,  378,   91,  341, 
           -1,  371,  372,  373,  841,  842,   10,  388,  378,   44, 
           -1,  328,  460,   -1,   -1,   10,   -1,  128,  335,  336, 
          308,  309,  696,  311,   59,  342,  474,   -1,  638,  866, 
           -1,   -1,  892,   -1,  279,  280,   -1,   -1,  648,   -1, 
           44,  262,  263,  264,  904,  362,  267,  268,  269,   -1, 
          271,   -1,   -1,  995,  996,  892,  893,   61,  506,   10, 
          281,  282,   -1,  900,   59,   -1,   -1,  904,  317,  290, 
          291,   -1,  293,  294,  295,  296,  297,  751,  848,  753, 
           -1,  755,   -1,  328,   -1,  533,  696,   91,  376,  377, 
          335,  336,   -1,   44,   -1,   -1,   91, 1039,  772, 1041, 
          349,   -1,  328,  480,  353,  354,  355,  356,   59,  335, 
          336,   -1,  560,  561,   -1,  341,   -1,  362,  955,   -1, 
          794,  342,   -1,  983,  345,  985,  347,   -1,   -1,  966, 
         1072,  991,  279,  359,  808,  809,  810,  371,  372,  373, 
           91,  751,  363,  753,  378,  755,  983,  595,  985,   -1, 
          261,  262,   -1,    0,  991,   -1,  281,  282,  283,  607, 
           10,  286,   -1,   10,  612,   -1,  387,  841,  842,   10, 
          940,   -1,  549,  943,   -1,  945,   -1,  947, 1038,  556, 
           -1,  328,   -1,   -1,  794,   -1,  279,   -1,  335,  336, 
           -1,   -1,  303,   -1,  305,   -1,  644,   44,  808,  809, 
          810, 1038,   -1,   -1,  652,  653,   10,  655,   -1,   59, 
           -1,   -1,   59,   -1,   -1,  663,  327,   -1,  892,  893, 
           15,   16,   -1,   -1,   19,   -1,  900,  262,  263,  264, 
          904,  841,  842,  268,  269,  328,  271,  371,  372,  373, 
           44,   -1,  335,  336,  378,   -1,   41,   42,  696,  342, 
           -1,   -1,   47,   48,   -1,   50,   51,   61,  293,  294, 
          295,  296,  297,   -1,   10,   -1,   -1,   -1,  379,  380, 
          381,  382,  267,  384,  385,  279,   44, 1047,   -1, 1049, 
           -1, 1051,  892,  893, 1054,  280,  306,   91,  308,  309, 
          310,  311,  966,  306,  904,  308,  309,  310,  311,  424, 
           -1,   -1,   -1,  428,   -1,   10,   -1,  342,   -1,  983, 
           -1,  985,   -1,   59,   10,   -1,   -1,  991, 1088,   -1, 
          340,   -1,   -1,   91,  328,   -1,   -1,  340,  363,  280, 
          778,  335,  336,  328,   -1,  348,  447,  341,  342,   44, 
          335,  336,  467,   -1,  792,   91,  341,  795,   44,   -1, 
           -1,   -1,  387,   -1,   59,   -1,  966,  482,  483,   -1, 
           -1,  486,   -1,   -1, 1038,   61,   -1,  362,   -1,  371, 
          372,  373,   -1,  983,   -1,  985,  378,  328,  749,   -1, 
           -1,  991,   -1,   -1,  335,  336,   91,  371,  372,  373, 
          341,   -1,   -1,  504,  378,   91,   10,  522,   -1,  306, 
          525,  308,  309,  310,  311,   -1,   -1,   -1,  359,   -1, 
           -1,  362,  262,  263,  264,  262,  263,  264,   -1,  269, 
          267,  268,  269,  317,  271,   -1,   -1,  306, 1038,  308, 
          309,  310,  311,  340,  281,  282,   10,   -1,   -1,  333, 
          334,  348,   -1,  290,  291,   59,  293,  294,  295,  296, 
          297,  379,  380,  381,  382,  349,   -1,  351,   -1,  353, 
          354,  355,  356,   -1,  912,  306,   -1,  308,  309,  310, 
          311,  312,   -1,   -1,   10,  279,  317,  848,   -1,   -1, 
          851,   -1,   -1,   -1,    0,   59,  281,  282,  283,  284, 
          615,  286,   -1,   -1,   10,  342,   -1,   -1,  345,  340, 
          347,   -1,  297,   -1,  299,  300,   -1,  348,  349,  350, 
          351,  279,   -1,  308,   -1,   -1,  363,   91,   -1,   -1, 
           -1,  267,   -1,   59,  328,   -1,  637,  652,   44,   -1, 
           -1,  335,  336,   -1,   -1,   -1,   -1,   10,  342,   -1, 
          387,   -1,   58,   59,   -1,  386,   -1,   63,   -1,   -1, 
           -1,   -1,  677,   -1,  679,   91,   -1,   -1,   -1,   -1, 
          328,  686,  687,   -1,   -1,  676,   -1,  335,  336,  940, 
           -1,   -1,  943,   -1,  945,  280,  947,   10,   -1,   10, 
           -1,   -1,  328,  279,  280, 1033,   59,   -1, 1036,  335, 
          336,  386,  387,  388,  389,  390,  391,  392,  393,  394, 
          395,  396,  397,  398,  399,  400,  401,  402,  403,  404, 
          405,  406,  407,  408,  409,  410,  411,   -1,   91,  744, 
           -1,   -1,  417,  328,   -1,   -1,   59,  422,   59,  424, 
          335,  336,  328,  428,  429,   -1,  341,   -1,   -1,  335, 
          336,   -1,   -1,   44,   -1,  341,  342,   -1,  773,  444, 
           -1,    0,   -1,   -1,  359,   -1,   -1,  362,   91,   44, 
           91,   10,   -1,   -1,   -1,  460,  362,  462,  463,  464, 
           -1,   -1,  467,   44,   -1,   -1, 1047,   -1, 1049,  474, 
         1051,   -1,  807, 1054,   -1,   -1,  797,  482,  483,   -1, 
           91,  486,  306,  267,  308,  309,  310,  311,  312,   -1, 
           -1,   -1,   -1,  317,   -1,   10,   91,   -1,   -1,   10, 
           59,   -1,   -1,   -1,   -1,  510,  511, 1088,   -1,   -1, 
           91,   -1,   -1,    0,   -1,   -1,  340,  522,   -1,  854, 
          525,  267,   -1,   10,  348,  349,  350,  351,  533,   44, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,  328,  271,   61,   -1,   59,   -1, 
           -1,  335,  336,  888,   -1,  281,  282,   44,   -1,   -1, 
           -1,   -1,  386,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   59,   -1,   -1,   -1,   91,   -1,   -1,  305, 
           91,  916,  328,   -1,  267,   -1,   -1,   -1,   -1,  335, 
          336,   -1,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,   -1,  333,  334,   -1, 
          615,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345, 
           -1,  347,   -1,  349,  267,  351,  267,  353,  354,  355, 
          356,  357,  358,  359,   -1,  361,   -1,  363,   -1,  280, 
           -1,   -1,   -1,   -1,   -1,  328,   -1,  652,   -1,  375, 
           -1,   -1,  335,  336,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,  387,   -1,   -1,   -1,   10,   -1,   -1,  279,  262, 
          263,  264,  677,   -1,  679,  268,  269,   -1,  271,   -1, 
           -1,  686,  687,   -1,  279,  328,   -1,  328,   -1,   -1, 
           -1,   -1,  335,  336,  335,  336,   -1,   -1,  279,   44, 
          341,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   58,   59,   -1,   61,  328,   63,   -1, 
           -1,  362,  281,  282,  335,  336,   -1,   -1,   -1,   -1, 
           -1,  290,  291,  328,  293,  294,  295,  296,  297,  744, 
          335,  336,   -1,   -1,   -1,   -1,   91,  328,   -1,  342, 
           -1,  756,  757,   -1,  335,  336,  267,  762,  763,   -1, 
           -1,   -1,   -1,   -1,  279,  280,  771,  772,  773,  280, 
          363,   -1,  777,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,  342,  271,   -1,  345,    0,  347,   -1, 
           -1,   -1,   -1,   -1,  387,  800,  801,   10,  803,  804, 
           -1,   -1,  807,   -1,  363,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,  328,   -1,   -1,   -1,  328,   -1,   -1, 
          335,  336,   -1,   -1,  335,  336,  341,  342,  387,   -1, 
          341,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   58,   59,  362,   61,  854, 
           63,  362,  339,   -1,  306,  342,  308,  309,  310,  311, 
          312,   -1,   -1,   -1,   -1,  317,  871,   -1,   -1,   -1, 
           -1,   -1,   -1,  878,   -1,   -1,  363,   -1,   91,   -1, 
           -1,   -1,   -1,  888,   -1,   -1,   -1,   -1,  340,  341, 
           -1,   -1,   -1,   -1,   -1,   -1,  348,  349,  350,  351, 
          387,   -1,   -1,   -1,  909,   -1,   -1,   10,   -1,   -1, 
           -1,  916,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,  267,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,  386,  280,  281,  282,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,   -1,  299,   -1,   59,  302,  303,  304, 
          305,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,  337,  338,  339,  340,  341,  342,  343,  344, 
          345,  346,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  362,  363,   44, 
          365,  366,  367,  368,  369,  370,   -1,   -1, 1033,  374, 
          375,  376,  377,   -1,  379,  380,  381,  382,   10,  384, 
          385,  386,  387,   -1,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,  267,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   91,  280,  281,  282, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,   -1,  299,   59,   -1,  302, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   44,   -1, 
          333,  334,  335,  336,  337,  338,  339,  340,  341,  342, 
          343,  344,  345,  346,  347,  348,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  362, 
          363,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
            0,  374,  375,  376,  377,   91,  379,  380,  381,  382, 
           10,  384,  385,  386,  387,  262,  263,  264,   -1,   -1, 
           -1,  268,  269,   -1,  271,   -1,  306,   -1,  308,  309, 
          310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1, 
           -1,   -1,   -1,  306,   44,  308,  309,  310,  311,  312, 
           -1,   -1,   -1,   -1,  317,   -1,   -1,   -1,   58,   59, 
          340,   61,   -1,   63,  317,  328,   -1,   -1,  348,  349, 
          350,  351,   -1,  336,   -1,   -1,   -1,  340,  341,   -1, 
          333,  334,   -1,   -1,   -1,  348,  349,  350,  351,   -1, 
           -1,   91,   -1,   -1,  279,  342,  349,   -1,   -1,   -1, 
          353,  354,  355,  356,   -1,   -1,  386,   -1,  306,   -1, 
          308,  309,  310,  311,  312,   -1,  363,   -1,   -1,  317, 
           -1,   -1,  317,  386,   -1,   -1,   -1,  322,  323,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,  333,  334, 
          387,   10,  340,  328,   -1,   -1,   -1,   -1,   -1,   -1, 
          335,  336,  350,  351,  349,   -1,  351,   -1,  353,  354, 
          355,  356,  357,  358,  359,   -1,  361,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  306,   44,  308,  309,  310,  311, 
          312,   -1,   -1,   -1,   -1,  317,   -1,   -1,  386,   58, 
           59,   -1,   61,  279,   63,   -1,  328,  317,  318,  319, 
          320,  321,  322,  323,  336,   -1,  326,  327,  340,  341, 
           -1,   -1,   -1,  333,  334,   -1,  348,  349,  350,  351, 
           -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,  349, 
           -1,  351,   -1,  353,  354,  355,  356,  357,  358,  359, 
           -1,  361,  328,   -1,   -1,   -1,   -1,   -1,   -1,  335, 
          336,   10,   -1,   -1,  386,   -1,   -1,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   -1, 
          280,  281,  282,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,   -1,  299, 
           59,   -1,  302,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   44,   -1,  333,  334,  335,  336,  337,   -1,  339, 
          340,  341,  342,  343,  344,  345,  346,  347,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  362,  363,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,  375,  376,  377,   91,  379, 
          380,  381,  382,   -1,  384,  385,  386,  387,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           -1,  280,  281,  282,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,   -1, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   44,   -1,  333,  334,  335,  336,  337,   -1, 
          339,  340,  341,  342,  343,  344,  345,  346,  347,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  362,  363,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,    0,  374,  375,  376,  377,   91, 
          379,  380,  381,  382,   10,  384,  385,  386,  387,   -1, 
          857,   -1,   -1,   -1,  861,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  306,   44,  308, 
          309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1, 
           -1,   -1,   58,   59,   -1,   61,  279,   63,   -1,  328, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
           -1,  340,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348, 
          349,  350,  351,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,   -1,   -1,  317,  328,  333,  334,   -1,   -1, 
           -1,   -1,  335,  336,   -1,   -1,   -1,  386,   -1,   -1, 
          333,  334,  349,   -1,  351,    0,  353,  354,  355,  356, 
          357,  358,  359,   -1,  361,   10,  349,   -1,  351,   -1, 
          353,  354,  355,  356,   -1,   -1,  359,   -1,  361,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1, 1011,   -1,   -1, 1014, 1015,   44, 
           -1, 1018, 1019,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   58,   59,   -1,   -1,  279,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1, 1078, 1079, 1080, 1081,   -1,  328,   -1,   -1,   -1, 
           -1,   -1,   -1,  335,  336,   10, 1093,   -1,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,  267,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   -1,  280,  281,  282,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,   -1,  299,   59,   -1,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   44,   -1,  333,  334,  335, 
          336,  337,   -1,  339,  340,  341,  342,  343,  344,  345, 
          346,  347,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,  363,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,  375, 
          376,  377,   91,  379,  380,  381,  382,   -1,  384,  385, 
          386,  387,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,  267,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   -1,  280,  281,  282,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,   -1,  299,   -1,   -1,  302,  303,  304, 
          305,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   44,   -1,  333,  334, 
          335,  336,  337,   -1,  339,  340,  341,  342,  343,  344, 
          345,  346,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  362,  363,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,    0,  374, 
          375,  376,  377,   91,  379,  380,  381,  382,   10,  384, 
          385,  386,  387,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  306,   44,  308,  309,  310,  311,  312,   -1,   -1, 
           -1,   -1,  317,   -1,   -1,   -1,   58,   59,   -1,   -1, 
          279,   63,   -1,  328,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,   -1,  340,  341,   -1,   -1,   -1, 
           -1,   -1,   -1,  348,  349,  350,  351,   -1,   -1,   91, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,   -1,  326,  327,   -1,   -1,   -1,   -1,  328, 
          333,  334,   -1,   -1,   -1,   -1,  335,  336,   -1,   -1, 
           -1,  386,   -1,   -1,   -1,   -1,  349,   -1,  351,    0, 
          353,  354,  355,  356,  357,  358,  359,   -1,  361,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  306,  307,   -1,   -1,  310,   -1,   -1,   -1,  314, 
          315,   -1,  317,  318,  319,  320,  321,  322,  323,   -1, 
           -1,  326,  327,   44,   -1,   -1,  331,  332,  333,  334, 
           -1,   -1,   -1,   -1,   -1,   -1,  341,   58,   59,   -1, 
           -1,  279,   63,  348,  349,   -1,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,   -1,   -1,  364, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  386,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          328,   -1,   -1,   -1,   -1,   -1,   -1,  335,  336,   10, 
           -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,  267,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   -1,  280,  281, 
          282,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   -1,  299,   59,   -1, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   44, 
           -1,  333,  334,  335,  336,  337,   -1,  339,  340,  341, 
          342,  343,  344,  345,  346,  347,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,  363,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   -1,  374,  375,  376,  377,   91,  379,  380,  381, 
          382,   -1,  384,  385,  386,  387,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,   63,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,  337,   -1,  339,  340, 
          341,  342,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,  363,   -1,  365,  366,  367,  368,  369,  370, 
           -1,   -1,    0,  374,  375,  376,  377,   -1,  379,  380, 
          381,  382,   10,  384,  385,  386,  387,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  306,   44,  308,  309,  310, 
          311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,   -1, 
           58,   59,   -1,   61,  279,   63,   -1,  328,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,   -1,  340, 
          341,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,  350, 
          351,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   -1,   -1, 
          335,  336,   -1,   -1,   -1,  386,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   59,  329,  330,   -1,   63,  333,  334,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  349,   -1,  351,   -1,  353,  354,  355, 
          356,  357,  358,  359,   91,  361,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,  267, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   59,   -1,  281,  282,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
           -1,  299,   -1,   -1,  302,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   44,   -1,  333,  334,  335,  336,  337, 
           -1,  339,  340,  341,  342,  343,  344,  345,  346,  347, 
          348,  349,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,   -1,  363,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,   -1,  374,  375,  376,  377, 
           91,  379,  380,  381,  382,   -1,  384,  385,  386,  387, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   63,  280,  281,  282,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,    0,   -1,  333,  334,  335,  336, 
          337,   -1,  339,  340,   10,  342,  343,  344,  345,  346, 
          347,  348,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,  362,  363,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   44,  376, 
          377,   -1,  379,  380,  381,  382,   -1,  384,  385,  386, 
          387,   -1,   -1,   59,   -1,   -1,   -1,   63,  306,   -1, 
          308,  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          328,   -1,   -1,   -1,   -1,   91,   -1,   -1,  336,   -1, 
           -1,   -1,  340,  341,   -1,   -1,   -1,   -1,  279,  280, 
          348,  349,  350,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,  386,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1, 
           -1,   -1,   -1,   -1,  335,  336,   -1,   -1,   -1,   -1, 
          341,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,   -1,  297,   -1,   -1,   -1, 
           -1,  362,   -1,   -1,   59,   -1,   -1,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
           -1,   -1,  333,  334,   -1,   -1,   91,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,  349,   -1, 
          351,   -1,  353,  354,  355,  356,  357,  358,  359,   -1, 
          361,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,  267,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   59,  280,  281,  282,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   44,   -1,  333,  334,  335, 
          336,  337,   -1,  339,  340,   -1,  342,  343,  344,  345, 
          346,  347,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,  363,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   91,  379,  380,  381,  382,   -1,  384,  385, 
          386,  387,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,  267,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   63,   -1,  281,  282,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,    0,   -1,  333,  334, 
          335,  336,  337,   -1,  339,  340,   10,  342,  343,  344, 
          345,  346,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,   -1,  363,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,   -1,  374, 
           44,  376,  377,   -1,  379,  380,  381,  382,   -1,  384, 
          385,  386,  387,   -1,   -1,   59,   -1,   61,   -1,   63, 
          306,   -1,  308,  309,  310,  311,  312,   -1,   -1,   -1, 
           -1,  317,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  328,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
          336,   -1,   -1,   -1,  340,  341,   -1,   -1,   -1,   -1, 
          279,  280,  348,  349,  350,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
          386,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328, 
           -1,   -1,   -1,   -1,   -1,   -1,  335,  336,   -1,   -1, 
           -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  362,   -1,   -1,   59,   -1,   61,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   10,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   -1,   -1,  333,  334,   -1,   -1,   91,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          349,   44,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   -1,  361,   -1,   -1,   -1,   -1,   10,   61,   -1, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,   -1,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,   -1,   91,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   10,  299,   59,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,  337,  338,   -1,  340,  341,  342,  343, 
          344,   -1,  346,   59,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,  363, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
          384,  385,  386,  387,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,   -1,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   -1,  280,  749,   -1, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,  337,  338,  279,  340,  341,  342, 
          343,  344,   -1,  346,   -1,  348,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  362, 
          363,   -1,  365,  366,  367,  368,  369,  370,  839,   -1, 
            0,  374,   -1,  376,  377,  846,  379,  380,  381,  382, 
           10,  384,  385,  386,  387,  328,   -1,   -1,   -1,   -1, 
           -1,   -1,  335,  336,   -1,   -1,   -1,   -1,   -1,  342, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  306,   44,  308,  309,  310,  311,  312, 
           -1,   -1,   -1,   -1,  317,   -1,   -1,   -1,   -1,   59, 
           -1,   61,   -1,   63,   -1,  328,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,   -1,  340,  341,   -1, 
           -1,   -1,   -1,   -1,   -1,  348,  349,  350,  351,   -1, 
          306,   91,  308,  309,  310,  311,  312,   -1,   -1,  940, 
           -1,  317,   -1,   -1,   -1,   -1,  947,   -1,   -1,   -1, 
           -1,   -1,  328,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  386,  340,  341,   -1,   -1,   -1,   -1, 
           -1,    0,  348,  349,  350,  351,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1, 1003,   -1, 1005,   -1, 1007,   -1,   -1,   -1, 
          386,   -1,   -1,   -1,   -1,   44,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           59,   -1,   61,   -1,   63,   61,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 1049,   -1, 
         1051,   -1,   -1, 1054,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   91,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1, 1074,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1, 1088,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,   -1,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   -1, 
          280,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,   -1,  299, 
           44,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,  337,   -1,   -1, 
          340,  341,  342,  343,  344,   -1,  346,   91,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  362,  363,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,  384,  385,  386,  387,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,   -1,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           -1,  280,   -1, 
      };
   }

   private static final short[] yyCheck2() {
      return new short[] {

          279,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   -1,  299,   44,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,  328, 
           -1,  333,  334,  335,  336,  337,  335,  336,  340,  341, 
          342,  343,  344,  342,  346,   91,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,  363,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,    0,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   10,  384,  385,  386,  387,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  279,  280,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           59,   -1,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  328,   -1,   -1,   -1,   -1,   -1,   -1,  335,  336, 
           -1,   -1,   91,   -1,  341,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  279,  280,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   59,   -1,   61,   -1,   63,   61,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  328,   -1,   -1,   -1,   -1,   -1,   -1,  335, 
          336,   -1,   -1,   91,   -1,  341,   91,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,   -1,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           -1,  280,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,  336,  337,   -1, 
           -1,  340,  341,  342,  343,  344,   -1,  346,   -1,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  362,  363,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,    0,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   10,  384,  385,  386,  387,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,   -1, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,  279,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
           -1,  299,   -1,   59,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,  328,   -1,  333,  334,  335,  336,  337, 
          335,  336,  340,  341,  342,  343,  344,  342,  346,   -1, 
          348,  349,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,   -1,  363,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,    0,  374,   -1,  376,  377, 
           -1,  379,  380,  381,  382,   10,  384,  385,  386,  387, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   58,   59,   -1,   61,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   61,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
           -1,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,  267,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   44,  280,  281,   -1,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,  328,   -1,   -1,   -1,   -1,   -1,   -1,  335, 
          336,  337,   -1,   -1,  340,   -1,  342,  343,  344,   -1, 
          346,    0,  348,   -1,  350,   -1,  352,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,  360,   -1,  362,  363,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,  384,  385, 
          386,  387,   -1,   -1,   -1,   44,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   58, 
           59,   -1,   -1,   -1,   63,  280,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   91,   -1,   -1,   -1,  279,  280,   -1,   -1, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,   -1,    0,  339,   -1,   -1,  342,   -1,   -1, 
          345,   -1,  347,   10,  349,   -1,  351,   -1,  353,  354, 
          355,  356,  357,  358,  359,  328,  361,  362,  363,   -1, 
           -1,   -1,  335,  336,   -1,   -1,   -1,   -1,  341,  342, 
          375,   -1,   -1,   -1,   -1,   -1,   -1,   44,  279,  280, 
           -1,   -1,  387,   -1,   -1,   -1,   -1,   -1,   -1,  362, 
           -1,   58,   59,   -1,   61,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,   -1,   -1,  328,   10,   -1, 
           -1,   -1,   -1,   -1,  335,  336,   -1,   10,   -1,   -1, 
          341,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,  262,  263,  264,   -1,   59,  267,  268, 
          269,   -1,  271,   -1,   -1,   44,   -1,   -1,   61,   -1, 
           -1,  280,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           59,  290,  291,   -1,  293,  294,  295,  296,  297,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,    0,   91,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,  336,   -1,   -1, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
          349,   44,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   -1,  361,  362,  363,   58,   59,   -1,   61,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,  387,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   91,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,  338,  339,   -1,   -1,  342,   -1,   -1,  345,   -1, 
          347,   -1,  349,   44,  351,  267,  353,  354,  355,  356, 
          357,  358,  359,   -1,  361,   -1,  363,   58,   59,   -1, 
           61,   -1,   63,  262,  263,  264,  279,  280,  375,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          387,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,  290,  291,   -1,  293,  294,  295,  296,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,  328,    0,   -1,   -1, 
           -1,   -1,   -1,  335,  336,  328,   -1,   10,   -1,   -1, 
           -1,   -1,  335,  336,   -1,   -1,   -1,   -1,  341,  342, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,  262, 
          263,  264,   -1,  342,  267,  268,  269,   -1,  271,  362, 
           -1,   -1,   -1,   -1,   61,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,  363,   -1,   59,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,    0,   91,   -1,   -1,   -1,  387,   -1, 
           -1,   -1,   -1,   10,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,   -1,  338,  339,   -1,   -1,  342, 
           -1,   -1,  345,   -1,  347,   -1,  349,   44,  351,   -1, 
          353,  354,  355,  356,  357,  358,  359,   -1,  361,   -1, 
          363,   58,   59,   -1,   61,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,  387,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,   -1,  338,  339,   -1, 
           -1,  342,   -1,   -1,  345,   -1,  347,   -1,  349,   44, 
          351,   -1,  353,  354,  355,  356,  357,  358,  359,   -1, 
          361,   -1,  363,   58,   59,   -1,   61,   -1,   63,  262, 
          263,  264,  279,  280,  375,  268,  269,   -1,  271,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,  387,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   44,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,  328,   44,   -1,   -1,   -1,   -1,   -1,  335,  336, 
           61,   -1,   -1,   -1,  341,  342,   -1,   -1,   -1,   61, 
           -1,   -1,   -1,   -1,   44,  262,  263,  264,   -1,  342, 
          267,  268,  269,   -1,  271,  362,   -1,   -1,   -1,   -1, 
           91,   61,   -1,   59,  281,  282,   -1,   -1,   -1,   91, 
          363,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,    0, 
           -1,   91,   -1,   -1,  387,   91,   -1,   -1,   -1,   10, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,  338,  339,   -1,   -1,  342,   -1,   -1,  345,   -1, 
          347,   -1,  349,   44,  351,   -1,  353,  354,  355,  356, 
          357,  358,  359,   -1,  361,   -1,  363,   58,   59,   -1, 
           61,   -1,   63,   -1,   -1,   -1,   -1,   -1,  375,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
          387,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           91,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,   -1,  338,  339,   -1,   -1,  342,  279,   -1, 
          345,   -1,  347,   -1,  349,   44,  351,  279,  353,  354, 
          355,  356,  357,  358,  359,   -1,  361,   -1,  363,   58, 
           59,  267,   61,   -1,   63,   -1,   -1,   -1,   -1,  279, 
          375,   -1,   -1,   -1,  280,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  387,   -1,   10,   -1,   -1,  328,   -1,   -1, 
           10,   -1,   91,   -1,  335,  336,  328,   -1,   -1,   -1, 
           10,  342,   10,  335,  336,   -1,   -1,   -1,   -1,   -1, 
          342,   10,   -1,   -1,   -1,   -1,   -1,   -1,  328,   -1, 
           -1,   -1,  328,   -1,   -1,  335,  336,   -1,   -1,  335, 
          336,   -1,  342,   59,   44,  341,   44,   -1,   -1,   59, 
           -1,  262,  263,  264,   10,   44,  267,  268,  269,   -1, 
          271,   61,   -1,   61,   -1,   -1,  362,   -1,   -1,   -1, 
          281,  282,   61,   -1,   -1,   91,   -1,   -1,   -1,  290, 
          291,   91,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   91,   -1,   91,  305,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   91,   59,   -1,   10,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,   -1,  338,  339,   -1, 
           -1,  342,   -1,   -1,  345,   91,  347,   -1,  349,   44, 
          351,   -1,  353,  354,  355,  356,  357,  358,  359,   -1, 
          361,   -1,  363,   58,   59,   -1,   61,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,  387,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   91,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,  336,   -1,  338, 
          339,  267,   -1,  342,   -1,   -1,  345,  267,  347,   10, 
          349,   44,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   -1,  361,   -1,  363,   58,   59,   -1,   61,  279, 
           63,  279,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1, 
          279,   -1,   10,   44,   -1,   -1,   -1,   -1,  387,   -1, 
           -1,   10,   -1,   10,   -1,   -1,   -1,   -1,   91,   -1, 
           61,  267,  328,   -1,   -1,   -1,   -1,   -1,  328,  335, 
          336,   -1,   -1,   -1,   -1,  335,  336,   -1,  328,   -1, 
          328,   -1,   -1,   -1,   -1,  335,  336,  335,  336,  328, 
           91,   59,  342,   -1,  342,   -1,  335,  336,   -1,   -1, 
           59,   -1,   59,  342,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,  328,   91,   -1,   -1,  281,  282,   -1,  335, 
          336,   -1,   91,   -1,   91,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,   -1,  338,  339,   -1,   -1,  342,   -1,   -1, 
          345,   -1,  347,   -1,  349,   44,  351,   -1,  353,  354, 
          355,  356,  357,  358,  359,   -1,  361,   -1,  363,   58, 
           59,   -1,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1, 
          375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,  387,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,    0,   -1,   -1,   -1,   -1,  279,   -1, 
           -1,   -1,   -1,   10,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,  267, 
          333,  334,  335,  336,   -1,  338,  339,   -1,  267,  342, 
          267,   -1,  345,   -1,  347,   -1,  349,   44,  351,   -1, 
          353,  354,  355,  356,  357,  358,  359,  328,  361,   -1, 
          363,   58,   59,   -1,  335,  336,   63,   -1,   -1,   -1, 
           -1,  342,  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  387,   -1,   -1,   -1,   -1,   -1, 
          328,   -1,   -1,   -1,   91,   -1,   -1,  335,  336,  328, 
           -1,  328,   -1,   -1,   -1,   -1,  335,  336,  335,  336, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,  336,   -1,  338, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
          349,   44,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   -1,  361,   -1,  363,   58,   59,   -1,   61,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,  387,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   91,   -1, 
           -1,   -1,   -1,  280,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1, 
          347,   -1,  349,   44,  351,   -1,  353,  354,  355,  356, 
          357,  358,  359,   -1,  361,  362,  363,   58,   59,   -1, 
           61,   -1,   63,   -1,   -1,   -1,   -1,   -1,  375,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          387,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,   -1,   -1,  339,   -1,   -1,  342, 
           -1,   -1,  345,   -1,  347,   -1,  349,   44,  351,   -1, 
          353,  354,  355,  356,  357,  358,  359,   -1,  361,   -1, 
          363,   58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,  387,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,   -1,   -1,  339,   -1, 
           -1,  342,   -1,   -1,  345,   -1,  347,   -1,  349,   44, 
          351,   -1,  353,  354,  355,  356,  357,  358,  359,   -1, 
          361,   -1,  363,   58,   59,   -1,   -1,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  387,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1, 
          347,   -1,  349,   44,  351,   -1,  353,  354,  355,  356, 
          357,  358,  359,   -1,  361,   -1,  363,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,  375,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
          387,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           91,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1, 
          345,   -1,  347,   -1,  349,   44,  351,   -1,  353,  354, 
          355,  356,  357,  358,  359,   -1,  361,   -1,  363,   58, 
           59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1, 
          375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  387,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,   -1,   -1,  339,   -1, 
           -1,  342,   -1,   -1,  345,   -1,  347,   -1,  349,   44, 
          351,   -1,  353,  354,  355,  356,  357,  358,  359,   -1, 
          361,   -1,  363,   58,   59,   -1,   -1,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,  387,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   91,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,  336,   -1,   -1, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
          349,   44,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   -1,  361,   -1,  363,   -1,   59,   -1,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  387,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   44,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           59,   -1,   -1,   -1,   63,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   91,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,   -1,    0,  339,   -1,   -1,  342,   -1,   -1, 
          345,   -1,  347,   10,  349,   -1,  351,   -1,  353,  354, 
          355,  356,  357,  358,  359,   -1,  361,   -1,  363,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          375,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,  262, 
          263,  264,  387,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   59,   -1,   -1,   -1,   63,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,   -1,   -1,  339,   -1,   -1,  342, 
           -1,   -1,  345,   -1,  347,   -1,  349,   -1,  351,    0, 
          353,  354,  355,  356,  357,  358,  359,   -1,  361,   10, 
          363,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,  387,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   44,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,  336,   -1,   -1, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
          349,   -1,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   -1,  361,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,  387,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1, 
          347,   -1,  349,   44,  351,   -1,  353,  354,  355,  356, 
          357,  358,  359,   -1,  361,   -1,  363,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          387,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   10,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
           58,   59,  333,  334,   -1,   63,   -1,   -1,  339,   -1, 
           -1,  342,   -1,   -1,  345,   -1,  347,   -1,  349,   -1, 
          351,   -1,  353,  354,  355,  356,  357,  358,  359,   -1, 
          361,   -1,  363,   -1,  306,  307,   -1,   -1,  310,   -1, 
           -1,   -1,  314,  315,  375,  317,  318,  319,  320,  321, 
          322,  323,   -1,   -1,  326,  327,  387,   -1,   -1,  331, 
          332,  333,  334,   -1,   -1,   -1,   -1,   -1,    0,  341, 
           -1,   -1,   -1,   -1,   -1,   -1,  348,  349,   10,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
           -1,   -1,  364,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   44,   -1,  386,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   58,   59,   -1,  290, 
          291,   63,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
           -1,   -1,  333,  334,   -1,   -1,   -1,   -1,  339,   -1, 
           -1,  342,   -1,   -1,  345,   -1,  347,   -1,  349,   -1, 
          351,   -1,  353,  354,  355,  356,  357,  358,  359,   -1, 
          361,   -1,  363,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,  375,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   10,  387,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   58,   59,  333,  334,   -1,   63,   -1, 
           -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347, 
           -1,  349,   -1,  351,   -1,  353,  354,  355,  356,  357, 
          358,  359,   -1,  361,   -1,  363,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,  387, 
          262,  263,  264,   -1,   10,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   59,   10,   -1,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   -1, 
           -1,  333,  334,   -1,   -1,   -1,   -1,  339,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,   -1,  349,   44,  351, 
           -1,  353,  354,  355,  356,  357,  358,  359,   -1,  361, 
           -1,  363,   -1,   59,   -1,   61,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  387,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   -1,  329,  330,   -1,   -1,  333,  334, 
           -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1, 
          345,   -1,  347,   -1,  349,   44,  351,   -1,  353,  354, 
          355,  356,  357,  358,  359,   -1,  361,   -1,  363,   -1, 
           59,   -1,   61,   -1,   63,   -1,  262,  263,  264,   -1, 
          375,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,  387,   -1,   -1,  281,   -1,   -1,   -1,   -1, 
           -1,   -1,   91,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,  262,  263,  264,   -1, 
           -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,  328,   -1,  280,   -1,   -1,   -1,   -1,  335, 
          336,   -1,   -1,   -1,  290,  291,  342,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   59,   -1,   -1,  363,   -1,   -1, 
           10,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,  387,   -1,   -1,   -1,   -1,  342,   -1,   -1,   -1, 
           -1,   -1,   -1,  349,   44,  351,   -1,  353,  354,  355, 
          356,  357,  358,  359,   -1,  361,  362,  363,   -1,   59, 
           -1,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  387,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,   -1,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,  336,   -1,  338, 
           -1,   -1,   -1,  342,   -1,   -1,   44,   -1,   -1,   -1, 
          349,   -1,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   59,  361,   61,  363,   63,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,   -1,  387,   -1, 
           -1,   -1,   -1,   91,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,   -1,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  342,   -1,   -1, 
          290,  291,   44,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,  363,   61, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,  387,  333,  334,  335,  336,   -1,  338,   91, 
           -1,   -1,  342,   -1,   -1,   -1,   -1,   -1,   -1,  349, 
           -1,  351,   -1,  353,  354,  355,  356,  357,  358,  359, 
           -1,  361,   -1,  363,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  387,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,   44, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   59,   -1,   61,   -1,   63,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
          338,   -1,   -1,   -1,  342,   -1,   -1,   -1,   -1,   -1, 
           -1,  349,   -1,  351,   -1,  353,  354,  355,  356,  357, 
          358,  359,   -1,  361,   -1,  363,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,   -1,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  387, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   -1,  338,   -1,   -1,   -1, 
          342,   -1,   -1,   44,   -1,   -1,   -1,  349,   -1,  351, 
           -1,  353,  354,  355,  356,  357,  358,  359,   59,  361, 
           61,  363,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,   -1,  268,  269,  387,  271,   -1,   -1,   -1, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,   -1,  338,   -1,   -1,   -1,  342,   -1,   -1, 
           44,   -1,   -1,   -1,  349,   -1,  351,   -1,  353,  354, 
          355,  356,  357,  358,  359,   59,  361,   61,  363,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  387,   10,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,   -1,   61,   -1,   63,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,   -1,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,   -1,  338,   -1,   -1, 
           -1,  342,   -1,   -1,   44,   -1,   -1,   -1,  349,   -1, 
          351,   -1,  353,  354,  355,  356,  357,  358,  359,   59, 
          361,   61,  363,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,   -1,  268,  269,  387,  271,   -1,   -1, 
           -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326, 
      };
   }

   private static final short[] yyCheck3() {
      return new short[] {

          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,  338,  262,  263,  264,  342,   -1,   -1,  268,  269, 
           -1,  271,  349,   -1,  351,   -1,  353,  354,  355,  356, 
          357,  358,  359,   -1,  361,   -1,  363,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          387,   10,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,  338,   -1, 
           -1,   -1,  342,   -1,   -1,   44,   -1,   -1,   -1,  349, 
           -1,  351,   -1,  353,  354,  355,  356,  357,  358,  359, 
           59,  361,   61,  363,   63,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  387,   -1,   -1, 
           -1,   -1,   91,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,   -1,  338,   -1,   -1,   -1,  342, 
           -1,   -1,   44,   -1,   -1,   -1,  349,   -1,  351,   -1, 
          353,  354,  355,  356,  357,  358,  359,   59,  361,   61, 
          363,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,  387,   -1,   -1,   -1,   -1,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,   -1,   61,   -1,   63,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,   -1,  268, 
          269,   -1,  271,   -1,   91,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,  336,   -1,  338, 
           -1,   -1,   -1,  342,   -1,   -1,   -1,   -1,   -1,   -1, 
          349,    0,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   10,  361,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,   -1,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  387,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   58, 
           59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,  262,  263,  264,   -1,   -1, 
          342,  268,  269,   -1,  271,   -1,   -1,  349,   -1,  351, 
           -1,  353,  354,  355,  356,  357,  358,  359,   -1,  361, 
           -1,  363,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,  387,   -1,   -1,   -1,   10, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,   -1,   -1,   -1,   -1,  342,   -1,   -1,   -1,   -1, 
           -1,   -1,  349,   44,  351,   -1,  353,  354,  355,  356, 
          357,  358,  359,   -1,  361,   -1,  363,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
          387,   -1,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  349,   -1, 
          351,    0,  353,  354,  355,  356,  357,  358,  359,   -1, 
          361,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   58, 
           59,   -1,   -1,   -1,   63,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   -1,   -1,  333,  334,   -1,   -1,   -1,   -1, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
           -1,   -1,  351,   -1,   -1,    0,  355,  356,  357,  358, 
          359,   -1,  361,   -1,  363,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  387,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   58,   59,   -1,   -1,   -1,   63,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
           -1,   -1,  333,  334,   -1,   -1,   -1,   -1,  339,   -1, 
           -1,  342,   -1,   -1,  345,   -1,  347,   -1,   -1,    0, 
          351,   -1,   -1,   -1,  355,  356,  357,  358,  359,   10, 
          361,   -1,  363,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,  375,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,  387,   -1,   -1,   -1, 
           -1,  290,  291,   44,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   -1,   -1,  333,  334,   -1,   -1,   -1,   -1, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
           -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,  357,  358, 
          359,   -1,  361,    0,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,  375,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,  387,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   44,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   -1,  329,  330,   -1,   -1,  333,  334, 
           -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1, 
          345,   -1,  347,   -1,   -1,    0,  351,   -1,   -1,   -1, 
           -1,   -1,  357,  358,  359,   10,  361,   -1,  363,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  387,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   58,   59,   -1,   -1,   -1,   63,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,   -1, 
           -1,  342,   -1,   -1,  345,   -1,  347,   -1,   -1,   -1, 
          351,   -1,   -1,    0,   -1,   -1,  357,  358,  359,   -1, 
          361,   -1,  363,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  375,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,  387,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   58,   59,   -1,   -1,   -1,   63,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1, 
          347,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
          357,  358,  359,   10,  361,   -1,  363,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,  375,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
          387,   -1,   -1,   -1,   -1,  290,  291,   44,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   -1,  329,  330,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1, 
          345,   -1,  347,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  357,  358,  359,   -1,  361,   -1,  363,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          375,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  387,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   58,   59,   -1,   -1,   -1,   63,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1, 
          347,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
          357,  358,   -1,   10,   -1,   -1,  363,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,  375,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
          387,   -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   58,   59,   -1,   -1,   -1,   63,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1, 
          347,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          357,  358,   -1,   -1,   -1,   -1,  363,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,  375,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
          387,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   58,   59,   -1,   -1,   -1,   63,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1, 
          347,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
          357,  358,   -1,   10,   -1,   -1,  363,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,  375,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
          387,   -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   58,   59,   -1,   -1,   -1,   63,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1, 
          347,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          357,  358,   -1,   -1,   -1,   -1,  363,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,  375,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
          387,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   58,   59,   -1,   -1,   -1,   63,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  324,  325,    0, 
           -1,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1, 
          347,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  363,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,  262,  263,  264,  375,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   58,   59,   -1, 
          387,   -1,   63,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,    0,   -1,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  324,  325,   -1, 
           -1,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345,   44, 
          347,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   58,   59,   -1,  363,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  375,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          387,   -1,   -1,    0,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   10,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   44,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   63,  324,  325,   -1, 
           -1,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345,    0, 
          347,  262,  263,  264,   -1,   -1,  267,  268,  269,   10, 
          271,   -1,   -1,   -1,   -1,   -1,  363,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,  375,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
          387,   -1,   -1,   44,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   63,  324,  325,   -1,   -1,   -1,  329,  330, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,   -1, 
           -1,  342,   -1,   -1,  345,    0,  347,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   10,  271,   -1,   -1,   -1, 
           -1,   -1,  363,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,  375,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,  387,   -1,   -1,   44, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   63,  324, 
          325,   -1,   -1,   -1,  329,  330,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1, 
          345,   -1,  347,    0,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   10,  271,   -1,   -1,   -1,  363,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
          375,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,  387,   -1,   -1,   -1,   -1,   44,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   63,  324,  325,   -1, 
           -1,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345,    0, 
          347,  262,  263,  264,   -1,   -1,  267,  268,  269,   10, 
          271,   -1,   -1,   -1,   -1,   -1,  363,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,  375,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
          387,   -1,   -1,   44,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   63,  324,  325,   -1,   -1,   -1,  329,  330, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,   -1, 
           -1,  342,   -1,   -1,  345,    0,  347,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   10,  271,   -1,   -1,   -1, 
           -1,   -1,  363,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,  375,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,  387,   -1,   -1,   44, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   -1,   -1, 
          325,   -1,   -1,   -1,  329,  330,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1, 
          345,   -1,  347,    0,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   10,  271,   -1,   -1,   -1,  363,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
          375,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,  387,   -1,   -1,   -1,   -1,   44,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345,    0, 
          347,  262,  263,  264,   -1,   -1,  267,  268,  269,   10, 
          271,   -1,   -1,   -1,   -1,   -1,  363,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,  375,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
          387,   -1,   -1,   44,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,   -1, 
           -1,  342,   -1,   -1,  345,    0,  347,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   10,  271,   -1,   -1,   -1, 
           -1,   -1,  363,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,  375,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,  387,   -1,   -1,   44, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1, 
          345,   -1,  347,    0,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   10,  271,   -1,   -1,   -1,  363,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
          375,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,  387,   -1,   -1,   -1,   -1,   44,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345,    0, 
          347,  262,  263,  264,   -1,   -1,  267,  268,  269,   10, 
          271,   -1,   -1,   -1,   -1,   -1,  363,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,  375,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
          387,   -1,   -1,   44,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,   -1, 
           -1,  342,   -1,   -1,  345,    0,  347,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   10,  271,   -1,   -1,   -1, 
           -1,   -1,  363,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,  375,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,  387,   -1,   -1,   44, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1, 
          345,   -1,  347,    0,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   10,  271,   -1,   -1,   -1,  363,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
          375,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,  387,   -1,   -1,   -1,   -1,   44,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345,    0, 
          347,  262,  263,  264,   -1,   -1,  267,  268,  269,   10, 
          271,   -1,   -1,   -1,   -1,   -1,  363,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,  375,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
          387,   -1,   -1,   44,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,   -1, 
           -1,  342,   -1,   -1,  345,    0,  347,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   10,  271,   -1,   -1,   -1, 
           -1,   -1,  363,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,  375,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,  387,   -1,   -1,   44, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1, 
          345,   -1,  347,    0,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   10,  271,   -1,   -1,   -1,  363,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
          375,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,  387,   -1,   -1,   -1,   -1,   44,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345,    0, 
          347,  262,  263,  264,   -1,   -1,  267,  268,  269,   10, 
          271,   -1,   -1,   -1,   -1,   -1,  363,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,  375,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
          387,   -1,   -1,   44,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,   -1, 
           -1,  342,   -1,   -1,  345,    0,  347,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   10,  271,   -1,   -1,   -1, 
           -1,   -1,  363,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,  375,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,  387,   -1,   -1,   44, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1, 
          345,   -1,  347,    0,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   10,  271,   -1,   -1,   -1,  363,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
          375,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,  387,    0,   -1,   -1,   -1,   44,  305,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1, 
          347,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   59,   -1,   -1,    0,  363,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   10,   -1,   -1,  375,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
          387,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   59,   -1,   -1,   -1,  339,   -1, 
           -1,  342,   -1,   -1,  345,   -1,  347,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,  363,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           59,   -1,   -1,   -1,  375,  290,  291,   -1,  293,  294, 
          295,  296,   -1,   -1,   -1,   -1,  387,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1, 
          345,   -1,  347,    0,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   10,  271,   -1,   -1,   -1,  363,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   59,   -1,   -1,   -1, 
          375,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
           -1,   -1,  387,    0,   -1,  262,  263,  264,  305,   -1, 
          267,  268,  269,   10,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1, 
          347,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,   -1,   -1,   -1,  363,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,  375,   -1, 
           -1,   -1,   -1,   -1,    0,  342,  281,  282,  345,   -1, 
          387,   -1,   -1,   -1,   10,  290,  291,   -1,  293,  294, 
          295,  296,  297,  262,  263,  264,  363,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   44,   -1, 
          387,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           10,   -1,   -1,   59,   -1,   -1,   -1,  342,   -1,   -1, 
          345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  363,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  342,   -1,   -1,  345,   -1,   -1,  262, 
          263,  264,  387,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,  363,   -1,   -1,   -1,  281,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,  262,  263,  264,  387,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,  342, 
          267,  268,  269,   10,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,   -1,   -1,   -1,   -1,   -1, 
          363,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,  342,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  387,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,   -1,   -1,   -1,  363,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  342,  262,  263,  264,   -1, 
          387,  267,  268,  269,   91,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  363,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,  257,  258,  259, 
          387,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           10,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,  339,   -1,   -1,  342,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  363,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1, 
          340,  387,   -1,  343,  344,   -1,  346,   -1,  348,   -1, 
          350,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          360,   91,   -1,   -1,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,  384,  385,  386,   -1,   -1,  256, 
          257,  258,  259,  260,  261,  262,  263,  264,  265,  266, 
           -1,   -1,  269,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,  280,   -1,   10,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,  298,  299,   -1,  301,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  328,   -1,   -1,   59,   -1,   -1,   -1,  335,  336, 
          337,   -1,   -1,  340,  341,   -1,  343,  344,   -1,  346, 
           -1,  348,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1, 
          357,   -1,   -1,  360,   -1,  362,   91,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,  384,  385,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  256,  257,  258,  259, 
          260,  261,  262,  263,  264,  265,  266,   -1,   -1,  269, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
          280,   -1,   10,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299, 
           -1,  301,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328,   -1, 
           -1,   59,   -1,   -1,   -1,  335,  336,  337,   -1,   -1, 
          340,  341,   -1,  343,  344,   -1,  346,   -1,  348,   -1, 
           -1,   -1,  352,   -1,   -1,   -1,   -1,  357,   -1,   -1, 
          360,   -1,  362,   91,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,  384,  385,   -1,   -1,   -1,   -1, 
           -1,  256,  257,  258,  259,  260,  261,  262,  263,  264, 
          265,  266,   -1,   -1,  269,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,  280,   -1,   10,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,  298,  299,   -1,  301,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  328,   -1,   -1,   59,   -1,   -1,   -1, 
          335,  336,  337,   -1,   -1,  340,  341,   -1,  343,  344, 
           -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1,   -1, 
           -1,   -1,  357,   -1,   -1,  360,   -1,  362,   91,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,   -1,  374, 
           -1,  376,  377,   -1,  379,  380,  381,  382,   -1,  384, 
          385,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,  257, 
          258,  259,  260,  261,  262,  263,  264,  265,  266,   -1, 
           -1,  269,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   10,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,   -1,  301,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          328,   59,   -1,   -1,   -1,   -1,   -1,  335,  336,  337, 
           -1,   -1,  340,  341,   -1,  343,  344,   -1,  346,   -1, 
          348,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,  357, 
           -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,   -1,  374,   -1,  376,  377, 
           -1,  379,  380,  381,  382,   -1,  384,  385,   -1,   -1, 
           -1,   -1,   -1,  256,  257,  258,  259,  260,  261,  262, 
          263,  264,  265,  266,   -1,   -1,  269,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   10,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  328,   59,   -1,   -1,   -1, 
           -1,   -1,  335,  336,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,  357,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,  384,  385,   -1,   -1,   -1,   -1,   -1,  256,  257, 
          258,  259,  260,  261,  262,  263,  264,  265,  266,   -1, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   10,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,   -1,  301,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337, 
           -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1, 
          348,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,   -1,  374,   -1,  376,  377, 
           -1,  379,  380,  381,  382,   -1,  384,  385,   -1,   -1, 
           -1,   -1,   -1,  256,  257,  258,  259,  260,  261,  262, 
          263,  264,  265,  266,   -1,   -1,  269,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   10,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,  362, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,  384,  385,   -1,   -1,   -1,   -1,  256,  257,  258, 
          259,  260,  261,  262,  263,  264,  265,  266,   -1,   -1, 
          269,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           10,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298, 
          299,   -1,  301,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1, 
           -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1,  348, 
           -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   -1,  384,  385,   -1,   -1,   -1, 
           -1,   -1,  256,  257,  258,  259,  260,  261,   -1,   -1, 
          264,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   10,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   59,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
          384,  385,   -1,   -1,   -1,   -1,  256,  257,  258,  259, 
          260,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   10, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299, 
           -1,  301,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1, 
          340,   -1,   -1,  343,  344,   -1,  346,   -1,  348,   -1, 
           -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          360,   -1,   -1,  363,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,  384,  385,   -1,   -1,   -1,   -1, 
           -1,   -1,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   10,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344, 
           -1,  346,   -1, 
      };
   }

   private static final short[] yyCheck4() {
      return new short[] {

           -1,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,   -1,  374,   -1,  376,  377, 
           -1,  379,  380,  381,  382,   -1,  384,  385,   -1,   -1, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   44,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   -1,  340,   -1,  342,  343, 
          344,   -1,  346,   -1,   -1,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
          384,  385,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   44,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1, 
           -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1,   -1, 
           -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   -1,  384,  385,   -1,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,   -1,   -1, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1, 
          346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,  384,  385, 
           -1,   -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,   -1,   -1,  316,   59,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340, 
           -1,   -1,  343,  344,   -1,  346,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  365,  366,  367,  368,  369,  370, 
           -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379,  380, 
          381,  382,   -1,  384,  385,  257,  258,  259,  260,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,  298,  299,  300,  301, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1, 
           -1,  343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1, 
          352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1, 
           -1,   -1,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   -1,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   -1,  384,  385,  257,  258,  259,  260,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,  384,  385,  257,  258,  259,  260,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,  279,  280,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,   -1, 
           -1,   -1,   -1,  297,  298,  299,  300,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1, 
           -1,   -1,   -1,   -1,  348,  349,   -1,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,   -1,   -1, 
          364,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  386,  257,  258,  259,  260,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,  279,  280,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,   -1, 
           -1,   -1,   -1,  297,  298,  299,  300,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  348,  349,   -1,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,   -1,   -1, 
          364,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  386,  257,  258,  259,  260,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,  279,  280,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,   -1, 
           -1,   -1,   -1,  297,  298,  299,  300,  301,  302,  303, 
          304,   -1,  306,  307,  308,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  348,  349,   -1,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,   -1,   -1, 
          364,  365,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  386,  257,  258,  259,  260,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,  279,  280,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,   -1, 
           -1,   -1,   -1,  297,  298,  299,  300,  301,  302,  303, 
          304,   -1,  306,  307,   -1,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  348,  349,   -1,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,   -1,   -1, 
          364,  365,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  386,  257,  258,  259,  260,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,  279,  280,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,   -1, 
           -1,   -1,   -1,  297,  298,  299,  300,  301,  302,  303, 
          304,   -1,  306,  307,   -1,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  348,  349,   -1,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,   -1,   -1, 
          364,   -1,   -1,   -1,   -1,   -1,   -1,  256,  257,  258, 
          259,  260,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,  386,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298, 
          299,  300,  301,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1, 
           -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1,  348, 
           -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   -1,  384,  385,  256,  257,  258, 
          259,  260,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298, 
          299,   -1,  301,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1, 
           -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1,  348, 
           -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   -1,  384,  385,  256,  257,  258, 
          259,  260,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298, 
          299,   -1,  301,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1, 
           -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1,  348, 
           -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   -1,  384,  385,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1, 
          340,   -1,   -1,  343,  344,   -1,  346,   -1,  348,   -1, 
          350,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          360,   -1,   -1,   -1,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,  384,  385,  386,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1, 
          340,   -1,   -1,  343,  344,   -1,  346,   -1,  348,   -1, 
          350,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          360,   -1,   -1,   -1,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,  384,  385,  386,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1, 
          340,   -1,   -1,  343,  344,   -1,  346,   -1,  348,   -1, 
          350,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          360,   -1,   -1,   -1,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,  384,  385,  386,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1, 
          340,   -1,   -1,  343,  344,   -1,  346,   -1,  348,   -1, 
           -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          360,   -1,   -1,   -1,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,  384,  385,  386,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1, 
          340,   -1,   -1,  343,  344,   -1,  346,   -1,   -1,   -1, 
          350,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          360,   -1,   -1,   -1,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,  384,  385,  386,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1, 
          340,   -1,   -1,  343,  344,   -1,  346,   -1,  348,   -1, 
           -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          360,   -1,   -1,   -1,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,  384,  385,  386,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1, 
          340,   -1,   -1,  343,  344,   -1,  346,   -1,   -1,   -1, 
           -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          360,   -1,   -1,   -1,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,  384,  385,  386,  257,  258,  259, 
          260,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299, 
          300,  301,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1, 
          340,   -1,   -1,  343,  344,   -1,  346,   -1,  348,   -1, 
           -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          360,   -1,   -1,   -1,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,  384,  385,  257,  258,  259,  260, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1, 
          301,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340, 
           -1,   -1,  343,  344,   -1,  346,   -1,  348,   -1,   -1, 
           -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360, 
           -1,   -1,   -1,   -1,  365,  366,  367,  368,  369,  370, 
           -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379,  380, 
          381,  382,   -1,  384,  385,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340,  341, 
           -1,  343,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1, 
          352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1, 
           -1,   -1,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   -1,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   -1,  384,  385,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,  384,  385,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
          384,  385,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344, 
           -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,   -1,  374, 
           -1,  376,  377,   -1,  379,  380,  381,  382,   -1,  384, 
          385,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1, 
          346,   -1,  348,   -1,   -1,   -1,  352,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,  384,  385, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346, 
           -1,  348,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,  384,  385,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337, 
           -1,   -1,  340,  341,   -1,  343,  344,   -1,  346,   -1, 
           -1,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,   -1,  374,   -1,  376,  377, 
           -1,  379,  380,  381,  382,   -1,  384,  385,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1, 
           -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1,   -1, 
           -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   -1,  384,  385,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1, 
          340,   -1,   -1,  343,  344,   -1,  346,   -1,   -1,   -1, 
           -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          360,   -1,   -1,   -1,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,  384,  385,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340, 
           -1,   -1,  343,  344,   -1,  346,   -1,   -1,   -1,   -1, 
           -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360, 
           -1,   -1,   -1,   -1,  365,  366,  367,  368,  369,  370, 
           -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379,  380, 
          381,  382,   -1,  384,  385,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1, 
           -1,  343,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1, 
          352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1, 
           -1,   -1,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   -1,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   -1,  384,  385,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          333,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,  384,  385,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
           -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
          384,  385,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,   -1, 
           -1,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344, 
           -1,  346,   -1,  348,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,   -1,  374, 
           -1,  376,  377,   -1,  379,  380,  381,  382,   -1,  384, 
          385,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,   -1,   -1, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1, 
          346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,  384,  385, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,   -1,   -1,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,  384,  385,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,   -1,   -1,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337, 
           -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,   -1,  374,   -1,  376,  377, 
           -1,  379,  380,  381,  382,   -1,  384,  385,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,   -1,   -1,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1, 
           -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   -1,  384,  385,  306,  307,   -1, 
           -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,   -1, 
           -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1, 
           -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348, 
          349,   -1,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  306,  307,  364,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,  321,  322, 
          323,   -1,   -1,  326,  327,   -1,   -1,  386,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1, 
           -1,   -1,   -1,   -1,   -1,  348,  349,   -1,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  306, 
          307,  364,   -1,  310,   -1,   -1,   -1,  314,  315,   -1, 
          317,  318,  319,  320,  321,  322,  323,   -1,   -1,  326, 
          327,   -1,   -1,  386,  331,  332,  333,  334,   -1,   -1, 
           -1,   -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1, 
           -1,  348,  349,   -1,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,  306,  307,  364,   -1,  310, 
           -1,   -1,   -1,  314,  315,   -1,  317,  318,  319,  320, 
          321,  322,  323,   -1,   -1,  326,  327,   -1,   -1,  386, 
          331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1, 
          341,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,   -1, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  306,  307,  364,   -1,  310,   -1,   -1,   -1,  314, 
          315,   -1,  317,  318,  319,  320,  321,  322,  323,   -1, 
           -1,  326,  327,   -1,   -1,  386,  331,  332,  333,  334, 
           -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,   -1, 
           -1,   -1,   -1,  348,  349,   -1,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  306,  307,  364, 
           -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,   -1, 
           -1,  386,  331,  332,  333,  334,   -1,   -1,   -1,   -1, 
           -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348, 
          349,   -1,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  306,  307,  364,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,  321,  322, 
          323,   -1,   -1,  326,  327,   -1,   -1,  386,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1, 
           -1,   -1,   -1,   -1,   -1,  348,  349,   -1,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  306, 
          307,  364,   -1,  310,   -1,   -1,   -1,  314,  315,   -1, 
          317,  318,  319,  320,  321,  322,  323,   -1,   -1,  326, 
          327,   -1,   -1,  386,  331,  332,  333,  334,   -1,   -1, 
           -1,   -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1, 
           -1,  348,  349,   -1,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,  306,  307,  364,   -1,  310, 
           -1,   -1,   -1,  314,  315,   -1,  317,  318,  319,  320, 
          321,  322,  323,   -1,   -1,  326,  327,   -1,   -1,  386, 
          331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1, 
          341,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,   -1, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  306,  307,  364,   -1,  310,   -1,   -1,   -1,  314, 
          315,   -1,  317,  318,  319,  320,  321,  322,  323,   -1, 
           -1,  326,  327,   -1,   -1,  386,  331,  332,  333,  334, 
           -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,   -1, 
           -1,   -1,   -1,  348,  349,   -1,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  306,  307,  364, 
           -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,   -1, 
           -1,  386,  331,  332,  333,  334,   -1,   -1,   -1,   -1, 
           -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348, 
          349,   -1,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  306,  307,  364,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,  321,  322, 
          323,   -1,   -1,  326,  327,   -1,   -1,  386,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  348,  349,   -1,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,   -1, 
           -1,  364,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  386, 
      };
   }

}
