// RUN: llvm-mc -arch=amdgcn -mcpu=gfx90a -show-encoding %s | FileCheck --check-prefix=GFX90A %s

image_load v[4:6], v[238:241], s[28:35] dmask:0x7 unorm
// GFX90A: image_load v[4:6], v[238:241], s[28:35] dmask:0x7 unorm ; encoding: [0x00,0x17,0x00,0xf0,0xee,0x04,0x07,0x00]

image_load_pck v5, v[0:3], s[8:15] dmask:0x1 glc
// GFX90A: image_load_pck v5, v[0:3], s[8:15] dmask:0x1 glc ; encoding: [0x00,0x21,0x08,0xf0,0x00,0x05,0x02,0x00]

image_load_pck_sgn v5, v[0:3], s[8:15] dmask:0x1 lwe
// GFX90A: image_load_pck_sgn v5, v[0:3], s[8:15] dmask:0x1 lwe ; encoding: [0x00,0x01,0x0e,0xf0,0x00,0x05,0x02,0x00]

image_load_mip v5, v[0:3], s[8:15]
// GFX90A: image_load_mip v5, v[0:3], s[8:15] ; encoding: [0x00,0x00,0x04,0xf0,0x00,0x05,0x02,0x00]

image_load_mip_pck v5, v1, s[8:15] dmask:0x1
// GFX90A: image_load_mip_pck v5, v1, s[8:15] dmask:0x1 ; encoding: [0x00,0x01,0x10,0xf0,0x01,0x05,0x02,0x00]

image_load_mip_pck_sgn v[4:5], v[0:3], s[8:15] dmask:0x5
// GFX90A: image_load_mip_pck_sgn v[4:5], v[0:3], s[8:15] dmask:0x5 ; encoding: [0x00,0x05,0x14,0xf0,0x00,0x04,0x02,0x00]

image_store v[192:194], v[238:241], s[28:35] dmask:0x7 unorm
// GFX90A: image_store v[192:194], v[238:241], s[28:35] dmask:0x7 unorm ; encoding: [0x00,0x17,0x20,0xf0,0xee,0xc0,0x07,0x00]

image_store_pck v1, v[2:5], s[12:19] dmask:0x1 unorm da
// GFX90A: image_store_pck v1, v[2:5], s[12:19] dmask:0x1 unorm da ; encoding: [0x00,0x51,0x28,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v1, v[2:5], s[12:19]
// GFX90A: image_store_mip v1, v[2:5], s[12:19] ; encoding: [0x00,0x00,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip_pck v252, v[2:3], s[12:19] dmask:0x1 a16
// GFX90A: image_store_mip_pck v252, v[2:3], s[12:19] dmask:0x1 a16 ; encoding: [0x00,0x81,0x2c,0xf0,0x02,0xfc,0x03,0x00]

image_atomic_add v4, v192, s[28:35] dmask:0x1 unorm glc
// GFX90A: image_atomic_add v4, v192, s[28:35] dmask:0x1 unorm glc ; encoding: [0x00,0x31,0x48,0xf0,0xc0,0x04,0x07,0x00]

image_atomic_and v4, v192, s[28:35] dmask:0x1 unorm
// GFX90A: image_atomic_and v4, v192, s[28:35] dmask:0x1 unorm ; encoding: [0x00,0x11,0x60,0xf0,0xc0,0x04,0x07,0x00]

image_atomic_swap v4, v[192:195], s[28:35] dmask:0x1 unorm glc
// GFX90A: image_atomic_swap v4, v[192:195], s[28:35] dmask:0x1 unorm glc ; encoding: [0x00,0x31,0x40,0xf0,0xc0,0x04,0x07,0x00]

image_atomic_cmpswap v[4:5], v[192:195], s[28:35] dmask:0x3 unorm glc
// GFX90A: image_atomic_cmpswap v[4:5], v[192:195], s[28:35] dmask:0x3 unorm glc ; encoding: [0x00,0x33,0x44,0xf0,0xc0,0x04,0x07,0x00]

image_atomic_or v4, v192, s[28:35] dmask:0x1 unorm
// GFX90A: image_atomic_or v4, v192, s[28:35] dmask:0x1 unorm ; encoding: [0x00,0x11,0x64,0xf0,0xc0,0x04,0x07,0x00]

image_atomic_xor v4, v192, s[28:35] dmask:0x1 unorm
// GFX90A: image_atomic_xor v4, v192, s[28:35] dmask:0x1 unorm ; encoding: [0x00,0x11,0x68,0xf0,0xc0,0x04,0x07,0x00]

image_atomic_sub v4, v192, s[28:35] dmask:0x1 unorm
// GFX90A: image_atomic_sub v4, v192, s[28:35] dmask:0x1 unorm ; encoding: [0x00,0x11,0x4c,0xf0,0xc0,0x04,0x07,0x00]

image_atomic_smin v4, v192, s[28:35] dmask:0x1 unorm
// GFX90A: image_atomic_smin v4, v192, s[28:35] dmask:0x1 unorm ; encoding: [0x00,0x11,0x50,0xf0,0xc0,0x04,0x07,0x00]

image_atomic_smax v4, v192, s[28:35] dmask:0x1 unorm
// GFX90A: image_atomic_smax v4, v192, s[28:35] dmask:0x1 unorm ; encoding: [0x00,0x11,0x58,0xf0,0xc0,0x04,0x07,0x00]

image_atomic_umin v4, v192, s[28:35] dmask:0x1 unorm
// GFX90A: image_atomic_umin v4, v192, s[28:35] dmask:0x1 unorm ; encoding: [0x00,0x11,0x54,0xf0,0xc0,0x04,0x07,0x00]

image_atomic_umax v4, v192, s[28:35] dmask:0x1 unorm
// GFX90A: image_atomic_umax v4, v192, s[28:35] dmask:0x1 unorm ; encoding: [0x00,0x11,0x5c,0xf0,0xc0,0x04,0x07,0x00]

image_atomic_inc v4, v192, s[28:35] dmask:0x1 unorm
// GFX90A: image_atomic_inc v4, v192, s[28:35] dmask:0x1 unorm ; encoding: [0x00,0x11,0x6c,0xf0,0xc0,0x04,0x07,0x00]

image_atomic_dec v4, v192, s[28:35] dmask:0x1 unorm
// GFX90A: image_atomic_dec v4, v192, s[28:35] dmask:0x1 unorm ; encoding: [0x00,0x11,0x70,0xf0,0xc0,0x04,0x07,0x00]

image_get_resinfo v5, v1, s[8:15] dmask:0x1
// GFX90A: image_get_resinfo v5, v1, s[8:15] dmask:0x1 ; encoding: [0x00,0x01,0x38,0xf0,0x01,0x05,0x02,0x00]

image_sample v5, v[0:3], s[8:15], s[12:15] dmask:0x1
// GFX90A: image_sample v5, v[0:3], s[8:15], s[12:15] dmask:0x1 ; encoding: [0x00,0x01,0x80,0xf0,0x00,0x05,0x62,0x00]
