// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at https://mozilla.org/MPL/2.0/.

#ifdef __cplusplus
extern "C" {
#endif

#ifndef MP4PARSE_CAPI_H
#define MP4PARSE_CAPI_H

// THIS FILE IS AUTOGENERATED BY mp4parse_capi/build.rs - DO NOT EDIT

#include <stdint.h>
#include <stdlib.h>
#include <stdbool.h>

typedef enum {
  MP4PARSE_CODEC_UNKNOWN,
  MP4PARSE_CODEC_AAC,
  MP4PARSE_CODEC_FLAC,
  MP4PARSE_CODEC_OPUS,
  MP4PARSE_CODEC_AVC,
  MP4PARSE_CODEC_VP9,
  MP4PARSE_CODEC_AV1,
  MP4PARSE_CODEC_MP3,
  MP4PARSE_CODEC_MP4V,
  MP4PARSE_CODEC_JPEG,
  MP4PARSE_CODEC_AC3,
  MP4PARSE_CODEC_EC3,
  MP4PARSE_CODEC_ALAC,
} Mp4parseCodec;

typedef enum {
  MP4PARSE_STATUS_OK = 0,
  MP4PARSE_STATUS_BAD_ARG = 1,
  MP4PARSE_STATUS_INVALID = 2,
  MP4PARSE_STATUS_UNSUPPORTED = 3,
  MP4PARSE_STATUS_EOF = 4,
  MP4PARSE_STATUS_IO = 5,
  MP4PARSE_STATUS_OOM = 6,
} Mp4parseStatus;

typedef enum {
  MP4PARSE_TRACK_TYPE_VIDEO = 0,
  MP4PARSE_TRACK_TYPE_AUDIO = 1,
  MP4PARSE_TRACK_TYPE_METADATA = 2,
} Mp4parseTrackType;

typedef struct Mp4parseParser Mp4parseParser;

typedef struct {
  uint64_t fragment_duration;
} Mp4parseFragmentInfo;

typedef struct {
  uint64_t start_offset;
  uint64_t end_offset;
  int64_t start_composition;
  int64_t end_composition;
  int64_t start_decode;
  bool sync;
} Mp4parseIndice;

typedef struct {
  uint32_t length;
  const uint8_t *data;
  const Mp4parseIndice *indices;
} Mp4parseByteData;

typedef struct {
  Mp4parseByteData data;
} Mp4parsePsshInfo;

typedef struct {
  uint32_t is_encrypted;
  uint8_t iv_size;
  Mp4parseByteData kid;
} Mp4parseSinfInfo;

typedef struct {
  uint16_t channels;
  uint16_t bit_depth;
  uint32_t sample_rate;
  uint16_t profile;
  uint16_t extended_profile;
  Mp4parseByteData codec_specific_config;
  Mp4parseByteData extra_data;
  Mp4parseSinfInfo protected_data;
} Mp4parseTrackAudioInfo;

typedef struct {
  Mp4parseTrackType track_type;
  Mp4parseCodec codec;
  uint32_t track_id;
  uint64_t duration;
  int64_t media_time;
} Mp4parseTrackInfo;

typedef struct {
  uint32_t display_width;
  uint32_t display_height;
  uint16_t image_width;
  uint16_t image_height;
  uint16_t rotation;
  Mp4parseByteData extra_data;
  Mp4parseSinfInfo protected_data;
} Mp4parseTrackVideoInfo;

typedef struct {
  intptr_t (*read)(uint8_t*, uintptr_t, void*);
  void *userdata;
} Mp4parseIo;

// THIS FILE IS AUTOGENERATED BY mp4parse_capi/build.rs - DO NOT EDIT

/*
 * Free an `Mp4parseParser*` allocated by `mp4parse_new()`.
 */
void mp4parse_free(Mp4parseParser *parser);

/*
 * Fill the supplied `Mp4parseFragmentInfo` with metadata from fragmented file.
 */
Mp4parseStatus mp4parse_get_fragment_info(Mp4parseParser *parser, Mp4parseFragmentInfo *info);

Mp4parseStatus mp4parse_get_indice_table(Mp4parseParser *parser,
                                         uint32_t track_id,
                                         Mp4parseByteData *indices);

/*
 * Get 'pssh' system id and 'pssh' box content for eme playback.
 *
 * The data format of the `info` struct passed to gecko is:
 *
 * - system id (16 byte uuid)
 * - pssh box size (32-bit native endian)
 * - pssh box content (including header)
 */
Mp4parseStatus mp4parse_get_pssh_info(Mp4parseParser *parser, Mp4parsePsshInfo *info);

/*
 * Fill the supplied `Mp4parseTrackAudioInfo` with metadata for `track`.
 */
Mp4parseStatus mp4parse_get_track_audio_info(Mp4parseParser *parser,
                                             uint32_t track_index,
                                             Mp4parseTrackAudioInfo *info);

/*
 * Return the number of tracks parsed by previous `mp4parse_read()` call.
 */
Mp4parseStatus mp4parse_get_track_count(const Mp4parseParser *parser, uint32_t *count);

/*
 * Fill the supplied `Mp4parseTrackInfo` with metadata for `track`.
 */
Mp4parseStatus mp4parse_get_track_info(Mp4parseParser *parser,
                                       uint32_t track_index,
                                       Mp4parseTrackInfo *info);

/*
 * Fill the supplied `Mp4parseTrackVideoInfo` with metadata for `track`.
 */
Mp4parseStatus mp4parse_get_track_video_info(Mp4parseParser *parser,
                                             uint32_t track_index,
                                             Mp4parseTrackVideoInfo *info);

/*
 * A fragmented file needs mvex table and contains no data in stts, stsc, and stco boxes.
 */
Mp4parseStatus mp4parse_is_fragmented(Mp4parseParser *parser,
                                      uint32_t track_id,
                                      uint8_t *fragmented);

/*
 * Allocate an `Mp4parseParser*` to read from the supplied `Mp4parseIo`.
 */
Mp4parseParser *mp4parse_new(const Mp4parseIo *io);

/*
 * Run the `Mp4parseParser*` allocated by `mp4parse_new()` until EOF or error.
 */
Mp4parseStatus mp4parse_read(Mp4parseParser *parser);

// THIS FILE IS AUTOGENERATED BY mp4parse_capi/build.rs - DO NOT EDIT

#endif /* MP4PARSE_CAPI_H */

#ifdef __cplusplus
} /* extern "C" */
#endif
