#!/usr/bin/python

import pycurl
import unittest
import sys
sys.path.insert(0, "..")

import softwareproperties.ppa

class TestLP(unittest.TestCase):

    def test_ppa_info_from_lp(self):
        # use correct data
        info = softwareproperties.ppa.get_ppa_info_from_lp("mvo", "ppa")
        self.assertNotEqual(info, {})
        self.assertEqual(info["name"], "ppa")
        # use empty CERT file
        softwareproperties.ppa.LAUNCHPAD_PPA_CERT = "/dev/null"
        self.assertRaises(
            pycurl.error, softwareproperties.ppa.get_ppa_info_from_lp, "mvo", "ppa")

        


if __name__ == "__main__":
    unittest.main()
