import OCP.FSD
from typing import *
from typing import Iterable as iterable
from typing import Iterator as iterator
from numpy import float64
_Shape = Tuple[int, ...]
import OCP.TCollection
import io
import OCP.Storage
import OCP.TColStd
import OCP.Standard
import OCP.NCollection
__all__  = [
"FSD_Base64",
"FSD_BinaryFile",
"FSD_File",
"FSD_CmpFile",
"FSD_FileHeader"
]
class FSD_Base64():
    """
    Tool for encoding/decoding base64 stream.
    """
    @staticmethod
    @overload
    def Decode_s(theDecodedData : int,theDataLen : int,theEncodedStr : str,theStrLen : int) -> int: 
        """
        Function decoding base64 string.

        Function decoding base64 string.
        """
    @staticmethod
    @overload
    def Decode_s(theStr : str,theLen : int) -> OCP.NCollection.NCollection_Buffer: ...
    @staticmethod
    @overload
    def Encode_s(theEncodedStr : str,theStrLen : int,theData : int,theDataLen : int) -> int: 
        """
        Function encoding a buffer to base64 string.

        Function encoding a buffer to base64 string.
        """
    @staticmethod
    @overload
    def Encode_s(theData : int,theDataLen : int) -> OCP.TCollection.TCollection_AsciiString: ...
    def __init__(self) -> None: ...
    pass
class FSD_BinaryFile(OCP.Storage.Storage_BaseDriver, OCP.Standard.Standard_Transient):
    def BeginReadCommentSection(self) -> OCP.Storage.Storage_Error: ...
    def BeginReadDataSection(self) -> OCP.Storage.Storage_Error: ...
    def BeginReadInfoSection(self) -> OCP.Storage.Storage_Error: ...
    def BeginReadObjectData(self) -> None: ...
    def BeginReadPersistentObjectData(self) -> None: ...
    def BeginReadRefSection(self) -> OCP.Storage.Storage_Error: ...
    def BeginReadRootSection(self) -> OCP.Storage.Storage_Error: ...
    def BeginReadTypeSection(self) -> OCP.Storage.Storage_Error: ...
    @overload
    def BeginWriteCommentSection(self) -> OCP.Storage.Storage_Error: ...
    @overload
    def BeginWriteCommentSection(self,theOStream : io.BytesIO) -> OCP.Storage.Storage_Error: ...
    def BeginWriteDataSection(self) -> OCP.Storage.Storage_Error: ...
    def BeginWriteInfoSection(self) -> OCP.Storage.Storage_Error: ...
    def BeginWriteObjectData(self) -> None: ...
    def BeginWritePersistentObjectData(self) -> None: ...
    def BeginWriteRefSection(self) -> OCP.Storage.Storage_Error: ...
    def BeginWriteRootSection(self) -> OCP.Storage.Storage_Error: ...
    def BeginWriteTypeSection(self) -> OCP.Storage.Storage_Error: ...
    def Close(self) -> OCP.Storage.Storage_Error: ...
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def Destroy(self) -> None: ...
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def EndReadCommentSection(self) -> OCP.Storage.Storage_Error: ...
    def EndReadDataSection(self) -> OCP.Storage.Storage_Error: ...
    def EndReadInfoSection(self) -> OCP.Storage.Storage_Error: ...
    def EndReadObjectData(self) -> None: ...
    def EndReadPersistentObjectData(self) -> None: ...
    def EndReadRefSection(self) -> OCP.Storage.Storage_Error: ...
    def EndReadRootSection(self) -> OCP.Storage.Storage_Error: ...
    def EndReadTypeSection(self) -> OCP.Storage.Storage_Error: ...
    @overload
    def EndWriteCommentSection(self) -> OCP.Storage.Storage_Error: ...
    @overload
    def EndWriteCommentSection(self,theOStream : io.BytesIO) -> OCP.Storage.Storage_Error: ...
    def EndWriteDataSection(self) -> OCP.Storage.Storage_Error: ...
    @overload
    def EndWriteInfoSection(self) -> OCP.Storage.Storage_Error: ...
    @overload
    def EndWriteInfoSection(self,theOStream : io.BytesIO) -> OCP.Storage.Storage_Error: ...
    def EndWriteObjectData(self) -> None: ...
    def EndWritePersistentObjectData(self) -> None: ...
    def EndWriteRefSection(self) -> OCP.Storage.Storage_Error: ...
    def EndWriteRootSection(self) -> OCP.Storage.Storage_Error: ...
    def EndWriteTypeSection(self) -> OCP.Storage.Storage_Error: ...
    def GetBoolean(self,aValue : bool) -> OCP.Storage.Storage_BaseDriver: ...
    def GetCharacter(self,aValue : str) -> OCP.Storage.Storage_BaseDriver: ...
    def GetExtCharacter(self,aValue : str) -> OCP.Storage.Storage_BaseDriver: ...
    def GetInteger(self,aValue : int) -> OCP.Storage.Storage_BaseDriver: ...
    @staticmethod
    def GetInteger_s(theIStream : io.BytesIO) -> tuple[int]: ...
    def GetReal(self,aValue : float) -> OCP.Storage.Storage_BaseDriver: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GetReference(self,aValue : int) -> OCP.Storage.Storage_BaseDriver: ...
    @staticmethod
    def GetReference_s(theIStream : io.BytesIO) -> tuple[int]: ...
    def GetShortReal(self,aValue : float) -> OCP.Storage.Storage_BaseDriver: ...
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    @staticmethod
    def InverseExtChar_s(theValue : str) -> str: 
        """
        Inverse bytes in extended character value
        """
    @staticmethod
    def InverseInt_s(theValue : int) -> int: 
        """
        Inverse bytes in integer value
        """
    @staticmethod
    def InverseReal_s(theValue : float) -> float: 
        """
        Inverse bytes in real value
        """
    @staticmethod
    def InverseShortReal_s(theValue : float) -> float: 
        """
        Inverse bytes in short real value
        """
    @staticmethod
    def InverseSize_s(theValue : int) -> int: 
        """
        Inverse bytes in size value
        """
    @staticmethod
    def InverseUint64_s(theValue : int) -> int: 
        """
        Inverse bytes in 64bit unsigned int value
        """
    def IsEnd(self) -> bool: ...
    @staticmethod
    def IsGoodFileType_s(aName : OCP.TCollection.TCollection_AsciiString) -> OCP.Storage.Storage_Error: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    @staticmethod
    def MagicNumber_s() -> str: ...
    def Name(self) -> OCP.TCollection.TCollection_AsciiString: ...
    def Open(self,aName : OCP.TCollection.TCollection_AsciiString,aMode : OCP.Storage.Storage_OpenMode) -> OCP.Storage.Storage_Error: ...
    def OpenMode(self) -> OCP.Storage.Storage_OpenMode: ...
    def PutBoolean(self,aValue : bool) -> OCP.Storage.Storage_BaseDriver: ...
    def PutCharacter(self,aValue : str) -> OCP.Storage.Storage_BaseDriver: ...
    def PutExtCharacter(self,aValue : str) -> OCP.Storage.Storage_BaseDriver: ...
    def PutInteger(self,aValue : int) -> OCP.Storage.Storage_BaseDriver: ...
    @staticmethod
    def PutInteger_s(theOStream : io.BytesIO,aValue : int,theOnlyCount : bool=False) -> int: ...
    def PutReal(self,aValue : float) -> OCP.Storage.Storage_BaseDriver: ...
    def PutReference(self,aValue : int) -> OCP.Storage.Storage_BaseDriver: ...
    def PutShortReal(self,aValue : float) -> OCP.Storage.Storage_BaseDriver: ...
    def ReadComment(self,userComments : OCP.TColStd.TColStd_SequenceOfExtendedString) -> None: ...
    @staticmethod
    def ReadComment_s(theIStream : io.BytesIO,userComments : OCP.TColStd.TColStd_SequenceOfExtendedString) -> None: ...
    def ReadCompleteInfo(self,theIStream : io.BytesIO,theData : OCP.Storage.Storage_Data) -> Any: ...
    @staticmethod
    def ReadExtendedString_s(theIStream : io.BytesIO,buffer : OCP.TCollection.TCollection_ExtendedString) -> None: ...
    @staticmethod
    def ReadHeaderData_s(theIStream : io.BytesIO,theHeaderData : OCP.Storage.Storage_HeaderData) -> None: ...
    @staticmethod
    def ReadHeader_s(theIStream : io.BytesIO,theFileHeader : FSD_FileHeader) -> None: ...
    def ReadInfo(self,dbVersion : OCP.TCollection.TCollection_AsciiString,date : OCP.TCollection.TCollection_AsciiString,schemaName : OCP.TCollection.TCollection_AsciiString,schemaVersion : OCP.TCollection.TCollection_AsciiString,appName : OCP.TCollection.TCollection_ExtendedString,appVersion : OCP.TCollection.TCollection_AsciiString,objectType : OCP.TCollection.TCollection_ExtendedString,userInfo : OCP.TColStd.TColStd_SequenceOfAsciiString) -> tuple[int]: ...
    @staticmethod
    def ReadMagicNumber_s(theIStream : io.BytesIO) -> OCP.TCollection.TCollection_AsciiString: ...
    def ReadPersistentObjectHeader(self) -> tuple[int, int]: ...
    def ReadReferenceType(self) -> tuple[int, int]: ...
    @staticmethod
    def ReadReferenceType_s(theIStream : io.BytesIO) -> tuple[int, int]: ...
    def ReadRoot(self,rootName : OCP.TCollection.TCollection_AsciiString,aType : OCP.TCollection.TCollection_AsciiString) -> tuple[int]: ...
    @staticmethod
    def ReadRoot_s(theIStream : io.BytesIO,rootName : OCP.TCollection.TCollection_AsciiString,aType : OCP.TCollection.TCollection_AsciiString) -> tuple[int]: ...
    @staticmethod
    def ReadString_s(theIStream : io.BytesIO,buffer : OCP.TCollection.TCollection_AsciiString) -> None: ...
    def ReadTypeInformations(self,typeName : OCP.TCollection.TCollection_AsciiString) -> tuple[int]: ...
    @staticmethod
    def ReadTypeInformations_s(theIStream : io.BytesIO,typeName : OCP.TCollection.TCollection_AsciiString) -> tuple[int]: ...
    def RefSectionSize(self) -> int: ...
    @staticmethod
    def RefSectionSize_s(theIStream : io.BytesIO) -> int: ...
    def RootSectionSize(self) -> int: ...
    @staticmethod
    def RootSectionSize_s(theIStream : io.BytesIO) -> int: ...
    def SetRefSectionSize(self,aSize : int) -> None: ...
    def SetRootSectionSize(self,aSize : int) -> None: ...
    def SetTypeSectionSize(self,aSize : int) -> None: ...
    def SkipObject(self) -> None: ...
    def Tell(self) -> int: 
        """
        return position in the file. Return -1 upon error.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def TypeSectionSize(self) -> int: ...
    @staticmethod
    def TypeSectionSize_s(theIStream : io.BytesIO) -> int: ...
    def WriteComment(self,userComments : OCP.TColStd.TColStd_SequenceOfExtendedString) -> None: ...
    @staticmethod
    def WriteComment_s(theOStream : io.BytesIO,theComments : OCP.TColStd.TColStd_SequenceOfExtendedString,theOnlyCount : bool=False) -> int: ...
    @staticmethod
    def WriteHeader_s(theOStream : io.BytesIO,theHeader : FSD_FileHeader,theOnlyCount : bool=False) -> int: ...
    def WriteInfo(self,nbObj : int,dbVersion : OCP.TCollection.TCollection_AsciiString,date : OCP.TCollection.TCollection_AsciiString,schemaName : OCP.TCollection.TCollection_AsciiString,schemaVersion : OCP.TCollection.TCollection_AsciiString,appName : OCP.TCollection.TCollection_ExtendedString,appVersion : OCP.TCollection.TCollection_AsciiString,objectType : OCP.TCollection.TCollection_ExtendedString,userInfo : OCP.TColStd.TColStd_SequenceOfAsciiString) -> None: ...
    @staticmethod
    def WriteInfo_s(theOStream : io.BytesIO,nbObj : int,dbVersion : OCP.TCollection.TCollection_AsciiString,date : OCP.TCollection.TCollection_AsciiString,schemaName : OCP.TCollection.TCollection_AsciiString,schemaVersion : OCP.TCollection.TCollection_AsciiString,appName : OCP.TCollection.TCollection_ExtendedString,appVersion : OCP.TCollection.TCollection_AsciiString,objectType : OCP.TCollection.TCollection_ExtendedString,userInfo : OCP.TColStd.TColStd_SequenceOfAsciiString,theOnlyCount : bool=False) -> int: ...
    def WritePersistentObjectHeader(self,aRef : int,aType : int) -> None: ...
    def WriteReferenceType(self,reference : int,typeNum : int) -> None: ...
    def WriteRoot(self,rootName : OCP.TCollection.TCollection_AsciiString,aRef : int,aType : OCP.TCollection.TCollection_AsciiString) -> None: ...
    def WriteTypeInformations(self,typeNum : int,typeName : OCP.TCollection.TCollection_AsciiString) -> None: ...
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class FSD_File(OCP.Storage.Storage_BaseDriver, OCP.Standard.Standard_Transient):
    """
    A general driver which defines as a file, the physical container for data to be stored or retrieved.A general driver which defines as a file, the physical container for data to be stored or retrieved.
    """
    def BeginReadCommentSection(self) -> OCP.Storage.Storage_Error: ...
    def BeginReadDataSection(self) -> OCP.Storage.Storage_Error: ...
    def BeginReadInfoSection(self) -> OCP.Storage.Storage_Error: ...
    def BeginReadObjectData(self) -> None: ...
    def BeginReadPersistentObjectData(self) -> None: ...
    def BeginReadRefSection(self) -> OCP.Storage.Storage_Error: ...
    def BeginReadRootSection(self) -> OCP.Storage.Storage_Error: ...
    def BeginReadTypeSection(self) -> OCP.Storage.Storage_Error: ...
    def BeginWriteCommentSection(self) -> OCP.Storage.Storage_Error: ...
    def BeginWriteDataSection(self) -> OCP.Storage.Storage_Error: ...
    def BeginWriteInfoSection(self) -> OCP.Storage.Storage_Error: ...
    def BeginWriteObjectData(self) -> None: ...
    def BeginWritePersistentObjectData(self) -> None: ...
    def BeginWriteRefSection(self) -> OCP.Storage.Storage_Error: ...
    def BeginWriteRootSection(self) -> OCP.Storage.Storage_Error: ...
    def BeginWriteTypeSection(self) -> OCP.Storage.Storage_Error: ...
    def Close(self) -> OCP.Storage.Storage_Error: 
        """
        Closes the file driven by this driver. This file was opened by the last call to the function Open. The function returns Storage_VSOk if the closure is correctly done, or any other value of the Storage_Error enumeration which specifies the problem encountered.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def Destroy(self) -> None: ...
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def EndReadCommentSection(self) -> OCP.Storage.Storage_Error: ...
    def EndReadDataSection(self) -> OCP.Storage.Storage_Error: ...
    def EndReadInfoSection(self) -> OCP.Storage.Storage_Error: ...
    def EndReadObjectData(self) -> None: ...
    def EndReadPersistentObjectData(self) -> None: ...
    def EndReadRefSection(self) -> OCP.Storage.Storage_Error: ...
    def EndReadRootSection(self) -> OCP.Storage.Storage_Error: ...
    def EndReadTypeSection(self) -> OCP.Storage.Storage_Error: ...
    def EndWriteCommentSection(self) -> OCP.Storage.Storage_Error: ...
    def EndWriteDataSection(self) -> OCP.Storage.Storage_Error: ...
    def EndWriteInfoSection(self) -> OCP.Storage.Storage_Error: ...
    def EndWriteObjectData(self) -> None: ...
    def EndWritePersistentObjectData(self) -> None: ...
    def EndWriteRefSection(self) -> OCP.Storage.Storage_Error: ...
    def EndWriteRootSection(self) -> OCP.Storage.Storage_Error: ...
    def EndWriteTypeSection(self) -> OCP.Storage.Storage_Error: ...
    def GetBoolean(self,aValue : bool) -> OCP.Storage.Storage_BaseDriver: ...
    def GetCharacter(self,aValue : str) -> OCP.Storage.Storage_BaseDriver: ...
    def GetExtCharacter(self,aValue : str) -> OCP.Storage.Storage_BaseDriver: ...
    def GetInteger(self,aValue : int) -> OCP.Storage.Storage_BaseDriver: ...
    def GetReal(self,aValue : float) -> OCP.Storage.Storage_BaseDriver: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GetReference(self,aValue : int) -> OCP.Storage.Storage_BaseDriver: ...
    def GetShortReal(self,aValue : float) -> OCP.Storage.Storage_BaseDriver: ...
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsEnd(self) -> bool: ...
    @staticmethod
    def IsGoodFileType_s(aName : OCP.TCollection.TCollection_AsciiString) -> OCP.Storage.Storage_Error: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    @staticmethod
    def MagicNumber_s() -> str: ...
    def Name(self) -> OCP.TCollection.TCollection_AsciiString: ...
    def Open(self,aName : OCP.TCollection.TCollection_AsciiString,aMode : OCP.Storage.Storage_OpenMode) -> OCP.Storage.Storage_Error: 
        """
        Assigns as aName the name of the file to be driven by this driver. aMode precises if the file is opened in read or write mode. The function returns Storage_VSOk if the file is opened correctly, or any other value of the Storage_Error enumeration which specifies the problem encountered.
        """
    def OpenMode(self) -> OCP.Storage.Storage_OpenMode: ...
    def PutBoolean(self,aValue : bool) -> OCP.Storage.Storage_BaseDriver: ...
    def PutCharacter(self,aValue : str) -> OCP.Storage.Storage_BaseDriver: ...
    def PutExtCharacter(self,aValue : str) -> OCP.Storage.Storage_BaseDriver: ...
    def PutInteger(self,aValue : int) -> OCP.Storage.Storage_BaseDriver: ...
    def PutReal(self,aValue : float) -> OCP.Storage.Storage_BaseDriver: ...
    def PutReference(self,aValue : int) -> OCP.Storage.Storage_BaseDriver: ...
    def PutShortReal(self,aValue : float) -> OCP.Storage.Storage_BaseDriver: ...
    def ReadComment(self,userComments : OCP.TColStd.TColStd_SequenceOfExtendedString) -> None: ...
    def ReadCompleteInfo(self,theIStream : io.BytesIO,theData : OCP.Storage.Storage_Data) -> Any: ...
    def ReadInfo(self,dbVersion : OCP.TCollection.TCollection_AsciiString,date : OCP.TCollection.TCollection_AsciiString,schemaName : OCP.TCollection.TCollection_AsciiString,schemaVersion : OCP.TCollection.TCollection_AsciiString,appName : OCP.TCollection.TCollection_ExtendedString,appVersion : OCP.TCollection.TCollection_AsciiString,objectType : OCP.TCollection.TCollection_ExtendedString,userInfo : OCP.TColStd.TColStd_SequenceOfAsciiString) -> tuple[int]: ...
    @staticmethod
    def ReadMagicNumber_s(theIStream : io.BytesIO) -> OCP.TCollection.TCollection_AsciiString: ...
    def ReadPersistentObjectHeader(self) -> tuple[int, int]: ...
    def ReadReferenceType(self) -> tuple[int, int]: ...
    def ReadRoot(self,rootName : OCP.TCollection.TCollection_AsciiString,aType : OCP.TCollection.TCollection_AsciiString) -> tuple[int]: ...
    def ReadTypeInformations(self,typeName : OCP.TCollection.TCollection_AsciiString) -> tuple[int]: ...
    def RefSectionSize(self) -> int: ...
    def RootSectionSize(self) -> int: ...
    def SetRefSectionSize(self,aSize : int) -> None: ...
    def SetRootSectionSize(self,aSize : int) -> None: ...
    def SetTypeSectionSize(self,aSize : int) -> None: ...
    def SkipObject(self) -> None: ...
    def Tell(self) -> int: 
        """
        return position in the file. Return -1 upon error.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def TypeSectionSize(self) -> int: ...
    def WriteComment(self,userComments : OCP.TColStd.TColStd_SequenceOfExtendedString) -> None: ...
    def WriteInfo(self,nbObj : int,dbVersion : OCP.TCollection.TCollection_AsciiString,date : OCP.TCollection.TCollection_AsciiString,schemaName : OCP.TCollection.TCollection_AsciiString,schemaVersion : OCP.TCollection.TCollection_AsciiString,appName : OCP.TCollection.TCollection_ExtendedString,appVersion : OCP.TCollection.TCollection_AsciiString,objectType : OCP.TCollection.TCollection_ExtendedString,userInfo : OCP.TColStd.TColStd_SequenceOfAsciiString) -> None: ...
    def WritePersistentObjectHeader(self,aRef : int,aType : int) -> None: ...
    def WriteReferenceType(self,reference : int,typeNum : int) -> None: ...
    def WriteRoot(self,rootName : OCP.TCollection.TCollection_AsciiString,aRef : int,aType : OCP.TCollection.TCollection_AsciiString) -> None: ...
    def WriteTypeInformations(self,typeNum : int,typeName : OCP.TCollection.TCollection_AsciiString) -> None: ...
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class FSD_CmpFile(FSD_File, OCP.Storage.Storage_BaseDriver, OCP.Standard.Standard_Transient):
    def BeginReadCommentSection(self) -> OCP.Storage.Storage_Error: ...
    def BeginReadDataSection(self) -> OCP.Storage.Storage_Error: ...
    def BeginReadInfoSection(self) -> OCP.Storage.Storage_Error: ...
    def BeginReadObjectData(self) -> None: ...
    def BeginReadPersistentObjectData(self) -> None: ...
    def BeginReadRefSection(self) -> OCP.Storage.Storage_Error: ...
    def BeginReadRootSection(self) -> OCP.Storage.Storage_Error: ...
    def BeginReadTypeSection(self) -> OCP.Storage.Storage_Error: ...
    def BeginWriteCommentSection(self) -> OCP.Storage.Storage_Error: ...
    def BeginWriteDataSection(self) -> OCP.Storage.Storage_Error: ...
    def BeginWriteInfoSection(self) -> OCP.Storage.Storage_Error: ...
    def BeginWriteObjectData(self) -> None: ...
    def BeginWritePersistentObjectData(self) -> None: ...
    def BeginWriteRefSection(self) -> OCP.Storage.Storage_Error: ...
    def BeginWriteRootSection(self) -> OCP.Storage.Storage_Error: ...
    def BeginWriteTypeSection(self) -> OCP.Storage.Storage_Error: ...
    def Close(self) -> OCP.Storage.Storage_Error: 
        """
        Closes the file driven by this driver. This file was opened by the last call to the function Open. The function returns Storage_VSOk if the closure is correctly done, or any other value of the Storage_Error enumeration which specifies the problem encountered.
        """
    def DecrementRefCounter(self) -> int: 
        """
        Decrements the reference counter of this object; returns the decremented value
        """
    def Delete(self) -> None: 
        """
        Memory deallocator for transient classes
        """
    def Destroy(self) -> None: ...
    def DynamicType(self) -> OCP.Standard.Standard_Type: ...
    def EndReadCommentSection(self) -> OCP.Storage.Storage_Error: ...
    def EndReadDataSection(self) -> OCP.Storage.Storage_Error: ...
    def EndReadInfoSection(self) -> OCP.Storage.Storage_Error: ...
    def EndReadObjectData(self) -> None: ...
    def EndReadPersistentObjectData(self) -> None: ...
    def EndReadRefSection(self) -> OCP.Storage.Storage_Error: ...
    def EndReadRootSection(self) -> OCP.Storage.Storage_Error: ...
    def EndReadTypeSection(self) -> OCP.Storage.Storage_Error: ...
    def EndWriteCommentSection(self) -> OCP.Storage.Storage_Error: ...
    def EndWriteDataSection(self) -> OCP.Storage.Storage_Error: ...
    def EndWriteInfoSection(self) -> OCP.Storage.Storage_Error: ...
    def EndWriteObjectData(self) -> None: ...
    def EndWritePersistentObjectData(self) -> None: ...
    def EndWriteRefSection(self) -> OCP.Storage.Storage_Error: ...
    def EndWriteRootSection(self) -> OCP.Storage.Storage_Error: ...
    def EndWriteTypeSection(self) -> OCP.Storage.Storage_Error: ...
    def GetBoolean(self,aValue : bool) -> OCP.Storage.Storage_BaseDriver: ...
    def GetCharacter(self,aValue : str) -> OCP.Storage.Storage_BaseDriver: ...
    def GetExtCharacter(self,aValue : str) -> OCP.Storage.Storage_BaseDriver: ...
    def GetInteger(self,aValue : int) -> OCP.Storage.Storage_BaseDriver: ...
    def GetReal(self,aValue : float) -> OCP.Storage.Storage_BaseDriver: ...
    def GetRefCount(self) -> int: 
        """
        Get the reference counter of this object
        """
    def GetReference(self,aValue : int) -> OCP.Storage.Storage_BaseDriver: ...
    def GetShortReal(self,aValue : float) -> OCP.Storage.Storage_BaseDriver: ...
    def IncrementRefCounter(self) -> None: 
        """
        Increments the reference counter of this object
        """
    def IsEnd(self) -> bool: ...
    @staticmethod
    def IsGoodFileType_s(aName : OCP.TCollection.TCollection_AsciiString) -> OCP.Storage.Storage_Error: ...
    @overload
    def IsInstance(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns a true value if this is an instance of Type.

        Returns a true value if this is an instance of TypeName.
        """
    @overload
    def IsInstance(self,theTypeName : str) -> bool: ...
    @overload
    def IsKind(self,theType : OCP.Standard.Standard_Type) -> bool: 
        """
        Returns true if this is an instance of Type or an instance of any class that inherits from Type. Note that multiple inheritance is not supported by OCCT RTTI mechanism.

        Returns true if this is an instance of TypeName or an instance of any class that inherits from TypeName. Note that multiple inheritance is not supported by OCCT RTTI mechanism.
        """
    @overload
    def IsKind(self,theTypeName : str) -> bool: ...
    @staticmethod
    def MagicNumber_s() -> str: ...
    def Name(self) -> OCP.TCollection.TCollection_AsciiString: ...
    def Open(self,aName : OCP.TCollection.TCollection_AsciiString,aMode : OCP.Storage.Storage_OpenMode) -> OCP.Storage.Storage_Error: ...
    def OpenMode(self) -> OCP.Storage.Storage_OpenMode: ...
    def PutBoolean(self,aValue : bool) -> OCP.Storage.Storage_BaseDriver: ...
    def PutCharacter(self,aValue : str) -> OCP.Storage.Storage_BaseDriver: ...
    def PutExtCharacter(self,aValue : str) -> OCP.Storage.Storage_BaseDriver: ...
    def PutInteger(self,aValue : int) -> OCP.Storage.Storage_BaseDriver: ...
    def PutReal(self,aValue : float) -> OCP.Storage.Storage_BaseDriver: ...
    def PutReference(self,aValue : int) -> OCP.Storage.Storage_BaseDriver: ...
    def PutShortReal(self,aValue : float) -> OCP.Storage.Storage_BaseDriver: ...
    def ReadComment(self,userComments : OCP.TColStd.TColStd_SequenceOfExtendedString) -> None: ...
    def ReadCompleteInfo(self,theIStream : io.BytesIO,theData : OCP.Storage.Storage_Data) -> Any: ...
    def ReadInfo(self,dbVersion : OCP.TCollection.TCollection_AsciiString,date : OCP.TCollection.TCollection_AsciiString,schemaName : OCP.TCollection.TCollection_AsciiString,schemaVersion : OCP.TCollection.TCollection_AsciiString,appName : OCP.TCollection.TCollection_ExtendedString,appVersion : OCP.TCollection.TCollection_AsciiString,objectType : OCP.TCollection.TCollection_ExtendedString,userInfo : OCP.TColStd.TColStd_SequenceOfAsciiString) -> tuple[int]: ...
    @staticmethod
    def ReadMagicNumber_s(theIStream : io.BytesIO) -> OCP.TCollection.TCollection_AsciiString: ...
    def ReadPersistentObjectHeader(self) -> tuple[int, int]: ...
    def ReadReferenceType(self) -> tuple[int, int]: ...
    def ReadRoot(self,rootName : OCP.TCollection.TCollection_AsciiString,aType : OCP.TCollection.TCollection_AsciiString) -> tuple[int]: ...
    def ReadTypeInformations(self,typeName : OCP.TCollection.TCollection_AsciiString) -> tuple[int]: ...
    def RefSectionSize(self) -> int: ...
    def RootSectionSize(self) -> int: ...
    def SetRefSectionSize(self,aSize : int) -> None: ...
    def SetRootSectionSize(self,aSize : int) -> None: ...
    def SetTypeSectionSize(self,aSize : int) -> None: ...
    def SkipObject(self) -> None: ...
    def Tell(self) -> int: 
        """
        return position in the file. Return -1 upon error.
        """
    def This(self) -> OCP.Standard.Standard_Transient: 
        """
        Returns non-const pointer to this object (like const_cast). For protection against creating handle to objects allocated in stack or call from constructor, it will raise exception Standard_ProgramError if reference counter is zero.
        """
    def TypeSectionSize(self) -> int: ...
    def WriteComment(self,userComments : OCP.TColStd.TColStd_SequenceOfExtendedString) -> None: ...
    def WriteInfo(self,nbObj : int,dbVersion : OCP.TCollection.TCollection_AsciiString,date : OCP.TCollection.TCollection_AsciiString,schemaName : OCP.TCollection.TCollection_AsciiString,schemaVersion : OCP.TCollection.TCollection_AsciiString,appName : OCP.TCollection.TCollection_ExtendedString,appVersion : OCP.TCollection.TCollection_AsciiString,objectType : OCP.TCollection.TCollection_ExtendedString,userInfo : OCP.TColStd.TColStd_SequenceOfAsciiString) -> None: ...
    def WritePersistentObjectHeader(self,aRef : int,aType : int) -> None: ...
    def WriteReferenceType(self,reference : int,typeNum : int) -> None: ...
    def WriteRoot(self,rootName : OCP.TCollection.TCollection_AsciiString,aRef : int,aType : OCP.TCollection.TCollection_AsciiString) -> None: ...
    def WriteTypeInformations(self,typeNum : int,typeName : OCP.TCollection.TCollection_AsciiString) -> None: ...
    def __init__(self) -> None: ...
    @staticmethod
    def get_type_descriptor_s() -> OCP.Standard.Standard_Type: ...
    @staticmethod
    def get_type_name_s() -> str: ...
    pass
class FSD_FileHeader():
    def __init__(self) -> None: ...
    @property
    def bcomment(self) -> int:
        """
        :type: int
        """
    @bcomment.setter
    def bcomment(self, arg0: int) -> None:
        pass
    @property
    def bdata(self) -> int:
        """
        :type: int
        """
    @bdata.setter
    def bdata(self, arg0: int) -> None:
        pass
    @property
    def binfo(self) -> int:
        """
        :type: int
        """
    @binfo.setter
    def binfo(self, arg0: int) -> None:
        pass
    @property
    def bref(self) -> int:
        """
        :type: int
        """
    @bref.setter
    def bref(self, arg0: int) -> None:
        pass
    @property
    def broot(self) -> int:
        """
        :type: int
        """
    @broot.setter
    def broot(self, arg0: int) -> None:
        pass
    @property
    def btype(self) -> int:
        """
        :type: int
        """
    @btype.setter
    def btype(self, arg0: int) -> None:
        pass
    @property
    def ecomment(self) -> int:
        """
        :type: int
        """
    @ecomment.setter
    def ecomment(self, arg0: int) -> None:
        pass
    @property
    def edata(self) -> int:
        """
        :type: int
        """
    @edata.setter
    def edata(self, arg0: int) -> None:
        pass
    @property
    def einfo(self) -> int:
        """
        :type: int
        """
    @einfo.setter
    def einfo(self, arg0: int) -> None:
        pass
    @property
    def eref(self) -> int:
        """
        :type: int
        """
    @eref.setter
    def eref(self, arg0: int) -> None:
        pass
    @property
    def eroot(self) -> int:
        """
        :type: int
        """
    @eroot.setter
    def eroot(self, arg0: int) -> None:
        pass
    @property
    def etype(self) -> int:
        """
        :type: int
        """
    @etype.setter
    def etype(self, arg0: int) -> None:
        pass
    @property
    def testindian(self) -> int:
        """
        :type: int
        """
    @testindian.setter
    def testindian(self, arg0: int) -> None:
        pass
    pass
