**Note:** Final project proposals must be submitted through to Google through the GSoC Program Website, as stated in the [rules](https://summerofcode.withgoogle.com/rules/).

Before submitting to the GSoC website, it is also helpful to solicit proposal feedback. This can be done by reaching out to us on our Slack at <https://metasploit.com/slack> via the `#gsoc` channel, or via sending an email to `msfdev [@] metasploit [dot]  com`. If you don't hear back right away on a proposal, don't give up! Contributors may be busy, or you may need to try again to get someone's attention (but don't spam).

# 2026 Timeline
An updated list of the application timeline can be found at https://developers.google.com/open-source/gsoc/timeline. Please refer to this link for any updates that Google may make, as they have been known to change the timeline for certain dates in the past.

## Important Dates

- GSoC Applications Open: March 16th at 18:00 UTC
- GSoC Applications Close: March 31th at 1800 UTC for 2026 GSoC applications
- Accepted GSoC contributor projects announced: April 30th at 1800 UTC
- Programming Starts: May 25th.

# 2026 Idea List
You can find the current list of GSoC ideas at [[GSoC-2026-Project-Ideas]]. Please see the note at the bottom of this page if you are interested in submitting your own idea, as this will require approval.

# Getting started
Students interesting in GSoC, can start by reading Google's official guides.
<https://developers.google.com/open-source/gsoc/help/student-advice>

Review all of the [student guide](https://google.github.io/gsocguides/student/) and carefully read the [proposal writing section](https://google.github.io/gsocguides/student/writing-a-proposal.html).

A listed `idea` is a seed for GSoC students to expand on and propose how to design and implement a solution.  You can start by investigating the code base and how existing users interaction with `msfconsole` functionality. Think through scenarios on how a user might want to interact with the proposed idea.

A place to get started with contributing to Metasploit is [here](https://github.com/rapid7/metasploit-framework/blob/master/CONTRIBUTING.md) and expanded on [[here|./Contributing-to-Metasploit.md]].

GSoC mentors tend to look for those items that have a chance of making development and usage easier or improving the overall performance of a certain area, however by starting with understanding the most common contribution pattern you can get familiar with the codebase and also the mindset of users. This will help you in creating a proposal with the end user in mind.

Once you have started digging feel free ask questions that help you understand the concepts you for the idea would like to propose.

Initial proposals can be sent for feedback before official submission opens to msfdev@metasploit.com. All proposals must be officially submitted during Student Application Period through the [GSoC official](https://g.co/gsoc) site.

At a bare minimum, proposals should include the following:

## Title

A brief description of what you would like to work on. See [[GSoC-2022-Project-Ideas]] for ideas.

## Vitals

* Your name
* Contact info - include at least:
  - an email address
  - github user name
  - Freenode nick/Slack nick

## Skillz

What programming languages are you familiar with, in order of proficiency? Most of Metasploit is written in Ruby; for any project you will most likely need at least a passing knowledge of it. If you want to work on Meterpreter or Mettle, C will be necessary as well.

What other projects have you worked on before?


## Your project

Fill in the details. What exactly do you want to accomplish?

# Past Submissions
If you are interested in looking at past accepted submissions and projects, you can find them at https://summerofcode.withgoogle.com/archive, and clicking on any year from 2017 onwards (with the exception of 2019 as Metasploit did not participate this year). Then click on the `Security` tag, and search for `Metasploit`. Scroll down to the bottom and you will see past successful applications and the associated code for each successful submission. Submissions from 2020 onwards also include copies of the proposal that was sent in by the accepted contributor.
