/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/unittest/test_case_cstr.t.cpp
 *
 * @brief [LEVEL: beta] testing test_case_cstr.hpp
 *
 * $Id: test_case_cstr.t.cpp,v 1.10 2005/06/23 09:54:24 esdentem Exp $
 *
 * @author Christian Schallhart
 */

#include <diagnostics/unittest.hpp>

#include <diagnostics/unittest/test_system_exception.hpp>

#include <diagnostics/util/dump_test_suite.ts.hpp>

#define TEST_COMPONENT_NAME Test_Case_Cstr
#define TEST_COMPONENT_NAMESPACE diagnostics::unittest

DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;
TEST_NAMESPACE_BEGIN;
TEST_COMPONENT_TEST_NAMESPACE_BEGIN;

class Test_Function_Object
{
public:
    Test_Function_Object(int const i) 
    {
    }
    
    void operator()(Test_Data & test_data) const
    {
	// just to check for the call
	throw Test_Exception("xxx");
    }
};

void test_function(Test_Data & test_data) 
{
    // just to check for the call
    throw Test_Exception("xxx");
}

    
/**
 * @brief [PRO] fct/normal: normal composition 
 */
void normal_composition(Test_Data & test_data) 
{
    // a test_suite with all variations which are offered by the macros of test_case_cstr.hpp
    TEST_BUILD_TEST_SYSTEM("test_suite");
    TEST_NORMAL_CASE(Test_Function_Object(0),LEVEL_PROD);
    TEST_NORMAL_CASE(Test_Function_Object(1),LEVEL_DEBUG);
    TEST_NORMAL_CASE(Test_Function_Object(2),LEVEL_AUDIT);
    TEST_ABNORMAL_CASE(Test_Function_Object(3),LEVEL_PROD);
    TEST_ABNORMAL_CASE(Test_Function_Object(4),LEVEL_DEBUG);
    TEST_ABNORMAL_CASE(Test_Function_Object(5),LEVEL_AUDIT);
    TEST_NONFCT_CASE(Test_Function_Object(6),10);

    // all debug levels with all matching mask
    TEST_ASSERT(test_data.compare("list_all",dump_test_suite(test_suite,"/*",LEVEL_TEST)));
    TEST_ASSERT(test_data.compare("list_audit",dump_test_suite(test_suite,"/*",LEVEL_AUDIT)));
    TEST_ASSERT(test_data.compare("list_debug",dump_test_suite(test_suite,"/*",LEVEL_DEBUG)));
    TEST_ASSERT(test_data.compare("list_prod",dump_test_suite(test_suite,"/*",LEVEL_PROD)));

    // LEVEL_TEST with all subbranches
    TEST_ASSERT(test_data.compare("list_fct",dump_test_suite(test_suite,"/*/fct/*",LEVEL_TEST)));
    TEST_ASSERT(test_data.compare("list_fct_normal",dump_test_suite(test_suite,"/*/fct/normal/*",LEVEL_TEST)));
    TEST_ASSERT(test_data.compare("list_fct_abnormal",dump_test_suite(test_suite,"/*/fct/abnormal/*",LEVEL_TEST)));
    TEST_ASSERT(test_data.compare("list_nonfct",dump_test_suite(test_suite,"/*/nonfct/*",LEVEL_TEST)));

    // an intersection
    TEST_ASSERT(test_data.compare("list_fct_abnormal_deb",dump_test_suite(test_suite,"/*/fct/abnormal/*",LEVEL_DEBUG)));

    // an empty intersection
    TEST_ASSERT(test_data.compare("list_nonfct_deb",dump_test_suite(test_suite,"/*/nonfct/*",LEVEL_DEBUG)));

    // adding same test twice -- but in different suites is not very sensible, but allowed.
    TEST_ABNORMAL_CASE(Test_Function_Object(0),LEVEL_PROD);
    TEST_NONFCT_CASE(Test_Function_Object(3),0);
    TEST_NORMAL_CASE(Test_Function_Object(6),LEVEL_DEBUG);

    // listing all again
    TEST_ASSERT(test_data.compare("list_all_expanded",dump_test_suite(test_suite,"/*",LEVEL_TEST)));
}

/**
 * @brief [PRO] fct/abnormal: erronous composition (double names, negative timeout)
 */
void erronous_composition_attempts(Test_Data & test_data) 
{
    // a test_suite with all variations which are offered by the macros of test_case_cstr.hpp
    // same as in normal_composition.
    TEST_BUILD_TEST_SYSTEM("test_suite");
    TEST_NORMAL_CASE(Test_Function_Object(0),LEVEL_PROD);
    TEST_NORMAL_CASE(Test_Function_Object(1),LEVEL_DEBUG);
    TEST_NORMAL_CASE(Test_Function_Object(2),LEVEL_AUDIT);
    TEST_ABNORMAL_CASE(Test_Function_Object(3),LEVEL_PROD);
    TEST_ABNORMAL_CASE(Test_Function_Object(4),LEVEL_DEBUG);
    TEST_ABNORMAL_CASE(Test_Function_Object(5),LEVEL_AUDIT);
    TEST_NONFCT_CASE(Test_Function_Object(6),10);

    // all debug levels with all matching mask
    TEST_ASSERT(test_data.compare("list_all",dump_test_suite(test_suite,"/*",LEVEL_TEST)));

    // adding into normal again
    TEST_THROWING_BLOCK_ENTER;
    TEST_NORMAL_CASE(Test_Function_Object(0),LEVEL_PROD);
    TEST_THROWING_BLOCK_EXIT(Test_System_Exception);

    // adding into abnormal again
    TEST_THROWING_BLOCK_ENTER;
    TEST_ABNORMAL_CASE(Test_Function_Object(3),LEVEL_PROD);
    TEST_THROWING_BLOCK_EXIT(Test_System_Exception);

    // adding into nonfct again
    TEST_THROWING_BLOCK_ENTER;
    TEST_NONFCT_CASE(Test_Function_Object(6),10);
    TEST_THROWING_BLOCK_EXIT(Test_System_Exception);

    // adding with negative timeout
    TEST_THROWING_BLOCK_ENTER;
    TEST_NONFCT_CASE(Test_Function_Object(6),-1);
    TEST_THROWING_BLOCK_EXIT(Test_System_Exception);

    // all debug levels with all matching mask -- same string -- id
    TEST_ASSERT(test_data.compare("list_all",dump_test_suite(test_suite,"/*",LEVEL_TEST)));
}


TEST_COMPONENT_TEST_NAMESPACE_END;
TEST_NAMESPACE_END;
UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;

TEST_SUITE_BEGIN;
TEST_NORMAL_CASE(&normal_composition,LEVEL_PROD);
TEST_ABNORMAL_CASE(&erronous_composition_attempts,LEVEL_PROD);
TEST_SUITE_END;

STREAM_TEST_SYSTEM_MAIN;
// vim:ts=4:sw=4
