/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/unittest/stream_test_system_main.cpp
 *
 * @brief [LEVEL: beta] implementation of @ref diagnostics::unittest::Stream_Test_System_Main
 *
 * $Id: stream_test_system_main.cpp,v 1.5 2005/06/23 09:54:24 esdentem Exp $
 * 
 * @author Christian Schallhart
 */

#include <diagnostics/unittest/stream_test_system_main.hpp>

#include <diagnostics/frame/logging_config.hpp>
#include <diagnostics/frame/logging_facility.hpp>
#include <diagnostics/frame/logging_config_exception.hpp>
#include <diagnostics/logger/intending_file_logger.hpp>

#include <diagnostics/unittest/test_exception.hpp>

#include <diagnostics/unittest/test_system/stream_test_system.hpp>

#include <fstream>
#include <string>

DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;

void Stream_Test_System_Main::set_initial_loggers(::std::vector<Logger *> & loggers) 
{ 
    loggers.push_back(new Intending_File_Logger("test/diagnostic.log")); 
} 


int Stream_Test_System_Main::main(int const argc,char const * const * const argv,int const debug_level,
								  Test_Suite* (*build_test_suite_ptr)()) 
{
    int result(0);
    try {
		Logging_Config::init();
		
		char const * result_log_file_name("test/result.log");
		char const * test_data_file_name("test/test.dat");
		
		
		Stream_Test_System test_system(static_cast<Level_t>(debug_level), 
									   argc,argv,
									   test_data_file_name,
									   result_log_file_name,
									   ::std::cin,
									   ::std::cout); 
		test_system.add((*build_test_suite_ptr)()); 
		result=test_system.run(); 

	} 
    catch(::diagnostics::Exception & e) { 
		DIAGNOSTICS_PANIC_LOG(::std::string("EXCEPTION=\"")+e.name()+"\" WHAT=\""+e.what()+"\"");
		DIAGNOSTICS_BASE_LOG(LEVEL_PROD,TYPE_UNEXPECTED_EXCEPTION,0,
							 ::std::string("EXCEPTION=\"")+e.name()+"\" WHAT=\""+e.what()+"\"");
		result=-1;
    }
    catch(...) { 
		DIAGNOSTICS_PANIC_LOG("Unknown Exception");
		DIAGNOSTICS_BASE_LOG(LEVEL_PROD,TYPE_UNEXPECTED_EXCEPTION,0,"");
		result=-1;
    }
    return result; 
}


UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;

// vim:ts=4:sw=4
