/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.service.trust;

import android.annotation.IntDef;
import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcelable;

import com.android.internal.util.DataClass;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * Result type for a callback in a call to
 * {@link TrustAgentService#grantTrust(CharSequence, long, int)}.
 *
 * @hide
 */
@DataClass
@SystemApi
public final class GrantTrustResult implements Parcelable {

    /** Result status is unknown to this version of the SDK. */
    public static final int STATUS_UNKNOWN = 0;

    /** The device went from locked to unlocked as a result of the call. */
    public static final int STATUS_UNLOCKED_BY_GRANT = 1;

    /** The status code of the result. */
    @Status
    private int mStatus;



    // Code below generated by codegen v1.0.23.
    //
    // DO NOT MODIFY!
    // CHECKSTYLE:OFF Generated code
    //
    // To regenerate run:
    // $ codegen $ANDROID_BUILD_TOP/frameworks/base/core/java/android/service/trust/GrantTrustResult.java
    //
    // To exclude the generated code from IntelliJ auto-formatting enable (one-time):
    //   Settings > Editor > Code Style > Formatter Control
    //@formatter:off


    /** @hide */
    @IntDef(prefix = "STATUS_", value = {
        STATUS_UNKNOWN,
        STATUS_UNLOCKED_BY_GRANT
    })
    @Retention(RetentionPolicy.SOURCE)
    @DataClass.Generated.Member
    public @interface Status {}

    @NonNull
    @DataClass.Generated.Member
    public static String statusToString(@Status int value) {
        switch (value) {
            case STATUS_UNKNOWN:
                    return "STATUS_UNKNOWN";
            case STATUS_UNLOCKED_BY_GRANT:
                    return "STATUS_UNLOCKED_BY_GRANT";
            default: return Integer.toHexString(value);
        }
    }

    /**
     * Creates a new GrantTrustResult.
     *
     * @param status
     *   The status code of the result.
     */
    @DataClass.Generated.Member
    public GrantTrustResult(
            @Status int status) {
        this.mStatus = status;

        if (!(mStatus == STATUS_UNKNOWN)
                && !(mStatus == STATUS_UNLOCKED_BY_GRANT)) {
            throw new java.lang.IllegalArgumentException(
                    "status was " + mStatus + " but must be one of: "
                            + "STATUS_UNKNOWN(" + STATUS_UNKNOWN + "), "
                            + "STATUS_UNLOCKED_BY_GRANT(" + STATUS_UNLOCKED_BY_GRANT + ")");
        }


        // onConstructed(); // You can define this method to get a callback
    }

    /**
     * The status code of the result.
     */
    @DataClass.Generated.Member
    public @Status int getStatus() {
        return mStatus;
    }

    @Override
    @DataClass.Generated.Member
    public void writeToParcel(@NonNull android.os.Parcel dest, int flags) {
        // You can override field parcelling by defining methods like:
        // void parcelFieldName(Parcel dest, int flags) { ... }

        dest.writeInt(mStatus);
    }

    @Override
    @DataClass.Generated.Member
    public int describeContents() { return 0; }

    /** @hide */
    @SuppressWarnings({"unchecked", "RedundantCast"})
    @DataClass.Generated.Member
    /* package-private */ GrantTrustResult(@NonNull android.os.Parcel in) {
        // You can override field unparcelling by defining methods like:
        // static FieldType unparcelFieldName(Parcel in) { ... }

        int status = in.readInt();

        this.mStatus = status;

        if (!(mStatus == STATUS_UNKNOWN)
                && !(mStatus == STATUS_UNLOCKED_BY_GRANT)) {
            throw new java.lang.IllegalArgumentException(
                    "status was " + mStatus + " but must be one of: "
                            + "STATUS_UNKNOWN(" + STATUS_UNKNOWN + "), "
                            + "STATUS_UNLOCKED_BY_GRANT(" + STATUS_UNLOCKED_BY_GRANT + ")");
        }


        // onConstructed(); // You can define this method to get a callback
    }

    @DataClass.Generated.Member
    public static final @NonNull Parcelable.Creator<GrantTrustResult> CREATOR
            = new Parcelable.Creator<GrantTrustResult>() {
        @Override
        public GrantTrustResult[] newArray(int size) {
            return new GrantTrustResult[size];
        }

        @Override
        public GrantTrustResult createFromParcel(@NonNull android.os.Parcel in) {
            return new GrantTrustResult(in);
        }
    };

    @DataClass.Generated(
            time = 1648138312806L,
            codegenVersion = "1.0.23",
            sourceFile = "frameworks/base/core/java/android/service/trust/GrantTrustResult.java",
            inputSignatures = "public static final  int STATUS_UNKNOWN\npublic static final  int STATUS_UNLOCKED_BY_GRANT\nprivate @android.service.trust.GrantTrustResult.Status int mStatus\nclass GrantTrustResult extends java.lang.Object implements [android.os.Parcelable]\n@com.android.internal.util.DataClass")
    @Deprecated
    private void __metadata() {}


    //@formatter:on
    // End of generated code

}
