// Source: https://github.com/atlassian/react-beautiful-dnd

import { canScrollWindow } from './can-scroll';
import getScroll from './get-scroll';
export default (function (_ref) {
  var viewport = _ref.viewport,
    center = _ref.center,
    dragStartTime = _ref.dragStartTime,
    shouldUseTimeDampening = _ref.shouldUseTimeDampening;
  var scroll = getScroll({
    dragStartTime: dragStartTime,
    container: viewport.container,
    center: center,
    shouldUseTimeDampening: shouldUseTimeDampening
  });
  return scroll && canScrollWindow(viewport, scroll) ? scroll : null;
});