/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth;

import com.oracle.bmc.Region;
import com.oracle.bmc.auth.AuthCachingPolicy;
import com.oracle.bmc.auth.ResourcePrincipalAuthenticationDetailsProvider;
import com.oracle.bmc.auth.SessionKeySupplier;
import com.oracle.bmc.auth.internal.DefaultLeafRptPathProvider;
import com.oracle.bmc.auth.internal.FederationClient;
import com.oracle.bmc.auth.internal.ResourcePrincipalsV3FederationClient;
import com.oracle.bmc.util.internal.StringUtils;
import com.oracle.bmc.util.internal.Validate;

@AuthCachingPolicy(cacheKeyId=false, cachePrivateKey=false)
public class ResourcePrincipalsV3AuthenticationDetailsProvider
extends ResourcePrincipalAuthenticationDetailsProvider {
    private static final String OCI_RESOURCE_PRINCIPAL_VERSION_FOR_LEAF_RESOURCE = "OCI_RESOURCE_PRINCIPAL_VERSION_FOR_LEAF_RESOURCE";
    private static final String OCI_RESOURCE_PRINCIPAL_RPT_ENDPOINT_FOR_LEAF_RESOURCE = "OCI_RESOURCE_PRINCIPAL_RPT_ENDPOINT_FOR_LEAF_RESOURCE";
    private static final String OCI_RESOURCE_PRINCIPAL_RPST_ENDPOINT_FOR_LEAF_RESOURCE = "OCI_RESOURCE_PRINCIPAL_RPST_ENDPOINT_FOR_LEAF_RESOURCE";
    private static final String RP_VERSION_1_1 = "1.1";
    private static final String OCI_RESOURCE_PRINCIPAL_RESOURCE_ID_FOR_LEAF_RESOURCE = "OCI_RESOURCE_PRINCIPAL_RESOURCE_ID_FOR_LEAF_RESOURCE";
    private static final String OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM_FOR_LEAF_RESOURCE = "OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM_FOR_LEAF_RESOURCE";
    private static final String OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM_PASSPHRASE_FOR_LEAF_RESOURCE = "OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM_PASSPHRASE_FOR_LEAF_RESOURCE";
    private static final String OCI_RESOURCE_PRINCIPAL_RPST_FOR_LEAF_RESOURCE = "OCI_RESOURCE_PRINCIPAL_RPST_FOR_LEAF_RESOURCE";
    private static final String OCI_RESOURCE_PRINCIPAL_REGION_FOR_LEAF_RESOURCE = "OCI_RESOURCE_PRINCIPAL_REGION_FOR_LEAF_RESOURCE";
    private static final String OCI_RESOURCE_PRINCIPAL_RPT_URL_FOR_PARENT_RESOURCE = "OCI_RESOURCE_PRINCIPAL_RPT_URL_FOR_PARENT_RESOURCE";
    private static final String OCI_RESOURCE_PRINCIPAL_RPST_ENDPOINT_FOR_PARENT_RESOURCE = "OCI_RESOURCE_PRINCIPAL_RPST_ENDPOINT_FOR_PARENT_RESOURCE";
    private static final String OCI_RESOURCE_PRINCIPAL_TENANCY_ID_FOR_LEAF_RESOURCE = "OCI_RESOURCE_PRINCIPAL_TENANCY_ID_FOR_LEAF_RESOURCE";
    private static final String RP_DEBUG_INFORMATION_LOG = "\nResource principals authentication can only be used in certain OCI services. Please check that the OCI service you're running this code from supports Resource principals.\nSee https://docs.oracle.com/en-us/iaas/Content/API/Concepts/sdk_authentication_methods.htm#sdk_authentication_methods_resource_principal for more info.";

    ResourcePrincipalsV3AuthenticationDetailsProvider(FederationClient federationClient, SessionKeySupplier sessionKeySupplier, Region region) {
        super(federationClient, sessionKeySupplier, region);
    }

    public static ResourcePrincipalsV3AuthenticationDetailsProviderBuilder builder() {
        return new ResourcePrincipalsV3AuthenticationDetailsProviderBuilder();
    }

    @Override
    public String refresh() {
        return this.federationClient.refreshAndGetSecurityToken();
    }

    public static class ResourcePrincipalsV3AuthenticationDetailsProviderBuilder
    extends ResourcePrincipalAuthenticationDetailsProvider.ResourcePrincipalAuthenticationDetailsProviderBuilder {
        private String resourcePrincipalTokenUrlForParentResource;
        private String federationEndpointForParentResource;

        public ResourcePrincipalsV3AuthenticationDetailsProviderBuilder resourcePrincipalTokenUrlForParentResource(String resourcePrincipalTokenUrlForParentResource) {
            this.resourcePrincipalTokenUrlForParentResource = resourcePrincipalTokenUrlForParentResource;
            return this;
        }

        public ResourcePrincipalsV3AuthenticationDetailsProviderBuilder federationEndpointForParentResource(String federationEndpointForParentResource) {
            this.federationEndpointForParentResource = federationEndpointForParentResource;
            return this;
        }

        @Override
        public ResourcePrincipalsV3AuthenticationDetailsProvider build() {
            String ociResourcePrincipalVersionForLeafResource = System.getenv(ResourcePrincipalsV3AuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_VERSION_FOR_LEAF_RESOURCE);
            if (StringUtils.isBlank(ociResourcePrincipalVersionForLeafResource)) {
                throw new IllegalArgumentException("OCI_RESOURCE_PRINCIPAL_VERSION_FOR_LEAF_RESOURCE environment variable missing");
            }
            ResourcePrincipalAuthenticationDetailsProvider leafResourceAuthProvider = null;
            switch (ociResourcePrincipalVersionForLeafResource) {
                case "1.1": {
                    String ociResourcePrincipalRptEndpointForLeafResource = System.getenv(ResourcePrincipalsV3AuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_RPT_ENDPOINT_FOR_LEAF_RESOURCE);
                    String ociResourcePrincipalRpstEndpointForLeafResource = System.getenv(ResourcePrincipalsV3AuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_RPST_ENDPOINT_FOR_LEAF_RESOURCE);
                    leafResourceAuthProvider = this.build_1_1(ociResourcePrincipalRptEndpointForLeafResource, ociResourcePrincipalRpstEndpointForLeafResource);
                    break;
                }
                case "2.1": 
                case "2.1.1": {
                    String ociResourcePrincipalRptEndpointForLeafResourceFor2_1_or_2_1_1 = System.getenv(ResourcePrincipalsV3AuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_RPT_ENDPOINT_FOR_LEAF_RESOURCE);
                    String ociResourcePrincipalRpstEndpointForLeafResourceFor2_1_or_2_1_1 = System.getenv(ResourcePrincipalsV3AuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_RPST_ENDPOINT_FOR_LEAF_RESOURCE);
                    String ociResourcePrincipalResourceIdForLeafResource = System.getenv(ResourcePrincipalsV3AuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_RESOURCE_ID_FOR_LEAF_RESOURCE);
                    String ociResourcePrincipalTenancyIdForLeafResource = System.getenv(ResourcePrincipalsV3AuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_TENANCY_ID_FOR_LEAF_RESOURCE);
                    String ociResourcePrincipalPrivateKeyForLeafResource = System.getenv(ResourcePrincipalsV3AuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM_FOR_LEAF_RESOURCE);
                    String ociResourcePrincipalPassphraseForLeafResource = System.getenv(ResourcePrincipalsV3AuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM_PASSPHRASE_FOR_LEAF_RESOURCE);
                    leafResourceAuthProvider = this.build_2_1_or_2_1_1(ociResourcePrincipalRptEndpointForLeafResourceFor2_1_or_2_1_1, ociResourcePrincipalRpstEndpointForLeafResourceFor2_1_or_2_1_1, ociResourcePrincipalResourceIdForLeafResource, ociResourcePrincipalTenancyIdForLeafResource, ociResourcePrincipalPrivateKeyForLeafResource, ociResourcePrincipalPassphraseForLeafResource, ociResourcePrincipalVersionForLeafResource);
                    break;
                }
                case "2.2": {
                    String ociResourcePrincipalPrivateKey = System.getenv(ResourcePrincipalsV3AuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM_FOR_LEAF_RESOURCE);
                    String ociResourcePrincipalPassphrase = System.getenv(ResourcePrincipalsV3AuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM_PASSPHRASE_FOR_LEAF_RESOURCE);
                    String ociResourcePrincipalRpst = System.getenv(ResourcePrincipalsV3AuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_RPST_FOR_LEAF_RESOURCE);
                    String ociResourcePrincipalRegion = System.getenv(ResourcePrincipalsV3AuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_REGION_FOR_LEAF_RESOURCE);
                    String inputType = "environment variable";
                    leafResourceAuthProvider = this.build_2_2_leaf(ociResourcePrincipalPrivateKey, ociResourcePrincipalPassphrase, ociResourcePrincipalRpst, ociResourcePrincipalRegion, "environment variable");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("OCI_RESOURCE_PRINCIPAL_VERSION_FOR_LEAF_RESOURCE has unknown value.\nResource principals authentication can only be used in certain OCI services. Please check that the OCI service you're running this code from supports Resource principals.\nSee https://docs.oracle.com/en-us/iaas/Content/API/Concepts/sdk_authentication_methods.htm#sdk_authentication_methods_resource_principal for more info.");
                }
            }
            return this.build(leafResourceAuthProvider);
        }

        public ResourcePrincipalAuthenticationDetailsProvider build_2_2_leaf(String ociResourcePrincipalPrivateKey, String ociResourcePrincipalPassphrase, String ociResourcePrincipalRpst, String ociResourcePrincipalRegion, String inputType) {
            this.sessionKeySupplier = ResourcePrincipalAuthenticationDetailsProvider.getSessionKeySupplierFromPemAndPassphrase(ociResourcePrincipalPrivateKey, ociResourcePrincipalPassphrase, inputType);
            this.federationClient = ResourcePrincipalAuthenticationDetailsProvider.getFederationClientFromRpst(ociResourcePrincipalRpst, inputType, this.sessionKeySupplier);
            this.region = ResourcePrincipalsV3AuthenticationDetailsProvider.getRegion(ociResourcePrincipalRegion, inputType);
            return new ResourcePrincipalAuthenticationDetailsProvider(this.federationClient, this.sessionKeySupplier, this.region);
        }

        public ResourcePrincipalsV3AuthenticationDetailsProvider build(ResourcePrincipalAuthenticationDetailsProvider leafResourceAuthProvider) {
            String ociResourcePrincipalRptUrlForParentResource = System.getenv(ResourcePrincipalsV3AuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_RPT_URL_FOR_PARENT_RESOURCE);
            this.resourcePrincipalTokenUrlForParentResource = this.resourcePrincipalTokenUrlForParentResource != null ? this.resourcePrincipalTokenUrlForParentResource : ociResourcePrincipalRptUrlForParentResource;
            Validate.notNull(this.resourcePrincipalTokenUrlForParentResource, "resourcePrincipalTokenUrlForParentResource must not be null", new Object[0]);
            String ociResourcePrincipalRpstEndpointForParentResource = System.getenv(ResourcePrincipalsV3AuthenticationDetailsProvider.OCI_RESOURCE_PRINCIPAL_RPST_ENDPOINT_FOR_PARENT_RESOURCE);
            String string = this.federationEndpointForParentResource = this.federationEndpointForParentResource != null ? this.federationEndpointForParentResource : ociResourcePrincipalRpstEndpointForParentResource;
            if (this.federationEndpointForParentResource == null) {
                this.federationEndpointForParentResource = this.autoDetectEndpointUsingMetadataUrl();
            }
            FederationClient federationClientForParentResource = this.createFederationClientForParentResource(leafResourceAuthProvider);
            return new ResourcePrincipalsV3AuthenticationDetailsProvider(federationClientForParentResource, this.sessionKeySupplier, this.region);
        }

        private FederationClient createFederationClientForParentResource(ResourcePrincipalAuthenticationDetailsProvider leafResourceAuthProvider) {
            return new ResourcePrincipalsV3FederationClient(this.resourcePrincipalTokenUrlForParentResource, this.federationEndpointForParentResource, this.sessionKeySupplier, leafResourceAuthProvider, this.federationClientConfigurator, this.circuitBreakerConfig);
        }

        @Override
        protected void createRptPathProvider() {
            Validate.notNull(this.resourcePrincipalTokenEndpoint, "resourcePrincipalTokenEndpoint for leaf-resource must not be null", new Object[0]);
            if (this.resourcePrincipalTokenPathProvider == null) {
                this.resourcePrincipalTokenPathProvider = new DefaultLeafRptPathProvider();
            }
        }
    }
}

