/*
 * Simulator of microcontrollers (simz80.cc)
 *
 * Copyright (C) 1999,99 Drotos Daniel, Talker Bt.
 * 
 * To contact author send email to drdani@mazsola.iit.uni-miskolc.hu
 *
 */

/* This file is part of microcontroller simulator: ucsim.

UCSIM is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

UCSIM is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with UCSIM; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA. */
/*@1@*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "globals.h"

// local
#include "glob.h"
#include "simz80cl.h"
#include "gb80cl.h"
#include "lr35902cl.h"
#include "ez80cl.h"

cl_simz80::cl_simz80(class cl_app *the_app):
  cl_sim(the_app)
{}

class cl_uc *
cl_simz80::mk_controller(void)
{
  int i;
  const char *typ= NULL;
  class cl_optref type_option(this);

  type_option.init();
  type_option.use("cpu_type");
  i= 0;
  if ((typ= type_option.get_value(typ)) == NULL)
    typ= "Z80";

  while ((cpus_z80[i].type_str != NULL) &&
	 (strcmp(typ, cpus_z80[i].type_str) != 0))
    i++;
  if (cpus_z80[i].type_str == NULL)
    {
      fprintf(stderr, "Unknown processor type. "
	      "Use -H option to see known types.\n");
      return(NULL);
    }

  switch (cpus_z80[i].type)
    {
    case CPU_Z80:
    case CPU_Z180:
    case CPU_Z80N:
      return(new cl_z80(&cpus_z80[i], this));
    // Add Rabbits, etc here.

    case CPU_R2K:
    case CPU_R3KA:
      {
	printf("\nTo simulate Rabbit use ucsim_rxk\n");
	return NULL;
      }
      
    case CPU_LR35902:
      return(new cl_lr35902(&cpus_z80[i], this));
    case CPU_GB80:
      return(new cl_gb80(&cpus_z80[i], this));

    case CPU_EZ80:
      return(new cl_ez80(&cpus_z80[i], this));
      
    default:
      return NULL;
    }

  return(NULL);
}


/* End of z80.src/simz80.cc */
