/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser.detail.constants;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import org.gjt.jclasslib.browser.config.window.BrowserPath;
import org.gjt.jclasslib.browser.config.window.CategoryHolder;
import org.gjt.jclasslib.browser.config.window.ReferenceHolder;
import org.gjt.jclasslib.browser.detail.constants.AbstractConstantInfoDetailPane;
import org.gjt.jclasslib.structures.CPInfo;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.constants.ConstantClassInfo;
import org.gjt.jclasslib.structures.constants.ConstantFieldrefInfo;
import org.gjt.jclasslib.structures.constants.ConstantInterfaceMethodrefInfo;
import org.gjt.jclasslib.structures.constants.ConstantMethodrefInfo;
import org.gjt.jclasslib.structures.constants.ConstantNameAndTypeInfo;
import org.gjt.jclasslib.structures.constants.ConstantReference;

public class ClassElementOpener
implements ActionListener {
    private JButton btnShow;
    private CPInfo cpInfo;
    private AbstractConstantInfoDetailPane detailPane;

    public ClassElementOpener(AbstractConstantInfoDetailPane abstractConstantInfoDetailPane) {
        this.detailPane = abstractConstantInfoDetailPane;
        this.btnShow = new JButton("Show");
        this.btnShow.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object;
            ConstantClassInfo constantClassInfo = null;
            BrowserPath browserPath = null;
            if (this.cpInfo instanceof ConstantClassInfo) {
                constantClassInfo = (ConstantClassInfo)this.cpInfo;
            } else if (this.cpInfo instanceof ConstantReference) {
                object = (ConstantReference)this.cpInfo;
                ConstantNameAndTypeInfo constantNameAndTypeInfo = ((ConstantReference)object).getNameAndTypeInfo();
                constantClassInfo = ((ConstantReference)object).getClassInfo();
                String string = null;
                if (this.cpInfo instanceof ConstantFieldrefInfo) {
                    string = "field";
                } else if (this.cpInfo instanceof ConstantMethodrefInfo || this.cpInfo instanceof ConstantInterfaceMethodrefInfo) {
                    string = "method";
                }
                if (string != null) {
                    browserPath = new BrowserPath();
                    browserPath.addPathComponent(new CategoryHolder(string));
                    browserPath.addPathComponent(new ReferenceHolder(constantNameAndTypeInfo.getName(), constantNameAndTypeInfo.getDescriptor()));
                }
            }
            if (constantClassInfo == null) {
                return;
            }
            object = constantClassInfo.getName().replace('/', '.');
            this.detailPane.getBrowserServices().openClassFile((String)object, browserPath);
        }
        catch (InvalidByteCodeException invalidByteCodeException) {
            invalidByteCodeException.printStackTrace();
        }
    }

    public int addSpecial(AbstractConstantInfoDetailPane abstractConstantInfoDetailPane, int n) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        abstractConstantInfoDetailPane.add((Component)this.btnShow, gridBagConstraints);
        return 1;
    }

    public void setCPInfo(CPInfo cPInfo) {
        this.cpInfo = cPInfo;
        String string = null;
        if (cPInfo instanceof ConstantClassInfo) {
            string = "Show class";
            try {
                if (((ConstantClassInfo)cPInfo).getName().equals(this.detailPane.getBrowserServices().getClassFile().getThisClassName())) {
                    string = null;
                }
            }
            catch (InvalidByteCodeException invalidByteCodeException) {}
        } else if (cPInfo instanceof ConstantFieldrefInfo) {
            string = "Show field";
        } else if (cPInfo instanceof ConstantMethodrefInfo) {
            string = "Show method";
        } else if (cPInfo instanceof ConstantInterfaceMethodrefInfo) {
            string = "Show interface method";
        }
        if (string != null) {
            this.btnShow.setVisible(true);
            this.btnShow.setText(string);
        } else {
            this.btnShow.setVisible(false);
        }
    }
}

