// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/support/v2/case_service.proto

#include "google/cloud/support/v2/case_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace support_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CaseServiceClient::CaseServiceClient(
    std::shared_ptr<CaseServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
CaseServiceClient::~CaseServiceClient() = default;

StatusOr<google::cloud::support::v2::Case> CaseServiceClient::GetCase(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::support::v2::GetCaseRequest request;
  request.set_name(name);
  return connection_->GetCase(request);
}

StatusOr<google::cloud::support::v2::Case> CaseServiceClient::GetCase(
    google::cloud::support::v2::GetCaseRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetCase(request);
}

StreamRange<google::cloud::support::v2::Case> CaseServiceClient::ListCases(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::support::v2::ListCasesRequest request;
  request.set_parent(parent);
  return connection_->ListCases(request);
}

StreamRange<google::cloud::support::v2::Case> CaseServiceClient::ListCases(
    google::cloud::support::v2::ListCasesRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListCases(std::move(request));
}

StreamRange<google::cloud::support::v2::Case> CaseServiceClient::SearchCases(
    google::cloud::support::v2::SearchCasesRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SearchCases(std::move(request));
}

StatusOr<google::cloud::support::v2::Case> CaseServiceClient::CreateCase(
    std::string const& parent, google::cloud::support::v2::Case const& case_,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::support::v2::CreateCaseRequest request;
  request.set_parent(parent);
  *request.mutable_case_() = case_;
  return connection_->CreateCase(request);
}

StatusOr<google::cloud::support::v2::Case> CaseServiceClient::CreateCase(
    google::cloud::support::v2::CreateCaseRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateCase(request);
}

StatusOr<google::cloud::support::v2::Case> CaseServiceClient::UpdateCase(
    google::cloud::support::v2::Case const& case_,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::support::v2::UpdateCaseRequest request;
  *request.mutable_case_() = case_;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateCase(request);
}

StatusOr<google::cloud::support::v2::Case> CaseServiceClient::UpdateCase(
    google::cloud::support::v2::UpdateCaseRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateCase(request);
}

StatusOr<google::cloud::support::v2::Case> CaseServiceClient::EscalateCase(
    google::cloud::support::v2::EscalateCaseRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->EscalateCase(request);
}

StatusOr<google::cloud::support::v2::Case> CaseServiceClient::CloseCase(
    google::cloud::support::v2::CloseCaseRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CloseCase(request);
}

StreamRange<google::cloud::support::v2::CaseClassification>
CaseServiceClient::SearchCaseClassifications(
    google::cloud::support::v2::SearchCaseClassificationsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SearchCaseClassifications(std::move(request));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace support_v2
}  // namespace cloud
}  // namespace google
