// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/storagetransfer/v1/transfer.proto

#include "google/cloud/storagetransfer/v1/internal/storage_transfer_option_defaults.h"
#include "google/cloud/storagetransfer/v1/storage_transfer_connection.h"
#include "google/cloud/storagetransfer/v1/storage_transfer_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>

namespace google {
namespace cloud {
namespace storagetransfer_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options StorageTransferServiceDefaultOptions(Options options) {
  options = google::cloud::internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_STORAGE_TRANSFER_SERVICE_ENDPOINT",
      "", "GOOGLE_CLOUD_CPP_STORAGE_TRANSFER_SERVICE_AUTHORITY",
      "storagetransfer.googleapis.com");
  options =
      google::cloud::internal::PopulateGrpcOptions(std::move(options), "");
  if (!options.has<
          storagetransfer_v1::StorageTransferServiceRetryPolicyOption>()) {
    options.set<storagetransfer_v1::StorageTransferServiceRetryPolicyOption>(
        storagetransfer_v1::StorageTransferServiceLimitedTimeRetryPolicy(
            std::chrono::minutes(30))
            .clone());
  }
  if (!options.has<
          storagetransfer_v1::StorageTransferServiceBackoffPolicyOption>()) {
    options.set<storagetransfer_v1::StorageTransferServiceBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options.has<
          storagetransfer_v1::StorageTransferServicePollingPolicyOption>()) {
    options.set<storagetransfer_v1::StorageTransferServicePollingPolicyOption>(
        GenericPollingPolicy<
            storagetransfer_v1::StorageTransferServiceRetryPolicyOption::Type,
            storagetransfer_v1::StorageTransferServiceBackoffPolicyOption::
                Type>(
            options
                .get<storagetransfer_v1::
                         StorageTransferServiceRetryPolicyOption>()
                ->clone(),
            ExponentialBackoffPolicy(std::chrono::seconds(1),
                                     std::chrono::minutes(5), kBackoffScaling)
                .clone())
            .clone());
  }
  if (!options.has<
          storagetransfer_v1::
              StorageTransferServiceConnectionIdempotencyPolicyOption>()) {
    options.set<storagetransfer_v1::
                    StorageTransferServiceConnectionIdempotencyPolicyOption>(
        storagetransfer_v1::
            MakeDefaultStorageTransferServiceConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace storagetransfer_v1_internal
}  // namespace cloud
}  // namespace google
