// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/security/privateca/v1/service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_PRIVATECA_V1_MOCKS_MOCK_CERTIFICATE_AUTHORITY_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_PRIVATECA_V1_MOCKS_MOCK_CERTIFICATE_AUTHORITY_CONNECTION_H

#include "google/cloud/privateca/v1/certificate_authority_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace privateca_v1_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * A class to mock `CertificateAuthorityServiceConnection`.
 *
 * Application developers may want to test their code with simulated responses,
 * including errors, from an object of type `CertificateAuthorityServiceClient`.
 * To do so, construct an object of type `CertificateAuthorityServiceClient`
 * with an instance of this class. Then use the Google Test framework functions
 * to program the behavior of this mock.
 *
 * @see [This example][bq-mock] for how to test your application with GoogleTest.
 * While the example showcases types from the BigQuery library, the underlying
 * principles apply for any pair of `*Client` and `*Connection`.
 *
 * [bq-mock]: @cloud_cpp_docs_link{bigquery,bigquery-read-mock}
 */
class MockCertificateAuthorityServiceConnection
    : public privateca_v1::CertificateAuthorityServiceConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  MOCK_METHOD(
      StatusOr<google::cloud::security::privateca::v1::Certificate>,
      CreateCertificate,
      (google::cloud::security::privateca::v1::CreateCertificateRequest const&
           request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::security::privateca::v1::Certificate>,
      GetCertificate,
      (google::cloud::security::privateca::v1::GetCertificateRequest const&
           request),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::security::privateca::v1::Certificate>),
      ListCertificates,
      (google::cloud::security::privateca::v1::ListCertificatesRequest request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::security::privateca::v1::Certificate>,
      RevokeCertificate,
      (google::cloud::security::privateca::v1::RevokeCertificateRequest const&
           request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::security::privateca::v1::Certificate>,
      UpdateCertificate,
      (google::cloud::security::privateca::v1::UpdateCertificateRequest const&
           request),
      (override));

  MOCK_METHOD(
      future<StatusOr<
          google::cloud::security::privateca::v1::CertificateAuthority>>,
      ActivateCertificateAuthority,
      (google::cloud::security::privateca::v1::
           ActivateCertificateAuthorityRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<
          google::cloud::security::privateca::v1::CertificateAuthority>>,
      CreateCertificateAuthority,
      (google::cloud::security::privateca::v1::
           CreateCertificateAuthorityRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<
          google::cloud::security::privateca::v1::CertificateAuthority>>,
      DisableCertificateAuthority,
      (google::cloud::security::privateca::v1::
           DisableCertificateAuthorityRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<
          google::cloud::security::privateca::v1::CertificateAuthority>>,
      EnableCertificateAuthority,
      (google::cloud::security::privateca::v1::
           EnableCertificateAuthorityRequest const& request),
      (override));

  MOCK_METHOD(StatusOr<google::cloud::security::privateca::v1::
                           FetchCertificateAuthorityCsrResponse>,
              FetchCertificateAuthorityCsr,
              (google::cloud::security::privateca::v1::
                   FetchCertificateAuthorityCsrRequest const& request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::security::privateca::v1::CertificateAuthority>,
      GetCertificateAuthority,
      (google::cloud::security::privateca::v1::
           GetCertificateAuthorityRequest const& request),
      (override));

  MOCK_METHOD(
      (StreamRange<
          google::cloud::security::privateca::v1::CertificateAuthority>),
      ListCertificateAuthorities,
      (google::cloud::security::privateca::v1::ListCertificateAuthoritiesRequest
           request),
      (override));

  MOCK_METHOD(
      future<StatusOr<
          google::cloud::security::privateca::v1::CertificateAuthority>>,
      UndeleteCertificateAuthority,
      (google::cloud::security::privateca::v1::
           UndeleteCertificateAuthorityRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<
          google::cloud::security::privateca::v1::CertificateAuthority>>,
      DeleteCertificateAuthority,
      (google::cloud::security::privateca::v1::
           DeleteCertificateAuthorityRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<
          google::cloud::security::privateca::v1::CertificateAuthority>>,
      UpdateCertificateAuthority,
      (google::cloud::security::privateca::v1::
           UpdateCertificateAuthorityRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::security::privateca::v1::CaPool>>,
      CreateCaPool,
      (google::cloud::security::privateca::v1::CreateCaPoolRequest const&
           request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::security::privateca::v1::CaPool>>,
      UpdateCaPool,
      (google::cloud::security::privateca::v1::UpdateCaPoolRequest const&
           request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::security::privateca::v1::CaPool>, GetCaPool,
      (google::cloud::security::privateca::v1::GetCaPoolRequest const& request),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::security::privateca::v1::CaPool>),
      ListCaPools,
      (google::cloud::security::privateca::v1::ListCaPoolsRequest request),
      (override));

  MOCK_METHOD(
      future<
          StatusOr<google::cloud::security::privateca::v1::OperationMetadata>>,
      DeleteCaPool,
      (google::cloud::security::privateca::v1::DeleteCaPoolRequest const&
           request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::security::privateca::v1::FetchCaCertsResponse>,
      FetchCaCerts,
      (google::cloud::security::privateca::v1::FetchCaCertsRequest const&
           request),
      (override));

  MOCK_METHOD(
      StatusOr<
          google::cloud::security::privateca::v1::CertificateRevocationList>,
      GetCertificateRevocationList,
      (google::cloud::security::privateca::v1::
           GetCertificateRevocationListRequest const& request),
      (override));

  MOCK_METHOD(
      (StreamRange<
          google::cloud::security::privateca::v1::CertificateRevocationList>),
      ListCertificateRevocationLists,
      (google::cloud::security::privateca::v1::
           ListCertificateRevocationListsRequest request),
      (override));

  MOCK_METHOD(
      future<StatusOr<
          google::cloud::security::privateca::v1::CertificateRevocationList>>,
      UpdateCertificateRevocationList,
      (google::cloud::security::privateca::v1::
           UpdateCertificateRevocationListRequest const& request),
      (override));

  MOCK_METHOD(future<StatusOr<
                  google::cloud::security::privateca::v1::CertificateTemplate>>,
              CreateCertificateTemplate,
              (google::cloud::security::privateca::v1::
                   CreateCertificateTemplateRequest const& request),
              (override));

  MOCK_METHOD(
      future<
          StatusOr<google::cloud::security::privateca::v1::OperationMetadata>>,
      DeleteCertificateTemplate,
      (google::cloud::security::privateca::v1::
           DeleteCertificateTemplateRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::security::privateca::v1::CertificateTemplate>,
      GetCertificateTemplate,
      (google::cloud::security::privateca::v1::
           GetCertificateTemplateRequest const& request),
      (override));

  MOCK_METHOD(
      (StreamRange<
          google::cloud::security::privateca::v1::CertificateTemplate>),
      ListCertificateTemplates,
      (google::cloud::security::privateca::v1::ListCertificateTemplatesRequest
           request),
      (override));

  MOCK_METHOD(future<StatusOr<
                  google::cloud::security::privateca::v1::CertificateTemplate>>,
              UpdateCertificateTemplate,
              (google::cloud::security::privateca::v1::
                   UpdateCertificateTemplateRequest const& request),
              (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace privateca_v1_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_PRIVATECA_V1_MOCKS_MOCK_CERTIFICATE_AUTHORITY_CONNECTION_H
