// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/oslogin/v1/oslogin.proto

#include "google/cloud/oslogin/v1/internal/os_login_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include <memory>

namespace google {
namespace cloud {
namespace oslogin_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

OsLoginServiceTracingConnection::OsLoginServiceTracingConnection(
    std::shared_ptr<oslogin_v1::OsLoginServiceConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::oslogin::common::SshPublicKey>
OsLoginServiceTracingConnection::CreateSshPublicKey(
    google::cloud::oslogin::v1::CreateSshPublicKeyRequest const& request) {
  auto span = internal::MakeSpan(
      "oslogin_v1::OsLoginServiceConnection::CreateSshPublicKey");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateSshPublicKey(request));
}

Status OsLoginServiceTracingConnection::DeletePosixAccount(
    google::cloud::oslogin::v1::DeletePosixAccountRequest const& request) {
  auto span = internal::MakeSpan(
      "oslogin_v1::OsLoginServiceConnection::DeletePosixAccount");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeletePosixAccount(request));
}

Status OsLoginServiceTracingConnection::DeleteSshPublicKey(
    google::cloud::oslogin::v1::DeleteSshPublicKeyRequest const& request) {
  auto span = internal::MakeSpan(
      "oslogin_v1::OsLoginServiceConnection::DeleteSshPublicKey");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteSshPublicKey(request));
}

StatusOr<google::cloud::oslogin::v1::LoginProfile>
OsLoginServiceTracingConnection::GetLoginProfile(
    google::cloud::oslogin::v1::GetLoginProfileRequest const& request) {
  auto span = internal::MakeSpan(
      "oslogin_v1::OsLoginServiceConnection::GetLoginProfile");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetLoginProfile(request));
}

StatusOr<google::cloud::oslogin::common::SshPublicKey>
OsLoginServiceTracingConnection::GetSshPublicKey(
    google::cloud::oslogin::v1::GetSshPublicKeyRequest const& request) {
  auto span = internal::MakeSpan(
      "oslogin_v1::OsLoginServiceConnection::GetSshPublicKey");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetSshPublicKey(request));
}

StatusOr<google::cloud::oslogin::v1::ImportSshPublicKeyResponse>
OsLoginServiceTracingConnection::ImportSshPublicKey(
    google::cloud::oslogin::v1::ImportSshPublicKeyRequest const& request) {
  auto span = internal::MakeSpan(
      "oslogin_v1::OsLoginServiceConnection::ImportSshPublicKey");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->ImportSshPublicKey(request));
}

StatusOr<google::cloud::oslogin::common::SshPublicKey>
OsLoginServiceTracingConnection::UpdateSshPublicKey(
    google::cloud::oslogin::v1::UpdateSshPublicKeyRequest const& request) {
  auto span = internal::MakeSpan(
      "oslogin_v1::OsLoginServiceConnection::UpdateSshPublicKey");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateSshPublicKey(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<oslogin_v1::OsLoginServiceConnection>
MakeOsLoginServiceTracingConnection(
    std::shared_ptr<oslogin_v1::OsLoginServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<OsLoginServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace oslogin_v1_internal
}  // namespace cloud
}  // namespace google
