// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/osconfig/v1/osconfig_service.proto

#include "google/cloud/osconfig/v1/internal/os_config_connection_impl.h"
#include "google/cloud/osconfig/v1/internal/os_config_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace osconfig_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<osconfig_v1::OsConfigServiceRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<osconfig_v1::OsConfigServiceRetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<osconfig_v1::OsConfigServiceBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<osconfig_v1::OsConfigServiceConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<osconfig_v1::OsConfigServiceConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

OsConfigServiceConnectionImpl::OsConfigServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<osconfig_v1_internal::OsConfigServiceStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      OsConfigServiceConnection::options())) {}

StatusOr<google::cloud::osconfig::v1::PatchJob>
OsConfigServiceConnectionImpl::ExecutePatchJob(
    google::cloud::osconfig::v1::ExecutePatchJobRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ExecutePatchJob(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::osconfig::v1::ExecutePatchJobRequest const& request) {
        return stub_->ExecutePatchJob(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::osconfig::v1::PatchJob>
OsConfigServiceConnectionImpl::GetPatchJob(
    google::cloud::osconfig::v1::GetPatchJobRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetPatchJob(request),
      [this](grpc::ClientContext& context,
             google::cloud::osconfig::v1::GetPatchJobRequest const& request) {
        return stub_->GetPatchJob(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::osconfig::v1::PatchJob>
OsConfigServiceConnectionImpl::CancelPatchJob(
    google::cloud::osconfig::v1::CancelPatchJobRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CancelPatchJob(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::osconfig::v1::CancelPatchJobRequest const& request) {
        return stub_->CancelPatchJob(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::osconfig::v1::PatchJob>
OsConfigServiceConnectionImpl::ListPatchJobs(
    google::cloud::osconfig::v1::ListPatchJobsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListPatchJobs(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::osconfig::v1::PatchJob>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<osconfig_v1::OsConfigServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::osconfig::v1::ListPatchJobsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::osconfig::v1::ListPatchJobsRequest const&
                       request) {
              return stub->ListPatchJobs(context, request);
            },
            r, function_name);
      },
      [](google::cloud::osconfig::v1::ListPatchJobsResponse r) {
        std::vector<google::cloud::osconfig::v1::PatchJob> result(
            r.patch_jobs().size());
        auto& messages = *r.mutable_patch_jobs();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StreamRange<google::cloud::osconfig::v1::PatchJobInstanceDetails>
OsConfigServiceConnectionImpl::ListPatchJobInstanceDetails(
    google::cloud::osconfig::v1::ListPatchJobInstanceDetailsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListPatchJobInstanceDetails(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::osconfig::v1::PatchJobInstanceDetails>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<osconfig_v1::OsConfigServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::osconfig::v1::ListPatchJobInstanceDetailsRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::osconfig::v1::
                       ListPatchJobInstanceDetailsRequest const& request) {
              return stub->ListPatchJobInstanceDetails(context, request);
            },
            r, function_name);
      },
      [](google::cloud::osconfig::v1::ListPatchJobInstanceDetailsResponse r) {
        std::vector<google::cloud::osconfig::v1::PatchJobInstanceDetails>
            result(r.patch_job_instance_details().size());
        auto& messages = *r.mutable_patch_job_instance_details();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::osconfig::v1::PatchDeployment>
OsConfigServiceConnectionImpl::CreatePatchDeployment(
    google::cloud::osconfig::v1::CreatePatchDeploymentRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreatePatchDeployment(request),
      [this](grpc::ClientContext& context,
             google::cloud::osconfig::v1::CreatePatchDeploymentRequest const&
                 request) {
        return stub_->CreatePatchDeployment(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::osconfig::v1::PatchDeployment>
OsConfigServiceConnectionImpl::GetPatchDeployment(
    google::cloud::osconfig::v1::GetPatchDeploymentRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetPatchDeployment(request),
      [this](grpc::ClientContext& context,
             google::cloud::osconfig::v1::GetPatchDeploymentRequest const&
                 request) {
        return stub_->GetPatchDeployment(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::osconfig::v1::PatchDeployment>
OsConfigServiceConnectionImpl::ListPatchDeployments(
    google::cloud::osconfig::v1::ListPatchDeploymentsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency =
      idempotency_policy(*current)->ListPatchDeployments(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::osconfig::v1::PatchDeployment>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<osconfig_v1::OsConfigServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::osconfig::v1::ListPatchDeploymentsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::osconfig::v1::ListPatchDeploymentsRequest const&
                    request) {
              return stub->ListPatchDeployments(context, request);
            },
            r, function_name);
      },
      [](google::cloud::osconfig::v1::ListPatchDeploymentsResponse r) {
        std::vector<google::cloud::osconfig::v1::PatchDeployment> result(
            r.patch_deployments().size());
        auto& messages = *r.mutable_patch_deployments();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

Status OsConfigServiceConnectionImpl::DeletePatchDeployment(
    google::cloud::osconfig::v1::DeletePatchDeploymentRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeletePatchDeployment(request),
      [this](grpc::ClientContext& context,
             google::cloud::osconfig::v1::DeletePatchDeploymentRequest const&
                 request) {
        return stub_->DeletePatchDeployment(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::osconfig::v1::PatchDeployment>
OsConfigServiceConnectionImpl::UpdatePatchDeployment(
    google::cloud::osconfig::v1::UpdatePatchDeploymentRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdatePatchDeployment(request),
      [this](grpc::ClientContext& context,
             google::cloud::osconfig::v1::UpdatePatchDeploymentRequest const&
                 request) {
        return stub_->UpdatePatchDeployment(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::osconfig::v1::PatchDeployment>
OsConfigServiceConnectionImpl::PausePatchDeployment(
    google::cloud::osconfig::v1::PausePatchDeploymentRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->PausePatchDeployment(request),
      [this](grpc::ClientContext& context,
             google::cloud::osconfig::v1::PausePatchDeploymentRequest const&
                 request) {
        return stub_->PausePatchDeployment(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::osconfig::v1::PatchDeployment>
OsConfigServiceConnectionImpl::ResumePatchDeployment(
    google::cloud::osconfig::v1::ResumePatchDeploymentRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ResumePatchDeployment(request),
      [this](grpc::ClientContext& context,
             google::cloud::osconfig::v1::ResumePatchDeploymentRequest const&
                 request) {
        return stub_->ResumePatchDeployment(context, request);
      },
      request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace osconfig_v1_internal
}  // namespace cloud
}  // namespace google
