// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/notebooks/v1/service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NOTEBOOKS_V1_NOTEBOOK_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NOTEBOOKS_V1_NOTEBOOK_CONNECTION_H

#include "google/cloud/notebooks/v1/internal/notebook_retry_traits.h"
#include "google/cloud/notebooks/v1/notebook_connection_idempotency_policy.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/cloud/notebooks/v1/service.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace notebooks_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `NotebookServiceConnection`.
class NotebookServiceRetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<NotebookServiceRetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `NotebookServiceConnection` based on counting errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class NotebookServiceLimitedErrorCountRetryPolicy
    : public NotebookServiceRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit NotebookServiceLimitedErrorCountRetryPolicy(int maximum_failures)
      : impl_(maximum_failures) {}

  NotebookServiceLimitedErrorCountRetryPolicy(
      NotebookServiceLimitedErrorCountRetryPolicy&& rhs) noexcept
      : NotebookServiceLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}
  NotebookServiceLimitedErrorCountRetryPolicy(
      NotebookServiceLimitedErrorCountRetryPolicy const& rhs) noexcept
      : NotebookServiceLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<NotebookServiceRetryPolicy> clone() const override {
    return std::make_unique<NotebookServiceLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = NotebookServiceRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      notebooks_v1_internal::NotebookServiceRetryTraits>
      impl_;
};

/**
 * A retry policy for `NotebookServiceConnection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class NotebookServiceLimitedTimeRetryPolicy
    : public NotebookServiceRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit NotebookServiceLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  NotebookServiceLimitedTimeRetryPolicy(
      NotebookServiceLimitedTimeRetryPolicy&& rhs) noexcept
      : NotebookServiceLimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  NotebookServiceLimitedTimeRetryPolicy(
      NotebookServiceLimitedTimeRetryPolicy const& rhs) noexcept
      : NotebookServiceLimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<NotebookServiceRetryPolicy> clone() const override {
    return std::make_unique<NotebookServiceLimitedTimeRetryPolicy>(
        maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = NotebookServiceRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      notebooks_v1_internal::NotebookServiceRetryTraits>
      impl_;
};

/**
 * The `NotebookServiceConnection` object for `NotebookServiceClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `NotebookServiceClient`. This allows users to inject custom behavior
 * (e.g., with a Google Mock object) when writing tests that use objects of type
 * `NotebookServiceClient`.
 *
 * To create a concrete instance, see `MakeNotebookServiceConnection()`.
 *
 * For mocking, see `notebooks_v1_mocks::MockNotebookServiceConnection`.
 */
class NotebookServiceConnection {
 public:
  virtual ~NotebookServiceConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual StreamRange<google::cloud::notebooks::v1::Instance> ListInstances(
      google::cloud::notebooks::v1::ListInstancesRequest request);

  virtual StatusOr<google::cloud::notebooks::v1::Instance> GetInstance(
      google::cloud::notebooks::v1::GetInstanceRequest const& request);

  virtual future<StatusOr<google::cloud::notebooks::v1::Instance>>
  CreateInstance(
      google::cloud::notebooks::v1::CreateInstanceRequest const& request);

  virtual future<StatusOr<google::cloud::notebooks::v1::Instance>>
  RegisterInstance(
      google::cloud::notebooks::v1::RegisterInstanceRequest const& request);

  virtual future<StatusOr<google::cloud::notebooks::v1::Instance>>
  SetInstanceAccelerator(
      google::cloud::notebooks::v1::SetInstanceAcceleratorRequest const&
          request);

  virtual future<StatusOr<google::cloud::notebooks::v1::Instance>>
  SetInstanceMachineType(
      google::cloud::notebooks::v1::SetInstanceMachineTypeRequest const&
          request);

  virtual future<StatusOr<google::cloud::notebooks::v1::Instance>>
  UpdateInstanceConfig(
      google::cloud::notebooks::v1::UpdateInstanceConfigRequest const& request);

  virtual future<StatusOr<google::cloud::notebooks::v1::Instance>>
  UpdateShieldedInstanceConfig(
      google::cloud::notebooks::v1::UpdateShieldedInstanceConfigRequest const&
          request);

  virtual future<StatusOr<google::cloud::notebooks::v1::Instance>>
  SetInstanceLabels(
      google::cloud::notebooks::v1::SetInstanceLabelsRequest const& request);

  virtual StatusOr<
      google::cloud::notebooks::v1::UpdateInstanceMetadataItemsResponse>
  UpdateInstanceMetadataItems(
      google::cloud::notebooks::v1::UpdateInstanceMetadataItemsRequest const&
          request);

  virtual future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
  DeleteInstance(
      google::cloud::notebooks::v1::DeleteInstanceRequest const& request);

  virtual future<StatusOr<google::cloud::notebooks::v1::Instance>>
  StartInstance(
      google::cloud::notebooks::v1::StartInstanceRequest const& request);

  virtual future<StatusOr<google::cloud::notebooks::v1::Instance>> StopInstance(
      google::cloud::notebooks::v1::StopInstanceRequest const& request);

  virtual future<StatusOr<google::cloud::notebooks::v1::Instance>>
  ResetInstance(
      google::cloud::notebooks::v1::ResetInstanceRequest const& request);

  virtual future<StatusOr<google::cloud::notebooks::v1::Instance>>
  ReportInstanceInfo(
      google::cloud::notebooks::v1::ReportInstanceInfoRequest const& request);

  virtual StatusOr<google::cloud::notebooks::v1::IsInstanceUpgradeableResponse>
  IsInstanceUpgradeable(
      google::cloud::notebooks::v1::IsInstanceUpgradeableRequest const&
          request);

  virtual StatusOr<google::cloud::notebooks::v1::GetInstanceHealthResponse>
  GetInstanceHealth(
      google::cloud::notebooks::v1::GetInstanceHealthRequest const& request);

  virtual future<StatusOr<google::cloud::notebooks::v1::Instance>>
  UpgradeInstance(
      google::cloud::notebooks::v1::UpgradeInstanceRequest const& request);

  virtual future<StatusOr<google::cloud::notebooks::v1::Instance>>
  RollbackInstance(
      google::cloud::notebooks::v1::RollbackInstanceRequest const& request);

  virtual future<StatusOr<google::cloud::notebooks::v1::Instance>>
  DiagnoseInstance(
      google::cloud::notebooks::v1::DiagnoseInstanceRequest const& request);

  virtual future<StatusOr<google::cloud::notebooks::v1::Instance>>
  UpgradeInstanceInternal(
      google::cloud::notebooks::v1::UpgradeInstanceInternalRequest const&
          request);

  virtual StreamRange<google::cloud::notebooks::v1::Environment>
  ListEnvironments(
      google::cloud::notebooks::v1::ListEnvironmentsRequest request);

  virtual StatusOr<google::cloud::notebooks::v1::Environment> GetEnvironment(
      google::cloud::notebooks::v1::GetEnvironmentRequest const& request);

  virtual future<StatusOr<google::cloud::notebooks::v1::Environment>>
  CreateEnvironment(
      google::cloud::notebooks::v1::CreateEnvironmentRequest const& request);

  virtual future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
  DeleteEnvironment(
      google::cloud::notebooks::v1::DeleteEnvironmentRequest const& request);

  virtual StreamRange<google::cloud::notebooks::v1::Schedule> ListSchedules(
      google::cloud::notebooks::v1::ListSchedulesRequest request);

  virtual StatusOr<google::cloud::notebooks::v1::Schedule> GetSchedule(
      google::cloud::notebooks::v1::GetScheduleRequest const& request);

  virtual future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
  DeleteSchedule(
      google::cloud::notebooks::v1::DeleteScheduleRequest const& request);

  virtual future<StatusOr<google::cloud::notebooks::v1::Schedule>>
  CreateSchedule(
      google::cloud::notebooks::v1::CreateScheduleRequest const& request);

  virtual future<StatusOr<google::cloud::notebooks::v1::Schedule>>
  TriggerSchedule(
      google::cloud::notebooks::v1::TriggerScheduleRequest const& request);

  virtual StreamRange<google::cloud::notebooks::v1::Execution> ListExecutions(
      google::cloud::notebooks::v1::ListExecutionsRequest request);

  virtual StatusOr<google::cloud::notebooks::v1::Execution> GetExecution(
      google::cloud::notebooks::v1::GetExecutionRequest const& request);

  virtual future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
  DeleteExecution(
      google::cloud::notebooks::v1::DeleteExecutionRequest const& request);

  virtual future<StatusOr<google::cloud::notebooks::v1::Execution>>
  CreateExecution(
      google::cloud::notebooks::v1::CreateExecutionRequest const& request);
};

/**
 * A factory function to construct an object of type
 * `NotebookServiceConnection`.
 *
 * The returned connection object should not be used directly; instead it
 * should be passed as an argument to the constructor of NotebookServiceClient.
 *
 * The optional @p options argument may be used to configure aspects of the
 * returned `NotebookServiceConnection`. Expected options are any of the types
 * in the following option lists:
 *
 * - `google::cloud::CommonOptionList`
 * - `google::cloud::GrpcOptionList`
 * - `google::cloud::UnifiedCredentialsOptionList`
 * - `google::cloud::notebooks_v1::NotebookServicePolicyOptionList`
 *
 * @note Unexpected options will be ignored. To log unexpected options instead,
 *     set `GOOGLE_CLOUD_CPP_ENABLE_CLOG=yes` in the environment.
 *
 * @param options (optional) Configure the `NotebookServiceConnection` created
 * by this function.
 */
std::shared_ptr<NotebookServiceConnection> MakeNotebookServiceConnection(
    Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace notebooks_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NOTEBOOKS_V1_NOTEBOOK_CONNECTION_H
