// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/notebooks/v1/service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NOTEBOOKS_V1_NOTEBOOK_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NOTEBOOKS_V1_NOTEBOOK_CLIENT_H

#include "google/cloud/notebooks/v1/notebook_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>

namespace google {
namespace cloud {
namespace notebooks_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// API v1 service for Cloud AI Platform Notebooks.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class NotebookServiceClient {
 public:
  explicit NotebookServiceClient(
      std::shared_ptr<NotebookServiceConnection> connection, Options opts = {});
  ~NotebookServiceClient();

  ///@{
  /// @name Copy and move support
  NotebookServiceClient(NotebookServiceClient const&) = default;
  NotebookServiceClient& operator=(NotebookServiceClient const&) = default;
  NotebookServiceClient(NotebookServiceClient&&) = default;
  NotebookServiceClient& operator=(NotebookServiceClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(NotebookServiceClient const& a,
                         NotebookServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(NotebookServiceClient const& a,
                         NotebookServiceClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Lists instances in a given project and location.
  ///
  /// @param parent  Required. Format:
  ///  `parent=projects/{project_id}/locations/{location}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.notebooks.v1.Instance], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.Instance]: @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  /// [google.cloud.notebooks.v1.ListInstancesRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L452}
  ///
  // clang-format on
  StreamRange<google::cloud::notebooks::v1::Instance> ListInstances(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists instances in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.ListInstancesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.notebooks.v1.Instance], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.Instance]: @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  /// [google.cloud.notebooks.v1.ListInstancesRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L452}
  ///
  // clang-format on
  StreamRange<google::cloud::notebooks::v1::Instance> ListInstances(
      google::cloud::notebooks::v1::ListInstancesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single Instance.
  ///
  /// @param name  Required. Format:
  ///  `projects/{project_id}/locations/{location}/instances/{instance_id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.notebooks.v1.Instance])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.GetInstanceRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L481}
  /// [google.cloud.notebooks.v1.Instance]: @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  ///
  // clang-format on
  StatusOr<google::cloud::notebooks::v1::Instance> GetInstance(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single Instance.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.GetInstanceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.notebooks.v1.Instance])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.GetInstanceRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L481}
  /// [google.cloud.notebooks.v1.Instance]: @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  ///
  // clang-format on
  StatusOr<google::cloud::notebooks::v1::Instance> GetInstance(
      google::cloud::notebooks::v1::GetInstanceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new Instance in a given project and location.
  ///
  /// @param parent  Required. Format:
  ///  `parent=projects/{project_id}/locations/{location}`
  /// @param instance  Required. The instance to be created.
  /// @param instance_id  Required. User-defined unique ID of this instance.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Instance] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.CreateInstanceRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L488}
  /// [google.cloud.notebooks.v1.Instance]: @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Instance>> CreateInstance(
      std::string const& parent,
      google::cloud::notebooks::v1::Instance const& instance,
      std::string const& instance_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new Instance in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.CreateInstanceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Instance] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.CreateInstanceRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L488}
  /// [google.cloud.notebooks.v1.Instance]: @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Instance>> CreateInstance(
      google::cloud::notebooks::v1::CreateInstanceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Registers an existing legacy notebook instance to the Notebooks API server.
  /// Legacy instances are instances created with the legacy Compute Engine
  /// calls. They are not manageable by the Notebooks API out of the box. This
  /// call makes these instances manageable by the Notebooks API.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.RegisterInstanceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Instance] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.Instance]: @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  /// [google.cloud.notebooks.v1.RegisterInstanceRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L501}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Instance>> RegisterInstance(
      google::cloud::notebooks::v1::RegisterInstanceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates the guest accelerators of a single Instance.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.SetInstanceAcceleratorRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Instance] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.Instance]: @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  /// [google.cloud.notebooks.v1.SetInstanceAcceleratorRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L514}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Instance>>
  SetInstanceAccelerator(
      google::cloud::notebooks::v1::SetInstanceAcceleratorRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates the machine type of a single Instance.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.SetInstanceMachineTypeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Instance] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.Instance]: @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  /// [google.cloud.notebooks.v1.SetInstanceMachineTypeRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L530}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Instance>>
  SetInstanceMachineType(
      google::cloud::notebooks::v1::SetInstanceMachineTypeRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Update Notebook Instance configurations.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.UpdateInstanceConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Instance] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.Instance]: @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  /// [google.cloud.notebooks.v1.UpdateInstanceConfigRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L541}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Instance>> UpdateInstanceConfig(
      google::cloud::notebooks::v1::UpdateInstanceConfigRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates the Shielded instance configuration of a single Instance.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.UpdateShieldedInstanceConfigRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Instance] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.Instance]: @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  /// [google.cloud.notebooks.v1.UpdateShieldedInstanceConfigRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L579}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Instance>>
  UpdateShieldedInstanceConfig(
      google::cloud::notebooks::v1::UpdateShieldedInstanceConfigRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Replaces all the labels of an Instance.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.SetInstanceLabelsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Instance] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.Instance]: @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  /// [google.cloud.notebooks.v1.SetInstanceLabelsRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L551}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Instance>> SetInstanceLabels(
      google::cloud::notebooks::v1::SetInstanceLabelsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Add/update metadata items for an instance.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.UpdateInstanceMetadataItemsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.notebooks.v1.UpdateInstanceMetadataItemsResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.UpdateInstanceMetadataItemsRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L562}
  /// [google.cloud.notebooks.v1.UpdateInstanceMetadataItemsResponse]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L572}
  ///
  // clang-format on
  StatusOr<google::cloud::notebooks::v1::UpdateInstanceMetadataItemsResponse>
  UpdateInstanceMetadataItems(
      google::cloud::notebooks::v1::UpdateInstanceMetadataItemsRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a single Instance.
  ///
  /// @param name  Required. Format:
  ///  `projects/{project_id}/locations/{location}/instances/{instance_id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.DeleteInstanceRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L589}
  /// [google.cloud.notebooks.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L422}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
  DeleteInstance(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single Instance.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.DeleteInstanceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.DeleteInstanceRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L589}
  /// [google.cloud.notebooks.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L422}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
  DeleteInstance(
      google::cloud::notebooks::v1::DeleteInstanceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Starts a notebook instance.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.StartInstanceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Instance] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.Instance]: @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  /// [google.cloud.notebooks.v1.StartInstanceRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L596}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Instance>> StartInstance(
      google::cloud::notebooks::v1::StartInstanceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Stops a notebook instance.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.StopInstanceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Instance] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.Instance]: @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  /// [google.cloud.notebooks.v1.StopInstanceRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L603}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Instance>> StopInstance(
      google::cloud::notebooks::v1::StopInstanceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Resets a notebook instance.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.ResetInstanceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Instance] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.Instance]: @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  /// [google.cloud.notebooks.v1.ResetInstanceRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L610}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Instance>> ResetInstance(
      google::cloud::notebooks::v1::ResetInstanceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Allows notebook instances to
  /// report their latest instance information to the Notebooks
  /// API server. The server will merge the reported information to
  /// the instance metadata store. Do not use this method directly.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.ReportInstanceInfoRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Instance] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.Instance]: @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  /// [google.cloud.notebooks.v1.ReportInstanceInfoRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L617}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Instance>> ReportInstanceInfo(
      google::cloud::notebooks::v1::ReportInstanceInfoRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Check if a notebook instance is upgradable.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.IsInstanceUpgradeableRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.notebooks.v1.IsInstanceUpgradeableResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.IsInstanceUpgradeableRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L632}
  /// [google.cloud.notebooks.v1.IsInstanceUpgradeableResponse]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L643}
  ///
  // clang-format on
  StatusOr<google::cloud::notebooks::v1::IsInstanceUpgradeableResponse>
  IsInstanceUpgradeable(
      google::cloud::notebooks::v1::IsInstanceUpgradeableRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Check if a notebook instance is healthy.
  ///
  /// @param name  Required. Format:
  ///  `projects/{project_id}/locations/{location}/instances/{instance_id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.notebooks.v1.GetInstanceHealthResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.GetInstanceHealthRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L661}
  /// [google.cloud.notebooks.v1.GetInstanceHealthResponse]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L673}
  ///
  // clang-format on
  StatusOr<google::cloud::notebooks::v1::GetInstanceHealthResponse>
  GetInstanceHealth(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Check if a notebook instance is healthy.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.GetInstanceHealthRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.notebooks.v1.GetInstanceHealthResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.GetInstanceHealthRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L661}
  /// [google.cloud.notebooks.v1.GetInstanceHealthResponse]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L673}
  ///
  // clang-format on
  StatusOr<google::cloud::notebooks::v1::GetInstanceHealthResponse>
  GetInstanceHealth(
      google::cloud::notebooks::v1::GetInstanceHealthRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Upgrades a notebook instance to the latest version.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.UpgradeInstanceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Instance] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.Instance]: @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  /// [google.cloud.notebooks.v1.UpgradeInstanceRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L714}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Instance>> UpgradeInstance(
      google::cloud::notebooks::v1::UpgradeInstanceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Rollbacks a notebook instance to the previous version.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.RollbackInstanceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Instance] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.Instance]: @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  /// [google.cloud.notebooks.v1.RollbackInstanceRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L725}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Instance>> RollbackInstance(
      google::cloud::notebooks::v1::RollbackInstanceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a Diagnostic File and runs Diagnostic Tool given an Instance.
  ///
  /// @param name  Required. Format:
  ///  `projects/{project_id}/locations/{location}/instances/{instance_id}`
  /// @param diagnostic_config  Required. Defines flags that are used to run the diagnostic tool
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Instance] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.DiagnoseInstanceRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L764}
  /// [google.cloud.notebooks.v1.Instance]: @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Instance>> DiagnoseInstance(
      std::string const& name,
      google::cloud::notebooks::v1::DiagnosticConfig const& diagnostic_config,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a Diagnostic File and runs Diagnostic Tool given an Instance.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.DiagnoseInstanceRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Instance] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.DiagnoseInstanceRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L764}
  /// [google.cloud.notebooks.v1.Instance]: @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Instance>> DiagnoseInstance(
      google::cloud::notebooks::v1::DiagnoseInstanceRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Allows notebook instances to
  /// call this endpoint to upgrade themselves. Do not use this method directly.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.UpgradeInstanceInternalRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Instance] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.Instance]: @googleapis_reference_link{google/cloud/notebooks/v1/instance.proto#L61}
  /// [google.cloud.notebooks.v1.UpgradeInstanceInternalRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L736}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Instance>>
  UpgradeInstanceInternal(
      google::cloud::notebooks::v1::UpgradeInstanceInternalRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists environments in a project.
  ///
  /// @param parent  Required. Format: `projects/{project_id}/locations/{location}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.notebooks.v1.Environment], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.Environment]: @googleapis_reference_link{google/cloud/notebooks/v1/environment.proto#L33}
  /// [google.cloud.notebooks.v1.ListEnvironmentsRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L751}
  ///
  // clang-format on
  StreamRange<google::cloud::notebooks::v1::Environment> ListEnvironments(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists environments in a project.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.ListEnvironmentsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.notebooks.v1.Environment], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.Environment]: @googleapis_reference_link{google/cloud/notebooks/v1/environment.proto#L33}
  /// [google.cloud.notebooks.v1.ListEnvironmentsRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L751}
  ///
  // clang-format on
  StreamRange<google::cloud::notebooks::v1::Environment> ListEnvironments(
      google::cloud::notebooks::v1::ListEnvironmentsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single Environment.
  ///
  /// @param name  Required. Format:
  ///  `projects/{project_id}/locations/{location}/environments/{environment_id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.notebooks.v1.Environment])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.Environment]: @googleapis_reference_link{google/cloud/notebooks/v1/environment.proto#L33}
  /// [google.cloud.notebooks.v1.GetEnvironmentRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L792}
  ///
  // clang-format on
  StatusOr<google::cloud::notebooks::v1::Environment> GetEnvironment(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single Environment.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.GetEnvironmentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.notebooks.v1.Environment])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.Environment]: @googleapis_reference_link{google/cloud/notebooks/v1/environment.proto#L33}
  /// [google.cloud.notebooks.v1.GetEnvironmentRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L792}
  ///
  // clang-format on
  StatusOr<google::cloud::notebooks::v1::Environment> GetEnvironment(
      google::cloud::notebooks::v1::GetEnvironmentRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new Environment.
  ///
  /// @param parent  Required. Format: `projects/{project_id}/locations/{location}`
  /// @param environment  Required. The environment to be created.
  /// @param environment_id  Required. User-defined unique ID of this environment. The `environment_id` must
  ///  be 1 to 63 characters long and contain only lowercase letters,
  ///  numeric characters, and dashes. The first character must be a lowercase
  ///  letter and the last character cannot be a dash.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Environment] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.CreateEnvironmentRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L799}
  /// [google.cloud.notebooks.v1.Environment]: @googleapis_reference_link{google/cloud/notebooks/v1/environment.proto#L33}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Environment>> CreateEnvironment(
      std::string const& parent,
      google::cloud::notebooks::v1::Environment const& environment,
      std::string const& environment_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new Environment.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.CreateEnvironmentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Environment] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.CreateEnvironmentRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L799}
  /// [google.cloud.notebooks.v1.Environment]: @googleapis_reference_link{google/cloud/notebooks/v1/environment.proto#L33}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Environment>> CreateEnvironment(
      google::cloud::notebooks::v1::CreateEnvironmentRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a single Environment.
  ///
  /// @param name  Required. Format:
  ///  `projects/{project_id}/locations/{location}/environments/{environment_id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.DeleteEnvironmentRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L814}
  /// [google.cloud.notebooks.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L422}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
  DeleteEnvironment(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single Environment.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.DeleteEnvironmentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.DeleteEnvironmentRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L814}
  /// [google.cloud.notebooks.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L422}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
  DeleteEnvironment(
      google::cloud::notebooks::v1::DeleteEnvironmentRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists schedules in a given project and location.
  ///
  /// @param parent  Required. Format:
  ///  `parent=projects/{project_id}/locations/{location}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.notebooks.v1.Schedule], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.ListSchedulesRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L821}
  /// [google.cloud.notebooks.v1.Schedule]: @googleapis_reference_link{google/cloud/notebooks/v1/schedule.proto#L30}
  ///
  // clang-format on
  StreamRange<google::cloud::notebooks::v1::Schedule> ListSchedules(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists schedules in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.ListSchedulesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.notebooks.v1.Schedule], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.ListSchedulesRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L821}
  /// [google.cloud.notebooks.v1.Schedule]: @googleapis_reference_link{google/cloud/notebooks/v1/schedule.proto#L30}
  ///
  // clang-format on
  StreamRange<google::cloud::notebooks::v1::Schedule> ListSchedules(
      google::cloud::notebooks::v1::ListSchedulesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of schedule
  ///
  /// @param name  Required. Format:
  ///  `projects/{project_id}/locations/{location}/schedules/{schedule_id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.notebooks.v1.Schedule])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.GetScheduleRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L862}
  /// [google.cloud.notebooks.v1.Schedule]: @googleapis_reference_link{google/cloud/notebooks/v1/schedule.proto#L30}
  ///
  // clang-format on
  StatusOr<google::cloud::notebooks::v1::Schedule> GetSchedule(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of schedule
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.GetScheduleRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.notebooks.v1.Schedule])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.GetScheduleRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L862}
  /// [google.cloud.notebooks.v1.Schedule]: @googleapis_reference_link{google/cloud/notebooks/v1/schedule.proto#L30}
  ///
  // clang-format on
  StatusOr<google::cloud::notebooks::v1::Schedule> GetSchedule(
      google::cloud::notebooks::v1::GetScheduleRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes schedule and all underlying jobs
  ///
  /// @param name  Required. Format:
  ///  `projects/{project_id}/locations/{location}/schedules/{schedule_id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.DeleteScheduleRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L874}
  /// [google.cloud.notebooks.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L422}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
  DeleteSchedule(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes schedule and all underlying jobs
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.DeleteScheduleRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.DeleteScheduleRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L874}
  /// [google.cloud.notebooks.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L422}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
  DeleteSchedule(
      google::cloud::notebooks::v1::DeleteScheduleRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new Scheduled Notebook in a given project and location.
  ///
  /// @param parent  Required. Format:
  ///  `parent=projects/{project_id}/locations/{location}`
  /// @param schedule  Required. The schedule to be created.
  /// @param schedule_id  Required. User-defined unique ID of this schedule.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Schedule] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.CreateScheduleRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L886}
  /// [google.cloud.notebooks.v1.Schedule]: @googleapis_reference_link{google/cloud/notebooks/v1/schedule.proto#L30}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Schedule>> CreateSchedule(
      std::string const& parent,
      google::cloud::notebooks::v1::Schedule const& schedule,
      std::string const& schedule_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new Scheduled Notebook in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.CreateScheduleRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Schedule] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.CreateScheduleRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L886}
  /// [google.cloud.notebooks.v1.Schedule]: @googleapis_reference_link{google/cloud/notebooks/v1/schedule.proto#L30}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Schedule>> CreateSchedule(
      google::cloud::notebooks::v1::CreateScheduleRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Triggers execution of an existing schedule.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.TriggerScheduleRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Schedule] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.Schedule]: @googleapis_reference_link{google/cloud/notebooks/v1/schedule.proto#L30}
  /// [google.cloud.notebooks.v1.TriggerScheduleRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L904}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Schedule>> TriggerSchedule(
      google::cloud::notebooks::v1::TriggerScheduleRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists executions in a given project and location
  ///
  /// @param parent  Required. Format:
  ///  `parent=projects/{project_id}/locations/{location}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.notebooks.v1.Execution], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.Execution]: @googleapis_reference_link{google/cloud/notebooks/v1/execution.proto#L279}
  /// [google.cloud.notebooks.v1.ListExecutionsRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L916}
  ///
  // clang-format on
  StreamRange<google::cloud::notebooks::v1::Execution> ListExecutions(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists executions in a given project and location
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.ListExecutionsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.notebooks.v1.Execution], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.Execution]: @googleapis_reference_link{google/cloud/notebooks/v1/execution.proto#L279}
  /// [google.cloud.notebooks.v1.ListExecutionsRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L916}
  ///
  // clang-format on
  StreamRange<google::cloud::notebooks::v1::Execution> ListExecutions(
      google::cloud::notebooks::v1::ListExecutionsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of executions
  ///
  /// @param name  Required. Format:
  ///  `projects/{project_id}/locations/{location}/executions/{execution_id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.notebooks.v1.Execution])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.Execution]: @googleapis_reference_link{google/cloud/notebooks/v1/execution.proto#L279}
  /// [google.cloud.notebooks.v1.GetExecutionRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L959}
  ///
  // clang-format on
  StatusOr<google::cloud::notebooks::v1::Execution> GetExecution(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of executions
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.GetExecutionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.notebooks.v1.Execution])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.Execution]: @googleapis_reference_link{google/cloud/notebooks/v1/execution.proto#L279}
  /// [google.cloud.notebooks.v1.GetExecutionRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L959}
  ///
  // clang-format on
  StatusOr<google::cloud::notebooks::v1::Execution> GetExecution(
      google::cloud::notebooks::v1::GetExecutionRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes execution
  ///
  /// @param name  Required. Format:
  ///  `projects/{project_id}/locations/{location}/executions/{execution_id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.DeleteExecutionRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L971}
  /// [google.cloud.notebooks.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L422}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
  DeleteExecution(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes execution
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.DeleteExecutionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.DeleteExecutionRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L971}
  /// [google.cloud.notebooks.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L422}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
  DeleteExecution(
      google::cloud::notebooks::v1::DeleteExecutionRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new Execution in a given project and location.
  ///
  /// @param parent  Required. Format:
  ///  `parent=projects/{project_id}/locations/{location}`
  /// @param execution  Required. The execution to be created.
  /// @param execution_id  Required. User-defined unique ID of this execution.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Execution] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.CreateExecutionRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L983}
  /// [google.cloud.notebooks.v1.Execution]: @googleapis_reference_link{google/cloud/notebooks/v1/execution.proto#L279}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Execution>> CreateExecution(
      std::string const& parent,
      google::cloud::notebooks::v1::Execution const& execution,
      std::string const& execution_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new Execution in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.notebooks.v1.CreateExecutionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.notebooks.v1.Execution] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.notebooks.v1.CreateExecutionRequest]: @googleapis_reference_link{google/cloud/notebooks/v1/service.proto#L983}
  /// [google.cloud.notebooks.v1.Execution]: @googleapis_reference_link{google/cloud/notebooks/v1/execution.proto#L279}
  ///
  // clang-format on
  future<StatusOr<google::cloud::notebooks::v1::Execution>> CreateExecution(
      google::cloud::notebooks::v1::CreateExecutionRequest const& request,
      Options opts = {});

 private:
  std::shared_ptr<NotebookServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace notebooks_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NOTEBOOKS_V1_NOTEBOOK_CLIENT_H
