// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/notebooks/v1/service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NOTEBOOKS_V1_INTERNAL_NOTEBOOK_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NOTEBOOKS_V1_INTERNAL_NOTEBOOK_TRACING_CONNECTION_H

#include "google/cloud/notebooks/v1/notebook_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace notebooks_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class NotebookServiceTracingConnection
    : public notebooks_v1::NotebookServiceConnection {
 public:
  ~NotebookServiceTracingConnection() override = default;

  explicit NotebookServiceTracingConnection(
      std::shared_ptr<notebooks_v1::NotebookServiceConnection> child);

  Options options() override { return child_->options(); }

  StreamRange<google::cloud::notebooks::v1::Instance> ListInstances(
      google::cloud::notebooks::v1::ListInstancesRequest request) override;

  StatusOr<google::cloud::notebooks::v1::Instance> GetInstance(
      google::cloud::notebooks::v1::GetInstanceRequest const& request) override;

  future<StatusOr<google::cloud::notebooks::v1::Instance>> CreateInstance(
      google::cloud::notebooks::v1::CreateInstanceRequest const& request)
      override;

  future<StatusOr<google::cloud::notebooks::v1::Instance>> RegisterInstance(
      google::cloud::notebooks::v1::RegisterInstanceRequest const& request)
      override;

  future<StatusOr<google::cloud::notebooks::v1::Instance>>
  SetInstanceAccelerator(
      google::cloud::notebooks::v1::SetInstanceAcceleratorRequest const&
          request) override;

  future<StatusOr<google::cloud::notebooks::v1::Instance>>
  SetInstanceMachineType(
      google::cloud::notebooks::v1::SetInstanceMachineTypeRequest const&
          request) override;

  future<StatusOr<google::cloud::notebooks::v1::Instance>> UpdateInstanceConfig(
      google::cloud::notebooks::v1::UpdateInstanceConfigRequest const& request)
      override;

  future<StatusOr<google::cloud::notebooks::v1::Instance>>
  UpdateShieldedInstanceConfig(
      google::cloud::notebooks::v1::UpdateShieldedInstanceConfigRequest const&
          request) override;

  future<StatusOr<google::cloud::notebooks::v1::Instance>> SetInstanceLabels(
      google::cloud::notebooks::v1::SetInstanceLabelsRequest const& request)
      override;

  StatusOr<google::cloud::notebooks::v1::UpdateInstanceMetadataItemsResponse>
  UpdateInstanceMetadataItems(
      google::cloud::notebooks::v1::UpdateInstanceMetadataItemsRequest const&
          request) override;

  future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
  DeleteInstance(google::cloud::notebooks::v1::DeleteInstanceRequest const&
                     request) override;

  future<StatusOr<google::cloud::notebooks::v1::Instance>> StartInstance(
      google::cloud::notebooks::v1::StartInstanceRequest const& request)
      override;

  future<StatusOr<google::cloud::notebooks::v1::Instance>> StopInstance(
      google::cloud::notebooks::v1::StopInstanceRequest const& request)
      override;

  future<StatusOr<google::cloud::notebooks::v1::Instance>> ResetInstance(
      google::cloud::notebooks::v1::ResetInstanceRequest const& request)
      override;

  future<StatusOr<google::cloud::notebooks::v1::Instance>> ReportInstanceInfo(
      google::cloud::notebooks::v1::ReportInstanceInfoRequest const& request)
      override;

  StatusOr<google::cloud::notebooks::v1::IsInstanceUpgradeableResponse>
  IsInstanceUpgradeable(
      google::cloud::notebooks::v1::IsInstanceUpgradeableRequest const& request)
      override;

  StatusOr<google::cloud::notebooks::v1::GetInstanceHealthResponse>
  GetInstanceHealth(
      google::cloud::notebooks::v1::GetInstanceHealthRequest const& request)
      override;

  future<StatusOr<google::cloud::notebooks::v1::Instance>> UpgradeInstance(
      google::cloud::notebooks::v1::UpgradeInstanceRequest const& request)
      override;

  future<StatusOr<google::cloud::notebooks::v1::Instance>> RollbackInstance(
      google::cloud::notebooks::v1::RollbackInstanceRequest const& request)
      override;

  future<StatusOr<google::cloud::notebooks::v1::Instance>> DiagnoseInstance(
      google::cloud::notebooks::v1::DiagnoseInstanceRequest const& request)
      override;

  future<StatusOr<google::cloud::notebooks::v1::Instance>>
  UpgradeInstanceInternal(
      google::cloud::notebooks::v1::UpgradeInstanceInternalRequest const&
          request) override;

  StreamRange<google::cloud::notebooks::v1::Environment> ListEnvironments(
      google::cloud::notebooks::v1::ListEnvironmentsRequest request) override;

  StatusOr<google::cloud::notebooks::v1::Environment> GetEnvironment(
      google::cloud::notebooks::v1::GetEnvironmentRequest const& request)
      override;

  future<StatusOr<google::cloud::notebooks::v1::Environment>> CreateEnvironment(
      google::cloud::notebooks::v1::CreateEnvironmentRequest const& request)
      override;

  future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
  DeleteEnvironment(
      google::cloud::notebooks::v1::DeleteEnvironmentRequest const& request)
      override;

  StreamRange<google::cloud::notebooks::v1::Schedule> ListSchedules(
      google::cloud::notebooks::v1::ListSchedulesRequest request) override;

  StatusOr<google::cloud::notebooks::v1::Schedule> GetSchedule(
      google::cloud::notebooks::v1::GetScheduleRequest const& request) override;

  future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
  DeleteSchedule(google::cloud::notebooks::v1::DeleteScheduleRequest const&
                     request) override;

  future<StatusOr<google::cloud::notebooks::v1::Schedule>> CreateSchedule(
      google::cloud::notebooks::v1::CreateScheduleRequest const& request)
      override;

  future<StatusOr<google::cloud::notebooks::v1::Schedule>> TriggerSchedule(
      google::cloud::notebooks::v1::TriggerScheduleRequest const& request)
      override;

  StreamRange<google::cloud::notebooks::v1::Execution> ListExecutions(
      google::cloud::notebooks::v1::ListExecutionsRequest request) override;

  StatusOr<google::cloud::notebooks::v1::Execution> GetExecution(
      google::cloud::notebooks::v1::GetExecutionRequest const& request)
      override;

  future<StatusOr<google::cloud::notebooks::v1::OperationMetadata>>
  DeleteExecution(google::cloud::notebooks::v1::DeleteExecutionRequest const&
                      request) override;

  future<StatusOr<google::cloud::notebooks::v1::Execution>> CreateExecution(
      google::cloud::notebooks::v1::CreateExecutionRequest const& request)
      override;

 private:
  std::shared_ptr<notebooks_v1::NotebookServiceConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<notebooks_v1::NotebookServiceConnection>
MakeNotebookServiceTracingConnection(
    std::shared_ptr<notebooks_v1::NotebookServiceConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace notebooks_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NOTEBOOKS_V1_INTERNAL_NOTEBOOK_TRACING_CONNECTION_H
