// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkservices/v1/network_services.proto

#include "google/cloud/networkservices/v1/network_services_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace networkservices_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

NetworkServicesClient::NetworkServicesClient(
    std::shared_ptr<NetworkServicesConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
NetworkServicesClient::~NetworkServicesClient() = default;

StreamRange<google::cloud::networkservices::v1::EndpointPolicy>
NetworkServicesClient::ListEndpointPolicies(std::string const& parent,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::ListEndpointPoliciesRequest request;
  request.set_parent(parent);
  return connection_->ListEndpointPolicies(request);
}

StreamRange<google::cloud::networkservices::v1::EndpointPolicy>
NetworkServicesClient::ListEndpointPolicies(
    google::cloud::networkservices::v1::ListEndpointPoliciesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListEndpointPolicies(std::move(request));
}

StatusOr<google::cloud::networkservices::v1::EndpointPolicy>
NetworkServicesClient::GetEndpointPolicy(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::GetEndpointPolicyRequest request;
  request.set_name(name);
  return connection_->GetEndpointPolicy(request);
}

StatusOr<google::cloud::networkservices::v1::EndpointPolicy>
NetworkServicesClient::GetEndpointPolicy(
    google::cloud::networkservices::v1::GetEndpointPolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetEndpointPolicy(request);
}

future<StatusOr<google::cloud::networkservices::v1::EndpointPolicy>>
NetworkServicesClient::CreateEndpointPolicy(
    std::string const& parent,
    google::cloud::networkservices::v1::EndpointPolicy const& endpoint_policy,
    std::string const& endpoint_policy_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::CreateEndpointPolicyRequest request;
  request.set_parent(parent);
  *request.mutable_endpoint_policy() = endpoint_policy;
  request.set_endpoint_policy_id(endpoint_policy_id);
  return connection_->CreateEndpointPolicy(request);
}

future<StatusOr<google::cloud::networkservices::v1::EndpointPolicy>>
NetworkServicesClient::CreateEndpointPolicy(
    google::cloud::networkservices::v1::CreateEndpointPolicyRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateEndpointPolicy(request);
}

future<StatusOr<google::cloud::networkservices::v1::EndpointPolicy>>
NetworkServicesClient::UpdateEndpointPolicy(
    google::cloud::networkservices::v1::EndpointPolicy const& endpoint_policy,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::UpdateEndpointPolicyRequest request;
  *request.mutable_endpoint_policy() = endpoint_policy;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateEndpointPolicy(request);
}

future<StatusOr<google::cloud::networkservices::v1::EndpointPolicy>>
NetworkServicesClient::UpdateEndpointPolicy(
    google::cloud::networkservices::v1::UpdateEndpointPolicyRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateEndpointPolicy(request);
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesClient::DeleteEndpointPolicy(std::string const& name,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::DeleteEndpointPolicyRequest request;
  request.set_name(name);
  return connection_->DeleteEndpointPolicy(request);
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesClient::DeleteEndpointPolicy(
    google::cloud::networkservices::v1::DeleteEndpointPolicyRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteEndpointPolicy(request);
}

StreamRange<google::cloud::networkservices::v1::Gateway>
NetworkServicesClient::ListGateways(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::ListGatewaysRequest request;
  request.set_parent(parent);
  return connection_->ListGateways(request);
}

StreamRange<google::cloud::networkservices::v1::Gateway>
NetworkServicesClient::ListGateways(
    google::cloud::networkservices::v1::ListGatewaysRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListGateways(std::move(request));
}

StatusOr<google::cloud::networkservices::v1::Gateway>
NetworkServicesClient::GetGateway(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::GetGatewayRequest request;
  request.set_name(name);
  return connection_->GetGateway(request);
}

StatusOr<google::cloud::networkservices::v1::Gateway>
NetworkServicesClient::GetGateway(
    google::cloud::networkservices::v1::GetGatewayRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetGateway(request);
}

future<StatusOr<google::cloud::networkservices::v1::Gateway>>
NetworkServicesClient::CreateGateway(
    std::string const& parent,
    google::cloud::networkservices::v1::Gateway const& gateway,
    std::string const& gateway_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::CreateGatewayRequest request;
  request.set_parent(parent);
  *request.mutable_gateway() = gateway;
  request.set_gateway_id(gateway_id);
  return connection_->CreateGateway(request);
}

future<StatusOr<google::cloud::networkservices::v1::Gateway>>
NetworkServicesClient::CreateGateway(
    google::cloud::networkservices::v1::CreateGatewayRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateGateway(request);
}

future<StatusOr<google::cloud::networkservices::v1::Gateway>>
NetworkServicesClient::UpdateGateway(
    google::cloud::networkservices::v1::Gateway const& gateway,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::UpdateGatewayRequest request;
  *request.mutable_gateway() = gateway;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateGateway(request);
}

future<StatusOr<google::cloud::networkservices::v1::Gateway>>
NetworkServicesClient::UpdateGateway(
    google::cloud::networkservices::v1::UpdateGatewayRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateGateway(request);
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesClient::DeleteGateway(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::DeleteGatewayRequest request;
  request.set_name(name);
  return connection_->DeleteGateway(request);
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesClient::DeleteGateway(
    google::cloud::networkservices::v1::DeleteGatewayRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteGateway(request);
}

StreamRange<google::cloud::networkservices::v1::GrpcRoute>
NetworkServicesClient::ListGrpcRoutes(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::ListGrpcRoutesRequest request;
  request.set_parent(parent);
  return connection_->ListGrpcRoutes(request);
}

StreamRange<google::cloud::networkservices::v1::GrpcRoute>
NetworkServicesClient::ListGrpcRoutes(
    google::cloud::networkservices::v1::ListGrpcRoutesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListGrpcRoutes(std::move(request));
}

StatusOr<google::cloud::networkservices::v1::GrpcRoute>
NetworkServicesClient::GetGrpcRoute(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::GetGrpcRouteRequest request;
  request.set_name(name);
  return connection_->GetGrpcRoute(request);
}

StatusOr<google::cloud::networkservices::v1::GrpcRoute>
NetworkServicesClient::GetGrpcRoute(
    google::cloud::networkservices::v1::GetGrpcRouteRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetGrpcRoute(request);
}

future<StatusOr<google::cloud::networkservices::v1::GrpcRoute>>
NetworkServicesClient::CreateGrpcRoute(
    std::string const& parent,
    google::cloud::networkservices::v1::GrpcRoute const& grpc_route,
    std::string const& grpc_route_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::CreateGrpcRouteRequest request;
  request.set_parent(parent);
  *request.mutable_grpc_route() = grpc_route;
  request.set_grpc_route_id(grpc_route_id);
  return connection_->CreateGrpcRoute(request);
}

future<StatusOr<google::cloud::networkservices::v1::GrpcRoute>>
NetworkServicesClient::CreateGrpcRoute(
    google::cloud::networkservices::v1::CreateGrpcRouteRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateGrpcRoute(request);
}

future<StatusOr<google::cloud::networkservices::v1::GrpcRoute>>
NetworkServicesClient::UpdateGrpcRoute(
    google::cloud::networkservices::v1::GrpcRoute const& grpc_route,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::UpdateGrpcRouteRequest request;
  *request.mutable_grpc_route() = grpc_route;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateGrpcRoute(request);
}

future<StatusOr<google::cloud::networkservices::v1::GrpcRoute>>
NetworkServicesClient::UpdateGrpcRoute(
    google::cloud::networkservices::v1::UpdateGrpcRouteRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateGrpcRoute(request);
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesClient::DeleteGrpcRoute(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::DeleteGrpcRouteRequest request;
  request.set_name(name);
  return connection_->DeleteGrpcRoute(request);
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesClient::DeleteGrpcRoute(
    google::cloud::networkservices::v1::DeleteGrpcRouteRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteGrpcRoute(request);
}

StreamRange<google::cloud::networkservices::v1::HttpRoute>
NetworkServicesClient::ListHttpRoutes(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::ListHttpRoutesRequest request;
  request.set_parent(parent);
  return connection_->ListHttpRoutes(request);
}

StreamRange<google::cloud::networkservices::v1::HttpRoute>
NetworkServicesClient::ListHttpRoutes(
    google::cloud::networkservices::v1::ListHttpRoutesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListHttpRoutes(std::move(request));
}

StatusOr<google::cloud::networkservices::v1::HttpRoute>
NetworkServicesClient::GetHttpRoute(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::GetHttpRouteRequest request;
  request.set_name(name);
  return connection_->GetHttpRoute(request);
}

StatusOr<google::cloud::networkservices::v1::HttpRoute>
NetworkServicesClient::GetHttpRoute(
    google::cloud::networkservices::v1::GetHttpRouteRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetHttpRoute(request);
}

future<StatusOr<google::cloud::networkservices::v1::HttpRoute>>
NetworkServicesClient::CreateHttpRoute(
    std::string const& parent,
    google::cloud::networkservices::v1::HttpRoute const& http_route,
    std::string const& http_route_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::CreateHttpRouteRequest request;
  request.set_parent(parent);
  *request.mutable_http_route() = http_route;
  request.set_http_route_id(http_route_id);
  return connection_->CreateHttpRoute(request);
}

future<StatusOr<google::cloud::networkservices::v1::HttpRoute>>
NetworkServicesClient::CreateHttpRoute(
    google::cloud::networkservices::v1::CreateHttpRouteRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateHttpRoute(request);
}

future<StatusOr<google::cloud::networkservices::v1::HttpRoute>>
NetworkServicesClient::UpdateHttpRoute(
    google::cloud::networkservices::v1::HttpRoute const& http_route,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::UpdateHttpRouteRequest request;
  *request.mutable_http_route() = http_route;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateHttpRoute(request);
}

future<StatusOr<google::cloud::networkservices::v1::HttpRoute>>
NetworkServicesClient::UpdateHttpRoute(
    google::cloud::networkservices::v1::UpdateHttpRouteRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateHttpRoute(request);
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesClient::DeleteHttpRoute(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::DeleteHttpRouteRequest request;
  request.set_name(name);
  return connection_->DeleteHttpRoute(request);
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesClient::DeleteHttpRoute(
    google::cloud::networkservices::v1::DeleteHttpRouteRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteHttpRoute(request);
}

StreamRange<google::cloud::networkservices::v1::TcpRoute>
NetworkServicesClient::ListTcpRoutes(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::ListTcpRoutesRequest request;
  request.set_parent(parent);
  return connection_->ListTcpRoutes(request);
}

StreamRange<google::cloud::networkservices::v1::TcpRoute>
NetworkServicesClient::ListTcpRoutes(
    google::cloud::networkservices::v1::ListTcpRoutesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListTcpRoutes(std::move(request));
}

StatusOr<google::cloud::networkservices::v1::TcpRoute>
NetworkServicesClient::GetTcpRoute(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::GetTcpRouteRequest request;
  request.set_name(name);
  return connection_->GetTcpRoute(request);
}

StatusOr<google::cloud::networkservices::v1::TcpRoute>
NetworkServicesClient::GetTcpRoute(
    google::cloud::networkservices::v1::GetTcpRouteRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetTcpRoute(request);
}

future<StatusOr<google::cloud::networkservices::v1::TcpRoute>>
NetworkServicesClient::CreateTcpRoute(
    std::string const& parent,
    google::cloud::networkservices::v1::TcpRoute const& tcp_route,
    std::string const& tcp_route_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::CreateTcpRouteRequest request;
  request.set_parent(parent);
  *request.mutable_tcp_route() = tcp_route;
  request.set_tcp_route_id(tcp_route_id);
  return connection_->CreateTcpRoute(request);
}

future<StatusOr<google::cloud::networkservices::v1::TcpRoute>>
NetworkServicesClient::CreateTcpRoute(
    google::cloud::networkservices::v1::CreateTcpRouteRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateTcpRoute(request);
}

future<StatusOr<google::cloud::networkservices::v1::TcpRoute>>
NetworkServicesClient::UpdateTcpRoute(
    google::cloud::networkservices::v1::TcpRoute const& tcp_route,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::UpdateTcpRouteRequest request;
  *request.mutable_tcp_route() = tcp_route;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateTcpRoute(request);
}

future<StatusOr<google::cloud::networkservices::v1::TcpRoute>>
NetworkServicesClient::UpdateTcpRoute(
    google::cloud::networkservices::v1::UpdateTcpRouteRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateTcpRoute(request);
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesClient::DeleteTcpRoute(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::DeleteTcpRouteRequest request;
  request.set_name(name);
  return connection_->DeleteTcpRoute(request);
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesClient::DeleteTcpRoute(
    google::cloud::networkservices::v1::DeleteTcpRouteRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTcpRoute(request);
}

StreamRange<google::cloud::networkservices::v1::TlsRoute>
NetworkServicesClient::ListTlsRoutes(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::ListTlsRoutesRequest request;
  request.set_parent(parent);
  return connection_->ListTlsRoutes(request);
}

StreamRange<google::cloud::networkservices::v1::TlsRoute>
NetworkServicesClient::ListTlsRoutes(
    google::cloud::networkservices::v1::ListTlsRoutesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListTlsRoutes(std::move(request));
}

StatusOr<google::cloud::networkservices::v1::TlsRoute>
NetworkServicesClient::GetTlsRoute(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::GetTlsRouteRequest request;
  request.set_name(name);
  return connection_->GetTlsRoute(request);
}

StatusOr<google::cloud::networkservices::v1::TlsRoute>
NetworkServicesClient::GetTlsRoute(
    google::cloud::networkservices::v1::GetTlsRouteRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetTlsRoute(request);
}

future<StatusOr<google::cloud::networkservices::v1::TlsRoute>>
NetworkServicesClient::CreateTlsRoute(
    std::string const& parent,
    google::cloud::networkservices::v1::TlsRoute const& tls_route,
    std::string const& tls_route_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::CreateTlsRouteRequest request;
  request.set_parent(parent);
  *request.mutable_tls_route() = tls_route;
  request.set_tls_route_id(tls_route_id);
  return connection_->CreateTlsRoute(request);
}

future<StatusOr<google::cloud::networkservices::v1::TlsRoute>>
NetworkServicesClient::CreateTlsRoute(
    google::cloud::networkservices::v1::CreateTlsRouteRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateTlsRoute(request);
}

future<StatusOr<google::cloud::networkservices::v1::TlsRoute>>
NetworkServicesClient::UpdateTlsRoute(
    google::cloud::networkservices::v1::TlsRoute const& tls_route,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::UpdateTlsRouteRequest request;
  *request.mutable_tls_route() = tls_route;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateTlsRoute(request);
}

future<StatusOr<google::cloud::networkservices::v1::TlsRoute>>
NetworkServicesClient::UpdateTlsRoute(
    google::cloud::networkservices::v1::UpdateTlsRouteRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateTlsRoute(request);
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesClient::DeleteTlsRoute(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::DeleteTlsRouteRequest request;
  request.set_name(name);
  return connection_->DeleteTlsRoute(request);
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesClient::DeleteTlsRoute(
    google::cloud::networkservices::v1::DeleteTlsRouteRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTlsRoute(request);
}

StreamRange<google::cloud::networkservices::v1::ServiceBinding>
NetworkServicesClient::ListServiceBindings(std::string const& parent,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::ListServiceBindingsRequest request;
  request.set_parent(parent);
  return connection_->ListServiceBindings(request);
}

StreamRange<google::cloud::networkservices::v1::ServiceBinding>
NetworkServicesClient::ListServiceBindings(
    google::cloud::networkservices::v1::ListServiceBindingsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListServiceBindings(std::move(request));
}

StatusOr<google::cloud::networkservices::v1::ServiceBinding>
NetworkServicesClient::GetServiceBinding(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::GetServiceBindingRequest request;
  request.set_name(name);
  return connection_->GetServiceBinding(request);
}

StatusOr<google::cloud::networkservices::v1::ServiceBinding>
NetworkServicesClient::GetServiceBinding(
    google::cloud::networkservices::v1::GetServiceBindingRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetServiceBinding(request);
}

future<StatusOr<google::cloud::networkservices::v1::ServiceBinding>>
NetworkServicesClient::CreateServiceBinding(
    std::string const& parent,
    google::cloud::networkservices::v1::ServiceBinding const& service_binding,
    std::string const& service_binding_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::CreateServiceBindingRequest request;
  request.set_parent(parent);
  *request.mutable_service_binding() = service_binding;
  request.set_service_binding_id(service_binding_id);
  return connection_->CreateServiceBinding(request);
}

future<StatusOr<google::cloud::networkservices::v1::ServiceBinding>>
NetworkServicesClient::CreateServiceBinding(
    google::cloud::networkservices::v1::CreateServiceBindingRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateServiceBinding(request);
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesClient::DeleteServiceBinding(std::string const& name,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::DeleteServiceBindingRequest request;
  request.set_name(name);
  return connection_->DeleteServiceBinding(request);
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesClient::DeleteServiceBinding(
    google::cloud::networkservices::v1::DeleteServiceBindingRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteServiceBinding(request);
}

StreamRange<google::cloud::networkservices::v1::Mesh>
NetworkServicesClient::ListMeshes(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::ListMeshesRequest request;
  request.set_parent(parent);
  return connection_->ListMeshes(request);
}

StreamRange<google::cloud::networkservices::v1::Mesh>
NetworkServicesClient::ListMeshes(
    google::cloud::networkservices::v1::ListMeshesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListMeshes(std::move(request));
}

StatusOr<google::cloud::networkservices::v1::Mesh>
NetworkServicesClient::GetMesh(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::GetMeshRequest request;
  request.set_name(name);
  return connection_->GetMesh(request);
}

StatusOr<google::cloud::networkservices::v1::Mesh>
NetworkServicesClient::GetMesh(
    google::cloud::networkservices::v1::GetMeshRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetMesh(request);
}

future<StatusOr<google::cloud::networkservices::v1::Mesh>>
NetworkServicesClient::CreateMesh(
    std::string const& parent,
    google::cloud::networkservices::v1::Mesh const& mesh,
    std::string const& mesh_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::CreateMeshRequest request;
  request.set_parent(parent);
  *request.mutable_mesh() = mesh;
  request.set_mesh_id(mesh_id);
  return connection_->CreateMesh(request);
}

future<StatusOr<google::cloud::networkservices::v1::Mesh>>
NetworkServicesClient::CreateMesh(
    google::cloud::networkservices::v1::CreateMeshRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateMesh(request);
}

future<StatusOr<google::cloud::networkservices::v1::Mesh>>
NetworkServicesClient::UpdateMesh(
    google::cloud::networkservices::v1::Mesh const& mesh,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::UpdateMeshRequest request;
  *request.mutable_mesh() = mesh;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateMesh(request);
}

future<StatusOr<google::cloud::networkservices::v1::Mesh>>
NetworkServicesClient::UpdateMesh(
    google::cloud::networkservices::v1::UpdateMeshRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateMesh(request);
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesClient::DeleteMesh(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::networkservices::v1::DeleteMeshRequest request;
  request.set_name(name);
  return connection_->DeleteMesh(request);
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesClient::DeleteMesh(
    google::cloud::networkservices::v1::DeleteMeshRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteMesh(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkservices_v1
}  // namespace cloud
}  // namespace google
