// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkservices/v1/network_services.proto

#include "google/cloud/networkservices/v1/internal/network_services_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace networkservices_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

NetworkServicesTracingConnection::NetworkServicesTracingConnection(
    std::shared_ptr<networkservices_v1::NetworkServicesConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::networkservices::v1::EndpointPolicy>
NetworkServicesTracingConnection::ListEndpointPolicies(
    google::cloud::networkservices::v1::ListEndpointPoliciesRequest request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::NetworkServicesConnection::ListEndpointPolicies");
  internal::OTelScope scope(span);
  auto sr = child_->ListEndpointPolicies(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::networkservices::v1::EndpointPolicy>(std::move(span),
                                                          std::move(sr));
}

StatusOr<google::cloud::networkservices::v1::EndpointPolicy>
NetworkServicesTracingConnection::GetEndpointPolicy(
    google::cloud::networkservices::v1::GetEndpointPolicyRequest const&
        request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::NetworkServicesConnection::GetEndpointPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetEndpointPolicy(request));
}

future<StatusOr<google::cloud::networkservices::v1::EndpointPolicy>>
NetworkServicesTracingConnection::CreateEndpointPolicy(
    google::cloud::networkservices::v1::CreateEndpointPolicyRequest const&
        request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::NetworkServicesConnection::CreateEndpointPolicy");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateEndpointPolicy(request));
}

future<StatusOr<google::cloud::networkservices::v1::EndpointPolicy>>
NetworkServicesTracingConnection::UpdateEndpointPolicy(
    google::cloud::networkservices::v1::UpdateEndpointPolicyRequest const&
        request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::NetworkServicesConnection::UpdateEndpointPolicy");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateEndpointPolicy(request));
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesTracingConnection::DeleteEndpointPolicy(
    google::cloud::networkservices::v1::DeleteEndpointPolicyRequest const&
        request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::NetworkServicesConnection::DeleteEndpointPolicy");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteEndpointPolicy(request));
}

StreamRange<google::cloud::networkservices::v1::Gateway>
NetworkServicesTracingConnection::ListGateways(
    google::cloud::networkservices::v1::ListGatewaysRequest request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::NetworkServicesConnection::ListGateways");
  internal::OTelScope scope(span);
  auto sr = child_->ListGateways(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::networkservices::v1::Gateway>(std::move(span),
                                                   std::move(sr));
}

StatusOr<google::cloud::networkservices::v1::Gateway>
NetworkServicesTracingConnection::GetGateway(
    google::cloud::networkservices::v1::GetGatewayRequest const& request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::NetworkServicesConnection::GetGateway");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetGateway(request));
}

future<StatusOr<google::cloud::networkservices::v1::Gateway>>
NetworkServicesTracingConnection::CreateGateway(
    google::cloud::networkservices::v1::CreateGatewayRequest const& request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::NetworkServicesConnection::CreateGateway");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateGateway(request));
}

future<StatusOr<google::cloud::networkservices::v1::Gateway>>
NetworkServicesTracingConnection::UpdateGateway(
    google::cloud::networkservices::v1::UpdateGatewayRequest const& request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::NetworkServicesConnection::UpdateGateway");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateGateway(request));
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesTracingConnection::DeleteGateway(
    google::cloud::networkservices::v1::DeleteGatewayRequest const& request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::NetworkServicesConnection::DeleteGateway");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteGateway(request));
}

StreamRange<google::cloud::networkservices::v1::GrpcRoute>
NetworkServicesTracingConnection::ListGrpcRoutes(
    google::cloud::networkservices::v1::ListGrpcRoutesRequest request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::NetworkServicesConnection::ListGrpcRoutes");
  internal::OTelScope scope(span);
  auto sr = child_->ListGrpcRoutes(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::networkservices::v1::GrpcRoute>(std::move(span),
                                                     std::move(sr));
}

StatusOr<google::cloud::networkservices::v1::GrpcRoute>
NetworkServicesTracingConnection::GetGrpcRoute(
    google::cloud::networkservices::v1::GetGrpcRouteRequest const& request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::NetworkServicesConnection::GetGrpcRoute");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetGrpcRoute(request));
}

future<StatusOr<google::cloud::networkservices::v1::GrpcRoute>>
NetworkServicesTracingConnection::CreateGrpcRoute(
    google::cloud::networkservices::v1::CreateGrpcRouteRequest const& request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::NetworkServicesConnection::CreateGrpcRoute");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateGrpcRoute(request));
}

future<StatusOr<google::cloud::networkservices::v1::GrpcRoute>>
NetworkServicesTracingConnection::UpdateGrpcRoute(
    google::cloud::networkservices::v1::UpdateGrpcRouteRequest const& request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::NetworkServicesConnection::UpdateGrpcRoute");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateGrpcRoute(request));
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesTracingConnection::DeleteGrpcRoute(
    google::cloud::networkservices::v1::DeleteGrpcRouteRequest const& request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::NetworkServicesConnection::DeleteGrpcRoute");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteGrpcRoute(request));
}

StreamRange<google::cloud::networkservices::v1::HttpRoute>
NetworkServicesTracingConnection::ListHttpRoutes(
    google::cloud::networkservices::v1::ListHttpRoutesRequest request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::NetworkServicesConnection::ListHttpRoutes");
  internal::OTelScope scope(span);
  auto sr = child_->ListHttpRoutes(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::networkservices::v1::HttpRoute>(std::move(span),
                                                     std::move(sr));
}

StatusOr<google::cloud::networkservices::v1::HttpRoute>
NetworkServicesTracingConnection::GetHttpRoute(
    google::cloud::networkservices::v1::GetHttpRouteRequest const& request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::NetworkServicesConnection::GetHttpRoute");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetHttpRoute(request));
}

future<StatusOr<google::cloud::networkservices::v1::HttpRoute>>
NetworkServicesTracingConnection::CreateHttpRoute(
    google::cloud::networkservices::v1::CreateHttpRouteRequest const& request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::NetworkServicesConnection::CreateHttpRoute");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateHttpRoute(request));
}

future<StatusOr<google::cloud::networkservices::v1::HttpRoute>>
NetworkServicesTracingConnection::UpdateHttpRoute(
    google::cloud::networkservices::v1::UpdateHttpRouteRequest const& request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::NetworkServicesConnection::UpdateHttpRoute");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateHttpRoute(request));
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesTracingConnection::DeleteHttpRoute(
    google::cloud::networkservices::v1::DeleteHttpRouteRequest const& request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::NetworkServicesConnection::DeleteHttpRoute");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteHttpRoute(request));
}

StreamRange<google::cloud::networkservices::v1::TcpRoute>
NetworkServicesTracingConnection::ListTcpRoutes(
    google::cloud::networkservices::v1::ListTcpRoutesRequest request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::NetworkServicesConnection::ListTcpRoutes");
  internal::OTelScope scope(span);
  auto sr = child_->ListTcpRoutes(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::networkservices::v1::TcpRoute>(std::move(span),
                                                    std::move(sr));
}

StatusOr<google::cloud::networkservices::v1::TcpRoute>
NetworkServicesTracingConnection::GetTcpRoute(
    google::cloud::networkservices::v1::GetTcpRouteRequest const& request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::NetworkServicesConnection::GetTcpRoute");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetTcpRoute(request));
}

future<StatusOr<google::cloud::networkservices::v1::TcpRoute>>
NetworkServicesTracingConnection::CreateTcpRoute(
    google::cloud::networkservices::v1::CreateTcpRouteRequest const& request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::NetworkServicesConnection::CreateTcpRoute");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateTcpRoute(request));
}

future<StatusOr<google::cloud::networkservices::v1::TcpRoute>>
NetworkServicesTracingConnection::UpdateTcpRoute(
    google::cloud::networkservices::v1::UpdateTcpRouteRequest const& request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::NetworkServicesConnection::UpdateTcpRoute");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateTcpRoute(request));
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesTracingConnection::DeleteTcpRoute(
    google::cloud::networkservices::v1::DeleteTcpRouteRequest const& request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::NetworkServicesConnection::DeleteTcpRoute");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteTcpRoute(request));
}

StreamRange<google::cloud::networkservices::v1::TlsRoute>
NetworkServicesTracingConnection::ListTlsRoutes(
    google::cloud::networkservices::v1::ListTlsRoutesRequest request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::NetworkServicesConnection::ListTlsRoutes");
  internal::OTelScope scope(span);
  auto sr = child_->ListTlsRoutes(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::networkservices::v1::TlsRoute>(std::move(span),
                                                    std::move(sr));
}

StatusOr<google::cloud::networkservices::v1::TlsRoute>
NetworkServicesTracingConnection::GetTlsRoute(
    google::cloud::networkservices::v1::GetTlsRouteRequest const& request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::NetworkServicesConnection::GetTlsRoute");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetTlsRoute(request));
}

future<StatusOr<google::cloud::networkservices::v1::TlsRoute>>
NetworkServicesTracingConnection::CreateTlsRoute(
    google::cloud::networkservices::v1::CreateTlsRouteRequest const& request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::NetworkServicesConnection::CreateTlsRoute");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateTlsRoute(request));
}

future<StatusOr<google::cloud::networkservices::v1::TlsRoute>>
NetworkServicesTracingConnection::UpdateTlsRoute(
    google::cloud::networkservices::v1::UpdateTlsRouteRequest const& request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::NetworkServicesConnection::UpdateTlsRoute");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateTlsRoute(request));
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesTracingConnection::DeleteTlsRoute(
    google::cloud::networkservices::v1::DeleteTlsRouteRequest const& request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::NetworkServicesConnection::DeleteTlsRoute");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteTlsRoute(request));
}

StreamRange<google::cloud::networkservices::v1::ServiceBinding>
NetworkServicesTracingConnection::ListServiceBindings(
    google::cloud::networkservices::v1::ListServiceBindingsRequest request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::NetworkServicesConnection::ListServiceBindings");
  internal::OTelScope scope(span);
  auto sr = child_->ListServiceBindings(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::networkservices::v1::ServiceBinding>(std::move(span),
                                                          std::move(sr));
}

StatusOr<google::cloud::networkservices::v1::ServiceBinding>
NetworkServicesTracingConnection::GetServiceBinding(
    google::cloud::networkservices::v1::GetServiceBindingRequest const&
        request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::NetworkServicesConnection::GetServiceBinding");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetServiceBinding(request));
}

future<StatusOr<google::cloud::networkservices::v1::ServiceBinding>>
NetworkServicesTracingConnection::CreateServiceBinding(
    google::cloud::networkservices::v1::CreateServiceBindingRequest const&
        request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::NetworkServicesConnection::CreateServiceBinding");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateServiceBinding(request));
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesTracingConnection::DeleteServiceBinding(
    google::cloud::networkservices::v1::DeleteServiceBindingRequest const&
        request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::NetworkServicesConnection::DeleteServiceBinding");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteServiceBinding(request));
}

StreamRange<google::cloud::networkservices::v1::Mesh>
NetworkServicesTracingConnection::ListMeshes(
    google::cloud::networkservices::v1::ListMeshesRequest request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::NetworkServicesConnection::ListMeshes");
  internal::OTelScope scope(span);
  auto sr = child_->ListMeshes(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::networkservices::v1::Mesh>(std::move(span), std::move(sr));
}

StatusOr<google::cloud::networkservices::v1::Mesh>
NetworkServicesTracingConnection::GetMesh(
    google::cloud::networkservices::v1::GetMeshRequest const& request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::NetworkServicesConnection::GetMesh");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetMesh(request));
}

future<StatusOr<google::cloud::networkservices::v1::Mesh>>
NetworkServicesTracingConnection::CreateMesh(
    google::cloud::networkservices::v1::CreateMeshRequest const& request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::NetworkServicesConnection::CreateMesh");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateMesh(request));
}

future<StatusOr<google::cloud::networkservices::v1::Mesh>>
NetworkServicesTracingConnection::UpdateMesh(
    google::cloud::networkservices::v1::UpdateMeshRequest const& request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::NetworkServicesConnection::UpdateMesh");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateMesh(request));
}

future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
NetworkServicesTracingConnection::DeleteMesh(
    google::cloud::networkservices::v1::DeleteMeshRequest const& request) {
  auto span = internal::MakeSpan(
      "networkservices_v1::NetworkServicesConnection::DeleteMesh");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteMesh(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<networkservices_v1::NetworkServicesConnection>
MakeNetworkServicesTracingConnection(
    std::shared_ptr<networkservices_v1::NetworkServicesConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<NetworkServicesTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkservices_v1_internal
}  // namespace cloud
}  // namespace google
