// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networksecurity/v1/network_security.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKSECURITY_V1_INTERNAL_NETWORK_SECURITY_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKSECURITY_V1_INTERNAL_NETWORK_SECURITY_CONNECTION_IMPL_H

#include "google/cloud/networksecurity/v1/internal/network_security_retry_traits.h"
#include "google/cloud/networksecurity/v1/internal/network_security_stub.h"
#include "google/cloud/networksecurity/v1/network_security_connection.h"
#include "google/cloud/networksecurity/v1/network_security_connection_idempotency_policy.h"
#include "google/cloud/networksecurity/v1/network_security_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace networksecurity_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class NetworkSecurityConnectionImpl
    : public networksecurity_v1::NetworkSecurityConnection {
 public:
  ~NetworkSecurityConnectionImpl() override = default;

  NetworkSecurityConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<networksecurity_v1_internal::NetworkSecurityStub> stub,
      Options options);

  Options options() override { return options_; }

  StreamRange<google::cloud::networksecurity::v1::AuthorizationPolicy>
  ListAuthorizationPolicies(
      google::cloud::networksecurity::v1::ListAuthorizationPoliciesRequest
          request) override;

  StatusOr<google::cloud::networksecurity::v1::AuthorizationPolicy>
  GetAuthorizationPolicy(
      google::cloud::networksecurity::v1::GetAuthorizationPolicyRequest const&
          request) override;

  future<StatusOr<google::cloud::networksecurity::v1::AuthorizationPolicy>>
  CreateAuthorizationPolicy(
      google::cloud::networksecurity::v1::
          CreateAuthorizationPolicyRequest const& request) override;

  future<StatusOr<google::cloud::networksecurity::v1::AuthorizationPolicy>>
  UpdateAuthorizationPolicy(
      google::cloud::networksecurity::v1::
          UpdateAuthorizationPolicyRequest const& request) override;

  future<StatusOr<google::cloud::networksecurity::v1::OperationMetadata>>
  DeleteAuthorizationPolicy(
      google::cloud::networksecurity::v1::
          DeleteAuthorizationPolicyRequest const& request) override;

  StreamRange<google::cloud::networksecurity::v1::ServerTlsPolicy>
  ListServerTlsPolicies(
      google::cloud::networksecurity::v1::ListServerTlsPoliciesRequest request)
      override;

  StatusOr<google::cloud::networksecurity::v1::ServerTlsPolicy>
  GetServerTlsPolicy(
      google::cloud::networksecurity::v1::GetServerTlsPolicyRequest const&
          request) override;

  future<StatusOr<google::cloud::networksecurity::v1::ServerTlsPolicy>>
  CreateServerTlsPolicy(
      google::cloud::networksecurity::v1::CreateServerTlsPolicyRequest const&
          request) override;

  future<StatusOr<google::cloud::networksecurity::v1::ServerTlsPolicy>>
  UpdateServerTlsPolicy(
      google::cloud::networksecurity::v1::UpdateServerTlsPolicyRequest const&
          request) override;

  future<StatusOr<google::cloud::networksecurity::v1::OperationMetadata>>
  DeleteServerTlsPolicy(
      google::cloud::networksecurity::v1::DeleteServerTlsPolicyRequest const&
          request) override;

  StreamRange<google::cloud::networksecurity::v1::ClientTlsPolicy>
  ListClientTlsPolicies(
      google::cloud::networksecurity::v1::ListClientTlsPoliciesRequest request)
      override;

  StatusOr<google::cloud::networksecurity::v1::ClientTlsPolicy>
  GetClientTlsPolicy(
      google::cloud::networksecurity::v1::GetClientTlsPolicyRequest const&
          request) override;

  future<StatusOr<google::cloud::networksecurity::v1::ClientTlsPolicy>>
  CreateClientTlsPolicy(
      google::cloud::networksecurity::v1::CreateClientTlsPolicyRequest const&
          request) override;

  future<StatusOr<google::cloud::networksecurity::v1::ClientTlsPolicy>>
  UpdateClientTlsPolicy(
      google::cloud::networksecurity::v1::UpdateClientTlsPolicyRequest const&
          request) override;

  future<StatusOr<google::cloud::networksecurity::v1::OperationMetadata>>
  DeleteClientTlsPolicy(
      google::cloud::networksecurity::v1::DeleteClientTlsPolicyRequest const&
          request) override;

 private:
  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<networksecurity_v1_internal::NetworkSecurityStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networksecurity_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKSECURITY_V1_INTERNAL_NETWORK_SECURITY_CONNECTION_IMPL_H
