// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/netapp/v1/cloud_netapp_service.proto

#include "google/cloud/netapp/v1/internal/net_app_option_defaults.h"
#include "google/cloud/netapp/v1/net_app_connection.h"
#include "google/cloud/netapp/v1/net_app_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>

namespace google {
namespace cloud {
namespace netapp_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options NetAppDefaultOptions(Options options) {
  options = google::cloud::internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_NET_APP_ENDPOINT", "",
      "GOOGLE_CLOUD_CPP_NET_APP_AUTHORITY", "netapp.googleapis.com");
  options =
      google::cloud::internal::PopulateGrpcOptions(std::move(options), "");
  if (!options.has<netapp_v1::NetAppRetryPolicyOption>()) {
    options.set<netapp_v1::NetAppRetryPolicyOption>(
        netapp_v1::NetAppLimitedTimeRetryPolicy(std::chrono::minutes(30))
            .clone());
  }
  if (!options.has<netapp_v1::NetAppBackoffPolicyOption>()) {
    options.set<netapp_v1::NetAppBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options.has<netapp_v1::NetAppPollingPolicyOption>()) {
    options.set<netapp_v1::NetAppPollingPolicyOption>(
        GenericPollingPolicy<netapp_v1::NetAppRetryPolicyOption::Type,
                             netapp_v1::NetAppBackoffPolicyOption::Type>(
            options.get<netapp_v1::NetAppRetryPolicyOption>()->clone(),
            ExponentialBackoffPolicy(std::chrono::seconds(1),
                                     std::chrono::minutes(5), kBackoffScaling)
                .clone())
            .clone());
  }
  if (!options.has<netapp_v1::NetAppConnectionIdempotencyPolicyOption>()) {
    options.set<netapp_v1::NetAppConnectionIdempotencyPolicyOption>(
        netapp_v1::MakeDefaultNetAppConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace netapp_v1_internal
}  // namespace cloud
}  // namespace google
