// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/snooze_service.proto

#include "google/cloud/monitoring/v3/internal/snooze_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/monitoring/v3/snooze_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace monitoring_v3_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

SnoozeServiceStub::~SnoozeServiceStub() = default;

StatusOr<google::monitoring::v3::Snooze> DefaultSnoozeServiceStub::CreateSnooze(
    grpc::ClientContext& context,
    google::monitoring::v3::CreateSnoozeRequest const& request) {
  google::monitoring::v3::Snooze response;
  auto status = grpc_stub_->CreateSnooze(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::monitoring::v3::ListSnoozesResponse>
DefaultSnoozeServiceStub::ListSnoozes(
    grpc::ClientContext& context,
    google::monitoring::v3::ListSnoozesRequest const& request) {
  google::monitoring::v3::ListSnoozesResponse response;
  auto status = grpc_stub_->ListSnoozes(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::monitoring::v3::Snooze> DefaultSnoozeServiceStub::GetSnooze(
    grpc::ClientContext& context,
    google::monitoring::v3::GetSnoozeRequest const& request) {
  google::monitoring::v3::Snooze response;
  auto status = grpc_stub_->GetSnooze(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::monitoring::v3::Snooze> DefaultSnoozeServiceStub::UpdateSnooze(
    grpc::ClientContext& context,
    google::monitoring::v3::UpdateSnoozeRequest const& request) {
  google::monitoring::v3::Snooze response;
  auto status = grpc_stub_->UpdateSnooze(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_v3_internal
}  // namespace cloud
}  // namespace google
