// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/iam/admin/v1/iam.proto

#include "google/cloud/iam/admin/v1/internal/iam_metadata_decorator.h"
#include "google/cloud/common_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <google/iam/admin/v1/iam.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace iam_admin_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

IAMMetadata::IAMMetadata(std::shared_ptr<IAMStub> child,
                         std::multimap<std::string, std::string> fixed_metadata,
                         std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<google::iam::admin::v1::ListServiceAccountsResponse>
IAMMetadata::ListServiceAccounts(
    grpc::ClientContext& context,
    google::iam::admin::v1::ListServiceAccountsRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->ListServiceAccounts(context, request);
}

StatusOr<google::iam::admin::v1::ServiceAccount> IAMMetadata::GetServiceAccount(
    grpc::ClientContext& context,
    google::iam::admin::v1::GetServiceAccountRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetServiceAccount(context, request);
}

StatusOr<google::iam::admin::v1::ServiceAccount>
IAMMetadata::CreateServiceAccount(
    grpc::ClientContext& context,
    google::iam::admin::v1::CreateServiceAccountRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->CreateServiceAccount(context, request);
}

StatusOr<google::iam::admin::v1::ServiceAccount>
IAMMetadata::PatchServiceAccount(
    grpc::ClientContext& context,
    google::iam::admin::v1::PatchServiceAccountRequest const& request) {
  SetMetadata(
      context, internal::CurrentOptions(),
      absl::StrCat("service_account.name=",
                   internal::UrlEncode(request.service_account().name())));
  return child_->PatchServiceAccount(context, request);
}

Status IAMMetadata::DeleteServiceAccount(
    grpc::ClientContext& context,
    google::iam::admin::v1::DeleteServiceAccountRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteServiceAccount(context, request);
}

StatusOr<google::iam::admin::v1::UndeleteServiceAccountResponse>
IAMMetadata::UndeleteServiceAccount(
    grpc::ClientContext& context,
    google::iam::admin::v1::UndeleteServiceAccountRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->UndeleteServiceAccount(context, request);
}

Status IAMMetadata::EnableServiceAccount(
    grpc::ClientContext& context,
    google::iam::admin::v1::EnableServiceAccountRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->EnableServiceAccount(context, request);
}

Status IAMMetadata::DisableServiceAccount(
    grpc::ClientContext& context,
    google::iam::admin::v1::DisableServiceAccountRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DisableServiceAccount(context, request);
}

StatusOr<google::iam::admin::v1::ListServiceAccountKeysResponse>
IAMMetadata::ListServiceAccountKeys(
    grpc::ClientContext& context,
    google::iam::admin::v1::ListServiceAccountKeysRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->ListServiceAccountKeys(context, request);
}

StatusOr<google::iam::admin::v1::ServiceAccountKey>
IAMMetadata::GetServiceAccountKey(
    grpc::ClientContext& context,
    google::iam::admin::v1::GetServiceAccountKeyRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetServiceAccountKey(context, request);
}

StatusOr<google::iam::admin::v1::ServiceAccountKey>
IAMMetadata::CreateServiceAccountKey(
    grpc::ClientContext& context,
    google::iam::admin::v1::CreateServiceAccountKeyRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->CreateServiceAccountKey(context, request);
}

StatusOr<google::iam::admin::v1::ServiceAccountKey>
IAMMetadata::UploadServiceAccountKey(
    grpc::ClientContext& context,
    google::iam::admin::v1::UploadServiceAccountKeyRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->UploadServiceAccountKey(context, request);
}

Status IAMMetadata::DeleteServiceAccountKey(
    grpc::ClientContext& context,
    google::iam::admin::v1::DeleteServiceAccountKeyRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteServiceAccountKey(context, request);
}

Status IAMMetadata::DisableServiceAccountKey(
    grpc::ClientContext& context,
    google::iam::admin::v1::DisableServiceAccountKeyRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DisableServiceAccountKey(context, request);
}

Status IAMMetadata::EnableServiceAccountKey(
    grpc::ClientContext& context,
    google::iam::admin::v1::EnableServiceAccountKeyRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->EnableServiceAccountKey(context, request);
}

StatusOr<google::iam::v1::Policy> IAMMetadata::GetIamPolicy(
    grpc::ClientContext& context,
    google::iam::v1::GetIamPolicyRequest const& request) {
  SetMetadata(
      context, internal::CurrentOptions(),
      absl::StrCat("resource=", internal::UrlEncode(request.resource())));
  return child_->GetIamPolicy(context, request);
}

StatusOr<google::iam::v1::Policy> IAMMetadata::SetIamPolicy(
    grpc::ClientContext& context,
    google::iam::v1::SetIamPolicyRequest const& request) {
  SetMetadata(
      context, internal::CurrentOptions(),
      absl::StrCat("resource=", internal::UrlEncode(request.resource())));
  return child_->SetIamPolicy(context, request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
IAMMetadata::TestIamPermissions(
    grpc::ClientContext& context,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  SetMetadata(
      context, internal::CurrentOptions(),
      absl::StrCat("resource=", internal::UrlEncode(request.resource())));
  return child_->TestIamPermissions(context, request);
}

StatusOr<google::iam::admin::v1::QueryGrantableRolesResponse>
IAMMetadata::QueryGrantableRoles(
    grpc::ClientContext& context,
    google::iam::admin::v1::QueryGrantableRolesRequest const& request) {
  SetMetadata(context, internal::CurrentOptions());
  return child_->QueryGrantableRoles(context, request);
}

StatusOr<google::iam::admin::v1::ListRolesResponse> IAMMetadata::ListRoles(
    grpc::ClientContext& context,
    google::iam::admin::v1::ListRolesRequest const& request) {
  SetMetadata(context, internal::CurrentOptions());
  return child_->ListRoles(context, request);
}

StatusOr<google::iam::admin::v1::Role> IAMMetadata::GetRole(
    grpc::ClientContext& context,
    google::iam::admin::v1::GetRoleRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetRole(context, request);
}

StatusOr<google::iam::admin::v1::Role> IAMMetadata::CreateRole(
    grpc::ClientContext& context,
    google::iam::admin::v1::CreateRoleRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateRole(context, request);
}

StatusOr<google::iam::admin::v1::Role> IAMMetadata::UpdateRole(
    grpc::ClientContext& context,
    google::iam::admin::v1::UpdateRoleRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->UpdateRole(context, request);
}

StatusOr<google::iam::admin::v1::Role> IAMMetadata::DeleteRole(
    grpc::ClientContext& context,
    google::iam::admin::v1::DeleteRoleRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteRole(context, request);
}

StatusOr<google::iam::admin::v1::Role> IAMMetadata::UndeleteRole(
    grpc::ClientContext& context,
    google::iam::admin::v1::UndeleteRoleRequest const& request) {
  SetMetadata(context, internal::CurrentOptions(),
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->UndeleteRole(context, request);
}

StatusOr<google::iam::admin::v1::QueryTestablePermissionsResponse>
IAMMetadata::QueryTestablePermissions(
    grpc::ClientContext& context,
    google::iam::admin::v1::QueryTestablePermissionsRequest const& request) {
  SetMetadata(context, internal::CurrentOptions());
  return child_->QueryTestablePermissions(context, request);
}

StatusOr<google::iam::admin::v1::QueryAuditableServicesResponse>
IAMMetadata::QueryAuditableServices(
    grpc::ClientContext& context,
    google::iam::admin::v1::QueryAuditableServicesRequest const& request) {
  SetMetadata(context, internal::CurrentOptions());
  return child_->QueryAuditableServices(context, request);
}

StatusOr<google::iam::admin::v1::LintPolicyResponse> IAMMetadata::LintPolicy(
    grpc::ClientContext& context,
    google::iam::admin::v1::LintPolicyRequest const& request) {
  SetMetadata(context, internal::CurrentOptions());
  return child_->LintPolicy(context, request);
}

void IAMMetadata::SetMetadata(grpc::ClientContext& context,
                              Options const& options,
                              std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void IAMMetadata::SetMetadata(grpc::ClientContext& context,
                              Options const& options) {
  for (auto const& kv : fixed_metadata_) {
    context.AddMetadata(kv.first, kv.second);
  }
  context.AddMetadata("x-goog-api-client", api_client_header_);
  if (options.has<UserProjectOption>()) {
    context.AddMetadata("x-goog-user-project",
                        options.get<UserProjectOption>());
  }
  auto const& authority = options.get<AuthorityOption>();
  if (!authority.empty()) context.set_authority(authority);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace iam_admin_v1_internal
}  // namespace cloud
}  // namespace google
