// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gkemulticloud/v1/azure_service.proto

#include "google/cloud/gkemulticloud/v1/internal/azure_clusters_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"

namespace google {
namespace cloud {
namespace gkemulticloud_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

AzureClustersTracingStub::AzureClustersTracingStub(
    std::shared_ptr<AzureClustersStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

future<StatusOr<google::longrunning::Operation>>
AzureClustersTracingStub::AsyncCreateAzureClient(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::gkemulticloud::v1::CreateAzureClientRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.gkemulticloud.v1.AzureClusters", "CreateAzureClient");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateAzureClient(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::cloud::gkemulticloud::v1::AzureClient>
AzureClustersTracingStub::GetAzureClient(
    grpc::ClientContext& context,
    google::cloud::gkemulticloud::v1::GetAzureClientRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.gkemulticloud.v1.AzureClusters", "GetAzureClient");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetAzureClient(context, request));
}

StatusOr<google::cloud::gkemulticloud::v1::ListAzureClientsResponse>
AzureClustersTracingStub::ListAzureClients(
    grpc::ClientContext& context,
    google::cloud::gkemulticloud::v1::ListAzureClientsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.gkemulticloud.v1.AzureClusters", "ListAzureClients");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListAzureClients(context, request));
}

future<StatusOr<google::longrunning::Operation>>
AzureClustersTracingStub::AsyncDeleteAzureClient(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::gkemulticloud::v1::DeleteAzureClientRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.gkemulticloud.v1.AzureClusters", "DeleteAzureClient");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteAzureClient(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
AzureClustersTracingStub::AsyncCreateAzureCluster(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::gkemulticloud::v1::CreateAzureClusterRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.gkemulticloud.v1.AzureClusters", "CreateAzureCluster");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateAzureCluster(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
AzureClustersTracingStub::AsyncUpdateAzureCluster(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::gkemulticloud::v1::UpdateAzureClusterRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.gkemulticloud.v1.AzureClusters", "UpdateAzureCluster");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncUpdateAzureCluster(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::cloud::gkemulticloud::v1::AzureCluster>
AzureClustersTracingStub::GetAzureCluster(
    grpc::ClientContext& context,
    google::cloud::gkemulticloud::v1::GetAzureClusterRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.gkemulticloud.v1.AzureClusters", "GetAzureCluster");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetAzureCluster(context, request));
}

StatusOr<google::cloud::gkemulticloud::v1::ListAzureClustersResponse>
AzureClustersTracingStub::ListAzureClusters(
    grpc::ClientContext& context,
    google::cloud::gkemulticloud::v1::ListAzureClustersRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.gkemulticloud.v1.AzureClusters", "ListAzureClusters");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListAzureClusters(context, request));
}

future<StatusOr<google::longrunning::Operation>>
AzureClustersTracingStub::AsyncDeleteAzureCluster(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::gkemulticloud::v1::DeleteAzureClusterRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.gkemulticloud.v1.AzureClusters", "DeleteAzureCluster");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteAzureCluster(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::cloud::gkemulticloud::v1::GenerateAzureAccessTokenResponse>
AzureClustersTracingStub::GenerateAzureAccessToken(
    grpc::ClientContext& context,
    google::cloud::gkemulticloud::v1::GenerateAzureAccessTokenRequest const&
        request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.gkemulticloud.v1.AzureClusters",
                             "GenerateAzureAccessToken");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GenerateAzureAccessToken(context, request));
}

future<StatusOr<google::longrunning::Operation>>
AzureClustersTracingStub::AsyncCreateAzureNodePool(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::gkemulticloud::v1::CreateAzureNodePoolRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.gkemulticloud.v1.AzureClusters", "CreateAzureNodePool");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateAzureNodePool(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
AzureClustersTracingStub::AsyncUpdateAzureNodePool(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::gkemulticloud::v1::UpdateAzureNodePoolRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.gkemulticloud.v1.AzureClusters", "UpdateAzureNodePool");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncUpdateAzureNodePool(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::cloud::gkemulticloud::v1::AzureNodePool>
AzureClustersTracingStub::GetAzureNodePool(
    grpc::ClientContext& context,
    google::cloud::gkemulticloud::v1::GetAzureNodePoolRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.gkemulticloud.v1.AzureClusters", "GetAzureNodePool");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetAzureNodePool(context, request));
}

StatusOr<google::cloud::gkemulticloud::v1::ListAzureNodePoolsResponse>
AzureClustersTracingStub::ListAzureNodePools(
    grpc::ClientContext& context,
    google::cloud::gkemulticloud::v1::ListAzureNodePoolsRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.gkemulticloud.v1.AzureClusters", "ListAzureNodePools");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListAzureNodePools(context, request));
}

future<StatusOr<google::longrunning::Operation>>
AzureClustersTracingStub::AsyncDeleteAzureNodePool(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::gkemulticloud::v1::DeleteAzureNodePoolRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.gkemulticloud.v1.AzureClusters", "DeleteAzureNodePool");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncDeleteAzureNodePool(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::cloud::gkemulticloud::v1::AzureServerConfig>
AzureClustersTracingStub::GetAzureServerConfig(
    grpc::ClientContext& context,
    google::cloud::gkemulticloud::v1::GetAzureServerConfigRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.gkemulticloud.v1.AzureClusters", "GetAzureServerConfig");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetAzureServerConfig(context, request));
}

future<StatusOr<google::longrunning::Operation>>
AzureClustersTracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> AzureClustersTracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCancelOperation(cq, context, options, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<AzureClustersStub> MakeAzureClustersTracingStub(
    std::shared_ptr<AzureClustersStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<AzureClustersTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gkemulticloud_v1_internal
}  // namespace cloud
}  // namespace google
