// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gkebackup/v1/gkebackup.proto

#include "google/cloud/gkebackup/v1/internal/backup_for_gke_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/cloud/gkebackup/v1/gkebackup.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace gkebackup_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

BackupForGKELogging::BackupForGKELogging(
    std::shared_ptr<BackupForGKEStub> child, TracingOptions tracing_options,
    std::set<std::string> const& components)
    : child_(std::move(child)),
      tracing_options_(std::move(tracing_options)),
      stream_logging_(components.find("rpc-streams") != components.end()) {}

future<StatusOr<google::longrunning::Operation>>
BackupForGKELogging::AsyncCreateBackupPlan(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::gkebackup::v1::CreateBackupPlanRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::cloud::gkebackup::v1::CreateBackupPlanRequest const&
                 request) {
        return child_->AsyncCreateBackupPlan(cq, std::move(context), options,
                                             request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::gkebackup::v1::ListBackupPlansResponse>
BackupForGKELogging::ListBackupPlans(
    grpc::ClientContext& context,
    google::cloud::gkebackup::v1::ListBackupPlansRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::cloud::gkebackup::v1::ListBackupPlansRequest const& request) {
        return child_->ListBackupPlans(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::gkebackup::v1::BackupPlan>
BackupForGKELogging::GetBackupPlan(
    grpc::ClientContext& context,
    google::cloud::gkebackup::v1::GetBackupPlanRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::cloud::gkebackup::v1::GetBackupPlanRequest const& request) {
        return child_->GetBackupPlan(context, request);
      },
      context, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKELogging::AsyncUpdateBackupPlan(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::gkebackup::v1::UpdateBackupPlanRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::cloud::gkebackup::v1::UpdateBackupPlanRequest const&
                 request) {
        return child_->AsyncUpdateBackupPlan(cq, std::move(context), options,
                                             request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKELogging::AsyncDeleteBackupPlan(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::gkebackup::v1::DeleteBackupPlanRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::cloud::gkebackup::v1::DeleteBackupPlanRequest const&
                 request) {
        return child_->AsyncDeleteBackupPlan(cq, std::move(context), options,
                                             request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKELogging::AsyncCreateBackup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::gkebackup::v1::CreateBackupRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::cloud::gkebackup::v1::CreateBackupRequest const& request) {
        return child_->AsyncCreateBackup(cq, std::move(context), options,
                                         request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::gkebackup::v1::ListBackupsResponse>
BackupForGKELogging::ListBackups(
    grpc::ClientContext& context,
    google::cloud::gkebackup::v1::ListBackupsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::gkebackup::v1::ListBackupsRequest const& request) {
        return child_->ListBackups(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::gkebackup::v1::Backup> BackupForGKELogging::GetBackup(
    grpc::ClientContext& context,
    google::cloud::gkebackup::v1::GetBackupRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::gkebackup::v1::GetBackupRequest const& request) {
        return child_->GetBackup(context, request);
      },
      context, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKELogging::AsyncUpdateBackup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::gkebackup::v1::UpdateBackupRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::cloud::gkebackup::v1::UpdateBackupRequest const& request) {
        return child_->AsyncUpdateBackup(cq, std::move(context), options,
                                         request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKELogging::AsyncDeleteBackup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::gkebackup::v1::DeleteBackupRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::cloud::gkebackup::v1::DeleteBackupRequest const& request) {
        return child_->AsyncDeleteBackup(cq, std::move(context), options,
                                         request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::gkebackup::v1::ListVolumeBackupsResponse>
BackupForGKELogging::ListVolumeBackups(
    grpc::ClientContext& context,
    google::cloud::gkebackup::v1::ListVolumeBackupsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::gkebackup::v1::ListVolumeBackupsRequest const&
                 request) {
        return child_->ListVolumeBackups(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::gkebackup::v1::VolumeBackup>
BackupForGKELogging::GetVolumeBackup(
    grpc::ClientContext& context,
    google::cloud::gkebackup::v1::GetVolumeBackupRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::cloud::gkebackup::v1::GetVolumeBackupRequest const& request) {
        return child_->GetVolumeBackup(context, request);
      },
      context, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKELogging::AsyncCreateRestorePlan(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::gkebackup::v1::CreateRestorePlanRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::cloud::gkebackup::v1::CreateRestorePlanRequest const&
                 request) {
        return child_->AsyncCreateRestorePlan(cq, std::move(context), options,
                                              request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::gkebackup::v1::ListRestorePlansResponse>
BackupForGKELogging::ListRestorePlans(
    grpc::ClientContext& context,
    google::cloud::gkebackup::v1::ListRestorePlansRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::gkebackup::v1::ListRestorePlansRequest const&
                 request) {
        return child_->ListRestorePlans(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::gkebackup::v1::RestorePlan>
BackupForGKELogging::GetRestorePlan(
    grpc::ClientContext& context,
    google::cloud::gkebackup::v1::GetRestorePlanRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::cloud::gkebackup::v1::GetRestorePlanRequest const& request) {
        return child_->GetRestorePlan(context, request);
      },
      context, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKELogging::AsyncUpdateRestorePlan(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::gkebackup::v1::UpdateRestorePlanRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::cloud::gkebackup::v1::UpdateRestorePlanRequest const&
                 request) {
        return child_->AsyncUpdateRestorePlan(cq, std::move(context), options,
                                              request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKELogging::AsyncDeleteRestorePlan(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::gkebackup::v1::DeleteRestorePlanRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::cloud::gkebackup::v1::DeleteRestorePlanRequest const&
                 request) {
        return child_->AsyncDeleteRestorePlan(cq, std::move(context), options,
                                              request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKELogging::AsyncCreateRestore(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::gkebackup::v1::CreateRestoreRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::gkebackup::v1::CreateRestoreRequest const& request) {
        return child_->AsyncCreateRestore(cq, std::move(context), options,
                                          request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::gkebackup::v1::ListRestoresResponse>
BackupForGKELogging::ListRestores(
    grpc::ClientContext& context,
    google::cloud::gkebackup::v1::ListRestoresRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::gkebackup::v1::ListRestoresRequest const& request) {
        return child_->ListRestores(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::gkebackup::v1::Restore> BackupForGKELogging::GetRestore(
    grpc::ClientContext& context,
    google::cloud::gkebackup::v1::GetRestoreRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::gkebackup::v1::GetRestoreRequest const& request) {
        return child_->GetRestore(context, request);
      },
      context, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKELogging::AsyncUpdateRestore(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::gkebackup::v1::UpdateRestoreRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::gkebackup::v1::UpdateRestoreRequest const& request) {
        return child_->AsyncUpdateRestore(cq, std::move(context), options,
                                          request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKELogging::AsyncDeleteRestore(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::cloud::gkebackup::v1::DeleteRestoreRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::gkebackup::v1::DeleteRestoreRequest const& request) {
        return child_->AsyncDeleteRestore(cq, std::move(context), options,
                                          request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::gkebackup::v1::ListVolumeRestoresResponse>
BackupForGKELogging::ListVolumeRestores(
    grpc::ClientContext& context,
    google::cloud::gkebackup::v1::ListVolumeRestoresRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::gkebackup::v1::ListVolumeRestoresRequest const&
                 request) {
        return child_->ListVolumeRestores(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::gkebackup::v1::VolumeRestore>
BackupForGKELogging::GetVolumeRestore(
    grpc::ClientContext& context,
    google::cloud::gkebackup::v1::GetVolumeRestoreRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::gkebackup::v1::GetVolumeRestoreRequest const&
                 request) {
        return child_->GetVolumeRestore(context, request);
      },
      context, request, __func__, tracing_options_);
}

future<StatusOr<google::longrunning::Operation>>
BackupForGKELogging::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::GetOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::longrunning::GetOperationRequest const& request) {
        return child_->AsyncGetOperation(cq, std::move(context), options,
                                         request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

future<Status> BackupForGKELogging::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context, Options const& options,
    google::longrunning::CancelOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             Options const& options,
             google::longrunning::CancelOperationRequest const& request) {
        return child_->AsyncCancelOperation(cq, std::move(context), options,
                                            request);
      },
      cq, std::move(context), options, request, __func__, tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gkebackup_v1_internal
}  // namespace cloud
}  // namespace google
