// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/privacy/dlp/v2/dlp.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DLP_V2_MOCKS_MOCK_DLP_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DLP_V2_MOCKS_MOCK_DLP_CONNECTION_H

#include "google/cloud/dlp/v2/dlp_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace dlp_v2_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * A class to mock `DlpServiceConnection`.
 *
 * Application developers may want to test their code with simulated responses,
 * including errors, from an object of type `DlpServiceClient`. To do so,
 * construct an object of type `DlpServiceClient` with an instance of this
 * class. Then use the Google Test framework functions to program the behavior
 * of this mock.
 *
 * @see [This example][bq-mock] for how to test your application with GoogleTest.
 * While the example showcases types from the BigQuery library, the underlying
 * principles apply for any pair of `*Client` and `*Connection`.
 *
 * [bq-mock]: @cloud_cpp_docs_link{bigquery,bigquery-read-mock}
 */
class MockDlpServiceConnection : public dlp_v2::DlpServiceConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  MOCK_METHOD(StatusOr<google::privacy::dlp::v2::InspectContentResponse>,
              InspectContent,
              (google::privacy::dlp::v2::InspectContentRequest const& request),
              (override));

  MOCK_METHOD(StatusOr<google::privacy::dlp::v2::RedactImageResponse>,
              RedactImage,
              (google::privacy::dlp::v2::RedactImageRequest const& request),
              (override));

  MOCK_METHOD(
      StatusOr<google::privacy::dlp::v2::DeidentifyContentResponse>,
      DeidentifyContent,
      (google::privacy::dlp::v2::DeidentifyContentRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::privacy::dlp::v2::ReidentifyContentResponse>,
      ReidentifyContent,
      (google::privacy::dlp::v2::ReidentifyContentRequest const& request),
      (override));

  MOCK_METHOD(StatusOr<google::privacy::dlp::v2::ListInfoTypesResponse>,
              ListInfoTypes,
              (google::privacy::dlp::v2::ListInfoTypesRequest const& request),
              (override));

  MOCK_METHOD(
      StatusOr<google::privacy::dlp::v2::InspectTemplate>,
      CreateInspectTemplate,
      (google::privacy::dlp::v2::CreateInspectTemplateRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::privacy::dlp::v2::InspectTemplate>,
      UpdateInspectTemplate,
      (google::privacy::dlp::v2::UpdateInspectTemplateRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::privacy::dlp::v2::InspectTemplate>, GetInspectTemplate,
      (google::privacy::dlp::v2::GetInspectTemplateRequest const& request),
      (override));

  MOCK_METHOD((StreamRange<google::privacy::dlp::v2::InspectTemplate>),
              ListInspectTemplates,
              (google::privacy::dlp::v2::ListInspectTemplatesRequest request),
              (override));

  MOCK_METHOD(
      Status, DeleteInspectTemplate,
      (google::privacy::dlp::v2::DeleteInspectTemplateRequest const& request),
      (override));

  MOCK_METHOD(StatusOr<google::privacy::dlp::v2::DeidentifyTemplate>,
              CreateDeidentifyTemplate,
              (google::privacy::dlp::v2::CreateDeidentifyTemplateRequest const&
                   request),
              (override));

  MOCK_METHOD(StatusOr<google::privacy::dlp::v2::DeidentifyTemplate>,
              UpdateDeidentifyTemplate,
              (google::privacy::dlp::v2::UpdateDeidentifyTemplateRequest const&
                   request),
              (override));

  MOCK_METHOD(
      StatusOr<google::privacy::dlp::v2::DeidentifyTemplate>,
      GetDeidentifyTemplate,
      (google::privacy::dlp::v2::GetDeidentifyTemplateRequest const& request),
      (override));

  MOCK_METHOD(
      (StreamRange<google::privacy::dlp::v2::DeidentifyTemplate>),
      ListDeidentifyTemplates,
      (google::privacy::dlp::v2::ListDeidentifyTemplatesRequest request),
      (override));

  MOCK_METHOD(Status, DeleteDeidentifyTemplate,
              (google::privacy::dlp::v2::DeleteDeidentifyTemplateRequest const&
                   request),
              (override));

  MOCK_METHOD(
      StatusOr<google::privacy::dlp::v2::JobTrigger>, CreateJobTrigger,
      (google::privacy::dlp::v2::CreateJobTriggerRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::privacy::dlp::v2::JobTrigger>, UpdateJobTrigger,
      (google::privacy::dlp::v2::UpdateJobTriggerRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::privacy::dlp::v2::HybridInspectResponse>,
      HybridInspectJobTrigger,
      (google::privacy::dlp::v2::HybridInspectJobTriggerRequest const& request),
      (override));

  MOCK_METHOD(StatusOr<google::privacy::dlp::v2::JobTrigger>, GetJobTrigger,
              (google::privacy::dlp::v2::GetJobTriggerRequest const& request),
              (override));

  MOCK_METHOD((StreamRange<google::privacy::dlp::v2::JobTrigger>),
              ListJobTriggers,
              (google::privacy::dlp::v2::ListJobTriggersRequest request),
              (override));

  MOCK_METHOD(
      Status, DeleteJobTrigger,
      (google::privacy::dlp::v2::DeleteJobTriggerRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::privacy::dlp::v2::DlpJob>, ActivateJobTrigger,
      (google::privacy::dlp::v2::ActivateJobTriggerRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::privacy::dlp::v2::DiscoveryConfig>,
      CreateDiscoveryConfig,
      (google::privacy::dlp::v2::CreateDiscoveryConfigRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::privacy::dlp::v2::DiscoveryConfig>,
      UpdateDiscoveryConfig,
      (google::privacy::dlp::v2::UpdateDiscoveryConfigRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::privacy::dlp::v2::DiscoveryConfig>, GetDiscoveryConfig,
      (google::privacy::dlp::v2::GetDiscoveryConfigRequest const& request),
      (override));

  MOCK_METHOD((StreamRange<google::privacy::dlp::v2::DiscoveryConfig>),
              ListDiscoveryConfigs,
              (google::privacy::dlp::v2::ListDiscoveryConfigsRequest request),
              (override));

  MOCK_METHOD(
      Status, DeleteDiscoveryConfig,
      (google::privacy::dlp::v2::DeleteDiscoveryConfigRequest const& request),
      (override));

  MOCK_METHOD(StatusOr<google::privacy::dlp::v2::DlpJob>, CreateDlpJob,
              (google::privacy::dlp::v2::CreateDlpJobRequest const& request),
              (override));

  MOCK_METHOD((StreamRange<google::privacy::dlp::v2::DlpJob>), ListDlpJobs,
              (google::privacy::dlp::v2::ListDlpJobsRequest request),
              (override));

  MOCK_METHOD(StatusOr<google::privacy::dlp::v2::DlpJob>, GetDlpJob,
              (google::privacy::dlp::v2::GetDlpJobRequest const& request),
              (override));

  MOCK_METHOD(Status, DeleteDlpJob,
              (google::privacy::dlp::v2::DeleteDlpJobRequest const& request),
              (override));

  MOCK_METHOD(Status, CancelDlpJob,
              (google::privacy::dlp::v2::CancelDlpJobRequest const& request),
              (override));

  MOCK_METHOD(
      StatusOr<google::privacy::dlp::v2::StoredInfoType>, CreateStoredInfoType,
      (google::privacy::dlp::v2::CreateStoredInfoTypeRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::privacy::dlp::v2::StoredInfoType>, UpdateStoredInfoType,
      (google::privacy::dlp::v2::UpdateStoredInfoTypeRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::privacy::dlp::v2::StoredInfoType>, GetStoredInfoType,
      (google::privacy::dlp::v2::GetStoredInfoTypeRequest const& request),
      (override));

  MOCK_METHOD((StreamRange<google::privacy::dlp::v2::StoredInfoType>),
              ListStoredInfoTypes,
              (google::privacy::dlp::v2::ListStoredInfoTypesRequest request),
              (override));

  MOCK_METHOD(
      Status, DeleteStoredInfoType,
      (google::privacy::dlp::v2::DeleteStoredInfoTypeRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::privacy::dlp::v2::HybridInspectResponse>,
      HybridInspectDlpJob,
      (google::privacy::dlp::v2::HybridInspectDlpJobRequest const& request),
      (override));

  MOCK_METHOD(Status, FinishDlpJob,
              (google::privacy::dlp::v2::FinishDlpJobRequest const& request),
              (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dlp_v2_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DLP_V2_MOCKS_MOCK_DLP_CONNECTION_H
