// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/conversational_search_service.proto

#include "google/cloud/discoveryengine/v1/conversational_search_connection.h"
#include "google/cloud/discoveryengine/v1/conversational_search_options.h"
#include "google/cloud/discoveryengine/v1/internal/conversational_search_connection_impl.h"
#include "google/cloud/discoveryengine/v1/internal/conversational_search_option_defaults.h"
#include "google/cloud/discoveryengine/v1/internal/conversational_search_stub_factory.h"
#include "google/cloud/discoveryengine/v1/internal/conversational_search_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace discoveryengine_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ConversationalSearchServiceConnection::
    ~ConversationalSearchServiceConnection() = default;

StatusOr<google::cloud::discoveryengine::v1::ConverseConversationResponse>
ConversationalSearchServiceConnection::ConverseConversation(
    google::cloud::discoveryengine::v1::ConverseConversationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::discoveryengine::v1::Conversation>
ConversationalSearchServiceConnection::CreateConversation(
    google::cloud::discoveryengine::v1::CreateConversationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status ConversationalSearchServiceConnection::DeleteConversation(
    google::cloud::discoveryengine::v1::DeleteConversationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::discoveryengine::v1::Conversation>
ConversationalSearchServiceConnection::UpdateConversation(
    google::cloud::discoveryengine::v1::UpdateConversationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::discoveryengine::v1::Conversation>
ConversationalSearchServiceConnection::GetConversation(
    google::cloud::discoveryengine::v1::GetConversationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::discoveryengine::v1::Conversation>
ConversationalSearchServiceConnection::ListConversations(
    google::cloud::discoveryengine::v1::
        ListConversationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::discoveryengine::v1::Conversation>>();
}

std::shared_ptr<ConversationalSearchServiceConnection>
MakeConversationalSearchServiceConnection(Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 ConversationalSearchServicePolicyOptionList>(
      options, __func__);
  options =
      discoveryengine_v1_internal::ConversationalSearchServiceDefaultOptions(
          std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub =
      discoveryengine_v1_internal::CreateDefaultConversationalSearchServiceStub(
          background->cq(), options);
  return discoveryengine_v1_internal::
      MakeConversationalSearchServiceTracingConnection(
          std::make_shared<discoveryengine_v1_internal::
                               ConversationalSearchServiceConnectionImpl>(
              std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1
}  // namespace cloud
}  // namespace google
