// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/knowledge_base.proto

#include "google/cloud/dialogflow_es/internal/knowledge_bases_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace dialogflow_es_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

KnowledgeBasesTracingConnection::KnowledgeBasesTracingConnection(
    std::shared_ptr<dialogflow_es::KnowledgeBasesConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::dialogflow::v2::KnowledgeBase>
KnowledgeBasesTracingConnection::ListKnowledgeBases(
    google::cloud::dialogflow::v2::ListKnowledgeBasesRequest request) {
  auto span = internal::MakeSpan(
      "dialogflow_es::KnowledgeBasesConnection::ListKnowledgeBases");
  internal::OTelScope scope(span);
  auto sr = child_->ListKnowledgeBases(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::dialogflow::v2::KnowledgeBase>(std::move(span),
                                                    std::move(sr));
}

StatusOr<google::cloud::dialogflow::v2::KnowledgeBase>
KnowledgeBasesTracingConnection::GetKnowledgeBase(
    google::cloud::dialogflow::v2::GetKnowledgeBaseRequest const& request) {
  auto span = internal::MakeSpan(
      "dialogflow_es::KnowledgeBasesConnection::GetKnowledgeBase");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetKnowledgeBase(request));
}

StatusOr<google::cloud::dialogflow::v2::KnowledgeBase>
KnowledgeBasesTracingConnection::CreateKnowledgeBase(
    google::cloud::dialogflow::v2::CreateKnowledgeBaseRequest const& request) {
  auto span = internal::MakeSpan(
      "dialogflow_es::KnowledgeBasesConnection::CreateKnowledgeBase");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateKnowledgeBase(request));
}

Status KnowledgeBasesTracingConnection::DeleteKnowledgeBase(
    google::cloud::dialogflow::v2::DeleteKnowledgeBaseRequest const& request) {
  auto span = internal::MakeSpan(
      "dialogflow_es::KnowledgeBasesConnection::DeleteKnowledgeBase");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteKnowledgeBase(request));
}

StatusOr<google::cloud::dialogflow::v2::KnowledgeBase>
KnowledgeBasesTracingConnection::UpdateKnowledgeBase(
    google::cloud::dialogflow::v2::UpdateKnowledgeBaseRequest const& request) {
  auto span = internal::MakeSpan(
      "dialogflow_es::KnowledgeBasesConnection::UpdateKnowledgeBase");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateKnowledgeBase(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<dialogflow_es::KnowledgeBasesConnection>
MakeKnowledgeBasesTracingConnection(
    std::shared_ptr<dialogflow_es::KnowledgeBasesConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<KnowledgeBasesTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es_internal
}  // namespace cloud
}  // namespace google
