// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/conversation_dataset.proto

#include "google/cloud/dialogflow_es/conversation_datasets_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace dialogflow_es {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ConversationDatasetsClient::ConversationDatasetsClient(
    std::shared_ptr<ConversationDatasetsConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
ConversationDatasetsClient::~ConversationDatasetsClient() = default;

future<StatusOr<google::cloud::dialogflow::v2::ConversationDataset>>
ConversationDatasetsClient::CreateConversationDataset(
    std::string const& parent,
    google::cloud::dialogflow::v2::ConversationDataset const&
        conversation_dataset,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::CreateConversationDatasetRequest request;
  request.set_parent(parent);
  *request.mutable_conversation_dataset() = conversation_dataset;
  return connection_->CreateConversationDataset(request);
}

future<StatusOr<google::cloud::dialogflow::v2::ConversationDataset>>
ConversationDatasetsClient::CreateConversationDataset(
    google::cloud::dialogflow::v2::CreateConversationDatasetRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateConversationDataset(request);
}

StatusOr<google::cloud::dialogflow::v2::ConversationDataset>
ConversationDatasetsClient::GetConversationDataset(std::string const& name,
                                                   Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::GetConversationDatasetRequest request;
  request.set_name(name);
  return connection_->GetConversationDataset(request);
}

StatusOr<google::cloud::dialogflow::v2::ConversationDataset>
ConversationDatasetsClient::GetConversationDataset(
    google::cloud::dialogflow::v2::GetConversationDatasetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetConversationDataset(request);
}

StreamRange<google::cloud::dialogflow::v2::ConversationDataset>
ConversationDatasetsClient::ListConversationDatasets(std::string const& parent,
                                                     Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::ListConversationDatasetsRequest request;
  request.set_parent(parent);
  return connection_->ListConversationDatasets(request);
}

StreamRange<google::cloud::dialogflow::v2::ConversationDataset>
ConversationDatasetsClient::ListConversationDatasets(
    google::cloud::dialogflow::v2::ListConversationDatasetsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListConversationDatasets(std::move(request));
}

future<StatusOr<
    google::cloud::dialogflow::v2::DeleteConversationDatasetOperationMetadata>>
ConversationDatasetsClient::DeleteConversationDataset(std::string const& name,
                                                      Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::DeleteConversationDatasetRequest request;
  request.set_name(name);
  return connection_->DeleteConversationDataset(request);
}

future<StatusOr<
    google::cloud::dialogflow::v2::DeleteConversationDatasetOperationMetadata>>
ConversationDatasetsClient::DeleteConversationDataset(
    google::cloud::dialogflow::v2::DeleteConversationDatasetRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteConversationDataset(request);
}

future<StatusOr<
    google::cloud::dialogflow::v2::ImportConversationDataOperationResponse>>
ConversationDatasetsClient::ImportConversationData(
    google::cloud::dialogflow::v2::ImportConversationDataRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ImportConversationData(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es
}  // namespace cloud
}  // namespace google
