// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataplex/v1/service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPLEX_V1_INTERNAL_DATAPLEX_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPLEX_V1_INTERNAL_DATAPLEX_TRACING_CONNECTION_H

#include "google/cloud/dataplex/v1/dataplex_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace dataplex_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class DataplexServiceTracingConnection
    : public dataplex_v1::DataplexServiceConnection {
 public:
  ~DataplexServiceTracingConnection() override = default;

  explicit DataplexServiceTracingConnection(
      std::shared_ptr<dataplex_v1::DataplexServiceConnection> child);

  Options options() override { return child_->options(); }

  future<StatusOr<google::cloud::dataplex::v1::Lake>> CreateLake(
      google::cloud::dataplex::v1::CreateLakeRequest const& request) override;

  future<StatusOr<google::cloud::dataplex::v1::Lake>> UpdateLake(
      google::cloud::dataplex::v1::UpdateLakeRequest const& request) override;

  future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>> DeleteLake(
      google::cloud::dataplex::v1::DeleteLakeRequest const& request) override;

  StreamRange<google::cloud::dataplex::v1::Lake> ListLakes(
      google::cloud::dataplex::v1::ListLakesRequest request) override;

  StatusOr<google::cloud::dataplex::v1::Lake> GetLake(
      google::cloud::dataplex::v1::GetLakeRequest const& request) override;

  StreamRange<google::cloud::dataplex::v1::Action> ListLakeActions(
      google::cloud::dataplex::v1::ListLakeActionsRequest request) override;

  future<StatusOr<google::cloud::dataplex::v1::Zone>> CreateZone(
      google::cloud::dataplex::v1::CreateZoneRequest const& request) override;

  future<StatusOr<google::cloud::dataplex::v1::Zone>> UpdateZone(
      google::cloud::dataplex::v1::UpdateZoneRequest const& request) override;

  future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>> DeleteZone(
      google::cloud::dataplex::v1::DeleteZoneRequest const& request) override;

  StreamRange<google::cloud::dataplex::v1::Zone> ListZones(
      google::cloud::dataplex::v1::ListZonesRequest request) override;

  StatusOr<google::cloud::dataplex::v1::Zone> GetZone(
      google::cloud::dataplex::v1::GetZoneRequest const& request) override;

  StreamRange<google::cloud::dataplex::v1::Action> ListZoneActions(
      google::cloud::dataplex::v1::ListZoneActionsRequest request) override;

  future<StatusOr<google::cloud::dataplex::v1::Asset>> CreateAsset(
      google::cloud::dataplex::v1::CreateAssetRequest const& request) override;

  future<StatusOr<google::cloud::dataplex::v1::Asset>> UpdateAsset(
      google::cloud::dataplex::v1::UpdateAssetRequest const& request) override;

  future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>> DeleteAsset(
      google::cloud::dataplex::v1::DeleteAssetRequest const& request) override;

  StreamRange<google::cloud::dataplex::v1::Asset> ListAssets(
      google::cloud::dataplex::v1::ListAssetsRequest request) override;

  StatusOr<google::cloud::dataplex::v1::Asset> GetAsset(
      google::cloud::dataplex::v1::GetAssetRequest const& request) override;

  StreamRange<google::cloud::dataplex::v1::Action> ListAssetActions(
      google::cloud::dataplex::v1::ListAssetActionsRequest request) override;

  future<StatusOr<google::cloud::dataplex::v1::Task>> CreateTask(
      google::cloud::dataplex::v1::CreateTaskRequest const& request) override;

  future<StatusOr<google::cloud::dataplex::v1::Task>> UpdateTask(
      google::cloud::dataplex::v1::UpdateTaskRequest const& request) override;

  future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>> DeleteTask(
      google::cloud::dataplex::v1::DeleteTaskRequest const& request) override;

  StreamRange<google::cloud::dataplex::v1::Task> ListTasks(
      google::cloud::dataplex::v1::ListTasksRequest request) override;

  StatusOr<google::cloud::dataplex::v1::Task> GetTask(
      google::cloud::dataplex::v1::GetTaskRequest const& request) override;

  StreamRange<google::cloud::dataplex::v1::Job> ListJobs(
      google::cloud::dataplex::v1::ListJobsRequest request) override;

  StatusOr<google::cloud::dataplex::v1::RunTaskResponse> RunTask(
      google::cloud::dataplex::v1::RunTaskRequest const& request) override;

  StatusOr<google::cloud::dataplex::v1::Job> GetJob(
      google::cloud::dataplex::v1::GetJobRequest const& request) override;

  Status CancelJob(
      google::cloud::dataplex::v1::CancelJobRequest const& request) override;

  future<StatusOr<google::cloud::dataplex::v1::Environment>> CreateEnvironment(
      google::cloud::dataplex::v1::CreateEnvironmentRequest const& request)
      override;

  future<StatusOr<google::cloud::dataplex::v1::Environment>> UpdateEnvironment(
      google::cloud::dataplex::v1::UpdateEnvironmentRequest const& request)
      override;

  future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
  DeleteEnvironment(google::cloud::dataplex::v1::DeleteEnvironmentRequest const&
                        request) override;

  StreamRange<google::cloud::dataplex::v1::Environment> ListEnvironments(
      google::cloud::dataplex::v1::ListEnvironmentsRequest request) override;

  StatusOr<google::cloud::dataplex::v1::Environment> GetEnvironment(
      google::cloud::dataplex::v1::GetEnvironmentRequest const& request)
      override;

  StreamRange<google::cloud::dataplex::v1::Session> ListSessions(
      google::cloud::dataplex::v1::ListSessionsRequest request) override;

 private:
  std::shared_ptr<dataplex_v1::DataplexServiceConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<dataplex_v1::DataplexServiceConnection>
MakeDataplexServiceTracingConnection(
    std::shared_ptr<dataplex_v1::DataplexServiceConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataplex_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPLEX_V1_INTERNAL_DATAPLEX_TRACING_CONNECTION_H
