// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/datacatalog/v1/datacatalog.proto

#include "google/cloud/datacatalog/v1/data_catalog_connection.h"
#include "google/cloud/datacatalog/v1/data_catalog_options.h"
#include "google/cloud/datacatalog/v1/internal/data_catalog_connection_impl.h"
#include "google/cloud/datacatalog/v1/internal/data_catalog_option_defaults.h"
#include "google/cloud/datacatalog/v1/internal/data_catalog_stub_factory.h"
#include "google/cloud/datacatalog/v1/internal/data_catalog_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace datacatalog_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DataCatalogConnection::~DataCatalogConnection() = default;

StreamRange<google::cloud::datacatalog::v1::SearchCatalogResult>
DataCatalogConnection::SearchCatalog(
    google::cloud::datacatalog::v1::
        SearchCatalogRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::datacatalog::v1::SearchCatalogResult>>();
}

StatusOr<google::cloud::datacatalog::v1::EntryGroup>
DataCatalogConnection::CreateEntryGroup(
    google::cloud::datacatalog::v1::CreateEntryGroupRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::datacatalog::v1::EntryGroup>
DataCatalogConnection::GetEntryGroup(
    google::cloud::datacatalog::v1::GetEntryGroupRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::datacatalog::v1::EntryGroup>
DataCatalogConnection::UpdateEntryGroup(
    google::cloud::datacatalog::v1::UpdateEntryGroupRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status DataCatalogConnection::DeleteEntryGroup(
    google::cloud::datacatalog::v1::DeleteEntryGroupRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::datacatalog::v1::EntryGroup>
DataCatalogConnection::ListEntryGroups(
    google::cloud::datacatalog::v1::
        ListEntryGroupsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::datacatalog::v1::EntryGroup>>();
}

StatusOr<google::cloud::datacatalog::v1::Entry>
DataCatalogConnection::CreateEntry(
    google::cloud::datacatalog::v1::CreateEntryRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::datacatalog::v1::Entry>
DataCatalogConnection::UpdateEntry(
    google::cloud::datacatalog::v1::UpdateEntryRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status DataCatalogConnection::DeleteEntry(
    google::cloud::datacatalog::v1::DeleteEntryRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::datacatalog::v1::Entry> DataCatalogConnection::GetEntry(
    google::cloud::datacatalog::v1::GetEntryRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::datacatalog::v1::Entry>
DataCatalogConnection::LookupEntry(
    google::cloud::datacatalog::v1::LookupEntryRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::datacatalog::v1::Entry>
DataCatalogConnection::ListEntries(
    google::cloud::datacatalog::v1::
        ListEntriesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::datacatalog::v1::Entry>>();
}

StatusOr<google::cloud::datacatalog::v1::EntryOverview>
DataCatalogConnection::ModifyEntryOverview(
    google::cloud::datacatalog::v1::ModifyEntryOverviewRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::datacatalog::v1::Contacts>
DataCatalogConnection::ModifyEntryContacts(
    google::cloud::datacatalog::v1::ModifyEntryContactsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::datacatalog::v1::TagTemplate>
DataCatalogConnection::CreateTagTemplate(
    google::cloud::datacatalog::v1::CreateTagTemplateRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::datacatalog::v1::TagTemplate>
DataCatalogConnection::GetTagTemplate(
    google::cloud::datacatalog::v1::GetTagTemplateRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::datacatalog::v1::TagTemplate>
DataCatalogConnection::UpdateTagTemplate(
    google::cloud::datacatalog::v1::UpdateTagTemplateRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status DataCatalogConnection::DeleteTagTemplate(
    google::cloud::datacatalog::v1::DeleteTagTemplateRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::datacatalog::v1::TagTemplateField>
DataCatalogConnection::CreateTagTemplateField(
    google::cloud::datacatalog::v1::CreateTagTemplateFieldRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::datacatalog::v1::TagTemplateField>
DataCatalogConnection::UpdateTagTemplateField(
    google::cloud::datacatalog::v1::UpdateTagTemplateFieldRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::datacatalog::v1::TagTemplateField>
DataCatalogConnection::RenameTagTemplateField(
    google::cloud::datacatalog::v1::RenameTagTemplateFieldRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::datacatalog::v1::TagTemplateField>
DataCatalogConnection::RenameTagTemplateFieldEnumValue(
    google::cloud::datacatalog::v1::
        RenameTagTemplateFieldEnumValueRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status DataCatalogConnection::DeleteTagTemplateField(
    google::cloud::datacatalog::v1::DeleteTagTemplateFieldRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::datacatalog::v1::Tag> DataCatalogConnection::CreateTag(
    google::cloud::datacatalog::v1::CreateTagRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::datacatalog::v1::Tag> DataCatalogConnection::UpdateTag(
    google::cloud::datacatalog::v1::UpdateTagRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status DataCatalogConnection::DeleteTag(
    google::cloud::datacatalog::v1::DeleteTagRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::datacatalog::v1::Tag>
DataCatalogConnection::ListTags(
    google::cloud::datacatalog::v1::
        ListTagsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::datacatalog::v1::Tag>>();
}

future<StatusOr<google::cloud::datacatalog::v1::ReconcileTagsResponse>>
DataCatalogConnection::ReconcileTags(
    google::cloud::datacatalog::v1::ReconcileTagsRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::datacatalog::v1::ReconcileTagsResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::datacatalog::v1::StarEntryResponse>
DataCatalogConnection::StarEntry(
    google::cloud::datacatalog::v1::StarEntryRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::datacatalog::v1::UnstarEntryResponse>
DataCatalogConnection::UnstarEntry(
    google::cloud::datacatalog::v1::UnstarEntryRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> DataCatalogConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> DataCatalogConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
DataCatalogConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::datacatalog::v1::ImportEntriesResponse>>
DataCatalogConnection::ImportEntries(
    google::cloud::datacatalog::v1::ImportEntriesRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::datacatalog::v1::ImportEntriesResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

std::shared_ptr<DataCatalogConnection> MakeDataCatalogConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 DataCatalogPolicyOptionList>(options,
                                                              __func__);
  options =
      datacatalog_v1_internal::DataCatalogDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = datacatalog_v1_internal::CreateDefaultDataCatalogStub(
      background->cq(), options);
  return datacatalog_v1_internal::MakeDataCatalogTracingConnection(
      std::make_shared<datacatalog_v1_internal::DataCatalogConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datacatalog_v1
}  // namespace cloud
}  // namespace google
