// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/config/v1/config.proto

#include "google/cloud/config/v1/internal/config_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace config_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

ConfigTracingConnection::ConfigTracingConnection(
    std::shared_ptr<config_v1::ConfigConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::config::v1::Deployment>
ConfigTracingConnection::ListDeployments(
    google::cloud::config::v1::ListDeploymentsRequest request) {
  auto span =
      internal::MakeSpan("config_v1::ConfigConnection::ListDeployments");
  internal::OTelScope scope(span);
  auto sr = child_->ListDeployments(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::config::v1::Deployment>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::config::v1::Deployment>
ConfigTracingConnection::GetDeployment(
    google::cloud::config::v1::GetDeploymentRequest const& request) {
  auto span = internal::MakeSpan("config_v1::ConfigConnection::GetDeployment");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetDeployment(request));
}

future<StatusOr<google::cloud::config::v1::Deployment>>
ConfigTracingConnection::CreateDeployment(
    google::cloud::config::v1::CreateDeploymentRequest const& request) {
  auto span =
      internal::MakeSpan("config_v1::ConfigConnection::CreateDeployment");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateDeployment(request));
}

future<StatusOr<google::cloud::config::v1::Deployment>>
ConfigTracingConnection::UpdateDeployment(
    google::cloud::config::v1::UpdateDeploymentRequest const& request) {
  auto span =
      internal::MakeSpan("config_v1::ConfigConnection::UpdateDeployment");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateDeployment(request));
}

future<StatusOr<google::cloud::config::v1::Deployment>>
ConfigTracingConnection::DeleteDeployment(
    google::cloud::config::v1::DeleteDeploymentRequest const& request) {
  auto span =
      internal::MakeSpan("config_v1::ConfigConnection::DeleteDeployment");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteDeployment(request));
}

StreamRange<google::cloud::config::v1::Revision>
ConfigTracingConnection::ListRevisions(
    google::cloud::config::v1::ListRevisionsRequest request) {
  auto span = internal::MakeSpan("config_v1::ConfigConnection::ListRevisions");
  internal::OTelScope scope(span);
  auto sr = child_->ListRevisions(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::config::v1::Revision>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::config::v1::Revision>
ConfigTracingConnection::GetRevision(
    google::cloud::config::v1::GetRevisionRequest const& request) {
  auto span = internal::MakeSpan("config_v1::ConfigConnection::GetRevision");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetRevision(request));
}

StatusOr<google::cloud::config::v1::Resource>
ConfigTracingConnection::GetResource(
    google::cloud::config::v1::GetResourceRequest const& request) {
  auto span = internal::MakeSpan("config_v1::ConfigConnection::GetResource");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetResource(request));
}

StreamRange<google::cloud::config::v1::Resource>
ConfigTracingConnection::ListResources(
    google::cloud::config::v1::ListResourcesRequest request) {
  auto span = internal::MakeSpan("config_v1::ConfigConnection::ListResources");
  internal::OTelScope scope(span);
  auto sr = child_->ListResources(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::config::v1::Resource>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::config::v1::Statefile>
ConfigTracingConnection::ExportDeploymentStatefile(
    google::cloud::config::v1::ExportDeploymentStatefileRequest const&
        request) {
  auto span = internal::MakeSpan(
      "config_v1::ConfigConnection::ExportDeploymentStatefile");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->ExportDeploymentStatefile(request));
}

StatusOr<google::cloud::config::v1::Statefile>
ConfigTracingConnection::ExportRevisionStatefile(
    google::cloud::config::v1::ExportRevisionStatefileRequest const& request) {
  auto span = internal::MakeSpan(
      "config_v1::ConfigConnection::ExportRevisionStatefile");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->ExportRevisionStatefile(request));
}

StatusOr<google::cloud::config::v1::Statefile>
ConfigTracingConnection::ImportStatefile(
    google::cloud::config::v1::ImportStatefileRequest const& request) {
  auto span =
      internal::MakeSpan("config_v1::ConfigConnection::ImportStatefile");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->ImportStatefile(request));
}

Status ConfigTracingConnection::DeleteStatefile(
    google::cloud::config::v1::DeleteStatefileRequest const& request) {
  auto span =
      internal::MakeSpan("config_v1::ConfigConnection::DeleteStatefile");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteStatefile(request));
}

future<StatusOr<google::cloud::config::v1::Deployment>>
ConfigTracingConnection::LockDeployment(
    google::cloud::config::v1::LockDeploymentRequest const& request) {
  auto span = internal::MakeSpan("config_v1::ConfigConnection::LockDeployment");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->LockDeployment(request));
}

future<StatusOr<google::cloud::config::v1::Deployment>>
ConfigTracingConnection::UnlockDeployment(
    google::cloud::config::v1::UnlockDeploymentRequest const& request) {
  auto span =
      internal::MakeSpan("config_v1::ConfigConnection::UnlockDeployment");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UnlockDeployment(request));
}

StatusOr<google::cloud::config::v1::LockInfo>
ConfigTracingConnection::ExportLockInfo(
    google::cloud::config::v1::ExportLockInfoRequest const& request) {
  auto span = internal::MakeSpan("config_v1::ConfigConnection::ExportLockInfo");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->ExportLockInfo(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<config_v1::ConfigConnection> MakeConfigTracingConnection(
    std::shared_ptr<config_v1::ConfigConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<ConfigTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace config_v1_internal
}  // namespace cloud
}  // namespace google
