// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/routers/v1/routers.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_ROUTERS_V1_ROUTERS_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_ROUTERS_V1_ROUTERS_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/compute/routers/v1/routers.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace compute_routers_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class RoutersConnectionIdempotencyPolicy {
 public:
  virtual ~RoutersConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<RoutersConnectionIdempotencyPolicy> clone() const;

  virtual google::cloud::Idempotency AggregatedListRouters(
      google::cloud::cpp::compute::routers::v1::AggregatedListRoutersRequest
          request);

  virtual google::cloud::Idempotency DeleteRouter(
      google::cloud::cpp::compute::routers::v1::DeleteRouterRequest const&
          request);

  virtual google::cloud::Idempotency GetRouter(
      google::cloud::cpp::compute::routers::v1::GetRouterRequest const&
          request);

  virtual google::cloud::Idempotency GetNatIpInfo(
      google::cloud::cpp::compute::routers::v1::GetNatIpInfoRequest const&
          request);

  virtual google::cloud::Idempotency GetNatMappingInfo(
      google::cloud::cpp::compute::routers::v1::GetNatMappingInfoRequest const&
          request);

  virtual google::cloud::Idempotency GetRouterStatus(
      google::cloud::cpp::compute::routers::v1::GetRouterStatusRequest const&
          request);

  virtual google::cloud::Idempotency InsertRouter(
      google::cloud::cpp::compute::routers::v1::InsertRouterRequest const&
          request);

  virtual google::cloud::Idempotency ListRouters(
      google::cloud::cpp::compute::routers::v1::ListRoutersRequest request);

  virtual google::cloud::Idempotency PatchRouter(
      google::cloud::cpp::compute::routers::v1::PatchRouterRequest const&
          request);

  virtual google::cloud::Idempotency Preview(
      google::cloud::cpp::compute::routers::v1::PreviewRequest const& request);

  virtual google::cloud::Idempotency UpdateRouter(
      google::cloud::cpp::compute::routers::v1::UpdateRouterRequest const&
          request);
};

std::unique_ptr<RoutersConnectionIdempotencyPolicy>
MakeDefaultRoutersConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_routers_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_ROUTERS_V1_ROUTERS_CONNECTION_IDEMPOTENCY_POLICY_H
