// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/compute/global_network_endpoint_groups/v1/global_network_endpoint_groups.proto

#include "google/cloud/compute/global_network_endpoint_groups/v1/internal/global_network_endpoint_groups_option_defaults.h"
#include "google/cloud/compute/global_network_endpoint_groups/v1/global_network_endpoint_groups_connection.h"
#include "google/cloud/compute/global_network_endpoint_groups/v1/global_network_endpoint_groups_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_global_network_endpoint_groups_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options GlobalNetworkEndpointGroupsDefaultOptions(Options options) {
  options = google::cloud::internal::PopulateCommonOptions(
      std::move(options),
      "GOOGLE_CLOUD_CPP_GLOBAL_NETWORK_ENDPOINT_GROUPS_ENDPOINT", "",
      "GOOGLE_CLOUD_CPP_GLOBAL_NETWORK_ENDPOINT_GROUPS_AUTHORITY",
      "compute.googleapis.com");
  options =
      google::cloud::internal::PopulateGrpcOptions(std::move(options), "");
  if (!options.has<compute_global_network_endpoint_groups_v1::
                       GlobalNetworkEndpointGroupsRetryPolicyOption>()) {
    options.set<compute_global_network_endpoint_groups_v1::
                    GlobalNetworkEndpointGroupsRetryPolicyOption>(
        compute_global_network_endpoint_groups_v1::
            GlobalNetworkEndpointGroupsLimitedTimeRetryPolicy(
                std::chrono::minutes(30))
                .clone());
  }
  if (!options.has<compute_global_network_endpoint_groups_v1::
                       GlobalNetworkEndpointGroupsBackoffPolicyOption>()) {
    options.set<compute_global_network_endpoint_groups_v1::
                    GlobalNetworkEndpointGroupsBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options.has<compute_global_network_endpoint_groups_v1::
                       GlobalNetworkEndpointGroupsPollingPolicyOption>()) {
    options.set<compute_global_network_endpoint_groups_v1::
                    GlobalNetworkEndpointGroupsPollingPolicyOption>(
        GenericPollingPolicy<
            compute_global_network_endpoint_groups_v1::
                GlobalNetworkEndpointGroupsRetryPolicyOption::Type,
            compute_global_network_endpoint_groups_v1::
                GlobalNetworkEndpointGroupsBackoffPolicyOption::Type>(
            options
                .get<compute_global_network_endpoint_groups_v1::
                         GlobalNetworkEndpointGroupsRetryPolicyOption>()
                ->clone(),
            ExponentialBackoffPolicy(std::chrono::seconds(1),
                                     std::chrono::minutes(5), kBackoffScaling)
                .clone())
            .clone());
  }
  if (!options.has<
          compute_global_network_endpoint_groups_v1::
              GlobalNetworkEndpointGroupsConnectionIdempotencyPolicyOption>()) {
    options.set<
        compute_global_network_endpoint_groups_v1::
            GlobalNetworkEndpointGroupsConnectionIdempotencyPolicyOption>(
        compute_global_network_endpoint_groups_v1::
            MakeDefaultGlobalNetworkEndpointGroupsConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_global_network_endpoint_groups_v1_internal
}  // namespace cloud
}  // namespace google
