// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/orchestration/airflow/service/v1/environments.proto

#include "google/cloud/composer/v1/internal/environments_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace composer_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

EnvironmentsTracingConnection::EnvironmentsTracingConnection(
    std::shared_ptr<composer_v1::EnvironmentsConnection> child)
    : child_(std::move(child)) {}

future<
    StatusOr<google::cloud::orchestration::airflow::service::v1::Environment>>
EnvironmentsTracingConnection::CreateEnvironment(
    google::cloud::orchestration::airflow::service::v1::
        CreateEnvironmentRequest const& request) {
  auto span = internal::MakeSpan(
      "composer_v1::EnvironmentsConnection::CreateEnvironment");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateEnvironment(request));
}

StatusOr<google::cloud::orchestration::airflow::service::v1::Environment>
EnvironmentsTracingConnection::GetEnvironment(
    google::cloud::orchestration::airflow::service::v1::
        GetEnvironmentRequest const& request) {
  auto span =
      internal::MakeSpan("composer_v1::EnvironmentsConnection::GetEnvironment");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetEnvironment(request));
}

StreamRange<google::cloud::orchestration::airflow::service::v1::Environment>
EnvironmentsTracingConnection::ListEnvironments(
    google::cloud::orchestration::airflow::service::v1::ListEnvironmentsRequest
        request) {
  auto span = internal::MakeSpan(
      "composer_v1::EnvironmentsConnection::ListEnvironments");
  internal::OTelScope scope(span);
  auto sr = child_->ListEnvironments(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::orchestration::airflow::service::v1::Environment>(
      std::move(span), std::move(sr));
}

future<
    StatusOr<google::cloud::orchestration::airflow::service::v1::Environment>>
EnvironmentsTracingConnection::UpdateEnvironment(
    google::cloud::orchestration::airflow::service::v1::
        UpdateEnvironmentRequest const& request) {
  auto span = internal::MakeSpan(
      "composer_v1::EnvironmentsConnection::UpdateEnvironment");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateEnvironment(request));
}

future<StatusOr<
    google::cloud::orchestration::airflow::service::v1::OperationMetadata>>
EnvironmentsTracingConnection::DeleteEnvironment(
    google::cloud::orchestration::airflow::service::v1::
        DeleteEnvironmentRequest const& request) {
  auto span = internal::MakeSpan(
      "composer_v1::EnvironmentsConnection::DeleteEnvironment");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteEnvironment(request));
}

StatusOr<google::cloud::orchestration::airflow::service::v1::
             ExecuteAirflowCommandResponse>
EnvironmentsTracingConnection::ExecuteAirflowCommand(
    google::cloud::orchestration::airflow::service::v1::
        ExecuteAirflowCommandRequest const& request) {
  auto span = internal::MakeSpan(
      "composer_v1::EnvironmentsConnection::ExecuteAirflowCommand");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->ExecuteAirflowCommand(request));
}

StatusOr<google::cloud::orchestration::airflow::service::v1::
             StopAirflowCommandResponse>
EnvironmentsTracingConnection::StopAirflowCommand(
    google::cloud::orchestration::airflow::service::v1::
        StopAirflowCommandRequest const& request) {
  auto span = internal::MakeSpan(
      "composer_v1::EnvironmentsConnection::StopAirflowCommand");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->StopAirflowCommand(request));
}

StatusOr<google::cloud::orchestration::airflow::service::v1::
             PollAirflowCommandResponse>
EnvironmentsTracingConnection::PollAirflowCommand(
    google::cloud::orchestration::airflow::service::v1::
        PollAirflowCommandRequest const& request) {
  auto span = internal::MakeSpan(
      "composer_v1::EnvironmentsConnection::PollAirflowCommand");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->PollAirflowCommand(request));
}

future<StatusOr<
    google::cloud::orchestration::airflow::service::v1::SaveSnapshotResponse>>
EnvironmentsTracingConnection::SaveSnapshot(
    google::cloud::orchestration::airflow::service::v1::
        SaveSnapshotRequest const& request) {
  auto span =
      internal::MakeSpan("composer_v1::EnvironmentsConnection::SaveSnapshot");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->SaveSnapshot(request));
}

future<StatusOr<
    google::cloud::orchestration::airflow::service::v1::LoadSnapshotResponse>>
EnvironmentsTracingConnection::LoadSnapshot(
    google::cloud::orchestration::airflow::service::v1::
        LoadSnapshotRequest const& request) {
  auto span =
      internal::MakeSpan("composer_v1::EnvironmentsConnection::LoadSnapshot");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->LoadSnapshot(request));
}

future<StatusOr<google::cloud::orchestration::airflow::service::v1::
                    DatabaseFailoverResponse>>
EnvironmentsTracingConnection::DatabaseFailover(
    google::cloud::orchestration::airflow::service::v1::
        DatabaseFailoverRequest const& request) {
  auto span = internal::MakeSpan(
      "composer_v1::EnvironmentsConnection::DatabaseFailover");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DatabaseFailover(request));
}

StatusOr<google::cloud::orchestration::airflow::service::v1::
             FetchDatabasePropertiesResponse>
EnvironmentsTracingConnection::FetchDatabaseProperties(
    google::cloud::orchestration::airflow::service::v1::
        FetchDatabasePropertiesRequest const& request) {
  auto span = internal::MakeSpan(
      "composer_v1::EnvironmentsConnection::FetchDatabaseProperties");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->FetchDatabaseProperties(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<composer_v1::EnvironmentsConnection>
MakeEnvironmentsTracingConnection(
    std::shared_ptr<composer_v1::EnvironmentsConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<EnvironmentsTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace composer_v1_internal
}  // namespace cloud
}  // namespace google
