// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/migration/v2/migration_service.proto

#include "google/cloud/bigquery/migration/v2/internal/migration_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/cloud/bigquery/migration/v2/migration_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace bigquery_migration_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

MigrationServiceStub::~MigrationServiceStub() = default;

StatusOr<google::cloud::bigquery::migration::v2::MigrationWorkflow>
DefaultMigrationServiceStub::CreateMigrationWorkflow(
    grpc::ClientContext& context,
    google::cloud::bigquery::migration::v2::
        CreateMigrationWorkflowRequest const& request) {
  google::cloud::bigquery::migration::v2::MigrationWorkflow response;
  auto status =
      grpc_stub_->CreateMigrationWorkflow(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::bigquery::migration::v2::MigrationWorkflow>
DefaultMigrationServiceStub::GetMigrationWorkflow(
    grpc::ClientContext& context,
    google::cloud::bigquery::migration::v2::GetMigrationWorkflowRequest const&
        request) {
  google::cloud::bigquery::migration::v2::MigrationWorkflow response;
  auto status = grpc_stub_->GetMigrationWorkflow(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::bigquery::migration::v2::ListMigrationWorkflowsResponse>
DefaultMigrationServiceStub::ListMigrationWorkflows(
    grpc::ClientContext& context,
    google::cloud::bigquery::migration::v2::ListMigrationWorkflowsRequest const&
        request) {
  google::cloud::bigquery::migration::v2::ListMigrationWorkflowsResponse
      response;
  auto status =
      grpc_stub_->ListMigrationWorkflows(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

Status DefaultMigrationServiceStub::DeleteMigrationWorkflow(
    grpc::ClientContext& context,
    google::cloud::bigquery::migration::v2::
        DeleteMigrationWorkflowRequest const& request) {
  google::protobuf::Empty response;
  auto status =
      grpc_stub_->DeleteMigrationWorkflow(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

Status DefaultMigrationServiceStub::StartMigrationWorkflow(
    grpc::ClientContext& context,
    google::cloud::bigquery::migration::v2::StartMigrationWorkflowRequest const&
        request) {
  google::protobuf::Empty response;
  auto status =
      grpc_stub_->StartMigrationWorkflow(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return google::cloud::Status();
}

StatusOr<google::cloud::bigquery::migration::v2::MigrationSubtask>
DefaultMigrationServiceStub::GetMigrationSubtask(
    grpc::ClientContext& context,
    google::cloud::bigquery::migration::v2::GetMigrationSubtaskRequest const&
        request) {
  google::cloud::bigquery::migration::v2::MigrationSubtask response;
  auto status = grpc_stub_->GetMigrationSubtask(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::bigquery::migration::v2::ListMigrationSubtasksResponse>
DefaultMigrationServiceStub::ListMigrationSubtasks(
    grpc::ClientContext& context,
    google::cloud::bigquery::migration::v2::ListMigrationSubtasksRequest const&
        request) {
  google::cloud::bigquery::migration::v2::ListMigrationSubtasksResponse
      response;
  auto status = grpc_stub_->ListMigrationSubtasks(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_migration_v2_internal
}  // namespace cloud
}  // namespace google
