// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/api/apikeys/v2/apikeys.proto

#include "google/cloud/apikeys/v2/api_keys_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace apikeys_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ApiKeysClient::ApiKeysClient(std::shared_ptr<ApiKeysConnection> connection,
                             Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
ApiKeysClient::~ApiKeysClient() = default;

future<StatusOr<google::api::apikeys::v2::Key>> ApiKeysClient::CreateKey(
    std::string const& parent, google::api::apikeys::v2::Key const& key,
    std::string const& key_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::api::apikeys::v2::CreateKeyRequest request;
  request.set_parent(parent);
  *request.mutable_key() = key;
  request.set_key_id(key_id);
  return connection_->CreateKey(request);
}

future<StatusOr<google::api::apikeys::v2::Key>> ApiKeysClient::CreateKey(
    google::api::apikeys::v2::CreateKeyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateKey(request);
}

StreamRange<google::api::apikeys::v2::Key> ApiKeysClient::ListKeys(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::api::apikeys::v2::ListKeysRequest request;
  request.set_parent(parent);
  return connection_->ListKeys(request);
}

StreamRange<google::api::apikeys::v2::Key> ApiKeysClient::ListKeys(
    google::api::apikeys::v2::ListKeysRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListKeys(std::move(request));
}

StatusOr<google::api::apikeys::v2::Key> ApiKeysClient::GetKey(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::api::apikeys::v2::GetKeyRequest request;
  request.set_name(name);
  return connection_->GetKey(request);
}

StatusOr<google::api::apikeys::v2::Key> ApiKeysClient::GetKey(
    google::api::apikeys::v2::GetKeyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetKey(request);
}

StatusOr<google::api::apikeys::v2::GetKeyStringResponse>
ApiKeysClient::GetKeyString(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::api::apikeys::v2::GetKeyStringRequest request;
  request.set_name(name);
  return connection_->GetKeyString(request);
}

StatusOr<google::api::apikeys::v2::GetKeyStringResponse>
ApiKeysClient::GetKeyString(
    google::api::apikeys::v2::GetKeyStringRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetKeyString(request);
}

future<StatusOr<google::api::apikeys::v2::Key>> ApiKeysClient::UpdateKey(
    google::api::apikeys::v2::Key const& key,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::api::apikeys::v2::UpdateKeyRequest request;
  *request.mutable_key() = key;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateKey(request);
}

future<StatusOr<google::api::apikeys::v2::Key>> ApiKeysClient::UpdateKey(
    google::api::apikeys::v2::UpdateKeyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateKey(request);
}

future<StatusOr<google::api::apikeys::v2::Key>> ApiKeysClient::DeleteKey(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::api::apikeys::v2::DeleteKeyRequest request;
  request.set_name(name);
  return connection_->DeleteKey(request);
}

future<StatusOr<google::api::apikeys::v2::Key>> ApiKeysClient::DeleteKey(
    google::api::apikeys::v2::DeleteKeyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteKey(request);
}

future<StatusOr<google::api::apikeys::v2::Key>> ApiKeysClient::UndeleteKey(
    google::api::apikeys::v2::UndeleteKeyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UndeleteKey(request);
}

StatusOr<google::api::apikeys::v2::LookupKeyResponse> ApiKeysClient::LookupKey(
    google::api::apikeys::v2::LookupKeyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->LookupKey(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace apikeys_v2
}  // namespace cloud
}  // namespace google
